//=============================================================================
/**
 * @file	worldtrade_local.h
 * @brief	Eʃwb_t@C
 *          
 * @author	Akito Mori
 * @date    	2006.04.16
 */
//=============================================================================


#ifndef __WORLDTRADE_LOCAL_H__
#define __WORLDTRADE_LOCAL_H__

#include "system/bmp_list.h"
#include "communication/wm_icon.h"
#include "savedata/zukanwork.h"
#include "savedata/wifilist.h"
#include "savedata/wifihistory.h"
#include "application/p_status.h"
#include "demo/demo_trade.h"
#include "battle/shinka.h"

// Proc_MainV[PX`
enum {
	SEQ_INIT_DPW=0,
	SEQ_INIT,
	SEQ_FADEIN,
	SEQ_MAIN,
	SEQ_FADEOUT,
	SEQ_OUT,
};

// TuvZXԍ
enum{
	WORLDTRADE_ENTER=0,		// ڑ
	WORLDTRADE_TITLE,		// ^CgEj[
	WORLDTRADE_MYPOKE,		// 悤݂
	WORLDTRADE_PARTNER,		// Ẵ|P̂悤݂
	WORLDTRADE_SEARCH,		// |P
	WORLDTRADE_MYBOX,		// ̃{bNX
	WORLDTRADE_DEPOSIT,		// ق|P̏
	WORLDTRADE_UPLOAD,		// |Pf[^Abv[h
	WORLDTRADE_STATUS,		// |PXe[^XĂяo
	WORLDTRADE_DEMO,		// |PXe[^XĂяo
};

// TuvZXɓn[hiTuvZXłgႤ邽߁j
enum{
	// worldtrade_title.c
	MODE_OPENING=0,				// ߂ĂƂ
	MODE_CONTINUE,				// p邽߂ɂ
	MODE_NOT_END,				// ߂I񂾂A߂Ȃ

	// worldtrade_mypoke.c
	MODE_VIEW,					// a|P̂悤݂
	MODE_DEPOSIT,				// |PƌƂɂ݂

	// worldtrade_box.c
	MODE_DEPOSIT_SELECT,		// |PaƂ
	MODE_EXCHANGE_SELECT,		// |Pƌ|PI
	
	// worldtrade_upload.c
	MODE_UPLOAD,				// |Paʂɍs
	MODE_DOWNLOAD,				// |P
	MODE_EXCHANGE,				// |P
	MODE_DOWNLOAD_EX,
	MODE_SERVER_CHECK,	// |PĂ邩mF遨j[
//	MODE_SERVER_CHECK,	// |PĂ邩mF遨悤݂
	MODE_POKEMON_EVO_SAVE,		// |PĩZ[u

};

// CLACTŒ`ĂZ傫ăTuʂɉełĂ܂̂ŗĂ݂
#define NAMEIN_SUB_ACTOR_DISTANCE 	(256*FX32_ONE)

// CellActorɏ郊\[X}l[W̎ނ̐i}`ZE}`ZAj͎gpȂj
#define CLACT_RESOURCE_NUM		(  4 )
#define NAMEIN_OAM_NUM			( 14 )

#define WORLDTRADE_MESFRAME_PAL	 ( 10 )
#define WORLDTRADE_MENUFRAME_PAL ( 11 )
#define WORLDTRADE_MESFRAME_CHR	 (  1 )
#define WORLDTRADE_MENUFRAME_CHR ( WORLDTRADE_MESFRAME_CHR + TALK_WIN_CGX_SIZ )
#define WORLDTRADE_TALKFONT_PAL	 ( 13 )

// bEChE\ʒu`
#define TALK_WIN_X		(  2 )
#define TALK_WIN_Y		( 19 )
#define	TALK_WIN_SX		( 27 )
#define	TALK_WIN_SY		(  4 )


// PsbZ[WEChE\ʒu`
#define LINE_TEXT_X		(  2 )
#define LINE_TEXT_Y		( 21 )
#define	LINE_TEXT_SX	( 27 )
#define	LINE_TEXT_SY	(  2 )


// ʏ㕔^CgEChE\ʒu`
#define TITLE_TEXT_X	(  1 )
#define TITLE_TEXT_Y	(  1 )
#define TITLE_TEXT_SX	( 28 )
#define TITLE_TEXT_SY	(  2 )

#define HEAD_LIST_X		( 15 )
#define HEAD_LIST_Y		(  5 )
#define HEAD_LIST_SX	(  4 )
#define HEAD_LIST_SY	( 13 )

#define NAME_LIST_X		( 21 )
#define NAME_LIST_Y		(  5 )
#define NAME_LIST_SX	( 10 )
#define NAME_LIST_SY	( 13 )


// IXg̈ʒuE`(_deposit.c _search.c)
// 
#define SELECT_MENU1_X	(  15 )
#define SELECT_MENU1_Y 	(   5 )
#define SELECT_MENU1_SX	(   4 )
#define SELECT_MENU1_SY	(  13 )

// |P
#define SELECT_MENU2_X	(  21 )
#define SELECT_MENU2_Y 	(   5 )
#define SELECT_MENU2_SX	(  10 )
#define SELECT_MENU2_SY	(  13 )

// 
#define SELECT_MENU3_X	(  21 )
#define SELECT_MENU3_Y 	(  10 )
#define SELECT_MENU3_SX	(  10 )
#define SELECT_MENU3_SY	(   8 )

// ~x
#define SELECT_MENU4_X	(  15 )
#define SELECT_MENU4_Y 	(   5 )
#define SELECT_MENU4_SX	(  16 )
#define SELECT_MENU4_SY	(  13 )


// ͂EEChEYW
#define	WORLDTRADE_YESNO_PY2	( 13 )		// bEChEQs̎
#define	WORLDTRADE_YESNO_PY1	( 15 )		// bEChEPs̎

// ^Cgobt@
#define TITLE_MESSAGE_BUF_NUM	( 20 * 2 )

// bEChEobt@
#define TALK_MESSAGE_BUF_NUM	( 90*2 )

#define DWC_ERROR_BUF_NUM		(16*8*2)

// {bNXg
#define BOX_TRAY_NAME_BUF_NUM	( 9*2 )

// ㉺ʎw`
#define RES_NUM	( 3 )
#define MAIN_LCD	( GF_BGL_MAIN_DISP )	// v͂O
#define SUB_LCD		( GF_BGL_SUB_DISP )		// PȂłB
#define CHARA_RES	( 2 )



// BMPWINw
enum{
	BMP_NAME1_S_BG0,
	BMP_NAME2_S_BG0,
	BMP_NAME3_S_BG0,
	BMP_NAME4_S_BG0,
	BMP_NAME5_S_BG0,
	BMP_RECORD_MAX,
};

// Pʂ̃{bNX̒̃|P̐
#define BOX_POKE_NUM		( 30 )

// |PACR̃pbg]ItZbg
#define POKEICON_PAL_OFFSET				(  3 )

// IłȂ|PACR̃pbg
#define POKEICON_NOTSELECT_PAL_OFFSET	(  6 )

// |PACRn܂VRAMł̃ItZbg
#define POKEICON_VRAM_OFFSET ( 12 )

// TÕ|P̓̐iAJT^in}j
#define HEADWORD_NUM		( 10 )

// ACeE[ACR̃ZAjԍ
#define CELL_ITEMICON_NO	( 40 )
#define CELL_MAILICON_NO	( 41 )
#define CELL_CBALLICON_NO	( 42 )

// {bNX̖
#define CELL_BOXARROW_NO	( 38 )


// |P
#define SEARCH_POKE_MAX		(  7 )

#define SUB_OBJ_NUM			(  8 )

// 1b҂
#define WAIT_ONE_SECONDE_NUM	( 30 )

// CṽXs[h
#define WORLDTRADE_WIPE_SPPED	( 6 )

// T[o[mFł悤ɂȂ܂ł̕biUObj
#define SEVER_RETRY_WAIT		( 60*30 )


//============================================================================================
//	\̒`
//============================================================================================

// |Paۂ̏
typedef struct{

	// |P̎푰i[e[ui2dALLOCj
	STRBUF **pokename;

	// |PaEp
	u16		headwordPos;		// I𓪃J[\ʒu
	u16		headwordListPos;	// IXgʒu
	u16		namePos;			// OIJ[\ʒu
	u16		nameListPos;		// OIXgʒu
	int		sexPos;				// ʃJ[\ʒu
	int		levelPos;			// xJ[\ʒu

	u8		*sinouTable;		// VIE}Ӄf[^il͊JNOj
	u16		*nameSortTable;		// |P\[ge[uǂݍ݃|C^
	int		nameSortNum;		// 
	int		sex_selection;		// I|P̐ʕz


	// |Pʗp
	int		cursorSide;			// 
	int		leftCursorPos;
	int		rightCursorPos;

}DEPOSIT_WORK;

typedef struct{
	Dpw_Tr_PokemonDataSimple	info[BOX_POKE_NUM];
}BOX_RESEARCH;

// x|Pî߂ɁA2ڂ݈̏ʒuۑĂ\
typedef struct{
	int boxno;
	int pos;
}EVOLUTION_POKEMON_INFO;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/11/28
// ؍̃\[gɑΉ
#if   PM_LANG == LANG_JAPAN
#define NAME_HEAD_MAX	( 10 )	// [AJT^in}]̐͂PO
#elif PM_LANG == LANG_KOREA
#define NAME_HEAD_MAX	( 14 )
#else
#define NAME_HEAD_MAX	(  9 )
#endif
// ----------------------------------------------------------------------------

typedef struct{
	u16 head_list,head_pos;

	u16 name_list[NAME_HEAD_MAX];
	u16 name_pos[NAME_HEAD_MAX];
}SELECT_LIST_POS;

struct WORLDTRADE_WORK{
	// NɖĂ
	WORLDTRADE_PARAM *param;							// Ăяop[^
	GF_BGL_INI		*bgl;								// GF_BGL_INI
	WIFI_LIST		*wifilist;							// wifiڑf[^EFBf[^
	
	
	// EVXeɊւ
	int				seq;								// ݂̐Eʂ̏
	int				nextseq;							// ݂̃V[PXIۂ̑Jڐ

	int				sub_process;						// ETuvOio[
	int				sub_nextprocess;					// ETuNEXTio[
	int				sub_returnprocess;					// nextvZXĂŏI̖߂vZX
	int				old_sub_process;					// ÕTuvZXۑĂ
	int				sub_process_mode;					// ̉ʂɂ[h͉H
	int				error_mes_no;

	int				subprocess_seq;						// TuvOV[PXNO
	int				subprocess_nextseq;					// TuvONEXTV[PXNO

	u16				OpeningFlag;						// E^CgH
	u16				DepositFlag;						// |PɃT[o[ɗaĂ邩Hi1:aĂj
	u16				ExchangeFlag;						// a|PĂ
	u16				serverWaitTime;						// T[o[ɃANZXłȂ悤ɂ^C}[

	int				ConnectErrorNo;						// DWCE܂̓T[o[̃G[
	int				ErrorRet;
	int				ErrorCode;

	void 			*heapPtr;							// NitroDWCɓnq[v[N̉p|C^
	NNSFndHeapHandle heapHandle;						// heapPtr32oCgACgɍ킹|C^
	DWCInetControl   stConnCtrl;							// DWCڑ[N

	PROC			*proc;								// X^[^XĂяopTuvZXf[^
	PSTATUS_DATA	 statusParam;						// X^[^XĂяopp[^
	DEMO_TRADE_PARAM tradeDemoParam;					// fp[^
	SHINKA_WORK		 *shinkaWork;						// ʐMifp[N
	int				 subprocflag;						// Xe[^XfĂяo߂̃tO
	u16				listpos;				
	u16				dummy;

	// eʂʂĂۑĂ
	u16				TitleCursorPos;						// ^Cgj[̃J[\ʒu
	u16				PartnerPageInfo;					// EEy[Ŵǂ݂Ă邩H
	u16				BoxTrayNo;							// ԃ{bNXĂ邩H
	u16				BoxCursorPos;						// {bNXł̃J[\̈ʒu
	POKEMON_PASO_PARAM	*deposit_ppp;					// UawɂȂ|P̃|C^
	int				SearchResult;						// ̌ʕԂĂ
	int				TouchTrainerPos;					// ʂ̒N^b`
	MYSTATUS		*partnerStatus;						// f悤ɂłMYSTATUS;
	EVOLUTION_POKEMON_INFO EvoPokeInfo;


	Dpw_Tr_Data		UploadPokemonData;					// Mf[^
	Dpw_Tr_Data		DownloadPokemonData[SEARCH_POKE_MAX];// ʃf[^
	Dpw_Tr_Data		ExchangePokemonData;				// ʃf[^
	Dpw_Tr_PokemonDataSimple Post;
	Dpw_Tr_PokemonSearchData Want;
	Dpw_Tr_PokemonSearchData Search;
	Dpw_Tr_PokemonSearchData SearchBackup;				// ͂łȂ悤ɂ邽߂



	// `܂̃[NiBMPp̕j
	WORDSET			*WordSet;								// bZ[WWJp[N}l[W[
	MSGDATA_MANAGER *MsgManager;							// O̓bZ[Wf[^}l[W[
	MSGDATA_MANAGER *MonsNameManager;						// |PbZ[Wf[^}l[W[
	MSGDATA_MANAGER *LobbyMsgManager;						// O̓bZ[Wf[^}l[W[
	MSGDATA_MANAGER *SystemMsgManager;						// WifiVXebZ[Wf[^
	STRBUF			*BoxTrayNameString;						// {bNXgC
	STRBUF			*EndString;								// u߂v
	STRBUF			*TalkString;							// bbZ[Wp
	STRBUF			*TitleString;							// ^CgbZ[Wp
	STRBUF			*InfoString[10];						// ^CgbZ[Wp
	STRBUF			*ErrorString;
	int				MsgIndex;								// Iop[N


	// `̃[NiOAM)
	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[CLACT_RESOURCE_NUM];				// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[RES_NUM][CLACT_RESOURCE_NUM];// \[XIuWFe[u
	CLACT_HEADER			clActHeader_main;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_sub;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_friend;						// ZAN^[wb_[
	CLACT_WORK_PTR			CursorActWork;							// ZAN^[[N|C^z
	CLACT_WORK_PTR			FingerActWork;							// ZAN^[[N|C^z
	CLACT_WORK_PTR			PokeIconActWork[BOX_POKE_NUM];			// |PACRAN^[
	CLACT_WORK_PTR			ItemIconActWork[BOX_POKE_NUM];			// ACeACRAN^[
	CLACT_WORK_PTR			CBallActWork[6];						// JX^{[ACRAN^[
	CLACT_WORK_PTR			PokemonActWork;				// ZAN^[[N|C^z
	CLACT_WORK_PTR			SubActWork[SUB_OBJ_NUM];				// Tuʗpnai|C^
	CLACT_WORK_PTR			BoxArrowActWork[2];						// {bNX̉ɂ

	// BMPWIN`
	GF_BGL_BMPWIN			MsgWin;									// bEChE
	GF_BGL_BMPWIN			NumberWin;								// ߂
	GF_BGL_BMPWIN			TitleWin;								// uR[hR[i[@ڂイイIvȂ
	GF_BGL_BMPWIN			SubWin;									// uR[hR[i[@ڂイイIvȂ
	GF_BGL_BMPWIN			MenuWin[3];								// j[pBMPWIN
	GF_BGL_BMPWIN			InfoWin[11];	
	GF_BGL_BMPWIN			TalkWin;


	BMP_MENULIST_DATA		*BmpMenuList;
	BMPMENU_WORK			*YesNoMenuWork;
	BMPMENU_WORK 			*BmpMenuWork;
	BMPLIST_WORK 			*BmpListWork;
	void*					timeWaitWork;							// bEChEACR[N

	int						wait;



	// ʖɎgƂ郏[N
	DEPOSIT_WORK			*dw;


	// worldtrade_upload.cp[N
	u16						saveNextSeq1st;						// Z[ȗOIɔԃV[PX
	u16						saveNextSeq2nd;						// Z[ǔ㔼IɔԃV[PX

	// worldtrade_sublcd.cp[N
	TCB_PTR					demotask;							// lfp^XN|C^
	u16						demo_end;							// fItO
	u16						SubLcdTouchOK;						// lOBJłĂĂG悤ɂȂtO
	void*					FieldObjCharaBuf;					// lOBJLt@Cf[^
	NNSG2dCharacterData*	FieldObjCharaData;					// lOBJLf[^̎|C^				
	void*					FieldObjPalBuf;						// lOBJpbg@Cf[^
	NNSG2dPaletteData*		FieldObjPalData;					// lOBJpbgt@Cf[^

	// worldtrade_demo.cp[N
	POKEMON_PARAM *demoPokePara;


	// worldtrade_box.cp[N
	BOX_RESEARCH			*boxWork;
	u16						boxPokeNum;								// {bNXɂ|P̑
	u16						boxSearchFlag;							// {bNX̑擾邽߂̃tO
	u32	sub_out_flg;		// ʃtF[hRg[
	
	void *boxicon;
	void (*vfunc)(void *);

	// worldtrade_deposit.c worldtrade_search.cŌp
	SELECT_LIST_POS			selectListPos;

	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/10/12
	// T[oւ̃vtB[o^ɑΉ
	Dpw_Common_Profile			Profile;
	Dpw_Common_ProfileResult	ProfileResult;
	// ----------------------------------------------------------------------------

#ifdef PM_DEBUG
	int 					frame;									//
	int						framenum[9][2];							//
#endif
};


//============================================================================================
// SEp`
//============================================================================================
#define WORLDTRADE_MOVE_SE		(SEQ_SE_DP_SELECT)
#define WORLDTRADE_DECIDE_SE	(SEQ_SE_DP_SELECT)


//============================================================================================
//	fobOp
//============================================================================================
//#define	GTS_FADE_OSP	// tF[hꏊ\p`


//============================================================================================
// extern錾
//============================================================================================
// worldtrade.c
extern void WorldTrade_MakeCLACT(CLACT_ADD *add, WORLDTRADE_WORK *wk, CLACT_HEADER *header, int param);
extern BMPMENU_WORK *WorldTrade_BmpWinYesNoMake( GF_BGL_INI *bgl, int y, int yesno_bmp_cgx );
extern void WorldTrade_SetNextSeq( WORLDTRADE_WORK *wk, int to_seq, int next_seq );
extern void WorldTrade_SetNextProcess( WORLDTRADE_WORK *wk, int next_process );
extern void WorldTrade_ActPos( CLACT_WORK_PTR act, int x, int y );
extern  int WorldTrade_WifiLinkLevel( void );
extern void WorldTrade_BmpWinPrint( GF_BGL_BMPWIN *win, MSGDATA_MANAGER *msgman, int msgno, u16 dat );
extern void WorldTrade_SysPrint( GF_BGL_BMPWIN *win, STRBUF *strbuf, int x, int y, int flag, GF_PRINTCOLOR color );
extern void WorldTrade_TalkPrint( GF_BGL_BMPWIN *win, STRBUF *strbuf, int x, int y, int flag, GF_PRINTCOLOR color );

extern void WorldTrade_WifiIconAdd( WORLDTRADE_WORK *wk );
extern void Enter_MessagePrint( WORLDTRADE_WORK *wk, MSGDATA_MANAGER *msgman, int msgno, int wait, u16 dat );
extern void WorldTrade_SubProcessChange( WORLDTRADE_WORK *wk, int subprccess, int mode );
extern WINTYPE WorldTrade_GetMesWinType( WORLDTRADE_WORK *wk );
extern int WorldTrade_GetTalkSpeed( WORLDTRADE_WORK *wk );
extern void FreeFieldObjData( WORLDTRADE_WORK *wk );
extern void WorldTrade_BoxPokeNumGetStart( WORLDTRADE_WORK *wk );
extern void WorldTrade_SubProcessUpdate( WORLDTRADE_WORK *wk );
extern void WorldTrade_TimeIconAdd( WORLDTRADE_WORK *wk );
extern void WorldTrade_TimeIconDel( WORLDTRADE_WORK *wk );


// worldtrade_sublcd.c
extern void WorldTrade_HeroDemo( WORLDTRADE_WORK *wk, int sex );
extern int  WorldTrade_SubLcdObjHitCheck( int max );
void WorldTrade_SubLcdMatchObjAppear( WORLDTRADE_WORK *wk, int num, int flag );
extern void WorldTrade_SubLcdMatchObjHide( WORLDTRADE_WORK *wk );
extern void WorldTrade_SubLcdActorAdd( WORLDTRADE_WORK *wk, int sex );
extern void WorldTrade_ReturnHeroDemo( WORLDTRADE_WORK *wk, int sex );


// worldtrade_enter.c
extern int  WorldTrade_Enter_End( WORLDTRADE_WORK *wk, int seq);
extern int  WorldTrade_Enter_Main(WORLDTRADE_WORK *wk, int seq);
extern int  WorldTrade_Enter_Init(WORLDTRADE_WORK *wk, int seq);

// worldtrade_title.c
extern int  WorldTrade_Title_End( WORLDTRADE_WORK *wk, int seq);
extern int  WorldTrade_Title_Main(WORLDTRADE_WORK *wk, int seq);
extern int  WorldTrade_Title_Init(WORLDTRADE_WORK *wk, int seq);
extern void WorldTrade_SubLcdBgGraphicSet( WORLDTRADE_WORK *wk );



// worldtrade_mypoke.c
extern int  WorldTrade_MyPoke_Init(WORLDTRADE_WORK *wk, int seq);
extern int  WorldTrade_MyPoke_Main(WORLDTRADE_WORK *wk, int seq);
extern int  WorldTrade_MyPoke_End(WORLDTRADE_WORK *wk, int seq);
extern void WorldTrade_PokeInfoPrint( 	MSGDATA_MANAGER *MsgManager,
							MSGDATA_MANAGER *MonsNameManager, 	
							WORDSET *WordSet, 
							GF_BGL_BMPWIN win[], 	
							POKEMON_PASO_PARAM *ppp,
							Dpw_Tr_PokemonDataSimple *post );
extern void WorldTrade_PokeInfoPrint2( MSGDATA_MANAGER *MsgManager, GF_BGL_BMPWIN win[], STRCODE *name );
extern void WorldTrade_TransPokeGraphic( POKEMON_PARAM *pp );


// worldtrade_partner.c
extern int WorldTrade_Partner_Init(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Partner_Main(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Partner_End(WORLDTRADE_WORK *wk, int seq);

// worldtrade_search.c
extern int WorldTrade_Search_Init(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Search_Main(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Search_End(WORLDTRADE_WORK *wk, int seq);

// worldtrade_box.c
extern int WorldTrade_Box_Init(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Box_Main(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Box_End(WORLDTRADE_WORK *wk, int seq);
extern POKEMON_PASO_PARAM *WorldTrade_GetPokePtr( POKEPARTY *party, BOX_DATA *box,  int  tray, int pos );
extern int WorldTrade_GetPPorPPP( int tray );
extern BOOL WorldTrade_PokemonMailCheck( POKEMON_PARAM *pp );

// workdtrade_deposit.c
extern int WorldTrade_Deposit_Init(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Deposit_Main(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Deposit_End(WORLDTRADE_WORK *wk, int seq);
extern void WodrldTrade_PokeWantPrint( MSGDATA_MANAGER *MsgManager, MSGDATA_MANAGER *MonsNameManager,
		WORDSET *WordSet, GF_BGL_BMPWIN win[], int monsno, int sex, int level );
extern void WodrldTrade_MyPokeWantPrint( MSGDATA_MANAGER *MsgManager, MSGDATA_MANAGER *MonsNameManager,
	WORDSET *WordSet, GF_BGL_BMPWIN win[], int monsno, int sex, int level );

extern BMPLIST_WORK *WorldTrade_WordheadBmpListMake( WORLDTRADE_WORK *wk, BMP_MENULIST_DATA **menulist, 
													GF_BGL_BMPWIN *win, MSGDATA_MANAGER *MsgManager );
extern BMPLIST_WORK *WorldTrade_PokeNameListMake( WORLDTRADE_WORK *wk, BMP_MENULIST_DATA **menulist, GF_BGL_BMPWIN *win, 
			MSGDATA_MANAGER *MsgManager, MSGDATA_MANAGER *MonsNameManager, DEPOSIT_WORK* dw, ZUKAN_WORK *zukan);
extern BMPLIST_WORK *WorldTrade_SexSelectListMake( BMP_MENULIST_DATA **menulist, GF_BGL_BMPWIN *win, MSGDATA_MANAGER *MsgManager  );
extern BMPLIST_WORK *WorldTrade_LevelListMake(BMP_MENULIST_DATA **menulist, GF_BGL_BMPWIN *win, MSGDATA_MANAGER *MsgManager  );
extern const int WorldTrade_WantLevelTable[];
extern const int WorldTrade_SexStringTable[];
extern u16* WorldTrade_ZukanSortDataGet( int heap, int idx, int* p_arry_num );

void WorldTrade_PokeNamePrint( GF_BGL_BMPWIN *win, MSGDATA_MANAGER *nameman, int monsno, int flag, int y, GF_PRINTCOLOR color );
void WorldTrade_SexPrint( GF_BGL_BMPWIN *win, MSGDATA_MANAGER *msgman, int sex, int flag, int y, int printflag, GF_PRINTCOLOR color );
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/16
// x Wŵł WorldTrade_WantLevelPrint() ֐p
void WorldTrade_WantLevelPrintEx( GF_BGL_BMPWIN *win, MSGDATA_MANAGER *msgman, int level, int flag, int y, GF_PRINTCOLOR color, int x );
void WorldTrade_WantLevelPrint( GF_BGL_BMPWIN *win, MSGDATA_MANAGER *msgman, int level, int flag, int y, GF_PRINTCOLOR color );
// ----------------------------------------------------------------------------
extern void WorldTrade_PostPokemonBaseDataMake( Dpw_Tr_Data *dtd, WORLDTRADE_WORK *wk );
extern int WorldTrade_SexSelectionCheck( Dpw_Tr_PokemonSearchData *dtp, int sex_selection );
extern int WorldTrade_LevelTermGet( int min, int max );
extern void WorldTrade_LevelMinMaxSet( Dpw_Tr_PokemonSearchData *dtps, int index );
extern u8 *WorldTrade_SinouZukanDataGet( int heap  );
extern u32 WorldTrade_BmpListMain( BMPLIST_WORK * lw, u16 *posbackup );
extern void WorldTrade_SelectListPosInit( SELECT_LIST_POS *slp);
extern void WorldTrade_SelectNameListBackup( SELECT_LIST_POS *slp, int head, int list, int pos );


// workdtrade_uploade.c
extern int WorldTrade_Upload_Init(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Upload_Main(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Upload_End(WORLDTRADE_WORK *wk, int seq);

// workdtrade_status.c
extern int WorldTrade_Status_Init(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Status_Main(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Status_End(WORLDTRADE_WORK *wk, int seq);

// workdtrade_demo.c
extern int WorldTrade_Demo_Init(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Demo_Main(WORLDTRADE_WORK *wk, int seq);
extern int WorldTrade_Demo_End(WORLDTRADE_WORK *wk, int seq);


#endif
