/**
 *	@file	tmap_sub.h
 *	@brief	^E}bv@Tuc[Q
 *	@author	Miyuki Iwasawa
 *	@date	06.04.01
 */

#ifndef __H_TMAP_SUB_H__
#define __H_TMAP_SUB_H__

////////////////////////////////////////////////////////////////
///^EViewpf[^\
typedef struct _TOWN_VIEW{
	int		zoneID;	//<][ID
	int		sysflag;	//<VXetOQID
	u8		ptn;	//<摜p^[	
	u8		typ;	//<摜p^[	
	u16		r;	//<]p
	fx32	x;	//<xW
	fx32	z;	//<yW
}TOWN_VIEW;

typedef struct _TMAP_VIEW_OBJ{
	TOWN_VIEW	prm;
	int		flag;
	CLACT_WORK_PTR	pAct;
}TMAP_VIEW_OBJ;

typedef struct _TMAP_VIEW_DAT{
	u16	dat_num;
	u8	selCount;
	u8	selFrame;

	TMAP_VIEW_OBJ *selPos;
	TMAP_VIEW_OBJ *pDat;
}TMAP_VIEW_DAT;

//////////////////////////////////////////////////////////////
///^E}bvpf[^^
typedef struct _TMAP_GDAT{
	u16	x;			//<ObhWX
	u16	z;			//<ObhWZ
	u16	kType;		//<Ŕ^Cv`
	u16 kIdx;		//<ŔIndexNo
	u16	gmes01;		//<KChbZ[W01CfbNX
	u16	gmes02;		//<KChbZ[W02CfbNX
	u16	gmes01_ox;	//<KChbZ[W01\ItZbgX
	u16	gmes01_oy;	//<KChbZ[W01\ItZbgY
	u16	gmes02_ox;	//<KChbZ[W02\ItZbgX
	u16	gmes02_oy;	//<KChbZ[W02\ItZbgY
	u16	view;		//<ViewtO
	u16	id;			//<ID
}TMAP_GDAT;

typedef struct _TMAP_GDAT_LIST{
	int	num;	///<f[^
	TMAP_GDAT *pDat;	//f[^z
}TMAP_GDAT_LIST;


//========================================================================
//Tuc[QOQƒ`GA
//

/**
 *	@brief	^EView\[X쐬
 *
 *	@param	actSys	ς݃ZAN^[VXe
 *	@param	actRes	ς݃ZAN^[\[X
 *
 *	@param	dat_num	f[^
 *	@param	heapID	q[vID
 */
extern TMAP_VIEW_DAT* TownViewDataCreate(CATS_SYS_PTR actSys,CATS_RES_PTR actRes,
		u8 *arrive,short dat_num,int heapID);

/**
 *	@brief	^EView\[X
 */
extern void TownViewDataRelease(TMAP_VIEW_DAT* wp);

/**
 *	@brief	^EView {`
 */
extern void TownViewDataDraw(TMAP_VIEW_DAT* wp,int mode);

/**
 *	^EView f[^ZoneID̂T
 */
extern TMAP_VIEW_OBJ* TownViewDataSearchPos(TMAP_VIEW_DAT* wp,int zoneID,int x,int z);

/**
 *	@brief	^EView
 */
extern int TownViewDataSelectPos(TMAP_VIEW_DAT* wp,int zoneID,int x,int z);

//============================================================
//}bvubNf[^QƊ֘A
//============================================================
/**
 *	@brief	}bvubNf[^[h
 */
extern TMAP_GDAT_LIST* TMapBlockDataLoad(const char* path,int heapID);

/**
 *	@brief	}bvubNf[^
 */
extern void TMapBlockDataRelease(TMAP_GDAT_LIST* pWork);

/**
 *	@brief	}bvubNf[^@ubNf[^擾
 *
 *	@param	pWork	f[^Xgz̐擪|C^
 *	@param	x		ubNXW
 *	@param	z		ubNZW
 *	@param	mapView	zz}bv`tO
 *	ubNx,zWubNf[^ւ̃|C^擾
 *	ȂꍇNULLԂ
 */
extern TMAP_GDAT* TMapBlockDataGet(TMAP_GDAT_LIST* pWork,int x,int z,u16 mapView);


#endif	//__H_TMAP_SUB_H__

