//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_drawglb.c
 *	@brief		}ӕ`O[of[^
 *	@author		tomoya takahashi
 *	@data		2006.01.19
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>
#include "include/gflib/display.h"
#include "include/poketool/poke_tool.h"
#include "include/system/fontproc.h"
#include "include/application/zukanlist/zukan.naix"
#include "include/system/arc_util.h"

#include "include/application/zukanlist/zkn_drawglb.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define ZKN_DRAWGLB_POKEGRA_BACK_OFS	(0)


// J[\Aj
#define ZKN_CURSOR_ANM_COUNT_HALF	( 32 )		// JE^̒
#define ZKN_CURSOR_ANM_COUNT_MAX	( ZKN_CURSOR_ANM_COUNT_HALF*2 )		// JE^̍ő
#define ZKN_CURSOR_ANM_DIS			( 4 )		// J[\Aj̓
#define ZKN_CORSOR_ANM_TCB_PRI		( 1 )		// ^XND揇

// J[\WύX
#define ZKN_CURSOR_MOVE_SYNC		( 3 )		// VN
#define ZKN_CORSOR_MOVE_TCB_PRI		( 0 )		// ^XND揇

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void ZknBgSetUp( GF_BGL_INI* p_bg, int heap );
static void ZknBgRelease( GF_BGL_INI* p_bg );

static void ZknFontBgBmpWinMake( ZKN_GLB_DRAWDATA* p_drawglb, int heap );
static void ZknFontBgBmpWinDelete( ZKN_GLB_DRAWDATA* p_drawglb );

static void ZknSoftSpriteInit( ZKN_GLB_DRAWDATA* p_drawglb, int heap );
static void ZknSoftSpriteDelete( ZKN_GLB_DRAWDATA* p_drawglb );

static void ZknPokeNameTblResLoad( ZKN_GLB_DRAWDATA* p_draw, int heap );
static void ZknPokeNameTblResRelease( ZKN_GLB_DRAWDATA* p_draw );
static void ZknPokeNameTblActAdd( ZKN_GLB_DRAWDATA* p_draw, int heap );
static void ZknPokeNameTblActDelete( ZKN_GLB_DRAWDATA* p_draw );

static void ZknCursorResInit( ZKN_GLB_DRAWDATA* p_draw, int heap );
static void ZknCursorResDelete( ZKN_GLB_DRAWDATA* p_draw );
static void ZknCursorActInit( ZKN_GLB_DRAWDATA* p_draw, int heap );
static void ZknCursorActDelete( ZKN_GLB_DRAWDATA* p_draw );
static void ZknCursorAnmAdd( ZKN_GLB_DRAWDATA* p_draw );
static void ZknCursorAnmDelete( ZKN_GLB_DRAWDATA* p_draw );
static void ZknCursorAnmTcb( TCB_PTR tcb, void* work );
static void ZknCursorSetMatrixLocal( ZKN_UTIL_CURSOR_OBJ* p_obj, int def_x, int def_y, int size_x, int size_y );
static void ZknCursorMoveTcbAdd( ZKN_GLB_DRAWDATA* p_draw );
static void ZknCursorMoveTcbDelete( ZKN_GLB_DRAWDATA* p_draw );
static void ZknCursorMoveSet( ZKN_GLB_DRAWDATA* p_draw, int x, int y, int size_x, int size_y );
static void ZknCursorMoveTcb( TCB_PTR tcb, void* p_work );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӕ`O[of[^
 *
 *	@param	p_draw		`O[of[^
 *	@param	heap		q[vID
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_GlbDrawDataInit( ZKN_GLB_DRAWDATA* p_draw, int heap )
{
	GF_BGL_SYS_HEADER bg_header;
	ZKN_FONTOAM_SYS_INIT fontoam_init;

	// OtBbNt@Cq[vnhI[v
	p_draw->p_graphic_arc_handl = ArchiveDataHandleOpen( ARC_ZUKAN_GRA, heap );


	// BGVXe̍쐬
	p_draw->p_bg = GF_BGL_BglIniAlloc( heap );

	// BGZbgAbv
	bg_header.dispMode	= GX_DISPMODE_GRAPHICS;
	bg_header.bgMode	= GX_BGMODE_0;
	bg_header.bgModeSub	= GX_BGMODE_1;
	bg_header.bg0_2Dor3D= GX_BG0_AS_3D;
	GF_BGL_InitBG( &bg_header );

	// BG
	ZknBgSetUp( p_draw->p_bg, heap );

	// fontʗprbg}bv쐬
	ZknFontBgBmpWinMake( p_draw, heap );

	// ZAN^[Zbg
	p_draw->clact_set = CLACT_U_SetEasyInit( ZKN_CLACT_SET_WORK_NUM, &p_draw->oam_rend, heap );

	// ZAN^[p\[XǗVXe
	p_draw->res_manager[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerInit( ZKN_CLACT_RES_DATA_TBL_NUM, CLACT_U_CHAR_RES, heap );
	p_draw->res_manager[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerInit( ZKN_CLACT_RES_DATA_TBL_NUM, CLACT_U_PLTT_RES, heap );
	p_draw->res_manager[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerInit( ZKN_CLACT_RES_DATA_TBL_NUM, CLACT_U_CELL_RES, heap );
	p_draw->res_manager[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerInit( ZKN_CLACT_RES_DATA_TBL_NUM, CLACT_U_CELLANM_RES, heap );

	// OBJON
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );

	// tHgOAMVXe쐬
	fontoam_init.clact_set	= p_draw->clact_set;
	fontoam_init.p_bg		= p_draw->p_bg;
	fontoam_init.work_num	= ZKN_FONTOAM_WORK_NUM;
	fontoam_init.heap		= heap;
	p_draw->fontoam_sys = ZKN_FONTOAM_InitSys( &fontoam_init );

	// tHgf[^ǂݍ
	FontProc_LoadFont( FONT_BUTTON, heap );
	

	// \tgEFA}l[W
	ZknSoftSpriteInit( p_draw, heap );


	// |PXgp\[Xǂݍ݁AN^[o^
	ZknPokeNameTblResLoad( p_draw, heap );
	ZknPokeNameTblActAdd( p_draw, heap );

	// J[\p\[Xǂݍ݁AN^[o^
	ZknCursorResInit( p_draw, heap );
	ZknCursorActInit( p_draw, heap );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃO[o`f[^j
 *
 *	@param	p_draw		`O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_GlbDrawDataDelete( ZKN_GLB_DRAWDATA* p_draw )
{
	
	// AN^[j\[Xj
	ZknPokeNameTblActDelete( p_draw );
	ZknPokeNameTblResRelease( p_draw );

	// J[\p\[XjAN^[j
	ZknCursorActDelete( p_draw );
	ZknCursorResDelete( p_draw );
	
	// `prbg}bvj
	ZknFontBgBmpWinDelete( p_draw );

	// BGj
	ZknBgRelease( p_draw->p_bg );

	
	// BGVXe
	sys_FreeMemoryEz( p_draw->p_bg );

	// ZAN^[Zbg
	CLACT_DestSet( p_draw->clact_set );

	// ZAN^[p\[XǗVXe
	CLACT_U_ResManagerDelete( p_draw->res_manager[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerDelete( p_draw->res_manager[ CLACT_U_PLTT_RES ] );
	CLACT_U_ResManagerDelete( p_draw->res_manager[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerDelete( p_draw->res_manager[ CLACT_U_CELLANM_RES ] );

	// FONTOAM
	ZKN_FONTOAM_DeleteSys( p_draw->fontoam_sys );

	// tHgj
	FontProc_UnloadFont( FONT_BUTTON );

	// \tgEFA}l[W
	ZknSoftSpriteDelete( p_draw );

	// A[JCunh
	ArchiveDataHandleClose( p_draw->p_graphic_arc_handl );

	memset( p_draw, 0, sizeof( ZKN_GLB_DRAWDATA ) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӕ`O[of[^@`VXe@`揈
 *
 *	@param	p_draw	`O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_GlbDrawDataMain( ZKN_GLB_DRAWDATA* p_draw )
{
	// ZAN^[`
	CLACT_Draw( p_draw->clact_set );
	
	// JZbgAbv
	NNS_G2dSetupSoftwareSpriteCamera();
	
	// \tgEFAXvCg`
	SoftSpriteMain( p_draw->soft_sprite_man );
	SWSP_SysDraw( p_draw->swsp_sys );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VBlank֐
 *
 *	@param	p_draw		`O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_GlbDrawDataVBlank( ZKN_GLB_DRAWDATA* p_draw )
{
	GF_BGL_VBlankFunc( p_draw->p_bg );

	// \tgEFAXvCg
	SoftSpriteTextureTrans( p_draw->soft_sprite_man );
}



//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbNݒ
 *
 *	@param	p_draw		`f[^
 *	@param	mons_no		X^[io[
 *	@param	sex					-1̂ƂftH
 *	@param	dir			
 *	@param	col			AJ[
 *	@param	form_no		tH[io[@֌WȂƂO
 *	@param	rnd			ő̗			֌WȂƂO
 *
 *	@return	none
 *
 *	sex
		PARA_MALE=0,		
		PARA_FEMALE,		߂
		PARA_UNK,			Ȃ

	dir
		PARA_FRONT:
		PARA_BACK:w
	
	col
		PARA_NORMAL:m[}
		PARA_RARE:A
 */
//----------------------------------------------------------------------------
void ZKN_GlbPokemonGraphicSet( ZKN_GLB_DRAWDATA* p_draw, int mons_no, int sex, int dir, int col, u8 form_no, u32 rnd, int x, int y )
{
	ZKN_GlbPokemonGraphicSet_Idx( p_draw, mons_no, sex, dir, col, form_no, rnd, x, y, 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POWݒ
 *
 *	@param	p_draw	`O[o
 *	@param	x		W
 *	@param	y		W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokemonGraphicSetMatrix( ZKN_GLB_DRAWDATA* p_draw, int x, int y )
{
	ZKN_GlbPokemonGraphicSetMatrix_Idx( p_draw, x, y, 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POW擾
 *
 *	@param	p_draw	`O[o
 *	@param	x		Wi[
 *	@param	y		Wi[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokemonGraphicGetMatrix( ZKN_GLB_DRAWDATA* p_draw, int* x, int* y )
{
	ZKN_GlbPokemonGraphicGetMatrix_Idx( p_draw, x, y, 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PIuWFNg擾
 *
 *	@param	p_draw	`f[^
 *
 *	@return	\tgEFAXvCg
 */
//-----------------------------------------------------------------------------
SOFT_SPRITE* ZKN_GlbPokemonGraphicGet( const ZKN_GLB_DRAWDATA* cp_draw )
{
	return ZKN_GlbPokemonGraphicGet_Idx( cp_draw, 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`tOݒ
 *
 *	@param	cp_draw
 *	@param	flag 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokemonGraphicDrawFlagSet( const ZKN_GLB_DRAWDATA* cp_draw, BOOL flag )
{
	ZKN_GlbPokemonGraphicDrawFlagSet_Idx( cp_draw, flag, 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbNݒ
 *
 *	@param	p_draw		`f[^
 *	@param	mons_no		X^[io[
 *	@param	sex					-1̂ƂftH
 *	@param	dir			
 *	@param	col			AJ[
 *	@param	form_no		tH[io[	֌WȂƂO
 *	@param	rnd			ő̗			֌WȂƂO
 *	@param	x			W
 *	@param	y			W
 *	@param	idx			CfbNX
 *
 *	@return	none
 *
 *	sex
		PARA_MALE=0,		
		PARA_FEMALE,		߂
		PARA_UNK,			Ȃ

	dir
		PARA_FRONT:
		PARA_BACK:w
	
	col
		PARA_NORMAL:m[}
		PARA_RARE:A
 */
//----------------------------------------------------------------------------
void ZKN_GlbPokemonGraphicSet_Idx( ZKN_GLB_DRAWDATA* p_draw, int mons_no, int sex, int dir, int col, u8 form_no, u32 rnd, int x, int y, int idx )
{
	SOFT_SPRITE_ARC poke_arc;
	s16 height;
	
	// ܂ł̂j
	if( p_draw->soft_sprite[idx] ){
		SoftSpriteDel( p_draw->soft_sprite[idx] );
	}

	// sex  -1̂Ƃ͕ʂ̐ʂݒ
	if( sex == -1 ){
		sex = PokeSexGetMonsNo( mons_no, 0 );
	}

	// |POtBbNf[^擾
	PokeGraArcDataGet( &poke_arc, mons_no, sex, dir, col, form_no, rnd );		//Ō̈́AFormNoƌł by soga 2006.05.01 mF܂ by tomoya

	// 
	if( dir == PARA_BACK ){
		height = PokeHeightGet( mons_no, sex, dir, form_no, rnd);
		height += ZKN_DRAWGLB_POKEGRA_BACK_OFS;	// }ӂł̍
	}else{
		height = 0;
	}

	// o^
	p_draw->soft_sprite[idx] = SoftSpriteAdd( 
			p_draw->soft_sprite_man,
			&poke_arc,
			x, y+height, 0, 0,
			NULL, NULL
			);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POWݒ
 *
 *	@param	p_draw	`O[o
 *	@param	x		W
 *	@param	y		W
 *	@param	idx		CfbNX
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokemonGraphicSetMatrix_Idx( ZKN_GLB_DRAWDATA* p_draw, int x, int y, int idx )
{
	SoftSpriteParaSet( p_draw->soft_sprite[idx], SS_PARA_POS_X, x );
	SoftSpriteParaSet( p_draw->soft_sprite[idx], SS_PARA_POS_Y, y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POW擾
 *
 *	@param	p_draw	`O[o
 *	@param	x		Wi[
 *	@param	y		Wi[
 *	@param	idx		CfbNX
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokemonGraphicGetMatrix_Idx( ZKN_GLB_DRAWDATA* p_draw, int* x, int* y, int idx )
{
	*x = SoftSpriteParaGet( p_draw->soft_sprite[idx], SS_PARA_POS_X );
	*y = SoftSpriteParaGet( p_draw->soft_sprite[idx], SS_PARA_POS_Y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PIuWFNg擾
 *
 *	@param	p_draw	`f[^
 *	@param	idx		CfbNX
 *
 *	@return	\tgEFAXvCg
 */
//-----------------------------------------------------------------------------
SOFT_SPRITE* ZKN_GlbPokemonGraphicGet_Idx( const ZKN_GLB_DRAWDATA* cp_draw, int idx )
{
	return cp_draw->soft_sprite[idx];
}

//----------------------------------------------------------------------------
/**
 *	@brief	`tOݒ
 *
 *	@param	cp_draw
 *	@param	flag 
 *	@param	idx			CfbNX
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokemonGraphicDrawFlagSet_Idx( const ZKN_GLB_DRAWDATA* cp_draw, BOOL flag, int idx )
{
	if( cp_draw->soft_sprite[idx] == NULL ){
		return ;
	}
	
	if( flag == TRUE ){
		SoftSpriteParaSet( cp_draw->soft_sprite[idx], SS_PARA_VANISH, FALSE );
	}else{
		SoftSpriteParaSet( cp_draw->soft_sprite[idx], SS_PARA_VANISH, TRUE );
	}
}




//----------------------------------------------------------------------------
/**
 *	@brief	|PXg̃e[uAN^[擾
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	AN^[
 */
//-----------------------------------------------------------------------------
CLACT_WORK_PTR ZKN_GlbPokeNameTblClactGet( const ZKN_GLB_DRAWDATA* p_draw )
{
	GF_ASSERT( p_draw->pokelist_data_draw.pokelist_tbl );

	return p_draw->pokelist_data_draw.pokelist_tbl;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXg̃ACRAN^[擾
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	AN^[
 */
//-----------------------------------------------------------------------------
CLACT_WORK_PTR ZKN_GlbPokeNameIconClactGet( const ZKN_GLB_DRAWDATA* p_draw )
{
	GF_ASSERT( p_draw->pokelist_data_draw.pokelist_icon );

	return p_draw->pokelist_data_draw.pokelist_icon;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pݒ
 *
 *	@param	p_draw			`O[o
 *	@param	p_fontoam_init	ӂOAMf[^
 *	@param	char_size		LN^]̈TCY
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokeNameTblSet( ZKN_GLB_DRAWDATA* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, int char_size, int mons_no, u32 zkn_mode )
{
	ZKN_GlbPokeNameTblSet_Minute( &p_draw->pokelist_data_draw, p_fontoam_init, char_size, mons_no, zkn_mode );
}


//----------------------------------------------------------------------------
/**
 *	@brief	ۂɃ|Pݒ
 *
 *	@param	p_data				f[^
 *	@param	p_fontoam_init		tHgf[^
 *	@param	char_size			LN^TCY
 *	@param	mons_no				X^[io[ 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokeNameTblSet_Minute( ZKN_POKELIST_DATA_OAM_DATA* p_data, ZKN_FONTOAM_INIT* p_fontoam_init, int char_size, int mons_no, u32 zkn_mode )
{
	// X^[ꏏȂ牽Ȃ
	if( (mons_no == p_data->mons_no) && (zkn_mode == p_data->zkn_mode) ){
		FONTOAM_SetDrawFlag( p_data->p_pokename->p_fontoam, TRUE );
		return ;
	}else{
		p_data->mons_no = mons_no;
		p_data->zkn_mode = zkn_mode;
	}
	
	// ܂ł̂j
	if( p_data->p_pokename ){
		ZKN_FONTOAM_Delete( p_data->p_pokename );
	}
	
	if( char_size != 0 ){
		p_data->p_pokename = ZKN_FONTOAM_MakeCharOfs( p_fontoam_init, char_size );
	}else{
		p_data->p_pokename = ZKN_FONTOAM_Make( p_fontoam_init );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POAMf[^擾
 *
 *	@param	p_draw `O[o
 *
 *	@return	OAMf[^
 */
//-----------------------------------------------------------------------------
ZKN_FONTOAM_DATA* ZKN_GlbPokeNameTblGet( const ZKN_GLB_DRAWDATA* p_draw )
{
	GF_ASSERT( p_draw->pokelist_data_draw.p_pokename );

	return  p_draw->pokelist_data_draw.p_pokename;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pe[up\[XIuWF擾
 *
 *	@param	p_draw		`O[o
 *	@param	res_type	\[X^Cv
 *
 *	@return	\[XIuWF
 *
 *	res_type
		CLACT_U_CHAR_RES,		// LN^\[XǗ
		CLACT_U_PLTT_RES,		// pbg\[XǗ
		CLACT_U_CELL_RES,		// Z\[XǗ
		CLACT_U_CELLANM_RES,	// ZAj\[XǗ
 */
//-----------------------------------------------------------------------------
CLACT_U_RES_OBJ_PTR ZKN_GlbPokeNameTblResObjGet( const ZKN_GLB_DRAWDATA* p_draw, int res_type )
{
	GF_ASSERT( res_type <= CLACT_U_CELLANM_RES );
	
	return p_draw->pokelist_data_draw.pokelist_res_obj[ res_type ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pe[uOAM[hݒ
 *
 *	@param	p_draw	`O[o
 *	@param	mode	OAM[h
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokeNameTblObjModeSet( const ZKN_GLB_DRAWDATA* p_draw, GXOamMode mode )
{
	CLACT_ObjModeSet( p_draw->pokelist_data_draw.pokelist_tbl, mode );
	CLACT_ObjModeSet( p_draw->pokelist_data_draw.pokelist_icon, mode );
	FONTOAM_ObjModeSet( p_draw->pokelist_data_draw.p_pokename->p_fontoam, mode );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXgBGD揇ʐݒ
 *
 *	@param	p_draw	`惏[N
 *	@param	pri		`BGpriority
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokeNameTblBGPriSet( const ZKN_GLB_DRAWDATA* p_draw, int pri )
{
	CLACT_BGPriorityChg( p_draw->pokelist_data_draw.pokelist_tbl, pri );
	CLACT_BGPriorityChg( p_draw->pokelist_data_draw.pokelist_icon, pri );
	FONTOAM_SetBGPriority( p_draw->pokelist_data_draw.p_pokename->p_fontoam, pri );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`tOݒ
 *
 *	@param	p_draw
 *	@param	flag 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokeNameTblDrawFlagSet( const ZKN_GLB_DRAWDATA* p_draw, BOOL flag )
{
	if( p_draw->pokelist_data_draw.pokelist_tbl ){
		CLACT_SetDrawFlag( p_draw->pokelist_data_draw.pokelist_tbl, flag );
	}
	if( p_draw->pokelist_data_draw.pokelist_icon ){
		CLACT_SetDrawFlag( p_draw->pokelist_data_draw.pokelist_icon, flag );
	}
	if( p_draw->pokelist_data_draw.p_pokename->p_fontoam ){
		FONTOAM_SetDrawFlag( p_draw->pokelist_data_draw.p_pokename->p_fontoam, flag );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	}Ӄ[eBeB@ƎtF[hC@AEgVXe
 *
 *	@param	p_fade		tF[hf[^
 *	@param	sync		VN
 *	@param	brightness_suCglXJnl
 *	@param	brightness_euCglXIl
 *	@param	s_alpha		Jnl	
 *	@param	e_alpha		Il	
 *	@param	plane1		Ώ̖ʂP	
 *	@param	plane2		Ώ̖ʂQ	iΏ̖ʂQ͐΂BD܂j
 *	@param	disp_flag	CTu
 *
 *	@return	none
 *
 *	disp_flag
	ZKN_UTIL_FADE_MAIN,
	ZKN_UTIL_FADE_SUB,
 */
//-----------------------------------------------------------------------------
void ZKN_GLB_ChangeFadeRequest( ZKN_UTIL_FADE_SYS* p_fade, u8 sync, int brightness_s, int brightness_e, int s_alpha, int e_alpha, BRIGHT_PLANEMASK plane1, BRIGHT_PLANEMASK plane2, int disp_flag )
{
	// CTu
	p_fade->disp_flag = disp_flag;

	// Ώ̖
	p_fade->plane1 = plane1;
	p_fade->plane2 = plane2 | PLANEMASK_BD;
	
	// tF[hf[^
	p_fade->brightness_s		= brightness_s;
	p_fade->brightness_dis		= brightness_e - brightness_s;
	p_fade->alpha_s				= s_alpha;
	p_fade->alpha_dis			= e_alpha - s_alpha;
	p_fade->count_max			= sync;
	p_fade->count				= 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}Ӄ[eBeB@ƎtF[hC@AEgVXe
 *
 *	@param	p_fade	tF[hf[^
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLB_ChangeFadeMain( ZKN_UTIL_FADE_SYS* p_fade )
{
	int set_alpha, set_brightness;

	if( ZKN_GLB_ChangeFadeEndCheck( p_fade ) == FALSE ){
		
		set_alpha = ZKN_GLB_GetFadeAlpha( p_fade );
		set_brightness = ZKN_GLB_GetFadeBrightness( p_fade );

		// ݒ
		if( p_fade->disp_flag == ZKN_UTIL_FADE_MAIN ){
			G2_SetBlendBrightnessExt( p_fade->plane1, p_fade->plane2,
					set_alpha, 0,
					set_brightness );
		}else{
			G2S_SetBlendBrightnessExt( p_fade->plane1, p_fade->plane2,
					set_alpha, 0,
					set_brightness );
		}

		// JEg
		p_fade->count++;
	}

	return ZKN_GLB_ChangeFadeEndCheck( p_fade );
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃l擾
 *
 *	@param	p_fade 
 *
 *	@return	l
 */
//-----------------------------------------------------------------------------
int ZKN_GLB_GetFadeAlpha( ZKN_UTIL_FADE_SYS* p_fade )
{
	fx32 alpha;

	alpha = FX_Mul( p_fade->alpha_dis << FX32_SHIFT, p_fade->count << FX32_SHIFT );
	alpha = FX_Div( alpha, p_fade->count_max << FX32_SHIFT );

	return (alpha >> FX32_SHIFT) + p_fade->alpha_s;
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃uCglXl擾
 *
 *	@param	p_fade 
 *
 *	@return	uCglXl
 */
//-----------------------------------------------------------------------------
int ZKN_GLB_GetFadeBrightness( ZKN_UTIL_FADE_SYS* p_fade )
{
	fx32 brightness;

	brightness = FX_Mul( p_fade->brightness_dis << FX32_SHIFT, p_fade->count << FX32_SHIFT );
	brightness = FX_Div( brightness, p_fade->count_max << FX32_SHIFT );
	
	return (brightness >> FX32_SHIFT) + p_fade->brightness_s;
}

//----------------------------------------------------------------------------
/**
 *	@brief	I`FbN
 *
 *	@param	p_fade	tF[h[N
 *
 *	@retval TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ZKN_GLB_ChangeFadeEndCheck( ZKN_UTIL_FADE_SYS* p_fade )
{
	if( p_fade->count <= p_fade->count_max ){
		return FALSE;
	}

	return TRUE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	|POpbgtF[hlݒ
 *
 *	@param	p_draw		`O[o
 *	@param	p_fade		tF[hf[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GLB_SpritePokeGraPalFade( const ZKN_GLB_DRAWDATA* p_draw, ZKN_UTIL_FADE_SYS* p_fade )
{
	SOFT_SPRITE* ssp;
	int brightness;

	brightness = -ZKN_GLB_GetFadeBrightness( p_fade );
	
	// |P\tgpbgtF[h
	ssp = ZKN_GlbPokemonGraphicGet( p_draw );
	SoftSpritePalFadeSet( ssp, brightness, brightness, 0, 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POpbgtF[hlݒ
 *
 *	@param	p_draw		`O[o
 *	@param	p_fade		tF[hf[^
 *	@param	idx			CfbNX
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GLB_SpritePokeGraPalFade_Idx( const ZKN_GLB_DRAWDATA* p_draw, ZKN_UTIL_FADE_SYS* p_fade, int idx )
{
	SOFT_SPRITE* ssp;
	int brightness;

	brightness = -ZKN_GLB_GetFadeBrightness( p_fade );
	
	// |P\tgpbgtF[h
	ssp = ZKN_GlbPokemonGraphicGet_Idx( p_draw, idx );
	SoftSpritePalFadeSet( ssp, brightness, brightness, 0, 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\IuWFNgɍWݒ
 *
 *	@param	cp_cursor	J[\VXe
 *	@param	p_draw		`O[o
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_CursorSetMatrixCursorSys( const ZKN_CURSOR* cp_cursor, ZKN_GLB_DRAWDATA* p_draw )
{
	int x,y,size_x,size_y;
	
	// WƃTCY擾
	ZKN_CURSOR_GetMat( cp_cursor, &x, &y );
	ZKN_CURSOR_GetSize( cp_cursor, &size_x, &size_y );
	ZKN_UTIL_CursorSetMatrix( p_draw, x, y, size_x, size_y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\Wݒ
 *
 *	@param@p_draw		`O[o	
 *	@param	def_x		ftHgw
 *	@param	def_y		ftHgx
 *	@param	size_x		J[\TCYw
 *	@param	size_y		J[\TCYx
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_CursorSetMatrix( ZKN_GLB_DRAWDATA* p_draw, int def_x, int def_y, int size_x, int size_y )
{
	ZknCursorMoveSet( p_draw, def_x, def_y, size_x, size_y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`nmnee
 *
 *	@param	p_obj	`IuWF
 *	@param	flag	tO
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_CursorSetDrawFlag( ZKN_UTIL_CURSOR_OBJ* p_obj, int flag )
{
	int i;

	// `nmnee
	for( i=0; i<ZKN_CURROS_MAT_RECT_NUM; i++ ){
		CLACT_SetDrawFlag( p_obj->cursor[i], flag );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	`ONOFF擾
 *
 *	@param	p_obj	IuWFNg
 *
 *	@retval	TRUE	`ON
 *	@retval	FALSE	`OFF
 */
//-----------------------------------------------------------------------------
BOOL ZKN_UTIL_CursorGetDrawFlag( ZKN_UTIL_CURSOR_OBJ* p_obj )
{
	return CLACT_GetDrawFlag( p_obj->cursor[0] );	// \0
}

//----------------------------------------------------------------------------
/**
 *	@brief	AjnmneetO
 *
 *	@param	p_obj	J[\IuWFNg
 *	@param	anm		AjtO
 *
 *	@return	none
 *
 *	anm
 *		TRUE	Xgbv
 *		FALSE	Đ
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_CursorSetAnimeStopFlag( ZKN_UTIL_CURSOR_OBJ* p_obj, BOOL anm )
{
	p_obj->anm_stop = anm;

	// JnȂJE^
	if( anm == FALSE ){
		p_obj->anm_count = 0;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ړAjȂ̍Wݒ@p
 *
 *	@param	cp_cursor	J[\VXe
 *	@param	p_draw		`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_CursorSetMatrixCursorSysNotAnm( const ZKN_CURSOR* cp_cursor, ZKN_GLB_DRAWDATA* p_draw )
{
	int x, y, size_x, size_y;

	// WƃTCY擾
	ZKN_CURSOR_GetMat( cp_cursor, &x, &y );
	ZKN_CURSOR_GetSize( cp_cursor, &size_x, &size_y );

	// Wݒ
	ZKN_UTIL_CursorSetMatrixNotAnm( p_draw, x, y, size_x, size_y );
}
//----------------------------------------------------------------------------
/**
 *	@brief	ړAjȂ̍Wݒ@p
 *
 *	@param	p_draw
 *	@param	def_x
 *	@param	def_y
 *	@param	size_x
 *	@param	size_y 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_CursorSetMatrixNotAnm( ZKN_GLB_DRAWDATA* p_draw, int def_x, int def_y, int size_x, int size_y )
{
	p_draw->cursor.x = def_x;
	p_draw->cursor.y = def_y;
	p_draw->cursor.size_x = size_x;
	p_draw->cursor.size_y = size_y;

	// Wݒ
	ZknCursorSetMatrixLocal( &p_draw->cursor, p_draw->cursor.x, p_draw->cursor.y,
			p_draw->cursor.size_x, p_draw->cursor.size_y );

	p_draw->cursor_move.ta_x = def_x;
	p_draw->cursor_move.ta_y = def_y;
	p_draw->cursor_move.ta_size_x = size_x;
	p_draw->cursor_move.ta_size_y = size_y;
	p_draw->cursor_move.move_stop = FALSE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	
 *
 *	@param	p_work			샏[N
 *	@param	s_x				JnxW
 *	@param	e_x				IxW
 *	@param	s_y				JnyW
 *	@param	e_y				IyW
 *	@param	count_max		JEgől
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_UTIL_MoveReq( ZKN_UTIL_MOVE_WORK* p_work, int s_x, int e_x, int s_y, int e_y, int count_max )
{
	p_work->x = s_x;
	p_work->y = s_y;

	p_work->s_x = s_x;
	p_work->s_y = s_y;
	p_work->dis_x = e_x - s_x;
	p_work->dis_y = e_y - s_y;
	p_work->count_max = count_max;
	p_work->count = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	상C
 *
 *	@param	p_work	[N
 *
 *	@retval	TRUE	I
 *	@retval FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ZKN_UTIL_MoveMain( ZKN_UTIL_MOVE_WORK* p_work )
{
	fx32 w_x, w_y;



	// ݍW擾
	w_x = FX_Mul( p_work->dis_x << FX32_SHIFT, p_work->count << FX32_SHIFT );
	w_x = FX_Div( w_x, p_work->count_max << FX32_SHIFT );
	w_y = FX_Mul( p_work->dis_y << FX32_SHIFT, p_work->count << FX32_SHIFT );
	w_y = FX_Div( w_y, p_work->count_max << FX32_SHIFT );

	
	p_work->x = (w_x >> FX32_SHIFT) + p_work->s_x;
	p_work->y = (w_y >> FX32_SHIFT) + p_work->s_y;

	if( (p_work->count + 1) <= p_work->count_max ){
		p_work->count++;
		return FALSE;
	}

	p_work->count = p_work->count_max;
	return TRUE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	A[JCut@Cnh擾
 *
 *	@param	p_draw	`ް
 *
 *	@return	A[JCut@Cnh
 */
//-----------------------------------------------------------------------------
ARCHANDLE* ZKN_GLBDATA_ArcHandlGet( ZKN_GLB_DRAWDATA* p_draw )
{
	return p_draw->p_graphic_arc_handl;
}

//------------------------------------------------------------------
/**
 * A[JCuf[^̓ǂݏoimۂj
 *
 * @param   p_draw			`۰ް
 * @param   dataIdx			A[JCuf[^CfbNX
 * @param   compressedFlag	kĂ邩H
 * @param	heapID			gpq[v
 *
 * @retval  void*			ǂݏö|C^
 */
//------------------------------------------------------------------
void* ZKN_GLBDATA_Arc_Load(ZKN_GLB_DRAWDATA* p_draw, u32 dataIdx, BOOL compressedFlag, u32 heapID)
{
	void* arcData;
	
	arcData = ArchiveDataLoadAllocByHandle( p_draw->p_graphic_arc_handl, dataIdx, heapID );

	if( arcData != NULL )
	{
		if( compressedFlag )
		{
			void* data;

			data = sys_AllocMemory( heapID, MI_GetUncompressedSize( arcData ) );
			if( data )
			{
				MI_UncompressLZ8( arcData, data );
				sys_FreeMemoryEz( arcData );
			}
			arcData = data;
		}
	}

	return arcData;
}

//------------------------------------------------------------------
/**
 * BGް VRAM ]
 *
 * @param   p_draw			`۰ް
 * @param   dataIndex		ްޯ
 * @param   bgl				BGLް
 * @param   frm				]ڰ
 * @param   offs			]̾āiגPʁj
 * @param	transSize		]黲ށi޲ĒP ==0őS]j
 * @param   compressedFlag	kĂްH
 * @param   heapID			ްǂݍ݁E؂ƂĎg˰ID
 *
 * @return  ]f[^TCYioCgj
 */
//------------------------------------------------------------------
u32 ZKN_GLBDATA_BgCharSet(ZKN_GLB_DRAWDATA* p_draw, u32 dataIdx, GF_BGL_INI* bgl, u32 frm, u32 offs, u32 transSize, BOOL compressedFlag, u32 heapID)
{
	void* arcData = ZKN_GLBDATA_Arc_Load( p_draw, dataIdx, compressedFlag, heapID );

	if( arcData != NULL )
	{
		NNSG2dCharacterData* charData;

		if( NNS_G2dGetUnpackedBGCharacterData( arcData, &charData ) )
		{
			if( transSize == 0 )
			{
				transSize = charData->szByte;
			}
			GF_BGL_LoadCharacter(bgl, frm, charData->pRawData, transSize, offs);
		}

		sys_FreeMemoryEz( arcData );
	}
    return transSize;
}
//------------------------------------------------------------------
/**
 * گް  VRAM ]
 *
 * @param   p_draw			`۰ް
 * @param   dataIdx		ްޯ
 * @param   palType		گē]
 * @param   offs		گē]̾
 * @param   transSize	گē]ށi0 őS]j
 * @param   heapID		ްǂݍ؂ƂĎg˰ID
 *
 */
//------------------------------------------------------------------
void ZKN_GLBDATA_PalSet(ZKN_GLB_DRAWDATA* p_draw, u32 dataIdx, PALTYPE palType, u32 offs, u32 transSize, u32 heapID )
{
	static void (* const load_func[])(const void*, u32, u32) = {
		GX_LoadBGPltt,
		GX_LoadOBJPltt,
		GX_LoadBGExtPltt,
		GX_LoadOBJExtPltt,
		GXS_LoadBGPltt,
		GXS_LoadOBJPltt,
		GXS_LoadBGExtPltt,
		GXS_LoadOBJExtPltt,
	};

	void* arcData = ZKN_GLBDATA_Arc_Load( p_draw, dataIdx, FALSE, heapID );

	if( arcData != NULL )
	{
		NNSG2dPaletteData* palData;

		if( NNS_G2dGetUnpackedPaletteData( arcData, &palData ) )
		{
			if( transSize == 0 )
			{
				transSize = palData->szByte;
			}
			DC_FlushRange( palData->pRawData, transSize );
			load_func[ palType ]( palData->pRawData, offs, transSize );
		}

		sys_FreeMemoryEz( arcData );
	}
}
//--------------------------------------------------------------------------------------------
/**
 * ذް ۰ނ Unpack 邾łB͊eŁB
 *
 * @param   p_draw			`۰ް
 * @param   arcIndex		[in] ްޯ
 * @param   compressedFlag	[in] kĂްH
 * @param   scrnData		[out] ذްڽێ߲̱ڽ
 * @param   heapID			[in] ˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//--------------------------------------------------------------------------------------------
void* ZKN_GLBDATA_ScrnDataGet(ZKN_GLB_DRAWDATA* p_draw, u32 dataIdx, BOOL compressedFlag, NNSG2dScreenData** scrnData, u32 heapID)
{
	void* arcData = ZKN_GLBDATA_Arc_Load( p_draw, dataIdx, compressedFlag, heapID );

	if( arcData != NULL )
	{
		if( NNS_G2dGetUnpackedScreenData( arcData, scrnData ) == FALSE )
		{
			sys_FreeMemoryEz( arcData );
			return NULL;
		}
	}
	return arcData;
}
//------------------------------------------------------------------
/**
 * گް۰ނ Unpack 邾łB͊eŁB
 *
 * @param   p_draw			`۰ް
 * @param   arcIndex		ްޯ
 * @param   palData			گްڽێ߲̱ڽ
 * @param   heapID			˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//------------------------------------------------------------------
void* ZKN_GLBDATA_PalDataGet( ZKN_GLB_DRAWDATA* p_draw, u32 dataIdx, NNSG2dPaletteData** palData, u32 heapID )
{
	void* arcData = ZKN_GLBDATA_Arc_Load( p_draw, dataIdx, FALSE, heapID );

	if( arcData != NULL )
	{
		if( NNS_G2dGetUnpackedPaletteData( arcData, palData ) == FALSE )
		{
			sys_FreeMemoryEz( arcData );
			return NULL;
		}
	}
	return arcData;
}
//------------------------------------------------------------------
/**
 * ް ۰ނ Unpack 邾łB͊eŁB
 *
 * @param   p_draw			`۰ް
 * @param   dataIdx				[in] ްޯ
 * @param   compressedFlag		[in] kĂ邩
 * @param   charData			[out] ްڽێ߲̱ڽ
 * @param   heapID				[in] ˰ID
 *
 * @retval  void*		۰ން̐擪߲
 */
//------------------------------------------------------------------
void* ZKN_GLBDATA_CharDataGet( ZKN_GLB_DRAWDATA* p_draw, u32 dataIdx, BOOL compressedFlag, NNSG2dCharacterData** charData, u32 heapID )
{
	void* arcData = ZKN_GLBDATA_Arc_Load( p_draw, dataIdx, compressedFlag, heapID );

	if( arcData != NULL )
	{
		if( NNS_G2dGetUnpackedBGCharacterData( arcData, charData ) == FALSE)
		{
			// sNULL
			sys_FreeMemoryEz( arcData );
			return NULL;
		}
	}
	return arcData;
}




//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGf[^ݒ
 *
 *	@param	p_bg	BGVXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void ZknBgSetUp( GF_BGL_INI* p_bg, int heap )
{
	// C BG1		񏑂ݖ
	{
		GF_BGL_BGCNT_HEADER bg_cnt_header = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x0000, GX_BG_CHARBASE_0x04000,
			GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( p_bg, ZKN_BG_FRM_FONT_M, &bg_cnt_header, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( ZKN_BG_FRM_FONT_M, 32, 0, heap );
		GF_BGL_ScrClear( p_bg, ZKN_BG_FRM_FONT_M );
	}

	// C BG2		[eBeB
	{
		GF_BGL_BGCNT_HEADER bg_cnt_header = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x0800, GX_BG_CHARBASE_0x0c000,
			GX_BG_EXTPLTT_01, 1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( p_bg, ZKN_BG_FRM_UTIL_M, &bg_cnt_header, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( ZKN_BG_FRM_UTIL_M, 32, 0, heap );
		GF_BGL_ScrClear( p_bg, ZKN_BG_FRM_UTIL_M );
	}

	// 3D
	GF_BGL_PrioritySet( GF_BGL_FRAME0_M, 2 );
	// BG0ON
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );


	// C BG3		wi
	{
		GF_BGL_BGCNT_HEADER bg_cnt_header = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x1000, GX_BG_CHARBASE_0x14000,
			GX_BG_EXTPLTT_01, 3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( p_bg, ZKN_BG_FRM_BACK_M, &bg_cnt_header, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( ZKN_BG_FRM_BACK_M, 32, 0, heap );
		GF_BGL_ScrClear( p_bg, ZKN_BG_FRM_BACK_M );
	}


	// Tu BG1		[eBeB
	{
		GF_BGL_BGCNT_HEADER bg_cnt_header = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x0000, GX_BG_CHARBASE_0x04000,
			GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( p_bg, ZKN_BG_FRM_UTIL_S, &bg_cnt_header, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( ZKN_BG_FRM_UTIL_S, 32, 0, heap );
		GF_BGL_ScrClear( p_bg, ZKN_BG_FRM_UTIL_S );
	}

	// Tu BG2		wi
	{
		GF_BGL_BGCNT_HEADER bg_cnt_header = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x1000, GX_BG_CHARBASE_0x08000,
			GX_BG_EXTPLTT_01, 2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( p_bg, ZKN_BG_FRM_BACK_S, &bg_cnt_header, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( ZKN_BG_FRM_BACK_S, 32, 0, heap );
		GF_BGL_ScrClear( p_bg, ZKN_BG_FRM_BACK_S );
	}

	// Tu BG3		gkBG
	{
		GF_BGL_BGCNT_HEADER bg_cnt_header = {
			0, 0, 0x400, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0x0800, GX_BG_CHARBASE_0x10000,
			GX_BG_EXTPLTT_01, 1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( p_bg, ZKN_BG_FRM_AFFINE_S, &bg_cnt_header, GF_BGL_MODE_AFFINE );
		GF_BGL_ClearCharSet( ZKN_BG_FRM_AFFINE_S, 64, 0, heap );
		GF_BGL_ScrClear( p_bg, ZKN_BG_FRM_AFFINE_S );
	}

}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGRg[f[^j
 *
 *	@param	p_bg	BGRg[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void ZknBgRelease( GF_BGL_INI* p_bg )
{
	GF_BGL_BGControlExit( p_bg, ZKN_BG_FRM_FONT_M );
	GF_BGL_BGControlExit( p_bg, ZKN_BG_FRM_UTIL_M );
	GF_BGL_BGControlExit( p_bg, ZKN_BG_FRM_BACK_M );
	GF_BGL_BGControlExit( p_bg, ZKN_BG_FRM_UTIL_S );
	GF_BGL_BGControlExit( p_bg, ZKN_BG_FRM_AFFINE_S );
	GF_BGL_BGControlExit( p_bg, ZKN_BG_FRM_BACK_S );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	`prbg}bv쐬
 *
 *	@param	p_drawglb	`O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void ZknFontBgBmpWinMake( ZKN_GLB_DRAWDATA* p_drawglb, int heap )
{
	// rbg}bvEBhEo^
	GF_BGL_BmpWinAdd( p_drawglb->p_bg, &p_drawglb->bmp_mfont,
			ZKN_BG_FRM_FONT_M, 0, 0, ZKN_BG_FONTBMP_CX, ZKN_BG_FONTBMP_CY, ZKN_BG_FONT_COLOR, 0 );

	// N[
	GF_BGL_BmpWinDataFill( &p_drawglb->bmp_mfont, 0 );

	// \
	GF_BGL_BmpWinOn( &p_drawglb->bmp_mfont );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`prbg}bvf[^j
 *
 *	@param	p_drawglb		`O[of[^j
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void ZknFontBgBmpWinDelete( ZKN_GLB_DRAWDATA* p_drawglb )
{
	GF_BGL_BmpWinDel( &p_drawglb->bmp_mfont );
}

//----------------------------------------------------------------------------
/**
 *	@brief	\tgEFAXvCg
 *
 *	@param	p_drawglb	`f[^
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoftSpriteInit( ZKN_GLB_DRAWDATA* p_drawglb, int heap )
{
	NNSGfdTexKey	texKey;
	NNSGfdPlttKey	plttKey;
	int i;

	// |Pf[^]̈Vrammہ]AhXƃTCYݒ
	p_drawglb->soft_sprite_man = SoftSpriteInit( heap );	
	texKey = NNS_GfdAllocTexVram(ZKN_POKEGRA_TEX_SIZE, FALSE, 0);
	plttKey = NNS_GfdAllocPlttVram(ZKN_POKEGRA_PLTT_SIZE, FALSE, NNS_GFD_ALLOC_FROM_LOW);
	SoftSpriteTextureTransParamSet( 
			p_drawglb->soft_sprite_man,
			NNS_GfdGetTexKeyAddr(texKey),
			NNS_GfdGetTexKeySize(texKey) );
	SoftSpritePaletteTransParamSet( 
			p_drawglb->soft_sprite_man,
			NNS_GfdGetPlttKeyAddr(plttKey),
			NNS_GfdGetPlttKeySize(plttKey) );

/*
	OS_Printf( 
			" addr %x size %x \n",
			NNS_GfdGetTexKeyAddr(texKey),
			NNS_GfdGetTexKeySize(texKey) );
	OS_Printf( 
			" addr %x size %x \n ",
			NNS_GfdGetPlttKeyAddr(plttKey),
			NNS_GfdGetPlttKeySize(plttKey) );
//*/

	//
	for( i=0; i<ZKN_DRAWGLB_POKEGRA_NUM; i++ ){
		p_drawglb->soft_sprite[i] = NULL;
	}



	// |POȊÕXvCgVXe
	{
		SWSP_SYSDATA swsp_sys_data = {
			ZKN_SWSP_OBJNUM,
			ZKN_SWSP_CHARNUM,			
			ZKN_SWSP_PLTTNUM,
			0
		};
		swsp_sys_data.heap = heap;

		p_drawglb->swsp_sys = SWSP_SysInit( &swsp_sys_data );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	\tgEFAXvCgj
 *
 *	@param	p_drawglb	`f[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSoftSpriteDelete( ZKN_GLB_DRAWDATA* p_drawglb )
{
	int i;
	
	for( i=0; i<ZKN_DRAWGLB_POKEGRA_NUM; i++ ){

		if( p_drawglb->soft_sprite[i] ){
			SoftSpriteDel( p_drawglb->soft_sprite[i] );
		}
	}
	
	// |P`XvCgf[^j
	SoftSpriteEnd( p_drawglb->soft_sprite_man );


	// \tgEFAXvCg
	SWSP_SysDelete( p_drawglb->swsp_sys );
}


//----------------------------------------------------------------------------
/**
 *	@brief	|Pe[u\[Xǂݍ
 *
 *	@param	p_draw	`f[^
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeNameTblResLoad( ZKN_GLB_DRAWDATA* p_draw, int heap )
{
	ZKN_POKELIST_DATA_OAM_DATA* p_darw_data = &p_draw->pokelist_data_draw;
	ARCHANDLE* p_handle = ZKN_GLBDATA_ArcHandlGet( p_draw );

	
	// LN^f[^ǂݍ
	p_darw_data->pokelist_res_obj[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar_ArcHandle( p_draw->res_manager[ CLACT_U_CHAR_RES ], 
			p_handle, NARC_zukan_zkn_oam_main_lzh_NCGR,
			TRUE, ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			NNS_G2D_VRAM_TYPE_2DMAIN, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_darw_data->pokelist_res_obj[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_darw_data->pokelist_res_obj[ CLACT_U_CHAR_RES ] );

	// pbgf[^ǂݍ
	p_darw_data->pokelist_res_obj[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerResAddArcPltt_ArcHandle( p_draw->res_manager[ CLACT_U_PLTT_RES ],
			p_handle, NARC_zukan_zkn_list_oam_NCLR,
			FALSE, ZKN_DRAWGLB_POKENAME_TBL_RES_ID, NNS_G2D_VRAM_TYPE_2DMAIN, 
			ZKN_DRAWGLB_POKENAME_TBL_PLTT_LOAD, heap );
	// ]
	CLACT_U_PlttManagerSetCleanArea( p_darw_data->pokelist_res_obj[ CLACT_U_PLTT_RES ] );	
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_darw_data->pokelist_res_obj[ CLACT_U_PLTT_RES ] );



	// Zf[^ǂݍ
	p_darw_data->pokelist_res_obj[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw->res_manager[ CLACT_U_CELL_RES ],
			p_handle, NARC_zukan_zkn_oam_main_lzh_NCER,
			TRUE, ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_darw_data->pokelist_res_obj[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw->res_manager[ CLACT_U_CELLANM_RES ],
			p_handle, NARC_zukan_zkn_oam_main_lzh_NANR,
			TRUE, ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			CLACT_U_CELLANM_RES, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pl[e[u\[Xǂݍ
 *
 *	@param	p_data
 *	@param	pp_res_manager
 *	@param	heap 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokeNameTblResLoad_Minute( ZKN_POKELIST_DATA_OAM_DATA* p_data, CLACT_U_RES_MANAGER_PTR* pp_res_manager, int heap )
{
	// LN^f[^ǂݍ
	p_data->pokelist_res_obj[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar( pp_res_manager[ CLACT_U_CHAR_RES ], 
			ARC_ZUKAN_GRA, NARC_zukan_zkn_oam_main_lzh_NCGR,
			TRUE, ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			NNS_G2D_VRAM_TYPE_2DMAIN, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_data->pokelist_res_obj[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_data->pokelist_res_obj[ CLACT_U_CHAR_RES ] );

	// pbgf[^ǂݍ
	p_data->pokelist_res_obj[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerResAddArcPltt( pp_res_manager[ CLACT_U_PLTT_RES ],
			ARC_ZUKAN_GRA, NARC_zukan_zkn_list_oam_NCLR,
			FALSE, ZKN_DRAWGLB_POKENAME_TBL_RES_ID, NNS_G2D_VRAM_TYPE_2DMAIN, 
			ZKN_DRAWGLB_POKENAME_TBL_PLTT_LOAD, heap );
	// ]
	CLACT_U_PlttManagerSetCleanArea( p_data->pokelist_res_obj[ CLACT_U_PLTT_RES ] );	
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_data->pokelist_res_obj[ CLACT_U_PLTT_RES ] );



	// Zf[^ǂݍ
	p_data->pokelist_res_obj[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell(
			pp_res_manager[ CLACT_U_CELL_RES ],
			ARC_ZUKAN_GRA, NARC_zukan_zkn_oam_main_lzh_NCER,
			TRUE, ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_data->pokelist_res_obj[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell(
			pp_res_manager[ CLACT_U_CELLANM_RES ],
			ARC_ZUKAN_GRA, NARC_zukan_zkn_oam_main_lzh_NANR,
			TRUE, ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			CLACT_U_CELLANM_RES, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pe[u\[Xj
 *
 *	@param	p_draw	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeNameTblResRelease( ZKN_GLB_DRAWDATA* p_draw )
{
	ZKN_POKELIST_DATA_OAM_DATA* p_draw_data = &p_draw->pokelist_data_draw;

	CLACT_U_CharManagerDelete( p_draw_data->pokelist_res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_PlttManagerDelete( p_draw_data->pokelist_res_obj[ CLACT_U_PLTT_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			p_draw->res_manager[ CLACT_U_CHAR_RES ],
			p_draw_data->pokelist_res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw->res_manager[ CLACT_U_PLTT_RES ],
			p_draw_data->pokelist_res_obj[ CLACT_U_PLTT_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw->res_manager[ CLACT_U_CELL_RES ],
			p_draw_data->pokelist_res_obj[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw->res_manager[ CLACT_U_CELLANM_RES ],
			p_draw_data->pokelist_res_obj[ CLACT_U_CELLANM_RES ] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pl[e[u@\[Xj
 *
 *	@param	p_data
 *	@param	pp_res_manager 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokeNameTblResRelease_Minute( ZKN_POKELIST_DATA_OAM_DATA* p_data, CLACT_U_RES_MANAGER_PTR* pp_res_manager )
{
	CLACT_U_CharManagerDelete( p_data->pokelist_res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_PlttManagerDelete( p_data->pokelist_res_obj[ CLACT_U_PLTT_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			pp_res_manager[ CLACT_U_CHAR_RES ],
			p_data->pokelist_res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			pp_res_manager[ CLACT_U_PLTT_RES ],
			p_data->pokelist_res_obj[ CLACT_U_PLTT_RES ] );
	CLACT_U_ResManagerResDelete( 
			pp_res_manager[ CLACT_U_CELL_RES ],
			p_data->pokelist_res_obj[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			pp_res_manager[ CLACT_U_CELLANM_RES ],
			p_data->pokelist_res_obj[ CLACT_U_CELLANM_RES ] );
}


//----------------------------------------------------------------------------
/**
 *	@brief	XgAN^[o^
 *
 *	@param	p_draw	`O[o
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeNameTblActAdd( ZKN_GLB_DRAWDATA* p_draw, int heap )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, 0,
			p_draw->res_manager[ CLACT_U_CHAR_RES ],
			p_draw->res_manager[ CLACT_U_PLTT_RES ],
			p_draw->res_manager[ CLACT_U_CELL_RES ],
			p_draw->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^ʕݒ
	add.ClActSet	= p_draw->clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= 0;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
	add.heap		= heap;
	
	// e[u
	add.mat.x = 0;
	add.mat.y = 0;
	p_draw->pokelist_data_draw.pokelist_tbl = CLACT_AddSimple( &add );
	// \
	CLACT_SetDrawFlag( p_draw->pokelist_data_draw.pokelist_tbl, FALSE );
	CLACT_DrawPriorityChg( p_draw->pokelist_data_draw.pokelist_tbl, 1 );

	// ACR
	add.mat.x = 0;
	add.mat.y = 0;
	p_draw->pokelist_data_draw.pokelist_icon = CLACT_AddSimple( &add );
	// \
	CLACT_SetDrawFlag( p_draw->pokelist_data_draw.pokelist_icon, FALSE );
	CLACT_AnmChg( p_draw->pokelist_data_draw.pokelist_icon, 1 );


	// O͓o^Ȃ
	p_draw->pokelist_data_draw.p_pokename = NULL;
	p_draw->pokelist_data_draw.mons_no = 0;
	p_draw->pokelist_data_draw.zkn_mode = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pe[uAN^[j
 *
 *	@param	p_draw	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeNameTblActDelete( ZKN_GLB_DRAWDATA* p_draw )
{
	CLACT_Delete( p_draw->pokelist_data_draw.pokelist_tbl );
	p_draw->pokelist_data_draw.pokelist_tbl = NULL;
	CLACT_Delete( p_draw->pokelist_data_draw.pokelist_icon );
	p_draw->pokelist_data_draw.pokelist_icon = NULL;
	if(p_draw->pokelist_data_draw.p_pokename){
		ZKN_FONTOAM_Delete( p_draw->pokelist_data_draw.p_pokename );
		p_draw->pokelist_data_draw.p_pokename = NULL;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pl[e[uAN^[o^
 *
 *	@param	p_data
 *	@param	clact_set
 *	@param	pp_res_manager
 *	@param	heap 
 *	@param	bg_pri
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokeNameTblActAdd_Minute( ZKN_POKELIST_DATA_OAM_DATA* p_data, CLACT_SET_PTR clact_set, CLACT_U_RES_MANAGER_PTR* pp_res_manager, int heap, int bg_pri )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			ZKN_DRAWGLB_POKENAME_TBL_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, bg_pri,
			pp_res_manager[ CLACT_U_CHAR_RES ],
			pp_res_manager[ CLACT_U_PLTT_RES ],
			pp_res_manager[ CLACT_U_CELL_RES ],
			pp_res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^ʕݒ
	add.ClActSet	= clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= 0;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
	add.heap		= heap;
	
	// e[u
	add.mat.x = 0;
	add.mat.y = 0;
	p_data->pokelist_tbl = CLACT_AddSimple( &add );
	// \
	CLACT_SetDrawFlag( p_data->pokelist_tbl, FALSE );
	CLACT_DrawPriorityChg( p_data->pokelist_tbl, 1 );

	// ACR
	add.mat.x = 0;
	add.mat.y = 0;
	p_data->pokelist_icon = CLACT_AddSimple( &add );
	// \
	CLACT_SetDrawFlag( p_data->pokelist_icon, FALSE );
	CLACT_AnmChg( p_data->pokelist_icon, 1 );


	// O͓o^Ȃ
	p_data->p_pokename = NULL;
	p_data->mons_no = 0;
	p_data->zkn_mode = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pl[e[uAN^[j
 *
 *	@param	p_data 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokeNameTblActDelete_Minute( ZKN_POKELIST_DATA_OAM_DATA* p_data )
{
	CLACT_Delete( p_data->pokelist_tbl );
	p_data->pokelist_tbl = NULL;
	CLACT_Delete( p_data->pokelist_icon );
	p_data->pokelist_icon = NULL;
	if(p_data->p_pokename){
		ZKN_FONTOAM_Delete( p_data->p_pokename );
		p_data->p_pokename = NULL;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pl[e[u`@ONOFF
 *
 *	@param	p_data		|Pl[e[u
 *	@param	flag		`@ON@OFF@tO
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_GlbPokeNameTblDrawFlagSet_Minute( ZKN_POKELIST_DATA_OAM_DATA* p_data, BOOL flag )
{
	if( p_data->pokelist_tbl ){
		CLACT_SetDrawFlag( p_data->pokelist_tbl, flag );
	}
	if( p_data->pokelist_icon ){
		CLACT_SetDrawFlag( p_data->pokelist_icon, flag );
	}
	if( p_data->p_pokename->p_fontoam ){
		FONTOAM_SetDrawFlag( p_data->p_pokename->p_fontoam, flag );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\@\[Xǂݍݏ
 *
 *	@param	p_draw	`O[o
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorResInit( ZKN_GLB_DRAWDATA* p_draw, int heap )
{
	ZKN_UTIL_CURSOR_OBJ* p_cursor = &p_draw->cursor;
	ARCHANDLE* p_handle = ZKN_GLBDATA_ArcHandlGet( p_draw );

	
	// J[\p\[X
	// LN^f[^ǂݍ
	p_cursor->res_obj[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar_ArcHandle( 
			p_draw->res_manager[ CLACT_U_CHAR_RES ], p_handle,
			NARC_zukan_zkn_cursor_oam_sub_lzh_NCGR, TRUE,
			ZKN_CUSOR_RES_ID,
			NNS_G2D_VRAM_TYPE_2DSUB, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_cursor->res_obj[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_cursor->res_obj[ CLACT_U_CHAR_RES ] );

	// pbgf[^ǂݍ
	p_cursor->res_obj[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerResAddArcPltt_ArcHandle( 
			p_draw->res_manager[ CLACT_U_PLTT_RES ], p_handle,
			NARC_zukan_zkn_cursor_oam_sub_NCLR, FALSE, 
			ZKN_CUSOR_RES_ID, 
			NNS_G2D_VRAM_TYPE_2DSUB, 
			ZKN_CURSOR_PLTT_LOAD, heap );
	// ]
	CLACT_U_PlttManagerSetCleanArea( p_cursor->res_obj[ CLACT_U_PLTT_RES ] );	
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_cursor->res_obj[ CLACT_U_PLTT_RES ] );


	// Zf[^ǂݍ
	p_cursor->res_obj[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw->res_manager[ CLACT_U_CELL_RES ], p_handle,
			NARC_zukan_zkn_cursor_oam_sub_lzh_NCER, TRUE,
			ZKN_CUSOR_RES_ID,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_cursor->res_obj[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw->res_manager[ CLACT_U_CELLANM_RES ], p_handle, 
			NARC_zukan_zkn_cursor_oam_sub_lzh_NANR, TRUE,
			ZKN_CUSOR_RES_ID,
			CLACT_U_CELLANM_RES, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\\[X̔j
 *
 *	@param	p_draw	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorResDelete( ZKN_GLB_DRAWDATA* p_draw )
{
	ZKN_UTIL_CURSOR_OBJ* p_cursor = &p_draw->cursor;

	CLACT_U_CharManagerDelete( p_cursor->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_PlttManagerDelete( p_cursor->res_obj[ CLACT_U_PLTT_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			p_draw->res_manager[ CLACT_U_CHAR_RES ],
			p_cursor->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw->res_manager[ CLACT_U_PLTT_RES ],
			p_cursor->res_obj[ CLACT_U_PLTT_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw->res_manager[ CLACT_U_CELL_RES ],
			p_cursor->res_obj[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw->res_manager[ CLACT_U_CELLANM_RES ],
			p_cursor->res_obj[ CLACT_U_CELLANM_RES ] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\ AN^[̓o^
 *
 *	@param	p_draw	`O[o
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorActInit( ZKN_GLB_DRAWDATA* p_draw, int heap )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	int i;
	ZKN_UTIL_CURSOR_OBJ* p_cursor = &p_draw->cursor;

	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			ZKN_CUSOR_RES_ID,
			ZKN_CUSOR_RES_ID, 
			ZKN_CUSOR_RES_ID,
			ZKN_CUSOR_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, 0,
			p_draw->res_manager[ CLACT_U_CHAR_RES ],
			p_draw->res_manager[ CLACT_U_PLTT_RES ],
			p_draw->res_manager[ CLACT_U_CELL_RES ],
			p_draw->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	add.ClActSet	= p_draw->clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= 0;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
	add.heap		= heap;
	add.mat.y		= SUB_SURFACE_Y + (100 * FX32_ONE);	// 0ƏʂɈڂ邽
	add.mat.x		= (100 * FX32_ONE);

	for( i=0; i<ZKN_CURROS_MAT_RECT_NUM; i++ ){
		p_cursor->cursor[i] = CLACT_AddSimple( &add );
		CLACT_AnmChg( p_cursor->cursor[i], i );
	}
	ZKN_UTIL_CursorSetDrawFlag( p_cursor, FALSE );


	// J[\Ajo^
	ZknCursorAnmAdd( p_draw );

	// J[\^XNo^
	ZknCursorMoveTcbAdd( p_draw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\AN^[̔j
 *		
 *	@param	p_draw	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorActDelete( ZKN_GLB_DRAWDATA* p_draw )
{
	int i;
	ZKN_UTIL_CURSOR_OBJ* p_cursor = &p_draw->cursor;

	// J[\Ajj
	ZknCursorMoveTcbDelete( p_draw );

	// J[\Ajj
	ZknCursorAnmDelete( p_draw );

	for( i=0; i<ZKN_CURROS_MAT_RECT_NUM; i++ ){
		CLACT_Delete( p_cursor->cursor[i] );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	}ӃJ[\Aj^XNo^
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorAnmAdd( ZKN_GLB_DRAWDATA* p_draw )
{
	p_draw->cursor_anm_tcb = TCB_Add( ZknCursorAnmTcb, &p_draw->cursor, ZKN_CORSOR_ANM_TCB_PRI );
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\Ajj
 *
 *	@param	p_draw
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorAnmDelete( ZKN_GLB_DRAWDATA* p_draw )
{
	TCB_Delete( p_draw->cursor_anm_tcb );
}	

//----------------------------------------------------------------------------
/**
 *	@brief	}ӃJ[\Aj^XN
 *
 *	@param	tcb
 *	@param	wrok 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorAnmTcb( TCB_PTR tcb, void* work )
{
	ZKN_UTIL_CURSOR_OBJ* p_cursor = work;
	int i;
	int size_x, size_y;
	fx32 calc;
	int count;
	
	// ~`FbN
	if( p_cursor->anm_stop ){
		ZknCursorSetMatrixLocal( p_cursor, p_cursor->x, p_cursor->y,
				p_cursor->size_x, p_cursor->size_y );
		return ;
	}

	p_cursor->anm_count = (p_cursor->anm_count + 1) % ZKN_CURSOR_ANM_COUNT_MAX;

	// JE^l擾
	if( p_cursor->anm_count < ZKN_CURSOR_ANM_COUNT_HALF ){
		count = p_cursor->anm_count;
	}else{
		// 1𑫂 ZKN_CURSOR_ANM_COUNT_HALF==countɂȂ߂ɂ
		// sB"=="ɂȂƂ̈ûsize_x, y̒lςĂ܂Aڂ
		count = ZKN_CURSOR_ANM_COUNT_MAX - (p_cursor->anm_count + 1);
	}

	// TCY߂
	calc = FX_Mul( ZKN_CURSOR_ANM_DIS << FX32_SHIFT, count << FX32_SHIFT );
	calc = FX_Div( calc, ZKN_CURSOR_ANM_COUNT_HALF << FX32_SHIFT );
	calc >>= FX32_SHIFT;
	size_x = p_cursor->size_x + calc;
	size_y = p_cursor->size_y + calc;

	ZknCursorSetMatrixLocal( p_cursor, p_cursor->x, p_cursor->y, size_x, size_y );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Wݒ̂ݍs
 *
 *	@param	p_obj
 *	@param	def_x
 *	@param	def_y
 *	@param	size_x
 *	@param	size_y 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknCursorSetMatrixLocal( ZKN_UTIL_CURSOR_OBJ* p_obj, int def_x, int def_y, int size_x, int size_y )
{
	VecFx32 mat;
	int x, y;
	int i;

	for( i=0; i<ZKN_CURROS_MAT_RECT_NUM; i++ ){
		// W擾
		ZKN_CURSOR_UTIL_GetRectMat( i, &x, &y, def_x, def_y, size_x, size_y );
		mat.x = x << FX32_SHIFT;
		mat.y = (y << FX32_SHIFT) + SUB_SURFACE_Y;

		//@ݒ
		CLACT_SetMatrix( p_obj->cursor[ i ], &mat );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\ړp[^ݒ
 *
 *	@param	p_draw
 *	@param	x
 *	@param	y
 *	@param	size_x
 *	@param	size_y 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------

static void ZknCursorMoveSet( ZKN_GLB_DRAWDATA* p_draw, int x, int y, int size_x, int size_y )
{
	ZKN_UTIL_CURSOR_OBJ_MOVE* p_cursor_move = &p_draw->cursor_move;


	// ̃^[QbgWƈႤƂ̂ݐݒ
	if( (p_cursor_move->ta_x == x) &&
		(p_cursor_move->ta_y == y) &&
		(p_cursor_move->ta_size_x == size_x) &&
		(p_cursor_move->ta_size_y == size_y) ){
		return;
	}

	//@J[\|C^ݒ
	p_cursor_move->p_cursor = &p_draw->cursor;
	
	// ̍W@TCYVWTCYɕύX
	// W
	ZKN_UTIL_MoveReq( &p_cursor_move->mat_move,
			p_cursor_move->p_cursor->x, x,
			p_cursor_move->p_cursor->y, y,
			ZKN_CURSOR_MOVE_SYNC );

	// TCY
	ZKN_UTIL_MoveReq( &p_cursor_move->size_move,
			p_cursor_move->p_cursor->size_x, size_x,
			p_cursor_move->p_cursor->size_y, size_y,
			ZKN_CURSOR_MOVE_SYNC );


	p_cursor_move->ta_x = x;
	p_cursor_move->ta_y = y;
	p_cursor_move->ta_size_x = size_x;
	p_cursor_move->ta_size_y = size_y;

	// Jn
	p_cursor_move->move_stop = TRUE;

/*	OS_Printf( "	p_cursor_move->ta_x %d\n", p_cursor_move->ta_x );
	OS_Printf( "	p_cursor_move->ta_y %d\n", p_cursor_move->ta_y );
	OS_Printf( "	p_cursor_move->ta_size_x %d\n", p_cursor_move->ta_size_x );
	OS_Printf( "	p_cursor_move->ta_size_y %d\n", p_cursor_move->ta_size_y );//*/
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\ړ
 *
 *	@param	tcb		^XNf[^
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorMoveTcb( TCB_PTR tcb, void* p_work )
{
	ZKN_UTIL_CURSOR_OBJ_MOVE* p_cursor_move = p_work;
	BOOL check;

	// ĂȂΓ삵Ȃ
	if( p_cursor_move->move_stop == FALSE ){
		return ;
	}

	// 삳
	check = ZKN_UTIL_MoveMain( &p_cursor_move->mat_move );		
	ZKN_UTIL_MoveMain( &p_cursor_move->size_move );		


	//@lύXꂽ
	// WTCYݒ
	p_cursor_move->p_cursor->x = p_cursor_move->mat_move.x;
	p_cursor_move->p_cursor->y = p_cursor_move->mat_move.y;
	p_cursor_move->p_cursor->size_x = p_cursor_move->size_move.x;
	p_cursor_move->p_cursor->size_y = p_cursor_move->size_move.y;

	// II
	if( check == TRUE ){
		p_cursor_move->move_stop = FALSE;
	}

/*	OS_Printf( "p_cursor_move->p_cursor->x %d\n", p_cursor_move->p_cursor->x );
	OS_Printf( "p_cursor_move->p_cursor->y %d\n", p_cursor_move->p_cursor->y );
	OS_Printf( "p_cursor_move->p_cursor->size_x %d\n", p_cursor_move->p_cursor->size_x );
	OS_Printf( "p_cursor_move->p_cursor->size_y %d\n", p_cursor_move->p_cursor->size_y );//*/
}

//----------------------------------------------------------------------------
/**
 *	@brief	TCBo^
 *
 *	@param	p_draw	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorMoveTcbAdd( ZKN_GLB_DRAWDATA* p_draw )
{
	p_draw->cursor_move_tcb = TCB_Add( ZknCursorMoveTcb, &p_draw->cursor_move, ZKN_CORSOR_MOVE_TCB_PRI );
}

//----------------------------------------------------------------------------
/**
 *	@brief	TCBj
 *
 *	@param	p_draw	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknCursorMoveTcbDelete( ZKN_GLB_DRAWDATA* p_draw )
{
	TCB_Delete( p_draw->cursor_move_tcb );
	p_draw->cursor_move_tcb = NULL;
}
