//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_event_aplchg.c
 *	@brief		AvP[VύXCxg
 *	@author		tomoya takahashi 
 *	@data		2006.01.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>

#include "include/application/zukanlist/zkn_event_func.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void ZknAplStart( ZKN_APL_DATA* p_apl, ZKN_EVENT_SYS_PTR p_event, ZKN_PROC_SYS_PTR p_proc );

//-----------------------------------------------------------------------------
/**
 *		[AvP[VJn
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief		AvP[VJn
 *
 *	@param		p_work	[N
 *
 *	@retval		TRUE	CxgI
 *	@retval		FALSE	Cxgs
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL ZKN_EVENT_AplStart( ZKN_EVENT_WORK* p_work )
{
	ZKN_EVENT_APL_START*	p_data = p_work->p_data;

	switch( p_work->seq ){
	case 0:
		// AvP[VJn
		ZknAplStart( p_data->p_apl, p_data->p_event, p_data->p_proc );
		p_work->seq++;
		break;

	case 1:
		// JnmF
		if( ZKN_PROC_MainMoveCheck( p_data->p_proc ) == TRUE ){
			p_work->seq++;
		}
		break;
		
	case 2:
		return TRUE;
	}

	return FALSE;
}



//-----------------------------------------------------------------------------
/**
 *		ÕAvP[VI[̃AvP[VJn
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief		AvP[VύX
 *
 *	@param		p_work	[N
 *
 *	@retval		TRUE	CxgI
 *	@retval		FALSE	Cxgs
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL ZKN_EVENT_AplChange( ZKN_EVENT_WORK* p_work )
{
	ZKN_EVENT_APL_CHANGE*	p_data = p_work->p_data;

	switch( p_work->seq ){
	//-------------------------------------
	//		̃vZXI
	//=====================================
	case 0:
		ZKN_PROC_EndReq( p_data->p_proc );
		p_work->seq++;
		break;

	//-------------------------------------
	//		I`FbN
	//=====================================
	case 1:
		if( ZKN_PROC_EndCheck( p_data->p_proc ) == TRUE ){
			p_work->seq++;
		}
		break;

	//-------------------------------------
	//		Jn
	//=====================================
	case 2:
		// AvP[VJn
		ZknAplStart( p_data->p_apl, p_data->p_event, p_data->p_proc );
		p_work->seq++;
		break;

	//-------------------------------------
	//		Jn`FbN
	//=====================================
	case 3:
		if( ZKN_PROC_MainMoveCheck( p_data->p_proc ) == TRUE ){
			return TRUE;
		}
		break;

	default:
		// ɂ̂͂
		GF_ASSERT( 0 );
		break;
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 *		̃AvP[VI[}Ӕj
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	̃AvP[VI}ӂ̏I
 *
 *	@param	p_work	[N
 *
 *	@retval		TRUE	CxgI
 *	@retval		FALSE	Cxgs
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL ZKN_EVENT_AplEndZknDelete( ZKN_EVENT_WORK* p_work )
{
	ZKN_EVENT_APL_END_ZKN_DELETE*	p_data = p_work->p_data;
	BOOL check[4];
	int i;

	switch( p_work->seq ){
	//-------------------------------------
	//		̃vZXI
	//=====================================
	case 0:
		ZKN_PROC_EndReq( p_data->p_proc_m );
		ZKN_PROC_EndReq( p_data->p_proc_s );
		ZKN_PROC_EndReq( p_data->p_proc_mc );
		ZKN_PROC_EndReq( p_data->p_proc_sc );
		p_work->seq++;
		break;

	//-------------------------------------
	//		I`FbN
	//=====================================
	case 1:
		check[0] = ZKN_PROC_EndCheck( p_data->p_proc_m );
		check[1] = ZKN_PROC_EndCheck( p_data->p_proc_s );
		check[2] = ZKN_PROC_EndCheck( p_data->p_proc_mc );
		check[3] = ZKN_PROC_EndCheck( p_data->p_proc_sc );
		for( i=0; i<4; i++ ){
			if( check[ i ] == FALSE ){
				break;
			}
		}
		if( i >= 4 ){
			p_work->seq++;
		}
		break;

	//-------------------------------------
	//		jtO𗧂Ă
	//=====================================
	case 2:
		*p_data->p_delete_flag = TRUE;
		return TRUE;

	default:
		// ɂ̂͂
		GF_ASSERT( 0 );
		break;
	}

	return FALSE;
}



//-----------------------------------------------------------------------------
/**
 *	̃AvP[VI
 */
//-----------------------------------------------------------------------------
BOOL ZKN_EVENT_AplEnd( ZKN_EVENT_WORK* p_work )
{
	ZKN_EVENT_APL_END* p_data = p_work->p_data;

	switch( p_work->seq ){
	//-------------------------------------
	//		̃vZXI
	//=====================================
	case 0:
		ZKN_PROC_EndReq( p_data->p_proc );
		p_work->seq++;
		break;

	//-------------------------------------
	//		I`FbN
	//=====================================
	case 1:
		
		if( ZKN_PROC_EndCheck( p_data->p_proc ) ){
			p_work->seq++;
		}
		break;

	//-------------------------------------
	//		jtO𗧂Ă
	//=====================================
	case 2:
		// Cxgf[^j
		ZKN_EVENT_Init( p_data->p_event, NULL, 0 );
		return TRUE;

	default:
		// ɂ̂͂
		GF_ASSERT( 0 );
		break;
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 *		mainʃTuʑSύX
 */
//-----------------------------------------------------------------------------
BOOL ZKN_EVENT_AplAllChange( ZKN_EVENT_WORK* p_work )
{
	ZKN_EVENT_APL_AllCHANGE*	p_data = p_work->p_data;
	BOOL check[4];
	int i;

	switch( p_work->seq ){
	//-------------------------------------
	//		̃vZXI
	//=====================================
	case 0:
		ZKN_PROC_EndReq( p_data->p_proc_m );
		ZKN_PROC_EndReq( p_data->p_proc_s );
		ZKN_PROC_EndReq( p_data->p_proc_mc );
		ZKN_PROC_EndReq( p_data->p_proc_sc );
		p_work->seq++;
		break;

	//-------------------------------------
	//		I`FbN
	//=====================================
	case 1:
		check[0] = ZKN_PROC_EndCheck( p_data->p_proc_m );
		check[1] = ZKN_PROC_EndCheck( p_data->p_proc_s );
		check[2] = ZKN_PROC_EndCheck( p_data->p_proc_mc );
		check[3] = ZKN_PROC_EndCheck( p_data->p_proc_sc );
		for( i=0; i<4; i++ ){
			if( check[ i ] == FALSE ){
				break;
			}
		}
		if( i >= 4 ){
			p_work->seq++;
		}
		break;

	//-------------------------------------
	//		Jn
	//=====================================
	case 2:
		// AvP[VJn
		ZknAplStart( p_data->p_apl_m, p_data->p_event_m, p_data->p_proc_m );
		ZknAplStart( p_data->p_apl_s, p_data->p_event_s, p_data->p_proc_s );
		ZknAplStart( p_data->p_apl_mc, p_data->p_event_mc, p_data->p_proc_mc );
		ZknAplStart( p_data->p_apl_sc, p_data->p_event_sc, p_data->p_proc_sc );
		p_work->seq++;
		break;

	//-------------------------------------
	//		AvP[VJn`FbN	
	//=====================================
	case 3:
		if( p_data->p_apl_m ){
			check[0] = ZKN_PROC_MainMoveCheck( p_data->p_proc_m );
		}else{
			check[0] = TRUE;
		}
		if( p_data->p_apl_s ){
			check[1] = ZKN_PROC_MainMoveCheck( p_data->p_proc_s );
		}
		if( p_data->p_apl_mc ){
			check[2] = ZKN_PROC_MainMoveCheck( p_data->p_proc_mc );
		}else{
			check[2] = TRUE;
		}
		if( p_data->p_apl_sc ){
			check[3] = ZKN_PROC_MainMoveCheck( p_data->p_proc_sc );
		}else{
			check[3] = TRUE;
		}
		
		for( i=0; i<4; i++ ){
			if( check[ i ] == FALSE ){
				break;
			}
		}
		if( i >= 4 ){
			return TRUE;
		}
		break;

	default:
		// ɂ̂͂
		GF_ASSERT( 0 );
		break;
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 *		mainʃTu	QύX
 */
//-----------------------------------------------------------------------------
BOOL ZKN_EVENT_AplDoubleChange( ZKN_EVENT_WORK* p_work )
{
	ZKN_EVENT_APL_DOUBLE_CHANGE*	p_data = p_work->p_data;
	BOOL check[2];
	int i;

	switch( p_work->seq ){
	//-------------------------------------
	//		̃vZXI
	//=====================================
	case 0:
		ZKN_PROC_EndReq( p_data->p_proc_m );
		ZKN_PROC_EndReq( p_data->p_proc_s );
		p_work->seq++;
		break;

	//-------------------------------------
	//		I`FbN
	//=====================================
	case 1:
		check[0] = ZKN_PROC_EndCheck( p_data->p_proc_m );
		check[1] = ZKN_PROC_EndCheck( p_data->p_proc_s );
		for( i=0; i<2; i++ ){
			if( check[ i ] == FALSE ){
				break;
			}
		}
		if( i >= 2 ){
			p_work->seq++;
		}
		break;

	//-------------------------------------
	//		Jn
	//=====================================
	case 2:
		// AvP[VJn
		ZknAplStart( p_data->p_apl_m, p_data->p_event_m, p_data->p_proc_m );
		ZknAplStart( p_data->p_apl_s, p_data->p_event_s, p_data->p_proc_s );
		p_work->seq++;
		break;

	//-------------------------------------
	//		AvP[VJn`FbN
	//=====================================
	case 3:
		if( p_data->p_apl_m ){
			check[0] = ZKN_PROC_MainMoveCheck( p_data->p_proc_m );
		}else{
			check[0] = TRUE;
		}
		if( p_data->p_apl_s ){
			check[1] = ZKN_PROC_MainMoveCheck( p_data->p_proc_s );
		}else{
			check[1] = TRUE;
		}
		
		for( i=0; i<2; i++ ){
			if( check[ i ] == FALSE ){
				break;
			}
		}
		if( i >= 2 ){
			return TRUE;
		}
		break;

	default:
		// ɂ̂͂
		GF_ASSERT( 0 );
		break;
	}

	return FALSE;
}




//-----------------------------------------------------------------------------
/**
 *		vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	AvP[V̊Jn
 *
 *	@param	p_apl		AvP[Vf[^
 *	@param	p_event		CxgVXe
 *	@param	p_proc		vZXVXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void ZknAplStart( ZKN_APL_DATA* p_apl, ZKN_EVENT_SYS_PTR p_event, ZKN_PROC_SYS_PTR p_proc )
{
	ZKN_PROC_INIT			proc_init;

	// AvP[Vf[^邩`FbN
	if( p_apl ){

		// vZXɓo^
		proc_init.p_glb_data	= p_apl->p_glb_data;
		proc_init.p_glb_draw	= p_apl->p_glb_draw;
		proc_init.cp_do_func	= p_apl->do_func;
		proc_init.cp_draw_func	= p_apl->draw_func;
		ZKN_PROC_Init( p_proc, &proc_init );

		// Cxgo^
		ZKN_EVENT_Init( p_event, p_apl->p_event_data, p_apl->event_num );
	}
}








//-----------------------------------------------------------------------------
/**
 *		eAvP[VɕύXCxgf[^쐬֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	Cxgf[^j֐
 *
 *	@param	p_event_data	f[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_DeleteData( ZKN_EVENT_DATA* p_event_data )
{
	GF_ASSERT( p_event_data->work.p_data );

	sys_FreeMemoryEz( p_event_data->work.p_data );
	p_event_data->work.p_data = NULL;
}

// \[g
//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[gɕύXCxg
 *
 *	@param	heap				q[v
 *	@param	p_event_data		Cxgf[^
 *	@param	zkn_sys				}ӃVXe
 *	@param	event_key			CxgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeSortSearch( int heap, ZKN_EVENT_DATA* p_event_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_AllCHANGE* p_e_data;
	
	p_event_data->key_msk	= event_key;
	p_event_data->func		= ZKN_EVENT_AplAllChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_AllCHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_AllCHANGE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );				// vbNVXe
	p_e_data->p_proc_mc	= ZKN_SYS_GetProcSysMainCommon( zkn_sys );		// vbNVXe
	p_e_data->p_proc_sc	= ZKN_SYS_GetProcSysSubCommon( zkn_sys );		// vbNVXe
		
	p_e_data->p_event_m	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe
	p_e_data->p_event_s	= ZKN_SYS_GetEventSysSub( zkn_sys );		// CxgVXe
	p_e_data->p_event_mc= ZKN_SYS_GetEventSysMainCommon( zkn_sys );		// CxgVXe
	p_e_data->p_event_sc= ZKN_SYS_GetEventSysSubCommon( zkn_sys );		// CxgVXe

	p_e_data->p_apl_m	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_SORTSEARCH );		// n߂AvP[Vf[^
	p_e_data->p_apl_s	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_SORTSEARCH );		// n߂AvP[Vf[^
	p_e_data->p_apl_mc	= NULL;		// n߂AvP[Vf[^
	p_e_data->p_apl_sc	= NULL;		// n߂AvP[Vf[^
	
	p_event_data->work.p_data = p_e_data;
}

// }ӃVXeI
//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӏICxg̐
 *
 *	@param	heap			q[vID
 *	@param	p_event_data	Cxgf[^
 *	@param	zkn_sys			}ӃVXe
 *	@param	event_key			CxgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeZukanEnd( int heap, ZKN_EVENT_DATA* p_event_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_END_ZKN_DELETE* p_e_data;
	
	p_event_data->key_msk	= event_key;
	p_event_data->func		= ZKN_EVENT_AplEndZknDelete;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_END_ZKN_DELETE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_END_ZKN_DELETE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );
	p_e_data->p_proc_mc	= ZKN_SYS_GetProcSysMainCommon( zkn_sys );
	p_e_data->p_proc_sc	= ZKN_SYS_GetProcSysSubCommon( zkn_sys );
	p_e_data->p_delete_flag	= ZKN_SYS_GetZknDeleteFlag( zkn_sys );
	
	p_event_data->work.p_data = p_e_data;
}


// }Ӊ
//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӂɕύXCxg
 *
 *	@param	heap				q[v
 *	@param	p_event_data		Cxgf[^
 *	@param	zkn_sys				}ӃVXe
 *	@param	event_key			CxgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeZukan( int heap, ZKN_EVENT_DATA* p_event_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_AllCHANGE* p_e_data;
	
	p_event_data->key_msk	= event_key;
	p_event_data->func		= ZKN_EVENT_AplAllChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_AllCHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_AllCHANGE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );				// vbNVXe
	p_e_data->p_proc_mc	= ZKN_SYS_GetProcSysMainCommon( zkn_sys );		// vbNVXe
	p_e_data->p_proc_sc	= ZKN_SYS_GetProcSysSubCommon( zkn_sys );		// vbNVXe
		
	p_e_data->p_event_m	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe
	p_e_data->p_event_s	= ZKN_SYS_GetEventSysSub( zkn_sys );		// CxgVXe
	p_e_data->p_event_mc= ZKN_SYS_GetEventSysMainCommon( zkn_sys );		// CxgVXe
	p_e_data->p_event_sc= ZKN_SYS_GetEventSysSubCommon( zkn_sys );		// CxgVXe

	p_e_data->p_apl_m	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN );		// n߂AvP[Vf[^
	p_e_data->p_apl_s	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_ZUKAN );		// n߂AvP[Vf[^
	p_e_data->p_apl_mc	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN_COMMON );		// n߂AvP[Vf[^
	p_e_data->p_apl_sc	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_ZUKAN_COMMON );		// n߂AvP[Vf[^
	
	p_event_data->work.p_data = p_e_data;
}

// |PXg
//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXgɈړ
 *
 *	@param	heap		q[v
 *	@param	p_data		Cxgf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	event_key			CxgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangePokeList( int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_AllCHANGE* p_e_data;
	
	p_data->key_msk	= event_key;
	p_data->func		= ZKN_EVENT_AplAllChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_AllCHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_AllCHANGE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );				// vbNVXe
	p_e_data->p_proc_mc	= ZKN_SYS_GetProcSysMainCommon( zkn_sys );		// vbNVXe
	p_e_data->p_proc_sc	= ZKN_SYS_GetProcSysSubCommon( zkn_sys );		// vbNVXe
		
	p_e_data->p_event_m	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe
	p_e_data->p_event_s	= ZKN_SYS_GetEventSysSub( zkn_sys );		// CxgVXe
	p_e_data->p_event_mc= ZKN_SYS_GetEventSysMainCommon( zkn_sys );		// CxgVXe
	p_e_data->p_event_sc= ZKN_SYS_GetEventSysSubCommon( zkn_sys );		// CxgVXe

	p_e_data->p_apl_m	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_POKELIST );		// n߂AvP[Vf[^
	p_e_data->p_apl_s	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_POKELIST );		// n߂AvP[Vf[^
	p_e_data->p_apl_mc	= NULL;		// n߂AvP[Vf[^
	p_e_data->p_apl_sc	= NULL;		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}

// |PXg̏ʂ̂ݕύX
//----------------------------------------------------------------------------
/**
 *	@brief	|PXgăX^[g
 *
 *	@param	p_event		Cxgi[
 *	@param	zkn_sys		}ӃVXe
 *	@param	heap		q[v
 *	@param	event_key			CxgL[
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeStartMainPokeList( ZKN_EVENT_DATA* p_event, ZKN_SYS_PTR zkn_sys, int heap, int event_key )
{
	ZKN_EVENT_APL_CHANGE* p_aplchg;
	
	p_event->key_msk	= event_key;
	p_event->func		= ZKN_EVENT_AplChange;

	// Cxg[N쐬
	p_aplchg = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_CHANGE) );
	GF_ASSERT( p_aplchg );
	p_aplchg->p_apl		= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_POKELIST );
	p_aplchg->p_proc	= ZKN_SYS_GetProcSysMain( zkn_sys );
	p_aplchg->p_event	= ZKN_SYS_GetEventSysMain( zkn_sys );
	
	// Cxg[Nݒ
	p_event->work.p_data = p_aplchg;
}

//----------------------------------------------------------------------------
/**
 *	@brief	z}ړ
 *
 *	@param	heap		q[v
 *	@param	p_data		Cxgf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	event_key	CxgL[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeRange( int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_DOUBLE_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplDoubleChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_DOUBLE_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_DOUBLE_CHANGE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );				// vbNVXe
		
	p_e_data->p_event_m	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe
	p_e_data->p_event_s	= ZKN_SYS_GetEventSysSub( zkn_sys );		// CxgVXe

	p_e_data->p_apl_m	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_RANGE );		// n߂AvP[Vf[^
	p_e_data->p_apl_s	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_RANGE );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}

//----------------------------------------------------------------------------
/**
 *	@brief	z̃CʂύX
 *
 *	@param	heap		q[v
 *	@param	p_data		Cxgf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	event_key	CxgL[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeRangeMain( int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_CHANGE) );
	p_e_data->p_proc	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
		
	p_e_data->p_event	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe

	p_e_data->p_apl	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_RANGE );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ړ
 *
 *	@param	heap		q[v
 *	@param	p_data		Cxgf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	event_key	CxgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeSound( int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_DOUBLE_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplDoubleChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_DOUBLE_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_DOUBLE_CHANGE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );				// vbNVXe
		
	p_e_data->p_event_m	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe
	p_e_data->p_event_s	= ZKN_SYS_GetEventSysSub( zkn_sys );		// CxgVXe

	p_e_data->p_apl_m	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_SOUND );		// n߂AvP[Vf[^
	p_e_data->p_apl_s	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_SOUND );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ړ
 *
 *	@param	heap		q[v
 *	@param	p_data		Cxgf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	event_key	CxgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeSoundMain( int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_CHANGE) );
	p_e_data->p_proc	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
		
	p_e_data->p_event	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe

	p_e_data->p_apl	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_SOUND );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	傫׈ړ
 *
 *	@param	heap		q[v
 *	@param	p_data		Cxgf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	event_key	CxgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeBig( int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_DOUBLE_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplDoubleChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_DOUBLE_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_DOUBLE_CHANGE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );				// vbNVXe
		
	p_e_data->p_event_m	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe
	p_e_data->p_event_s	= ZKN_SYS_GetEventSysSub( zkn_sys );		// CxgVXe

	p_e_data->p_apl_m	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_BIG );		// n߂AvP[Vf[^
	p_e_data->p_apl_s	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_BIG );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	傫׈ړ	
 *
 *	@param	heap		q[v
 *	@param	p_data		Cxgf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	event_key	CxgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeBigMain( int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_CHANGE) );
	p_e_data->p_proc	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
		
	p_e_data->p_event	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe

	p_e_data->p_apl	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_BIG );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}


//----------------------------------------------------------------------------
//
/**
 *
 *	@brief	傫׈ړ	
 *
 *	@param	heap		q[v
 *	@param	p_data		Cxgf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	event_key	CxgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeBigWeightMain( int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_CHANGE) );
	p_e_data->p_proc	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
		
	p_e_data->p_event	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe

	p_e_data->p_apl	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_BIG_WEIGHT );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӂ̂ݍ쐬
 *
 *	@param	heap			q[v
 *	@param	p_event_data	Cxgf[^
 *	@param	zkn_sys			}ӃVXe
 *	@param	event_key		CxgL[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeZukanOnly(  int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key  )
{
	ZKN_EVENT_APL_DOUBLE_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplDoubleChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_DOUBLE_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_DOUBLE_CHANGE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );				// vbNVXe
		
	p_e_data->p_event_m	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe
	p_e_data->p_event_s	= ZKN_SYS_GetEventSysSub( zkn_sys );		// CxgVXe

	p_e_data->p_apl_m	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN );		// n߂AvP[Vf[^
	p_e_data->p_apl_s	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_ZUKAN );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}Ӄf[^Cʂ̂ݍ쐬
 *
 *	@param	heap			q[v
 *	@param	p_event_data	Cxgf[^
 *	@param	zkn_sys			}ӃVXe
 *	@param	event_key		CxgL[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeZukanNormalMainOnly(  int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key  )
{
	ZKN_EVENT_APL_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_CHANGE) );
	p_e_data->p_proc	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
		
	p_e_data->p_event	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe

	p_e_data->p_apl	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}Ӄf[^OtBbNo[W
 *
 *	@param	heap			q[v
 *	@param	p_event_data	Cxgf[^
 *	@param	zkn_sys			}ӃVXe
 *	@param	event_key		CxgL[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeZukanGraphic(  int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key  )
{
	ZKN_EVENT_APL_DOUBLE_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplDoubleChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_DOUBLE_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_DOUBLE_CHANGE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );				// vbNVXe
		
	p_e_data->p_event_m	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe
	p_e_data->p_event_s	= ZKN_SYS_GetEventSysSub( zkn_sys );		// CxgVXe

	p_e_data->p_apl_m	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN_GRA );		// n߂AvP[Vf[^
	p_e_data->p_apl_s	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_ZUKAN_GRA );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}Ӄf[^o[WCʂ̂ݍ쐬
 *
 *	@param	heap			q[v
 *	@param	p_event_data	Cxgf[^
 *	@param	zkn_sys			}ӃVXe
 *	@param	event_key		CxgL[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeZukanTextMainOnly(  int heap, ZKN_EVENT_DATA* p_data, ZKN_SYS_PTR zkn_sys, int event_key  )
{
	ZKN_EVENT_APL_CHANGE* p_e_data;
	
	p_data->key_msk		= event_key;
	p_data->func		= ZKN_EVENT_AplChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_CHANGE) );
	p_e_data->p_proc	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
		
	p_e_data->p_event	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe

	p_e_data->p_apl	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN_TEXT );		// n߂AvP[Vf[^
	
	p_data->work.p_data = p_e_data;
}


//----------------------------------------------------------------------------
/**
 *	@brief	}ӃTuR̂ݕύX
 *
 *	@param	heap			q[v
 *	@param	p_event_data	Cxgf[^i[
 *	@param	zkn_sys			}ӃVXe
 *	@param	event_key		CxgL[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_EVENT_MakeChangeZukanCommonSubOnly( int heap, ZKN_EVENT_DATA* p_event_data, ZKN_SYS_PTR zkn_sys, int event_key )
{
	ZKN_EVENT_APL_CHANGE* p_e_data;
	
	p_event_data->key_msk		= event_key;
	p_event_data->func		= ZKN_EVENT_AplChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_CHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_CHANGE) );
	p_e_data->p_proc	= ZKN_SYS_GetProcSysSubCommon( zkn_sys );			// vbNVXe
		
	p_e_data->p_event	= ZKN_SYS_GetEventSysSubCommon( zkn_sys );		// CxgVXe

	p_e_data->p_apl	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_ZUKAN_COMMON );		// n߂AvP[Vf[^
	
	p_event_data->work.p_data = p_e_data;
}

#ifdef PM_DEBUG
// DEBUGAv
void ZKN_EVENT_BigHeightDebugApl( ZKN_EVENT_DATA* p_event, ZKN_SYS_PTR zkn_sys, int heap, int event_key )
{
	ZKN_EVENT_APL_AllCHANGE* p_e_data;
	
	p_event->key_msk	= event_key;
	p_event->func		= ZKN_EVENT_AplAllChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_AllCHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_AllCHANGE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );				// vbNVXe
	p_e_data->p_proc_mc	= ZKN_SYS_GetProcSysMainCommon( zkn_sys );		// vbNVXe
	p_e_data->p_proc_sc	= ZKN_SYS_GetProcSysSubCommon( zkn_sys );		// vbNVXe
		
	p_e_data->p_event_m	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe
	p_e_data->p_event_s	= ZKN_SYS_GetEventSysSub( zkn_sys );		// CxgVXe
	p_e_data->p_event_mc= ZKN_SYS_GetEventSysMainCommon( zkn_sys );		// CxgVXe
	p_e_data->p_event_sc= ZKN_SYS_GetEventSysSubCommon( zkn_sys );		// CxgVXe

	p_e_data->p_apl_m	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_BIG );		// n߂AvP[Vf[^
	p_e_data->p_apl_s	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_HEIGHT_DEBUG );		// n߂AvP[Vf[^
	p_e_data->p_apl_mc	= NULL;		// n߂AvP[Vf[^
	p_e_data->p_apl_sc	= NULL;		// n߂AvP[Vf[^
	
	p_event->work.p_data = p_e_data;
}

// DEBUGAv獂ׂɕA
void ZKN_EVENT_BigHeightDebugAplReturn( ZKN_EVENT_DATA* p_event, ZKN_SYS_PTR zkn_sys, int heap, int event_key )
{
	ZKN_EVENT_APL_AllCHANGE* p_e_data;
	
	p_event->key_msk	= event_key;
	p_event->func		= ZKN_EVENT_AplAllChange;
	
	// Cxgf[^쐬
	p_e_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_APL_AllCHANGE) );
	GF_ASSERT( p_e_data );
	memset( p_e_data, 0, sizeof(ZKN_EVENT_APL_AllCHANGE) );
	p_e_data->p_proc_m	= ZKN_SYS_GetProcSysMain( zkn_sys );			// vbNVXe
	p_e_data->p_proc_s	= ZKN_SYS_GetProcSysSub( zkn_sys );				// vbNVXe
	p_e_data->p_proc_mc	= ZKN_SYS_GetProcSysMainCommon( zkn_sys );		// vbNVXe
	p_e_data->p_proc_sc	= ZKN_SYS_GetProcSysSubCommon( zkn_sys );		// vbNVXe
		
	p_e_data->p_event_m	= ZKN_SYS_GetEventSysMain( zkn_sys );		// CxgVXe
	p_e_data->p_event_s	= ZKN_SYS_GetEventSysSub( zkn_sys );		// CxgVXe
	p_e_data->p_event_mc= ZKN_SYS_GetEventSysMainCommon( zkn_sys );		// CxgVXe
	p_e_data->p_event_sc= ZKN_SYS_GetEventSysSubCommon( zkn_sys );		// CxgVXe

	p_e_data->p_apl_m	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_BIG );		// n߂AvP[Vf[^
	p_e_data->p_apl_s	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_BIG );		// n߂AvP[Vf[^
	p_e_data->p_apl_mc	= ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN_COMMON );		// n߂AvP[Vf[^
	p_e_data->p_apl_sc	= ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_ZUKAN_COMMON );		// n߂AvP[Vf[^
	
	p_event->work.p_data = p_e_data;
}
#endif

