//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	@file		zkn_height_gram.c
 *	@brief		|P@dANZX
 *	@author		tomoya takahashi 
 *	@data		2006.02.02
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>

#include "include/system/arc_tool.dat"
#include "include/system/arc_util.h"
#include "src/application/zukanlist/zkn_data/zukan_data.naix"

#define __ZKN_HEIGHT_GRAM_H_GLOBAL
#include "include/application/zukanlist/zkn_height_gram.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	d
//=====================================
typedef struct _ZKN_HEIGHT_GRAM{
	int* p_height;
	int* p_gram;

	// `֌W
	short* p_height_y;
	short* p_height_y_poke;
	short* p_height_scale;
	short* p_height_scale_poke;
} ZKN_HEIGHT_GRAM;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static int* LoadHeight( int heap );
static int* LoadGram( int heap );
static void LoadHeightY_man( short** p_hero, short** p_poke, int heap );
static void LoadHeightY_girl( short** p_hero, short** p_poke, int heap );
static void LoadHeightScale_man( short** p_hero, short** p_poke, int heap );
static void LoadHeightScale_girl( short** p_hero, short** p_poke, int heap );

//----------------------------------------------------------------------------
/**
 *	@brief	di[GA쐬
 *
 *	@param	heap	gpq[v
 *
 *	@return	GA
 */
//-----------------------------------------------------------------------------
ZKN_HEIGHT_GRAM_PTR ZKN_HEIGHTGRAM_Alloc( int heap )
{
	ZKN_HEIGHT_GRAM_PTR p_heightgram;

	p_heightgram = sys_AllocMemory( heap, sizeof(ZKN_HEIGHT_GRAM) );
	memset( p_heightgram, 0, sizeof(ZKN_HEIGHT_GRAM) );

	return p_heightgram;
}

//----------------------------------------------------------------------------
/**
 *	@brief	di[GAj
 *
 *	@param	p_heightgram	jdata
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_HEIGHTGRAM_Free( ZKN_HEIGHT_GRAM_PTR p_heightgram )
{
	GF_ASSERT( p_heightgram );

	sys_FreeMemoryEz( p_heightgram );
	p_heightgram = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	dǂݍ
 *
 *	@param	p_heightgram	i[GA
 *	@param	type			f[^^Cv
 *	@param	heap			q[v
 *
 *	@return	none
 *
 * type
 *		ZKN_HEIGHT_GRAM_TYPE_MAN,	// lj
 *		ZKN_HEIGHT_GRAM_TYPE_GIRL,	// l
 *	
 */
//-----------------------------------------------------------------------------
void ZKN_HEIGHTGRAM_Load( ZKN_HEIGHT_GRAM_PTR p_heightgram, int type, int heap )
{
	GF_ASSERT( p_heightgram );

	// ǂݍݍς݂łB
	GF_ASSERT(p_heightgram->p_height == NULL);
	GF_ASSERT(p_heightgram->p_gram == NULL);

	p_heightgram->p_height = LoadHeight( heap );
	p_heightgram->p_gram = LoadGram( heap );

	// \p[^
	if( type == ZKN_HEIGHT_GRAM_TYPE_MAN ){
		LoadHeightY_man( &p_heightgram->p_height_y, &p_heightgram->p_height_y_poke, heap );
		LoadHeightScale_man( &p_heightgram->p_height_scale, &p_heightgram->p_height_scale_poke, heap );
	}else{
		LoadHeightY_girl( &p_heightgram->p_height_y, &p_heightgram->p_height_y_poke, heap );
		LoadHeightScale_girl( &p_heightgram->p_height_scale, &p_heightgram->p_height_scale_poke, heap );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	dj
 *
 *	@param	p_heightgram	jdata
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_HEIGHTGRAM_Release( ZKN_HEIGHT_GRAM_PTR p_heightgram )
{
	GF_ASSERT( p_heightgram->p_height );
	GF_ASSERT( p_heightgram->p_gram );
	
	sys_FreeMemoryEz( p_heightgram->p_height );
	sys_FreeMemoryEz( p_heightgram->p_gram );

	sys_FreeMemoryEz( p_heightgram->p_height_y );
	sys_FreeMemoryEz( p_heightgram->p_height_y_poke );
	sys_FreeMemoryEz( p_heightgram->p_height_scale );
	sys_FreeMemoryEz( p_heightgram->p_height_scale_poke );
	
	p_heightgram->p_height	= NULL;
	p_heightgram->p_gram	= NULL;
	p_heightgram->p_height_y = NULL;
	p_heightgram->p_height_y_poke = NULL;
	p_heightgram->p_height_scale = NULL;
	p_heightgram->p_height_scale_poke = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	擾
 *
 *	@param	cp_heightgram		d
 *	@param	mons_no				X^[io[
 *
 *	@return	10{l
 */
//-----------------------------------------------------------------------------
int ZKN_HEIGHTGRAM_GetHeight( CONST_ZKN_HEIGHT_GRAM_PTR cp_heightgram, int mons_no )
{
	GF_ASSERT( cp_heightgram );
	GF_ASSERT( cp_heightgram->p_height );
	return cp_heightgram->p_height[ mons_no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	d擾
 *
 *	@param	cp_heightgram		d
 *	@param	mons_no				X^[io[
 *
 *	@return	d10{l
 */
//-----------------------------------------------------------------------------
int ZKN_HEIGHTGRAM_GetGram( CONST_ZKN_HEIGHT_GRAM_PTR cp_heightgram, int mons_no )
{
	GF_ASSERT( cp_heightgram );
	GF_ASSERT( cp_heightgram->p_gram );
	return cp_heightgram->p_gram[ mons_no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	ׁ@l̕\ItZbgʒu
 *
 *	@param	cp_heightgram		f[^[N
 *	@param	mons_no				|Pio[
 *
 *	@return	ItZbgl
 */
//-----------------------------------------------------------------------------
short ZKN_HEIGHTGRAM_GetHeightY_hero( CONST_ZKN_HEIGHT_GRAM_PTR cp_heightgram, int mons_no )
{
	GF_ASSERT( cp_heightgram );
	GF_ASSERT( cp_heightgram->p_height_y );
	return cp_heightgram->p_height_y[ mons_no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	ׁ@|P̕\ItZbgʒu
 *
 *	@param	cp_heightgram	f[^[N
 *	@param	mons_no			X^[io[ 
 *
 *	@return	ItZbgl
 */
//-----------------------------------------------------------------------------
short ZKN_HEIGHTGRAM_GetHeightY_poke( CONST_ZKN_HEIGHT_GRAM_PTR cp_heightgram, int mons_no )
{
	GF_ASSERT( cp_heightgram );
	GF_ASSERT( cp_heightgram->p_height_y_poke );
	return cp_heightgram->p_height_y_poke[ mons_no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	ׁ@lgkl
 *
 *	@param	cp_heightgram	f[^[N
 *	@param	mons_no			X^[io[
 *	
 *	@return	gkl
 */
//-----------------------------------------------------------------------------
short ZKN_HEIGHTGRAM_GetHeightScale_hero( CONST_ZKN_HEIGHT_GRAM_PTR cp_heightgram, int mons_no )
{
	GF_ASSERT( cp_heightgram );
	GF_ASSERT( cp_heightgram->p_height_scale );
	return cp_heightgram->p_height_scale[ mons_no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	ׁ@|Pgkl
 *
 *	@param	cp_heightgram	f[^[N
 *	@param	mons_no			X^[io[
 *	
 *	@return	gkl
 */
//-----------------------------------------------------------------------------
short ZKN_HEIGHTGRAM_GetHeightScale_poke( CONST_ZKN_HEIGHT_GRAM_PTR cp_heightgram, int mons_no )
{
	GF_ASSERT( cp_heightgram );
	GF_ASSERT( cp_heightgram->p_height_scale_poke );
	return cp_heightgram->p_height_scale_poke[ mons_no ];
}







//----------------------------------------------------------------------------
/**
 *	@brief	f[^ǂݍ
 *
 *	@param	heap	q[v
 *
 *	@return	ǂݍ݃f[^
 */
//-----------------------------------------------------------------------------
static int* LoadHeight( int heap )
{
	void* buff;

	buff = ArcUtil_Load( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_height_dat, FALSE, heap, ALLOC_TOP );
	

	return (int*)buff;
}

//----------------------------------------------------------------------------
/**
 *	@brief	df[^ǂݍ
 *
 *	@param	heap	q[v
 *
 *	@return	ǂݍ݃f[^
 */
//-----------------------------------------------------------------------------
static int* LoadGram( int heap )
{
	void* buff;

	buff = ArcUtil_Load( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_gram_dat, FALSE, heap, ALLOC_TOP );

	return (int*)buff;
}

//----------------------------------------------------------------------------
/**
 *	@brief	\YWz
 *
 *	@param	p_hero		l
 *	@param	p_poke		|P
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void LoadHeightY_man( short** p_hero, short** p_poke, int heap )
{

	*p_hero = (short*)ArcUtil_Load( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_height_y_man_dat, FALSE, heap, ALLOC_TOP );
	*p_poke = (short*)ArcUtil_Load( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_height_y_man_poke_dat, FALSE, heap, ALLOC_TOP );
}

//----------------------------------------------------------------------------
/**
 *	@brief	\YWz
 *
 *	@param	p_hero		l
 *	@param	p_poke		|P
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void LoadHeightY_girl( short** p_hero, short** p_poke, int heap )
{
	*p_hero = (short*)ArcUtil_Load( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_height_y_girl_dat, FALSE, heap, ALLOC_TOP );
	*p_poke = (short*)ArcUtil_Load( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_height_y_girl_poke_dat, FALSE, heap, ALLOC_TOP );
}

//----------------------------------------------------------------------------
/**
 *	@brief	\gklz
 *
 *	@param	p_hero		l
 *	@param	p_poke		|P
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void LoadHeightScale_man( short** p_hero, short** p_poke, int heap )
{
	*p_hero = (short*)ArcUtil_Load( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_height_scale_man_dat, FALSE, heap, ALLOC_TOP );
	*p_poke = (short*)ArcUtil_Load( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_height_scale_man_poke_dat, FALSE, heap, ALLOC_TOP );
}

//----------------------------------------------------------------------------
/**
 *	@brief	\gklz
 *
 *	@param	p_hero		l
 *	@param	p_poke		|P
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void LoadHeightScale_girl( short** p_hero, short** p_poke, int heap )
{
	*p_hero = (short*)ArcUtil_Load( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_height_scale_girl_dat, FALSE, heap, ALLOC_TOP );
	*p_poke = (short*)ArcUtil_Load( ARC_ZUKAN_DATA, NARC_zukan_data_zkn_height_scale_girl_poke_dat, FALSE, heap, ALLOC_TOP );
}	

