//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_pokelist.c
 *	@brief		|PXg
 *	@author		tomoya takahashi
 *	@data		2006.01.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>

#include "include/application/zukanlist/zkn_event_func.h"
#include "include/system/brightness.h"
#include "include/system/arc_util.h"
#include "include/system/fontproc.h"
#include "include/system/msgdata_util.h"
#include "include/msgdata/msg.naix"
#include "include/msgdata/msg_zkn.h"
#include "include/application/zukanlist/zkn_snd_def.h"

#include "include/application/zukanlist/zukan.naix"

#define __ZKN_POKELIST_H_GLOBAL
#include "include/application/zukanlist/zkn_pokelist.h"

// GtFNgōWLink邽߁AdȂCN[h
#include "include/application/zukanlist/zkn_zukan.h"


//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
// |PXg`揈V[PX
//=====================================
enum{
	ZKN_POKELIST_DRAWINIT_SEQ_GRA_LOAD,
	ZKN_POKELIST_DRAWINIT_SEQ_FADEIN,
	ZKN_POKELIST_DRAWINIT_SEQ_FADEIN_WAIT,
	ZKN_POKELIST_DRAWINIT_SEQ_END,
};

//-------------------------------------
// |PXg`揈CV[PX
//=====================================
enum{
	ZKN_POKELIST_DRAWMAIN_SEQ_END,
};

//-------------------------------------
// |PXg`揈jV[PX
//=====================================
enum{
	ZKN_POKELIST_DRAWEND_SEQ_FADEOUT,
	ZKN_POKELIST_DRAWEND_SEQ_FADEOUT_WAIT,
	ZKN_POKELIST_DRAWEND_SEQ_GRA_RELEASE,
	ZKN_POKELIST_DRAWEND_SEQ_END,
};


#define EVENT_DATA_NUM		( 5 )

// Cxg萔
#define EVENT_MSK_POKELIST_CHENGE_SORTSEARCH	( 1 << 0 )
#define EVENT_MSK_POKELIST_CHENGE_ZUKAN			( 1 << 1 )
#define EVENT_MSK_POKELIST_ZUKAN_END			( 1 << 2 )
#define EVENT_MSK_POKELIST_MAIN_CHANGE			( 1 << 3 )
#define EVENT_MSK_POKELIST_CHANGE				( 1 << 4 )

// 萔
#define ZKN_POKE_LIST_MOVE_CHENGE_NUM		( 4 )	// Xs[hύX
#define ZKN_POKE_LIST_MOVE_CHENGE_TIMING	( 4 )	// ̉񐔃|Pf[^io[ύXXs[hύX
#define ZKN_POKE_LIST_MOVE_COUNT_S		( 60 )	// 1=10̒P
#define ZKN_POKE_LIST_MOVE_COUNT_MUL	( 1.60f )	// JEgAbvZl

#define ZKN_POKE_LIST_MOVE_SKIP_NUM	( 5 )		// XLbv


// tF[hC萔
#define ZKN_POKELIST_FADEIN_SYNC	( ZKN_FADE_SYNC_LONG_COMMON)		// tF[hCVN
// tF[hAEg萔
#define ZKN_POKELIST_FADEOUT_SYNC	( ZKN_FADE_SYNC_LONG_COMMON)		// tF[hCVN

// BGuCglXtF[h
#define ZKN_POKELSIT_BRIGHTNESS_MSK	( GX_BLEND_PLANEMASK_BG0|GX_BLEND_PLANEMASK_BG3|GX_BLEND_PLANEMASK_OBJ|GX_BLEND_PLANEMASK_BD )	// ʏ
#define ZKN_POKELSIT_BRIGHTNESS_ZUKAN_MSK	( GX_BLEND_PLANEMASK_BG3|GX_BLEND_PLANEMASK_BD )	// }ӃtF[hp
#define ZKN_POKELIST_BRIGHTNESS_ZUKAN_END_MSK	( GX_BLEND_PLANEMASK_BG1|GX_BLEND_PLANEMASK_BG2|GX_BLEND_PLANEMASK_BG3|GX_BLEND_PLANEMASK_BD )



// wi
#define ZKN_POKELIST_BACK_POKEFRAME_CX	( 1 )
#define ZKN_POKELIST_BACK_POKEFRAME_CY	( 4 )


// 
#define ZKN_POKELIST_STR_Y			( 152 )
#define ZKN_POKELIST_SEE_STR_X		( 8 )
#define ZKN_POKELIST_GET_STR_X		( 128 )
#define ZKN_POKELIST_SEE_NUM_X		( 48 )
#define ZKN_POKELIST_SEE_NUM_Y		( 170 )
#define ZKN_POKELIST_GET_NUM_X		( 180 )
#define ZKN_POKELIST_GET_NUM_Y		( 170 )
#define ZKN_POKELIST_NUM_STR		( 32 )	// obt@TCY
#define ZKN_POKELIST_PLACE			( 3 )	// 




// ZAN^[\[X
#define ZKN_POKELIST_CELL_CG_NUM	( 2 )
#define ZKN_POKELIST_CELL_CL_NUM	( 2 )
#define ZKN_POKELIST_CELL_CE_NUM	( 2 )
#define ZKN_POKELIST_CELL_AN_NUM	( 2 )


// |Pe[u萔
#define ZKN_POKELIST_POKETBL_NUM	(9)		// \p|Pe[u
#define ZKN_POKELIST_POKETBL_CHECK	(4)		// I|P̈ʒu
#define ZKN_POKELIST_POKETBL_TBL_DEFX	( 180 * FX32_ONE )
#define ZKN_POKELIST_POKETBL_TBL_CHECKX	( ZKN_POKELIST_TBL_MAT_X * FX32_ONE )
const static ZknPokeListPokeTblMoveX[] = {		// e[u
	ZKN_POKELIST_POKETBL_TBL_DEFX + 9*FX32_ONE,		// T
	ZKN_POKELIST_POKETBL_TBL_DEFX + 5*FX32_ONE,		// ` 
	ZKN_POKELIST_POKETBL_TBL_DEFX + 1*FX32_ONE,		// ` 
	ZKN_POKELIST_POKETBL_TBL_DEFX - 3*FX32_ONE,		// ` 
	ZKN_POKELIST_POKETBL_TBL_DEFX - 5*FX32_ONE,		// `
	ZKN_POKELIST_POKETBL_TBL_CHECKX,	// I
	ZKN_POKELIST_POKETBL_TBL_DEFX - 5*FX32_ONE,		// `
	ZKN_POKELIST_POKETBL_TBL_DEFX - 3*FX32_ONE,		// `
	ZKN_POKELIST_POKETBL_TBL_DEFX + 1*FX32_ONE,		// `
	ZKN_POKELIST_POKETBL_TBL_DEFX + 5*FX32_ONE,		// `
	ZKN_POKELIST_POKETBL_TBL_DEFX + 9,		// T
};
const static ZknPokeListPokeTblMoveY[] = {		// e[u
	12 * FX32_ONE,
	22 * FX32_ONE,		// `
	26 * FX32_ONE,
	42 * FX32_ONE, 
	58 * FX32_ONE,
	82 * FX32_ONE,		// I
	106 * FX32_ONE,
	122 * FX32_ONE,
	138 * FX32_ONE,
	142 * FX32_ONE,		// ܂
	152 * FX32_ONE,
};
#if 0
const static ZknPokeListPokeTblMoveX[] = {		// e[u
	ZKN_POKELIST_POKETBL_TBL_DEFX,		// \
	ZKN_POKELIST_POKETBL_TBL_DEFX,		// T
	ZKN_POKELIST_POKETBL_TBL_DEFX,		// ` 
	ZKN_POKELIST_POKETBL_TBL_DEFX,		// `
	ZKN_POKELIST_POKETBL_TBL_CHECKX,	// I
	ZKN_POKELIST_POKETBL_TBL_DEFX,		// `
	ZKN_POKELIST_POKETBL_TBL_DEFX,		// `
	ZKN_POKELIST_POKETBL_TBL_DEFX,		// T
	ZKN_POKELIST_POKETBL_TBL_DEFX,		// \
};
const static ZknPokeListPokeTblMoveY[] = {		// e[u
	7 * FX32_ONE,	// 5
	12 * FX32_ONE,	// 10
	22 * FX32_ONE,	// 26
	48 * FX32_ONE,  // 34
	82 * FX32_ONE,
	116 * FX32_ONE,
	142 * FX32_ONE,
	152 * FX32_ONE,
	157 * FX32_ONE,
};
#endif
#define ZKN_POKELIST_PLTT_SELECT	(0)		// ̃Xg̃J[
#define ZKN_POKELIST_PLTT_OTHER0	(7)		// ̑̃Xg̃J[
#define ZKN_POKELIST_PLTT_OTHER1	(8)		// ̑̃Xg̃J[
#define ZKN_POKELIST_PLTT_OTHER2	(9)		// ̑̃Xg̃J[

#define ZKN_POKELIST_OAM_BG_PRI	( 2 )


// Cursor萔
#define ZKN_POKELIST_CURSOR_X		( 248 * FX32_ONE )	// XW
#define ZKN_POKELIST_CURSOR_YMIN	( 58 * FX32_ONE )	// ŏYW
#define ZKN_POKELIST_CURSOR_YDIS	( 54 * FX32_ONE )	// Yړ


// |POAM萔
#define ZKN_POKELIST_ICON_ANMSEQ	( 1 )
#define ZKN_POKELIST_ICON_PRI		( 0 )
#define ZKN_POKELIST_POKETBL_ANMSEQ	( 0 )
#define ZKN_POKELIST_POKETBL_PRI	( 32 )
#define ZKN_POKELIST_CURSOR_ANMSEQ	( 2 )
#define ZKN_POKELIST_CURSOR_PRI		( 0 )





//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	|PXg`O[of[^
//=====================================
typedef struct {
	ZKN_GLB_DRAWDATA*	p_drawglb;			// `O[of[^
} ZKN_POKELIST_GLB_DRAW;


//-------------------------------------
//	|PXg[N
//=====================================
typedef struct {
	int move_way;			// ۑ
	int move_count_add_num;	// O[of[^move_countZ
	int move_speed_chg_timing;	// Xs[hύX^C~O
	int move_speed_chg_num;	// Xs[hύX

	int sub_seq;		// Tuœp̃V[PX
	
	BOOL skip_flag;		// XLbvtO
	int skip_count;		// XLbvJE^
	int skip_add;		// 1̑Zl
	int skip_way;		// XLbv

} ZKN_POKELIST_WORK;

//-------------------------------------
//	|PXgOtBbN[N
//=====================================
typedef struct {
	CLACT_WORK_PTR	poke_tbl[ ZKN_POKELIST_POKETBL_NUM ];// |Pe[u
	int poke_tbl_start;				// |Pe[u̍WO̗vf
	ZKN_FONTOAM_DATA* poke_name[ ZKN_POKELIST_POKETBL_NUM ];// |POAM
	int poke_name_char_size;		// |P̃LN^f[^]̈̃TCY

	CLACT_WORK_PTR	icon[ ZKN_POKELIST_POKETBL_NUM ];// |Pe[uwACR
	CLACT_WORK_PTR	cursor;			// Ŝ݂̌̈ʒuJ[\
	fx32	onepoke_move_dis;		// 1̃|PCursor̈ړl

	CLACT_WORK_PTR dummy_poke;	// |POtBbN_~[
	
	// \[X}l[W
	CLACT_U_RES_MANAGER_PTR	res_manager[ ZKN_CLACT_RES_MANAGER_NUM ];	
	
	// ZAN^[o^wb_
	CLACT_HEADER		clheader;
	CLACT_HEADER		clheader_dummy_poke;

	void*			p_util_scrn_buff;
	NNSG2dScreenData* p_util_scrn;	// [eBeBʂ̃XN[f[^
	ZKN_UTIL_BGSHTTER_DADE bg_fade;	// BGʃtF[hf[^

	// }ӃtF[hp샏[N
	ZKN_UTIL_MOVE_WORK pokegra_move;
	ZKN_UTIL_MOVE_WORK pokelist_move;


	// ɕ\Ă|P̃e[uvfiZKN_GLBDATA.ZKN_POKELIST_TBL̔z̗vf j
	int draw_poke_name;				
} ZKN_POKELIST_GRAWORK;


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		AvP[Vf[^쐬֌W
 */
//-----------------------------------------------------------------------------
static ZKN_POKELIST_GLB_DATA* MakeGlbData( int heap, ZKN_SYS_PTR zkn_sys );
static void DeleteGlbData( ZKN_POKELIST_GLB_DATA* p_glb );

static ZKN_POKELIST_GLB_DRAW* MakeGlbDraw( int heap, ZKN_SYS_PTR zkn_sys );
static void DeleteGlbDraw( ZKN_POKELIST_GLB_DRAW* p_glb );

// Cxgf[^֌W
static ZKN_EVENT_DATA* MakeEventData( int heap, ZKN_APL_DATA* p_data, ZKN_SYS_PTR zkn_sys );
static void DeleteEventData( ZKN_EVENT_DATA* p_event_data );
static int EventDataNumGet( void );


//-----------------------------------------------------------------------------
/**
 *		AvP[VvZX֌W
 */
//-----------------------------------------------------------------------------
// vZX֐
static int ZknPokeListProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknPokeListProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknPokeListProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknPokeListProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknPokeListProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknPokeListProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );

// FadeInOut
static void ZknPokeListDefaultFadeReq( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out );
static BOOL ZknPokeListDefaultFadeEndCheck( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out );
static void ZknPokeListChZukanFadeReq( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out );
static BOOL ZknPokeListChZukanFadeEndCheck( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out );

static void PokeListBgFadeInit( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out );
static BOOL PokeListBgFadeMain( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb );
static void PokeListBgFadeDel( ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out );

static void PokeListPokeGraFadeInit( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb );
static BOOL PokeListPokeGraFadeMain( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb );
static void PokeListPokeListFadeInit( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb );
static BOOL PokeListPokeListFadeMain( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb );


// 암
static void PokeListMoveMain( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work, int heap );
static BOOL PokeListMoveIf( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work, int heap );
static void PokeListMoveIfFlagReset( ZKN_POKELIST_GLB_DATA* p_glb );
static void PokeListMoveIfKey( ZKN_POKELIST_GLB_DATA* p_glb );
static void PokeListMoveInit( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work );
static void PokeListMoveUp( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work );
static void PokeListMoveReq( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work, int way );
static BOOL PokeListMoveAdd( ZKN_POKELIST_GLB_DATA* p_glb, int num );

static BOOL PokeListListReset( ZKN_POKELIST_WORK* p_work, ZKN_POKELIST_GLB_DATA* p_glb );
static BOOL PokeListListStart( ZKN_POKELIST_WORK* p_work, ZKN_POKELIST_GLB_DATA* p_glb );
static BOOL PokeListListEnd( ZKN_POKELIST_WORK* p_work, ZKN_POKELIST_GLB_DATA* p_glb );

static void PokeListSkipMoveInit( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work );

static void PokeListZukanDel( ZKN_POKELIST_GLB_DATA* p_glb );
static void PokeListZukanChg( ZKN_POKELIST_WORK* p_work, ZKN_POKELIST_GLB_DATA* p_glb );
static BOOL PokeListSortChg( ZKN_POKELIST_GLB_DATA* p_glb );
static BOOL PokeListZukanModeChg( ZKN_POKELIST_GLB_DATA* p_glb, int heap );
static void PokeListZukanReset( ZKN_POKELIST_GLB_DATA* p_glb, int heap );
static void PokeListSkipMove( ZKN_POKELIST_WORK* p_work, ZKN_POKELIST_GLB_DATA* p_glb );
static void PokeListKeyMove( ZKN_POKELIST_WORK* p_work, ZKN_POKELIST_GLB_DATA* p_glb );

// [N쐬
static void PokeListDrawWorkInit( ZKN_POKELIST_GRAWORK*	p_work, const ZKN_POKELIST_GLB_DATA* cp_dataglb );

// t@Cǂݍ݁ʍ쐬
static void PokeListLoadGraphicFile( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap );
static void PokeListReleaseGraphicFile( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb );
static void PokeListLoadGraphicFileSortMode( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap );
static void PokeListReleaseGraphicFileSortMode( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb );

static void PokeListBackGroundSetUp( ZKN_GLB_DRAWDATA* p_drawglb, int heap );
static void PokeListUtilSetUp( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, int heap, int zkn_mode );
static void PokeListUtilDelete( ZKN_POKELIST_GRAWORK* p_work );
static void PokeListFontSetUp( ZKN_GLB_DRAWDATA* p_drawglb, int heap, int see_num, int get_num );
static void PokeListSortVerFontSetUp( ZKN_GLB_DRAWDATA* p_drawglb, int heap, int list_num );
static void PokeListResManagerMake( ZKN_POKELIST_GRAWORK* p_work, int heap );
static void PokeListResManagerDelete( ZKN_POKELIST_GRAWORK* p_work );
static void PokeListClActResLoad( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, int heap );
static void PokeListClActAdd( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, int heap );
static void PokeListClActDelete( ZKN_POKELIST_GRAWORK* p_work );

static int PokeListPokeNameCharTransSizeGet( ZKN_GLB_DRAWDATA* p_drawglb, int heap );
static void PokeListPokeNameSetUp( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap );
static void PokeListPokeNameDelete( ZKN_POKELIST_GRAWORK* p_work );
static void PokeGraphicSetUp( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb );


static void PokeListOamFadeInit( ZKN_POKELIST_GRAWORK* p_work );
static void PokeListOamFadeDelete( ZKN_POKELIST_GRAWORK* p_work );

// CLACT_OBJp[^vZݒ֐S
static void PokeListPokeTblInit( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb );
static void PokeListPokeTblMove( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb );
static void PokeListPokeTblDrawFlagSetUp( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb );
static void PokeListPokeTblListStartNumChenge( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb );
static void PokeListIconMove( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb );
static void PokeListCursorInit( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb );
static void PokeListCursorMove( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb );

static void PokeListPokeNameMove( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap );
static void PokeListPokeNameMoveNameChange( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap );
static void PokeListPokeNameChange( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap, int pokename_tbl_no, int pokelist_tbl_no );
static void PokeListPokeNameDummySet( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, int heap, int pokename_tbl_no, int pokenum );
static void PokeListPokeNameMoveMatGet( CLACT_WORK_PTR target_act, int* x, int* y );
static fx32 PokeListPokeTblMoveCalc( fx32 s, fx32 e, int max_count, int count );
static void PokeListPokeGraMove( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb );
static void PokeListDummyPokeGraMove( const ZKN_POKELIST_GLB_DATA* cp_glb );
static void PokeListPokeGraAlphaInit( ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb );
static void PokeListSelectPokeDataGlbSet( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	AvP[Vf[^	쐬
 *
 *	@param	p_data		AvP[Vf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	heap		q[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_PokeListAplMake( ZKN_APL_DATA* p_data, ZKN_SYS_PTR zkn_sys, int heap )
{
	ZKN_POKELIST_GLB_DATA* p_glb;
	ZKN_POKELIST_GLB_DRAW* p_glb_draw;
	ZKN_EVENT_DATA*	p_event_data_tbl;

	p_glb = MakeGlbData( heap, zkn_sys );
	p_glb_draw = MakeGlbDraw( heap, zkn_sys );
	p_event_data_tbl = MakeEventData( heap, p_data, zkn_sys );

	p_data->p_glb_data		= p_glb;
	p_data->p_glb_draw		= p_glb_draw;
	p_data->p_event_data	= p_event_data_tbl;
	p_data->event_num		= EventDataNumGet();

	p_data->do_func[ ZKN_PROC_FUNC_INIT ] = ZknPokeListProcDoFuncInit;
	p_data->do_func[ ZKN_PROC_FUNC_MAIN ] = ZknPokeListProcDoFuncMain;
	p_data->do_func[ ZKN_PROC_FUNC_DELETE ] = ZknPokeListProcDoFuncDelete;
	p_data->draw_func[ ZKN_PROC_FUNC_INIT ] = ZknPokeListProcDrawFuncInit;
	p_data->draw_func[ ZKN_PROC_FUNC_MAIN ] = ZknPokeListProcDrawFuncMain;
	p_data->draw_func[ ZKN_PROC_FUNC_DELETE ] = ZknPokeListProcDrawFuncDelete;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	AvP[Vf[^j
 *
 *	@param	p_data	AvP[Vf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_PokeListAplDelete( ZKN_APL_DATA* p_data )
{
	DeleteGlbData( p_data->p_glb_data );
	DeleteGlbDraw( p_data->p_glb_draw );
	DeleteEventData( p_data->p_event_data );
}



//----------------------------------------------------------------------------
/**
 *	@brief	߹ؽăCxgݒ肵đv`FbN
 *
 *	@param	cp_glb	O[of[^
 *
 *	@retval	TRUE	悢
 *	@retval	FALSE	
 */
//-----------------------------------------------------------------------------
BOOL ZKN_PokeList_SubEventSetOkCheck( const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	if( (cp_glb->zukan_sort_end == TRUE) ||		
		(cp_glb->zukan_end == TRUE) ||
		(cp_glb->zukan_see == TRUE) ||
		(cp_glb->zukan_chg == TRUE) ||
		(cp_glb->sort_chg  == TRUE) ){

		return FALSE;
	}
	return TRUE;
}




//-----------------------------------------------------------------------------
/**
 *		vCx[g֐
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		AvP[Vf[^쐬֌W
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg̃O[of[^쐬
 *
 *	@param	heap		q[v	
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_POKELIST_GLB_DATA* MakeGlbData( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_POKELIST_GLB_DATA*	p_glb;

	// m
	p_glb = sys_AllocMemory( heap, sizeof(ZKN_POKELIST_GLB_DATA) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_POKELIST_GLB_DATA) );
	
	// CxgL[|C^擾
	p_glb->p_event_key = ZKN_SYS_GetEventKeyPtrMain( zkn_sys );

	// }ӂ̊eAvP[VLf[^
	p_glb->p_glb = ZKN_SYS_GetGlbData( zkn_sys );


	// tF[hC[hύX
	p_glb->fade_mode = ZKN_POKELIST_BG_FADE_NORMAL;

	// }Ӄf[^ʂւ̃tF[h`FbNtO
	p_glb->fade_zukan_data = FALSE;

	// `XVtO
	p_glb->move_draw = TRUE;
	
	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	O[of[^j
 *
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteGlbData( ZKN_POKELIST_GLB_DATA* p_glb )
{
	GF_ASSERT( p_glb );
	
	sys_FreeMemoryEz(p_glb);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg̃O[of[^쐬
 *
 *	@param	heap		q[v	
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_POKELIST_GLB_DRAW* MakeGlbDraw( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_POKELIST_GLB_DRAW*	p_glb;

	// m
	p_glb = sys_AllocMemory( heap, sizeof(ZKN_POKELIST_GLB_DRAW) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_POKELIST_GLB_DRAW) );
	

	// }ӂ̊eAvP[VLOtBbNf[^
	p_glb->p_drawglb = ZKN_SYS_GetGlbDrawData( zkn_sys );
	
	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	O[of[^j
 *
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteGlbDraw( ZKN_POKELIST_GLB_DRAW* p_glb )
{
	GF_ASSERT( p_glb );
	
	sys_FreeMemoryEz(p_glb);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Cxgf[^e[u쐬
 *
 *	@param	heap		q[v
 *	@param	p_data		AvP[Vf[^
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	Cxgf[^e[u
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_EVENT_DATA* MakeEventData( int heap, ZKN_APL_DATA* p_data, ZKN_SYS_PTR zkn_sys )
{
	ZKN_EVENT_DATA* p_event_data;

	p_event_data = sys_AllocMemory( heap, sizeof(ZKN_EVENT_DATA) *  EventDataNumGet() );
	ZKN_EVENT_MakeChangeSortSearch( heap, &p_event_data[0], zkn_sys, EVENT_MSK_POKELIST_CHENGE_SORTSEARCH );
	ZKN_EVENT_MakeChangeZukan( heap, &p_event_data[1], zkn_sys, EVENT_MSK_POKELIST_CHENGE_ZUKAN );
	ZKN_EVENT_MakeZukanEnd( heap, &p_event_data[2], zkn_sys, EVENT_MSK_POKELIST_ZUKAN_END );
	ZKN_EVENT_MakeStartMainPokeList( &p_event_data[3], zkn_sys, heap, EVENT_MSK_POKELIST_MAIN_CHANGE );
	ZKN_EVENT_MakeChangePokeList( heap, &p_event_data[4], zkn_sys, EVENT_MSK_POKELIST_CHANGE );

	return p_event_data;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Cxgf[^j
 *
 *	@param	p_event_data		Cxgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteEventData( ZKN_EVENT_DATA* p_event_data )
{
	GF_ASSERT( p_event_data );
	
	ZKN_EVENT_DeleteData( &p_event_data[0] );
	ZKN_EVENT_DeleteData( &p_event_data[1] );
	ZKN_EVENT_DeleteData( &p_event_data[2] );
	ZKN_EVENT_DeleteData( &p_event_data[3] );
	ZKN_EVENT_DeleteData( &p_event_data[4] );

	sys_FreeMemoryEz( p_event_data );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	Cxg擾
 *
 *	@param	none
 *
 *	@return	Cxg
 *
 *
 */
//-----------------------------------------------------------------------------
static int EventDataNumGet( void )
{
	return	EVENT_DATA_NUM;
}




//-----------------------------------------------------------------------------
/**
 *		AvP[VvZX֌W
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	[]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_POKELIST_GLB_DATA* p_glb = p_glbdata;
	
	// [N
	p_dodata->p_work = sys_AllocMemory( p_dodata->heap, sizeof(ZKN_POKELIST_WORK) );
	GF_ASSERT( p_dodata->p_work );
	memset( p_dodata->p_work, 0, sizeof(ZKN_POKELIST_WORK) );

	// f[^ݒ
	PokeListMoveInit( p_glb, p_dodata->p_work );

	// ̃|PXgʒuɕ`ʒu킹
	ZKN_GLBDATA_PokeListDrawTblSetNowTblNo( p_glb->p_glb );
	
	// `XVtO
	p_glb->move_draw = TRUE;

	// zC[bNtO
	p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_NONE;


	// Ӱނ̂Ƃ̓tF[h߂Vb^[ɂ
	if( p_glb->fade_sort_data == TRUE ){
		p_glb->fade_mode = ZKN_POKELIST_BG_FADE_SHUTTER;
	}

	// tȌ
	PokeListMoveIfFlagReset( p_glb );

	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 *	[C]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_POKELIST_GLB_DATA* p_glb = p_glbdata;
	ZKN_POKELIST_WORK*	p_work = p_dodata->p_work;


	// I
	if( p_dodata->end_req == TRUE ){
		return ZKN_PROC_TRUE;
	}

	if( p_dodata->seq == 0 ){		//@
		p_glb->fade_sort_data = FALSE;
		p_dodata->seq = 1;
	}else{		// C

		// CXg
		PokeListMoveMain( p_glb, p_work, p_dodata->heap );
	}


	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	[j]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	// [Nj
	sys_FreeMemoryEz( p_dodata->p_work );
	p_dodata->p_work = NULL;
	
	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 * []
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	ZKN_POKELIST_GLB_DRAW* p_drawglb = p_glbdraw;
	const ZKN_POKELIST_GLB_DATA* cp_dataglb = cp_glbdata;
	const ZKN_POKELIST_WORK*	cp_datawork = cp_dodata->p_work;
	ZKN_POKELIST_GRAWORK*		p_work = p_drawdata->p_work;
	BOOL check;

	// f[^t@Cǂݍݏ@tF[h
	switch( p_drawdata->seq ){
	case ZKN_POKELIST_DRAWINIT_SEQ_GRA_LOAD:
		// [N쐬
		p_work = sys_AllocMemory( p_drawdata->heap, sizeof(ZKN_POKELIST_GRAWORK) );
		GF_ASSERT(p_work);
		p_drawdata->p_work = p_work;
		PokeListDrawWorkInit( p_work, cp_dataglb );

		// |POtBbNZbgAbv
		PokeGraphicSetUp( p_work, p_drawglb->p_drawglb, cp_dataglb );

		
		p_drawdata->seq++;
		break;

	case  ZKN_POKELIST_DRAWINIT_SEQ_FADEIN:
		// |P̃OtBbN]̂܂
		// OtBbNf[^ǂݍ
		if( cp_dataglb->p_glb->sort_search_flag == ZKN_SORTSEARCH_NONE ){
			// ʏ
			PokeListLoadGraphicFile( p_work, p_drawglb->p_drawglb, cp_dataglb, p_drawdata->heap );
		}else{
			// Ӱ
			PokeListLoadGraphicFileSortMode( p_work, p_drawglb->p_drawglb, cp_dataglb, p_drawdata->heap );
		}

		// }ӗptF[hʏtF[h`FbN
		if( cp_dataglb->fade_zukan_data ){

			ZknPokeListChZukanFadeReq( p_work, p_drawglb, cp_dataglb, TRUE );
		}else{
			ZknPokeListDefaultFadeReq( p_work, p_drawglb, cp_dataglb, TRUE );
		}

		p_drawdata->seq++;
		break;
		
	case ZKN_POKELIST_DRAWINIT_SEQ_FADEIN_WAIT:
	
		// }ӗptF[hʏtF[h`FbN
		if( cp_dataglb->fade_zukan_data ){
			check = ZknPokeListChZukanFadeEndCheck( p_work, p_drawglb, cp_dataglb, TRUE );
		}else{
			check = ZknPokeListDefaultFadeEndCheck( p_work, p_drawglb, cp_dataglb, TRUE );
		}
		if( check ){
			p_drawdata->seq++;
		}
		break;
		
	case ZKN_POKELIST_DRAWINIT_SEQ_END:
		// l̐ݒ
		G2_SetBlendAlpha( GX_BLEND_PLANEMASK_BG0, GX_BLEND_PLANEMASK_BG3, 0, 16 );
		return ZKN_PROC_TRUE;

	default:
		// ɂ̂͂
		GF_ASSERT(0);
		break;
	}
	
	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [C]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	ZKN_POKELIST_GLB_DRAW* p_drawglb = p_glbdraw;
	const ZKN_POKELIST_GLB_DATA* cp_glb = cp_glbdata;
	const ZKN_POKELIST_WORK*	cp_datawork = cp_dodata->p_work;
	ZKN_POKELIST_GRAWORK*		p_work = p_drawdata->p_work;
	int tbl_no;

	// `XVONOFF
	if( cp_glb->move_draw == FALSE ){
		return ZKN_PROC_FALSE;
	}

	// ݕ\̑I|Pio[XV
	tbl_no = ZKN_GLBDATA_PokeListDrawTblNoGet( cp_glb->p_glb );
	if( p_work->draw_poke_name != tbl_no ){
		// Z^[\e[uio[ݒ
		p_work->draw_poke_name = tbl_no;

		// XgύX
		// |PXge[u̐擪ύX鏈
		// Xg̕\\Ǘ
		PokeListPokeTblListStartNumChenge( p_work, cp_glb );
	
		// |PLN^f[^ύX
		PokeListPokeNameMoveNameChange( p_work, p_drawglb->p_drawglb, cp_glb, p_drawdata->heap );

		// |POtBbN̕ύX
		PokeGraphicSetUp( p_work, p_drawglb->p_drawglb, cp_glb );
	}
	
	// Xg`Wݒ
	PokeListPokeTblMove( p_work, cp_glb );
	PokeListIconMove( p_work, cp_glb );
	PokeListCursorMove( p_work, cp_glb );
	PokeListPokeNameMove( p_work, p_drawglb->p_drawglb, cp_glb, p_drawdata->heap );
	PokeListPokeGraMove( p_work, p_drawglb->p_drawglb, cp_glb );
	PokeListDummyPokeGraMove( cp_glb );

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [j]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknPokeListProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	ZKN_POKELIST_GLB_DRAW* p_drawglb = p_glbdraw;
	const ZKN_POKELIST_GLB_DATA* cp_dataglb = cp_glbdata;
	const ZKN_POKELIST_WORK*	cp_datawork = cp_dodata->p_work;
	ZKN_POKELIST_GRAWORK*		p_work = p_drawdata->p_work;
	BOOL check;

	// f[^t@Cǂݍݏ@tF[h
	switch( p_drawdata->seq ){
	case ZKN_POKELIST_DRAWEND_SEQ_FADEOUT:
		G2_BlendNone();

		// }ӗptF[hʏtF[h`FbN
		if( cp_dataglb->fade_zukan_data ){
			// O[oGAɃ|PXg쐬
			PokeListSelectPokeDataGlbSet( p_work, p_drawglb->p_drawglb, cp_dataglb, p_drawdata->heap );

			// |POtBbNlZbg
			PokeListPokeGraAlphaInit( p_drawglb->p_drawglb, cp_dataglb );

			ZknPokeListChZukanFadeReq( p_work, p_drawglb, cp_dataglb, FALSE );
		}else{
			ZknPokeListDefaultFadeReq( p_work, p_drawglb, cp_dataglb, FALSE );
		}
		p_drawdata->seq++;
		break;
		
	case ZKN_POKELIST_DRAWEND_SEQ_FADEOUT_WAIT:
		// }ӗptF[hʏtF[h`FbN
		if( cp_dataglb->fade_zukan_data ){
			check = ZknPokeListChZukanFadeEndCheck( p_work, p_drawglb, cp_dataglb, FALSE );
		}else{
			check = ZknPokeListDefaultFadeEndCheck( p_work, p_drawglb, cp_dataglb, FALSE );
		}
		if( check ){
			p_drawdata->seq++;
		}
		break;

	case ZKN_POKELIST_DRAWEND_SEQ_GRA_RELEASE:
		PokeListReleaseGraphicFile( p_work, p_drawglb->p_drawglb );

		// p[Nj
		sys_FreeMemoryEz( p_work );
		p_drawdata->seq++;
		break;
		
		
	case ZKN_POKELIST_DRAWEND_SEQ_END:
		return ZKN_PROC_TRUE;

	default:
		// ɂ̂͂
		GF_ASSERT(0);
		break;
	}
	
	return ZKN_PROC_FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg쏉
 *
 *	@param	p_glb	O[of[^
 *	@param	p_work	[N
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListMoveInit( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work )
{
	p_glb->move_way					= ZKN_POKE_LIST_NO_MOVE;
	p_work->move_way				= ZKN_POKE_LIST_NO_MOVE;
	p_work->move_count_add_num		= ZKN_POKE_LIST_MOVE_COUNT_S;
	p_work->move_speed_chg_timing	= ZKN_POKE_LIST_MOVE_CHENGE_TIMING;
	p_work->move_speed_chg_num		= ZKN_POKE_LIST_MOVE_CHENGE_NUM;
}

//----------------------------------------------------------------------------
/**
 *	@brief	XLbv쏉
 *
 *	@param	p_glb
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void PokeListSkipMoveInit( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work )
{
	p_work->move_count_add_num		= ZKN_POKELIST_MOVE_END_COUNT;
	p_work->move_speed_chg_timing	= 0;
	p_work->move_speed_chg_num		= 0;
}


//----------------------------------------------------------------------------
/**
 *	@brief	|PXgC
 *
 *	@param	p_glb	O[of[^
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListMoveMain( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work, int heap )
{
	// 򏈗
	if( PokeListMoveIf( p_glb, p_work, heap ) == TRUE ){
		return ;	// ʐ؂ւsꂽ̂ŁÂ܂ܔ
		// ͂āAMoveIfFlagResets
		// pokelist_sub̃Xg擪AŏIWvsł悤ɂȂႢ܂
	}

	// tȌ
	PokeListMoveIfFlagReset( p_glb );


	// ~Ă
	if( p_work->move_way == ZKN_POKE_LIST_NO_MOVE ){

		// XLbv
		if( p_work->skip_flag == TRUE ){

			// XLbv
			PokeListSkipMove( p_work, p_glb );
		}else{

			// XLbvłȂƂ̏
			PokeListKeyMove( p_work, p_glb );
		}
	}


	// 
	if( p_glb->sub_wheel_lock != ZKN_POKELIST_WHEEL_LOCK_NONE ){
		PokeListMoveUp( p_glb, p_work );
	}

	// ^b`plƕ^C~OɂȂ悤
	// ̈ʒuŕL[
	PokeListMoveIfKey( p_glb );
	
}


//----------------------------------------------------------------------------
/**
 *	@brief	tOZbg
 *
 *	@param	p_glb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void PokeListMoveIfFlagReset( ZKN_POKELIST_GLB_DATA* p_glb )
{
	p_glb->zukan_sort_end = FALSE;			// SORT[hI
	p_glb->zukan_end = FALSE;				// }ӏI
	p_glb->zukan_see = FALSE;				// }Ӄf[^
	p_glb->zukan_chg = FALSE;				// }Ӄ[hύX
	p_glb->sort_chg = FALSE;				// SORTʂ֕ύX
}

//----------------------------------------------------------------------------
/**
 *	@brief	zL[
 *
 *	@param	p_glb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void PokeListMoveIfKey( ZKN_POKELIST_GLB_DATA* p_glb )
{
	if( sys.trg & PAD_BUTTON_B ){
		if(  p_glb->p_glb->sort_search_flag == ZKN_SORTSEARCH_NONE ){
			p_glb->zukan_end = TRUE;
		}else{
			p_glb->zukan_sort_end = TRUE;
		}
		return ;
	}

	if( sys.trg & PAD_BUTTON_A ){
		p_glb->zukan_see = TRUE;
		return ;
	}

//	if( sys.trg & PAD_BUTTON_START ){
	if( sys.trg & PAD_BUTTON_X ){
		p_glb->sort_chg = TRUE;
		return ;
	}

	if( sys.trg & PAD_BUTTON_SELECT ){
		p_glb->zukan_chg = TRUE;
		return ;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	򏈗
 *
 *	@param	p_glb
 *	@param	p_work
 *	@param	heap 
 *
 *	@retval	TRUE	
 *	@retval	FALSE	Ȃ
 */
//-----------------------------------------------------------------------------
static BOOL PokeListMoveIf( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work, int heap )
{
	// }ӔjCxg
	if( p_glb->zukan_end ){

		PokeListZukanDel( p_glb );
		
		// LZ
		Snd_SePlay( ZKN_SND_CANCEL );
		return TRUE;
	}

	// SORT[hZbg
	if( p_glb->zukan_sort_end ){

		PokeListZukanReset( p_glb, heap );
		// LZ
		Snd_SePlay( ZKN_SND_CANCEL );
		return TRUE;
	}

	// }Ӊʂ
	if( p_glb->zukan_see ){
		int draw_tbl_no = ZKN_GLBDATA_PokeListDrawTblNoGet( p_glb->p_glb );
		// 邩`FbN
		if( ZKN_GLBDATA_PokeListDrawTblDataGet( p_glb->p_glb, draw_tbl_no ) != POKEMON_LIST_DRAWTBL_DUMMY ){
			
			PokeListZukanChg( p_work, p_glb );

			// I
			Snd_SePlay( ZKN_SND_SELECT );
			return TRUE;
		}

	}//*/

	// SORTʂ
	if( p_glb->sort_chg ){
		return PokeListSortChg( p_glb );
	}

	// }ӂ؂ւ
	if( p_glb->zukan_chg ){
		return PokeListZukanModeChg( p_glb, heap );
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	Xs[hAbv
 *
 *	@param	p_glb		O[of[^
 *	@param	p_work		[N
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListMoveUp( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work )
{
	// ĂȂȂ甲
	if( p_work->move_way == ZKN_POKE_LIST_NO_MOVE ){
		return;
	}

	// VNύX
	if( (p_glb->move_count - p_work->move_count_add_num) > 0 ){
		// JEg
		p_glb->move_count -= p_work->move_count_add_num;
	}else{
		// JEgI
		p_glb->move_count = 0;
		p_work->move_way = ZKN_POKE_LIST_NO_MOVE;

		if( p_work->move_speed_chg_num > 0 ){
			// JEgAbvXs[hύX邩`FbN
			if( (p_work->move_speed_chg_timing - 1) > 0 ){
				p_work->move_speed_chg_timing--;
			}else{
				p_work->move_count_add_num *= ZKN_POKE_LIST_MOVE_COUNT_MUL;
				p_work->move_speed_chg_num --;

				// ύX邽тɃXs[hAbvԊu傫
				p_work->move_speed_chg_timing = ZKN_POKE_LIST_MOVE_CHENGE_TIMING * (ZKN_POKE_LIST_MOVE_CHENGE_NUM - p_work->move_speed_chg_num);
			}
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	JnNGXgo
 *
 *	@param	p_glb	O[of[^
 *	@param	p_work	[N
 *	@param	way		
 *	
 *	@return	none
 *
	ZKN_POKE_LIST_UP,			// Ɉړ
	ZKN_POKE_LIST_DOWN,			// Ɉړ
 *
 */
//-----------------------------------------------------------------------------
static void PokeListMoveReq( ZKN_POKELIST_GLB_DATA* p_glb, ZKN_POKELIST_WORK* p_work, int way )
{
	p_glb->move_count			= ZKN_POKELIST_MOVE_END_COUNT;
	p_work->move_way			= way;
	p_glb->move_way				= way;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	w|P|Pi߂
 *
 *	@param	p_glb	O[of[^
 *	@param	num		i߂l
 *
 *	@retval	TRUE	XVꂽ
 *	@retval	FALSE	l͕ςȂ
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL PokeListMoveAdd( ZKN_POKELIST_GLB_DATA* p_glb, int num )
{
	return ZKN_GLBDATA_PokeListDrawTblNoAdd( p_glb->p_glb, num );
}




//----------------------------------------------------------------------------
/**
 *
 *	@brief	`t@Cǂݍ݁
 *
 *	@param	p_work			f[^i[[N
 *	@param	p_drawglb		`O[of[^
 *	@param	cp_glb			O[of[^
 *	@param	heap			gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListLoadGraphicFile( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap )
{
	// BG
	// pbgf[^]
	ZKN_GLBDATA_PalSet( p_drawglb, NARC_zukan_zkn_list_NCLR, PALTYPE_MAIN_BG, 0, 0, heap );

	// wiʐݒ
	PokeListBackGroundSetUp( p_drawglb, heap );

	// [eBeB
	PokeListUtilSetUp( p_work, p_drawglb, heap, ZKN_GLBDATA_PokeZknModeGet( cp_glb->p_glb ) );

	// 
	PokeListFontSetUp( p_drawglb, heap, 
			ZKN_GLBDATA_PokeSeeNumGet( cp_glb->p_glb ),
			ZKN_GLBDATA_PokeGetNumGet( cp_glb->p_glb ) );


	// Zf[^ǂݍ
	// \[X}l[W
	PokeListResManagerMake( p_work, heap );

	// \[Xǂݍ
	PokeListClActResLoad( p_work, p_drawglb, heap );

	// AN^[o^
	PokeListClActAdd( p_work, p_drawglb, heap );

	// OAMo^
	// |Pe[u]̈̃LN^TCY߂
	p_work->poke_name_char_size = PokeListPokeNameCharTransSizeGet( p_drawglb, heap );

	// ̈쐬
	PokeListPokeNameSetUp( p_work, p_drawglb, cp_glb, heap );


	// AN^[W̃ZbgAbv
	PokeListPokeTblInit( p_work, cp_glb );
	PokeListPokeTblMove( p_work, cp_glb );
	PokeListIconMove( p_work, cp_glb );
	PokeListCursorInit( p_work, cp_glb );
	PokeListCursorMove( p_work, cp_glb );

	// 񓮍
	PokeListPokeNameMove(p_work, p_drawglb, cp_glb, heap);

	// |P̃lZbgAbv
	PokeListPokeGraMove( p_work, p_drawglb, cp_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ǂݍ݃f[^j
 *
 *	@param	p_work			[Nf[^
 *	@param	p_drawglb		`O[of[^
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListReleaseGraphicFile( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb )
{
	// Zf[^
	// SZAN^[̔j
	PokeListClActDelete( p_work );	
	
	// \[X}l[Ŵ͂
	PokeListResManagerDelete( p_work );

	// OAMj
	PokeListPokeNameDelete( p_work );

	// [eBeBʃf[^j
	PokeListUtilDelete( p_work );

}

//----------------------------------------------------------------------------
/**
 *	@brief	\[X̓ǂݍݿă[h
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[oް
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListLoadGraphicFileSortMode( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap )
{
	void* p_palBuff;
	NNSG2dPaletteData* p_palData;
	u8* p_pal_data;
	
	// BG
	// J[pbg]
	ZKN_GLBDATA_PalSet( p_drawglb, NARC_zukan_zkn_sort1_NCLR, PALTYPE_MAIN_BG, 0, 32, heap );
	// pbgf[^]
	p_palBuff = ZKN_GLBDATA_PalDataGet( p_drawglb, NARC_zukan_zkn_list_NCLR, &p_palData, heap );

	// vZ₷̂u8*ɃLXg
	p_pal_data = (u8*)p_palData->pRawData;
	DC_FlushRange( p_pal_data, 16*32 );
	GX_LoadBGPltt( p_pal_data + 32, 32, 15*32 );
	sys_FreeMemoryEz( p_palBuff );

	// wiʐݒ
	PokeListBackGroundSetUp( p_drawglb, heap );

	// [eBeB
	PokeListUtilSetUp( p_work, p_drawglb, heap, ZKN_GLBDATA_PokeZknModeGet( cp_glb->p_glb ) );

	// Zf[^ǂݍ
	// \[X}l[W
	PokeListResManagerMake( p_work, heap );

	// \[Xǂݍ
	PokeListClActResLoad( p_work, p_drawglb, heap );

	// AN^[o^
	PokeListClActAdd( p_work, p_drawglb, heap );

	// OAMo^
	// |Pe[u]̈̃LN^TCY߂
	p_work->poke_name_char_size = PokeListPokeNameCharTransSizeGet( p_drawglb, heap );

	// ̈쐬
	PokeListPokeNameSetUp( p_work, p_drawglb, cp_glb, heap );

	// 
	PokeListSortVerFontSetUp( p_drawglb, heap, 
			ZKN_GLBDATA_PokeSeeNumGet( cp_glb->p_glb ) );


	// AN^[W̃ZbgAbv
	PokeListPokeTblInit( p_work, cp_glb );
	PokeListPokeTblMove( p_work, cp_glb );
	PokeListIconMove( p_work, cp_glb );
	PokeListCursorInit( p_work, cp_glb );
	PokeListCursorMove( p_work, cp_glb );

	// 񓮍
	PokeListPokeNameMove(p_work, p_drawglb, cp_glb, heap);

	// |P̃lZbgAbv
	PokeListPokeGraMove( p_work, p_drawglb, cp_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGʂ̃ZbgAbv
 *
 *	@param	p_drawglb	`O[of[^
 *	@param	heap		gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListBackGroundSetUp( ZKN_GLB_DRAWDATA* p_drawglb, int heap )
{
	void* buff;
	NNSG2dScreenData* p_scrn;
	
	// LN^f[^]
	ZKN_GLBDATA_BgCharSet( p_drawglb, NARC_zukan_zkn_list_main_lzh_NCGR, p_drawglb->p_bg, ZKN_BG_FRM_BACK_M, 0, 0, TRUE, heap );

	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb, NARC_zukan_zkn_list_bg_main1_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_drawglb->p_bg, ZKN_BG_FRM_BACK_M,
			p_scrn->rawData, 0, 0,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );

	// |P̕\gwiɓ\t	
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb, NARC_zukan_zkn_list_bg_main1a_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_drawglb->p_bg, ZKN_BG_FRM_BACK_M, p_scrn->rawData,
			ZKN_POKELIST_BACK_POKEFRAME_CX, ZKN_POKELIST_BACK_POKEFRAME_CY,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );
	
	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_drawglb->p_bg, ZKN_BG_FRM_BACK_M );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg̐}Ӗ\ʐݒ
 *
 *	@param	p_work			`惏[N
 *	@param	p_drawglb		`O[of[^
 *	@param	heap			q[v 
 *	@param	zkn_mode		}Ӄ[h
 *
 *	@return	none
 *
 * zkn_mode
	ZKN_MODE_SHINOH,	// VIE}
	ZKN_MODE_ZENKOKU,	// S}
 *
 */
//-----------------------------------------------------------------------------
static void PokeListUtilSetUp( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, int heap, int zkn_mode )
{
	int dataidx;
	
	// LN^f[^]
	ZKN_GLBDATA_BgCharSet( p_drawglb, NARC_zukan_zkn_list_main_lzh_NCGR, p_drawglb->p_bg, ZKN_BG_FRM_UTIL_M, 0, 0, TRUE, heap );

	// SƃVIEŃf[^idxύX
	if( zkn_mode == ZKN_MODE_ZENKOKU ){
		dataidx = NARC_zukan_zkn_list_bg_zen_lzh_NSCR;
	}else{
		dataidx = NARC_zukan_zkn_list_bg_sin_lzh_NSCR;
	}
	
	// XN[f[^ǂݍ
	p_work->p_util_scrn_buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb, dataidx, TRUE, &p_work->p_util_scrn, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	[eBeBʃf[^j
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListUtilDelete( ZKN_POKELIST_GRAWORK* p_work )
{
	sys_FreeMemoryEz( p_work->p_util_scrn_buff );
	p_work->p_util_scrn_buff = NULL;
	p_work->p_util_scrn = NULL;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXgtHgʐݒ
 *
 *	@param	p_drawglb	`O[of[^
 *	@param	heap		q[vID
 *	@param	see_num		
 *	@param	get_num		ߊl
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListFontSetUp( ZKN_GLB_DRAWDATA* p_drawglb, int heap, int see_num, int get_num )
{
	STRBUF* str = STRBUF_Create(ZKN_POKELIST_NUM_STR, heap);
	MSGDATA_MANAGER* man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_zkn_dat, heap);

	// ݂Ƃ
	MSGMAN_GetString( man, ZNK_POKELIST_00, str );
	GF_STR_PrintColor( &p_drawglb->bmp_mfont, FONT_SYSTEM, str, ZKN_POKELIST_SEE_STR_X, ZKN_POKELIST_STR_Y, 0, ZKN_BG_FONT_COLOR_MSK, NULL );
	
	// ܂Ƃ
	MSGMAN_GetString( man, ZNK_POKELIST_01, str );
	GF_STR_PrintColor( &p_drawglb->bmp_mfont, FONT_SYSTEM, str, ZKN_POKELIST_GET_STR_X, ZKN_POKELIST_STR_Y, 0, ZKN_BG_FONT_COLOR_MSK, NULL );

	// 
	STRBUF_SetNumber( str, see_num, ZKN_POKELIST_PLACE, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );
	GF_STR_PrintColor( &p_drawglb->bmp_mfont, FONT_SYSTEM, str, ZKN_POKELIST_SEE_NUM_X, ZKN_POKELIST_SEE_NUM_Y, 0, ZKN_BG_FONT_COLOR_MSK, NULL );

	// ߊl
	STRBUF_SetNumber( str, get_num, ZKN_POKELIST_PLACE, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );
	GF_STR_PrintColor( &p_drawglb->bmp_mfont, FONT_SYSTEM, str, ZKN_POKELIST_GET_NUM_X, ZKN_POKELIST_GET_NUM_Y, 0, ZKN_BG_FONT_COLOR_MSK, NULL );
	
	STRBUF_Delete(str);

	MSGMAN_Delete(man);

	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_drawglb->p_bg, ZKN_BG_FRM_FONT_M );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Ă̎̓Xĝݏo
 *
 *	@param	p_drawglb		O[oް
 *	@param	heap			q[v
 *	@param	list_num		\Xg 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListSortVerFontSetUp( ZKN_GLB_DRAWDATA* p_drawglb, int heap, int list_num )
{
	STRBUF* str = STRBUF_Create(ZKN_POKELIST_NUM_STR, heap);
	MSGDATA_MANAGER* man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_zkn_dat, heap);

	// ݂Ƃ
	MSGMAN_GetString( man, ZNK_SORT_NUM, str );
	GF_STR_PrintColor( &p_drawglb->bmp_mfont, FONT_SYSTEM, str, ZKN_POKELIST_SEE_STR_X, ZKN_POKELIST_STR_Y, 0, ZKN_BG_FONT_COLOR_MSK, NULL );
	
	// 
	STRBUF_SetNumber( str, list_num, ZKN_POKELIST_PLACE, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );
	GF_STR_PrintColor( &p_drawglb->bmp_mfont, FONT_SYSTEM, str, ZKN_POKELIST_SEE_NUM_X, ZKN_POKELIST_SEE_NUM_Y, 0, ZKN_BG_FONT_COLOR_MSK, NULL );

	STRBUF_Delete(str);

	MSGMAN_Delete(man);

	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_drawglb->p_bg, ZKN_BG_FRM_FONT_M );

}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXgp\[X}l[W̍쐬
 *
 *	@param	p_work	[N
 *	@param	heap	q[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListResManagerMake( ZKN_POKELIST_GRAWORK* p_work, int heap )
{
	// ZAN^[p\[XǗVXe
	p_work->res_manager[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerInit( ZKN_POKELIST_CELL_CG_NUM, CLACT_U_CHAR_RES, heap );
	p_work->res_manager[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerInit( ZKN_POKELIST_CELL_CL_NUM, CLACT_U_PLTT_RES, heap );
	p_work->res_manager[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerInit( ZKN_POKELIST_CELL_CE_NUM, CLACT_U_CELL_RES, heap );
	p_work->res_manager[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerInit( ZKN_POKELIST_CELL_AN_NUM, CLACT_U_CELLANM_RES, heap );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXgp\[X}l[Wj
 *
 *	@param	p_work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListResManagerDelete( ZKN_POKELIST_GRAWORK* p_work )
{
	CLACT_U_RES_OBJ_PTR res_obj;
	// pbgƃLN^̊Ǘ̈j
	res_obj = CLACT_U_ResManagerGetIDResObjPtr( p_work->res_manager[ CLACT_U_CHAR_RES ], NARC_zukan_zkn_list_oam_main_lzh_NCGR );
	CLACT_U_CharManagerDelete( res_obj );
	
	res_obj = CLACT_U_ResManagerGetIDResObjPtr( p_work->res_manager[ CLACT_U_PLTT_RES ], NARC_zukan_zkn_list_oam_NCLR );
	CLACT_U_PlttManagerDelete( res_obj );


	res_obj = CLACT_U_ResManagerGetIDResObjPtr( p_work->res_manager[ CLACT_U_CHAR_RES ], NARC_zukan_zkn_hatena_oam_lzh_NCGR );
	CLACT_U_CharManagerDelete( res_obj );
	

	
	// ZAN^[p\[XǗVXe
	CLACT_U_ResManagerDelete( p_work->res_manager[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerDelete( p_work->res_manager[ CLACT_U_PLTT_RES ] );
	CLACT_U_ResManagerDelete( p_work->res_manager[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerDelete( p_work->res_manager[ CLACT_U_CELLANM_RES ] );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[p\[Xǂݍ
 *
 *	@param	p_work	[N
 *	@param	heap	q[v
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListClActResLoad( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, int heap )
{
	CLACT_U_RES_OBJ_PTR res_obj;
	ARCHANDLE* p_handle =ZKN_GLBDATA_ArcHandlGet( p_drawglb ); 
	
	// LN^f[^ǂݍ
	res_obj = CLACT_U_ResManagerResAddArcChar_ArcHandle( p_work->res_manager[ CLACT_U_CHAR_RES ], 
			p_handle, NARC_zukan_zkn_list_oam_main_lzh_NCGR,
			TRUE, NARC_zukan_zkn_list_oam_main_lzh_NCGR,
			NNS_G2D_VRAM_TYPE_2DMAIN, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( res_obj );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( res_obj );

	// pbgf[^ǂݍ
	res_obj = CLACT_U_ResManagerResAddArcPltt_ArcHandle( p_work->res_manager[ CLACT_U_PLTT_RES ],
			p_handle, NARC_zukan_zkn_list_oam_NCLR,
			FALSE, NARC_zukan_zkn_list_oam_NCLR, NNS_G2D_VRAM_TYPE_2DMAIN, 
			ZKN_POKELIST_TBL_PLTT_LOAD, heap );
	// ]
	CLACT_U_PlttManagerSetCleanArea( res_obj );	
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( res_obj );



	// Zf[^ǂݍ
	CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_work->res_manager[ CLACT_U_CELL_RES ],
			p_handle, NARC_zukan_zkn_list_oam_main_lzh_NCER,
			TRUE, NARC_zukan_zkn_list_oam_main_lzh_NCER,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_work->res_manager[ CLACT_U_CELLANM_RES ],
			p_handle, NARC_zukan_zkn_list_oam_main_lzh_NANR,
			TRUE, NARC_zukan_zkn_list_oam_main_lzh_NANR,
			CLACT_U_CELLANM_RES, heap );

	// ZAN^[wb_[쐬
	CLACT_U_MakeHeader( &p_work->clheader,
			NARC_zukan_zkn_list_oam_main_lzh_NCGR,
			NARC_zukan_zkn_list_oam_NCLR,
			NARC_zukan_zkn_list_oam_main_lzh_NCER,
			NARC_zukan_zkn_list_oam_main_lzh_NANR,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
			0, ZKN_POKELIST_OAM_BG_PRI,
			p_work->res_manager[ CLACT_U_CHAR_RES ],
			p_work->res_manager[ CLACT_U_PLTT_RES ],
			p_work->res_manager[ CLACT_U_CELL_RES ],
			p_work->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );


	// LN^f[^ǂݍ
	res_obj = CLACT_U_ResManagerResAddArcChar_ArcHandle( p_work->res_manager[ CLACT_U_CHAR_RES ], 
			p_handle, NARC_zukan_zkn_hatena_oam_lzh_NCGR,
			TRUE, NARC_zukan_zkn_hatena_oam_lzh_NCGR,
			NNS_G2D_VRAM_TYPE_2DMAIN, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( res_obj );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( res_obj );

	// Zf[^ǂݍ
	CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_work->res_manager[ CLACT_U_CELL_RES ],
			p_handle, NARC_zukan_zkn_hatena_oam_lzh_NCER,
			TRUE, NARC_zukan_zkn_hatena_oam_lzh_NCER,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_work->res_manager[ CLACT_U_CELLANM_RES ],
			p_handle, NARC_zukan_zkn_hatena_oam_lzh_NANR,
			TRUE, NARC_zukan_zkn_hatena_oam_lzh_NANR,
			CLACT_U_CELLANM_RES, heap );

	// ZAN^[wb_[쐬
	CLACT_U_MakeHeader( &p_work->clheader_dummy_poke,
			NARC_zukan_zkn_hatena_oam_lzh_NCGR,
			NARC_zukan_zkn_list_oam_NCLR,
			NARC_zukan_zkn_hatena_oam_lzh_NCER,
			NARC_zukan_zkn_hatena_oam_lzh_NANR,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
			0, ZKN_POKELIST_OAM_BG_PRI,
			p_work->res_manager[ CLACT_U_CHAR_RES ],
			p_work->res_manager[ CLACT_U_PLTT_RES ],
			p_work->res_manager[ CLACT_U_CELL_RES ],
			p_work->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[o^
 *
 *	@param	p_work		[N
 *	@param	p_drawglb	`O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListClActAdd( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, int heap )
{
	CLACT_ADD_SIMPLE	add;
	int i;

	// o^f[^ev[g쐬
	memset( &add, 0, sizeof(CLACT_ADD_SIMPLE) );
	add.ClActSet		= p_drawglb->clact_set;
	add.ClActHeader		= &p_work->clheader;
	add.DrawArea		= NNS_G2D_VRAM_TYPE_2DMAIN;
	add.heap			= heap;

	
	// XgIuWFNg
	add.pri		= ZKN_POKELIST_POKETBL_PRI;
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){
		p_work->poke_tbl[ i ] = CLACT_AddSimple( &add );
		CLACT_AnmChg( p_work->poke_tbl[ i ], ZKN_POKELIST_POKETBL_ANMSEQ );
	}
	
	// ACR
	add.pri		= ZKN_POKELIST_ICON_PRI;
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){
		p_work->icon[ i ] = CLACT_AddSimple( &add );
		CLACT_AnmChg( p_work->icon[ i ], ZKN_POKELIST_ICON_ANMSEQ );
	}

	// J[\
	add.pri			= ZKN_POKELIST_CURSOR_PRI;
	p_work->cursor	= CLACT_AddSimple( &add );
	CLACT_AnmChg( p_work->cursor, ZKN_POKELIST_CURSOR_ANMSEQ );

	// _~[|P
	add.pri			= 0;
	add.mat.x		= ZKN_POKELIST_POKEGRA_X << FX32_SHIFT;
	add.mat.y		= ZKN_POKELIST_POKEGRA_Y << FX32_SHIFT;
	add.ClActHeader		= &p_work->clheader_dummy_poke;
	p_work->dummy_poke = CLACT_AddSimple( &add );
	CLACT_SetDrawFlag( p_work->dummy_poke, FALSE );
	CLACT_ObjModeSet( p_work->dummy_poke, GX_OAM_MODE_XLU );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|POe[u쐬
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[of[^
 *	@param	cp_glb		O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListPokeNameSetUp( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap )
{
	int i;	// [vp
	int pokelist_s;	// |PXg̕\vf̊Jnԍ
	int poketbl_s;	// |Pe[u̕\vf̊Jnԍ
	int pokelist_tbl_num;	// |PXge[u
	ZKN_FONTOAM_INIT fontoam_init;
	GF_BGL_BMPWIN* p_bmp;	// ݗ̈
	const ZKN_POKELIST_DATA* p_poke_data;	// |Pf[^
	int poke_listdraw_link_list_idx;

	// ʃf[^
	fontoam_init.zkn_fontoam = p_drawglb->fontoam_sys;
	fontoam_init.pltt		 = p_work->clheader.pPaletteProxy;
	fontoam_init.parent		 = NULL;
	fontoam_init.x			 = 0;
	fontoam_init.y			 = 0;
	fontoam_init.bg_pri		 = ZKN_POKELIST_OAM_BG_PRI;
	fontoam_init.soft_pri	 = 0;
	fontoam_init.draw_area	 = NNS_G2D_VRAM_TYPE_2DMAIN;
	fontoam_init.heap		 = heap;


	// |Pe[uZKN_POKELIST_POKETBL_NUM쐬
	pokelist_s = ZKN_GLBDATA_PokeListDrawTblNoGet( cp_glb->p_glb ) - ZKN_POKELIST_POKETBL_CHECK;
	poketbl_s = p_work->poke_tbl_start;
	pokelist_tbl_num = ZKN_GLBDATA_PokeListDrawTblNumGet( cp_glb->p_glb );
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){

		// j
		if( p_work->poke_name[ poketbl_s ] ){
			ZKN_FONTOAM_Delete( p_work->poke_name[ poketbl_s ] );
			p_work->poke_name[ poketbl_s ] = NULL;
		}
		
		// lL`FbN
		if( (pokelist_s >= 0) && (pokelist_s < pokelist_tbl_num) ){
			
			// |PXg`zidx|PXgf[^zidx擾
			poke_listdraw_link_list_idx = ZKN_GLBDATA_PokeListDrawTblDataGet( cp_glb->p_glb, pokelist_s );
			// _~[łȂ΃|P
			if( poke_listdraw_link_list_idx != POKEMON_LIST_DRAWTBL_DUMMY ){

				p_poke_data = ZKN_GLBDATA_PokeListTblGet( cp_glb->p_glb, poke_listdraw_link_list_idx );

#if 0
				// 񏑂ݗ̈쐬
				p_bmp = ZKN_FONTOAM_GetBmp( p_drawglb->fontoam_sys, ZKN_POKELIST_POKENAME_BMP_SIZE_CX, ZKN_POKELIST_POKENAME_BMP_SIZE_CY );


				// rbg}bv̈ɏ
				ZKN_UTIL_PokeListPokeNameBmpMake( p_bmp, p_poke_data->mons_no, heap );
#endif
				// rbg}bv̈ɏ
				p_bmp = ZKN_UTIL_PokeListPokeNameTblBmpMake( p_drawglb, cp_glb->p_glb, heap, p_poke_data->mons_no );

				
				// FONTOAMo^
				fontoam_init.p_bmp = p_bmp;
				p_work->poke_name[ poketbl_s ] = ZKN_FONTOAM_MakeCharOfs( &fontoam_init, p_work->poke_name_char_size );

				// BMP̈j
				ZKN_FONTOAM_DeleteBmp( p_bmp );
			}else{

				// _~[̖Oݒ
				PokeListPokeNameDummySet( p_work, p_drawglb, heap, poketbl_s, pokelist_s + 1 );
			}
		}else{

			p_work->poke_name[ poketbl_s ] = NULL;
		}

		poketbl_s = (poketbl_s + 1) % ZKN_POKELIST_POKETBL_NUM;
		pokelist_s ++;
	}

}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbNt@Cݒ
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[of[^
 *	@param	cp_glb		O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeGraphicSetUp( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	int pokelist_no;
	int drawpokelist_no;
	const ZKN_POKELIST_DATA* cp_pokedata;

	drawpokelist_no = ZKN_GLBDATA_PokeListDrawTblNoGet( cp_glb->p_glb );

	pokelist_no = ZKN_GLBDATA_PokeListTblNoGet( cp_glb->p_glb );
	cp_pokedata = ZKN_GLBDATA_PokeListTblGet( cp_glb->p_glb , pokelist_no );

	// \邩`FbN
	if( ZKN_GLBDATA_PokeListDrawTblDataGet( cp_glb->p_glb, drawpokelist_no ) == POKEMON_LIST_DRAWTBL_DUMMY ){
		// `OFF
		ZKN_GlbPokemonGraphicDrawFlagSet( p_drawglb,FALSE ); 
	
		// _~[`ON
		if( p_work->dummy_poke ){
			CLACT_SetDrawFlag( p_work->dummy_poke, TRUE );
		}
	}else{

		// |POtBbNf[^ݒ
		ZKN_UTIL_PokemonGraphicSet( p_drawglb, cp_glb->p_glb, cp_pokedata->mons_no,
				PARA_FRONT, ZKN_POKELIST_POKEGRA_X, ZKN_POKELIST_POKEGRA_Y );

		// `ON
		ZKN_GlbPokemonGraphicDrawFlagSet( p_drawglb,TRUE ); 

		// _~[`OFF
		if( p_work->dummy_poke ){
			CLACT_SetDrawFlag( p_work->dummy_poke, FALSE );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|POe[uj
 *
 *	@param	p_work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListPokeNameDelete( ZKN_POKELIST_GRAWORK* p_work )
{
	int i;

	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){
		if( p_work->poke_name[ i ] ){
			ZKN_FONTOAM_Delete( p_work->poke_name[ i ] );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[j
 *
 *	@param	p_work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListClActDelete( ZKN_POKELIST_GRAWORK* p_work )
{
	int i;

	// |Pe[u
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){
		CLACT_Delete( p_work->poke_tbl[ i ] );
	}

	// ACR
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){
		CLACT_Delete( p_work->icon[ i ] );
	}

	// J[\
	CLACT_Delete( p_work->cursor );

	//@_~[ۂ 
	CLACT_Delete( p_work->dummy_poke );
}

// CLACT_OBJp[^vZݒ֐S
//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXge[uO
 *
 *	@param	p_work	`惏[N
 *	@param	cp_glb	O[of[^
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListPokeTblInit( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	p_work->poke_tbl_start = 0;

	// \\ݒ
	PokeListPokeTblDrawFlagSetUp( p_work, cp_glb );
	
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|POe[u
 *
 *	@param	p_work	`惏[N
 *	@param	cp_glb	O[of[^
 *
 *	@return none;
 *
 */
//-----------------------------------------------------------------------------
static void PokeListPokeTblMove( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	int tbl_count;
	VecFx32 mat;
	int i;
	int tbl_s, tbl_e;
	int center_dis;		// ̋
	int pri;			// \vCIeB
	int col;			// J[pbg

	// move_countɂWݒ
	tbl_count = p_work->poke_tbl_start;
	// 擪Wݒ肷
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){

		// Jne[uƏIe[uio[𓮂Ăɂĕω
		if( cp_glb->move_way == ZKN_POKE_LIST_UP ){
			tbl_s = i + 2;		// ЂƂ玩̍W
			tbl_e = i + 1;
		}else{
			tbl_s = i;			// ЂƂ玩̍W
			tbl_e = i + 1;
		}
		
		mat.x = PokeListPokeTblMoveCalc( ZknPokeListPokeTblMoveX[ tbl_s ], ZknPokeListPokeTblMoveX[ tbl_e ], ZKN_POKELIST_MOVE_END_COUNT, ZKN_POKELIST_MOVE_END_COUNT - cp_glb->move_count );	// XWvZ
		mat.y = PokeListPokeTblMoveCalc( ZknPokeListPokeTblMoveY[ tbl_s ], ZknPokeListPokeTblMoveY[ tbl_e ], ZKN_POKELIST_MOVE_END_COUNT, ZKN_POKELIST_MOVE_END_COUNT - cp_glb->move_count );	// YWvZ

		
		// Wݒ
		CLACT_SetMatrix( p_work->poke_tbl[ tbl_count ], &mat );

		// S̋߂
		center_dis = ZKN_POKELIST_POKETBL_CHECK - i;
		if( center_dis < 0 ){
			center_dis = -center_dis;
		}
		
		// \D揇ʌvZ
		pri = center_dis * 2;
		if( pri < 0 ){
			pri = -pri;
		}
		pri += ZKN_POKELIST_POKETBL_PRI;
		CLACT_DrawPriorityChg( p_work->poke_tbl[ tbl_count ], pri );

		// J[pbg
		// ȊOŃJ[pbgύX
		if( i == ZKN_POKELIST_POKETBL_CHECK ){
			CLACT_PaletteOffsetChgAddTransPlttNo( p_work->poke_tbl[ tbl_count ], ZKN_POKELIST_PLTT_SELECT );
		}else{
			if( ZKN_POKELIST_PLTT_OTHER0 + (center_dis - 1) < ZKN_POKELIST_PLTT_OTHER2 ){
				CLACT_PaletteOffsetChgAddTransPlttNo( p_work->poke_tbl[ tbl_count ], ZKN_POKELIST_PLTT_OTHER0 + (center_dis - 1) );
			}else{
				CLACT_PaletteOffsetChgAddTransPlttNo( p_work->poke_tbl[ tbl_count ], ZKN_POKELIST_PLTT_OTHER2 );
			}
		}
		
		// ̔z
		tbl_count = (tbl_count + 1) % ZKN_POKELIST_POKETBL_NUM;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXge[uJnio[ύX
 *
 *	@param	p_work		`惏[N
 *	@param	cp_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListPokeTblListStartNumChenge( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	int poke_last;
	int pokelist_no;
	int pokelist_num;
	
	pokelist_no = ZKN_GLBDATA_PokeListDrawTblNoGet( cp_glb->p_glb );
	pokelist_num = ZKN_GLBDATA_PokeListDrawTblNumGet( cp_glb->p_glb );
	
	// ǂ̕ɓ삵Ă邩`FbN
	if( cp_glb->move_way == ZKN_POKE_LIST_UP ){
		// Ɉړ	
		// ύX
		if( (p_work->poke_tbl_start + 1) < ZKN_POKELIST_POKETBL_NUM ){
			p_work->poke_tbl_start ++;
		}else{
			p_work->poke_tbl_start = 0;
		}

		// 擪Ԍɍse[uio[擾
		poke_last = p_work->poke_tbl_start + (ZKN_POKELIST_POKETBL_NUM - 1);
		poke_last %= ZKN_POKELIST_POKETBL_NUM;

		// \e[u`FbN
		// ZKN_POKELIST_POKETBL_CHECKȂ`FbN
		if( (pokelist_no + ZKN_POKELIST_POKETBL_CHECK) >= pokelist_num ){
			// ԉ̃e[u\ɂ
			CLACT_SetDrawFlag( p_work->poke_tbl[ poke_last ], FALSE );
		}else{
			// ԉ̃e[u\ɂ
			CLACT_SetDrawFlag( p_work->poke_tbl[ poke_last ], TRUE );
		}
	}else{
		
		// Ɉړ
		if( cp_glb->move_way == ZKN_POKE_LIST_DOWN ){
			if( (p_work->poke_tbl_start - 1) >= 0 ){
				p_work->poke_tbl_start --;
			}else{
				p_work->poke_tbl_start = ZKN_POKELIST_POKETBL_NUM - 1;
			}
		
			// Ԑ擪ɍse[uio[擾
			poke_last = p_work->poke_tbl_start;

			// ZKN_POKELIST_POKETBL_CHECKȂ`FbN
			if( (pokelist_no - ZKN_POKELIST_POKETBL_CHECK) < 0 ){
				// ԏ̃e[uWɂ
				CLACT_SetDrawFlag( p_work->poke_tbl[ poke_last ], FALSE );
			}else{
				// ԏ̃e[u\ɂ
				CLACT_SetDrawFlag( p_work->poke_tbl[ poke_last ], TRUE );
			}
		}else{
			// łłȂlύXĂƂ͕\ONOFFݒ̂ݍs
			PokeListPokeTblDrawFlagSetUp( p_work, cp_glb );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ACR̓
 *
 *	@param	p_work		`惏[N
 *	@param	cp_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListIconMove( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	const VecFx32* cp_mat;
	VecFx32 mat;
	int i;
	int tbl_no;
	BOOL draw_on_off;
	int pokelist_no_work;
	int pokelist_no;
	int pokelist_num;
	const ZKN_POKELIST_DATA* cp_poke_data;
	int pri;
	int pltt_no;
	int poke_listdraw_link_list_idx;

	pokelist_no = ZKN_GLBDATA_PokeListDrawTblNoGet( cp_glb->p_glb );
	pokelist_num = ZKN_GLBDATA_PokeListDrawTblNumGet( cp_glb->p_glb );
	
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){
		tbl_no = (p_work->poke_tbl_start + i) % ZKN_POKELIST_POKETBL_NUM;

		// \ONOFFݒ
		draw_on_off = FALSE;
		pokelist_no_work = ((pokelist_no - ZKN_POKELIST_POKETBL_CHECK) + i);
		// ̃|P͕߂܂|P|P
		if( (pokelist_no_work >= 0) && (pokelist_no_work < pokelist_num) ){
			// |PXg`zidx|PXgf[^zidx擾
			poke_listdraw_link_list_idx = ZKN_GLBDATA_PokeListDrawTblDataGet( cp_glb->p_glb, pokelist_no_work );
			
			// _~[f[^oȂ`FbN
			if( poke_listdraw_link_list_idx != POKEMON_LIST_DRAWTBL_DUMMY ){
			
				cp_poke_data = ZKN_GLBDATA_PokeListTblGet( cp_glb->p_glb, poke_listdraw_link_list_idx );

				// ߂܂|P`FbN
				if( cp_poke_data->type == ZKN_POKELIST_TYPE_GET ){
					draw_on_off = TRUE;
				}
			}
			
		}

		// \ݒ
		CLACT_SetDrawFlag( p_work->icon[ tbl_no ], draw_on_off );

		// \Ȃݒ		
		if( draw_on_off ){
			
			// |Pe[ũZ^[e[uWɒǏ]
			cp_mat = CLACT_GetMatrix( p_work->poke_tbl[ tbl_no ] );

			mat.x = cp_mat->x + ZKN_POKELIST_ICON_X_OFS;
			mat.y = cp_mat->y;

			CLACT_SetMatrix( p_work->icon[ tbl_no ], &mat );

			// ee[uƓJ[pbgݒ
			pltt_no = CLACT_PaletteOffsetGet( p_work->poke_tbl[ tbl_no ] );
			CLACT_PaletteOffsetChg( p_work->icon[ tbl_no ], pltt_no );

			// \D揇ʂݒ
			pri = CLACT_DrawPriorityGet( p_work->poke_tbl[ tbl_no ] );
			pri--;
			CLACT_DrawPriorityChg( p_work->icon[ tbl_no ], pri );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Cursor쏉
 *
 *	@param	p_work		`惏[N
 *	@param	cp_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListCursorInit( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	int pokelist_num = ZKN_GLBDATA_PokeListDrawTblNumGet( cp_glb->p_glb );
	
	p_work->onepoke_move_dis = FX_Div( ZKN_POKELIST_CURSOR_YDIS, pokelist_num << FX32_SHIFT );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Cursor
 *
 *	@param	p_work		`惏[N
 *	@param	cp_glb		O[of[^
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListCursorMove( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	VecFx32	mat;
	int pokelist_no = ZKN_GLBDATA_PokeListDrawTblNoGet( cp_glb->p_glb );
	
	// Ŝ̃|PXgł̍̑I|P̈ʒuɂW߂
	mat.y = FX_Mul( p_work->onepoke_move_dis, pokelist_no  << FX32_SHIFT );
	mat.y += ZKN_POKELIST_CURSOR_YMIN;
	mat.x = ZKN_POKELIST_CURSOR_X;

	CLACT_SetMatrix( p_work->cursor, &mat );
}



//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXgWvZ
 *
 *	@param	s				JnW
 *	@param	e				I_W
 *	@param	max_count		őJEg
 *	@param	count			̃JEgl
 *
 *	@return	W
 *
 *
 */
//-----------------------------------------------------------------------------
static fx32 PokeListPokeTblMoveCalc( fx32 s, fx32 e, int max_count, int count )
{
	fx32 work;

	work = (e - s);

	work = FX_Mul( work, count << FX32_SHIFT );
	work = FX_Div( work, max_count << FX32_SHIFT );	// W

	return work + s;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	[N̏
 *
 *	@param	p_work			[N
 *	@param	cp_dataglb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListDrawWorkInit( ZKN_POKELIST_GRAWORK*	p_work, const ZKN_POKELIST_GLB_DATA* cp_dataglb )
{
	memset( p_work, 0, sizeof(ZKN_POKELIST_GRAWORK) );
	p_work->draw_poke_name = ZKN_GLBDATA_PokeListDrawTblNoGet( cp_dataglb->p_glb );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POe[u
 *
 *	@param	p_work		[N
 *	@param	p_drawglb	`O[of[^
 *	@param	cp_glb		O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 *
 *
 *	Ƀ|PXg𓮂Ă
 */
//-----------------------------------------------------------------------------
static void PokeListPokeNameMove( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap )
{
	int i;
	int x, y;
	VecFx32 mat;
	int poke_tbl_no;
	int pri;
	int col;
	
	// |PXg̊ee[uWɂ킹
	poke_tbl_no = p_work->poke_tbl_start;
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){
		if( p_work->poke_name[ poke_tbl_no ] ){
			// W擾
			PokeListPokeNameMoveMatGet( p_work->poke_tbl[ poke_tbl_no ], &x, &y );
			// Wݒ
			FONTOAM_SetMat( p_work->poke_name[ poke_tbl_no ]->p_fontoam, 
					x, y );

			// \D揇ʐݒ
			pri = CLACT_DrawPriorityGet( p_work->poke_tbl[ poke_tbl_no ] );
			pri--;
			FONTOAM_SetDrawPriority( p_work->poke_name[ poke_tbl_no ]->p_fontoam, pri );

			// J[pbg
			col = CLACT_PaletteOffsetGet( p_work->poke_tbl[ poke_tbl_no ] );
			FONTOAM_SetPaletteOffset( p_work->poke_name[ poke_tbl_no ]->p_fontoam, col );
		}

		// ̃e[u
		poke_tbl_no = (poke_tbl_no + 1) % ZKN_POKELIST_POKETBL_NUM;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ZAN^[WɏtHgOAM̍W߂
 *
 *	@param	target_act	^[QbgAN^[
 *	@param	x			XW
 *	@param	y			YW
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListPokeNameMoveMatGet( CLACT_WORK_PTR target_act, int* x, int* y )
{
	const VecFx32* p_mat;

	// W擾
	p_mat = CLACT_GetMatrix( target_act );

	*x = p_mat->x >> FX32_SHIFT;
	*y = p_mat->y >> FX32_SHIFT;
	*x -= (ZKN_POKELIST_POKENAME_BMP_SIZE_X / 2);	// Wɂ
	*y -= (ZKN_POKELIST_POKENAME_BMP_SIZE_Y / 2);			
}

//----------------------------------------------------------------------------
/**
 *	@brief	OύXf[^ύX`FbNs
 *
 *	@param	p_work			[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb			O[o
 *	@param	heap			q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListPokeNameMoveNameChange( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap )
{
	int pokelisttbl_no;
	int pokelisttbl_num;
	int chg_name_no;	// ύX閼Oe[uio[
	int poke_list_no;	// ύX|PXgio[
	int poke_listdraw_link_list_idx;

	pokelisttbl_no = ZKN_GLBDATA_PokeListDrawTblNoGet( cp_glb->p_glb );
	pokelisttbl_num = ZKN_GLBDATA_PokeListDrawTblNumGet( cp_glb->p_glb );

	// ǂ̕ɓ삵Ă邩`FbN
	switch( cp_glb->move_way ){
	case ZKN_POKE_LIST_UP:
		// Ԃ̃e[ũ|PIꂽ|P + ZKN_POKELIST_POKETBL_CHECK̃e[u|PŕύX
		chg_name_no = p_work->poke_tbl_start + ZKN_POKELIST_POKETBL_NUM - 1;
		poke_list_no = pokelisttbl_no + ZKN_POKELIST_POKETBL_CHECK;
		break;
		
	case ZKN_POKE_LIST_DOWN:
		// Ԑ擪̃e[ũ|PIꂽ|P - ZKN_POKELIST_POKETBL_CHECK̃e[u|PŕύX
		chg_name_no = p_work->poke_tbl_start;
		poke_list_no = pokelisttbl_no - ZKN_POKELIST_POKETBL_CHECK;

		break;

	default:
		break;
	}
	
	// łłƂ͑SύX(XLbvR[ꂽ)
	if( (cp_glb->move_way == ZKN_POKE_LIST_NO_MOVE) ){
		// SύX
		PokeListPokeNameSetUp( p_work, p_drawglb, cp_glb, heap );
	}else{
		// PύX
		chg_name_no %= ZKN_POKELIST_POKETBL_NUM;

		// ͈͓ȂύX
		if( (poke_list_no < pokelisttbl_num) &&
			(poke_list_no >= 0) ){
			
			// |PXg`zidx|PXgf[^zidx擾
			poke_listdraw_link_list_idx = ZKN_GLBDATA_PokeListDrawTblDataGet( cp_glb->p_glb, poke_list_no );
			
			// _~[f[^łȂ`FbN
			if( poke_listdraw_link_list_idx != POKEMON_LIST_DRAWTBL_DUMMY ){
			
				PokeListPokeNameChange( p_work, p_drawglb, cp_glb, heap, chg_name_no, poke_listdraw_link_list_idx );
			}else{

				// ݁[Oݒ
				PokeListPokeNameDummySet( p_work, p_drawglb, heap, chg_name_no, poke_list_no + 1 );
			}
		}else{
			// ͈͊OȂj
			if( p_work->poke_name[ chg_name_no ] ){
				ZKN_FONTOAM_Delete( p_work->poke_name[ chg_name_no ] );
				p_work->poke_name[ chg_name_no ] = NULL;
			}
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PLN^f[^ύX
 *
 *	@param	p_work				`惏[N
 *	@param	p_drawglb			`O[of[^
 *	@param	cp_glb				O[of[^
 *	@param	heap				q[v
 *	@param	pokename_tbl_no		|POe[ủԖڂύX̂
 *	@param	pokelist_tbl_no		ύX|P̃f[^e[uio[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListPokeNameChange( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap, int pokename_tbl_no, int pokelist_tbl_no )
{
	ZKN_FONTOAM_INIT fontoam_init;
	GF_BGL_BMPWIN* p_bmp;	// ݗ̈
	const ZKN_POKELIST_DATA* cp_pokedata;

	//@|Pf[^
	cp_pokedata = ZKN_GLBDATA_PokeListTblGet( cp_glb->p_glb, pokelist_tbl_no );
	GF_ASSERT_MSG( cp_pokedata, " %d\n", pokelist_tbl_no );

	// ʃf[^
	fontoam_init.zkn_fontoam = p_drawglb->fontoam_sys;
	fontoam_init.pltt		 = p_work->clheader.pPaletteProxy;
	fontoam_init.parent		 = NULL;
	fontoam_init.x			 = 0;
	fontoam_init.y			 = 0;
	fontoam_init.bg_pri		 = ZKN_POKELIST_OAM_BG_PRI;
	fontoam_init.soft_pri	 = 0;
	fontoam_init.draw_area	 = NNS_G2D_VRAM_TYPE_2DMAIN;
	fontoam_init.heap		 = heap;

	// 񏑂ݗ̈쐬
	p_bmp = ZKN_UTIL_PokeListPokeNameTblBmpMake( p_drawglb, cp_glb->p_glb, heap, cp_pokedata->mons_no );
	

	// j
	if( p_work->poke_name[ pokename_tbl_no ] ){
		ZKN_FONTOAM_Delete( p_work->poke_name[ pokename_tbl_no ] );
	}
	
	// FONTOAMo^
	fontoam_init.p_bmp = p_bmp;
	p_work->poke_name[ pokename_tbl_no ] = ZKN_FONTOAM_MakeCharOfs( &fontoam_init, p_work->poke_name_char_size );

	// BMP̈j
	ZKN_FONTOAM_DeleteBmp( p_bmp );
}

//----------------------------------------------------------------------------
/**
 *	@brief	_~[f[^ݒ
 *
 *	@param	p_work			`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	heap			q[v
 *	@param	pokename_tbl_no	l[e[uio[
 *	@param	pokenum
 *
 *	@return	none
 */	
//-----------------------------------------------------------------------------
static void PokeListPokeNameDummySet( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, int heap, int pokename_tbl_no, int pokenum )
{
	ZKN_FONTOAM_INIT fontoam_init;
	GF_BGL_BMPWIN* p_bmp;	// ݗ̈
	STRBUF* str = STRBUF_Create(ZKN_POKELIST_NUM_STR, heap);
	MSGDATA_MANAGER* man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_zkn_dat, heap);


	// ʃf[^
	fontoam_init.zkn_fontoam = p_drawglb->fontoam_sys;
	fontoam_init.pltt		 = p_work->clheader.pPaletteProxy;
	fontoam_init.parent		 = NULL;
	fontoam_init.x			 = 0;
	fontoam_init.y			 = 0;
	fontoam_init.bg_pri		 = ZKN_POKELIST_OAM_BG_PRI;
	fontoam_init.soft_pri	 = 0;
	fontoam_init.draw_area	 = NNS_G2D_VRAM_TYPE_2DMAIN;
	fontoam_init.heap		 = heap;

	// 񏑂ݗ̈쐬
	p_bmp = ZKN_FONTOAM_GetBmp( p_drawglb->fontoam_sys, ZKN_POKELIST_POKENAME_BMP_SIZE_CX, ZKN_POKELIST_POKENAME_BMP_SIZE_CY );

	// 쐬
	STRBUF_SetNumber( str, pokenum, ZKN_POKELIST_POKENAME_NO_KETA,
			NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );
	GF_STR_PrintColor( p_bmp, FONT_BUTTON, str, ZKN_POKELIST_POKENAME_NO_MAT_X, ZKN_POKELIST_POKENAME_MAT_Y, MSG_NO_PUT, ZKN_FOTNOAM_COLOR, NULL );

	// Ȃ|P 
	MSGMAN_GetString( man, ZNK_UNKNOWN_00, str );
	GF_STR_PrintColor( p_bmp, FONT_BUTTON, str, ZKN_POKELIST_POKENAME_NAME_MAT_X, ZKN_POKELIST_POKENAME_MAT_Y, MSG_NO_PUT, ZKN_FOTNOAM_COLOR, NULL );
	
	// j
	if( p_work->poke_name[ pokename_tbl_no ] ){
		ZKN_FONTOAM_Delete( p_work->poke_name[ pokename_tbl_no ] );
	}
	
	// FONTOAMo^
	fontoam_init.p_bmp = p_bmp;
	p_work->poke_name[ pokename_tbl_no ] = ZKN_FONTOAM_MakeCharOfs( &fontoam_init, p_work->poke_name_char_size );

	// BMP̈j
	ZKN_FONTOAM_DeleteBmp( p_bmp );


	STRBUF_Delete(str);

	MSGMAN_Delete(man);

}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	e[u̕`IItݒ	CɑSe[uݒ肵܂B
 *
 *	@param	p_work		`惏[N
 *	@param	cp_glb		O[of[^	
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void PokeListPokeTblDrawFlagSetUp( ZKN_POKELIST_GRAWORK* p_work, const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	int poke_list_no;
	int poke_tbl_no;
	int i;		// [vp
	int pokelisttbl_no;
	int pokelisttbl_num;

	pokelisttbl_no = ZKN_GLBDATA_PokeListDrawTblNoGet( cp_glb->p_glb );
	pokelisttbl_num = ZKN_GLBDATA_PokeListDrawTblNumGet( cp_glb->p_glb );

	poke_list_no = pokelisttbl_no - ZKN_POKELIST_POKETBL_CHECK;
	poke_tbl_no = p_work->poke_tbl_start;
	
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){

		if( (poke_list_no >= 0) &&
			(poke_list_no < pokelisttbl_num) ){
			CLACT_SetDrawFlag( p_work->poke_tbl[ poke_tbl_no ], TRUE );
		}else{
			CLACT_SetDrawFlag( p_work->poke_tbl[ poke_tbl_no ], FALSE );
		}

		poke_tbl_no = (poke_tbl_no + 1) % ZKN_POKELIST_POKETBL_NUM;
		poke_list_no++;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbN
 *
 *	@param	p_work			`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb			O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListPokeGraMove( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	fx32 calc;
	int alpha;
	SOFT_SPRITE* ssp;
	
	// JEgl烿ύX
	// 0`31ɏXɕςĂ
	calc = FX_Mul( 31 << FX32_SHIFT, (ZKN_POKELIST_MOVE_END_COUNT - cp_glb->move_count) << FX32_SHIFT );
	calc = FX_Div( calc, ZKN_POKELIST_MOVE_END_COUNT << FX32_SHIFT );
	alpha = calc >> FX32_SHIFT;

	// softsprite
	ssp = ZKN_GlbPokemonGraphicGet( p_drawglb );
	SoftSpriteParaSet( ssp, SS_PARA_ALPHA, alpha );
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbÑlZbg
 *
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListPokeGraAlphaInit( ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	SOFT_SPRITE* ssp;
	
	// softsprite
	ssp = ZKN_GlbPokemonGraphicGet( p_drawglb );
	SoftSpriteParaSet( ssp, SS_PARA_ALPHA, 31 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	_~[|POtBbN̓
 *
 *	@param	cp_glb			O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListDummyPokeGraMove( const ZKN_POKELIST_GLB_DATA* cp_glb )
{
	fx32 calc;
	int alpha;
	
	// JEgl烿ύX
	// 0`16ɏXɕςĂ
	calc = FX_Mul( 16 << FX32_SHIFT, (ZKN_POKELIST_MOVE_END_COUNT - cp_glb->move_count) << FX32_SHIFT );
	calc = FX_Div( calc, ZKN_POKELIST_MOVE_END_COUNT << FX32_SHIFT );
	alpha = calc >> FX32_SHIFT;

	// OAM
	G2_ChangeBlendAlpha( alpha, 16 - alpha );
}


//----------------------------------------------------------------------------
/**
 *	@brief	BGʃtF[h
 *
 *	@param	p_work			`惏[N
 *	@param	p_drawglb		`O[of[^
 *	@param	cp_glb			O[of[^
 *	@param	fadein_out		tF[hCTRUE@AEgFALSEtO
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListBgFadeInit( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out )
{
	int top_s, top_e;
	int bottom_s, bottom_e;
	int fade_sync;

	
	// Vb^[
	Snd_SePlay( ZKN_SND_SHUTTER );

	// fontʃ}XN
/*	GX_SetVisibleWnd( GX_WNDMASK_W0 );
	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 | GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_BG3 | GX_WND_PLANEMASK_OBJ, TRUE );
	G2_SetWndOutsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_BG3 | GX_WND_PLANEMASK_OBJ, TRUE );
	G2_SetWnd0Position( 0, 0, 255, 192 );//*/

	
	// tF[hf[^f[^ݒ
	if( cp_glb->fade_mode == ZKN_POKELIST_BG_FADE_NORMAL ){
		
		if( fadein_out ){
			top_s = ZKN_POKELIST_BGSHUTTER_FADE00_TOP_S;
			bottom_s = ZKN_POKELIST_BGSHUTTER_FADE00_BOTTOM_S;
			top_e = ZKN_POKELIST_BGSHUTTER_FADE00_TOP_E;
			bottom_e = ZKN_POKELIST_BGSHUTTER_FADE00_BOTTOM_E;
			fade_sync = ZKN_POKELIST_FADEIN_SYNC;

			// ʂ̕\ItZbgݒ
			GF_BGL_ScrollSet( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_FONT_M, GF_BGL_SCROLL_Y_SET, 192 );

		}else{
			top_s = ZKN_POKELIST_BGSHUTTER_FADE00_TOP_E;
			bottom_s = ZKN_POKELIST_BGSHUTTER_FADE00_BOTTOM_E;
			top_e = ZKN_POKELIST_BGSHUTTER_FADE00_TOP_S;
			bottom_e = ZKN_POKELIST_BGSHUTTER_FADE00_BOTTOM_S;
			fade_sync = ZKN_POKELIST_FADEOUT_SYNC;
		}
		
	}else{
		
		if( fadein_out ){
			top_s = ZKN_POKELIST_BGSHUTTER_FADE01_TOP_S;
			bottom_s = ZKN_POKELIST_BGSHUTTER_FADE01_BOTTOM_S;
			top_e = ZKN_POKELIST_BGSHUTTER_FADE01_TOP_E;
			bottom_e = ZKN_POKELIST_BGSHUTTER_FADE01_BOTTOM_E;
			fade_sync = ZKN_POKELIST_FADEIN_SYNC;
		}else{
			top_s = ZKN_POKELIST_BGSHUTTER_FADE01_TOP_E;
			bottom_s = ZKN_POKELIST_BGSHUTTER_FADE01_BOTTOM_E;
			top_e = ZKN_POKELIST_BGSHUTTER_FADE01_TOP_S;
			bottom_e = ZKN_POKELIST_BGSHUTTER_FADE01_BOTTOM_S;
			fade_sync = ZKN_POKELIST_FADEOUT_SYNC;
		}
	}


	// tF[hf[^
	ZKN_UTIL_BgShutterFadeInit( &p_work->bg_fade,
			p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_UTIL_M,
			p_work->p_util_scrn, 
			top_s, top_e, bottom_s, bottom_e,
			fade_sync );

}

//----------------------------------------------------------------------------
/**
 *	@brief	BGtF[h֐
 *
 *	@param	p_work 
 *	@param	p_drawglb
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL PokeListBgFadeMain( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb )
{
	BOOL check;
	int bottom_w_size;
	
	check = ZKN_UTIL_BgShutterFade( &p_work->bg_fade );

	// ʃXN[
	if( check == FALSE ){
		bottom_w_size = (p_work->bg_fade.bottom_dis * (p_work->bg_fade.move_count - 1)) / p_work->bg_fade.move_count_max;
		bottom_w_size += p_work->bg_fade.bottom_start;
		bottom_w_size = bottom_w_size;			// ̃LN^TCY
		bottom_w_size *= 8;						// ̃sNZTCY
		bottom_w_size = bottom_w_size - ZKN_POKELIST_SCR_START_DOWN_YSIZ; // ̕\ʒu

		// ZKN_POKELIST_BGSHUTTER_FADE_FONTBG_LIMIT傫lɂȂ
		if( bottom_w_size < ZKN_POKELIST_BGSHUTTER_FADE_FONTBG_LIMIT ){
			bottom_w_size = ZKN_POKELIST_BGSHUTTER_FADE_FONTBG_LIMIT;
		}
		
		// ꂪBG̈ړlɂȂ
		GF_BGL_ScrollReq( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_FONT_M, GF_BGL_SCROLL_Y_SET, bottom_w_size );

	}

	return check;
}

//----------------------------------------------------------------------------
/**
 *	@brief	SHUTTERtF[h㏈
 *
 *	@param	p_drawglb		`O[of[^
 *	@param	cp_glb			O[of[^
 *	@param	fadein_out		tF[hCTRUE@AEgFALSE
 *	@param	set_blend_msk	ݒuCglX}XN
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListBgFadeDel( ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out )
{
	if( cp_glb->fade_mode == ZKN_POKELIST_BG_FADE_NORMAL ){
		
		if( fadein_out == FALSE ){
			
			// S̖ʂɃuCglXAXN[WZbg
			GF_BGL_ScrollSet( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_FONT_M, GF_BGL_SCROLL_Y_SET, 0 );
		}
	}

	GX_SetVisibleWnd( GX_WNDMASK_NONE );
}


//----------------------------------------------------------------------------
/**
 *	@brief	|PXg̃|P]TCY߂
 *
 *	@param	p_drawglb	`O[of[^
 *	@param	heap		q[v
 *
 *	@return	]TCY
 */
//-----------------------------------------------------------------------------
static int PokeListPokeNameCharTransSizeGet( ZKN_GLB_DRAWDATA* p_drawglb, int heap )
{
	GF_BGL_BMPWIN* p_bmp;	// ݗ̈
	int char_size;

	p_bmp = ZKN_FONTOAM_GetBmp( p_drawglb->fontoam_sys, ZKN_POKELIST_POKENAME_BMP_SIZE_CX, ZKN_POKELIST_POKENAME_BMP_SIZE_CY );
	char_size = FONTOAM_NeedCharSize( p_bmp, NNS_G2D_VRAM_TYPE_2DMAIN, heap ); 
	ZKN_FONTOAM_DeleteBmp( p_bmp );

	return char_size;
}


//----------------------------------------------------------------------------
/**
 *	@brief	OAM̃tF[h
 *
 *	@param	p_work	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListOamFadeInit( ZKN_POKELIST_GRAWORK* p_work )
{
	int i;


	CLACT_ObjModeSet( p_work->cursor, GX_OAM_MODE_XLU );
	
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){
		CLACT_ObjModeSet( p_work->poke_tbl[ i ], GX_OAM_MODE_XLU );
		CLACT_ObjModeSet( p_work->icon[ i ], GX_OAM_MODE_XLU );
		if(p_work->poke_name[ i ]){
			FONTOAM_ObjModeSet( p_work->poke_name[ i ]->p_fontoam, GX_OAM_MODE_XLU );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAM̃tF[hj
 *
 *	@param	p_work	`惏[N
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void PokeListOamFadeDelete( ZKN_POKELIST_GRAWORK* p_work )
{
	int i;


	CLACT_ObjModeSet( p_work->cursor, GX_OAM_MODE_NORMAL );
	
	for( i=0; i<ZKN_POKELIST_POKETBL_NUM; i++ ){
		CLACT_ObjModeSet( p_work->poke_tbl[ i ], GX_OAM_MODE_NORMAL );
		CLACT_ObjModeSet( p_work->icon[ i ], GX_OAM_MODE_NORMAL );
		if(p_work->poke_name[ i ]){
			FONTOAM_ObjModeSet( p_work->poke_name[ i ]->p_fontoam, GX_OAM_MODE_NORMAL );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ZNg|P̃Xgf[^O[õf[^ɔf
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListSelectPokeDataGlbSet( ZKN_POKELIST_GRAWORK* p_work, ZKN_GLB_DRAWDATA* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, int heap )
{
	const VecFx32* p_mat;
	int select_work_no;
	
	// IĂe[uidx擾
	select_work_no = (p_work->poke_tbl_start + ZKN_POKELIST_POKETBL_CHECK) % ZKN_POKELIST_POKETBL_NUM;

	// |PXge[u̍Wݒ
	p_mat = CLACT_GetMatrix( p_work->poke_tbl[ select_work_no ] );

	// |PXgf[^쐬
	ZKN_UTIL_PokeListPokeNameMakeGlb( p_drawglb, cp_glb->p_glb, heap, ZKN_GLBDATA_PokeListTblNoGet( cp_glb->p_glb ), p_mat->x, p_mat->y );
	ZKN_GlbPokeNameTblBGPriSet( p_drawglb, 0 );
}

//----------------------------------------------------------------------------
/**
 *	@brief	m[}tF[h	ʂƃ[eBeBʂSLIDEC@̑uCglX
 *
 *	@param	p_work			`惏[N
 *	@param	cp_dataglb		`O[o
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknPokeListDefaultFadeReq( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out )
{
	// BG
	PokeListBgFadeInit( p_work, p_drawglb, cp_glb, fadein_out );

	// BGtF[h[hZKN_POKELIST_BG_FADE_SHUTTER̎̓uCglXgpȂ
	if( cp_glb->fade_mode != ZKN_POKELIST_BG_FADE_SHUTTER ){
	
		if( fadein_out ){
			// tF[hC
			ChangeBrightnessRequest( ZKN_POKELIST_FADEIN_SYNC, 
					BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, ZKN_POKELSIT_BRIGHTNESS_MSK, MASK_MAIN_DISPLAY );
		}else{
			// tF[hAEg
			ChangeBrightnessRequest( ZKN_POKELIST_FADEIN_SYNC, 
					BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, ZKN_POKELSIT_BRIGHTNESS_MSK, MASK_MAIN_DISPLAY );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[hI`FbN
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb			O[of[^
 *	@param	fadein_out	tF[hCAEg
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL ZknPokeListDefaultFadeEndCheck( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out )
{
	BOOL check[2];

	// BGʂSHUTTERtF[h
	check[0] = PokeListBgFadeMain( p_work, p_drawglb );
	
	// BGtF[h[hZKN_POKELIST_BG_FADE_SHUTTER̎̓uCglXgpȂ
	if( cp_glb->fade_mode != ZKN_POKELIST_BG_FADE_SHUTTER ){
		check[1] = IsFinishedBrightnessChg( MASK_MAIN_DISPLAY );
	}else{
		check[1] = TRUE;
	}

	// uCglXtF[h
	if( (check[0] == TRUE) &&
		(check[1] == TRUE) ){

		// BGtF[h[hZKN_POKELIST_BG_FADE_SHUTTER̎̓uCglXgpȂ
		if( cp_glb->fade_mode != ZKN_POKELIST_BG_FADE_SHUTTER ){
			// ^Âɂ
			if( fadein_out == FALSE ){
				SetBrightness( BRIGHTNESS_BLACK, PLANEMASK_ALL, MASK_MAIN_DISPLAY );
				// BGʂ̏
				GF_BGL_BmpWinDataFill( &p_drawglb->p_drawglb->bmp_mfont, 0 );
				// ʏ
				GF_BGL_ScrClear( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_FONT_M );
			}
		}

		PokeListBgFadeDel( p_drawglb, cp_glb, fadein_out );

		return TRUE;
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	}ӉʂƂ̃tF[h
 *
 *	@param	p_work			`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb			O[of[^
 *	@param	fadein_out		tF[hC TRUE AEg FALSE 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknPokeListChZukanFadeReq( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out )
{
	// tF[hIuWF[h𔼓
	PokeListOamFadeInit( p_work );

	// BG
	PokeListBgFadeInit( p_work, p_drawglb, cp_glb, fadein_out );

	// tF[hAEĝ݂̏
	if( fadein_out == FALSE ){
		// |POtF[h
		PokeListPokeGraFadeInit( p_work, p_drawglb );

		// |PXgtF[h
		PokeListPokeListFadeInit( p_work, p_drawglb );
	}

	// BGtF[h[hZKN_POKELIST_BG_FADE_SHUTTER̎̓uCglXgpȂ
	if( cp_glb->fade_mode != ZKN_POKELIST_BG_FADE_SHUTTER ){


		if( fadein_out ){
			// tF[hC
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade, ZKN_POKELIST_FADEIN_SYNC, 
					BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 0, 16, ZKN_POKELSIT_BRIGHTNESS_ZUKAN_MSK, PLANEMASK_BG3, ZKN_UTIL_FADE_MAIN );
		}else{
			// tF[hAEg
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade, ZKN_POKELIST_FADEIN_SYNC, 
					BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 16, 0, ZKN_POKELSIT_BRIGHTNESS_ZUKAN_MSK, PLANEMASK_BG3, ZKN_UTIL_FADE_MAIN );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӉʂƂ̃tF[hI`FbN
 *
 *	@param	p_work			`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb			O[of[^
 *	@param	fadein_out		tF[hC TRUE@AEg FALSE
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL ZknPokeListChZukanFadeEndCheck( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb, const ZKN_POKELIST_GLB_DATA* cp_glb, BOOL fadein_out )
{
	BOOL check[4];
	int i;

	// BGʂSHUTTERtF[h
	check[0] = PokeListBgFadeMain( p_work, p_drawglb );


	// BGtF[h[hZKN_POKELIST_BG_FADE_SHUTTER̎̓uCglXgpȂ
	if( cp_glb->fade_mode != ZKN_POKELIST_BG_FADE_SHUTTER ){
		// uCglXtF[h
		check[1] = ZKN_GLB_ChangeFadeMain( &p_drawglb->p_drawglb->fade );
	}

	// tF[hAEĝ݂̏
	if( fadein_out == FALSE ){

		// |PO
		check[2] = PokeListPokeGraFadeMain( p_work, p_drawglb );

		// |PXg
		check[3] = PokeListPokeListFadeMain( p_work, p_drawglb );
	}else{
		check[2] = TRUE;
		check[3] = TRUE;
	}

	
	for( i=0; i<4; i++ ){
		if( check[i] == FALSE ){
			break;
		}
	}
	
	if( i == 4 ){
		// tF[hAEĝƂ
		if( fadein_out == FALSE ){
			// BGtF[h[hZKN_POKELIST_BG_FADE_SHUTTER̎̓uCglXgpȂ
			if( cp_glb->fade_mode != ZKN_POKELIST_BG_FADE_SHUTTER ){
				// ^Âɂ
				G2_SetBlendBrightnessExt( ZKN_POKELIST_BRIGHTNESS_ZUKAN_END_MSK, PLANEMASK_BG3, 0, 0, BRIGHTNESS_BLACK );

				// BGʂ̏
				GF_BGL_BmpWinDataFill( &p_drawglb->p_drawglb->bmp_mfont, 0 );
				// ʏ
				GF_BGL_ScrClear( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_FONT_M );
			}
			
		}else{
			// tF[hĈƂ
			// OAM̔[hj
			PokeListOamFadeDelete( p_work );

			// O[o|PXg\OFF
			ZKN_GlbPokeNameTblDrawFlagSet( p_drawglb->p_drawglb, FALSE );
			ZKN_GlbPokeNameTblObjModeSet( p_drawglb->p_drawglb, GX_OAM_MODE_NORMAL );
		}
		
		// BGtF[hZbg
		PokeListBgFadeDel( p_drawglb, cp_glb, fadein_out );
		
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 * [}ӃtF[hGtFNg]
 *	@brief	|POtBbN쏉
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListPokeGraFadeInit( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb )
{
	ZKN_UTIL_MoveReq( &p_work->pokegra_move, ZKN_POKELIST_POKEGRA_X, ZKN_ZUKAN_POKEGRA_MAT_X, ZKN_POKELIST_POKEGRA_Y, ZKN_ZUKAN_POKEGRA_MAT_Y, ZKN_POKELIST_FADEIN_SYNC );

	// Wݒ
	ZKN_GlbPokemonGraphicSetMatrix( p_drawglb->p_drawglb, p_work->pokegra_move.x, p_work->pokegra_move.y );
}

//----------------------------------------------------------------------------
/**
 * [}ӃtF[hGtFNg]
 *	@brief	|POtBbN
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL PokeListPokeGraFadeMain( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb )
{
	BOOL check;
	
	check = ZKN_UTIL_MoveMain( &p_work->pokegra_move );

	// Wݒ
	ZKN_GlbPokemonGraphicSetMatrix( p_drawglb->p_drawglb, p_work->pokegra_move.x, p_work->pokegra_move.y );

	return check;
}

//----------------------------------------------------------------------------
/**
 * [}ӃtF[hGtFNg]
 *	@brief	|PXg쏉
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListPokeListFadeInit( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb )
{
	ZKN_UTIL_MoveReq( &p_work->pokelist_move, ZKN_POKELIST_TBL_MAT_X, ZKN_ZUKAN_POKELIST_MAT_IX, ZKN_POKELIST_TBL_MAT_Y, ZKN_ZUKAN_POKELIST_MAT_IY, ZKN_POKELIST_FADEIN_SYNC );

	// Wݒ
	ZKN_UTIL_PokeListPokeNameGlbMatrixSet( p_drawglb->p_drawglb, p_work->pokelist_move.x, p_work->pokelist_move.y );
}

//----------------------------------------------------------------------------
/**
 * [}ӃtF[hGtFNg]
 *	@brief	|PXg쏉
 *
 *	@param	p_work		`惏[N
 *	@param	p_drawglb	`O[o
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static BOOL PokeListPokeListFadeMain( ZKN_POKELIST_GRAWORK* p_work, ZKN_POKELIST_GLB_DRAW* p_drawglb )
{
	BOOL check;
	
	check = ZKN_UTIL_MoveMain( &p_work->pokelist_move );

	// Wݒ
	ZKN_UTIL_PokeListPokeNameGlbMatrixSet( p_drawglb->p_drawglb, p_work->pokelist_move.x, p_work->pokelist_move.y );

	return check;
}


//----------------------------------------------------------------------------
/**
 *	@brief	}Ӕj
 *
 *	@param	p_glb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void PokeListZukanDel( ZKN_POKELIST_GLB_DATA* p_glb )
{
	*p_glb->p_event_key	|= EVENT_MSK_POKELIST_ZUKAN_END;
	// tF[hC[hύX
	p_glb->fade_mode = ZKN_POKELIST_BG_FADE_NORMAL;
	p_glb->fade_zukan_data = FALSE;

	p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_ALL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}Ӄf[^ʂɈڍs
 *
 *	@param	p_glb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void PokeListZukanChg( ZKN_POKELIST_WORK* p_work, ZKN_POKELIST_GLB_DATA* p_glb )
{
	*p_glb->p_event_key	|= EVENT_MSK_POKELIST_CHENGE_ZUKAN;
	// tF[hC[hύX
	p_glb->fade_mode = ZKN_POKELIST_BG_FADE_NORMAL;
	p_glb->fade_zukan_data = TRUE;

	// O[oϐ
	p_glb->move_count = 0;
//	PokeListMoveInit( p_glb, p_work );	
	p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_ALL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PXgSORTʂɕ
 *
 *	@param	p_glb 
 *
 *	@retval	TRUE	ꂽ
 *	@retval	FALSE	ȂȂ
 */
//-----------------------------------------------------------------------------
static BOOL PokeListSortChg( ZKN_POKELIST_GLB_DATA* p_glb )
{
	if( p_glb->p_glb->sort_search_flag == ZKN_SORTSEARCH_NONE ){
		
		// \[gʒuɃJ[\ړČ\[gʊJn
		*p_glb->p_event_key |= EVENT_MSK_POKELIST_CHENGE_SORTSEARCH;//*/

		// tF[h[h
		p_glb->fade_mode = ZKN_POKELIST_BG_FADE_NORMAL;
		p_glb->fade_zukan_data = FALSE;

		p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_ALL;

		// I
		Snd_SePlay( ZKN_SND_SELECT );
		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}Ӄ[h؂ւ
 *
 *	@param	p_glb	O[of[^
 *
 *	@retval	TRUE	ꂽ
 *	@retval	FALSE	Ȃ
 */
//-----------------------------------------------------------------------------
static BOOL PokeListZukanModeChg( ZKN_POKELIST_GLB_DATA* p_glb, int heap )
{
	int zkn_mode;

	// Ӱނ̎͂Ȃ
	if( p_glb->p_glb->sort_search_flag == ZKN_SORTSEARCH_SORT ){
		return FALSE;
	}
		

	// }Ӄ[hύX
	zkn_mode = ZKN_GLBDATA_PokeZknModeGet(p_glb->p_glb);
	if( zkn_mode == ZKN_MODE_SHINOH ){
		zkn_mode = ZKN_MODE_ZENKOKU;
	}else{
		zkn_mode = ZKN_MODE_SHINOH;
	}
	
	// }Ӄ[hύXł邩`FbN
	if( ZKN_GLBDATA_PokeZknModeChengeCheck( p_glb->p_glb, zkn_mode ) ){
		// ύX
		ZKN_GLBDATA_PokeZknModeChenge( p_glb->p_glb, zkn_mode );

		// I
		Snd_SePlay( ZKN_SND_SELECT );

		// Xgݒ
		ZKN_GLBDATA_PokeListTblMake( p_glb->p_glb, 
				ZKN_POKELIST_SORT_NORMAL, 
				ZKN_POKELIST_SEARCH_NAME_NONE,
				ZKN_POKELIST_SEARCH_TYPE_NONE,
				ZKN_POKELIST_SEARCH_TYPE_NONE,
				ZKN_POKELIST_SEARCH_FORM_NONE,
				zkn_mode, heap );

		// Xgio[
		ZKN_GLBDATA_PokeListTblNoSet( p_glb->p_glb, 0 );

		// JE^
		p_glb->move_count = 0;	

		// |PXgʍč쐬
		*p_glb->p_event_key |= EVENT_MSK_POKELIST_CHANGE;
		// tF[hC[hύX
		p_glb->fade_mode = ZKN_POKELIST_BG_FADE_NORMAL;
		p_glb->fade_zukan_data = FALSE;

		p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_ALL;

		// `siOFF
		p_glb->move_draw = FALSE;

		return TRUE;
	}
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӂSORTݒ胊Zbg
 *
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void PokeListZukanReset( ZKN_POKELIST_GLB_DATA* p_glb, int heap )
{
	// X^[io[ۑ
	u32 monsno = ZKN_GLBDATA_PokeMonsNoGet( p_glb->p_glb );
	
	// }ӃXgZbg
	ZKN_GLBDATA_PokeListTblMake( p_glb->p_glb, 
			ZKN_POKELIST_SORT_NORMAL, 
			ZKN_POKELIST_SEARCH_NAME_NONE,
			ZKN_POKELIST_SEARCH_TYPE_NONE,
			ZKN_POKELIST_SEARCH_TYPE_NONE,
			ZKN_POKELIST_SEARCH_FORM_NONE,
			ZKN_GLBDATA_PokeZknModeGet( p_glb->p_glb ), heap );
	(*p_glb->p_event_key) |= EVENT_MSK_POKELIST_CHANGE;

	// Xgio[
	ZKN_GLBDATA_PokeListTblNoSet_Monsno( p_glb->p_glb, monsno );

	// JE^
	p_glb->move_count = 0;	

	// ă[hύX
	p_glb->p_glb->sort_search_flag = ZKN_SORTSEARCH_NONE;

	// tF[hC[hύX
	p_glb->fade_mode = ZKN_POKELIST_BG_FADE_NORMAL;
	p_glb->fade_zukan_data = FALSE;
	// Ȃ
	p_glb->move_way = ZKN_POKE_LIST_NO_MOVE;

	p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_ALL;

	// `siOFF
	p_glb->move_draw = FALSE;
}



//----------------------------------------------------------------------------
/**
 *	@brief	XLbv
 *
 *	@param	p_work
 *	@param	p_glb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void PokeListSkipMove( ZKN_POKELIST_WORK* p_work, ZKN_POKELIST_GLB_DATA* p_glb )
{
	p_work->skip_count--;
	
	if( p_work->skip_count >= 0 ){
		if( PokeListMoveAdd( p_glb, p_work->skip_add ) ){

			PokeListMoveReq( p_glb, p_work, p_work->skip_way );
			p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_NORMAL;	// TuʃzC[~
			// Iړ
			Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
		}else{
			p_work->skip_count = 0;		// ŏIVڂ܂ł
		}
	}else{

		// XLbvI
		PokeListMoveInit( p_glb, p_work );	
		p_work->skip_flag = FALSE;		// XLbvI
		p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_NONE;	// TuʃzC[bN
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	L[
 *
 *	@param	p_work
 *	@param	p_glb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void PokeListKeyMove( ZKN_POKELIST_WORK* p_work, ZKN_POKELIST_GLB_DATA* p_glb )
{

	// J[\Abv
	if( sys.cont & PAD_KEY_UP ){
		// lXVꂽ瓮
		if( PokeListMoveAdd( p_glb, -1 ) ){
			PokeListMoveReq( p_glb, p_work, ZKN_POKE_LIST_DOWN );
			p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_NORMAL;	// TuʃzC[~
			
			// Iړ
			Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
		}else{
			PokeListMoveInit( p_glb, p_work );	
			p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_NONE;	// TuʃzC[~
		}
		return ;
	}

	// J[\
	if( sys.cont & PAD_KEY_DOWN ){
		// lXVꂽ瓮
		if( PokeListMoveAdd( p_glb, 1 ) ){
			PokeListMoveReq( p_glb, p_work, ZKN_POKE_LIST_UP );
			p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_NORMAL;	// TuʃzC[~

			// Iړ
			Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
		}else{
			PokeListMoveInit( p_glb, p_work );	
			p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_NONE;	// TuʃzC[~
		}
		return ;
	}

	//XLbv
	if( sys.trg & PAD_KEY_LEFT ){
		p_work->skip_flag = TRUE;
		p_work->skip_count = ZKN_POKE_LIST_MOVE_SKIP_NUM;
		p_work->skip_add = -1;
		p_work->skip_way = ZKN_POKE_LIST_DOWN;
		// x
		PokeListSkipMoveInit( p_glb, p_work );
		return ;
	}
	if( sys.trg & PAD_KEY_RIGHT ){
		p_work->skip_flag = TRUE;
		p_work->skip_count = ZKN_POKE_LIST_MOVE_SKIP_NUM;
		p_work->skip_add = 1;
		p_work->skip_way = ZKN_POKE_LIST_UP;
		// x
		PokeListSkipMoveInit( p_glb, p_work );
		return ;
	}

	// SĂɈȂƂ͉Ȃ
	// dɏƃTuʂŃf[^XV
	// Ă܂
	if( p_glb->sub_wheel_lock == ZKN_POKELIST_WHEEL_LOCK_NORMAL ){
		PokeListMoveInit( p_glb, p_work );	
		p_glb->sub_wheel_lock = ZKN_POKELIST_WHEEL_LOCK_NONE;	// TuʃzC[~
	}
}

