//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_proc_sys.c
 *	@brief		}ӏVXe
 *	@author		tomoya takahashi
 *	@data		2006.01.17
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>

#define __ZKN_PROC_SYS_H_GLOBAL
#include "include/application/zukanlist/zkn_proc_sys.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	}ӃvZXVXȅ̗
//=====================================
enum{
	ZKN_PROC_MAINSEQ_DO_INIT,			// f[^ύX̏
	ZKN_PROC_MAINSEQ_DRAW_INIT,			// `揈tF[hC
	ZKN_PROC_MAINSEQ_MAIN,				// C
	ZKN_PROC_MAINSEQ_DRAW_DELETE,		// `揈jtF[hAEg
	ZKN_PROC_MAINSEQ_DO_DELETE,			// f[^ύXj
	ZKN_PROC_MAINSEQ_ALL_END,			// SĂ̏I܂
};

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		vZXVXe
 */
//-----------------------------------------------------------------------------
typedef struct _ZKN_PROC_SYS{
	// O[of[^
	void* p_glb_data;	// Ǘ҂󂯎O[of[^
	void* p_glb_draw;	// Ǘ҂󂯎O[of[^

	// Ŝ̗̏
	int	main_seq;

	// f[^́XV
	ZKN_PROC_DO_DATA	do_data;						// [N
	ZKN_PROC_DO_FUNC	do_func[ ZKN_PROC_FUNC_NUM ];	// e֐

	// `揈
	ZKN_PROC_DRAW_DATA	draw_data;						// [N
	ZKN_PROC_DRAW_FUNC	draw_func[ ZKN_PROC_FUNC_NUM ];	// e֐

	// ̑
	int heap;				// gpq[v
} ZKN_PROC_SYS;



//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void InitProcDoData( ZKN_PROC_DO_DATA* data );
static void InitProcDrawData( ZKN_PROC_DRAW_DATA* data );

static int DoFuncProcDo( ZKN_PROC_DO_FUNC func, ZKN_PROC_DO_DATA* p_do_data, void* p_glb_data );
static int DoFuncProcDraw( ZKN_PROC_DRAW_FUNC func, void* p_glb_draw, ZKN_PROC_DRAW_DATA* p_draw_data, const void* cp_glb_data, const ZKN_PROC_DO_DATA* cp_do_data );

//-----------------------------------------------------------------------------
/**
 *
 *				
 * 
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	m
 *
 *	@param	heap	q[v
 *
 *	@return	mۂďς݂̃vZXVXe
 *
 *
 */
//-----------------------------------------------------------------------------
ZKN_PROC_SYS_PTR ZKN_PROC_MemoryAlloc( int heap )
{
	ZKN_PROC_SYS_PTR proc;

	proc = sys_AllocMemory( heap, sizeof(ZKN_PROC_SYS) );
	GF_ASSERT( proc );
	memset( proc, 0, sizeof(ZKN_PROC_SYS) );

	proc->main_seq = ZKN_PROC_MAINSEQ_ALL_END;
	proc->heap = heap;

	return proc;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	
 *
 *	@param	proc		vZXVXe
 *	@param	cp_init		f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_PROC_Init( ZKN_PROC_SYS_PTR proc, const ZKN_PROC_INIT* cp_init )
{
	GF_ASSERT( proc );
	GF_ASSERT( cp_init );

	// IĂȂ̂ɏ悤Ƃ
	GF_ASSERT( ZKN_PROC_EndCheck(proc) );

	// vZXf[^̑
	proc->p_glb_data = cp_init->p_glb_data;		// O[of[^
	proc->p_glb_draw = cp_init->p_glb_draw;		// O[of[^
	proc->main_seq	 = ZKN_PROC_FUNC_INIT;		// CV[PX
	InitProcDoData( &proc->do_data );			// f[^ύXp[N
	proc->do_data.heap = proc->heap;
	InitProcDrawData( &proc->draw_data );		// `揈p[N
	proc->draw_data.heap = proc->heap;

	// ֐|C^
	proc->do_func[ ZKN_PROC_FUNC_INIT ] = cp_init->cp_do_func[ ZKN_PROC_FUNC_INIT ];
	proc->do_func[ ZKN_PROC_FUNC_MAIN ] = cp_init->cp_do_func[ ZKN_PROC_FUNC_MAIN ];
	proc->do_func[ ZKN_PROC_FUNC_DELETE ] = cp_init->cp_do_func[ ZKN_PROC_FUNC_DELETE ];
	proc->draw_func[ ZKN_PROC_FUNC_INIT ] = cp_init->cp_draw_func[ ZKN_PROC_FUNC_INIT ];
	proc->draw_func[ ZKN_PROC_FUNC_MAIN ] = cp_init->cp_draw_func[ ZKN_PROC_FUNC_MAIN ];
	proc->draw_func[ ZKN_PROC_FUNC_DELETE ] = cp_init->cp_draw_func[ ZKN_PROC_FUNC_DELETE ];
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C
 *
 *	@param	proc	vZXVXe
 *
 *	@retval	ZKN_PROC_TRUE		SĔjďI܂B
 *	@retval	ZKN_PROC_FALSE		
 *
 *
 */
//-----------------------------------------------------------------------------
int ZKN_PROC_Main( ZKN_PROC_SYS_PTR proc )
{
	int ret;

	GF_ASSERT( proc );

	switch( proc->main_seq ){

	//-------------------------------------
	// f[^ύX̏
	//=====================================
	case ZKN_PROC_MAINSEQ_DO_INIT:			
		ret = DoFuncProcDo( proc->do_func[ ZKN_PROC_FUNC_INIT ], &proc->do_data, proc->p_glb_data );
		if( ret == ZKN_PROC_TRUE ){
			proc->main_seq++;
			proc->do_data.seq = 0;
		}
		break;
		
	//-------------------------------------
	// `揈tF[hC
	//=====================================
	case ZKN_PROC_MAINSEQ_DRAW_INIT:			
		break;
		
	//-------------------------------------
	// C
	//=====================================
	case ZKN_PROC_MAINSEQ_MAIN:				
		// f[^ύX
		ret = DoFuncProcDo( proc->do_func[ ZKN_PROC_FUNC_MAIN ], &proc->do_data, proc->p_glb_data );

		// f[^ύXIȂI
		if( ret == ZKN_PROC_TRUE ){
			proc->main_seq++;
			proc->do_data.seq = 0;
			proc->draw_data.seq = 0;
		}
		break;
		
	//-------------------------------------
	// `揈jtF[hAEg
	//=====================================
	case ZKN_PROC_MAINSEQ_DRAW_DELETE:		
		break;
		
	//-------------------------------------
	// f[^ύXj
	//=====================================
	case ZKN_PROC_MAINSEQ_DO_DELETE:			
		ret = DoFuncProcDo( proc->do_func[ ZKN_PROC_FUNC_DELETE ], &proc->do_data, proc->p_glb_data );
		if( ret == ZKN_PROC_TRUE ){
			proc->main_seq++;
		}
		break;
		
	//-------------------------------------
	//	SύX
	//=====================================
	case ZKN_PROC_MAINSEQ_ALL_END:			// SĂ̏I܂
		return ZKN_PROC_TRUE;

	default:
		// ɂ̂͂
		GF_ASSERT(0);
		break;
	}
	
	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`揈
 *
 *	@param	proc	vZXf[^
 *
 *	@retval	ZKN_PROC_TRUE		SĔjďI܂B
 *	@retval	ZKN_PROC_FALSE		
 */
//-----------------------------------------------------------------------------
int ZKN_PROC_Draw( ZKN_PROC_SYS_PTR proc )
{
	int ret;

	GF_ASSERT( proc );

	switch( proc->main_seq ){

	//-------------------------------------
	// f[^ύX̏
	//=====================================
	case ZKN_PROC_MAINSEQ_DO_INIT:			
		break;
		
	//-------------------------------------
	// `揈tF[hC
	//=====================================
	case ZKN_PROC_MAINSEQ_DRAW_INIT:			
		ret = DoFuncProcDraw( proc->draw_func[ ZKN_PROC_FUNC_INIT ], proc->p_glb_draw, &proc->draw_data, proc->p_glb_data, &proc->do_data );
		if( ret == ZKN_PROC_TRUE ){
			proc->main_seq++;
			proc->draw_data.seq = 0;
		}
		break;
		
	//-------------------------------------
	// C
	//=====================================
	case ZKN_PROC_MAINSEQ_MAIN:				
		
		// `
		DoFuncProcDraw( proc->draw_func[ ZKN_PROC_FUNC_MAIN ], proc->p_glb_draw, &proc->draw_data, proc->p_glb_data, &proc->do_data );
		break;
		
	//-------------------------------------
	// `揈jtF[hAEg
	//=====================================
	case ZKN_PROC_MAINSEQ_DRAW_DELETE:		
		ret = DoFuncProcDraw( proc->draw_func[ ZKN_PROC_FUNC_DELETE ], proc->p_glb_draw, &proc->draw_data, proc->p_glb_data, &proc->do_data );
		if( ret == ZKN_PROC_TRUE ){
			proc->main_seq++;
		}
		break;
		
	//-------------------------------------
	// f[^ύXj
	//=====================================
	case ZKN_PROC_MAINSEQ_DO_DELETE:			
		break;
		
	//-------------------------------------
	//	SύX
	//=====================================
	case ZKN_PROC_MAINSEQ_ALL_END:			// SĂ̏I܂
		return ZKN_PROC_TRUE;

	default:
		// ɂ̂͂
		GF_ASSERT(0);
		break;
	}
	
	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Clock
 *
 *	@param	proc	vbNC
 *	@param	lock	locktO
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_PROC_MoveLock( ZKN_PROC_SYS_PTR proc, BOOL lock )
{
	proc->do_data.lock = lock;
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	INGXgo
 *
 *	@param	proc	vZXVXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_PROC_EndReq( ZKN_PROC_SYS_PTR proc )
{
	GF_ASSERT( proc );

	proc->do_data.end_req = TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	I`FbN
 *
 *	@param	proc	`FbNvZXVXe
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL ZKN_PROC_EndCheck( ZKN_PROC_SYS_PTR proc )
{
	GF_ASSERT( proc );

	if( proc->main_seq == ZKN_PROC_MAINSEQ_ALL_END ){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	C삵Ă邩`FbN
 *
 *	@param	proc	vZXVXe
 *
 *	@retval	TRUE	C쒆
 *	@retval	FALSE	ȊȌĂ܂
 *
 *	CƂ̓tF[hCȈł
 */
//-----------------------------------------------------------------------------
BOOL ZKN_PROC_MainMoveCheck( ZKN_PROC_SYS_PTR proc )
{
	GF_ASSERT( proc );

	if( proc->main_seq == ZKN_PROC_MAINSEQ_MAIN ){
		return TRUE;
	}

	return FALSE;
}




//-----------------------------------------------------------------------------
/**
 *			vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	f[^ύXp[NgpȌԂɂ
 *
 *	@param	data	f[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void InitProcDoData( ZKN_PROC_DO_DATA* data )
{
	data->seq = 0;
	data->p_work = NULL;
	data->end_req = FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`p[NgpȌԂɂ
 *
 *	@param	data	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void InitProcDrawData( ZKN_PROC_DRAW_DATA* data )
{
	data->seq = 0;
	data->p_work = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	f[^ύX@֐s
 *
 *	@param	func			֐
 *	@param	p_do_data		f[^ύX[N
 *	@param	p_glb_data		O[of[^
 *
 *	@retval	ZKN_PROC_TRUE		̏
 *	@retval	ZKN_PROC_FALSE		
 *
 *
 */
//-----------------------------------------------------------------------------
static int DoFuncProcDo( ZKN_PROC_DO_FUNC func, ZKN_PROC_DO_DATA* p_do_data, void* p_glb_data )
{
	int ret;
	
	GF_ASSERT( func );
	GF_ASSERT( p_do_data );
//	GF_ASSERT( p_glb_data );

	ret = func( p_do_data, p_glb_data );

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	`揈֐s
 *
 *	@param	func			֐|C^
 *	@param	p_glb_draw		`pO[of[^
 *	@param	p_draw_data		`揈[N
 *	@param	cp_glb_data		O[of[^
 *	@param	cp_do_data		[N 
 *
 *	@retval	ZKN_PROC_TRUE		SĔjďI܂B
 *	@retval	ZKN_PROC_FALSE		
 *
 *
 */
//-----------------------------------------------------------------------------
static int DoFuncProcDraw( ZKN_PROC_DRAW_FUNC func, void* p_glb_draw,  ZKN_PROC_DRAW_DATA* p_draw_data, const void* cp_glb_data, const ZKN_PROC_DO_DATA* cp_do_data )
{
	int ret;
	
	GF_ASSERT( func );
	GF_ASSERT( p_draw_data );
	GF_ASSERT( cp_do_data );
//	GF_ASSERT( cp_glb_data );
//	GF_ASSERT( p_glb_draw );

	ret = func( p_glb_draw, p_draw_data, cp_glb_data, cp_do_data );

	return ret;
}
