//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_range_sub.c
 *	@brief		z}Tu
 *	@author		tomoya takahashi 
 *	@data		2006.01.21
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include "calctool.h"
#include <string.h>
#include "include/application/zukanlist/zkn_event_func.h"
#include "include/gflib/vram_transfer_manager.h"

#include "include/system/brightness.h"
#include "include/system/arc_tool.dat"
#include "include/system/arc_util.h"
#include "include/system/clact_util.h"
#include "include/application/zukanlist/zukan.naix"
#include "include/gflib/button_man.h"
#include "include/system/msgdata_util.h"
#include "include/msgdata/msg.naix"
#include "include/msgdata/msg_zkn.h"

#include "include/application/zukanlist/zkn_snd_def.h"
#include "include/application/zukanlist/zkn_zukan_common.h"
#include "include/application/zukanlist/zkn_range.h"

#define	__ZKN_RANGE_SUB_SUB_H_GLOBAL
#include "include/application/zukanlist/zkn_range_sub.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define ZKN_RANGE_SUB_EVENT_NUM ( 0 )	// Cxg

#define ZKN_RANGE_SUB_OAM_BG_PRI	( 1 )
#define ZKN_RANGE_SUB_OAM_SOFT_PRI	( 31 )

enum{
	ZKN_RANGESUB_SEQINIT_ALLOC,
	ZKN_RANGESUB_SEQINIT_LOAD,
	ZKN_RANGESUB_SEQINIT_FADEIN,
	ZKN_RANGESUB_SEQINIT_END,
};
enum{
	ZKN_RANGESUB_SEQDELETE_FADEOUT_INIT,
	ZKN_RANGESUB_SEQDELETE_FADEOUT,
	ZKN_RANGESUB_SEQDELETE_RELEASE,
	ZKN_RANGESUB_SEQDELETE_FREE,
	ZKN_RANGESUB_SEQDELETE_END,
};

// {^
enum{
	ZKN_RANGESUB_BUTTON_CURSOR,
	ZKN_RANGESUB_BUTTON_NUM,
};


// ԃe[u
#define ZKN_RANGE_SUB_TIME_LIMIT	( 85 )

//BGpbgtF[h
#define ZKN_RANGE_SUB_TIMEPLTT_LIMIT	( 51 )
#define ZKN_RANGE_SUB_PLTT_NUM			( 5 )
#define ZKN_RANGE_SUB_PLTT_NO			( 2 )

// pbgAj
#define ZKN_RANGE_SUB_PLTT_ANM_WAIT	( 0 )
enum{
	ZKN_RANGESUB_PLTTANM_SEQ_NOW_PLTT_0,
//	ZKN_RANGESUB_PLTTANM_SEQ_NOW_PLTT_0WAIT,
	ZKN_RANGESUB_PLTTANM_SEQ_NEXT_PLTT_0,
//	ZKN_RANGESUB_PLTTANM_SEQ_NEXT_PLTT_0WAIT,
	ZKN_RANGESUB_PLTTANM_SEQ_NEXT_PLTT_1,
};
	

// J[\ʒu
#define ZKN_RANGE_SUB_CURSOR_MORNING_X	( 32 )
#define ZKN_RANGE_SUB_CURSOR_MORNING_Y	( 128 )
#define ZKN_RANGE_SUB_CURSOR_NOON_X		( 128 )
#define ZKN_RANGE_SUB_CURSOR_NOON_Y		( 96 )
#define ZKN_RANGE_SUB_CURSOR_NIGHT_X	( 224 )
#define ZKN_RANGE_SUB_CURSOR_NIGHT_Y	( 128 )
#define ZKN_RANGE_SUB_CURSOR_SEQ		( 0 )
#define ZKN_RANGE_SUB_CURSOR_SIZE_R		( 32 )
#define ZKN_RANGE_SUB_CURSOR_LIMIT_X	( 24 )
#define ZKN_RANGE_SUB_CURSOR_LIMIT_X_MAX	( 246 )
#define ZKN_RANGE_SUB_CURSOR_LIMIT_Y	( 64 )
#define ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX	( 132 )
#define ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_DIS	( 48 )
#define ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_SUB_X	( 40 )	// [猸炷XWl
#define ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_SUB_X_CALC_DIS	( 256 - (ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_SUB_X * 2) )	// [猸炷XWlւ炵size
#define ZKN_RANGE_SUB_CURSOR_MARK_SIZE_X		( 32 )
#define ZKN_RANGE_SUB_CURSOR_MARK_SIZE_Y		( 32 )


// tF[h
#define ZKN_RANGESUB_FADE_PLANEMSK	( GX_BLEND_PLANEMASK_BG2|GX_BLEND_PLANEMASK_BG3|GX_BLEND_PLANEMASK_BD )

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	z}Tuʉʁ@O[oϐ
//=====================================
typedef struct {
	// z}TuAvf[^
	ZKN_APL_DATA* p_range_apl;
	
	// }ӃRTuAvf[^
	const ZKN_APL_DATA* cp_zukan_common_apl;
} ZKN_RANGE_SUB_GLB;

//-------------------------------------
//	z}Tuʉʁ@`O[oϐ
//=====================================
typedef struct {
	ZKN_GLB_DRAWDATA* p_drawglb;
} ZKN_RANGE_SUB_DRAWGLB;

//-------------------------------------
//	{^R[obNp[N
//=====================================
typedef struct {
	void* p_glb;
	void* p_work;
} ZKN_RANGE_SUB_CALLBACK_WORK;


//-------------------------------------
//	z}Tuʉʁ@[N
//=====================================
typedef struct {
	// ^b`W
	int x;
	int y;
	int ofs_x;	// }ꂽƂ̒S̗ꂽW
	int ofs_y;

	BUTTON_MAN* p_button_man;
	TP_HIT_TBL *hit_tbl;	// {^f[^
	ZKN_RANGE_SUB_CALLBACK_WORK button_work;
	int touch;

	BOOL key_set;
	
} ZKN_RANGE_SUB_WORK;

//-------------------------------------
//	z}Tuʉʁ@[N
//=====================================
typedef struct {
	CLACT_WORK_PTR cursor;	// J[\
	CLACT_U_RES_OBJ_PTR res_obj[ ZKN_CLACT_RES_OBJ_NUM_DEF ];

	void* pltt_buff;
	int pltt_no;
	int next_pltt_no;
	NNSG2dPaletteData* p_plt;
	int pltt_anm_seq;
	int pltt_anm_count;
} ZKN_RANGE_SUB_DRAW;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		AvP[Vf[^쐬֌W
 */
//-----------------------------------------------------------------------------
static ZKN_RANGE_SUB_GLB* MakeRangeSubGlb( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_RANGE_SUB_DRAWGLB* MakeRangeSubDrawGlb( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_EVENT_DATA* MakeRangeSubEvent( int heap, ZKN_SYS_PTR zkn_sys );
static void DeleteRangeSubGlb( ZKN_RANGE_SUB_GLB* p_glb );
static void DeleteRangeSubDrawGlb( ZKN_RANGE_SUB_DRAWGLB* p_glb );
static void DeleteRangeSubEvent( ZKN_EVENT_DATA* p_event );


static int RangeSubEventDataNumGet( void );


//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
static int ZknRangeSubProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknRangeSubProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknRangeSubProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknRangeSubProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknRangeSubProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknRangeSubProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );

// tF[h
static void ZknRangeSubOamFadeInit( ZKN_RANGE_SUB_DRAW* p_draw );
static void ZknRangeSubOamFadeDelete( ZKN_RANGE_SUB_DRAW* p_draw );
static void ZknRangeSubFadeInit( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, const ZKN_RANGE_SUB_GLB* cp_glb, BOOL fadein_out );
static BOOL ZknRangeSubFadeMain( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, const ZKN_RANGE_SUB_GLB* cp_glb, BOOL fadein_out );

// {^
static void ZknRangeSubCursorInit( ZKN_RANGE_SUB_WORK* p_work, ZKN_RANGE_SUB_GLB* p_glb, int heap );

static void ZknRangeSubCursorMain( ZKN_RANGE_SUB_WORK* p_work, ZKN_RANGE_SUB_GLB* p_glb );
static void ZknRangeSubButtonCallBack( u32 button_no, u32 event, void* p_work );
static void ZknRangeSubCursorDelete( ZKN_RANGE_SUB_WORK* p_work );
static void ZknRangeSubCursorMove( ZKN_RANGE_SUB_WORK* p_work, ZKN_RANGE_SUB_GLB* p_glb );
static void ZknRangeSubCursorDefMatSet( ZKN_RANGE_SUB_WORK* p_work, ZKN_RANGE_SUB_GLB* p_glb );

// L[ɂJ[\
static void ZknRangeSubCursorMoveKey( ZKN_RANGE_SUB_WORK* p_work, ZKN_RANGE_SUB_GLB* p_glb );

static void ZknRangeSubCursorMoveKey_CorsorDrawSet( ZKN_RANGE_SUB_DRAWGLB* p_drawglb, const ZKN_RANGE_SUB_WORK* cp_work, const ZKN_RANGE_SUB_GLB* cp_glb );


// ǂݍݏ
static void ZknRangeSubLoadResource( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknRangeSubReleaseResource( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknRangeSubSetUpBg( ZKN_RANGE_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknRangeSubLoadOamData( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknRangeSubReleaseOamData( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb );
static void ZknRangeSubAddClact( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknRangeSubDeleteClact( ZKN_RANGE_SUB_DRAW* p_draw );

// CURSOR`搧
static void ZknRangeSubCursorDraw( ZKN_RANGE_SUB_DRAW* p_draw, const ZKN_RANGE_SUB_GLB* cp_glb, const ZKN_RANGE_SUB_WORK* cp_work );

static int ZknRangeSubCursorMoveMaxDisGet( int x );

// BGpbg
static void ZknRangeSubBgPlttDraw( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, const ZKN_RANGE_SUB_GLB* cp_glb, int heap );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	z}Tuʁ@Av쐬
 *
 *	@param	p_data		AvP[Vf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	heap		gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_RangeSubAplMake( ZKN_APL_DATA* p_data, ZKN_SYS_PTR zkn_sys, int heap )
{
	ZKN_RANGE_SUB_GLB*	p_glb;
	ZKN_RANGE_SUB_DRAWGLB*	p_drawglb;
	ZKN_EVENT_DATA*	p_event;
	
	p_glb = MakeRangeSubGlb( heap, zkn_sys );
	p_drawglb = MakeRangeSubDrawGlb( heap, zkn_sys );
	p_event = MakeRangeSubEvent( heap, zkn_sys );

	p_data->p_glb_data		= p_glb;
	p_data->p_glb_draw		= p_drawglb;
	p_data->p_event_data	= p_event;
	p_data->event_num		= RangeSubEventDataNumGet();

	p_data->do_func[ ZKN_PROC_FUNC_INIT ] = ZknRangeSubProcDoFuncInit;
	p_data->do_func[ ZKN_PROC_FUNC_MAIN ] = ZknRangeSubProcDoFuncMain;
	p_data->do_func[ ZKN_PROC_FUNC_DELETE ] = ZknRangeSubProcDoFuncDelete;
	p_data->draw_func[ ZKN_PROC_FUNC_INIT ] = ZknRangeSubProcDrawFuncInit;
	p_data->draw_func[ ZKN_PROC_FUNC_MAIN ] = ZknRangeSubProcDrawFuncMain;
	p_data->draw_func[ ZKN_PROC_FUNC_DELETE ] = ZknRangeSubProcDrawFuncDelete;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg	Tuʁ@j[Avj
 *
 *	@param	p_data	AvP[Vf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_RangeSubAplDelete( ZKN_APL_DATA* p_data )
{
	DeleteRangeSubGlb( p_data->p_glb_data ); 
	DeleteRangeSubDrawGlb( p_data->p_glb_draw ); 
	DeleteRangeSubEvent( p_data->p_event_data );
}



//-----------------------------------------------------------------------------
/**
 *		vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	z}Tuʁ@O[of[^쐬
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_RANGE_SUB_GLB* MakeRangeSubGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_RANGE_SUB_GLB* p_glb;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_RANGE_SUB_GLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_RANGE_SUB_GLB) );

	// z}Avf[^
	p_glb->p_range_apl = ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_RANGE );

	// }ӃTuRf[^
	p_glb->cp_zukan_common_apl = ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_ZUKAN_COMMON );

	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *	@brief	`O[o
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static ZKN_RANGE_SUB_DRAWGLB* MakeRangeSubDrawGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_RANGE_SUB_DRAWGLB* p_glb;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_RANGE_SUB_DRAWGLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_RANGE_SUB_DRAWGLB) );

	// `f[^
	p_glb->p_drawglb = ZKN_SYS_GetGlbDrawData( zkn_sys );


	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	z}Tuʁ@Cxg쐬
 *
 *	@param	heap		gpq[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	Cxgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_EVENT_DATA* MakeRangeSubEvent( int heap, ZKN_SYS_PTR zkn_sys )
{
	return NULL;	// ͂Ȃ
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	z}Tuʁ@O[of[^j
 *
 *	@param	p_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteRangeSubGlb( ZKN_RANGE_SUB_GLB* p_glb )
{
	GF_ASSERT( p_glb );
	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	z}Tuʁ@O[of[^j
 *
 *	@param	p_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteRangeSubDrawGlb( ZKN_RANGE_SUB_DRAWGLB* p_glb )
{
	GF_ASSERT( p_glb );
	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	z}Tuʁ@Cxgf[^j
 *
 *	@param	p_event	Cxgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteRangeSubEvent( ZKN_EVENT_DATA* p_event )
{
	// ͂Ȃ
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	z}TuʃAv@Cxg擾
 *	
 *	@param	none	
 *
 *	@return	z}TuʃAv@Cxg
 *
 *
 */
//-----------------------------------------------------------------------------
static int RangeSubEventDataNumGet( void )
{
	return ZKN_RANGE_SUB_EVENT_NUM;
}


//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	[]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknRangeSubProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_RANGE_SUB_GLB* p_glb = p_glbdata;
	ZKN_RANGE_SUB_WORK* p_work;

	// m
	p_work = sys_AllocMemory( p_dodata->heap, sizeof(ZKN_RANGE_SUB_WORK) );
	GF_ASSERT( p_work );
	memset( p_work, 0, sizeof(ZKN_RANGE_SUB_WORK) );
	p_dodata->p_work = p_work;

	// CURSORftHʒuݒ
	ZknRangeSubCursorDefMatSet( p_work, p_glb );

	// {^쐬
	// CURSORftHʒuݒ̌̕Kv
	ZknRangeSubCursorInit( p_work, p_glb, p_dodata->heap );
	
	return ZKN_PROC_TRUE;
}


//----------------------------------------------------------------------------
/**
 *	[C]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknRangeSubProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_RANGE_SUB_GLB* p_glb = p_glbdata;
	ZKN_RANGE_SUB_WORK* p_work = p_dodata->p_work;

	// I
	if( p_dodata->end_req == TRUE ){
		return ZKN_PROC_TRUE;
	}

	// lock
	if( p_dodata->lock == TRUE ){
		return ZKN_PROC_FALSE;
	}

	// `FbN
	if( ZKN_ZukanCommonSubMoveFlagGet( p_glb->cp_zukan_common_apl ) ){
		// CURSOR
		ZknRangeSubCursorMain( p_work, p_glb );	
	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	[j]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknRangeSubProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_RANGE_SUB_GLB* p_glb = p_glbdata;
	ZKN_RANGE_SUB_WORK* p_work = p_dodata->p_work;


	// {^j
	ZknRangeSubCursorDelete( p_work );
	
	sys_FreeMemoryEz( p_work );
	
	
	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 * []
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknRangeSubProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_RANGE_SUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_RANGE_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_RANGE_SUB_DRAWGLB*	p_drawglb = p_glbdraw;
	ZKN_RANGE_SUB_DRAW*		p_drawwork = p_drawdata->p_work;
	
	switch( p_drawdata->seq ){
	case ZKN_RANGESUB_SEQINIT_ALLOC:
		p_drawdata->p_work = sys_AllocMemory( p_drawdata->heap, sizeof(ZKN_RANGE_SUB_DRAW) );
		memset( p_drawdata->p_work, 0, sizeof(ZKN_RANGE_SUB_DRAW) );

		p_drawdata->seq++;
		break;
		
	case ZKN_RANGESUB_SEQINIT_LOAD:
		// Resourceǂݍ
		ZknRangeSubLoadResource( p_drawwork, p_drawglb, p_drawdata->heap );
		// Wݒ
		ZknRangeSubCursorDraw( p_drawwork, cp_dataglb, cp_datawork );
		ZknRangeSubBgPlttDraw( p_drawwork, p_drawglb, cp_dataglb, p_drawdata->heap );

		// tF[h
		ZknRangeSubFadeInit( p_drawwork, p_drawglb, cp_dataglb, TRUE );
		
		p_drawdata->seq++;
		break;
		
	case ZKN_RANGESUB_SEQINIT_FADEIN:
		// AĵłƌĂ
		ZknRangeSubBgPlttDraw( p_drawwork, p_drawglb, cp_dataglb, p_drawdata->heap );


		if( ZknRangeSubFadeMain( p_drawwork, p_drawglb, cp_dataglb, TRUE ) ){
			p_drawdata->seq++;
		}
		break;
		
	case ZKN_RANGESUB_SEQINIT_END:
		// AĵłƌĂ
		ZknRangeSubBgPlttDraw( p_drawwork, p_drawglb, cp_dataglb, p_drawdata->heap );

		// J[\AjJn
		ZKN_UTIL_CursorSetAnimeStopFlag( &p_drawglb->p_drawglb->cursor, FALSE );
		return ZKN_PROC_TRUE;
		
	default:
		break;
	}
	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [C]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknRangeSubProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_RANGE_SUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_RANGE_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_RANGE_SUB_DRAWGLB*	p_drawglb = p_glbdraw;
	ZKN_RANGE_SUB_DRAW*		p_drawwork = p_drawdata->p_work;

	// CURSOR
	ZknRangeSubCursorDraw( p_drawwork, cp_dataglb, cp_datawork );

	// J[\MARK`
	ZknRangeSubCursorMoveKey_CorsorDrawSet( p_drawglb, cp_datawork, cp_dataglb );

	// pbgtF[h
	ZknRangeSubBgPlttDraw( p_drawwork, p_drawglb, cp_dataglb, p_drawdata->heap );

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [j]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknRangeSubProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_RANGE_SUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_RANGE_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_RANGE_SUB_DRAWGLB*	p_drawglb = p_glbdraw;
	ZKN_RANGE_SUB_DRAW*		p_drawwork = p_drawdata->p_work;
	
	switch( p_drawdata->seq ){
	case ZKN_RANGESUB_SEQDELETE_FADEOUT_INIT:

		// J[\Aj~
		ZKN_UTIL_CursorSetAnimeStopFlag( &p_drawglb->p_drawglb->cursor, TRUE );
		
		// tF[h
		ZknRangeSubFadeInit( p_drawwork, p_drawglb, cp_dataglb, FALSE );
		p_drawdata->seq++;
		break;
		
	case ZKN_RANGESUB_SEQDELETE_FADEOUT:
		if( ZknRangeSubFadeMain( p_drawwork, p_drawglb, cp_dataglb, FALSE ) ){
			p_drawdata->seq++;
		}
		break;

	case ZKN_RANGESUB_SEQDELETE_RELEASE:
		// Resourceǂݍ
		ZknRangeSubReleaseResource( p_drawwork, p_drawglb, p_drawdata->heap );
		p_drawdata->seq++;
		break;
		
	case ZKN_RANGESUB_SEQDELETE_FREE:

		sys_FreeMemoryEz( p_drawwork->pltt_buff );
		sys_FreeMemoryEz( p_drawdata->p_work );
		p_drawdata->seq++;
		break;
		
		
	case ZKN_RANGESUB_SEQDELETE_END:
		return ZKN_PROC_TRUE;
		
	default:
		break;
	}
	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMtF[h	
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubOamFadeInit( ZKN_RANGE_SUB_DRAW* p_draw )
{
	CLACT_ObjModeSet( p_draw->cursor, GX_OAM_MODE_XLU );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMtF[h@㏈
 *
 *	@param	p_draw 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubOamFadeDelete( ZKN_RANGE_SUB_DRAW* p_draw )
{
	CLACT_ObjModeSet( p_draw->cursor, GX_OAM_MODE_NORMAL );
}

//----------------------------------------------------------------------------
/**
 *	@brief	TuʃtF[h
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb		O[o
 *	@param	fadein_out	tF[hC@TRUE@AEg FALSE	
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubFadeInit( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, const ZKN_RANGE_SUB_GLB* cp_glb, BOOL fadein_out )
{
	// OAMݒ
	ZknRangeSubOamFadeInit( p_draw );

	// uCglXsĂ悢
	if( ZKN_ZukanCommonSubBrightnessOnFlagGet( cp_glb->cp_zukan_common_apl ) ){
		if( fadein_out ){
			// tF[hC
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade_sub, ZKN_FADE_SYNC_COMMON,
					BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 0, 16, ZKN_RANGESUB_FADE_PLANEMSK, ZKN_BRIGHTNESS_MSK_PLANE2DEF, ZKN_UTIL_FADE_SUB );
		}else{
			// tF[hAEg
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade_sub, ZKN_FADE_SYNC_COMMON,
					BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 16, 0, ZKN_RANGESUB_FADE_PLANEMSK, ZKN_BRIGHTNESS_MSK_PLANE2DEF, ZKN_UTIL_FADE_SUB );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[h@C
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb		O[o
 *	@param	fadein_out	tF[hC@TRUE@AEg@FALSE
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL ZknRangeSubFadeMain( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, const ZKN_RANGE_SUB_GLB* cp_glb, BOOL fadein_out )
{
	BOOL check;

	// uCglX悤łĂ邩`FbN
	if( ZKN_ZukanCommonSubBrightnessOnFlagGet( cp_glb->cp_zukan_common_apl ) ){
		check = ZKN_GLB_ChangeFadeMain( &p_drawglb->p_drawglb->fade_sub );
	}else{
//		check = ZKN_GLB_ChangeFadeEndCheck( &p_drawglb->p_drawglb->fade_sub );
		check = IsFinishedBrightnessChg( MASK_SUB_DISPLAY );
	}

	// II
	if( check ){
		if( fadein_out ){
			// OAMj
			ZknRangeSubOamFadeDelete( p_draw );
		}

		return TRUE;
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	OtBbN
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubLoadResource( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, int heap )
{
	// wi
	ZknRangeSubSetUpBg( p_drawglb, heap );

	// OAM
	ZknRangeSubLoadOamData( p_draw, p_drawglb, heap );

	// ZAN^[o^
	ZknRangeSubAddClact( p_draw, p_drawglb, heap );


}

//----------------------------------------------------------------------------
/**
 *	@brief	OtBbNj
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubReleaseResource( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, int heap )
{
	// ZAN^[j
	ZknRangeSubDeleteClact( p_draw );

	// OAM
	ZknRangeSubReleaseOamData( p_draw, p_drawglb );
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGʃZbgAbv
 *
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubSetUpBg( ZKN_RANGE_SUB_DRAWGLB* p_drawglb, int heap )
{
	void* buff;
	NNSG2dScreenData* p_scrn;

	// LN^f[^]
	ZKN_GLBDATA_BgCharSet( p_drawglb->p_drawglb, NARC_zukan_zkn_data_sub_lzh_NCGR, p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S, 0, 0, TRUE, heap );

	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_map_bg_sub_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S,
			p_scrn->rawData, 0, 0,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );

	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAM\[Xǂݍ
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubLoadOamData( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, int heap )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;
	ARCHANDLE* p_handle = ZKN_GLBDATA_ArcHandlGet( p_drawglb->p_drawglb );
	
	// LN^f[^ǂݍ
	p_draw->res_obj[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ], p_handle,
			NARC_zukan_zkn_data_oam_sub4_lzh_NCGR, TRUE,
			NARC_zukan_zkn_data_oam_sub4_lzh_NCGR + ZKN_RANGE_RES_ID,
			NNS_G2D_VRAM_TYPE_2DSUB, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_draw->res_obj[ CLACT_U_CHAR_RES ] );

	// Zf[^ǂݍ
	p_draw->res_obj[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ], p_handle,
			NARC_zukan_zkn_data_oam_sub4_lzh_NCER, TRUE,
			NARC_zukan_zkn_data_oam_sub4_lzh_NCER + ZKN_RANGE_RES_ID,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_draw->res_obj[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ], p_handle, 
			NARC_zukan_zkn_data_oam_sub4_lzh_NANR, TRUE,
			NARC_zukan_zkn_data_oam_sub4_lzh_NANR + ZKN_RANGE_RES_ID,
			CLACT_U_CELLANM_RES, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAM\[Xj
 *
 *	@param	p_draw			`惏[N
 *	@param	p_drawglb		`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubReleaseOamData( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;


	CLACT_U_CharManagerDelete( p_draw->res_obj[ CLACT_U_CHAR_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw->res_obj[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			p_draw->res_obj[ CLACT_U_CELLANM_RES ] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ZAN^[o^
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubAddClact( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, int heap )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	ZKN_GLB_DRAWDATA*	p_draw_glb = p_drawglb->p_drawglb;
	
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			NARC_zukan_zkn_data_oam_sub4_lzh_NCGR + ZKN_RANGE_RES_ID,
			NARC_zukan_zkn_data_oam_sub_NCLR + ZKN_ZUKAN_COMMON_SUB_RES_ID_OFS, 
			NARC_zukan_zkn_data_oam_sub4_lzh_NCER + ZKN_RANGE_RES_ID,
			NARC_zukan_zkn_data_oam_sub4_lzh_NANR + ZKN_RANGE_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, ZKN_RANGE_SUB_OAM_BG_PRI,
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^ʕݒ
	add.ClActSet	= p_draw_glb->clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= ZKN_RANGE_SUB_OAM_SOFT_PRI;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
	add.heap		= heap;
	
	// CURSOR
	add.mat.x = 0;
	add.mat.y = 0;
	add.mat.y += SUB_SURFACE_Y;
	p_draw->cursor = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_draw->cursor, ZKN_RANGE_SUB_CURSOR_SEQ );	

}

//----------------------------------------------------------------------------
/**
 *	@brief	ZAN^[j
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubDeleteClact( ZKN_RANGE_SUB_DRAW* p_draw )
{
	CLACT_Delete( p_draw->cursor );
}

//----------------------------------------------------------------------------
/**
 *	@brief	CURSORp{^}l[W쐬
 *
 *	@param	p_work		[N
 *	@param	p_glb		O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubCursorInit( ZKN_RANGE_SUB_WORK* p_work, ZKN_RANGE_SUB_GLB* p_glb, int heap )
{
	// e[u쐬
	p_work->hit_tbl = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_RANGESUB_BUTTON_NUM );

	// e[uf[^ݒ
	p_work->hit_tbl[ 0 ].circle.code = TP_USE_CIRCLE;
	p_work->hit_tbl[ 0 ].circle.x	 = p_work->x;
	p_work->hit_tbl[ 0 ].circle.y	 = p_work->y;
	p_work->hit_tbl[ 0 ].circle.r	 = ZKN_RANGE_SUB_CURSOR_SIZE_R;

	p_work->button_work.p_glb = p_glb;
	p_work->button_work.p_work = p_work;

	// {^}l[W쐬
	p_work->p_button_man = BMN_Create( 
			p_work->hit_tbl,
			ZKN_RANGESUB_BUTTON_NUM,
			ZknRangeSubButtonCallBack,
			&p_work->button_work,
			heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	CURSOR상C֐
 *
 *	@param	p_work		[N
 *	@param	p_glb		O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubCursorMain( ZKN_RANGE_SUB_WORK* p_work, ZKN_RANGE_SUB_GLB* p_glb )
{
	
	// {^͈͓ɓ
	BMN_Main( p_work->p_button_man );

	ZknRangeSubCursorMove( p_work, p_glb );

	// 蔻̈ɐݒ
	p_work->hit_tbl[ 0 ].circle.x = p_work->x;
	p_work->hit_tbl[ 0 ].circle.y = p_work->y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	L[͓
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[o[N
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubCursorMoveKey( ZKN_RANGE_SUB_WORK* p_work, ZKN_RANGE_SUB_GLB* p_glb )
{
	s32 type;

	if( sys.tp_cont ){
		return ;
	}
	
	if( ZKN_ZukanCommonSubCursorFlagGet( p_glb->cp_zukan_common_apl ) == TRUE ){
		type = ZKN_RangeTypeGet( p_glb->p_range_apl );
		if( sys.trg & PAD_KEY_LEFT ){
			type --;
			if( type < 0 ){
				type = 0;
			}
			// ̍Ŵ
			ZKN_RangeTypeSet( p_glb->p_range_apl, type );

			// ̎Ԃ̍WJ[\ɐݒ
			ZknRangeSubCursorDefMatSet( p_work, p_glb );
			p_work->key_set = TRUE;
			
		}else if( sys.trg & PAD_KEY_RIGHT ){

			type ++;
			if( type >= ZKN_RANGE_TYPE_NUM ){
				type = ZKN_RANGE_TYPE_NUM - 1;
			}
			// ̍Ŵ
			ZKN_RangeTypeSet( p_glb->p_range_apl, type );
			// ̎Ԃ̍WJ[\ɐݒ
			ZknRangeSubCursorDefMatSet( p_work, p_glb );
			p_work->key_set = TRUE;
		}
	
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	CURSOR
 *
 *	@param	p_work	[Nf[^
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubCursorMove( ZKN_RANGE_SUB_WORK* p_work, ZKN_RANGE_SUB_GLB* p_glb )
{
	int type;
	int y_max_dis;
	
	p_work->key_set = FALSE;
	
	if( p_work->touch ){

		// ^b`Ă炻̍Wۑ
		// ̍Wʒu̎Ԃݒb
		if( sys.tp_cont ){
			p_work->x = sys.tp_x - p_work->ofs_x;
			p_work->y = sys.tp_y - p_work->ofs_y;

			if( p_work->x < ZKN_RANGE_SUB_CURSOR_LIMIT_X ){
				p_work->x = ZKN_RANGE_SUB_CURSOR_LIMIT_X;
			}
			if( p_work->x > ZKN_RANGE_SUB_CURSOR_LIMIT_X_MAX ){
				p_work->x = ZKN_RANGE_SUB_CURSOR_LIMIT_X_MAX;
			}

			if( p_work->y < ZKN_RANGE_SUB_CURSOR_LIMIT_Y ){
				p_work->y = ZKN_RANGE_SUB_CURSOR_LIMIT_Y;
			}

			// Yől߂
			y_max_dis = ZknRangeSubCursorMoveMaxDisGet( p_work->x );
			if( p_work->y > (ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX + y_max_dis) ){
				p_work->y = (ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX + y_max_dis);
			}


			type = p_work->x / ZKN_RANGE_SUB_TIME_LIMIT;

			if( type > ZKN_RANGE_TYPE_NIGHT ){
				type = ZKN_RANGE_TYPE_NIGHT;
			}
			
			// ̍Ŵ
			ZKN_RangeTypeSet( p_glb->p_range_apl, type );
		}else{
			p_work->touch = 0;
		}
	}else{
		ZknRangeSubCursorMoveKey( p_work, p_glb );
	}
}

//----------------------------------------------------------------------------
/**	
 *	@brief	}Ӄ{^R[΂֐
 *
 *	@param	button_no	{^io[
 *	@param	event		Cxgio[
 *	@param	p_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubButtonCallBack( u32 button_no, u32 event, void* p_work )
{
	ZKN_RANGE_SUB_CALLBACK_WORK* p_work_data = p_work;
	ZKN_RANGE_SUB_GLB* p_glb = p_work_data->p_glb;
	ZKN_RANGE_SUB_WORK* p_subwork = p_work_data->p_work;

	switch( event ){
	case BMN_EVENT_TOUCH:
		// {^Ƀ^b`
		Snd_SePlay( ZKN_SND_BUTTON );
		p_subwork->touch = 1;	// ^b`

		// S̍W擾
		p_subwork->ofs_x = sys.tp_x - p_subwork->x;
		p_subwork->ofs_y = sys.tp_y - p_subwork->y;
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	CURSORf[^j
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubCursorDelete( ZKN_RANGE_SUB_WORK* p_work )
{
	BMN_Delete( p_work->p_button_man );

	// e[u[Nj
	sys_FreeMemoryEz( p_work->hit_tbl );
	p_work->hit_tbl = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	CURSOR`搧
 *
 *	@param	p_draw		`惏[N
 *	@param	cp_glb		O[of[^
 *	@param	cp_work		f[^[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubCursorDraw( ZKN_RANGE_SUB_DRAW* p_draw, const ZKN_RANGE_SUB_GLB* cp_glb, const ZKN_RANGE_SUB_WORK* cp_work )
{
	VecFx32 mat;
	
	// CURSORWݒ
	mat.x = cp_work->x << FX32_SHIFT;
	mat.y = cp_work->y << FX32_SHIFT;
	mat.y += SUB_SURFACE_Y;

	CLACT_SetMatrix( p_draw->cursor, &mat );

	// ԂɂĊGύX
	CLACT_AnmChg( p_draw->cursor, ZKN_RangeTypeGet( cp_glb->p_range_apl ) );
}

// BGpbg
//----------------------------------------------------------------------------
/**
 *	@brief	BGpbg
 *
 *	@param	p_draw	`惏[N
 *	@param	cp_glb	O[of[^
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubBgPlttDraw( ZKN_RANGE_SUB_DRAW* p_draw, ZKN_RANGE_SUB_DRAWGLB* p_drawglb, const ZKN_RANGE_SUB_GLB* cp_glb, int heap )
{
	int pltt_no;
	int pltt_anm = 0;
	BOOL check;
	
	// pbg^Cvio[
	pltt_no = ZKN_RangeTypeGet( cp_glb->p_range_apl );

	// pbgio[Ⴄobt@NULL̂Ƃݒ
	if( (p_draw->pltt_no != pltt_no) || ( p_draw->pltt_buff == NULL ) ||
		(p_draw->next_pltt_no != p_draw->pltt_no) ){

		// ݒ蒆̃pbgio[Ⴄ̂ɂȂĂ܂
		// Đݒ
		if( p_draw->next_pltt_no != pltt_no ){
			p_draw->pltt_no = p_draw->next_pltt_no;
			p_draw->pltt_anm_seq = 0;
		}
		
		// pbgAj
		switch( p_draw->pltt_anm_seq ){
		case ZKN_RANGESUB_PLTTANM_SEQ_NOW_PLTT_0:
			// ̃pbgio[ݒ
			p_draw->next_pltt_no = pltt_no;
			
			// ܂ł̂j
			if( p_draw->pltt_buff ){
				sys_FreeMemoryEz( p_draw->pltt_buff );
			}
			// pbgǂݍ
			p_draw->pltt_buff = ZKN_GLBDATA_PalDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_map_00_NCLR + p_draw->pltt_no, &p_draw->p_plt, heap );
			p_draw->pltt_anm_count = ZKN_RANGE_SUB_PLTT_ANM_WAIT;

			// pbgAjZbg
			if( p_draw->pltt_no > pltt_no ){
				pltt_anm = 1;	// [@[
			}else{
				pltt_anm = 2;	// [@[
			}
			p_draw->pltt_anm_seq ++;
			break;

/*		case ZKN_RANGESUB_PLTTANM_SEQ_NOW_PLTT_0WAIT:
			p_draw->pltt_anm_count--;
			if( p_draw->pltt_anm_count <= 0 ){
				p_draw->pltt_anm_seq ++;
			}
			return ;//*/

		case ZKN_RANGESUB_PLTTANM_SEQ_NEXT_PLTT_0:
			// ܂ł̂j
			if( p_draw->pltt_buff ){
				sys_FreeMemoryEz( p_draw->pltt_buff );
			}
			// pbgǂݍ
			p_draw->pltt_buff = ZKN_GLBDATA_PalDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_map_00_NCLR + p_draw->next_pltt_no, &p_draw->p_plt, heap );
			p_draw->pltt_anm_count = ZKN_RANGE_SUB_PLTT_ANM_WAIT;

			// pbgAjZbg
			if( p_draw->pltt_no < p_draw->next_pltt_no ){
				pltt_anm = 1;	// [@[
			}else{
				pltt_anm = 2;	// [@[
			}
			p_draw->pltt_anm_seq ++;
			break;

/*		case ZKN_RANGESUB_PLTTANM_SEQ_NEXT_PLTT_0WAIT:
			p_draw->pltt_anm_count--;
			if( p_draw->pltt_anm_count <= 0 ){
				p_draw->pltt_anm_seq ++;
			}
			return ;//*/
			
		case ZKN_RANGESUB_PLTTANM_SEQ_NEXT_PLTT_1:
			pltt_anm = 0;		// ʏ
			p_draw->pltt_anm_seq = 0;
			p_draw->pltt_no = p_draw->next_pltt_no;
			break;

		}

		// TransferManagerɓo^
		check = AddVramTransferManager(
				NNS_GFD_DST_2D_BG_PLTT_SUB,
				ZKN_RANGE_SUB_PLTT_NO*32,
				&((u8*)(p_draw->p_plt->pRawData))[(pltt_anm*32)],
				32 );
		// ]^XNs
		GF_ASSERT( check );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	CURSORftHgʒuݒ
 *
 *	@param	p_work	샏[N
 *	@param	p_glb	O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubCursorDefMatSet( ZKN_RANGE_SUB_WORK* p_work, ZKN_RANGE_SUB_GLB* p_glb )
{
	int type = ZKN_RangeTypeGet( p_glb->p_range_apl );
	
	// ŏ̃J[\ʒuݒ
	switch( type ){
	case ZKN_RANGE_TYPE_MORNING:	// 
		p_work->x = ZKN_RANGE_SUB_CURSOR_MORNING_X;
		p_work->y = ZKN_RANGE_SUB_CURSOR_MORNING_Y;
		break;
		
	case ZKN_RANGE_TYPE_NOON:	// 
		p_work->x = ZKN_RANGE_SUB_CURSOR_NOON_X;
		p_work->y = ZKN_RANGE_SUB_CURSOR_NOON_Y;
		break;
		
	case ZKN_RANGE_TYPE_NIGHT:	// 
		p_work->x = ZKN_RANGE_SUB_CURSOR_NIGHT_X;
		p_work->y = ZKN_RANGE_SUB_CURSOR_NIGHT_Y;
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	YɈړőlXWɂϓl߂
 *
 *	@param	x 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static int ZknRangeSubCursorMoveMaxDisGet( int x )
{
	int rota_num;
	int ret_num;
	
	// ő͌̕vZȂĂ킩
	if( (x < ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_SUB_X) ||
		( (256 - ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_SUB_X) < x ) ){

		return ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_DIS;
	}
	
	// Ă邱Ƃ͂W獡̍WsinJ[u]p
	// 擾āA̒lYW~bgύXl
	// 炢炷ƍ̃~bgύXlɂȂ邩߂Ă
	x -= ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_SUB_X;

	rota_num = FX_GET_ROTA_NUM( 180 ) * x;
	rota_num = rota_num / ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_SUB_X_CALC_DIS;
	// ̃~bgŴ猸炷l߂
	ret_num = FX_Mul( FX_SinIdx( (u16)rota_num ), ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_DIS << FX32_SHIFT );
	ret_num >>= FX32_SHIFT;

	// 
	ret_num = ZKN_RANGE_SUB_CURSOR_LIMIT_Y_MAX_DIS - ret_num;

	return ret_num;
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\@Wݒ
 *
 *	@param	p_drawglb
 *	@param	p_drawwork
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknRangeSubCursorMoveKey_CorsorDrawSet( ZKN_RANGE_SUB_DRAWGLB* p_drawglb, const ZKN_RANGE_SUB_WORK* cp_work, const ZKN_RANGE_SUB_GLB* cp_glb )
{
	ZKN_GLB_DRAWDATA* p_draw = p_drawglb->p_drawglb;

	// ̍Wݒ肵Ă悢`FbN
	if( ZKN_ZukanCommonSubCursorFlagGet( cp_glb->cp_zukan_common_apl ) == TRUE ){

		if( cp_work->key_set == FALSE ){
			ZKN_UTIL_CursorSetMatrix( p_draw, 
					cp_work->x, cp_work->y,
					ZKN_RANGE_SUB_CURSOR_MARK_SIZE_X, 
					ZKN_RANGE_SUB_CURSOR_MARK_SIZE_Y);
		}else{
			ZKN_UTIL_CursorSetMatrixNotAnm(  p_draw, 
					cp_work->x, cp_work->y,
					ZKN_RANGE_SUB_CURSOR_MARK_SIZE_X, 
					ZKN_RANGE_SUB_CURSOR_MARK_SIZE_Y );
		}
	}
}

