//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_sortsearch_sub.c
 *	@brief		\[gTuʃTu		ʕ
 *	@author		tomoya takahashi 
 *	@data		2006.01.21
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>
#include "include/application/zukanlist/zkn_event_func.h"

#include "include/system/brightness.h"
#include "include/system/arc_tool.dat"
#include "include/system/arc_util.h"
#include "include/system/clact_util.h"
#include "include/application/zukanlist/zukan.naix"
#include "include/gflib/button_man.h"
#include "include/gflib/calctool.h"
#include "include/system/msgdata_util.h"
#include "include/msgdata/msg.naix"
#include "include/msgdata/msg_zkn.h"
#include "include/application/zukanlist/zkn_snd_def.h"

#include "include/application/zukanlist/zukan.naix"
#include "include/application/zukanlist/zkn_sortsearch.h"

#define	__ZKN_SORTSEARCHSUB_SUB_H_GLOBAL
#include "include/application/zukanlist/zkn_sortsearch_sub.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define ZKN_SORTSEARCHSUB_EVENT_NUM ( 0 )	// Cxg


//-------------------------------------
//	V[PX
//=====================================
enum{
	ZKN_SORTSEARCHSUB_SEQINIT_ALLOC,
	ZKN_SORTSEARCHSUB_SEQINIT_LOAD,
	ZKN_SORTSEARCHSUB_SEQINIT_FADEIN,
	ZKN_SORTSEARCHSUB_SEQINIT_END,
};
enum{
	ZKN_SORTSEARCHSUB_SEQDELETE_FADEOUT_INIT,
	ZKN_SORTSEARCHSUB_SEQDELETE_FADEOUT,
	ZKN_SORTSEARCHSUB_SEQDELETE_RELEASE,
	ZKN_SORTSEARCHSUB_SEQDELETE_FREE,
	ZKN_SORTSEARCHSUB_SEQDELETE_END,
};


//AjV[PX
enum{
	ZKN_SORTSEARCHSUB_MAIN_BUTTON,
	ZKN_SORTSEARCHSUB_ACTION_BUTTON,
	ZKN_SORTSEARCHSUB_SELECT_BUTTON,
	ZKN_SORTSEARCHSUB_RET_BUTTON,
	ZKN_SORTSEARCHSUB_PAGE_SUB_BUTTON,
	ZKN_SORTSEARCHSUB_PAGE_ADD_BUTTON,
	ZKN_SORTSEARCHSUB_FORM_BUTTON,
};
enum{
	// FORM
	ZKN_SORTSEARCHSUB_CIRCLE_BUTTON,
	ZKN_SORTSEARCHSUB_ARM_BUTTON,
	ZKN_SORTSEARCHSUB_LEGS_BUTTON,
	ZKN_SORTSEARCHSUB_MANY_LEGS_BUTTON,
	ZKN_SORTSEARCHSUB_FOURWING_BUTTON,
	ZKN_SORTSEARCHSUB_HARABAI_BUTTON,
	ZKN_SORTSEARCHSUB_STRAIGHT_BUTTON,
	ZKN_SORTSEARCHSUB_HAITSUKUBARI_BUTTON,
	ZKN_SORTSEARCHSUB_COMP_BUTTON,
	ZKN_SORTSEARCHSUB_FOURLEGS_BUTTON,
	ZKN_SORTSEARCHSUB_WATER_BUTTON,
	ZKN_SORTSEARCHSUB_TAIL_BUTTON,
	ZKN_SORTSEARCHSUB_TWO_WING_BUTTON,
	ZKN_SORTSEARCHSUB_TWO_LEGS_BUTTON,
	ZKN_SORTSEARCHSUB_FORM_NONE,
};

// tȌ
#define ZKN_SORTSEARCHSUB_DO_FLAG_INIT ( 0xffff )

//-----------------------------------------------------------------------------
/**
 *		{^J[\ްʕ
 */
//-----------------------------------------------------------------------------
// ʈȊÕ{^̍ő吔
#define ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX	( 15 )


// c̐
#define ZKN_SORTSEARCHSUB_BUTTON_Y_NUM		( 6 )


// YWʒu
#define ZKN_SORTSEARCHSUB_BUTTON_00_Y		( 16 )	
#define ZKN_SORTSEARCHSUB_BUTTON_01_Y		( 48 )	
#define ZKN_SORTSEARCHSUB_BUTTON_02_Y		( 80 )
#define ZKN_SORTSEARCHSUB_BUTTON_03_Y		( 112 )	
#define ZKN_SORTSEARCHSUB_BUTTON_04_Y		( 144 )
#define ZKN_SORTSEARCHSUB_BUTTON_05_Y		( 176 )

// Ȃс@Ȃ܂@ՋXW
#define ZKN_SORTSEARCHSUB_BUTTONDEF_00_X	( 48 )
#define ZKN_SORTSEARCHSUB_BUTTONDEF_01_X	( 128 )


// ӂOAM̕OFSET
#define ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_2_X		( -12 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_3_X		( -18 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_4_X		( -24 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_5_X		( -30 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_6_X		( -36 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y		( -6 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_PLTOFS	( 3 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_KETTEI_PLTOFS	( 1 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_PUSHPLTOFS	( 5 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_OTHER_PLTOFS	( 0xB )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_OTHER_PUSHPLTOFS	( 6 )

// J[\Y
#define ZKN_SORTSEARCHSUB_CURSOR_MAX_Y	( ZKN_SORTSEARCHSUB_BUTTON_Y_NUM )

// sƊ{{^̃TCY
#define ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX	( 80 )
#define ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZY	( 32 )
#define ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX	( 60 )
#define ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY	( 16 )

// 12̃y[W؂ւ{^TCY
#define ZKN_SORTSEARCHSUB_BUTTON_PAGE_SIZX	( 32 )
#define ZKN_SORTSEARCHSUB_BUTTON_PAGE_SIZY	( 32 )
#define ZKN_SORTSEARCHSUB_CURSOR_PAGE_SIZX	( 16 )
#define ZKN_SORTSEARCHSUB_CURSOR_PAGE_SIZY	( 16 )


//-------------------------------------
//	J[\ID	J[\ID͂ԂȂ悤ɂ
//=====================================
enum{
	ZKN_SORTSEARCHSUB_CURSOR_ID_BACK,
	ZKN_SORTSEARCHSUB_CURSOR_ID_NARABI,
	ZKN_SORTSEARCHSUB_CURSOR_ID_NAME,
	ZKN_SORTSEARCHSUB_CURSOR_ID_TYPE,
	ZKN_SORTSEARCHSUB_CURSOR_ID_FORM,
	ZKN_SORTSEARCHSUB_CURSOR_ID_ACTION,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_00,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_01,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_02,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_03,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_04,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_05,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_06,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_07,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_08,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_09,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_10,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_11,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_12,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_13,
	ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_14,
	ZKN_SORTSEARCHSUB_SURSOR_ID_NUM,
};

// J[\̖ƂɓID
#define ZKN_SORTSEARCHSUB_CURSOR_ID_NONE	( 0xff )

//-----------------------------------------------------------------------------
/**
 *		ʕ{^J[\ް
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	TuR{^
//=====================================
enum{
	ZKN_SORTSEARCHSUB_BUTTON_BACK,
	ZKN_SORTSEARCHSUB_BUTTON_NARABI,
	ZKN_SORTSEARCHSUB_BUTTON_NAME,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE,
	ZKN_SORTSEARCHSUB_BUTTON_FORM,
	ZKN_SORTSEARCHSUB_BUTTON_ACTION,
	ZKN_SORTSEARCHSUB_BUTTON_NUM,
};
#define ZKN_SORTSEARCHSUB_BUTTON_SIZX		( 64 )
#define ZKN_SORTSEARCHSUB_BUTTON_SIZY		( 32 )
#define ZKN_SORTSEARCHSUB_BUTTON_BACK_SIZX		( 48 )
#define ZKN_SORTSEARCHSUB_BUTTON_BACK_SIZY		( 32 )
#define ZKN_SORTSEARCHSUB_BUTTON_X			( 224 )
#define ZKN_SORTSEARCHSUB_BUTTON_ACTION_X	( 212 )
#define ZKN_SORTSEARCHSUB_BUTTON_BACK_X		( 212 )
#define ZKN_SORTSEARCHSUB_BUTTON_BACK_Y		( ZKN_SORTSEARCHSUB_BUTTON_00_Y )	
#define ZKN_SORTSEARCHSUB_BUTTON_NARABI_Y	( ZKN_SORTSEARCHSUB_BUTTON_01_Y )	
#define ZKN_SORTSEARCHSUB_BUTTON_NAME_Y		( ZKN_SORTSEARCHSUB_BUTTON_02_Y )
#define ZKN_SORTSEARCHSUB_BUTTON_TYPE_Y		( ZKN_SORTSEARCHSUB_BUTTON_03_Y )	
#define ZKN_SORTSEARCHSUB_BUTTON_FORM_Y		( ZKN_SORTSEARCHSUB_BUTTON_04_Y )
#define ZKN_SORTSEARCHSUB_BUTTON_ACTION_Y	(ZKN_SORTSEARCHSUB_BUTTON_05_Y  )

// FONTOAM
#define ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CX	( 8 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CY	( 2 )

// J[\
#define ZKN_SORTSEARCHSUB_CURSOR_SIZX		( 44 )
#define ZKN_SORTSEARCHSUB_CURSOR_SIZY		( 16 )
#define ZKN_SORTSEARCHSUB_CURSOR_BACK_SIZX	( 28 )
#define ZKN_SORTSEARCHSUB_CURSOR_BACK_SIZY	( 16 )



//-----------------------------------------------------------------------------
/**
 *		Ȃщʃ{^zuް
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	Tu{^
//=====================================
enum{
	ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUMBER,
	ZKN_SORTSEARCHSUB_BUTTON_NARABI_AIUEO,
	ZKN_SORTSEARCHSUB_BUTTON_NARABI_HEAVY,
	ZKN_SORTSEARCHSUB_BUTTON_NARABI_LIGHT,
	ZKN_SORTSEARCHSUB_BUTTON_NARABI_TALL,
	ZKN_SORTSEARCHSUB_BUTTON_NARABI_SHORT,
	ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUM,
};

// FONTOAM
#define ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_NARABI_SIZE_CX	( 10 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_NARABI_SIZE_CY	( 2 )

// J[\
#define ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X	( 3 )

//-----------------------------------------------------------------------------
/**
 *		Ȃ܂ʃ{^zuް
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	Tu{^
//=====================================
enum{
	ZKN_SORTSEARCHSUB_BUTTON_NAME_A,
	ZKN_SORTSEARCHSUB_BUTTON_NAME_HA,
	ZKN_SORTSEARCHSUB_BUTTON_NAME_KA,
	ZKN_SORTSEARCHSUB_BUTTON_NAME_MA,
	ZKN_SORTSEARCHSUB_BUTTON_NAME_SA,
	ZKN_SORTSEARCHSUB_BUTTON_NAME_RA,
	ZKN_SORTSEARCHSUB_BUTTON_NAME_TA,
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/11/09
// ؍̃\[gɑΉ
#if PM_LANG != LANG_KOREA
	ZKN_SORTSEARCHSUB_BUTTON_NAME_YAWA,
	ZKN_SORTSEARCHSUB_BUTTON_NAME_NA,
#endif
// ----------------------------------------------------------------------------
	ZKN_SORTSEARCHSUB_BUTTON_NAME_NONE,
	ZKN_SORTSEARCHSUB_BUTTON_NAME_NUM,
};

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/18
// \[g܏\At@xbg

#define ZKN_SORTSEARCHSUB_BUTTON_NAME_ABC	ZKN_SORTSEARCHSUB_BUTTON_NAME_A
#define ZKN_SORTSEARCHSUB_BUTTON_NAME_DEF	ZKN_SORTSEARCHSUB_BUTTON_NAME_HA
#define ZKN_SORTSEARCHSUB_BUTTON_NAME_GHI	ZKN_SORTSEARCHSUB_BUTTON_NAME_KA
#define ZKN_SORTSEARCHSUB_BUTTON_NAME_JKL	ZKN_SORTSEARCHSUB_BUTTON_NAME_MA
#define ZKN_SORTSEARCHSUB_BUTTON_NAME_MNO	ZKN_SORTSEARCHSUB_BUTTON_NAME_SA
#define ZKN_SORTSEARCHSUB_BUTTON_NAME_PQR	ZKN_SORTSEARCHSUB_BUTTON_NAME_RA
#define ZKN_SORTSEARCHSUB_BUTTON_NAME_STU	ZKN_SORTSEARCHSUB_BUTTON_NAME_TA
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/11/09
// ؍̃\[gɑΉ
#if PM_LANG != LANG_KOREA
#define ZKN_SORTSEARCHSUB_BUTTON_NAME_VWX	ZKN_SORTSEARCHSUB_BUTTON_NAME_YAWA
#define ZKN_SORTSEARCHSUB_BUTTON_NAME_YZ	ZKN_SORTSEARCHSUB_BUTTON_NAME_NA
#endif
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------

// FONTOAM
#define ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_NAME_SIZE_CX	( 10 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_NAME_SIZE_CY	( 2 )

// J[\
#define ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X	( 3 )


//-----------------------------------------------------------------------------
/**
 *		1ʃ{^zuް
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	Tu{^
//=====================================
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/19
// ^Cv̕я܏\]̏
enum{
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NORMAL,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_BATTLE,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HIKOR,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_DOKU,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_JIMEN,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_IWA,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_MUSHI,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_GHOST,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HAGANE,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NONE,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NUM,
};
// ----------------------------------------------------------------------------

// FONTOAM
#define ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_TYPE1_SIZE_CX	( 10 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_TYPE1_SIZE_CY	( 2 )

// ւ̃{^ʒu
#define ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2_X	( ZKN_SORTSEARCHSUB_BUTTONDEF_00_X - 24 )

// J[\
#define ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X	( 3 )

//-----------------------------------------------------------------------------
/**
 *		2ʃ{^zuް
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	Tu{^
//=====================================
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/12/19
// ^Cv̕я܏\]̏
enum{
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_FIRE,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_WATER,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KUSA,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_ELEC,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_SP,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KOORI,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_DRAGON,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_AKU,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NONE,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1,
	ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NUM,
};
// ----------------------------------------------------------------------------
// FONTOAM
#define ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_TYPE2_SIZE_CX	( 10 )
#define ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_TYPE2_SIZE_CY	( 2 )

// ւ̃{^ʒu
#define ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1_X	( ZKN_SORTSEARCHSUB_BUTTONDEF_00_X - 24 )

// J[\
#define ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X	( 3 )


//-----------------------------------------------------------------------------
/**
 *		`ʃ{^zuް
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	Tu{^
//=====================================
enum{
	ZKN_SORTSEARCHSUB_BUTTON_FORM_CIRCLE,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_HARABAI,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_WATER,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_ARM,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_STRAIGHT,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_TAIL,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_LEGS,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_LEGS,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_WING,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_MANY_LEGS,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_COMP,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_LEGS,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_WING,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_HAITSUKUBARI,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_NONE,
	ZKN_SORTSEARCHSUB_BUTTON_FORM_NUM,
};

#define ZKN_SORTSEARCHSUB_BUTTON_FORM_SIZX		( 48 )
#define ZKN_SORTSEARCHSUB_BUTTON_FORM_SIZY		( 32 )

#define ZKN_SORTSEARCHSUB_BUTTON_FORM_DEF_X			( 28 )
#define ZKN_SORTSEARCHSUB_BUTTON_FORM_OFS_X			( 56 )

// J[\
#define ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X	( 4 )
#define ZKN_SORTSEARCHSUB_CURSOR_FORM_SIZX		( 32 )
#define ZKN_SORTSEARCHSUB_CURSOR_FORM_SIZY		( 20 )

// {^tF[h
enum{
	ZKN_SORTSEARCH_SUB_BUTTON_FADE_NONE,
	ZKN_SORTSEARCH_SUB_BUTTON_FADE_IN,
	ZKN_SORTSEARCH_SUB_BUTTON_FADE_OUT,
};
#define ZKN_SORTSEARCHSUB_BUTTON_FADE_SYNC	(2)

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	\[gʁ@O[oϐ
//=====================================
typedef struct {
	int*				p_event_key;		// CxgL[
	ZKN_GLB_DATA*		p_glb;				// O[of[^
	ZKN_APL_DATA*		p_main_apl;			// CʃAvf[^

	// ̃AvP[Vް
	ZKN_APL_DATA*		p_my_apl;			// `Ƃ̘AgKv邽
} ZKN_SORTSEARCHSUB_GLB;

//-------------------------------------
//	\[gʁ@`O[oϐ
//=====================================
typedef struct {
	ZKN_GLB_DRAWDATA*	p_drawglb;			// `O[of[^

	// {^tF[hp
	int button_fade_req;
	BOOL* button_fade;
} ZKN_SORTSEARCHSUB_DRAWGLB;

//-------------------------------------
//	{^p[N
//=====================================
typedef struct {
	void* p_glb;
	void* p_work;
} ZKN_SORTSEARCHSUB_BUTTON_WORK;

//-------------------------------------
//	\[gʁ@[N
//=====================================
typedef struct {
	// {^}l[W
	BUTTON_MAN* p_button_man;
	TP_HIT_TBL *hit_tbl;	// {^f[^
	// Tu{^}l[W
	BUTTON_MAN* p_button_man_sub;
	TP_HIT_TBL *hit_tbl_sub;	// {^f[^
	ZKN_SORTSEARCHSUB_BUTTON_WORK button_work;


	// J[\VXe
	ZKN_CURSOR* p_cursor;
	ZKN_CURSOR_ONEDATA* p_cursor_tbl;


	int type_page;			// ߃y[W

	// [N[J̑I
	int local_select;	
	int local_type_page;			// f`FbNp߃y[W

	// {^ް
	int button_event[ ZKN_SORTSEARCHSUB_BUTTON_NUM ];	// {^Cxgf[^
	int button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX ];	// {^Cxgf[^

	// sް
	int do_flag_common;		// sް	ꂽ{^ްi[
	int do_flag_select;		// sްꂽ{^ްi[

	int type_set_no;		// ݒ肷ް

	BOOL cursor_no_touch;
	BOOL tp_no_touch;
	

	int req_count;	// ςȂ̂QڂTRUE

	// {^tF[h҂tO
	BOOL button_fade_flag;
} ZKN_SORTSEARCHSUB_WORK;

//-------------------------------------
//	\[gʁ@`惏[N
//=====================================
typedef struct {
	CLACT_WORK_PTR clact[ ZKN_SORTSEARCHSUB_BUTTON_NUM ];
	ZKN_FONTOAM_DATA* p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_NUM ];

	CLACT_WORK_PTR clact_sub[ ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX ];
	ZKN_FONTOAM_DATA* p_fontoam_sub[ ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX ];
	CLACT_WORK_PTR clact_sub_form[ ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX ];

	CLACT_U_RES_OBJ_PTR res_obj[ ZKN_CLACT_RES_OBJ_NUM_DEF ];	// ResourceIuWF|C^
	CLACT_U_RES_OBJ_PTR res_obj_form[ ZKN_CLACT_RES_OBJ_NUM_DEF ];	// ResourceIuWF|C^

	// [N[J̑I
	int local_select;	
	int local_type_page;			// ߃y[W


	// {^tF[h
	ZKN_UTIL_MOVE_WORK fade_work;
	int do_fade;
	int do_fade_seq;
	BOOL* end_flag;
} ZKN_SORTSEARCHSUB_DRAW;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		AvP[Vf[^쐬֌W
 */
//-----------------------------------------------------------------------------
static ZKN_SORTSEARCHSUB_GLB* MakeSortSearchSubGlb( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_SORTSEARCHSUB_DRAWGLB* MakeSortSearchSubDrawGlb( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_EVENT_DATA* MakeSortSearchSubEvent( int heap, ZKN_SYS_PTR zkn_sys );
static void DeleteSortSearchSubGlb( ZKN_SORTSEARCHSUB_GLB* p_glb );
static void DeleteSortSearchSubDrawGlb( ZKN_SORTSEARCHSUB_DRAWGLB* p_glb );
static void DeleteSortSearchSubEvent( ZKN_EVENT_DATA* p_event );


static int SortSearchSubEventDataNumGet( void );

//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
static int ZknSortSearchSubProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknSortSearchSubProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknSortSearchSubProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknSortSearchSubProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknSortSearchSubProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknSortSearchSubProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );


// tF[h
static void ZknSortSearchSubSortFadeSys( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_GLB* cp_glb );

// Resourceǂݍ
static void ZknSortSearchSubLoadRes( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_GLB* cp_glb, const ZKN_SORTSEARCHSUB_WORK* cp_datawork, int heap );
static void ZknSortSearchSubDeleteRes( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb );
static void ZknSortSearchSubSetUpBg( ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_GLB* cp_glb, int heap );
static void ZknSortSearchSubLoadOam( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap );
static void ZknSortSearchSubReleaseOam( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb );
static void ZknSortSearchSubLoadOamForm( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap );
static void ZknSortSearchSubReleaseOamForm( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb );


// {^tF[h
static void ZknSortSearchSubButtonFadeCont( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb );
static void ZknSortSearchSubButtonFade( ZKN_SORTSEARCHSUB_DRAW* p_draw );
static void ZknSortSearchSubButtonFadeOamModeSet_Pack( ZKN_SORTSEARCHSUB_DRAW* p_draw, int mode, int select_type, int type_page );
static void ZknSortSearchSubButtonFadeOamModeSet( ZKN_SORTSEARCHSUB_DRAW* p_draw, int mode );
static void ZknSortSearchSubButtonFadeOamModeSet_Type1Ver( ZKN_SORTSEARCHSUB_DRAW* p_draw, int mode );
static void ZknSortSearchSubButtonFadeOamModeSet_Type2Ver( ZKN_SORTSEARCHSUB_DRAW* p_draw, int mode );

//-----------------------------------------------------------------------------
/**
 *	ZAN^[o^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddClact( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap );
static void ZknSortSearchSubDeleteClact( ZKN_SORTSEARCHSUB_DRAW* p_draw );
static void ZknSortSearchSubAddSubClact( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add, int select_type, int local_type_page );
static void ZknSortSearchSubChgClact( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap );

// ʃ{^o^
static void ZknSortSearchSubAddClactCommon( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add );
static void ZknSortSearchSubDeleteClactCommon( ZKN_SORTSEARCHSUB_DRAW* p_draw );
// j
static void ZknSortSearchSubDeleteClactSub( ZKN_SORTSEARCHSUB_DRAW* p_draw );
// ĉʓo^
static void ZknSortSearchSubAddClactSort( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add );
// Ȃ܂ʓo^
static void ZknSortSearchSubAddClactName( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add );
// 1ʓo^
static void ZknSortSearchSubAddClactType1( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add );
// 2ʓo^
static void ZknSortSearchSubAddClactType2( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add );
// tH[ʓo^
static void ZknSortSearchSubAddClactForm( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add );
static void ZknSortSearchSubAddClactForm_Gra( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap );
static void ZknSortSearchSubDeleteClactForm_Gra( ZKN_SORTSEARCHSUB_DRAW* p_draw );

//-----------------------------------------------------------------------------
/**
 *	FONTOAM쐬
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddFontOam( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap );
static void ZknSortSearchSubDeleteFontOam( ZKN_SORTSEARCHSUB_DRAW* p_draw );
static void ZknSortSearchSubAddSubFontOam( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys, int select_type, int local_type_page );
static void ZknSortSearchSubChgFontOam( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap );
// ʃ{^
static void ZknSortSearchSubAddFontCommon( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys );
static void ZknSortSearchSubDeleteFontCommon( ZKN_SORTSEARCHSUB_DRAW* p_draw );
// j
static void ZknSortSearchSubDeleteFontSub( ZKN_SORTSEARCHSUB_DRAW* p_draw );
// ă{^
static void ZknSortSearchSubAddFontSort( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys );
// O{^
static void ZknSortSearchSubAddFontName( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys );
// 1{^
static void ZknSortSearchSubAddFontType1( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys );
// 2{^
static void ZknSortSearchSubAddFontType2( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys );

//-----------------------------------------------------------------------------
/**
 *		{^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonInit( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap );
static void ZknSortSearchSubButtonAllDelete( ZKN_SORTSEARCHSUB_WORK* p_work );
static void ZknSortSearchSubButtonChgMake( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap );
static void ZknSortSearchSubButtonMakeSub( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap, int select_type, int type_page );
static void ZknSortSearchSubButtonMoveAll( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubButtonMoveSub( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int select_type, int type_page );

static void ZknSortSearchSubButtonEventBuffInit( ZKN_SORTSEARCHSUB_WORK* p_work );

//@ʃ{^p
static void ZknSortSearchSubButtonMake( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap );
static void ZknSortSearchSubButtonMove( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubButtonDelete( ZKN_SORTSEARCHSUB_WORK* p_work );
static void ZknSortSearchSubButtonCallBack( u32 button_no, u32 event, void* p_work );
static void ZknSortSearchSubButtonEventInit( ZKN_SORTSEARCHSUB_WORK* p_work );
static void ZknSortSearchSubButtonSelectEventSet( ZKN_SORTSEARCHSUB_WORK* p_work, int select_type );

// Tu{^pj
static void ZknSortSearchSubButtonSubDelete( ZKN_SORTSEARCHSUB_WORK* p_work );
// Tu{^Cxgz񏉊
static void ZknSortSearchSubButtonSubEventInit( ZKN_SORTSEARCHSUB_WORK* p_work );
// \[g
static void ZknSortSearchSubButtonMakeSort( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap );
static void ZknSortSearchSubButtonMoveSort( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubButtonCallBackSort( u32 button_no, u32 event, void* p_work );
// O
static void ZknSortSearchSubButtonMakeName( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap );
static void ZknSortSearchSubButtonMoveName( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubButtonCallBackName( u32 button_no, u32 event, void* p_work );
// 1
static void ZknSortSearchSubButtonMakeType1( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap );
static void ZknSortSearchSubButtonMoveType1( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubButtonCallBackType1( u32 button_no, u32 event, void* p_work );
static void ZknSortSearchSubButtonSelectSetType1( ZKN_SORTSEARCHSUB_WORK* p_work, int type );
// 2
static void ZknSortSearchSubButtonMakeType2( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap );
static void ZknSortSearchSubButtonMoveType2( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubButtonCallBackType2( u32 button_no, u32 event, void* p_work );
static void ZknSortSearchSubButtonSelectSetType2( ZKN_SORTSEARCHSUB_WORK* p_work, int type );
// 
static void ZknSortSearchSubButtonMakeForm( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap );
static void ZknSortSearchSubButtonMoveForm( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubButtonCallBackForm( u32 button_no, u32 event, void* p_work );

//-----------------------------------------------------------------------------
/**
 *	J[\
 */
//-----------------------------------------------------------------------------
//@ʔj
static void ZknSortSearchSubCursorDelete( ZKN_SORTSEARCHSUB_WORK* p_work );

// J[\실
static void ZknSortSearchSubCursorMake( ZKN_SORTSEARCHSUB_WORK* p_work, int heap );
static void ZknSortSearchSubCursorMakeSub( ZKN_SORTSEARCHSUB_WORK* p_work, int heap, int select_type, int type_page );
static void ZknSortSearchSubCursorInit( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubCursorMove( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubCursorMoveSub( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int select_type, int type_page );
static void ZknSortSearchSubCursorChg( ZKN_SORTSEARCHSUB_WORK* p_work, int heap );
static void ZknSortSearchSubCursorCommonSet( ZKN_CURSOR_ONEDATA* p_data, int id );
static void ZknSortSearchSubCursorMoveCommon( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );

// ĉ
static void ZknSortSearchSubCursorMakeSort( ZKN_SORTSEARCHSUB_WORK* p_work, int heap );
static void ZknSortSearchSubCursorMoveSort( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
// O
static void ZknSortSearchSubCursorMakeName( ZKN_SORTSEARCHSUB_WORK* p_work, int heap );
static void ZknSortSearchSubCursorMoveName( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
// 1
static void ZknSortSearchSubCursorMakeType1( ZKN_SORTSEARCHSUB_WORK* p_work, int heap );
static void ZknSortSearchSubCursorMoveType1( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
// 2
static void ZknSortSearchSubCursorMakeType2( ZKN_SORTSEARCHSUB_WORK* p_work, int heap );
static void ZknSortSearchSubCursorMoveType2( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
// `
static void ZknSortSearchSubCursorMakeForm( ZKN_SORTSEARCHSUB_WORK* p_work, int heap );
static void ZknSortSearchSubCursorMoveForm( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );

// `揈
static void ZknSortSearchSubCursorDrawInit( ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_WORK* cp_work, const ZKN_SORTSEARCHSUB_GLB* cp_glb );
static void ZknSortSearchSubCursorDrawPack( ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_WORK* cp_work, const ZKN_SORTSEARCHSUB_GLB* cp_glb );
static void ZknSortSearchSubCursorDraw( ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_WORK* cp_work );
static BOOL ZknSortSearchSubCursorOnOff( ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb,  BOOL flag );


//-----------------------------------------------------------------------------
/**
 *		s
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDoInit( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubDoMain( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubDoSelect( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int select_type, int type_page );

// ʃ{^̎s
static void ZknSortSearchSubDoCommon( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
// ă{^̎s
static void ZknSortSearchSubDoSort( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
// O{^̎s
static void ZknSortSearchSubDoName( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
// 1{^̎s
static void ZknSortSearchSubDoType1( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
// 2{^̎s
static void ZknSortSearchSubDoType2( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );
static void ZknSortSearchSubDoTypeSetCommon( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int set_num );
// `{^̎s
static void ZknSortSearchSubDoForm( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb );


//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[g@Av쐬
 *
 *	@param	p_data		AvP[Vf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	heap		gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_SortSearchSubAplMake( ZKN_APL_DATA* p_data, ZKN_SYS_PTR zkn_sys, int heap )
{
	ZKN_SORTSEARCHSUB_GLB*	p_glb;
	ZKN_SORTSEARCHSUB_DRAWGLB*	p_drawglb;
	ZKN_EVENT_DATA*	p_event;
	
	p_glb = MakeSortSearchSubGlb( heap, zkn_sys );
	p_drawglb = MakeSortSearchSubDrawGlb( heap, zkn_sys );
	p_event = MakeSortSearchSubEvent( heap, zkn_sys );

	p_data->p_glb_data		= p_glb;
	p_data->p_glb_draw		= p_drawglb;
	p_data->p_event_data	= p_event;
	p_data->event_num		= SortSearchSubEventDataNumGet();

	p_data->do_func[ ZKN_PROC_FUNC_INIT ] = ZknSortSearchSubProcDoFuncInit;
	p_data->do_func[ ZKN_PROC_FUNC_MAIN ] = ZknSortSearchSubProcDoFuncMain;
	p_data->do_func[ ZKN_PROC_FUNC_DELETE ] = ZknSortSearchSubProcDoFuncDelete;
	p_data->draw_func[ ZKN_PROC_FUNC_INIT ] = ZknSortSearchSubProcDrawFuncInit;
	p_data->draw_func[ ZKN_PROC_FUNC_MAIN ] = ZknSortSearchSubProcDrawFuncMain;
	p_data->draw_func[ ZKN_PROC_FUNC_DELETE ] = ZknSortSearchSubProcDrawFuncDelete;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg	Tuʁ@j[Avj
 *
 *	@param	p_data	AvP[Vf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_SortSearchSubAplDelete( ZKN_APL_DATA* p_data )
{
	DeleteSortSearchSubGlb( p_data->p_glb_data ); 
	DeleteSortSearchSubDrawGlb( p_data->p_glb_draw ); 
	DeleteSortSearchSubEvent( p_data->p_event_data );
}



//-----------------------------------------------------------------------------
/**
 *		vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[g@O[of[^쐬
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_SORTSEARCHSUB_GLB* MakeSortSearchSubGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_SORTSEARCHSUB_GLB* p_glb;
	ZKN_APL_DATA* p_apl;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_SORTSEARCHSUB_GLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_SORTSEARCHSUB_GLB) );

	// mainʂ̃CxgL[
	p_glb->p_event_key = ZKN_SYS_GetEventKeyPtrMain( zkn_sys ); 

	// O[of[^
	p_glb->p_glb = ZKN_SYS_GetGlbData( zkn_sys );


	// CʃAvް
	p_glb->p_main_apl = ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_SORTSEARCH );

	// ̃Avް
	p_glb->p_my_apl = ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_SORTSEARCH );
	
	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[g@O[of[^쐬
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_SORTSEARCHSUB_DRAWGLB* MakeSortSearchSubDrawGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_SORTSEARCHSUB_DRAWGLB* p_glb;
	ZKN_APL_DATA* p_apl;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_SORTSEARCHSUB_DRAWGLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_SORTSEARCHSUB_DRAWGLB) );

	// `f[^
	p_glb->p_drawglb = ZKN_SYS_GetGlbDrawData( zkn_sys );

	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[g@Cxg쐬
 *
 *	@param	heap		gpq[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	Cxgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_EVENT_DATA* MakeSortSearchSubEvent( int heap, ZKN_SYS_PTR zkn_sys )
{
	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[g@O[of[^j
 *
 *	@param	p_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteSortSearchSubGlb( ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	GF_ASSERT( p_glb );
	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[g@O[of[^j
 *
 *	@param	p_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteSortSearchSubDrawGlb( ZKN_SORTSEARCHSUB_DRAWGLB* p_glb )
{
	GF_ASSERT( p_glb );
	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[g@Cxgf[^j
 *
 *	@param	p_event	Cxgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteSortSearchSubEvent( ZKN_EVENT_DATA* p_event )
{
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	\[gAv@Cxg擾
 *	
 *	@param	none	
 *
 *	@return	\[gAv@Cxg
 *
 *
 */
//-----------------------------------------------------------------------------
static int SortSearchSubEventDataNumGet( void )
{
	return ZKN_SORTSEARCHSUB_EVENT_NUM;
}


//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	[]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSortSearchSubProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_SORTSEARCHSUB_GLB* p_glb = p_glbdata;
	ZKN_SORTSEARCHSUB_WORK* p_work;
	int i;

	// [N쐬
	p_work = sys_AllocMemory( p_dodata->heap, sizeof(ZKN_SORTSEARCHSUB_WORK) );
	GF_ASSERT( p_work );
	memset( p_work, 0, sizeof(ZKN_SORTSEARCHSUB_WORK) );
	p_dodata->p_work = p_work;


	// 򏈗
	p_work->do_flag_common = ZKN_SORTSEARCHSUB_DO_FLAG_INIT;
	ZknSortSearchSubDoInit( p_work, p_glb );


	// {^J[\쐬
	ZknSortSearchSubButtonInit( p_work, p_glb, p_dodata->heap );
	ZknSortSearchSubCursorMake( p_work, p_dodata->heap );
	ZknSortSearchSubCursorInit( p_work, p_glb );


	// {^Cxgf[^
	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_NUM; i++ ){
		p_work->button_event[ i ] = ZKN_UTIL_BUTTON_PUSH_NONE;	// {^Cxgf[^
	}
	
	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 *	[C]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSortSearchSubProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_SORTSEARCHSUB_GLB* p_glb = p_glbdata;
	ZKN_SORTSEARCHSUB_WORK*	p_work = p_dodata->p_work;
	ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb = p_glb->p_my_apl->p_glb_draw;
	int select_type;
	int old_local_select;
	
	// I
	if( p_dodata->end_req == TRUE ){
		return ZKN_PROC_TRUE;
	}


	// lock
	if( p_dodata->lock == TRUE ){
		return ZKN_PROC_FALSE;
	}

	// tF[h͓֎~II
	if( ZKN_SortSearchAplFadeModeGet( p_glb->p_main_apl ) != ZKN_SORTSEARCH_FADENONE ){
		return ZKN_PROC_FALSE;
	}

	select_type = ZKN_SortSearchAplSelectTypeGet( p_glb->p_main_apl );
	
	switch( p_dodata->seq ){
	// 쏈
	case 0:	

		// Iߕ
		if( (p_work->local_select != select_type) ||
			(p_work->local_type_page != p_work->type_page ) ){

			// {^tF[hNGXg
			p_work->button_fade_flag = FALSE;
			p_drawglb->button_fade_req = ZKN_SORTSEARCH_SUB_BUTTON_FADE_OUT;
			p_drawglb->button_fade = &p_work->button_fade_flag;

			// {^Cxg
			ZknSortSearchSubButtonEventInit( p_work );
			// `̂߂Ƀ{^Cxg̒lݒ
			ZknSortSearchSubButtonSelectEventSet( p_work, select_type );


			// {^ύX
			p_dodata->seq++;
			break;
		}

		// {^
		ZknSortSearchSubButtonMoveAll( p_work, p_glb );

		// J[\
		if( (ZKN_GLBDATA_TouchCursorFlagGet( p_glb->p_glb ) == TRUE) ){

			ZknSortSearchSubCursorMove( p_work, p_glb );
		}


		// 상C
		ZknSortSearchSubDoMain( p_work, p_glb );
		break;

	// {^tF[hAEg҂
	case 1:
		if( p_work->button_fade_flag ){
			p_dodata->seq ++;

		}
		break;

	// {^ύX
	case 2:
		old_local_select = p_work->local_select;	// J[\ʒûߕۑ
		p_work->local_select = select_type;
		p_work->local_type_page = p_work->type_page;
		
		ZknSortSearchSubButtonChgMake( p_work, p_glb, p_dodata->heap );
		ZknSortSearchSubCursorChg( p_work, p_dodata->heap );
		ZknSortSearchSubDoInit( p_work, p_glb );

		// I߂̕ύXƂ̂݃J[\ʒu
		if( old_local_select != p_work->local_select ){
			ZknSortSearchSubCursorInit( p_work, p_glb );
		}

		// {^tF[hNGXg
		p_work->button_fade_flag = FALSE;
		p_drawglb->button_fade_req = ZKN_SORTSEARCH_SUB_BUTTON_FADE_IN;
		p_drawglb->button_fade = &p_work->button_fade_flag;


		// Tu{^
		ZknSortSearchSubButtonSubEventInit( p_work );
		
		p_dodata->seq++;
		break;

	// {^tF[hC҂
	case 3:
		if( p_work->button_fade_flag ){
			p_dodata->seq ++;
		}
		break;

	// C쏈ɖ߂
	case 4:
		p_dodata->seq = 0;
		break;
	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	[j]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSortSearchSubProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_SORTSEARCHSUB_WORK* p_work = p_dodata->p_work;

	// {^J[\j
	ZknSortSearchSubButtonAllDelete( p_work );
	ZknSortSearchSubCursorDelete( p_work );

	sys_FreeMemoryEz( p_work );
	p_dodata->p_work = NULL;
	
	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 * []
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSortSearchSubProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_SORTSEARCHSUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_SORTSEARCHSUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb = p_glbdraw;
	ZKN_SORTSEARCHSUB_DRAW* p_drawwork = p_drawdata->p_work;
	BOOL check;

	switch( p_drawdata->seq ){
	case ZKN_SORTSEARCHSUB_SEQINIT_ALLOC:
		p_drawdata->p_work = sys_AllocMemory( p_drawdata->heap, sizeof(ZKN_SORTSEARCHSUB_DRAW) );
		memset( p_drawdata->p_work, 0, sizeof(ZKN_SORTSEARCHSUB_DRAW) );
		p_drawdata->seq++;
		break;
		
	case ZKN_SORTSEARCHSUB_SEQINIT_LOAD:
		ZknSortSearchSubLoadRes( p_drawwork, p_drawglb, cp_dataglb, cp_datawork, p_drawdata->heap );
		
		// tF[h
		ChangeBrightnessRequest( ZKN_FADE_SYNC_COMMON,
				BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, PLANEMASK_ALL, MASK_SUB_DISPLAY );

		// J[\`揉
		ZknSortSearchSubCursorDrawInit( p_drawglb, cp_datawork, cp_dataglb );
		
		p_drawdata->seq++;
		break;
		
	case ZKN_SORTSEARCHSUB_SEQINIT_FADEIN:
		// tF[h
		if( IsFinishedBrightnessChg( MASK_SUB_DISPLAY  ) ){
			p_drawdata->seq++;
		}
		break;
		
	case ZKN_SORTSEARCHSUB_SEQINIT_END:
		return ZKN_PROC_TRUE;
	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [C]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSortSearchSubProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_SORTSEARCHSUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_SORTSEARCHSUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb = p_glbdraw;
	ZKN_SORTSEARCHSUB_DRAW* p_drawwork = p_drawdata->p_work;
	int i;
	int old_select;
	int old_type_page;
	int pltt_ofs;


	if( ZKN_SortSearchAplFadeModeGet( cp_dataglb->p_main_apl ) != ZKN_SORTSEARCH_FADENONE ){

		// tF[hVXe
		ZknSortSearchSubSortFadeSys( p_drawwork, p_drawglb, cp_dataglb );


	}else{

		// tF[hCAEg
		ZknSortSearchSubButtonFadeCont( p_drawwork, p_drawglb );

		// AN^[@tHgOAM̕ύX
		if( (p_drawwork->local_select != cp_datawork->local_select) || 
			(p_drawwork->local_type_page != cp_datawork->local_type_page) ){
			old_select = p_drawwork->local_select;
			old_type_page = p_drawwork->local_type_page;

			p_drawwork->local_select = cp_datawork->local_select;
			p_drawwork->local_type_page = cp_datawork->local_type_page;

			// old_select`̂Ƃ̓\[Xj
			if( old_select == ZKN_SORTSEARCH_SELECT_FORM ){
				ZknSortSearchSubReleaseOamForm( p_drawwork, p_drawglb );
				ZknSortSearchSubDeleteClactForm_Gra( p_drawwork );
			}

			ZknSortSearchSubChgClact( p_drawwork, p_drawglb, p_drawdata->heap );
			ZknSortSearchSubChgFontOam( p_drawwork, p_drawglb, p_drawdata->heap );

			// `̂Ƃ̓\[Xǂݍ
			if( p_drawwork->local_select == ZKN_SORTSEARCH_SELECT_FORM ){
				ZknSortSearchSubLoadOamForm( p_drawwork, p_drawglb, p_drawdata->heap );
				ZknSortSearchSubAddClactForm_Gra( p_drawwork, p_drawglb, p_drawdata->heap );
			} 

			// OAM𔼓ݒ
			ZknSortSearchSubButtonFadeOamModeSet_Pack( p_drawwork, GX_OAM_MODE_XLU, p_drawwork->local_select, p_drawwork->local_type_page );
		}
		
		// J[\
		ZknSortSearchSubCursorDrawPack( p_drawglb, cp_datawork, cp_dataglb );
	}

	// {^
	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_NUM; i++ ){
		ZKN_UTIL_ButtonMove( p_drawwork->clact[ i ],
				cp_datawork->button_event[ i ] );

		// {^tHgAj
		if( p_drawwork->p_fontoam[ i ] ){
			if( i==ZKN_SORTSEARCHSUB_BUTTON_ACTION ){
				pltt_ofs = ZKN_SORTSEARCHSUB_BUTTONFONT_KETTEI_PLTOFS;		
			}else{
				pltt_ofs = ZKN_SORTSEARCHSUB_BUTTONFONT_PLTOFS;	
			}
			ZKN_UTIL_ButtonFontMove_Col( p_drawwork->clact[ i ],
					p_drawwork->p_fontoam[ i ],
					ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y,
					pltt_ofs,
					ZKN_SORTSEARCHSUB_BUTTONFONT_PUSHPLTOFS );
		}
	}

	// Tu{^
	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX; i++ ){
		if( p_drawwork->clact_sub[ i ] ){
			ZKN_UTIL_ButtonMove( p_drawwork->clact_sub[ i ],
					cp_datawork->button_event_sub[ i ] );
		}

		// {^tHgAj
		if( p_drawwork->p_fontoam_sub[ i ] ){
			ZKN_UTIL_ButtonFontMove_Col( p_drawwork->clact_sub[ i ],
					p_drawwork->p_fontoam_sub[ i ],
					ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y,
					ZKN_SORTSEARCHSUB_BUTTONFONT_OTHER_PLTOFS,
					ZKN_SORTSEARCHSUB_BUTTONFONT_OTHER_PUSHPLTOFS );
		}

		// `{^
		if( p_drawwork->clact_sub_form[i] ){
			ZKN_UTIL_ButtonMove( p_drawwork->clact_sub_form[ i ],
					cp_datawork->button_event_sub[ i ] );
		}
	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [j]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknSortSearchSubProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_SORTSEARCHSUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_SORTSEARCHSUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb = p_glbdraw;
	ZKN_SORTSEARCHSUB_DRAW* p_drawwork = p_drawdata->p_work;
	BOOL check;


	switch( p_drawdata->seq ){
	case ZKN_SORTSEARCHSUB_SEQDELETE_FADEOUT_INIT:

		if( ZKN_SortSearchAplSortDoFlagGet( cp_dataglb->p_main_apl ) == TRUE ){
			p_drawdata->seq = ZKN_SORTSEARCHSUB_SEQDELETE_RELEASE;
		}else{
		
			ChangeBrightnessRequest( COMM_BRIGHTNESS_SYNC, 
					BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_SUB_DISPLAY );
			p_drawdata->seq++;
		}
		break;
		
	case ZKN_SORTSEARCHSUB_SEQDELETE_FADEOUT:
		if( IsFinishedBrightnessChg( MASK_SUB_DISPLAY  ) ){
			p_drawdata->seq++;
		}
		break;

	case ZKN_SORTSEARCHSUB_SEQDELETE_RELEASE:
		
		ZknSortSearchSubDeleteRes( p_drawwork, p_drawglb );

		// `̂Ƃ̓\[Xj
		if( p_drawwork->local_select == ZKN_SORTSEARCH_SELECT_FORM ){
			ZknSortSearchSubReleaseOamForm( p_drawwork, p_drawglb );
			ZknSortSearchSubDeleteClactForm_Gra( p_drawwork );
		}
		
		p_drawdata->seq++;
		break;
		
	case ZKN_SORTSEARCHSUB_SEQDELETE_FREE:

		sys_FreeMemoryEz(p_drawdata->p_work);
		p_drawdata->p_work = NULL;
		p_drawdata->seq++;
		break;
		
		
	case ZKN_SORTSEARCHSUB_SEQDELETE_END:
		return ZKN_PROC_TRUE;
	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Resourceǂݍ݁ʍ\z
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[of[^
 *	@param	cp_datawork	f[^[N
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubLoadRes( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_GLB* cp_glb, const ZKN_SORTSEARCHSUB_WORK* cp_datawork, int heap )
{
	// BGݒ
	ZknSortSearchSubSetUpBg( p_drawglb, cp_glb, heap );

	// \[Xǂݍ
	ZknSortSearchSubLoadOam( p_draw, p_drawglb, heap );

	// OAMo^
	ZknSortSearchSubAddClact( p_draw, p_drawglb, heap );


	// FONTOAM
	ZknSortSearchSubAddFontOam( p_draw, p_drawglb, heap );

	// OAM𔼓ݒ
	ZknSortSearchSubButtonFadeOamModeSet_Pack( p_draw, GX_OAM_MODE_XLU, p_draw->local_select, p_draw->local_type_page );

}

//----------------------------------------------------------------------------
/**
 *	@brief	Resourcej
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDeleteRes( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb )
{
	// FOMTOAM	
	ZknSortSearchSubDeleteFontOam( p_draw );

	// OAM
	ZknSortSearchSubDeleteClact( p_draw );

	// OAM\[X
	ZknSortSearchSubReleaseOam( p_draw, p_drawglb );

	// J[\\OFF
	ZKN_UTIL_CursorSetDrawFlag( &p_drawglb->p_drawglb->cursor, FALSE );
}

//----------------------------------------------------------------------------
/**
 *	@brief	wiʃZbg	
 *
 *	@param	p_drawglb	`O[o
 *	@param	cp_glb		O[o
 *	@param	heap		q[v
 *
 *	@return	none
 *
 * [CxgŏoĂ铇̃XN[f[^̒]
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubSetUpBg( ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_GLB* cp_glb, int heap )
{
	void* buff;
	NNSG2dScreenData* p_scrn;

	// LN^f[^]
	ZKN_GLBDATA_BgCharSet( p_drawglb->p_drawglb, NARC_zukan_zkn_list_sub_lzh_NCGR, p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S, 0, 0, TRUE, heap );
	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_sort_bg_sub2_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S,
			p_scrn->rawData, 0, 0,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );

	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S );
}



//----------------------------------------------------------------------------
/**
 *	@brief	{^ް쐬
 *
 *	@param	p_work		ް[N
 *	@param	p_glb		ްO[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonInit( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap )
{
	// ʃ{^쐬
	ZknSortSearchSubButtonMake( p_work, p_glb, heap );

	// Tuʃ{^쐬
	ZknSortSearchSubButtonMakeSub( p_work, p_glb, heap, p_work->local_select, p_work->local_type_page );

	// {^Cxgobt@
	ZknSortSearchSubButtonEventBuffInit( p_work );
}
// {^Cxgobt@
static void ZknSortSearchSubButtonEventBuffInit( ZKN_SORTSEARCHSUB_WORK* p_work )
{
	int i;
	
	for( i = 0; i < ZKN_SORTSEARCHSUB_BUTTON_NUM; i++ ){
		p_work->button_event[ i ] = BMN_EVENT_SLIDEOUT;
	}

	for( i = 0; i < ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX; i++ ){
		p_work->button_event_sub[ i ] = BMN_EVENT_SLIDEOUT;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	S{^ްj
 *
 *	@param	p_work	ް[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonAllDelete( ZKN_SORTSEARCHSUB_WORK* p_work )
{
	// ʃ{^
	ZknSortSearchSubButtonDelete( p_work );

	// Tuʃ{^
	ZknSortSearchSubButtonSubDelete( p_work );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Tuʃ{^ް̕ύX
 *
 *	@param	p_work	ް[N
 *	@param	p_glb	ްO[o
 *	@param	heap	q[v 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonChgMake( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap )
{
	// ܂ł̂j
	ZknSortSearchSubButtonSubDelete( p_work );


	// č쐬
	ZknSortSearchSubButtonMakeSub( p_work, p_glb, heap, p_work->local_select, p_work->local_type_page );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Tuʃ{^쐬
 *
 *	@param	p_work		ް[N
 *	@param	p_glb		ްO[o
 *	@param	heap		q[v
 *	@param	select_type	I
 *	@param	type_page	߃y[W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonMakeSub( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap, int select_type, int type_page )
{
	switch( select_type ){
	case ZKN_SORTSEARCH_SELECT_SORT:
		ZknSortSearchSubButtonMakeSort( p_work, p_glb, heap );
		break;
		
	case ZKN_SORTSEARCH_SELECT_NEME:
		ZknSortSearchSubButtonMakeName( p_work, p_glb, heap );
		break;
		
	case ZKN_SORTSEARCH_SELECT_TYPE:
		if( type_page == 0 ){
			ZknSortSearchSubButtonMakeType1( p_work, p_glb, heap );
		}else{
			ZknSortSearchSubButtonMakeType2( p_work, p_glb, heap );
		}
		break;
		
	case ZKN_SORTSEARCH_SELECT_FORM:
		ZknSortSearchSubButtonMakeForm( p_work, p_glb, heap );
		break;
		
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^̓
 *
 *	@param	p_work	ް[N
 *	@param	p_glb	ްO[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonMoveAll( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	// ʃ{^
	ZknSortSearchSubButtonMove( p_work, p_glb );


	//@Iߕʓ
	ZknSortSearchSubButtonMoveSub( p_work, p_glb, p_work->local_select, p_work->local_type_page );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Tuʃ{^
 *
 *	@param	p_work			ް[N
 *	@param	p_glb			ްO[o
 *	@param	select_type		I
 *	@param	type_page		߃y[W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonMoveSub( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int select_type, int type_page )
{
	switch( select_type ){
	case ZKN_SORTSEARCH_SELECT_SORT:
		ZknSortSearchSubButtonMoveSort( p_work, p_glb );
		break;
		
	case ZKN_SORTSEARCH_SELECT_NEME:
		ZknSortSearchSubButtonMoveName( p_work, p_glb );
		break;
		
	case ZKN_SORTSEARCH_SELECT_TYPE:
		if( type_page == 0 ){
			ZknSortSearchSubButtonMoveType1( p_work, p_glb );
		}else{
			ZknSortSearchSubButtonMoveType2( p_work, p_glb );
		}
		break;
		
	case ZKN_SORTSEARCH_SELECT_FORM:
		ZknSortSearchSubButtonMoveForm( p_work, p_glb );
		break;
		
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^^b`f[^쐬
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[of[^
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonMake( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap )
{
	// e[u쐬
	p_work->hit_tbl = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_SORTSEARCHSUB_BUTTON_NUM );

	// e[uf[^ݒ
	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_SORTSEARCHSUB_BUTTON_NARABI ],
			ZKN_SORTSEARCHSUB_BUTTON_NARABI_Y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_NARABI_Y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_X - (ZKN_SORTSEARCHSUB_BUTTON_SIZX/2),
			ZKN_SORTSEARCHSUB_BUTTON_X + (ZKN_SORTSEARCHSUB_BUTTON_SIZX/2) );
	
	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_SORTSEARCHSUB_BUTTON_BACK ],
			ZKN_SORTSEARCHSUB_BUTTON_BACK_Y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_BACK_Y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_BACK_X - (ZKN_SORTSEARCHSUB_BUTTON_BACK_SIZX/2),
			ZKN_SORTSEARCHSUB_BUTTON_BACK_X + (ZKN_SORTSEARCHSUB_BUTTON_BACK_SIZX/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_SORTSEARCHSUB_BUTTON_NAME ],
			ZKN_SORTSEARCHSUB_BUTTON_NAME_Y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_NAME_Y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_X - (ZKN_SORTSEARCHSUB_BUTTON_SIZX/2),
			ZKN_SORTSEARCHSUB_BUTTON_X + (ZKN_SORTSEARCHSUB_BUTTON_SIZX/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_SORTSEARCHSUB_BUTTON_TYPE ],
			ZKN_SORTSEARCHSUB_BUTTON_TYPE_Y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_TYPE_Y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_X - (ZKN_SORTSEARCHSUB_BUTTON_SIZX/2),
			ZKN_SORTSEARCHSUB_BUTTON_X + (ZKN_SORTSEARCHSUB_BUTTON_SIZX/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_SORTSEARCHSUB_BUTTON_FORM ],
			ZKN_SORTSEARCHSUB_BUTTON_FORM_Y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_FORM_Y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_X - (ZKN_SORTSEARCHSUB_BUTTON_SIZX/2),
			ZKN_SORTSEARCHSUB_BUTTON_X + (ZKN_SORTSEARCHSUB_BUTTON_SIZX/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_SORTSEARCHSUB_BUTTON_ACTION ],
			ZKN_SORTSEARCHSUB_BUTTON_ACTION_Y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_ACTION_Y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			ZKN_SORTSEARCHSUB_BUTTON_ACTION_X - (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2),
			ZKN_SORTSEARCHSUB_BUTTON_ACTION_X + (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2) );

	p_work->button_work.p_glb = p_glb;
	p_work->button_work.p_work = p_work;

	// {^}l[W쐬
	p_work->p_button_man = BMN_Create( 
			p_work->hit_tbl,
			ZKN_SORTSEARCHSUB_BUTTON_NUM,
			ZknSortSearchSubButtonCallBack,
			&p_work->button_work,
			heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonMove( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	// {^Cxg
	ZknSortSearchSubButtonEventInit( p_work );
	
	BMN_Main( p_work->p_button_man );

	// I𒆂̍ڂ̃{^͉ςȂ
	ZknSortSearchSubButtonSelectEventSet( p_work, p_work->local_select );
}

// Cxg
static void ZknSortSearchSubButtonEventInit( ZKN_SORTSEARCHSUB_WORK* p_work )
{
	int i;
	
	// ꂽSẴ{^̊Gɖ߂
	for( i = 0; i < ZKN_SORTSEARCHSUB_BUTTON_NUM; i++ ){
		p_work->button_event[ i ] = BMN_EVENT_SLIDEOUT;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^̃ZNgߐݒ
 *
 *	@param	p_work 
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonSelectEventSet( ZKN_SORTSEARCHSUB_WORK* p_work, int select_type )
{
	switch( select_type ){
	case ZKN_SORTSEARCH_SELECT_SORT:
		if( p_work->button_event[ ZKN_SORTSEARCHSUB_BUTTON_NARABI ] != BMN_EVENT_HOLD ){
			p_work->button_event[ ZKN_SORTSEARCHSUB_BUTTON_NARABI ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_SORTSEARCH_SELECT_NEME:
		if( p_work->button_event[ ZKN_SORTSEARCHSUB_BUTTON_NAME ] != BMN_EVENT_HOLD ){
			p_work->button_event[ ZKN_SORTSEARCHSUB_BUTTON_NAME ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_SORTSEARCH_SELECT_TYPE:
		if( p_work->button_event[ ZKN_SORTSEARCHSUB_BUTTON_TYPE ] != BMN_EVENT_HOLD ){
			p_work->button_event[ ZKN_SORTSEARCHSUB_BUTTON_TYPE ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_SORTSEARCH_SELECT_FORM:
		if( p_work->button_event[ ZKN_SORTSEARCHSUB_BUTTON_FORM ] != BMN_EVENT_HOLD ){
			p_work->button_event[ ZKN_SORTSEARCHSUB_BUTTON_FORM ] = BMN_EVENT_RELEASE;
		}
		break;
	default:
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	{^j
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonDelete( ZKN_SORTSEARCHSUB_WORK* p_work )
{
	BMN_Delete( p_work->p_button_man );

	// e[u[Nj
	sys_FreeMemoryEz( p_work->hit_tbl );
	p_work->hit_tbl = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^CxgR[obN
 *
 *	@param	button_no	{^io[
 *	@param	event		Cxg^Cv
 *	@param	p_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonCallBack( u32 button_no, u32 event, void* p_work )
{
	ZKN_SORTSEARCHSUB_BUTTON_WORK* p_button_work = p_work;
	ZKN_SORTSEARCHSUB_GLB* p_glb = p_button_work->p_glb;
	ZKN_SORTSEARCHSUB_WORK* p_subwork = p_button_work->p_work;

	// {^Cxgi[
	p_subwork->button_event[ button_no ] = event;
	
	switch( event ){
	case BMN_EVENT_HOLD:
		p_subwork->do_flag_common = button_no;
		p_subwork->req_count ++;
		break;

	default:
		p_subwork->req_count = 0;
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	Tu{^pj
 *
 *	@param	p_work
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonSubDelete( ZKN_SORTSEARCHSUB_WORK* p_work )
{
	BMN_Delete( p_work->p_button_man_sub );

	// e[u[Nj
	sys_FreeMemoryEz( p_work->hit_tbl_sub );
	p_work->hit_tbl_sub = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Tu{^Cxg
 *
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonSubEventInit( ZKN_SORTSEARCHSUB_WORK* p_work )
{
	int i;
	
	// ꂽSẴ{^̊Gɖ߂
	for( i = 0; i < ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX; i++ ){
		p_work->button_event_sub[ i ] = BMN_EVENT_SLIDEOUT;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	\[g
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonMakeSort( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap )
{
	int i, j;
	int x, y;
	// e[u쐬
	p_work->hit_tbl_sub = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUM );


	// eWOAM쐬
	for( i=0; i<3; i++ ){
		y = ZKN_SORTSEARCHSUB_BUTTON_01_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		for( j=0; j<2; j++ ){
			x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));

			// e[uf[^ݒ
			ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl_sub[ (i*2)+j ],
					y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
					y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
					x - (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2),
					x + (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2) );
		}
	}
	

	p_work->button_work.p_glb = p_glb;
	p_work->button_work.p_work = p_work;

	// {^}l[W쐬
	p_work->p_button_man_sub = BMN_Create( 
			p_work->hit_tbl_sub,
			ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUM,
			ZknSortSearchSubButtonCallBackSort,
			&p_work->button_work,
			heap );
}
static void ZknSortSearchSubButtonMoveSort( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int i;
	
	// ꂽSẴ{^̊Gɖ߂
	for( i = 0; i < ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUM; i++ ){
		p_work->button_event_sub[ i ] = BMN_EVENT_SLIDEOUT;
	}
	
	BMN_Main( p_work->p_button_man_sub );

	// I𒆂̃{^ςȂɂ
	switch( ZKN_SortSearchAplSortTypeGet( p_glb->p_main_apl ) ){
	case ZKN_POKELIST_SORT_NORMAL:		// |Pio[
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUMBER ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUMBER ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SORT_GOZYUUON:		// ܏\
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_AIUEO ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_AIUEO ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SORT_GRAM_L:		// d
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_HEAVY ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_HEAVY ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SORT_GRAM_S:		// y
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_LIGHT ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_LIGHT ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SORT_HIGH_L:		// 
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_TALL ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_TALL ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELSIT_SOTT_HIGH_S:		// Ⴂ
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_SHORT ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NARABI_SHORT ] = BMN_EVENT_RELEASE;
		}
		break;
	}
}
static void ZknSortSearchSubButtonCallBackSort( u32 button_no, u32 event, void* p_work )
{
	ZKN_SORTSEARCHSUB_BUTTON_WORK* p_button_work = p_work;
	ZKN_SORTSEARCHSUB_GLB* p_glb = p_button_work->p_glb;
	ZKN_SORTSEARCHSUB_WORK* p_subwork = p_button_work->p_work;

	// {^Cxgi[
	p_subwork->button_event_sub[ button_no ] = event;
	
	switch( event ){
	case BMN_EVENT_HOLD:
		p_subwork->do_flag_select = button_no;
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	O
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonMakeName( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap )
{
	int i, j;
	int x, y;
	// e[u쐬
	p_work->hit_tbl_sub = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_SORTSEARCHSUB_BUTTON_NAME_NUM );

	// eWOAM쐬
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/11/09
// ؍̃\[gɑΉ
	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_NAME_NUM / 2; i++ ){
#if PM_LANG == LANG_KOREA
		y = ZKN_SORTSEARCHSUB_BUTTON_01_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
#else
		y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
#endif
// ----------------------------------------------------------------------------
		for( j=0; j<2; j++ ){
			x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));

			// e[uf[^ݒ
			ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl_sub[ (i*2)+j ],
					y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
					y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
					x - (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2),
					x + (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2) );
		}
	}

	p_work->button_work.p_glb = p_glb;
	p_work->button_work.p_work = p_work;

	// {^}l[W쐬
	p_work->p_button_man_sub = BMN_Create( 
			p_work->hit_tbl_sub,
			ZKN_SORTSEARCHSUB_BUTTON_NAME_NUM,
			ZknSortSearchSubButtonCallBackName,
			&p_work->button_work,
			heap );
}
static void ZknSortSearchSubButtonMoveName( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int i;
	
	// ꂽSẴ{^̊Gɖ߂
	for( i = 0; i < ZKN_SORTSEARCHSUB_BUTTON_NAME_NUM; i++ ){
		p_work->button_event_sub[ i ] = BMN_EVENT_SLIDEOUT;
	}
	
	BMN_Main( p_work->p_button_man_sub );

	switch( ZKN_SortSearchAplNameTypeGet( p_glb->p_main_apl ) ){
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// \[g܏\At@xbg
	case ZKN_POKELIST_SEARCH_NAME_ABC:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_ABC ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_ABC ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SEARCH_NAME_DEF:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_DEF ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_DEF ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SEARCH_NAME_GHI:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_GHI ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_GHI ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SEARCH_NAME_JKL:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_JKL ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_JKL ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SEARCH_NAME_MNO:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_MNO ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_MNO ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SEARCH_NAME_PQR:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_PQR ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_PQR ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SEARCH_NAME_STU:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_STU ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_STU ] = BMN_EVENT_RELEASE;
		}
		break;
		
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/11/09
// ؍̃\[gɑΉ
#if PM_LANG != LANG_KOREA
	case ZKN_POKELIST_SEARCH_NAME_VWX:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_VWX ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_VWX ] = BMN_EVENT_RELEASE;
		}
		break;
		
	case ZKN_POKELIST_SEARCH_NAME_YZ:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_YZ ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_NAME_YZ ] = BMN_EVENT_RELEASE;
		}
		break;
#endif
// ----------------------------------------------------------------------------
	// ----------------------------------------------------------------------------

	default:
		break;
	}
}
static void ZknSortSearchSubButtonCallBackName( u32 button_no, u32 event, void* p_work )
{
	ZKN_SORTSEARCHSUB_BUTTON_WORK* p_button_work = p_work;
	ZKN_SORTSEARCHSUB_GLB* p_glb = p_button_work->p_glb;
	ZKN_SORTSEARCHSUB_WORK* p_subwork = p_button_work->p_work;

	// {^Cxgi[
	p_subwork->button_event_sub[ button_no ] = event;
	
	switch( event ){
	case BMN_EVENT_HOLD:
		p_subwork->do_flag_select = button_no;
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	1
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonMakeType1( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap )
{
	int i, j;
	int x, y;
	// e[u쐬
	p_work->hit_tbl_sub = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NUM );

	// eWOAM쐬
	for( i=0; i<5; i++ ){
		y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		for( j=0; j<2; j++ ){
			x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));

			// e[uf[^ݒ
			ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl_sub[ (i*2)+j ],
					y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
					y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
					x - (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2),
					x + (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2) );
		}
	}
	
	// y[W{^
	y = ZKN_SORTSEARCHSUB_BUTTON_05_Y;
	x = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2_X;
	// e[uf[^ݒ
	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2 ],
			y - (ZKN_SORTSEARCHSUB_BUTTON_PAGE_SIZY/2),
			y + (ZKN_SORTSEARCHSUB_BUTTON_PAGE_SIZY/2),
			x - (ZKN_SORTSEARCHSUB_BUTTON_PAGE_SIZX/2),
			x + (ZKN_SORTSEARCHSUB_BUTTON_PAGE_SIZX/2) );

	p_work->button_work.p_glb = p_glb;
	p_work->button_work.p_work = p_work;

	// {^}l[W쐬
	p_work->p_button_man_sub = BMN_Create( 
			p_work->hit_tbl_sub,
			ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NUM,
			ZknSortSearchSubButtonCallBackType1,
			&p_work->button_work,
			heap );
}
static void ZknSortSearchSubButtonMoveType1( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int i;
	
	// ꂽSẴ{^̊Gɖ߂
	for( i = 0; i < ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NUM; i++ ){
		p_work->button_event_sub[ i ] = BMN_EVENT_SLIDEOUT;
	}
	
	BMN_Main( p_work->p_button_man_sub );

	// I𒆂̍ڂςȂ
	ZknSortSearchSubButtonSelectSetType1( p_work, ZKN_SortSearchAplTypeTypeGet( p_glb->p_main_apl, ZKN_SORTSEARCH_TYPE1 ) );
	ZknSortSearchSubButtonSelectSetType1( p_work, ZKN_SortSearchAplTypeTypeGet( p_glb->p_main_apl, ZKN_SORTSEARCH_TYPE2 ) );

}
static void ZknSortSearchSubButtonSelectSetType1( ZKN_SORTSEARCHSUB_WORK* p_work, int type )
{
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/19
	// ^Cv̕я܏\]̏
	switch( type ){
	case ZKN_POKELIST_SEARCH_TYPE_NORMAL:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NORMAL ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NORMAL ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_BATTLE:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_BATTLE ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_BATTLE ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_HIKOU:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HIKOR ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HIKOR ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_POISON:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_DOKU ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_DOKU ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_JIMEN:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_JIMEN ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_JIMEN ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_IWA:		
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_IWA ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_IWA ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_MUSHI:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_MUSHI ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_MUSHI ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_GHOST:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_GHOST ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_GHOST ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_METAL:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HAGANE ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HAGANE ] = BMN_EVENT_RELEASE;
		}
		break;
	default:
		break;
	}
	// ----------------------------------------------------------------------------
}
static void ZknSortSearchSubButtonCallBackType1( u32 button_no, u32 event, void* p_work )
{
	ZKN_SORTSEARCHSUB_BUTTON_WORK* p_button_work = p_work;
	ZKN_SORTSEARCHSUB_GLB* p_glb = p_button_work->p_glb;
	ZKN_SORTSEARCHSUB_WORK* p_subwork = p_button_work->p_work;

	// {^Cxgi[
	p_subwork->button_event_sub[ button_no ] = event;

	switch( event ){
	case BMN_EVENT_HOLD:
		if( p_subwork->tp_no_touch == FALSE ){
			p_subwork->do_flag_select = button_no;
			p_subwork->tp_no_touch = TRUE;
		}
		break;

	default:
		p_subwork->tp_no_touch = FALSE;
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	2
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonMakeType2( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap )
{
	int i, j;
	int x, y;
	// e[u쐬
	p_work->hit_tbl_sub = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NUM );

	// eWOAM쐬
	for( i=0; i<4; i++ ){
		y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		for( j=0; j<2; j++ ){
			x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));

			// e[uf[^ݒ
			ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl_sub[ (i*2)+j ],
					y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
					y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
					x - (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2),
					x + (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2) );
		}
	}

	// [[[[[{^
	y = ZKN_SORTSEARCHSUB_BUTTON_04_Y;
	x = ZKN_SORTSEARCHSUB_BUTTONDEF_01_X;
	// e[uf[^ݒ
	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NONE ],
			y - (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			y + (ZKN_SORTSEARCHSUB_BUTTON_SIZY/2),
			x - (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2),
			x + (ZKN_SORTSEARCHSUB_BUTTON_ACTION_SIZX/2) );
	
	// y[W{^
	y = ZKN_SORTSEARCHSUB_BUTTON_05_Y;
	x = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1_X;
	// e[uf[^ݒ
	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1 ],
			y - (ZKN_SORTSEARCHSUB_BUTTON_PAGE_SIZY/2),
			y + (ZKN_SORTSEARCHSUB_BUTTON_PAGE_SIZY/2),
			x - (ZKN_SORTSEARCHSUB_BUTTON_PAGE_SIZX/2),
			x + (ZKN_SORTSEARCHSUB_BUTTON_PAGE_SIZX/2) );


	p_work->button_work.p_glb = p_glb;
	p_work->button_work.p_work = p_work;

	// {^}l[W쐬
	p_work->p_button_man_sub = BMN_Create( 
			p_work->hit_tbl_sub,
			ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NUM,
			ZknSortSearchSubButtonCallBackType2,
			&p_work->button_work,
			heap );
}
static void ZknSortSearchSubButtonMoveType2( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int i;
	
	// ꂽSẴ{^̊Gɖ߂
	for( i = 0; i < ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NUM; i++ ){
		p_work->button_event_sub[ i ] = BMN_EVENT_SLIDEOUT;
	}
	
	BMN_Main( p_work->p_button_man_sub );

	// I𒆂̍ڂςȂ
	ZknSortSearchSubButtonSelectSetType2( p_work, ZKN_SortSearchAplTypeTypeGet( p_glb->p_main_apl, ZKN_SORTSEARCH_TYPE1 ) );
	ZknSortSearchSubButtonSelectSetType2( p_work, ZKN_SortSearchAplTypeTypeGet( p_glb->p_main_apl, ZKN_SORTSEARCH_TYPE2 ) );
}
static void ZknSortSearchSubButtonCallBackType2( u32 button_no, u32 event, void* p_work )
{
	ZKN_SORTSEARCHSUB_BUTTON_WORK* p_button_work = p_work;
	ZKN_SORTSEARCHSUB_GLB* p_glb = p_button_work->p_glb;
	ZKN_SORTSEARCHSUB_WORK* p_subwork = p_button_work->p_work;

	// {^Cxgi[
	p_subwork->button_event_sub[ button_no ] = event;
	
	switch( event ){
	case BMN_EVENT_HOLD:
		if( p_subwork->tp_no_touch == FALSE ){
			p_subwork->do_flag_select = button_no;
			p_subwork->tp_no_touch = TRUE;
		}
		break;

	default:
		p_subwork->tp_no_touch = FALSE;
		break;
	}
}
static void ZknSortSearchSubButtonSelectSetType2( ZKN_SORTSEARCHSUB_WORK* p_work, int type )
{
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/19
	// ^Cv̕я܏\]̏
	switch( type ){
	case ZKN_POKELIST_SEARCH_TYPE_FIRE:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_FIRE ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_FIRE ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_WATER:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_WATER ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_WATER ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_KUSA:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KUSA ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KUSA ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_ELECTRIC:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_ELEC ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_ELEC ] = BMN_EVENT_RELEASE;
			}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_SP:		
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_SP ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_SP ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_KOORI:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KOORI ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KOORI ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_DRAGON:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_DRAGON ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_DRAGON ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_TYPE_AKU:	
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_AKU ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_AKU ] = BMN_EVENT_RELEASE;
		}
		break;
	default:
		break;
	}
	// ----------------------------------------------------------------------------
}

//----------------------------------------------------------------------------
/**
 *	@brief	
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonMakeForm( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int heap )
{
	int i, j;
	int x, y;
	// e[u쐬
	p_work->hit_tbl_sub = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_SORTSEARCHSUB_BUTTON_FORM_NUM );

	// eWOAM쐬
	for( i=0; i<5; i++ ){
		y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		for( j=0; j<3; j++ ){
			x = ZKN_SORTSEARCHSUB_BUTTON_FORM_DEF_X + (j * ZKN_SORTSEARCHSUB_BUTTON_FORM_OFS_X);

			// e[uf[^ݒ
			ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl_sub[ (i*3)+j ],
					y - (ZKN_SORTSEARCHSUB_BUTTON_FORM_SIZY/2),
					y + (ZKN_SORTSEARCHSUB_BUTTON_FORM_SIZY/2),
					x - (ZKN_SORTSEARCHSUB_BUTTON_FORM_SIZX/2),
					x + (ZKN_SORTSEARCHSUB_BUTTON_FORM_SIZX/2) );
		}
	}
	
	p_work->button_work.p_glb = p_glb;
	p_work->button_work.p_work = p_work;

	// {^}l[W쐬
	p_work->p_button_man_sub = BMN_Create( 
			p_work->hit_tbl_sub,
			ZKN_SORTSEARCHSUB_BUTTON_FORM_NUM,
			ZknSortSearchSubButtonCallBackForm,
			&p_work->button_work,
			heap );
}
static void ZknSortSearchSubButtonMoveForm( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int i;
	
	// ꂽSẴ{^̊Gɖ߂
	for( i = 0; i < ZKN_SORTSEARCHSUB_BUTTON_FORM_NUM; i++ ){
		p_work->button_event_sub[ i ] = BMN_EVENT_SLIDEOUT;
	}
	
	BMN_Main( p_work->p_button_man_sub );

	switch( ZKN_SortSearchAplFormTypeGet( p_glb->p_main_apl ) ){
	case ZKN_POKELIST_SEARCH_FORM_FOUR_LEGS:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_LEGS ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_LEGS ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_TWO_LEGS:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_LEGS ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_LEGS ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_TAIL:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_TAIL ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_TAIL ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_HARABAI:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_HARABAI ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_HARABAI ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_FOUR_WING:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_WING ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_WING ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_TWO_WING:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_WING ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_WING ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_HAITSUKUBARI:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_HAITSUKUBARI ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_HAITSUKUBARI ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_STRAIGHT:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_STRAIGHT ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_STRAIGHT ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_ARM:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_ARM ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_ARM ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_LEGS:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_LEGS ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_LEGS ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_MANY_LEGS:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_MANY_LEGS ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_MANY_LEGS ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_WATER:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_WATER ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_WATER ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_CIRCLE:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_CIRCLE ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_CIRCLE ] = BMN_EVENT_RELEASE;
		}
		break;
	case ZKN_POKELIST_SEARCH_FORM_COMP:
		if( p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_COMP ] != BMN_EVENT_HOLD ){
			p_work->button_event_sub[ ZKN_SORTSEARCHSUB_BUTTON_FORM_COMP ] = BMN_EVENT_RELEASE;
		}
		break;

	default:
		break;
	}
}
static void ZknSortSearchSubButtonCallBackForm( u32 button_no, u32 event, void* p_work )
{
	ZKN_SORTSEARCHSUB_BUTTON_WORK* p_button_work = p_work;
	ZKN_SORTSEARCHSUB_GLB* p_glb = p_button_work->p_glb;
	ZKN_SORTSEARCHSUB_WORK* p_subwork = p_button_work->p_work;

	// {^Cxgi[
	p_subwork->button_event_sub[ button_no ] = event;
	
	switch( event ){
	case BMN_EVENT_HOLD:
		p_subwork->do_flag_select = button_no;
		break;

	default:
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	J[\f[^쐬
 *	
 *	@param	p_work	[N
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *	@brief	J[\
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
// ʃ{^
static void ZknSortSearchSubCursorCommonSet( ZKN_CURSOR_ONEDATA* p_data, int id )
{
	int x, y;
	int size_x, size_y;

	switch( id ){
	case ZKN_SORTSEARCHSUB_CURSOR_ID_BACK:
		x = ZKN_SORTSEARCHSUB_BUTTON_BACK_X;
		y = ZKN_SORTSEARCHSUB_BUTTON_BACK_Y;
		size_x = ZKN_SORTSEARCHSUB_CURSOR_BACK_SIZX;
		size_y = ZKN_SORTSEARCHSUB_CURSOR_BACK_SIZY;
		break;
		
	case ZKN_SORTSEARCHSUB_CURSOR_ID_NARABI:
		x = ZKN_SORTSEARCHSUB_BUTTON_X;
		y = ZKN_SORTSEARCHSUB_BUTTON_NARABI_Y;
		size_x = ZKN_SORTSEARCHSUB_CURSOR_SIZX;
		size_y = ZKN_SORTSEARCHSUB_CURSOR_SIZY;
		break;
		
	case ZKN_SORTSEARCHSUB_CURSOR_ID_NAME:
		x = ZKN_SORTSEARCHSUB_BUTTON_X;
		y = ZKN_SORTSEARCHSUB_BUTTON_NAME_Y;
		size_x = ZKN_SORTSEARCHSUB_CURSOR_SIZX;
		size_y = ZKN_SORTSEARCHSUB_CURSOR_SIZY;
		break;
		
	case ZKN_SORTSEARCHSUB_CURSOR_ID_TYPE:
		x = ZKN_SORTSEARCHSUB_BUTTON_X;
		y = ZKN_SORTSEARCHSUB_BUTTON_TYPE_Y;
		size_x = ZKN_SORTSEARCHSUB_CURSOR_SIZX;
		size_y = ZKN_SORTSEARCHSUB_CURSOR_SIZY;
		break;
		
	case ZKN_SORTSEARCHSUB_CURSOR_ID_FORM:
		x = ZKN_SORTSEARCHSUB_BUTTON_X;
		y = ZKN_SORTSEARCHSUB_BUTTON_FORM_Y;
		size_x = ZKN_SORTSEARCHSUB_CURSOR_SIZX;
		size_y = ZKN_SORTSEARCHSUB_CURSOR_SIZY;
		break;
		
	case ZKN_SORTSEARCHSUB_CURSOR_ID_ACTION:
		x = ZKN_SORTSEARCHSUB_BUTTON_ACTION_X;
		y = ZKN_SORTSEARCHSUB_BUTTON_ACTION_Y;
		size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
		size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
		break;
	}
	// J[\ړf[^ݒ
	ZKN_CURSOR_SetOneData( 
			p_data,
			x, 
			y,
			size_x,
			size_y,
			ZKN_CURSOR_MOVE_NORMAL,
			ZKN_CURSOR_MOVE_NORMAL,
			id );

}
//----------------------------------------------------------------------------
/**
 *	@brief	ʃ{^
 *
 *	@param	p_work	ް[N
 *	@param	p_glb	ްO[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorMoveCommon( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	// J[\ʒű@\s
	// ʕꂽ͈ꏏ
	if( sys.cont & PAD_BUTTON_A ){

		if( p_work->cursor_no_touch == FALSE ){

			switch( ZKN_CURSOR_GetContID( p_work->p_cursor ) ){
			case ZKN_SORTSEARCHSUB_CURSOR_ID_NARABI:
				p_work->do_flag_common = ZKN_SORTSEARCHSUB_BUTTON_NARABI;
				p_work->button_event[ p_work->do_flag_common ] = BMN_EVENT_HOLD;
				break;
				
			case ZKN_SORTSEARCHSUB_CURSOR_ID_NAME:
				p_work->do_flag_common = ZKN_SORTSEARCHSUB_BUTTON_NAME;
				p_work->button_event[ p_work->do_flag_common ] = BMN_EVENT_HOLD;
				break;
				
			case ZKN_SORTSEARCHSUB_CURSOR_ID_TYPE:
				p_work->do_flag_common = ZKN_SORTSEARCHSUB_BUTTON_TYPE;
				p_work->button_event[ p_work->do_flag_common ] = BMN_EVENT_HOLD;
				break;
				
			case ZKN_SORTSEARCHSUB_CURSOR_ID_FORM:
				p_work->do_flag_common = ZKN_SORTSEARCHSUB_BUTTON_FORM;
				p_work->button_event[ p_work->do_flag_common ] = BMN_EVENT_HOLD;
				break;

			case ZKN_SORTSEARCHSUB_CURSOR_ID_ACTION:
				p_work->do_flag_common = ZKN_SORTSEARCHSUB_BUTTON_ACTION;
				p_work->button_event[ p_work->do_flag_common ] = BMN_EVENT_HOLD;
				break;
				
			case ZKN_SORTSEARCHSUB_CURSOR_ID_BACK:
				p_work->do_flag_common = ZKN_SORTSEARCHSUB_BUTTON_BACK;
				p_work->button_event[ p_work->do_flag_common ] = BMN_EVENT_HOLD;
				break;

			default:
				break;
			}

			p_work->req_count ++;
		}

	}else{
		p_work->req_count = 0;

		p_work->cursor_no_touch = FALSE;	// PAD_BUTTON_A͂Ȃ
	}

	// B{^Ń|PXgɖ߂
	if(sys.trg & PAD_BUTTON_B){
		p_work->do_flag_common = ZKN_SORTSEARCHSUB_BUTTON_BACK;
		p_work->button_event[ p_work->do_flag_common ] = BMN_EVENT_HOLD;
	}

}

// ĉ
static void ZknSortSearchSubCursorMakeSort( ZKN_SORTSEARCHSUB_WORK* p_work, int heap )
{
	int i, j;
	int x, y;
	int move_type;
	int id;

	p_work->p_cursor_tbl = sys_AllocMemory( heap, sizeof(ZKN_CURSOR_ONEDATA) * (ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X * ZKN_SORTSEARCHSUB_CURSOR_MAX_Y) );

	//@J[\ް쐬
	for( i=0; i<ZKN_SORTSEARCHSUB_CURSOR_MAX_Y; i++ ){
		y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		
		for( j=0; j<ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X; j++ ){	
		
			x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));
			id = ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_00 + (i * (ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X - 1)) + j;

			// sɂi[f[^ύX
			switch( i ){
			case ZKN_SORTSEARCHSUB_BUTTON_BACK:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_BACK;
				}else{
					move_type = ZKN_CURSOR_MOVE_STOP;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_NARABI:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_NARABI;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_NAME:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_NAME;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_TYPE:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_TYPE;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_FORM;
				}else{
					move_type = ZKN_CURSOR_MOVE_STOP;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_ACTION:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_ACTION;
				}else{
					move_type = ZKN_CURSOR_MOVE_STOP;
				}
				break;
			}

			// I߃{^
			if( j < (ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X - 1) ){
				// J[\ړf[^ݒ
				ZKN_CURSOR_SetOneData( 
						&p_work->p_cursor_tbl[ (i*ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X) + j ],
						x, y,
						ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX, 
						ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY,
						move_type, move_type,
						id );
			}else{
				// p{^
				ZknSortSearchSubCursorCommonSet( 
						&p_work->p_cursor_tbl[ (i*ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X) + j ],
						id );
			}
		}
	}


	// J[\f[^ݒ
	p_work->p_cursor = ZKN_CURSOR_Alloc( heap );
	ZKN_CURSOR_Init( p_work->p_cursor, p_work->p_cursor_tbl,
			ZKN_SORTSEARCHSUB_CURSOR_NARABI_MAX_X,
			ZKN_SORTSEARCHSUB_CURSOR_MAX_Y );
}
static void ZknSortSearchSubCursorMoveSort( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	if( sys.cont & PAD_BUTTON_A ){

		if( p_work->cursor_no_touch == FALSE ){

			switch( ZKN_CURSOR_GetContID( p_work->p_cursor ) ){
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_02:		// 01̓_~[
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUMBER;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_03:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NARABI_AIUEO;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_04:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NARABI_HEAVY;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_05:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NARABI_LIGHT;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_06:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NARABI_TALL;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_07:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NARABI_SHORT;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
				
			default:
				break;
			}
		}

	}else{
		p_work->cursor_no_touch = FALSE;	// PAD_BUTTON_A͂Ȃ
	}
}

// O
static void ZknSortSearchSubCursorMakeName( ZKN_SORTSEARCHSUB_WORK* p_work, int heap )
{
	int i, j;
	int x, y;
	int move_type;
	int id;
	p_work->p_cursor_tbl = sys_AllocMemory( heap, sizeof(ZKN_CURSOR_ONEDATA) * (ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X * ZKN_SORTSEARCHSUB_CURSOR_MAX_Y) );

	//@J[\ް쐬
	for( i=0; i<ZKN_SORTSEARCHSUB_CURSOR_MAX_Y; i++ ){
		y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		
		for( j=0; j<ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X; j++ ){	
		
			x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));
			id = ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_00 + (i * 2) + j;

			// sɂi[f[^ύX
			switch( i ){
			case ZKN_SORTSEARCHSUB_BUTTON_BACK:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_BACK;
				}else{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/11/09
// ؍̃\[gɑΉ
#if PM_LANG == LANG_KOREA
					move_type = ZKN_CURSOR_MOVE_STOP;
#else
					move_type = ZKN_CURSOR_MOVE_NORMAL;
#endif
// ----------------------------------------------------------------------------
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_NARABI:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_NARABI;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_NAME:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_NAME;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_TYPE:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_TYPE;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_FORM;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_ACTION:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_ACTION;
				}else{
					move_type = ZKN_CURSOR_MOVE_STOP;
				}
				break;
			}

			// I߃{^
			if( j < (ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X - 1) ){
				// J[\ړf[^ݒ
				ZKN_CURSOR_SetOneData( 
						&p_work->p_cursor_tbl[ (i*ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X) + j ],
						x, y,
						ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX, 
						ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY,
						move_type, move_type,
						id );
			}else{
				// p{^
				ZknSortSearchSubCursorCommonSet( 
						&p_work->p_cursor_tbl[ (i*ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X) + j ],
						id );
			}
		}
	}

	// J[\f[^ݒ
	p_work->p_cursor = ZKN_CURSOR_Alloc( heap );
	ZKN_CURSOR_Init( p_work->p_cursor, p_work->p_cursor_tbl,
			ZKN_SORTSEARCHSUB_CURSOR_NAME_MAX_X,
			ZKN_SORTSEARCHSUB_CURSOR_MAX_Y );
}
static void ZknSortSearchSubCursorMoveName( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	if( sys.cont & PAD_BUTTON_A ){
		if( p_work->cursor_no_touch == FALSE ){

			switch( ZKN_CURSOR_GetContID( p_work->p_cursor ) ){
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/11/09
// ؍̃\[gɑΉ
#if PM_LANG == LANG_KOREA
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_02:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_A;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_03:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_HA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_04:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_KA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_05:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_MA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_06:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_SA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_07:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_RA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_08:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_TA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_09:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_NONE;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
#else
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_00:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_A;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_01:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_HA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_02:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_KA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_03:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_MA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_04:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_SA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_05:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_RA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_06:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_TA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_07:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_YAWA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_08:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_NA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_09:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_NAME_NONE;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
#endif
// ----------------------------------------------------------------------------
			default:
				break;
			}
		}

	}else{

		p_work->cursor_no_touch = FALSE;
	}
}

// 1
static void ZknSortSearchSubCursorMakeType1( ZKN_SORTSEARCHSUB_WORK* p_work, int heap )
{
	int i, j;
	int x, y;
	int size_x, size_y;
	int move_type;
	int id;
	p_work->p_cursor_tbl = sys_AllocMemory( heap, sizeof(ZKN_CURSOR_ONEDATA) * (ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X * ZKN_SORTSEARCHSUB_CURSOR_MAX_Y) );

	//@J[\ް쐬
	for( i=0; i<ZKN_SORTSEARCHSUB_CURSOR_MAX_Y; i++ ){
		y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		
		for( j=0; j<ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X; j++ ){	
		
			x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));
			id = ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_00 + (i * 2) + j;

			// sɂi[f[^ύX
			switch( i ){
			case ZKN_SORTSEARCHSUB_BUTTON_BACK:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_BACK;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
					size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
					size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_NARABI:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_NARABI;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
					size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
					size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_NAME:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_NAME;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
					size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
					size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_TYPE:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_TYPE;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
					size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
					size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_FORM;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
					size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
					size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_ACTION:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_ACTION;
				}else{
					if( j == 0 ){
						move_type = ZKN_CURSOR_MOVE_NORMAL;
						size_x = ZKN_SORTSEARCHSUB_CURSOR_PAGE_SIZX;
						size_y = ZKN_SORTSEARCHSUB_CURSOR_PAGE_SIZY;
						x = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2_X;	
					}else{
						move_type = ZKN_CURSOR_MOVE_STOP;
						size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
						size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
					}
				}
				break;
			}

			// I߃{^
			if( j < (ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X - 1) ){
				// J[\ړf[^ݒ
				ZKN_CURSOR_SetOneData( 
						&p_work->p_cursor_tbl[ (i*ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X) + j ],
						x, y,
						size_x, 
						size_y,
						move_type, move_type,
						id );
			}else{
				// p{^
				ZknSortSearchSubCursorCommonSet( 
						&p_work->p_cursor_tbl[ (i*ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X) + j ],
						id );
			}
		}
	}

	// J[\f[^ݒ
	p_work->p_cursor = ZKN_CURSOR_Alloc( heap );
	ZKN_CURSOR_Init( p_work->p_cursor, p_work->p_cursor_tbl,
			ZKN_SORTSEARCHSUB_CURSOR_TYPE1_MAX_X,
			ZKN_SORTSEARCHSUB_CURSOR_MAX_Y );
}
static void ZknSortSearchSubCursorMoveType1( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	if( sys.cont & PAD_BUTTON_A ){

		if( p_work->cursor_no_touch == FALSE ){

			// ----------------------------------------------------------------------------
			// localize_spec_mark(LANG_ALL) imatake 2006/12/19
			// ^Cv̕я܏\]̏
			switch( ZKN_CURSOR_GetContID( p_work->p_cursor ) ){
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_00:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NORMAL;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_01:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_BATTLE;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_02:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HIKOR;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_03:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_DOKU;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_04:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_JIMEN;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_05:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_IWA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_06:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_MUSHI;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_07:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_GHOST;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_08:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HAGANE;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_09:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NONE;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				p_work->cursor_no_touch = TRUE;	// ĂȂ
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_10:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			default:
				break;
			}
			// ----------------------------------------------------------------------------
		}

	}else{

		p_work->cursor_no_touch = FALSE;
	}
}

// 2
static void ZknSortSearchSubCursorMakeType2( ZKN_SORTSEARCHSUB_WORK* p_work, int heap )
{
	int i, j;
	int x, y;
	int size_x, size_y;
	int move_typex, move_typey;
	int id;
	p_work->p_cursor_tbl = sys_AllocMemory( heap, sizeof(ZKN_CURSOR_ONEDATA) * (ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X * ZKN_SORTSEARCHSUB_CURSOR_MAX_Y) );

	//@J[\ް쐬
	for( i=0; i<ZKN_SORTSEARCHSUB_CURSOR_MAX_Y; i++ ){
		y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		
		for( j=0; j<ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X; j++ ){	
		
			x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));
			id = ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_00 + (i * 2) + j;

			// sɂi[f[^ύX
			switch( i ){
			case ZKN_SORTSEARCHSUB_BUTTON_BACK:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_BACK;
				}else{
					move_typex = ZKN_CURSOR_MOVE_NORMAL;
					move_typey = ZKN_CURSOR_MOVE_NORMAL;
					size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
					size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_NARABI:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_NARABI;
				}else{
					move_typex = ZKN_CURSOR_MOVE_NORMAL;
					move_typey = ZKN_CURSOR_MOVE_NORMAL;
					size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
					size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_NAME:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_NAME;
				}else{
					move_typex = ZKN_CURSOR_MOVE_NORMAL;
					move_typey = ZKN_CURSOR_MOVE_NORMAL;
					size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
					size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_TYPE:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_TYPE;
				}else{
					move_typex = ZKN_CURSOR_MOVE_NORMAL;
					move_typey = ZKN_CURSOR_MOVE_NORMAL;
					size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
					size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_FORM;
				}else{
					if( j==0 ){
						move_typex = ZKN_CURSOR_MOVE_STOP;
						move_typey = ZKN_CURSOR_MOVE_SKIP;
						size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
						size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
					}else{
						move_typex = ZKN_CURSOR_MOVE_NORMAL;
						move_typey = ZKN_CURSOR_MOVE_NORMAL;
						size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
						size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
					}
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_ACTION:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_ACTION;
				}else{
					if( j == 0 ){
						move_typex = ZKN_CURSOR_MOVE_NORMAL;
						move_typey = ZKN_CURSOR_MOVE_NORMAL;
						size_x = ZKN_SORTSEARCHSUB_CURSOR_PAGE_SIZX;
						size_y = ZKN_SORTSEARCHSUB_CURSOR_PAGE_SIZY;
						x = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1_X;
					}else{
						move_typex = ZKN_CURSOR_MOVE_STOP;
						move_typey = ZKN_CURSOR_MOVE_STOP;
						size_x = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZX;
						size_y = ZKN_SORTSEARCHSUB_CURSOR_ACTION_SIZY;
					}
				}
				break;
			}

			// I߃{^
			if( j < (ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X - 1) ){
				// J[\ړf[^ݒ
				ZKN_CURSOR_SetOneData( 
						&p_work->p_cursor_tbl[ (i*ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X) + j ],
						x, y,
						size_x, 
						size_y,
						move_typex, move_typey,
						id );
			}else{
				// p{^
				ZknSortSearchSubCursorCommonSet( 
						&p_work->p_cursor_tbl[ (i*ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X) + j ],
						id );
			}
		}
	}

	// J[\f[^ݒ
	p_work->p_cursor = ZKN_CURSOR_Alloc( heap );
	ZKN_CURSOR_Init( p_work->p_cursor, p_work->p_cursor_tbl,
			ZKN_SORTSEARCHSUB_CURSOR_TYPE2_MAX_X,
			ZKN_SORTSEARCHSUB_CURSOR_MAX_Y );
}
static void ZknSortSearchSubCursorMoveType2( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	if( sys.cont & PAD_BUTTON_A ){
		if( p_work->cursor_no_touch == FALSE ){

			// ----------------------------------------------------------------------------
			// localize_spec_mark(LANG_ALL) imatake 2006/12/19
			// ^Cv̕я܏\]̏
			switch( ZKN_CURSOR_GetContID( p_work->p_cursor ) ){
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_00:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_FIRE;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_01:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_WATER;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_02:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KUSA;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_03:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_ELEC;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_04:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_SP;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_05:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KOORI;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_06:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_DRAGON;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_07:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_AKU;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_09:		// W̓_~[
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NONE;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				p_work->cursor_no_touch = TRUE;	// ĂȂ
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_10:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			default:
				break;
			}
			// ----------------------------------------------------------------------------
		}

	}else{

		p_work->cursor_no_touch = FALSE;
	}
}

// `
static void ZknSortSearchSubCursorMakeForm( ZKN_SORTSEARCHSUB_WORK* p_work, int heap )
{
	int i, j;
	int x, y;
	int move_type;
	int id;
	p_work->p_cursor_tbl = sys_AllocMemory( heap, sizeof(ZKN_CURSOR_ONEDATA) * (ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X * ZKN_SORTSEARCHSUB_CURSOR_MAX_Y) );


	//@J[\ް쐬
	for( i=0; i<ZKN_SORTSEARCHSUB_CURSOR_MAX_Y; i++ ){
		y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		
		for( j=0; j<ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X; j++ ){	
		
			x = ZKN_SORTSEARCHSUB_BUTTON_FORM_DEF_X + (j * ZKN_SORTSEARCHSUB_BUTTON_FORM_OFS_X);
			id = ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_00 + (i * (ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X - 1)) + j;

			// sɂi[f[^ύX
			switch( i ){
			case ZKN_SORTSEARCHSUB_BUTTON_BACK:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_BACK;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_NARABI:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_NARABI;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_NAME:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_NAME;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_TYPE:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_TYPE;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_FORM;
				}else{
					move_type = ZKN_CURSOR_MOVE_NORMAL;
				}
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_ACTION:
				if( j == (ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X - 1) ){
					id = ZKN_SORTSEARCHSUB_CURSOR_ID_ACTION;
				}else{
					move_type = ZKN_CURSOR_MOVE_STOP;
				}
				break;
			}

			// I߃{^
			if( j < (ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X - 1) ){
				// J[\ړf[^ݒ
				ZKN_CURSOR_SetOneData( 
						&p_work->p_cursor_tbl[ (i*ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X) + j ],
						x, y,
						ZKN_SORTSEARCHSUB_CURSOR_FORM_SIZX, 
						ZKN_SORTSEARCHSUB_CURSOR_FORM_SIZY,
						move_type, move_type,
						id );
			}else{
				// p{^
				ZknSortSearchSubCursorCommonSet( 
						&p_work->p_cursor_tbl[ (i*ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X) + j ],
						id );
			}
		}
	}

	// J[\f[^ݒ
	p_work->p_cursor = ZKN_CURSOR_Alloc( heap );
	ZKN_CURSOR_Init( p_work->p_cursor, p_work->p_cursor_tbl,
			ZKN_SORTSEARCHSUB_CURSOR_FORM_MAX_X,
			ZKN_SORTSEARCHSUB_CURSOR_MAX_Y );
}
static void ZknSortSearchSubCursorMoveForm( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	if( sys.cont & PAD_BUTTON_A ){
		if( p_work->cursor_no_touch == FALSE ){

			switch( ZKN_CURSOR_GetContID( p_work->p_cursor ) ){
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_00:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_CIRCLE;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_01:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_HARABAI;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_02:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_WATER;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_03:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_ARM;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_04:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_STRAIGHT;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_05:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_TAIL;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_06:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_LEGS;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_07:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_LEGS;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_08:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_WING;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_09:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_MANY_LEGS;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_10:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_COMP;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_11:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_LEGS;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_12:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_WING;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_13:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_HAITSUKUBARI;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			case ZKN_SORTSEARCHSUB_SURSOR_ID_OTHER_14:
				p_work->do_flag_select = ZKN_SORTSEARCHSUB_BUTTON_FORM_NONE;
				p_work->button_event_sub[ p_work->do_flag_select ] = BMN_EVENT_HOLD;
				break;
			default:
				break;
			}
		}
	}else{
		p_work->cursor_no_touch = FALSE;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\ʓ
 *
 *	@param	p_work
 *	@param	p_glb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorMove( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	
	if( sys.trg & PAD_KEY_RIGHT ){
		ZKN_CURSOR_Cont( p_work->p_cursor, ZKN_CURSOR_CONT_ADD_X, 1 );
		p_work->cursor_no_touch = TRUE;	// PAD_BUTTON_AĂȂ
		//		Snd_SePlay( ZKN_SND_SELECT );
	}

	if( sys.trg & PAD_KEY_LEFT ){
		ZKN_CURSOR_Cont( p_work->p_cursor, ZKN_CURSOR_CONT_ADD_X, -1 );
		p_work->cursor_no_touch = TRUE;	// PAD_BUTTON_AĂȂ
//		Snd_SePlay( ZKN_SND_SELECT );
	}

	if( sys.trg & PAD_KEY_UP ){
		ZKN_CURSOR_Cont( p_work->p_cursor, ZKN_CURSOR_CONT_ADD_Y, -1 );
		p_work->cursor_no_touch = TRUE;	// PAD_BUTTON_AĂȂ
//		Snd_SePlay( ZKN_SND_SELECT );
	}

	if( sys.trg & PAD_KEY_DOWN ){
		ZKN_CURSOR_Cont( p_work->p_cursor, ZKN_CURSOR_CONT_ADD_Y, 1 );
		p_work->cursor_no_touch = TRUE;	// PAD_BUTTON_AĂȂ
//		Snd_SePlay( ZKN_SND_SELECT );
	}

	// ʓ
	ZknSortSearchSubCursorMoveCommon( p_work, p_glb );


	// Iʓ
	ZknSortSearchSubCursorMoveSub( p_work, p_glb, p_work->local_select, p_work->local_type_page );
}

//----------------------------------------------------------------------------
/**
 *	@brief	IߕʃJ[\
 *
 *	@param	p_work			[Nް
 *	@param	p_glb			O[oް
 *	@param	select_type		ZNg
 *	@param	type_page		߂̃y[W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorMoveSub( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int select_type, int type_page )
{
	switch( select_type ){
	case ZKN_SORTSEARCH_SELECT_SORT:
		ZknSortSearchSubCursorMoveSort( p_work, p_glb );
		break;
		
	case ZKN_SORTSEARCH_SELECT_NEME:
		ZknSortSearchSubCursorMoveName( p_work, p_glb );
		break;
		
	case ZKN_SORTSEARCH_SELECT_TYPE:
		if( type_page == 0 ){
			ZknSortSearchSubCursorMoveType1( p_work, p_glb );
		}else{
			ZknSortSearchSubCursorMoveType2( p_work, p_glb );
		}
		break;
		
	case ZKN_SORTSEARCH_SELECT_FORM:
		ZknSortSearchSubCursorMoveForm( p_work, p_glb );
		break;
		
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\f[^j
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorDelete( ZKN_SORTSEARCHSUB_WORK* p_work )
{
	sys_FreeMemoryEz( p_work->p_cursor_tbl );
	ZKN_CURSOR_Free( p_work->p_cursor );
	p_work->p_cursor = NULL;
	p_work->p_cursor_tbl = NULL;
}


//----------------------------------------------------------------------------
/**
 *	@brief	J[\̏쐬
 *
 *	@param	p_work	[N
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorMake( ZKN_SORTSEARCHSUB_WORK* p_work, int heap )
{
	ZknSortSearchSubCursorMakeSub( p_work, heap, p_work->local_select, p_work->local_type_page );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Iߕʍ쐬
 *
 *	@param	p_work			[N
 *	@param	heap			q[v
 *	@param	select_type		I
 *	@param	type_page		߃y[W
 *
 *	@return	none
 */	
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorMakeSub( ZKN_SORTSEARCHSUB_WORK* p_work, int heap, int select_type, int type_page )
{
	switch( select_type ){
	case ZKN_SORTSEARCH_SELECT_SORT:
		ZknSortSearchSubCursorMakeSort( p_work, heap );
		break;
		
	case ZKN_SORTSEARCH_SELECT_NEME:
		ZknSortSearchSubCursorMakeName( p_work, heap );
		break;
		
	case ZKN_SORTSEARCH_SELECT_TYPE:
		if( type_page == 0 ){
			ZknSortSearchSubCursorMakeType1( p_work, heap );
		}else{
			ZknSortSearchSubCursorMakeType2( p_work, heap );
		}
		break;
		
	case ZKN_SORTSEARCH_SELECT_FORM:
		ZknSortSearchSubCursorMakeForm( p_work, heap );
		break;
		
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\
 *
 *	@param	p_work
 *	@param	p_glb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorInit( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int cursor_id; 
	
	switch( p_work->local_select ){
	case ZKN_SORTSEARCH_SELECT_SORT:
		cursor_id = ZKN_SORTSEARCHSUB_CURSOR_ID_NARABI;
		break;
		
	case ZKN_SORTSEARCH_SELECT_NEME:
		cursor_id = ZKN_SORTSEARCHSUB_CURSOR_ID_NAME;
		break;
		
	case ZKN_SORTSEARCH_SELECT_TYPE:
		cursor_id = ZKN_SORTSEARCHSUB_CURSOR_ID_TYPE;
		break;
		
	case ZKN_SORTSEARCH_SELECT_FORM:
		cursor_id = ZKN_SORTSEARCHSUB_CURSOR_ID_FORM;
		break;
	default:
		GF_ASSERT(0);
		break;
	}
	
	ZKN_CURSOR_Cont( p_work->p_cursor, ZKN_CURSOR_CONT_SET_CONTID, cursor_id );
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\ύX
 *
 *	@param	p_work
 *	@param	heap 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorChg( ZKN_SORTSEARCHSUB_WORK* p_work, int heap )
{
	// ܂ł̃J[\ްj
	ZknSortSearchSubCursorDelete( p_work );

	// 쐬
	ZknSortSearchSubCursorMakeSub( p_work, heap, p_work->local_select, p_work->local_type_page );
}




//----------------------------------------------------------------------------
/**
 *	@brief	J[\
 *
 *	@param	p_drawglb	`O[o
 *	@param	cp_work		f[^[N
 *	@param	cp_glb		f[^O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorDrawInit( ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_WORK* cp_work, const ZKN_SORTSEARCHSUB_GLB* cp_glb )
{
	// J[\Wݒ
	ZKN_UTIL_CursorSetMatrixCursorSysNotAnm( cp_work->p_cursor, p_drawglb->p_drawglb );
	// J[\
	ZknSortSearchSubCursorDrawPack( p_drawglb, cp_work, cp_glb );
}



//----------------------------------------------------------------------------
/**
 *	@brief	J[\`揈pbN֐
 *
 *	@param	p_drawglb	`O[o
 *	@param	cp_work		f[^[N
 *	@param	cp_glb		f[^O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorDrawPack( ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_WORK* cp_work, const ZKN_SORTSEARCHSUB_GLB* cp_glb )
{
	BOOL check;
	
	//@\nmneeƃJ[\
	if( (ZKN_GLBDATA_TouchCursorFlagGet( cp_glb->p_glb ) == TRUE) ){

		check = ZknSortSearchSubCursorOnOff( p_drawglb, TRUE );

		if( check ){
			// ĕ`悳ꂽƂ,J[\`W
			// J[\Wݒ
			ZKN_UTIL_CursorSetMatrixCursorSysNotAnm( cp_work->p_cursor, p_drawglb->p_drawglb );
		}

		ZknSortSearchSubCursorDraw( p_drawglb, cp_work );
	}else{
		ZknSortSearchSubCursorOnOff( p_drawglb, FALSE );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӃJ[\`揈
 *
 *	@param	p_drawglb	`O[o
 *	@param	p_work		f[^[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubCursorDraw( ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_WORK* cp_work )
{
	ZKN_GLB_DRAWDATA* p_draw = p_drawglb->p_drawglb;
	
	ZKN_UTIL_CursorSetMatrixCursorSys( cp_work->p_cursor, p_draw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[\`ONOFF
 *
 *	@param	p_draw	`惏[N
 *	@param	flag	ONOFFtO
 *	
 *	@retval	TRUE	lύX
 *	@retval	FALSE	ύXȂ
 */
//-----------------------------------------------------------------------------
static BOOL ZknSortSearchSubCursorOnOff( ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb,  BOOL flag )
{
	ZKN_GLB_DRAWDATA* p_draw = p_drawglb->p_drawglb;
	
	if( ZKN_UTIL_CursorGetDrawFlag( &p_draw->cursor ) != flag ){
		ZKN_UTIL_CursorSetDrawFlag( &p_draw->cursor, flag );
		return TRUE;
	}
	
	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	TuOAMResourceǂݍ
 *
 *	@param	p_draw			`惏[N
 *	@param	p_drawglb		`O[΂
 *	@param	heap			q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubLoadOam( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;
	ARCHANDLE* p_handle = ZKN_GLBDATA_ArcHandlGet( p_drawglb->p_drawglb );
	
	// LN^f[^ǂݍ
	p_draw->res_obj[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ], p_handle,
			NARC_zukan_zkn_sort_oam_sub_lzh_NCGR, TRUE,
			NARC_zukan_zkn_sort_oam_sub_lzh_NCGR + ZKN_SORTSEARCHSUB_RES_ID,
			NNS_G2D_VRAM_TYPE_2DSUB, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_draw->res_obj[ CLACT_U_CHAR_RES ] );

	// pbgf[^ǂݍ
	p_draw->res_obj[ CLACT_U_PLTT_RES ] = CLACT_U_ResManagerResAddArcPltt_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ], p_handle,
			NARC_zukan_zkn_list_oam_NCLR, FALSE, 
			NARC_zukan_zkn_list_oam_NCLR + ZKN_SORTSEARCHSUB_RES_ID, 
			NNS_G2D_VRAM_TYPE_2DSUB, 
			ZKN_ZUKAN_COMMON_PLTT_SUB_LOAD, heap );
	// ]
	CLACT_U_PlttManagerSetCleanArea( p_draw->res_obj[ CLACT_U_PLTT_RES ] );	
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_draw->res_obj[ CLACT_U_PLTT_RES ] );


	// Zf[^ǂݍ
	p_draw->res_obj[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ], p_handle,
			NARC_zukan_zkn_sort_oam_sub_lzh_NCER, TRUE,
			NARC_zukan_zkn_sort_oam_sub_lzh_NCER + ZKN_SORTSEARCHSUB_RES_ID,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_draw->res_obj[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ], p_handle, 
			NARC_zukan_zkn_sort_oam_sub_lzh_NANR, TRUE,
			NARC_zukan_zkn_sort_oam_sub_lzh_NANR + ZKN_SORTSEARCHSUB_RES_ID,
			CLACT_U_CELLANM_RES, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	TuOAMResourcej
 *
 *	@param	p_draw			`惏[N
 *	@param	p_drawglb		`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubReleaseOam( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;


	CLACT_U_CharManagerDelete( p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_PlttManagerDelete( p_draw->res_obj[ CLACT_U_PLTT_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw->res_obj[ CLACT_U_PLTT_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw->res_obj[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			p_draw->res_obj[ CLACT_U_CELLANM_RES ] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`OAMǂݍ
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubLoadOamForm( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;
	ARCHANDLE* p_handle = ZKN_GLBDATA_ArcHandlGet( p_drawglb->p_drawglb );
	
	// LN^f[^ǂݍ
	p_draw->res_obj_form[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ], p_handle,
			NARC_zukan_zkn_sort_oam_sub2_lzh_NCGR, TRUE,
			NARC_zukan_zkn_sort_oam_sub2_lzh_NCGR + ZKN_SORTSEARCHSUB_RES_ID,
			NNS_G2D_VRAM_TYPE_2DSUB, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_draw->res_obj_form[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_draw->res_obj_form[ CLACT_U_CHAR_RES ] );


	// Zf[^ǂݍ
	p_draw->res_obj_form[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ], p_handle,
			NARC_zukan_zkn_sort_oam_sub2_lzh_NCER, TRUE,
			NARC_zukan_zkn_sort_oam_sub2_lzh_NCER + ZKN_SORTSEARCHSUB_RES_ID,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_draw->res_obj_form[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ], p_handle, 
			NARC_zukan_zkn_sort_oam_sub2_lzh_NANR, TRUE,
			NARC_zukan_zkn_sort_oam_sub2_lzh_NANR + ZKN_SORTSEARCHSUB_RES_ID,
			CLACT_U_CELLANM_RES, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	`OMAj
 *
 *	@param	p_draw
 *	@param	p_drawglb 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubReleaseOamForm( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;


	CLACT_U_CharManagerDelete( p_draw->res_obj_form[ CLACT_U_CHAR_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw->res_obj_form[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw->res_obj_form[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			p_draw->res_obj_form[ CLACT_U_CELLANM_RES ] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	AN^[o^
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddClact( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	ZKN_GLB_DRAWDATA*	p_draw_glb = p_drawglb->p_drawglb;
	int i;
	
	// e{^o^
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			NARC_zukan_zkn_sort_oam_sub_lzh_NCGR + ZKN_SORTSEARCHSUB_RES_ID,
			NARC_zukan_zkn_list_oam_NCLR + ZKN_SORTSEARCHSUB_RES_ID, 
			NARC_zukan_zkn_sort_oam_sub_lzh_NCER + ZKN_SORTSEARCHSUB_RES_ID,
			NARC_zukan_zkn_sort_oam_sub_lzh_NANR + ZKN_SORTSEARCHSUB_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, 0,
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^ʕݒ
	add.ClActSet	= p_draw_glb->clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= 32;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
	add.heap		= heap;

	// ްo^
	ZknSortSearchSubAddClactCommon( p_draw, &add );

	// Tuްo^
	ZknSortSearchSubAddSubClact( p_draw, &add, p_draw->local_select, p_draw->local_type_page );
}

//----------------------------------------------------------------------------
/**
 *	@brief	AN^[j
 *
 *	@param	p_draw		`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDeleteClact( ZKN_SORTSEARCHSUB_DRAW* p_draw )
{
	ZknSortSearchSubDeleteClactCommon( p_draw );

	// IߕʃAN^[j
	ZknSortSearchSubDeleteClactSub( p_draw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ZNg߂ύXꂽ̂ŁAZAN^[ύX
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubChgClact( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	ZKN_GLB_DRAWDATA*	p_draw_glb = p_drawglb->p_drawglb;
	int i;
	
	// e{^o^
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			NARC_zukan_zkn_sort_oam_sub_lzh_NCGR + ZKN_SORTSEARCHSUB_RES_ID,
			NARC_zukan_zkn_list_oam_NCLR + ZKN_SORTSEARCHSUB_RES_ID, 
			NARC_zukan_zkn_sort_oam_sub_lzh_NCER + ZKN_SORTSEARCHSUB_RES_ID,
			NARC_zukan_zkn_sort_oam_sub_lzh_NANR + ZKN_SORTSEARCHSUB_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, 0,
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^ʕݒ
	add.ClActSet	= p_draw_glb->clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= 32;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
	add.heap		= heap;


	// ܂ł̂̂j
	ZknSortSearchSubDeleteClactSub( p_draw );

	// Tuްo^
	ZknSortSearchSubAddSubClact( p_draw, &add, p_draw->local_select, p_draw->local_type_page );
}

//----------------------------------------------------------------------------
/**
 *	@brief	TuZAN^[o^֐
 *
 *	@param	p_draw		`惏[N
 *	@param	p_add		o^ް
 *	@param	select_type	ZNg
 *	@param	local_type_page	߂page
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddSubClact( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add, int select_type, int local_type_page )
{
	switch( select_type ){
	case ZKN_SORTSEARCH_SELECT_SORT:
		ZknSortSearchSubAddClactSort( p_draw, p_add );
		break;
	case ZKN_SORTSEARCH_SELECT_NEME:
		ZknSortSearchSubAddClactName( p_draw, p_add );
		break;
	case ZKN_SORTSEARCH_SELECT_TYPE:
		if( local_type_page == 0 ){
			ZknSortSearchSubAddClactType1( p_draw, p_add );
		}else{
			ZknSortSearchSubAddClactType2( p_draw, p_add );
		}
		break;
	case ZKN_SORTSEARCH_SELECT_FORM:
		ZknSortSearchSubAddClactForm( p_draw, p_add );
		break;
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ʕ̃OtBbNZAN^[o^
 *
 *	@param	p_draw		`惏[N
 *	@param	p_add		o^ް@K{ްi[ς
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddClactCommon( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add )
{
	int i;
	
	
	// {^쐬
	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_NUM; i++ ){
		// o^Wݒ
		switch( i ){
		case ZKN_SORTSEARCHSUB_BUTTON_BACK:
			p_add->mat.y		= (ZKN_SORTSEARCHSUB_BUTTON_BACK_Y * FX32_ONE) + SUB_SURFACE_Y;
			p_add->mat.x		= ZKN_SORTSEARCHSUB_BUTTON_BACK_X * FX32_ONE;
			break;

		case ZKN_SORTSEARCHSUB_BUTTON_NARABI:
			p_add->mat.y		= (ZKN_SORTSEARCHSUB_BUTTON_NARABI_Y * FX32_ONE) + SUB_SURFACE_Y;
			p_add->mat.x		= ZKN_SORTSEARCHSUB_BUTTON_X * FX32_ONE;
			break;
			
		case ZKN_SORTSEARCHSUB_BUTTON_NAME:
			p_add->mat.y		= (ZKN_SORTSEARCHSUB_BUTTON_NAME_Y * FX32_ONE) + SUB_SURFACE_Y;
			p_add->mat.x		= ZKN_SORTSEARCHSUB_BUTTON_X * FX32_ONE;
			break;
			
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE:
			p_add->mat.y		= (ZKN_SORTSEARCHSUB_BUTTON_TYPE_Y * FX32_ONE) + SUB_SURFACE_Y;
			p_add->mat.x		= ZKN_SORTSEARCHSUB_BUTTON_X * FX32_ONE;
			break;
			
		case ZKN_SORTSEARCHSUB_BUTTON_FORM:
			p_add->mat.y		= (ZKN_SORTSEARCHSUB_BUTTON_FORM_Y * FX32_ONE) + SUB_SURFACE_Y;
			p_add->mat.x		= ZKN_SORTSEARCHSUB_BUTTON_X * FX32_ONE;
			break;

		case ZKN_SORTSEARCHSUB_BUTTON_ACTION:
			p_add->mat.y		= (ZKN_SORTSEARCHSUB_BUTTON_ACTION_Y * FX32_ONE) + SUB_SURFACE_Y;
			p_add->mat.x		= ZKN_SORTSEARCHSUB_BUTTON_ACTION_X * FX32_ONE;
			break;
		}

		// o^@Aj[Vݒ
		p_draw->clact[ i ] = CLACT_AddSimple( p_add );
		
		// AjV[PXݒ
		switch( i ){
		case ZKN_SORTSEARCHSUB_BUTTON_BACK:
			CLACT_AnmChg( p_draw->clact[ i ], ZKN_SORTSEARCHSUB_RET_BUTTON );
			break;

		case ZKN_SORTSEARCHSUB_BUTTON_NARABI:
		case ZKN_SORTSEARCHSUB_BUTTON_NAME:
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE:
		case ZKN_SORTSEARCHSUB_BUTTON_FORM:
			CLACT_AnmChg( p_draw->clact[ i ], ZKN_SORTSEARCHSUB_SELECT_BUTTON );
			break;

		case ZKN_SORTSEARCHSUB_BUTTON_ACTION:
			CLACT_AnmChg( p_draw->clact[ i ], ZKN_SORTSEARCHSUB_ACTION_BUTTON );
			break;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ʕOAMj
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDeleteClactCommon( ZKN_SORTSEARCHSUB_DRAW* p_draw )
{
	int i;

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_NUM; i++ ){
		CLACT_Delete( p_draw->clact[i] );
	}
}

//-----------------------------------------------------------------------------
/**
 *	@brief	Tu{^AN^[j
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDeleteClactSub( ZKN_SORTSEARCHSUB_DRAW* p_draw )
{
	int i;

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX; i++ ){
		if( p_draw->clact_sub[i] ){
			CLACT_Delete( p_draw->clact_sub[i] );
			p_draw->clact_sub[i] = NULL;
		}
	}
}

//-----------------------------------------------------------------------------
/**
 *	@brief	ĉʓo^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddClactSort( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add )
{
	int i, j;
	
	// eWOAM쐬
	for( i=0; i<3; i++ ){
		p_add->mat.y = ZKN_SORTSEARCHSUB_BUTTON_01_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		p_add->mat.y = (p_add->mat.y << FX32_SHIFT)  + SUB_SURFACE_Y;
		for( j=0; j<2; j++ ){
			p_add->mat.x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));

			p_add->mat.x <<= FX32_SHIFT;
			p_draw->clact_sub[ (i*2) + j ] = CLACT_AddSimple( p_add );
			CLACT_AnmChg( p_draw->clact_sub[ (i*2) + j ], ZKN_SORTSEARCHSUB_MAIN_BUTTON );
		}
	}
}

//-----------------------------------------------------------------------------
/**
 *	@brief	Ȃ܂ʓo^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddClactName( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add )
{
	int i, j;
	
	// eWOAM쐬
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/11/09
// ؍̃\[gɑΉ
	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_NAME_NUM / 2; i++ ){
#if PM_LANG == LANG_KOREA
		p_add->mat.y = ZKN_SORTSEARCHSUB_BUTTON_01_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
#else
		p_add->mat.y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
#endif
// ----------------------------------------------------------------------------
		p_add->mat.y = (p_add->mat.y << FX32_SHIFT)  + SUB_SURFACE_Y;
		for( j=0; j<2; j++ ){
			p_add->mat.x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));

			p_add->mat.x <<= FX32_SHIFT;
			p_draw->clact_sub[ (i*2) + j ] = CLACT_AddSimple( p_add );
			CLACT_AnmChg( p_draw->clact_sub[ (i*2) + j ], ZKN_SORTSEARCHSUB_MAIN_BUTTON );
		}
	}
}

//-----------------------------------------------------------------------------
/**
 *	@brief	1ʓo^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddClactType1( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add )
{
	int i, j;
	
	// eWOAM쐬
	for( i=0; i<5; i++ ){
		p_add->mat.y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		p_add->mat.y = (p_add->mat.y << FX32_SHIFT)  + SUB_SURFACE_Y;
		for( j=0; j<2; j++ ){
			p_add->mat.x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));

			p_add->mat.x <<= FX32_SHIFT;
			p_draw->clact_sub[ (i*2) + j ] = CLACT_AddSimple( p_add );
			CLACT_AnmChg( p_draw->clact_sub[ (i*2) + j ], ZKN_SORTSEARCHSUB_MAIN_BUTTON );
		}
	}
	
	// y[W{^
	p_add->mat.y = ZKN_SORTSEARCHSUB_BUTTON_05_Y;
	p_add->mat.x = ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2_X;
	p_add->mat.x <<= FX32_SHIFT;
	p_add->mat.y = (p_add->mat.y << FX32_SHIFT)  + SUB_SURFACE_Y;
	p_draw->clact_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2 ] = CLACT_AddSimple( p_add );
	CLACT_AnmChg( p_draw->clact_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2 ], ZKN_SORTSEARCHSUB_PAGE_ADD_BUTTON );
}

//-----------------------------------------------------------------------------
/**
 *	@brief	2ʓo^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddClactType2( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add )
{
	int i, j;
	
	// eWOAM쐬
	for( i=0; i<4; i++ ){
		p_add->mat.y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		p_add->mat.y = (p_add->mat.y << FX32_SHIFT)  + SUB_SURFACE_Y;
		for( j=0; j<2; j++ ){
			p_add->mat.x = ZKN_SORTSEARCHSUB_BUTTONDEF_00_X + (j * (ZKN_SORTSEARCHSUB_BUTTONDEF_01_X - ZKN_SORTSEARCHSUB_BUTTONDEF_00_X));

			p_add->mat.x <<= FX32_SHIFT;
			p_draw->clact_sub[ (i*2) + j ] = CLACT_AddSimple( p_add );
			CLACT_AnmChg( p_draw->clact_sub[ (i*2) + j ], ZKN_SORTSEARCHSUB_MAIN_BUTTON );
		}
	}

	// [[[[[{^
	p_add->mat.y = ZKN_SORTSEARCHSUB_BUTTON_04_Y;
	p_add->mat.x = ZKN_SORTSEARCHSUB_BUTTONDEF_01_X;
	p_add->mat.x <<= FX32_SHIFT;
	p_add->mat.y = (p_add->mat.y << FX32_SHIFT)  + SUB_SURFACE_Y;
	p_draw->clact_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NONE ] = CLACT_AddSimple( p_add );
	CLACT_AnmChg( p_draw->clact_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NONE ], ZKN_SORTSEARCHSUB_MAIN_BUTTON );
	
	// y[W{^
	p_add->mat.y = ZKN_SORTSEARCHSUB_BUTTON_05_Y;
	p_add->mat.x = ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1_X;
	p_add->mat.x <<= FX32_SHIFT;
	p_add->mat.y = (p_add->mat.y << FX32_SHIFT)  + SUB_SURFACE_Y;
	p_draw->clact_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1 ] = CLACT_AddSimple( p_add );
	CLACT_AnmChg( p_draw->clact_sub[ ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1 ], ZKN_SORTSEARCHSUB_PAGE_SUB_BUTTON );
}

//-----------------------------------------------------------------------------
/**
 *	@brief	tH[ʓo^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddClactForm( ZKN_SORTSEARCHSUB_DRAW* p_draw, CLACT_ADD_SIMPLE* p_add )
{
	int i, j;
	
	// eWOAM쐬
	for( i=0; i<5; i++ ){
		p_add->mat.y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		p_add->mat.y = (p_add->mat.y << FX32_SHIFT)  + SUB_SURFACE_Y;
		for( j=0; j<3; j++ ){
			p_add->mat.x = ZKN_SORTSEARCHSUB_BUTTON_FORM_DEF_X + (j * ZKN_SORTSEARCHSUB_BUTTON_FORM_OFS_X);

			p_add->mat.x <<= FX32_SHIFT;
			p_draw->clact_sub[ (i*3) + j ] = CLACT_AddSimple( p_add );

			CLACT_AnmChg( p_draw->clact_sub[ (i*3) + j ], ZKN_SORTSEARCHSUB_FORM_BUTTON );
		}
	}
}
//----------------------------------------------------------------------------
/**
 *	@brief	`OAM̊GOAM쐬
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddClactForm_Gra( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	ZKN_GLB_DRAWDATA*	p_draw_glb = p_drawglb->p_drawglb;
	int i, j;
	
	// e{^o^
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			NARC_zukan_zkn_sort_oam_sub2_lzh_NCGR + ZKN_SORTSEARCHSUB_RES_ID,
			NARC_zukan_zkn_list_oam_NCLR + ZKN_SORTSEARCHSUB_RES_ID, 
			NARC_zukan_zkn_sort_oam_sub2_lzh_NCER + ZKN_SORTSEARCHSUB_RES_ID,
			NARC_zukan_zkn_sort_oam_sub2_lzh_NANR + ZKN_SORTSEARCHSUB_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, 0,
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^ʕݒ
	add.ClActSet	= p_draw_glb->clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= 15;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
	add.heap		= heap;


	// eWOAM쐬
	for( i=0; i<5; i++ ){
		add.mat.y = ZKN_SORTSEARCHSUB_BUTTON_00_Y + (i * (ZKN_SORTSEARCHSUB_BUTTON_01_Y - ZKN_SORTSEARCHSUB_BUTTON_00_Y));
		add.mat.y = (add.mat.y << FX32_SHIFT)  + SUB_SURFACE_Y;
		for( j=0; j<3; j++ ){
			add.mat.x = ZKN_SORTSEARCHSUB_BUTTON_FORM_DEF_X + (j * ZKN_SORTSEARCHSUB_BUTTON_FORM_OFS_X);

			add.mat.x <<= FX32_SHIFT;
			p_draw->clact_sub_form[ (i*3) + j ] = CLACT_AddSimple( &add );

			switch( (i*3) + j ){
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_CIRCLE:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_CIRCLE_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_HARABAI:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_HARABAI_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_WATER:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_WATER_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_ARM:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_ARM_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_STRAIGHT:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_STRAIGHT_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_TAIL:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_TAIL_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_LEGS:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_LEGS_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_LEGS:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_FOURLEGS_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_WING:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_TWO_WING_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_MANY_LEGS:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_MANY_LEGS_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_COMP:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_COMP_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_LEGS:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_TWO_LEGS_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_WING:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_FOURWING_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_HAITSUKUBARI:
				CLACT_AnmChg( p_draw->clact_sub_form[ (i*3) + j ], ZKN_SORTSEARCHSUB_HAITSUKUBARI_BUTTON );
				break;
			case ZKN_SORTSEARCHSUB_BUTTON_FORM_NONE:
				CLACT_SetDrawFlag( p_draw->clact_sub_form[ (i*3) + j ], FALSE );
				break;
			}
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	`@OtBbNAN^[j
 *
 *	@param	p_draw 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDeleteClactForm_Gra( ZKN_SORTSEARCHSUB_DRAW* p_draw )
{
	int i;

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX; i++ ){
		if( p_draw->clact_sub_form[ i ] ){
			CLACT_Delete( p_draw->clact_sub_form[ i ] );
			p_draw->clact_sub_form[ i ] = NULL;
		}
	}
}



//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAM쐬
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddFontOam( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap )
{
	ZKN_FONTOAM_INIT fontoam_init;
	CLACT_U_RES_OBJ_PTR res_obj;
	ZKN_GLB_DRAWDATA* p_glb_draw = p_drawglb->p_drawglb;

	// pbg̃\[Xf[^擾
	// pbgvNV擾p
	res_obj = CLACT_U_ResManagerGetIDResObjPtr( p_glb_draw->res_manager[ CLACT_U_PLTT_RES ], NARC_zukan_zkn_list_oam_NCLR + ZKN_SORTSEARCHSUB_RES_ID );

	// f[^̋ʕ쐬
	// ʃf[^
	fontoam_init.zkn_fontoam = p_glb_draw->fontoam_sys;
	fontoam_init.pltt		 = CLACT_U_PlttManagerGetProxy( res_obj, NULL );
	fontoam_init.bg_pri		 = 0;
	fontoam_init.soft_pri	 = 0;
	fontoam_init.draw_area	 = NNS_G2D_VRAM_TYPE_2DSUB;
	fontoam_init.heap		 = heap;

	// ʃ{^̃tHgOAM
	ZknSortSearchSubAddFontCommon( p_draw, &fontoam_init, p_glb_draw->fontoam_sys );


	// I߂̃tHgOAMo^
	ZknSortSearchSubAddSubFontOam( p_draw, &fontoam_init, p_glb_draw->fontoam_sys, p_draw->local_select, p_draw->local_type_page );
}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMj
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDeleteFontOam( ZKN_SORTSEARCHSUB_DRAW* p_draw )
{
	ZknSortSearchSubDeleteFontCommon( p_draw );

	// ItHgOAM̔j
	ZknSortSearchSubDeleteFontSub( p_draw );
}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMύX
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 *	ύXԂƂĂZknSortSearchSubChgClacťɍs
 *
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubChgFontOam( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, int heap )
{
	ZKN_FONTOAM_INIT fontoam_init;
	CLACT_U_RES_OBJ_PTR res_obj;
	ZKN_GLB_DRAWDATA* p_glb_draw = p_drawglb->p_drawglb;

	// pbg̃\[Xf[^擾
	// pbgvNV擾p
	res_obj = CLACT_U_ResManagerGetIDResObjPtr( p_glb_draw->res_manager[ CLACT_U_PLTT_RES ], NARC_zukan_zkn_list_oam_NCLR + ZKN_SORTSEARCHSUB_RES_ID );

	// f[^̋ʕ쐬
	// ʃf[^
	fontoam_init.zkn_fontoam = p_glb_draw->fontoam_sys;
	fontoam_init.pltt		 = CLACT_U_PlttManagerGetProxy( res_obj, NULL );
	fontoam_init.bg_pri		 = 0;
	fontoam_init.soft_pri	 = 0;
	fontoam_init.draw_area	 = NNS_G2D_VRAM_TYPE_2DSUB;
	fontoam_init.heap		 = heap;

	// ܂łFONTOAMj
	ZknSortSearchSubDeleteFontSub( p_draw );


	// o^
	ZknSortSearchSubAddSubFontOam( p_draw, &fontoam_init, p_glb_draw->fontoam_sys, p_draw->local_select, p_draw->local_type_page );
}

//----------------------------------------------------------------------------
/**
 *	@brief	TuʃtHgOAM̓o^
 *
 *	@param	p_draw			`惏[N
 *	@param	p_fontoam_init	tHgOAMo^f[^
 *	@param	fontoam_sys		tHgOAMVXe
 *	@param	select_type		I
 *	@param	local_type_page	߂̃y[W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddSubFontOam( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys, int select_type, int local_type_page )
{
	switch( select_type ){
	case ZKN_SORTSEARCH_SELECT_SORT:
		ZknSortSearchSubAddFontSort( p_draw, p_fontoam_init, fontoam_sys );
		break;
		
	case ZKN_SORTSEARCH_SELECT_NEME:
		ZknSortSearchSubAddFontName( p_draw, p_fontoam_init, fontoam_sys );
		break;
		
	case ZKN_SORTSEARCH_SELECT_TYPE:
		if( local_type_page == 0 ){
			ZknSortSearchSubAddFontType1( p_draw, p_fontoam_init, fontoam_sys );
		}else{
			ZknSortSearchSubAddFontType2( p_draw, p_fontoam_init, fontoam_sys );
		}
		break;
		
	default:
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	{^tHg@ʃ{^p
 *
 *	@param	p_draw
 *	@param	p_fontoam_init	K{ްi[ς
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddFontCommon( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys )
{
	GF_BGL_BMPWIN* win;	// 񏑂ݐ
	int pltt_ofs;	// pbgAhX
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// {^̕Œ񂹂悤
	u32 width;
	// ----------------------------------------------------------------------------


	// pbg]AhX擾
	pltt_ofs = GetPlttProxyOffset( p_fontoam_init->pltt, NNS_G2D_VRAM_TYPE_2DSUB );

	//-------------------------------------
	//	Ȃ
	//=====================================
	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( fontoam_sys, 
			ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CX,
			ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CY );
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// {^̕Œ񂹂悤
	width = ZKN_FONTOAM_PrintBmpStr( fontoam_sys, win, NARC_msg_zkn_dat, ZNK_SORTSEARCH_03, 0, 0 );
	p_fontoam_init->p_bmp		 = win;
	p_fontoam_init->parent = p_draw->clact[ ZKN_SORTSEARCHSUB_BUTTON_NARABI ];
	p_fontoam_init->x			 = -width / 2;
	// ----------------------------------------------------------------------------
	p_fontoam_init->y			 = ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y;
	p_draw->p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_NARABI ] = ZKN_FONTOAM_Make( p_fontoam_init );
	FONTOAM_SetPaletteNo( p_draw->p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_NARABI ]->p_fontoam, pltt_ofs + ZKN_SORTSEARCHSUB_BUTTONFONT_PLTOFS );
	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );

	//-------------------------------------
	//	Ȃ܂
	//=====================================
	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( fontoam_sys, 
			ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CX,
			ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CY );
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// {^̕Œ񂹂悤
	width = ZKN_FONTOAM_PrintBmpStr( fontoam_sys, win, NARC_msg_zkn_dat, ZNK_SORTSEARCH_00, 0, 0 );
	p_fontoam_init->p_bmp		 = win;
	p_fontoam_init->parent = p_draw->clact[ ZKN_SORTSEARCHSUB_BUTTON_NAME ];
	p_fontoam_init->x			 = -width / 2;
	// ----------------------------------------------------------------------------
	p_fontoam_init->y			 = ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y;
	p_draw->p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_NAME ] = ZKN_FONTOAM_Make( p_fontoam_init );
	FONTOAM_SetPaletteNo( p_draw->p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_NAME ]->p_fontoam, pltt_ofs + ZKN_SORTSEARCHSUB_BUTTONFONT_PLTOFS );
	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );

	//-------------------------------------
	//	
	//=====================================
	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( fontoam_sys, 
			ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CX,
			ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CY );
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// {^̕Œ񂹂悤
	width = ZKN_FONTOAM_PrintBmpStr( fontoam_sys, win, NARC_msg_zkn_dat, ZNK_SORTSEARCH_01, 0, 0 );
	p_fontoam_init->p_bmp		 = win;
	p_fontoam_init->parent = p_draw->clact[ ZKN_SORTSEARCHSUB_BUTTON_TYPE ];
	p_fontoam_init->x			 = -width / 2;
	// ----------------------------------------------------------------------------
	p_fontoam_init->y			 = ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y;
	p_draw->p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_TYPE ] = ZKN_FONTOAM_Make( p_fontoam_init );
	FONTOAM_SetPaletteNo( p_draw->p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_TYPE ]->p_fontoam, pltt_ofs + ZKN_SORTSEARCHSUB_BUTTONFONT_PLTOFS );
	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );

	//-------------------------------------
	//@
	//=====================================
	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( fontoam_sys, 
			ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CX,
			ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CY );
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// {^̕Œ񂹂悤
	width = ZKN_FONTOAM_PrintBmpStr( fontoam_sys, win, NARC_msg_zkn_dat, ZNK_SORTSEARCH_02, 0, 0 );
	p_fontoam_init->p_bmp		 = win;
	p_fontoam_init->parent = p_draw->clact[ ZKN_SORTSEARCHSUB_BUTTON_FORM ];
	p_fontoam_init->x			 = -width / 2;
	// ----------------------------------------------------------------------------
	p_fontoam_init->y			 = ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y;
	p_draw->p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_FORM ] = ZKN_FONTOAM_Make( p_fontoam_init );
	FONTOAM_SetPaletteNo( p_draw->p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_FORM ]->p_fontoam, pltt_ofs + ZKN_SORTSEARCHSUB_BUTTONFONT_PLTOFS );
	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );

	//-------------------------------------
	//	
	//=====================================
	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( fontoam_sys, 
			ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CX,
			ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_SIZE_CY );
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// {^̕Œ񂹂悤
	width = ZKN_FONTOAM_PrintBmpStr( fontoam_sys, win, NARC_msg_zkn_dat, ZNK_SORTSEARCH_04, 0, 0 );
	p_fontoam_init->p_bmp		 = win;
	p_fontoam_init->parent = p_draw->clact[ ZKN_SORTSEARCHSUB_BUTTON_ACTION ];
	p_fontoam_init->x			 = -width / 2;
	// ----------------------------------------------------------------------------
	p_fontoam_init->y			 = ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y;
	p_draw->p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_ACTION ] = ZKN_FONTOAM_Make( p_fontoam_init );
	FONTOAM_SetPaletteNo( p_draw->p_fontoam[ ZKN_SORTSEARCHSUB_BUTTON_ACTION ]->p_fontoam, pltt_ofs + ZKN_SORTSEARCHSUB_BUTTONFONT_KETTEI_PLTOFS );
	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^tHgj
 *
 *	@param	p_draw 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDeleteFontCommon( ZKN_SORTSEARCHSUB_DRAW* p_draw )
{
	int i;

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_NUM; i++ ){
		if( p_draw->p_fontoam[ i ] ){
			ZKN_FONTOAM_Delete( p_draw->p_fontoam[ i ] );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief		Tuʂ̃{^tHgݒ
 */
//-----------------------------------------------------------------------------
// j
static void ZknSortSearchSubDeleteFontSub( ZKN_SORTSEARCHSUB_DRAW* p_draw )
{
	int i;
	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX; i++ ){
		if( p_draw->p_fontoam_sub[ i ] ){
			ZKN_FONTOAM_Delete( p_draw->p_fontoam_sub[ i ] );
			p_draw->p_fontoam_sub[ i ] = NULL;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ă{^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddFontSort( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys )
{
	GF_BGL_BMPWIN* win;	// 񏑂ݐ
	int pltt_ofs;	// pbgAhX
	int i;
	int msg_idx;
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// {^̕Œ񂹂悤
	u32 width;
	// ----------------------------------------------------------------------------

	// pbg]AhX擾
	pltt_ofs = GetPlttProxyOffset( p_fontoam_init->pltt, NNS_G2D_VRAM_TYPE_2DSUB );

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUM; i++ ){
		// rbg}bvEBhE쐬
		win = ZKN_FONTOAM_GetBmp( fontoam_sys, 
				ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_NARABI_SIZE_CX,
				ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_NARABI_SIZE_CY );
		
		
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/12/18
		// {^̕Œ񂹂悤
		switch( i ){
		case ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUMBER:
			msg_idx = ZNK_SORTSEARCH_SORT_00;
			break;
			
		case ZKN_SORTSEARCHSUB_BUTTON_NARABI_AIUEO:
			msg_idx = ZNK_SORTSEARCH_SORT_01;
			break;
			
		case ZKN_SORTSEARCHSUB_BUTTON_NARABI_HEAVY:
			msg_idx = ZNK_SORTSEARCH_SORT_02;
			break;
			
		case ZKN_SORTSEARCHSUB_BUTTON_NARABI_LIGHT:
			msg_idx = ZNK_SORTSEARCH_SORT_03;
			break;
			
		case ZKN_SORTSEARCHSUB_BUTTON_NARABI_TALL:
			msg_idx = ZNK_SORTSEARCH_SORT_04;
			break;
			
		case ZKN_SORTSEARCHSUB_BUTTON_NARABI_SHORT:
			msg_idx = ZNK_SORTSEARCH_SORT_05;
			break;
		}
		
		width = ZKN_FONTOAM_PrintBmpStr( fontoam_sys, win, NARC_msg_zkn_dat, msg_idx, 0, 0 );
		p_fontoam_init->x			 = -width / 2;
		// ----------------------------------------------------------------------------
		p_fontoam_init->p_bmp		 = win;
		p_fontoam_init->parent = p_draw->clact_sub[ i ];
		p_fontoam_init->y			 = ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y;
	
		p_draw->p_fontoam_sub[ i ] = ZKN_FONTOAM_Make( p_fontoam_init );
		FONTOAM_SetPaletteNo( p_draw->p_fontoam_sub[ i ]->p_fontoam, pltt_ofs + ZKN_SORTSEARCHSUB_BUTTONFONT_OTHER_PLTOFS );
		// rbg}bvEBhEj
		ZKN_FONTOAM_DeleteBmp( win );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	O{^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddFontName( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys )
{
	GF_BGL_BMPWIN* win;	// 񏑂ݐ
	int pltt_ofs;	// pbgAhX
	int i, j;
	int msg_idx;
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// {^̕Œ񂹂悤
	u32 width;
	// ----------------------------------------------------------------------------

	// pbg]AhX擾
	pltt_ofs = GetPlttProxyOffset( p_fontoam_init->pltt, NNS_G2D_VRAM_TYPE_2DSUB );

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_NAME_NUM; i++ ){
		// rbg}bvEBhE쐬
		win = ZKN_FONTOAM_GetBmp( fontoam_sys, 
				ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_NAME_SIZE_CX,
				ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_NAME_SIZE_CY );
		
		
		switch( i ){
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/12/18
		// \[g܏\At@xbgɁAu|||||veLXgɒu
		case ZKN_SORTSEARCHSUB_BUTTON_NAME_ABC:
			msg_idx = ZNK_SORTSEARCH_NAME_01;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_NAME_DEF:
			msg_idx = ZNK_SORTSEARCH_NAME_02;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_NAME_GHI:
			msg_idx = ZNK_SORTSEARCH_NAME_03;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_NAME_JKL:
			msg_idx = ZNK_SORTSEARCH_NAME_04;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_NAME_MNO:
			msg_idx = ZNK_SORTSEARCH_NAME_05;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_NAME_PQR:
			msg_idx = ZNK_SORTSEARCH_NAME_06;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_NAME_STU:
			msg_idx = ZNK_SORTSEARCH_NAME_07;
			break;
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/11/09
// ؍̃\[gɑΉ
#if PM_LANG != LANG_KOREA
		case ZKN_SORTSEARCHSUB_BUTTON_NAME_VWX:
			msg_idx = ZNK_SORTSEARCH_NAME_08;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_NAME_YZ:
			msg_idx = ZNK_SORTSEARCH_NAME_09;
			break;
#endif
// ----------------------------------------------------------------------------
		case ZKN_SORTSEARCHSUB_BUTTON_NAME_NONE:
			msg_idx = ZNK_SORTSEARCH_NAME_NONE;
			break;
		// ----------------------------------------------------------------------------
		}
		
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/12/18
		// {^̕Œ񂹂悤
		width = ZKN_FONTOAM_PrintBmpStr( fontoam_sys, win, NARC_msg_zkn_dat, msg_idx, 0, 0 );

		p_fontoam_init->x = -width / 2;
		// ----------------------------------------------------------------------------
		p_fontoam_init->p_bmp		 = win;
		p_fontoam_init->parent		 = p_draw->clact_sub[ i ];
		p_fontoam_init->y			 = ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y;
	
		p_draw->p_fontoam_sub[ i ] = ZKN_FONTOAM_Make( p_fontoam_init );
		FONTOAM_SetPaletteNo( p_draw->p_fontoam_sub[ i ]->p_fontoam, pltt_ofs + ZKN_SORTSEARCHSUB_BUTTONFONT_OTHER_PLTOFS );
		// rbg}bvEBhEj
		ZKN_FONTOAM_DeleteBmp( win );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	1{^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddFontType1( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys )
{
	GF_BGL_BMPWIN* win;	// 񏑂ݐ
	int pltt_ofs;	// pbgAhX
	int i, j;
	int msg_idx;
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// {^̕Œ񂹂悤
	u32 width;
	// ----------------------------------------------------------------------------

	// pbg]AhX擾
	pltt_ofs = GetPlttProxyOffset( p_fontoam_init->pltt, NNS_G2D_VRAM_TYPE_2DSUB );

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2; i++ ){
		// rbg}bvEBhE쐬
		win = ZKN_FONTOAM_GetBmp( fontoam_sys, 
				ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_TYPE1_SIZE_CX,
				ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_TYPE1_SIZE_CY );
		
		
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/12/18
		// {^̕Œ񂹂悤
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/12/19
		// ^Cv̕я܏\]̏
		switch( i ){
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NORMAL:
			msg_idx = ZNK_SORTSEARCH_TYPE_00;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_BATTLE:
			msg_idx = ZNK_SORTSEARCH_TYPE_06;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HIKOR:
			msg_idx = ZNK_SORTSEARCH_TYPE_09;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_DOKU:
			msg_idx = ZNK_SORTSEARCH_TYPE_07;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_JIMEN:
			msg_idx = ZNK_SORTSEARCH_TYPE_08;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_IWA:
			msg_idx = ZNK_SORTSEARCH_TYPE_12;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_MUSHI:
			msg_idx = ZNK_SORTSEARCH_TYPE_11;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_GHOST:
			msg_idx = ZNK_SORTSEARCH_TYPE_13;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HAGANE:
			msg_idx = ZNK_SORTSEARCH_TYPE_16;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NONE:
			msg_idx = ZNK_SORTSEARCH_TYPE_NONE;
			break;
		}
		// ----------------------------------------------------------------------------
		
		width = ZKN_FONTOAM_PrintBmpStr( fontoam_sys, win, NARC_msg_zkn_dat, msg_idx, 0, 0 );
		p_fontoam_init->x = -width / 2;
		// ----------------------------------------------------------------------------
		p_fontoam_init->p_bmp		 = win;
		p_fontoam_init->parent = p_draw->clact_sub[ i ];
		p_fontoam_init->y			 = ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y;
	
		p_draw->p_fontoam_sub[ i ] = ZKN_FONTOAM_Make( p_fontoam_init );
		FONTOAM_SetPaletteNo( p_draw->p_fontoam_sub[ i ]->p_fontoam, pltt_ofs + ZKN_SORTSEARCHSUB_BUTTONFONT_OTHER_PLTOFS );
		// rbg}bvEBhEj
		ZKN_FONTOAM_DeleteBmp( win );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	2{^
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubAddFontType2( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_FONTOAM_INIT* p_fontoam_init, ZKN_FONTOAM_SYS_PTR fontoam_sys )
{
	GF_BGL_BMPWIN* win;	// 񏑂ݐ
	int pltt_ofs;	// pbgAhX
	int i, j;
	int msg_idx;
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// {^̕Œ񂹂悤
	u32 width;
	// ----------------------------------------------------------------------------

	// pbg]AhX擾
	pltt_ofs = GetPlttProxyOffset( p_fontoam_init->pltt, NNS_G2D_VRAM_TYPE_2DSUB );

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1; i++ ){
		// rbg}bvEBhE쐬
		win = ZKN_FONTOAM_GetBmp( fontoam_sys, 
				ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_TYPE2_SIZE_CX,
				ZKN_SORTSEARCHSUB_BUTTONFONT_BMP_TYPE2_SIZE_CY );
		
		
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/12/18
		// {^̕Œ񂹂悤
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/12/19
		// ^Cv̕я܏\]̏
		switch( i ){
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_FIRE:
			msg_idx = ZNK_SORTSEARCH_TYPE_01;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_WATER:
			msg_idx = ZNK_SORTSEARCH_TYPE_02;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KUSA:
			msg_idx = ZNK_SORTSEARCH_TYPE_04;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_ELEC:
			msg_idx = ZNK_SORTSEARCH_TYPE_03;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_SP:
			msg_idx = ZNK_SORTSEARCH_TYPE_10;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KOORI:
			msg_idx = ZNK_SORTSEARCH_TYPE_05;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_DRAGON:
			msg_idx = ZNK_SORTSEARCH_TYPE_14;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_AKU:
			msg_idx = ZNK_SORTSEARCH_TYPE_15;
			break;
		case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NONE:
			msg_idx = ZNK_SORTSEARCH_TYPE_NONE;
			break;
		}
		// ----------------------------------------------------------------------------
		
		width = ZKN_FONTOAM_PrintBmpStr( fontoam_sys, win, NARC_msg_zkn_dat, msg_idx, 0, 0 );
		p_fontoam_init->x = -width / 2;
		// ----------------------------------------------------------------------------
		p_fontoam_init->p_bmp		 = win;
		p_fontoam_init->parent = p_draw->clact_sub[ i ];
		p_fontoam_init->y			 = ZKN_SORTSEARCHSUB_BUTTONFONT_OFS_Y;
	
		p_draw->p_fontoam_sub[ i ] = ZKN_FONTOAM_Make( p_fontoam_init );
		FONTOAM_SetPaletteNo( p_draw->p_fontoam_sub[ i ]->p_fontoam, pltt_ofs + ZKN_SORTSEARCHSUB_BUTTONFONT_OTHER_PLTOFS );
		// rbg}bvEBhEj
		ZKN_FONTOAM_DeleteBmp( win );
	}
}





//----------------------------------------------------------------------------
/**
 *	@brief	s@
 *
 *	@param	p_work	ް[N
 *	@param	p_glb	ްO[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDoInit( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int select_type = p_work->local_select;
	p_work->do_flag_select = ZKN_SORTSEARCHSUB_DO_FLAG_INIT;
}

//----------------------------------------------------------------------------
/**
 *	@brief	̎s
 *
 *	@param	p_work		ް[N
 *	@param	p_glb		ްO[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDoMain( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	// ʓ
	ZknSortSearchSubDoCommon( p_work, p_glb );


	// Iߕʓ
	ZknSortSearchSubDoSelect( p_work, p_glb, p_work->local_select, p_work->local_type_page  );
}
static void ZknSortSearchSubDoSelect( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int select_type, int type_page )
{
	switch( select_type ){
	case ZKN_SORTSEARCH_SELECT_SORT:
		ZknSortSearchSubDoSort( p_work, p_glb );
		break;
		
	case ZKN_SORTSEARCH_SELECT_NEME:
		ZknSortSearchSubDoName( p_work, p_glb );
		break;
		
	case ZKN_SORTSEARCH_SELECT_TYPE:
		if( type_page == 0 ){
			ZknSortSearchSubDoType1( p_work, p_glb );
		}else{
			ZknSortSearchSubDoType2( p_work, p_glb );
		}
		break;

	case ZKN_SORTSEARCH_SELECT_FORM:
		ZknSortSearchSubDoForm( p_work, p_glb );
		break;
		
	default:
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	ʃ{^̎s
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDoCommon( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	switch( p_work->do_flag_common ){
	case ZKN_SORTSEARCHSUB_BUTTON_BACK:
		// |PXgɉɖ߂
		ZKN_SortSearchAplReqListFade( p_glb->p_main_apl, FALSE );
		// {^
		Snd_SePlay( ZKN_SND_BUTTON );
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NARABI:
		if( ZKN_SortSearchAplSelectTypeGet( p_glb->p_main_apl ) != ZKN_SORTSEARCH_SELECT_SORT ){
			// đI[h
			ZKN_SortSearchAplSelectTypeSet( p_glb->p_main_apl, ZKN_SORTSEARCH_SELECT_SORT );
			// {^
			Snd_SePlay( ZKN_SND_BUTTON );
		}
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NAME:
		if( ZKN_SortSearchAplSelectTypeGet( p_glb->p_main_apl ) != ZKN_SORTSEARCH_SELECT_NEME ){
			// Ȃ܂I[h
			ZKN_SortSearchAplSelectTypeSet( p_glb->p_main_apl, ZKN_SORTSEARCH_SELECT_NEME );
			// {^
			Snd_SePlay( ZKN_SND_BUTTON );
		}
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE:
		if( ZKN_SortSearchAplSelectTypeGet( p_glb->p_main_apl ) != ZKN_SORTSEARCH_SELECT_TYPE ){
			// ߑI[h
			ZKN_SortSearchAplSelectTypeSet( p_glb->p_main_apl, ZKN_SORTSEARCH_SELECT_TYPE );
			// {^
			Snd_SePlay( ZKN_SND_BUTTON );
			p_work->type_set_no = ZKN_SORTSEARCH_TYPE1;
		}
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM:
		if( ZKN_SortSearchAplSelectTypeGet( p_glb->p_main_apl ) != ZKN_SORTSEARCH_SELECT_FORM ){
			// `I[h
			ZKN_SortSearchAplSelectTypeSet( p_glb->p_main_apl, ZKN_SORTSEARCH_SELECT_FORM );
			// {^
			Snd_SePlay( ZKN_SND_BUTTON );
		}
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_ACTION:
		if( p_work->req_count <= 1 ){	// ŏ̃NGXgɂȂ
			//@Ďs 
			ZKN_SortSearchAplReqListFade( p_glb->p_main_apl, TRUE );
			// {^
			Snd_SePlay( ZKN_SND_BUTTON );
		}
		break;

	default:
		break;
	}
	p_work->do_flag_common = ZKN_SORTSEARCHSUB_DO_FLAG_INIT;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ă{^̎s
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDoSort( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int set_num = 100;
	
	switch( p_work->do_flag_select ){
	case ZKN_SORTSEARCHSUB_BUTTON_NARABI_NUMBER:
		set_num = ZKN_POKELIST_SORT_NORMAL;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NARABI_AIUEO:
		set_num =  ZKN_POKELIST_SORT_GOZYUUON;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NARABI_HEAVY:
		set_num =  ZKN_POKELIST_SORT_GRAM_L;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NARABI_LIGHT:
		set_num =  ZKN_POKELIST_SORT_GRAM_S;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NARABI_TALL:
		set_num =  ZKN_POKELIST_SORT_HIGH_L;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NARABI_SHORT:
		set_num =  ZKN_POKELSIT_SOTT_HIGH_S;
		break;
	default:
		break;
	}
	if( set_num != 100 ){

		if( ZKN_SortSearchAplSortTypeGet( p_glb->p_main_apl ) != set_num ){
			// {^
			Snd_SePlay( ZKN_SND_BUTTON );
			ZKN_SortSearchAplSortTypeSet( p_glb->p_main_apl, set_num );	
		}
	}
	
	p_work->do_flag_select = ZKN_SORTSEARCHSUB_DO_FLAG_INIT; 
}

//----------------------------------------------------------------------------
/**
 *	@brief	O{^̎s
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDoName( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int set_num = 100;
	
	switch( p_work->do_flag_select ){
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/18
	// \[g܏\At@xbg
	case ZKN_SORTSEARCHSUB_BUTTON_NAME_ABC:
		set_num = ZKN_POKELIST_SEARCH_NAME_ABC;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NAME_DEF:
		set_num = ZKN_POKELIST_SEARCH_NAME_DEF;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NAME_GHI:
		set_num = ZKN_POKELIST_SEARCH_NAME_GHI;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NAME_JKL:
		set_num = ZKN_POKELIST_SEARCH_NAME_JKL;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NAME_MNO:
		set_num = ZKN_POKELIST_SEARCH_NAME_MNO;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NAME_PQR:
		set_num = ZKN_POKELIST_SEARCH_NAME_PQR;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NAME_STU:
		set_num = ZKN_POKELIST_SEARCH_NAME_STU;
		break;
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/11/09
// ؍̃\[gɑΉ
#if PM_LANG != LANG_KOREA
	case ZKN_SORTSEARCHSUB_BUTTON_NAME_VWX:
		set_num = ZKN_POKELIST_SEARCH_NAME_VWX;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_NAME_YZ:
		set_num = ZKN_POKELIST_SEARCH_NAME_YZ;
		break;
#endif
// ----------------------------------------------------------------------------
	case ZKN_SORTSEARCHSUB_BUTTON_NAME_NONE:
		set_num = ZKN_POKELIST_SEARCH_NAME_NONE;
		break;
	default:
		break;
	// ----------------------------------------------------------------------------
	}

	if( set_num != 100 ){
		if( ZKN_SortSearchAplNameTypeGet( p_glb->p_main_apl ) !=set_num  ){
			// {^
			Snd_SePlay( ZKN_SND_BUTTON );

			ZKN_SortSearchAplNameTypeSet( p_glb->p_main_apl, set_num );
		}
	}
	p_work->do_flag_select = ZKN_SORTSEARCHSUB_DO_FLAG_INIT; 
}

//----------------------------------------------------------------------------
/**
 *	@brief	1{^̎s
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDoType1( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int set_num = 100;
	
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/19
	// ^Cv̕я܏\]̏
	switch( p_work->do_flag_select ){
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NORMAL:
		set_num = ZKN_POKELIST_SEARCH_TYPE_NORMAL;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_BATTLE:
		set_num = ZKN_POKELIST_SEARCH_TYPE_BATTLE;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HIKOR:
		set_num = ZKN_POKELIST_SEARCH_TYPE_HIKOU;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_DOKU:
		set_num = ZKN_POKELIST_SEARCH_TYPE_POISON;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_JIMEN:
		set_num = ZKN_POKELIST_SEARCH_TYPE_JIMEN;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_IWA:
		set_num = ZKN_POKELIST_SEARCH_TYPE_IWA;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_MUSHI:
		set_num = ZKN_POKELIST_SEARCH_TYPE_MUSHI;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_GHOST:
		set_num = ZKN_POKELIST_SEARCH_TYPE_GHOST;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_HAGANE:
		set_num = ZKN_POKELIST_SEARCH_TYPE_METAL;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_NONE:
		set_num = ZKN_POKELIST_SEARCH_TYPE_NONE;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2:
		p_work->type_page = 1;
		// {^
		Snd_SePlay( ZKN_SND_BUTTON );
		break;
	default:
		break;
	}
	// ----------------------------------------------------------------------------

	if( set_num != 100 ){
		ZknSortSearchSubDoTypeSetCommon( p_work, p_glb, set_num );
	}
	p_work->do_flag_select = ZKN_SORTSEARCHSUB_DO_FLAG_INIT; 
}

//----------------------------------------------------------------------------
/**
 *	@brief	2{^̎s
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDoType2( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int set_num = 100;
	
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/19
	// ^Cv̕я܏\]̏
	switch( p_work->do_flag_select ){
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_FIRE:
		set_num = ZKN_POKELIST_SEARCH_TYPE_FIRE;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_WATER:
		set_num = ZKN_POKELIST_SEARCH_TYPE_WATER;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KUSA:
		set_num = ZKN_POKELIST_SEARCH_TYPE_KUSA;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_ELEC:
		set_num = ZKN_POKELIST_SEARCH_TYPE_ELECTRIC;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_SP:
		set_num = ZKN_POKELIST_SEARCH_TYPE_SP;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_KOORI:
		set_num = ZKN_POKELIST_SEARCH_TYPE_KOORI;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_DRAGON:
		set_num = ZKN_POKELIST_SEARCH_TYPE_DRAGON;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_AKU:
		set_num = ZKN_POKELIST_SEARCH_TYPE_AKU;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_NONE:
		set_num = ZKN_POKELIST_SEARCH_TYPE_NONE;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1:
		p_work->type_page = 0;
		// {^
		Snd_SePlay( ZKN_SND_BUTTON );
		break;
	default:
		break;
	}
	// ----------------------------------------------------------------------------

	if( set_num != 100 ){
		ZknSortSearchSubDoTypeSetCommon( p_work,p_glb, set_num );
	}
	p_work->do_flag_select = ZKN_SORTSEARCHSUB_DO_FLAG_INIT; 
}
static void ZknSortSearchSubDoTypeSetCommon( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb, int set_num )
{
	if( set_num != ZKN_POKELIST_SEARCH_TYPE_NONE ){

		// ̒lƈĂݒ
		if( (ZKN_SortSearchAplTypeTypeGet( p_glb->p_main_apl, ZKN_SORTSEARCH_TYPE1 ) != set_num) &&
			(ZKN_SortSearchAplTypeTypeGet( p_glb->p_main_apl, ZKN_SORTSEARCH_TYPE2 ) != set_num) ){
		
			if( ZKN_SortSearchAplTypeTypeGet( p_glb->p_main_apl, p_work->type_set_no ) != set_num ){
				
				ZKN_SortSearchAplTypeTypeSet( p_glb->p_main_apl, set_num, p_work->type_set_no );
				p_work->type_set_no = (p_work->type_set_no + 1) % ZKN_SORTSEARCH_TYPENUM;
				// {^
				Snd_SePlay( ZKN_SND_BUTTON );
			}
		}
	}else{
		// 󔒂ɂƂ
		// 󔒈ȊOĂق
		if( ZKN_SortSearchAplTypeTypeGet( p_glb->p_main_apl, ZKN_SORTSEARCH_TYPE1 ) != ZKN_POKELIST_SEARCH_TYPE_NONE ){
			ZKN_SortSearchAplTypeTypeSet( p_glb->p_main_apl, set_num, ZKN_SORTSEARCH_TYPE1 );
			// {^
			Snd_SePlay( ZKN_SND_BUTTON );
		}else{
			if( ZKN_SortSearchAplTypeTypeGet( p_glb->p_main_apl, ZKN_SORTSEARCH_TYPE2 ) != ZKN_POKELIST_SEARCH_TYPE_NONE ){
				ZKN_SortSearchAplTypeTypeSet( p_glb->p_main_apl, set_num, ZKN_SORTSEARCH_TYPE2 );
				// {^
				Snd_SePlay( ZKN_SND_BUTTON );
			}
		}
		p_work->type_set_no = ZKN_SORTSEARCH_TYPE1;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	`{^̎s
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubDoForm( ZKN_SORTSEARCHSUB_WORK* p_work, ZKN_SORTSEARCHSUB_GLB* p_glb )
{
	int set_num = 100;
	
	switch( p_work->do_flag_select ){
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_CIRCLE:
		set_num = ZKN_POKELIST_SEARCH_FORM_CIRCLE;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_HARABAI:
		set_num = ZKN_POKELIST_SEARCH_FORM_HARABAI;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_WATER:
		set_num = ZKN_POKELIST_SEARCH_FORM_WATER;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_ARM:
		set_num = ZKN_POKELIST_SEARCH_FORM_ARM;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_STRAIGHT:
		set_num = ZKN_POKELIST_SEARCH_FORM_STRAIGHT;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_TAIL:
		set_num = ZKN_POKELIST_SEARCH_FORM_TAIL;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_LEGS:
		set_num = ZKN_POKELIST_SEARCH_FORM_LEGS;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_LEGS:
		set_num = ZKN_POKELIST_SEARCH_FORM_FOUR_LEGS;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_WING:
		set_num = ZKN_POKELIST_SEARCH_FORM_TWO_WING;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_MANY_LEGS:
		set_num = ZKN_POKELIST_SEARCH_FORM_MANY_LEGS;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_COMP:
		set_num = ZKN_POKELIST_SEARCH_FORM_COMP;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_TWO_LEGS:
		set_num = ZKN_POKELIST_SEARCH_FORM_TWO_LEGS;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_FOUR_WING:
		set_num = ZKN_POKELIST_SEARCH_FORM_FOUR_WING;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_HAITSUKUBARI:
		set_num = ZKN_POKELIST_SEARCH_FORM_HAITSUKUBARI;
		break;
	case ZKN_SORTSEARCHSUB_BUTTON_FORM_NONE:
		set_num = ZKN_POKELIST_SEARCH_FORM_NONE;
		break;
	default:
		break;
	}

	if( set_num != 100 ){
		if( ZKN_SortSearchAplFormTypeGet( p_glb->p_main_apl ) != set_num ){
			// {^
			Snd_SePlay( ZKN_SND_BUTTON );

			ZKN_SortSearchAplFormTypeSet( p_glb->p_main_apl, set_num );
		}
	}
	p_work->do_flag_select = ZKN_SORTSEARCHSUB_DO_FLAG_INIT; 
}


//----------------------------------------------------------------------------
/**
 *	@brief	{^tF[hRg[
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonFadeCont( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb )
{
	// tF[h`FbN
	if( p_draw->do_fade == ZKN_SORTSEARCH_SUB_BUTTON_FADE_NONE ){
		
		// NGXgtF[hJn
		if( p_drawglb->button_fade_req > ZKN_SORTSEARCH_SUB_BUTTON_FADE_NONE ){
			p_draw->do_fade = p_drawglb->button_fade_req;
			p_draw->do_fade_seq = 0;
			p_draw->end_flag = p_drawglb->button_fade;
			*p_draw->end_flag = FALSE;

			// NGXgް
			p_drawglb->button_fade_req = ZKN_SORTSEARCH_SUB_BUTTON_FADE_NONE;
		}
	}else{

		// tF[hs
		ZknSortSearchSubButtonFade( p_draw );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^tF[h
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonFade( ZKN_SORTSEARCHSUB_DRAW* p_draw )
{
	BOOL check;


	// stF[h߂NONEȂȂɂȂ
	if( p_draw->do_fade == ZKN_SORTSEARCH_SUB_BUTTON_FADE_NONE ){
		return ;
	}
	
	switch( p_draw->do_fade_seq ){
	case 0:
		// 쏉
		if( p_draw->do_fade == ZKN_SORTSEARCH_SUB_BUTTON_FADE_IN ){
			ZKN_UTIL_MoveReq( &p_draw->fade_work, 0, 16, 0, 0, ZKN_SORTSEARCHSUB_BUTTON_FADE_SYNC );
		}else{
			ZKN_UTIL_MoveReq( &p_draw->fade_work, 16, 0, 0, 0, ZKN_SORTSEARCHSUB_BUTTON_FADE_SYNC );
		}

		G2S_SetBlendAlpha( GX_BLEND_PLANEMASK_NONE, GX_BLEND_PLANEMASK_BG2, p_draw->fade_work.x, 16 - p_draw->fade_work.x );
		p_draw->do_fade_seq ++;
		break;

	case 1:
		check = ZKN_UTIL_MoveMain( &p_draw->fade_work );	
		G2S_ChangeBlendAlpha( p_draw->fade_work.x, 16 - p_draw->fade_work.x );
		if( check == TRUE ){
			// OAM𔼓
			if( p_draw->do_fade == ZKN_SORTSEARCH_SUB_BUTTON_FADE_IN ){
				G2S_BlendNone();
			}
			
			*p_draw->end_flag = TRUE;
			p_draw->do_fade_seq = 0;
			p_draw->do_fade = ZKN_SORTSEARCH_SUB_BUTTON_FADE_NONE;
		}
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ĻOAMӰސݒpbN֐
 *
 *	@param	p_draw
 *	@param	mode
 *	@param	select_type
 *	@param	type_page 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonFadeOamModeSet_Pack( ZKN_SORTSEARCHSUB_DRAW* p_draw, int mode, int select_type, int type_page )
{
	if( select_type == ZKN_SORTSEARCH_SELECT_TYPE ){
		if( type_page == 0 ){
			// TYPE1
			ZknSortSearchSubButtonFadeOamModeSet_Type1Ver( p_draw, mode );
		}else{
			// TYPE2
			ZknSortSearchSubButtonFadeOamModeSet_Type2Ver( p_draw, mode );
		}
	}else{
		ZknSortSearchSubButtonFadeOamModeSet( p_draw, mode );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[hIuWF[hݒ
 *
 *	@param	p_draw
 *	@param	mode 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonFadeOamModeSet( ZKN_SORTSEARCHSUB_DRAW* p_draw, int mode )
{
	int i;

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX; i++ ){
		if( p_draw->clact_sub[i] ){
			CLACT_ObjModeSet( p_draw->clact_sub[i], mode );
		}
		if( p_draw->p_fontoam_sub[i] ){
			FONTOAM_ObjModeSet( p_draw->p_fontoam_sub[i]->p_fontoam, mode );
		}
		if( p_draw->clact_sub_form[i] ){
			CLACT_ObjModeSet( p_draw->clact_sub_form[i], mode );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ݒ@߂Po[W
 *
 *	@param	p_draw
 *	@param	mode 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubButtonFadeOamModeSet_Type1Ver( ZKN_SORTSEARCHSUB_DRAW* p_draw, int mode )
{
	int i;

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX; i++ ){
		if( i != ZKN_SORTSEARCHSUB_BUTTON_TYPE1_TYPE2 ){
			if( p_draw->clact_sub[i] ){
				CLACT_ObjModeSet( p_draw->clact_sub[i], mode );
			}
			if( p_draw->p_fontoam_sub[i] ){
				FONTOAM_ObjModeSet( p_draw->p_fontoam_sub[i]->p_fontoam, mode );
			}
		}
	}
}
// ߂Qo[W
static void ZknSortSearchSubButtonFadeOamModeSet_Type2Ver( ZKN_SORTSEARCHSUB_DRAW* p_draw, int mode )
{
	int i;

	for( i=0; i<ZKN_SORTSEARCHSUB_BUTTON_SUB_MAX; i++ ){
		if( i != ZKN_SORTSEARCHSUB_BUTTON_TYPE2_TYPE1 ){
			if( p_draw->clact_sub[i] ){
				CLACT_ObjModeSet( p_draw->clact_sub[i], mode );
			}
			if( p_draw->p_fontoam_sub[i] ){
				FONTOAM_ObjModeSet( p_draw->p_fontoam_sub[i]->p_fontoam, mode );
			}
		}
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	ătF[hVXe
 *
 *	@param	p_draw			`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb			O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknSortSearchSubSortFadeSys( ZKN_SORTSEARCHSUB_DRAW* p_draw, ZKN_SORTSEARCHSUB_DRAWGLB* p_drawglb, const ZKN_SORTSEARCHSUB_GLB* cp_glb )
{
	// 쏈
	if( ZKN_SortSearchAplFadeModeCountGet( cp_glb->p_main_apl ) == ZKN_SORTSEARCH_FADECOUNT_MAX ){
		
		if( ZKN_SortSearchAplFadeModeGet( cp_glb->p_main_apl ) == ZKN_SORTSEARCH_FADEIN ){
			ChangeBrightnessRequest( ZKN_SORTSEARCH_FADECOUNT_MAX,
					BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, PLANEMASK_ALL, MASK_SUB_DISPLAY );
		}else if( ZKN_SortSearchAplFadeModeGet( cp_glb->p_main_apl ) == ZKN_SORTSEARCH_FADEOUT ){
			ChangeBrightnessRequest( ZKN_SORTSEARCH_FADECOUNT_MAX,
					BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_SUB_DISPLAY );
		}
	}
}

