//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_world_text_sys.c
 *	@brief		}ӂ̊OeLXgANZX
 *	@author		tomoya takahashi 
 *	@data		2006.02.28
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>
#include "include/system/fontproc.h"
#include "include/system/msgdata_util.h"
#include "include/msgdata/msg.naix"

#include "include/application/zukanlist/zkn_world_text_data.h"
#include "src/application/zukanlist/zkn_worldtext.h"

#include "include/application/zukanlist/zkn_version.h"

#define	__ZKN_WORLD_TEXT_SYS_H_GLOBAL
#include "include/application/zukanlist/zkn_world_text_sys.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define ZKN_WT_ALLOC_STR_NUM		( 256 )		// mۂ镶


//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
 *					O[of[^
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	|POeLXgpR[h
//	ۂGMMt@CɓĂf[^̊Oꍀڐ
//	Ήf[^
//	IDX͊OeLXgpR[h
//
//	zukan_data.xlsɂ͉̐̏ްi[Ă
//=====================================

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/10/05
// Oꂸ̃eLXg`ɕύX
// localize_spec_mark(LANG_KOREA) imatake 2007/06/27
// ؍łmakeɑΉ
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g

enum {
	TEXTCODE_JAPAN,
	TEXTCODE_ENGLISH,
	TEXTCODE_FRANCE,
	TEXTCODE_GERMANY,
	TEXTCODE_ITALY,
	TEXTCODE_SPAIN,
#if PM_LANG == LANG_KOREA
	TEXTCODE_KOREA,
#endif
};

#if (PM_LANG == LANG_JAPAN)
#define TEXTCODE_OWN	TEXTCODE_JAPAN
#elif (PM_LANG == LANG_ENGLISH)
#define TEXTCODE_OWN	TEXTCODE_ENGLISH
#elif (PM_LANG == LANG_FRANCE)
#define TEXTCODE_OWN	TEXTCODE_FRANCE
#elif (PM_LANG == LANG_GERMANY)
#define TEXTCODE_OWN	TEXTCODE_GERMANY
#elif (PM_LANG == LANG_ITALY)
#define TEXTCODE_OWN	TEXTCODE_ITALY
#elif (PM_LANG == LANG_SPAIN)
#define TEXTCODE_OWN	TEXTCODE_SPAIN
#elif (PM_LANG == LANG_KOREA)
#define TEXTCODE_OWN	TEXTCODE_KOREA
#endif

static const u8 ZKN_WORLD_TEXT_LangBtnOrder[ZKN_WORLD_TEXT_NUM] = {
#if (PM_LANG == LANG_JAPAN)
	TEXTCODE_JAPAN, TEXTCODE_ENGLISH, TEXTCODE_FRANCE, TEXTCODE_GERMANY, TEXTCODE_ITALY, TEXTCODE_SPAIN
#elif (PM_LANG == LANG_ENGLISH)
	TEXTCODE_ENGLISH, TEXTCODE_FRANCE, TEXTCODE_GERMANY, TEXTCODE_ITALY, TEXTCODE_SPAIN, TEXTCODE_JAPAN
#elif (PM_LANG == LANG_FRANCE)
	TEXTCODE_FRANCE, TEXTCODE_ENGLISH, TEXTCODE_GERMANY, TEXTCODE_ITALY, TEXTCODE_SPAIN, TEXTCODE_JAPAN
#elif (PM_LANG == LANG_GERMANY)
	TEXTCODE_GERMANY, TEXTCODE_ENGLISH, TEXTCODE_FRANCE, TEXTCODE_ITALY, TEXTCODE_SPAIN, TEXTCODE_JAPAN
#elif (PM_LANG == LANG_ITALY)
	TEXTCODE_ITALY, TEXTCODE_ENGLISH, TEXTCODE_FRANCE, TEXTCODE_GERMANY, TEXTCODE_SPAIN, TEXTCODE_JAPAN
#elif (PM_LANG == LANG_SPAIN)
	TEXTCODE_SPAIN, TEXTCODE_ENGLISH, TEXTCODE_FRANCE, TEXTCODE_GERMANY, TEXTCODE_ITALY, TEXTCODE_JAPAN
#elif (PM_LANG == LANG_KOREA)
	TEXTCODE_KOREA, TEXTCODE_ENGLISH, TEXTCODE_FRANCE, TEXTCODE_GERMANY, TEXTCODE_ITALY, TEXTCODE_SPAIN, TEXTCODE_JAPAN
#endif
};

// ----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static inline int ZknWt_GetGmmIdx( int zkn_text_code );
static inline BOOL ZknWt_CheckWorldData( int textverpokenum, int gmm_idx );
static STRBUF* ZknWt_GetSTRData( int file_idx, int data_idx, int heap );
static void ZknWt_GetCountryPokeData( int monsno, int country, int* p_country_poke_num, int* p_country_text_code, int* p_country_gmm_idx );

//----------------------------------------------------------------------------
/**
 *	@brief	obt@j
 *
 *	@param	buf		obt@
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ZKN_WT_DeleteStrBuf( STRBUF* buf )
{
	STRBUF_Delete( buf );
}

//----------------------------------------------------------------------------
/**
 *	@brief	R[hΉOGMMCfbNX擾
 *
 *	@param	country	R[h
 *
 *	@return	Oԍ
 */
//-----------------------------------------------------------------------------
int ZKN_WT_LANG_Code_WORLD_TEXT_GMM_Idx( int country )
{
	int country_text_code;
	int country_gmm_idx;
	
	// OeLXgpR[hɕϊ
	country_text_code = ZKN_WT_GetLANG_Code_ZKN_WORLD_TEXT_Code( country );
	GF_ASSERT( country_text_code < ZKN_WORLD_TEXT_NUM );	// ƂƂ̓f[^
	// OeLXgpR[hGMMf[^Oꍀڐ擾
	country_gmm_idx = ZknWt_GetGmmIdx( country_text_code );

	return country_gmm_idx;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OԍΉ鍑R[h擾
 *
 *	@param	county	Oԍ	(gmmt@Cɕłԍ)
 *
 *	@return	R[h		// ȂƂ̓z[^EԂ
 */
//-----------------------------------------------------------------------------
int ZKN_WT_WORLD_TEXT_GMM_Idx_LANG_Code( int country )
{
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/05
	// Oꂸ̃eLXg`ɕύX

	return ZKN_WT_GetZKN_WORLD_TEXT_Code_LANG_Code( ZKN_WORLD_TEXT_LangBtnOrder[country+1] );

	// ----------------------------------------------------------------------------
}


//----------------------------------------------------------------------------
/**
 *	@brief	̃|PԂ
 *
 *	@param	monsno		X^[io[
 *	@param	country		Q[R[h
 *	@param	heap		q[v
 *
 *	@return	f[^
 */
//-----------------------------------------------------------------------------
STRBUF* ZKN_WT_GetPokeName( int monsno, int country, int heap )
{
	int country_poke_num;
	int country_text_code;
	int country_gmm_idx;
	int gmm_file_idx;

	// X^[io[ƃQ[R[h
	// OeLXgf[^ڐ
	// OeLXgf[^pR[h
	// OeLXgf[^GMMOڐ擾
	ZknWt_GetCountryPokeData( monsno, country, &country_poke_num, &country_text_code, &country_gmm_idx );

	// `FbN
	if( country_gmm_idx == ZKN_WORLD_TEXT_NUM ){
		// 
		// GMM̒̃f[^idxmonsno
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2007/01/19
		// |Pׂ͂đS啶
		return MSGDAT_UTIL_GetMonsName( monsno, heap );
		// ----------------------------------------------------------------------------
	}else{
		// O
		// GMM̒̃f[^CfbNX߂
		// O|PGMM̃f[^\
		// OPA|P, OQA|P,ORA|P,OSA|P,OTA|P
		// OPB|P, OQB|P,ORB|P,OSB|P,OTB|P
		country_gmm_idx += country_poke_num * ZKN_WORLD_TEXT_OUTWORLD_NUM;
		gmm_file_idx = NARC_msg_zkn_worldname_dat;
	}

	// gmm_file_idxcountry_gmm_idxSTRBUF擾
	return ZknWt_GetSTRData( gmm_file_idx, country_gmm_idx, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃|P^CvԂ
 *
 *	@param	monsno		X^[io[
 *	@param	country		Q[R[h
 *	@param	heap		q[v
 *
 *	@return	f[^
 */
//-----------------------------------------------------------------------------
STRBUF* ZKN_WT_GetPokeType( int monsno, int country, int heap )
{
	int country_poke_num;
	int country_text_code;
	int country_gmm_idx;
	int gmm_file_idx;

	// X^[io[ƃQ[R[h
	// OeLXgf[^ڐ
	// OeLXgf[^pR[h
	// OeLXgf[^GMMOڐ擾
	ZknWt_GetCountryPokeData( monsno, country, &country_poke_num, &country_text_code, &country_gmm_idx );

	// `FbN
	if( country_gmm_idx == ZKN_WORLD_TEXT_NUM ){
		// 
		// GMM̒̃f[^idxmonsno
		country_gmm_idx = monsno;
		gmm_file_idx = NARC_msg_zkn_type_dat;
	}else{
		// O
		// GMM̒̃f[^CfbNX߂
		// O|PGMM̃f[^\
		// OPA|P, OQA|P,ORA|P,OSA|P,OTA|P
		// OPB|P, OQB|P,ORB|P,OSB|P,OTB|P
		country_gmm_idx += country_poke_num * ZKN_WORLD_TEXT_OUTWORLD_NUM;
		gmm_file_idx = NARC_msg_zkn_worldtype_dat;
	}

	// gmm_file_idxcountry_gmm_idxSTRBUF擾
	return ZknWt_GetSTRData( gmm_file_idx, country_gmm_idx, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃eLXgf[^Ԃ
 *
 *	@param	monsno		X^[io[
 *	@param	country		Q[R[h
 *	@param	page		y[W
 *	@param	heap		q[v
 *	
 *	@return	f[^
 */
//-----------------------------------------------------------------------------
STRBUF* ZKN_WT_GetText( int monsno, int country, int page, int heap )
{
	int country_poke_num;
	int country_text_code;
	int country_gmm_idx;
	int gmm_file_idx;

	// X^[io[ƃQ[R[h
	// OeLXgf[^ڐ
	// OeLXgf[^pR[h
	// OeLXgf[^GMMOڐ擾
	ZknWt_GetCountryPokeData( monsno, country, &country_poke_num, &country_text_code, &country_gmm_idx );

	// `FbN
	if( country_gmm_idx == ZKN_WORLD_TEXT_NUM ){

		// y[W`FbN
		GF_ASSERT( page < ZKN_WT_HOME_TEXT_PAGE_NUM );
		// 
		// GMM̒̃f[^idxmonsno
		country_gmm_idx = (monsno * ZKN_WT_HOME_TEXT_PAGE_NUM) + page;
		gmm_file_idx = ZKN_TEXT_DAT;
	}else{

		// y[W`FbN
		GF_ASSERT( page < ZKN_WT_WORLD_TEXT_PAGE_NUM );
		// O
		// GMM̒̃f[^CfbNX߂
		// O|PGMM̃f[^\
		// OPA|P1y[W,OQA|P1y[W,ORA|P1y[W,OSA|P1y[W,OTA|P1y[W,
		// OPB|P1y[W,OQB|P1y[W,ORB|P1y[W,OSB|P1y[W,OTB|P1y[W,
		country_gmm_idx = (country_gmm_idx * ZKN_WT_WORLD_TEXT_PAGE_NUM) + page + (country_poke_num * (ZKN_WORLD_TEXT_OUTWORLD_NUM * ZKN_WT_WORLD_TEXT_PAGE_NUM));
		gmm_file_idx = NARC_msg_zkn_comment_02_dat;
	}

	// gmm_file_idxcountry_gmm_idxSTRBUF擾
	return ZknWt_GetSTRData( gmm_file_idx, country_gmm_idx, heap );
}


//-----------------------------------------------------------------------------
/**
 *			vCx[g֐
 */
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *	@brief	֐ł̖߂l[OGMM̃f[^][GMMf[^Oꍀڐ]炻̃f[^̂`FbN
 *
 *	@param	textverpokenum
 *	@param	gmm_idx 
 *
 *	@retval	TRUE	f[^
 *	@retval	FALSE	̃|P̂̍̃f[^͂Ȃ
 */
//-----------------------------------------------------------------------------
static inline BOOL ZknWt_CheckWorldData( int textverpokenum, int gmm_idx )
{
	// ̃f[^߂ĂȂ̂ɂ̃|P̊Of[^Ƃ
	// ̓f[^ȂƂƂɂȂ
	if( (textverpokenum == ZKN_WORLD_TEXT_POKE_NUM) && (gmm_idx != ZKN_WORLD_TEXT_NUM) ){
		return FALSE;
	}

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	t@CCfbNX當f[^擾
 *
 *	@param	file_idx
 *	@param	data_idx
 *	@param	heap 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static STRBUF* ZknWt_GetSTRData( int file_idx, int data_idx, int heap )
{
	MSGDATA_MANAGER* man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, file_idx, heap );
	if( man )
	{
		STRBUF* buf = STRBUF_Create(ZKN_WT_ALLOC_STR_NUM, heap );
		if( buf )
		{
			MSGMAN_GetString(man, data_idx, buf);
		}
		MSGMAN_Delete(man);
		return buf;
	}
	return NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	X^[io[ƃQ[R[h
 *			OeLXgf[^ڐ
 *			OeLXgf[^pR[h
 *			OeLXgf[^GMMOڐ
 *			擾
 *
 *	@param	monsno				X^[io[
 *	@param	country				Q[R[h
 *	@param	p_country_poke_num	OeLXgf[^ڐ
 *	@param	p_country_text_code	OeLXgf[^pR[h
 *	@param	p_country_gmm_idx	OeLXgf[^GMMOڐ
 */
//-----------------------------------------------------------------------------
static void ZknWt_GetCountryPokeData( int monsno, int country, int* p_country_poke_num, int* p_country_text_code, int* p_country_gmm_idx )
{
	// OeLXgpR[hɕϊ
	*p_country_text_code = ZKN_WT_GetLANG_Code_ZKN_WORLD_TEXT_Code( country );
	GF_ASSERT( *p_country_text_code < ZKN_WORLD_TEXT_NUM );	// ƂƂ̓f[^
	// X^[io[OGMM̃f[^ڐ߂
	*p_country_poke_num = ZKN_WT_GetMonsNo_TEXTVERPokeNum( monsno );

	// OeLXgpR[hGMMf[^Oꍀڐ擾
	*p_country_gmm_idx = ZknWt_GetGmmIdx( *p_country_text_code );

	// f[^邩`FbN
	GF_ASSERT( ZknWt_CheckWorldData( *p_country_poke_num, *p_country_gmm_idx ) );
}

//----------------------------------------------------------------------------
/**
 *	@brief	}ӊOeLXgpR[hOeLXgGMMf[^̊Oꍀڐ擾
 *
 *	@param	zkn_text_code	}ӊOeLXgpR[h
 *
 *	@retval	OeLXgGMMf[^Oꍀڐ
 *	@retval ZKN_WORLD_TEXT_NUM͎̎GMMɃf[^
 */
//-----------------------------------------------------------------------------
static inline int ZknWt_GetGmmIdx( int zkn_text_code )
{
	GF_ASSERT( zkn_text_code < ZKN_WORLD_TEXT_NUM );
	
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/05
	// Oꂸ̃eLXg`ɕύX
	return zkn_text_code == TEXTCODE_OWN ? ZKN_WORLD_TEXT_NUM : zkn_text_code;
	// ----------------------------------------------------------------------------
}

