//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		zkn_zukan_sub.c
 *	@brief		}ӃTu
 *	@author		tomoya takahashi 
 *	@data		2006.01.21
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "system.h"
#include "assert.h"
#include <string.h>
#include "include/application/zukanlist/zkn_event_func.h"

#include "include/gflib/vram_transfer_manager.h"
#include "include/system/brightness.h"
#include "include/system/arc_tool.dat"
#include "include/system/arc_util.h"
#include "include/system/clact_util.h"
#include "include/application/zukanlist/zukan.naix"
#include "include/gflib/button_man.h"
#include "include/system/msgdata_util.h"
#include "include/msgdata/msg.naix"
#include "include/msgdata/msg_zkn.h"

#include "include/application/zukanlist/zkn_snd_def.h"
#include "include/application/zukanlist/zkn_zukan_common.h"
#include "include/application/zukanlist/zkn_zukan.h"
#include "include/application/zukanlist/zkn_zukan_graver.h"
#include "include/application/zukanlist/zkn_zukan_textver.h"
#include "include/application/zukanlist/zkn_world_text_sys.h"
#include "include/application/zukanlist/zkn_world_text_data.h"

#define	__ZKN_ZUKAN_SUB_H_GLOBAL
#include "include/application/zukanlist/zkn_zukan_sub.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define ZKN_ZUKAN_SUB_EVENT_NUM ( 3 )	// Cxg
#define ZKN_ZUKAN_SUB_EVENT_CHANGE_NORMAL		(1<<0)
#define ZKN_ZUKAN_SUB_EVENT_CHANGE_TEXT			(1<<1)
#define ZKN_ZUKAN_SUB_EVENT_CHANGE_DATA_MAIN	(1<<2)


#define ZKN_ZUKAN_SUB_OAM_SF_PRI	( 31 )
#define ZKN_ZUKAN_SUB_OAM_BG_PRI	( 2 )

enum{
	ZKN_ZUKANSUB_SEQINIT_ALLOC,
	ZKN_ZUKANSUB_SEQINIT_LOAD,
	ZKN_ZUKANSUB_SEQINIT_FADEIN,
	ZKN_ZUKANSUB_SEQINIT_END,
};
enum{
	ZKN_ZUKANSUB_SEQDELETE_FADEOUT_INIT,
	ZKN_ZUKANSUB_SEQDELETE_FADEOUT,
	ZKN_ZUKANSUB_SEQDELETE_RELEASE,
	ZKN_ZUKANSUB_SEQDELETE_FREE,
	ZKN_ZUKANSUB_SEQDELETE_END,
};

// TuʂŕύXAvP[V^Cv
enum{
	ZKN_ZUKANSUB_CONTROL_NORMAL,	// m[}^Cv}ӂ\
	ZKN_ZUKANSUB_CONTROL_TEXT00,		// eLXgo[W
	ZKN_ZUKANSUB_CONTROL_TEXT01,		// eLXgo[W
	ZKN_ZUKANSUB_CONTROL_TEXT02,		// eLXgo[W
	ZKN_ZUKANSUB_CONTROL_TEXT03,		// eLXgo[W
	ZKN_ZUKANSUB_CONTROL_TEXT04,		// eLXgo[W
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
	ZKN_ZUKANSUB_CONTROL_TEXT05,		// eLXgo[W
#endif
// ----------------------------------------------------------------------------
};

// {^
enum{
	ZKN_ZUKANSUB_BUTTON_NEXT,
	ZKN_ZUKANSUB_BUTTON_BACK,
	ZKN_ZUKANSUB_BUTTON_MY_COUNTRY,		// {^
	ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_00,	// O00{^
	ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_01,	// O01{^
	ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_02,	// O02{^
	ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_03,	// O03{^
	ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_04,	// O04{^
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
	ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_05,	// O05{^
#endif
	ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_MAX,
	ZKN_ZUKANSUB_BUTTON_NUM = ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_MAX,
// ----------------------------------------------------------------------------
};
#define ZKN_ZUKANSUB_BUTTON_SIZE_X	( 160 )
#define ZKN_ZUKANSUB_BUTTON_SIZE_Y	( 40 )
#define ZKN_ZUKANSUB_BUTTON_DEF_X	( 128 )
#define ZKN_ZUKANSUB_BUTTON_NEXT_Y	( 132 )
#define ZKN_ZUKANSUB_BUTTON_BACK_Y		( 76 )
#define ZKN_ZUKANSUB_BUTTON_FONT_OFS_Y	( -6 )
#define ZKN_ZUKANSUB_BUTTON_FONT_NEXT_OFS_X	( -32 )
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/20
// ua`bjvE
#define ZKN_ZUKANSUB_BUTTON_FONT_BACK_OFS_X	( 32 )
// ----------------------------------------------------------------------------
#define ZKN_ZUKANSUB_BUTTON_ANM_SEQ		( 0 )
#define ZKN_ZUKANSUB_BUTTONFONT_BMP_SIZE_CX	( 8 )
#define ZKN_ZUKANSUB_BUTTONFONT_BMP_SIZE_CY	( 4 )
#define ZKN_ZUKANSUB_BUTTON_NEXTBG_PLTT_NO	(4)
#define ZKN_ZUKANSUB_BUTTON_BACKBG_PLTT_NO	(5)

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
#define ZKN_ZUKANSUB_BUTTON_MY_C_X	(  23 )
#define ZKN_ZUKANSUB_BUTTON_O_C00_X	(  58 )
#define ZKN_ZUKANSUB_BUTTON_O_C01_X	(  93 )
#define ZKN_ZUKANSUB_BUTTON_O_C02_X	( 128 )
#define ZKN_ZUKANSUB_BUTTON_O_C03_X	( 163 )
#define ZKN_ZUKANSUB_BUTTON_O_C04_X	( 198 )
#define ZKN_ZUKANSUB_BUTTON_O_C05_X	( 233 )
#define ZKN_ZUKANSUB_BUTTON_DEF_Y	( 176 )
#define ZKN_ZUKANSUB_BUTTON_C_SIZE_X	( 35 )
#define ZKN_ZUKANSUB_BUTTON_C_SIZE_Y	( 32 )
#else
#define ZKN_ZUKANSUB_BUTTON_MY_C_X	( 28 )
#define ZKN_ZUKANSUB_BUTTON_O_C00_X	( 68 )
#define ZKN_ZUKANSUB_BUTTON_O_C01_X	( 108 )
#define ZKN_ZUKANSUB_BUTTON_O_C02_X	( 148 )
#define ZKN_ZUKANSUB_BUTTON_O_C03_X	( 188 )
#define ZKN_ZUKANSUB_BUTTON_O_C04_X	( 228 )
#define ZKN_ZUKANSUB_BUTTON_DEF_Y	( 176 )
#define ZKN_ZUKANSUB_BUTTON_C_SIZE_X	( 40 )
#define ZKN_ZUKANSUB_BUTTON_C_SIZE_Y	( 32 )
#endif
enum{
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_JPN_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_JPN_ON,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_E_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_E_ON,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_FRA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_FRA_ON,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_GER_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_GER_ON,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_ITA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_ITA_ON,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_SPA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_SPA_ON,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_BACK_ICON,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_NEXT_ICON,
#if PM_LANG == LANG_KOREA
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_KOR_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_KOR_ON,
#endif
};
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/10/05
// o[WɂāAOꂸ{^̕т\[g悤ɕύX
// localize_spec_mark(LANG_KOREA) imatake 2007/06/27
// ؍łmakeɑΉ
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g

#define ZKN_ZUKANSUB_BUTTON_WORLD_NUM	(ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_MAX - ZKN_ZUKANSUB_BUTTON_MY_COUNTRY)

static u32 const ZukanSub_WorldButtonX[ZKN_ZUKANSUB_BUTTON_WORLD_NUM] = {
	ZKN_ZUKANSUB_BUTTON_MY_C_X  << FX32_SHIFT,
	ZKN_ZUKANSUB_BUTTON_O_C00_X << FX32_SHIFT,
	ZKN_ZUKANSUB_BUTTON_O_C01_X << FX32_SHIFT,
	ZKN_ZUKANSUB_BUTTON_O_C02_X << FX32_SHIFT,
	ZKN_ZUKANSUB_BUTTON_O_C03_X << FX32_SHIFT,
	ZKN_ZUKANSUB_BUTTON_O_C04_X << FX32_SHIFT,
#if PM_LANG == LANG_KOREA
	ZKN_ZUKANSUB_BUTTON_O_C05_X << FX32_SHIFT,
#endif
};

static u32 const ZukanSub_WorldButtonSeq[ZKN_ZUKANSUB_BUTTON_WORLD_NUM] = {
#if (PM_LANG == LANG_JAPAN)
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_JPN_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_E_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_FRA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_GER_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_ITA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_SPA_OFF,
#elif (PM_LANG == LANG_ENGLISH)
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_E_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_FRA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_GER_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_ITA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_SPA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_JPN_OFF,
#elif (PM_LANG == LANG_FRANCE)
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_FRA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_E_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_GER_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_ITA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_SPA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_JPN_OFF,
#elif (PM_LANG == LANG_GERMANY)
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_GER_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_E_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_FRA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_ITA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_SPA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_JPN_OFF,
#elif (PM_LANG == LANG_ITALY)
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_ITA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_E_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_FRA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_GER_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_SPA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_JPN_OFF,
#elif (PM_LANG == LANG_SPAIN)
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_SPA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_E_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_FRA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_GER_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_ITA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_JPN_OFF,
#elif (PM_LANG == LANG_KOREA)
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_KOR_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_E_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_FRA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_GER_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_ITA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_SPA_OFF,
	ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_JPN_OFF,
#endif
};

// ----------------------------------------------------------------------------

#define ZKN_ZUKANSUB_BUTTON_PAL_OFS		( 4 )
#define ZKN_ZUKANSUB_BUTTON_PAL_OFS_ON		( 1 )

#define ZKN_ZUKANSUB_BUTTON_BG_DEF_X	( (ZKN_ZUKANSUB_BUTTON_DEF_X - (ZKN_ZUKANSUB_BUTTON_SIZE_X / 2)) / 8 )
#define ZKN_ZUKANSUB_BUTTON_BG_GRA_Y	( ((ZKN_ZUKANSUB_BUTTON_NEXT_Y - (ZKN_ZUKANSUB_BUTTON_SIZE_Y / 2)) / 8) )
#define ZKN_ZUKANSUB_BUTTON_BG_TEXT_Y	( ((ZKN_ZUKANSUB_BUTTON_BACK_Y - (ZKN_ZUKANSUB_BUTTON_SIZE_Y / 2)) / 8) )

// {^ACR
#define ZKN_ZUKANSUB_BUTTON_ICON_NEXT_OFS_X	( +32 )
#define ZKN_ZUKANSUB_BUTTON_ICON_BACK_OFS_X	( -32 )
#define ZKN_ZUKANSUB_BUTTON_ICON_NEXT_Y		( ZKN_ZUKANSUB_BUTTON_NEXT_Y + 2 )
#define ZKN_ZUKANSUB_BUTTON_ICON_BACK_Y		( ZKN_ZUKANSUB_BUTTON_BACK_Y + 2 )


//-------------------------------------
//	ǂ̍̌o邩̃}XN	
//=====================================
enum{
	ZKN_ZUKANSUB_COUNTRY_HOME = 1 << 0,
	ZKN_ZUKANSUB_COUNTRY_OUT00 = 1 << 1,
	ZKN_ZUKANSUB_COUNTRY_OUT01 = 1 << 2,
	ZKN_ZUKANSUB_COUNTRY_OUT02 = 1 << 3,
	ZKN_ZUKANSUB_COUNTRY_OUT03 = 1 << 4,
	ZKN_ZUKANSUB_COUNTRY_OUT04 = 1 << 5,
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
	ZKN_ZUKANSUB_COUNTRY_OUT05 = 1 << 6,
	ZKN_ZUKANSUB_COUNTRY_ALL = ZKN_ZUKANSUB_COUNTRY_HOME| ZKN_ZUKANSUB_COUNTRY_OUT00 | ZKN_ZUKANSUB_COUNTRY_OUT01 | ZKN_ZUKANSUB_COUNTRY_OUT02 | ZKN_ZUKANSUB_COUNTRY_OUT03 | ZKN_ZUKANSUB_COUNTRY_OUT04 | ZKN_ZUKANSUB_COUNTRY_OUT05,
#else
	ZKN_ZUKANSUB_COUNTRY_ALL = ZKN_ZUKANSUB_COUNTRY_HOME| ZKN_ZUKANSUB_COUNTRY_OUT00 | ZKN_ZUKANSUB_COUNTRY_OUT01 | ZKN_ZUKANSUB_COUNTRY_OUT02 | ZKN_ZUKANSUB_COUNTRY_OUT03 | ZKN_ZUKANSUB_COUNTRY_OUT04,
#endif
// ----------------------------------------------------------------------------
};
	


#define ZKN_ZUKANSUB_FADE_PLANEMSK	( GX_BLEND_PLANEMASK_BG2|GX_BLEND_PLANEMASK_BG3|GX_BLEND_PLANEMASK_BD )

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	}ӃTuʁ@O[oϐ
//=====================================
typedef struct {
	int* p_event_key;		// CxgL[

	ZKN_GLB_DATA* p_glb;		// O[of[^
	ZKN_ZUKAN_GLB* p_zukan_glb;	// }ӃO[o
	ZKN_APL_DATA* p_zukan_graver_apl;	// }ӃOtBbNo[W
	ZKN_APL_DATA* p_zukan_textver_apl;	// }ӃOtBbNo[W

	// }ӃRTuAvf[^
	const ZKN_APL_DATA* cp_zukan_common_apl;
} ZKN_ZUKAN_SUB_GLB;


//-------------------------------------
//	}ӃTuʁ@`O[oϐ
//=====================================
typedef struct {
	ZKN_GLB_DRAWDATA* p_drawglb;
} ZKN_ZUKAN_SUB_DRAWGLB;

//-------------------------------------
//	{^R[obNւ̃[N
//=====================================
typedef struct {
	void* p_glb;
	void* p_work;
} ZKN_ZUKAN_BUTTON_CALLBACK;


//-------------------------------------
//	}ӃTuʁ@[N
//=====================================
typedef struct {
	// {^}l[W
	BUTTON_MAN* p_button_man;
	TP_HIT_TBL *hit_tbl;	// {^f[^
	ZKN_ZUKAN_BUTTON_CALLBACK callcack;

	// Avf[^
	int now_apply;
	int button_event[ ZKN_ZUKANSUB_BUTTON_NUM ];	// {^Cxgf[^

	int poke_tbl_move;		// NEXT:ZKN_ZUKANSUB_BUTTON_NEXT  BACK:ZKN_ZUKANSUB_BUTTON_BACK  NONE:ZKN_ZUKANSUB_BUTTON_NUM

	u32 poke_country_msk;	// ǂ̍̃eLXgȂo邩
} ZKN_ZUKAN_SUB_WORK;

//-------------------------------------
//	}ӃTuʁ@`惏[N
//=====================================
typedef struct {
	// {^OtBbN
	CLACT_WORK_PTR button[ ZKN_ZUKANSUB_BUTTON_NUM ];
	ZKN_FONTOAM_DATA* p_button_font[ ZKN_ZUKANSUB_BUTTON_NUM ];
	CLACT_U_RES_OBJ_PTR res_obj[ ZKN_CLACT_RES_OBJ_NUM_DEF ];

	// {^ACR
	CLACT_WORK_PTR button_icon[ ZKN_ZUKANSUB_BUTTON_NUM ];

	// O{^OtBbN
	CLACT_U_RES_OBJ_PTR res_obj_world[ ZKN_CLACT_RES_OBJ_NUM_DEF ];

	int	bgpltt_no[ ZKN_ZUKANSUB_BUTTON_NUM ];

	void* pltt_buff[ ZKN_ZUKANSUB_BUTTON_NUM ];


	u32 local_poke_country_msk;	// ǂ̍̃eLXgȂo邩
} ZKN_ZUKAN_SUB_DRAW;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *		AvP[Vf[^쐬֌W
 */
//-----------------------------------------------------------------------------
static ZKN_ZUKAN_SUB_GLB* MakeZukanSubGlb( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_ZUKAN_SUB_DRAWGLB* MakeZukanSubDrawGlb( int heap, ZKN_SYS_PTR zkn_sys );
static ZKN_EVENT_DATA* MakeZukanSubEvent( int heap, ZKN_SYS_PTR zkn_sys );
static void DeleteZukanSubGlb( ZKN_ZUKAN_SUB_GLB* p_glb );
static void DeleteZukanSubDrawGlb( ZKN_ZUKAN_SUB_DRAWGLB* p_glb );
static void DeleteZukanSubEvent( ZKN_EVENT_DATA* p_event );


static int ZukanSubEventDataNumGet( void );


//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
static int ZknZukanSubProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknZukanSubProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknZukanSubProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata );
static int ZknZukanSubProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknZukanSubProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );
static int ZknZukanSubProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata );

// tF[h
static void ZknZukanSubOamFadeInit( ZKN_ZUKAN_SUB_DRAW* p_draw );
static void ZknZukanSubOamFadeDelete( ZKN_ZUKAN_SUB_DRAW* p_draw );
static void ZknZukanSubFadeInit( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, const ZKN_ZUKAN_SUB_GLB* cp_glb, BOOL fadein_out );
static BOOL ZknZukanSubFadeMain( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, const ZKN_ZUKAN_SUB_GLB* cp_glb, BOOL fadein_out );

// {^
static void ZknZukanSubButtonMake( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb, int heap );
static void ZknZukanSubButtonMove( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb );
static void ZknZukanSubButtonDelete( ZKN_ZUKAN_SUB_WORK* p_work );
static void ZknZukanSubButtonCallBack( u32 button_no, u32 event, void* p_work );

// {^`搧
static void ZknZukanSubButtonControl( ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, CLACT_WORK_PTR button, ZKN_FONTOAM_DATA* p_fontoam, int event, int def_y, int bgpltt_no, int* p_nowbgpltt_no, int heap, int off_fontoam_pl, int on_fontoam_pl, void** buff );

static void ZknZukanSubFontButtonMove( CLACT_WORK_PTR act, ZKN_FONTOAM_DATA* p_fontoam, int def_y, int off_pltt, int on_pltt );

// O{^\\ݒ
static void ZknZukanSubWorldTextButtonDrawSet( ZKN_ZUKAN_SUB_DRAW* p_draw, const ZKN_ZUKAN_SUB_WORK* cp_work );
// O{^Aj
static void ZknZUkanSubWorldTextButtonAnm( CLACT_WORK_PTR act, int button_event, int world );

// OeLXg}XNݒ
static void ZknZukanSubWorldTextMskSet( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb );


// ǂݍݏ
static void ZknZukanSubLoadResource( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknZukanSubReleaseResource( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknZukanSubSetUpBg( ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknZukanSubLoadOamData( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknZukanSubReleaseOamData( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb );
static void ZknZukanSubAddClact( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknZukanSubDeleteClact( ZKN_ZUKAN_SUB_DRAW* p_draw );
static void ZknZukanSubAddFontOam( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap );
static void ZknZukanSubDeleteFontOam( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb );

// AvP[VύX
static void ZknZukanSubChangMons( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb, int now_apply );
static void ZknZukanSubApplyChange( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb, int now_apply, int next_apply );


// |P؂ւ
static void ZknZukanSubPokeTblMove(  ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb );
static void ZKnZukanSubKeyMove( ZKN_ZUKAN_SUB_WORK* p_work );

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃTuʁ@Av쐬
 *
 *	@param	p_data		AvP[Vf[^
 *	@param	zkn_sys		}ӃVXe
 *	@param	heap		gpq[v
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_ZukanSubAplMake( ZKN_APL_DATA* p_data, ZKN_SYS_PTR zkn_sys, int heap )
{
	ZKN_ZUKAN_SUB_GLB*	p_glb;
	ZKN_ZUKAN_SUB_DRAWGLB*	p_drawglb;
	ZKN_EVENT_DATA*	p_event;
	
	p_glb = MakeZukanSubGlb( heap, zkn_sys );
	p_drawglb = MakeZukanSubDrawGlb( heap, zkn_sys );
	p_event = MakeZukanSubEvent( heap, zkn_sys );

	p_data->p_glb_data		= p_glb;
	p_data->p_glb_draw		= p_drawglb;
	p_data->p_event_data	= p_event;
	p_data->event_num		= ZukanSubEventDataNumGet();

	p_data->do_func[ ZKN_PROC_FUNC_INIT ] = ZknZukanSubProcDoFuncInit;
	p_data->do_func[ ZKN_PROC_FUNC_MAIN ] = ZknZukanSubProcDoFuncMain;
	p_data->do_func[ ZKN_PROC_FUNC_DELETE ] = ZknZukanSubProcDoFuncDelete;
	p_data->draw_func[ ZKN_PROC_FUNC_INIT ] = ZknZukanSubProcDrawFuncInit;
	p_data->draw_func[ ZKN_PROC_FUNC_MAIN ] = ZknZukanSubProcDrawFuncMain;
	p_data->draw_func[ ZKN_PROC_FUNC_DELETE ] = ZknZukanSubProcDrawFuncDelete;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	|PXg	Tuʁ@j[Avj
 *
 *	@param	p_data	AvP[Vf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ZKN_ZukanSubAplDelete( ZKN_APL_DATA* p_data )
{
	DeleteZukanSubGlb( p_data->p_glb_data ); 
	DeleteZukanSubDrawGlb( p_data->p_glb_data ); 
	DeleteZukanSubEvent( p_data->p_event_data );
}



//-----------------------------------------------------------------------------
/**
 *		vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃTuʁ@O[of[^쐬
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	O[of[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_ZUKAN_SUB_GLB* MakeZukanSubGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_ZUKAN_SUB_GLB* p_glb;
	ZKN_APL_DATA* p_apl;
	ZKN_GLB_DATA* p_glbdata;
	int i;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_ZUKAN_SUB_GLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_ZUKAN_SUB_GLB) );

	// ϐ
	// CxgL[
	p_glb->p_event_key = ZKN_SYS_GetEventKeyPtrSub( zkn_sys );		

	// O[of[^
	p_glb->p_glb = ZKN_SYS_GetGlbData( zkn_sys );

	// }ӃRAvO[of[^
	p_apl = ZKN_GetAplDataSub( zkn_sys, ZKN_SYS_APLSUB_ZUKAN_COMMON );
	p_glb->cp_zukan_common_apl = p_apl;

	// }ӃO[oϐ
	p_apl = ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN );
	p_glb->p_zukan_glb = p_apl->p_glb_data;

	// }ӃOtBbNo[Wϐ
	p_apl = ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN_GRA );
	p_glb->p_zukan_graver_apl = p_apl;

	// }ӌOtBbNo[Wϐ
	p_apl = ZKN_GetAplDataMain( zkn_sys, ZKN_SYS_APLMAIN_ZUKAN_TEXT );
	p_glb->p_zukan_textver_apl = p_apl;
	
	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Tuʕ`O[o쐬
 *
 *	@param	heap		q[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	Tuʕ`O[o
 */
//-----------------------------------------------------------------------------
static ZKN_ZUKAN_SUB_DRAWGLB* MakeZukanSubDrawGlb( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_ZUKAN_SUB_DRAWGLB* p_glb;
	ZKN_APL_DATA* p_apl;

	p_glb = sys_AllocMemory( heap, sizeof(ZKN_ZUKAN_SUB_DRAWGLB) );
	GF_ASSERT( p_glb );
	memset( p_glb, 0, sizeof(ZKN_ZUKAN_SUB_DRAWGLB) );


	// `f[^
	p_glb->p_drawglb = ZKN_SYS_GetGlbDrawData( zkn_sys );

	return p_glb;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃTuʁ@Cxg쐬
 *
 *	@param	heap		gpq[v
 *	@param	zkn_sys		}ӃVXe
 *
 *	@return	Cxgf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static ZKN_EVENT_DATA* MakeZukanSubEvent( int heap, ZKN_SYS_PTR zkn_sys )
{
	ZKN_EVENT_DATA* p_event_tbl;
	int event_num = ZukanSubEventDataNumGet();

	// Cxgf[^e[u쐬
	p_event_tbl = sys_AllocMemory( heap, sizeof(ZKN_EVENT_DATA) * event_num );
	GF_ASSERT( p_event_tbl );
	memset( p_event_tbl, 0, sizeof(ZKN_EVENT_DATA) * event_num );
	
	ZKN_EVENT_MakeChangeZukanOnly( heap, &p_event_tbl[0], zkn_sys, ZKN_ZUKAN_SUB_EVENT_CHANGE_NORMAL );
	ZKN_EVENT_MakeChangeZukanTextMainOnly( heap, &p_event_tbl[1], zkn_sys, ZKN_ZUKAN_SUB_EVENT_CHANGE_TEXT );
	ZKN_EVENT_MakeChangeZukanNormalMainOnly( heap, &p_event_tbl[2], zkn_sys, ZKN_ZUKAN_SUB_EVENT_CHANGE_DATA_MAIN );

	return p_event_tbl;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃTuʁ@O[of[^j
 *
 *	@param	p_glb		O[of[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteZukanSubGlb( ZKN_ZUKAN_SUB_GLB* p_glb )
{
	GF_ASSERT( p_glb );
	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Tuʕ`O[oj
 *
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void DeleteZukanSubDrawGlb( ZKN_ZUKAN_SUB_DRAWGLB* p_glb )
{
	GF_ASSERT( p_glb );
	sys_FreeMemoryEz( p_glb );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃTuʁ@Cxgf[^j
 *
 *	@param	p_event	Cxgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void DeleteZukanSubEvent( ZKN_EVENT_DATA* p_event )
{
	GF_ASSERT( p_event );
	
	ZKN_EVENT_DeleteData( &p_event[0] );
	ZKN_EVENT_DeleteData( &p_event[1] );
	ZKN_EVENT_DeleteData( &p_event[2] );

	sys_FreeMemoryEz( p_event );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӃTuʃAv@Cxg擾
 *	
 *	@param	none	
 *
 *	@return	}ӃTuʃAv@Cxg
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZukanSubEventDataNumGet( void )
{
	return ZKN_ZUKAN_SUB_EVENT_NUM;
}


//-----------------------------------------------------------------------------
/**
 *		vZX֌W
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	[]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknZukanSubProcDoFuncInit( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_ZUKAN_SUB_GLB* p_glb = p_glbdata;
	ZKN_ZUKAN_SUB_WORK* p_work = p_dodata->p_work;
	int i;

	// [N̍쐬
	p_work = sys_AllocMemory( p_dodata->heap, sizeof(ZKN_ZUKAN_SUB_WORK) );
	memset( p_work, 0, sizeof(ZKN_ZUKAN_SUB_WORK) );

	// {^Cxgf[^
	for( i=0; i<ZKN_ZUKANSUB_BUTTON_NUM; i++ ){
		p_work->button_event[ i ] = ZKN_UTIL_BUTTON_PUSH_NONE;	// {^Cxgf[^
	}

	// ̃AvP[V
	p_work->now_apply = ZKN_ZUKANSUB_CONTROL_NORMAL;

	// {^쐬
	ZknZukanSubButtonMake( p_work, p_glb, p_dodata->heap );

	// OeLXgo邩`FbN
	ZknZukanSubWorldTextMskSet( p_work, p_glb );
	
	p_dodata->p_work = p_work;
	
	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 *	[C]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknZukanSubProcDoFuncMain( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_ZUKAN_SUB_GLB* p_glb = p_glbdata;
	ZKN_ZUKAN_SUB_WORK* p_work = p_dodata->p_work;

	// I
	if( p_dodata->end_req == TRUE ){
		return ZKN_PROC_TRUE;
	}

	// lock
	if( p_dodata->lock == TRUE ){
		return ZKN_PROC_FALSE;
	}


	// `FbN
	if( ZKN_ZukanCommonSubMoveFlagGet( p_glb->cp_zukan_common_apl ) ){

		// L[
		ZKnZukanSubKeyMove( p_work );
		
		// {^
		ZknZukanSubButtonMove( p_work, p_glb );

		// |P؂ւ
		ZknZukanSubPokeTblMove( p_work, p_glb );
	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 *	[j]
 *	@brief	AvP[VvZX	f[^ύX
 *
 *	@param	p_dodata	ZKN_PROC_DO_DATA
 *	@param	p_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknZukanSubProcDoFuncDelete( ZKN_PROC_DO_DATA* p_dodata, void* p_glbdata )
{
	ZKN_ZUKAN_SUB_GLB* p_glb = p_glbdata;
	ZKN_ZUKAN_SUB_WORK* p_work = p_dodata->p_work;

	// {^j
	ZknZukanSubButtonDelete( p_work );

	// [Nj
	sys_FreeMemoryEz( p_work );

	return ZKN_PROC_TRUE;
}

//----------------------------------------------------------------------------
/**
 * []
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknZukanSubProcDrawFuncInit( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_ZUKAN_SUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_ZUKAN_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_ZUKAN_SUB_DRAWGLB*	p_drawglb = p_glbdraw;
	ZKN_ZUKAN_SUB_DRAW*		p_drawwork = p_drawdata->p_work;

	switch( p_drawdata->seq ){
	case ZKN_ZUKANSUB_SEQINIT_ALLOC:
		p_drawdata->p_work = sys_AllocMemory( p_drawdata->heap, sizeof(ZKN_ZUKAN_SUB_DRAW) );
		memset( p_drawdata->p_work, 0, sizeof(ZKN_ZUKAN_SUB_DRAW) );
		p_drawdata->seq++;
		break;
		
	case ZKN_ZUKANSUB_SEQINIT_LOAD:
		// Resourceǂݍ
		ZknZukanSubLoadResource( p_drawwork, p_drawglb, p_drawdata->heap );

		// O{^\\ݒ
		ZknZukanSubWorldTextButtonDrawSet( p_drawwork, cp_datawork );
		
		// tF[h
		ZknZukanSubFadeInit( p_drawwork, p_drawglb, cp_dataglb, TRUE );
		
		p_drawdata->seq++;
		break;
		
	case ZKN_ZUKANSUB_SEQINIT_FADEIN:
		if( ZknZukanSubFadeMain( p_drawwork, p_drawglb, cp_dataglb, TRUE ) ){
			p_drawdata->seq++;
		}
		break;
		
	case ZKN_ZUKANSUB_SEQINIT_END:
		
		// J[\AjJn
		ZKN_UTIL_CursorSetAnimeStopFlag( &p_drawglb->p_drawglb->cursor, FALSE );
		return ZKN_PROC_TRUE;
		
	default:
		break;
	}
	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [C]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknZukanSubProcDrawFuncMain( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_ZUKAN_SUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_ZUKAN_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_ZUKAN_SUB_DRAWGLB*	p_drawglb = p_glbdraw;
	ZKN_ZUKAN_SUB_DRAW*		p_drawwork = p_drawdata->p_work;
	int i;	// [vp
	int bgpltt_no;
	BOOL move;


	// }XNύXꂽ{^̕\ύX
	if( p_drawwork->local_poke_country_msk != cp_datawork->poke_country_msk ){
		
		ZknZukanSubWorldTextButtonDrawSet( p_drawwork, cp_datawork );

		p_drawwork->local_poke_country_msk = cp_datawork->poke_country_msk;
	}

	// {^\
	for( i=0; i<=ZKN_ZUKANSUB_BUTTON_BACK; i++ ){
		move = FALSE;
		
		if( i==0 ){	
			move = TRUE;
		}else{
			move = TRUE;
		}
		
		if( move ){
			if( i == ZKN_ZUKANSUB_BUTTON_NEXT ){
				bgpltt_no = ZKN_ZUKANSUB_BUTTON_NEXTBG_PLTT_NO;
			}else{
				bgpltt_no = ZKN_ZUKANSUB_BUTTON_BACKBG_PLTT_NO;
			}
			
			ZknZukanSubButtonControl( p_drawglb, p_drawwork->button[i],
					p_drawwork->p_button_font[i], cp_datawork->button_event[i],
					ZKN_ZUKANSUB_BUTTON_FONT_OFS_Y, bgpltt_no,
					&p_drawwork->bgpltt_no[i], p_drawdata->heap,
					ZKN_ZUKANSUB_BUTTON_PAL_OFS, 
					ZKN_ZUKANSUB_BUTTON_PAL_OFS_ON,
					&p_drawwork->pltt_buff[i] );

			// ACRɓ
			ZKN_UTIL_ButtonMove( p_drawwork->button_icon[i],
			cp_datawork->button_event[i] );

		}
	}

	// Op{^
	for( i=ZKN_ZUKANSUB_BUTTON_MY_COUNTRY; i<ZKN_ZUKANSUB_BUTTON_NUM; i++ ){
		// {^
		ZknZUkanSubWorldTextButtonAnm( p_drawwork->button[i],
				cp_datawork->button_event[i],
				i );

	}

	return ZKN_PROC_FALSE;
}

//----------------------------------------------------------------------------
/**
 * [j]
 *
 *	@brief	AvP[VvZX	`
 *
 *	@param	p_glbdraw	`O[of[^
 *	@param	p_drawdata	ZKN_PROC_DRAW_DATA
 *	@param	cp_glbdata	Ǘ҂󂯎f[^@iۑĂf[^j
 *	@param	cp_dodata	̏̓[Nf[^
 *
 *	@retval	ZKN_PROC_TRUE		̏֐i݂܂B
 *	@retval	ZKN_PROC_FALSE		܂i݂܂B
 *
 *
 */
//-----------------------------------------------------------------------------
static int ZknZukanSubProcDrawFuncDelete( void* p_glbdraw, ZKN_PROC_DRAW_DATA* p_drawdata, const void* cp_glbdata, const ZKN_PROC_DO_DATA* cp_dodata )
{
	const ZKN_ZUKAN_SUB_GLB* cp_dataglb = cp_glbdata;
	const ZKN_ZUKAN_SUB_WORK* cp_datawork = cp_dodata->p_work;
	ZKN_ZUKAN_SUB_DRAWGLB*	p_drawglb = p_glbdraw;
	ZKN_ZUKAN_SUB_DRAW*		p_drawwork = p_drawdata->p_work;

	switch( p_drawdata->seq ){
	case ZKN_ZUKANSUB_SEQDELETE_FADEOUT_INIT:

		// J[\Aj~
		ZKN_UTIL_CursorSetAnimeStopFlag( &p_drawglb->p_drawglb->cursor, TRUE );
		// tF[h
		ZknZukanSubFadeInit( p_drawwork, p_drawglb, cp_dataglb, FALSE );
		p_drawdata->seq++;
		break;
		
	case ZKN_ZUKANSUB_SEQDELETE_FADEOUT:
		if( ZknZukanSubFadeMain( p_drawwork, p_drawglb, cp_dataglb, FALSE ) ){
			p_drawdata->seq++;
		}
		break;

	case ZKN_ZUKANSUB_SEQDELETE_RELEASE:
		// Resourceǂݍ
		ZknZukanSubReleaseResource( p_drawwork, p_drawglb, p_drawdata->heap );
		p_drawdata->seq++;
		break;
		
	case ZKN_ZUKANSUB_SEQDELETE_FREE:
		sys_FreeMemoryEz( p_drawdata->p_work );
		p_drawdata->seq++;
		break;
		
		
	case ZKN_ZUKANSUB_SEQDELETE_END:
		return ZKN_PROC_TRUE;
		
	default:
		break;
	}
	return ZKN_PROC_FALSE;
}




//----------------------------------------------------------------------------
/**
 *	@brief	{^쐬֐
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[o
 *	@param	heap	q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubButtonMake( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb, int heap )
{
	// e[u쐬
	p_work->hit_tbl = sys_AllocMemory( heap, sizeof(TP_HIT_TBL) * ZKN_ZUKANSUB_BUTTON_NUM );

	// e[uf[^ݒ
	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_ZUKANSUB_BUTTON_NEXT ],
			ZKN_ZUKANSUB_BUTTON_NEXT_Y - (ZKN_ZUKANSUB_BUTTON_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_NEXT_Y + (ZKN_ZUKANSUB_BUTTON_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_DEF_X - (ZKN_ZUKANSUB_BUTTON_SIZE_X/2),
			ZKN_ZUKANSUB_BUTTON_DEF_X + (ZKN_ZUKANSUB_BUTTON_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_ZUKANSUB_BUTTON_BACK ],
			ZKN_ZUKANSUB_BUTTON_BACK_Y - (ZKN_ZUKANSUB_BUTTON_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_BACK_Y + (ZKN_ZUKANSUB_BUTTON_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_DEF_X - (ZKN_ZUKANSUB_BUTTON_SIZE_X/2),
			ZKN_ZUKANSUB_BUTTON_DEF_X + (ZKN_ZUKANSUB_BUTTON_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_ZUKANSUB_BUTTON_MY_COUNTRY ],
			ZKN_ZUKANSUB_BUTTON_DEF_Y - (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_DEF_Y + (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_MY_C_X - (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2),
			ZKN_ZUKANSUB_BUTTON_MY_C_X + (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_00 ],
			ZKN_ZUKANSUB_BUTTON_DEF_Y - (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_DEF_Y + (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_O_C00_X - (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2),
			ZKN_ZUKANSUB_BUTTON_O_C00_X + (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_01 ],
			ZKN_ZUKANSUB_BUTTON_DEF_Y - (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_DEF_Y + (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_O_C01_X - (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2),
			ZKN_ZUKANSUB_BUTTON_O_C01_X + (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_02 ],
			ZKN_ZUKANSUB_BUTTON_DEF_Y - (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_DEF_Y + (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_O_C02_X - (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2),
			ZKN_ZUKANSUB_BUTTON_O_C02_X + (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_03 ],
			ZKN_ZUKANSUB_BUTTON_DEF_Y - (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_DEF_Y + (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_O_C03_X - (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2),
			ZKN_ZUKANSUB_BUTTON_O_C03_X + (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2) );

	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_04 ],
			ZKN_ZUKANSUB_BUTTON_DEF_Y - (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_DEF_Y + (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_O_C04_X - (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2),
			ZKN_ZUKANSUB_BUTTON_O_C04_X + (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2) );

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
	ZKN_UTIL_HitTblDataSet( &p_work->hit_tbl[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_05 ],
			ZKN_ZUKANSUB_BUTTON_DEF_Y - (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_DEF_Y + (ZKN_ZUKANSUB_BUTTON_C_SIZE_Y/2),
			ZKN_ZUKANSUB_BUTTON_O_C05_X - (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2),
			ZKN_ZUKANSUB_BUTTON_O_C05_X + (ZKN_ZUKANSUB_BUTTON_C_SIZE_X/2) );
#endif
// ----------------------------------------------------------------------------


	p_work->callcack.p_glb = p_glb;
	p_work->callcack.p_work = p_work;

	// {^}l[W쐬
	p_work->p_button_man = BMN_Create( 
			p_work->hit_tbl,
			ZKN_ZUKANSUB_BUTTON_NUM,
			ZknZukanSubButtonCallBack,
			&p_work->callcack,
			heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^쏈
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubButtonMove( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb )
{
	int i;
	
	// ꂽSẴ{^̊Gɖ߂
	for( i = 0; i < ZKN_ZUKANSUB_BUTTON_NUM; i++ ){
		p_work->button_event[ i ] = BMN_EVENT_SLIDEOUT;
	}

	BMN_Main( p_work->p_button_man );
	
	// ĂO{^́AςȂ
	switch( p_work->now_apply ){
	case ZKN_ZUKANSUB_CONTROL_NORMAL:	// m[}^Cv}ӂ\
		p_work->button_event[ ZKN_ZUKANSUB_BUTTON_MY_COUNTRY ] = BMN_EVENT_RELEASE;
		break;
		
	case ZKN_ZUKANSUB_CONTROL_TEXT00:		// eLXgo[W
		p_work->button_event[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_00 ] = BMN_EVENT_RELEASE;
		break;
		
	case ZKN_ZUKANSUB_CONTROL_TEXT01:		// eLXgo[W
		p_work->button_event[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_01 ] = BMN_EVENT_RELEASE;
		break;
		
	case ZKN_ZUKANSUB_CONTROL_TEXT02:		// eLXgo[W
		p_work->button_event[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_02 ] = BMN_EVENT_RELEASE;
		break;
		
	case ZKN_ZUKANSUB_CONTROL_TEXT03:		// eLXgo[W
		p_work->button_event[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_03 ] = BMN_EVENT_RELEASE;
		break;
		
	case ZKN_ZUKANSUB_CONTROL_TEXT04:		// eLXgo[W
		p_work->button_event[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_04 ] = BMN_EVENT_RELEASE;
		break;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
	case ZKN_ZUKANSUB_CONTROL_TEXT05:		// eLXgo[W
		p_work->button_event[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_05 ] = BMN_EVENT_RELEASE;
		break;
#endif
// ----------------------------------------------------------------------------

	default:
		break;
	}


	// |PύXΉ
	// {^𔽉
	switch( p_work->poke_tbl_move ){
		
	case ZKN_ZUKANSUB_BUTTON_NEXT:
		p_work->button_event[ ZKN_ZUKANSUB_BUTTON_NEXT ] = BMN_EVENT_HOLD;
		break;

	case ZKN_ZUKANSUB_BUTTON_BACK:
		p_work->button_event[ ZKN_ZUKANSUB_BUTTON_BACK ] = BMN_EVENT_HOLD;
		break;
		
	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^j
 *
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubButtonDelete( ZKN_ZUKAN_SUB_WORK* p_work )
{
	BMN_Delete( p_work->p_button_man );

	// e[u[Nj
	sys_FreeMemoryEz( p_work->hit_tbl );
	p_work->hit_tbl = NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^R[obN֐
 *
 *	@param	button_no	{^io[
 *	@param	event		{^Cxg^Cv
 *	@param	p_work		[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubButtonCallBack( u32 button_no, u32 event, void* p_work )
{
	ZKN_ZUKAN_BUTTON_CALLBACK* p_work_data = p_work;
	ZKN_ZUKAN_SUB_GLB* p_glb = p_work_data->p_glb;
	ZKN_ZUKAN_SUB_WORK* p_subwork = p_work_data->p_work;
	BOOL check;

	// {^Cxgi[
	p_subwork->button_event[ button_no ] = event;
	
	switch( event ){
	case BMN_EVENT_HOLD:
		switch( button_no ){
		case ZKN_ZUKANSUB_BUTTON_NEXT:
			p_subwork->poke_tbl_move = ZKN_ZUKANSUB_BUTTON_NEXT;
			break;
			
		case ZKN_ZUKANSUB_BUTTON_BACK:
			p_subwork->poke_tbl_move = ZKN_ZUKANSUB_BUTTON_BACK;
			break;

		case ZKN_ZUKANSUB_BUTTON_MY_COUNTRY:		// {^
			if( p_subwork->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_HOME ){
				// Oꃂ[ĥƂ́Aꃂ[hɂ
				if( p_subwork->now_apply == ZKN_ZUKANSUB_CONTROL_NORMAL ){
					// y[W
					check = ZKN_ZukanAplPageAdd( p_glb->p_zukan_glb, 1 );
				}else{
					// y[W
					ZKN_ZukanAplPageSet( p_glb->p_zukan_glb, 0 );

					check = TRUE;	// tF[h͂
				}

				// AvP[VύXō̃AvP[VZbg
				if( check ){
					ZknZukanSubApplyChange( p_subwork, p_glb, p_subwork->now_apply, ZKN_ZUKANSUB_CONTROL_NORMAL );

					// Iړ
					Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
				}
			}
			break;
			
		case ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_00:	// O00{^
			if( p_subwork->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT00 ){

				if( p_subwork->now_apply == ZKN_ZUKANSUB_CONTROL_TEXT00 ){
					// y[W
					check = ZKN_ZukanTexverPageAdd( p_glb->p_zukan_textver_apl );
				}else{
					// y[W
					ZKN_ZukanTexverPageSet( p_glb->p_zukan_textver_apl, 0 );
					check = TRUE;	// tF[h͂
				}

				if( check ){
					ZknZukanSubApplyChange( p_subwork, p_glb, p_subwork->now_apply, ZKN_ZUKANSUB_CONTROL_TEXT00 );

					// Iړ
					Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );

				}
			}
			break;
			
		case ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_01:	// O01{^
			if( p_subwork->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT01 ){
				// Oꃂ[ĥƂ́Aꃂ[hɂ
				if( p_subwork->now_apply == ZKN_ZUKANSUB_CONTROL_TEXT01 ){
					// y[W
					check = ZKN_ZukanTexverPageAdd( p_glb->p_zukan_textver_apl );
				}else{
					// y[W
					ZKN_ZukanTexverPageSet( p_glb->p_zukan_textver_apl, 0 );
					check = TRUE;	// tF[h͂
				}

				if( check ){
					ZknZukanSubApplyChange( p_subwork, p_glb, p_subwork->now_apply, ZKN_ZUKANSUB_CONTROL_TEXT01 );

					// Iړ
					Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
				}
			}
			break;
			
		case ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_02:	// O02{^
			if( p_subwork->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT02 ){

				// Oꃂ[ĥƂ́Aꃂ[hɂ
				if( p_subwork->now_apply == ZKN_ZUKANSUB_CONTROL_TEXT02 ){
					// y[W
					check = ZKN_ZukanTexverPageAdd( p_glb->p_zukan_textver_apl );
				}else{
					// y[W
					ZKN_ZukanTexverPageSet( p_glb->p_zukan_textver_apl, 0 );
					check = TRUE;	// tF[h͂
				}
				// AvP[VύXō̃AvP[VZbg
				if( check ){
					ZknZukanSubApplyChange( p_subwork, p_glb, p_subwork->now_apply, ZKN_ZUKANSUB_CONTROL_TEXT02 );

					// Iړ
					Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
				}
			}
			break;
			
		case ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_03:	// O03{^
			if( p_subwork->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT03 ){

				// Oꃂ[ĥƂ́Aꃂ[hɂ
				if( p_subwork->now_apply == ZKN_ZUKANSUB_CONTROL_TEXT03 ){
					// y[W
					check = ZKN_ZukanTexverPageAdd( p_glb->p_zukan_textver_apl );
				}else{
					// y[W
					ZKN_ZukanTexverPageSet( p_glb->p_zukan_textver_apl, 0 );
					check = TRUE;	// tF[h͂
				}
				// AvP[VύXō̃AvP[VZbg
				if( check ){
					ZknZukanSubApplyChange( p_subwork, p_glb, p_subwork->now_apply, ZKN_ZUKANSUB_CONTROL_TEXT03 );

					// Iړ
					Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
				}
			}
			break;
			
		case ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_04:	// O04{^
			if( p_subwork->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT04 ){

				// Oꃂ[ĥƂ́Aꃂ[hɂ
				if( p_subwork->now_apply == ZKN_ZUKANSUB_CONTROL_TEXT04 ){
					// y[W
					check = ZKN_ZukanTexverPageAdd( p_glb->p_zukan_textver_apl );
				}else{
					// y[W
					ZKN_ZukanTexverPageSet( p_glb->p_zukan_textver_apl, 0 );
					check = TRUE;	// tF[h͂
				}

				// AvP[VύXō̃AvP[VZbg
				if( check ){
					ZknZukanSubApplyChange( p_subwork, p_glb, p_subwork->now_apply, ZKN_ZUKANSUB_CONTROL_TEXT04 );

					// Iړ
					Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
				}
			}
			break;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
		case ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_05:	// O05{^
			if( p_subwork->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT05 ){

				// Oꃂ[ĥƂ́Aꃂ[hɂ
				if( p_subwork->now_apply == ZKN_ZUKANSUB_CONTROL_TEXT05 ){
					// y[W
					check = ZKN_ZukanTexverPageAdd( p_glb->p_zukan_textver_apl );
				}else{
					// y[W
					ZKN_ZukanTexverPageSet( p_glb->p_zukan_textver_apl, 0 );
					check = TRUE;	// tF[h͂
				}

				// AvP[VύXō̃AvP[VZbg
				if( check ){
					ZknZukanSubApplyChange( p_subwork, p_glb, p_subwork->now_apply, ZKN_ZUKANSUB_CONTROL_TEXT05 );

					// Iړ
					Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
				}
			}
			break;
#endif
// ----------------------------------------------------------------------------

		default:
			break;
		}
		break;

	default:
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	OtBbN
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubLoadResource( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap )
{
	// wi
	ZknZukanSubSetUpBg( p_drawglb, heap );

	// OAM
	ZknZukanSubLoadOamData( p_draw, p_drawglb, heap );

	// ZAN^[o^
	ZknZukanSubAddClact( p_draw, p_drawglb, heap );

	// FONTOAMo^
	ZknZukanSubAddFontOam( p_draw, p_drawglb, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OtBbNj
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubReleaseResource( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap )
{
	int i;


	// pbgZbg
	ZKN_GLBDATA_PalSet( p_drawglb->p_drawglb, NARC_zukan_zkn_data_4_NCLR, PALTYPE_SUB_BG, ZKN_ZUKANSUB_BUTTON_NEXTBG_PLTT_NO*32, 32, heap );
	ZKN_GLBDATA_PalSet( p_drawglb->p_drawglb, NARC_zukan_zkn_data_4_NCLR, PALTYPE_SUB_BG, ZKN_ZUKANSUB_BUTTON_BACKBG_PLTT_NO*32, 32, heap );
	
	// ZAN^[j
	ZknZukanSubDeleteClact( p_draw );

	// FONTOAMj
	ZknZukanSubDeleteFontOam( p_draw, p_drawglb );

	// OAM
	ZknZukanSubReleaseOamData( p_draw, p_drawglb );

	// pbgobt@j
	for( i=0;i<ZKN_ZUKANSUB_BUTTON_NUM; i++ ){
		if( p_draw->pltt_buff[i] ){
			sys_FreeMemoryEz( p_draw->pltt_buff[i] );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGʃZbgAbv
 *
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubSetUpBg( ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap )
{
	void* buff;
	NNSG2dScreenData* p_scrn;

	// LN^f[^]
	ZKN_GLBDATA_BgCharSet( p_drawglb->p_drawglb, NARC_zukan_zkn_data_sub_lzh_NCGR, p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S, 0, 0, TRUE, heap );

	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_data_bg_sub2_c_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S,
			p_scrn->rawData, 0, 0,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );

	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_data_bg_sub2_a_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// {^P	
	GF_BGL_ScrWrite( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S,
			p_scrn->rawData, ZKN_ZUKANSUB_BUTTON_BG_DEF_X, ZKN_ZUKANSUB_BUTTON_BG_GRA_Y,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	sys_FreeMemoryEz( buff );


	// XN[f[^ǂݍ
	buff = ZKN_GLBDATA_ScrnDataGet( p_drawglb->p_drawglb, NARC_zukan_zkn_data_bg_sub2_d_lzh_NSCR, TRUE, &p_scrn, heap );
	
	// {^2
	GF_BGL_ScrWrite( p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S,
			p_scrn->rawData, ZKN_ZUKANSUB_BUTTON_BG_DEF_X, ZKN_ZUKANSUB_BUTTON_BG_TEXT_Y,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );
	
	sys_FreeMemoryEz( buff );



	// XN[f[^]
	GF_BGL_LoadScreenV_Req(p_drawglb->p_drawglb->p_bg, ZKN_BG_FRM_BACK_S );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAM\[Xǂݍ
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubLoadOamData( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;
	ARCHANDLE* p_handle = ZKN_GLBDATA_ArcHandlGet( p_draw_glb );
	
	// LN^f[^ǂݍ
	p_draw->res_obj[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ], p_handle,
			NARC_zukan_zkn_data_oam_sub3_lzh_NCGR, TRUE,
			NARC_zukan_zkn_data_oam_sub3_lzh_NCGR + ZKN_ZUKAN_SUB_RES_ID,
			NNS_G2D_VRAM_TYPE_2DSUB, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_draw->res_obj[ CLACT_U_CHAR_RES ] );

	// Zf[^ǂݍ
	p_draw->res_obj[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ], p_handle,
			NARC_zukan_zkn_data_oam_sub3_lzh_NCER, TRUE,
			NARC_zukan_zkn_data_oam_sub3_lzh_NCER + ZKN_ZUKAN_SUB_RES_ID,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_draw->res_obj[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ], p_handle, 
			NARC_zukan_zkn_data_oam_sub3_lzh_NANR, TRUE,
			NARC_zukan_zkn_data_oam_sub3_lzh_NANR + ZKN_ZUKAN_SUB_RES_ID,
			CLACT_U_CELLANM_RES, heap );


	// LN^f[^ǂݍ
	p_draw->res_obj_world[ CLACT_U_CHAR_RES ] = CLACT_U_ResManagerResAddArcChar_ArcHandle( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ], p_handle,
			NARC_zukan_zkn_data_oam_sub2_lzh_NCGR, TRUE,
			NARC_zukan_zkn_data_oam_sub2_lzh_NCGR + ZKN_ZUKAN_SUB_RES_ID,
			NNS_G2D_VRAM_TYPE_2DSUB, heap );
	// ]
	CLACT_U_CharManagerSetAreaCont( p_draw->res_obj_world[ CLACT_U_CHAR_RES ] );
	// OtBbNf[^j
	CLACT_U_ResManagerResOnlyDelete( p_draw->res_obj_world[ CLACT_U_CHAR_RES ] );

	// Zf[^ǂݍ
	p_draw->res_obj_world[ CLACT_U_CELL_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ], p_handle,
			NARC_zukan_zkn_data_oam_sub2_lzh_NCER, TRUE,
			NARC_zukan_zkn_data_oam_sub2_lzh_NCER + ZKN_ZUKAN_SUB_RES_ID,
			CLACT_U_CELL_RES, heap );

	// ZAjf[^ǂݍ
	p_draw->res_obj_world[ CLACT_U_CELLANM_RES ] = CLACT_U_ResManagerResAddArcKindCell_ArcHandle(
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ], p_handle, 
			NARC_zukan_zkn_data_oam_sub2_lzh_NANR, TRUE,
			NARC_zukan_zkn_data_oam_sub2_lzh_NANR + ZKN_ZUKAN_SUB_RES_ID,
			CLACT_U_CELLANM_RES, heap );
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAM\[Xj
 *
 *	@param	p_draw			`惏[N
 *	@param	p_drawglb		`O[o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubReleaseOamData( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb )
{
	ZKN_GLB_DRAWDATA* p_draw_glb = p_drawglb->p_drawglb;


	CLACT_U_CharManagerDelete( p_draw->res_obj[ CLACT_U_CHAR_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw->res_obj[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw->res_obj[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			p_draw->res_obj[ CLACT_U_CELLANM_RES ] );


	// Ě{^
	CLACT_U_CharManagerDelete( p_draw->res_obj_world[ CLACT_U_CHAR_RES ] );

	// \[Xj
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw->res_obj_world[ CLACT_U_CHAR_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw->res_obj_world[ CLACT_U_CELL_RES ] );
	CLACT_U_ResManagerResDelete( 
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			p_draw->res_obj_world[ CLACT_U_CELLANM_RES ] );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ZAN^[o^
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubAddClact( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap )
{
	CLACT_HEADER		clact_head;
	CLACT_ADD_SIMPLE	add;
	ZKN_GLB_DRAWDATA*	p_draw_glb = p_drawglb->p_drawglb;
	int i;
	
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			NARC_zukan_zkn_data_oam_sub3_lzh_NCGR + ZKN_ZUKAN_SUB_RES_ID,
			NARC_zukan_zkn_data_oam_sub_NCLR + ZKN_ZUKAN_COMMON_SUB_RES_ID_OFS, 
			NARC_zukan_zkn_data_oam_sub3_lzh_NCER + ZKN_ZUKAN_SUB_RES_ID,
			NARC_zukan_zkn_data_oam_sub3_lzh_NANR + ZKN_ZUKAN_SUB_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, ZKN_ZUKAN_SUB_OAM_BG_PRI,
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^ʕݒ
	add.ClActSet	= p_draw_glb->clact_set;
	add.ClActHeader = &clact_head;
	add.pri			= ZKN_ZUKAN_SUB_OAM_SF_PRI;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
	add.heap		= heap;
	
	// OtBbN^CvύX{^
	add.mat.x = ZKN_ZUKANSUB_BUTTON_DEF_X << FX32_SHIFT;
	add.mat.y = ZKN_ZUKANSUB_BUTTON_NEXT_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_draw->button[ ZKN_ZUKANSUB_BUTTON_NEXT ] = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_draw->button[ ZKN_ZUKANSUB_BUTTON_NEXT ], ZKN_ZUKANSUB_BUTTON_ANM_SEQ );	

	// eLXg^CvύX{^
	add.mat.x = ZKN_ZUKANSUB_BUTTON_DEF_X << FX32_SHIFT;
	add.mat.y = ZKN_ZUKANSUB_BUTTON_BACK_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_draw->button[ ZKN_ZUKANSUB_BUTTON_BACK ] = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_draw->button[ ZKN_ZUKANSUB_BUTTON_BACK ], ZKN_ZUKANSUB_BUTTON_ANM_SEQ );	


	// O{^p
	// AN^[wb_[쐬
	CLACT_U_MakeHeader( &clact_head,
			NARC_zukan_zkn_data_oam_sub2_lzh_NCGR + ZKN_ZUKAN_SUB_RES_ID,
			NARC_zukan_zkn_data_oam_sub_NCLR + ZKN_ZUKAN_COMMON_SUB_RES_ID_OFS, 
			NARC_zukan_zkn_data_oam_sub2_lzh_NCER + ZKN_ZUKAN_SUB_RES_ID,
			NARC_zukan_zkn_data_oam_sub2_lzh_NANR + ZKN_ZUKAN_SUB_RES_ID,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE, 0, ZKN_ZUKAN_SUB_OAM_BG_PRI,
			p_draw_glb->res_manager[ CLACT_U_CHAR_RES ],
			p_draw_glb->res_manager[ CLACT_U_PLTT_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELL_RES ],
			p_draw_glb->res_manager[ CLACT_U_CELLANM_RES ],
			NULL, NULL );

	// o^ʕݒ
	add.ClActHeader = &clact_head;

	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/05
	// o[WɂāAOꂸ{^̕т\[g悤ɕύX

	add.mat.y = ZKN_ZUKANSUB_BUTTON_DEF_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	for (i = 0; i < ZKN_ZUKANSUB_BUTTON_WORLD_NUM; ++i) {
		add.mat.x = ZukanSub_WorldButtonX[i];
		p_draw->button[i+ZKN_ZUKANSUB_BUTTON_MY_COUNTRY] = CLACT_AddSimple(&add);
		CLACT_AnmChg(p_draw->button[i+ZKN_ZUKANSUB_BUTTON_MY_COUNTRY], ZukanSub_WorldButtonSeq[i]);
	}

	// ----------------------------------------------------------------------------

	add.pri = ZKN_ZUKAN_SUB_OAM_SF_PRI - 1;
	
	// {^ACR
	add.mat.x = (ZKN_ZUKANSUB_BUTTON_DEF_X + ZKN_ZUKANSUB_BUTTON_ICON_NEXT_OFS_X) << FX32_SHIFT;
	add.mat.y = ZKN_ZUKANSUB_BUTTON_ICON_NEXT_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_draw->button_icon[ ZKN_ZUKANSUB_BUTTON_NEXT ] = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_draw->button_icon[ ZKN_ZUKANSUB_BUTTON_NEXT ], ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_NEXT_ICON );	

	// {^ACR
	add.mat.x = (ZKN_ZUKANSUB_BUTTON_DEF_X + ZKN_ZUKANSUB_BUTTON_ICON_BACK_OFS_X) << FX32_SHIFT;
	add.mat.y = ZKN_ZUKANSUB_BUTTON_ICON_BACK_Y << FX32_SHIFT;
	add.mat.y += SUB_SURFACE_Y;
	p_draw->button_icon[ ZKN_ZUKANSUB_BUTTON_BACK ] = CLACT_AddSimple( &add );
	CLACT_AnmChg( p_draw->button_icon[ ZKN_ZUKANSUB_BUTTON_BACK ], ZKN_ZUKANSUB_BUTTON_WORLD_SEQ_BACK_ICON );
	
	// {^ACRȂ
	for( i=ZKN_ZUKANSUB_BUTTON_BACK + 1; i<ZKN_ZUKANSUB_BUTTON_NUM; i++ ){
		p_draw->button_icon[ i ] = NULL;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	ZAN^[j
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubDeleteClact( ZKN_ZUKAN_SUB_DRAW* p_draw )
{
	int i;

	for( i=0; i<ZKN_ZUKANSUB_BUTTON_NUM; i++ ){
		CLACT_Delete( p_draw->button[ i ] );
		if( p_draw->button_icon[ i ] ){
			CLACT_Delete( p_draw->button_icon[ i ] );
		}
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAM쐬
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	@param	heap		q[v
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubAddFontOam( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, int heap )
{
	GF_BGL_BMPWIN* win;	// 񏑂ݐ
	ZKN_FONTOAM_INIT fontoam_init;
	CLACT_U_RES_OBJ_PTR res_obj;
	ZKN_GLB_DRAWDATA* p_glb_draw = p_drawglb->p_drawglb;
	int pltt_ofs;	// pbgAhX
	int i;

	// CLACTo^ĂKv
	GF_ASSERT( p_draw->button[ ZKN_ZUKANSUB_BUTTON_NEXT ] );

	// pbg̃\[Xf[^擾
	// pbgvNV擾p
	res_obj = CLACT_U_ResManagerGetIDResObjPtr( p_glb_draw->res_manager[ CLACT_U_PLTT_RES ], NARC_zukan_zkn_data_oam_sub_NCLR + ZKN_ZUKAN_COMMON_SUB_RES_ID_OFS );

	// f[^̋ʕ쐬
	// ʃf[^
	fontoam_init.zkn_fontoam = p_glb_draw->fontoam_sys;
	fontoam_init.pltt		 = CLACT_U_PlttManagerGetProxy( res_obj, NULL );
	fontoam_init.y			 = ZKN_ZUKANSUB_BUTTON_FONT_OFS_Y;
	fontoam_init.bg_pri		 = ZKN_ZUKAN_SUB_OAM_BG_PRI;
	fontoam_init.soft_pri	 = 0;
	fontoam_init.draw_area	 = NNS_G2D_VRAM_TYPE_2DSUB;
	fontoam_init.heap		 = heap;

	// pbg]AhX擾
	pltt_ofs = GetPlttProxyOffset( fontoam_init.pltt, NNS_G2D_VRAM_TYPE_2DSUB );

	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( p_glb_draw->fontoam_sys, 
			ZKN_ZUKANSUB_BUTTONFONT_BMP_SIZE_CX,
			ZKN_ZUKANSUB_BUTTONFONT_BMP_SIZE_CY );

	// 
	ZKN_FONTOAM_PrintBmpStr( p_glb_draw->fontoam_sys, win,
			NARC_msg_zkn_dat, ZNK_ZUKAN_BUTTON_00, 0, 0 );
	fontoam_init.p_bmp		 = win;
	fontoam_init.parent = p_draw->button[ ZKN_ZUKANSUB_BUTTON_NEXT ];
	fontoam_init.x		= ZKN_ZUKANSUB_BUTTON_FONT_NEXT_OFS_X;
	p_draw->p_button_font[ ZKN_ZUKANSUB_BUTTON_NEXT ] = ZKN_FONTOAM_Make( &fontoam_init );
	FONTOAM_SetPaletteNo( p_draw->p_button_font[ ZKN_ZUKANSUB_BUTTON_NEXT ]->p_fontoam, pltt_ofs + ZKN_ZUKANSUB_BUTTON_PAL_OFS );

	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );


	// rbg}bvEBhE쐬
	win = ZKN_FONTOAM_GetBmp( p_glb_draw->fontoam_sys, 
			ZKN_ZUKANSUB_BUTTONFONT_BMP_SIZE_CX,
			ZKN_ZUKANSUB_BUTTONFONT_BMP_SIZE_CY );

	// ߂
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/11/20
	// ua`bjvE
	{
		u32 width = ZKN_FONTOAM_PrintBmpStr( p_glb_draw->fontoam_sys, win,
						NARC_msg_zkn_dat, ZNK_ZUKAN_BUTTON_01, 0, 0 );
		fontoam_init.x		= ZKN_ZUKANSUB_BUTTON_FONT_BACK_OFS_X - width;
	}
	fontoam_init.p_bmp		 = win;
	fontoam_init.parent = p_draw->button[ ZKN_ZUKANSUB_BUTTON_BACK ];
	// ----------------------------------------------------------------------------
	p_draw->p_button_font[ ZKN_ZUKANSUB_BUTTON_BACK ] = ZKN_FONTOAM_Make( &fontoam_init );
	FONTOAM_SetPaletteNo( p_draw->p_button_font[ ZKN_ZUKANSUB_BUTTON_BACK ]->p_fontoam, pltt_ofs + ZKN_ZUKANSUB_BUTTON_PAL_OFS );

	// rbg}bvEBhEj
	ZKN_FONTOAM_DeleteBmp( win );


	// ͏oȂ
	for( i=ZKN_ZUKANSUB_BUTTON_MY_COUNTRY; i< ZKN_ZUKANSUB_BUTTON_NUM; i++){
		p_draw->p_button_font[ i ] = NULL;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	tHgOAMj
 *	
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb	`O[o
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubDeleteFontOam( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb )
{
	int i;

	for( i=0; i<ZKN_ZUKANSUB_BUTTON_NUM; i++ ){
		if(p_draw->p_button_font[ i ]){
			ZKN_FONTOAM_Delete( p_draw->p_button_font[ i ] );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMtF[h	
 *
 *	@param	p_draw	`惏[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubOamFadeInit( ZKN_ZUKAN_SUB_DRAW* p_draw )
{
	int i;
	// OBJMODE𔼓ɂ
	for( i=0; i<ZKN_ZUKANSUB_BUTTON_NUM; i++ ){
		CLACT_ObjModeSet( p_draw->button[ i ], GX_OAM_MODE_XLU );
		if(p_draw->p_button_font[ i ]){
			FONTOAM_ObjModeSet( p_draw->p_button_font[ i ]->p_fontoam, GX_OAM_MODE_XLU );
		}
		if(p_draw->button_icon[ i ]){
			CLACT_ObjModeSet( p_draw->button_icon[ i ], GX_OAM_MODE_XLU );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAMtF[h@㏈
 *
 *	@param	p_draw 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubOamFadeDelete( ZKN_ZUKAN_SUB_DRAW* p_draw )
{
	int i;
	// OBJMODEm[}ɂ
	for( i=0; i<ZKN_ZUKANSUB_BUTTON_NUM; i++ ){
		CLACT_ObjModeSet( p_draw->button[ i ], GX_OAM_MODE_NORMAL );
		if(p_draw->p_button_font[ i ]){
			FONTOAM_ObjModeSet( p_draw->p_button_font[ i ]->p_fontoam, GX_OAM_MODE_NORMAL );
		}
		if(p_draw->button_icon[ i ]){
			CLACT_ObjModeSet( p_draw->button_icon[ i ], GX_OAM_MODE_NORMAL );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	TuʃtF[h
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb		O[o
 *	@param	fadein_out	tF[hC@TRUE@AEg FALSE	
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubFadeInit( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, const ZKN_ZUKAN_SUB_GLB* cp_glb, BOOL fadein_out )
{
	// OAMݒ
	ZknZukanSubOamFadeInit( p_draw );

	// uCglXsĂ悢
	if( ZKN_ZukanCommonSubBrightnessOnFlagGet( cp_glb->cp_zukan_common_apl ) ){
		if( fadein_out ){
			// tF[hC
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade_sub, ZKN_FADE_SYNC_COMMON,
					BRIGHTNESS_BLACK, BRIGHTNESS_NORMAL, 0, 16, ZKN_ZUKANSUB_FADE_PLANEMSK, ZKN_BRIGHTNESS_MSK_PLANE2DEF, ZKN_UTIL_FADE_SUB );
		}else{
			// tF[hAEg
			ZKN_GLB_ChangeFadeRequest( &p_drawglb->p_drawglb->fade_sub, ZKN_FADE_SYNC_COMMON,
					BRIGHTNESS_NORMAL, BRIGHTNESS_BLACK, 16, 0, ZKN_ZUKANSUB_FADE_PLANEMSK, ZKN_BRIGHTNESS_MSK_PLANE2DEF, ZKN_UTIL_FADE_SUB );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	tF[h@C
 *
 *	@param	p_draw		`惏[N
 *	@param	p_drawglb		`O[o
 *	@param	cp_glb		O[o
 *	@param	fadein_out	tF[hC@TRUE@AEg@FALSE
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
static BOOL ZknZukanSubFadeMain( ZKN_ZUKAN_SUB_DRAW* p_draw, ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, const ZKN_ZUKAN_SUB_GLB* cp_glb, BOOL fadein_out )
{
	BOOL check;

	// uCglX悤łĂ邩`FbN
	if( ZKN_ZukanCommonSubBrightnessOnFlagGet( cp_glb->cp_zukan_common_apl ) ){
		check = ZKN_GLB_ChangeFadeMain( &p_drawglb->p_drawglb->fade_sub );
	}else{
//		check = ZKN_GLB_ChangeFadeEndCheck( &p_drawglb->p_drawglb->fade_sub );
		check = IsFinishedBrightnessChg( MASK_SUB_DISPLAY );
	}

	// II
	if( check ){
		if( fadein_out ){
			// OAMj
			ZknZukanSubOamFadeDelete( p_draw );
		}

		return TRUE;
	}

	return FALSE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	{^`搧
 *
 *	@param	button		{^AN^[
 *	@param	event		Cxg
 *	@param	p_fontoam	tHgOAM
 *	@param	def_y		Y
 *	@param	bgpltt_no	BGpbgNO
 *	@param	heap		q[v
 *	@param	off_fontoam_pl	tHgOAMIt
 *	@param	on_fontoam_pl	tHgOAMI
 *	@param	pbgobt@	
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubButtonControl( ZKN_ZUKAN_SUB_DRAWGLB* p_drawglb, CLACT_WORK_PTR button, ZKN_FONTOAM_DATA* p_fontoam, int event, int def_y, int bgpltt_no, int* p_nowbgpltt_no, int heap, int off_fontoam_pl, int on_fontoam_pl, void** buff )
{
	int now_frm;
	NNSG2dPaletteData* p_plt;
	BOOL check;
	BOOL chenge = FALSE;
	int arc_data_idx;

	// {^
	ZKN_UTIL_ButtonMove( button,
			event );


	ZknZukanSubFontButtonMove( 
			button,
			p_fontoam,
			def_y,
			off_fontoam_pl,
			on_fontoam_pl );

	// ݃t[擾
	now_frm = CLACT_AnmFrameGet( button );


	// J[pbgݒ
	switch( now_frm ){
	case ZKN_UTIL_BUTTON_FRAME_NONE:
	case ZKN_UTIL_BUTTON_FRAME_PUSH1:
		if( *p_nowbgpltt_no != 0 ){
			// off_pltt
			chenge = TRUE;
			arc_data_idx = NARC_zukan_zkn_data_4_NCLR;
			*p_nowbgpltt_no = 0;
		}
		break;
	case ZKN_UTIL_BUTTON_FRAME_PUSH2:
		if( *p_nowbgpltt_no != 1 ){
			// on_pltt
			chenge = TRUE;
			arc_data_idx = NARC_zukan_zkn_data_5_NCLR;
			*p_nowbgpltt_no = 1;
		}
		break;

	case ZKN_UTIL_BUTTON_FRAME_SELECT:
		if( *p_nowbgpltt_no != 2 ){
			// on_pltt
			chenge = TRUE;
			arc_data_idx = NARC_zukan_zkn_data_3_NCLR;
			*p_nowbgpltt_no = 2;
		}
		break;
	}
	if( chenge ){
		// ܂ł̂j
		if( *buff ){
			sys_FreeMemoryEz( *buff );
		}
		*buff = ZKN_GLBDATA_PalDataGet( p_drawglb->p_drawglb, arc_data_idx, &p_plt, heap );
		// TransferManagerɓo^
		check = AddVramTransferManager(
				NNS_GFD_DST_2D_BG_PLTT_SUB,
				bgpltt_no*32,
				p_plt->pRawData,
				32);
		// ]^XNs
		GF_ASSERT( check );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	{^tHg
 *
 *	@param	act				AN^[
 *	@param	p_fontoam		tHgOAM
 *	@param	def_y			ftHgYʒu
 *	@param	off_pltt		{^OFF̃J[pbg
 *	@param	on_pltt			{^OÑJ[pbg
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubFontButtonMove( CLACT_WORK_PTR act, ZKN_FONTOAM_DATA* p_fontoam, int def_y, int off_pltt, int on_pltt )
{
	ZKN_UTIL_ButtonFontMove_Col( act, p_fontoam, def_y, off_pltt, on_pltt );
}

//----------------------------------------------------------------------------
/**
 *	@brief	X^[ύX
 *
 *	@param	p_work		[N
 *	@param	p_glb		O[o
 *	@param	now_apply	̃AvP[V
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubChangMons( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb, int now_apply )
{
	int gra_x, gra_y;
	
	// |P̐o
	p_glb->p_zukan_glb->mons_snd_req = TRUE;
		
	// ̃AvtF[h[hݒ
	*p_glb->p_event_key |= ZKN_ZUKAN_SUB_EVENT_CHANGE_DATA_MAIN;
	p_work->now_apply = ZKN_ZUKANSUB_CONTROL_NORMAL;
	gra_x = ZKN_ZUKAN_POKEGRA_MAT_X;
	gra_y = ZKN_ZUKAN_POKEGRA_MAT_Y;
	p_glb->p_zukan_glb->fade_mode = ZKK_ZUKAN_FADE_MODE_OTHER;


	// ̃AvtF[hݒ
	switch( now_apply ){
	case ZKN_ZUKANSUB_CONTROL_NORMAL:	// m[}^Cv}ӂ\
		p_glb->p_zukan_glb->poke_gra_move_x = gra_x;
		p_glb->p_zukan_glb->poke_gra_move_y = gra_y;
		p_glb->p_zukan_glb->fade_mode = ZKK_ZUKAN_FADE_MODE_NORMAL;
		break;
		
	case ZKN_ZUKANSUB_CONTROL_TEXT00:		// O00
	case ZKN_ZUKANSUB_CONTROL_TEXT01:		// O01
	case ZKN_ZUKANSUB_CONTROL_TEXT02:		// O02
	case ZKN_ZUKANSUB_CONTROL_TEXT03:		// O03
	case ZKN_ZUKANSUB_CONTROL_TEXT04:		// O04
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
	case ZKN_ZUKANSUB_CONTROL_TEXT05:		// O05
#endif
// ----------------------------------------------------------------------------
		ZKN_ZukanTextverPokeGraFadeOutSet( p_glb->p_zukan_textver_apl, gra_x, gra_y );
		ZKN_ZukanTextverFadeModeSet( p_glb->p_zukan_textver_apl, ZKK_ZUKANTEXTVER_FADE_MODE_NORMAL );
		break;

	default:
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	AvP[VύX
 *	
 *	@param	p_work			[N
 *	@param	p_glb			O[o
 *	@param	now_apply		̃Av
 *	@param	next_apply		̃Av
 *	@param	fade_mode		tF[h[h	TRUE:|Pc܂ FALSE:StF[h
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubApplyChange( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb, int now_apply, int next_apply )
{
	int gra_x, gra_y;
	int lang_code;

	// |P̐炷
	
	// ̃AvtF[h[hݒ
	switch( next_apply ){
	case ZKN_ZUKANSUB_CONTROL_NORMAL:	// m[}^Cv}ӂ\
		*p_glb->p_event_key |= ZKN_ZUKAN_SUB_EVENT_CHANGE_DATA_MAIN;
		p_work->now_apply = ZKN_ZUKANSUB_CONTROL_NORMAL;
		gra_x = ZKN_ZUKAN_POKEGRA_MAT_X;
		gra_y = ZKN_ZUKAN_POKEGRA_MAT_Y;
		p_glb->p_zukan_glb->fade_mode = ZKK_ZUKAN_FADE_MODE_OTHER;
		break;
		
	case ZKN_ZUKANSUB_CONTROL_TEXT00:		// O00
	case ZKN_ZUKANSUB_CONTROL_TEXT01:		// O01
	case ZKN_ZUKANSUB_CONTROL_TEXT02:		// O02
	case ZKN_ZUKANSUB_CONTROL_TEXT03:		// O03
	case ZKN_ZUKANSUB_CONTROL_TEXT04:		// O04
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
	case ZKN_ZUKANSUB_CONTROL_TEXT05:		// O05
#endif
// ----------------------------------------------------------------------------
		*p_glb->p_event_key |= ZKN_ZUKAN_SUB_EVENT_CHANGE_TEXT;
		p_work->now_apply = next_apply;
		gra_x = ZKN_ZUKANTEXTVER_POKEGRA_MAT_X;
		gra_y = ZKN_ZUKANTEXTVER_POKEGRA_MAT_Y;

		ZKN_ZukanTextverFadeModeSet( p_glb->p_zukan_textver_apl, ZKK_ZUKANTEXTVER_FADE_MODE_OTHER );

		// R[hݒ
		lang_code = ZKN_WT_WORLD_TEXT_GMM_Idx_LANG_Code( next_apply - ZKN_ZUKANSUB_CONTROL_TEXT00 );
		ZKN_ZukanTexverTypeSet( p_glb->p_zukan_textver_apl, lang_code );

		break;

	default:
		break;
	}

	// ̃AvtF[hݒ
	switch( now_apply ){
	case ZKN_ZUKANSUB_CONTROL_NORMAL:	// m[}^Cv}ӂ\
		p_glb->p_zukan_glb->poke_gra_move_x = gra_x;
		p_glb->p_zukan_glb->poke_gra_move_y = gra_y;
		p_glb->p_zukan_glb->fade_mode = ZKK_ZUKAN_FADE_MODE_OTHER;
		break;
		
	case ZKN_ZUKANSUB_CONTROL_TEXT00:		// O00
	case ZKN_ZUKANSUB_CONTROL_TEXT01:		// O01
	case ZKN_ZUKANSUB_CONTROL_TEXT02:		// O02
	case ZKN_ZUKANSUB_CONTROL_TEXT03:		// O03
	case ZKN_ZUKANSUB_CONTROL_TEXT04:		// O04
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
	case ZKN_ZUKANSUB_CONTROL_TEXT05:		// O05
#endif
// ----------------------------------------------------------------------------
		ZKN_ZukanTextverPokeGraFadeOutSet( p_glb->p_zukan_textver_apl, gra_x, gra_y );

		ZKN_ZukanTextverFadeModeSet( p_glb->p_zukan_textver_apl, ZKK_ZUKANTEXTVER_FADE_MODE_OTHER );
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P؂ւ
 *
 *	@param	p_work		[N
 *	@param	p_glb		O[o
 *	@param	up_down		ɍsɍs
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubPokeTblMove( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb )
{
	BOOL check;

	if( p_work->poke_tbl_move != ZKN_ZUKANSUB_BUTTON_NUM ){
		
		// }Ӄf[^ʂŏ㉺ꂽ|Pւ
		if( p_work->poke_tbl_move == ZKN_ZUKANSUB_BUTTON_BACK ){
			// |PXgi߂
			check = ZKN_GLBDATA_PokeListTblNoAdd( p_glb->p_glb, -1 );
		}else{
			// |PXgi߂
			check = ZKN_GLBDATA_PokeListTblNoAdd( p_glb->p_glb, 1 );
		}
		
		if( check == TRUE ){
			// AvP[VύXō̃AvP[VZbg
			ZknZukanSubChangMons( p_work, p_glb, p_work->now_apply );

			// OeLXgo邩`FbN
			ZknZukanSubWorldTextMskSet( p_work, p_glb );

			// Iړ
			Snd_SePlay( ZKN_SND_SELECT_MOVE_ONE );
		}
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	L[ɂύX
 *
 *	@param	p_work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void ZKnZukanSubKeyMove( ZKN_ZUKAN_SUB_WORK* p_work )
{

	if( sys.trg & PAD_KEY_UP ){
		p_work->poke_tbl_move = ZKN_ZUKANSUB_BUTTON_BACK;
		return ;
	}

	if( sys.trg & PAD_KEY_DOWN ){
		p_work->poke_tbl_move = ZKN_ZUKANSUB_BUTTON_NEXT;
		return ;
	}

	p_work->poke_tbl_move = ZKN_ZUKANSUB_BUTTON_NUM;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OeLXg̃{^ONOFFݒ
 *
 *	@param	p_draw		`惏[N
 *	@param	cp_work		f[^[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubWorldTextButtonDrawSet( ZKN_ZUKAN_SUB_DRAW* p_draw, const ZKN_ZUKAN_SUB_WORK* cp_work )
{
	if( (cp_work->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_HOME) == 0 ){
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_MY_COUNTRY ], FALSE );
	}else{
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_MY_COUNTRY ], TRUE );
	}

	if( (cp_work->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT00) == 0 ){
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_00 ], FALSE );
	}else{
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_00 ], TRUE );
	}

	if( (cp_work->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT01) == 0 ){
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_01 ], FALSE );
	}else{
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_01 ], TRUE );
	}

	if( (cp_work->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT02) == 0 ){
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_02 ], FALSE );
	}else{
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_02 ], TRUE );
	}

	if( (cp_work->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT03) == 0 ){
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_03 ], FALSE );
	}else{
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_03 ], TRUE );
	}

	if( (cp_work->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT04) == 0 ){
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_04 ], FALSE );
	}else{
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_04 ], TRUE );
	}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_KOREA) imatake 2007/07/23
// Oꂸ1g
#if PM_LANG == LANG_KOREA
	if( (cp_work->poke_country_msk & ZKN_ZUKANSUB_COUNTRY_OUT05) == 0 ){
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_05 ], FALSE );
	}else{
		CLACT_SetDrawFlag( p_draw->button[ ZKN_ZUKANSUB_BUTTON_OUT_COUNTRY_05 ], TRUE );
	}
#endif
// ----------------------------------------------------------------------------
}

//----------------------------------------------------------------------------
/**
 *	@brief	O}XNݒ
 *
 *	@param	p_work	[N
 *	@param	p_glb	O[of[^
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZukanSubWorldTextMskSet( ZKN_ZUKAN_SUB_WORK* p_work, ZKN_ZUKAN_SUB_GLB* p_glb )
{
	BOOL ret;
	int i;
	int lang;
	
	p_work->poke_country_msk = 0;

	// ̃|P̊OtOݒ肳Ă邩`FbN
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/07/24
// O̐͏Ɍꐔ-1igmmɊ܂ފOꂸ̃eLXgƋʁj
	for( i=0; i<ZKN_WORLD_TEXT_NUM-1; i++ ){
// ----------------------------------------------------------------------------
		// i̒l͊OpR[hł͂ȂGMMIDXlȂ̂
		// OpR[hɕϊ
		lang = ZKN_WT_WORLD_TEXT_GMM_Idx_LANG_Code( i );
		ret = ZKN_GLBDATA_PokeTextVersionFlagGet( p_glb->p_glb, lang );
		if( ret ){
			p_work->poke_country_msk |= ZKN_ZUKANSUB_COUNTRY_HOME;
			p_work->poke_country_msk |= 1 << (i + 1);
		}
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	{^Aj
 *	
 *	@param	act				AN^[
 *	@param	button_event	{^Cxg
 *	@param  world			{^io[	ZKN_ZUKANSUB_BUTTON`萔ƃN
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ZknZUkanSubWorldTextButtonAnm( CLACT_WORK_PTR act, int button_event, int world )
{
	int anm_seq;

	GF_ASSERT( (world >= ZKN_ZUKANSUB_BUTTON_MY_COUNTRY) && (world < ZKN_ZUKANSUB_BUTTON_NUM) );

	// worldAjV[PXio[擾
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/10/05
	// o[WɂāAOꂸ{^̕т\[g悤ɕύX
	anm_seq = ZukanSub_WorldButtonSeq[world - ZKN_ZUKANSUB_BUTTON_MY_COUNTRY];
	// ----------------------------------------------------------------------------
	
	if( button_event == BMN_EVENT_RELEASE ){
		
		// {^ɂ
		CLACT_AnmChg( act, anm_seq + 1 );
	}else{

		// ĂȂ{^ɂ
		CLACT_AnmChg( act, anm_seq );
	}
}
