//============================================================================================
/**
 * @file	b_app_tool.h
 * @brief	퓬pAvʏ
 * @author	Hiroyuki Nakamura
 * @date	06.03.30
 */
//============================================================================================
#ifndef B_APP_TOOL_H
#define B_APP_TOOL_H
#undef GLOBAL
#ifdef B_APP_TOOL_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


#include "battle_cursor.h"


//============================================================================================
//	萔`
//============================================================================================
typedef struct _BAPP_CURSOR_MVWK	BAPP_CURSOR_MVWK;

#define	BAPP_CMV_CANCEL		( 0xfffffffe )	// LZ
#define	BAPP_CMV_NONE		( 0xffffffff )	// 삵

#define	BAPP_CMV_RETBIT		( 0x80 )		// J[\ړőÖʒu֖߂


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ[N쐬
 *
 * @param	heap	q[vID
 *
 * @return	J[\ړ[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL BAPP_CURSOR_MVWK * BAPP_CursorMoveWorkAlloc( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ[N
 *
 * @param	heap	q[vID
 *
 * @return	J[\ړ[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAPP_CursorMoveWorkFree( BAPP_CURSOR_MVWK * wk );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ[N擾FJ[\f[^
 *
 * @param	wk		IJ[\ړ[N
 *
 * @return	J[\f[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL BCURSOR_PTR BAPP_CursorMvWkGetBCURSOR_PTR( BAPP_CURSOR_MVWK * wk );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ[N擾FJ[\ʒu
 *
 * @param	wk		IJ[\ړ[N
 *
 * @return	J[\ʒu
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BAPP_CursorMvWkGetPos( BAPP_CURSOR_MVWK * wk );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ[N擾FJ[\ON/OFF
 *
 * @param	wk		IJ[\ړ[N
 *
 * @return	J[\ON/OFF
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BAPP_CursorMvWkGetFlag( BAPP_CURSOR_MVWK * wk );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ[NZbgFJ[\ON/OFF
 *
 * @param	wk		IJ[\ړ[N
 * @param	flg		ON/OFFtO
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAPP_CursorMvWkSetFlag( BAPP_CURSOR_MVWK * wk, u8 flg );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ[NZbgFJ[\f[^
 *
 * @param	wk		IJ[\ړ[N
 * @param	flg		J[\f[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAPP_CursorMvWkSetBCURSOR_PTR( BAPP_CURSOR_MVWK * wk, BCURSOR_PTR cur );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ[NZbgFJ[\ʒu
 *
 * @param	wk		IJ[\ړ[N
 * @param	pos		J[\ʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAPP_CursorMvWkSetPos( BAPP_CURSOR_MVWK * wk, u8 pos );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ʒu
 *
 * @param	wk		IJ[\ړ[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAPP_CursorMvWkPosInit( BAPP_CURSOR_MVWK * wk );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ[NZbgFJ[\ʒu[N
 *
 * @param	wk		IJ[\ړ[N
 * @param	pwk		J[\ʒu[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAPP_CursorMvWkSetPoint( BAPP_CURSOR_MVWK * wk, const POINTER_WORK * pwk );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ[NZbgFړe[u
 *
 * @param	wk		IJ[\ړ[N
 * @param	mv_tbl	ړe[u
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BAPP_CursorMvWkSetMvTbl( BAPP_CURSOR_MVWK * wk, u32 mv_tbl );

//--------------------------------------------------------------------------------------------
/**
 * IJ[\ړ
 *
 * @param	wk		IJ[\ړ[N
 *
 * @return	쌋
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 BAPP_CursorMove( BAPP_CURSOR_MVWK * wk );


#undef GLOBAL
#endif	/* B_APP_TOOL_H */
