//============================================================================================
/**
 * @file	b_plist_bmp.h
 * @brief	퓬p|PXgBMP֘A
 * @author	Hiroyuki Nakamura
 * @date	05.02.01
 */
//============================================================================================
#ifndef B_PLIST_BMP_H
#define B_PLIST_BMP_H
#undef GLOBAL
#ifdef B_PLIST_BMP_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * BMPEBhE
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_BmpInit( BPLIST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * y[WƂBMPEBhEǉ
 *
 * @param	wk		[N
 * @param	page	y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_BmpAdd( BPLIST_WORK * wk, u32 page );

//--------------------------------------------------------------------------------------------
/**
 * ǉBMPEBhE폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_BmpFree( BPLIST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * BMPEBhES폜
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_BmpFreeAll( BPLIST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * BMP
 *
 * @param	wk		[N
 * @param	page	y[W
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_BmpWrite( BPLIST_WORK * wk, u32 page );

//--------------------------------------------------------------------------------------------
/**
 * bZ[W\
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_TalkMsgSet( BPLIST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * bZ[W\Jn
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_TalkMsgStart( BPLIST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * HP\ & HPQ[W\
 *
 * @param	wk		[N
 * @param	pos		|Pʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_P1_HPPut( BPLIST_WORK * wk, u8 pos );

//--------------------------------------------------------------------------------------------
/**
 * y[WPLv\
 *
 * @param	wk		[N
 * @param	pos		шʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_P1_LvPut( BPLIST_WORK * wk, u8 pos );

//--------------------------------------------------------------------------------------------
/**
 * Z񕜑Iy[WBMP\
 *
 * @param	wk		[N
 * @param	widx	EBhECfbNX
 * @param	pos		Zʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_PPRcv( BPLIST_WORK * wk, u16 widx, u16 pos );

//--------------------------------------------------------------------------------------------
/**
 * `ZG[bZ[W\
 *
 * @param	wk		[N
 *
 * @return	none
 *
 *	y[WUŎgp
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BPL_HidenMsgPut( BPLIST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ACegpbZ[WZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_ItemUseMsgSet( BPLIST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ZɂACegpG[bZ[WZbg
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BattlePokeList_ItemUseSkillErrMsgSet( BPLIST_WORK * wk );


#undef GLOBAL
#endif	// B_PLIST_BMP_H
