//============================================================================================
/**
 * @file	b_plist_main.h
 * @brief	퓬p|PXg
 * @author	Hiroyuki Nakamura
 * @date	05.02.01
 */
//============================================================================================
#ifndef B_PLIST_MAIN_H
#define B_PLIST_MAIN_H
#undef GLOBAL
#ifdef B_PLIST_MAIN_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
// pbg`
#define	BPL_PAL_NN_PLATE	( 0 )		///< pbg00Fv[giʏj
#define	BPL_PAL_MN_PLATE	( 1 )		///< pbg01Fv[gi}`j
#define	BPL_PAL_DN_PLATE	( 2 )		///< pbg02Fv[gimj
#define	BPL_PAL_HPGAGE		( 9 )		///< pbg09FHPQ[W

#define	BPL_PAL_B_RED		( 10 )		///< pbg09F{^iԁj
#define	BPL_PAL_B_GREEN		( 12 )		///< pbg09F{^i΁j

#define	BPL_PAL_SYS_FONT	( 13 )		///< pbg13FVXetHg
#define	BPL_PAL_TALK_WIN	( 14 )		///< pbg14FbEBhE
#define	BPL_PAL_TALK_FONT	( 15 )		///< pbg15FbtHg

#define	BPL_HP_DOTTO_MAX	( 48 )		///< HPQ[W̃hbgTCY

// EBhECfbNX
enum {
	WIN_COMMENT = 0,	///< RgpEBhE
	WIN_TALK,			///< bpEBhE
	WIN_MAX
};

// y[WP̒ǉEBhECfbNX
enum {
	WIN_P1_POKE1 = 0,	// |PP
	WIN_P1_POKE2,		// |PQ
	WIN_P1_POKE3,		// |PR
	WIN_P1_POKE4,		// |PS
	WIN_P1_POKE5,		// |PT
	WIN_P1_POKE6,		// |PU
	WIN_P1_MAX
};

// ւy[W̒ǉEBhECfbNX
enum {
	WIN_CHG_NAME = 0,	// O
	WIN_CHG_IREKAE,		// uꂩv
	WIN_CHG_STATUS,		// u悳݂v
	WIN_CHG_WAZACHECK,	// u킴݂v
	WIN_CHG_MAX
};

// ZIy[W̒ǉEBhECfbNX
enum {
	WIN_STW_NAME = 0,		// O
	WIN_STW_SKILL1,			// ZP
	WIN_STW_SKILL2,			// ZQ
	WIN_STW_SKILL3,			// ZR
	WIN_STW_SKILL4,			// ZS

	WIN_STW_STATUS,			// u悳݂v

	// Xbvp
	WIN_STW_NAME_S,			// OiXbvj
	WIN_STW_SKILL1_S,		// ZPiXbvj
	WIN_STW_SKILL2_S,		// ZQiXbvj
	WIN_STW_SKILL3_S,		// ZRiXbvj
	WIN_STW_SKILL4_S,		// ZSiXbvj

	WIN_STW_MAX
};

// Xe[^XCy[W̒ǉEBhECfbNX
enum {
	WIN_P3_NAME = 0,	// O
	WIN_P3_SPANAME,		// 
	WIN_P3_SPAINFO,		// 
	WIN_P3_ITEMNAME,	// 
	WIN_P3_HPNUM,		// HPl
	WIN_P3_POWNUM,		// Ul
	WIN_P3_DEFNUM,		// hl
	WIN_P3_AGINUM,		// fl
	WIN_P3_SPPNUM,		// Ul
	WIN_P3_SPDNUM,		// hl
	WIN_P3_HPGAGE,		// HPQ[W
	WIN_P3_LVNUM,		// xl
	WIN_P3_NEXTNUM,		// ̃xl

	WIN_P3_HP,			// uHPv
	WIN_P3_POW,			// uv
	WIN_P3_DEF,			// uڂv
	WIN_P3_AGI,			// u΂₳v
	WIN_P3_SPP,			// uƂv
	WIN_P3_SPD,			// uƂڂv
	WIN_P3_LV,			// uLv.v
	WIN_P3_NEXT,		// u̃x܂Łv
	WIN_P3_WAZACHECK,	// u킴݂v

	// Xbvp
	WIN_P3_NAME_S,		// OiXbvj
	WIN_P3_SPANAME_S,	// iXbvj
	WIN_P3_SPAINFO_S,	// iXbvj
	WIN_P3_ITEMNAME_S,	// iXbvj
	WIN_P3_HPNUM_S,		// HPliXbvj
	WIN_P3_POWNUM_S,	// UliXbvj
	WIN_P3_DEFNUM_S,	// hliXbvj
	WIN_P3_AGINUM_S,	// fliXbvj
	WIN_P3_SPPNUM_S,	// UliXbvj
	WIN_P3_SPDNUM_S,	// hliXbvj
	WIN_P3_HPGAGE_S,	// HPQ[WiXbvj
	WIN_P3_LVNUM_S,		// xliXbvj
	WIN_P3_NEXTNUM_S,	// ̃xliXbvj
	WIN_P3_MAX
};

// Xe[^XZڍ׃y[W̒ǉEBhECfbNX
enum {
	WIN_P4_SKILL = 0,	// Z
	WIN_P4_PPNUM,		// PP/PP
	WIN_P4_HITNUM,		// l
	WIN_P4_POWNUM,		// З͒l
	WIN_P4_INFO,		// Z
	WIN_P4_BRNAME,		// ޖ

	WIN_P4_NAME,		// O
	WIN_P4_PP,			// PP
	WIN_P4_HIT,			// u߂イv
	WIN_P4_POW,			// u傭v
	WIN_P4_BUNRUI,		// uԂ邢v

	// Xbvp
	WIN_P4_SKILL_S,		// Z
	WIN_P4_PPNUM_S,		// PP/PP
	WIN_P4_HITNUM_S,	// l
	WIN_P4_POWNUM_S,	// З͒l
	WIN_P4_INFO_S,		// Z
	WIN_P4_BRNAME_S,	// ޖ
	WIN_P4_MAX
};

// ZYIy[W̒ǉEBhECfbNX
enum {
	WIN_P5_NAME = 0,	// O
	WIN_P5_SKILL1,		// ZP
	WIN_P5_SKILL2,		// ZQ
	WIN_P5_SKILL3,		// ZR
	WIN_P5_SKILL4,		// ZS
	WIN_P5_SKILL5,		// ZT
	WIN_P5_MAX
};

// y[WU̒ǉEBhECfbNX
enum {
	WIN_P6_NAME = 0,	// O
	WIN_P6_SKILL,		// Z
	WIN_P6_PP,			// PP
	WIN_P6_PPNUM,		// PP/PP
	WIN_P6_HIT,			// u߂イv
	WIN_P6_POW,			// u傭v
	WIN_P6_HITNUM,		// l
	WIN_P6_POWNUM,		// З͒l
	WIN_P6_INFO,		// Z
	WIN_P6_BUNRUI,		// uԂ邢v
	WIN_P6_BRNAME,		// ޖ
	WIN_P6_WASURERU,	// u킷v
	WIN_P6_MAX
};

// Z񕜑Iy[W̒ǉEBhECfbNX
enum {
	WIN_P7_NAME = 0,	// O
	WIN_P7_SKILL1,		// ZP
	WIN_P7_SKILL2,		// ZQ
	WIN_P7_SKILL3,		// ZR
	WIN_P7_SKILL4,		// ZS
	WIN_P7_MAX
};

// y[WW̒ǉEBhECfbNX
enum {
	WIN_P8_NAME = 0,	// O
	WIN_P8_SKILL,		// Z
	WIN_P8_PP,			// PP
	WIN_P8_PPNUM,		// PP/PP
	WIN_P8_APP,			// uAs[|Cgv
	WIN_P8_INFO,		// Z
	WIN_P8_WASURERU,	// u킷v
	WIN_P8_MAX
};

// ZAN^[ID
enum {
	BPL_CA_ITEM1 = 0,
	BPL_CA_ITEM2,
	BPL_CA_ITEM3,
	BPL_CA_ITEM4,
	BPL_CA_ITEM5,
	BPL_CA_ITEM6,

	BPL_CA_ITEM7,

	BPL_CA_POKE1,
	BPL_CA_POKE2,
	BPL_CA_POKE3,
	BPL_CA_POKE4,
	BPL_CA_POKE5,
	BPL_CA_POKE6,

	BPL_CA_STATUS1,
	BPL_CA_STATUS2,
	BPL_CA_STATUS3,
	BPL_CA_STATUS4,
	BPL_CA_STATUS5,
	BPL_CA_STATUS6,

	BPL_CA_POKETYPE1,
	BPL_CA_POKETYPE2,

	BPL_CA_WAZATYPE1,
	BPL_CA_WAZATYPE2,
	BPL_CA_WAZATYPE3,
	BPL_CA_WAZATYPE4,
	BPL_CA_WAZATYPE5,

	BPL_CA_BUNRUI,

	BPL_CA_CND1,
	BPL_CA_CND2,
	BPL_CA_CND3,
	BPL_CA_CND4,
	BPL_CA_CND5,

	BPL_CA_CB1,
	BPL_CA_CB2,
	BPL_CA_CB3,
	BPL_CA_CB4,
	BPL_CA_CB5,
	BPL_CA_CB6,

	BPL_CA_MAX
};

typedef struct {
	u16	id;		// Zԍ
	u8	pp;		// PP
	u8	mpp;	// őPP

	u8	type;	// ^Cv
	u8	kind;	// 
	u8	hit;	// 
	u8	pow;	// З
}BPL_POKEWAZA;

typedef struct {
	POKEMON_PARAM * pp;		// |Pf[^

	u16	mons;		// |Pԍ
	u16	pow;		// U

	u16	def;		// h
	u16	agi;		// f

	u16	spp;		// U
	u16	spd;		// h

	u16	hp;			// HP
	u16	mhp;		// őHP

	u8	type1;		// ^CvP
	u8	type2;		// ^CvQ
	u8	lv:7;		// x
	u8	sex_put:1;	// ʕ\ijhpj0=ON, 1=OFF
	u8	sex:3;		// 
	u8	st:4;		// Ԉُ
	u8	egg:1;		// ^}S

	u16	spa;		// 
	u16	item;		// ACe

	u32	now_exp;		// ݂̌ol
	u32	now_lv_exp;		// ݂̃x̌ol
	u32	next_lv_exp;	// ̃x̌ol

	u8	style;			// 悳
	u8	beautiful;		// 
	u8	cute;			// 킢
	u8	clever;			// 
	u8	strong;			// ܂

	u8	cb;				// JX^{[
	u8	form;			// tHNo

	BPL_POKEWAZA	waza[4];	// Zf[^

}BPL_POKEDATA;

#define	BPL_BANM_MAX_N	( 3 )		// {^Ajp^[iʏj
#define	BPL_BANM_MAX_E	( 4 )		// {^Ajp^[iȂ{^j
// v[g{^TCY
#define	BPL_BSX_PLATE	( 16 )
#define	BPL_BSY_PLATE	( 6 )
// ߃{^TCY
#define	BPL_BSX_COMMAND	( 13 )
#define	BPL_BSY_COMMAND	( 5 )
// ؂ւ{^TCY
#define	BPL_BSX_UPDOWN	( 5 )
#define	BPL_BSY_UPDOWN	( 5 )
// ߂{^TCY
#define	BPL_BSX_RET		( 5 )
#define	BPL_BSY_RET		( 5 )
// ւ{^
#define	BPL_BSX_CHG		( 30 )
#define	BPL_BSY_CHG		( 17 )
// Z{^TCY
#define	BPL_BSX_WAZA	( 16 )
#define	BPL_BSY_WAZA	( 6 )
// Y{^TCY
#define	BPL_BSX_DEL		( 26 )
#define	BPL_BSY_DEL		( 5 )
// ReXg؂ւ{^TCY
#define	BPL_BSX_CONTEST	( 9 )
#define	BPL_BSY_CONTEST	( 4 )
// Zʒu{^
#define	BPL_BSX_WP		( 5 )
#define	BPL_BSY_WP		( 2 )

typedef struct {
	BPLIST_DATA * dat;	// OQƃf[^

	BPL_POKEDATA	poke[6];	// |Pf[^

	GF_BGL_INI * bgl;		// BGf[^

	PALETTE_FADE_PTR pfd;	// pbgtF[hf[^

	u16	btn_plate1[BPL_BANM_MAX_E][BPL_BSX_PLATE*BPL_BSY_PLATE];		// 퓬̃v[g{^
	u16	btn_plate2[BPL_BANM_MAX_E][BPL_BSX_PLATE*BPL_BSY_PLATE];		// T̃v[g{^
	u16	btn_command[BPL_BANM_MAX_E][BPL_BSX_COMMAND*BPL_BSY_COMMAND];	// ߃{^
	u16	btn_up[BPL_BANM_MAX_E][BPL_BSX_UPDOWN*BPL_BSY_UPDOWN];			// ؂ւ{^ij
	u16	btn_down[BPL_BANM_MAX_E][BPL_BSX_UPDOWN*BPL_BSY_UPDOWN];		// ؂ւ{^ij
	u16	btn_ret[BPL_BANM_MAX_E][BPL_BSX_RET*BPL_BSY_RET];				// ߂{^
	u16	btn_chg[BPL_BANM_MAX_N][BPL_BSX_CHG*BPL_BSY_CHG];				// ւ{^
	u16	btn_waza[BPL_BANM_MAX_E][BPL_BSX_WAZA*BPL_BSY_WAZA];			// Z{^
	u16	btn_del[BPL_BANM_MAX_N][BPL_BSX_DEL*BPL_BSY_DEL];				// Y{^
	u16	btn_contest[BPL_BANM_MAX_N][BPL_BSX_CONTEST*BPL_BSY_CONTEST];	// ReXg؂ւ{^
	u16	btn_wp[BPL_BANM_MAX_N][BPL_BSX_WP*BPL_BSY_WP];					// Zʒu{^

	u16	wb_pal[16*2];	// Z{^̃pbg

	u8	btn_seq;
	u8	btn_cnt;
	u8	btn_id;
	u8	btn_mode:4;
	u8	btn_pat:3;
	u8	btn_flg:1;

	NUMFONT * nfnt;					// 8x8tHg
	MSGDATA_MANAGER * mman;			// bZ[Wf[^}l[W
	WORDSET * wset;					// PZbg
	STRBUF * msg_buf;				// bZ[Wpobt@

	CATS_RES_PTR	crp;				// \[XǗ
	CATS_ACT_PTR	cap[BPL_CA_MAX];	// OAMCAP

	GF_BGL_BMPWIN	win[WIN_MAX];	// BMPEBhEf[^iʏj
	GF_BGL_BMPWIN * add_win;		// BMPEBhEf[^iǉj
	u8	bmp_add_max;				// ǉBMP̐
	u8	bmp_swap;					// Xbv`tO

	u8	init_poke;		// ւΏۂ̃|Pʒu

	u8	bc_put:4;			// Z̕\퓬ReXg
	u8	ev_contest:4;		// ReXg\tO

	u8	seq;			// CV[PX
	u8	ret_seq;		// AV[PX
	u8	page;			// ݂̃y[W
	u8	midx;			// bZ[WCfbNX

	u8	rcv_seq;
	u8	rcv_st;
	u16	rcv_hp;
	u16	rcv_pp[4];

	BAPP_CURSOR_MVWK * cmv_wk;	// J[\䃏[N
	u8	chg_page_cp;			// |Pւy[W̃J[\ʒu
	u8	wws_page_cp;			// Xe[^XZYZIy[W̃J[\ʒu
	u8	wwm_page_cp;			// Xe[^XZYZڍ׃y[W̃J[\ʒu

	u8	multi_pos;				// }`og̗ʒu
}BPLIST_WORK;


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * wʒuɃ|P݂邩
 *
 * @param	wk		[N
 * @param	pos		ʒu
 *
 * @retval	"0 = Ȃ"
 * @retval	"1 = 퓬"
 * @retval	"2 = T"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BattlePokeList_PokeSetCheck( BPLIST_WORK * wk, s32 pos );

//--------------------------------------------------------------------------------------------
/**
 * _uog`FbN
 *
 * @param	wk		[N
 *
 * @retval	"TRUE = _uog"
 * @retval	"FALSE = _uogȊO"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BattlePokeList_DoubleCheck( BPLIST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * }`og`FbN
 *
 * @param	wk		[N
 *
 * @retval	"TRUE = _uog"
 * @retval	"FALSE = _uogȊO"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BattlePokeList_MultiCheck( BPLIST_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * }`ogŃp[gi[̃|P`FbN
 *
 * @param	wk		[N
 * @param	pos		ʒu
 *
 * @retval	"TRUE = ͂"
 * @retval	"FALSE = "
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BattlePokeList_MultiPosCheck( BPLIST_WORK * wk, u8 pos );


#undef GLOBAL
#endif	// B_PLIST_MAIN_H
