
//============================================================================================
/**
 * @file	fight_def.h
 * @bfief	퓬CvO
 * @author	HisashiSogabe
 * @date	05.05.24
 */
//============================================================================================

#include	"battle/battle_common.h"
#include	"poketool/poke_tool.h"
#include	"../src/poketool/poke_tool_def.h"
#include	"battle/server.h"
#include	"battle/client.h"
#include	"system/softsprite.h"
#include	"wazaeffect/we_mana.h"
#include	"system/clact_tool.h"
#include	"battle/ground.h"
#include	"battle/battle_input.h"
#include "system/numfont.h"
#include "system/msgdata.h"
#include "system/wordset.h"
#include "system/palanm.h"
#include "system/gra_tool.h"
#include "vs_demo.h"
#include "field/tvtopic_battle.h"		//TVWATCH_BATTLE_WORK
#include "battle/temoti_gauge.h"
#include "gflib/vram_transfer_manager.h"

#ifndef __FIGHT_DEF_H_
#define __FIGHT_DEF_H_

typedef struct _MYSTATUS MYSTATUS;
typedef struct _MYITEM MYITEM;
typedef struct _POKEPARTY POKEPARTY;
typedef struct _ZUKAN_WORK ZUKAN_WORK;
typedef struct _BOX_DATA BOX_DATA;
typedef struct PERAPVOICE PERAPVOICE;
typedef struct _CONFIG CONFIG;
typedef struct _POKETCH_DATA POKETCH_DATA;

///<퓬p[N\̐錾
struct battle_work
{
	GF_G3DMAN			*g3Dman;					///<3Dʏ}l[W[̃|C^
	GF_BGL_INI			*bgl;
	GF_BGL_BMPWIN		*win;
	MSGDATA_MANAGER		*fight_msg;					///<퓬bZ[WpbZ[Wf[^}l[W̃|C^
	MSGDATA_MANAGER		*attack_msg;				///<퓬bZ[WpbZ[Wf[^}l[W̃|C^iA^bNbZ[Wj
	WORDSET				*wordset;					///<퓬bZ[WpPobt@
	STRBUF				*msg_buf;					///<bZ[WpɊmۂ[Nւ̃|C^
	TCB_PTR				update_tcb;
	TCB_PTR				pinch_tcb;					///<s`SE̐^XN
	TCB_PTR				msgwinmove_tcb;				///<ŏ̉op(BG1ʁibZ[WʁjɃXN[j
	PALETTE_FADE_PTR	pfd;						///<pbgtF[hVXe[Nւ̃|C^
	u32					fight_type;
	SERVER_PARAM		*server_param;
	CLIENT_PARAM		*client_param[CLIENT_MAX];
	int					client_set_max;
	MYSTATUS			*my_status[CLIENT_MAX];		///<v[[
	MYITEM				*my_item;					///<莝ACe
	BAG_CURSOR			*bag_cursor;				///<obÕJ[\f[^
	ZUKAN_WORK			*zw;						///<}Ӄ[N
	BOX_DATA			*box;						///<{bNXf[^
	POKEPARTY			*poke_party[CLIENT_MAX];	///<莝|P̍\
	PERAPVOICE			*poke_voice[CLIENT_MAX];	///<|P̖f[^
	SOFT_SPRITE_MANAGER	*soft_sprite;
	WE_SYS_PTR			wsp;
	CATS_SYS_PTR		csp;
	CATS_RES_PTR		crp;
	POKETCH_DATA		*poketch_data;				///<|Pb`f[^
	TVWATCH_BATTLE_WORK * TVWatchBattleWork;		///<erFߊlԑgp
	u16					trainer_id[CLIENT_MAX];
	u8					trainer_sex[CLIENT_MAX];
	TRAINER_DATA		trainer_data[CLIENT_MAX];	///<g[i[f[^
	GROUND_WORK			ground[GROUND_MAX];			///<nʃ[N(@ + G)
	BI_PARAM_PTR		bip;						///<퓬͉ʃVXe[Nւ̃|C^
	TEMOTIGAUGE_PTR		tg[TEMOTIGAUGE_MAX];		///<莝Q[W[Nւ̃|C^
	NUMFONT				*numfont_hp;				///<8x8tHg(HPp)
	NUMFONT				*numfont_lv;				///<8x8tHg(xp)
	void				*msg_icon;					///<bZ[WEChEDSACRp|C^
	CONFIG				*config;					///<Q[RtBO
	FRIEND_LIST			*friendlist;				///<ƂO[vf[^
	void				*time_icon;					///<ʐMҋ@̎vACR^XN
	

	VS_DEMO_DATA		*vdd;						///<ΐJnOfp[Nւ̃|C^
	POKE_ANM_SYS_PTR	pasp;						///<|PvOAjVXe[Nւ̃|C^
	NNSG2dCellTransferState	*cell_trans;			///<Z]}l[W
	

	EXCHR_PARAM			exchr_param[CLIENT_MAX];	///<ZGtFNgp|PLWJp[^

	BATTLE_TOWER_RECORD	btr;						///<og^[їp[N

	RECORD				*record;					///<JEgAbvp[N

	u8					*bg_area;					///<wiOtBbNޔ̈iLj
	u16					*pal_area;					///<wiOtBbNޔ̈ipbgj

	u8					sio_send_buffer[BATTLE_SIO_BUF_SIZE];	///<ʐMMobt@
	u8					sio_recv_buffer[BATTLE_SIO_BUF_SIZE];	///<ʐMMobt@

	u16					push_bg_palette[0x10*7];	///<BGpbgޔ̈
	u16					push_obj_palette[0x10*7];	///<OBJpbgޔ̈

	u16					sio_send_read;				///<ʐMMobt@ǂݍ݈ʒu
	u16					sio_send_write;				///<ʐMMobt@݈ʒu

	u16					sio_send_over;				///<ʐMMobt@ݎɃI[o[Ƃ̃[N
	u16					sio_recv_read;				///<ʐMMobt@ǂݍ݈ʒu

	u16					sio_recv_write;				///<ʐMMobt@݈ʒu
	u16					sio_recv_over;				///<ʐMMobt@ݎɃI[o[Ƃ̃[N

	u8					*tcb_sio_send_seq_no;		///<ʐMMTCB̃V[PXio[ւ̃|C^
	u8					*tcb_sio_recv_seq_no;		///<ʐMMTCB̃V[PXio[ւ̃|C^

	u8					server_flag;				///<T[oNĂ邩tO
	u8					proc_mode;					///<퓬VXe̓샂[h
	u8					fight_end_flag;				///<퓬ItO
	u8					bld_init_req		:1;		///<uhݒ菉vtO
	u8					vram_init_req		:1;		///<VRAMݒ菉vtO
	u8					bl_vram_init_req	:1;		///<VRAMݒ菉vtOiobOXgʁj
	u8					pinch_se_flag		:2;		///<s`SEtO
	u8					pinch_se_wait		:3;		///<s`SEEGCg

	int					ground_id;					///<n`ID
	int					bg_id;						///<wiID
	int					place_id;					///<n於ID
	u32					battle_status_flag;			///<퓬ʃtO
	int					time_zone;					///<ԑ

	int					safari_ball;				///<Tt@{[̐

	u8					appear_flag[CLIENT_MAX];	///<Jo|PSelMonsNorbgŊi[

	u32					regulation_flag;			///<M[VtO

	u8					win_lose_flag;				///<stO
	u8					demo_seq_no;				///<ߊlfpV[PXio[
	u16					ball_count;					///<{[𓊂

	int					shinka_place_mode;			///<ꏊiiSHINKA_PLACE`j	
	int					contest_see_flag;			///<ReXgǂ̃tO
	int					weather;					///<tB[hV
	int					mizuki_flag;				///<~YLɂǂ̃tO
	u32					seed_temp;					///<̎̑ޔ[N
	int					bg1_scroll;					///<BG1YXN[p[N
	int					get_pokemon_client;			///<ߊl|PClientNo

	int					command_select_flag;		///<R}hZNgŃ{^̃XChC̏IŗƂtO

	u8					no_reshuffle_client;		///<ւłȂClientNorbgŊǗiʐMpj
	u8					dummy[3];
};

#endif __FIGHT_DEF_H_
