
//============================================================================================
/**
 * @file	server.c
 * @bfief	퓬T[ovO
 * @author	HisashiSogabe
 * @date	05.05.24
 */
//============================================================================================

#include "common.h"

#include "battle/battle_server.h"
#include "battle/client.h"
#include "battle/client_tool.h"
#include "battle/fight.h"
#include "battle/fight_tool.h"
#include "battle/scio.h"
#include "battle/server.h"
#include "battle/server_tool.h"
#include "battle/skill_intp.h"
#include "battle/wazano_def.h"
#include "battle/tokusyu_def.h"
#include "battle/tr_ai.h"
#include "battle/tr_ai_def.h"

#include "poketool/monsno.h"
#include "poketool/poke_tool.h"
#include "poketool/waza_tool.h"
#include "poketool/pokeparty.h"
#include "poketool/tr_tool.h"
#include "battle/trtype_def.h"

#include "application/pokelist.h"

#include "system/arc_tool.h"

#include "itemtool/item.h"
#include "itemtool/myitem.h"

#include "server_def.h"

#include "msgdata/msg_fightmsg_dp.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "comm_command_battle.h"
#include "system/snd_tool.h"
#include "field/sysflag_def.h"

#include "bugfix.h"	//add by 2006.08.15

#ifdef PM_DEBUG
#ifdef DEBUG_ONLY_FOR_sogabe
//#define	ORDER_IGNORE_ONLY	//ߖĈႤZoɂ
#endif DEBUG_ONLY_FOR_sogabe
#endif PM_DEBUG

void	*ServerInit(BATTLE_WORK *bw);
int		ServerMain(BATTLE_WORK *battle_work,SERVER_PARAM *server_param);
void	ServerEnd(SERVER_PARAM *server_param);

void	ServerHitCheckAct(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,int defence,int waza_no);

static	void	ServerPokemonParamGet(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<|Pp[^T[o[NɃQbg
static	void	ServerEncountSet(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<GJEg
static	void	ServerTrainerMessage(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<퓬Ƀg[i[oĂăbZ[W\
static	void	ServerPokeAppearCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<|PoꎞɃ`FbN鍀
static	void	ServerCommandSelectInit(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<R}hI
static	void	ServerCommandSelect(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<R}hI
static	void	ServerAgiCalc(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<fvZ
static	void	ServerBeforeAct(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<O
static	void	ServerActionBranch(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<앪򏈗
static	void	ServerFieldConditionCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);	///<ɂĂ퓬ʃ`FbN
static	void	ServerPokeConditionCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<|PɂĂ퓬ʃ`FbN
static	void	ServerSideConditionCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<|PɂĂ퓬ʃ`FbNiɂĂʁj
static	void	ServerTurnEnd(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<퓬^[I
static	void	ServerFightCommand(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<쏈
static	void	ServerItemCommand(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<gp
static	void	ServerPokemonCommand(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<|PI
static	void	ServerEscapeCommand(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<ɂ铮쏈

static	void	ServerSafariBallCommand(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<Tt@Ń{[鏈
static	void	ServerSafariEsaCommand(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<Tt@ŃGT鏈
static	void	ServerSafariDoroCommand(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<Tt@Ńh鏈
static	void	ServerSafariYousumiCommand(BATTLE_WORK *bw,SERVER_PARAM *sp);	///<Tt@ŗlq

static	int		ServerBadgeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no);	///<obW`FbN
static	BOOL	ServerPPCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<PP`FbN
static	BOOL	ServerDefenceCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<UΏۃ`FbN
static	BOOL	ServerTypeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<TYPE`FbN
static	BOOL	ServerStatusCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<Ԉُ`FbN
static	BOOL	ServerTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<`FbN
static	BOOL	ServerSenseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<搧ñACeʂ̃`FbN
static	BOOL	ServerHitCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,int defence,int waza_no);	///<`FbN
static	BOOL	ServerWazaKoukaCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,int defence,int waza_no);	///<Zʃ`FbN
static	BOOL	ServerWazaKoyuuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<ZŗL`FbN

static	void	ServerWazaSequence(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<ZV[PXs
static	void	ServerWazaBefore(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<ZO
static	void	ServerWazaOutCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<Z`FbN
static	void	ServerAddStatusDirectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);	///<ǉʃ`FbNiڒǉ̂݁j
static	void	ServerWazaHazureMessage(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<ȂnbZ[W\
static	void	ServerWazaOut(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<Z
static	void	ServerHPCalc(BATTLE_WORK *bw,SERVER_PARAM *sp);					///<HPvZ
static	void	ServerWazaOutAfterMessage(BATTLE_WORK *bw,SERVER_PARAM *sp);	///<Zł̂낢ȃbZ[W\
static	void	ServerAddStatusCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<ǉʃ`FbNiڒǉȊOj
static	void	ServerWazaOutAfterKouka(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<Zł̂낢Ȍʃ`FbN
static	void	ServerRenzokuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<AŨ`FbN
static	void	ServerSinkuroCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<VN`FbN
static	void	ServerKizetsuEffect(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<CGtFNg
static	void	ServerLoopCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<̓Z̃`FbN
static	void	ServerJibakuEffect(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<΂ɂCGtFNg
static	void	ServerWazaHitAfterCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<Zqbg̃`FbN
static	void	ServerGetExpEffect(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<ol擾GtFNg
static	void	ServerWazaNoBufferSet(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<Zio[obt@Ɋi[
static	void	ServerWazaEnd(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<ZV[PXI
static	void	ServerPokeReshuffleAfter(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<|PꂩV[PX
static	void	ServerWinLose(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<퓬sV[PX
//static	void	ServerQueCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<T[oL[`FbNďI҂

static	void	ServerFightEnd(BATTLE_WORK *bw,SERVER_PARAM *sp);				///<퓬I
static	void	ServerFightEndWait(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<퓬IiʐMΐ펞̑҂j

static	BOOL	ServerReshuffleCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<ւ`FbN
static	BOOL	ServerZenmetsuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<SŃ`FbN
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/24
// Ă1̂̃_uogŁAuĂv̑ΏۂIׂ͂܂sC
#if AFTER_MASTER_070117_FIX
static	BOOL	ServerDirSelectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,u8 client_no,u32 fight_type,int *range,int waza_pos,u32 *dir); ///<UΏۑI`FbN
#else	//AFTER_MASTER_070117_FIX
static	BOOL	ServerDirSelectCheck(SERVER_PARAM *sp,u8 client_no,u32 fight_type,int *range,int waza_pos,u32 *dir); ///<UΏۑI`FbN
#endif	//AFTER_MASTER_070117_FIX
// ----------------------------------------------------------------------------
static	void	ServerFlagOffReqAct(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<폜v̂tO̍폜

static	BOOL	ServerKizetsuCheck(SERVER_PARAM *sp,int next_seq,int no_set_seq,int flag);	///<C`FbN
static	BOOL	ServerGetExpCheck(SERVER_PARAM *sp,int next_seq,int no_set_seq);	///<ol擾`FbN
static	void	ServerOumugaeshiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<IEobt@ւ̑`FbN
static	BOOL	ServerWazaHitAfterCheckAct(BATTLE_WORK *bw,SERVER_PARAM *sp);	///<Zqbg̃`FbN

//static	void	ServerQueCheckSet(SERVER_PARAM *sp,int next_seq,int wait);

static	BOOL	ServerCriticalMessage(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<}ɂbZ[W\
static	BOOL	ServerWazaStatusMessage(BATTLE_WORK *bw,SERVER_PARAM *sp);		///<΂₢܂ЂƂȂǃbZ[W\
static	BOOL	ServerIkariCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	ServerHirumaseruCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
static	BOOL	ServerVanishCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);			///<Ă|Pǂ邩`FbN

///<T[oV[PXe[u
static	const	svFunc	ServerSequenceTbl[]={
	ServerPokemonParamGet,		///<|Pp[^T[o[NɃQbg
	ServerEncountSet,			///<GJEg
	ServerTrainerMessage,		///<퓬Ƀg[i[oĂăbZ[W\
	ServerPokeAppearCheck,		///<|PoꎞɃ`FbN鍀
	ServerCommandSelectInit,	///<R}hI
	ServerCommandSelect,		///<R}hI
	ServerAgiCalc,				///<fvZ
	ServerBeforeAct,			///<O
	ServerActionBranch,			///<앪򏈗
	ServerFieldConditionCheck,	///<ɂĂ퓬ʃ`FbN
	ServerPokeConditionCheck,	///<|PɂĂ퓬ʃ`FbN
	ServerSideConditionCheck,	///<|PɂĂ퓬ʃ`FbNiɂĂʁj
	ServerTurnEnd,				///<퓬^[I

	ServerFightCommand,			///<쏈
	ServerItemCommand,			///<gp
	ServerPokemonCommand,		///<|PI
	ServerEscapeCommand,		///<ɂ铮쏈

	ServerSafariBallCommand,	///<Tt@Ń{[鏈
	ServerSafariEsaCommand,		///<Tt@ŃGT鏈
	ServerSafariDoroCommand,	///<Tt@Ńh鏈
	ServerSafariYousumiCommand,	///<Tt@ŗlq

	ServerWazaSequence,			///<ZV[PXs
	ServerWazaBefore,			///<ZO
	ServerWazaOutCheck,			///<Z`FbN
	ServerAddStatusDirectCheck,	///<ǉʃ`FbNiڒǉ̂݁j
	ServerWazaHazureMessage,	///<ȂnbZ[W\
	ServerWazaOut,				///<Z
	ServerHPCalc,				///<HPvZ
	ServerWazaOutAfterMessage,	///<Zł̂낢ȃbZ[W\
	ServerAddStatusCheck,		///<ǉʃ`FbNiڒǉȊOj
	ServerWazaOutAfterKouka,	///<Zł̂낢Ȍʃ`FbN
	ServerRenzokuCheck,			///<AŨ`FbN
	ServerSinkuroCheck,			///<VN`FbN
	ServerKizetsuEffect,		///<CGtFNg
	ServerLoopCheck,			///<̓Z̃`FbN
	ServerJibakuEffect,			///<΂ɂCGtFNg
	ServerWazaHitAfterCheck,	///<Zqbg̃`FbN
	ServerGetExpEffect,			///<ol擾GtFNg
	ServerWazaNoBufferSet,		///<Zio[obt@֊i[
	ServerWazaEnd,				///<ZV[PXI

	ServerPokeReshuffleAfter,	///<|PꂩV[PX

	ServerWinLose,				///<퓬sV[PX

//	ServerQueCheck,				///<T[oL[`FbNďI҂

	ServerFightEnd,				///<퓬I
	ServerFightEndWait,			///<퓬IiʐMΐ펞̑҂j
};

//============================================================================================
/**
 * @param
 */
//============================================================================================
void	*ServerInit(BATTLE_WORK *bw)
{
	SERVER_PARAM	*sp;
	int				i;

	sp=sys_AllocMemory(HEAPID_BATTLE,sizeof(SERVER_PARAM));

	MI_CpuClearFast(sp,sizeof(SERVER_PARAM));

	ST_ServerWorkInit(sp);
	ST_ServerCounterWorkInit(bw,sp);

	//Wifi̎́AAI[hĂȂ̂Ŗ
	if(!CommStateIsWifiConnect()){
		WazaAIInit(bw,sp,NULL,NULL);
	}

	WT_WazaTableDataGet(&sp->AIWT.wtd);
	sp->AIWT.item=ItemDataTableLoad(HEAPID_BATTLE);

	return sp;
}

//============================================================================================
/**
 * @param
 */
//============================================================================================
int		ServerMain(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(sp->fight_end_flag==0){
		if((BattleWorkWinLoseGet(bw))&&
		  ((BattleWorkWinLoseGet(bw)&FIGHT_ESCAPE_SELECT_PAUSE)==0)){
			sp->server_seq_no=SERVER_WIN_LOSE_NO;
		}
	}

	//̎dl͂ȂȂ܂
#if 0
	//Ԃ肪ĂpbZ[W\V[PX
	if(sp->server_status_flag&SERVER_STATUS_FLAG_KATAYABURI){
		sp->server_status_flag&=SERVER_STATUS_FLAG_KATAYABURI_OFF;
		if(sp->server_seq_no==SERVER_WAZA_SEQUENCE_NO){
			ST_ServerSequenceLoadGosub(sp,ARC_SUB_SEQ,SUB_SEQ_KATAYABURI);
		}
		else{
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_KATAYABURI);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		}
	}
#endif

	ServerSequenceTbl[sp->server_seq_no](bw,sp);
	if(sp->server_seq_no==SERVER_FIGHT_END_WAIT_NO){			///<퓬I
		return 1;
	}
	return 0;
}

//============================================================================================
/**
 * @param
 */
//============================================================================================
void	ServerEnd(SERVER_PARAM *server_param)
{
	//AĨWJ߂̂ŁAJ͕KvȂ
//	if(server_param->AISeqWork){
//		sys_FreeMemoryEz(server_param->AIWT.handle);
//		sys_FreeMemoryEz(server_param->AISeqWork);
//	}
	sys_FreeMemoryEz(server_param->AIWT.item);
	sys_FreeMemoryEz(server_param);
}

//============================================================================================
/**
 *	`FbNƋZʂɂ閽`FbN	
 *
 * @param
 */
//============================================================================================
void	ServerHitCheckAct(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,int defence,int waza_no)
{
	ServerHitCheck(bw,sp,attack,defence,waza_no);
	ServerWazaKoukaCheck(bw,sp,attack,defence,waza_no);
}

//============================================================================================
/**
 *	|Pp[^T[o[NɃQbg
 *
 * @param
 */
//============================================================================================
static	void	ServerPokemonParamGet(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	client_set_max;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(client_no=0;client_no<client_set_max;client_no++){
		ST_PokemonParamGet(bw,sp,client_no,sp->sel_mons_no[client_no]);
	}

	//ΐ푊̌HPۑ
	sp->hp_temp=sp->psp[CLIENT_NO_ENEMY].hp;

	sp->server_seq_no=SERVER_ENCOUNT_SET_NO;
}

//============================================================================================
/**
 *	GJEg
 *
 * @param
 */
//============================================================================================
static	void	ServerEncountSet(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_POKEMON_ENCOUNT);
	sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	sp->next_server_seq_no=SERVER_TRAINER_MESSAGE_NO;
}

//============================================================================================
/**
 *	퓬Ƀg[i[oĂăbZ[W\
 *
 * @param
 */
//============================================================================================
static	void	ServerTrainerMessage(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(ST_ServerTrainerMessageCheck(bw,sp)){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TRAINER_MESSAGE);
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		sp->next_server_seq_no=SERVER_POKE_APPEAR_CHECK_NO;
	}
	else{
		sp->server_seq_no=SERVER_POKE_APPEAR_CHECK_NO;
	}
	//Zʔ̂߂̑fvZ
	ST_ServerPSPAgiCalc(bw,sp);
}

//============================================================================================
/**
 *	|PoꎞɃ`FbN鍀
 *
 * @param
 */
//============================================================================================
static	void	ServerPokeAppearCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	seq_no;

	seq_no=ST_ServerPokeAppearCheck(bw,sp);

	if(seq_no){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	}
	else{
		//Zʔ̂߂̑fvZiʂ̔őfςĂꍇ̂ŁAČvZj
		ST_ServerPSPAgiCalc(bw,sp);
		sp->server_seq_no=SERVER_COMMAND_SELECT_INIT_NO;
	}
}

//============================================================================================
/**
 *	R}hI
 *
 * @param
 */
//============================================================================================
static	void	ServerCommandSelectInit(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	client_set_max;

	client_set_max=BattleWorkClientSetMaxGet(bw);
	
	for(client_no=0;client_no<client_set_max;client_no++){
		sp->com_seq_no[client_no]=0;
		//ĂԂĎ邽߂ɁAZʃ[Ne|ɃRs[
		sp->psp[client_no].waza_kouka_temp=sp->psp[client_no].waza_kouka;
	}

	//R}hIŃ{^XChCƂɗƂtOZbg
	BattleWorkCommandSelectFlagSet(bw,SLIDE_IN_BEFORE);

	sp->server_seq_no=SERVER_COMMAND_SELECT_NO;
}

//============================================================================================
// 	R}hĨV[PXio[
//============================================================================================
enum{
	SCSSEQ_COMMAND_SELECT_INIT=0,
	SCSSEQ_COMMAND_SELECT,
	SCSSEQ_WAZA_SELECT_INIT,
	SCSSEQ_WAZA_SELECT,
	SCSSEQ_DIR_SELECT_INIT,
	SCSSEQ_DIR_SELECT,
	SCSSEQ_ITEM_SELECT_INIT,
	SCSSEQ_ITEM_SELECT,
	SCSSEQ_POKEMON_SELECT_INIT,
	SCSSEQ_POKEMON_SELECT,
	SCSSEQ_ESCAPE_SELECT_INIT,
	SCSSEQ_ESCAPE_SELECT,
	SCSSEQ_COMMAND_SELECT_WAIT,
	SCSSEQ_COMMAND_SELECT_END,
	SCSSEQ_ALERT_MESSAGE_WAIT,
	SCSSEQ_WARUAGAKI_MESSAGE,
	SCSSEQ_SUBBG_WALL_PUT,
};

//============================================================================================
/**
 *	R}hI
 *
 * @param
 */
//============================================================================================
static	void	ServerCommandSelect(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int				client_no;
	int				client_set_max;
	int				fight_type;
	int				command_end_cnt;
	MESSAGE_PARAM	mp;

	client_set_max=BattleWorkClientSetMaxGet(bw);
	fight_type=BattleWorkFightTypeGet(bw);
	command_end_cnt=0;

	for(client_no=0;client_no<client_set_max;client_no++){
		switch(sp->com_seq_no[client_no]){
		case SCSSEQ_COMMAND_SELECT_INIT:
			if((fight_type&FIGHT_TYPE_2vs2)&&
			  ((fight_type&FIGHT_TYPE_MULTI)==0)&&
			  ((client_no==2)&&(sp->com_seq_no[0]!=SCSSEQ_COMMAND_SELECT_END)||
			   (client_no==3)&&(sp->com_seq_no[1]!=SCSSEQ_COMMAND_SELECT_END))){
				break;
			}
			///<ւ|PȂClientNóAR}hIȂ
			if(sp->no_reshuffle_client&No2Bit(client_no)){
				sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
				sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_WAZA_END_NO;	///<ZV[PXI
				break;
			}
			else if(ST_ServerCommandSelectCheck(sp,client_no)==FALSE){
				//R}hIȂPP炳ȂtO𗧂Ă
				sp->otf[client_no].pp_dec_flag=1;
				sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
				sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_FIGHT_COMMAND_NO;
				break;
			}
			SCIO_CommandSelectSet(bw,sp,client_no,sp->sel_mons_no[client_no]);
			sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT;
		case SCSSEQ_COMMAND_SELECT:
			if(ST_ServerBufferResGet(sp,client_no)){
				sp->client_act_work[client_no][ACT_PARA_SELECT_COMMAND]=sp->server_buffer[client_no][0];
				if(fight_type&FIGHT_TYPE_POKE_PARK){
					switch(ST_ServerBufferResGet(sp,client_no)){
					case SELECT_POKEPARK_BALL:
						sp->com_seq_no[client_no]=SCSSEQ_SUBBG_WALL_PUT;
						sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
						sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_SAFARI_BALL_NO;
						break;
					case SELECT_POKEPARK_ESCAPE:
						sp->com_seq_no[client_no]=SCSSEQ_SUBBG_WALL_PUT;
						sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
						sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_ESCAPE_COMMAND_NO;
						break;
					}
				}
				else if(fight_type&FIGHT_TYPE_SAFARI){
					switch(ST_ServerBufferResGet(sp,client_no)){
					case SELECT_SAFARI_BALL:
						sp->com_seq_no[client_no]=SCSSEQ_SUBBG_WALL_PUT;
						sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
						sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_SAFARI_BALL_NO;
						break;
					case SELECT_SAFARI_ESA:
						sp->com_seq_no[client_no]=SCSSEQ_SUBBG_WALL_PUT;
						sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
						sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_SAFARI_ESA_NO;
						break;
					case SELECT_SAFARI_DORO:
						sp->com_seq_no[client_no]=SCSSEQ_SUBBG_WALL_PUT;
						sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
						sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_SAFARI_DORO_NO;
						break;
					case SELECT_SAFARI_ESCAPE:
						sp->com_seq_no[client_no]=SCSSEQ_SUBBG_WALL_PUT;
						sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
						sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_ESCAPE_COMMAND_NO;
						break;
					case SELECT_SAFARI_YOUSUMI:
						sp->com_seq_no[client_no]=SCSSEQ_SUBBG_WALL_PUT;
						sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
						sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_SAFARI_YOUSUMI_NO;
						break;
					}
				}
				else{
					switch(ST_ServerBufferResGet(sp,client_no)){
					case SELECT_FIGHT_COMMAND:
						if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_ALL)==0x0f){
							sp->com_seq_no[client_no]=SCSSEQ_SUBBG_WALL_PUT;
							sp->ret_seq_no[client_no]=SCSSEQ_WARUAGAKI_MESSAGE;
						}
						///<AR[󂯂Ă鎞́AZIȂ
						else if(sp->psp[client_no].wkw.encore_wazano){
							sp->waza_no_pos[client_no]=sp->psp[client_no].wkw.encore_wazapos;
							sp->waza_no_select[client_no]=sp->psp[client_no].wkw.encore_wazano;
							sp->client_act_work[client_no][ACT_PARA_WORK]=0;
							sp->com_seq_no[client_no]=SCSSEQ_SUBBG_WALL_PUT;
							sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
						}
						else{
							sp->com_seq_no[client_no]=SCSSEQ_WAZA_SELECT_INIT;
						}
						sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_FIGHT_COMMAND_NO;
						break;
					case SELECT_ITEM_COMMAND:
						if(BattleWorkFightTypeGet(bw)&FIGHT_TYPE_NO_ITEM_USE){
							mp.msg_id=DouguAlertMsg;
							mp.msg_tag=TAG_NONE;
							SCIO_AlertMessageSet(bw,client_no,mp);
							sp->com_seq_no[client_no]=SCSSEQ_ALERT_MESSAGE_WAIT;
							sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_INIT;
							OS_TPrintf("AlertMessage\n");
						}
						else{
							sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_ITEM_COMMAND_NO;
							sp->com_seq_no[client_no]=SCSSEQ_ITEM_SELECT_INIT;
						}
						break;
					case SELECT_POKEMON_COMMAND:
						sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_POKEMON_COMMAND_NO;
						sp->com_seq_no[client_no]=SCSSEQ_POKEMON_SELECT_INIT;
						break;
					case SELECT_ESCAPE_COMMAND:
						sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_ESCAPE_COMMAND_NO;
						sp->com_seq_no[client_no]=SCSSEQ_ESCAPE_SELECT_INIT;
						break;
#ifdef PM_DEBUG
					case SELECT_DEBUG_ESCAPE_COMMAND:
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_ESCAPE);
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->next_server_seq_no=SERVER_FIGHT_END_NO;
						break;
					case SELECT_DEBUG_WIN_ESCAPE_COMMAND:
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_WIN_ESCAPE);
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->next_server_seq_no=SERVER_FIGHT_END_NO;
						break;
#endif
					case SELECT_CANCEL:
						if(fight_type&FIGHT_TYPE_SIO){
							SCIO_GaugeAnimeStop(bw,client_no);
							sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_INIT;
							sp->com_seq_no[BattleWorkPartnerClientNoGet(bw,client_no)]=SCSSEQ_COMMAND_SELECT_INIT;
						}
						else if((fight_type&FIGHT_TYPE_2vs2)&&(client_no==2)){
							SCIO_GaugeAnimeStop(bw,client_no);
							sp->com_seq_no[0]=SCSSEQ_COMMAND_SELECT_INIT;
							sp->com_seq_no[2]=SCSSEQ_COMMAND_SELECT_INIT;
						}
						else{
							OS_Printf("R}hZNgŁAsSELECT_CALCELI\n");
						}
						break;
					}
				}
			}
			break;
		case SCSSEQ_WAZA_SELECT_INIT:
			SCIO_WazaSelectSet(bw,sp,client_no);
			sp->com_seq_no[client_no]=SCSSEQ_WAZA_SELECT;
		case SCSSEQ_WAZA_SELECT:
			if(ST_ServerBufferResGet(sp,client_no)==SELECT_CANCEL){
				sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_INIT;
			}
			else if(ST_ServerBufferResGet(sp,client_no)){
				if((sp->server_buffer[client_no][0]-1)==AI_ENEMY_ESCAPE){
					sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_ESCAPE_COMMAND_NO;
					sp->com_seq_no[client_no]=SCSSEQ_ESCAPE_SELECT_INIT;
					break;
				}
				else{
					if(ST_ServerWazaNGCheck(bw,sp,client_no,sp->server_buffer[client_no][0]-1,&mp)==FALSE){
						SCIO_AlertMessageSet(bw,client_no,mp);
						sp->com_seq_no[client_no]=SCSSEQ_ALERT_MESSAGE_WAIT;
						sp->ret_seq_no[client_no]=SCSSEQ_WAZA_SELECT_INIT;
					}
					else{
						//Z̃|WVԂĂ
						sp->client_act_work[client_no][ACT_PARA_WORK]=sp->server_buffer[client_no][0];
						sp->waza_no_pos[client_no]=sp->server_buffer[client_no][0]-1;
						sp->waza_no_select[client_no]=sp->psp[client_no].waza[sp->waza_no_pos[client_no]];
						sp->com_seq_no[client_no]=SCSSEQ_DIR_SELECT_INIT;
					}
				}
			}
			break;
		case SCSSEQ_DIR_SELECT_INIT:
			{
				int	range;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/24
// Ă1̂̃_uogŁAuĂv̑ΏۂIׂ͂܂sC
#if AFTER_MASTER_070117_FIX
				if(ServerDirSelectCheck(bw,sp,client_no,fight_type,&range,
										sp->waza_no_pos[client_no],
										&sp->client_act_work[client_no][ACT_PARA_CLIENT_NO])){
#else //AFTER_MASTER_070117_FIX
				if(ServerDirSelectCheck(sp,client_no,fight_type,&range,
										sp->waza_no_pos[client_no],
										&sp->client_act_work[client_no][ACT_PARA_CLIENT_NO])){
#endif //AFTER_MASTER_070117_FIX
// ----------------------------------------------------------------------------
					SCIO_DirSelectSet(bw,sp,range,client_no);
					sp->com_seq_no[client_no]=SCSSEQ_DIR_SELECT;
				}
				else{
					sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
				}
			}
			break;
		case SCSSEQ_DIR_SELECT:
			if(ST_ServerBufferResGet(sp,client_no)==SELECT_CANCEL){
				sp->com_seq_no[client_no]=SCSSEQ_WAZA_SELECT_INIT;
			}
			else if(ST_ServerBufferResGet(sp,client_no)){
				//UΏۂԂĂ
				sp->client_act_work[client_no][ACT_PARA_CLIENT_NO]=sp->server_buffer[client_no][0]-1;
				sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
			}
			break;
		case SCSSEQ_ITEM_SELECT_INIT:
			SCIO_ItemSelectSet(bw,sp,client_no);
			sp->com_seq_no[client_no]=SCSSEQ_ITEM_SELECT;
		case SCSSEQ_ITEM_SELECT:
			if(ST_ServerBufferResGet(sp,client_no)==SELECT_CANCEL){
				sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_INIT;
			}
			else if(ST_ServerBufferResGet(sp,client_no)){
				{
					u32	*data;

					data=(u32 *)&sp->server_buffer[client_no][0];
					//ACeio[ƃy[Wio[ԂĂ
					sp->client_act_work[client_no][ACT_PARA_WORK]=data[0];
					sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
				}
			}
			break;
		case SCSSEQ_POKEMON_SELECT_INIT:
			{
				int	chg_waza;
				int	double_sel=NO_DOUBLE_SEL;
				int	partner_no;

				chg_waza=ST_ServerPokemonSelectCheck(bw,sp,client_no);
				if(((BattleWorkClientTypeGet(bw,client_no)==CLIENT_TYPE_C)||
				    (BattleWorkClientTypeGet(bw,client_no)==CLIENT_TYPE_D))&&
				   ((fight_type==FIGHT_TYPE_2vs2_TRAINER)||
					(fight_type==FIGHT_TYPE_2vs2_SIO)||
					(fight_type==FIGHT_TYPE_BATTLE_TOWER_2vs2)||
				   ((fight_type==FIGHT_TYPE_TAG_BATTLE)&&(BattleWorkClientTypeGet(bw,client_no)==CLIENT_TYPE_C)))){
					partner_no=BattleWorkPartnerClientNoGet(bw,client_no);
					if(sp->client_act_work[partner_no][ACT_PARA_ACT_NO]==SERVER_POKEMON_COMMAND_NO){
						double_sel=sp->client_act_work[partner_no][ACT_PARA_WORK];
					}
				}
				SCIO_PokemonSelectSet(bw,sp,client_no,BPL_MODE_NORMAL,chg_waza,double_sel);
				sp->com_seq_no[client_no]=SCSSEQ_POKEMON_SELECT;
			}
		case SCSSEQ_POKEMON_SELECT:
			if(ST_ServerBufferResGet(sp,client_no)==SELECT_CANCEL){
				sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_INIT;
			}
			else if(ST_ServerBufferResGet(sp,client_no)){
				//I񂾃|P̈ʒuԂĂ
				sp->client_act_work[client_no][ACT_PARA_WORK]=sp->server_buffer[client_no][0]-1;
				sp->reshuffle_sel_mons_no[client_no]=sp->server_buffer[client_no][0]-1;
				sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
				OS_TPrintf("client_no:%d r_sel_mons:%d\n",client_no,sp->reshuffle_sel_mons_no[client_no]);
			}
			break;
		case SCSSEQ_ESCAPE_SELECT_INIT:
			//^[́A߂邩
			if(fight_type&FIGHT_TYPE_TOWER){
				SCIO_YesNoSelectSet(bw,sp,client_no,GiveUpMsg,YNTYPE_YES_NO,NULL,NULL);
				sp->com_seq_no[client_no]=SCSSEQ_ESCAPE_SELECT;
			}
			//g[i[͓Ȃ
			else if((fight_type&FIGHT_TYPE_TRAINER)&&((fight_type&FIGHT_TYPE_SIO)==0)){
				mp.msg_tag=TAG_NONE;
				mp.msg_id=TrainerEscapeMsg;
				SCIO_AlertMessageSet(bw,client_no,mp);
				sp->com_seq_no[client_no]=SCSSEQ_ALERT_MESSAGE_WAIT;
				sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_INIT;
			}
			else if(ST_EscapeNGCheck(bw,sp,client_no,&mp)){
				SCIO_AlertMessageSet(bw,client_no,mp);
				sp->com_seq_no[client_no]=SCSSEQ_ALERT_MESSAGE_WAIT;
				sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_INIT;
			}
			else{
				sp->com_seq_no[client_no]=SCSSEQ_ESCAPE_SELECT;
			}
			break;
		case SCSSEQ_ESCAPE_SELECT:
			if(fight_type&FIGHT_TYPE_TOWER){
				if(ST_ServerBufferResGet(sp,client_no)){
					if(ST_ServerBufferResGet(sp,client_no)==SELECT_CANCEL){
						sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_INIT;
					}
					else{
						sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
					}
				}
			}
			else{
				//ɂł́A͂^I͖
				sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
			}
			//2vs2́A1̖ڂ̓IŁAm
			if((fight_type&FIGHT_TYPE_2vs2)&&
			  ((fight_type&FIGHT_TYPE_MULTI)==0)&&
			   (sp->com_seq_no[client_no]==SCSSEQ_COMMAND_SELECT_WAIT)){
				sp->com_seq_no[BattleWorkPartnerClientNoGet(bw,client_no)]=SCSSEQ_COMMAND_SELECT_WAIT;
			}
			break;
		case SCSSEQ_COMMAND_SELECT_WAIT:
			SCIO_GaugeAnimeStop(bw,client_no);
			if(fight_type==FIGHT_TYPE_2vs2_SIO){
				{
					int	pair_client;

					pair_client=BattleWorkPartnerClientNoGet(bw,client_no);
					if(sp->com_seq_no[pair_client]==SCSSEQ_COMMAND_SELECT_END){
						SCIO_SioWaitMessage(bw,client_no);
					}
				}
			}
			else{
				SCIO_SioWaitMessage(bw,client_no);
			}
			sp->com_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_END;
		case SCSSEQ_COMMAND_SELECT_END:
			command_end_cnt++;
			break;
		case SCSSEQ_ALERT_MESSAGE_WAIT:
			if(ST_ServerBufferResGet(sp,client_no)){
				//NCAg̕ԓobt@NA
				ST_ServerBufferClear(sp,client_no);
				sp->com_seq_no[client_no]=sp->ret_seq_no[client_no];
			}
			break;
		case SCSSEQ_WARUAGAKI_MESSAGE:
			mp.msg_tag=TAG_NICK;
			mp.msg_id=WazaNGMineMsg;
			mp.msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
			SCIO_AlertMessageSet(bw,client_no,mp);
			sp->otf[client_no].waruagaki_flag=1;
			sp->com_seq_no[client_no]=SCSSEQ_ALERT_MESSAGE_WAIT;
			sp->ret_seq_no[client_no]=SCSSEQ_COMMAND_SELECT_WAIT;
			break;
		case SCSSEQ_SUBBG_WALL_PUT:
			SCIO_SubBGWallPut(bw,client_no);
			sp->com_seq_no[client_no]=sp->ret_seq_no[client_no];
			break;
		}
	}
	if(command_end_cnt==client_set_max){
		sp->server_seq_no=SERVER_AGI_CALC_NO;
		//ListRow̕ёւ`FbN
		for(client_no=0;client_no<client_set_max;client_no++){
			if(sp->client_act_work[client_no][ACT_PARA_ACT_NO]==SERVER_POKEMON_COMMAND_NO){
				ST_ServerListRowChange(bw,sp,client_no,sp->reshuffle_sel_mons_no[client_no]);
			}
		}
	}
}

//============================================================================================
/**
 *	fvZ
 *
 * @param
 */
//============================================================================================
static	void	ServerAgiCalc(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	client_set_max;
	u32	fight_type;
	int	i,j;
	int	turn;
	int	flag;

	client_set_max=BattleWorkClientSetMaxGet(bw);
	fight_type=BattleWorkFightTypeGet(bw);

	turn=0;
	//Tt@][A|Pp[N͕KU
	if(fight_type&(FIGHT_TYPE_SAFARI|FIGHT_TYPE_POKE_PARK)){
		for(client_no=0;client_no<client_set_max;client_no++){	
			sp->client_agi_work[client_no]=client_no;
		}
	}
	else{
		if(fight_type&FIGHT_TYPE_SIO){
			for(client_no=0;client_no<client_set_max;client_no++){	
				if(sp->client_act_work[client_no][ACT_PARA_SELECT_COMMAND]==SELECT_ESCAPE_COMMAND){
					turn=5;
					break;
				}
			}
		}
		else{
			if(sp->client_act_work[0][ACT_PARA_SELECT_COMMAND]==SELECT_ESCAPE_COMMAND){
				client_no=0;
				turn=5;
			}
			if(sp->client_act_work[2][ACT_PARA_SELECT_COMMAND]==SELECT_ESCAPE_COMMAND){
				client_no=2;
				turn=5;
			}
		}
		if(turn==5){
			sp->client_agi_work[0]=client_no;
			turn=1;
			for(i=0;i<client_set_max;i++){	
				if(i!=client_no){
					sp->client_agi_work[turn]=i;
					turn++;
				}
			}
		}
		else{
			for(client_no=0;client_no<client_set_max;client_no++){	
													//ZIƓȊO𒊏o
													//ZƂɂȊO͖ɐU
				if((sp->client_act_work[client_no][ACT_PARA_SELECT_COMMAND]==SELECT_ITEM_COMMAND)||
				   (sp->client_act_work[client_no][ACT_PARA_SELECT_COMMAND]==SELECT_POKEMON_COMMAND)){
					sp->client_agi_work[turn]=client_no;
					turn++;
				}
			}
			for(client_no=0;client_no<client_set_max;client_no++){	
													//ZI𒊏o
				if((sp->client_act_work[client_no][ACT_PARA_SELECT_COMMAND]!=SELECT_ITEM_COMMAND)&&
				   (sp->client_act_work[client_no][ACT_PARA_SELECT_COMMAND]!=SELECT_POKEMON_COMMAND)){
					sp->client_agi_work[turn]=client_no;
					turn++;
				}
			}
			for(i=0;i<client_set_max-1;i++){
				for(j=i+1;j<client_set_max;j++){
					{
						int	cl1;
						int	cl2;

						cl1=sp->client_agi_work[i];
						cl2=sp->client_agi_work[j];

						if(sp->client_act_work[cl1][ACT_PARA_SELECT_COMMAND]==
						   sp->client_act_work[cl2][ACT_PARA_SELECT_COMMAND]){
							if(sp->client_act_work[cl1][ACT_PARA_SELECT_COMMAND]==SELECT_FIGHT_COMMAND){
								flag=0;
							}
							else{
								flag=1;
							}
							if(ST_ServerAgiCalc(bw,sp,cl1,cl2,flag)){
								sp->client_agi_work[i]=cl2;
								sp->client_agi_work[j]=cl1;
							}
						}
					}
				}
			}
		}
	}
	sp->server_seq_no=SERVER_BEFORE_ACT_NO;
}

//============================================================================================
/**
 *	OV[PXio[
 */
//============================================================================================

enum{
	SBA_KIAI_PUNCH=0,			//p`bZ[W\`FbN
	SBA_IKARI,					//AI`FbN
	SBA_AGI_CALC,				//ZʔԂ߂f`FbN

	SBA_END
};

//============================================================================================
/**
 *	O
 *
 * @param
 */
//============================================================================================
static	void	ServerBeforeAct(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int ret;
	int	client_no;
	int	client_set_max;
	
	ret=0;
	client_set_max=BattleWorkClientSetMaxGet(bw);

	do{
		switch(sp->sba_seq_no){
		case SBA_KIAI_PUNCH:		//p`bZ[W\`FbN
			while(sp->sba_work<client_set_max){
				client_no=sp->client_agi_work[sp->sba_work];
				if(sp->no_reshuffle_client&No2Bit(client_no)){
					sp->sba_work++;
					continue;
				}
				sp->sba_work++;
				if(((sp->psp[client_no].condition&CONDITION_NEMURI)==0)&&
				    (ST_ServerSelectWazaGet(sp,client_no)==WAZANO_KIAIPANTI)&&
					(ST_ServerNamakeCheck(sp,client_no)==FALSE)&&
					(sp->otf[client_no].waruagaki_flag==0)){
					SCIO_BlankMessage(bw);
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_KIAIPUNCH_BEFORE);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					return;
				}
			}
			sp->sba_work=0;
			sp->sba_seq_no++;
			break;
		case SBA_IKARI:				//AI`FbN
			for(client_no=0;client_no<client_set_max;client_no++){
				//ԂŁA
				//AőIĂȂ΁AԂ
				if((sp->psp[client_no].condition2&CONDITION2_IKARI)&&(ST_ServerSelectWazaGet(sp,client_no)!=WAZANO_IKARI)){
					sp->psp[client_no].condition2&=CONDITION2_IKARI;
				}
			}
			sp->sba_seq_no++;
			break;
		case SBA_AGI_CALC:
			for(client_no=0;client_no<CLIENT_MAX;client_no++){
				sp->agi_rand[client_no]=gf_rand();	///<f`FbNɎgp闐l
			}
			sp->sba_seq_no++;
			break;
		case SBA_END:
			sp->sba_seq_no=0;
			ret=2;
			break;
		}
	}while(ret==0);
	if(ret==2){
		sp->server_seq_no=SERVER_ACTION_BRANCH_NO;
	}
}

//============================================================================================
/**
 *	앪򏈗
 *
 * @param
 */
//============================================================================================
static	void	ServerActionBranch(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_set_max;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	//Zʔ̂߂̑fvZ
	ST_ServerPSPAgiCalc(bw,sp);

	if(sp->agi_cnt==client_set_max){
		sp->agi_cnt=0;
		sp->server_seq_no=SERVER_FIELD_CONDITION_CHECK_NO;
	}
	else{
		sp->server_seq_no=sp->client_act_work[sp->client_agi_work[sp->agi_cnt]][ACT_PARA_ACT_NO];
	}
}

//============================================================================================
/**
 *	ɂĂ퓬ʃ`FbNpV[PXio[
 */
//============================================================================================

enum{
	FCC_REFLEC=0,	//tN^[ʐ؂
	FCC_HIKARI,		//Ђ̂׌ʐ؂
	FCC_SHIROI,		//낢ʐ؂
	FCC_SHINPI,		//҂̂܂ʐ؂
	FCC_OIKAZE,		//ʐ؂
	FCC_OMAZINAI,	//܂Ȃʐ؂
	FCC_NEGAIGOTO,	//˂Ɣ
	FCC_AMAGOI,		//܂ʐ؂
	FCC_SUNAARASHI,	//Ȃ炵ʐ؂
	FCC_NIHONBARE,	//ɂق΂ʐ؂
	FCC_ARARE,		//ʐ؂
	FCC_HUKAIKIRI,	//ӂʐ؂
	FCC_JUURYOKU,	//イ傭ʐ؂
	FCC_END
};

//============================================================================================
/**
 *	ɂĂ퓬ʃ`FbN
 *
 * @param
 */
//============================================================================================
static	void	ServerFieldConditionCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	ret=0;
	int	dir;
	int	client_set_max;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	do{
		//C`FbN
		if(ServerKizetsuCheck(sp,sp->server_seq_no,sp->server_seq_no,SKC_MICHIDURE_OFF)==TRUE){
			return;
		}
		//ol擾`FbN
		if(ServerGetExpCheck(sp,sp->server_seq_no,sp->server_seq_no)==TRUE){
			return;
		}
		//SŃ`FbN
		if(ServerZenmetsuCheck(bw,sp)==TRUE){
			return;
		}

		switch(sp->fcc_seq_no){
		case FCC_REFLEC:	 //tN^[
			while(sp->fcc_work<2){
				dir=sp->fcc_work;
				if(sp->side_condition[dir]&SIDE_CONDITION_BUTSURIGUARD){
					if(--sp->scw[dir].butsuri_guard_count==0){
						sp->side_condition[dir]&=SIDE_CONDITION_BUTSURIGUARD_OFF;
						sp->waza_work=WAZANO_RIHUREKUTAA;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_WAZA_KOUKA_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->client_work=ST_ServerDir2ClientNoGet(bw,sp,dir);
						ret=1;
					}
				}
				sp->fcc_work++;
				if(ret){
					break;
				}
			}
			if(ret==0){
				sp->fcc_seq_no++;
				sp->fcc_work=0;
			}
			break;
		case FCC_HIKARI: //Ђ̂
			while(sp->fcc_work<2){
				dir=sp->fcc_work;
				if(sp->side_condition[dir]&SIDE_CONDITION_TOKUSYUGUARD){
					if(--sp->scw[dir].tokusyu_guard_count==0){
						sp->side_condition[dir]&=SIDE_CONDITION_TOKUSYUGUARD_OFF;
						sp->waza_work=WAZANO_HIKARINOKABE;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_WAZA_KOUKA_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->client_work=ST_ServerDir2ClientNoGet(bw,sp,dir);
						ret=1;
					}
				}
				sp->fcc_work++;
				if(ret){
					break;
				}
			}
			if(ret==0){
				sp->fcc_seq_no++;
				sp->fcc_work=0;
			}
			break;
		case FCC_SHIROI: //낢
			while(sp->fcc_work<2){
				dir=sp->fcc_work;
				if(sp->side_condition[dir]&SIDE_CONDITION_SHIROIKIRI){
					if(--sp->scw[dir].shiroikiri_count==0){
						sp->side_condition[dir]&=SIDE_CONDITION_SHIROIKIRI_OFF;
						sp->waza_work=WAZANO_SIROIKIRI;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_WAZA_KOUKA_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->client_work=ST_ServerDir2ClientNoGet(bw,sp,dir);
						ret=1;
					}
				}
				sp->fcc_work++;
				if(ret){
					break;
				}
			}
			if(ret==0){
				sp->fcc_seq_no++;
				sp->fcc_work=0;
			}
			break;
		case FCC_SHINPI: //҂̂܂
			while(sp->fcc_work<2){
				dir=sp->fcc_work;
				if(sp->side_condition[dir]&SIDE_CONDITION_SHINPI){
					if(--sp->scw[dir].shinpi_count==0){
						sp->side_condition[dir]&=SIDE_CONDITION_SHINPI_OFF;
						sp->client_work=sp->scw[dir].shinpi_client;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_SHINPI_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->client_work=ST_ServerDir2ClientNoGet(bw,sp,dir);
						ret=1;
					}
				}
				sp->fcc_work++;
				if(ret){
					break;
				}
			}
			if(ret==0){
				sp->fcc_seq_no++;
				sp->fcc_work=0;
			}
			break;
		case FCC_OIKAZE:					//`FbN
			while(sp->fcc_work<2){
				dir=sp->fcc_work;
				if(sp->side_condition[dir]&SIDE_CONDITION_OIKAZE){
					sp->side_condition[dir]-=1<<OIKAZE_SHIFT;
					if((sp->side_condition[dir]&SIDE_CONDITION_OIKAZE)==0){
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_OIKAZE_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->client_work=ST_ServerDir2ClientNoGet(bw,sp,dir);
						ret=1;
					}
				}
				sp->fcc_work++;
				if(ret){
					break;
				}
			}
			if(ret==0){
				sp->fcc_seq_no++;
				sp->fcc_work=0;
			}
			break;
		case FCC_OMAZINAI:	//܂Ȃʐ؂
			while(sp->fcc_work<2){
				dir=sp->fcc_work;
				if(sp->side_condition[dir]&SIDE_CONDITION_OMAZINAI){
					sp->side_condition[dir]-=1<<OMAZINAI_SHIFT;
					if((sp->side_condition[dir]&SIDE_CONDITION_OMAZINAI)==0){
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_OMAZINAI_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->client_work=ST_ServerDir2ClientNoGet(bw,sp,dir);
						ret=1;
					}
				}
				sp->fcc_work++;
				if(ret){
					break;
				}
			}
			if(ret==0){
				sp->fcc_seq_no++;
				sp->fcc_work=0;
			}
			break;
		case FCC_NEGAIGOTO:		//˂ƃ`FbN
			while(sp->fcc_work<client_set_max){
				dir=sp->psp_agi_work[sp->fcc_work];
				if(sp->fcc.negaigoto_count[dir]){
					if(--sp->fcc.negaigoto_count[dir]==0){
						if(sp->psp[dir].hp){
							sp->client_work=dir;
							sp->mp.msg_tag=TAG_NICK;
							sp->mp.msg_id=NegaigotoMineMsg;
							sp->mp.msg_para[0]=dir|(sp->fcc.negaigoto_sel_mons[dir]<<8);
							sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[dir].hpmax,2);
							ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_NEGAIGOTO);
							sp->next_server_seq_no=sp->server_seq_no;
							sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
							ret=1;
						}
					}
				}
				sp->fcc_work++;
				if(ret){
					break;
				}
			}
			if(ret==0){
				sp->fcc_seq_no++;
				sp->fcc_work=0;
			}
			break;
		case FCC_AMAGOI:					//܂`FbN
			if(sp->field_condition&FIELD_CONDITION_AME_ALL){
				if(sp->field_condition&FIELD_CONDITION_AMEHURASHI){
					sp->mp.msg_id=AmagoiKeep1Msg;
					sp->mp.msg_tag=TAG_NONE;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TENKOU_KEEP);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				}
				else{
					if(--sp->fcc.weather_count==0){
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_AMAGOI_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					}
					else{
						sp->mp.msg_id=AmagoiKeep1Msg;
						sp->mp.msg_tag=TAG_NONE;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TENKOU_KEEP);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					}
				}
				sp->temp_work=STATUS_WEATHER_RAIN;
				ret=1;
			}
			sp->fcc_seq_no++;
			break;
		case FCC_SUNAARASHI:					//Ȃ炵`FbN
			if(sp->field_condition&FIELD_CONDITION_SUNAARASHI_ALL){
				if(sp->field_condition&FIELD_CONDITION_SUNAOKOSHI){
					sp->mp.msg_id=SunaarashiKeepMsg;
					sp->mp.msg_tag=TAG_NONE;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TENKOU_KEEP);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				}
				else{
					if(--sp->fcc.weather_count==0){
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_SUNAARASHI_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					}
					else{
						sp->mp.msg_id=SunaarashiKeepMsg;
						sp->mp.msg_tag=TAG_NONE;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TENKOU_KEEP);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					}
				}
				sp->temp_work=STATUS_WEATHER_SAND;
				ret=1;
			}
			sp->fcc_seq_no++;
			break;
		case FCC_NIHONBARE:					//ɂق΂`FbN
			if(sp->field_condition&FIELD_CONDITION_HARE_ALL){
				if(sp->field_condition&FIELD_CONDITION_HIDERI){
					sp->mp.msg_id=NihonbareKeepMsg;
					sp->mp.msg_tag=TAG_NONE;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TENKOU_KEEP);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				}
				else{
					if(--sp->fcc.weather_count==0){
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_NIHONBARE_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					}
					else{
						sp->mp.msg_id=NihonbareKeepMsg;
						sp->mp.msg_tag=TAG_NONE;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TENKOU_KEEP);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					}
				}
				sp->temp_work=STATUS_WEATHER_SUN;
				ret=1;
			}
			sp->fcc_seq_no++;
			break;
		case FCC_ARARE:						//`FbN
			if(sp->field_condition&FIELD_CONDITION_ARARE_ALL){
				if(sp->field_condition&FIELD_CONDITION_YUKIHURASHI){
					sp->mp.msg_id=ArareKeepMsg;
					sp->mp.msg_tag=TAG_NONE;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TENKOU_KEEP);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				}
				else{
					if(--sp->fcc.weather_count==0){
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_ARARE_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					}
					else{
						sp->mp.msg_id=ArareKeepMsg;
						sp->mp.msg_tag=TAG_NONE;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TENKOU_KEEP);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					}
				}
				sp->temp_work=STATUS_WEATHER_ICE;
				ret=1;
			}
			sp->fcc_seq_no++;
			break;
		case FCC_HUKAIKIRI:					//ӂ`FbN
			if(sp->field_condition&FIELD_CONDITION_HUKAIKIRI){
				sp->mp.msg_id=HukaiKiriMsg;
				sp->mp.msg_tag=TAG_NONE;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TENKOU_KEEP);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				sp->temp_work=STATUS_WEATHER_MIST;
				ret=1;
			}
			sp->fcc_seq_no++;
			break;
		case FCC_JUURYOKU:					//イ傭`FbN
			if(sp->field_condition&FIELD_CONDITION_JUURYOKU){
				sp->field_condition-=(1<<FIELD_JUURYOKU_SHIFT);
				if((sp->field_condition&FIELD_CONDITION_JUURYOKU)==0){
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_JUURYOKU_END);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->fcc_seq_no++;
			break;
		case FCC_END:
			ret=2;
			break;
		}
	}while(ret==0);

	if(ret==1){
		SCIO_BlankMessage(bw);
	}

	if(ret==2){
		sp->fcc_seq_no=0;
		sp->server_seq_no=SERVER_POKE_CONDITION_CHECK_NO;
	}
}

//============================================================================================
/**
 *	|PɂĂ퓬ʃ`FbNpV[PXio[
 */
//============================================================================================

enum{
//HP񕜌nɃ`FbNċC₵ɂ
	POKE_CONDITION_CHECK_NEWOHARU=0,	//˂͂HP
	POKE_CONDITION_CHECK_AQUARING,		//ANAOHP
	POKE_CONDITION_CHECK_SPEABI,		//HP
	POKE_CONDITION_CHECK_SOUBI,			//ʂHP
	POKE_CONDITION_CHECK_TABENOKOSI,	//ʂHP񕜁îׂ̂݁j

	POKE_CONDITION_CHECK_YADORIGI,		//ǂ肬ŁAHP
	POKE_CONDITION_CHECK_DOKU,			//ǂ̃_[W`FbN
	POKE_CONDITION_CHECK_DOKUDOKU,		//ǂǂ̃_[W`FbN
	POKE_CONDITION_CHECK_YAKEDO,		//₯ǂ̃_[W`FbN
	POKE_CONDITION_CHECK_AKUMU,			//ނ̃_[W`FbN
	POKE_CONDITION_CHECK_NOROI,			//̂낢̃_[W`FbN
	POKE_CONDITION_CHECK_SHIME,			//߂ñ_[W`FbN
	POKE_CONDITION_CHECK_NIGHTMARE,		//iCgÃ_[W`FbN
	POKE_CONDITION_CHECK_SAWAGU,		//킮ʐ؂`FbN
	POKE_CONDITION_CHECK_ABARERU,		//΂ʐ؂`FbN
	POKE_CONDITION_CHECK_KANASHIBARI,	//Ȃ΂ʐ؂`FbN
	POKE_CONDITION_CHECK_ENCORE,		//AR[ʐ؂`FbN
	POKE_CONDITION_CHECK_LOCKON,		//bNIʐ؂`FbN
	POKE_CONDITION_CHECK_JUUDEN,		//イł񔭓`FbN
	POKE_CONDITION_CHECK_CHOUHATSU,		//傤͂ʐ؂`FbN
	POKE_CONDITION_CHECK_DENZIHUYUU,	//ł񂶂ӂ䂤ʐ؂`FbN
	POKE_CONDITION_CHECK_HEALBLOCK,		//q[ubNʐ؂`FbN
	POKE_CONDITION_CHECK_SHUTOUT,		//VbgAEgʐ؂`FbN
	POKE_CONDITION_CHECK_AKUBI,			//є`FbN
	POKE_CONDITION_CHECK_SOUBI2,		//ʂŉ
	POKE_CONDITION_CHECK_SOUBI_DAMAGE,	//ʂŃ_[W
//	POKE_CONDITION_CHECK_SINKURO,		//ʂŃ_[WŏԈُɂȂ\̂Ń`FbN
	POKE_CONDITION_CHECK_END,
};

//============================================================================================
/**
 *	|PɂĂ퓬ʃ`FbN
 *
 * @param
 */
//============================================================================================
static	void	ServerPokeConditionCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i;
	u8	ret=0;
	int	client_set_max;
	int	client_no;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	//C`FbN
	if(ServerKizetsuCheck(sp,sp->server_seq_no,sp->server_seq_no,SKC_MICHIDURE_OFF)==TRUE){
		return;
	}
	//ol擾`FbN
	if(ServerGetExpCheck(sp,sp->server_seq_no,sp->server_seq_no)==TRUE){
		return;
	}
	//SŃ`FbN
	if(ServerZenmetsuCheck(bw,sp)==TRUE){
		return;
	}

	while(sp->pcc_work<client_set_max){
		client_no=sp->psp_agi_work[sp->pcc_work];
		if(sp->no_reshuffle_client&No2Bit(client_no)){
			sp->pcc_work++;
			continue;
		}
		switch(sp->pcc_seq_no){
		//˂͂
		case POKE_CONDITION_CHECK_NEWOHARU:
			if((sp->psp[client_no].waza_kouka&WAZAKOUKA_NEWOHARU)&&
			   (sp->psp[client_no].hp!=sp->psp[client_no].hpmax)&&
			   (sp->psp[client_no].hp!=0)){
				if(sp->psp[client_no].wkw.healblock_count){
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HEALBLOCK_RECOVER_NG);
				}
				else{
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_NEWOHARU);
				}
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//ANAO
		case POKE_CONDITION_CHECK_AQUARING:
			if((sp->psp[client_no].waza_kouka&WAZAKOUKA_AQUARING)&&
			   (sp->psp[client_no].hp!=sp->psp[client_no].hpmax)&&
			   (sp->psp[client_no].hp!=0)){
				if(sp->psp[client_no].wkw.healblock_count){
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HEALBLOCK_RECOVER_NG);
				}
				else{
					sp->client_work=client_no;
					sp->waza_work=WAZANO_AKUARINGU;
					sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,16);
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_WAZAKOUKA_HP_KAIFUKU);
				}
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//\
		case POKE_CONDITION_CHECK_SPEABI:
			if(ST_ServerPCCTokuseiCheck(sp,client_no)==TRUE){
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//ACe
		case POKE_CONDITION_CHECK_SOUBI:
			if(ST_ServerSoubiItemCheck(bw,sp,client_no)==TRUE){
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//ʂHP񕜁îׂ̂݁j
		case POKE_CONDITION_CHECK_TABENOKOSI:
			if(ST_ServerSoubiItemTabenokosiCheck(bw,sp,client_no)==TRUE){
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//ǂ肬̂
		case POKE_CONDITION_CHECK_YADORIGI:
			if((sp->psp[client_no].waza_kouka&WAZAKOUKA_YADORARE)&&
			   (sp->psp[sp->psp[client_no].waza_kouka&WAZAKOUKA_YADORIGI].hp!=0)&&
			   //}WbNK[h́Aǂ肬̂˂̌ʂ󂯂Ȃ
			   (ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_MAZIKKUGAADO)&&
			   (sp->psp[client_no].hp!=0)){
				sp->attack_client_work=sp->psp[client_no].waza_kouka&WAZAKOUKA_YADORIGI;
				sp->defence_client_work=client_no;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_YADORIGI_HP_DEC);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//ǂ`FbN
		case POKE_CONDITION_CHECK_DOKU:
			if((sp->psp[client_no].condition&CONDITION_DOKU)&&(sp->psp[client_no].hp!=0)){
				sp->client_work=client_no;
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,8);
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_DOKU_HP_DEC);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//ǂǂ`FbN
		case POKE_CONDITION_CHECK_DOKUDOKU:
			if((sp->psp[client_no].condition&CONDITION_DOKUDOKU)&&(sp->psp[client_no].hp!=0)){
				sp->client_work=client_no;
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,16);
				if((sp->psp[client_no].condition&CONDITION_DOKUDOKU_CNT)!=CONDITION_DOKUDOKU_CNT){
					sp->psp[client_no].condition+=DOKUDOKU_COUNT;
				}
				sp->hp_calc_work*=((sp->psp[client_no].condition&CONDITION_DOKUDOKU_CNT)>>8);
				sp->hp_calc_work*=-1;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_DOKU_HP_DEC);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//₯ǃ`FbN
		case POKE_CONDITION_CHECK_YAKEDO:
			if((sp->psp[client_no].condition&CONDITION_YAKEDO)&&(sp->psp[client_no].hp!=0)){
				sp->client_work=client_no;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_YAKEDO_HP_DEC);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//ރ`FbN
		case POKE_CONDITION_CHECK_AKUMU:
			if((sp->psp[client_no].condition2&CONDITION2_AKUMU)&&(sp->psp[client_no].hp!=0)){
				if(sp->psp[client_no].condition&CONDITION_NEMURI){
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_AKUMU_HP_DEC);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
				else{
					sp->psp[client_no].condition2&=CONDITION2_AKUMU_OFF;
				}
			}
			sp->pcc_seq_no++;
			break;
		//̂낢`FbN
		case POKE_CONDITION_CHECK_NOROI:
			if((sp->psp[client_no].condition2&CONDITION2_NOROI)&&(sp->psp[client_no].hp!=0)){
				sp->client_work=client_no;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_NOROI_HP_DEC);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//ߌn̋Z
		case POKE_CONDITION_CHECK_SHIME:
			if((sp->psp[client_no].condition2&CONDITION2_SHIME)&&(sp->psp[client_no].hp!=0)){
				sp->psp[client_no].condition2-=SHIME_COUNT;
				if(sp->psp[client_no].condition2&CONDITION2_SHIME){
					sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,16);
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_SHIME_HP_DEC);
				}
				else{
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_SHIME_END);
				}
				sp->waza_work=sp->psp[client_no].wkw.shime_wazano;
				sp->client_work=client_no;
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//iCgÃ_[W`FbN
		case POKE_CONDITION_CHECK_NIGHTMARE:
			sp->temp_work=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE_RET,client_no,TOKUSYU_NAITOMEA);
			if((sp->psp[client_no].condition&CONDITION_NEMURI)&&
			   (ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_MAZIKKUGAADO)&&
			   (sp->psp[client_no].hp!=0)&&
			   (sp->temp_work)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,8);
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_NIGHTMARE);
				sp->server_status_flag|=SERVER_STATUS_FLAG_NO_BLINK;
				sp->client_work=client_no;
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
		//킮`FbN
		case POKE_CONDITION_CHECK_SAWAGU:
			if(sp->psp[client_no].condition2&CONDITION2_SAWAGU){
				{
					u8	sleep_client;

					//Ă|PN
					for(sleep_client=0;sleep_client<client_set_max;sleep_client++){
						if((sp->psp[sleep_client].condition&CONDITION_NEMURI)&&
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/04/21
// 킮̋N`FbNC₵Ă|PɂȂĂ̂C
#if AFTER_MASTER_070409_44_EUR_FIX
						   (sp->psp[sleep_client].hp)&&
#endif //AFTER_MASTER_070409_44_EUR_FIX
// ----------------------------------------------------------------------------
						   (ST_ServerTokuseiGet(sp,sleep_client)!=TOKUSYU_BOUON)){
							sp->client_work=sleep_client;
							ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MEZAME);
							sp->next_server_seq_no=sp->server_seq_no;
							sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
							break;
						}
					}
					if(sleep_client!=client_set_max){
						ret=2;
						break;
					}
				}
				sp->psp[client_no].condition2-=SAWAGU_COUNT;
				if(ST_ServerWazaOutCheck(sp,client_no)){
					i=SUB_SEQ_SAWAGU_END;
					sp->psp[client_no].condition2&=CONDITION2_SAWAGU_OFF;
					sp->field_condition&=((No2Bit(client_no)<<FIELD_SAWAGU_SHIFT)^0xffffffff);
				}
				else if(sp->psp[client_no].condition2&CONDITION2_SAWAGU){
					i=SUB_SEQ_NOISY;
				}
				else{
					i=SUB_SEQ_SAWAGU_END;
					sp->psp[client_no].condition2&=CONDITION2_SAWAGU_OFF;
					sp->field_condition&=((No2Bit(client_no)<<FIELD_SAWAGU_SHIFT)^0xffffffff);
				}
				sp->client_work=client_no;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,i);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			if(ret!=2){
				sp->pcc_seq_no++;
			}
			break;
		//΂`FbN
		case POKE_CONDITION_CHECK_ABARERU:
			if(sp->psp[client_no].condition2&CONDITION2_ABARERU){
				sp->psp[client_no].condition2-=ABARERU_COUNT;
				//܂ЂōUoȂƂ́A΂ꂨ
				if(ST_ServerWazaOutCheck(sp,client_no)){
					sp->psp[client_no].condition2&=CONDITION2_ABARERU_OFF;
				}
				else if(((sp->psp[client_no].condition2&CONDITION2_ABARERU)==0)&&
						((sp->psp[client_no].condition2&CONDITION2_KONRAN)==0)){
					sp->tsuika_client=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_ABARERU_END);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
#if 0
				//KEEPĂƂ́AIɋZƂ߂Ă̂ŁA
				//Ȃ悤ɂ
				else if(((sp->psp[client_no].condition2&CONDITION2_ABARERU)==0)&&
						 (sp->psp[client_no].condition2&CONDITION2_KEEP)){
					sp->psp[client_no].condition2&=CONDITION2_KEEP_OFF;
					if((sp->psp[client_no].condition2&CONDITION2_KONRAN)==0){
						sp->tsuika_client=client_no;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_ABARERU_END);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						ret=1;
					}
				}
#endif
			}
			sp->pcc_seq_no++;
			break;
		//Ȃ΂
		case POKE_CONDITION_CHECK_KANASHIBARI:
			if(sp->psp[client_no].wkw.kanashibari_wazano){
				//ZYŁAȂ΂肳ĂZȂƂ̏
				for(i=0;i<WAZA_TEMOTI_MAX;i++){
					if(sp->psp[client_no].wkw.kanashibari_wazano==sp->psp[client_no].waza[i]){
						break;
					}
				}
				if(i==WAZA_TEMOTI_MAX){
					sp->psp[client_no].wkw.kanashibari_count=0;
				}
				if(sp->psp[client_no].wkw.kanashibari_count){
					sp->psp[client_no].wkw.kanashibari_count--;
				}
				else{
					sp->psp[client_no].wkw.kanashibari_wazano=0;
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_KANASIBARI_END);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->pcc_seq_no++;
			break;
		//AR[
		case POKE_CONDITION_CHECK_ENCORE:
			if(sp->psp[client_no].wkw.encore_wazano){
				for(i=0;i<WAZA_TEMOTI_MAX;i++){
					if(sp->psp[client_no].wkw.encore_wazano==sp->psp[client_no].waza[i]){
						break;
					}
				}
				//ZYŁAAR[ĂZȂƂAPPȂ̏
				if((i==WAZA_TEMOTI_MAX)||((i!=WAZA_TEMOTI_MAX)&&(sp->psp[client_no].pp[i]==0))){
					sp->psp[client_no].wkw.encore_count=0;
				}
				if(sp->psp[client_no].wkw.encore_count){
					sp->psp[client_no].wkw.encore_count--;
				}
				else{
					sp->psp[client_no].wkw.encore_wazano=0;
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_ENCORE_END);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->pcc_seq_no++;
			break;
		//bNI
		case POKE_CONDITION_CHECK_LOCKON:
			if(sp->psp[client_no].waza_kouka&WAZAKOUKA_LOCKON){
				sp->psp[client_no].waza_kouka-=LOCKON_COUNT;
			}
			sp->pcc_seq_no++;
			break;
		//イł
		case POKE_CONDITION_CHECK_JUUDEN:
			if(sp->psp[client_no].wkw.juuden_count){
				if(--sp->psp[client_no].wkw.juuden_count==0){
					sp->psp[client_no].waza_kouka&=WAZAKOUKA_JUUDEN_OFF;
				}
			}
			sp->pcc_seq_no++;
			break;
		//傤͂
		case POKE_CONDITION_CHECK_CHOUHATSU:
			if(sp->psp[client_no].wkw.chouhatsu_count){
				sp->psp[client_no].wkw.chouhatsu_count--;
				if(sp->psp[client_no].wkw.chouhatsu_count==0){
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_CHOUHATSU_END);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->pcc_seq_no++;
			break;
		//ł񂶂ӂ䂤
		case POKE_CONDITION_CHECK_DENZIHUYUU:
			if(sp->psp[client_no].wkw.denzihuyuu_count){
				sp->psp[client_no].wkw.denzihuyuu_count--;
				if(sp->psp[client_no].wkw.denzihuyuu_count==0){
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_DENZIHUYUU_END);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->pcc_seq_no++;
			break;
		//q[ubN
		case POKE_CONDITION_CHECK_HEALBLOCK:
			if(sp->psp[client_no].wkw.healblock_count){
				sp->psp[client_no].wkw.healblock_count--;
				if(sp->psp[client_no].wkw.healblock_count==0){
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HEALBLOCK_END);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->pcc_seq_no++;
			break;
		//VbgAEg
		case POKE_CONDITION_CHECK_SHUTOUT:
			if(sp->psp[client_no].wkw.shutout_count){
				sp->psp[client_no].wkw.shutout_count--;
				if(sp->psp[client_no].wkw.shutout_count==0){
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_SHUTOUT_END);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->pcc_seq_no++;
			break;
		//
		case POKE_CONDITION_CHECK_AKUBI:
			if(sp->psp[client_no].waza_kouka&WAZAKOUKA_AKUBI){
				sp->psp[client_no].waza_kouka-=AKUBI_COUNT;
				if((sp->psp[client_no].waza_kouka&WAZAKOUKA_AKUBI)==0){
					sp->tsuika_client=client_no;
					sp->tsuika_type=ADD_STATUS_WAZA_KOUKA;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_NEMURI);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->pcc_seq_no++;
			break;
		//ACe
		case POKE_CONDITION_CHECK_SOUBI2:
			{
				int	seq_no;

				if(ST_ServerSoubiItemConditionBadCheck(bw,sp,client_no,&seq_no)==TRUE){
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->pcc_seq_no++;
			break;
		//ʂŃ_[W
		case POKE_CONDITION_CHECK_SOUBI_DAMAGE:
			if(ST_ServerSoubiItemDamageCheck(bw,sp,client_no)==TRUE){
				ret=1;
			}
			sp->pcc_seq_no++;
			break;
#if 0
		//ʂŃ_[WŏԈُɂȂ\̂Ń`FbN
		case POKE_CONDITION_CHECK_SINKURO:
			if((ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_SINKURO)&&
			   (client_no==sp->tsuika_client)&&
			   (sp->server_status_flag&SERVER_STATUS_FLAG_SINKURO_TSUIKA)){
				if(BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2){
					{
						int	cl1,cl2;

						cl1=BattleWorkEnemyClientNoGet(bw,client_no,BWECNG_SIDE_RIGHT);
						cl2=BattleWorkEnemyClientNoGet(bw,client_no,BWECNG_SIDE_LEFT);

						if((((sp->psp[cl1].condition&CONDITION_BAD)==0)&&(sp->psp[cl1].hp))&&
						   (((sp->psp[cl2].condition&CONDITION_BAD)==0)&&(sp->psp[cl2].hp))){
							sp->tsuika_client=ST_ServerDirClientGet(bw,sp,client_no);
						}
						else if(((sp->psp[cl1].condition&CONDITION_BAD)==0)&&(sp->psp[cl1].hp)){
							sp->tsuika_client=cl1;
						}
						else{
							sp->tsuika_client=cl2;
						}
					}
				}
				else{
					sp->tsuika_client=ST_ServerDirClientGet(bw,sp,client_no);
				}
				sp->client_work=client_no;
				{
					int	seq_no;

					if(sp->psp[sp->client_work].condition&CONDITION_DOKUALL){
						seq_no=SUB_SEQ_DOKU;
					}
					else if(sp->psp[sp->client_work].condition&CONDITION_YAKEDO){
						seq_no=SUB_SEQ_YAKEDO;
					}
					else{
						seq_no=SUB_SEQ_MAHI;
					}
					sp->tsuika_type=ADD_STATUS_TOKUSEI;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->pcc_seq_no++;
			break;
#endif
		case POKE_CONDITION_CHECK_END:
			sp->pcc_seq_no=0;
			sp->pcc_work++;
			break;
		}
		if(ret){
			SCIO_BlankMessage(bw);
			return;
		}
	}
	sp->pcc_seq_no=0;
	sp->pcc_work=0;
	sp->server_seq_no=SERVER_SIDE_CONDITION_CHECK_NO;
}

//============================================================================================
/**
 *	|PɂĂ퓬ʃ`FbNQpV[PXio[
 */
//============================================================================================

enum{
	SIDE_CONDITION_CHECK_MIRAIYOCHI=0,
	SIDE_CONDITION_CHECK_HOROBINOUTA,
	SIDE_CONDITION_CHECK_TRICKROOM,			//ɉêŁAȂ炸ŌɃ`FbN邱ƁI
//	SIDE_CONDITION_CHECK_DOUJOU_HANTEI,
};

//============================================================================================
/**
 *	|PɂĂ퓬ʃ`FbNiɂĂʁj
 *
 * @param
 */
//============================================================================================
static	void	ServerSideConditionCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i;
	int	client_set_max;
	int	client_no;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	//C`FbN
	if(ServerKizetsuCheck(sp,sp->server_seq_no,sp->server_seq_no,SKC_MICHIDURE_OFF)==TRUE){
		return;
	}
	//قт̂ŁAfő̕ɋC₵ɌolȂ悤TurnEndɈړ
	//ol擾`FbN
//	if(ServerGetExpCheck(sp,sp->server_seq_no,sp->server_seq_no)==TRUE){
//		return;
//	}
	//قт̂ŁAɂ邽߂ɖSync̃`FbN͂Ȃ
	//SŃ`FbN
//	if(ServerZenmetsuCheck(bw,sp)==TRUE){
//		return;
//	}

	SCIO_BlankMessage(bw);

	switch(sp->scc_seq_no){
	case SIDE_CONDITION_CHECK_MIRAIYOCHI:
		while(sp->scc_work<client_set_max){
			client_no=sp->psp_agi_work[sp->scc_work];
			if(sp->no_reshuffle_client&No2Bit(client_no)){
				sp->scc_work++;
				continue;
			}
			sp->scc_work++;
			if(sp->fcc.miraiyochi_count[client_no]){
				if((--sp->fcc.miraiyochi_count[client_no]==0)&&(sp->psp[client_no].hp!=0)){
					sp->side_condition[BattleWorkMineEnemyCheck(bw,client_no)]&=SIDE_CONDITION_MIRAIYOCHI_OFF;
					sp->mp.msg_id=MiraiyochiDamageMineMsg;
					sp->mp.msg_tag=TAG_NICK_WAZA;
					sp->mp.msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
					sp->mp.msg_para[1]=sp->fcc.miraiyochi_wazano[client_no];
					sp->client_work=client_no;
					sp->attack_client_work=sp->fcc.miraiyochi_client_no[client_no];
					sp->waza_work=sp->fcc.miraiyochi_wazano[client_no];
					sp->hp_calc_work=sp->fcc.miraiyochi_damage[client_no];
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MIRAIYOCHI_DAMAGE);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					return;
				}
			}
		}
		sp->scc_seq_no++;
		sp->scc_work=0;
	case SIDE_CONDITION_CHECK_HOROBINOUTA:
		while(sp->scc_work<client_set_max){
			client_no=sp->psp_agi_work[sp->scc_work];
			if(sp->no_reshuffle_client&No2Bit(client_no)){
				sp->scc_work++;
				continue;
			}
			sp->scc_work++;
			//قт̂
			if(sp->psp[client_no].waza_kouka&WAZAKOUKA_HOROBINOUTA){
				if(sp->psp[client_no].wkw.horobinouta_count==0){
					sp->psp[client_no].waza_kouka&=WAZAKOUKA_HOROBINOUTA_OFF;
					sp->msg_work=sp->psp[client_no].wkw.horobinouta_count;
					sp->hp_calc_work=sp->psp[client_no].hp*-1;
					sp->server_status_flag|=SERVER_STATUS_FLAG_NO_BLINK;
				}
				else{
					sp->msg_work=sp->psp[client_no].wkw.horobinouta_count;
					sp->psp[client_no].wkw.horobinouta_count--;
				}
				sp->client_work=client_no;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HOROBINOUTA_COUNTDOWN);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				return;
			}
		}
		sp->scc_seq_no++;
		sp->scc_work=0;
	case SIDE_CONDITION_CHECK_TRICKROOM:					//gbN[ʐ؂
		if(sp->field_condition&FIELD_CONDITION_TRICKROOM){
			sp->field_condition-=(1<<FIELD_TRICKROOM_SHIFT);
			if((sp->field_condition&FIELD_CONDITION_TRICKROOM)==0){
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TRICKROOM_END);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				return;
			}
		}
		sp->scc_seq_no++;
		sp->scc_work=0;
		break;
	default:
		break;
	}
	sp->scc_seq_no=0;
	sp->scc_work=0;
	sp->server_seq_no=SERVER_TURN_END_NO;
}

//============================================================================================
/**
 *	퓬^[I
 *
 * @param
 */
//============================================================================================
static	void	ServerTurnEnd(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//ol擾`FbN
	if(ServerGetExpCheck(sp,sp->server_seq_no,sp->server_seq_no)==TRUE){
		return;
	}
	if(ServerZenmetsuCheck(bw,sp)==TRUE){
		return;
	}
	if(ServerReshuffleCheck(bw,sp)==TRUE){
		return;
	}

	sp->total_turn++;
	sp->sakidori_total_turn++;
	//T[o[N̏
	ST_ServerWorkInit(sp);
	ST_ServerOneTurnFlagInit(bw,sp);
	sp->server_seq_no=SERVER_TRAINER_MESSAGE_NO;
}

//============================================================================================
/**
 *	쏈
 *
 * @param
 */
//============================================================================================
static	void	ServerFightCommand(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	flag;

	flag=0;		//DefenceClient߂flag

#ifdef PM_DEBUG
	if(BattleWorkBattleStatusFlagGet(bw)&BATTLE_STATUS_FLAG_AUTO_BATTLE){
		//WIFIڑł́AAÎĂȂ̂ŁA_őI
		if(CommStateIsWifiConnect()){
			flag=1;
		}
	}
#endif PM_DEBUG

	sp->attack_client=sp->client_agi_work[sp->agi_cnt];
	//邠tOĂꍇ͂邠Zbg
	if(sp->otf[sp->attack_client].waruagaki_flag){
		sp->waza_no_temp=WAZANO_WARUAGAKI;
		flag=1;
	}
	//AR[󂯂Ă鎞́A󂯂Zio[Zbg
	else if((sp->psp[sp->attack_client].wkw.encore_wazano)&&
			(sp->psp[sp->attack_client].wkw.encore_wazano==
			 sp->psp[sp->attack_client].waza[sp->psp[sp->attack_client].wkw.encore_wazapos])){
		sp->waza_no_temp=sp->psp[sp->attack_client].wkw.encore_wazano;
		flag=1;
	}
	//AR[󂯂ĂZYꂽAR[
	else if((sp->psp[sp->attack_client].wkw.encore_wazano)&&
			(sp->psp[sp->attack_client].wkw.encore_wazano!=
			 sp->psp[sp->attack_client].waza[sp->psp[sp->attack_client].wkw.encore_wazapos])){
		sp->waza_no_temp=sp->psp[sp->attack_client].waza[sp->psp[sp->attack_client].wkw.encore_wazapos];
		sp->psp[sp->attack_client].wkw.encore_wazano=0;
		sp->psp[sp->attack_client].wkw.encore_wazapos=0;
		sp->psp[sp->attack_client].wkw.encore_count=0;
		flag=1;
	}
	//ߋZn̋ZoĂꍇAœȂꍇ́AO^[̋Zio[Zbg
	else if(ST_ServerCommandSelectCheck(sp,sp->attack_client)==FALSE){
		sp->waza_no_temp=sp->waza_no_keep[sp->attack_client];
	}
	//IĂZYĂDefenceĒI
	else if(sp->waza_no_select[sp->attack_client]!=
			sp->psp[sp->attack_client].waza[sp->waza_no_pos[sp->attack_client]]){
		sp->waza_no_temp=sp->psp[sp->attack_client].waza[sp->waza_no_pos[sp->attack_client]];
		flag=1;
	}
	else{
		sp->waza_no_temp=sp->psp[sp->attack_client].waza[sp->waza_no_pos[sp->attack_client]];
	}
	sp->waza_no_now=sp->waza_no_temp;
	sp->server_seq_no=SERVER_WAZA_BEFORE_NO;

	sp->defence_client=ST_ServerDefenceClientSet(bw,sp,sp->attack_client,sp->waza_no_temp,flag,0);

	SCIO_BlankMessage(bw);

	//UΏۂȂ̂ŁAV[PXIփWviƂŃ`FbNɕύXj
//	if(sp->defence_client==NONE_CLIENT_NO){
//		OS_TPrintf("ΏۂȂ: atk:%d def:%d\n",sp->attack_client,sp->defence_client);
//		sp->server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
//	}
}

//============================================================================================
/**
 *	gp
 *
 * @param
 */
//============================================================================================
static	void	ServerItemCommand(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	ITEM_SELECT_RETURN_PARAM	*isrp;
	int							seq_no;

	sp->attack_client=sp->client_agi_work[sp->agi_cnt];
	sp->defence_client=ST_ServerDirClientGet(bw,sp,sp->attack_client);
	isrp=(ITEM_SELECT_RETURN_PARAM *)&sp->client_act_work[sp->attack_client][ACT_PARA_WORK];

	if(BattleWorkMineEnemyCheck(bw,sp->attack_client)){
		switch(sp->AIWT.AI_ITEM_TYPE[sp->attack_client>>1]){
		case ITEMTYPE_KAIHUKUNOKUSURI:
			seq_no=SUB_SEQ_TRUSE_KAIHUKUNOKUSURI;
			break;
		case ITEMTYPE_HP_KAIHUKU:
			seq_no=SUB_SEQ_TRUSE_RECV_HP;
			break;
		case ITEMTYPE_CONDITION_KAIHUKU:
			if((sp->AIWT.AI_ITEM_CONDITION[sp->attack_client>>1]&1)&&
			   (sp->AIWT.AI_ITEM_CONDITION[sp->attack_client>>1]&0x3e)){
				sp->msg_work=ITEM_USE_MSG_RECV_MULTI;
			}
			else{
				sp->msg_work=Bit2No(sp->AIWT.AI_ITEM_CONDITION[sp->attack_client>>1]);
			}
			seq_no=SUB_SEQ_TRUSE_RECV_CONDITION;
			break;
		case ITEMTYPE_ABIRITY_UP:
			sp->msg_work=sp->AIWT.AI_ITEM_CONDITION[sp->attack_client>>1];
			seq_no=SUB_SEQ_TRUSE_ABIRITY_UP;
			break;
		case ITEMTYPE_EFFECT_GUARD:
			seq_no=SUB_SEQ_TRUSE_EFFECT_GUARD;
			break;
		}
		sp->item_work=sp->AIWT.AI_ITEM_NO[sp->attack_client>>1];
	}
	else{
		switch(isrp->page){
		case BBAG_POKE_STRCV:	// ԉ񕜃|Pbg
		case BBAG_POKE_HPRCV:	// HP񕜃|Pbg
		case BBAG_POKE_BATTLE:	// 퓬p|Pbg
			if((isrp->item_no==ITEM_PIPPININGYOU)||
			   (isrp->item_no==ITEM_ENEKONOSIPPO)){
				seq_no=SUB_SEQ_ITEM_ESCAPE;
			}
			else{
				seq_no=SUB_SEQ_ITEM_BATTLE_ITEM;
			}
			break;
		case BBAG_POKE_BALL:	// {[|Pbg
			seq_no=SUB_SEQ_BALL_THROW;
			if(((BattleWorkFightTypeGet(bw)&FIGHT_TYPE_TRAINER)==0)&&
			   ((BattleWorkFightTypeGet(bw)&FIGHT_TYPE_GET_DEMO)==0)){
				MyItem_SubItem( BattleWorkMyItemGet(bw), isrp->item_no, 1, HEAPID_BATTLE );
				MyItem_BattleBagLastItemSet( BattleWorkBagCursorGet(bw), isrp->item_no, isrp->page );
			}
			break;
		}
		sp->item_work=isrp->item_no;
	}

	ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
	sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	sp->next_server_seq_no=SERVER_WAZA_END_NO;
	//Z͔ĂȂ̂ŁAsɂ
	sp->waza_status_flag|=WAZA_STATUS_FLAG_SIPPAI;
}

//============================================================================================
/**
 *	|PI
 *
 * @param
 */
//============================================================================================
static	void	ServerPokemonCommand(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_POKEMON_RESHUFFLE);
	sp->attack_client=sp->client_agi_work[sp->agi_cnt];
	sp->reshuffle_client=sp->attack_client;
	sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// ւuvւ̃JE^[_[W2̂Ƃ|ꂽƂ̕sC
#if AFTER_MASTER_070202_BT1_FIX
	sp->next_server_seq_no=SERVER_POKE_RESHUFFLE_AFTER_NO;		///<|PꂩV[PX
#else
//	sp->next_server_seq_no=SERVER_POKE_RESHUFFLE_AFTER_NO;		///<|PꂩV[PX
	sp->next_server_seq_no=SERVER_WAZA_END_NO;
#endif AFTER_MASTER_070202_BT1_FIX
// ----------------------------------------------------------------------------
	sp->temp_work=0;	//̂ꂩlĂ
	//Z͔ĂȂ̂ŁAsɂ
	sp->waza_status_flag|=WAZA_STATUS_FLAG_SIPPAI;
}

//============================================================================================
/**
 *	ɂ铮쏈
 *
 * @param
 */
//============================================================================================
static	void	ServerEscapeCommand(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	sp->attack_client=sp->client_agi_work[sp->agi_cnt];

	//G100%œ
	if((BattleWorkMineEnemyCheck(bw,sp->attack_client))&&
	  ((BattleWorkFightTypeGet(bw)&FIGHT_TYPE_SIO)==0)){
		//ȂZʂ󂯂Ă鎞́AȂ
		if(sp->psp[sp->attack_client].condition2&(CONDITION2_SHIME|CONDITION2_KUROIMANAZASHI)){
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_ENEMY_ESCAPE_NG);
			sp->skill_seq_no=0;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			sp->next_server_seq_no=SERVER_WAZA_END_NO;
		}
		else{
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_ENEMY_ESCAPE);
			sp->skill_seq_no=0;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			sp->next_server_seq_no=SERVER_FIGHT_END_NO;
		}
	}
	else{
		if(ST_EscapeActCheck(bw,sp,sp->attack_client)){
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_ESCAPE);
			sp->skill_seq_no=0;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			sp->next_server_seq_no=SERVER_FIGHT_END_NO;
		}
		else{
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_ESCAPE_NG);
			sp->skill_seq_no=0;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			sp->next_server_seq_no=SERVER_WAZA_END_NO;
		}
	}
}

//============================================================================================
/**
 *	Tt@Ń{[鏈
 *
 * @param
 */
//============================================================================================
static	void	ServerSafariBallCommand(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	ball;

	ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_SAFARI_BALL_THROW);
	sp->attack_client=CLIENT_NO_MINE;
	sp->defence_client=CLIENT_NO_ENEMY;
	sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	sp->next_server_seq_no=SERVER_WAZA_END_NO;
	sp->item_work=ITEM_SAFARIBOORU;
	ball=BattleWorkSafariBallCountGet(bw)-1;
	BattleWorkSafariBallCountSet(bw,ball);
	SCIO_HPGaugeRefreshSet(bw,sp,CLIENT_NO_MINE);
}

//============================================================================================
/**
 *	Tt@ŃGT鏈
 *
 * @param
 */
//============================================================================================
static	void	ServerSafariEsaCommand(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_ESA_THROW);
	sp->attack_client=CLIENT_NO_MINE;
	sp->defence_client=CLIENT_NO_ENEMY;
	sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	sp->next_server_seq_no=SERVER_WAZA_END_NO;
	sp->temp_work=gf_rand()%SAFARI_ATARI;
	if(sp->safari_get_count<SAFARI_COUNT_MAX){
		sp->safari_get_count++;
	}
	//哖̎́Aߊl̂ݏ㏸
	if(sp->temp_work!=0){
		if(sp->safari_escape_count<SAFARI_COUNT_MAX){
			sp->safari_escape_count++;
		}
	}
}

//============================================================================================
/**
 *	Tt@Ńh鏈
 *
 * @param
 */
//============================================================================================
static	void	ServerSafariDoroCommand(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_DORO_THROW);
	sp->attack_client=CLIENT_NO_MINE;
	sp->defence_client=CLIENT_NO_ENEMY;
	sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	sp->next_server_seq_no=SERVER_WAZA_END_NO;
	sp->temp_work=gf_rand()%SAFARI_ATARI;
	if(sp->safari_escape_count){
		sp->safari_escape_count--;
	}
	//哖̎́Â݉~
	if(sp->temp_work!=0){
		sp->msg_work=1;
		if(sp->safari_get_count){
			sp->safari_get_count--;
		}
	}
}

//============================================================================================
/**
 *	Tt@ŗlq
 *
 * @param
 */
//============================================================================================
static	void	ServerSafariYousumiCommand(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_YOUSUMI);
	sp->attack_client=CLIENT_NO_MINE;
	sp->defence_client=CLIENT_NO_ENEMY;
	sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	sp->next_server_seq_no=SERVER_WAZA_END_NO;
}

//============================================================================================
/**
 *	obW`FbN
 *
 * @param
 */
//============================================================================================
static	int	ServerBadgeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no)
{
	int			i,j;
	u32			fight_type;
	u8			level=0;
	MYSTATUS	*status;

	fight_type=BattleWorkFightTypeGet(bw);
	status=BattleWorkMyStatusGet(bw,CLIENT_NO_MINE);

	//obW`FbNȂFIGHT_TYPE`FbN
	if(fight_type&FIGHT_TYPE_NO_BADGE){
		return 0;
	}
	//ǴAobW`FbNȂ
	if(BattleWorkMineEnemyCheck(bw,sp->attack_client)){
		return 0;
	}
	//sȃ|P`FbN
//	if(HuseiPokemonCheck(AttackClient)){
//		return 0;
//	}
	//AI}`ΐŁAp[gi[obW`FbN͂Ȃ
	if((fight_type&FIGHT_TYPE_AI)&&(BattleWorkClientTypeGet(bw,sp->attack_client)==CLIENT_TYPE_C)){
		return 0;
	}
	//̎|PobW`FbN͂Ȃ
	if((ST_ServerPokeOneSelfCheckAct(bw,sp))==TRUE){
		return 0;
	}
	//R}hÎȂZłɏoĂȂobW`FbN͂Ȃ
	if(ST_ServerCommandSelectCheck(sp,sp->attack_client)==FALSE){
		return 0;
	}
	//obWׂĂĂȂ`FbN͂Ȃ
//	if(MyStatus_GetBadgeFlag(status,BADGE_ID_C08)){
	if(MyStatus_GetBadgeCount(status)>=8){
		return 0;
	}
	
	level=10;
//	if(MyStatus_GetBadgeFlag(status,BADGE_ID_C02)){
	if(MyStatus_GetBadgeCount(status)>=2){
		level=30;
	}
//	if(MyStatus_GetBadgeFlag(status,BADGE_ID_C04)){
	if(MyStatus_GetBadgeCount(status)>=4){
		level=50;
	}
//	if(MyStatus_GetBadgeFlag(status,BADGE_ID_C06)){
	if(MyStatus_GetBadgeCount(status)>=6){
		level=70;
	}

	//obWŉւĂ郌xȂ炢Ƃ𕷂
	if(sp->psp[sp->attack_client].level<=level){
		return 0;
	}

	i=((gf_rand()&0xff)*(sp->psp[sp->attack_client].level+level))>>8;

	if(i<level){
		return 0;
	}

	//IĂȂA{e[WȂ悤ɂ
	if(sp->waza_no_now==WAZANO_IKARI){
		sp->psp[sp->attack_client].condition2&=CONDITION2_IKARI_OFF;
	}

	if((sp->psp[sp->attack_client].condition&CONDITION_NEMURI)&&
	  ((sp->waza_no_now==WAZANO_IBIKI)||(sp->waza_no_now==WAZANO_NEGOTO))){
		seq_no[0]=SUB_SEQ_ORDER_IGNORE_SLEEP;	//ߖi˂ނj
		return 1;
	}

	i=((gf_rand()&0xff)*(sp->psp[sp->attack_client].level+level))>>8;

#ifndef ORDER_IGNORE_ONLY
	if(i<level){
#endif ORDER_IGNORE_ONLY
		i=ST_ServerWaruagakiCheck(bw,sp,sp->attack_client,No2Bit(sp->waza_no_pos[sp->attack_client]),SSWC_ALL);
		if(i==0x0f){		//oZȂ
			seq_no[0]=SUB_SEQ_NAMAKERU;		//ߖiȂ܂j
			return 1;
		}
		do{
			j=gf_rand()&3;
		}while(i&No2Bit(j));
		sp->waza_no_pos[sp->attack_client]=j;
		sp->waza_no_temp=sp->psp[sp->attack_client].waza[sp->waza_no_pos[sp->attack_client]];
		sp->waza_no_now=sp->waza_no_temp;
		sp->defence_client=ST_ServerDefenceClientSet(bw,sp,sp->attack_client,sp->waza_no_temp,1,0);
		seq_no[0]=SUB_SEQ_ORDER_IGNORE;		//ߖ
		sp->waza_out_check_on_off|=BADGE_CHECK_OFF;
		return 2;
#ifndef ORDER_IGNORE_ONLY
	}
#endif ORDER_IGNORE_ONLY

	level=sp->psp[sp->attack_client].level-level;
	i=gf_rand()&0xff;

	if(((i<level)&&((sp->psp[sp->attack_client].condition&CONDITION_BAD)==0))&&
	    (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_YARUKI)&&
	    (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_HUMIN)&&
	    (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_RIIHUGAADO)){
		if((sp->field_condition&FIELD_CONDITION_SAWAGU)==0){
			seq_no[0]=SUB_SEQ_HIRUNE;				//ߖiЂˁj
			return 1;
		}
	}

	i-=level;

	if(i<level){
		sp->defence_client=sp->attack_client;
		sp->client_work=sp->defence_client;
		//ւ̍ÚA͂З͂SOŌvZ_[W
		sp->hp_calc_work=ST_WazaDamageCalc(bw,sp,
										   WAZANO_HATAKU,
										   0,
										   0,
										   40,
										   0,
										   sp->attack_client,
										   sp->attack_client,
										   1);
		sp->hp_calc_work=ST_DamageLossCalc(sp,sp->hp_calc_work);
		sp->hp_calc_work*=-1;
		seq_no[0]=SUB_SEQ_OWN_ATTACK;			//ߖiUj
		return 3;
	}

	seq_no[0]=SUB_SEQ_NAMAKERU;			//ߖiȂ܂j

	return 1;
}


//============================================================================================
/**
 *	PP`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerPPCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	decpp=1;
	int	pos;

#ifdef PM_DEBUG
	if(BattleWorkBattleStatusFlagGet(bw)&BATTLE_STATUS_FLAG_NO_PP_DEC){
		return	FALSE;
	}
#endif PM_DEBUG

//\̓vbV[PP{
	if((sp->ostf[sp->attack_client].no_pressure_flag==0)&&(sp->defence_client!=NONE_CLIENT_NO)){
		//ӂ́ARANGE_DOUBLEƓ
		if(sp->waza_no_temp==WAZANO_HUUIN){
			decpp+=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE_HP,sp->attack_client,TOKUSYU_PURESSYAA);
		}
		else{
			switch(sp->AIWT.wtd[sp->waza_no_temp].attackrange){
			case RANGE_TRIPLE:
			case RANGE_FIELD:
				decpp+=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_NOMINE_HP,sp->attack_client,TOKUSYU_PURESSYAA);
				break;
			case RANGE_DOUBLE:
			case RANGE_MAKIBISHI:
				decpp+=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE_HP,sp->attack_client,TOKUSYU_PURESSYAA);
				break;
			case RANGE_MINE_DOUBLE:
			case RANGE_MINE:
			case RANGE_TUBOWOTUKU:
			case RANGE_TEDASUKE:
				break;
			default:
				if((sp->attack_client!=sp->defence_client)&&
				   (ST_ServerTokuseiGet(sp,sp->defence_client)==TOKUSYU_PURESSYAA)){
					decpp++;
				}
				break;
			}
		}
	}

	pos=ST_ServerWazaPosGet(&sp->psp[sp->attack_client],sp->waza_no_temp);

	//邠́APPCheck͖
	if((sp->otf[sp->attack_client].pp_dec_flag==0)&&(sp->otf[sp->attack_client].waruagaki_flag==0)){
		sp->otf[sp->attack_client].pp_dec_flag=1;
		if((sp->psp[sp->attack_client].pp[pos])&&(pos<WAZA_TEMOTI_MAX)){
			if(sp->psp[sp->attack_client].pp[pos]>decpp){
				sp->psp[sp->attack_client].pp[pos]-=decpp;
			}
			else{
				sp->psp[sp->attack_client].pp[pos]=0;
			}
			ST_PSPtoPPCopy(bw,sp,sp->attack_client);
		}
#ifdef PM_DEBUG
		else if(pos>=WAZA_TEMOTI_MAX){
			GF_ASSERT_MSG(0,"莝ɂȂZPP炻ƂĂI\n");
		}
#endif PM_DEBUG
		else{
			sp->waza_status_flag|=WAZA_STATUS_FLAG_PP_NONE;
		}
	}
	//PPȂ`FbN
	else if((sp->psp[sp->attack_client].pp[pos]==0)&&
		   ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME_AFTER)==0)&&
		   ((sp->psp[sp->attack_client].condition2&CONDITION2_KEEP)==0)&&
		   ((sp->psp[sp->attack_client].condition2&CONDITION2_ABARERU)==0)&&
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if AFTER_MASTER_061113_1_FIX
		   ((sp->field_condition&(No2Bit(sp->attack_client)<<FIELD_SAWAGU_SHIFT))==0)&&
#endif AFTER_MASTER_061113_1_FIX
// ----------------------------------------------------------------------------
			(pos<WAZA_TEMOTI_MAX)){
		sp->waza_status_flag|=WAZA_STATUS_FLAG_PP_NONE;
	}
	
	return FALSE;
}

//============================================================================================
/**
 *	UΏۃ`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerDefenceCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	BOOL	ret;

	ret=FALSE;

	//UΏۂȂꍇ́A̎|̃bZ[W\ďIi߃^[͏j
	if(((sp->defence_client==NONE_CLIENT_NO)&&(ST_TameWazaCheck(sp,sp->waza_no_now)==FALSE))||
	   ((sp->defence_client==NONE_CLIENT_NO)&&
		(ST_TameWazaCheck(sp,sp->waza_no_now)==TRUE)&&
	   ((sp->psp[sp->attack_client].condition2&CONDITION2_KEEP)||
		(sp->server_status_flag&SERVER_STATUS_FLAG_TAME_AFTER)))){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_NO_DEFENCE);
		sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		ret=TRUE;
	}

	return ret;
}

//============================================================================================
/**
 *	TYPE`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerTypeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//I̋ZAЗ͖A^CvAߋZn1^[ڂ́ATYPE`FbNȂA
	//uł񂶂́v́AnʂɓĂȂ悤ɂ邽߂ɁA`FbN
//	if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_attackrange)!=RANGE_MINE)&&
//	   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage))&&
	if(((sp->AIWT.wtd[sp->waza_no_now].attackrange!=RANGE_MINE)&&
	    (sp->AIWT.wtd[sp->waza_no_now].attackrange!=RANGE_MINE_DOUBLE)&&
	    (sp->AIWT.wtd[sp->waza_no_now].damage)&&
	   ((sp->server_status_flag&SERVER_STATUS_FLAG_TYPE_NONE)==0)&&
	   ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0))||
	    (sp->waza_no_now==WAZANO_DENZIHA)){
		sp->damage=ST_ServerTypeCheck(bw,sp,sp->waza_no_now,sp->waza_type,sp->attack_client,sp->defence_client,sp->damage,&sp->waza_status_flag);
		if(sp->waza_status_flag&WAZA_STATUS_FLAG_KOUKANAI){
			sp->wocf[sp->attack_client].koukanai_flag=1;
		}
	}
	return FALSE;
}

//============================================================================================
/**
 *	Ԉُ`FbÑV[PXio[
 */
//============================================================================================
enum{
	SSC_INIT=0,		//`FbN
	SSC_NEMURI,		//˂ނ`FbN
	SSC_KOORI,		//`FbN
	SSC_NAMAKE,		//Ȃ܂`FbN
	SSC_HANDOU,		//͂ǂ`FbN
	SSC_HIRUMU,		//Ђރ`FbN
	SSC_KANASIBARI,	//Ȃ΂`FbN
	SSC_TYOUHATU,	//傤͂`FbN
	SSC_HUUIN,		//ӂ`FbN
	SSC_JUURYOKU,	//イ傭`FbN
	SSC_HEALBLOCK,	//q[ubN`FbN
	SSC_KONRAN,		//`FbN
	SSC_MAHI,		//܂Ѓ`FbN
	SSC_MEROMERO,	//`FbN
	SSC_GAMAN,		//܂`FbN
	SSC_MELT,		//Ƃ`FbN
	SSC_END			//`FbNGh
};

enum{
	SSC_ACT_LOOP=0,			//`FbNp
	SSC_ACT_NO_WAZA_OUT,	//Z̔łȂ
	SSC_ACT_WAZA_SEQ,		//bZ[W\Ȃǂ̃V[PX
	SSC_ACT_END				//`FbN̏I
};

//============================================================================================
/**
 *	Ԉُ`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerStatusCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	battle_effect;
	int	ret;

//	battle_effect=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_battleeffect);
	battle_effect=sp->AIWT.wtd[sp->waza_no_now].battleeffect;

	ret=SSC_ACT_LOOP;
	
	do{
		switch(sp->ssc_seq_no){
		case SSC_INIT:		//`FbN
			//݂ÂtOOFF
			sp->psp[sp->attack_client].condition2&=CONDITION2_MICHIDURE_OFF;
			//˂tOOFF
			sp->psp[sp->attack_client].waza_kouka&=WAZAKOUKA_ONNEN_OFF;
			sp->ssc_seq_no++;
			break;
		case SSC_NEMURI:		//˂ނ`FbN
			//ĂƂ́AN`FbN
			if(sp->psp[sp->attack_client].condition&CONDITION_NEMURI){
				{
					int	cnt;
		
					//ԂŁAڂĂȂƂ͋N
					if((sp->field_condition&FIELD_CONDITION_SAWAGU)&&
					   (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_BOUON)){
						sp->client_work=sp->attack_client;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MEZAME);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						ret=SSC_ACT_WAZA_SEQ;
					}
					else{
						//˂Ƃ̔hł́A˂ނJE^DECȂ
						if(((sp->waza_no_now!=WAZANO_NEGOTO)&&(sp->waza_no_temp==WAZANO_NEGOTO))==0){
							//\͂͂₨́A͂₭˂ނ肩炳߂
							if(ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_HAYAOKI){
								cnt=2;
							}
							else{
								cnt=1;
							}
							if((sp->psp[sp->attack_client].condition&CONDITION_NEMURI)<cnt){
								sp->psp[sp->attack_client].condition&=CONDITION_NEMURI_OFF;
							}
							else{
								sp->psp[sp->attack_client].condition-=cnt;
							}
							if(sp->psp[sp->attack_client].condition&CONDITION_NEMURI){
								//˂ƂƂт́AQĂĂZôŖ
								if((sp->waza_no_now!=WAZANO_IBIKI)&&(sp->waza_no_temp!=WAZANO_NEGOTO)){
									ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_SLEEPING);
									sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//									sp->next_server_seq_no=SERVER_WAZA_END_NO;
									sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
									ret=SSC_ACT_WAZA_SEQ;
								}
							}
							else{
								sp->client_work=sp->attack_client;
								ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MEZAME);
								sp->next_server_seq_no=sp->server_seq_no;
								sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
								ret=SSC_ACT_WAZA_SEQ;
							}
						}
					}
				}
			}
			sp->ssc_seq_no++;
			break;
		case SSC_KOORI:		//`FbN
			//ĂƂ́AƂ`FbN
			if(sp->psp[sp->attack_client].condition&CONDITION_KOORI){
				//51̊mŗn
				if(gf_rand()%5!=0){
					if((battle_effect!=125)&&(battle_effect!=253)){
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_FREEZING);
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//						sp->next_server_seq_no=SERVER_WAZA_END_NO;
						sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
						ret=SSC_ACT_NO_WAZA_OUT;
					}
				}
				else{
					sp->client_work=sp->attack_client;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MELT);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=SSC_ACT_WAZA_SEQ;
				}
			}
			sp->ssc_seq_no++;
			break;
		case SSC_NAMAKE:		//Ȃ܂`FbN
			if(ST_ServerNamakeCheck(sp,sp->attack_client)==TRUE){
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_NAMAKE);
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//				sp->next_server_seq_no=SERVER_WAZA_END_NO;
				sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
				ret=SSC_ACT_NO_WAZA_OUT;
			}
			sp->ssc_seq_no++;
			break;
		case SSC_HANDOU:		//͂ǂ`FbN
			if(sp->psp[sp->attack_client].condition2&CONDITION2_HANDOU){
				sp->psp[sp->attack_client].condition2&=CONDITION2_HANDOU_OFF;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HANDOU_NOHIT);
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//				sp->next_server_seq_no=SERVER_WAZA_END_NO;
				sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
				ret=SSC_ACT_NO_WAZA_OUT;
			}
			sp->ssc_seq_no++;
			break;
		case SSC_HIRUMU:		//Ђރ`FbN
			//Ђł鎞͋ZoȂ
			if(sp->psp[sp->attack_client].condition2&CONDITION2_HIRUMU){
				sp->psp[sp->attack_client].condition2&=CONDITION2_HIRUMU_OFF;
				sp->wocf[sp->attack_client].hirumu_flag=1;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HIRUMU_WAZA_NO_HIT);
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//				sp->next_server_seq_no=SERVER_WAZA_END_NO;
				sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
				ret=SSC_ACT_NO_WAZA_OUT;
			}
			sp->ssc_seq_no++;
			break;
		case SSC_KANASIBARI:	//Ȃ΂`FbN
			if(sp->psp[sp->attack_client].wkw.kanashibari_wazano==sp->waza_no_temp){
				sp->wocf[sp->attack_client].kanashibari_flag=1;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_KANASIBARI_NG);
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//				sp->next_server_seq_no=SERVER_WAZA_END_NO;
				sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
				ret=SSC_ACT_NO_WAZA_OUT;
			}
			sp->ssc_seq_no++;
			break;
		case SSC_TYOUHATU:	//傤͂`FbN
//			if((sp->psp[sp->attack_client].wkw.chouhatsu_count)&&(WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage)==0)){
			if((sp->psp[sp->attack_client].wkw.chouhatsu_count)&&(sp->AIWT.wtd[sp->waza_no_now].damage==0)){
				sp->wocf[sp->attack_client].chouhatsu_flag=1;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_CHOUHATSU_NG);
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//				sp->next_server_seq_no=SERVER_WAZA_END_NO;
				sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
				ret=SSC_ACT_NO_WAZA_OUT;
			}
			sp->ssc_seq_no++;
			break;
		case SSC_HUUIN:		//ӂ`FbN
			if(ST_ServerHuuinCheck(bw,sp,sp->attack_client,sp->waza_no_now)){
				sp->wocf[sp->attack_client].huuin_flag=1;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HUUIN_NG);
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//				sp->next_server_seq_no=SERVER_WAZA_END_NO;
				sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
				ret=SSC_ACT_NO_WAZA_OUT;
			}
			sp->ssc_seq_no++;
			break;
		case SSC_JUURYOKU:	//イ傭`FbN
			if(ST_ServerJuuryokuCheck(bw,sp,sp->attack_client,sp->waza_no_now)){
				sp->wocf[sp->attack_client].juuryoku_flag=1;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_JUURYOKU_NG);
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//				sp->next_server_seq_no=SERVER_WAZA_END_NO;
				sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
				ret=SSC_ACT_NO_WAZA_OUT;
			}
			sp->ssc_seq_no++;
			break;
		case SSC_HEALBLOCK:	//q[ubN`FbN
			if(ST_ServerHealblockCheck(bw,sp,sp->attack_client,sp->waza_no_now)){
				sp->wocf[sp->attack_client].healblock_flag=1;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HEALBLOCK_NG);
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//				sp->next_server_seq_no=SERVER_WAZA_END_NO;
				sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
				ret=SSC_ACT_NO_WAZA_OUT;
			}
			sp->ssc_seq_no++;
			break;
		case SSC_KONRAN:		//`FbN
			sp->ssc_seq_no++;
			if(sp->psp[sp->attack_client].condition2&CONDITION2_KONRAN){		//`FbN
				sp->psp[sp->attack_client].condition2-=KONRAN_COUNT;
				if(sp->psp[sp->attack_client].condition2&CONDITION2_KONRAN){
					if(gf_rand()&1){
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_CONFUSE);
						sp->next_server_seq_no=sp->server_seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						ret=SSC_ACT_WAZA_SEQ;
					}
					else{
						sp->wocf[sp->attack_client].konran_flag=1;
						sp->defence_client=sp->attack_client;
						sp->client_work=sp->defence_client;
						//ւ̍ÚA邠З͂SOŌvZ_[WieNjV𔭓Ȃ߁j
						sp->hp_calc_work=ST_WazaDamageCalc(
												bw,sp,
												WAZANO_WARUAGAKI,
												0,
												0,
												40,
												0,
												sp->attack_client,
												sp->attack_client,
												1);
						sp->hp_calc_work=ST_DamageLossCalc(sp,sp->hp_calc_work);
						sp->hp_calc_work*=-1;
						ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_CONFUSE_MINE_ATTACK);
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->next_server_seq_no=SERVER_KIZETSU_EFFECT_NO;
						ret=SSC_ACT_NO_WAZA_OUT;
					}
				}
				else{
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_CONFUSE_END);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=SSC_ACT_WAZA_SEQ;
				}
			}
			break;
		case SSC_MAHI:		//܂Ѓ`FbN
			if((sp->psp[sp->attack_client].condition&CONDITION_MAHI)&&
				//}WbNK[h́A܂Ђ̌ʂȂ
			   (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_MAZIKKUGAADO)){
				if(gf_rand()%4==0){
					sp->wocf[sp->attack_client].mahi_flag=1;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_PARALYSIS);
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//					sp->next_server_seq_no=SERVER_WAZA_END_NO;
					sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
					ret=SSC_ACT_NO_WAZA_OUT;
				}
			}
			sp->ssc_seq_no++;
			break;
		case SSC_MEROMERO:	//`FbN
			if(sp->psp[sp->attack_client].condition2&CONDITION2_MEROMERO){
				sp->client_work=Bit2No((sp->psp[sp->attack_client].condition2&CONDITION2_MEROMERO)>>MEROMERO_SHIFT);
				if(gf_rand()&1){
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MEROMERO_KEEP);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=SSC_ACT_WAZA_SEQ;
				}
				else{
					sp->wocf[sp->attack_client].meromero_flag=1;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MEROMERO_NG);
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//					sp->next_server_seq_no=SERVER_WAZA_END_NO;
					sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
					ret=SSC_ACT_NO_WAZA_OUT;
				}
			}
			sp->ssc_seq_no++;
			break;
		case SSC_GAMAN:		//܂`FbN
			sp->ssc_seq_no++;
			if(sp->psp[sp->attack_client].condition2&CONDITION2_GAMAN){
				sp->psp[sp->attack_client].condition2-=GAMAN_COUNT;
				if((sp->psp[sp->attack_client].condition2&CONDITION2_GAMAN)==0){
					if(sp->store_damage[sp->attack_client]){
						sp->damage=sp->store_damage[sp->attack_client]*2;
						if(sp->psp[sp->client_no_hit[sp->attack_client]].hp){
							sp->defence_client=sp->client_no_hit[sp->attack_client];
						}
						else{
							sp->defence_client=ST_ServerDirClientGet(bw,sp,sp->attack_client);
							if(sp->psp[sp->defence_client].hp==0){
								ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_GAMAN_NO_DEFENCE);
								sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
								sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
								ret=SSC_ACT_WAZA_SEQ;
								break;
							}
						}
					}
				}
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_GAMAN_AFTER);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=SSC_ACT_WAZA_SEQ;
			}
			break;
		case SSC_MELT:		//Ƃ`FbN
			if(sp->psp[sp->attack_client].condition&CONDITION_KOORI){
				if((battle_effect==125)||(battle_effect==253)){
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_WAZA_MELT);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=SSC_ACT_WAZA_SEQ;
				}
			}
			sp->ssc_seq_no++;
			break;
		case SSC_END:		//`FbNGh
			sp->ssc_seq_no=SSC_INIT;
			ret=SSC_ACT_END;
			break;
		}
	}while(ret==SSC_ACT_LOOP);

	ST_PSPtoPPCopy(bw,sp,sp->attack_client);

	if(ret==SSC_ACT_NO_WAZA_OUT){
		//Z̋NɎsĂȂÂɓ`FbNȂtO𗧂Ă
		sp->server_status_flag|=SERVER_STATUS_FLAG_NO_DOUBLE_CHECK;
		//Z̋NɎsĂȂAstO𗧂Ă
		sp->waza_status_flag|=WAZA_STATUS_FLAG_SIPPAI;
	}
	return (ret!=SSC_ACT_END);
}
	
//============================================================================================
/**
 *	`FbÑV[PXio[
 */
//============================================================================================
enum{
	STC_DAMAGE=0,		//_[W󂯎~߂`FbN
	STC_END
};

enum{
	STC_ACT_LOOP=0,			//`FbNp
	STC_ACT_WAZA_SEQ,		//bZ[W\Ȃǂ̃V[PX
	STC_ACT_END				//`FbN̏I
};

//============================================================================================
/**
 *	`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	ret;
	int	seq_no;

	ret=STC_ACT_LOOP;

	do{
		switch(sp->stc_seq_no){
		case STC_DAMAGE:
			//Ń_[W󂯎~߂`FbN
			seq_no=ST_ServerDamageTokuseiCheck(sp,sp->attack_client,sp->defence_client);
			if(((seq_no)&&((sp->waza_status_flag&WAZA_STATUS_FLAG_HAZURE)==0))||
				(seq_no==SUB_SEQ_BOUON)){
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				//Z̋NɎsĂȂAstO𗧂Ă
				//sp->waza_status_flag|=WAZA_STATUS_FLAG_SIPPAI_RENZOKU_CHECK;
				sp->waza_status_flag|=WAZA_STATUS_FLAG_SIPPAI;
				ret=STC_ACT_WAZA_SEQ;
			}
			sp->stc_seq_no++;
			break;
		case STC_END:
			sp->stc_seq_no=0;
			ret=STC_ACT_END;
			break;
		}
	}while(ret==STC_ACT_LOOP);
	
	return (ret!=STC_ACT_END);
}

//============================================================================================
/**
 *	搧ñACeʂ̃`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerSenseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_SENSEI_CHECK);
	sp->next_server_seq_no=sp->server_seq_no;
	sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;

	return TRUE;
}

//============================================================================================
/**
 *	abiritycntɂ閽ωe[u
 */
//============================================================================================

typedef struct{
	u8	kakeru;
	u8	waru;
}HitProbabilityTable;

static	const	HitProbabilityTable	HPT[]={
	{
	33,100			// 0.33
	},
	{
	36,100			//  0.36
	},
	{
	43,100			//  0.43
	},
	{
	50,100			//  0.50
	},
	{
	60,100			//  0.60
	},
	{
	75,100			//  0.75
	},
	{
	1,1				//  1.00
	},
	{
	133,100			//  1.33
	},
	{
	166,100			//  1.66
	},
	{
	2,1				//  2.00
	},
	{
	233,100			//  2.33
	},
	{
	133,50			//  2.66
	},
	{
	3,1				//  3.00
	},
};

//============================================================================================
/**
 *	`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerHitCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,int defence,int waza_no)
{
	u16		hit;
	s8		value;
	s8		cond_hit,cond_avoid;
	int		eqp;
	int		atk;
	u8		wazatype;
	u8		wazakind;

	//ߊlf́A100%
	if(BattleWorkFightTypeGet(bw)&FIGHT_TYPE_GET_DEMO){
		return FALSE;
	}

	//m[}XĹA^Cvm[}
	if(ST_ServerTokuseiGet(sp,attack)==TOKUSYU_NOOMARUSUKIN){
		wazatype=NORMAL_TYPE;
	}
	else if(sp->waza_type){
		wazatype=sp->waza_type;
	}
	else{
//		wazatype=WT_WazaDataParaGet(waza_no,ID_WTD_wazatype);
		wazatype=sp->AIWT.wtd[waza_no].wazatype;
	}
//	wazakind=WT_WazaDataParaGet(waza_no,ID_WTD_kind);
	wazakind=sp->AIWT.wtd[waza_no].kind;

	cond_hit=sp->psp[attack].abiritycnt[COND_HIT]-6;
	cond_avoid=6-sp->psp[defence].abiritycnt[COND_AVOID];

	//񂶂ĂƂ́Aqbg㏸{
	if(ST_ServerTokuseiGet(sp,attack)==TOKUSYU_TANZYUN){
		cond_hit*=2;
	}

	//񂶂ĂƂ́A𗦏㏸{
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TANZYUN)==TRUE){
		cond_avoid*=2;
	}

	//Ă˂ĂƂ́Aqbgtbg
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TENNEN)==TRUE){
		cond_hit=0;
	}

	//Ă˂ĂƂ́A𗦂tbg
	if(ST_ServerTokuseiGet(sp,attack)==TOKUSYU_TENNEN){
		cond_avoid=0;
	}

	//݂ԂA킯A~NACʂ̂Ƃ́A㏸Ă𗦂ɖ߂
	if(((sp->psp[defence].condition2&CONDITION2_MIYABURU)||(sp->psp[defence].waza_kouka&WAZAKOUKA_MIRACLE_EYE))&&
		(cond_avoid<0)){
		cond_avoid=0;
	}

	value=6+cond_avoid+cond_hit;

	if(value<0){
		value=0;
	}
	if(value>12){
		value=12;
	}

//	hit=WT_WazaDataParaGet(waza_no,ID_WTD_hitprobability);
	hit=sp->AIWT.wtd[waza_no].hitprobability;

	//0́AGNZŁu|vȂ̂Ő΂ɓ
	if(hit==0){
		return FALSE;
	}

	//ߋZn1^[ڂ́AɊ֌WȂZ𔭓
	if(sp->server_status_flag&SERVER_STATUS_FLAG_TAME){
		return FALSE;
	}

	//ʂ̖vZĂ鎞́ǍvZ͂Ȃ
	if(sp->server_status_flag&SERVER_STATUS_FLAG_OTHER_HIT_CALC){
		return FALSE;
	}

	//\͂̂Ă񂫂́A`FbNȂ
	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		//̂ƂA݂Ȃ͖50%ɂ
//		if((sp->field_condition&FIELD_CONDITION_HARE_ALL)&&(WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)==152)){
		if((sp->field_condition&FIELD_CONDITION_HARE_ALL)&&(sp->AIWT.wtd[waza_no].battleeffect==152)){
			hit=50;
		}
	}

	hit*=HPT[value].kakeru;
	hit/=HPT[value].waru;

	//\͂ӂ́AROAbv
	if(ST_ServerTokuseiGet(sp,attack)==TOKUSYU_HUKUGAN){
		hit=hit*130/100;
	}

	//\͂̂Ă񂫂́A`FbNȂ
	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		//\͂Ȃ́AQO_EiȂ炵̎Ɂj
		if(sp->field_condition&FIELD_CONDITION_SUNAARASHI_ALL){
			if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_SUNAGAKURE)==TRUE){
				hit=hit*80/100;
			}
		}
		//Ⴊ́AQO_Ei̎Ɂj
		if(sp->field_condition&FIELD_CONDITION_ARARE_ALL){
			if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_YUKIGAKURE)==TRUE){
				hit=hit*80/100;
			}
		}
		//V󂪂ӂ̎́A6/10ɂ
		if(sp->field_condition&FIELD_CONDITION_HUKAIKIRI){
			hit=hit*6/10;
		}
	}

	//\͂͂肫́AU̖QO_E
	if((ST_ServerTokuseiGet(sp,attack)==TOKUSYU_HARIKIRI)&&(wazakind==KIND_BUTSURI)){
		hit=hit*80/100;
	}

	//ǂ肠́A̖TO_E
	if((ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TIDORIASI)==TRUE)&&
	   (sp->psp[defence].condition2&CONDITION2_KONRAN)){
		hit=hit*50/100;
	}

	eqp=ST_ServerSoubiEqpGet(sp,defence);
	atk=ST_ServerSoubiAtkGet(sp,defence,ATK_CHECK_NORMAL);

	//ACeŖ_Ěʂ̂̂́A_E
	if(eqp==SOUBI_MEITYUURITUDOWN){
		hit=hit*(100-atk)/100;
	}

	eqp=ST_ServerSoubiEqpGet(sp,attack);
	atk=ST_ServerSoubiAtkGet(sp,attack,ATK_CHECK_NORMAL);

	//ACeŖAbv̌ʂ̂̂́AAbv
	if(eqp==SOUBI_MEITYUUUP){
		hit=hit*(100+atk)/100;
	}

	//ACeŌÛƂAAbv̌ʂ̂̂́AAbv
	if((eqp==SOUBI_KOUKOUNOTOKIMEITYUUUP)&&(ST_ServerWazaEndCheck(sp,defence)==TRUE)){
		hit=hit*(100+atk)/100;
	}

	//ʂňxAbv́A20%Abv
	if(sp->psp[attack].wkw.once_hit_up){
		sp->psp[attack].wkw.once_hit_up=0;
		hit=hit*120/100;
	}

	//イ傭́A10/6{ɃAbv
	if(sp->field_condition&FIELD_CONDITION_JUURYOKU){
		hit=hit*10/6;
	}

	if((gf_rand()%100)+1>hit){
		sp->waza_status_flag|=WAZA_STATUS_FLAG_NOHIT;
	}
	return FALSE;
}

//============================================================================================
/**
 *	Zʃ`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerWazaKoukaCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,int defence,int waza_no)
{
	//ߋZn1^[ڂ́AZ𔭓̂ŁA`FbN̕KvȂ
	if(sp->server_status_flag&SERVER_STATUS_FLAG_TAME){
		return FALSE;
	}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// s킴hł܂sC
// localize_spec_mark(LANG_ALL) imatake 2007/04/21
// m[K[hł܂ђʂ邱Ƃ̂C

#if AFTER_MASTER_070202_BT3_FIX && !(AFTER_MASTER_070405_BT_FIX)
	//܂邪AD揇ʓIɍŏ
	//Zɂ܂tOĂāAmamoru_flagĂ΁A܂
	if((sp->otf[defence].mamoru_flag)&&
	   (sp->AIWT.wtd[waza_no].flag&FLAG_MAMORU)&&
	   //łɊOĂ鎞́A܂𖳎
	  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)){
		//̂낢Ńm[}A܂𖳎
		if((waza_no!=WAZANO_NOROI)||(ST_ServerWazaNoroiCheck(sp,waza_no,attack)==TRUE)){
			if((ST_TameWazaCheck(sp,waza_no)==FALSE)||(sp->server_status_flag&SERVER_STATUS_FLAG_TAME_AFTER)){
				ST_ServerKeepOff(bw,sp,attack);
				sp->waza_status_flag|=WAZA_STATUS_FLAG_MAMORU_NOHIT;
				return FALSE;
			}
		}
	}
#else AFTER_MASTER_070202_BT3_FIX
	//܂邪AD揇ʓIɍŏ
	//Zɂ܂tOĂāAmamoru_flagĂ΁A܂
//	if((sp->otf[defence].mamoru_flag)&&(WT_WazaDataParaGet(waza_no,ID_WTD_flag)&FLAG_MAMORU)){
	if((sp->otf[defence].mamoru_flag)&&(sp->AIWT.wtd[waza_no].flag&FLAG_MAMORU)){
		//̂낢Ńm[}A܂𖳎
		if((waza_no!=WAZANO_NOROI)||(ST_ServerWazaNoroiCheck(sp,waza_no,attack)==TRUE)){
			if((ST_TameWazaCheck(sp,waza_no)==FALSE)||(sp->server_status_flag&SERVER_STATUS_FLAG_TAME_AFTER)){
				ST_ServerKeepOff(bw,sp,attack);
				sp->waza_status_flag|=WAZA_STATUS_FLAG_MAMORU_NOHIT;
				return FALSE;
			}
		}
	}
#endif //AFTER_MASTER_070202_BT3_FIX

// ----------------------------------------------------------------------------

	//ʏ̖vZł͂Ȃꍇ́AbNIAm[K[h`FbNȂ
	if((sp->server_status_flag&SERVER_STATUS_FLAG_OTHER_HIT_CALC)==0){
		//bNIʂĂƂAm[K[hĂ|Pɑ΂ẮAK
		if(((sp->psp[defence].waza_kouka&WAZAKOUKA_LOCKON)&&
		    (sp->psp[defence].wkw.lockon_client_no==attack))||
		    (ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_NOOGAADO)||
		    (ST_ServerTokuseiGet(sp,sp->defence_client)==TOKUSYU_NOOGAADO)){
			//vZł̂͂𗎂Ƃ
			sp->waza_status_flag&=WAZA_STATUS_FLAG_NOHIT_OFF;
			return FALSE;
		}
	}
	//\͂̂Ă񂫂́A`FbNȂ
	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		//ĴƂA݂Ȃ͕K
//		if((sp->field_condition&FIELD_CONDITION_AME_ALL)&&(WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)==152)){
		if((sp->field_condition&FIELD_CONDITION_AME_ALL)&&(sp->AIWT.wtd[waza_no].battleeffect==152)){
			sp->waza_status_flag&=WAZA_STATUS_FLAG_NOHIT_OFF;
		}
		//̂ƂAӂԂ͕K
//		if((sp->field_condition&FIELD_CONDITION_ARARE_ALL)&&(WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)==260)){
		if((sp->field_condition&FIELD_CONDITION_ARARE_ALL)&&(sp->AIWT.wtd[waza_no].battleeffect==260)){
			sp->waza_status_flag&=WAZA_STATUS_FLAG_NOHIT_OFF;
		}
	}

	//bNIʂœĂꍇ́AɂȂ`FbN͂Ȃ
	if(((sp->waza_status_flag&WAZA_STATUS_FLAG_LOCK_ON)==0)&&
	//܂тńA`FbNȂ
		(sp->AIWT.wtd[sp->waza_no_now].attackrange!=RANGE_MAKIBISHI)){
		if(
			//ƂԁAȂقA_CrOAVhE_CúAȂi̋Zāj
			(
			((sp->server_status_flag&SERVER_STATUS_FLAG_SORAWOTOBU_HIT)==0)&&
			(sp->psp[defence].waza_kouka&WAZAKOUKA_SORAWOTOBU)
			)||
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/04/21
// Vh[_CűuȂقvƈv悤ɏC
#if AFTER_MASTER_070409_49_EUR_FIX
			(
			((sp->server_status_flag&SERVER_STATUS_FLAG_SHADOW_DIVE_HIT)==0)&&
			(sp->psp[defence].waza_kouka&WAZAKOUKA_SHADOW_DIVE)
			)||
#else //AFTER_MASTER_070409_49_EUR_FIX
			(sp->psp[defence].waza_kouka&WAZAKOUKA_SHADOW_DIVE)
			 ||
#endif //AFTER_MASTER_070409_49_EUR_FIX
// ----------------------------------------------------------------------------
			(
			((sp->server_status_flag&SERVER_STATUS_FLAG_ANAWOHORU_HIT)==0)&&
			(sp->psp[defence].waza_kouka&WAZAKOUKA_ANAWOHORU)
			)||
			(
			((sp->server_status_flag&SERVER_STATUS_FLAG_DAIBINGU_HIT)==0)&&
			(sp->psp[defence].waza_kouka&WAZAKOUKA_DAIBINGU)
			)){
			sp->waza_status_flag|=WAZA_STATUS_FLAG_KIE_NOHIT;
		}
	}
	return FALSE;
}

//============================================================================================
/**
 *	ZŗL`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerWazaKoyuuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i;
	int	client_no;
	int	client_set_max;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	//ΏۂȂ΁A`FbNȂ
	if(sp->defence_client==NONE_CLIENT_NO){
		return FALSE;
	}

	//}WbNR[g`FbN
	if(((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
	    (sp->otf[sp->defence_client].magic_cort_flag)&&
//	    (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_MAGICCORT)){
	    (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_MAGICCORT)){
	    sp->otf[sp->defence_client].magic_cort_flag=0;
		sp->waza_no_mamoru[sp->attack_client]=0;
		sp->waza_no_old[sp->attack_client]=sp->waza_no_temp;
		sp->waza_no_last=sp->waza_no_temp;
		sp->server_status_flag|=SERVER_STATUS_FLAG_NO_WAZANO_SET;
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MAGIC_CORT);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		ST_ServerPressurePPDecCheck(sp,sp->defence_client,sp->attack_client);
		return TRUE;
	}
	//悱ǂ`FbN
	for(i=0;i<client_set_max;i++){
		client_no=sp->psp_agi_work[i];
		if(((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		    (sp->otf[client_no].yokodori_flag)&&
//		    (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_YOKODORI)){
		    (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_YOKODORI)){
			sp->client_work=client_no;
		    sp->otf[client_no].yokodori_flag=0;
			if((sp->server_status_flag&SERVER_STATUS_FLAG_NO_WAZANO_SET)==0){
				sp->waza_no_mamoru[sp->attack_client]=0;
				sp->waza_no_old[sp->attack_client]=sp->waza_no_temp;
				sp->waza_no_last=sp->waza_no_temp;
				sp->server_status_flag|=SERVER_STATUS_FLAG_NO_WAZANO_SET;
			}
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_YOKODORI);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			ST_ServerPressurePPDecCheck(sp,client_no,sp->attack_client);
			return TRUE;
		}
	}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/24
// NĂƂ́uށvuтvhł܂sC
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// ݂̂ĂȂƂ́û߂݁vuȂv̏CƓ
// û߂݁vCIt̂Ƃ͂̏CIɂȂ悤ɕύXĔf
// localize_spec_mark(LANG_ALL) imatake 2007/04/21
// C@ēxύX

//ʂ̏C@ɕύXiAFTER_MASTER_070202_BT3_FIX̉ӏj
#if !AFTER_MASTER_070405_BT_FIX
#if !AFTER_MASTER_070202_BT3_FIX
#if AFTER_MASTER_070123_BT4_FIX
	//܂̃`FbNOɋNĂ`FbNāA܂`FbNX[
	//ރ`FbN
	if(((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
	   ((sp->psp[sp->defence_client].condition&CONDITION_NEMURI)==0)&&
//	    (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_battleeffect)==107)){
	    (sp->AIWT.wtd[sp->waza_no_now].battleeffect==107)){
		sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
	}
	//т`FbN
	if(((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
	   ((sp->psp[sp->attack_client].condition&CONDITION_NEMURI)==0)&&
//	    (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_battleeffect)==92)){
	    (sp->AIWT.wtd[sp->waza_no_now].battleeffect==92)){
		sp->waza_status_flag|=WAZA_STATUS_FLAG_UMAKUKIMARAN;
	}
#endif //AFTER_MASTER_070123_BT4_FIX
#endif
#endif

// ----------------------------------------------------------------------------

	return FALSE;
}

//============================================================================================
/**
 *	ZV[PXs
 *
 * @param
 */
//============================================================================================
static	void	ServerWazaSequence(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(SkillIntp(bw,sp)==TRUE){
		sp->skill_seq_no=0;
		sp->server_seq_no=sp->next_server_seq_no;
	}
}

//============================================================================================
/**
 *	ZO`FbNV[PX
 *
 * @param
 */
//============================================================================================
enum{
	SEQ_SENSEI_CHECK=0,
	SEQ_STATUS_CHECK,
	SEQ_BADGE_CHECK,
	SEQ_PP_CHECK,
	SEQ_DEFENCE_CHECK,
	SEQ_WAZAKOYUU_CHECK,
	SEQ_DEFENCE_CHANGE_CHECK
};

//============================================================================================
/**
 *	ZO
 *
 * @param
 */
//============================================================================================
static	void	ServerWazaBefore(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	switch(sp->wb_seq_no){
	case SEQ_SENSEI_CHECK:
		ServerSenseiCheck(bw,sp);			///<搧ñACeʂ̃`FbN
		sp->wb_seq_no++;
		return;
		break;
	case SEQ_STATUS_CHECK:
		if((sp->waza_out_check_on_off&STATUS_CHECK_OFF)==0){
			if(ServerStatusCheck(bw,sp)==TRUE){			///<Ԉُ`FbN
				return;
			}
		}
		sp->wb_seq_no++;
	case SEQ_BADGE_CHECK:
		{
			int	ret;
			int	seq_no;

			if((sp->waza_out_check_on_off&BADGE_CHECK_OFF)==0){
				ret=ServerBadgeCheck(bw,sp,&seq_no);
				if(ret){
					switch(ret){			///<obW`FbN
					case 1:		//Ƃ𕷂ɋZȂn
//						sp->next_server_seq_no=SERVER_WAZA_END_NO;
						sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
						break;
					case 2:		//Ƃ𕷂ɕʂ̋Zo
						sp->next_server_seq_no=sp->server_seq_no;
						break;
					case 3:		//߂𖳎ĎU
						sp->next_server_seq_no=SERVER_KIZETSU_EFFECT_NO;
						break;
					}
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
					return;
				}
			}
		}
		sp->wb_seq_no++;
	case SEQ_PP_CHECK:
		if((sp->waza_out_check_on_off&PP_CHECK_OFF)==0){
			if(ServerPPCheck(bw,sp)==TRUE){				///<PP`FbN
				return;
			}
		}
		sp->wb_seq_no++;
	case SEQ_DEFENCE_CHECK:
		if(ServerDefenceCheck(bw,sp)==TRUE){			///<UΏۃ`FbN
			return;
		}
		sp->wb_seq_no++;
	case SEQ_WAZAKOYUU_CHECK:
		if((sp->waza_out_check_on_off&WAZAKOYUU_CHECK_OFF)==0){
			if(ServerWazaKoyuuCheck(bw,sp)==TRUE){		///<ZŗL`FbN
				return;
			}
		}
		sp->wb_seq_no++;
	case SEQ_DEFENCE_CHANGE_CHECK:
		ST_ServerDefenceClientTokuseiCheck(bw,sp,sp->attack_client,sp->waza_no_now);
		sp->wb_seq_no=0;
	}
	//ZoȂñtOĂꍇ́A͂ꃁbZ[WV[PX
	if(sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT){
		sp->server_seq_no=SERVER_WAZA_HAZURE_MESSAGE_NO;
	}
	else{
		sp->server_status_flag2|=SERVER_STATUS_FLAG2_WAZA_OUT;
		ST_ServerSequenceLoad(sp,ARC_WAZA_SEQ,sp->waza_no_now);
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		sp->next_server_seq_no=SERVER_WAZA_OUT_CHECK_NO;
		//ƂĂJEgvZ
		ST_ServerTotteokiCountCalc(bw,sp);
	}
	//gm[`FbN
	ST_ServerMetronomeBeforeCheck(bw,sp);
}

//============================================================================================
/**
 *	Z`FbÑV[PXio[
 */
//============================================================================================
enum{
	SEQ_DEFENCE_CHECK2=0,
	SEQ_DEFENCE_CHANGE_ACT,
	SEQ_HIT_CHECK,
	SEQ_WAZAKOUKA_CHECK,
	SEQ_TYPE_CHECK,
	SEQ_TOKUSEI_CHECK,
	SEQ_CHECK_END
};

//============================================================================================
/**
 *	Z`FbN
 *
 * @param
 */
//============================================================================================
static	void	ServerWazaOutCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{

	switch(sp->woc_seq_no){
	//ptn[uŁA߃^[X[Ă܂łĂ܂̂ŁAēxNONE_CLIENT_NO`FbN
	case SEQ_DEFENCE_CHECK2:
		sp->woc_seq_no++;
		if(ServerDefenceCheck(bw,sp)==TRUE){			///<UΏۃ`FbN
			return;
		}
	//DefenceClientύX̃`FbN
	case SEQ_DEFENCE_CHANGE_ACT:
		sp->woc_seq_no++;
		if(ST_ServerDefenceClientTokuseiAct(bw,sp)==TRUE){
			return;
		}
	case SEQ_HIT_CHECK:
		if(((sp->waza_out_check_on_off&HIT_CHECK_OFF)==0)&&(sp->defence_client!=NONE_CLIENT_NO)){
			if(ServerHitCheck(bw,sp,sp->attack_client,sp->defence_client,sp->waza_no_now)==TRUE){		///<`FbN
				return;
			}
		}
		sp->woc_seq_no++;
	case SEQ_WAZAKOUKA_CHECK:
		if(((sp->waza_out_check_on_off&WAZAKOUKA_CHECK_OFF)==0)&&(sp->defence_client!=NONE_CLIENT_NO)){
			if(ServerWazaKoukaCheck(bw,sp,sp->attack_client,sp->defence_client,sp->waza_no_now)==TRUE){		///<Zʃ`FbN
				return;
			}
		}
		sp->woc_seq_no++;
	case SEQ_TYPE_CHECK:
		if(((sp->waza_out_check_on_off&TYPE_CHECK_OFF)==0)&&(sp->defence_client!=NONE_CLIENT_NO)){
			if(ServerTypeCheck(bw,sp)==TRUE){			///<TYPE`FbN
				return;
			}
		}
		sp->woc_seq_no++;
	case SEQ_TOKUSEI_CHECK:
		if(((sp->waza_out_check_on_off&TOKUSEI_CHECK_OFF)==0)&&(sp->defence_client!=NONE_CLIENT_NO)){
			if(ServerTokuseiCheck(bw,sp)==TRUE){		///<`FbN
				return;
			}
		}
		sp->woc_seq_no++;
	case SEQ_CHECK_END:
		sp->woc_seq_no=0;
		break;
	}
	sp->server_seq_no=SERVER_ADD_STATUS_DIRECT_CHECK_NO;
}

//============================================================================================
/**
 *	ǉʃ`FbNiڒǉ̂݁j
 *
 * @param
 */
//============================================================================================
static	void	ServerAddStatusDirectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	seq_no;

	if(ST_ServerAddStatusDirectCheck(bw,sp,&seq_no)==TRUE){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		sp->next_server_seq_no=SERVER_WAZA_HAZURE_MESSAGE_NO;
		return;
	}
	else{
		sp->server_seq_no=SERVER_WAZA_HAZURE_MESSAGE_NO;
	}
}

//============================================================================================
/**
 *	ȂnbZ[W\
 *
 * @param
 */
//============================================================================================
static	void	ServerWazaHazureMessage(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//Z̋NɎsĂƁÃtOĂ̂ŁAȍ~̃`FbN͂Ȃ
	if(sp->waza_status_flag&WAZA_STATUS_FLAG_SIPPAI){
		sp->server_seq_no=SERVER_LOOP_CHECK_NO;
	}
	//PPȂ
	else if(sp->waza_status_flag&WAZA_STATUS_FLAG_PP_NONE){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_PP_NONE);
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
//		sp->next_server_seq_no=SERVER_WAZA_END_NO;
		sp->next_server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
	}
	//AUnł̂͂́AA߂
	else if((sp->loop_flag)&&(sp->waza_status_flag&WAZA_STATUS_FLAG_NOHIT)){
		sp->waza_status_flag&=WAZA_STATUS_FLAG_NOHIT_OFF;
		sp->waza_status_flag|=WAZA_STATUS_FLAG_RENZOKU_NOHIT;
		sp->server_seq_no=SERVER_WAZA_OUT_AFTER_MESSAGE_NO;
	}
	else if(sp->waza_status_flag&WAZA_STATUS_FLAG_HAZURE){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_WAZA_NO_HIT);
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		sp->next_server_seq_no=SERVER_KIZETSU_EFFECT_NO;
	}
	else{
		sp->server_seq_no=SERVER_WAZA_OUT_NO;
	}
}

//============================================================================================
/**
 *	Z㏈
 *
 * @param
 */
//============================================================================================
static	void	ServerWazaOut(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_WAZA_OUT);
	sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	sp->next_server_seq_no=SERVER_HP_CALC_NO;
}

//============================================================================================
/**
 *	HPvZ
 *
 * @param
 */
//============================================================================================
static	void	ServerHPCalc(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	eqp;
	int	atk;

	//ꌂKE̎́AHPMAX_[Wɑ
	if(sp->waza_status_flag&WAZA_STATUS_FLAG_ICHIGEKI){
		sp->damage=sp->psp[sp->defence_client].hpmax*-1;
	}
	if(sp->damage){
		eqp=ST_ServerSoubiEqpGet(sp,sp->defence_client);
		atk=ST_ServerSoubiAtkGet(sp,sp->defence_client,ATK_CHECK_NORMAL);

		//oOł͂ȂǁA邩Ȃ𔻒f邽
		GF_ASSERT_MSG(sp->damage<0,"_[W{ł\n");

		//p[eBA^bN񐔂JEgAbv
		if(BattleWorkMineEnemyCheck(bw,sp->attack_client)==BattleWorkMineEnemyCheck(bw,sp->defence_client)){
			SCIO_IncRecord(bw,sp->attack_client,CLIENT_BOOT_TYPE_MINE,RECID_TEMOTI_MAKIZOE);
		}

		//ŌɓĂClientNopobt@Ɋi[
		sp->client_no_hit[sp->defence_client]=sp->attack_client;

		//݂`FbN
		if((sp->psp[sp->defence_client].condition2&CONDITION2_MIGAWARI)&&(sp->damage<0)){
			if((sp->psp[sp->defence_client].wkw.migawari_hp+sp->damage)<=0){
				sp->ostf[sp->attack_client].kaigara_damage+=(sp->psp[sp->defence_client].wkw.migawari_hp*-1);
				sp->psp[sp->defence_client].condition2&=CONDITION2_MIGAWARI_OFF;
				sp->hit_damage=sp->psp[sp->defence_client].wkw.migawari_hp*-1;
				sp->psp[sp->defence_client].wkw.migawari_hp=0;
			}
			else{
				sp->ostf[sp->attack_client].kaigara_damage+=sp->damage;
				sp->psp[sp->defence_client].wkw.migawari_hp+=sp->damage;
				sp->hit_damage=sp->damage;
			}
			sp->ostf[sp->defence_client].status_flag|=OSTF_STATUS_FLAG_MIGAWARI_HIT;
			sp->client_work=sp->defence_client;
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MIGAWARI_HIT);
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			sp->next_server_seq_no=SERVER_WAZA_OUT_AFTER_MESSAGE_NO;
		}
		else{
			//݂˂`FbN
//			if(WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_battleeffect)==101){
			if(sp->AIWT.wtd[sp->waza_no_now].battleeffect==101){
				//C₵Ă܂́APc悤ɂ
				if((sp->psp[sp->defence_client].hp+sp->damage)<=0){
					sp->damage=(sp->psp[sp->defence_client].hp-1)*-1;
				}
			}
			//Ẑ炦邪Ă鎞́AACẽ`FbNȂ
			if(sp->otf[sp->defence_client].koraeru_flag==0){
				//ACe炦`FbN
#ifdef PM_DEBUG
				if((eqp==SOUBI_HPITIDETAERU)&&(((gf_rand()%100)<atk)||(sp->dbp.debug_flag&DEBUG_FLAG_SOUBI))){
#else
				if((eqp==SOUBI_HPITIDETAERU)&&((gf_rand()%100)<atk)){
#endif
					sp->ostf[sp->defence_client].item_koraeru_flag=1;
				}
				if((eqp==SOUBI_HPMAXDEITIGEKISISINAI)&&(sp->psp[sp->defence_client].hp==sp->psp[sp->defence_client].hpmax)){
					sp->ostf[sp->defence_client].item_koraeru_flag=1;
				}
			}
			//炦`FbN
			if((sp->otf[sp->defence_client].koraeru_flag)||(sp->ostf[sp->defence_client].item_koraeru_flag)){
				//C₵Ă܂́APc悤ɂ
				if((sp->psp[sp->defence_client].hp+sp->damage)<=0){
					sp->damage=(sp->psp[sp->defence_client].hp-1)*-1;
					if(sp->otf[sp->defence_client].koraeru_flag){
						sp->waza_status_flag|=WAZA_STATUS_FLAG_KORAETA;
					}
					else{
						sp->waza_status_flag|=WAZA_STATUS_FLAG_ITEM_KORAETA;
					}
				}
			}
			//܂p̃_[WXgbN[Nɑ
			sp->store_damage[sp->defence_client]+=sp->damage;
	
			//U󂯂JE^JEgAbv
			if(sp->psp[sp->defence_client].hit_count<255){
				sp->psp[sp->defence_client].hit_count++;
			}
//			if(WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_kind)==KIND_BUTSURI){
			if(sp->AIWT.wtd[sp->waza_no_now].kind==KIND_BUTSURI){
				sp->otf[sp->defence_client].butsuri_otf_damage[sp->attack_client]=sp->damage;
				sp->otf[sp->defence_client].butsuri_otf_client=sp->attack_client;
				sp->otf[sp->defence_client].butsuri_otf_client_bit|=No2Bit(sp->attack_client);
				sp->ostf[sp->defence_client].butsuri_ostf_damage=sp->damage;
				sp->ostf[sp->defence_client].butsuri_ostf_client=sp->attack_client;
			}
//			else if(WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_kind)==KIND_TOKUSYU){
			else if(sp->AIWT.wtd[sp->waza_no_now].kind==KIND_TOKUSYU){
				sp->otf[sp->defence_client].tokusyu_otf_damage[sp->attack_client]=sp->damage;
				sp->otf[sp->defence_client].tokusyu_otf_client=sp->attack_client;
				sp->otf[sp->defence_client].tokusyu_otf_client_bit|=No2Bit(sp->attack_client);
				sp->ostf[sp->defence_client].tokusyu_ostf_damage=sp->damage;
				sp->ostf[sp->defence_client].tokusyu_ostf_client=sp->attack_client;
			}
			//_[W͎ۂɂgo炵ۗʂŌvZ
			if((sp->psp[sp->defence_client].hp+sp->damage)<=0){
				sp->ostf[sp->attack_client].kaigara_damage+=(sp->psp[sp->defence_client].hp*-1);
			}
			else{
				sp->ostf[sp->attack_client].kaigara_damage+=sp->damage;
			}
			sp->otf[sp->defence_client].last_otf_damage=sp->damage;
			sp->otf[sp->defence_client].last_otf_client=sp->attack_client;
			///<HPvZ
			sp->client_work=sp->defence_client;
			sp->hp_calc_work=sp->damage;
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HP_CALC);
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			sp->next_server_seq_no=SERVER_WAZA_OUT_AFTER_MESSAGE_NO;
			//ZƂtO𗧂Ă
			sp->server_status_flag|=SERVER_STATUS_FLAG_WAZA_HIT;
		}
	}
	else{
		sp->server_seq_no=SERVER_WAZA_OUT_AFTER_MESSAGE_NO;
	}
}

//============================================================================================
/**
 *	Zł̂낢ȃbZ[W\
 *
 * @param
 */
//============================================================================================
static	void	ServerWazaOutAfterMessage(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	switch(sp->swoam_type){
	case SWOAM_NORMAL:
		switch(sp->swoam_seq_no){
		case 0:
			sp->swoam_seq_no++;
			if(ServerCriticalMessage(bw,sp)==TRUE){
				return;
			}
		case 1:
			sp->swoam_seq_no++;
			if(ServerWazaStatusMessage(bw,sp)==TRUE){
				return;
			}
		case 2:
			{
				int	seq_no;

				sp->swoam_seq_no++;
				if((ST_ServerAddStatusCheck(bw,sp,&seq_no)==TRUE)&&((sp->waza_status_flag&WAZA_STATUS_FLAG_HAZURE)==0)){
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					return;
				}
			}
		case 3:
			sp->swoam_seq_no++;
			if(ServerIkariCheck(bw,sp)==TRUE){
				return;
			}
		case 4:
			{
				int	seq_no;
	
				sp->swoam_seq_no++;
				if(ST_ServerWazaHitTokuseiCheck(bw,sp,&seq_no)==TRUE){
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					return;
				}
			}
		case 5:
			sp->swoam_seq_no++;
			if(ServerHirumaseruCheck(bw,sp)==TRUE){
				return;
			}
		default:
			break;
		}
		break;
	case SWOAM_LOOP:
		switch(sp->swoam_seq_no){
		case 0:
			sp->swoam_seq_no++;
			if(ServerCriticalMessage(bw,sp)==TRUE){
				return;
			}
		case 1:
			{
				int	seq_no;

				sp->swoam_seq_no++;
				if((ST_ServerAddStatusCheck(bw,sp,&seq_no)==TRUE)&&((sp->waza_status_flag&WAZA_STATUS_FLAG_HAZURE)==0)){
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					return;
				}
			}
		case 2:
			sp->swoam_seq_no++;
			if(ServerIkariCheck(bw,sp)==TRUE){
				return;
			}
		case 3:
			{
				int	seq_no;
	
				sp->swoam_seq_no++;
				if(ST_ServerWazaHitTokuseiCheck(bw,sp,&seq_no)==TRUE){
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					return;
				}
			}
		case 4:
			sp->swoam_seq_no++;
			if(ServerWazaStatusMessage(bw,sp)==TRUE){
				return;
			}
		case 5:
			sp->swoam_seq_no++;
			if(ServerHirumaseruCheck(bw,sp)==TRUE){
				return;
			}
		default:
			break;
		}
		break;
	}
	sp->swoam_seq_no=0;
	sp->server_seq_no=SERVER_WAZA_OUT_AFTER_KOUKA_NO;
}

//============================================================================================
/**
 *	ǉʃ`FbNiڒǉȊOji̊֐̒ɋzj
 *
 * @param
 */
//============================================================================================
static	void	ServerAddStatusCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
#if 0
	int	seq_no;

	if((ST_ServerAddStatusCheck(bw,sp,&seq_no)==TRUE)&&((sp->waza_status_flag&WAZA_STATUS_FLAG_HAZURE)==0)){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		sp->next_server_seq_no=SERVER_WAZA_OUT_AFTER_KOUKA_NO;
		return;
	}
	else{
		sp->server_seq_no=SERVER_WAZA_OUT_AFTER_KOUKA_NO;
	}
#endif
}

//============================================================================================
/**
 *	Zł̂낢Ȍʃ`FbN
 *
 * @param
 */
//============================================================================================
enum{
//	SWOAK_SEQ_WAZA_HIT_TOKUSEI=0,
	SWOAK_SEQ_VANISH_ON_OFF=0,
	SWOAK_SEQ_SINKURO_CHECK,
	SWOAK_SEQ_POKE_APPEAR_CHECK,
//	SWOAK_SEQ_TOKUSEI_RECOVER_ATTACK,
//	SWOAK_SEQ_TOKUSEI_RECOVER_DEFENCE,
	SWOAK_SEQ_SOUBI_ITEM_ATTACK,
	SWOAK_SEQ_SOUBI_ITEM_DEFENCE,
	SWOAK_SEQ_WAZA_HIT_SOUBI_ITEM,
	SWOAK_SEQ_MELT_ICE,
	SWOAK_SEQ_SOUBI_ITEM_CONDITION_BAD
};

static	void	ServerWazaOutAfterKouka(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	switch(sp->swoak_seq_no){
#if 0
	case SWOAK_SEQ_WAZA_HIT_TOKUSEI:
		{
			int	seq_no;

			sp->swoak_seq_no++;
			if(ST_ServerWazaHitTokuseiCheck(bw,sp,&seq_no)==TRUE){
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				return;
			}
		}
#endif
	case SWOAK_SEQ_VANISH_ON_OFF:
		{
			int	ret=0;
			while(sp->swoak_work<BattleWorkClientSetMaxGet(bw)){
				//wazakoukatO(\\Ɂj
				if(((sp->psp[sp->swoak_work].waza_kouka&WAZAKOUKA_KIE)==0)&&
				    (sp->psp[sp->swoak_work].waza_kouka_temp&WAZAKOUKA_KIE)){
				    sp->psp[sp->swoak_work].waza_kouka_temp&=WAZAKOUKA_KIE_OFF;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_VANISH_OFF);
					sp->client_work=sp->swoak_work;
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
				sp->swoak_work++;
				if(ret){
					return;
				}
			}
		}
		sp->swoak_seq_no++;
		sp->swoak_work=0;
	case SWOAK_SEQ_SINKURO_CHECK:
		sp->swoak_seq_no++;
		if(ST_ServerSinkuroCheck(bw,sp,sp->server_seq_no)==TRUE){
			return;
		}
	//og^b`Ƃڂœꂩp
	case SWOAK_SEQ_POKE_APPEAR_CHECK:
		{
			int	seq_no;

			seq_no=ST_ServerPokeAppearCheck(bw,sp);

			if(seq_no){
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				return;
			}
		}
		sp->swoak_seq_no++;
#if 0
	case SWOAK_SEQ_TOKUSEI_RECOVER_ATTACK:
		sp->swoak_seq_no++;
		if(ST_ServerTokuseiStatusRecoverCheck(bw,sp,sp->attack_client,0)==TRUE){
			return;
		}
	case SWOAK_SEQ_TOKUSEI_RECOVER_DEFENCE:
		sp->swoak_seq_no++;
		if(sp->defence_client!=NONE_CLIENT_NO){
			if(ST_ServerTokuseiStatusRecoverCheck(bw,sp,sp->defence_client,0)==TRUE){
				return;
			}
		}
#endif
	case SWOAK_SEQ_SOUBI_ITEM_ATTACK:
		sp->swoak_seq_no++;
		if(ST_ServerSoubiItemCheck(bw,sp,sp->attack_client)==TRUE){
			return;
		}
	case SWOAK_SEQ_SOUBI_ITEM_DEFENCE:
		sp->swoak_seq_no++;
		if(sp->defence_client!=NONE_CLIENT_NO){
			if(ST_ServerSoubiItemCheck(bw,sp,sp->defence_client)==TRUE){
				return;
			}
		}
	case SWOAK_SEQ_WAZA_HIT_SOUBI_ITEM:
		{
			int	seq_no;

			sp->swoak_seq_no++;
			if(ST_ServerWazaHitSoubiItemCheck(bw,sp,&seq_no)==TRUE){
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				return;
			}
		}
	case SWOAK_SEQ_MELT_ICE:
		{
			int	wazatype;
			
			//m[}XĹAZ^Cvm[}ɂ
			if(ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_NOOMARUSUKIN){
				wazatype=NORMAL_TYPE;
			}
			else if(sp->waza_type){
				wazatype=sp->waza_type;
			}
			else{
				wazatype=sp->AIWT.wtd[sp->waza_no_now].wazatype;
			}

			sp->swoak_seq_no++;
			if(sp->defence_client!=NONE_CLIENT_NO){
				if((sp->psp[sp->defence_client].condition&CONDITION_KOORI)&&
				  ((sp->waza_status_flag&WAZA_STATUS_FLAG_RENZOKU_NOHIT)==0)&&
				   (sp->defence_client!=sp->attack_client)&&
				  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||(sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
				   (sp->psp[sp->defence_client].hp)&&
				   (wazatype==FIRE_TYPE)){	
					sp->client_work=sp->defence_client;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MELT);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					return;
				}
			}
		}
	case SWOAK_SEQ_SOUBI_ITEM_CONDITION_BAD:
		{
			int client_no;
			int	ret=0;
			int	seq_no;

			while(sp->swoak_work<BattleWorkClientSetMaxGet(bw)){
				client_no=sp->psp_agi_work[sp->swoak_work];
				if(sp->no_reshuffle_client&No2Bit(client_no)){
					sp->swoak_work++;
					continue;
				}
				sp->swoak_work++;
				if(ST_ServerSoubiItemConditionBadCheck(bw,sp,client_no,&seq_no)==TRUE){
					sp->client_work=client_no;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
					break;
				}
			}
			if(ret==0){
				sp->swoak_seq_no++;
				sp->swoak_work=0;
			}
		}
		break;
	default:
		break;
	}
	sp->swoak_seq_no=0;
	sp->swoak_work=0;
//	sp->server_seq_no=SERVER_SINKURO_CHECK_NO;
	sp->server_seq_no=SERVER_RENZOKU_CHECK_NO;
}

//============================================================================================
/**
 *	VN`FbNiꏊړj
 *
 * @param
 */
//============================================================================================
static	void	ServerSinkuroCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
#if 0
	if(ST_ServerSinkuroCheck(bw,sp,SERVER_RENZOKU_CHECK_NO)==TRUE){
		return;
	}
	else{
		sp->server_seq_no=SERVER_RENZOKU_CHECK_NO;
	}
#endif
}

//============================================================================================
/**
 *	AŨ`FbN
 *
 * @param
 */
//============================================================================================
static	void	ServerRenzokuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(sp->renzoku_count_temp){
		//C₵|PꍇAĂ܂ꍇA`FbNŊOꂽꍇ́A`FbNI
		if((sp->kizetsu_client==NONE_CLIENT_NO)&&
		  ((sp->psp[sp->attack_client].condition&CONDITION_NEMURI)==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_RENZOKU_NOHIT)==0)){
			if(--sp->renzoku_count){
				sp->loop_flag=1;
				ST_ServerLoopInit(bw,sp);
				//ZGtFNgēxo悤ɂ
				sp->server_status_flag&=SERVER_STATUS_FLAG_NO_WAZA_EFFECT_OFF;
				//[v鎞Ƀ`FbNWazaOutCheckrbgŎw
				sp->waza_out_check_on_off=sp->loop_hit_check;
				ST_ServerSequenceLoad(sp,ARC_WAZA_SEQ,sp->waza_no_now);
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				sp->next_server_seq_no=SERVER_WAZA_OUT_CHECK_NO;
			}
			else{
				sp->msg_work=sp->renzoku_count_temp;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_LOOP_HIT);
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				sp->next_server_seq_no=SERVER_KIZETSU_EFFECT_NO;
			}
		}
		else{
			if((sp->kizetsu_client!=NONE_CLIENT_NO)||
			   (sp->psp[sp->attack_client].condition&CONDITION_NEMURI)){
				sp->msg_work=sp->renzoku_count_temp-sp->renzoku_count+1;
			}
			else{
				sp->msg_work=sp->renzoku_count_temp-sp->renzoku_count;
			}
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_LOOP_HIT);
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			sp->next_server_seq_no=SERVER_KIZETSU_EFFECT_NO;
		}
		SCIO_BlankMessage(bw);
	}
	else{
		sp->server_seq_no=SERVER_KIZETSU_EFFECT_NO;
	}
}

//============================================================================================
/**
 *	CGtFNg
 *
 * @param
 */
//============================================================================================
static	void	ServerKizetsuEffect(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(sp->server_status_flag&SERVER_STATUS_FLAG_KIZETSU){
		ServerKizetsuCheck(sp,SERVER_KIZETSU_EFFECT_NO,SERVER_KIZETSU_EFFECT_NO,SKC_MICHIDURE_ON);
	}
	else{
		sp->server_seq_no=SERVER_LOOP_CHECK_NO;
	}
}

//============================================================================================
/**
 *	̓Z̃`FbN
 *
 * @param
 */
//============================================================================================
static	void	ServerLoopCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//}WbNR[gɂāAAttackDefenceւĂ猳ɖ߂
	if(sp->server_status_flag2&SERVER_STATUS_FLAG2_MAGIC_CORT_A_D){
		sp->server_status_flag2&=SERVER_STATUS_FLAG2_MAGIC_CORT_A_D_OFF;
		sp->defence_client=sp->attack_client;
		sp->attack_client=sp->magic_cort_client;
	}

#if B1370_060815_FIX
	//IEԂ[Nւ̊i[i̓Zp̊i[Ȃ̂ŁAړ͌ցj
	ServerOumugaeshiCheck(bw,sp);
#endif B1370_060815_FIX

//	if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_attackrange)==RANGE_DOUBLE)&&
	if((sp->AIWT.wtd[sp->waza_no_now].attackrange==RANGE_DOUBLE)&&
		   ((sp->server_status_flag&SERVER_STATUS_FLAG_NO_DOUBLE_CHECK)==0)&&
			(sp->client_loop<BattleWorkClientSetMaxGet(bw))){
		//[v鎞Ƀ`FbNWazaOutCheckrbgŎw
		sp->waza_out_check_on_off=DOUBLE_HIT_OFF;
		{
			int	client_no;
			int	client_set_max=BattleWorkClientSetMaxGet(bw);
			CLIENT_PARAM *cp=BattleWorkClientParamGet(bw,sp->attack_client);
			u8	flag=CT_CPClientTypeGet(cp);

			do{
				client_no=sp->psp_agi_work[sp->client_loop++];
				if(((sp->no_reshuffle_client&No2Bit(client_no))==0)&&(sp->psp[client_no].hp)){
					cp=BattleWorkClientParamGet(bw,client_no);
					if( ((flag&CLIENT_ENEMY_FLAG)&&((CT_CPClientTypeGet(cp)&CLIENT_ENEMY_FLAG)==0))||
						((flag&CLIENT_ENEMY_FLAG)==0)&&(CT_CPClientTypeGet(cp)&CLIENT_ENEMY_FLAG)){
						ST_ServerLoopInit(bw,sp);
						sp->defence_client=client_no;
						sp->server_seq_no=SERVER_WAZA_BEFORE_NO;
						break;
					}
				}
			}while(sp->client_loop<BattleWorkClientSetMaxGet(bw));
		}
		SCIO_BlankMessage(bw);
	}
//	else if((WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_attackrange)==RANGE_TRIPLE)&&
	else if((sp->AIWT.wtd[sp->waza_no_now].attackrange==RANGE_TRIPLE)&&
		   ((sp->server_status_flag&SERVER_STATUS_FLAG_NO_DOUBLE_CHECK)==0)&&
			(sp->client_loop<BattleWorkClientSetMaxGet(bw))){
		//[v鎞Ƀ`FbNWazaOutCheckrbgŎw
		sp->waza_out_check_on_off=DOUBLE_HIT_OFF;
		{
			int	client_no;
			int	client_set_max=BattleWorkClientSetMaxGet(bw);

			do{
				client_no=sp->psp_agi_work[sp->client_loop++];
				if(((sp->no_reshuffle_client&No2Bit(client_no))==0)&&(sp->psp[client_no].hp)){
					if(client_no!=sp->attack_client){
						ST_ServerLoopInit(bw,sp);
						sp->defence_client=client_no;
						sp->server_seq_no=SERVER_WAZA_BEFORE_NO;
						break;
					}
				}
			}while(sp->client_loop<BattleWorkClientSetMaxGet(bw));
		}
		SCIO_BlankMessage(bw);
	}
	else{
		sp->server_seq_no=SERVER_JIBAKU_EFFECT_NO;
	}
}

//============================================================================================
/**
 *	΂ɂCGtFNg
 *
 * @param
 */
//============================================================================================
static	void	ServerJibakuEffect(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(sp->server_status_flag&SERVER_STATUS_FLAG_JIBAKU_MASK){
		sp->kizetsu_client=Bit2No((sp->server_status_flag&SERVER_STATUS_FLAG_JIBAKU_MASK)>>SERVER_STATUS_FLAG_JIBAKU_SHIFT);
		sp->server_status_flag&=SERVER_STATUS_FLAG_JIBAKU_MASK_OFF;
//		sp->server_status_flag2|=No2Bit(sp->kizetsu_client)<<SERVER_STATUS_FLAG2_GET_EXP_SHIFT;
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_JIBAKU_KIZETSU);
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		sp->next_server_seq_no=SERVER_WAZA_HIT_AFTER_CHECK_NO;
	}
	else{
		sp->server_seq_no=SERVER_WAZA_HIT_AFTER_CHECK_NO;
	}
}

//============================================================================================
/**
 *	Zqbg̃`FbN
 *
 * @param
 */
//============================================================================================
static	void	ServerWazaHitAfterCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(ServerWazaHitAfterCheckAct(bw,sp)==TRUE){
		return;
	}
//	sp->server_seq_no=SERVER_GET_EXP_EFFECT_NO;
	sp->server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
}

//============================================================================================
/**
 *	ol擾GtFNg
 *
 * @param
 */
//============================================================================================
static	void	ServerGetExpEffect(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
#if 0
	if(sp->server_status_flag2&SERVER_STATUS_FLAG2_GET_EXP){
		ServerGetExpCheck(sp,SERVER_GET_EXP_EFFECT_NO,SERVER_WAZA_NO_BUFFER_SET_NO);
	}
	else{
		sp->server_seq_no=SERVER_WAZA_NO_BUFFER_SET_NO;
	}
#endif
}

//============================================================================================
/**
 *	Zio[obt@Ɋi[
 *
 * @param
 */
//============================================================================================
static	void	ServerWazaNoBufferSet(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
#if B1370_060815_FIX
	u8	eqp_a;
#else //B1370_060815_FIX
	int	wazatype;
	u8	eqp_a;
	u8	eqp_d;
#endif //B1370_060815_FIX

#if B1370_060815_FIX == 0
	//m[}XĹA^Cvm[}
	if(ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_NOOMARUSUKIN){
		wazatype=NORMAL_TYPE;
	}
	else if(sp->waza_type){
		wazatype=sp->waza_type;
	}
	else{
		wazatype=sp->AIWT.wtd[sp->waza_no_now].wazatype;
	}
#endif //B1370_060815_FIX

	//Attack̑
	eqp_a=ST_ServerSoubiEqpGet(sp,sp->attack_client);
	if((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)||
	   (sp->server_status_flag2&SERVER_STATUS_FLAG2_ATTACK_MSG)){
		//ACeu͂܂v́AZ̔Ń[N֑
		if((eqp_a==SOUBI_ONAZIWAZAONLY)||
		   (eqp_a==SOUBI_ONAZIWAZAONLYSUBAYASAUP)||
		   (eqp_a==SOUBI_ONAZIAWZAONLYTOKUSYUUP)){
			if((sp->waza_no_temp==WAZANO_WARUAGAKI)||
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/19
// uvn̂ǂƁuƂڂv̕s̏C𔽉f
#if AFTER_MASTER_070213_BT_FIX
			  ((sp->waza_no_temp==WAZANO_TONBOGAERI)&&(sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI))||
			  ((sp->waza_no_temp==WAZANO_BATONTATTI)&&(sp->server_status_flag2&SERVER_STATUS_FLAG2_WAZA_OUT))){
#else AFTER_MASTER_070213_BT_FIX
			  ((sp->waza_no_temp==WAZANO_BATONTATTI)&&(sp->server_status_flag2&SERVER_STATUS_FLAG2_WAZA_OUT))){
#endif AFTER_MASTER_070213_BT_FIX
// ----------------------------------------------------------------------------
				;
			}
			else{
				sp->psp[sp->attack_client].wkw.kodawari_wazano=sp->waza_no_temp;
			}
		}
		else{
			sp->psp[sp->attack_client].wkw.kodawari_wazano=0;
		}
	}

	//1^[OɌJoĂZƂĊi[itOĂ鎞͊i[Ȃ
	if((sp->server_status_flag&SERVER_STATUS_FLAG_NO_WAZANO_SET)==0){
		if(sp->server_status_flag2&SERVER_STATUS_FLAG2_ATTACK_MSG){
			sp->waza_no_mamoru[sp->attack_client]=sp->waza_no_now;
			sp->waza_no_last=sp->waza_no_temp;
		}
		else{
			sp->waza_no_mamoru[sp->attack_client]=0;
			sp->waza_no_last=0;
		}
		if(sp->server_status_flag2&SERVER_STATUS_FLAG2_WAZA_OUT){
			sp->waza_no_old[sp->attack_client]=sp->waza_no_temp;
		}
		else{
			sp->waza_no_old[sp->attack_client]=0;
		}
	}

	if(sp->server_status_flag2&SERVER_STATUS_FLAG2_ATTACK_MSG){
		sp->waza_no_sketch[sp->attack_client]=sp->waza_no_temp;
	}

#if B1370_060815_FIX == 0
	if(sp->defence_client!=NONE_CLIENT_NO){
		//Defencȇ
		eqp_d=ST_ServerSoubiEqpGet(sp,sp->defence_client);
		if((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)||
		   (sp->server_status_flag2&SERVER_STATUS_FLAG2_ATTACK_MSG)){
			//ACeu͂܂v́AZ̔Ń[N֑
			if((eqp_d!=SOUBI_ONAZIWAZAONLY)&&
			   (eqp_d!=SOUBI_ONAZIWAZAONLYSUBAYASAUP)&&
			   (eqp_d!=SOUBI_ONAZIAWZAONLYTOKUSYUUP)){
				sp->psp[sp->defence_client].wkw.kodawari_wazano=0;
			}
		}

		//1^[OɌJoĂZƂĊi[itOĂ鎞͊i[Ȃ
		if((sp->server_status_flag&SERVER_STATUS_FLAG_NO_WAZANO_SET)==0){
			if(sp->server_status_flag2&SERVER_STATUS_FLAG2_ATTACK_MSG){
				sp->waza_no_hit[sp->defence_client]=sp->waza_no_now;
				sp->waza_no_hit_client[sp->defence_client]=sp->attack_client;
				sp->waza_no_hit_type[sp->defence_client]=wazatype;
				sp->waza_no_last=sp->waza_no_temp;
			}
			else{
				sp->waza_no_hit[sp->defence_client]=0;
				sp->waza_no_hit_client[sp->defence_client]=NONE_CLIENT_NO;
				sp->waza_no_hit_type[sp->defence_client]=0;
				sp->waza_no_last=0;
			}
			if((sp->server_status_flag2&SERVER_STATUS_FLAG2_WAZA_OUT)&&
			  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)){
				//eNX`[Q[ŃAi[郌W肷
				switch(sp->AIWT.wtd[sp->waza_no_now].attackrange){
				case RANGE_MINE:		//I
				case RANGE_MINE_DOUBLE:	//Q̑I
				case RANGE_FIELD:		//ɂ
				case RANGE_MAKIBISHI:	//܂тp
				case RANGE_TEDASUKE:	//Ăp
				case RANGE_TUBOWOTUKU:	//ڂp
					sp->waza_no_texture2[sp->defence_client]=0;
					sp->waza_no_texture2_client[sp->defence_client]=NONE_CLIENT_NO;
					sp->waza_no_texture2_type[sp->defence_client]=0;
					break;
				default:
					sp->waza_no_texture2[sp->defence_client]=sp->waza_no_now;
					sp->waza_no_texture2_client[sp->defence_client]=sp->attack_client;
					sp->waza_no_texture2_type[sp->defence_client]=wazatype;
					break;
				}
			}
			else{
				sp->waza_no_texture2[sp->defence_client]=0;
				sp->waza_no_texture2_client[sp->defence_client]=NONE_CLIENT_NO;
				sp->waza_no_texture2_type[sp->defence_client]=0;
			}
		}
	}
#endif //B1370_060815_FIX

	//IEԂ[Nւ̊i[iZOꂽꍇp̊i[Ȃ̂ŁAړ͌ցj
	ServerOumugaeshiCheck(bw,sp);

	//gm[`FbN
	ST_ServerMetronomeAfterCheck(bw,sp);

	sp->server_seq_no=SERVER_WAZA_END_NO;
}

//============================================================================================
/**
 *	ZV[PXI
 *
 * @param
 */
//============================================================================================
static	void	ServerWazaEnd(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	seq_no;
	u32	fight_type;

	fight_type=BattleWorkFightTypeGet(bw);

	//Tt@][A|Pp[Nł́Aȉ͕̏KvȂ
	if((fight_type&(FIGHT_TYPE_SAFARI|FIGHT_TYPE_POKE_PARK))==0){
		//ēxJo[n̓̃`FbN
		if(ST_ServerTokuseiStatusRecoverCheck(bw,sp,sp->attack_client,0)==TRUE){
			return;
		}
		//UΏۂȂꍇ̂Ń`FbN
		if((sp->defence_client!=NONE_CLIENT_NO)&&(ST_ServerTokuseiStatusRecoverCheck(bw,sp,sp->defence_client,0)==TRUE)){
			return;
		}

		if(ServerGetExpCheck(sp,sp->server_seq_no,sp->server_seq_no)==TRUE){
			return;
		}

		if(ServerZenmetsuCheck(bw,sp)==TRUE){
			return;
		}

		seq_no=ST_ServerPokeAppearCheck(bw,sp);
		if(seq_no){
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			return;
		}
		if(ServerVanishCheck(bw,sp)==TRUE){
			return;
		}
		ServerFlagOffReqAct(bw,sp);
	}

	sp->client_act_work[sp->client_agi_work[sp->agi_cnt]][ACT_PARA_ACT_NO]=SERVER_WAZA_END_NO;

	//gbN[́Aŏɂ
	if(sp->ostf[sp->attack_client].trickroom_flag){
		ST_ServerTrickRoomAct(bw,sp);
		//Zʔ̂߂̑fvZ
		ST_ServerPSPAgiCalc(bw,sp);
		sp->agi_cnt=0;
	}
	else{
		sp->agi_cnt++;
	}

	ST_ServerWorkInit(sp);

	sp->server_seq_no=SERVER_ACTION_BRANCH_NO;
}

//============================================================================================
/**
 *	|PꂩV[PX
 *
 * @param
 */
//============================================================================================
static	void	ServerPokeReshuffleAfter(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	seq_no;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// ւuvւ̃JE^[_[W2̂Ƃ|ꂽƂ̕sC

#if AFTER_MASTER_070202_BT1_FIX
	//C`FbN
	if(ServerKizetsuCheck(sp,sp->server_seq_no,sp->server_seq_no,SKC_MICHIDURE_OFF)==TRUE){
		return;
	}
#else AFTER_MASTER_070202_BT1_FIX
	//Ԉُ풼n`FbN
	if(ST_ServerSoubiItemConditionBadCheck(bw,sp,sp->attack_client,&seq_no)==TRUE){
		sp->client_work=sp->attack_client;
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		return;
	}
#endif AFTER_MASTER_070202_BT1_FIX

// ----------------------------------------------------------------------------

	sp->server_seq_no=SERVER_WAZA_END_NO;
}

//============================================================================================
/**
 *	퓬sV[PX
 *
 * @param
 */
//============================================================================================
static	void	ServerWinLose(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(BattleWorkWinLoseGet(bw)&FIGHT_ESCAPE_SELECT){
		sp->server_seq_no=SERVER_FIGHT_END_NO;
	}
	else if((BattleWorkWinLoseGet(bw)==FIGHT_LOSE)||(BattleWorkWinLoseGet(bw)==FIGHT_DRAW)){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_FIGHT_LOSE);
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		sp->next_server_seq_no=SERVER_FIGHT_END_NO;
	}
	else if(BattleWorkWinLoseGet(bw)==FIGHT_WIN){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_FIGHT_WIN);
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		sp->next_server_seq_no=SERVER_FIGHT_END_NO;
	}
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/04/21
// |PߊlĐ퓬IہA񂩂ӂȂ̂C
#if AFTER_MASTER_070409_60_EUR_FIX
	else if(BattleWorkWinLoseGet(bw)==FIGHT_POKE_GET){
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		sp->next_server_seq_no=SERVER_FIGHT_END_NO;
	}
	else if(BattleWorkWinLoseGet(bw)==FIGHT_ESCAPE){
		sp->server_seq_no=SERVER_FIGHT_END_NO;
	}
#else //AFTER_MASTER_070409_60_EUR_FIX
	else if((BattleWorkWinLoseGet(bw)==FIGHT_POKE_GET)||(BattleWorkWinLoseGet(bw)==FIGHT_ESCAPE)){
		sp->server_seq_no=SERVER_FIGHT_END_NO;
	}
#endif //AFTER_MASTER_070409_60_EUR_FIX
// ----------------------------------------------------------------------------
	sp->fight_end_flag=1;
}

//============================================================================================
/**
 *	T[oL[`FbNďI҂
 *
 * @param
 */
//============================================================================================
static	void	ServerQueCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	if(ST_ServerQueCheck(sp)){
		if(sp->que_check_wait){
			sp->que_check_wait--;
		}
		else{
			sp->server_seq_no=sp->next_server_seq_no;
		}
	}
}

//============================================================================================
/**
 *	퓬I
 *
 * @param
 */
//============================================================================================
static	void	ServerFightEnd(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	POKEPARTY	*ppt;
	u32	fight_type;

	fight_type=BattleWorkFightTypeGet(bw);

	//|PX`FbN
	if((fight_type&FIGHT_TYPE_SIO)==0){
		ppt=BattleWorkPokePartyGet(bw,CLIENT_NO_MINE);
		PokerusSetCheck(ppt);
		PokerusCatchCheck(ppt);
	}

	if(fight_type&FIGHT_TYPE_SIO){
		CommSendFixData(CB_EXIT_BATTLE);
	}

	sp->server_seq_no=SERVER_FIGHT_END_WAIT_NO;
}

//============================================================================================
/**
 *	퓬IiʐMΐ펞̑҂j
 *
 * @param
 */
//============================================================================================
static	void	ServerFightEndWait(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
}

#if 0
//============================================================================================
/**
 *	ServerQueCheckɈڍs邽߂̃p[^Zbg
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	next_seq	ServerQueCheckɈڍsV[PXio[
 *	@param[in]	wait		ServerQueCheckWAIT
 */
//============================================================================================
static	void	ServerQueCheckSet(SERVER_PARAM *sp,int next_seq,int wait)
{
	sp->server_seq_no=SERVER_QUE_CHECK_NO;
	sp->next_server_seq_no=next_seq;
	sp->que_check_wait=wait;
}
#endif

//============================================================================================
/**
 *	ւ`FbN
 *
 * @param
 */
//============================================================================================
static	const int	PosTable[]={
	0,0,0,0,3,3,
};

//============================================================================================
/**
 *	ւ`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerReshuffleCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	BOOL	ret=FALSE;
	int		client_no;
	int		client_set_max;
	u32		fight_type;
	int		seq_no;

	client_set_max=BattleWorkClientSetMaxGet(bw);
	fight_type=BattleWorkFightTypeGet(bw);
	seq_no=sp->server_seq_no;

	for(client_no=0;client_no<client_set_max;client_no++){
		sp->client_status[client_no]&=CLIENT_STATUS_POKE_RESHUFFLE_OFF;
		if(((fight_type&FIGHT_TYPE_2vs2)&&((fight_type&(FIGHT_TYPE_MULTI|FIGHT_TYPE_TAG))==0))||
		   ((fight_type&FIGHT_TYPE_TAG)&&((BattleWorkMineEnemyCheck(bw,client_no))==0))){
			//_umbN_EȂ1̖ڂ`FbN
			if((sp->psp[client_no].hp==0)&&(sp->psp[client_no^2].hp==0)&&(client_no&2)){
				continue;
			}
			if(sp->psp[client_no].hp==0){
				{
					int	i;
					int	hp;
					int	hp_total=0;
					int	cnt=0;
					POKEPARTY		*poke_party;
					POKEMON_PARAM	*pp;
					CLIENT_PARAM	*cp;

					poke_party=BattleWorkPokePartyGet(bw,client_no);
					cp=BattleWorkClientParamGet(bw,client_no);
	
					for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
						pp=PokeParty_GetMemberPointer(poke_party,i);
						if((PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
						   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)){
							if(hp=PokeParaGet(pp,ID_PARA_hp,NULL)){
								cnt++;
								if(sp->sel_mons_no[client_no^2]!=i){
									hp_total+=hp;
								}
							}
						}
					}
					if(hp_total==0){
						sp->no_reshuffle_client|=No2Bit(client_no);	///<ւ|PȂClientNorbgŊi[
						sp->sel_mons_no[client_no]=POKEMON_TEMOTI_MAX;
					}
					else{
						sp->next_server_seq_no=seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->client_status[client_no]|=CLIENT_STATUS_POKE_RESHUFFLE;
					}
				}
			}
		}
		else{
			if(sp->psp[client_no].hp==0){
				{
					int	i;
					int	hp=0;
					POKEPARTY		*poke_party;
					POKEMON_PARAM	*pp;
					CLIENT_PARAM	*cp;

					poke_party=BattleWorkPokePartyGet(bw,client_no);
					cp=BattleWorkClientParamGet(bw,client_no);
	
					for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
						pp=PokeParty_GetMemberPointer(poke_party,i);
						if((PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
						   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)){
							hp+=PokeParaGet(pp,ID_PARA_hp,NULL);
						}
					}
	
					if(hp==0){
						sp->no_reshuffle_client|=No2Bit(client_no);	///<ւ|PȂClientNorbgŊi[
						sp->sel_mons_no[client_no]=POKEMON_TEMOTI_MAX;
					}
					else{
						sp->next_server_seq_no=seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->client_status[client_no]|=CLIENT_STATUS_POKE_RESHUFFLE;
					}
				}
			}
		}
	}
#if 0
	if((fight_type&FIGHT_TYPE_2vs2)&&((fight_type&FIGHT_TYPE_MULTI)==0)){
		for(client_no=0;client_no<client_set_max;client_no++){
			sp->client_status[client_no]&=CLIENT_STATUS_POKE_RESHUFFLE_OFF;
			//_umbN_EȂ1̖ڂ`FbN
			if((sp->psp[client_no].hp==0)&&(sp->psp[client_no^2].hp==0)&&(client_no&2)){
				continue;
			}
			if(sp->psp[client_no].hp==0){
				{
					int	i;
					int	hp;
					int	hp_total=0;
					int	cnt=0;
					POKEPARTY		*poke_party;
					POKEMON_PARAM	*pp;
					CLIENT_PARAM	*cp;

					poke_party=BattleWorkPokePartyGet(bw,client_no);
					cp=BattleWorkClientParamGet(bw,client_no);
	
					for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
						pp=PokeParty_GetMemberPointer(poke_party,i);
						if((PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
						   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)){
							if(hp=PokeParaGet(pp,ID_PARA_hp,NULL)){
								cnt++;
								if(sp->sel_mons_no[client_no^2]!=i){
									hp_total+=hp;
								}
							}
						}
					}
//Z̏IőSŃ`FbNȂȂ̂ŁAł̃Zbgł͖ӖɂȂiC₵uԂɃZbgɕύXj
#if 0
					//C₵ĂNCAgclient_act_workWAZA_ENDZbg
					//ZV[PX삵Ȃ悤ɂ
					sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_WAZA_END_NO;
#endif
					if(hp_total==0){
						sp->no_reshuffle_client|=No2Bit(client_no);	///<ւ|PȂClientNorbgŊi[
					}
					else{
						sp->next_server_seq_no=seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->client_status[client_no]|=CLIENT_STATUS_POKE_RESHUFFLE;
					}
				}
			}
		}
	}
	else{
		for(client_no=0;client_no<client_set_max;client_no++){
			sp->client_status[client_no]&=CLIENT_STATUS_POKE_RESHUFFLE_OFF;
			if(sp->psp[client_no].hp==0){
				{
					int	i;
					int	hp=0;
					POKEPARTY		*poke_party;
					POKEMON_PARAM	*pp;
					CLIENT_PARAM	*cp;

					poke_party=BattleWorkPokePartyGet(bw,client_no);
					cp=BattleWorkClientParamGet(bw,client_no);
	
					for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
						pp=PokeParty_GetMemberPointer(poke_party,i);
						if((PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
						   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)){
							hp+=PokeParaGet(pp,ID_PARA_hp,NULL);
						}
					}
	
//Z̏IőSŃ`FbNȂȂ̂ŁAł̃Zbgł͖ӖɂȂiC₵uԂɃZbgɕύXj
					//C₵ĂNCAgclient_act_workWAZA_ENDZbg
					//ZV[PX삵Ȃ悤ɂ
//					sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_WAZA_END_NO;
	
					if(hp==0){
						sp->no_reshuffle_client|=No2Bit(client_no);	///<ւ|PȂClientNorbgŊi[
					}
					else{
						sp->next_server_seq_no=seq_no;
						sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
						sp->client_status[client_no]|=CLIENT_STATUS_POKE_RESHUFFLE;
					}
				}
			}
		}
	}
#endif
	if(sp->server_seq_no==SERVER_WAZA_SEQUENCE_NO){
		//ΐ탋[ɂēւς
		if(((fight_type&FIGHT_TYPE_NO_IREKAE)==0)&&
			(BattleWorkConfigBattleRuleGet(bw)==BATTLERULE_IREKAE)&&
		  (((sp->client_status[CLIENT_NO_MINE]&CLIENT_STATUS_POKE_RESHUFFLE)==0)||
		   ((sp->client_status[CLIENT_NO_ENEMY]&CLIENT_STATUS_POKE_RESHUFFLE)==0))&&
			(ST_ServerReshuffleCheck(bw,sp,CLIENT_NO_MINE))){
			if(sp->client_status[CLIENT_NO_MINE]&CLIENT_STATUS_POKE_RESHUFFLE){
				sp->temp_work=0;
			}
			else{
				sp->temp_work=1;
			}
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_POKEMON_IREKAE);
		}
		else{
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_POKEMON_LIST);
		}
		ret=TRUE;
	}
	return ret;
}

//============================================================================================
/**
 *	SŃ`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerZenmetsuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int		client_no;
	int		client_set_max;
	u32		fight_type;
	u8		win_lose_flag;

	client_set_max=BattleWorkClientSetMaxGet(bw);
	fight_type=BattleWorkFightTypeGet(bw);
	win_lose_flag=0;

	for(client_no=0;client_no<client_set_max;client_no++){
		//AI}`ł́Aŏs߂
		if(((fight_type==FIGHT_TYPE_AI_MULTI)||
//		    (fight_type==FIGHT_TYPE_BATTLE_TOWER_AI_MULTI)||
		    (fight_type==FIGHT_TYPE_2vs2_YASEI))&&
			(BattleWorkMineEnemyCheck(bw,client_no)==0)){
			if(BattleWorkClientTypeGet(bw,client_no)==CLIENT_TYPE_A){	
				if(sp->psp[client_no].hp==0){
					{
						int	i;
						int	hp=0;
						POKEPARTY		*poke_party;
						POKEMON_PARAM	*pp;
						CLIENT_PARAM	*cp;
		
						poke_party=BattleWorkPokePartyGet(bw,client_no);
						cp=BattleWorkClientParamGet(bw,client_no);
		
						for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
							pp=PokeParty_GetMemberPointer(poke_party,i);
							if((PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
							   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)){
								hp+=PokeParaGet(pp,ID_PARA_hp,NULL);
							}
						}
						if(hp==0){
							win_lose_flag|=FIGHT_LOSE;
						}
					}
				}
			}
		}
		else if((fight_type&FIGHT_TYPE_MULTI)||((fight_type&FIGHT_TYPE_TAG)&&(BattleWorkMineEnemyCheck(bw,client_no)))){
			if(sp->psp[client_no].hp==0){
				{
					int	i;
					int	hp=0;
					POKEPARTY		*poke_party1;
					POKEPARTY		*poke_party2;
					POKEMON_PARAM	*pp;
					CLIENT_PARAM	*cp;
	
					poke_party1=BattleWorkPokePartyGet(bw,client_no);
					poke_party2=BattleWorkPokePartyGet(bw,BattleWorkPartnerClientNoGet(bw,client_no));
					cp=BattleWorkClientParamGet(bw,client_no);
	
					for(i=0;i<PokeParty_GetPokeCount(poke_party1);i++){
						pp=PokeParty_GetMemberPointer(poke_party1,i);
						if((PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
						   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)){
							hp+=PokeParaGet(pp,ID_PARA_hp,NULL);
						}
					}
					for(i=0;i<PokeParty_GetPokeCount(poke_party2);i++){
						pp=PokeParty_GetMemberPointer(poke_party2,i);
						if((PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
						   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)){
							hp+=PokeParaGet(pp,ID_PARA_hp,NULL);
						}
					}
	
					if(hp==0){
						if(CT_CPClientTypeGet(cp)&CLIENT_ENEMY_FLAG){
							win_lose_flag|=FIGHT_WIN;
						}
						else{
							win_lose_flag|=FIGHT_LOSE;
						}
					}
				}
			}
		}
		else{
			if(sp->psp[client_no].hp==0){
				{
					int	i;
					int	hp=0;
					POKEPARTY		*poke_party;
					POKEMON_PARAM	*pp;
					CLIENT_PARAM	*cp;
	
					poke_party=BattleWorkPokePartyGet(bw,client_no);
					cp=BattleWorkClientParamGet(bw,client_no);
	
					for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
						pp=PokeParty_GetMemberPointer(poke_party,i);
						if((PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=0)&&
						   (PokeParaGet(pp,ID_PARA_monsno_egg,NULL)!=MONSNO_TAMAGO)){
							hp+=PokeParaGet(pp,ID_PARA_hp,NULL);
						}
					}
	
					if(hp==0){
						if(CT_CPClientTypeGet(cp)&CLIENT_ENEMY_FLAG){
							win_lose_flag|=FIGHT_WIN;
						}
						else{
							win_lose_flag|=FIGHT_LOSE;
						}
					}
				}
			}
		}
	}
	if(((win_lose_flag==FIGHT_WIN)&&(fight_type&FIGHT_TYPE_TRAINER)&&((fight_type&FIGHT_TYPE_SIO)==0))||
	   ((win_lose_flag==FIGHT_WIN)&&(fight_type&FIGHT_TYPE_TOWER)&&((fight_type&FIGHT_TYPE_SIO)==0))){
		{
			TRAINER_DATA	*td;

			td=BattleWorkTrainerDataGet(bw,CLIENT_NO_ENEMY);

			switch(td->tr_type){
			case TRTYPE_LEADER1:
			case TRTYPE_LEADER2:
			case TRTYPE_LEADER3:
			case TRTYPE_LEADER4:
			case TRTYPE_LEADER5:
			case TRTYPE_LEADER6:
			case TRTYPE_LEADER7:
			case TRTYPE_LEADER8:
			case TRTYPE_KUROTUGU:
				Snd_BgmPlay(SEQ_WINTGYM);
				break;
			case TRTYPE_CHAMPION:
				Snd_BgmPlay(SEQ_WINCHAMP);
				break;
			case TRTYPE_GINGALEADER1:
			case TRTYPE_GINGALEADER2:
			case TRTYPE_GINGALEADER3:
			case TRTYPE_GINGAM:
			case TRTYPE_GINGAW:
				Snd_BgmPlay(SEQ_WINGINGA);
				break;
			case TRTYPE_GINGALBOSS:
				Snd_BgmPlay(SEQ_WINAKAGI);
				break;
			case TRTYPE_BIGFOUR1:
			case TRTYPE_BIGFOUR2:
			case TRTYPE_BIGFOUR3:
			case TRTYPE_BIGFOUR4:
				Snd_BgmPlay(SEQ_WINTENNO);
				break;
			default:
				Snd_BgmPlay(SEQ_WINTRAIN);
				break;
			}
		}
		BattleWorkPinchSEFlagSet(bw,2);
	}

	if(win_lose_flag){
		BattleWorkWinLoseSet(bw,win_lose_flag);
	}

	return (win_lose_flag!=0);
}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/24
// Ă1̂̃_uogŁAuĂv̑ΏۂIׂ͂܂sC

#if AFTER_MASTER_070117_FIX
//============================================================================================
/**
 *	UΏۑI`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerDirSelectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,u8 client_no,u32 fight_type,int *range,int waza_pos,u32 *dir)
{
//	*range=WT_WazaDataParaGet(sp->psp[client_no].waza[waza_pos],ID_WTD_attackrange);
	//̂낢̎́AJoClient݂āArangeω
	if((sp->psp[client_no].waza[waza_pos]==WAZANO_NOROI)&&
	   (ST_ServerWazaNoroiCheck(sp,sp->psp[client_no].waza[waza_pos],client_no)==FALSE)){
		*range=RANGE_MINE;
	}
	else{
		*range=sp->AIWT.wtd[sp->psp[client_no].waza[waza_pos]].attackrange;
	}

	if(fight_type&FIGHT_TYPE_2vs2){
		if(*range==RANGE_TEDASUKE){
			if((sp->no_reshuffle_client&No2Bit(BattleWorkPartnerClientNoGet(bw,client_no)))==0){
				return TRUE;
			}
			else{
				return FALSE;
			}
		}
		else{
			return TRUE;
		}
	}
	else{
		if(*range&RANGE_MINE_DIR){
			*dir=client_no;
		}
		else{
			*dir=client_no^1;
		}
		return FALSE;
	}
}
#else //AFTER_MASTER_070117_FIX
//============================================================================================
/**
 *	UΏۑI`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerDirSelectCheck(SERVER_PARAM *sp,u8 client_no,u32 fight_type,int *range,int waza_pos,u32 *dir)
{
//	*range=WT_WazaDataParaGet(sp->psp[client_no].waza[waza_pos],ID_WTD_attackrange);
	//̂낢̎́AJoClient݂āArangeω
	if((sp->psp[client_no].waza[waza_pos]==WAZANO_NOROI)&&
	   (ST_ServerWazaNoroiCheck(sp,sp->psp[client_no].waza[waza_pos],client_no)==FALSE)){
		*range=RANGE_MINE;
	}
	else{
		*range=sp->AIWT.wtd[sp->psp[client_no].waza[waza_pos]].attackrange;
	}

	if(fight_type&FIGHT_TYPE_2vs2){
		return TRUE;
	}
	else{
		if(*range&RANGE_MINE_DIR){
			*dir=client_no;
		}
		else{
			*dir=client_no^1;
		}
		return FALSE;
	}
}
#endif //AFTER_MASTER_070117_FIX

// ----------------------------------------------------------------------------

//============================================================================================
/**
 *	ZV[PXō폜v̂tOׂč폜
 *
 * @param
 */
//============================================================================================
static	void	ServerFlagOffReqAct(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	client_set_max;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(client_no=0;client_no<client_set_max;client_no++){
		//condition2tO
		sp->psp[client_no].condition2&=(sp->condition2_off_req[client_no]^0xffffffff);
		sp->condition2_off_req[client_no]=0;
		//wazakoukatO(\\Ɂj
//		if((sp->psp[client_no].waza_kouka&WAZAKOUKA_KIE)==0){
//			SCIO_PokemonVanishOnOff(bw,client_no,SW_VANISH_OFF);
//		}
	}

	sp->waza_no_hit[sp->attack_client]=0;
	sp->waza_no_texture2[sp->attack_client]=0;
}

//============================================================================================
/**
 *	C`FbN
 *
 * @param[in]	sp			T[op[^\
 * @param[in]	next_seq	ɈړV[PXio[
 * @param[in]	no_set_seq	C₵ĂȂƂɃZbgV[PXio[
 * @param[in]	flag		݂Â`FbN̗L
 *
 * @retval	FALSE:CȂ@TRUE:C₠
 */
//============================================================================================
static	BOOL	ServerKizetsuCheck(SERVER_PARAM *sp,int next_seq,int no_set_seq,int flag)
{
	int	no;
	int	client_bit;

	no=0;
	client_bit=No2Bit(sp->psp_agi_work[no])<<SERVER_STATUS_FLAG_KIZETSU_SHIFT;

	if(sp->server_status_flag&SERVER_STATUS_FLAG_KIZETSU){
		while((sp->server_status_flag&client_bit)==0){
			no++;
			client_bit=No2Bit(sp->psp_agi_work[no])<<SERVER_STATUS_FLAG_KIZETSU_SHIFT;
		}
		sp->server_status_flag&=(client_bit^0xffffffff);
		sp->kizetsu_client=Bit2No(client_bit>>SERVER_STATUS_FLAG_KIZETSU_SHIFT);
//		sp->server_status_flag2|=No2Bit(sp->kizetsu_client)<<SERVER_STATUS_FLAG2_GET_EXP_SHIFT;
		if(flag==SKC_MICHIDURE_OFF){
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_KIZETSU);
		}
		else{
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_MICHIDURE_KIZETSU);
		}
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		sp->next_server_seq_no=next_seq;
		//C₵ĂNCAgclient_act_workWAZA_ENDZbg
		//ZV[PX삵Ȃ悤ɂ
		sp->client_act_work[sp->kizetsu_client][ACT_PARA_ACT_NO]=SERVER_WAZA_END_NO;
		return TRUE;
	}
	else{
		sp->server_seq_no=no_set_seq;
		return FALSE;
	}
}

//============================================================================================
/**
 *	ol擾`FbN
 *
 * @param[in]	sp			T[op[^\
 * @param[in]	next_seq	ɈړV[PXio[
 * @param[in]	no_set_seq	擾ȂƂɃZbgV[PXio[
 *
 * @retval	FALSE:擾Ȃ@TRUE:擾
 */
//============================================================================================
static	BOOL	ServerGetExpCheck(SERVER_PARAM *sp,int next_seq,int no_set_seq)
{
	if(sp->server_status_flag2&SERVER_STATUS_FLAG2_GET_EXP){
		{
			int	client_bit;

			client_bit=1<<SERVER_STATUS_FLAG2_GET_EXP_SHIFT;

			while((sp->server_status_flag2&client_bit)==0){
				client_bit=client_bit<<1;
			}
			sp->server_status_flag2&=(client_bit^0xffffffff);
			sp->kizetsu_client=Bit2No(client_bit>>SERVER_STATUS_FLAG2_GET_EXP_SHIFT);
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_GET_EXP);
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			sp->next_server_seq_no=next_seq;
		}
		return TRUE;
	}
	else{
		sp->server_seq_no=no_set_seq;
		return FALSE;
	}
}

#if B1370_060815_FIX
//============================================================================================
/**
 *	IEp[Nւ̑`FbN
 *
 * @param[in]	bw			퓬VXep[^\
 * @param[in]	sp			T[op[^\
 */
//============================================================================================
static	void	ServerOumugaeshiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	flag;
	int	wazatype;
	u8	eqp_d;

	//m[}XĹA^Cvm[}
	if(ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_NOOMARUSUKIN){
		wazatype=NORMAL_TYPE;
	}
	else if(sp->waza_type){
		wazatype=sp->waza_type;
	}
	else{
		wazatype=sp->AIWT.wtd[sp->waza_no_now].wazatype;
	}

//	flag=WT_WazaDataParaGet(sp->waza_no_temp,ID_WTD_flag);
	flag=sp->AIWT.wtd[sp->waza_no_temp].flag;

	//IEtOĂ邩
	if((flag&FLAG_OUMUGAESI)&&
	//ZbgȂtO͗ĂȂH
	  ((sp->server_status_flag&SERVER_STATUS_FLAG_NO_WAZANO_SET)==0)&&
	//UΏۂ͐킩H
	  (sp->defence_client!=NONE_CLIENT_NO)&&
	//AttackMessage
	  (sp->server_status_flag2&SERVER_STATUS_FLAG2_ATTACK_MSG)){
		sp->waza_no_oumu[sp->defence_client]=sp->waza_no_temp;	//OɏoĂobt@ɑ
		sp->waza_no_oumu_hit[sp->defence_client][sp->attack_client]=
			sp->waza_no_temp;	//2vs2̂ƂɎ󂯂̃obt@ɑ
	}

	if(sp->defence_client!=NONE_CLIENT_NO){
		//Defencȇ
		eqp_d=ST_ServerSoubiEqpGet(sp,sp->defence_client);
		if((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)||
		   (sp->server_status_flag2&SERVER_STATUS_FLAG2_ATTACK_MSG)){
			//ACeu͂܂v́AZ̔Ń[N֑
			if((eqp_d!=SOUBI_ONAZIWAZAONLY)&&
			   (eqp_d!=SOUBI_ONAZIWAZAONLYSUBAYASAUP)&&
			   (eqp_d!=SOUBI_ONAZIAWZAONLYTOKUSYUUP)){
				sp->psp[sp->defence_client].wkw.kodawari_wazano=0;
			}
		}

		//1^[OɌJoĂZƂĊi[itOĂ鎞͊i[Ȃ
		if((sp->server_status_flag&SERVER_STATUS_FLAG_NO_WAZANO_SET)==0){
			if(sp->server_status_flag2&SERVER_STATUS_FLAG2_ATTACK_MSG){
				sp->waza_no_hit[sp->defence_client]=sp->waza_no_now;
				sp->waza_no_hit_client[sp->defence_client]=sp->attack_client;
				sp->waza_no_hit_type[sp->defence_client]=wazatype;
				sp->waza_no_last=sp->waza_no_temp;
			}
			else{
				sp->waza_no_hit[sp->defence_client]=0;
				sp->waza_no_hit_client[sp->defence_client]=NONE_CLIENT_NO;
				sp->waza_no_hit_type[sp->defence_client]=0;
				sp->waza_no_last=0;
			}
			if((sp->server_status_flag2&SERVER_STATUS_FLAG2_WAZA_OUT)&&
			  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)){
				//eNX`[Q[ŃAi[郌W肷
				switch(sp->AIWT.wtd[sp->waza_no_now].attackrange){
				case RANGE_MINE:		//I
				case RANGE_MINE_DOUBLE:	//Q̑I
				case RANGE_FIELD:		//ɂ
				case RANGE_MAKIBISHI:	//܂тp
				case RANGE_TEDASUKE:	//Ăp
				case RANGE_TUBOWOTUKU:	//ڂp
					sp->waza_no_texture2[sp->defence_client]=0;
					sp->waza_no_texture2_client[sp->defence_client]=NONE_CLIENT_NO;
					sp->waza_no_texture2_type[sp->defence_client]=0;
					break;
				default:
					sp->waza_no_texture2[sp->defence_client]=sp->waza_no_now;
					sp->waza_no_texture2_client[sp->defence_client]=sp->attack_client;
					sp->waza_no_texture2_type[sp->defence_client]=wazatype;
					break;
				}
			}
			else{
				sp->waza_no_texture2[sp->defence_client]=0;
				sp->waza_no_texture2_client[sp->defence_client]=NONE_CLIENT_NO;
				sp->waza_no_texture2_type[sp->defence_client]=0;
			}
		}
	}
}
#else //B1370_060815_FIX
//============================================================================================
/**
 *	IEp[Nւ̑`FbN
 *
 * @param[in]	bw			퓬VXep[^\
 * @param[in]	sp			T[op[^\
 */
//============================================================================================
static	void	ServerOumugaeshiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	flag;

//	flag=WT_WazaDataParaGet(sp->waza_no_temp,ID_WTD_flag);
	flag=sp->AIWT.wtd[sp->waza_no_temp].flag;

	//IEtOĂ邩
	if((flag&FLAG_OUMUGAESI)&&
	//ZbgȂtO͗ĂȂH
	  ((sp->server_status_flag&SERVER_STATUS_FLAG_NO_WAZANO_SET)==0)&&
	//UΏۂ͐킩H
	  (sp->defence_client!=NONE_CLIENT_NO)&&
	//AttackMessage
	  (sp->server_status_flag2&SERVER_STATUS_FLAG2_ATTACK_MSG)){
		sp->waza_no_oumu[sp->defence_client]=sp->waza_no_temp;	//OɏoĂobt@ɑ
		sp->waza_no_oumu_hit[sp->defence_client][sp->attack_client]=
			sp->waza_no_temp;	//2vs2̂ƂɎ󂯂̃obt@ɑ
	}
}
#endif //B1370_060815_FIX

//============================================================================================
/**
 *	}ɂbZ[W\
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerCriticalMessage(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_CRITICAL_HIT);
	sp->next_server_seq_no=sp->server_seq_no;
	sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;

	return TRUE;
}

//============================================================================================
/**
 *	΂₢܂ЂƂȂǃbZ[W\
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerWazaStatusMessage(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	BOOL	ret;

	ret=FALSE;

	if(sp->waza_status_flag){
		//AȔꍇ́AŌɃbZ[Wo
		if(sp->renzoku_count_temp){
			if((sp->kizetsu_client!=NONE_CLIENT_NO)||
			   (sp->renzoku_count==1)||
			   (sp->waza_status_flag&WAZA_STATUS_FLAG_RENZOKU_NOHIT)){
				ret=TRUE;
			}
		}
		else{
			ret=TRUE;
		}
	}
	if(ret==TRUE){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_WAZA_STATUS_MSG);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	}
	return ret;
}

//============================================================================================
/**
 *	肪qbg̃`FbNV[PXio[
 */
//============================================================================================
enum{
	SIC_IKARI_ATTACK_CHECK=0,
	SIC_IKARI_DEFENCE_CHECK,
	SIC_END
};

//============================================================================================
/**
 *	Zqbĝ`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerIkariCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	BOOL	ret;
	
	ret=FALSE;

	//UΏۂȂ΁A`FbNȂ
	if(sp->defence_client==NONE_CLIENT_NO){
		return ret;
	}

	if((sp->psp[sp->defence_client].condition2&CONDITION2_IKARI)&&
	  ((sp->waza_status_flag&WAZA_STATUS_FLAG_RENZOKU_NOHIT)==0)&&
	   (sp->defence_client!=sp->attack_client)&&
	   (sp->psp[sp->defence_client].hp)&&
	  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||(sp->ostf[sp->defence_client].tokusyu_ostf_damage))){
		if(sp->psp[sp->defence_client].abiritycnt[COND_POW]<12){
			sp->psp[sp->defence_client].abiritycnt[COND_POW]++;
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_IKARI_VOLTAGE_UP);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			ret=TRUE;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	Zqbĝ̂邵`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerHirumaseruCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	BOOL	ret=FALSE;
	int		eqp;
	int		atk;

	eqp=ST_ServerSoubiEqpGet(sp,sp->attack_client);
	atk=ST_ServerSoubiAtkGet(sp,sp->attack_client,ATK_CHECK_NORMAL);

	if(sp->defence_client!=NONE_CLIENT_NO){
#ifdef PM_DEBUG
		if((eqp==SOUBI_HIRUMASERU)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
		 (((gf_rand()%100)<atk)||(sp->dbp.debug_flag&DEBUG_FLAG_SOUBI))&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_OUZYANOSIRUSI)&&
		   (sp->psp[sp->defence_client].hp)){
#else
		if((eqp==SOUBI_HIRUMASERU)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
		  ((gf_rand()%100)<atk)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_OUZYANOSIRUSI)&&
		   (sp->psp[sp->defence_client].hp)){
#endif
			sp->tsuika_client=sp->defence_client;
			sp->tsuika_type=ADD_STATUS_INDIRECT;
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HIRUMU);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			ret=TRUE;
		}
	}
	return ret;
}

//============================================================================================
/**
 *	Ă|Pǂ邩`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerVanishCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	BOOL	ret=FALSE;

	while(sp->svc_work<BattleWorkClientSetMaxGet(bw)){
		if(((sp->psp[sp->svc_work].waza_kouka&WAZAKOUKA_KIE)==0)&&
			(sp->psp[sp->svc_work].waza_kouka_temp&WAZAKOUKA_KIE)){
		    sp->psp[sp->svc_work].waza_kouka_temp&=WAZAKOUKA_KIE_OFF;
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_VANISH_OFF);
			sp->client_work=sp->svc_work;
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
			ret=TRUE;
		}
		sp->svc_work++;
		if(ret==TRUE){
			break;
		}
	}
	if(ret==FALSE){
		sp->svc_work=0;
	}
	return ret;
}

//============================================================================================
/**
 *	Zqbg̃`FbNV[PXio[
 */
//============================================================================================
enum{
	SWHAC_IKARI_ATTACK_CHECK=0,
	SWHAC_SOUBI_HPKAIHUKUDAMEEZIRITU,
	SWHAC_SOUBI_WAZAIRYOKUUPHPMAINASU,
	SWHAC_END
};

//============================================================================================
/**
 *	Zqbg̃`FbN
 *
 * @param
 */
//============================================================================================
static	BOOL	ServerWazaHitAfterCheckAct(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	ret;
	int	client_no;
	int	client_set_max;
	int	eqp;
	int	atk;
	
	ret=0;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	eqp=ST_ServerSoubiEqpGet(sp,sp->attack_client);
	atk=ST_ServerSoubiAtkGet(sp,sp->attack_client,ATK_CHECK_NORMAL);

	//C`FbN
	if(ServerKizetsuCheck(sp,sp->server_seq_no,sp->server_seq_no,SKC_MICHIDURE_OFF)==TRUE){
		return TRUE;
	}
	//ol擾`FbN
//	if(ServerGetExpCheck(sp,sp->server_seq_no,sp->server_seq_no)==TRUE){
//		return TRUE;
//	}
	//SŃ`FbN
//	if(ServerZenmetsuCheck(bw,sp)==TRUE){
//		return TRUE;
//	}

	do{
		switch(sp->swhac_seq_no){
		case SWHAC_IKARI_ATTACK_CHECK:
			//ԂŁAoĂȂ́Aԉ
			if((sp->psp[sp->attack_client].condition2&CONDITION2_IKARI)&&(sp->waza_no_now!=WAZANO_IKARI)){
				sp->psp[sp->attack_client].condition2&=CONDITION2_IKARI_OFF;
			}
			sp->swhac_seq_no++;
			break;
		case SWHAC_SOUBI_HPKAIHUKUDAMEEZIRITU:
			if(sp->defence_client!=NONE_CLIENT_NO){
				if((eqp==SOUBI_HPKAIHUKUDAMEEZIRITU)&&
				   //Ƃڂւł́AȂ
				  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
				   (sp->server_status_flag&SERVER_STATUS_FLAG_WAZA_HIT)&&
			       (sp->ostf[sp->attack_client].kaigara_damage)&&
				   (sp->attack_client!=sp->defence_client)&&
				   (sp->psp[sp->attack_client].hp<sp->psp[sp->attack_client].hpmax)&&
				   (sp->psp[sp->attack_client].hp)){
					sp->hp_calc_work=ST_ServerDamageDiv(sp->ostf[sp->attack_client].kaigara_damage*-1,atk);
					sp->client_work=sp->attack_client;
					ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_EQPITEM_HP_KAIHUKUMAITURN);
					sp->next_server_seq_no=sp->server_seq_no;
					sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
					ret=1;
				}
			}
			sp->swhac_seq_no++;
			break;
		case SWHAC_SOUBI_WAZAIRYOKUUPHPMAINASU:
			if((eqp==SOUBI_WAZAIRYOKUUPHPMAINASU)&&
				//}WbNK[h̓_[WȂ
			   (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_MAZIKKUGAADO)&&
			   //Ƃڂւł́AȂ
			  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
			   (sp->server_status_flag&SERVER_STATUS_FLAG_WAZA_HIT)&&
//				(WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_kind)!=KIND_HENKA)&&
				(sp->AIWT.wtd[sp->waza_no_now].kind!=KIND_HENKA)&&
				(sp->psp[sp->attack_client].hp)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*-1,10);
				sp->client_work=sp->attack_client;
				ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_EQPITEM_HP_MAINASU);
				sp->next_server_seq_no=sp->server_seq_no;
				sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
				ret=1;
			}
			sp->swhac_seq_no++;
			break;
		case SWHAC_END:
			sp->swhac_seq_no=0;
			sp->swhac_work=0;
			ret=2;
			break;
		}
	}while(ret==0);

	return (ret==1);
}


