
//============================================================================================
/**
 * @file	server_tool.c
 * @bfief	퓬T[opc[vO
 * @author	HisashiSogabe
 * @date	05.05.26
 */
//============================================================================================

#include "common.h"

#include "battle/battle_server.h"
#include "battle/fight_tool.h"
#include "battle/server.h"
#include "battle/server_tool.h"
#include "battle/client_tool.h"
#include "battle/tokusyu_def.h"
#include "battle/wazano_def.h"
#include "battle/attr_def.h"

#include "field/weather_no.h"

#include "msgdata/msg_fightmsg_dp.h"

#include "poketool/poke_tool.h"
#include "poketool/tr_tool.h"
#include "poketool/waza_tool.h"
#include "poketool/monsno.h"

#include "application/app_tool.h"
#include "application/zukanlist/zkn_fight_text.h"
#include "application/zukanlist/zkn_height_gram.h"

#include "communication/communication.h"

#include "itemtool/item.h"

#include "system/arc_tool.h"
#include "system/snd_tool.h"
#include "system/pm_rtc.h"

#include "gflib/strbuf_family.h"

#include "server_def.h"
#include "tr_ai_def.h"

#include "bugfix.h"	//add by 2006.08.15

//============================================================================================
//	vg^Cv錾
//============================================================================================

void	ST_PokemonParamGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int sel_mons_no);
void	ST_PokemonParamReload(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int sel_mons_no);
void	ST_ServerSequenceLoad(SERVER_PARAM *sp,int kind,int index);
void	ST_ServerSequenceLoadGosub(SERVER_PARAM *sp,int	kind,int index);
BOOL	ST_ServerSequencePushCheck(SERVER_PARAM *sp);
void	ST_ServerQueSet(SERVER_PARAM *sp,int id,int client_no,int index);
void	ST_ServerQueReset(SERVER_PARAM *sp,int id,int client_no,int index);
BOOL	ST_ServerQueCheck(SERVER_PARAM *sp);
void	ST_ServerQueTimeOutCheck(SERVER_PARAM *sp);
void	ST_ServerBufferClear(SERVER_PARAM *sp,int client_no);
int		ST_ServerPokemonServerParamGet(SERVER_PARAM *sp,int client,int id,void *data);
void	ST_ServerPokemonServerParamPut(SERVER_PARAM *sp,int client,int id,const void *buf);
void	ST_ServerPokemonServerParamAdd(SERVER_PARAM *sp,int client,int id,int value);
void	ST_PokemonServerParamAdd(POKEMON_SERVER_PARAM *psp,int id,int value);
u8		ST_ServerAgiCalc(BATTLE_WORK *bw,SERVER_PARAM *sp,int cl1,int cl2,int flag);
void	ST_ServerGetExpRightFlagClear(SERVER_PARAM *sp,int client_no);
void	ST_ServerGetExpRightFlagSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
void	ST_ServerGetExpRightFlagReset(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerAddStatusDirectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no);
BOOL	ST_ServerAddStatusCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no);
int		ST_ServerDefenceClientSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,u16 waza_no,int flag,int set_range);
void	ST_ServerDefenceClientTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,u16 waza_no);
BOOL	ST_ServerDefenceClientTokuseiAct(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	ST_PSPtoPPCopy(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
void	ST_ServerKeepOn(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
void	ST_ServerKeepOff(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
int		ST_ServerConditionNoGet(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerTrainerMessageCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	ST_ServerWorkInit(SERVER_PARAM *sp);
void	ST_ServerCounterWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	ST_ServerReshuffleWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
void	ST_ServerKizetsuWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
void	ST_ServerOneTurnFlagInit(BATTLE_WORK *bw,SERVER_PARAM *sp);
int		ST_ServerWaruagakiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_bit,int check_bit);
BOOL	ST_ServerWazaNGCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int pos,MESSAGE_PARAM *mp);
int		ST_ServerWazaPosGet(POKEMON_SERVER_PARAM *psp,u16 waza_no);
int		ST_ServerTypeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int waza_no,int waza_type,int attack_client,int defence_client,int damage,u32 *flag);
void	ST_AITypeCheck(SERVER_PARAM *sp,int waza_no,int waza_type,int spe_a,int spe_d,int eqp,int type1,int type2,u32 *flag);
BOOL	ST_ServerWazaOutCheck(SERVER_PARAM *sp,int client_no);
u8		ST_ServerHitCountCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int flag,int client_no);
int		ST_ServerTagNickParaMake(SERVER_PARAM *sp,int client_no);
u16		ST_ServerSelectWazaGet(SERVER_PARAM *sp,int client_no);
int		ST_ServerTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int flag,int client_no,int speabi);
BOOL	ST_TameWazaCheck(SERVER_PARAM *sp,int waza_no);
BOOL	ST_ServerTypeCheckTableParaGet(int pos,u8 *type_w,u8 *type_p,u8 *value);
int		ST_ServerTypeCheckTablePowerGet(u8 type_w,u8 type_p1,u8 type_p2);
BOOL	ST_RendouWazaCheck(u16 waza_no);
BOOL	ST_ServerWazaNoroiCheck(SERVER_PARAM *sp,u16 waza_no,int client_no);
BOOL	ST_ServerDorobouItemCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerTrickItemCheck(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerHukitobasiCheck(SERVER_PARAM *sp);
u8		ST_ServerTokuseiGet(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerKatayaburiTokuseiCheck(SERVER_PARAM *sp,int attack,int defence,int tokusei);
BOOL	ST_ServerReshuffleCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_EscapeNGCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,MESSAGE_PARAM *mp);
BOOL	ST_EscapeActCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerNamakeCheck(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerSawaguCheck(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerHuuinCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no);
BOOL	ST_ServerWazaKoukaCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int waza_kouka);
void	ST_ServerLoopInit(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	ST_ServerPSPAgiCalc(BATTLE_WORK *bw,SERVER_PARAM *sp);
BOOL	ST_ServerJuuryokuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no);
BOOL	ST_ServerHealblockCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no);
void	ST_ServerTotteokiCountCalc(BATTLE_WORK *bw,SERVER_PARAM *sp);
int		ST_ServerWazaCountGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
int		ST_ServerDamageTokuseiCheck(SERVER_PARAM *sp,int attack,int defence);
BOOL	ST_ServerPCCTokuseiCheck(SERVER_PARAM *sp,int client_no);
int		ST_ServerDamageDiv(int data,int value);
int		ST_ServerPokeAppearCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
int		ST_ServerDirClientGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerWazaHitTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no);
BOOL	ST_ServerTokuseiStatusRecoverCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int act_flag);
BOOL	ST_ServerTokuseiStatusRecoverReshuffleCheck(SERVER_PARAM *sp,int tokusei,int condition);
BOOL	ST_ServerSinkuroCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int server_seq_no);
BOOL	ST_ServerSoubiItemCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerSoubiItemTabenokosiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerSoubiItemConditionBadCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int *seq_no);
BOOL	ST_ServerSoubiItemDamageCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
u16		ST_ServerSoubiItemNoGet(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerWazaEndCheck(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerWazaHitSoubiItemCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no);
s32		ST_ServerSoubiEqpGet(SERVER_PARAM *sp,int client_no);
s32		ST_ServerSoubiAtkGet(SERVER_PARAM *sp,int client_no,int flag);
s32		ST_ServerShizennomegumiAtkGet(SERVER_PARAM *sp,int client_no);
s32		ST_ServerShizennomegumiTypeGet(SERVER_PARAM *sp,int client_no);
s32		ST_ServerTsuibamuEqpGet(SERVER_PARAM *sp,int client_no);
s32		ST_ServerNagetsukeruEqpGet(SERVER_PARAM *sp,int client_no);
s32		ST_ServerNagetsukeruAtkGet(SERVER_PARAM *sp,int client_no);
int		ST_ServerPokemonSelectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerTsuibamuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerNagetsukeruCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no);
void	ST_ServerMetronomeBeforeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	ST_ServerMetronomeAfterCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
int		ST_ServerPokeVoiceEffNoGet(SERVER_PARAM *sp,int client_no, int client_type, int encount);
BOOL	ST_ServerCommandSelectCheck(SERVER_PARAM *sp,int client_no);
void	ST_ServerPokemonGetParamSet(BATTLE_WORK *bw,SERVER_PARAM *sp,POKEMON_PARAM *pp);
u8		ST_ServerBufferResGet(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerMigawariCheck(SERVER_PARAM *sp,int client_no);
BOOL	ST_ServerPokeOneSelfCheckAct(BATTLE_WORK *bw,SERVER_PARAM *sp);
BOOL	ST_ServerPokeOneSelfCheckActPP(BATTLE_WORK *bw,POKEMON_PARAM *pp);
BOOL	ST_ServerTenkiyaCheck(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	ST_ServerListRowInit(BATTLE_WORK *bw,SERVER_PARAM *sp);
void	ST_ServerListRowChange(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int sel_mons_no);
int		ST_WazaDamageCalc(BATTLE_WORK *bw,SERVER_PARAM *sp,
						  int wazano,u32 side_cond,u32 field_cond,u16 pow,u8 type,u8 attack,u8 defence,u8 critical);
int		ST_DamageLossCalc(SERVER_PARAM *sp,int damage);
int		ST_CriticalCheck(SERVER_PARAM *sp,int attack,int defence,int critical_count,u32 side_condition);
BOOL	ST_MonomaneNGCheck(u16 waza_no);
BOOL	ST_YubiwohuruNGCheck(u16 waza_no);
BOOL	ST_OumuEncoreNGCheck(SERVER_PARAM *sp,u16 waza_no);
BOOL	ST_SakidoriNGCheck(SERVER_PARAM *sp,u16 waza_no);
s32		ST_ItemParamGet(SERVER_PARAM *sp,u16 item_no,u16 param);
int		ST_ServerDir2ClientNoGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int dir);
void	ST_ServerTrickRoomAct(BATTLE_WORK *bw,SERVER_PARAM *sp);
BOOL	ST_ServerStatusEffectMigawariCheck(SERVER_PARAM *sp,int client_no,int status);
BOOL	ST_ServerWazaHitSoubiItemCheckTonbogaeri(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no);
void	ST_ServerPressurePPDecCheck(SERVER_PARAM *sp,int attack,int defence);

//p[^Qbgn
int		ST_ServerParamDataGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int id,int client_no);

//p[^Zbgn
void	ST_ServerOSTFStatusFlagSet(SERVER_PARAM *sp,int client_no,u32 value);
void	ST_ServerParamDataPut(BATTLE_WORK *bw,SERVER_PARAM *sp,int id,int client_no,int data);

//OJȂn
static	BOOL	ST_KoukanaiCheck(SERVER_PARAM *sp,int attack_client,int defence_client,int pos);
static	int		ST_ServerAddStatusParamSet(SERVER_PARAM *sp,int type,u32 flag);
static	int		ST_TypeCheckCalc(SERVER_PARAM *sp,int attack,int power,int damage,int waza_damage,u32 *flag);
static	BOOL	ST_AIKoukanaiCheck(SERVER_PARAM *sp,int eqp,int pos);
static	void	ST_AITypeCheckCalc(int power,u32 *flag);
static	BOOL	ST_TameWazaTurnCheck(SERVER_PARAM *sp,int waza_no);
static	u8		ST_ServerTypeGet(SERVER_PARAM *sp,int client,int id);
static	void	WazaNoStockClear(SERVER_PARAM *sp,u8 client_no);
static	void	TokusyuNoClear(SERVER_PARAM *sp,u8 client_no);
static	void	SoubiItemClear(SERVER_PARAM *sp,u8 client_no);
static	int		ST_ServerTraceClientNoGet(SERVER_PARAM *sp,int def1,int def2);
static	BOOL	ST_ServerKikenyochiWazaSeqCheck(SERVER_PARAM *sp,int waza_no);
#if B1366_060815_FIX
static	int		ST_AIWazaTypeGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no);
#endif //B1366_060815_FIX

//============================================================================================
/**
 *	PokemonParamPokemonServerParamɓǂݍ
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	ǂݍclient_no
 * @param[in]	sel_mons_no	ǂݍPokemonParam̐擪̈ʒu
 */
//============================================================================================
void	ST_PokemonParamGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int sel_mons_no)
{
	POKEMON_PARAM		*pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
	int					i;
	int					dir;
	ZKN_HEIGHT_GRAM_PTR	zhgp;

	sp->psp[client_no].monsno=			PokeParaGet(pp,ID_PARA_monsno,			0);
	sp->psp[client_no].pow=				PokeParaGet(pp,ID_PARA_pow,				0);
	sp->psp[client_no].def=				PokeParaGet(pp,ID_PARA_def,				0);
	sp->psp[client_no].agi=				PokeParaGet(pp,ID_PARA_agi,				0);
	sp->psp[client_no].spepow=			PokeParaGet(pp,ID_PARA_spepow,			0);
	sp->psp[client_no].spedef=			PokeParaGet(pp,ID_PARA_spedef,			0);

	for(i=0;i<WAZA_TEMOTI_MAX;i++){
		sp->psp[client_no].waza[i]=		PokeParaGet(pp,ID_PARA_waza1+i,			0);
		sp->psp[client_no].pp[i]=		PokeParaGet(pp,ID_PARA_pp1+i,			0);
		sp->psp[client_no].pp_count[i]=	PokeParaGet(pp,ID_PARA_pp_count1+i,		0);
	}

	sp->psp[client_no].hp_rnd=			PokeParaGet(pp,ID_PARA_hp_rnd,			0);
	sp->psp[client_no].pow_rnd=			PokeParaGet(pp,ID_PARA_pow_rnd,			0);
	sp->psp[client_no].def_rnd=			PokeParaGet(pp,ID_PARA_def_rnd,			0);
	sp->psp[client_no].agi_rnd=			PokeParaGet(pp,ID_PARA_agi_rnd,			0);
	sp->psp[client_no].spepow_rnd=		PokeParaGet(pp,ID_PARA_spepow_rnd,		0);
	sp->psp[client_no].spedef_rnd=		PokeParaGet(pp,ID_PARA_spedef_rnd,		0);

	sp->psp[client_no].tamago_flag=		PokeParaGet(pp,ID_PARA_tamago_flag,		0);
	sp->psp[client_no].nickname_flag=	PokeParaGet(pp,ID_PARA_nickname_flag,	0);

	//og^b`ʂ̎́AȂ
	if((sp->server_status_flag&SERVER_STATUS_FLAG_BATON_TOUCH)==0){
		for(i=0;i<COND_MAX;i++){
			sp->psp[client_no].abiritycnt[i]=COND_NUM_DEFAULT;
		}
	}

	sp->psp[client_no].appear_check_flag=0;			//oꎞVn`FbNǂ
	sp->psp[client_no].ikaku_flag=0;				//oꎞ`FbNǂ
	sp->psp[client_no].trace_flag=0;				//oꎞg[X`FbNǂ
	sp->psp[client_no].download_flag=0;				//oꎞ_E[h`FbN
	sp->psp[client_no].kikenyochi_flag=0;			//oꎞ悿`FbN
	sp->psp[client_no].yochimu_flag=0;				//oꎞ悿ރ`FbN
	sp->psp[client_no].slow_start_flag=0;			//oꎞX[X^[g`FbN
	sp->psp[client_no].slow_start_end_flag=0;		//X[X^[gI`FbN
	sp->psp[client_no].omitooshi_flag=0;			//oꎞ݂Ƃ`FbN
	sp->psp[client_no].katayaburi_flag=0;			//oꎞԂ`FbN
	sp->psp[client_no].pressure_flag=0;				//oꎞvbV[`FbN

	sp->psp[client_no].type1=			PokeParaGet(pp,ID_PARA_type1,			0);
	sp->psp[client_no].type2=			PokeParaGet(pp,ID_PARA_type2,			0);

	sp->psp[client_no].sex=				PokeSexGet(pp);
	sp->psp[client_no].rare=			PokeRareGet(pp);

	sp->psp[client_no].form_no=			PokeParaGet(pp,ID_PARA_form_no,			0);

	//Tt@A|Pp[NȂǁAoꎞɔ}邽߂0Zbg
	//Tt@A|Pp[NȂǁAԈُ̃`FbN}邽߂0Zbg
	if(BattleWorkFightTypeGet(bw)&FIGHT_TYPE_NO_TOKUSEI){
		sp->psp[client_no].speabino=	0;
		sp->psp[client_no].condition=	0;
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/19
// Tt@Epp[Nłǂ̌ʂ}悤
#if AFTER_MASTER_070219_BT_FIX
		sp->psp[client_no].item=		0;
#endif
// ----------------------------------------------------------------------------
	}
	else{
		sp->psp[client_no].speabino=	PokeParaGet(pp,ID_PARA_speabino,		0);
		sp->psp[client_no].condition=	PokeParaGet(pp,ID_PARA_condition,		0);
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/20
// Tt@Epp[Nłǂ̌ʂ}悤
#if AFTER_MASTER_070219_BT_FIX
		sp->psp[client_no].item=		PokeParaGet(pp,ID_PARA_item,			0);
#endif
// ----------------------------------------------------------------------------
	}

	sp->psp[client_no].level=			PokeParaGet(pp,ID_PARA_level,			0);
	sp->psp[client_no].friend=			PokeParaGet(pp,ID_PARA_friend,			0);


	sp->psp[client_no].hp=				PokeParaGet(pp,ID_PARA_hp,				0);
	sp->psp[client_no].hpmax=			PokeParaGet(pp,ID_PARA_hpmax,			0);

	sp->psp[client_no].exp=				PokeParaGet(pp,ID_PARA_exp,				0);
	sp->psp[client_no].personal_rnd=	PokeParaGet(pp,ID_PARA_personal_rnd,	0);
	sp->psp[client_no].id_no=			PokeParaGet(pp,ID_PARA_id_no,			0);
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/20
// Tt@Epp[Nłǂ̌ʂ}悤
#if !(AFTER_MASTER_070219_BT_FIX)
	sp->psp[client_no].item=			PokeParaGet(pp,ID_PARA_item,			0);
#endif
// ----------------------------------------------------------------------------
	sp->psp[client_no].oyasex=			PokeParaGet(pp,ID_PARA_oyasex,			0);
	sp->psp[client_no].get_ball=		PokeParaGet(pp,ID_PARA_get_ball,		0);

	//}ӂ̍d񃏁[Nm
	zhgp=ZKN_HEIGHTGRAM_Alloc(HEAPID_BATTLE);
	//}ӂ̍d[h
	ZKN_HEIGHTGRAM_Load(zhgp,ZKN_HEIGHT_GRAM_TYPE_MAN,HEAPID_BATTLE);

	sp->psp[client_no].weight=ZKN_HEIGHTGRAM_GetGram(zhgp,sp->psp[client_no].monsno);

	//}ӂ̍dj
	ZKN_HEIGHTGRAM_Release(zhgp);
	//}ӂ̍d񃏁[NJ
	ZKN_HEIGHTGRAM_Free(zhgp);

	PokeParaGet(pp,ID_PARA_nickname,&sp->psp[client_no].nickname[0]);
	PokeParaGet(pp,ID_PARA_oyaname,&sp->psp[client_no].oyaname[0]);

	sp->psp[client_no].hit_count=0;
	sp->psp[client_no].message_flag=0;

	//͂ƂĂ鎞́AACeĂȂƂɂ
	dir=BattleWorkMineEnemyCheck(bw,client_no);
	if(sp->scw[dir].hatakiotosu_item&No2Bit(sp->sel_mons_no[client_no])){
		sp->psp[client_no].item=0;
		sp->psp[client_no].wkw.karuwaza_flag=0;
	}
	else{
		if(sp->psp[client_no].item){
			sp->psp[client_no].wkw.karuwaza_flag=1;
		}
	}
}

//============================================================================================
/**
 *	PokemonParamPokemonServerParamɓǂݍށixAbṽ[hj
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	ǂݍclient_no
 * @param[in]	sel_mons_no	ǂݍPokemonParam̐擪̈ʒu
 */
//============================================================================================
void	ST_PokemonParamReload(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int sel_mons_no)
{
	POKEMON_PARAM	*pp=BattleWorkPokemonParamGet(bw,client_no,sel_mons_no);
	int				i;
	int				dir;

	sp->psp[client_no].pow=				PokeParaGet(pp,ID_PARA_pow,				0);
	sp->psp[client_no].def=				PokeParaGet(pp,ID_PARA_def,				0);
	sp->psp[client_no].agi=				PokeParaGet(pp,ID_PARA_agi,				0);
	sp->psp[client_no].spepow=			PokeParaGet(pp,ID_PARA_spepow,			0);
	sp->psp[client_no].spedef=			PokeParaGet(pp,ID_PARA_spedef,			0);
	sp->psp[client_no].level=			PokeParaGet(pp,ID_PARA_level,			0);
	sp->psp[client_no].friend=			PokeParaGet(pp,ID_PARA_friend,			0);
	sp->psp[client_no].hp=				PokeParaGet(pp,ID_PARA_hp,				0);
	sp->psp[client_no].hpmax=			PokeParaGet(pp,ID_PARA_hpmax,			0);

	//ւ񂵂񂵂Ă|P͈ȉ̃[h͂Ȃ
	if((sp->psp[client_no].condition2&CONDITION2_HENSHIN)==0){
		for(i=0;i<WAZA_TEMOTI_MAX;i++){
			//̂܂˂ĂZ̃[h͂Ȃ
			if((sp->psp[client_no].wkw.monomane_bit&No2Bit(i))==0){
				sp->psp[client_no].waza[i]=		PokeParaGet(pp,ID_PARA_waza1+i,			0);
				sp->psp[client_no].pp[i]=		PokeParaGet(pp,ID_PARA_pp1+i,			0);
				sp->psp[client_no].pp_count[i]=	PokeParaGet(pp,ID_PARA_pp_count1+i,		0);
			}
		}
		sp->psp[client_no].exp=				PokeParaGet(pp,ID_PARA_exp,				0);
	}
}

//============================================================================================
/**
 *	V[PXf[^ǂݍ
 *
 * @param[in]	sp		T[opp[^[N\
 * @param[in]	kind	ǂݍރA[JCut@C̎
 * @param[in]	index	ǂݍރf[^̃CfbNX
 */
//============================================================================================
void	ST_ServerSequenceLoad(SERVER_PARAM *sp,int	kind,int index)
{
	GF_ASSERT(ArchiveDataSizeGet(kind,index)<SKILL_SEQ_MAX*4);
	sp->skill_arc_kind=kind;
	sp->skill_arc_index=index;
	sp->skill_seq_no=0;
	ArchiveDataLoad(&sp->SkillSeqWork,kind,index);
}

//============================================================================================
/**
 *	V[PXf[^ǂݍށiTu[`WvΉj
 *
 * @param[in]	sp		T[opp[^[N\
 * @param[in]	kind	ǂݍރA[JCut@C̎
 * @param[in]	index	ǂݍރf[^̃CfbNX
 */
//============================================================================================
void	ST_ServerSequenceLoadGosub(SERVER_PARAM *sp,int	kind,int index)
{
	GF_ASSERT(ArchiveDataSizeGet(kind,index)<SKILL_SEQ_MAX*4);
	GF_ASSERT(sp->push_count<SKILL_SEQ_STACK);
	sp->push_skill_arc_kind[sp->push_count]	=sp->skill_arc_kind;
	sp->push_skill_arc_index[sp->push_count]=sp->skill_arc_index;
	sp->push_skill_seq_no[sp->push_count]	=sp->skill_seq_no;
	sp->push_count++;
	sp->skill_arc_kind=kind;
	sp->skill_arc_index=index;
	sp->skill_seq_no=0;
	ArchiveDataLoad(&sp->SkillSeqWork,kind,index);
}

//============================================================================================
/**
 *	Tu[`Wv`FbN
 *
 * @param[in]	sp		T[opp[^[N\
 *
 * @retval	TRUE:WvȂ@FALSEFWvÕAhXɂǂāAV[PXs
 */
//============================================================================================
BOOL	ST_ServerSequencePushCheck(SERVER_PARAM *sp)
{
	if(sp->push_count){
		sp->push_count--;
		ST_ServerSequenceLoad(sp,sp->push_skill_arc_kind[sp->push_count],sp->push_skill_arc_index[sp->push_count]);
		sp->skill_seq_no=sp->push_skill_seq_no[sp->push_count];
		return FALSE;
	}
	else{
		return TRUE;
	}
}

//============================================================================================
/**
 *	T[o߃L[Ƀp[^Zbg
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	id			ʐM̒ʐMID
 * @param[in]	client_no	T[o߂ZbgNCAgio[
 * @param[in]	index		߃R[h̃CfbNX
 */
//============================================================================================
void	ST_ServerQueSet(SERVER_PARAM *sp,int id,int client_no,int index)
{
	int	i;

	for(i=0;i<SERVER_QUE_MAX;i++){
		if(sp->ServerQue[id][client_no][i]==0){
			sp->ServerQue[id][client_no][i]=index;
			break;
		}
	}
//	OS_Printf("id:%d client_no:%d no:%d index:%d\n",id,client_no,i,index);
	//T[oL[ӂĂ͂܂̂ŁAASSERTo
	GF_ASSERT_MSG(i<SERVER_QUE_MAX,"ServerQueSet:ServerQue Overflow!\n");
}

//============================================================================================
/**
 *	T[o߃L[̃Zbg
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	id			ʐM̒ʐMID
 * @param[in]	client_no	ZbgNCAgio[
 * @param[in]	index		Zbg閽߃R[h̃CfbNX
 */
//============================================================================================
void	ST_ServerQueReset(SERVER_PARAM *sp,int id,int client_no,int index)
{
	int	i;

	//indexO͂肦Ȃ̂ŁAASSERTo
	GF_ASSERT_MSG(index!=0,"ServerQueSet:index == 0\n");

	for(i=0;i<SERVER_QUE_MAX;i++){
		if(sp->ServerQue[id][client_no][i]==index){
			sp->ServerQue[id][client_no][i]=0;
			break;
		}
	}
	//T[oL[ɑΏۂȂԂł̊֐Ă΂̂͂܂̂ŁAASSERTo
	GF_ASSERT_MSG(i<SERVER_QUE_MAX,"ServerQueSet:ServerQue NotFound code=%d!\n",index);
}

//============================================================================================
/**
 *	T[o߃L[󂩃`FbN
 *
 * @param[in]	sp			T[opp[^[N\
 *
 * @retval	TRUE:@FALSE:ł͂Ȃ
 */
//============================================================================================
BOOL	ST_ServerQueCheck(SERVER_PARAM *sp)
{
	int	id,client_no,cnt;
	int	data=0;

	for(id=0;id<ID_MAX;id++){
		for(client_no=0;client_no<CLIENT_MAX;client_no++){
			for(cnt=0;cnt<SERVER_QUE_MAX;cnt++){
				data+=sp->ServerQue[id][client_no][cnt];
			}
		}
	}
	//^CAEgJEgNA
	if(data==0){
		sp->server_que_time_out=0;
	}
	return (data==0);
}

//============================================================================================
/**
 *	T[o߃L[^CAEg`FbN
 *
 * @param[in]	sp			T[opp[^[N\
 */
//============================================================================================
void	ST_ServerQueTimeOutCheck(SERVER_PARAM *sp)
{
	sp->server_que_time_out++;
	if(sp->server_que_time_out>SERVER_QUE_TIME_OUT){
		OS_Printf("T[o^CAEg\n");
		CommStateSetError(COMM_ERROR_RESET_SAVEPOINT);
	}
}

//============================================================================================
/**
 *	server_bufferNA
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	NAobt@client_no
 */
//============================================================================================
void	ST_ServerBufferClear(SERVER_PARAM *sp,int client_no)
{
	int	i;

	for(i=0;i<BUF_SIZE;i++){
		sp->server_buffer[client_no][i]=0;
	}
}

//============================================================================================
/**
 *	POKEMON_SERVER_PARAMl擾
 *
 * @param[in]	sp		T[op[^[N\
 * @param[in]	client	擾ClientNo
 * @param[in]	id		擾l̃CfbNX
 * @param[in]	data	擾li[|C^iintł͑ȂȂǁj
 */
//============================================================================================
int		ST_ServerPokemonServerParamGet(SERVER_PARAM *sp,int client,int id,void *data)
{
	POKEMON_SERVER_PARAM *psp;

	psp=&sp->psp[client];

	switch(id){
	case ID_PSP_monsno:
		return psp->monsno;
		break;
	case ID_PSP_pow:
		return psp->pow;
		break;
	case ID_PSP_def:
		return psp->def;
		break;
	case ID_PSP_agi:
		return psp->agi;
		break;
	case ID_PSP_spepow:
		return psp->spepow;
		break;
	case ID_PSP_spedef:
		return psp->spedef;
		break;
	case ID_PSP_waza1:
	case ID_PSP_waza2:
	case ID_PSP_waza3:
	case ID_PSP_waza4:
		return psp->waza[id-ID_PSP_waza1];
		break;
	case ID_PSP_hp_rnd:
		return psp->hp_rnd;
		break;
	case ID_PSP_pow_rnd:
		return psp->pow_rnd;
		break;
	case ID_PSP_def_rnd:
		return psp->def_rnd;
		break;
	case ID_PSP_agi_rnd:
		return psp->agi_rnd;
		break;
	case ID_PSP_spepow_rnd:
		return psp->spepow_rnd;
		break;
	case ID_PSP_spedef_rnd:
		return psp->spedef_rnd;
		break;
	case ID_PSP_tamago_flag:
		return psp->tamago_flag;
		break;
	case ID_PSP_nickname_flag:
		return psp->nickname_flag;
		break;
	case ID_PSP_abiritycnt_hp:
	case ID_PSP_abiritycnt_pow:
	case ID_PSP_abiritycnt_def:
	case ID_PSP_abiritycnt_agi:
	case ID_PSP_abiritycnt_spepow:
	case ID_PSP_abiritycnt_spedef:
	case ID_PSP_abiritycnt_hit:
	case ID_PSP_abiritycnt_avoid:
		return psp->abiritycnt[id-ID_PSP_abiritycnt_hp];
		break;
	case ID_PSP_speabino:
		return psp->speabino;
		break;
	case ID_PSP_type1:
	case ID_PSP_type2:
		//}`^Cv́Aɂă^Cvς
		return ST_ServerTypeGet(sp,client,id);
		break;
	case ID_PSP_sex:
		return psp->sex;
		break;
	case ID_PSP_rare:
		return psp->rare;
		break;
	case ID_PSP_pp1:
	case ID_PSP_pp2:
	case ID_PSP_pp3:
	case ID_PSP_pp4:
		return psp->pp[id-ID_PSP_pp1];
		break;
	case ID_PSP_pp_count1:
	case ID_PSP_pp_count2:
	case ID_PSP_pp_count3:
	case ID_PSP_pp_count4:
		return psp->pp_count[id-ID_PSP_pp_count1];
		break;
	case ID_PSP_pp_max1:
	case ID_PSP_pp_max2:
	case ID_PSP_pp_max3:
	case ID_PSP_pp_max4:
		return WT_PPMaxGet(psp->waza[id-ID_PSP_pp_max1],psp->pp_count[id-ID_PSP_pp_max1]);
		break;
	case ID_PSP_level:
		return psp->level;
		break;
	case ID_PSP_friend:
		return psp->friend;
		break;
	case ID_PSP_nickname:
		{
			int	i;
			u16	*buf=data;

			for(i=0;i<MONS_NAME_SIZE+EOM_SIZE;i++){
				buf[i]=psp->nickname[i];
			}
		}
		break;
	case ID_PSP_nickname_buf:
		STRBUF_SetStringCode((STRBUF*)data, psp->nickname);
		break;
	case ID_PSP_hp:
		return psp->hp;
		break;
	case ID_PSP_hpmax:
		return psp->hpmax;
		break;
	case ID_PSP_oyaname:
		{
			int	i;
			u16	*buf=data;

			for(i=0;i<MONS_NAME_SIZE+EOM_SIZE;i++){
				buf[i]=psp->oyaname[i];
			}
		}
		break;
	case ID_PSP_exp:
		return psp->exp;
		break;
	case ID_PSP_personal_rnd:
		return psp->personal_rnd;
		break;
	case ID_PSP_condition:
		return psp->condition;
		break;
	case ID_PSP_condition2:
		return psp->condition2;
		break;
	case ID_PSP_id_no:
		return psp->id_no;
		break;
	case ID_PSP_item:
		return psp->item;
		break;
	case ID_PSP_hit_count:
		return psp->hit_count;
		break;
	case ID_PSP_message_flag:
		return psp->message_flag;
		break;
	case ID_PSP_oyasex:
		return psp->oyasex;
		break;
	case ID_PSP_waza_kouka:
		return psp->waza_kouka;
		break;
	case ID_PSP_waza_kouka_temp:
		return psp->waza_kouka_temp;
		break;
	case ID_PSP_wkw_kanashibari_count:
		return psp->wkw.kanashibari_count;
		break;
	case ID_PSP_wkw_encore_count:
		return psp->wkw.encore_count;
		break;
	case ID_PSP_wkw_juuden_count:
		return psp->wkw.juuden_count;
		break;
	case ID_PSP_wkw_chouhatsu_count:
		return psp->wkw.chouhatsu_count;
		break;
	case ID_PSP_wkw_success_count:
		return psp->wkw.success_count;
		break;
	case ID_PSP_wkw_horobinouta_count:
		return psp->wkw.horobinouta_count;
		break;
	case ID_PSP_wkw_korogaru_count:
		return psp->wkw.korogaru_count;
		break;
	case ID_PSP_wkw_renzokugiri_count:
		return psp->wkw.renzokugiri_count;
		break;
	case ID_PSP_wkw_takuwaeru_count:
		return psp->wkw.takuwaeru_count;
		break;
	case ID_PSP_wkw_takuwaeru_def_count:
		return psp->wkw.takuwaeru_def_count;
		break;
	case ID_PSP_wkw_takuwaeru_spedef_count:
		return psp->wkw.takuwaeru_spedef_count;
		break;
	case ID_PSP_wkw_namake_bit:
		return psp->wkw.namake_bit;
		break;
	case ID_PSP_wkw_moraibi_flag:
		return psp->wkw.moraibi_flag;
		break;
	case ID_PSP_wkw_lockon_client_no:
		return psp->wkw.lockon_client_no;
		break;
	case ID_PSP_wkw_monomane_bit:
		return psp->wkw.monomane_bit;
		break;
	case ID_PSP_wkw_shime_client_no:
		return psp->wkw.shime_client_no;
		break;
	case ID_PSP_wkw_manazashi_client_no:
		return psp->wkw.manazashi_client_no;
		break;
	case ID_PSP_wkw_totteoki_count:
		return psp->wkw.totteoki_count;
		break;
	case ID_PSP_wkw_denzihuyuu_count:
		return psp->wkw.denzihuyuu_count;
		break;
	case ID_PSP_wkw_healblock_count:
		return psp->wkw.healblock_count;
		break;
	case ID_PSP_wkw_shutout_count:
		return psp->wkw.shutout_count;
		break;
	case ID_PSP_wkw_karuwaza_flag:
		return psp->wkw.karuwaza_flag;
		break;
	case ID_PSP_wkw_metronome_work:
		return psp->wkw.metronome_work;
		break;
	case ID_PSP_wkw_once_hit_up:
		return psp->wkw.once_hit_up;
		break;
	case ID_PSP_wkw_once_agi_up:
		return psp->wkw.once_agi_up;
		break;
	case ID_PSP_wkw_sensei_flag:
		return psp->wkw.sensei_flag;
		break;
	case ID_PSP_wkw_handou_count:
		return psp->wkw.handou_count;
		break;
	case ID_PSP_wkw_nekodamashi_count:
		return psp->wkw.nekodamashi_count;
		break;
	case ID_PSP_wkw_slow_start_count:
		return psp->wkw.slow_start_count;
		break;
	case ID_PSP_wkw_migawari_hp:
		return psp->wkw.migawari_hp;
		break;
	case ID_PSP_wkw_henshin_rnd:
		return psp->wkw.henshin_rnd;
		break;
	case ID_PSP_wkw_kanashibari_wazano:
		return psp->wkw.kanashibari_wazano;
		break;
	case ID_PSP_wkw_encore_wazano:
		return psp->wkw.encore_wazano;
		break;
	case ID_PSP_wkw_shime_wazano:
		return psp->wkw.shime_wazano;
		break;
	case ID_PSP_wkw_item_hp_recover:
		return psp->wkw.item_hp_recover;
		break;
	case ID_PSP_slow_start_flag:
		return psp->slow_start_flag;
		break;
	case ID_PSP_slow_start_end_flag:
		return psp->slow_start_end_flag;
		break;
	case ID_PSP_work:
		return ST_ServerPokemonServerParamGet(sp,client,sp->temp_work,data);
		break;
	default:
		GF_ASSERT_MSG((0),"݂ȂPSPp[^ł\n");
		break;
	}

	return 0;
}

//============================================================================================
/**
 *	POKEMON_SERVER_PARAMɒli[
 *
 * @param[in]	sp		T[op[^[N\
 * @param[in]	client	i[ClientNo
 * @param[in]	id		i[l̃CfbNX
 * @param[in]	data	i[lւ̃|C^
 */
//============================================================================================
void	ST_ServerPokemonServerParamPut(SERVER_PARAM *sp,int client,int id,const void *buf)
{
	int	i;
	u32	*buf32=(u32 *)buf;
	u16	*buf16=(u16 *)buf;
	s16	*bufs16=(s16 *)buf;
	u8	*buf8=(u8 *)buf;
	s8	*bufs8=(s8 *)buf;
	POKEMON_SERVER_PARAM	*psp=&sp->psp[client];

	switch(id){
	case ID_PSP_monsno:
		psp->monsno=buf16[0];
		break;
	case ID_PSP_pow:
		psp->pow=buf16[0];
		break;
	case ID_PSP_def:
		psp->def=buf16[0];
		break;
	case ID_PSP_agi:
		psp->agi=buf16[0];
		break;
	case ID_PSP_spepow:
		psp->spepow=buf16[0];
		break;
	case ID_PSP_spedef:
		psp->spedef=buf16[0];
		break;
	case ID_PSP_waza1:
	case ID_PSP_waza2:
	case ID_PSP_waza3:
	case ID_PSP_waza4:
		psp->waza[id-ID_PSP_waza1]=buf16[0];
		break;
	case ID_PSP_hp_rnd:
		psp->hp_rnd=buf8[0];
		break;
	case ID_PSP_pow_rnd:
		psp->pow_rnd=buf8[0];
		break;
	case ID_PSP_def_rnd:
		psp->def_rnd=buf8[0];
		break;
	case ID_PSP_agi_rnd:
		psp->agi_rnd=buf8[0];
		break;
	case ID_PSP_spepow_rnd:
		psp->spepow_rnd=buf8[0];
		break;
	case ID_PSP_spedef_rnd:
		psp->spedef_rnd=buf8[0];
		break;
	case ID_PSP_tamago_flag:
		psp->tamago_flag=buf8[0];
		break;
	case ID_PSP_nickname_flag:
		psp->nickname_flag=buf8[0];
		break;
	case ID_PSP_abiritycnt_hp:
	case ID_PSP_abiritycnt_pow:
	case ID_PSP_abiritycnt_def:
	case ID_PSP_abiritycnt_agi:
	case ID_PSP_abiritycnt_spepow:
	case ID_PSP_abiritycnt_spedef:
	case ID_PSP_abiritycnt_hit:
	case ID_PSP_abiritycnt_avoid:
		psp->abiritycnt[id-ID_PSP_abiritycnt_hp]=bufs8[0];
		break;
	case ID_PSP_speabino:
		psp->speabino=buf8[0];
		break;
	case ID_PSP_type1:
		psp->type1=buf8[0];
		break;
	case ID_PSP_type2:
		psp->type2=buf8[0];
		break;
	case ID_PSP_sex:
		psp->sex=buf8[0];
		break;
	case ID_PSP_rare:
		psp->rare=buf8[0];
		break;
	case ID_PSP_pp1:
	case ID_PSP_pp2:
	case ID_PSP_pp3:
	case ID_PSP_pp4:
		psp->pp[id-ID_PSP_pp1]=buf8[0];
		break;
	case ID_PSP_pp_count1:
	case ID_PSP_pp_count2:
	case ID_PSP_pp_count3:
	case ID_PSP_pp_count4:
		psp->pp_count[id-ID_PSP_pp_count1]=buf8[0];
		break;
	case ID_PSP_pp_max1:
	case ID_PSP_pp_max2:
	case ID_PSP_pp_max3:
	case ID_PSP_pp_max4:
		GF_ASSERT_MSG((0),"Putł܂\n");
		break;
	case ID_PSP_level:
		psp->level=buf8[0];
		break;
	case ID_PSP_friend:
		psp->friend=buf8[0];
		break;
	case ID_PSP_nickname:
		{
			int	i;
			for(i=0;i<MONS_NAME_SIZE+EOM_SIZE;i++){
				psp->nickname[i]=buf16[i];
			}
		}
		break;
	case ID_PSP_hp:
		psp->hp=bufs16[0];
		break;
	case ID_PSP_hpmax:
		psp->hpmax=buf16[0];
		break;
	case ID_PSP_oyaname:
		{
			int	i;

			for(i=0;i<MONS_NAME_SIZE+EOM_SIZE;i++){
				psp->oyaname[i]=buf16[i];
			}
		}
		break;
	case ID_PSP_exp:
		psp->exp=buf32[0];
		break;
	case ID_PSP_personal_rnd:
		psp->personal_rnd=buf32[0];
		break;
	case ID_PSP_condition:
		psp->condition=buf32[0];
		break;
	case ID_PSP_condition2:
		psp->condition2=buf32[0];
		break;
	case ID_PSP_id_no:
		psp->id_no=buf32[0];
		break;
	case ID_PSP_item:
		psp->item=buf16[0];
		break;
	case ID_PSP_hit_count:
		psp->hit_count=buf8[0];
		break;
	case ID_PSP_message_flag:
		psp->message_flag=buf8[0];
		break;
	case ID_PSP_oyasex:
		psp->oyasex=buf8[0];
		break;
	case ID_PSP_waza_kouka:
		psp->waza_kouka=buf32[0];
		break;
	case ID_PSP_waza_kouka_temp:
		psp->waza_kouka_temp=buf32[0];
		break;
	case ID_PSP_wkw_kanashibari_count:
		psp->wkw.kanashibari_count=buf8[0];
		break;
	case ID_PSP_wkw_encore_count:
		psp->wkw.encore_count=buf8[0];
		break;
	case ID_PSP_wkw_juuden_count:
		psp->wkw.juuden_count=buf8[0];
		break;
	case ID_PSP_wkw_chouhatsu_count:
		psp->wkw.chouhatsu_count=buf8[0];
		break;
	case ID_PSP_wkw_success_count:
		psp->wkw.success_count=buf8[0];
		break;
	case ID_PSP_wkw_horobinouta_count:
		psp->wkw.horobinouta_count=buf8[0];
		break;
	case ID_PSP_wkw_korogaru_count:
		psp->wkw.korogaru_count=buf8[0];
		break;
	case ID_PSP_wkw_renzokugiri_count:
		psp->wkw.renzokugiri_count=buf8[0];
		break;
	case ID_PSP_wkw_takuwaeru_count:
		psp->wkw.takuwaeru_count=buf8[0];
		break;
	case ID_PSP_wkw_takuwaeru_def_count:
		psp->wkw.takuwaeru_def_count=buf8[0];
		break;
	case ID_PSP_wkw_takuwaeru_spedef_count:
		psp->wkw.takuwaeru_spedef_count=buf8[0];
		break;
	case ID_PSP_wkw_namake_bit:
		psp->wkw.namake_bit=buf8[0];
		break;
	case ID_PSP_wkw_moraibi_flag:
		psp->wkw.moraibi_flag=buf8[0];
		break;
	case ID_PSP_wkw_lockon_client_no:
		psp->wkw.lockon_client_no=buf8[0];
		break;
	case ID_PSP_wkw_monomane_bit:
		psp->wkw.monomane_bit=buf8[0];
		break;
	case ID_PSP_wkw_shime_client_no:
		psp->wkw.shime_client_no=buf8[0];
		break;
	case ID_PSP_wkw_manazashi_client_no:
		psp->wkw.manazashi_client_no=buf8[0];
		break;
	case ID_PSP_wkw_totteoki_count:
		psp->wkw.totteoki_count=buf8[0];
		break;
	case ID_PSP_wkw_denzihuyuu_count:
		psp->wkw.denzihuyuu_count=buf8[0];
		break;
	case ID_PSP_wkw_healblock_count:
		psp->wkw.healblock_count=buf8[0];
		break;
	case ID_PSP_wkw_shutout_count:
		psp->wkw.shutout_count=buf8[0];
		break;
	case ID_PSP_wkw_karuwaza_flag:
		psp->wkw.karuwaza_flag=buf8[0];
		break;
	case ID_PSP_wkw_metronome_work:
		psp->wkw.metronome_work=buf8[0];
		break;
	case ID_PSP_wkw_once_hit_up:
		psp->wkw.once_hit_up=buf8[0];
		break;
	case ID_PSP_wkw_once_agi_up:
		psp->wkw.once_agi_up=buf8[0];
		break;
	case ID_PSP_wkw_sensei_flag:
		psp->wkw.sensei_flag=buf8[0];
		break;
	case ID_PSP_wkw_handou_count:
		psp->wkw.handou_count=buf32[0];
		break;
	case ID_PSP_wkw_nekodamashi_count:
		psp->wkw.nekodamashi_count=buf32[0];
		break;
	case ID_PSP_wkw_slow_start_count:
		psp->wkw.slow_start_count=buf32[0];
		break;
	case ID_PSP_wkw_migawari_hp:
		psp->wkw.migawari_hp=buf32[0];
		break;
	case ID_PSP_wkw_henshin_rnd:
		psp->wkw.henshin_rnd=buf32[0];
		break;
	case ID_PSP_wkw_kanashibari_wazano:
		psp->wkw.kanashibari_wazano=buf16[0];
		break;
	case ID_PSP_wkw_encore_wazano:
		psp->wkw.encore_wazano=buf16[0];
		break;
	case ID_PSP_wkw_shime_wazano:
		psp->wkw.shime_wazano=buf16[0];
		break;
	case ID_PSP_wkw_item_hp_recover:
		psp->wkw.item_hp_recover=buf32[0];
		break;
	case ID_PSP_slow_start_flag:
		psp->slow_start_flag=buf8[0];
		break;
	case ID_PSP_slow_start_end_flag:
		psp->slow_start_end_flag=buf8[0];
		break;
	case ID_PSP_work:
		ST_ServerPokemonServerParamPut(sp,client,sp->temp_work,buf);
		break;
	default:
		GF_ASSERT_MSG((0),"݂ȂPSPp[^ł\n");
		break;
	}
}

//============================================================================================
/**
 *	POKEMON_SERVER_PARAMɒlZ
 *
 * @param[in]	sp		T[op[^[N\
 * @param[in]	client	ZClientNo
 * @param[in]	id		Zl̃CfbNX
 * @param[in]	value	Zl
 */
//============================================================================================
void	ST_ServerPokemonServerParamAdd(SERVER_PARAM *sp,int client,int id,int value)
{
	ST_PokemonServerParamAdd(&sp->psp[client],id,value);
}

//============================================================================================
/**
 *	POKEMON_SERVER_PARAMɒlZ
 *
 * @param[in]	psp		T[op|Pp[^[N\
 * @param[in]	id		Zl̃CfbNX
 * @param[in]	value	Zlւ̃|C^
 */
//============================================================================================
void	ST_PokemonServerParamAdd(POKEMON_SERVER_PARAM *psp,int id,int value)
{
	int	i;

	switch(id){
	case ID_PSP_pow:
		psp->pow+=value;
		break;
	case ID_PSP_def:
		psp->def+=value;
		break;
	case ID_PSP_agi:
		psp->agi+=value;
		break;
	case ID_PSP_spepow:
		psp->spepow+=value;
		break;
	case ID_PSP_spedef:
		psp->spedef+=value;
		break;
	case ID_PSP_hp_rnd:
		psp->hp_rnd+=value;
		break;
	case ID_PSP_pow_rnd:
		psp->pow_rnd+=value;
		break;
	case ID_PSP_def_rnd:
		psp->def_rnd+=value;
		break;
	case ID_PSP_agi_rnd:
		psp->agi_rnd+=value;
		break;
	case ID_PSP_spepow_rnd:
		psp->spepow_rnd+=value;
		break;
	case ID_PSP_spedef_rnd:
		psp->spedef_rnd+=value;
		break;
	case ID_PSP_abiritycnt_hp:
	case ID_PSP_abiritycnt_pow:
	case ID_PSP_abiritycnt_def:
	case ID_PSP_abiritycnt_agi:
	case ID_PSP_abiritycnt_spepow:
	case ID_PSP_abiritycnt_spedef:
	case ID_PSP_abiritycnt_hit:
	case ID_PSP_abiritycnt_avoid:
		if(psp->abiritycnt[id-ID_PSP_abiritycnt_hp]+value<0){
			psp->abiritycnt[id-ID_PSP_abiritycnt_hp]=0;
		}
		else if(psp->abiritycnt[id-ID_PSP_abiritycnt_hp]+value>12){
			psp->abiritycnt[id-ID_PSP_abiritycnt_hp]=12;
		}
		else{
			psp->abiritycnt[id-ID_PSP_abiritycnt_hp]+=value;
		}
		break;
	case ID_PSP_pp1:
	case ID_PSP_pp2:
	case ID_PSP_pp3:
	case ID_PSP_pp4:
		{
			int	ppmax;

			ppmax=WT_PPMaxGet(psp->waza[id-ID_PSP_pp1],psp->pp_count[id-ID_PSP_pp1]);

			if(psp->pp[id-ID_PSP_pp1]+value>ppmax){
				psp->pp[id-ID_PSP_pp1]=ppmax;
			}
			else{
				psp->pp[id-ID_PSP_pp1]+=value;
			}
		}
		break;
	case ID_PSP_pp_count1:
	case ID_PSP_pp_count2:
	case ID_PSP_pp_count3:
	case ID_PSP_pp_count4:
		psp->pp_count[id-ID_PSP_pp_count1]+=value;
		break;
	case ID_PSP_level:
		psp->level+=value;
		break;
	case ID_PSP_friend:
		if((psp->friend+value)>FRIEND_MAX){
			psp->friend=FRIEND_MAX;
		}
		else{
			psp->friend+=value;
		}
		break;
	case ID_PSP_hp:
		if(psp->hp+value>psp->hpmax){
			psp->hp=psp->hpmax;
		}
		else{
			psp->hp+=value;
		}
		break;
	case ID_PSP_hpmax:
		psp->hpmax+=value;
		break;
	case ID_PSP_exp:
		psp->exp+=value;
		break;
	case ID_PSP_personal_rnd:
		psp->personal_rnd+=value;
		break;
	case ID_PSP_wkw_kanashibari_count:
		psp->wkw.kanashibari_count+=value;
		break;
	case ID_PSP_wkw_encore_count:
		psp->wkw.encore_count+=value;
		break;
	case ID_PSP_wkw_juuden_count:
		psp->wkw.juuden_count+=value;
		break;
	case ID_PSP_wkw_chouhatsu_count:
		psp->wkw.chouhatsu_count+=value;
		break;
	case ID_PSP_wkw_success_count:
		psp->wkw.success_count+=value;
		break;
	case ID_PSP_wkw_horobinouta_count:
		psp->wkw.horobinouta_count+=value;
		break;
	case ID_PSP_wkw_korogaru_count:
		psp->wkw.korogaru_count+=value;
		break;
	case ID_PSP_wkw_renzokugiri_count:
		psp->wkw.renzokugiri_count+=value;
		break;
	case ID_PSP_wkw_takuwaeru_count:
		psp->wkw.takuwaeru_count+=value;
		break;
	case ID_PSP_wkw_takuwaeru_def_count:
		psp->wkw.takuwaeru_def_count+=value;
		break;
	case ID_PSP_wkw_takuwaeru_spedef_count:
		psp->wkw.takuwaeru_spedef_count+=value;
		break;
	case ID_PSP_wkw_totteoki_count:
		psp->wkw.totteoki_count+=value;
		break;
	case ID_PSP_wkw_denzihuyuu_count:
		psp->wkw.denzihuyuu_count+=value;
		break;
	case ID_PSP_wkw_healblock_count:
		psp->wkw.healblock_count+=value;
		break;
	case ID_PSP_wkw_handou_count:
		psp->wkw.handou_count+=value;
		break;
	case ID_PSP_wkw_nekodamashi_count:
		psp->wkw.nekodamashi_count+=value;
		break;
	case ID_PSP_wkw_slow_start_count:
		psp->wkw.slow_start_count+=value;
		break;
	case ID_PSP_wkw_migawari_hp:
		psp->wkw.migawari_hp+=value;
		break;
	case ID_PSP_wkw_item_hp_recover:
		psp->wkw.item_hp_recover+=value;
		break;
	case ID_PSP_slow_start_flag:
		psp->slow_start_flag+=value;
		break;
	case ID_PSP_slow_start_end_flag:
		psp->slow_start_end_flag+=value;
		break;
	default:
		GF_ASSERT_MSG((0),"݂ȂPSPp[^ł\n");
		break;
	}
}

//============================================================================================
/**
 *	f𔼌鑕ʃe[u
 */
//============================================================================================
static	const	u8	ItemEqpAgiHalfTable[]={
	SOUBI_DORYOKUTINIBAI,
	SOUBI_SUBAYASADOWN,
	SOUBI_HPDORYOKUTIUP,
	SOUBI_KOUGEKIDORYOKUTIUP,
	SOUBI_BOUGYODORYOKUTIUP,
	SOUBI_SUBAYASADORYOKUTIUP,
	SOUBI_TOKUKOUDORYOKUTIUP,
	SOUBI_TOKUBOUDORYOKUTIUP,
};

//============================================================================================
/**
 *	|P̑fvZ
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	cl1			`FbNClientNo1
 * @param[in]	cl2			`FbNClientNo2
 * @param[in]	flag		Z̐搧vCIeB̗L(0)^(1)
 *
 * @retval	0:\[g̕KvȂ@1:\[g̕Kv@2:\[g̕Kvif̂ŁA_Ō肳ꂽj
 */
//============================================================================================
u8	ST_ServerAgiCalc(BATTLE_WORK *bw,SERVER_PARAM *sp,int cl1,int cl2,int flag)
{
	u8	ret=0;
	u32	agi1,agi2;
	u16	wazano1=0,wazano2=0;
	u8	eqp1;
	u8	atk1;
	u8	eqp2;
	u8	atk2;
	s8	attackpri1=0;
	s8	attackpri2=0;
	u8	sensei1=0,sensei2=0;
	u8	koukou1=0,koukou2=0;
	int	command1;
	int	command2;
	int	wazapos1;
	int	wazapos2;
	int	speabi1;
	int	speabi2;
	int	cond_agi1;
	int	cond_agi2;
	int	i;

	//HP0̓z͖ɒx
	if((sp->psp[cl1].hp==0)&&(sp->psp[cl2].hp)){
		return 1;
	}
	if((sp->psp[cl1].hp)&&(sp->psp[cl2].hp==0)){
		return 0;
	}

	speabi1=ST_ServerTokuseiGet(sp,cl1);
	speabi2=ST_ServerTokuseiGet(sp,cl2);

	eqp1=ST_ServerSoubiEqpGet(sp,cl1);
	atk1=ST_ServerSoubiAtkGet(sp,cl1,ATK_CHECK_NORMAL);
	eqp2=ST_ServerSoubiEqpGet(sp,cl2);
	atk2=ST_ServerSoubiAtkGet(sp,cl2,ATK_CHECK_NORMAL);

	cond_agi1=sp->psp[cl1].abiritycnt[COND_AGI];
	cond_agi2=sp->psp[cl2].abiritycnt[COND_AGI];

	//񂶂ĂƂ́A΂₳㏸{
	if(ST_ServerTokuseiGet(sp,cl1)==TOKUSYU_TANZYUN){
		cond_agi1=6+((cond_agi1-6)*2);
		if(cond_agi1>12){
			cond_agi1=12;
		}
		if(cond_agi1<0){
			cond_agi1=0;
		}
	}
	if(ST_ServerTokuseiGet(sp,cl2)==TOKUSYU_TANZYUN){
		cond_agi2=6+((cond_agi2-6)*2);
		if(cond_agi2>12){
			cond_agi2=12;
		}
		if(cond_agi2<0){
			cond_agi2=0;
		}
	}
	
	agi1=sp->psp[cl1].agi*CondChgTable[cond_agi1][0]/
						  CondChgTable[cond_agi1][1];

	agi2=sp->psp[cl2].agi*CondChgTable[cond_agi2][0]/
						  CondChgTable[cond_agi2][1];

	//\͂̂Ă񂫂̃|P퓬ɏoĂƂ̓`FbNȂ
	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		//\͂́AĴƂf{
		//\͂悤傭́ÂƂf{
		if(((speabi1==TOKUSYU_SUISUI)&&(sp->field_condition&FIELD_CONDITION_AME_ALL))||
		   ((speabi1==TOKUSYU_YOURYOKUSO)&&(sp->field_condition&FIELD_CONDITION_HARE_ALL))){
			agi1*=2;
		}
		//\͂́AĴƂf{
		//\͂悤傭́ÂƂf{
		if(((speabi2==TOKUSYU_SUISUI)&&(sp->field_condition&FIELD_CONDITION_AME_ALL))||
		   ((speabi2==TOKUSYU_YOURYOKUSO)&&(sp->field_condition&FIELD_CONDITION_HARE_ALL))){
			agi2*=2;
		}
	}

	//ACeœw͒lQ{̌ʁA΂₳DOWN𑕔Ƒf1/2ɂ
	for(i=0;i<NELEMS(ItemEqpAgiHalfTable);i++){
		if(ST_ItemParamGet(sp,sp->psp[cl1].item,ITEM_PRM_EQUIP)==ItemEqpAgiHalfTable[i]){
			agi1/=2;
			break;
		}
	}

	//ACełn𑕔Ƒf1.5{ɂ
	if(eqp1==SOUBI_ONAZIWAZAONLYSUBAYASAUP){
		agi1=agi1*15/10;
	}

	//ACeŃ^Ƒf2{ɂ
	if((eqp1==SOUBI_METAMONSUBAYASAUP)&&(sp->psp[cl1].monsno==MONSNO_METAMON)){
		agi1*=2;
	}

	//͂₠́AԈُőf1.5{ɂ
	if((speabi1==TOKUSYU_HAYAASI)&&(sp->psp[cl1].condition&CONDITION_BAD)){
		agi1=agi1*15/10;
	}
	else{
		//܂Ђ̎́Af1/4ɂ
		if(sp->psp[cl1].condition&CONDITION_MAHI){
			agi1/=4;
		}
	}

	//X[X^[ǵAɂłĂ5^[ȓ͑f𔼕ɂ
	if((speabi1==TOKUSYU_SUROOSUTAATO)&&
	  ((sp->total_turn-sp->psp[cl1].wkw.slow_start_count)<5)){
		agi1/=2;
	}

	//킴́AACeĂ܂Ƒf{ɂȂ
	if((speabi1==TOKUSYU_KARUWAZA)&&
	   (sp->psp[cl1].wkw.karuwaza_flag)&&
	   (sp->psp[cl1].item==0)){
		agi1*=2;
	}

	//Zʂ󂯂Ă鎞́Af2{
	if(sp->side_condition[BattleWorkMineEnemyCheck(bw,cl1)]&SIDE_CONDITION_OIKAZE){
		agi1*=2;
	}

	//ACeŐ搧Ǔʂ𑕔Ɛ搧Uɂ
	if(eqp1==SOUBI_SENSEIKOUGEKI){
#ifdef PM_DEBUG
		if(((sp->agi_rand[cl1]%(100/atk1))==0)||sp->dbp.debug_flag&DEBUG_FLAG_SOUBI){
#else
		if((sp->agi_rand[cl1]%(100/atk1))==0){
#endif
			sensei1=1;
			//Z̃vCIeBȂ́AʃGtFNg̔͂Ȃ
			if(flag==0){
				sp->psp[cl1].wkw.sensei_flag=1;
			}
		}
	}
	
	//ʂŐ搧Uɂ
	if(sp->psp[cl1].wkw.once_agi_up){
		sensei1=1;
	}

	//ACeŌUǓʂ𑕔ƌUUɂ
	if(eqp1==SOUBI_KOUKOUNINARU){
		koukou1=1;
	}

	//ACeœw͒lQ{̌ʁA΂₳DOWN𑕔Ƒf1/2ɂ
	for(i=0;i<NELEMS(ItemEqpAgiHalfTable);i++){
		if(ST_ItemParamGet(sp,sp->psp[cl2].item,ITEM_PRM_EQUIP)==ItemEqpAgiHalfTable[i]){
			agi2/=2;
			break;
		}
	}

	//ACełn𑕔Ƒf1.5{ɂ
	if(eqp2==SOUBI_ONAZIWAZAONLYSUBAYASAUP){
		agi2=agi2*15/10;
	}

	//ACeŃ^Ƒf2{ɂ
	if((eqp2==SOUBI_METAMONSUBAYASAUP)&&(sp->psp[cl2].monsno==MONSNO_METAMON)){
		agi2*=2;
	}

	//͂₠́AԈُőf1.5{ɂ
	if((speabi2==TOKUSYU_HAYAASI)&&(sp->psp[cl2].condition&CONDITION_BAD)){
		agi2=agi2*15/10;
	}
	else{
		//܂Ђ̎́Af1/4ɂ
		if(sp->psp[cl2].condition&CONDITION_MAHI){
			agi2/=4;
		}
	}

	//X[X^[ǵAɂłĂ5^[ȓ͑f𔼕ɂ
	if((speabi2==TOKUSYU_SUROOSUTAATO)&&
	  ((sp->total_turn-sp->psp[cl2].wkw.slow_start_count)<5)){
		agi2/=2;
	}

	//킴́AACeĂ܂Ƒf{ɂȂ
	if((speabi2==TOKUSYU_KARUWAZA)&&
	   (sp->psp[cl2].wkw.karuwaza_flag)&&
	   (sp->psp[cl2].item==0)){
		agi2*=2;
	}

	//Zʂ󂯂Ă鎞́Af2{
	if(sp->side_condition[BattleWorkMineEnemyCheck(bw,cl2)]&SIDE_CONDITION_OIKAZE){
		agi2*=2;
	}

	//ACeŐ搧Ǔʂ𑕔Ɛ搧Uɂ
	if(eqp2==SOUBI_SENSEIKOUGEKI){
#ifdef PM_DEBUG
		if(((sp->agi_rand[cl2]%(100/atk2))==0)||sp->dbp.debug_flag&DEBUG_FLAG_SOUBI){
#else
		if((sp->agi_rand[cl2]%(100/atk2))==0){
#endif
			sensei2=1;
			//Z̃vCIeBȂ́AʃGtFNg̔͂Ȃ
			if(flag==0){
				sp->psp[cl2].wkw.sensei_flag=1;
			}
		}
	}

	//ʂŐ搧Uɂ
	if(sp->psp[cl2].wkw.once_agi_up){
		sensei2=1;
	}

	//ACeŌUǓʂ𑕔ƌUUɂ
	if(eqp2==SOUBI_KOUKOUNINARU){
		koukou2=1;
	}

	//ȑfp[^[NɊi[
	sp->psp_agi_point[cl1]=agi1;
	sp->psp_agi_point[cl2]=agi2;

	if(flag==0){
		command1=sp->client_act_work[cl1][ACT_PARA_SELECT_COMMAND];
		command2=sp->client_act_work[cl2][ACT_PARA_SELECT_COMMAND];
		wazapos1=sp->waza_no_pos[cl1];
		wazapos2=sp->waza_no_pos[cl2];
		if(command1==SELECT_FIGHT_COMMAND){
			if(sp->otf[cl1].waruagaki_flag){
				wazano1=WAZANO_WARUAGAKI;
			}
			else{
				wazano1=ST_ServerPokemonServerParamGet(sp,cl1,ID_PSP_waza1+wazapos1,NULL);
			}
		}
		if(command2==SELECT_FIGHT_COMMAND){
			if(sp->otf[cl2].waruagaki_flag){
				wazano2=WAZANO_WARUAGAKI;
			}
			else{
				wazano2=ST_ServerPokemonServerParamGet(sp,cl2,ID_PSP_waza1+wazapos2,NULL);
			}
		}
//		attackpri1=WT_WazaDataParaGet(wazano1,ID_WTD_attackpri);
//		attackpri2=WT_WazaDataParaGet(wazano2,ID_WTD_attackpri);
		attackpri1=sp->AIWT.wtd[wazano1].attackpri;
		attackpri2=sp->AIWT.wtd[wazano2].attackpri;
	}

	if(attackpri1==attackpri2){
		//搧vCIeBꏏ̎́A񂹂̃cÂہAƂAgbN[̏Ō
		if((sensei1)&&(sensei2)){
			if(agi1<agi2){
				ret=1;
			}
			else if((agi1==agi2)&&(gf_rand()&1)){
				ret=2;
			}
		}
		else if((sensei1==0)&&(sensei2)){
			ret=1;
		}
		else if((sensei1)&&(sensei2==0)){
			ret=0;
		}
		else if((koukou1)&&(koukou2)){
			if(agi1>agi2){
				ret=1;
			}
			else if((agi1==agi2)&&(gf_rand()&1)){
				ret=2;
			}
		}
		else if((koukou1)&&(koukou2==0)){
			ret=1;
		}
		else if((koukou1==0)&&(koukou2)){
			ret=0;
		}
		else if((speabi1==TOKUSYU_ATODASI)&&(speabi2==TOKUSYU_ATODASI)){
			if(agi1>agi2){
				ret=1;
			}
			else if((agi1==agi2)&&(gf_rand()&1)){
				ret=2;
			}
		}
		else if((speabi1==TOKUSYU_ATODASI)&&(speabi2!=TOKUSYU_ATODASI)){
			ret=1;
		}
		else if((speabi1!=TOKUSYU_ATODASI)&&(speabi2==TOKUSYU_ATODASI)){
			ret=0;
		}
		else if(sp->field_condition&FIELD_CONDITION_TRICKROOM){
			if(agi1>agi2){
				ret=1;
			}
			if((agi1==agi2)&&(gf_rand()&1)){
				ret=2;
			}
		}
		else{
			if(agi1<agi2){
				ret=1;
			}
			if((agi1==agi2)&&(gf_rand()&1)){
				ret=2;
			}
		}
	}
	else if(attackpri1<attackpri2){
		ret=1;
	}

	return	ret;
}

//============================================================================================
/**
 *	ollł錠tÕNA
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	NANCAgio[
 */
//============================================================================================
void	ST_ServerGetExpRightFlagClear(SERVER_PARAM *sp,int client_no)
{
	sp->get_exp_right_flag[(client_no>>1)&1]=0;
}

//============================================================================================
/**
 *	ollł錠tÕZbg
 *
 * @param[in]	bw			퓬VXe[N\̃|C^
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	ZbgNCAgio[
 */
//============================================================================================
void	ST_ServerGetExpRightFlagSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int	no;
	u32	fight_type;

	no=CLIENT_NO_MINE;
	fight_type=BattleWorkFightTypeGet(bw);

	while(no<=CLIENT_NO_MINE2){
		if( ((sp->no_reshuffle_client&No2Bit(no))==0) && 
			((sp->no_reshuffle_client&No2Bit(client_no))==0) &&
			(sp->psp[client_no].hp) ){
			sp->get_exp_right_flag[(client_no>>1)&1]|=No2Bit(sp->sel_mons_no[no]);
		}
		no+=2;
		if((fight_type==FIGHT_TYPE_2vs2_YASEI)||(fight_type==FIGHT_TYPE_AI_MULTI)){
			break;
		}
	}
}

//============================================================================================
/**
 *	ollł錠tÕZbg
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	ZbgNCAgio[
 */
//============================================================================================
void	ST_ServerGetExpRightFlagReset(SERVER_PARAM *sp,int client_no)
{
	int	no;

	no=CLIENT_NO_MINE;

	while(no<=CLIENT_NO_MINE2){
		if( ((sp->no_reshuffle_client&No2Bit(no))==0) && ((sp->no_reshuffle_client&No2Bit(client_no))==0) ){
			sp->get_exp_right_flag[(client_no>>1)&1]&=(No2Bit(sp->sel_mons_no[no])^0xffffffff);
		}
		no+=2;
	}
}

//============================================================================================
/**
 *	ǉʂ̃`FbNiڒǉ̂݁j
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[out]	seq_no		ǉʂ邽߂̃TuV[PXio[
 */
//============================================================================================
BOOL	ST_ServerAddStatusDirectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no)
{
	BOOL	ret=FALSE;

	if(sp->add_status_flag_direct&ADD_STATUS_WAZAKOUKA){
		//Zʂ̒ǉ́A100%N
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_DIRECT,sp->add_status_flag_direct);
		sp->add_status_flag_direct=0;
		//͂Ŏsɂ
		if((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0){
			ret=TRUE;
		}
	}
	else if(sp->add_status_flag_direct){
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_DIRECT,sp->add_status_flag_direct);
		//C₵Ă鑊ɂ͎s
		if((sp->psp[sp->tsuika_client].hp)&&
		//Zʂ̒ǉł͂𖳎w肪Ȃ́A͂Ŏsɂ
		  (((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)||
		   ((sp->add_status_flag_direct&ADD_STATUS_WAZAKOUKA_KAWARAWARI)&&
		    (sp->waza_status_flag&WAZA_STATUS_FLAG_KAWARAWARI))||
		   ((sp->add_status_flag_direct&ADD_STATUS_WAZAKOUKA_NOHIT)&&
		    (sp->waza_status_flag&WAZA_STATUS_FLAG_NOHIT_CHG)))){
			ret=TRUE;
		}
		sp->add_status_flag_direct=0;
	}

	return ret;
}

//============================================================================================
/**
 *	ǉʂ̃`FbNiڒǉȊOj
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[out]	seq_no		ǉʂ邽߂̃TuV[PXio[
 */
//============================================================================================
BOOL	ST_ServerAddStatusCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no)
{
	BOOL	ret=FALSE;
	u16		kakuritsu;

	//Zʂ̒ǉ́A100%N
	if(sp->add_status_flag_indirect&ADD_STATUS_WAZAKOUKA){
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
		sp->add_status_flag_indirect=0;
		//͂Ŏsɂ
		if(((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)){
			ret=TRUE;
		}
	}
	//Zʂ̒ǉ́A100%N
	else if(sp->add_status_flag_indirect&ADD_STATUS_WAZAKOUKA_NOHP){
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
		sp->add_status_flag_indirect=0;
		//݂肪ꍇ́Asɂ@͂Ŏsɂ
		if((ST_ServerMigawariCheck(sp,sp->tsuika_client)==FALSE)&&
		   ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)){
			ret=TRUE;
		}
	}
	//Zʂ̒ǉ́A100%N
	else if(sp->add_status_flag_indirect&ADD_STATUS_WAZAKOUKA_CHECK){
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
		sp->add_status_flag_indirect=0;
		//C₵Ă鑊ɂ͎s ݂肪ꍇ́Asɂ@͂Ŏsɂ
		if((sp->psp[sp->tsuika_client].hp)&&
		  (ST_ServerMigawariCheck(sp,sp->tsuika_client)==FALSE)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)){
			ret=TRUE;
		}
	}
	//Zʂ̒ǉ́A100%N
	else if(sp->add_status_flag_indirect&ADD_STATUS_WAZAKOUKA_NOHIT){
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
		sp->add_status_flag_indirect=0;
		//C₵Ă鑊ɂ͎s
		if(sp->psp[sp->tsuika_client].hp){
			ret=TRUE;
		}
	}
	//Zʂ̒ǉ́A100%N
	else if(sp->add_status_flag_indirect&ADD_STATUS_WAZAKOUKA_PROB){
		//\͂Ă̂߂݂́Am{ɂ
		if(ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_TENNOMEGUMI){
//			kakuritsu=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_addeffect)*2;
			kakuritsu=sp->AIWT.wtd[sp->waza_no_now].addeffect*2;
		}
		else{
//			kakuritsu=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_addeffect);
			kakuritsu=sp->AIWT.wtd[sp->waza_no_now].addeffect;
		}
		//ԐڂŊmO͂肦Ȃ̂ŁAAT[g
		GF_ASSERT(kakuritsu!=0);
#ifdef PM_DEBUG
		if(((gf_rand()%100)<kakuritsu)||(sp->dbp.debug_flag&DEBUG_FLAG_ADD_STATUS)){
			//ǉʋNɂȂAtOIɂ
			sp->server_status_flag|=SERVER_STATUS_FLAG_TSUIKA;
		}
#else
		if((gf_rand()%100)<kakuritsu){
			//ǉʋNɂȂAtOIɂ
			sp->server_status_flag|=SERVER_STATUS_FLAG_TSUIKA;
		}
#endif
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
		sp->add_status_flag_indirect=0;
		//C₵Ă鑊ɂ͎s
		if(sp->psp[sp->tsuika_client].hp==0){
			sp->server_status_flag&=SERVER_STATUS_FLAG_TSUIKA_OFF;
		}
		ret=TRUE;
	}
	else if(sp->add_status_flag_indirect){
		//\͂Ă̂߂݂́Am{ɂ
		if(ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_TENNOMEGUMI){
//			kakuritsu=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_addeffect)*2;
			kakuritsu=sp->AIWT.wtd[sp->waza_no_now].addeffect*2;
		}
		else{
//			kakuritsu=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_addeffect);
			kakuritsu=sp->AIWT.wtd[sp->waza_no_now].addeffect;
		}
		//ԐڂŊmO͂肦Ȃ̂ŁAAT[g
		GF_ASSERT(kakuritsu!=0);
#ifdef PM_DEBUG
		if(((gf_rand()%100)<kakuritsu)||(sp->dbp.debug_flag&DEBUG_FLAG_ADD_STATUS)){
			seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
			sp->add_status_flag_indirect=0;
			//C₵Ă鑊ɂ͎s ݂肪ꍇ́Asɂ@͂Ŏsɂ
			if((sp->psp[sp->tsuika_client].hp)&&
			   (ST_ServerMigawariCheck(sp,sp->tsuika_client)==FALSE)&&
			   (sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0){
				ret=TRUE;
			}
		}
#else
		if((gf_rand()%100)<kakuritsu){
			seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_INDIRECT,sp->add_status_flag_indirect);
			sp->add_status_flag_indirect=0;
			//C₵Ă鑊ɂ͎s ݂肪ꍇ́Asɂ@͂Ŏsɂ
			if((sp->psp[sp->tsuika_client].hp)&&
			   (ST_ServerMigawariCheck(sp,sp->tsuika_client)==FALSE)&&
			   (sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0){
				ret=TRUE;
			}
		}
#endif PM_DEBUG
	}
	else if(sp->add_status_flag_tokusei){
		seq_no[0]=ST_ServerAddStatusParamSet(sp,ADD_STATUS_TOKUSEI,sp->add_status_flag_tokusei);
		sp->add_status_flag_tokusei=0;
		//C₵Ă鑊ɂ͎s
		if(sp->psp[sp->tsuika_client].hp){
			ret=TRUE;
		}
	}

	return ret;
}

//============================================================================================
/**
 * @brief	UΏۂZbg
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	attack		UClientNo
 * @param[in]	waza_no		JoƂĂZ
 * @param[in]	flag		0:DirSelectŃZbgl 1:Ώۂ_őI
 * @param[in]	range		waza_no0̎ɗLRANGEl
 *
 * @retval	ZbgClientNo
 */
//============================================================================================
int		ST_ServerDefenceClientSet(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,u16 waza_no,int flag,int set_range)
{
	int	defence;
	int	range;

	defence=NONE_CLIENT_NO;

	if(waza_no){
//		range=WT_WazaDataParaGet(waza_no,ID_WTD_attackrange);
		range=sp->AIWT.wtd[waza_no].attackrange;
	}
	else{
		range=set_range;
	}

	if(range==RANGE_DOUBLE){
		{
			int	client_no;
			int	client_set_max=BattleWorkClientSetMaxGet(bw);
			CLIENT_PARAM *cp=BattleWorkClientParamGet(bw,attack);
			u8	flag=CT_CPClientTypeGet(cp);

			for(sp->client_loop=0;sp->client_loop<client_set_max;sp->client_loop++){
				client_no=sp->psp_agi_work[sp->client_loop];
				if(sp->psp[client_no].hp!=0){
					cp=BattleWorkClientParamGet(bw,client_no);
					if( ((flag&CLIENT_ENEMY_FLAG)&&((CT_CPClientTypeGet(cp)&CLIENT_ENEMY_FLAG)==0))||
						((flag&CLIENT_ENEMY_FLAG)==0)&&(CT_CPClientTypeGet(cp)&CLIENT_ENEMY_FLAG)){
						defence=client_no;
						break;
					}
				}
			}
			if(sp->client_loop!=client_set_max){
				sp->client_loop++;
			}
		}
	}
	else if(range==RANGE_TRIPLE){
		{
			int	client_no;
			int	client_set_max;

			client_set_max=BattleWorkClientSetMaxGet(bw);

			for(sp->client_loop=0;sp->client_loop<client_set_max;sp->client_loop++){
				client_no=sp->psp_agi_work[sp->client_loop];
				if(sp->psp[client_no].hp!=0){
					if(client_no!=attack){
						defence=client_no;
						break;
					}
				}
			}
			if(sp->client_loop!=client_set_max){
				sp->client_loop++;
			}
		}
	}
	//тӂȂǂŁAΏۂI΂ɋZȍ
	else if((range==RANGE_TUBOWOTUKU)&&(flag==1)){
		{
			int	fight_type;

			fight_type=BattleWorkFightTypeGet(bw);

			if((fight_type&FIGHT_TYPE_2vs2)&&((gf_rand()%2)==0)){
				defence=BattleWorkPartnerClientNoGet(bw,attack);
				if(sp->psp[defence].hp==0){
					defence=attack;
				}
			}
			else{
				defence=attack;
			}
		}
	}
	//тӂȂǂŁAΏۂI΂ɋZȍ
	else if((range==RANGE_SAKIDORI)&&(flag==1)){
		defence=ST_ServerDirClientGet(bw,sp,attack);
	}
	else if(range==RANGE_MAKIBISHI){
		defence=ST_ServerDirClientGet(bw,sp,attack);
	}
	else if((range==RANGE_MINE)||(range==RANGE_MINE_DOUBLE)||(range==RANGE_NONE)||(range==RANGE_FIELD)){
		defence=attack;
	}
	else if(range==RANGE_TEDASUKE){
		{
			int	fight_type;

			fight_type=BattleWorkFightTypeGet(bw);

			if(fight_type&FIGHT_TYPE_2vs2){
				defence=BattleWorkPartnerClientNoGet(bw,attack);
			}
			else{
				defence=attack;
			}
		}
	}
	else if(range==RANGE_TUBOWOTUKU){
		{
			int	fight_type;

			fight_type=BattleWorkFightTypeGet(bw);

			if(fight_type&FIGHT_TYPE_2vs2){
				defence=sp->client_act_work[attack][ACT_PARA_CLIENT_NO];
				if(sp->psp[defence].hp==0){
					defence=attack;
				}
			}
			else{
				defence=attack;
			}
		}
	}
	else if((range==RANGE_RANDOM)||(flag==1)){
		{
			int	fight_type;
			int	dir;
			int	def[2];
//			int	wazatype;

			fight_type=BattleWorkFightTypeGet(bw);
			dir=BattleWorkMineEnemyCheck(bw,attack)^1;
			def[0]=BattleWorkEnemyClientNoGet(bw,attack,BWECNG_SIDE_RIGHT);
			def[1]=BattleWorkEnemyClientNoGet(bw,attack,BWECNG_SIDE_LEFT);

#if 0
			//m[}XĹAZ^Cvm[}ɂ
			if(ST_ServerTokuseiGet(sp,attack)==TOKUSYU_NOOMARUSUKIN){
				wazatype=NORMAL_TYPE;
			}
			else if(sp->waza_type){
				wazatype=sp->waza_type;
			}
			else{
				wazatype=sp->AIWT.wtd[waza_no].wazatype;
			}
#endif

			if(fight_type&FIGHT_TYPE_2vs2){
				//̂тƂ܂ꂪȂAI
				if((sp->scw[dir].konoyubitomare_flag)&&(sp->psp[sp->scw[dir].konoyubitomare_client].hp)){
					defence=sp->scw[dir].konoyubitomare_client;
				}
				//ȂA_őI
				else if((sp->psp[def[0]].hp)&&(sp->psp[def[1]].hp)){
					dir=gf_rand()&1;
					defence=def[dir];
#if 0	//`FbNꏊړ
					//Z^Cvł񂫂ŁAЂ炢ĂzAI
					if((wazatype==ELECTRIC_TYPE)&&
					   (ST_ServerTokuseiGet(sp,defence)!=TOKUSYU_HIRAISIN)&&
					   (ST_ServerKatayaburiTokuseiCheck(sp,attack,def[dir^1],TOKUSYU_HIRAISIN)==TRUE)){
						defence=def[dir^1];
						sp->ostf[defence].hiraisin_flag=1;
					}
					//Z^Cv݂ŁAт݂ĂzAI
					if((wazatype==WATER_TYPE)&&
					   (ST_ServerTokuseiGet(sp,defence)!=TOKUSYU_YOBIMIZU)&&
					   (ST_ServerKatayaburiTokuseiCheck(sp,attack,def[dir^1],TOKUSYU_YOBIMIZU)==TRUE)){
						defence=def[dir^1];
						sp->ostf[defence].yobimizu_flag=1;
					}
#endif
				}
				//ǂȂAI
				else if(sp->psp[def[0]].hp){
					defence=def[0];
				}
				else if(sp->psp[def[1]].hp){
					defence=def[1];
				}
			}
			else{
				if(sp->psp[attack^1].hp){
					defence=attack^1;
				}
			}
		}
	}
	else{
		{
			int	dir;
			int	def_no;
			int	client_set_max;
//			int	wazatype;

			dir=BattleWorkMineEnemyCheck(bw,attack)^1;
			def_no=sp->client_act_work[attack][ACT_PARA_CLIENT_NO];
			client_set_max=BattleWorkClientSetMaxGet(bw);

#if 0
			//m[}XĹAZ^Cvm[}ɂ
			if(ST_ServerTokuseiGet(sp,attack)==TOKUSYU_NOOMARUSUKIN){
				wazatype=NORMAL_TYPE;
			}
			else if(sp->waza_type){
				wazatype=sp->waza_type;
			}
			else{
				wazatype=sp->AIWT.wtd[waza_no].wazatype;
			}
#endif

			//̂тƂ܂ꂪȂAI
			if((sp->scw[dir].konoyubitomare_flag)&&(sp->psp[sp->scw[dir].konoyubitomare_client].hp)){
				defence=sp->scw[dir].konoyubitomare_client;
			}
			else{
#if 0	//`FbNꏊړ
				//Ԃł͂ȂƂ́AЂ炢Ƃт݂`FbN
				if(ST_ServerTokuseiGet(sp,attack)!=TOKUSYU_KATAYABURI){
					//Z^Cvł񂫂ŁAЂ炢ĂzAI
					if((wazatype==ELECTRIC_TYPE)&&
					   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_NOMINE_HP,attack,TOKUSYU_HIRAISIN))){
						for(def_no=0;def_no<client_set_max;def_no++){
							defence=sp->psp_agi_work[def_no];
							if((ST_ServerTokuseiGet(sp,defence)==TOKUSYU_HIRAISIN)&&
							   (sp->psp[defence].hp)&&
							   (attack!=defence)){
								break;
							}
						}
						if(defence!=sp->client_act_work[attack][ACT_PARA_CLIENT_NO]){
							sp->ostf[defence].hiraisin_flag=1;
						}
					}
					//Z^Cv݂ŁAт݂ĂzAI
					else if((wazatype==WATER_TYPE)&&
							(ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_NOMINE_HP,attack,TOKUSYU_YOBIMIZU))){
						for(def_no=0;def_no<client_set_max;def_no++){
							defence=sp->psp_agi_work[def_no];
							if((ST_ServerTokuseiGet(sp,defence)==TOKUSYU_YOBIMIZU)&&
							   (sp->psp[defence].hp)&&
							   (attack!=defence)){
								break;
							}
						}
						if(defence!=sp->client_act_work[attack][ACT_PARA_CLIENT_NO]){
							sp->ostf[defence].yobimizu_flag=1;
						}
					}
					//UΏۂC₵ĂAႤClientɃXCb`
					else if(sp->psp[def_no].hp){
						defence=def_no;
					}
					else{
						def_no=ST_ServerDirClientGet(bw,sp,attack);
						if(sp->psp[def_no].hp){
							defence=def_no;
						}
					}
				}
#endif
				//UΏۂC₵ĂAႤClientɃXCb`
//				else if(sp->psp[def_no].hp){
				if(sp->psp[def_no].hp){
					defence=def_no;
				}
				else{
					def_no=ST_ServerDirClientGet(bw,sp,attack);
					if(sp->psp[def_no].hp){
						defence=def_no;
					}
				}
			}
		}
	}

	return defence;
}

//============================================================================================
/**
 * @brief	UΏۂς̃`FbN
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	attack		UClientNo
 * @param[in]	waza_no		JoƂĂZ
 *
 * @retval	TRUE:UΏۂς@FALSE:UΏۂ̂܂
 */
//============================================================================================
void	ST_ServerDefenceClientTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int attack,u16 waza_no)
{
	int		dir;
	int		client;
	int		defence;
	int		wazatype;
	int		client_set_max;

	//ΏۂȂ΁A`FbNȂ
	if(sp->defence_client==NONE_CLIENT_NO){
		return;
	}

	//m[}XĹAZ^Cvm[}Ȃ̂ŁA`FbNȂ
	//Ԃ́A֌WȂZł̂ŁA`FbNȂ
	if((ST_ServerTokuseiGet(sp,attack)==TOKUSYU_NOOMARUSUKIN)||
	   (ST_ServerTokuseiGet(sp,attack)==TOKUSYU_KATAYABURI)){
		return;
	}
	dir=BattleWorkMineEnemyCheck(bw,attack)^1;
	//̂тƂ܂D悷̂ŁA`FbNȂ
	if((sp->scw[dir].konoyubitomare_flag)&&(sp->psp[sp->scw[dir].konoyubitomare_client].hp)){
		return;
	}

#if B1366_060815_FIX
	wazatype=ST_AIWazaTypeGet(bw,sp,attack,waza_no);
	if(wazatype==0){
		wazatype=sp->AIWT.wtd[waza_no].wazatype;
	}
#else //B1366_060815_FIX
	if(sp->waza_type){
		wazatype=sp->waza_type;
	}
	else{
		wazatype=sp->AIWT.wtd[waza_no].wazatype;
	}
#endif //B1366_060815_FIX

	client_set_max=BattleWorkClientSetMaxGet(bw);

	//Z^Cvł񂫂ŁAЂ炢ĂzAI
	if((wazatype==ELECTRIC_TYPE)&&
	  ((sp->AIWT.wtd[waza_no].attackrange==RANGE_NORMAL)||
	   (sp->AIWT.wtd[waza_no].attackrange==RANGE_RANDOM))&&
	  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_NOMINE_HP,attack,TOKUSYU_HIRAISIN))){
		for(client=0;client<client_set_max;client++){
			defence=sp->psp_agi_work[client];
			if((ST_ServerTokuseiGet(sp,defence)==TOKUSYU_HIRAISIN)&&
			   (sp->psp[defence].hp)&&
			   (attack!=defence)){
				break;
			}
		}
		if(defence!=sp->defence_client){
			sp->ostf[defence].hiraisin_flag=1;
			sp->defence_client=defence;
		}
	}
	//Z^Cv݂ŁAт݂ĂzAI
	else if((wazatype==WATER_TYPE)&&
		   ((sp->AIWT.wtd[waza_no].attackrange==RANGE_NORMAL)||
			(sp->AIWT.wtd[waza_no].attackrange==RANGE_RANDOM))&&
		   ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
			(ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_NOMINE_HP,attack,TOKUSYU_YOBIMIZU))){
		for(client=0;client<client_set_max;client++){
			defence=sp->psp_agi_work[client];
			if((ST_ServerTokuseiGet(sp,defence)==TOKUSYU_YOBIMIZU)&&
			   (sp->psp[defence].hp)&&
			   (attack!=defence)){
				break;
			}
		}
		if(defence!=sp->defence_client){
			sp->ostf[defence].yobimizu_flag=1;
			sp->defence_client=defence;
		}
	}
}

//============================================================================================
/**
 * @brief	UΏۂς̋N
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 *
 * @retval	TRUE:UΏۂς@FALSE:UΏۂ̂܂
 */
//============================================================================================
BOOL	ST_ServerDefenceClientTokuseiAct(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	BOOL	ret=FALSE;

	//Ђ炢`FbN
	if(((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
	    (sp->ostf[sp->defence_client].hiraisin_flag)){
	    sp->ostf[sp->defence_client].hiraisin_flag=0;
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HIRAISIN);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		ret=TRUE;
	}
	//т݂`FbN
	if(((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
	    (sp->ostf[sp->defence_client].yobimizu_flag)){
	    sp->ostf[sp->defence_client].yobimizu_flag=0;
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_HIRAISIN);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		ret=TRUE;
	}

	return ret;
}

//============================================================================================
/**
 *	PokemonServerParamKvȃf[^̂PokemonParamɏ߂
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	ǂݏclient_no
 */
//============================================================================================
void	ST_PSPtoPPCopy(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	//ACeĂȂȂAAIp̃[NNAĂ
	if(sp->psp[client_no].item==0){
		SoubiItemClear(sp,client_no);
	}
	SCIO_PSPtoPPCopy(bw,sp,client_no);
}

//============================================================================================
/**
 *	ߌñtO𗧂Ă
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	tO𗧂Ăclient_no
 */
//============================================================================================
void	ST_ServerKeepOn(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	sp->psp[client_no].condition2|=CONDITION2_KEEP;
	sp->waza_no_keep[client_no]=sp->waza_no_now;
}

//============================================================================================
/**
 *	ߌñtO𗎂Ƃ
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	tO𗎂Ƃclient_no
 */
//============================================================================================
void	ST_ServerKeepOff(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	sp->psp[client_no].condition2&=CONDITION2_KEEP_OFF;
	sp->psp[client_no].condition2&=CONDITION2_GAMAN_OFF;
	sp->psp[client_no].waza_kouka&=WAZAKOUKA_KIE_OFF;
	sp->psp[client_no].wkw.korogaru_count=0;
	sp->psp[client_no].wkw.renzokugiri_count=0;
}

//============================================================================================
/**
 *	RfBVAԈُio[Ԃ
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	Ԉُ`FbNclient_no
 */
//============================================================================================
int		ST_ServerConditionNoGet(SERVER_PARAM *sp,int client_no)
{
	if(sp->psp[client_no].condition&CONDITION_NEMURI){
		return STATUS_NEMURI;
	}
	else if(sp->psp[client_no].condition&CONDITION_DOKU){
		return STATUS_DOKU;
	}
	else if(sp->psp[client_no].condition&CONDITION_YAKEDO){
		return STATUS_YAKEDO;
	}
	else if(sp->psp[client_no].condition&CONDITION_KOORI){
		return STATUS_KOORI;
	}
	else if(sp->psp[client_no].condition&CONDITION_MAHI){
		return STATUS_MAHI;
	}
	else if(sp->psp[client_no].condition&CONDITION_DOKUDOKU){
		return STATUS_DOKU;
	}
	return STATUS_NORMAL;
}

//============================================================================================
/**
 *	퓬Ƀg[i[oĂĕ\郁bZ[W`FbÑV[PXio[
 */
//============================================================================================
enum{
	SEQ_STMC_FIRST_DAMAGE=0,
	SEQ_STMC_HP_HALF,
	SEQ_STMC_POKE_LAST,
	SEQ_STMC_POKE_LAST_HP_HALF,
	SEQ_STMC_END
};

//============================================================================================
/**
 *	퓬Ƀg[i[oĂĕ\郁bZ[W`FbN
 *
 * @param[in]	bw		퓬VXep[N\
 * @param[in]	sp		T[opp[^[N\
 */
//============================================================================================
BOOL	ST_ServerTrainerMessageCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	fight_type;
	int	tr_id;
	int seq_no;

	fight_type=BattleWorkFightTypeGet(bw);

	//ʐMΐAog^[́A肵Ȃ
	if(fight_type&(FIGHT_TYPE_SIO|FIGHT_TYPE_TOWER)){
		return FALSE;
	}
	//g[i[ł͂Ȃ΁A肵Ȃ
	if((fight_type&FIGHT_TYPE_TRAINER)==0){
		return FALSE;
	}

	//2vs2́A肵Ȃ
	if(fight_type&FIGHT_TYPE_2vs2){
		return FALSE;
	}

	tr_id=BattleWorkTrainerIDGet(bw,CLIENT_NO_ENEMY);
	seq_no=SEQ_STMC_FIRST_DAMAGE;

	do{
		switch(seq_no){
		//퓬F|Pɍŏ̃_[W^ƂîĂĂŏ1̂ɂ\j
		case SEQ_STMC_FIRST_DAMAGE:
			if((sp->psp[CLIENT_NO_ENEMY].hit_count==1)&&
//			  ((sp->psp[CLIENT_NO_ENEMY].message_flag&TRAINER_MESSAGE_FLAG_FIRST_DAMAGE)==0)){
			  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_FIRST_DAMAGE_MSG)==0)){
				if(TT_TrainerMessageCheck(tr_id,TRMSG_FIGHT_FIRST_DAMAGE,HEAPID_BATTLE)){
//					sp->psp[CLIENT_NO_ENEMY].message_flag|=TRAINER_MESSAGE_FLAG_FIRST_DAMAGE;
					sp->server_status_flag2|=SERVER_STATUS_FLAG2_FIRST_DAMAGE_MSG;
					sp->msg_work=TRMSG_FIGHT_FIRST_DAMAGE;
					return TRUE;
				}
			}
			seq_no++;
			break;
		//퓬F|P̂goȉ
		case SEQ_STMC_HP_HALF:
			if((sp->psp[CLIENT_NO_ENEMY].message_flag&TRAINER_MESSAGE_FLAG_POKE_HP_HALF)==0){
				if(sp->psp[CLIENT_NO_ENEMY].hp<=(sp->psp[CLIENT_NO_ENEMY].hpmax/2)){
					if(TT_TrainerMessageCheck(tr_id,TRMSG_FIGHT_POKE_HP_HALF,HEAPID_BATTLE)){
						sp->psp[CLIENT_NO_ENEMY].message_flag|=TRAINER_MESSAGE_FLAG_POKE_HP_HALF;
						sp->msg_work=TRMSG_FIGHT_POKE_HP_HALF;
						return TRUE;
					}
				}
			}
			seq_no++;
			break;
		//퓬F|PcPC
		case SEQ_STMC_POKE_LAST:
			if((sp->psp[CLIENT_NO_ENEMY].message_flag&TRAINER_MESSAGE_FLAG_POKE_LAST)==0){
				{
					int	i;
					int	cnt;
					POKEPARTY		*poke_party;
					POKEMON_PARAM	*pp;

					poke_party=BattleWorkPokePartyGet(bw,CLIENT_NO_ENEMY);
					cnt=0;
	
					for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
						pp=PokeParty_GetMemberPointer(poke_party,i);
						if(PokeParaGet(pp,ID_PARA_hp,NULL)){
							cnt++;
						}
					}
					if(cnt==1){
						if(TT_TrainerMessageCheck(tr_id,TRMSG_FIGHT_POKE_LAST,HEAPID_BATTLE)){
							sp->psp[CLIENT_NO_ENEMY].message_flag|=TRAINER_MESSAGE_FLAG_POKE_LAST;
							sp->msg_work=TRMSG_FIGHT_POKE_LAST;
							return TRUE;
						}
					}
				}
			}
			seq_no++;
			break;
		//퓬F|PcPCłgoȉ
		case SEQ_STMC_POKE_LAST_HP_HALF:
			if((sp->psp[CLIENT_NO_ENEMY].message_flag&TRAINER_MESSAGE_FLAG_POKE_LAST_HP_HALF)==0){
				{
					int	i;
					int	cnt;
					POKEPARTY		*poke_party;
					POKEMON_PARAM	*pp;

					poke_party=BattleWorkPokePartyGet(bw,CLIENT_NO_ENEMY);
					cnt=0;
	
					for(i=0;i<PokeParty_GetPokeCount(poke_party);i++){
						pp=PokeParty_GetMemberPointer(poke_party,i);
						if(PokeParaGet(pp,ID_PARA_hp,NULL)){
							cnt++;
						}
					}
					if((cnt==1)&&(sp->psp[CLIENT_NO_ENEMY].hp<=(sp->psp[CLIENT_NO_ENEMY].hpmax/2))){
						if(TT_TrainerMessageCheck(tr_id,TRMSG_FIGHT_POKE_LAST_HP_HALF,HEAPID_BATTLE)){
							sp->psp[CLIENT_NO_ENEMY].message_flag|=TRAINER_MESSAGE_FLAG_POKE_LAST_HP_HALF;
							sp->msg_work=TRMSG_FIGHT_POKE_LAST_HP_HALF;
							return TRUE;
						}
					}
				}
			}
			seq_no++;
			break;
		case SEQ_STMC_END:
			break;
		}
	}while(seq_no!=SEQ_STMC_END);

	return FALSE;
}

//============================================================================================
/**
 *	ServerWork̏
 *
 *	@param[in]	sp	T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerWorkInit(SERVER_PARAM *sp)
{
	int	client_no;

	sp->damage=0;							///<Zɂ_[W[N
	sp->critical=1;							///<NeBJqbg[N
	sp->critical_count=0;					///<NeBJ`FbNɎgpNeBJ̏o₷{[N
	sp->damage_power=0;						///<ZɂU̓[N
	sp->damage_value=10;					///<Zɂ_[W{[N
	sp->waza_type=0;						///<Z^Cv[N
	sp->waza_eff_cnt=0;						///<ZGtFNgJE^

	sp->waza_status_flag=0;					///<ZƂŕωtO

	sp->kizetsu_client=NONE_CLIENT_NO;		///<C₵ClientNo

	sp->add_status_flag_direct=0;			///<ڒǉʃtO
	sp->add_status_flag_indirect=0;			///<ԐڒǉʃtO
	sp->add_status_flag_tokusei=0;			///<ɂǉʃtO
	sp->tsuika_type=ADD_STATUS_NONE;		///<ǉʂ̎ށiځAԐځAj
	sp->tsuika_para=ADD_COND_NONE;			///<ǉʂ̎ށi˂ނA܂ЂƂj
	sp->tsuika_client=NONE_CLIENT_NO;		///<ǉʂNCAg

	sp->renzoku_count=0;					///<AUpJE^
	sp->renzoku_count_temp=0;				///<AUpJE^i\pj
	sp->client_loop=0;						///<̓ZJE^
	sp->loop_flag=0;						///<[vtO
	sp->swoam_type=0;						///<ServerWazaOutAfterMessagep^Cvio[i[[N
	sp->waza_out_check_on_off=0;			///<HITCHECKLtO
	sp->loop_hit_check=0;					///<[vHITCHECKLtO

	sp->fcc_seq_no=0;						///<FieldConditionCheckpV[PXio[i[[N
	sp->pcc_seq_no=0;						///<PokeConditionCheckpV[PXio[i[[N
	sp->scc_seq_no=0;						///<SideConditionCheckpV[PXio[i[[N
	sp->sba_seq_no=0;						///<ServerBeforeActpV[PXio[i[[N
	sp->swhac_seq_no=0;						///<ServerWazaHitAfterCheckpV[PXio[i[[N
	sp->swoam_seq_no=0;						///<ServerWazaOutAfterMessagepV[PXio[i[[N
	sp->swoak_seq_no=0;						///<ServerWazaOutAfterKoukapV[PXio[i[[N
	sp->wb_seq_no=0;						///<WazaBeforẽV[PXio[
	sp->woc_seq_no=0;						///<WazaOutCheck̃V[PXio[
	sp->ssc_seq_no=0;						///<ServerStatusCheck̃V[PXio[
	sp->stc_seq_no=0;						///<ServerTokuseiCheck̃V[PXio[

	sp->server_status_flag&=SERVER_STATUS_FLAG_ATTACK_TURN;	//̃^[LȃtO
	sp->server_status_flag2&=SERVER_STATUS_FLAG2_ATTACK_TURN;	//̃^[LȃtO

	sp->magnitude=0;						///<}Oj`[h̑傫

	for(client_no=0;client_no<CLIENT_MAX;client_no++){
		MI_CpuClearFast(&sp->ostf[client_no],sizeof(ONE_SELF_TURN_FLAG));		//̃^[̂ݐ\ȃ[NQ
		sp->ai_reshuffle_sel_mons_no[client_no]=6;
	}

}

//============================================================================================
/**
 *	JE^[N̏
 *
 *	@param[in]	sp	T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerCounterWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	fight_type;
	int	i;

	for(i=0;i<CLIENT_MAX;i++){
		sp->waza_no_hit_client[i]=NONE_CLIENT_NO;
		sp->reshuffle_sel_mons_no[i]=6;
		sp->agi_rand[i]=gf_rand();	///<f`FbNɎgp闐l
	}

	sp->okodukai_value=1;		///<̔{[N

	sp->sakidori_total_turn=1;	///<ǂp̃g[^^[JE^

	fight_type=BattleWorkFightTypeGet(bw);

	if((fight_type&FIGHT_TYPE_2vs2)==0){
		sp->no_reshuffle_client|=No2Bit(CLIENT_NO_MINE2);
		sp->no_reshuffle_client|=No2Bit(CLIENT_NO_ENEMY2);
	}

	sp->safari_get_count=	SAFARI_COUNT_FLAT;		///<Tt@̕ߊlJE^
	sp->safari_escape_count=SAFARI_COUNT_FLAT;		///<Tt@̓JE^
}

//============================================================================================
/**
 *	T[o[N̏i|Pւj
 *
 *	@param[in]	sp	T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerReshuffleWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int				i;
	int				client_set_max;
	u32				fight_type;
	u8				*adr;
	WAZA_KOUKA_WORK	wkw_temp;

	wkw_temp=sp->psp[client_no].wkw;
	client_set_max=BattleWorkClientSetMaxGet(bw);
	fight_type=BattleWorkFightTypeGet(bw);
	sp->client_act_work[client_no][ACT_PARA_ACT_NO]=SERVER_WAZA_END_NO;

	if((sp->server_status_flag&SERVER_STATUS_FLAG_BATON_TOUCH)==0){
		for(i=0;i<client_set_max;i++){
			//u낢܂ȂvAuN̂vւAʂ
			if((sp->psp[i].condition2&CONDITION2_KUROIMANAZASHI)&&(sp->psp[i].wkw.manazashi_client_no==client_no)){
				sp->psp[i].condition2&=CONDITION2_KUROIMANAZASHI_OFF;
			}
			//bNIւAʂ
			if((sp->psp[i].waza_kouka&WAZAKOUKA_LOCKON)&&(sp->psp[i].wkw.lockon_client_no==client_no)){
				sp->psp[i].waza_kouka&=WAZAKOUKA_LOCKON_OFF;
				sp->psp[i].wkw.lockon_client_no=0;
			}
		}
		sp->psp[client_no].condition2=0;
		sp->psp[client_no].waza_kouka=0;
	}
	else{
		sp->psp[client_no].condition2&=CONDITION2_BATON_TOUCH_ON;
		sp->psp[client_no].waza_kouka&=WAZAKOUKA_BATON_TOUCH_ON;
		for(i=0;i<client_set_max;i++){
			//bNIog^b`AJE^ɖ߂Čʂp
			if((sp->psp[i].waza_kouka&WAZAKOUKA_LOCKON)&&(sp->psp[i].wkw.lockon_client_no==client_no)){
				sp->psp[i].waza_kouka&=WAZAKOUKA_LOCKON_OFF;
				sp->psp[i].waza_kouka|=(LOCKON_COUNT*2);
			}
		}
	}

	for(i=0;i<client_set_max;i++){
	//uvւAʂ
		if(sp->psp[i].condition2&(No2Bit(client_no)<<MEROMERO_SHIFT)){
			sp->psp[i].condition2&=((No2Bit(client_no)<<MEROMERO_SHIFT)^0xffffffff);
		}
	//ߌn̋ZւAʂ
		if((sp->psp[i].condition2&CONDITION2_SHIME)&&(sp->psp[i].wkw.shime_client_no==client_no)){
			sp->psp[i].condition2&=CONDITION2_SHIME_OFF;
		}
	}

	adr=(u8 *)&sp->psp[client_no].wkw;
	for(i=0;i<sizeof(WAZA_KOUKA_WORK);i++){
		adr[i]=0;
	}
	if(sp->server_status_flag&SERVER_STATUS_FLAG_BATON_TOUCH){
		sp->psp[client_no].wkw.migawari_hp=			wkw_temp.migawari_hp;
		sp->psp[client_no].wkw.lockon_client_no=	wkw_temp.lockon_client_no;
		sp->psp[client_no].wkw.horobinouta_count=	wkw_temp.horobinouta_count;
		sp->psp[client_no].wkw.manazashi_client_no=	wkw_temp.manazashi_client_no;
		sp->psp[client_no].wkw.denzihuyuu_count=	wkw_temp.denzihuyuu_count;
		sp->psp[client_no].wkw.shutout_count=		wkw_temp.shutout_count;
		sp->psp[client_no].wkw.healblock_count=		wkw_temp.healblock_count;
	}

	sp->psp[client_no].wkw.nekodamashi_count=sp->total_turn+1;		//lR܂JE^
	sp->psp[client_no].wkw.slow_start_count=sp->total_turn+1;		//X[X^[gJE^
	//Ȃ܂^[iEjZbg
	sp->psp[client_no].wkw.namake_bit=(sp->total_turn+1)&1;

	sp->waza_no_mamoru[client_no]=0;					///<1^[OɌJoĂZǂi܂pj
	sp->waza_no_hit[client_no]=0;						///<1^[OɌJoĂZ󂯂ǂ
	sp->waza_no_hit_client[client_no]=NONE_CLIENT_NO;	///<1^[OɌJoĂZ𔭓ClientNo
	sp->waza_no_hit_type[client_no]=0;					///<1^[OɃqbgZ̃^Cv
	sp->waza_no_old[client_no]=0;						///<1^[OɌJoĂZ
	sp->waza_no_oumu[client_no]=0;						///<OɎ󂯂Zi[iIEpj
	sp->waza_no_oumu_hit[client_no][0]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][1]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][2]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][3]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_sketch[client_no]=0;					///<XPb`p̋Zio[[N
#if GB002_060815_FIX
	sp->waza_no_texture2[client_no]=0;					///<1^[OɌJoĂZ󂯂ǂieNX`[Qpj
	sp->waza_no_texture2_client[client_no]=0;			///<1^[OɌJoĂZ𔭓ClientieNX`[Qpj
	sp->waza_no_texture2_type[client_no]=0;				///<1^[OɌJoĂZ̃^CvieNX`[Qpj
#endif //GB002_060815_FIX
#if GB003_060815_FIX
	sp->waza_no_metronome[client_no]=0;					///<gm[pZ[N
#endif //GB003_060815_FIX

#if B1371_060815_FIX
	sp->field_condition&=((No2Bit(client_no)<<FIELD_SAWAGU_SHIFT)^0xffffffff);	//킮tO𗎂Ƃ
#endif B1371_060815_FIX

	//p[gbNtOĂꍇ́AUƖh̒lւ
	if(sp->psp[client_no].waza_kouka&WAZAKOUKA_POWER_TRICK){
		i=sp->psp[client_no].pow;
		sp->psp[client_no].pow=sp->psp[client_no].def;
		sp->psp[client_no].def=i;
	}

///<C⎞̊mFĂ鎞ɓւ̕s𔭌̂
///<̃[NNA悤ɏCiGBłƓdlɂȂ܂j
	for(i=0;i<client_set_max;i++){
		if((i!=client_no)&&(BattleWorkMineEnemyCheck(bw,i)!=BattleWorkMineEnemyCheck(bw,client_no))){
			sp->waza_no_oumu[i]=0;
		}
		sp->waza_no_oumu_hit[i][client_no]=0;
	}

	WazaNoStockClear(sp,client_no);		//AIp̋Zio[XgbN[NNA
	TokusyuNoClear(sp,client_no);		//AIp̓io[[NNA
	SoubiItemClear(sp,client_no);		//AIp̑ACeio[[NNA
}

//============================================================================================
/**
 *	T[o[N̏i|PC⎞j
 *
 *	@param[in]	sp	T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerKizetsuWorkInit(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int				i;
	int				client_set_max;
	u8				*adr;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(i=COND_HP;i<COND_MAX;i++){
		sp->psp[client_no].abiritycnt[i]=6;
	}

	sp->psp[client_no].condition2=0;
	sp->psp[client_no].waza_kouka=0;

	//u낢܂ȂvAuN̂vC₵Aʂ
	for(i=0;i<client_set_max;i++){
		if((sp->psp[i].condition2&CONDITION2_KUROIMANAZASHI)&&(sp->psp[i].wkw.manazashi_client_no==client_no)){
			sp->psp[i].condition2&=CONDITION2_KUROIMANAZASHI_OFF;
		}
	//uvւAʂ
		if(sp->psp[i].condition2&(No2Bit(client_no)<<MEROMERO_SHIFT)){
			sp->psp[i].condition2&=((No2Bit(client_no)<<MEROMERO_SHIFT)^0xffffffff);
		}
	//ߌn̋ZւAʂ
		if((sp->psp[i].condition2&CONDITION2_SHIME)&&(sp->psp[i].wkw.shime_client_no==client_no)){
			sp->psp[i].condition2&=CONDITION2_SHIME_OFF;
		}
	}

	//̃^[ɂĂʌnSď
	adr=(u8 *)&sp->psp[client_no].wkw;
	for(i=0;i<sizeof(WAZA_KOUKA_WORK);i++){
		adr[i]=0;
	}

	adr=(u8 *)&sp->otf[client_no];
	for(i=0;i<sizeof(ONE_TURN_FLAG);i++){
		adr[i]=0;
	}

	sp->psp[client_no].wkw.nekodamashi_count=sp->total_turn+1;		//lR܂JE^
	sp->psp[client_no].wkw.slow_start_count=sp->total_turn+1;		//X[X^[gJE^
	//Ȃ܂^[iEjZbg
	sp->psp[client_no].wkw.namake_bit=(sp->total_turn+1)&1;

	sp->waza_no_mamoru[client_no]=0;						///<1^[OɌJoĂZǂi܂pj
	sp->waza_no_hit[client_no]=0;						///<1^[OɌJoĂZ󂯂ǂ
	sp->waza_no_hit_client[client_no]=NONE_CLIENT_NO;	///<1^[OɌJoĂZ𔭓ClientNo
	sp->waza_no_hit_type[client_no]=0;					///<1^[OɃqbgZ̃^Cv
	sp->waza_no_old[client_no]=0;						///<1^[OɌJoĂZ
	sp->waza_no_oumu[client_no]=0;						///<OɎ󂯂Zi[iIEpj
	sp->waza_no_oumu_hit[client_no][0]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][1]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][2]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_oumu_hit[client_no][3]=0;				///<OɎ󂯂Zi[i2vs2̃IEpj
	sp->waza_no_sketch[client_no]=0;					///<XPb`p̋Zio[[N
#if GB002_060815_FIX
	sp->waza_no_texture2[client_no]=0;					///<1^[OɌJoĂZ󂯂ǂieNX`[Qpj
	sp->waza_no_texture2_client[client_no]=0;			///<1^[OɌJoĂZ𔭓ClientieNX`[Qpj
	sp->waza_no_texture2_type[client_no]=0;				///<1^[OɌJoĂZ̃^CvieNX`[Qpj
#endif //GB002_060815_FIX
#if GB003_060815_FIX
	sp->waza_no_metronome[client_no]=0;					///<gm[pZ[N
#endif //GB003_060815_FIX

#if B1371_060815_FIX
	sp->field_condition&=((No2Bit(client_no)<<FIELD_SAWAGU_SHIFT)^0xffffffff);	//킮tO𗎂Ƃ
#endif B1371_060815_FIX

///<C⎞̊mFĂ鎞ɓւ̕s𔭌̂
///<̃[NNA悤ɏCiGBłƓdlɂȂ܂j
	for(i=0;i<client_set_max;i++){
		if((i!=client_no)&&(BattleWorkMineEnemyCheck(bw,i)!=BattleWorkMineEnemyCheck(bw,client_no))){
			sp->waza_no_oumu[i]=0;
		}
		sp->waza_no_oumu_hit[i][client_no]=0;
	}

	//ւŋC₵Ăꍇ́AꂩtOςȂȂ̂ŁAƂ
	sp->client_status[client_no]&=CLIENT_STATUS_POKE_RESHUFFLE_OFF;

	WazaNoStockClear(sp,client_no);		//AIp̋Zio[XgbN[NNA
	TokusyuNoClear(sp,client_no);		//AIp̓io[[NNA
	SoubiItemClear(sp,client_no);		//AIp̑ACeio[[NNA
}

//============================================================================================
/**
 *	P^[LȃtO
 *
 * @param[in]	sp		T[op[^̍\̃|C^
 */
//============================================================================================
void	ST_ServerOneTurnFlagInit(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;

	for(client_no=0;client_no<CLIENT_MAX;client_no++){
		MI_CpuClearFast(&sp->otf[client_no],sizeof(ONE_TURN_FLAG));
		MI_CpuClearFast(&sp->wocf[client_no],sizeof(WAZA_OUT_CHECK_FLAG));
		sp->psp[client_no].condition2&=CONDITION2_HIRUMU_OFF;
		if(sp->psp[client_no].wkw.handou_count+1<sp->total_turn){
			sp->psp[client_no].condition2&=CONDITION2_HANDOU_OFF;
		}
		//Ă鎞ɏoAߋZńA߂͂i˂Ƒ΍j
		if((sp->psp[client_no].condition&CONDITION_NEMURI)&&(sp->psp[client_no].condition2&CONDITION2_KEEP)){
			ST_ServerKeepOff(bw,sp,client_no);
		}
		if((sp->psp[client_no].condition&CONDITION_NEMURI)&&(sp->psp[client_no].condition2&CONDITION2_ABARERU)){
			sp->psp[client_no].condition2&=CONDITION2_ABARERU_OFF;
		}
	}
	//̂тƂ܂tONA
	sp->scw[0].konoyubitomare_flag=0;
	sp->scw[1].konoyubitomare_flag=0;
}

//============================================================================================
/**
 *	邠ɂȂ邩`FbN
 *
 * @param[in]	bw				퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	`FbNClientNo
 * @param[in]	check_bit	`FbN鍀ځibattle_common.hɒ`j
 */
//============================================================================================
int		ST_ServerWaruagakiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_bit,int check_bit)
{
	int	pos;
	int	eqp;

	eqp=ST_ServerSoubiEqpGet(sp,client_no);

	for(pos=0;pos<4;pos++){
		//킴Ȃ
		if((sp->psp[client_no].waza[pos]==0)&&(check_bit&SSWC_WAZA_NONE)){
			waza_bit|=No2Bit(pos);
		}
		//PPȂ
		if((sp->psp[client_no].pp[pos]==0)&&(check_bit&SSWC_PP_NONE)){
			waza_bit|=No2Bit(pos);
		}
		//Ȃ΂肳Ă
		if((sp->psp[client_no].waza[pos]==sp->psp[client_no].wkw.kanashibari_wazano)&&(check_bit&SSWC_KANASHIBARI)){
			waza_bit|=No2Bit(pos);
		}
		//Ă
		if((sp->psp[client_no].waza[pos]==sp->waza_no_old[client_no])&&(check_bit&SSWC_ICHAMON)&&
		   (sp->psp[client_no].condition2&CONDITION2_ICHAMON)){
			waza_bit|=No2Bit(pos);
		}
		//傤͂Ă
		if((sp->psp[client_no].wkw.chouhatsu_count)&&(check_bit&SSWC_CHOUHATSU)&&
//	   	   (WT_WazaDataParaGet(sp->psp[client_no].waza[pos],ID_WTD_damage)==0)){
	   	   (sp->AIWT.wtd[sp->psp[client_no].waza[pos]].damage==0)){
			waza_bit|=No2Bit(pos);
		}
		//ӂ񂳂Ă
		if((ST_ServerHuuinCheck(bw,sp,client_no,sp->psp[client_no].waza[pos]))&&(check_bit&SSWC_HUUIN)){
			waza_bit|=No2Bit(pos);
		}
		//イ傭󂯂Ă
		if((ST_ServerJuuryokuCheck(bw,sp,client_no,sp->psp[client_no].waza[pos]))&&(check_bit&SSWC_JUURYOKU)){
			waza_bit|=No2Bit(pos);
		}
		//q[ubN󂯂Ă
		if((ST_ServerHealblockCheck(bw,sp,client_no,sp->psp[client_no].waza[pos]))&&(check_bit&SSWC_HEALBLOCK)){
			waza_bit|=No2Bit(pos);
		}
		//AR[
		if((sp->psp[client_no].wkw.encore_wazano)&&(sp->psp[client_no].wkw.encore_wazano!=sp->psp[client_no].waza[pos])){
			waza_bit|=No2Bit(pos);
		}
		//n`}L`FbN
		if(((eqp==SOUBI_ONAZIWAZAONLY)||(eqp==SOUBI_ONAZIWAZAONLYSUBAYASAUP)||(eqp==SOUBI_ONAZIAWZAONLYTOKUSYUUP))&&
		    (check_bit&SSWC_KODAWARI)){
			//ZYłn`}Lñ[NɊi[ZĂȂ`FbN
			if(ST_ServerWazaPosGet(&sp->psp[client_no],sp->psp[client_no].wkw.kodawari_wazano)==WAZA_TEMOTI_MAX){
				sp->psp[client_no].wkw.kodawari_wazano=0;
			}
			else{
				if((sp->psp[client_no].wkw.kodawari_wazano)&&
				   (sp->psp[client_no].wkw.kodawari_wazano!=sp->psp[client_no].waza[pos])){
					waza_bit|=No2Bit(pos);
				}
			}
		}
	}
	return waza_bit;
}

//============================================================================================
/**
 *	IZoƂo邩`FbN
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	waza_no		|WV擾Zio[
 *
 * @retval	TRUE:o@FALSE:oȂ
 */
//============================================================================================
BOOL	ST_ServerWazaNGCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int pos,MESSAGE_PARAM *mp)
{
	BOOL	ret;

	ret=TRUE;

	//Ȃ΂`FbN
	if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_KANASHIBARI)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK_WAZA;
		mp->msg_id=KanashibariNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		mp->msg_para[1]=sp->psp[client_no].waza[pos];
		ret=FALSE;
	}
	//`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_ICHAMON)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK;
		mp->msg_id=IchamonNGMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		ret=FALSE;
	}
	//傤͂`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_CHOUHATSU)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK_WAZA;
		mp->msg_id=ChouhatsuNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		mp->msg_para[1]=sp->psp[client_no].waza[pos];
		ret=FALSE;
	}
	//ӂ`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_HUUIN)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK_WAZA;
		mp->msg_id=HuuinNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		mp->msg_para[1]=sp->psp[client_no].waza[pos];
		ret=FALSE;
	}
	//イ傭`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_JUURYOKU)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK_WAZA;
		mp->msg_id=JuuryokuNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		mp->msg_para[1]=sp->psp[client_no].waza[pos];
		ret=FALSE;
	}
	//q[ubN`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_HEALBLOCK)&No2Bit(pos)){
		mp->msg_tag=TAG_NICK_WAZA_WAZA;
		mp->msg_id=HealblockNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,client_no);
		mp->msg_para[1]=WAZANO_KAIHUKUHUUZI;
		mp->msg_para[2]=sp->psp[client_no].waza[pos];
		ret=FALSE;
	}
	//n`}L`FbN
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_KODAWARI)&No2Bit(pos)){
		mp->msg_tag=TAG_ITEM_WAZA;
		mp->msg_id=ItemOnaziWazaOnlyMsg;
		mp->msg_para[0]=sp->psp[client_no].item;
		mp->msg_para[1]=sp->psp[client_no].wkw.kodawari_wazano;
		ret=FALSE;
	}
	//PP`FbNíAȂ炸Ōɂj
	else if(ST_ServerWaruagakiCheck(bw,sp,client_no,0,SSWC_PP_NONE)&No2Bit(pos)){
		mp->msg_tag=TAG_NONE;
		mp->msg_id=PPNoneMsg;
		ret=FALSE;
	}

	return ret;
}

//============================================================================================
/**
 *	Z̃|WV擾
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	waza_no		|WV擾Zio[
 */
//============================================================================================
int	ST_ServerWazaPosGet(POKEMON_SERVER_PARAM *psp,u16 waza_no)
{
	int	pos;

	for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
		if(psp->waza[pos]==waza_no){
			break;
		}
	}

	return pos;
}

//============================================================================================
/**
 *	Zƃ|P̑`FbNpe[u
 */
//============================================================================================
#define	KOUKANAI	(0)
#define	IMAHITOTSU	(5)
#define	BATSUGUN	(20)

enum{
	WAZA_TYPE=0,
	POKE_TYPE,
	POWER
};

static	const	u8	TypeCheckTable[][3]={
	{NORMAL_TYPE,	IWA_TYPE,		IMAHITOTSU},	// NORMAL  IWA ɍUƁA
													// З͂ODT{
	{NORMAL_TYPE,	METAL_TYPE,		IMAHITOTSU},

	{FIRE_TYPE,		FIRE_TYPE,		IMAHITOTSU},
	{FIRE_TYPE,		WATER_TYPE,		IMAHITOTSU},
	{FIRE_TYPE,		KUSA_TYPE,		BATSUGUN},	
	{FIRE_TYPE,		KOORI_TYPE,		BATSUGUN},	
	{FIRE_TYPE,		MUSHI_TYPE,		BATSUGUN},
	{FIRE_TYPE,		IWA_TYPE,		IMAHITOTSU},
	{FIRE_TYPE,		DRAGON_TYPE,	IMAHITOTSU},
	{FIRE_TYPE,		METAL_TYPE,		BATSUGUN},

	{WATER_TYPE,	FIRE_TYPE,		BATSUGUN},
	{WATER_TYPE,	WATER_TYPE,		IMAHITOTSU},
	{WATER_TYPE,	KUSA_TYPE,		IMAHITOTSU},
	{WATER_TYPE,	JIMEN_TYPE,		BATSUGUN},
	{WATER_TYPE,	IWA_TYPE,		BATSUGUN},
	{WATER_TYPE,	DRAGON_TYPE,	IMAHITOTSU},

	{ELECTRIC_TYPE,	WATER_TYPE,		BATSUGUN},
	{ELECTRIC_TYPE,	ELECTRIC_TYPE,	IMAHITOTSU},
	{ELECTRIC_TYPE,	KUSA_TYPE,		IMAHITOTSU},
	{ELECTRIC_TYPE,	JIMEN_TYPE,		KOUKANAI},
	{ELECTRIC_TYPE,	HIKOU_TYPE,		BATSUGUN},
	{ELECTRIC_TYPE,	DRAGON_TYPE,	IMAHITOTSU},

	{KUSA_TYPE,		FIRE_TYPE,		IMAHITOTSU},
	{KUSA_TYPE,		WATER_TYPE,		BATSUGUN},
	{KUSA_TYPE,		KUSA_TYPE,		IMAHITOTSU},
	{KUSA_TYPE,		POISON_TYPE,	IMAHITOTSU},
	{KUSA_TYPE,		JIMEN_TYPE,		BATSUGUN},
	{KUSA_TYPE,		HIKOU_TYPE,		IMAHITOTSU},
	{KUSA_TYPE,		MUSHI_TYPE,		IMAHITOTSU},
	{KUSA_TYPE,		IWA_TYPE,		BATSUGUN},
	{KUSA_TYPE,		DRAGON_TYPE,	IMAHITOTSU},
	{KUSA_TYPE,		METAL_TYPE,		IMAHITOTSU},

	{KOORI_TYPE,	WATER_TYPE,		IMAHITOTSU},
	{KOORI_TYPE,	KUSA_TYPE,		BATSUGUN},
	{KOORI_TYPE,	KOORI_TYPE,		IMAHITOTSU},
	{KOORI_TYPE,	JIMEN_TYPE,		BATSUGUN},
	{KOORI_TYPE,	HIKOU_TYPE,		BATSUGUN},
	{KOORI_TYPE,	DRAGON_TYPE,	BATSUGUN},
	{KOORI_TYPE,	METAL_TYPE,		IMAHITOTSU},
	{KOORI_TYPE,	FIRE_TYPE,		IMAHITOTSU},

	{BATTLE_TYPE,	NORMAL_TYPE,	BATSUGUN},
	{BATTLE_TYPE,	KOORI_TYPE,		BATSUGUN},
	{BATTLE_TYPE,	POISON_TYPE,	IMAHITOTSU},
	{BATTLE_TYPE,	HIKOU_TYPE,		IMAHITOTSU},
	{BATTLE_TYPE,	SP_TYPE,		IMAHITOTSU},
	{BATTLE_TYPE,	MUSHI_TYPE,		IMAHITOTSU},
	{BATTLE_TYPE,	IWA_TYPE,		BATSUGUN},
	{BATTLE_TYPE,	AKU_TYPE,		BATSUGUN},
	{BATTLE_TYPE,	METAL_TYPE,		BATSUGUN},

	{POISON_TYPE,	KUSA_TYPE,		BATSUGUN},
	{POISON_TYPE,	POISON_TYPE,	IMAHITOTSU},
	{POISON_TYPE,	JIMEN_TYPE,		IMAHITOTSU},
	{POISON_TYPE,	IWA_TYPE,		IMAHITOTSU},
	{POISON_TYPE,	GHOST_TYPE,		IMAHITOTSU},
	{POISON_TYPE,	METAL_TYPE,		KOUKANAI},

	{JIMEN_TYPE,	FIRE_TYPE,		BATSUGUN},
	{JIMEN_TYPE,	ELECTRIC_TYPE,	BATSUGUN},
	{JIMEN_TYPE,	KUSA_TYPE,		IMAHITOTSU},
	{JIMEN_TYPE,	POISON_TYPE,	BATSUGUN},
	{JIMEN_TYPE,	HIKOU_TYPE,		KOUKANAI},
	{JIMEN_TYPE,	MUSHI_TYPE,		IMAHITOTSU},
	{JIMEN_TYPE,	IWA_TYPE,		BATSUGUN},
	{JIMEN_TYPE,	METAL_TYPE,		BATSUGUN},

	{HIKOU_TYPE,	ELECTRIC_TYPE,	IMAHITOTSU},
	{HIKOU_TYPE,	KUSA_TYPE,		BATSUGUN},
	{HIKOU_TYPE,	BATTLE_TYPE,	BATSUGUN},
	{HIKOU_TYPE,	MUSHI_TYPE,		BATSUGUN},
	{HIKOU_TYPE,	IWA_TYPE,		IMAHITOTSU},
	{HIKOU_TYPE,	METAL_TYPE,		IMAHITOTSU},

	{SP_TYPE,		BATTLE_TYPE,	BATSUGUN},
	{SP_TYPE,		POISON_TYPE,	BATSUGUN},
	{SP_TYPE,		SP_TYPE,		IMAHITOTSU},
	{SP_TYPE,		AKU_TYPE,		KOUKANAI},
	{SP_TYPE,		METAL_TYPE,		IMAHITOTSU},	

	{MUSHI_TYPE,	FIRE_TYPE,		IMAHITOTSU},
	{MUSHI_TYPE,	KUSA_TYPE,		BATSUGUN},
	{MUSHI_TYPE,	BATTLE_TYPE,	IMAHITOTSU},
	{MUSHI_TYPE,	POISON_TYPE,	IMAHITOTSU},
	{MUSHI_TYPE,	HIKOU_TYPE,		IMAHITOTSU},
	{MUSHI_TYPE,	SP_TYPE,		BATSUGUN},
	{MUSHI_TYPE,	GHOST_TYPE,		IMAHITOTSU},
	{MUSHI_TYPE,	AKU_TYPE,		BATSUGUN},
	{MUSHI_TYPE,	METAL_TYPE,		IMAHITOTSU},

	{IWA_TYPE,		FIRE_TYPE,		BATSUGUN},
	{IWA_TYPE,		KOORI_TYPE,		BATSUGUN},
	{IWA_TYPE,		BATTLE_TYPE,	IMAHITOTSU},
	{IWA_TYPE,		JIMEN_TYPE,		IMAHITOTSU},
	{IWA_TYPE,		HIKOU_TYPE,		BATSUGUN},
	{IWA_TYPE,		MUSHI_TYPE,		BATSUGUN},
	{IWA_TYPE,		METAL_TYPE,		IMAHITOTSU},

	{GHOST_TYPE,	NORMAL_TYPE,	KOUKANAI},
	{GHOST_TYPE,	SP_TYPE,		BATSUGUN},
	{GHOST_TYPE,	AKU_TYPE,		IMAHITOTSU},
	{GHOST_TYPE,	METAL_TYPE,		IMAHITOTSU},
	{GHOST_TYPE,	GHOST_TYPE,		BATSUGUN},	

	{DRAGON_TYPE,	DRAGON_TYPE,	BATSUGUN},
	{DRAGON_TYPE,	METAL_TYPE,		IMAHITOTSU},

	{AKU_TYPE,		BATTLE_TYPE,	IMAHITOTSU},
	{AKU_TYPE,		SP_TYPE,		BATSUGUN},
	{AKU_TYPE,		GHOST_TYPE,		BATSUGUN},
	{AKU_TYPE,		AKU_TYPE,		IMAHITOTSU},
	{AKU_TYPE,		METAL_TYPE,		IMAHITOTSU},

	{METAL_TYPE,	FIRE_TYPE,		IMAHITOTSU},
	{METAL_TYPE,	WATER_TYPE,		IMAHITOTSU},
	{METAL_TYPE,	ELECTRIC_TYPE,	IMAHITOTSU},
	{METAL_TYPE,	KOORI_TYPE,		BATSUGUN},
	{METAL_TYPE,	IWA_TYPE,		BATSUGUN},
	{METAL_TYPE,	METAL_TYPE,		IMAHITOTSU},

	{0xfe,			0xfe,			KOUKANAI},	// miyaburi check

	{NORMAL_TYPE,	GHOST_TYPE,		KOUKANAI},
	{BATTLE_TYPE,	GHOST_TYPE,		KOUKANAI},

	{0xff,			0xff,			KOUKANAI},
};


//============================================================================================
/**
 *	ʂȂ|P̑𓖂ĂZʂ̃`FbN
 *
 * @param[in]	sp				T[op[^̍\̃|C^
 * @param[in]	attack_client	UClientNo
 * @param[in]	defence_client	h䑤ClientNo
 * @param[in]	pos				TypeCheckTableIndex
 *
 * @retval	FALSE:@TRUE:ʂȂ܂܂OK
 */
//============================================================================================
static	BOOL	ST_KoukanaiCheck(SERVER_PARAM *sp,int attack_client,int defence_client,int pos)
{
	BOOL	ret;
	int		eqp;

	eqp=ST_ServerSoubiEqpGet(sp,defence_client);

	ret=TRUE;

	//˂͂`FbN
	//ʂ΂₳DOWN
	if((eqp==SOUBI_SUBAYASADOWN)||(sp->psp[defence_client].waza_kouka&WAZAKOUKA_NEWOHARU)){
		//ЂɃqbg
		if((TypeCheckTable[pos][POKE_TYPE]==HIKOU_TYPE)&&
		   (TypeCheckTable[pos][POWER]==KOUKANAI)){
			ret=FALSE;
		}
	}
	//͂˂₷߃`FbN
	if(sp->otf[defence_client].haneyasume_flag){
		//ЂɃqbg(1{łĂj
		if(TypeCheckTable[pos][POKE_TYPE]==HIKOU_TYPE){
			ret=FALSE;
		}
	}
	//イ傭`FbN
	if(sp->field_condition&FIELD_CONDITION_JUURYOKU){
		//ЂɃqbg
		if((TypeCheckTable[pos][POKE_TYPE]==HIKOU_TYPE)&&
		   (TypeCheckTable[pos][POWER]==KOUKANAI)){
			ret=FALSE;
		}
	}
	//~NAC`FbN
	if(sp->psp[defence_client].waza_kouka&WAZAKOUKA_MIRACLE_EYE){
		//Ƀqbg
		if((TypeCheckTable[pos][POKE_TYPE]==AKU_TYPE)&&
		   (TypeCheckTable[pos][POWER]==KOUKANAI)){
			ret=FALSE;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	Zƃ|P̑`FbN
 *
 * @param[in]	bw				퓬VXep[N\
 * @param[in]	sp				T[op[^̍\̃|C^
 * @param[in]	waza_no			`FbNZ
 * @param[in]	attack_client	UClientNo
 * @param[in]	defence_client	h䑤ClientNo
 * @param[out]	damage			~ςĂ_[W
 * @param[out]	flag			`FbNʂ̃tOi[郏[N
 */
//============================================================================================
int	ST_ServerTypeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int waza_no,int waza_type,int attack_client,int defence_client,int damage,u32 *flag)
{
	int	i;
	int	bairitu;
	u8	wazatype;
	u32	waza_damage;
	u8	eqp_a;
	u8	eqp_d;
	u8	atk_a;
	u8	atk_d;

	bairitu=1;
	
	//邠́AȂ̂TypeCheckȂ
	if(waza_no==WAZANO_WARUAGAKI){
		return damage;
	}

	eqp_a=ST_ServerSoubiEqpGet(sp,attack_client);
	atk_a=ST_ServerSoubiAtkGet(sp,attack_client,ATK_CHECK_NORMAL);
	eqp_d=ST_ServerSoubiEqpGet(sp,defence_client);
	atk_d=ST_ServerSoubiAtkGet(sp,defence_client,ATK_CHECK_NORMAL);

	//m[}XĹAZ^Cvm[}ɂ
	if(ST_ServerTokuseiGet(sp,attack_client)==TOKUSYU_NOOMARUSUKIN){
		wazatype=NORMAL_TYPE;
	}
	else if(waza_type){
		wazatype=waza_type;
	}
	else{
//		wazatype=WT_WazaDataParaGet(waza_no,ID_WTD_wazatype);
		wazatype=sp->AIWT.wtd[waza_no].wazatype;
	}

//	waza_damage=WT_WazaDataParaGet(waza_no,ID_WTD_damage);
	waza_damage=sp->AIWT.wtd[waza_no].damage;

	if(((sp->server_status_flag&SERVER_STATUS_FLAG_TYPE_FLAT)==0)&&
	   ((ST_ServerPokemonServerParamGet(sp,attack_client,ID_PSP_type1,NULL)==wazatype)||
		(ST_ServerPokemonServerParamGet(sp,attack_client,ID_PSP_type2,NULL)==wazatype))){
		//Ă傭́A^CvvA1.5{2{ɂ
		if(ST_ServerTokuseiGet(sp,attack_client)==TOKUSYU_TEKIOURYOKU){
			damage*=2;
		}
		else{
			damage=damage*15/10;
		}
	}

	//ʂӂ䂤ɂ́A߂^Cv̋Z͓ȂiʂőfDOWN̓qbgj
	if((ST_ServerKatayaburiTokuseiCheck(sp,attack_client,defence_client,TOKUSYU_HUYUU)==TRUE)&&
  	   (wazatype==JIMEN_TYPE)&&
	   (eqp_d!=SOUBI_SUBAYASADOWN)){
		flag[0]|=WAZA_STATUS_FLAG_JIMEN_NOHIT;
	}
	//Zʂł񂶂ӂ䂤ɂ́A߂^Cv̋Z͓Ȃiイ傭́Ał񂶂ӂ䂤𖳌ɂj
	//iʂőfDOWN̓qbgj
	else if((sp->psp[defence_client].wkw.denzihuyuu_count)&&
		   ((sp->psp[defence_client].waza_kouka&WAZAKOUKA_NEWOHARU)==0)&&
			(wazatype==JIMEN_TYPE)&&
			(eqp_d!=SOUBI_SUBAYASADOWN)){
		flag[0]|=WAZA_STATUS_FLAG_DENZIHUYUU_NOHIT;
	}
	else{
		i=0;
		while(TypeCheckTable[i][WAZA_TYPE]!=0xff){
			if(TypeCheckTable[i][WAZA_TYPE]==0xfe){
				//݂Ԃ`FbNor܂Ă
				if((sp->psp[defence_client].condition2&CONDITION2_MIYABURU)||
				   (ST_ServerTokuseiGet(sp,attack_client)==TOKUSYU_KIMOTTAMA)){
					break;
				}
				else{
					i++;
					continue;
				}
			}
			if(TypeCheckTable[i][WAZA_TYPE]==wazatype){
				if(TypeCheckTable[i][POKE_TYPE]==ST_ServerPokemonServerParamGet(sp,defence_client,ID_PSP_type1,NULL)){
					if(ST_KoukanaiCheck(sp,attack_client,defence_client,i)==TRUE){
						damage=ST_TypeCheckCalc(sp,attack_client,TypeCheckTable[i][POWER],damage,waza_damage,flag);
						if(TypeCheckTable[i][POWER]==BATSUGUN){
							bairitu*=2;
						}
					}
				}
				if((TypeCheckTable[i][POKE_TYPE]==ST_ServerPokemonServerParamGet(sp,defence_client,ID_PSP_type2,NULL))&&
				   (ST_ServerPokemonServerParamGet(sp,defence_client,ID_PSP_type1,NULL)!=
					ST_ServerPokemonServerParamGet(sp,defence_client,ID_PSP_type2,NULL))){
					if(ST_KoukanaiCheck(sp,attack_client,defence_client,i)==TRUE){
						damage=ST_TypeCheckCalc(sp,attack_client,TypeCheckTable[i][POWER],damage,waza_damage,flag);
						if(TypeCheckTable[i][POWER]==BATSUGUN){
							bairitu*=2;
						}
					}
				}
			}
			i++;
		}
	}

	//\͂ӂȂ܂́AʂQȂ
	if((ST_ServerKatayaburiTokuseiCheck(sp,attack_client,defence_client,TOKUSYU_HUSIGINAMAMORI)==TRUE)&&
	   (ST_TameWazaTurnCheck(sp,waza_no))&&
	 (((flag[0]&WAZA_STATUS_FLAG_BATSUGUN)==0)||
	  ((flag[0]&WAZA_STATUS_FLAG_SOUSAI)==WAZA_STATUS_FLAG_SOUSAI))&&
	   (waza_damage)){
		flag[0]|=WAZA_STATUS_FLAG_BATSUGUN_NOHIT;
	}
	else{
		if(((sp->server_status_flag&SERVER_STATUS_FLAG_TYPE_FLAT)==0)&&
		   ((sp->server_status_flag&SERVER_STATUS_FLAG_TYPE_NONE)==0)){
			if((flag[0]&WAZA_STATUS_FLAG_BATSUGUN)&&(waza_damage)){
				//tB^[An[hbŃAQœA_[W3/4ɂ
				if((ST_ServerKatayaburiTokuseiCheck(sp,attack_client,defence_client,TOKUSYU_FIRUTAA)==TRUE)||
				   (ST_ServerKatayaburiTokuseiCheck(sp,attack_client,defence_client,TOKUSYU_HAADOROKKU)==TRUE)){
					damage=ST_ServerDamageDiv(damage*3,4);
				}
				//ʂŔQЗ́Abv
				if(eqp_a==SOUBI_BATUGUNIRYOKUUP){
					damage=damage*(100+atk_a)/100;
				}
			}
			if((flag[0]&WAZA_STATUS_FLAG_IMAHITOTSU)&&(waza_damage)){
				//߂˂́A܂ЂƂ0.51ɁA0.250.5ɂ
				if(ST_ServerTokuseiGet(sp,attack_client)==TOKUSYU_IROMEGANE){
					damage*=2;
				}
			}
		}
		else{
			flag[0]&=WAZA_STATUS_FLAG_BATSUGUN_OFF;
			flag[0]&=WAZA_STATUS_FLAG_IMAHITOTSU_OFF;
		}
	}

	return damage;
}

//============================================================================================
/**
 *	Zƃ|P̑`FbNiAIpj
 *
 * @param[in]	bw				퓬VXep[N\
 * @param[in]	sp				T[op[^̍\̃|C^
 * @param[in]	waza_no			`FbNZ
 * @param[in]	attack_client	UClientNo
 * @param[in]	defence_client	h䑤ClientNo
 * @param[out]	flag			`FbNʂ̃tOi[郏[N
 */
//============================================================================================
void	ST_AITypeCheck(SERVER_PARAM *sp,int waza_no,int waza_type,int spe_a,int spe_d,int eqp,int type1,int type2,u32 *flag)
{
	int	i;
	u8	wazatype;

	//邠́AȂ̂TypeCheckȂ
	if(waza_no==WAZANO_WARUAGAKI){
		return;
	}

	//m[}XĹAZ^Cvm[}ɂ
	if(spe_a==TOKUSYU_NOOMARUSUKIN){
		wazatype=NORMAL_TYPE;
	}
	else if(waza_type){
		wazatype=waza_type;
	}
	else{
		wazatype=sp->AIWT.wtd[waza_no].wazatype;
	}

	//ʂӂ䂤ɂ́A߂^Cv̋Z͓ȂiʂőfDOWN̓qbgj
	if((spe_a!=TOKUSYU_KATAYABURI)&&
	   (spe_d==TOKUSYU_HUYUU)&&
  	   (wazatype==JIMEN_TYPE)&&
	  ((sp->field_condition&FIELD_CONDITION_JUURYOKU)==0)&&
	   (eqp!=SOUBI_SUBAYASADOWN)){
		flag[0]|=WAZA_STATUS_FLAG_KOUKANAI;
	}
	else{
		i=0;
		while(TypeCheckTable[i][WAZA_TYPE]!=0xff){
			if(TypeCheckTable[i][WAZA_TYPE]==0xfe){
				//݂Ԃ`FbNor܂Ă
				if(spe_a==TOKUSYU_KIMOTTAMA){
					break;
				}
				else{
					i++;
					continue;
				}
			}
			if(TypeCheckTable[i][WAZA_TYPE]==wazatype){
				if(TypeCheckTable[i][POKE_TYPE]==type1){
					if(ST_AIKoukanaiCheck(sp,eqp,i)==TRUE){
						ST_AITypeCheckCalc(TypeCheckTable[i][POWER],flag);
					}
				}
				if((TypeCheckTable[i][POKE_TYPE]==type2)&&(type1!=type2)){
					if(ST_AIKoukanaiCheck(sp,eqp,i)==TRUE){
						ST_AITypeCheckCalc(TypeCheckTable[i][POWER],flag);
					}
				}
			}
			i++;
		}
	}

	//\͂ӂȂ܂́AʂQȂ
	if((spe_a!=TOKUSYU_KATAYABURI)&&
	   (spe_d==TOKUSYU_HUSIGINAMAMORI)&&
	   (ST_TameWazaTurnCheck(sp,waza_no))&&
	 (((flag[0]&WAZA_STATUS_FLAG_BATSUGUN)==0)||
	  ((flag[0]&WAZA_STATUS_FLAG_SOUSAI)==WAZA_STATUS_FLAG_SOUSAI))){
		flag[0]|=WAZA_STATUS_FLAG_KOUKANAI;
	}

	return;
}

//============================================================================================
/**
 *	ʂȂ|P̑𓖂ĂZʂ̃`FbN
 *
 * @param[in]	sp				T[op[^̍\̃|C^
 * @param[in]	eqp				
 * @param[in]	pos				TypeCheckTableIndex
 *
 * @retval	FALSE:@TRUE:ʂȂ܂܂OK
 */
//============================================================================================
static	BOOL	ST_AIKoukanaiCheck(SERVER_PARAM *sp,int eqp,int pos)
{
	BOOL	ret;

	ret=TRUE;

	//ʂ΂₳DOWN
	if(eqp==SOUBI_SUBAYASADOWN){
		//ЂɃqbg
		if((TypeCheckTable[pos][POKE_TYPE]==HIKOU_TYPE)&&
		   (TypeCheckTable[pos][POWER]==KOUKANAI)){
			ret=FALSE;
		}
	}
	//イ傭`FbN
	if(sp->field_condition&FIELD_CONDITION_JUURYOKU){
		//ЂɃqbg
		if((TypeCheckTable[pos][POKE_TYPE]==HIKOU_TYPE)&&
		   (TypeCheckTable[pos][POWER]==KOUKANAI)){
			ret=FALSE;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	|PƋZ̃^Cv̑ŃtOZbg
 *
 * @param[in]	client_no	ZJoClientNo
 * @param[in]	power		З
 * @param[out]	flag		tOZbg郏[N
 */
//============================================================================================
static	void	ST_AITypeCheckCalc(int power,u32 *flag)
{
	switch(power){
	case KOUKANAI:
		flag[0]|=WAZA_STATUS_FLAG_KOUKANAI;
		flag[0]&=WAZA_STATUS_FLAG_IMAHITOTSU_OFF;
		flag[0]&=WAZA_STATUS_FLAG_BATSUGUN_OFF;
		break;
	case IMAHITOTSU:
		if(flag[0]&WAZA_STATUS_FLAG_BATSUGUN){
			flag[0]&=WAZA_STATUS_FLAG_BATSUGUN_OFF;
		}
		else{
			flag[0]|=WAZA_STATUS_FLAG_IMAHITOTSU;
		}
		break;
	case BATSUGUN:
		if(flag[0]&WAZA_STATUS_FLAG_IMAHITOTSU){
			flag[0]&=WAZA_STATUS_FLAG_IMAHITOTSU_OFF;
		}
		else{
			flag[0]|=WAZA_STATUS_FLAG_BATSUGUN;
		}
		break;
	}

	return;
}

//============================================================================================
/**
 *	Z̔Wꂽ`FbN
 *
 * @param[in]	sp	T[op[^̍\̃|C^
 *
 * @retval	FALSE:WĂȂ@TRUE:Wꂽ
 */
//============================================================================================
BOOL	ST_ServerWazaOutCheck(SERVER_PARAM *sp,int client_no)
{
	if( (sp->wocf[client_no].mahi_flag)||
		(sp->wocf[client_no].koukanai_flag)||
		(sp->wocf[client_no].huuin_flag)||
		(sp->wocf[client_no].meromero_flag)||
		(sp->wocf[client_no].kanashibari_flag)||
		(sp->wocf[client_no].chouhatsu_flag)||
		(sp->wocf[client_no].hirumu_flag)||
		(sp->wocf[client_no].juuryoku_flag)||
		(sp->wocf[client_no].konran_flag)){
		return TRUE;
	}
	else{
		return FALSE;
	}
}

//============================================================================================
/**
 *	U𓖂Ă邱Ƃ̏o|P̂邩`FbN
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	flag		`FbNΏۃtO
 * @param[in]	client_no	`FbNΏClientNo
 *
 * @retval	|P̐
 */
//============================================================================================
u8		ST_ServerHitCountCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int flag,int client_no)
{
	int	no;
	u8	count;
	int	client_set_max;

	count=0;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	switch(flag){
	case SHCC_NORMAL:
		for(no=0;no<client_set_max;no++){
			if((no!=client_no)&&(sp->psp[no].hp)){
				count++;
			}
		}
		break;
	case SHCC_SIDE:
		for(no=0;no<client_set_max;no++){
			if((BattleWorkMineEnemyCheck(bw,no)==BattleWorkMineEnemyCheck(bw,client_no))&&(sp->psp[no].hp)){
				count++;
			}
		}
		break;
	}
	return count;
}

//============================================================================================
/**
 *	bZ[W\p[^̃jbNl[f[^𐶐
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	ΏClientNo
 *
 * @retval	p[^
 */
//============================================================================================
int		ST_ServerTagNickParaMake(SERVER_PARAM *sp,int client_no)
{
	return (client_no|(sp->sel_mons_no[client_no]<<8));
}

//============================================================================================
/**
 *	IZio[擾
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	擾ClientNo
 *
 * @retval	IZio[
 */
//============================================================================================
u16		ST_ServerSelectWazaGet(SERVER_PARAM *sp,int client_no)
{
	u16	wazano;

	wazano=0;

	if((sp->client_act_work[client_no][ACT_PARA_SELECT_COMMAND]==SELECT_FIGHT_COMMAND)&&
	   (sp->client_act_work[client_no][ACT_PARA_WORK])){
		wazano=sp->psp[client_no].waza[sp->client_act_work[client_no][ACT_PARA_WORK]-1];
	}
	return wazano;
}

//============================================================================================
/**
 *	|P邩`FbN
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	flag		`FbN̎
 * @param[in]	client_no	`FbNClientNoi`FbN̎ނɂӖωj
 * @param[in]	speabi		`FbNio[
 *
 * @retval	Ă|P
 */
//============================================================================================
int		ST_ServerTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int flag,int client_no,int speabi)
{
	int	cnt;
	int	no;
	int	client_set_max;

	cnt=0;
	client_set_max=BattleWorkClientSetMaxGet(bw);

	switch(flag){
	case STC_HAVE_MINE_SIDE:	//Ă邩`FbN
		for(no=0;no<client_set_max;no++){
			if((BattleWorkMineEnemyCheck(bw,no)==BattleWorkMineEnemyCheck(bw,client_no))&&
			   (ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt++;
			}
		}
		break;
	case STC_HAVE_MINE_SIDE_HP:	//Ă邩`FbNiHP0͖j
		for(no=0;no<client_set_max;no++){
			if((BattleWorkMineEnemyCheck(bw,no)==BattleWorkMineEnemyCheck(bw,client_no))&&
			   (sp->psp[no].hp)&&
			   (ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt++;
			}
		}
		break;
	case STC_HAVE_ENEMY_SIDE:	//葤Ă邩`FbN
		for(no=0;no<client_set_max;no++){
			if((BattleWorkMineEnemyCheck(bw,no)!=BattleWorkMineEnemyCheck(bw,client_no))&&
			   (ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt++;
			}
		}
		break;
	case STC_HAVE_ENEMY_SIDE_HP:	//葤Ă邩`FbNiHP0͖j
		for(no=0;no<client_set_max;no++){
			if((BattleWorkMineEnemyCheck(bw,no)!=BattleWorkMineEnemyCheck(bw,client_no))&&
			   (sp->psp[no].hp)&&
			   (ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt++;
			}
		}
		break;
	case STC_HAVE_ENEMY_SIDE_RET:	//葤Ă邩`FbNĎĂClientNoԂ
		for(no=0;no<client_set_max;no++){
			if((BattleWorkMineEnemyCheck(bw,no)!=BattleWorkMineEnemyCheck(bw,client_no))&&
			   (sp->psp[no].hp)&&
			   (ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt|=No2Bit(no);
			}
		}
		break;
	case STC_HAVE_ALL:			//܂ߎĂ邩`FbN
		for(no=0;no<client_set_max;no++){
			if(ST_ServerTokuseiGet(sp,no)==speabi){
				cnt++;
			}
		}
		break;
	case STC_HAVE_ALL_NOMINE:	//ȊÕ|PĂ邩`FbN
		for(no=0;no<client_set_max;no++){
			if((no!=client_no)&&(ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt++;
			}
		}
		break;
	case STC_HAVE_ALL_NOMINE_RET:	//ȊÕ|PĂ邩`FbNĎĂClientNoԂ
		for(no=0;no<client_set_max;no++){
			if((no!=client_no)&&(ST_ServerTokuseiGet(sp,no)==speabi)){
				cnt=no+1;
				break;
			}
		}
		break;
	case STC_HAVE_ALL_HP:			//܂ߎĂ邩`FbNiHP0͖j
		for(no=0;no<client_set_max;no++){
			if((ST_ServerTokuseiGet(sp,no)==speabi)&&(sp->psp[no].hp)){
				cnt++;
			}
		}
		break;
	case STC_HAVE_ALL_NOMINE_HP:	//ȊÕ|PĂ邩`FbNiHP0͖j
		for(no=0;no<client_set_max;no++){
			if((no!=client_no)&&(ST_ServerTokuseiGet(sp,no)==speabi)&&(sp->psp[no].hp)){
				cnt++;
			}
		}
		break;
	}

	return cnt;
}

//============================================================================================
/**
 *	ߋZIĂ邩`FbN
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	TRUEFߋZ@FALSE:ߋZȂ
 */
//============================================================================================
BOOL	ST_TameWazaCheck(SERVER_PARAM *sp,int waza_no)
{
	switch(sp->AIWT.wtd[waza_no].battleeffect){
	case 26:	//܂
	case 39:	//܂
	case 75:	//Sbho[h
	case 145:	//Pbg˂
	case 151:	//\[[r[
	case 155:	//Ƃ
	case 255:	//_CrO
	case 256:	//Ȃق
	case 263:	//Ƃт͂˂
	case 272:	//Vh[_Cu
		return TRUE;
		break;
	}

	return FALSE;
}

//============================================================================================
/**
 *	TypeCheckTablẽp[^擾
 *
 * @param[in]	pos		e[ũCfbNX
 * @param[in]	type_w	Z^Cvi[
 * @param[in]	type_p	|P^Cvi[
 * @param[in]	value	type_wtype_p̑
 *
 * @retval	FALSE:e[uI[o[@TRUE:e[uȂ擾
 *
 */
//============================================================================================
BOOL	ST_ServerTypeCheckTableParaGet(int pos,u8 *type_w,u8 *type_p,u8 *value)
{
	BOOL	ret;

	ret=TRUE;

	if(pos>=NELEMS(TypeCheckTable)){
		pos=gf_rand()%(NELEMS(TypeCheckTable));
		ret=FALSE;
	}
	type_w[0]=TypeCheckTable[pos][WAZA_TYPE];
	type_p[0]=TypeCheckTable[pos][POKE_TYPE];
	value[0]=TypeCheckTable[pos][POWER];

	return ret;
}

//============================================================================================
/**
 *	TypeCheckTablep[擾
 *
 * @param[in]	type_w	Z^Cv
 * @param[in]	type_p1	|P^Cv
 * @param[in]	type_p2	|P^Cv
 *
 * @retval	power
 *
 */
//============================================================================================
int	ST_ServerTypeCheckTablePowerGet(u8 type_w,u8 type_p1,u8 type_p2)
{
	int	i;
	int	damage;

	i=0;
	damage=AISYOU_1BAI;

	while(TypeCheckTable[i][WAZA_TYPE]!=0xff){
		if(TypeCheckTable[i][WAZA_TYPE]==type_w){
			if(TypeCheckTable[i][POKE_TYPE]==type_p1){
				damage=damage*TypeCheckTable[i][POWER]/10;
			}
			if((TypeCheckTable[i][POKE_TYPE]==type_p2)&&(type_p1!=type_p2)){
				damage=damage*TypeCheckTable[i][POWER]/10;
			}
		}
		i++;
	}

	return damage;
}

//============================================================================================
/**
 *	ႤZ֔hZ̃`FbN
 *
 * @param[in]	waza_no	`FbNZio[
 *
 * @retval	FALSE:hZł͂Ȃ@TRUE:hZ
 */
//============================================================================================
BOOL	ST_RendouWazaCheck(u16 waza_no)
{
	if((waza_no==0)||
	   (waza_no==WAZANO_NEGOTO)||
	   (waza_no==WAZANO_MANEKKO)||
	   (waza_no==WAZANO_NEKONOTE)||
	   (waza_no==WAZANO_SAKIDORI)||
	   (waza_no==WAZANO_OUMUGAESI)||
	   (waza_no==WAZANO_YUBIWOHURU)){
		return TRUE;
	}
	return FALSE;
}

//============================================================================================
/**
 *	JoƂĂ̂낢Am[}AS[Xg`FbN
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	waza_no		`FbNZio[
 * @param[in]	client_no	JoƂĂClientNo
 *
 * @retval	FALSE:m[}@TRUE:S[Xg
 */
//============================================================================================
BOOL	ST_ServerWazaNoroiCheck(SERVER_PARAM *sp,u16 waza_no,int client_no)
{
	return ((waza_no==WAZANO_NOROI)&&
		   ((ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type1,NULL)==GHOST_TYPE)||
			(ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type2,NULL)==GHOST_TYPE)));
}

//============================================================================================
/**
 *	ǂڂłACe`FbN
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	client_no	ǂڂClientNo
 *
 * @retval	FALSE:łȂ@TRUE:ł
 */
//============================================================================================
BOOL	ST_ServerDorobouItemCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		dir;

	ret=FALSE;

	dir=BattleWorkMineEnemyCheck(bw,client_no);

	if((sp->psp[client_no].item)&&
	  ((sp->scw[dir].hatakiotosu_item&No2Bit(sp->sel_mons_no[client_no]))==0)&&
	   (ItemMailCheck(sp->psp[client_no].item)==FALSE)){
		ret=TRUE;
	}

	return ret;
}

//============================================================================================
/**
 *	gbNłACe`FbN
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	client_no	gbNĂClientNo
 *
 * @retval	FALSE:łȂ@TRUE:ł
 */
//============================================================================================
BOOL	ST_ServerTrickItemCheck(SERVER_PARAM *sp,int client_no)
{
	return (ItemMailCheck(sp->psp[client_no].item)==FALSE);
}

//============================================================================================
/**
 *	ӂƂ΂۔
 *
 * @param[in]	sp			T[o[N\
 *
 * @retval	FALSE:łȂ@TRUE:ł
 */
//============================================================================================
BOOL	ST_ServerHukitobasiCheck(SERVER_PARAM *sp)
{
	BOOL	ret;

	ret=FALSE;

	//õx΁A100%
	if(sp->psp[sp->attack_client].level>=sp->psp[sp->defence_client].level){
		ret=TRUE;
	}
	else{
		{
			int	level;

			level=(((gf_rand()&0xff)*(sp->psp[sp->attack_client].level+sp->psp[sp->defence_client].level))>>8)+1;

			if(level>(sp->psp[sp->defence_client].level/4)){
				ret=TRUE;
			}
		}
	}

	return ret;
}

//============================================================================================
/**
 *	擾iZuv̌ʂfĎ擾j
 *
 * @param[in]	psp			|PT[o[N\
 *
 * @retval	io[
 */
//============================================================================================
u8	ST_ServerTokuseiGet(SERVER_PARAM *sp,int client_no)
{
	//́Ai}`^Cv͏Oj
	if((sp->psp[client_no].waza_kouka&WAZAKOUKA_IEKI)&&(sp->psp[client_no].speabino!=TOKUSYU_MARUTITAIPU)){
		return 0;
	}
	//イ傭́Aӂ䂤͖
	else if((sp->field_condition&FIELD_CONDITION_JUURYOKU)&&(sp->psp[client_no].speabino==TOKUSYU_HUYUU)){
		return 0;
	}
	//˂͂锭́Aӂ䂤͖
	else if((sp->psp[client_no].waza_kouka&WAZAKOUKA_NEWOHARU)&&(sp->psp[client_no].speabino==TOKUSYU_HUYUU)){
		return 0;
	}
	else{
		return sp->psp[client_no].speabino;
	}
}

//============================================================================================
/**
 *	Ԃ𔽉fă`FbN
 *
 * @param[in]	sp			T[o[N\
 * @param[in]	attack		U
 * @param[in]	defence		h䑤
 * @param[in]	tokusei		`FbN
 *
 * @retval	FALSE:Ԃœ@TRUEFԂ֌WȂ
 */
//============================================================================================
BOOL	ST_ServerKatayaburiTokuseiCheck(SERVER_PARAM *sp,int attack,int defence,int tokusei)
{
	BOOL	ret;

	ret=FALSE;

	if(ST_ServerTokuseiGet(sp,attack)!=TOKUSYU_KATAYABURI){
		if(ST_ServerTokuseiGet(sp,defence)==tokusei){
			ret=TRUE;
		}
	}
	else{
		if((ST_ServerTokuseiGet(sp,defence)==tokusei)&&(sp->ostf[attack].katayaburi_flag==0)){
			sp->ostf[attack].katayaburi_flag=1;
			sp->server_status_flag|=SERVER_STATUS_FLAG_KATAYABURI;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	ւ|P邩`FbN
 *
 * @param[in]	bw			퓬VXe[N\
 * @param[in]	sp			T[o[N\
 * @param[in]	client_no	`FbNClientNo
 *
 * @retval	FALSE:Ȃ@TRUE:
 */
//============================================================================================
BOOL	ST_ServerReshuffleCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL			ret;
	POKEPARTY		*poke_p;
	POKEMON_PARAM	*pp;
	int				poke_count;
	int				cnt=0,cntmax,i,start,end,rnd_max;
	int				selmons1,selmons2;
	u32				fight_type;

	ret=FALSE;
	fight_type=BattleWorkFightTypeGet(bw);
	poke_p=BattleWorkPokePartyGet(bw,client_no);
	poke_count=BattleWorkPokeCountGet(bw,client_no);

	if((fight_type&FIGHT_TYPE_MULTI)||
	  ((fight_type&FIGHT_TYPE_TAG)&&(BattleWorkClientTypeGet(bw,client_no)&CLIENT_ENEMY_FLAG))){
		start=0;
		end=poke_count;
		rnd_max=poke_count;
		cntmax=1;
		selmons1=sp->sel_mons_no[client_no];
		selmons2=sp->sel_mons_no[client_no];
	}
	//_u
	else if(fight_type&FIGHT_TYPE_2vs2){
		start=0;
		end=poke_count;
		rnd_max=poke_count;
		cntmax=1;
		selmons1=sp->sel_mons_no[client_no];
		selmons2=sp->sel_mons_no[BattleWorkPartnerClientNoGet(bw,client_no)];
	}
	//VO
	else{
		start=0;
		end=poke_count;
		rnd_max=poke_count;
		cntmax=1;
		selmons1=sp->sel_mons_no[client_no];
		selmons2=sp->sel_mons_no[client_no];
	}

	for(i=start;i<end;i++){
		pp=PokeParty_GetMemberPointer(poke_p,i);
		if((PokeParaGet(pp,ID_PARA_monsno,NULL))&&
		   (PokeParaGet(pp,ID_PARA_tamago_flag,NULL)==0)&&
		   (PokeParaGet(pp,ID_PARA_hp,NULL))&&
		   (selmons1!=i)&&(selmons2!=i)){
			cnt++;
		}
	}
	if(cnt>=cntmax){
		ret=TRUE;
	}

	return ret;
}

//============================================================================================
/**
 *	퓬瓦邩`FbNiR}h邩ǂj
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	@param[in]	mp			A[gbZ[W̃p[^i[\
 *	
 *	@retval	FALSE:@TRUE:Ȃ
 */
//============================================================================================
BOOL	ST_EscapeNGCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,MESSAGE_PARAM *mp)
{
	int	i;
	int	client_set_max;
	u8	dir;
	int	eqp;
	u32	fight_type;

	fight_type=BattleWorkFightTypeGet(bw);

	eqp=ST_ServerSoubiEqpGet(sp,client_no);

	//ACeŕK̑ʂ100%
	if((eqp==SOUBI_KANARAZUNIGERARERU)||
	//KFIGHT_TYPE̓`FbNȂ
	   (fight_type&FIGHT_TYPE_ESCAPE)||
	//\͂ɂ͕K̂Ń`FbNȂ
	   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_NIGEASI)){
		return 0;
	}

	dir=BattleWorkMineEnemyCheck(bw,client_no);
	client_set_max=BattleWorkClientSetMaxGet(bw);

	//ӂ݂͓Ȃi݂ӂ݂̎͗Oj
	if((i=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_NOMINE_HP,client_no,TOKUSYU_KAGEHUMI))&&
	   (ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_KAGEHUMI)){
		if(mp==NULL){
			return TRUE;
		}
		mp->msg_tag=TAG_NICK_TOKU;
		mp->msg_id=TokuseiEscapeNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,i);
		mp->msg_para[1]=TOKUSYU_KAGEHUMI;
		return TRUE;
	}
	//肶͓Ȃ
	if((i=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE_HP,client_no,TOKUSYU_ARIZIGOKU))){
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if B1373_060816_FIX
	   //΂₳_E𑕔Ă鎞͂肶肠
		if(((sp->field_condition&FIELD_CONDITION_JUURYOKU)==0)&&(eqp!=SOUBI_SUBAYASADOWN)){
#else //B1373_060816_FIX
		if((sp->field_condition&FIELD_CONDITION_JUURYOKU)==0){
#endif //B1373_060816_FIX
// ----------------------------------------------------------------------------
			//ӂ䂤As^Cvɂ́A肶͌ʂ
			if((ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_HUYUU)&&
			   (sp->psp[client_no].wkw.denzihuyuu_count==0)&&
			  ((ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type1,NULL)!=HIKOU_TYPE)&&
			   (ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type2,NULL)!=HIKOU_TYPE))){
				if(mp==NULL){
					return TRUE;
				}
				mp->msg_tag=TAG_NICK_TOKU;
				mp->msg_id=TokuseiEscapeNGMineMsg;
				mp->msg_para[0]=ST_ServerTagNickParaMake(sp,i);
				mp->msg_para[1]=TOKUSYU_ARIZIGOKU;
				return TRUE;
			}
		}
		else{
			if(mp==NULL){
				return TRUE;
			}
			mp->msg_tag=TAG_NICK_TOKU;
			mp->msg_id=TokuseiEscapeNGMineMsg;
			mp->msg_para[0]=ST_ServerTagNickParaMake(sp,i);
			mp->msg_para[1]=TOKUSYU_ARIZIGOKU;
			return TRUE;
		}
	}
#if 0
	//肶͓Ȃ
	if((i=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_NOMINE,client_no,TOKUSYU_ARIZIGOKU))&&
		//ӂ䂤As^Cvɂ́A肶͌ʂ
	   (ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_HUYUU)&&
	   (sp->psp[client_no].wkw.denzihuyuu_count==0)&&
	  ((ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type1,NULL)!=HIKOU_TYPE)&&
	   (ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type2,NULL)!=HIKOU_TYPE))){
		if(mp==NULL){
			return TRUE;
		}
		mp->msg_tag=TAG_NICK_TOKU;
		mp->msg_id=TokuseiEscapeNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,i);
		mp->msg_para[1]=TOKUSYU_ARIZIGOKU;
		return TRUE;
	}
#endif
	//傭|^Cṽ|P͓Ȃ
	if((i=ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE_HP,client_no,TOKUSYU_ZIRYOKU))&&
	  ((ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type1,NULL)==METAL_TYPE)||
	   (ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type2,NULL)==METAL_TYPE))){
		if(mp==NULL){
			return TRUE;
		}
		mp->msg_tag=TAG_NICK_TOKU;
		mp->msg_id=TokuseiEscapeNGMineMsg;
		mp->msg_para[0]=ST_ServerTagNickParaMake(sp,i);
		mp->msg_para[1]=TOKUSYU_ZIRYOKU;
		return TRUE;
	}

	//߂ĂA낢܂ȂĂA˂͂Ă鎞͓Ȃ
	if((sp->psp[client_no].condition2&(CONDITION2_SHIME|CONDITION2_KUROIMANAZASHI))||
	   (sp->psp[client_no].waza_kouka&WAZAKOUKA_NEWOHARU)){
		if(mp==NULL){
			return TRUE;
		}
		mp->msg_tag=TAG_NONE;
		mp->msg_id=EscapeNGMsg1;
		return TRUE;
	}

#if 0
	//퓬^CvKChog͓̎Ȃ
	if(FightType&FIGHT_TYPE_GUIDE){
		ServerWork[5]=1;
		return 1;
	}
#endif
	return	FALSE;
}

//============================================================================================
/**
 *	퓬瓦邩`FbNiR}hj
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	
 *	@retval	TRUE:@FALSE:Ȃ
 */
//============================================================================================
BOOL	ST_EscapeActCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	u8		escape;
	int		eqp;
	u8		escape_range;
	u32		fight_type;

	fight_type=BattleWorkFightTypeGet(bw);
	eqp=ST_ServerSoubiEqpGet(sp,client_no);
	ret=FALSE;

	//ACeŕK̑ʂ100%
	if(eqp==SOUBI_KANARAZUNIGERARERU){
		sp->otf[client_no].escape_flag=1;
		ret=TRUE;
	}
	//100%FIGHT_TYPE`FbN
	else if(fight_type&FIGHT_TYPE_ESCAPE){
		ret=TRUE;
	}
	//\͂ɂ100%
	else if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_NIGEASI){
		sp->otf[client_no].escape_flag=2;
		ret=TRUE;
	}
	else{
		//̕ΓI񐔂قǓ₷
		if(sp->psp[client_no].agi<sp->psp[client_no^1].agi){
			escape=sp->psp[client_no].agi*128/sp->psp[client_no^1].agi+sp->escape_count*30;
			if(escape>(gf_rand()%256)){
				ret=TRUE;
			}
		}
		//̕100%
		else{
			ret=TRUE;
		}
		//ɎsJE^JEgAbv
		if(ret==FALSE){
			SCIO_IncRecord(bw,client_no,CLIENT_BOOT_TYPE_MINE,RECID_NIGERU_SIPPAI);
		}
		sp->escape_count++;
	}
	return ret;
}

//============================================================================================
/**
 *	Ȃ܂`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	
 *	@retval	FALSE:Ȃ܂Ȃ@TRUE:Ȃ܂
 */
//============================================================================================
BOOL	ST_ServerNamakeCheck(SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;

	ret=FALSE;

	if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_NAMAKE){
		if(sp->psp[client_no].wkw.namake_bit!=(sp->total_turn&1)){
			ret=TRUE;
		}
	}
	
	return ret;
}

//============================================================================================
/**
 *	킮`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	
 *	@retval	FALSE:@TRUE:킪
 */
//============================================================================================
BOOL	ST_ServerSawaguCheck(SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;

	ret=FALSE;

	if(ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_BOUON){
		if(sp->field_condition&FIELD_CONDITION_SAWAGU){
			ret=TRUE;
		}
	}
	return ret;
}

//============================================================================================
/**
 *	ӂ`FbN
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	@param[in]	waza_no		`FbNWazaNo
 *	
 *	@retval	FALSE:ӂ񂳂ĂȂ@TRUE:ӂ񂳂Ă
 */
//============================================================================================
BOOL	ST_ServerHuuinCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no)
{
	int		client;
	int		client_set_max;
	int		dir;
	int		pos;
	BOOL	ret;

	ret=FALSE;

	client_set_max=BattleWorkClientSetMaxGet(bw);
	dir=BattleWorkMineEnemyCheck(bw,client_no);

	for(client=0;client<client_set_max;client++){
		if((dir!=BattleWorkMineEnemyCheck(bw,client))&&(sp->psp[client].waza_kouka&WAZAKOUKA_HUUIN)){
			for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
				if(waza_no==sp->psp[client].waza[pos]){
					break;
				}
			}
			if(pos!=WAZA_TEMOTI_MAX){
				ret=TRUE;
			}
		}
	}

	return ret;
}

//============================================================================================
/**
 *	ɂ|PɋZʂĂ邩`FbN
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	waza_kouka	`FbNZ
 *	
 *	@retval	FALSE:ʂĂȂ@TRUE:ʂ
 */
//============================================================================================
BOOL	ST_ServerWazaKoukaCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int waza_kouka)
{
	int		client_no;
	int		client_set_max;
	BOOL	ret;

	ret=FALSE;
	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(client_no=0;client_no<client_set_max;client_no++){
		if(sp->psp[client_no].waza_kouka&waza_kouka){
			ret=TRUE;
			break;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	[vn̋ZŃ[v鎞ɏ郏[N
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerLoopInit(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	sp->waza_status_flag=0;
//	sp->damage_value=10;
	sp->critical=1;
#if	GB001_060815_FIX
	sp->server_status_flag&=(SERVER_STATUS_FLAG_NO_WAZANO_SET^0xffffffff);
#endif	//GB001_060815_FIX
}

//============================================================================================
/**
 *	fɂZԂ̂߂̃[N𐶐
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerPSPAgiCalc(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	client_set_max;
	int	i,j;
	int	cl1,cl2;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(client_no=0;client_no<client_set_max;client_no++){
		sp->psp_agi_work[client_no]=client_no;
	}
	for(i=0;i<client_set_max-1;i++){
		for(j=i+1;j<client_set_max;j++){
			cl1=sp->psp_agi_work[i];
			cl2=sp->psp_agi_work[j];
			if(ST_ServerAgiCalc(bw,sp,cl1,cl2,1)){
				sp->psp_agi_work[i]=cl2;
				sp->psp_agi_work[j]=cl1;
			}
		}
	}
}

//============================================================================================
/**
 *	イ傭`FbNe[u
 */
//============================================================================================
static	const	u16	JuuryokuWazaTable[]={
	WAZANO_SORAWOTOBU,
	WAZANO_TOBIHANERU,
	WAZANO_TOBIGERI,
	WAZANO_TOBIHIZAGERI,
	WAZANO_HANERU,
	WAZANO_DENZIHUYUU,
};

//============================================================================================
/**
 *	イ傭`FbN
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	@param[in]	waza_no		`FbNWazaNo
 *	
 *	@retval	FALSE:イ傭̉eȂ@TRUE:イ傭̉e
 */
//============================================================================================
BOOL	ST_ServerJuuryokuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no)
{
	int		no;
	BOOL	ret;

	ret=FALSE;

	if(sp->field_condition&FIELD_CONDITION_JUURYOKU){
		for(no=0;no<NELEMS(JuuryokuWazaTable);no++){
			if(JuuryokuWazaTable[no]==waza_no){
				ret=TRUE;
				break;
			}
		}
	}

	return ret;
}

//============================================================================================
/**
 *	q[ubN`FbNe[u
 */
//============================================================================================
static	const	u16	HealblockWazaTable[]={
	WAZANO_ZIKOSAISEI,
	WAZANO_TAMAGOUMI,
	WAZANO_NEMURU,
	WAZANO_MIRUKUNOMI,
	WAZANO_ASANOHIZASI,
	WAZANO_KOUGOUSEI,
	WAZANO_TUKINOHIKARI,
	WAZANO_NOMIKOMU,
	WAZANO_KAIHUKUSIREI,
	WAZANO_NAMAKERU,
	WAZANO_HANEYASUME,
	WAZANO_MIKADUKINOMAI,
	WAZANO_IYASINONEGAI,
	WAZANO_NEGAIGOTO,
};

//============================================================================================
/**
 *	q[ubN`FbN
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	@param[in]	waza_no		`FbNWazaNo
 *	
 *	@retval	FALSE:q[ubN̉eȂ@TRUE:q[ubN̉e
 */
//============================================================================================
BOOL	ST_ServerHealblockCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no)
{
	int		no;
	BOOL	ret;

	ret=FALSE;

	if(sp->psp[client_no].wkw.healblock_count){
		OS_TPrintf("wazano:%d\n",waza_no);
		for(no=0;no<NELEMS(HealblockWazaTable);no++){
			if(HealblockWazaTable[no]==waza_no){
				ret=TRUE;
				break;
			}
		}
	}

	return ret;
}

//============================================================================================
/**
 *	ƂĂJEgvZ
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerTotteokiCountCalc(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	pos;

	//ƂẮAJEgȂ
	//ƂĂJEgMAXȂAJEgȂ
	if((sp->waza_no_temp==WAZANO_TOTTEOKI)||(sp->psp[sp->attack_client].wkw.totteoki_count==WAZA_TEMOTI_MAX)){
		return;
	}

	for(pos=0;pos<sp->psp[sp->attack_client].wkw.totteoki_count;pos++){
		if(sp->psp[sp->attack_client].wkw.totteoki_wazano[pos]==sp->waza_no_temp){
			return;
		}
	}
	sp->psp[sp->attack_client].wkw.totteoki_wazano[pos]=sp->waza_no_temp;
	sp->psp[sp->attack_client].wkw.totteoki_count++;
}

//============================================================================================
/**
 *	ZĂ邩JEg
 *
 *	@param[in]	bw			퓬VXe\̂̃|C^
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	JEgClientNo
 */
//============================================================================================
int		ST_ServerWazaCountGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int	count;

	for(count=0;count<WAZA_TEMOTI_MAX;count++){
		if(sp->psp[client_no].waza[count]==0){
			break;
		}
	}

	return count;
}

//============================================================================================
/**
 *	_[W̃`FbNpf[^e[u
 */
//============================================================================================
//ڂe[u
static	u16	BouonWazaTable[]={
	WAZANO_NAKIGOE,
	WAZANO_HOERU,
	WAZANO_UTAU,
	WAZANO_TYOUONPA,
	WAZANO_IYANAOTO,
	WAZANO_IBIKI,
	WAZANO_SAWAGU,
	WAZANO_KINZOKUON,
	WAZANO_KUSABUE,
	WAZANO_HAIPAABOISU,
	WAZANO_MUSINOSAZAMEKI,
	WAZANO_OSYABERI,
};

//============================================================================================
/**
 *	_[W̃`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	attack		UClientNo
 *	@param[in]	defence		h䂷ClientNo
 */
//============================================================================================
int		ST_ServerDamageTokuseiCheck(SERVER_PARAM *sp,int attack,int defence)
{
	int	seq_no;
	int	wazatype;

	seq_no=0;

	//m[}XĹAZ^Cvm[}ɂ
	if(ST_ServerTokuseiGet(sp,attack)==TOKUSYU_NOOMARUSUKIN){
		wazatype=NORMAL_TYPE;
	}
	else if(sp->waza_type){
		wazatype=sp->waza_type;
	}
	else{
//		wazatype=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype);
		wazatype=sp->AIWT.wtd[sp->waza_no_now].wazatype;
	}

	//ł`FbN
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TIKUDEN)==TRUE){
		if((wazatype==ELECTRIC_TYPE)&&(attack!=defence)){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[defence].hpmax,4);
			seq_no=SUB_SEQ_TOKUSEI_HP_KAIFUKU;
		}
	}
	//傷`FbN
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TYOSUI)==TRUE){
		if((wazatype==WATER_TYPE)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage))){
		   (sp->AIWT.wtd[sp->waza_no_now].damage)){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[defence].hpmax,4);
			seq_no=SUB_SEQ_TOKUSEI_HP_KAIFUKU;
		}
	}
	//炢у`FbN
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_MORAIBI)==TRUE){
		if((wazatype==FIRE_TYPE)&&
		  ((sp->psp[defence].condition&CONDITION_KOORI)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage))){
		  ((sp->AIWT.wtd[sp->waza_no_now].damage)||(sp->waza_no_now==WAZANO_ONIBI))){
			seq_no=SUB_SEQ_MORAIBI;
		}
	}
	//ڂ`FbN
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_BOUON)==TRUE){
		{
			int	no;

			for(no=0;no<NELEMS(BouonWazaTable);no++){
				if(BouonWazaTable[no]==sp->waza_no_now){
					seq_no=SUB_SEQ_BOUON;
					break;
				}
			}
		}
	}
	//ł񂫃GW`FbN	
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_DENKIENZIN)==TRUE){
		if((wazatype==ELECTRIC_TYPE)&&(attack!=defence)){
			seq_no=SUB_SEQ_DENKIENZIN;
		}
	}
	//񂻂͂`FbN
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_KANSOUHADA)==TRUE){
		if((wazatype==WATER_TYPE)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage))){
		   (sp->AIWT.wtd[sp->waza_no_now].damage)){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[defence].hpmax,4);
			seq_no=SUB_SEQ_TOKUSEI_HP_KAIFUKU;
		}
	}

	return seq_no;
}

//============================================================================================
/**
 *	^[`FbN̓̃`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 */
//============================================================================================
BOOL	ST_ServerPCCTokuseiCheck(SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		seq_no;

	ret=FALSE;

	switch(ST_ServerTokuseiGet(sp,client_no)){
	//
	case TOKUSYU_KASOKU:
		if((sp->psp[client_no].hp)&&
		   (sp->psp[client_no].abiritycnt[COND_AGI]<12)&&
		   //oĂŏ̃^[́A𖳎
		   (sp->psp[client_no].wkw.nekodamashi_count!=sp->total_turn+1)){
			sp->tsuika_para=ADD_COND2_AGIUP;
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=client_no;
			seq_no=SUB_SEQ_ABICNT_CALC;
			ret=TRUE;
		}
		break;
	//
	case TOKUSYU_DAPPI:
#ifdef PM_DEBUG
		if((sp->psp[client_no].condition&CONDITION_BAD)&&
		   (sp->psp[client_no].hp)&&
		   ((gf_rand()%10<3)||(sp->dbp.debug_flag&DEBUG_FLAG_TOKUSYU))){
#else
		if((sp->psp[client_no].condition&CONDITION_BAD)&&
		   (sp->psp[client_no].hp)&&
		   (gf_rand()%10<3)){
#endif
			if(sp->psp[client_no].condition&CONDITION_NEMURI){
				sp->msg_work=MSG_COND_NEMURI;
			}
			else if(sp->psp[client_no].condition&CONDITION_DOKUALL){
				sp->msg_work=MSG_COND_DOKU;
			}
			else if(sp->psp[client_no].condition&CONDITION_YAKEDO){
				sp->msg_work=MSG_COND_YAKEDO;
			}
			else if(sp->psp[client_no].condition&CONDITION_MAHI){
				sp->msg_work=MSG_COND_MAHI;
			}
			else{
				sp->msg_work=MSG_COND_KOORI;
			}
			sp->client_work=client_no;
			seq_no=SUB_SEQ_DAPPI;
			ret=TRUE;
		}
		break;
	default:
		break;
	}
	if(ret==TRUE){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	}

	return ret;
}

//============================================================================================
/**
 *	_[WvZp̊ZsiʂO̎́A1or-1␳
 *
 *	@param[in]	data	鐔
 *	@param[in]	value	鐔
 *
 *	@retval	
 */
//============================================================================================
int		ST_ServerDamageDiv(int data,int value)
{
	int	zero_flag;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/03/28
// 0ŊƂɒl1ɂȂs̏C𔽉f

#if AFTER_MASTER_070320_BT5_EUR_FIX
	//鐔0̎͂̂܂ܕԂ
	if(data==0){
		return data;
	}
#endif //AFTER_MASTER_070320_BT5_EUR_FIX

// ----------------------------------------------------------------------------

	if(data<0){
		zero_flag=-1;
	}
	else{
		zero_flag=1;
	}

	data/=value;

	if(data==0){
		data=zero_flag;
	}

	return data;
}

//============================================================================================
//			ST_ServerPokeAppearCheck̃V[PXio[
//============================================================================================
enum{
	SPAC_WEATHER=0,
	SPAC_TRACE,
	SPAC_WEATHER_TOKUSEI,
	SPAC_IKAKU,
	SPAC_DOWNLOAD,
	SPAC_KIKENYOCHI,
	SPAC_YOCHIMU,
	SPAC_OMITOOSHI,
	SPAC_SLOWSTART,
	SPAC_KATAYABURI,
	SPAC_PRESSURE,
	SPAC_TENKIYA,
	SPAC_OKANE2BAI,
	SPAC_CONDITION_BAD_TOKUSEI,
	SPAC_CONDITION_BAD,
	SPAC_END
};

enum{
	SPAC_LOOP=0,
	SPAC_WAZA_SEQ,
	SPAC_CHECK_END
};

//============================================================================================
/**
 *	|Poꎞ̃`FbNȂ
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 *
 * @retval	`FbNɈɋNSUB_SEQ_NO
 */
//============================================================================================
int	ST_ServerPokeAppearCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i,j;
	int	seq_no;
	int	ret;
	int	client_no;
	int	client_set_max;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	seq_no=0;
	ret=SPAC_LOOP;

	do{
		switch(sp->spac_seq_no){
		//V`FbN
		case SPAC_WEATHER:
			if(sp->weather_check_flag==0){
				switch(BattleWorkWeatherGet(bw)){
				case WEATHER_SYS_RAIN:			// J
				case WEATHER_SYS_STRAIN:		// J
				case WEATHER_SYS_SPARK:			// J
					seq_no=SUB_SEQ_FIELD_AME;
					ret=SPAC_WAZA_SEQ;
					break;
				case WEATHER_SYS_SNOW:			// 
				case WEATHER_SYS_SNOWSTORM:		// 
				case WEATHER_SYS_SNOWSTORM_H:	// Ґ
					seq_no=SUB_SEQ_FIELD_ARARE;
					ret=SPAC_WAZA_SEQ;
					break;
				case WEATHER_SYS_SANDSTORM:		// BGgp
					seq_no=SUB_SEQ_FIELD_SUNAARASHI;
					ret=SPAC_WAZA_SEQ;
					break;
				case WEATHER_SYS_MIST1:			// ̖
				case WEATHER_SYS_MIST2:			// ̖
					seq_no=SUB_SEQ_FIELD_HUKAIKIRI;
					ret=SPAC_WAZA_SEQ;
					break;
				}
				if(ret==SPAC_WAZA_SEQ){
					sp->weather_check_flag=1;
				}
			}
			sp->spac_seq_no++;
			break;
		//g[X`FbN
		case SPAC_TRACE:
			{
				int	def1,def2;
				
				for(i=0;i<client_set_max;i++){
					client_no=sp->psp_agi_work[i];
					def1=BattleWorkEnemyClientNoGet(bw,client_no,BWECNG_SIDE_RIGHT);
					def2=BattleWorkEnemyClientNoGet(bw,client_no,BWECNG_SIDE_LEFT);
					sp->defence_client_work=ST_ServerTraceClientNoGet(sp,def1,def2);
					if((sp->psp[client_no].trace_flag==0)&&
					   (sp->defence_client_work!=NONE_CLIENT_NO)&&
					   (sp->psp[client_no].hp)&&
					   (sp->psp[sp->defence_client_work].hp)&&
					   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_TOREESU)){
						sp->psp[client_no].trace_flag=1;
						sp->client_work=client_no;
						seq_no=SUB_SEQ_TRACE;
						ret=SPAC_WAZA_SEQ;
						break;
					}
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		
		case SPAC_WEATHER_TOKUSEI:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].appear_check_flag==0)&&
				   (sp->psp[client_no].hp)){
					switch(ST_ServerTokuseiGet(sp,client_no)){
					//߂ӂ炵
					case TOKUSYU_AMEHURASI:
						sp->psp[client_no].appear_check_flag=1;
						if((sp->field_condition&FIELD_CONDITION_AMEHURASHI)==0){
							seq_no=SUB_SEQ_AMEHURASI;
							ret=SPAC_WAZA_SEQ;
						}
						break;
					//Ȃ
					case TOKUSYU_SUNAOKOSI:
						sp->psp[client_no].appear_check_flag=1;
						if((sp->field_condition&FIELD_CONDITION_SUNAOKOSHI)==0){
							seq_no=SUB_SEQ_SUNAOKOSI;
							ret=SPAC_WAZA_SEQ;
						}
						break;
					//Ђł
					case TOKUSYU_HIDERI:
						sp->psp[client_no].appear_check_flag=1;
						if((sp->field_condition&FIELD_CONDITION_HIDERI)==0){
							seq_no=SUB_SEQ_HIDERI;
							ret=SPAC_WAZA_SEQ;
						}
						break;
					//䂫ӂ炵
					case TOKUSYU_YUKIHURASI:
						sp->psp[client_no].appear_check_flag=1;
						if((sp->field_condition&FIELD_CONDITION_YUKIHURASHI)==0){
							seq_no=SUB_SEQ_YUKIHURASI;
							ret=SPAC_WAZA_SEQ;
						}
						break;
					}
				}
				if(ret==SPAC_WAZA_SEQ){
					sp->client_work=client_no;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//`FbN
		case SPAC_IKAKU:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].ikaku_flag==0)&&
				   (sp->psp[client_no].hp)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_IKAKU)){
					sp->psp[client_no].ikaku_flag=1;
					sp->client_work=client_no;
					seq_no=SUB_SEQ_IKAKU;
					ret=SPAC_WAZA_SEQ;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//_E[h`FbN
		case SPAC_DOWNLOAD:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].download_flag==0)&&
				   (sp->psp[client_no].hp)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_DAUNROODO)){
					{
						int	no;
						int	def,spedef;

						def=0;
						spedef=0;

						for(no=0;no<client_set_max;no++){
							if((BattleWorkMineEnemyCheck(bw,client_no)!=BattleWorkMineEnemyCheck(bw,no))&&
							  ((sp->psp[no].condition2&CONDITION2_MIGAWARI)==0)&&
							   (sp->psp[no].hp)){
								def+=sp->psp[no].def*
									 CondChgTable[sp->psp[no].abiritycnt[COND_DEF]][0]/
									 CondChgTable[sp->psp[no].abiritycnt[COND_DEF]][1];
								spedef+=sp->psp[no].spedef*
									 CondChgTable[sp->psp[no].abiritycnt[COND_SPEDEF]][0]/
									 CondChgTable[sp->psp[no].abiritycnt[COND_SPEDEF]][1];
							}
						}
						sp->psp[client_no].download_flag=1;
						if((def+spedef)!=0){
							if(def>=spedef){
								sp->tsuika_para=ADD_COND2_SPEPOWUP;
							}
							else{
								sp->tsuika_para=ADD_COND2_POWUP;
							}
							sp->tsuika_type=ADD_STATUS_TOKUSEI;
							sp->tsuika_client=client_no;
							seq_no=SUB_SEQ_ABICNT_CALC;
							ret=SPAC_WAZA_SEQ;
							break;
						}
					}
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//悿
		case SPAC_KIKENYOCHI:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].kikenyochi_flag==0)&&
				   (sp->psp[client_no].hp)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KIKENYOTI)){
					sp->psp[client_no].kikenyochi_flag=1;
					{
						int	no,pos;
						u16	waza_no;
						u32	flag;

						for(no=0;no<client_set_max;no++){
							if((BattleWorkMineEnemyCheck(bw,client_no)!=BattleWorkMineEnemyCheck(bw,no))&&(sp->psp[no].hp)){
								for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
									waza_no=sp->psp[no].waza[pos];
									if(waza_no){
										flag=0;
										sp->damage=ST_ServerTypeCheck(bw,sp,waza_no,NULL,no,client_no,sp->damage,&flag);
										//悿́AʔQAꌂKE̋Zɑ΂ČxbZ[Wo
										if(((flag&WAZA_STATUS_FLAG_KOUKANAI)==0)&&
											(ST_ServerKikenyochiWazaSeqCheck(sp,waza_no)==FALSE)&&
										   ((flag&WAZA_STATUS_FLAG_BATSUGUN)||
										   ((sp->AIWT.wtd[waza_no].battleeffect==38)&&
											(sp->psp[client_no].level<=sp->psp[no].level)))){
											ret=SPAC_WAZA_SEQ;
											break;
										}
									}
								}
								if(ret==SPAC_WAZA_SEQ){
									break;
								}
							}
						}
						if(ret==SPAC_WAZA_SEQ){
							sp->client_work=client_no;
							seq_no=SUB_SEQ_KIKENYOCHI;
						}
						break;
					}
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//悿
		case SPAC_YOCHIMU:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].yochimu_flag==0)&&
				   (sp->psp[client_no].hp)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_YOTIMU)){
					sp->psp[client_no].yochimu_flag=1;
					{
						int	no,pos;
						u16	waza_no;
						u32	pow,pow_temp;
						int	hp;

						pow_temp=0;
						hp=0;

						for(no=0;no<client_set_max;no++){
							if((BattleWorkMineEnemyCheck(bw,client_no)!=BattleWorkMineEnemyCheck(bw,no))&&(sp->psp[no].hp)){
								hp+=sp->psp[no].hp;
								for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
									waza_no=sp->psp[no].waza[pos];
//									pow=WT_WazaDataParaGet(waza_no,ID_WTD_damage);
									pow=sp->AIWT.wtd[waza_no].damage;
									switch(pow){
									//З͂P
									case 1:
//										switch(WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)){
										switch(sp->AIWT.wtd[waza_no].battleeffect){
										//ꌂKE
										case 38:
											if((pow_temp<150)||
											  ((pow_temp==150)&&(gf_rand()&1))){
												pow_temp=150;
												sp->waza_work=waza_no;
											}
											break;
										//JE^[
										//~[R[g
										//
										case 89:
										case 144:
										case 227:
											if((pow_temp<120)||
											  ((pow_temp==120)&&(gf_rand()&1))){
												pow_temp=120;
												sp->waza_work=waza_no;
											}
											break;
										default:
											if((pow_temp<80)||
											  ((pow_temp==80)&&(gf_rand()&1))){
												pow_temp=80;
												sp->waza_work=waza_no;
											}
											break;
										}
										break;
									default:
										if((pow_temp<pow)||
										  ((pow_temp==pow)&&(gf_rand()&1))){
											pow_temp=pow;
											sp->waza_work=waza_no;
										}
										break;
									}
								}
							}
						}
						if(pow_temp){
							sp->client_work=client_no;
							seq_no=SUB_SEQ_YOCHIMU;
							ret=SPAC_WAZA_SEQ;
						}
						//Ȃꍇ́AĂZ烉_őI
						else if(hp){
							no=ST_ServerDirClientGet(bw,sp,client_no);
							pos=ST_ServerWazaCountGet(bw,sp,no);
							sp->waza_work=sp->psp[no].waza[gf_rand()%pos];
							sp->client_work=client_no;
							seq_no=SUB_SEQ_YOCHIMU;
							ret=SPAC_WAZA_SEQ;
						}
						break;
					}
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//݂Ƃ
		case SPAC_OMITOOSHI:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].omitooshi_flag==0)&&
				   (sp->psp[client_no].hp)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_OMITOOSI)){
					sp->psp[client_no].omitooshi_flag=1;
					if(BattleWorkFightTypeGet(bw)&FIGHT_TYPE_2vs2){
						{
							int	def[2];

							def[0]=BattleWorkEnemyClientNoGet(bw,client_no,BWECNG_SIDE_RIGHT);
							def[1]=BattleWorkEnemyClientNoGet(bw,client_no,BWECNG_SIDE_LEFT);

							if((sp->psp[def[0]].hp)&&(sp->psp[def[0]].item)&&
							   (sp->psp[def[1]].hp)&&(sp->psp[def[1]].item)){
								sp->item_work=sp->psp[def[gf_rand()&1]].item;
								ret=SPAC_WAZA_SEQ;
							}
							else if((sp->psp[def[0]].hp)&&(sp->psp[def[0]].item)){
								sp->item_work=sp->psp[def[0]].item;
								ret=SPAC_WAZA_SEQ;
							}
							else if((sp->psp[def[1]].hp)&&(sp->psp[def[1]].item)){
								sp->item_work=sp->psp[def[1]].item;
								ret=SPAC_WAZA_SEQ;
							}
						}
					}
					else{
						if((sp->psp[client_no^1].hp)&&(sp->psp[client_no^1].item)){
							sp->item_work=sp->psp[client_no^1].item;
							ret=SPAC_WAZA_SEQ;
						}
					}
				}
				if(ret==SPAC_WAZA_SEQ){
					sp->client_work=client_no;
					seq_no=SUB_SEQ_OMITOOSHI;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//X[X^[g
		case SPAC_SLOWSTART:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				//^[ƌʐ؂^[ɃbZ[W
				if((sp->psp[client_no].slow_start_flag==0)&&
				   (sp->psp[client_no].hp)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_SUROOSUTAATO)&&
				   (sp->total_turn<=sp->psp[client_no].wkw.slow_start_count)){
					sp->psp[client_no].slow_start_flag=1;
					sp->client_work=client_no;
					seq_no=SUB_SEQ_SLOWSTART;
					ret=SPAC_WAZA_SEQ;
					break;
				}
				if((sp->psp[client_no].slow_start_end_flag==0)&&
				   (sp->psp[client_no].hp)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_SUROOSUTAATO)&&
				  ((sp->total_turn-sp->psp[client_no].wkw.slow_start_count)==5)){
					sp->psp[client_no].slow_start_end_flag=1;
					sp->client_work=client_no;
					seq_no=SUB_SEQ_SLOWSTART_END;
					ret=SPAC_WAZA_SEQ;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//Ԃ
		case SPAC_KATAYABURI:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].katayaburi_flag==0)&&
				   (sp->psp[client_no].hp)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KATAYABURI)){
					sp->psp[client_no].katayaburi_flag=1;
					sp->client_work=client_no;
					seq_no=SUB_SEQ_KATAYABURI;
					ret=SPAC_WAZA_SEQ;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//vbV[
		case SPAC_PRESSURE:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if((sp->psp[client_no].pressure_flag==0)&&
				   (sp->psp[client_no].hp)&&
				   (ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_PURESSYAA)){
					sp->psp[client_no].pressure_flag=1;
					sp->client_work=client_no;
					seq_no=SUB_SEQ_PRESSURE;
					ret=SPAC_WAZA_SEQ;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//Ă񂫂
		case SPAC_TENKIYA:
			if(ST_ServerTenkiyaCheck(bw,sp)==TRUE){
				seq_no=SUB_SEQ_TENKIYA;
				ret=SPAC_WAZA_SEQ;
			}
			else{
				sp->spac_seq_no++;
			}
			break;
		//ʂ2{
		case SPAC_OKANE2BAI:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if(ST_ItemParamGet(sp,sp->psp[client_no].item,ITEM_PRM_EQUIP)==SOUBI_OKANENIBAI){
					sp->okodukai_value=2;	///<̔{[N
				}
			}
			sp->spac_seq_no++;
			break;
		case SPAC_CONDITION_BAD_TOKUSEI:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if(ST_ServerTokuseiStatusRecoverCheck(bw,sp,client_no,1)==TRUE){
					seq_no=SUB_SEQ_TOKUSEI_CONDITION_RECOVER;
					ret=SPAC_WAZA_SEQ;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		case SPAC_CONDITION_BAD:
			for(i=0;i<client_set_max;i++){
				client_no=sp->psp_agi_work[i];
				if(ST_ServerSoubiItemConditionBadCheck(bw,sp,client_no,&seq_no)==TRUE){
					sp->client_work=client_no;
					ret=SPAC_WAZA_SEQ;
					break;
				}
			}
			if(i==client_set_max){
				sp->spac_seq_no++;
			}
			break;
		//`FbNI
		case SPAC_END:
			sp->spac_seq_no=0;
			ret=SPAC_CHECK_END;
			break;
		}
	}while(ret==SPAC_LOOP);

	return seq_no;
}

//============================================================================================
/**
 *	葤2̂̂1̂_őIi1vs1̎͑fɑ葤Ij
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	`FbNClientNo
 *
 * @retval	IClientNo
 */
//============================================================================================
int	ST_ServerDirClientGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	u32	fight_type;
	int	defence;
	int	def[2];
	int	i;

	fight_type=BattleWorkFightTypeGet(bw);

	if(fight_type&FIGHT_TYPE_2vs2){
		def[0]=BattleWorkEnemyClientNoGet(bw,client_no,BWECNG_SIDE_RIGHT);
		def[1]=BattleWorkEnemyClientNoGet(bw,client_no,BWECNG_SIDE_LEFT);
		i=gf_rand()&1;
		defence=def[i];
		if(sp->psp[defence].hp==0){
			defence=def[i^1];
		}
	}
	else{
		defence=client_no^1;
	}

	return defence;
}

//============================================================================================
/**
 *	ZqbgɃ`FbN
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	seq_no		seq_no|C^[N
 *
 * @retval	TRUE:@FALSE:s
 */
//============================================================================================
BOOL	ST_ServerWazaHitTokuseiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no)
{
	BOOL	ret;

	ret=FALSE;

	//UΏۂȂ΁A`FbNȂ
	if(sp->defence_client==NONE_CLIENT_NO){
		return ret;
	}

	//݂ł͕s
	if(ST_ServerMigawariCheck(sp,sp->defence_client)==TRUE){
		return ret;
	}

	switch(ST_ServerTokuseiGet(sp,sp->defence_client)){
	//ł
	case TOKUSYU_SEIDENKI:
#ifdef PM_DEBUG
		if((sp->psp[sp->attack_client].hp)&&
		   (sp->psp[sp->attack_client].condition==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)&&
		  ((gf_rand()%10<3)||(sp->dbp.debug_flag&DEBUG_FLAG_TOKUSYU))){
#else
		if((sp->psp[sp->attack_client].hp)&&
		   (sp->psp[sp->attack_client].condition==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)&&
		   (gf_rand()%10<3)){
#endif
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=sp->attack_client;
			sp->client_work=sp->defence_client;
			seq_no[0]=SUB_SEQ_MAHI;
			ret=TRUE;
		}
		break;
	//ւ񂵂傭
	case TOKUSYU_HENSYOKU:
		{
			u8	wazatype;

			//m[}XĹAZ^Cvm[}ɂ
			if(ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_NOOMARUSUKIN){
				wazatype=NORMAL_TYPE;
			}
			else if(sp->waza_type){
				wazatype=sp->waza_type;
			}
			else{
//				wazatype=WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_wazatype);
				wazatype=sp->AIWT.wtd[sp->waza_no_now].wazatype;
			}

			if((sp->psp[sp->defence_client].hp)&&
			  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
			   (sp->waza_no_now!=WAZANO_WARUAGAKI)&&
			  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
			   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
				//Ƃڂւł́AȂ
			  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
//			   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_damage))&&
			   (sp->AIWT.wtd[sp->waza_no_now].damage)&&
			   (ST_ServerPokemonServerParamGet(sp,sp->defence_client,ID_PSP_type1,NULL)!=wazatype)&&
			   (ST_ServerPokemonServerParamGet(sp,sp->defence_client,ID_PSP_type2,NULL)!=wazatype)){
				seq_no[0]=SUB_SEQ_HENSYOKU;
				sp->msg_work=wazatype;
				ret=TRUE;
			}
		}
		break;
	//߂͂
	case TOKUSYU_SAMEHADA:
		if((sp->psp[sp->attack_client].hp)&&
			//}WbNK[h́A߂͂̌ʂ󂯂Ȃ
		   (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_MAZIKKUGAADO)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)){
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*-1,8);
			sp->client_work=sp->attack_client;
			seq_no[0]=SUB_SEQ_SAMEHADA;
			ret=TRUE;
		}
		break;
	//ق
	case TOKUSYU_HOUSI:
#ifdef PM_DEBUG
		if((sp->psp[sp->attack_client].hp)&&
		   (sp->psp[sp->attack_client].condition==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		  //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)&&
		  ((gf_rand()%10<3)||(sp->dbp.debug_flag&DEBUG_FLAG_TOKUSYU))){
#else
		if((sp->psp[sp->attack_client].hp)&&
		   (sp->psp[sp->attack_client].condition==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)&&
		   (gf_rand()%10<3)){
#endif
			switch(gf_rand()%3){
			case 0:
			default:
				seq_no[0]=SUB_SEQ_DOKU;
				break;
			case 1:
				seq_no[0]=SUB_SEQ_MAHI;
				break;
			case 2:
				seq_no[0]=SUB_SEQ_NEMURI;
				break;
			}
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=sp->attack_client;
			sp->client_work=sp->defence_client;
			ret=TRUE;
		}
		break;
	//ǂ̂Ƃ
	case TOKUSYU_DOKUNOTOGE:
#ifdef PM_DEBUG
		if((sp->psp[sp->attack_client].hp)&&
		   (sp->psp[sp->attack_client].condition==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)&&
		  ((gf_rand()%10<3)||(sp->dbp.debug_flag&DEBUG_FLAG_TOKUSYU))){
#else
		if((sp->psp[sp->attack_client].hp)&&
		   (sp->psp[sp->attack_client].condition==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)&&
		   (gf_rand()%10<3)){
#endif
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=sp->attack_client;
			sp->client_work=sp->defence_client;
			seq_no[0]=SUB_SEQ_DOKU;
			ret=TRUE;
		}
		break;
	//ق̂̂炾
	case TOKUSYU_HONOONOKARADA:
#ifdef PM_DEBUG
		if((sp->psp[sp->attack_client].hp)&&
		   (sp->psp[sp->attack_client].condition==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)&&
		  ((gf_rand()%10<3)||(sp->dbp.debug_flag&DEBUG_FLAG_TOKUSYU))){
#else
		if((sp->psp[sp->attack_client].hp)&&
		   (sp->psp[sp->attack_client].condition==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)&&
		   (gf_rand()%10<3)){
#endif
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=sp->attack_client;
			sp->client_work=sp->defence_client;
			seq_no[0]=SUB_SEQ_YAKEDO;
			ret=TRUE;
		}
		break;
	//{fB
	case TOKUSYU_MEROMEROBODHI:
#ifdef PM_DEBUG
		if((sp->psp[sp->attack_client].hp)&&
		  ((sp->psp[sp->attack_client].condition2&CONDITION2_MEROMERO)==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)&&
		   (sp->psp[sp->defence_client].hp)&&
		  ((gf_rand()%10<3)||(sp->dbp.debug_flag&DEBUG_FLAG_TOKUSYU))){
#else
		if((sp->psp[sp->attack_client].hp)&&
		  ((sp->psp[sp->attack_client].condition2&CONDITION2_MEROMERO)==0)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)&&
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)&&
		   (sp->psp[sp->defence_client].hp)&&
		   (gf_rand()%10<3)){
#endif
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			sp->tsuika_client=sp->attack_client;
			sp->client_work=sp->defence_client;
			seq_no[0]=SUB_SEQ_MEROMERO;
			ret=TRUE;
		}
		break;
	//䂤΂
	case TOKUSYU_YUUBAKU:
		if((sp->defence_client==sp->kizetsu_client)&&
			//}WbNK[h́A䂤΂̌ʂ󂯂Ȃ
		   (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_MAZIKKUGAADO)&&
		   //߂肯鎞́A䂤΂łȂ
		   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_SIMERIKE)==0)&&
		   //Ƃڂւł́AȂ
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
		   (sp->psp[sp->attack_client].hp)&&
		  ((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)==0)&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)){
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*-1,4);
			sp->client_work=sp->attack_client;
			seq_no[0]=SUB_SEQ_YUUBAKU;
			ret=TRUE;
		}
		break;
	default:
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	ZqbgɃ`FbNiXLXbvȂǂŁAւďԈُ𒼂`FbNj
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	`FbNClientNo
 * @param[in]	act_flag	tOi0:Kvȃ[Nɂׂđ@1:V[PXio[ނ̑͂Ȃj
 *
 * @retval	TRUE:@FALSE:s
 */
//============================================================================================
BOOL	ST_ServerTokuseiStatusRecoverCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int act_flag)
{
	BOOL	ret;

	ret=FALSE;

	switch(ST_ServerTokuseiGet(sp,client_no)){
	case TOKUSYU_MENEKI:
		if(sp->psp[client_no].condition&CONDITION_DOKUALL){
			sp->msg_work=MSG_COND_DOKU;
			ret=TRUE;
		}
		break;
	case TOKUSYU_MAIPEESU:
		if(sp->psp[client_no].condition2&CONDITION2_KONRAN){
			sp->msg_work=MSG_COND_KONRAN;
			ret=TRUE;
		}
		break;
	case TOKUSYU_ZYUUNAN:
		if(sp->psp[client_no].condition&CONDITION_MAHI){
			sp->msg_work=MSG_COND_MAHI;
			ret=TRUE;
		}
		break;
	case TOKUSYU_HUMIN:
	case TOKUSYU_YARUKI:
		if(sp->psp[client_no].condition&CONDITION_NEMURI){
			sp->msg_work=MSG_COND_NEMURI;
			ret=TRUE;
		}
		break;
	case TOKUSYU_MIZUNOBEERU:
		if(sp->psp[client_no].condition&CONDITION_YAKEDO){
			sp->msg_work=MSG_COND_YAKEDO;
			ret=TRUE;
		}
		break;
	case TOKUSYU_MAGUMANOYOROI:
		if(sp->psp[client_no].condition&CONDITION_KOORI){
			sp->msg_work=MSG_COND_KOORI;
			ret=TRUE;
		}
		break;
	case TOKUSYU_DONKAN:
		if(sp->psp[client_no].condition2&CONDITION2_MEROMERO){
			sp->msg_work=MSG_COND_MEROMERO;
			ret=TRUE;
		}
		break;
	case TOKUSYU_KARUWAZA:
		//ǂڂgbNŃACe肵ɃtO𗧂Ă
		if(sp->psp[client_no].item){
			sp->psp[client_no].wkw.karuwaza_flag=1;
		}
		break;
	}
	if(ret==TRUE){
		sp->client_work=client_no;
		sp->tokusei_work=ST_ServerTokuseiGet(sp,client_no);
		if(act_flag==0){
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TOKUSEI_CONDITION_RECOVER);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	ւɏԈُ𒼂`FbN
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	tokusei		`FbN
 * @param[in]	condition	`FbNԈُ
 *
 * @retval	TRUE:@FALSE:s
 */
//============================================================================================
BOOL	ST_ServerTokuseiStatusRecoverReshuffleCheck(SERVER_PARAM *sp,int tokusei,int condition)
{
	BOOL	ret;

	ret=FALSE;

	switch(tokusei){
	case TOKUSYU_MENEKI:
		if(condition&CONDITION_DOKUALL){
			ret=TRUE;
		}
		break;
	case TOKUSYU_ZYUUNAN:
		if(condition&CONDITION_MAHI){
			ret=TRUE;
		}
		break;
	case TOKUSYU_HUMIN:
	case TOKUSYU_YARUKI:
		if(condition&CONDITION_NEMURI){
			ret=TRUE;
		}
		break;
	case TOKUSYU_MIZUNOBEERU:
		if(condition&CONDITION_YAKEDO){
			ret=TRUE;
		}
		break;
	case TOKUSYU_MAGUMANOYOROI:
		if(condition&CONDITION_KOORI){
			ret=TRUE;
		}
		break;
	}

	return ret;
}

//============================================================================================
/**
 *	ZqbgɃ`FbNiVN̂݁j
 *
 * @param[in]	bw				퓬VXep[N\
 * @param[in]	sp				T[opp[^[N\
 * @param[in]	server_seq_no	sp->next_server_seq_noɃZbgio[
 *
 * @retval	TRUE:@FALSE:s
 */
//============================================================================================
BOOL	ST_ServerSinkuroCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int server_seq_no)
{
	BOOL	ret;
	int		seq_no;

	ret=FALSE;

// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if AFTER_MASTER_061113_2_FIX

	seq_no=0;

	//h䑤`FbN
	if((ST_ServerTokuseiGet(sp,sp->defence_client)==TOKUSYU_SINKURO)&&
	   (sp->defence_client!=NONE_CLIENT_NO)&&
	   (sp->defence_client==sp->tsuika_client)&&
	   (sp->server_status_flag&SERVER_STATUS_FLAG_SINKURO_TSUIKA)){
		sp->client_work=sp->defence_client;
		sp->tsuika_client=sp->attack_client;
		ret=TRUE;
	}
	//U`FbN
	else if((ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_SINKURO)&&
	   (sp->attack_client==sp->tsuika_client)&&
	   (sp->server_status_flag&SERVER_STATUS_FLAG_SINKURO_TSUIKA)){
		sp->client_work=sp->attack_client;
		sp->tsuika_client=sp->defence_client;
		ret=TRUE;
	}

	if(ret==TRUE){
		if(sp->psp[sp->client_work].condition&CONDITION_DOKUALL){
			seq_no=SUB_SEQ_DOKU;
		}
		else if(sp->psp[sp->client_work].condition&CONDITION_YAKEDO){
			seq_no=SUB_SEQ_YAKEDO;
		}
		else if(sp->psp[sp->client_work].condition&CONDITION_MAHI){
			seq_no=SUB_SEQ_MAHI;
		}
		if(seq_no){
			sp->tsuika_type=ADD_STATUS_TOKUSEI;
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
			sp->next_server_seq_no=server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;

			return ret;
		}
	}
#else AFTER_MASTER_061113_2_FIX
	//h䑤`FbN
	if((ST_ServerTokuseiGet(sp,sp->defence_client)==TOKUSYU_SINKURO)&&
	   (sp->defence_client!=NONE_CLIENT_NO)&&
	   (sp->defence_client==sp->tsuika_client)&&
	   (sp->server_status_flag&SERVER_STATUS_FLAG_SINKURO_TSUIKA)){
		sp->client_work=sp->defence_client;
		sp->tsuika_client=sp->attack_client;
		ret=TRUE;
	}
	//U`FbN
	else if((ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_SINKURO)&&
	   (sp->attack_client==sp->tsuika_client)&&
	   (sp->server_status_flag&SERVER_STATUS_FLAG_SINKURO_TSUIKA)){
		sp->client_work=sp->attack_client;
		sp->tsuika_client=sp->defence_client;
		ret=TRUE;
	}

	if(ret==TRUE){
		if(sp->psp[sp->client_work].condition&CONDITION_DOKUALL){
			seq_no=SUB_SEQ_DOKU;
		}
		else if(sp->psp[sp->client_work].condition&CONDITION_YAKEDO){
			seq_no=SUB_SEQ_YAKEDO;
		}
		else{
			seq_no=SUB_SEQ_MAHI;
		}
		sp->tsuika_type=ADD_STATUS_TOKUSEI;
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;

		return ret;
	}
#endif AFTER_MASTER_061113_2_FIX
// ----------------------------------------------------------------------------

	//Ă񂫂^C~O͂Ȃ̂Ń`FbN
	ret=ST_ServerTenkiyaCheck(bw,sp);
	if(ret==TRUE){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,SUB_SEQ_TENKIYA);
		sp->next_server_seq_no=server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		return ret;
	}

	//`FbN^C~O͓Ȃ̂ŁAACeuƁv`FbN
	//h䑤`FbN
	if((ST_ServerSoubiEqpGet(sp,sp->defence_client)==SOUBI_MEROMERODETEKIMOMEROMERO)&&
	   (sp->defence_client!=NONE_CLIENT_NO)&&
	   (sp->defence_client==sp->tsuika_client)&&
	   (sp->ostf[sp->defence_client].status_flag&OSTF_STATUS_FLAG_MEROMERO)){
		sp->client_work=sp->defence_client;
		sp->tsuika_client=sp->attack_client;
		ret=TRUE;
	}
	//U`FbN
	else if((ST_ServerSoubiEqpGet(sp,sp->attack_client)==SOUBI_MEROMERODETEKIMOMEROMERO)&&
	   (sp->attack_client==sp->tsuika_client)&&
	   (sp->ostf[sp->attack_client].status_flag&OSTF_STATUS_FLAG_MEROMERO)){
		sp->client_work=sp->attack_client;
		sp->tsuika_client=sp->defence_client;
		ret=TRUE;
	}

	if(ret==TRUE){
		seq_no=SUB_SEQ_MEROMERO;
		sp->tsuika_type=ADD_STATUS_SOUBIITEM;
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;

		return ret;
	}

	return FALSE;
}

//============================================================================================
/**
 *	^[`FbN̑ACeʂ̃`FbN
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:ȂɂȂ	TRUE:ʔ
 */
//============================================================================================
BOOL	ST_ServerSoubiItemCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		seq_no;
	int		eqp;
	int		atk;

	ret=FALSE;

	eqp=ST_ServerSoubiEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no,ATK_CHECK_NORMAL);

	if(sp->psp[client_no].hp){
		switch(eqp){
		case SOUBI_HPKAIHUKU:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=atk;
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				ret=TRUE;
			}
			break;
		case SOUBI_HPKAIHUKUHIRITU:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*atk,100);
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				ret=TRUE;
			}
			break;
		case SOUBI_MAHINAOSI:
			if(sp->psp[client_no].condition&CONDITION_MAHI){
				seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
				ret=TRUE;
			}
			break;
		case SOUBI_NEMUKEZAMASI:
			if(sp->psp[client_no].condition&CONDITION_NEMURI){
				seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
				ret=TRUE;
			}
			break;
		case SOUBI_DOKUKESI:
			if(sp->psp[client_no].condition&CONDITION_DOKUALL){
				seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
				ret=TRUE;
			}
			break;
		case SOUBI_YAKEDONAOSI:
			if(sp->psp[client_no].condition&CONDITION_YAKEDO){
				seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
				ret=TRUE;
			}
			break;
		case SOUBI_KOORINAOSI:
			if(sp->psp[client_no].condition&CONDITION_KOORI){
				seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
				ret=TRUE;
			}
			break;
		case SOUBI_PPKAIHUKU:
			{
				int	pos;

				for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
					if((sp->psp[client_no].waza[pos])&&
					   (sp->psp[client_no].pp[pos]==0)){
						break;
					}
				}
				if(pos!=WAZA_TEMOTI_MAX){
					ST_PokemonServerParamAdd(&sp->psp[client_no],ID_PSP_pp1+pos,atk);
					ST_PSPtoPPCopy(bw,sp,client_no);
					sp->waza_work=sp->psp[client_no].waza[pos];
					seq_no=SUB_SEQ_EQPITEM_PP_KAIHUKU;
					ret=TRUE;
				}
			}
			break;
		case SOUBI_KONRANNAOSI:
			if(sp->psp[client_no].condition2&CONDITION2_KONRAN){
				seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
				ret=TRUE;
			}
			break;
		case SOUBI_ZYOUTAIIZYOUNAOSI:
			if((sp->psp[client_no].condition&CONDITION_BAD)||
			   (sp->psp[client_no].condition2&CONDITION2_KONRAN)){
				if(sp->psp[client_no].condition&CONDITION_MAHI){
					seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
				}
				if(sp->psp[client_no].condition&CONDITION_NEMURI){
					seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
				}
				if(sp->psp[client_no].condition&CONDITION_DOKUALL){
					seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
				}
				if(sp->psp[client_no].condition&CONDITION_YAKEDO){
					seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
				}
				if(sp->psp[client_no].condition&CONDITION_KOORI){
					seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
				}
				if(sp->psp[client_no].condition2&CONDITION2_KONRAN){
					seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
				}
				if((sp->psp[client_no].condition&CONDITION_BAD)&&
				   (sp->psp[client_no].condition2&CONDITION2_KONRAN)){
					seq_no=SUB_SEQ_EQPITEM_NO_JOUTAIIJOU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_KARAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_KARAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_KARAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_SIBUIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_SIBUI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_SIBUI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_AMAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_AMAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_AMAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_NIGAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_NIGAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_NIGAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_SUPPAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_SUPPAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_SUPPAI)==DISLIKE_TASTE){
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_KOUGEKIUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_POW]<12)){
				sp->msg_work=COND_POW;
				seq_no=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_BOUGYOUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_DEF]<12)){
				sp->msg_work=COND_DEF;
				seq_no=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_SUBAYASAUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_AGI]<12)){
				sp->msg_work=COND_AGI;
				seq_no=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_TOKUKOUUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_SPEPOW]<12)){
				sp->msg_work=COND_SPEPOW;
				seq_no=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_TOKUBOUUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_SPEDEF]<12)){
				sp->msg_work=COND_SPEDEF;
				seq_no=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_KURITHIKARUUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			  ((sp->psp[client_no].condition2&CONDITION2_KIAIDAME)==0)){
				seq_no=SUB_SEQ_EQPITEM_CRITICALUP;
				ret=TRUE;
			}
			break;
		case SOUBI_NOURYOKURNDUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk)){
				{
					int	i;

					for(i=0;i<5;i++){
						if(sp->psp[client_no].abiritycnt[COND_POW+i]<12){
							break;
						}
					}
					if(i!=5){
						do{
							i=gf_rand()%5;
						}while(sp->psp[client_no].abiritycnt[COND_POW+i]==12);
						sp->msg_work=COND_POW+i;
						seq_no=SUB_SEQ_EQPITEM_CONDUP_MAX;
						ret=TRUE;
					}
				}
			}
			break;
		case SOUBI_NOURYOKUKAIHUKU:
			{
				int	i;

				for(i=0;i<COND_MAX;i++){
					if(sp->psp[client_no].abiritycnt[i]<6){
						sp->psp[client_no].abiritycnt[i]=6;
						ret=TRUE;
					}
				}
				if(ret==TRUE){
					seq_no=SUB_SEQ_EQPITEM_ABIRITY_KAIHUKU;
				}
			}
			break;
		case SOUBI_MEROMERONAOSI:
			if(sp->psp[client_no].condition2&CONDITION2_MEROMERO){
				sp->msg_work=MSG_COND_MEROMERO;
				seq_no=SUB_SEQ_EQPITEM_NO_MEROMERO;
				ret=TRUE;
			}
			break;
		case SOUBI_ITIDODAKEMEITYUUUP:
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk)){
				seq_no=SUB_SEQ_EQPITEM_ONCE_HIT_UP;
				ret=TRUE;
			}
			break;
		case SOUBI_ITIDODAKESENSEI:
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk)){
				sp->psp[client_no].wkw.once_agi_up=1;
			}
			break;
		default:
			break;
		}
		if(ret==TRUE){
			sp->client_work=client_no;
			sp->item_work=ST_ServerSoubiItemNoGet(sp,client_no);
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		}
	}

	return ret;
}

//============================================================================================
/**
 *	^[`FbN̑ACeʂ̃`FbNîׂA낢whj
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:ȂɂȂ	TRUE:ʔ
 */
//============================================================================================
BOOL	ST_ServerSoubiItemTabenokosiCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		seq_no;
	int		eqp;
	int		atk;

	ret=FALSE;

	eqp=ST_ServerSoubiEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no,ATK_CHECK_NORMAL);

	if(sp->psp[client_no].hp){
		switch(eqp){
		case SOUBI_HPKAIHUKUMAITURN:
			if(sp->psp[client_no].hp<(sp->psp[client_no].hpmax)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,16);
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKUMAITURN;
				ret=TRUE;
			}
			break;
		case SOUBI_DOKUKAIHUKU:
			if((ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type1,NULL)==POISON_TYPE)||
			   (ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type2,NULL)==POISON_TYPE)){
				if(sp->psp[client_no].hp<(sp->psp[client_no].hpmax)){
					sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,16);
					seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKUMAITURN;
					ret=TRUE;
				}
			}
			//}WbNK[h̓_[WȂ
			else if(ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_MAZIKKUGAADO){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,8);
				seq_no=SUB_SEQ_EQPITEM_DAMAGE;
				ret=TRUE;
			}
			break;
		default:
			break;
		}
		if(ret==TRUE){
			sp->client_work=client_no;
			sp->item_work=ST_ServerSoubiItemNoGet(sp,client_no);
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		}
	}
	return ret;
}

//============================================================================================
/**
 *	ACeʂ̃`FbNiԈُn𒼂ẑ݁j
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	@param[in]	seq_no		NV[PXio[
 *
 *	@retval	FALSE:ȂɂȂ	TRUE:ʔ
 */
//============================================================================================
BOOL	ST_ServerSoubiItemConditionBadCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int *seq_no)
{
	BOOL	ret;
	u16		item_no;
	int		eqp;
	int		atk;

	ret=FALSE;

	eqp=ST_ServerSoubiEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no,ATK_CHECK_NORMAL);

	if(sp->psp[client_no].hp){
		switch(eqp){
		case SOUBI_HPKAIHUKU:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=atk;
				seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				ret=TRUE;
			}
			break;
		case SOUBI_HPKAIHUKUHIRITU:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*atk,100);
				seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				ret=TRUE;
			}
			break;
		case SOUBI_MAHINAOSI:
			if(sp->psp[client_no].condition&CONDITION_MAHI){
				seq_no[0]=SUB_SEQ_EQPITEM_NO_MAHI;
				ret=TRUE;
			}
			break;
		case SOUBI_NEMUKEZAMASI:
			if(sp->psp[client_no].condition&CONDITION_NEMURI){
				seq_no[0]=SUB_SEQ_EQPITEM_NO_NEMURI;
				ret=TRUE;
			}
			break;
		case SOUBI_DOKUKESI:
			if(sp->psp[client_no].condition&CONDITION_DOKUALL){
				seq_no[0]=SUB_SEQ_EQPITEM_NO_DOKU;
				ret=TRUE;
			}
			break;
		case SOUBI_YAKEDONAOSI:
			if(sp->psp[client_no].condition&CONDITION_YAKEDO){
				seq_no[0]=SUB_SEQ_EQPITEM_NO_YAKEDO;
				ret=TRUE;
			}
			break;
		case SOUBI_KOORINAOSI:
			if(sp->psp[client_no].condition&CONDITION_KOORI){
				seq_no[0]=SUB_SEQ_EQPITEM_NO_KOORI;
				ret=TRUE;
			}
			break;
		case SOUBI_PPKAIHUKU:
			{
				int	pos;

				for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
					if((sp->psp[client_no].waza[pos])&&
					   (sp->psp[client_no].pp[pos]==0)){
						break;
					}
				}
				if(pos!=WAZA_TEMOTI_MAX){
					ST_PokemonServerParamAdd(&sp->psp[client_no],ID_PSP_pp1+pos,atk);
					ST_PSPtoPPCopy(bw,sp,client_no);
					sp->waza_work=sp->psp[client_no].waza[pos];
					seq_no[0]=SUB_SEQ_EQPITEM_PP_KAIHUKU;
					ret=TRUE;
				}
			}
			break;
		case SOUBI_KONRANNAOSI:
			if(sp->psp[client_no].condition2&CONDITION2_KONRAN){
				seq_no[0]=SUB_SEQ_EQPITEM_NO_KONRAN;
				ret=TRUE;
			}
			break;
		case SOUBI_ZYOUTAIIZYOUNAOSI:
			if((sp->psp[client_no].condition&CONDITION_BAD)||
			   (sp->psp[client_no].condition2&CONDITION2_KONRAN)){
				if(sp->psp[client_no].condition&CONDITION_MAHI){
					seq_no[0]=SUB_SEQ_EQPITEM_NO_MAHI;
				}
				if(sp->psp[client_no].condition&CONDITION_NEMURI){
					seq_no[0]=SUB_SEQ_EQPITEM_NO_NEMURI;
				}
				if(sp->psp[client_no].condition&CONDITION_DOKUALL){
					seq_no[0]=SUB_SEQ_EQPITEM_NO_DOKU;
				}
				if(sp->psp[client_no].condition&CONDITION_YAKEDO){
					seq_no[0]=SUB_SEQ_EQPITEM_NO_YAKEDO;
				}
				if(sp->psp[client_no].condition&CONDITION_KOORI){
					seq_no[0]=SUB_SEQ_EQPITEM_NO_KOORI;
				}
				if(sp->psp[client_no].condition2&CONDITION2_KONRAN){
					seq_no[0]=SUB_SEQ_EQPITEM_NO_KONRAN;
				}
				if((sp->psp[client_no].condition&CONDITION_BAD)&&
				   (sp->psp[client_no].condition2&CONDITION2_KONRAN)){
					seq_no[0]=SUB_SEQ_EQPITEM_NO_JOUTAIIJOU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_NOURYOKUKAIHUKU:
			{
				int	i;

				for(i=0;i<COND_MAX;i++){
					if(sp->psp[client_no].abiritycnt[i]<6){
						sp->psp[client_no].abiritycnt[i]=6;
						ret=TRUE;
					}
				}
				if(ret==TRUE){
					seq_no[0]=SUB_SEQ_EQPITEM_ABIRITY_KAIHUKU;
				}
			}
			break;
		case SOUBI_MEROMERONAOSI:
			if(sp->psp[client_no].condition2&CONDITION2_MEROMERO){
				sp->msg_work=MSG_COND_MEROMERO;
				seq_no[0]=SUB_SEQ_EQPITEM_NO_MEROMERO;
				ret=TRUE;
			}
			break;
		case SOUBI_ITIDODAKEMEITYUUUP:
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk)){
				seq_no[0]=SUB_SEQ_EQPITEM_ONCE_HIT_UP;
				ret=TRUE;
			}
			break;
		case SOUBI_ITIDODAKESENSEI:
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk)){
				sp->psp[client_no].wkw.once_agi_up=1;
			}
			break;
		case SOUBI_KARAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_KARAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_KARAI)==DISLIKE_TASTE){
					seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_SIBUIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_SIBUI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_SIBUI)==DISLIKE_TASTE){
					seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_AMAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_AMAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_AMAI)==DISLIKE_TASTE){
					seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_NIGAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_NIGAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_NIGAI)==DISLIKE_TASTE){
					seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_SUPPAIKONRAN:
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/2)){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax,atk);
				sp->msg_work=TASTE_SUPPAI;
				if(PokeLikeTasteCheck(sp->psp[client_no].personal_rnd,TASTE_SUPPAI)==DISLIKE_TASTE){
					seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
				}
				else{
					seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU;
				}
				ret=TRUE;
			}
			break;
		case SOUBI_KOUGEKIUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_POW]<12)){
				sp->msg_work=COND_POW;
				seq_no[0]=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_BOUGYOUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_DEF]<12)){
				sp->msg_work=COND_DEF;
				seq_no[0]=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_SUBAYASAUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_AGI]<12)){
				sp->msg_work=COND_AGI;
				seq_no[0]=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_TOKUKOUUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_SPEPOW]<12)){
				sp->msg_work=COND_SPEPOW;
				seq_no[0]=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_TOKUBOUUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			   (sp->psp[client_no].abiritycnt[COND_SPEDEF]<12)){
				sp->msg_work=COND_SPEDEF;
				seq_no[0]=SUB_SEQ_EQPITEM_CONDUP;
				ret=TRUE;
			}
			break;
		case SOUBI_KURITHIKARUUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if((sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk))&&
			  ((sp->psp[client_no].condition2&CONDITION2_KIAIDAME)==0)){
				seq_no[0]=SUB_SEQ_EQPITEM_CRITICALUP;
				ret=TRUE;
			}
			break;
		case SOUBI_NOURYOKURNDUP:
			//ڂ́AiKŋN悤
			if(ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_KUISINBOU){
				atk/=2;
			}
			if(sp->psp[client_no].hp<=(sp->psp[client_no].hpmax/atk)){
				{
					int	i;

					for(i=0;i<5;i++){
						if(sp->psp[client_no].abiritycnt[COND_POW+i]<12){
							break;
						}
					}
					if(i!=5){
						do{
							i=gf_rand()%5;
						}while(sp->psp[client_no].abiritycnt[COND_POW+i]==12);
						sp->msg_work=COND_POW+i;
						seq_no[0]=SUB_SEQ_EQPITEM_CONDUP_MAX;
						ret=TRUE;
					}
				}
			}
			break;
		default:
			break;
		}
		if(ret==TRUE){
//			sp->client_work=client_no;
			sp->item_work=ST_ServerSoubiItemNoGet(sp,client_no);
//			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
//			sp->next_server_seq_no=sp->server_seq_no;
//			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		}
	}

	return ret;
}

//============================================================================================
/*
 *	ACeʂ̃`FbNi_[Wnj
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	ACeio[
 */
//============================================================================================
BOOL	ST_ServerSoubiItemDamageCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		seq_no;
	u16		item_no;
	int		eqp;
	int		atk;

	ret=FALSE;

	eqp=ST_ServerSoubiEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no,ATK_CHECK_NORMAL);

	if(sp->psp[client_no].hp){
		switch(eqp){
		case SOUBI_TEKINIMOTASERUTOMOUDOKU:
			sp->tsuika_client=client_no;
			sp->tsuika_type=ADD_STATUS_SOUBIITEM;
			seq_no=SUB_SEQ_DOKUDOKU;
			ret=TRUE;
			break;
		case SOUBI_TTEKINIMOTASERUTOYAKEDO:
			sp->tsuika_client=client_no;
			sp->tsuika_type=ADD_STATUS_SOUBIITEM;
			seq_no=SUB_SEQ_YAKEDO;
			ret=TRUE;
			break;
		case SOUBI_TEKINIMOTASETEDAMEEZI:
			//}WbNK[h̓_[WȂ
			if(ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_MAZIKKUGAADO){
				sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[client_no].hpmax*-1,atk);
				seq_no=SUB_SEQ_EQPITEM_DAMAGE;
				ret=TRUE;
			}
			break;
		default:
			break;
		}
		if(ret==TRUE){
			sp->client_work=client_no;
			sp->item_work=ST_ServerSoubiItemNoGet(sp,client_no);
			ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
			sp->next_server_seq_no=sp->server_seq_no;
			sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
		}
	}
	return ret;
}

//============================================================================================
/*
 *	ACeio[̎擾
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	ACeio[
 */
//============================================================================================
u16	ST_ServerSoubiItemNoGet(SERVER_PARAM *sp,int client_no)
{
	//Ԃ悤́AACegȂȂ
	if((ST_ServerTokuseiGet(sp,client_no)==TOKUSYU_BUKIYOU)){
		return 0;
	}
	//VbgAEg̋Zʔ́AACegȂ
	if(sp->psp[client_no].wkw.shutout_count){
		return 0;
	}
	
	return sp->psp[client_no].item;
}

//============================================================================================
/*
 *	`FbNΏۂIĂ邩`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:܂삵ĂȂ@TRUE:I
 */
//============================================================================================
BOOL	ST_ServerWazaEndCheck(SERVER_PARAM *sp,int client_no)
{
	return (sp->client_act_work[client_no][ACT_PARA_ACT_NO]==SERVER_WAZA_END_NO);
}

//============================================================================================
/**
 *	ZqbgɃ`FbN鑕
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[out]	seq_no		V[PXio[i[[N
 *
 * @retval	TRUE:ʔ@FALSE:ʕs
 */
//============================================================================================
BOOL	ST_ServerWazaHitSoubiItemCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no)
{
	BOOL	ret;
	u16		item_no;
	int		eqp;
	int		atk;
	int		dir;

	ret=FALSE;

	//UΏۂȂꍇ́A`FbNȂ
	if(sp->defence_client==NONE_CLIENT_NO){
		return ret;
	}

	//݂ł͕s
	if(ST_ServerMigawariCheck(sp,sp->defence_client)==TRUE){
		return ret;
	}

	eqp=ST_ServerSoubiEqpGet(sp,sp->defence_client);
	atk=ST_ServerSoubiAtkGet(sp,sp->defence_client,ATK_CHECK_NORMAL);
	dir=BattleWorkMineEnemyCheck(bw,sp->attack_client);

	switch(eqp){
	case SOUBI_TEKINIMOTASETEDAMEEZI:
		if((sp->psp[sp->attack_client].hp)&&
		   (sp->psp[sp->attack_client].item==0)&&
		  ((sp->scw[dir].hatakiotosu_item&No2Bit(sp->sel_mons_no[sp->attack_client]))==0)&&
		   //͂Ƃ͏O
		   (sp->waza_no_now!=WAZANO_HATAKIOTOSU)&&
		  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
//		   (WT_WazaDataParaGet(sp->waza_no_now,ID_WTD_flag)&FLAG_DAGEKI)){
		   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)){
			seq_no[0]=SUB_SEQ_EQPITEM_KUTTUKI;
			ret=TRUE;
		}
		break;
	case SOUBI_BUTURIDEKOUGEKI:
		if((sp->psp[sp->attack_client].hp)&&
			//}WbNK[hɂ͕s
		   (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_MAZIKKUGAADO)&&
#if B1368_060815_FIX
		  ((sp->server_status_flag2&SERVER_STATUS_FLAG2_TONBOGAERI)==0)&&
#endif //B1368_060815_FIX
		   (sp->ostf[sp->defence_client].butsuri_ostf_damage)){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*-1,atk);
			seq_no[0]=SUB_SEQ_EQPITEM_HIT_DAMAGE;
			ret=TRUE;
		}
		break;
	case SOUBI_TOKUSYUDEKOUGEKI:
		if((sp->psp[sp->attack_client].hp)&&
			//}WbNK[hɂ͕s
		   (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_MAZIKKUGAADO)&&
		   (sp->ostf[sp->defence_client].tokusyu_ostf_damage)){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*-1,atk);
			seq_no[0]=SUB_SEQ_EQPITEM_HIT_DAMAGE;
			ret=TRUE;
		}
		break;
	case SOUBI_BATUGUNKAIHUKU:
		if((sp->psp[sp->defence_client].hp)&&
		   (sp->waza_status_flag&WAZA_STATUS_FLAG_BATSUGUN)){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			sp->client_work=sp->defence_client;
			sp->item_work=sp->psp[sp->defence_client].item;
			ret=TRUE;
		}
		break;
	default:
		break;
	}
#if 0
	if(ret==TRUE){
		ST_ServerSequenceLoad(sp,ARC_SUB_SEQ,seq_no);
		sp->next_server_seq_no=sp->server_seq_no;
		sp->server_seq_no=SERVER_WAZA_SEQUENCE_NO;
	}
#endif

	return ret;
}

//============================================================================================
/**
 *	ʃio[擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	ʃio[擾ClientNo
 *
 * @retval	ʃio[
 */
//============================================================================================
s32	ST_ServerSoubiEqpGet(SERVER_PARAM *sp,int client_no)
{
	u16		item_no;

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);

//	return ItemParamGet(item_no,ITEM_PRM_EQUIP,HEAPID_BATTLE);
	return ST_ItemParamGet(sp,item_no,ITEM_PRM_EQUIP);
}

//============================================================================================
/**
 *	ʈЗ͂擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	ʈЗ͂擾ClientNo
 * @param[in]	flag		Zʂ𔻒fȂĂǂtOi0:f@1:fȂj
 *
 * @retval	ʈЗ
 */
//============================================================================================
s32	ST_ServerSoubiAtkGet(SERVER_PARAM *sp,int client_no,int flag)
{
	u16		item_no;

	switch(flag){
	case ATK_CHECK_NORMAL:	//`FbN
		item_no=ST_ServerSoubiItemNoGet(sp,client_no);
		break;
	case ATK_CHECK_SHUTOUT:	//VbgAEg`FbN
		if(sp->psp[client_no].wkw.shutout_count){
			return 0;
		}
	case ATK_CHECK_NONE:	//`FbNȂ
		item_no=sp->psp[client_no].item;
		break;
	}

//	return ItemParamGet(item_no,ITEM_PRM_ATTACK,HEAPID_BATTLE);
	return ST_ItemParamGet(sp,item_no,ITEM_PRM_ATTACK);
}

//============================================================================================
/**
 *	̂߂݈З͂擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	З͂擾ClientNo
 *
 * @retval	̂߂݈З
 */
//============================================================================================
s32	ST_ServerShizennomegumiAtkGet(SERVER_PARAM *sp,int client_no)
{
	u16	item_no;

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);

//	return ItemParamGet(item_no,ITEM_PRM_SIZENNOMEGUMI_ATC,HEAPID_BATTLE);
	return ST_ItemParamGet(sp,item_no,ITEM_PRM_SIZENNOMEGUMI_ATC);
}

//============================================================================================
/**
 *	̂߂݃^Cv擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	^Cv擾ClientNo
 *
 * @retval	̂߂݃^Cv
 */
//============================================================================================
s32	ST_ServerShizennomegumiTypeGet(SERVER_PARAM *sp,int client_no)
{
	u16	item_no;

	item_no=ST_ServerSoubiItemNoGet(sp,client_no);

//	return ItemParamGet(item_no,ITEM_PRM_SIZENNOMEGUMI_TYPE,HEAPID_BATTLE);
	return ST_ItemParamGet(sp,item_no,ITEM_PRM_SIZENNOMEGUMI_TYPE);
}

//============================================================================================
/**
 *	΂ތʃio[擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	΂ތʃio[擾ClientNo
 *
 * @retval	΂ތʃio[
 */
//============================================================================================
s32	ST_ServerTsuibamuEqpGet(SERVER_PARAM *sp,int client_no)
{
	u16	item_no;
	int	eqp;

	//΂ނ́AZʂŃACegȂ󋵂𔻒fȂĂ̂ŁAڎ
//	item_no=ST_ServerSoubiItemNoGet(sp,client_no);
	item_no=sp->psp[client_no].item;
//	eqp=ItemParamGet(item_no,ITEM_PRM_TUIBAMU_EFF,HEAPID_BATTLE);
	eqp=ST_ItemParamGet(sp,item_no,ITEM_PRM_TUIBAMU_EFF);

#if 0
	if(eqp){
		//˂񂿂Ⴍ́A΂߂Ȃ
		if(ST_ServerKatayaburiTokuseiCheck(sp,sp->attack_client,client_no,TOKUSYU_NENTYAKU)==TRUE){
			eqp=0;
		}
	}
#endif

	return eqp;
}

//============================================================================================
/**
 *	Ȃʃio[擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	Ȃʃio[擾ClientNo
 *
 * @retval	Ȃʃio[
 */
//============================================================================================
s32	ST_ServerNagetsukeruEqpGet(SERVER_PARAM *sp,int client_no)
{
	//VbgAEg̋Zʔ́AACegȂ
	if(sp->psp[client_no].wkw.shutout_count){
		return 0;
	}

//	return ItemParamGet(sp->psp[client_no].item,ITEM_PRM_NAGETUKERU_EFF,HEAPID_BATTLE);
	return ST_ItemParamGet(sp,sp->psp[client_no].item,ITEM_PRM_NAGETUKERU_EFF);
}

//============================================================================================
/**
 *	ȂЗ͂擾
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	З͂擾ClientNo
 *
 * @retval	ȂЗ
 */
//============================================================================================
s32	ST_ServerNagetsukeruAtkGet(SERVER_PARAM *sp,int client_no)
{
	//VbgAEg̋Zʔ́AACegȂ
	if(sp->psp[client_no].wkw.shutout_count){
		return 0;
	}

//	return ItemParamGet(sp->psp[client_no].item,ITEM_PRM_NAGETUKERU_ATC,HEAPID_BATTLE);
	return ST_ItemParamGet(sp,sp->psp[client_no].item,ITEM_PRM_NAGETUKERU_ATC);
}

//============================================================================================
/**
 *	|Pւ\`FbN
 *
 * @param[in]	bw			퓬VXep[N\
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	`FbNClientNo
 *
 * @retval	ւłȂZʂ̋Zio[
 */
//============================================================================================
int		ST_ServerPokemonSelectCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int	wazano;

	wazano=0;

	//ʂłȂ炸ւʂ̏ꍇ́Aւ
	if(ST_ServerSoubiEqpGet(sp,client_no)==SOUBI_KANARAZUIREKAWARERU){
		return 0;
	}

	//߂nA낢܂ȂA˂͂́AւłȂ
	if((sp->psp[client_no].condition2&(CONDITION2_SHIME|CONDITION2_KUROIMANAZASHI))||
	   (sp->psp[client_no].waza_kouka&WAZAKOUKA_NEWOHARU)){
		wazano=1;
	}

	//肪ӂ݁A傭ĂƂ́AւłȂ
	if( ((ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_KAGEHUMI)&&
		 (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE_HP,client_no,TOKUSYU_KAGEHUMI)))||
	   (((ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type1,NULL)==METAL_TYPE)||
		 (ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type2,NULL)==METAL_TYPE))&&
		 (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE_HP,client_no,TOKUSYU_ZIRYOKU))) ){
		wazano=1;
	}
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if B1373_060816_FIX
	//肪肶ĂƂ́AւłȂ
	if((((ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_HUYUU)&&
	 	 (sp->psp[client_no].wkw.denzihuyuu_count==0)&&
		 (ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type1,NULL)!=HIKOU_TYPE)&&
		 (ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type2,NULL)!=HIKOU_TYPE))||
		 (ST_ServerSoubiEqpGet(sp,client_no)==SOUBI_SUBAYASADOWN)||
	     (sp->field_condition&FIELD_CONDITION_JUURYOKU))&&
		 (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE_HP,client_no,TOKUSYU_ARIZIGOKU))){
		wazano=1;
	}
#else //B1373_060816_FIX
	//肪肶ĂƂ́AւłȂ
	if((((ST_ServerTokuseiGet(sp,client_no)!=TOKUSYU_HUYUU)&&
	 	 (sp->psp[client_no].wkw.denzihuyuu_count==0)&&
		 (ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type1,NULL)!=HIKOU_TYPE)&&
		 (ST_ServerPokemonServerParamGet(sp,client_no,ID_PSP_type2,NULL)!=HIKOU_TYPE))||
	     (sp->field_condition&FIELD_CONDITION_JUURYOKU))&&
		 (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ENEMY_SIDE_HP,client_no,TOKUSYU_ARIZIGOKU))){
		wazano=1;
	}
#endif //B1373_060816_FIX
// ----------------------------------------------------------------------------

	return wazano;
}

//============================================================================================
/**
 *	΂ތʂ̃`FbN
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:ȂɂȂ	TRUE:΂ތʔ
 */
//============================================================================================
BOOL	ST_ServerTsuibamuCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	BOOL	ret;
	int		seq_no;
	int		eqp;
	int		atk;

	ret=FALSE;
	seq_no=0;

	eqp=ST_ServerTsuibamuEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no,ATK_CHECK_NONE);

	//݂肩́A΂߂Ȃ
	if(ST_ServerMigawariCheck(sp,sp->defence_client)==TRUE){
		return ret;
	}

	switch(eqp){
	case TUIBAMU_HPKAIHUKU:
		if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
			sp->hp_calc_work=atk;
			seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
		}
		ret=TRUE;
		break;
	case TUIBAMU_HPKAIHUKUHIRITU:
		if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*atk,100);
			seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
		}
		ret=TRUE;
		break;
	case TUIBAMU_MAHINAOSI:
		if(sp->psp[sp->attack_client].condition&CONDITION_MAHI){
			seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
		}
		ret=TRUE;
		break;
	case TUIBAMU_NEMUKEZAMASI:
		if(sp->psp[sp->attack_client].condition&CONDITION_NEMURI){
			seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
		}
		ret=TRUE;
		break;
	case TUIBAMU_DOKUKESI:
		if(sp->psp[sp->attack_client].condition&CONDITION_DOKUALL){
			seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
		}
		ret=TRUE;
		break;
	case TUIBAMU_YAKEDONAOSI:
		if(sp->psp[sp->attack_client].condition&CONDITION_YAKEDO){
			seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
		}
		ret=TRUE;
		break;
	case TUIBAMU_KOORINAOSI:
		if(sp->psp[sp->attack_client].condition&CONDITION_KOORI){
			seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
		}
		ret=TRUE;
		break;
	case TUIBAMU_PPKAIHUKU:
		{
			int	pp_sub;
			int	pos;
			int	max;
			int	max_pos;

			max=0;

			for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
				if(sp->psp[sp->attack_client].waza[pos]){
					pp_sub=WT_PPMaxGet(sp->psp[sp->attack_client].waza[pos],sp->psp[sp->attack_client].pp_count[pos])-
						   sp->psp[sp->attack_client].pp[pos];
					if(pp_sub>max){
						max=pp_sub;
						max_pos=pos;
					}
				}
			}
			ST_PokemonServerParamAdd(&sp->psp[sp->attack_client],ID_PSP_pp1+max_pos,atk);
			ST_PSPtoPPCopy(bw,sp,sp->attack_client);
			sp->waza_work=sp->psp[sp->attack_client].waza[max_pos];
			seq_no=SUB_SEQ_EQPITEM_PP_KAIHUKU;
		}
		ret=TRUE;
		break;
	case TUIBAMU_KONRANNAOSI:
		if(sp->psp[sp->attack_client].condition2&CONDITION2_KONRAN){
			seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
		}
		ret=TRUE;
		break;
	case TUIBAMU_ZYOUTAIIZYOUNAOSI:
		if((sp->psp[sp->attack_client].condition&CONDITION_BAD)||
		   (sp->psp[sp->attack_client].condition2&CONDITION2_KONRAN)){
			if(sp->psp[sp->attack_client].condition&CONDITION_MAHI){
				seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
			}
			if(sp->psp[sp->attack_client].condition&CONDITION_NEMURI){
				seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
			}
			if(sp->psp[sp->attack_client].condition&CONDITION_DOKUALL){
				seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
			}
			if(sp->psp[sp->attack_client].condition&CONDITION_YAKEDO){
				seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
			}
			if(sp->psp[sp->attack_client].condition&CONDITION_KOORI){
				seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
			}
			if(sp->psp[sp->attack_client].condition2&CONDITION2_KONRAN){
				seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
			}
			if((sp->psp[sp->attack_client].condition&CONDITION_BAD)&&
			   (sp->psp[sp->attack_client].condition2&CONDITION2_KONRAN)){
				seq_no=SUB_SEQ_EQPITEM_NO_JOUTAIIJOU;
			}
		}
		ret=TRUE;
		break;
	case TUIBAMU_KARAIKONRAN:
		if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,atk);
			sp->msg_work=TASTE_KARAI;
			if(PokeLikeTasteCheck(sp->psp[sp->attack_client].personal_rnd,TASTE_KARAI)==DISLIKE_TASTE){
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
		}
		ret=TRUE;
		break;
	case TUIBAMU_SIBUIKONRAN:
		if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,atk);
			sp->msg_work=TASTE_SIBUI;
			if(PokeLikeTasteCheck(sp->psp[sp->attack_client].personal_rnd,TASTE_SIBUI)==DISLIKE_TASTE){
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
		}
		ret=TRUE;
		break;
	case TUIBAMU_AMAIKONRAN:
		if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,atk);
			sp->msg_work=TASTE_AMAI;
			if(PokeLikeTasteCheck(sp->psp[sp->attack_client].personal_rnd,TASTE_AMAI)==DISLIKE_TASTE){
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
		}
		ret=TRUE;
		break;
	case TUIBAMU_NIGAIKONRAN:
		if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,atk);
			sp->msg_work=TASTE_NIGAI;
			if(PokeLikeTasteCheck(sp->psp[sp->attack_client].personal_rnd,TASTE_NIGAI)==DISLIKE_TASTE){
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
		}
		ret=TRUE;
		break;
	case TUIBAMU_SUPPAIKONRAN:
		if(sp->psp[sp->attack_client].hp!=sp->psp[sp->attack_client].hpmax){
			sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax,atk);
			sp->msg_work=TASTE_SUPPAI;
			if(PokeLikeTasteCheck(sp->psp[sp->attack_client].personal_rnd,TASTE_SUPPAI)==DISLIKE_TASTE){
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
		}
		ret=TRUE;
		break;
	case TUIBAMU_KOUGEKIUP:
		if(sp->psp[sp->attack_client].abiritycnt[COND_POW]<12){
			sp->msg_work=COND_POW;
			seq_no=SUB_SEQ_EQPITEM_CONDUP;
		}
		ret=TRUE;
		break;
	case TUIBAMU_BOUGYOUP:
		if(sp->psp[sp->attack_client].abiritycnt[COND_DEF]<12){
			sp->msg_work=COND_DEF;
			seq_no=SUB_SEQ_EQPITEM_CONDUP;
		}
		ret=TRUE;
		break;
	case TUIBAMU_SUBAYASAUP:
		if(sp->psp[sp->attack_client].abiritycnt[COND_AGI]<12){
			sp->msg_work=COND_AGI;
			seq_no=SUB_SEQ_EQPITEM_CONDUP;
		}
		ret=TRUE;
		break;
	case TUIBAMU_TOKUKOUUP:
		if(sp->psp[sp->attack_client].abiritycnt[COND_SPEPOW]<12){
			sp->msg_work=COND_SPEPOW;
			seq_no=SUB_SEQ_EQPITEM_CONDUP;
		}
		ret=TRUE;
		break;
	case TUIBAMU_TOKUBOUUP:
		if(sp->psp[sp->attack_client].abiritycnt[COND_SPEDEF]<12){
			sp->msg_work=COND_SPEDEF;
			seq_no=SUB_SEQ_EQPITEM_CONDUP;
		}
		ret=TRUE;
		break;
	case TUIBAMU_NOURYOKURNDUP:
		{
			int	i;

			for(i=0;i<5;i++){
				if(sp->psp[sp->attack_client].abiritycnt[COND_POW+i]<12){
					break;
				}
			}
			if(i!=5){
				do{
					i=gf_rand()%5;
				}while(sp->psp[sp->attack_client].abiritycnt[COND_POW+i]==12);
				sp->msg_work=COND_POW+i;
				seq_no=SUB_SEQ_EQPITEM_CONDUP_MAX;
			}
		}
		ret=TRUE;
		break;
	case TUIBAMU_KURITHIKARUUP:
		if((sp->psp[sp->attack_client].condition2&CONDITION2_KIAIDAME)==0){
			seq_no=SUB_SEQ_EQPITEM_CRITICALUP;
		}
		ret=TRUE;
		break;
	case TUIBAMU_ITIDODAKEMEITYUUUP:
		seq_no=SUB_SEQ_EQPITEM_ONCE_HIT_UP;
		ret=TRUE;
		break;
	default:
		//Ă̂؂̎ȂA΂ނƂ͔
		if(ItemNutsCheck(sp->psp[client_no].item)==TRUE){
			ret=TRUE;
		}
		break;
	}

	if(ret==TRUE){
		//Ԃ悤AZʃVbgAEǵAACěʂ𔭊łȂ
		if(((ST_ServerTokuseiGet(sp,sp->attack_client)==TOKUSYU_BUKIYOU))||
			(sp->psp[sp->attack_client].waza_kouka&WAZAKOUKA_SHUTOUT)){
			sp->temp_work=0;
		}
		else{
			sp->temp_work=seq_no;
		}
		sp->item_work=sp->psp[client_no].item;
		sp->ostf[sp->attack_client].status_flag|=OSTF_STATUS_FLAG_TSUIBAMU;
	}

	return ret;
}

//============================================================================================
/**
 *	Ȃʂ̃`FbN
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:ȂɂȂ	TRUE:Ȃʔ
 */
//============================================================================================
BOOL	ST_ServerNagetsukeruCheck(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no)
{
	int	seq_no;
	int	eqp;
	int	atk;

	eqp=ST_ServerNagetsukeruEqpGet(sp,client_no);
	atk=ST_ServerSoubiAtkGet(sp,client_no,ATK_CHECK_SHUTOUT);
	sp->damage_power=ST_ServerNagetsukeruAtkGet(sp,client_no);
	sp->nagetsukeru_seq_no=0;
	sp->tsuika_type=0;

	//З͂̂ȂACéAłȂ
	if(sp->damage_power==0){
		return FALSE;
	}

	switch(eqp){
	case NAGETUKERU_HPKAIHUKU:
//		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=atk;
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
//		}
		break;
	case NAGETUKERU_HPKAIHUKUHIRITU:
//		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax*atk,100);
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
//		}
		break;
	case NAGETUKERU_MAHINAOSI:
		if(sp->psp[sp->defence_client].condition&CONDITION_MAHI){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
		}
		break;
	case NAGETUKERU_NEMUKEZAMASI:
		if(sp->psp[sp->defence_client].condition&CONDITION_NEMURI){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
		}
		break;
	case NAGETUKERU_DOKUKESI:
		if(sp->psp[sp->defence_client].condition&CONDITION_DOKUALL){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
		}
		break;
	case NAGETUKERU_YAKEDONAOSI:
		if(sp->psp[sp->defence_client].condition&CONDITION_YAKEDO){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
		}
		break;
	case NAGETUKERU_KOORINAOSI:
		if(sp->psp[sp->defence_client].condition&CONDITION_KOORI){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
		}
		break;
	case NAGETUKERU_PPKAIHUKU:
		{
			int	pp_sub;
			int	pos;
			int	max;
			int	max_pos;

			max=0;

			for(pos=0;pos<WAZA_TEMOTI_MAX;pos++){
				if(sp->psp[sp->defence_client].waza[pos]){
					pp_sub=WT_PPMaxGet(sp->psp[sp->defence_client].waza[pos],sp->psp[sp->defence_client].pp_count[pos])-
						   sp->psp[sp->defence_client].pp[pos];
					if(pp_sub>max){
						max=pp_sub;
						max_pos=pos;
					}
				}
			}
			if(max){
				ST_PokemonServerParamAdd(&sp->psp[sp->defence_client],ID_PSP_pp1+max_pos,atk);
				ST_PSPtoPPCopy(bw,sp,sp->defence_client);
				sp->waza_work=sp->psp[sp->defence_client].waza[max_pos];
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_PP_KAIHUKU;
			}
		}
		break;
	case NAGETUKERU_KONRANNAOSI:
		if(sp->psp[sp->defence_client].condition2&CONDITION2_KONRAN){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
		}
		break;
	case NAGETUKERU_ZYOUTAIIZYOUNAOSI:
		if((sp->psp[sp->defence_client].condition&CONDITION_BAD)||
		   (sp->psp[sp->defence_client].condition2&CONDITION2_KONRAN)){
			if(sp->psp[sp->defence_client].condition&CONDITION_MAHI){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_MAHI;
			}
			if(sp->psp[sp->defence_client].condition&CONDITION_NEMURI){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_NEMURI;
			}
			if(sp->psp[sp->defence_client].condition&CONDITION_DOKUALL){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_DOKU;
			}
			if(sp->psp[sp->defence_client].condition&CONDITION_YAKEDO){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_YAKEDO;
			}
			if(sp->psp[sp->defence_client].condition&CONDITION_KOORI){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_KOORI;
			}
			if(sp->psp[sp->defence_client].condition2&CONDITION2_KONRAN){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_KONRAN;
			}
			if((sp->psp[sp->defence_client].condition&CONDITION_BAD)&&
			   (sp->psp[sp->defence_client].condition2&CONDITION2_KONRAN)){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_JOUTAIIJOU;
			}
		}
		break;
	case NAGETUKERU_KARAIKONRAN:
//		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			sp->msg_work=TASTE_KARAI;
			if(PokeLikeTasteCheck(sp->psp[sp->defence_client].personal_rnd,TASTE_KARAI)==DISLIKE_TASTE){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
//		}
		break;
	case NAGETUKERU_SIBUIKONRAN:
//		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			sp->msg_work=TASTE_SIBUI;
			if(PokeLikeTasteCheck(sp->psp[sp->defence_client].personal_rnd,TASTE_SIBUI)==DISLIKE_TASTE){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
//		}
		break;
	case NAGETUKERU_AMAIKONRAN:
//		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			sp->msg_work=TASTE_AMAI;
			if(PokeLikeTasteCheck(sp->psp[sp->defence_client].personal_rnd,TASTE_AMAI)==DISLIKE_TASTE){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
//		}
		break;
	case NAGETUKERU_NIGAIKONRAN:
//		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			sp->msg_work=TASTE_NIGAI;
			if(PokeLikeTasteCheck(sp->psp[sp->defence_client].personal_rnd,TASTE_NIGAI)==DISLIKE_TASTE){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
//		}
		break;
	case NAGETUKERU_SUPPAIKONRAN:
//		if(sp->psp[sp->defence_client].hp!=sp->psp[sp->defence_client].hpmax){
			sp->nagetsukeru_work=ST_ServerDamageDiv(sp->psp[sp->defence_client].hpmax,atk);
			sp->msg_work=TASTE_SUPPAI;
			if(PokeLikeTasteCheck(sp->psp[sp->defence_client].personal_rnd,TASTE_SUPPAI)==DISLIKE_TASTE){
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU_KONRAN;
			}
			else{
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_HP_KAIHUKU;
			}
//		}
		break;
	case NAGETUKERU_NOURYOKUKAIHUKU:
		{
			int	i;

			for(i=0;i<COND_MAX;i++){
				if(sp->psp[sp->defence_client].abiritycnt[i]<6){
					sp->psp[sp->defence_client].abiritycnt[i]=6;
					sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_ABIRITY_KAIHUKU;
				}
			}
		}
		break;
	case NAGETUKERU_MEROMERONAOSI:
		if(sp->psp[sp->defence_client].condition2&CONDITION2_MEROMERO){
			sp->msg_work=MSG_COND_MEROMERO;
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_NO_MEROMERO;
		}
		break;
	case NAGETUKERU_HIRUMASERU:
		sp->tsuika_client=client_no;
		sp->tsuika_type=ADD_STATUS_INDIRECT;
		sp->nagetsukeru_seq_no=SUB_SEQ_HIRUMU;
		break;
	case NAGETUKERU_MAHINISURU:
		sp->tsuika_client=client_no;
		sp->tsuika_type=ADD_STATUS_INDIRECT;
		sp->nagetsukeru_seq_no=SUB_SEQ_MAHI;
		break;
	case NAGETUKERU_DOKUNISURU:
		sp->tsuika_client=client_no;
		sp->tsuika_type=ADD_STATUS_INDIRECT;
		sp->nagetsukeru_seq_no=SUB_SEQ_DOKU;
		break;
	case NAGETUKERU_MOUDOKUNISURU:
		sp->tsuika_client=client_no;
		sp->tsuika_type=ADD_STATUS_INDIRECT;
		sp->nagetsukeru_seq_no=SUB_SEQ_DOKUDOKU;
		break;
	case NAGETUKERU_YAKEDONISURU:
		sp->tsuika_client=client_no;
		sp->tsuika_type=ADD_STATUS_INDIRECT;
		sp->nagetsukeru_seq_no=SUB_SEQ_YAKEDO;
		break;
	case NAGETUKERU_KOUGEKIUP:
		if(sp->psp[sp->defence_client].abiritycnt[COND_POW]<12){
			sp->msg_work=COND_POW;
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_CONDUP;
		}
		break;
	case NAGETUKERU_BOUGYOUP:
		if(sp->psp[sp->defence_client].abiritycnt[COND_DEF]<12){
			sp->msg_work=COND_DEF;
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_CONDUP;
		}
		break;
	case NAGETUKERU_SUBAYASAUP:
		if(sp->psp[sp->defence_client].abiritycnt[COND_AGI]<12){
			sp->msg_work=COND_AGI;
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_CONDUP;
		}
		break;
	case NAGETUKERU_TOKUKOUUP:
		if(sp->psp[sp->defence_client].abiritycnt[COND_SPEPOW]<12){
			sp->msg_work=COND_SPEPOW;
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_CONDUP;
		}
		break;
	case NAGETUKERU_TOKUBOUUP:
		if(sp->psp[sp->defence_client].abiritycnt[COND_SPEDEF]<12){
			sp->msg_work=COND_SPEDEF;
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_CONDUP;
		}
		break;
	case NAGETUKERU_NOURYOKURNDUP:
		{
			int	i;

			for(i=0;i<5;i++){
				if(sp->psp[sp->defence_client].abiritycnt[COND_POW+i]<12){
					break;
				}
			}
			if(i!=5){
				do{
					i=gf_rand()%5;
				}while(sp->psp[sp->defence_client].abiritycnt[COND_POW+i]==12);
				sp->msg_work=COND_POW+i;
				sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_CONDUP_MAX;
			}
		}
		break;
	case NAGETUKERU_KURITHIKARUUP:
		if((sp->psp[sp->defence_client].condition2&CONDITION2_KIAIDAME)==0){
			sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_CRITICALUP;
		}
		break;
	case NAGETUKERU_ITIDODAKEMEITYUUUP:
		sp->nagetsukeru_seq_no=SUB_SEQ_EQPITEM_ONCE_HIT_UP;
		break;
	default:
		break;
	}

	//Ă鎞́Aʂ̔Ȃ
	if(sp->psp[sp->defence_client].waza_kouka&WAZAKOUKA_SHUTOUT){
		sp->nagetsukeru_seq_no=0;
	}
	else{
		sp->item_work=sp->psp[client_no].item;
		if((sp->tsuika_type==0)&&(sp->nagetsukeru_seq_no)){
			sp->ostf[sp->attack_client].status_flag|=OSTF_STATUS_FLAG_TSUIBAMU;
		}
		sp->client_work=sp->defence_client;
	}

	return TRUE;
}

//============================================================================================
/**
 *	gm[`FbNiZoO`FbNj
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerMetronomeBeforeCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//ZoƈЗ̓Abṽ`FbNipZn͏Oj
	if(ST_ServerSoubiEqpGet(sp,sp->attack_client)==SOUBI_ONAZIWAZANOIRYOKUUP){
		if(((sp->psp[sp->attack_client].condition2&CONDITION2_ABARERU)==0)&&
		   ((sp->psp[sp->attack_client].condition2&CONDITION2_SAWAGU)==0)&&
		   ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME_AFTER)==0)&&
		   ((sp->psp[sp->attack_client].condition2&CONDITION2_KEEP)==0)){
			if(sp->waza_no_metronome[sp->attack_client]==sp->waza_no_temp){
				if(sp->psp[sp->attack_client].wkw.metronome_work<10){
					sp->psp[sp->attack_client].wkw.metronome_work++;
				}
			}
			else{
				sp->psp[sp->attack_client].wkw.metronome_work=0;
				sp->waza_no_metronome[sp->attack_client]=sp->waza_no_temp;
			}
		}
	}
	else{
		sp->psp[sp->attack_client].wkw.metronome_work=0;
	}
	OS_Printf("no:%d metro_count:%d\n",sp->attack_client,sp->psp[sp->attack_client].wkw.metronome_work);
}

//============================================================================================
/**
 *	gm[`FbNiZo`FbNj
 *
 *	@param[in]	bw			퓬VXep[N\
 *	@param[in]	sp			T[op[^\̂̃|C^
 */
//============================================================================================
void	ST_ServerMetronomeAfterCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	//ZoƈЗ̓Abṽ`FbNipZn͏Oj
	if(ST_ServerSoubiEqpGet(sp,sp->attack_client)==SOUBI_ONAZIWAZANOIRYOKUUP){
		if((sp->waza_status_flag&WAZA_STATUS_FLAG_NO_OUT)&&
		   (sp->waza_no_metronome[sp->attack_client]==sp->waza_no_temp)&&
		   (sp->psp[sp->attack_client].wkw.metronome_work)&&
		   (sp->ostf[sp->attack_client].korogaru_count==0)&&
		  ((sp->psp[sp->attack_client].condition2&CONDITION2_ABARERU)==0)&&
		  ((sp->psp[sp->attack_client].condition2&CONDITION2_SAWAGU)==0)&&
		  ((sp->server_status_flag&SERVER_STATUS_FLAG_TAME_AFTER)==0)&&
		  ((sp->psp[sp->attack_client].condition2&CONDITION2_KEEP)==0)){
			sp->psp[sp->attack_client].wkw.metronome_work--;
		}
	}
	else{
		sp->psp[sp->attack_client].wkw.metronome_work=0;
	}
}

//============================================================================================
/**
 *	|P̂C`FbNāAp^[擾
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *	@param[in]	client_no	`FbNClientType
 *	@param[in]	encount		TRUE:GJEgoꎞ
 */
//============================================================================================
int		ST_ServerPokeVoiceEffNoGet(SERVER_PARAM *sp,int client_no, int client_type, int encount)
{
	int	ptn;
	int	col;
	int half;
	
	if(encount == TRUE && (client_type == CLIENT_TYPE_A || client_type == CLIENT_TYPE_B)){
		half = TRUE;
	}
	else{
		half = FALSE;
	}

	ptn=PV_NORMAL;
	if(half == TRUE){
		ptn = PV_NORMAL;//PV_HALF;
	}
	
	col=GetHPGaugeDottoColor(sp->psp[client_no].hp,sp->psp[client_no].hpmax,GAUGE_HP_DOTTOMAX);
	
	if((sp->psp[client_no].condition&CONDITION_BAD)||
	   ((col!=HP_DOTTO_MAX)&&(col!=HP_DOTTO_GREEN))){
		
		if(half == TRUE){
			ptn = PV_PINCHNORMAL;//PV_PINCHHALF;
		}
		else{
			ptn=PV_PINCHNORMAL;
		}
	}

	return ptn;
}

//============================================================================================
/**
 *	R}hIׂ
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNClientNo
 *
 *	@retval	FALSE:R}hIȂ@TRUE:R}hI
 */
//============================================================================================
BOOL	ST_ServerCommandSelectCheck(SERVER_PARAM *sp,int client_no)
{
	BOOL	ret=TRUE;

	///<̎́AR}hIȂ
	if((sp->psp[client_no].condition2&CONDITION2_HANDOU)||
	///<΂ĂŒ́AR}hIȂ
	   (sp->psp[client_no].condition2&CONDITION2_ABARERU)||
	///<킢łŒ́AR}hIȂ
	   (sp->psp[client_no].condition2&CONDITION2_SAWAGU)||
	///<ߌn̋Z̎́AR}hIȂ
	   (sp->psp[client_no].condition2&CONDITION2_KEEP)){
		ret=FALSE;
	}

	return ret;
}

//============================================================================================
/**
 *	|Pߊl̃Zbg
 *
 *	@param[in]	sp	T[op[^\̂̃|C^
 *	@param[in]	pp	ZbgPOKEMON_PARAM\
 */
//============================================================================================
void	ST_ServerPokemonGetParamSet(BATTLE_WORK *bw,SERVER_PARAM *sp,POKEMON_PARAM *pp)
{
	MYSTATUS	*status;
	int			place;
	int			ground_id;
	int			ballID;

	//MYSTATUS擾
	status=BattleWorkMyStatusGet(bw,CLIENT_NO_MINE);

	//n於ID擾
	place=BattleWorkPlaceIDGet(bw);

	//n`Agr[g擾
	ground_id=BattleWorkGroundIDGet(bw);

	//|Pp[Nł́Aߊl{[ύXȂ
	if(BattleWorkFightTypeGet(bw)&FIGHT_TYPE_POKE_PARK){
		ballID=PokeParaGet(pp,ID_PARA_get_ball,NULL);
	}
	else{
		ballID=sp->item_work;
	}

	PokeParaGetInfoSet(pp,status,ballID,place,ground_id,HEAPID_BATTLE);
}

//============================================================================================
/**
 *	NCAg̕ԓo
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	oNCAgio[
 */
//============================================================================================
u8	ST_ServerBufferResGet(SERVER_PARAM *sp,int client_no)
{
	return sp->server_buffer[client_no][0];
}

//============================================================================================
/**
 *	݂łӂ邩`FbN
 *
 *	@param[in]	sp			T[op[^\̂̃|C^
 *	@param[in]	client_no	`FbNNCAgio[
 *
 *@@retval FALSE:hȂ@TRUE:h
 */
//============================================================================================
BOOL	ST_ServerMigawariCheck(SERVER_PARAM *sp,int client_no)
{
	BOOL	ret=FALSE;

//	if((sp->ostf[client_no].status_flag&OSTF_STATUS_FLAG_MIGAWARI_HIT)||
//	   (sp->psp[client_no].condition2&CONDITION2_MIGAWARI)){
//		ret=TRUE;
//	}
	if(sp->ostf[client_no].status_flag&OSTF_STATUS_FLAG_MIGAWARI_HIT){
		ret=TRUE;
	}

	return ret;
}

//============================================================================================
/**
 *	̃|P`FbN
 *
 *	@param[in]	bw	퓬VXe[N\̂̃|C^
 *	@param[in]	sp	T[op[^\̂̃|C^
 *
 *@@retval FALSE:l̃|P@TRUE:̃|P
 */
//============================================================================================
BOOL	ST_ServerPokeOneSelfCheckAct(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	MYSTATUS		*status;
	u32				id;
	u32				sex;
	const STRCODE	*name;

	status=BattleWorkMyStatusGet(bw,CLIENT_NO_MINE);
	id=MyStatus_GetID(status);
	sex=MyStatus_GetMySex(status);
	name=MyStatus_GetMyName(status);

	if((id==sp->psp[sp->attack_client].id_no)&&
	   (sex==sp->psp[sp->attack_client].oyasex)&&
	   (PM_strncmp(name,&sp->psp[sp->attack_client].oyaname[0],PERSON_NAME_SIZE)==0)){
		return TRUE;
	}

	return FALSE;
}

//============================================================================================
/**
 *	̃|P`FbN
 *
 *	@param[in]	bw	퓬VXe[N\̂̃|C^
 *	@param[in]	sp	T[op[^\̂̃|C^
 *
 *@@retval FALSE:l̃|P@TRUE:̃|P
 */
//============================================================================================
BOOL	ST_ServerPokeOneSelfCheckActPP(BATTLE_WORK *bw,POKEMON_PARAM *pp)
{
	MYSTATUS		*status;
	u32				id;
	u32				sex;
	const STRCODE	*name;
	STRCODE			oyaname[PERSON_NAME_SIZE+EOM_SIZE];

	status=BattleWorkMyStatusGet(bw,CLIENT_NO_MINE);
	id=MyStatus_GetID(status);
	sex=MyStatus_GetMySex(status);
	name=MyStatus_GetMyName(status);
	PokeParaGet(pp,ID_PARA_oyaname,&oyaname[0]);

	if((id==PokeParaGet(pp,ID_PARA_id_no,NULL))&&
	   (sex==PokeParaGet(pp,ID_PARA_oyasex,NULL))&&
	   (PM_strncmp(name,&oyaname[0],PERSON_NAME_SIZE)==0)){
		return TRUE;
	}

	return FALSE;
}

//============================================================================================
/**
 *	Ă񂫂`FbNi|PF`FVl̓̂ł킹ă`FbNj
 *
 *	@param[in]	bw	퓬VXe[N\̂̃|C^
 *	@param[in]	sp	T[op[^\̂̃|C^
 *
 *@@retval FALSE:Ă񂫂Ȃ@TRUE:Ă񂫂┭
 */
//============================================================================================
BOOL	ST_ServerTenkiyaCheck(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int		i;
	int		form_no;
	BOOL	ret=FALSE;

	for(i=0;i<BattleWorkClientSetMaxGet(bw);i++){
		sp->client_work=sp->psp_agi_work[i];
		if((sp->psp[sp->client_work].monsno==MONSNO_POWARUN)&&
		   (sp->psp[sp->client_work].hp)&&
		   (ST_ServerTokuseiGet(sp,sp->client_work)==TOKUSYU_TENKIYA)){
			if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
			   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
				if(((sp->field_condition&FIELD_CONDITION_TENKI_CHG)==0)&&
					(sp->psp[sp->client_work].type1!=NORMAL_TYPE)&&
					(sp->psp[sp->client_work].type2!=NORMAL_TYPE)){
					sp->psp[sp->client_work].type1=NORMAL_TYPE;
					sp->psp[sp->client_work].type2=NORMAL_TYPE;
					sp->psp[sp->client_work].form_no=FORMNO_POWARUN_NORMAL;
					ret=TRUE;
					break;
				}
				else if((sp->field_condition&FIELD_CONDITION_HARE_ALL)&&
						(sp->psp[sp->client_work].type1!=FIRE_TYPE)&&
						(sp->psp[sp->client_work].type2!=FIRE_TYPE)){
					sp->psp[sp->client_work].type1=FIRE_TYPE;
					sp->psp[sp->client_work].type2=FIRE_TYPE;
					sp->psp[sp->client_work].form_no=FORMNO_POWARUN_SUN;
					ret=TRUE;
					break;
				}
				else if((sp->field_condition&FIELD_CONDITION_AME_ALL)&&
						(sp->psp[sp->client_work].type1!=WATER_TYPE)&&
						(sp->psp[sp->client_work].type2!=WATER_TYPE)){
					sp->psp[sp->client_work].type1=WATER_TYPE;
					sp->psp[sp->client_work].type2=WATER_TYPE;
					sp->psp[sp->client_work].form_no=FORMNO_POWARUN_RAIN;
					ret=TRUE;
					break;
				}
				else if((sp->field_condition&FIELD_CONDITION_ARARE_ALL)&&
						(sp->psp[sp->client_work].type1!=KOORI_TYPE)&&
						(sp->psp[sp->client_work].type2!=KOORI_TYPE)){
					sp->psp[sp->client_work].type1=KOORI_TYPE;
					sp->psp[sp->client_work].type2=KOORI_TYPE;
					sp->psp[sp->client_work].form_no=FORMNO_POWARUN_SNOW;
					ret=TRUE;
					break;
				}
			}
			else{
				if((sp->psp[sp->client_work].type1!=NORMAL_TYPE)&&
				   (sp->psp[sp->client_work].type2!=NORMAL_TYPE)){
					sp->psp[sp->client_work].type1=NORMAL_TYPE;
					sp->psp[sp->client_work].type2=NORMAL_TYPE;
					sp->psp[sp->client_work].form_no=FORMNO_POWARUN_NORMAL;
					ret=TRUE;
					break;
				}
			}
		}
		if((sp->psp[sp->client_work].monsno==MONSNO_THERISYU)&&
		   (sp->psp[sp->client_work].hp)){
			if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
			   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
				if(((sp->field_condition&FIELD_CONDITION_TENKI_CHG)==0)&&
					(sp->psp[sp->client_work].form_no==FORMNO_THERISYU_SUN)){
					sp->psp[sp->client_work].form_no=FORMNO_THERISYU_NORMAL;
					ret=TRUE;
					break;
				}
				else if((sp->field_condition&FIELD_CONDITION_HARE_ALL)&&
						(sp->psp[sp->client_work].form_no==FORMNO_THERISYU_NORMAL)){
					sp->psp[sp->client_work].form_no=FORMNO_THERISYU_SUN;
					ret=TRUE;
					break;
				}
				else if((sp->field_condition&FIELD_CONDITION_AME_ALL)&&
						(sp->psp[sp->client_work].form_no==FORMNO_THERISYU_SUN)){
					sp->psp[sp->client_work].form_no=FORMNO_THERISYU_NORMAL;
					ret=TRUE;
					break;
				}
				else if((sp->field_condition&FIELD_CONDITION_ARARE_ALL)&&
						(sp->psp[sp->client_work].form_no==FORMNO_THERISYU_SUN)){
					sp->psp[sp->client_work].form_no=FORMNO_THERISYU_NORMAL;
					ret=TRUE;
					break;
				}
			}
			else{
				if(sp->psp[sp->client_work].form_no==FORMNO_THERISYU_SUN){
					sp->psp[sp->client_work].form_no=FORMNO_THERISYU_NORMAL;
					ret=TRUE;
					break;
				}
			}
		}
		if((sp->psp[sp->client_work].monsno==MONSNO_AUSU)&&
		   (sp->psp[sp->client_work].hp)){
			form_no=AusuTypeGet(ItemParamGet(sp->psp[sp->client_work].item,ITEM_PRM_EQUIP,HEAPID_BATTLE));
			if(sp->psp[sp->client_work].form_no!=form_no){
				sp->psp[sp->client_work].form_no=form_no;
				ret=TRUE;
				break;
			}
		}
	}

	return ret;
}

//============================================================================================
/**
 *	ListRow̏
 *
 * @param[in]	bw			퓬p[^̍\̃|C^
 * @param[in]	sp			T[op[^̍\̃|C^
 *
 */
//============================================================================================
void	ST_ServerListRowInit(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	client_no;
	int	pos;

	for(client_no=0;client_no<BattleWorkClientSetMaxGet(bw);client_no++){
		for(pos=0;pos<POKEMON_TEMOTI_MAX;pos++){
			sp->list_row[client_no][pos]=pos;
		}
		ST_ServerListRowChange(bw,sp,client_no,sp->sel_mons_no[client_no]);
	}
}

//============================================================================================
/**
 *	ListRow̓ւ
 *
 * @param[in]	bw			퓬p[^̍\̃|C^
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	ւΏClientNo
 * @param[in]	sel_mons_no	ւΏۃ|Pʒu
 *
 */
//============================================================================================
void	ST_ServerListRowChange(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int sel_mons_no)
{
	int	pos;
	int	work;
	int	fb_flag;
	u32	fight_type;

	fight_type=BattleWorkFightTypeGet(bw);

	if(((fight_type&FIGHT_TYPE_2vs2)&&((fight_type&(FIGHT_TYPE_MULTI|FIGHT_TYPE_TAG))==0))||
	   ((fight_type&FIGHT_TYPE_TAG)&&((BattleWorkClientTypeGet(bw,client_no)&CLIENT_ENEMY_FLAG)==0))){
		if((BattleWorkClientTypeGet(bw,client_no)==CLIENT_TYPE_C)||
		   (BattleWorkClientTypeGet(bw,client_no)==CLIENT_TYPE_D)){
			fb_flag=FB_BACKWARD;
		}
		else{
			fb_flag=FB_FORWARD;
		}
		client_no&=1;
	}
	else{
		fb_flag=FB_FORWARD;
	}
	
	for(pos=0;pos<POKEMON_TEMOTI_MAX;pos++){
		if(sp->list_row[client_no][pos]==sel_mons_no){
			break;
		}
	}

	//擪Ƃꂩ
	work=sp->list_row[client_no][fb_flag];
	sp->list_row[client_no][fb_flag]=sp->list_row[client_no][pos];
	sp->list_row[client_no][pos]=work;
}

//============================================================================================
/**
 * \̒`
 */
//============================================================================================

typedef struct{
	u16	monsno;
	s16 hp;

	u16	hpmax;
	u16	dummy;

	int	eqp;
	int	atc;

	u32 condition;

	u8	speabino;
	u8	sex;
	u8	type1;
	u8	type2;
}WAZA_DAMAGE_CALC_PARAM;

//============================================================================================
/**
 *	ʂɂZ^CvU̓Abve[u
 */
//============================================================================================
static	const u8 SoubiItemWazaTypePowUpTbl[][2]={
	{SOUBI_MUSIIRYOKUUP,		MUSHI_TYPE},
	{SOUBI_HAGANEIRYOKUUP,		METAL_TYPE},
	{SOUBI_ZIMENUP,				JIMEN_TYPE},
	{SOUBI_IWAUP,				IWA_TYPE},
	{SOUBI_KUSAUP,				KUSA_TYPE},
	{SOUBI_AKUUP,				AKU_TYPE},
	{SOUBI_KAKUTOUUP,			BATTLE_TYPE},
	{SOUBI_DENKIUP,				ELECTRIC_TYPE},
	{SOUBI_MIZUUP,				WATER_TYPE},
	{SOUBI_TORIUP,				HIKOU_TYPE},
	{SOUBI_DOKUBARIUP,			POISON_TYPE},
	{SOUBI_KOORIUP,				KOORI_TYPE},
	{SOUBI_GOOSUTOUP,			GHOST_TYPE},
	{SOUBI_ESUPAAUP,			SP_TYPE},
	{SOUBI_HONOOUP,				FIRE_TYPE},
	{SOUBI_DORAGONUP,			DRAGON_TYPE},
	{SOUBI_NOOMARUUP,			NORMAL_TYPE},
	{SOUBI_AUSUHONOOUP,			FIRE_TYPE},
	{SOUBI_AUSUMIZUUP,			WATER_TYPE},
	{SOUBI_AUSUDENKIUP,			ELECTRIC_TYPE},
	{SOUBI_AUSUKUSAUP,			KUSA_TYPE},
	{SOUBI_AUSUKOORIUP,			KOORI_TYPE},
	{SOUBI_AUSUKAKUTOUUP,		BATTLE_TYPE},
	{SOUBI_AUSUDOKUBARIUP,		POISON_TYPE},
	{SOUBI_AUSUZIMENUP,			JIMEN_TYPE},
	{SOUBI_AUSUTORIUP,			HIKOU_TYPE},
	{SOUBI_AUSUESUPAAUP,		SP_TYPE},
	{SOUBI_AUSUMUSIIRYOKUUP,	MUSHI_TYPE},
	{SOUBI_AUSUIWAUP,			IWA_TYPE},
	{SOUBI_AUSUGOOSUTOUP,		GHOST_TYPE},
	{SOUBI_AUSUDORAGONUP,		DRAGON_TYPE},
	{SOUBI_AUSUAKUUP,			AKU_TYPE},
	{SOUBI_AUSUHAGANEIRYOKUUP,	METAL_TYPE},
};

//============================================================================================
/**
 *	abiritycntɂp[^e[u
 */
//============================================================================================
const	u8	CondChgTable[][2]={
		{10,40},
		{10,35},
		{10,30},
		{10,25},
		{10,20},
		{10,15},
		{10,10},
		{15,10},
		{20,10},
		{25,10},
		{30,10},
		{35,10},
		{40,10},
};

//============================================================================================
/**
 *	Ă̂Ԃpe[u
 */
//============================================================================================
static	const	u16	TetsunoKobushiTable[]={
	WAZANO_REITOUPANTI,		//ꂢƂp`
	WAZANO_HONOONOPANTI,	//ق̂̃p`
	WAZANO_KAMINARIPANTI,	//݂Ȃp`
	WAZANO_MAHHAPANTI,		//}bnp`
	WAZANO_KIAIPANTI,		//p`
	WAZANO_PIYOPIYOPANTI,	//ssp`
	WAZANO_BAKURETUPANTI,	//΂p`
	WAZANO_AAMUHANMAA,		//A[n}[
	WAZANO_MEGATONPANTI,	//Kgp`
	WAZANO_RENZOKUPANTI,	//񂼂p`
	WAZANO_KOMETTOPANTI,	//Rbgp`
	WAZANO_SYADOOPANTI,		//Vh[p`
	WAZANO_DOREINPANTI,		//hCp`
	WAZANO_BARETTOPANTI,	//obgp`
	WAZANO_SUKAIAPPAA,		//XJCAbp[
};

//============================================================================================
/**
 *	Z̃_[WvZB
 *
 * @param[in]	pspa		Zo|P̍\̂̃|C^
 * @param[in]	pspd		Z󂯂|P̍\̂̃|C^
 * @param[in]	wazano		vZZio[
 * @param[in]	side_cond	ɂĂ
 * @param[in]	pow			Z̈З(0:e[uQƁ@0ȊO:̒lQ)
 * @param[in]	type		Z̃^Cv(0:e[uQƁ@0ȊO:̒lQ)
 * @param[in]	attack		ŨNCAgio[
 * @param[in]	defence		h䑤̃NCAgio[
 * @param[in]	critical	}ɓǂ(1:ʏ@2ȏ:NeBJj
 *
 *	@retval	vZʂ̃_[W
 */
//============================================================================================
int	ST_WazaDamageCalc(BATTLE_WORK *bw,SERVER_PARAM *sp,
					  int wazano,u32 side_cond,u32 field_cond,u16 pow,u8 type,u8 attack,u8 defence,u8 critical)
{

	int	i;
	s32	damage=0;
	s32	damage2=0;
	u8	wazatype;
	u8	wazakind;
	u16	pokepow;
	u16	pokedef;
	u16	pokespepow;
	u16	pokespedef;
	s8	condpow;
	s8	conddef;
	s8	condspepow;
	s8	condspedef;
	u8	level;
	u16	wazapow;
	u16	item;
	u32	fight_type;
	WAZA_DAMAGE_CALC_PARAM	wdcp_a;
	WAZA_DAMAGE_CALC_PARAM	wdcp_d;

	GF_ASSERT(((critical==1)||(critical>1))&&"WT_WazaDamageCalc:critical != 1 or 2\n");

	pokepow=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_pow,				NULL);
	pokedef=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_def,				NULL);
	pokespepow=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_spepow,				NULL);
	pokespedef=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_spedef,			NULL);
	condpow=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_abiritycnt_pow,		NULL)-6;
	conddef=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_abiritycnt_def,	NULL)-6;
	condspepow=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_abiritycnt_spepow,	NULL)-6;
	condspedef=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_abiritycnt_spedef,	NULL)-6;
	level=				ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_level,				NULL);
	wdcp_a.monsno=		ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_monsno,				NULL);
	wdcp_d.monsno=		ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_monsno,			NULL);
	wdcp_a.hp=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_hp,					NULL);
	wdcp_d.hp=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_hp,				NULL);
	wdcp_a.hpmax=		ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_hpmax,				NULL);
	wdcp_d.hpmax=		ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_hpmax,				NULL);
	wdcp_a.condition=	ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_condition,			NULL);
	wdcp_d.condition=	ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_condition,			NULL);
	wdcp_a.speabino=	ST_ServerTokuseiGet(sp,attack);
	wdcp_d.speabino=	ST_ServerTokuseiGet(sp,defence);
	wdcp_a.sex=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_sex,				NULL);
	wdcp_d.sex=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_sex,				NULL);
	wdcp_a.type1=		ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_type1,				NULL);
	wdcp_d.type1=		ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_type1,				NULL);
	wdcp_a.type2=		ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_type2,				NULL);
	wdcp_d.type2=		ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_type2,				NULL);

	item=ST_ServerSoubiItemNoGet(sp,attack);
//	wdcp_a.eqp=ItemParamGet(item,ITEM_PRM_EQUIP,HEAPID_BATTLE);
//	wdcp_a.atc=ItemParamGet(item,ITEM_PRM_ATTACK,HEAPID_BATTLE);
	wdcp_a.eqp=ST_ItemParamGet(sp,item,ITEM_PRM_EQUIP);
	wdcp_a.atc=ST_ItemParamGet(sp,item,ITEM_PRM_ATTACK);
	item=ST_ServerSoubiItemNoGet(sp,defence);
//	wdcp_d.eqp=ItemParamGet(item,ITEM_PRM_EQUIP,HEAPID_BATTLE);
//	wdcp_d.atc=ItemParamGet(item,ITEM_PRM_ATTACK,HEAPID_BATTLE);
	wdcp_d.eqp=ST_ItemParamGet(sp,item,ITEM_PRM_EQUIP);
	wdcp_d.atc=ST_ItemParamGet(sp,item,ITEM_PRM_ATTACK);

	fight_type=BattleWorkFightTypeGet(bw);

	if(pow==0){
		wazapow=sp->AIWT.wtd[wazano].damage;
	}
	else{
		wazapow=pow;
	}

	//m[}XĹAZ^Cvm[}ɂ
	if(wdcp_a.speabino==TOKUSYU_NOOMARUSUKIN){
		wazatype=NORMAL_TYPE;
	}
	else if(type==0){
		wazatype=sp->AIWT.wtd[wazano].wazatype;
	}
	else{
		wazatype=type&0x3f;
	}

	GF_ASSERT_MSG(sp->damage_value>=10,"damage_value Under 10!\n");
	wazapow=wazapow*sp->damage_value/10;	//Zɂ_[W{[NɂЗ̓AbvvZ

	//イł񒆂͗̓_[W2{
	if((sp->psp[attack].waza_kouka&WAZAKOUKA_JUUDEN)&&
	   (wazatype==ELECTRIC_TYPE)){	
		wazapow*=2;
	}

	//Ă̓_[W1.5{
	if(sp->otf[attack].tedasuke_flag){	
		wazapow=wazapow*15/10;
	}

	//eNjV́AЗ50ȉ̋Z1.5{ɂi邠́AOj
	if((wdcp_a.speabino==TOKUSYU_TEKUNISYAN)&&
	   (wazano!=WAZANO_WARUAGAKI)&&
	   (wazapow<=60)){
		wazapow=wazapow*15/10;
	}

	wazakind=sp->AIWT.wtd[wazano].kind;

	//́AKp[́AU͂{
	if((wdcp_a.speabino==TOKUSYU_TIKARAMOTI)||(wdcp_a.speabino==TOKUSYU_YOGAPAWAA)){
		pokepow=pokepow*2;
	}

	//X[X^[ǵAɂłĂ5^[ȓ́AU͂𔼕ɂ
	if((wdcp_a.speabino==TOKUSYU_SUROOSUTAATO)&&
	  ((ST_ServerParamDataGet(bw,sp,ID_SP_total_turn,NULL)-
		ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_wkw_slow_start_count,NULL))<5)){
		pokepow/=2;
	}

	//ACeŋZ^CvɂЗ̓Abv̑ʂ̂Ƃ́AЗ́U̓Abv
	for(i=0;i<NELEMS(SoubiItemWazaTypePowUpTbl);i++){
		if((wdcp_a.eqp==SoubiItemWazaTypePowUpTbl[i][0])&&(wazatype==SoubiItemWazaTypePowUpTbl[i][1])){
			wazapow=wazapow*(100+wdcp_a.atc)/100;
			break;
		}
	}

	//ACeœZȂ̑ʂ̂Ƃ́AU1.5{Abv
	if(wdcp_a.eqp==SOUBI_ONAZIWAZAONLY){
		pokepow=pokepow*150/100;
	}
	//ACeœZȂ̑ʂ̂Ƃ́AU1.5{Abv
	if(wdcp_a.eqp==SOUBI_ONAZIAWZAONLYTOKUSYUUP){
		pokespepow=pokespepow*150/100;
	}

	//ACeœUh1.5{̑ʂ̂Ƃ́AUh1.5{Abv
	if((wdcp_a.eqp==SOUBI_TOKUKOUTOKUBOUUP)&&
	  ((fight_type&FIGHT_TYPE_TOWER)==0)&&
	  ((wdcp_a.monsno==MONSNO_RATHIOSU)||(wdcp_a.monsno==MONSNO_RATHIASU))){
		pokespepow=pokespepow*150/100;
	}

	//ACeœUh1.5{̑ʂ̂Ƃ́AUh1.5{Abv
	if((wdcp_d.eqp==SOUBI_TOKUKOUTOKUBOUUP)&&
	  ((fight_type&FIGHT_TYPE_TOWER)==0)&&
	  ((wdcp_d.monsno==MONSNO_RATHIOSU)||(wdcp_d.monsno==MONSNO_RATHIASU))){
		pokespedef=pokespedef*150/100;
	}

	//ACeŃp[ƓU2{̑ʂ̂Ƃ́AU2{Abv
	if((wdcp_a.eqp==SOUBI_PAARURUTOKUKOUNIBAI)&&
	   (wdcp_a.monsno==MONSNO_PAARURU)){
		pokespepow*=2;
	}

	//ACeŃp[Ɠh2{̑ʂ̂Ƃ́Ah2{Abv
	if((wdcp_d.eqp==SOUBI_PAARURUTOKUBOUNIBAI)&&
	   (wdcp_d.monsno==MONSNO_PAARURU)){
		pokespedef*=2;
	}

	//ACeŃsJ`EƈЗ2{̑ʂ̂Ƃ́AЗ2{Abv
	if((wdcp_a.eqp==SOUBI_PIKATYUUTOKUKOUNIBAI)&&
	   (wdcp_a.monsno==MONSNO_PIKATYUU)){
		wazapow*=2;
	}

	//ACeŃ^Ɩh͂2{̑ʂ̂Ƃ́Ah2{Abv
	if((wdcp_d.eqp==SOUBI_METAMONDATOBOUGYORYOKUUP)&&
	   (wdcp_d.monsno==MONSNO_METAMON)){
		pokedef*=2;
	}

	//ACeŃJJAKKƍU͂2{̑ʂ̂Ƃ́AU2{Abv
	if((wdcp_a.eqp==SOUBI_KARAGARADATOKOUGEKINIBAI)&&
	  ((wdcp_a.monsno==MONSNO_KARAKARA)||
	   (wdcp_a.monsno==MONSNO_GARAGARA))){
		pokepow*=2;
	}

	//ACeŃfBAKƋZ̈З͂1.5{
	if((wdcp_a.eqp==SOUBI_DORAGONHAGANEUP)&&
	  ((wazatype==DRAGON_TYPE)||(wazatype==METAL_TYPE))&&
	   (wdcp_a.monsno==MONSNO_IA)){
		wazapow=wazapow*(100+wdcp_a.atc)/100;
	}

	//ACeŃpLAƋZ̈З͂1.5{
	if((wdcp_a.eqp==SOUBI_DORAGONMIZUUP)&&
	  ((wazatype==DRAGON_TYPE)||(wazatype==WATER_TYPE))&&
	   (wdcp_a.monsno==MONSNO_EA)){
		wazapow=wazapow*(100+wdcp_a.atc)/100;
	}

	//ACeŁAÜЗ͂Abv̎́AЗ͂Abv
	if((wdcp_a.eqp==SOUBI_BUTURIIRYOKUUP)&&(wazakind==KIND_BUTSURI)){
		wazapow=wazapow*(100+wdcp_a.atc)/100;
	}

	//ACeŁAÜЗ͂Abv̎́AЗ͂Abv
	if((wdcp_a.eqp==SOUBI_TOKUSYUIRYOKUUP)&&(wazakind==KIND_TOKUSYU)){
		wazapow=wazapow*(100+wdcp_a.atc)/100;
	}

	//\͂ڂ́Aق̂Aɂ悢
	if((ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_ATUISIBOU)==TRUE)&&
	  ((wazatype==FIRE_TYPE)||(wazatype==KOORI_TYPE))){
		wazapow/=2;
	}

	//\͂͂肫́AU1.5{Abv
	if(wdcp_a.speabino==TOKUSYU_HARIKIRI){
		pokepow=pokepow*150/100;
	}

	//\͂񂶂傤́AԈُ̂ƂɍU1.5{Abv
	if((wdcp_a.speabino==TOKUSYU_KONZYOU)&&(wdcp_a.condition)){
		pokepow=pokepow*150/100;
	}

	//\͂ӂȂ낱́AԈُ̂Ƃɖh1.5{Abv
	if((ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_HUSIGINAUROKO)==TRUE)&&(wdcp_d.condition)){
		pokedef=pokedef*150/100;
	}

	//\̓vXA}CiX݂͂ɂƓU͂1.5{Abv
	if((wdcp_a.speabino==TOKUSYU_PURASU)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_MINE_SIDE_HP,attack,TOKUSYU_MAINASU))){
		pokespepow=pokespepow*150/100;
	}
	if((wdcp_a.speabino==TOKUSYU_MAINASU)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_MINE_SIDE_HP,attack,TOKUSYU_PURASU))){
		pokespepow=pokespepow*150/100;
	}

	//Zʂǂ날т́AdCn̋Z̈З͂𔼌
	if((wazatype==ELECTRIC_TYPE)&&(ST_ServerWazaKoukaCheck(bw,sp,WAZAKOUKA_DOROASOBI))){
		wazapow/=2;
	}

	//Zʂ݂т́An̋Z̈З͂𔼌
	if((wazatype==FIRE_TYPE)&&(ST_ServerWazaKoukaCheck(bw,sp,WAZAKOUKA_MIZUASOBI))){
		wazapow/=2;
	}

	//\͂傭HP1/3ȉő^Cv̈З͂1.5{ɂ
	if((wazatype==KUSA_TYPE)&&(wdcp_a.speabino==TOKUSYU_SINRYOKU)&&(wdcp_a.hp<=(wdcp_a.hpmax/3))){
		wazapow=wazapow*150/100;
	}

	//\͂HP1/3ȉŉ^Cv̈З͂1.5{ɂ
	if((wazatype==FIRE_TYPE)&&(wdcp_a.speabino==TOKUSYU_MOUKA)&&(wdcp_a.hp<=(wdcp_a.hpmax/3))){
		wazapow=wazapow*150/100;
	}

	//\͂イHP1/3ȉŐ^Cv̈З͂1.5{ɂ
	if((wazatype==WATER_TYPE)&&(wdcp_a.speabino==TOKUSYU_GEKIRYUU)&&(wdcp_a.hp<=(wdcp_a.hpmax/3))){
		wazapow=wazapow*150/100;
	}
	//\͂ނ̂点HP1/3ȉŒ^Cv̈З͂1.5{ɂ
	if((wazatype==MUSHI_TYPE)&&(wdcp_a.speabino==TOKUSYU_MUSINOSIRASE)&&(wdcp_a.hp<=(wdcp_a.hpmax/3))){
		wazapow=wazapow*150/100;
	}
	//˂́An̋Z̈З͂𔼌
	if((wazatype==FIRE_TYPE)&&(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TAINETU)==TRUE)){
		wazapow/=2;
	}
	//񂻂͂́An̋Z̈З͂25%
	if((wazatype==FIRE_TYPE)&&(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_KANSOUHADA)==TRUE)){
		wazapow=wazapow*125/100;
	}
	//񂶂́A\͕ωl{
	if(wdcp_a.speabino==TOKUSYU_TANZYUN){
		condpow*=2;
		if(condpow<-6){
			condpow=-6;
		}
		if(condpow>6){
			condpow=6;
		}
		condspepow*=2;
		if(condspepow<-6){
			condspepow=-6;
		}
		if(condspepow>6){
			condspepow=6;
		}
	}
	//񂶂́A\͕ωl{
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TANZYUN)==TRUE){
		conddef*=2;
		if(conddef<-6){
			conddef=-6;
		}
		if(conddef>6){
			conddef=6;
		}
		condspedef*=2;
		if(condspedef<-6){
			condspedef=-6;
		}
		if(condspedef>6){
			condspedef=6;
		}
	}

	//Ă˂́A\͕ωltbg
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TENNEN)==TRUE){
		condpow=0;
		condspepow=0;
	}
	//Ă˂́A\͕ωltbg
	if(wdcp_a.speabino==TOKUSYU_TENNEN){
		conddef=0;
		condspedef=0;
	}

	condpow+=6;
	conddef+=6;
	condspepow+=6;
	condspedef+=6;

	//Ƃ́Aʂꏏ1.25{ɂ
	if((wdcp_a.speabino==TOKUSYU_TOUSOUSIN)&&
	   (wdcp_a.sex==wdcp_d.sex)&&(wdcp_a.sex!=PARA_UNK)&&(wdcp_d.sex!=PARA_UNK)){
		wazapow=wazapow*125/100;
	}
	//Ƃ́Aʂ0.75{ɂ
	if((wdcp_a.speabino==TOKUSYU_TOUSOUSIN)&&
	   (wdcp_a.sex!=wdcp_d.sex)&&(wdcp_a.sex!=PARA_UNK)&&(wdcp_d.sex!=PARA_UNK)){
		wazapow=wazapow*75/100;
	}

	//Ă̂Ԃ́Ap`n̋Z̈З͂1.2{ɂ
	for(i=0;i<NELEMS(TetsunoKobushiTable);i++){
		if((TetsunoKobushiTable[i]==wazano)&&(wdcp_a.speabino==TOKUSYU_TETUNOKOBUSI)){
			wazapow=wazapow*12/10;
			break;
		}
	}

	//V`FbNîĂ񂫂̃|P퓬ɏoĂꍇ͓V`FbNȂj
	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		//Tp[́A͂̎AU1.5{ɂ
		if((field_cond&FIELD_CONDITION_HARE_ALL)&&(wdcp_a.speabino==TOKUSYU_SANPAWAA)){
			pokespepow=pokespepow*15/10;
		}
		//^Cv́AȂ炵̎Ah1.5{ɂ
		if((field_cond&FIELD_CONDITION_SUNAARASHI_ALL)&&
		  ((wdcp_d.type1==IWA_TYPE)||(wdcp_d.type2==IWA_TYPE))){
			pokespedef=pokespedef*15/10;
		}
		//t[MtǵAV󂪐̂ƂAƖ̍UƓh1.5{B
		if((field_cond&FIELD_CONDITION_HARE_ALL)&&
		   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_MINE_SIDE_HP,attack,TOKUSYU_HURAWAAGIHUTO))){
			pokepow=pokepow*15/10;
		}
		if((field_cond&FIELD_CONDITION_HARE_ALL)&&
		   (ST_ServerTokuseiGet(sp,attack)!=TOKUSYU_KATAYABURI)&&
		   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_MINE_SIDE_HP,defence,TOKUSYU_HURAWAAGIHUTO))){
			pokespedef=pokespedef*15/10;
		}
	}

	//u΂vu΂͂v́Ah͂𔼕ɂČvZ
	if(sp->AIWT.wtd[wazano].battleeffect==7){
		pokedef=pokedef/2;
	}

	if(wazakind==KIND_BUTSURI){	//U
		if(critical>1){
			if(condpow>6){
				damage=pokepow*CondChgTable[condpow][0];
				damage/=CondChgTable[condpow][1];
			}
			else{
				damage=pokepow;
			}
		}
		else{
			damage=pokepow*CondChgTable[condpow][0];
			damage/=CondChgTable[condpow][1];
		}

		damage*=wazapow;
		damage*=(level*2/5+2);

		if(critical>1){
			if(conddef<6){
				damage2=pokedef*CondChgTable[conddef][0];
				damage2/=CondChgTable[conddef][1];
			}
			else{
				damage2=pokedef;
			}
		}
		else{
			damage2=pokedef*CondChgTable[conddef][0];
			damage2/=CondChgTable[conddef][1];
		}

		damage/=damage2;
		damage/=50;

		//\͂񂶂傤́AԈُōU͂̂ł͖̔
		if((wdcp_a.condition&CONDITION_YAKEDO)&&(wdcp_a.speabino!=TOKUSYU_KONZYOU)){
			damage/=2;
		}

		//퓬186̓K[h̉e󂯂Ȃ
		if(((side_cond&SIDE_CONDITION_BUTSURIGUARD)!=0)&&(critical==1)&&(sp->AIWT.wtd[wazano].battleeffect!=186)){
			if((fight_type&FIGHT_TYPE_2vs2)&&(ST_ServerHitCountCheck(bw,sp,SHCC_SIDE,defence)==2)){
				damage=damage*2/3;
			}
			else{
				damage/=2;
			}
		}
	}
	else if(wazakind==KIND_TOKUSYU){			//U
		if(critical>1){
			if(condspepow>6){
				damage=pokespepow*CondChgTable[condspepow][0];
				damage/=CondChgTable[condspepow][1];
			}
			else{
				damage=pokespepow;
			}
		}
		else{
			damage=pokespepow*CondChgTable[condspepow][0];
			damage/=CondChgTable[condspepow][1];
		}

		damage*=wazapow;
		damage*=(level*2/5+2);

		if(critical>1){
			if(condspedef<6){
				damage2=pokespedef*CondChgTable[condspedef][0];
				damage2/=CondChgTable[condspedef][1];
			}
			else{
				damage2=pokespedef;
			}
		}
		else{
			damage2=pokespedef*CondChgTable[condspedef][0];
			damage2/=CondChgTable[condspedef][1];
		}

		damage/=damage2;
		damage/=50;

		//퓬186̓K[h̉e󂯂Ȃ
		if(((side_cond&SIDE_CONDITION_TOKUSYUGUARD)!=0)&&(critical==1)&&(sp->AIWT.wtd[wazano].battleeffect!=186)){
			if((fight_type&FIGHT_TYPE_2vs2)&&(ST_ServerHitCountCheck(bw,sp,SHCC_SIDE,defence)==2)){
				damage=damage*2/3;
			}
			else{
				damage/=2;
			}
		}

	}

	if((fight_type&FIGHT_TYPE_2vs2)&&
	   (sp->AIWT.wtd[wazano].attackrange==RANGE_DOUBLE)&&
	   (ST_ServerHitCountCheck(bw,sp,SHCC_SIDE,defence)==2)){
		damage=damage*3/4;
	}
	if((fight_type&FIGHT_TYPE_2vs2)&&
	   (sp->AIWT.wtd[wazano].attackrange==RANGE_TRIPLE)&&
	   (ST_ServerHitCountCheck(bw,sp,SHCC_NORMAL,defence)>=2)){
		damage=damage*3/4;
	}

	//V`FbNîĂ񂫂̃|P퓬ɏoĂꍇ͓V`FbNȂj
	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		if(field_cond&FIELD_CONDITION_AME_ALL){
			switch(wazatype){
				case FIRE_TYPE:
					damage/=2;
					break;
				case WATER_TYPE:
					damage=damage*15/10;
					break;
			}
		}

		if((field_cond&FIELD_CONDITION_NO_SOLAR)&&(wazano==WAZANO_SOORAABIIMU)){
			damage/=2;
		}
		if(field_cond&FIELD_CONDITION_HARE_ALL){
			switch(wazatype){
				case FIRE_TYPE:
					damage=damage*15/10;
					break;
				case WATER_TYPE:
					damage/=2;
					break;
			}
		}
	}

	//\͂炢у`FbN
	if((ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_wkw_moraibi_flag,NULL))&&(wazatype==FIRE_TYPE)){
		damage=damage*15/10;
	}

	return	damage+2;
}

// =================================================================
// void	WS_DAMAGE_LOSS
// Tv  : _[WvZŋ߂l85%`100%͈̔͂Œ
//   : none
// ߂l: none
// =================================================================
int		ST_DamageLossCalc(SERVER_PARAM *sp,int damage)
{
#ifdef PM_DEBUG
	//fobO[hŃ_[WŒtOĂꍇ́ALossCalc͂Ȃ
	if(sp->dbp.debug_flag&DEBUG_FLAG_DAMAGE_LOCK){
		return damage;
	}
#endif

	if(damage){
		damage*=(100-(gf_rand()%16));
		damage/=100;
		if(damage==0){
			damage=1;
		}
	}

	return damage;
}

//============================================================================================
/**
 *	NeBJqbgłme[u
 */
//============================================================================================
static	const	u8	CriticalTable[]={
	16,8,4,3,2
};

//============================================================================================
/**
 *	}ɓ邩ǂ̃`FbN
 *
 * @param[in]	sp				T[op[^\̂̃|C^
 * @param[in]	attack			UClientNo
 * @param[in]	defence			h䑤ClientNo
 * @param[in]	critical_count	NeBJqbg̔{ϓ郏[N
 *
 * @retval	1:_[W{1{	2:_[W{2{
 */
//============================================================================================
int		ST_CriticalCheck(SERVER_PARAM *sp,int attack,int defence,int critical_count,u32 side_condition)
{
	u16		work;
	u16		item;
	int		eqp;
	u16		monsno;
	u32		condition2;
	u32		waza_kouka;
	int		ret=1;
	int		speabi;

	item=ST_ServerSoubiItemNoGet(sp,attack);
//	eqp=ItemParamGet(item,ITEM_PRM_EQUIP,HEAPID_BATTLE);
	eqp=ST_ItemParamGet(sp,item,ITEM_PRM_EQUIP);

	monsno=sp->psp[attack].monsno;
	condition2=sp->psp[attack].condition2;
	waza_kouka=sp->psp[defence].waza_kouka;
	speabi=sp->psp[attack].speabino;

	work=(((condition2&CONDITION2_KIAIDAME)!=0)*2)+
		 (eqp==SOUBI_KYUUSYONIATARIYASUI)+
		 critical_count+
		 //傤́A}qbgiKPAbv
		 (speabi==TOKUSYU_KYOUUN)+
		 (2*((eqp==SOUBI_RAKKIIDATOKYUUSYONIATARIYASUI)&&(monsno==MONSNO_RAKKII)))+
		 (2*((eqp==SOUBI_KAMONEGIKYUUSYOATARIYASUI)&&(monsno==MONSNO_KAMONEGI)));

	if(work>4){
		work=4;
	}

	if(gf_rand()%CriticalTable[work]==0){
		//JugA[}[AVFA[}[Ƃ͋}ɂȂ
		if((ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_KABUTOAAMAA)==FALSE)&&
		   (ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_SHERUAAMAA)==FALSE)&&
		  ((side_condition&SIDE_CONDITION_OMAZINAI)==0)&&
		  ((waza_kouka&WAZAKOUKA_NOCRITICAL)==0)){
			ret=2;
		}
	}

	//XiCp[́A}{3{ɂ
	if((ret==2)&&(ST_ServerTokuseiGet(sp,attack)==TOKUSYU_SUNAIPAA)){
		ret=3;
	}

	return ret;
}

//============================================================================================
/**
 * ȋZe[u
 */
//============================================================================================
#define	MONOMANE_NG_TBL_END	(0xfffe)
#define	WAZA_OUT_NG_TBL_END	(0xffff)

static	const u16 WazaOutNGTbl[]={
	WAZANO_YUBIWOHURU,			// тӂ
	WAZANO_WARUAGAKI,			// 邠
	WAZANO_SUKETTI,				// XPb`
	WAZANO_MONOMANE,			// ̂܂
	WAZANO_OSYABERI,			// ׂ
	MONOMANE_NG_TBL_END,		// ̂܂˂łȂe[ũGh
	WAZANO_NEGOTO,				// ˂
	WAZANO_NEKONOTE,			// ˂̂
	WAZANO_OUMUGAESI,			// IE
	WAZANO_KAUNTAA,				// JE^[
	WAZANO_MIRAAKOOTO,			// ~[R[g
	WAZANO_MAMORU,				// ܂
	WAZANO_MIKIRI,				// ݂
	WAZANO_KORAERU,				// 炦
	WAZANO_MITIDURE,			// ݂Â
	WAZANO_DOROBOU,				// ǂڂ
	WAZANO_KONOYUBITOMARE,		// ̂тƂ܂
	WAZANO_YOKODORI,			// 悱ǂ
	WAZANO_TEDASUKE,			// Ă
	WAZANO_HOSIGARU,			// ق
	WAZANO_TORIKKU,				// gbN
	WAZANO_KIAIPANTI,			// p`
	WAZANO_FEINTO,				// tFCg
	WAZANO_MANEKKO,				// ܂˂
	WAZANO_SAKIDORI,			// ǂ
	WAZANO_SURIKAE,				// 肩
	WAZA_OUT_NG_TBL_END
};

//============================================================================================
/**
 *	̂܂˂łZ`FbN
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	FALSE:łȂ@TRUE:ł
 */
//============================================================================================
BOOL	ST_MonomaneNGCheck(u16 waza_no)
{
	int	i;

	i=0;

	while(WazaOutNGTbl[i]!=MONOMANE_NG_TBL_END){
		if(WazaOutNGTbl[i]==waza_no){
			break;
		}
		i++;
	}
	return (WazaOutNGTbl[i]==MONOMANE_NG_TBL_END);
}

//============================================================================================
/**
 *	тӂłZ`FbN
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	FALSE:oȂ@TRUE:o
 */
//============================================================================================
BOOL	ST_YubiwohuruNGCheck(u16 waza_no)
{
	int	i;

	i=0;

	while(WazaOutNGTbl[i]!=WAZA_OUT_NG_TBL_END){
		if(WazaOutNGTbl[i]==waza_no){
			break;
		}
		i++;
	}
	return (WazaOutNGTbl[i]==WAZA_OUT_NG_TBL_END);
}

//============================================================================================
/**
 *	IEŕԂ邩AAR[oZ`FbNpZio[e[u
 */
//============================================================================================

static	const	u16		WazaOumuEncoreNGCheckTable[]={
	WAZANO_HENSIN,
	WAZANO_MONOMANE,
	WAZANO_SUKETTI,
	WAZANO_OUMUGAESI,
	WAZANO_ANKOORU,
	WAZANO_WARUAGAKI,
};

//============================================================================================
/**
 *	IEŕԂ邩AAR[oZ`FbN
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	FALSE:oȂ@TRUE:o
 */
//============================================================================================
BOOL	ST_OumuEncoreNGCheck(SERVER_PARAM *sp,u16 waza_no)
{
	int	i;

	i=0;

	while(i<NELEMS(WazaOumuEncoreNGCheckTable)){
//		if(WT_WazaDataParaGet(WazaOumuEncoreNGCheckTable[i],ID_WTD_battleeffect)==
//		   WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)){
		if(sp->AIWT.wtd[WazaOumuEncoreNGCheckTable[i]].battleeffect==sp->AIWT.wtd[waza_no].battleeffect){
			break;
		}
		i++;
	}

	return (i==NELEMS(WazaOumuEncoreNGCheckTable));
}

//============================================================================================
/**
 *	ǂ萬Z`FbNpZio[e[u
 */
//============================================================================================

static	const	u16		SakidoriNGCheckTable[]={
	WAZANO_KAUNTAA,
	WAZANO_MIRAAKOOTO,
	WAZANO_DOROBOU,
	WAZANO_HOSIGARU,
	WAZANO_KIAIPANTI,
	WAZANO_OSYABERI,
};

//============================================================================================
/**
 *	ǂ萬Z`FbN
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	FALSE:oȂ@TRUE:o
 */
//============================================================================================
BOOL	ST_SakidoriNGCheck(SERVER_PARAM *sp,u16 waza_no)
{
	int	i;

	i=0;

	while(i<NELEMS(SakidoriNGCheckTable)){
		if(sp->AIWT.wtd[SakidoriNGCheckTable[i]].battleeffect==sp->AIWT.wtd[waza_no].battleeffect){
			break;
		}
		i++;
	}

	return (i==NELEMS(SakidoriNGCheckTable));
}

//============================================================================================
/**
 *	ACep[^̎擾
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	item_no		擾ACeio[
 * @param[in]	param		擾p[^ID
 *
 * @retval	l
 */
//============================================================================================
s32	ST_ItemParamGet(SERVER_PARAM *sp,u16 item_no,u16 param)
{
	ITEMDATA	*item_data;
	u16			index;

	index=GetItemIndex(item_no,ITEM_GET_DATA);
	item_data=GetItemDataPointer(sp->AIWT.item,index);

	return ItemBufParamGet(item_data,param);
}

//============================================================================================
/**
 *	dirp[^ClientNo擾
 *
 * @param[in]	bw		퓬VXe\̃|C^
 * @param[in]	sp		T[op[^̍\̃|C^
 * @param[in]	dir		擾ClientNǒ
 *
 * @retval	l
 */
//============================================================================================
int		ST_ServerDir2ClientNoGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int dir)
{
	int	client_no;
	int	client_set_max;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(client_no=0;client_no<client_set_max;client_no++){
		if(BattleWorkMineEnemyCheck(bw,client_no)==dir){
			break;
		}
	}

	return client_no;
}

//============================================================================================
/**
 *	gbN[
 *
 * @param[in]	bw		퓬VXe\̃|C^
 * @param[in]	sp		T[op[^̍\̃|C^
 */
//============================================================================================
void	ST_ServerTrickRoomAct(BATTLE_WORK *bw,SERVER_PARAM *sp)
{
	int	i,j;
	int	cl1;
	int	cl2;
	int	flag;
	int	client_set_max;

	client_set_max=BattleWorkClientSetMaxGet(bw);

	for(i=0;i<client_set_max-1;i++){
		for(j=i+1;j<client_set_max;j++){
			cl1=sp->client_agi_work[i];
			cl2=sp->client_agi_work[j];
			if(sp->client_act_work[cl1][ACT_PARA_SELECT_COMMAND]==sp->client_act_work[cl2][ACT_PARA_SELECT_COMMAND]){
				if(sp->client_act_work[cl1][ACT_PARA_SELECT_COMMAND]==SELECT_FIGHT_COMMAND){
					flag=0;
				}
				else{
					flag=1;
				}
				if(ST_ServerAgiCalc(bw,sp,cl1,cl2,flag)){
					sp->client_agi_work[i]=cl2;
					sp->client_agi_work[j]=cl1;
				}
			}
		}
	}
}

//============================================================================================
/**
 *	݂肪邩`FbNāASTATUS_EFFECTł邩fpe[u
 */
//============================================================================================
static	const	int	MigawariOKStatusEffect[]={
	STATUS_EFF_MIGAWARI_OUT,	///< oʊO
	STATUS_EFF_MIGAWARI_IN,		///< oʓ
	STATUS_EFF_ITEM_POUCH,		///< oGlRۂƃsbsl`
	STATUS_WEATHER_MIST,		///< V 
	STATUS_WEATHER_RAIN,		///< V J
	STATUS_WEATHER_ICE,			///< V 
	STATUS_WEATHER_SAND,		///< V 炵
	STATUS_WEATHER_SUN,			///< V Ђ
	STATUS_ACTION_DOLL_ON,		///< o ݂肨Ă
	STATUS_ACTION_DOLL_OFF,		///<  ݂OFF
};

//============================================================================================
/**
 *	݂肪邩`FbNāASTATUS_EFFECTł邩f
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	`FbNClientNo
 * @param[in]	status		`FbNSTATUS_EFFECTio[
 *
 * @retval	FALSE:łȂ@TRUE:ł
 */
//============================================================================================
BOOL	ST_ServerStatusEffectMigawariCheck(SERVER_PARAM *sp,int client_no,int status)
{
	int		i;
	BOOL	ret=FALSE;

	if((sp->psp[client_no].condition2&CONDITION2_MIGAWARI)||
	   (sp->psp[client_no].waza_kouka&WAZAKOUKA_KIE)){
		for(i=0;i<NELEMS(MigawariOKStatusEffect);i++){
			if(MigawariOKStatusEffect[i]==status){
				ret=TRUE;
				break;
			}
		}
	}
	else{
		ret=TRUE;
	}

	return ret;
}

//============================================================================================
/**
 *	UqbgɃ`FbN鑕ʁiƂڂj
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	`FbNClientNo
 * @param[in]	status		`FbNSTATUS_EFFECTio[
 *
 * @retval	FALSE:łȂ@TRUE:ł
 */
//============================================================================================
BOOL	ST_ServerWazaHitSoubiItemCheckTonbogaeri(BATTLE_WORK *bw,SERVER_PARAM *sp,int *seq_no)
{
	BOOL	ret;
	int		client_no;
	int		eqp_a;
	int		atk_a;
	int		eqp_d;
	int		atk_d;
	int		dir;
	
	ret=FALSE;

	eqp_a=ST_ServerSoubiEqpGet(sp,sp->attack_client);
	atk_a=ST_ServerSoubiAtkGet(sp,sp->attack_client,ATK_CHECK_NORMAL);

	eqp_d=ST_ServerSoubiEqpGet(sp,sp->defence_client);
	atk_d=ST_ServerSoubiAtkGet(sp,sp->defence_client,ATK_CHECK_NORMAL);

	dir=BattleWorkMineEnemyCheck(bw,sp->attack_client);

	if((eqp_a==SOUBI_HPKAIHUKUDAMEEZIRITU)&&
	   (sp->server_status_flag&SERVER_STATUS_FLAG_WAZA_HIT)&&
       (sp->ostf[sp->attack_client].kaigara_damage)&&
	   (sp->attack_client!=sp->defence_client)&&
	   (sp->psp[sp->attack_client].hp<sp->psp[sp->attack_client].hpmax)&&
	   (sp->psp[sp->attack_client].hp)){
		sp->hp_calc_work=ST_ServerDamageDiv(sp->ostf[sp->attack_client].kaigara_damage*-1,atk_a);
		sp->client_work=sp->attack_client;
		seq_no[0]=SUB_SEQ_EQPITEM_HP_KAIHUKUMAITURN;
		ret=TRUE;
	}

	if((eqp_a==SOUBI_WAZAIRYOKUUPHPMAINASU)&&
		//}WbNK[h̓_[WȂ
	   (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_MAZIKKUGAADO)&&
	   (sp->server_status_flag&SERVER_STATUS_FLAG_WAZA_HIT)&&
	   (sp->AIWT.wtd[sp->waza_no_now].kind!=KIND_HENKA)&&
	   (sp->psp[sp->attack_client].hp)){
		sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*-1,10);
		sp->client_work=sp->attack_client;
		seq_no[0]=SUB_SEQ_EQPITEM_HP_MAINASU;
		ret=TRUE;
	}

	if((eqp_d==SOUBI_BUTURIDEKOUGEKI)&&
	   (sp->psp[sp->attack_client].hp)&&
		//}WbNK[hɂ͕s
	   (ST_ServerTokuseiGet(sp,sp->attack_client)!=TOKUSYU_MAZIKKUGAADO)&&
	   (sp->ostf[sp->defence_client].butsuri_ostf_damage)){
		sp->hp_calc_work=ST_ServerDamageDiv(sp->psp[sp->attack_client].hpmax*-1,atk_d);
		seq_no[0]=SUB_SEQ_EQPITEM_HIT_DAMAGE;
		ret=TRUE;
	}
	if((eqp_d==SOUBI_TEKINIMOTASETEDAMEEZI)&&
	   (sp->psp[sp->attack_client].hp)&&
	   (sp->psp[sp->attack_client].item==0)&&
	  ((sp->scw[dir].hatakiotosu_item&No2Bit(sp->sel_mons_no[sp->attack_client]))==0)&&
	  ((sp->ostf[sp->defence_client].butsuri_ostf_damage)||
	   (sp->ostf[sp->defence_client].tokusyu_ostf_damage))&&
	   (sp->AIWT.wtd[sp->waza_no_now].flag&FLAG_DAGEKI)){
		seq_no[0]=SUB_SEQ_EQPITEM_KUTTUKI;
		ret=TRUE;
	}

	return ret;
}

//============================================================================================
/**
 *	UΏۂvbV[Ă邩`FbNPP炷
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	attack		UClientNo
 * @param[in]	defence		h䑤ClientNo
 */
//============================================================================================
void	ST_ServerPressurePPDecCheck(SERVER_PARAM *sp,int attack,int defence)
{
	if((ST_ServerTokuseiGet(sp,defence)==TOKUSYU_PURESSYAA)&&
	   (defence!=NONE_CLIENT_NO)&&
	   (sp->psp[attack].pp[sp->waza_no_pos[attack]])){
		sp->psp[attack].pp[sp->waza_no_pos[attack]]--;
	}
}

//============================================================================================
//			p[^Qbgn
//============================================================================================
//============================================================================================
/**
 *	SERVER_PARAM\̂̃o̒l擾
 *
 * @param[in]	bw			퓬p[^̍\̃|C^
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	id			擾õCfbNX
 * @param[in]	client_no	擾oClientNoiKvȏꍇj
 *
 * @retval	l
 */
//============================================================================================
int		ST_ServerParamDataGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int id,int client_no)
{
	int	dir;

	switch(id){
	case ID_SP_side_condition:
		dir=BattleWorkMineEnemyCheck(bw,client_no);
		return sp->side_condition[dir];
		break;
	case ID_SP_shiroikiri_count:
		dir=BattleWorkMineEnemyCheck(bw,client_no);
		return sp->scw[dir].shiroikiri_count;
		break;
	case ID_SP_sel_mons_no:
		return sp->sel_mons_no[client_no];
		break;
	case ID_SP_total_turn:
		return sp->total_turn;
		break;
	case ID_SP_level_up_pokemon:
		return sp->level_up_pokemon;
		break;
	case ID_SP_safari_escape_count:
		return sp->safari_escape_count;
		break;
	case ID_SP_total_hinshi:
		return sp->total_hinshi[client_no];
		break;
	case ID_SP_total_damage:
		return sp->total_damage[client_no];
		break;
	case ID_SP_act_no:
		return sp->client_act_work[client_no][ACT_PARA_ACT_NO];
		break;
	case ID_SP_ai_defence_client:
		return sp->AIWT.AI_DefenceClient;
		break;
	case ID_SP_no_reshuffle_client:
		return sp->no_reshuffle_client;
		break;
	case ID_SP_dir_select_client:
		return sp->AIWT.AI_DirSelectClient[client_no];
		break;
	case ID_SP_act_work:
		return sp->client_act_work[client_no][ACT_PARA_WORK];
		break;
	}
	GF_ASSERT_MSG((0),"`ĂȂIDł\n");
	return 0;
}

//============================================================================================
//			p[^Zbgn
//============================================================================================
//============================================================================================
/**
 *	ostf_status_flagZbg
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	client_no	ZbgClientNo
 * @param[in]	value		Zbgl
 */
//============================================================================================
void	ST_ServerOSTFStatusFlagSet(SERVER_PARAM *sp,int client_no,u32 value)
{
	sp->ostf[client_no].status_flag|=value;
}

//============================================================================================
/**
 *	SERVER_PARAM̃oɒlZbg
 *
 * @param[in]	bw			퓬p[^̍\̃|C^
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	id			ZbgõCfbNX
 * @param[in]	client_no	ZbgoClientNoiKvȏꍇj
 * @param[in]	data		Zbgl
 */
//============================================================================================
void	ST_ServerParamDataPut(BATTLE_WORK *bw,SERVER_PARAM *sp,int id,int client_no,int data)
{
	int	dir;

	switch(id){
	case ID_SP_side_condition:
		dir=BattleWorkMineEnemyCheck(bw,client_no);
		sp->side_condition[dir]=data;
		break;
	case ID_SP_shiroikiri_count:
		dir=BattleWorkMineEnemyCheck(bw,client_no);
		sp->scw[dir].shiroikiri_count=data;
		break;
	case ID_SP_sel_mons_no:
		sp->sel_mons_no[client_no]=data;
		break;
	case ID_SP_total_turn:
		sp->total_turn=data;
		break;
	case ID_SP_ai_defence_client:
		sp->AIWT.AI_DefenceClient=data;
		break;
	case ID_SP_dir_select_client:
		sp->AIWT.AI_DirSelectClient[client_no]=data;
		break;
	default:
		GF_ASSERT_MSG((0),"`ĂȂIDł\n");
		break;
	}
}

//============================================================================================
//			OJȂn
//============================================================================================
//============================================================================================
//			ǉʓV[PXio[e[u
//============================================================================================
static const int AddStatusSeqNoTable[]=
{
	NULL,		//_~[
	SUB_SEQ_NEMURI,				//˂ނ
	SUB_SEQ_DOKU,				//
	SUB_SEQ_YAKEDO,				//₯
	SUB_SEQ_KOORI,				//
	SUB_SEQ_MAHI,				//܂
	SUB_SEQ_DOKUDOKU,			//ǂǂ
	SUB_SEQ_KONRAN,				//
	SUB_SEQ_HIRUMU,				//Ђ
	SUB_SEQ_NEMURU,				//˂ނ
	SUB_SEQ_SAWAGU,				//킮
	SUB_SEQ_NEKONIKOBAN,		//˂ɂ΂
	SUB_SEQ_KEEP,				//ߌn̋Z
	SUB_SEQ_SHIME,				//ߌn̋Z
	SUB_SEQ_HANEKAERI,			//͂˂n̋Z(1/4)
	SUB_SEQ_ABICNT_CALC,		//U̓Abv
	SUB_SEQ_ABICNT_CALC,		//h̓Abv
	SUB_SEQ_ABICNT_CALC,		//fAbv
	SUB_SEQ_ABICNT_CALC,		//UAbv
	SUB_SEQ_ABICNT_CALC,		//hAbv
	SUB_SEQ_ABICNT_CALC,		//Abv
	SUB_SEQ_ABICNT_CALC,		//𗦃Abv
	SUB_SEQ_ABICNT_CALC,		//U̓_E
	SUB_SEQ_ABICNT_CALC,		//h̓_E
	SUB_SEQ_ABICNT_CALC,		//f_E
	SUB_SEQ_ABICNT_CALC,		//U_E
	SUB_SEQ_ABICNT_CALC,		//h_E
	SUB_SEQ_ABICNT_CALC,		//_E
	SUB_SEQ_ABICNT_CALC,		//𗦃_E
	SUB_SEQ_HANDOU,				//͂ǂ
	SUB_SEQ_IKARI,				//
	SUB_SEQ_DOROBOU,			//ǂڂ
	SUB_SEQ_KUROIMANAZASI,		//낢܂Ȃ
	SUB_SEQ_AKUMU,				//
	SUB_SEQ_GENSHINOCHIKARA,	//񂵂̂
	SUB_SEQ_KOUSOKUSPIN,		//Xs
	SUB_SEQ_NO_MAHI,			//܂ЂȂ
	SUB_SEQ_BAKADIKARA,			//΂
	SUB_SEQ_HANEKAERI2,			//͂˂n̋Z(1/3)
	SUB_SEQ_ABICNT_CALC,		//U̓Abv(2iKj
	SUB_SEQ_ABICNT_CALC,		//h̓Abv(2iKj
	SUB_SEQ_ABICNT_CALC,		//fAbv(2iKj
	SUB_SEQ_ABICNT_CALC,		//UAbv(2iKj
	SUB_SEQ_ABICNT_CALC,		//hAbv(2iKj
	SUB_SEQ_ABICNT_CALC,		//Abv(2iKj
	SUB_SEQ_ABICNT_CALC,		//𗦃Abv(2iKj
	SUB_SEQ_ABICNT_CALC,		//U̓_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//h̓_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//f_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//U_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//h_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//_E(2iKj
	SUB_SEQ_ABICNT_CALC,		//𗦃_E(2iKj
	SUB_SEQ_ABARERU,			//΂
	SUB_SEQ_HATAKIOTOSU,		//͂Ƃ
	SUB_SEQ_COSMO_POWER,		//RXp[iAbviabiritycntnjj
	SUB_SEQ_BUILD_UP,			//rhAbviAbviabiritycntnjj
	SUB_SEQ_KUSUGURU,			//i_Eiabiritycntnjj
	SUB_SEQ_MEISOU,				//߂iAbviabiritycntnjj
	SUB_SEQ_RYUUNOMAI,			//イ̂܂iAbviabiritycntnjj
	SUB_SEQ_SUITORI,			//HPƂn
	SUB_SEQ_YUMEKUI,			//߂
	SUB_SEQ_KUROIKIRI,			//낢
	SUB_SEQ_GAMAN,				//܂
	SUB_SEQ_WARUAGAKI,			//邠
	SUB_SEQ_TEXTURE,			//eNX`
	SUB_SEQ_JIKOSAISEI,			//
	SUB_SEQ_HIKARINOKABE,		//Ђ̂
	SUB_SEQ_RIHUREKUTAA,		//tN^[
	SUB_SEQ_SIROIKIRI,			//낢
	SUB_SEQ_KIAIDAME,			//
	SUB_SEQ_MONOMANE,			//̂܂
	SUB_SEQ_YADORIGI,			//ǂ肬̂
	SUB_SEQ_KANASIBARI,			//Ȃ΂
	SUB_SEQ_ENCORE,				//AR[
	SUB_SEQ_ITAMIWAKE,			//݂킯
	SUB_SEQ_TEXTURE2,			//eNX`Q
	SUB_SEQ_LOCKON,				//bNI
	SUB_SEQ_SKETCH,				//XPb`
	SUB_SEQ_FEINT,				//tFCg
	SUB_SEQ_MICHIDURE,			//݂Â
	SUB_SEQ_URAMI,				//
	SUB_SEQ_GUARD,				//܂A݂A炦Ȃ
	SUB_SEQ_IYASINOSUZU,		//₵̂
	SUB_SEQ_MIGAWARI,			//݂
	SUB_SEQ_HUKITOBASI,			//ӂƂ΂
	SUB_SEQ_HENSIN,				//ւ񂵂
	SUB_SEQ_CHIISAKUNARU,		//Ȃ
	SUB_SEQ_NORMAL_NOROI,		//̂낢im[}j
	SUB_SEQ_GHOST_NOROI,		//̂낢iS[Xgj
	SUB_SEQ_ADD_MESSAGE_WORK,	//bZ[W\
	SUB_SEQ_MIYABURU,			//݂Ԃ
	SUB_SEQ_HOROBINOUTA,		//قт̂
	SUB_SEQ_TENKOU,				//Vn
	SUB_SEQ_IBARU,				//΂
	SUB_SEQ_MEROMERO,			//
	SUB_SEQ_SHINPI,				//҂̂܂
	SUB_SEQ_PRESENT,			//v[g
	SUB_SEQ_MAGNITUDE,			//}Oj`[h
	SUB_SEQ_BATONTOUCH,			//og^b`
	SUB_SEQ_HARADAIKO,			//͂炾
	SUB_SEQ_TELEPORT,			//e|[g
	SUB_SEQ_HUKURODATAKI,		//ӂ낾
	SUB_SEQ_TAKUWAERU,			//킦
	SUB_SEQ_NOMIKOMU,			//݂̂
	SUB_SEQ_ICHAMON,			//
	SUB_SEQ_ODATERU,			//Ă
	SUB_SEQ_OKIMIYAGE,			//݂₰
	SUB_SEQ_JUUDEN,				//イł
	SUB_SEQ_CHOUHATSU,			//傤͂
	SUB_SEQ_TRICK,				//gbN
	SUB_SEQ_NARIKIRI,			//Ȃ肫
	SUB_SEQ_KAWARAWARI,			//
	SUB_SEQ_AKUBI,				//
	SUB_SEQ_SKILLSWAP,			//XLXbv
	SUB_SEQ_REFRESH,			//tbV
	SUB_SEQ_HANEYASUME,			//͂˂₷
	SUB_SEQ_NO_NEMURI,			//߂܂r^
	SUB_SEQ_JUURYOKU,			//イ傭
	SUB_SEQ_MIRACLE_EYE,		//~NAC
	SUB_SEQ_IYASINONEGAI,		//₵̂˂
	SUB_SEQ_OIKAZE,				//
	SUB_SEQ_INFIGHT,			//Ct@Cg
	SUB_SEQ_POWER_TRICK,		//p[gbN
	SUB_SEQ_IEKI,				//
	SUB_SEQ_OMAZINAI,			//܂Ȃ
	SUB_SEQ_POWER_SWAP,			//p[Xbv
	SUB_SEQ_GUARD_SWAP,			//K[hXbv
	SUB_SEQ_NAYAMINOTANE,		//Ȃ݂̂
	SUB_SEQ_HEART_SWAP,			//n[gXbv
	SUB_SEQ_HEAT_ATTACK,		//q[gA^bN
	SUB_SEQ_KIRIHARAI,			//͂炢
	SUB_SEQ_HEALBLOCK,			//q[ubN
	SUB_SEQ_TONBOGAERI,			//Ƃڂ
	SUB_SEQ_SHUTOUT,			//VbgAEg
	SUB_SEQ_TSUIBAMU,			//΂
	SUB_SEQ_NAGETSUKERU,		//Ȃ
	SUB_SEQ_VOLT,				//{ebJ[
	SUB_SEQ_HANEKAERI3,			//͂˂n̋Z(1/2)
	SUB_SEQ_YAKEDO_HIRUMU,		//₯ǁ{Ђނ̒ǉ
	SUB_SEQ_KOORI_HIRUMU,		//{Ђނ̒ǉ
	SUB_SEQ_MAHI_HIRUMU,		//܂Ё{Ђނ̒ǉ
	SUB_SEQ_OSYABERI,			//ׂ̒ǉ
	SUB_SEQ_MIKADUKINOMAI,		//݂Â̂܂ǉ
	SUB_SEQ_SURIKOMI,			//肱ݒǉ
};

//============================================================================================
/**
 *	ǉʂ邽߂̃p[^Zbg
 *
 * @param[in]	sp		T[op[^̍\̃|C^
 * @param[in]	type	ǉʂ̃^Cv
 * @param[in]	flag	ǉʂ̎
 *
 * @retval	ǉʓV[PXio[
 */
//============================================================================================
static	int		ST_ServerAddStatusParamSet(SERVER_PARAM *sp,int type,u32 flag)
{
	sp->tsuika_type=type;
	sp->tsuika_para=flag&ADD_STATUS_MASK;
	sp->tsuika_flag=flag&(ADD_STATUS_MASK^0xffffffff);

	if(flag&ADD_STATUS_ATTACK){
		sp->tsuika_client=sp->attack_client;
	}
	else if(flag&ADD_STATUS_DEFENCE){
		sp->tsuika_client=sp->defence_client;
	}
	else if((flag&ADD_STATUS_WAZAKOUKA)||(flag&ADD_STATUS_WAZAKOUKA_NOHIT)){
		sp->tsuika_client=0;
	}
	else{
		OS_TPrintf("ST_ServerAddStausParamSet:ɂ̂͂->%08x\n",flag);
	}

	GF_ASSERT_MSG(NELEMS(AddStatusSeqNoTable)>(flag&ADD_STATUS_MASK),"݂ȂSUB_SEQ_NOł");

	return AddStatusSeqNoTable[flag&ADD_STATUS_MASK];
}

//============================================================================================
/**
 *	|PƋZ̃^Cv̑ŃtOZbg
 *
 * @param[in]	client_no	ZJoClientNo
 * @param[in]	power		З
 * @param[in]	damage		~ςĂ_[W
 * @param[in]	waza_damage	Z̈З
 * @param[out]	flag		tOZbg郏[N
 */
//============================================================================================
static	int	ST_TypeCheckCalc(SERVER_PARAM *sp,int client_no,int power,int damage,int waza_damage,u32 *flag)
{
	//^Cvɂ␳vZ
	if(((sp->server_status_flag&SERVER_STATUS_FLAG_TYPE_FLAT)==0)&&
	   ((sp->server_status_flag&SERVER_STATUS_FLAG_TYPE_NONE)==0)&&
		(damage)){
		damage=ST_ServerDamageDiv(damage*power,10);
	}
	switch(power){
	case KOUKANAI:
		flag[0]|=WAZA_STATUS_FLAG_KOUKANAI;
		flag[0]&=WAZA_STATUS_FLAG_IMAHITOTSU_OFF;
		flag[0]&=WAZA_STATUS_FLAG_BATSUGUN_OFF;
		break;
	case IMAHITOTSU:
//		if(((waza_damage)&&(flag[0]&WAZA_STATUS_FLAG_HAZURE)==0)){
		if(waza_damage){
			if(flag[0]&WAZA_STATUS_FLAG_BATSUGUN){
				flag[0]&=WAZA_STATUS_FLAG_BATSUGUN_OFF;
			}
			else{
				flag[0]|=WAZA_STATUS_FLAG_IMAHITOTSU;
			}
		}
		break;
	case BATSUGUN:
//		if((waza_damage)&&((flag[0]&WAZA_STATUS_FLAG_HAZURE)==0)){
		if(waza_damage){
			if(flag[0]&WAZA_STATUS_FLAG_IMAHITOTSU){
				flag[0]&=WAZA_STATUS_FLAG_IMAHITOTSU_OFF;
			}
			else{
				flag[0]|=WAZA_STATUS_FLAG_BATSUGUN;
			}
		}
		break;
	}

	return damage;
}

//============================================================================================
/**
 *	ߋZ^[Ȃ̂`FbNiߋZȊO͋Iɔj
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	TRUEF@FALSE:߂^[
 */
//============================================================================================
static BOOL	ST_TameWazaTurnCheck(SERVER_PARAM *sp,int waza_no)
{
	switch(sp->AIWT.wtd[waza_no].battleeffect){
	case 26:	//܂
	case 39:	//܂
	case 75:	//Sbho[h
	case 145:	//Pbg˂
	case 151:	//\[[r[
	case 155:	//Ƃ
	case 255:	//_CrO
	case 256:	//Ȃق
	case 263:	//Ƃт͂˂
	case 273:	//Vh[_Cu
		return (sp->server_status_flag&SERVER_STATUS_FLAG_TAME_AFTER);
		break;
	}

	return TRUE;
}

//============================================================================================
/**
 *	|Pio[Ɠ`FbNĎ擾ׂ^CvԂ
 *
 * @param[in]	sp		T[o[N\
 * @param[in]	client	擾ClientNo
 * @param[in]	id		擾^CviID_PSP_type1 or ID_PSP_type2j
 *
 * @retval	TRUEF@FALSE:߂^[
 */
//============================================================================================
static	u8	 ST_ServerTypeGet(SERVER_PARAM *sp,int client,int id)
{
	u8	type;

	if(id==ID_PSP_type1){
		type=sp->psp[client].type1;
	}
	else if(id==ID_PSP_type2){
		type=sp->psp[client].type2;
	}
	else{
		GF_ASSERT(0);
	}
	
	//AEX}`^CvĂƂ́Aɂă^Cvς
	if((sp->psp[client].monsno==MONSNO_AUSU)&&
	   (sp->psp[client].speabino==TOKUSYU_MARUTITAIPU)){
//		switch(ItemParamGet(sp->psp[client].item,ITEM_PRM_EQUIP,HEAPID_BATTLE)){
		switch(ST_ItemParamGet(sp,sp->psp[client].item,ITEM_PRM_EQUIP)){
		case SOUBI_AUSUHONOOUP:
			type=FIRE_TYPE;
			break;
		case SOUBI_AUSUMIZUUP:
			type=WATER_TYPE;
			break;
		case SOUBI_AUSUDENKIUP:
			type=ELECTRIC_TYPE;
			break;
		case SOUBI_AUSUKUSAUP:
			type=KUSA_TYPE;
			break;
		case SOUBI_AUSUKOORIUP:
			type=KOORI_TYPE;
			break;
		case SOUBI_AUSUKAKUTOUUP:
			type=BATTLE_TYPE;
			break;
		case SOUBI_AUSUDOKUBARIUP:
			type=POISON_TYPE;
			break;
		case SOUBI_AUSUZIMENUP:
			type=JIMEN_TYPE;
			break;
		case SOUBI_AUSUTORIUP:
			type=HIKOU_TYPE;
			break;
		case SOUBI_AUSUESUPAAUP:
			type=SP_TYPE;
			break;
		case SOUBI_AUSUMUSIIRYOKUUP:
			type=MUSHI_TYPE;
			break;
		case SOUBI_AUSUIWAUP:
			type=IWA_TYPE;
			break;
		case SOUBI_AUSUGOOSUTOUP:	
			type=GHOST_TYPE;
			break;
		case SOUBI_AUSUDORAGONUP:	
			type=DRAGON_TYPE;
			break;
		case SOUBI_AUSUAKUUP:	
			type=AKU_TYPE;
			break;
		case SOUBI_AUSUHAGANEIRYOKUUP:	
			type=METAL_TYPE;
			break;
		default:
			type=NORMAL_TYPE;
			break;
		}
	}

	return type;
}

//============================================================================================
/**
 *	Zio[XgbNp[N̏
 *
 * @param[in]	sp			T[opp[^[N\
 * @param[in]	client_no	NAClientNo
 */
//============================================================================================
static	void	WazaNoStockClear(SERVER_PARAM *sp,u8 client_no)
{
	int	i;

	for(i=0;i<WAZA_TEMOTI_MAX;i++){
		sp->AIWT.AI_DEFENCE_USE_WAZA[client_no][i]=0;
	}
}

//=========================================================================
/**
 *	AIp[NNA
 *
 * @param[in]	sp			T[oVXe\
 * @param[in]	client_no	NAClientNo
 */
//=========================================================================
static	void	TokusyuNoClear(SERVER_PARAM *sp,u8 client_no)
{
	sp->AIWT.AI_TOKUSYUNO[client_no]=0;
}

//=========================================================================
/**
 *	AIpACe[NNA
 *
 * @param[in]	sp			T[oVXe\
 * @param[in]	client_no	NAClientNo
 */
//=========================================================================
static	void	SoubiItemClear(SERVER_PARAM *sp,u8 client_no)
{
	sp->AIWT.AI_SOUBIITEM[client_no]=0;
}

//=========================================================================
/**
 *	g[Xł`FbNĔł邩Ԃ
 *
 * @param[in]	sp		T[oVXe\
 * @param[in]	def1	`FbNΏClientNo
 * @param[in]	def2	`FbNΏClientNo
 *
 * @retval	ΏClientNo
 */
//=========================================================================
static	int	ST_ServerTraceClientNoGet(SERVER_PARAM *sp,int def1,int def2)
{
	int	ret=NONE_CLIENT_NO;

	if((sp->psp[def1].speabino!=TOKUSYU_TENKIYA)&&
	   (sp->psp[def1].speabino!=TOKUSYU_TOREESU)&&
	   (sp->psp[def1].speabino!=TOKUSYU_MARUTITAIPU)&&
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/04/21
// 肪1̂̃_uogŃg[XȂƂ̂C
#if AFTER_MASTER_070409_42_EUR_FIX
	   (sp->psp[def1].hp)&&
	   (sp->psp[def2].hp)&&
#endif //AFTER_MASTER_070409_42_EUR_FIX
// ----------------------------------------------------------------------------
	   (sp->psp[def2].speabino!=TOKUSYU_TENKIYA)&&
	   (sp->psp[def2].speabino!=TOKUSYU_TOREESU)&&
	   (sp->psp[def2].speabino!=TOKUSYU_MARUTITAIPU)){
		if(gf_rand()&1){
			ret=def2;
		}
		else{
			ret=def1;
		}
	}
	else if((sp->psp[def1].speabino!=TOKUSYU_TENKIYA)&&
	 	    (sp->psp[def1].speabino!=TOKUSYU_TOREESU)&&
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/04/21
// 肪1̂̃_uogŃg[XȂƂ̂C
#if AFTER_MASTER_070409_42_EUR_FIX
		    (sp->psp[def1].hp)&&
#endif //AFTER_MASTER_070409_42_EUR_FIX
// ----------------------------------------------------------------------------
	 	    (sp->psp[def1].speabino!=TOKUSYU_MARUTITAIPU)){
		ret=def1;
	}
	else if((sp->psp[def2].speabino!=TOKUSYU_TENKIYA)&&
	 	    (sp->psp[def2].speabino!=TOKUSYU_TOREESU)&&
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/04/21
// 肪1̂̃_uogŃg[XȂƂ̂C
#if AFTER_MASTER_070409_42_EUR_FIX
		    (sp->psp[def2].hp)&&
#endif //AFTER_MASTER_070409_42_EUR_FIX
// ----------------------------------------------------------------------------
	 	    (sp->psp[def2].speabino!=TOKUSYU_MARUTITAIPU)){
		ret=def2;
	}
	return ret;
}

//============================================================================================
/**
 *	悿ŏO퓬ʃio[e[u
 */
//============================================================================================
static	const	u16	KikenyochiNGWazaSeqTable[]={
	41,
	87,
	88,
	89,
	144,
	227,
};

//============================================================================================
/**
 *	悿ŏO퓬ʃio[𒲂ׂ
 *
 * @param[in]	sp			T[op[^̍\̃|C^
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	FALSE:OȂ TRUE:O
 */
//============================================================================================
static	BOOL	ST_ServerKikenyochiWazaSeqCheck(SERVER_PARAM *sp,int waza_no)
{
	int	i;

	for(i=0;i<NELEMS(KikenyochiNGWazaSeqTable);i++){
		if(KikenyochiNGWazaSeqTable[i]==sp->AIWT.wtd[waza_no].battleeffect){
			return TRUE;
		}
	}
	return FALSE;
}

#if B1366_060815_FIX
//============================================================================================
/**
 * ȋZ̃^Cv擾
 *
 * @param[in]	bw			퓬VXe[N\̂̃|C^
 * @param[in]	sp			T[oVXe[N\̂̃|C^
 * @param[in]	client_no	ZgpClientNo
 * @param[in]	waza_no		^Cv擾Zio[
 *
 * @retval	Z^Cv
 */
//============================================================================================
static	int		ST_AIWazaTypeGet(BATTLE_WORK *bw,SERVER_PARAM *sp,int client_no,int waza_no)
{
	int	type;

	switch(waza_no){
	case WAZANO_SIZENNOMEGUMI:
		type=ST_ServerShizennomegumiTypeGet(sp,client_no);
		break;
	case WAZANO_SABAKINOTUBUTE:
		switch(ST_ServerSoubiEqpGet(sp,client_no)){
		case SOUBI_AUSUKAKUTOUUP:
			type=BATTLE_TYPE;
			break;
		case SOUBI_AUSUTORIUP:
			type=HIKOU_TYPE;
			break;
		case SOUBI_AUSUDOKUBARIUP:
			type=POISON_TYPE;
			break;
		case SOUBI_AUSUZIMENUP:
			type=JIMEN_TYPE;
			break;
		case SOUBI_AUSUIWAUP:
			type=IWA_TYPE;
			break;
		case SOUBI_AUSUMUSIIRYOKUUP:
			type=MUSHI_TYPE;
			break;
		case SOUBI_AUSUGOOSUTOUP:
			type=GHOST_TYPE;
			break;
		case SOUBI_AUSUHAGANEIRYOKUUP:
			type=METAL_TYPE;
			break;
		case SOUBI_AUSUHONOOUP:
			type=FIRE_TYPE;
			break;
		case SOUBI_AUSUMIZUUP:
			type=WATER_TYPE;
			break;
		case SOUBI_AUSUKUSAUP:
			type=KUSA_TYPE;
			break;
		case SOUBI_AUSUDENKIUP:
			type=ELECTRIC_TYPE;
			break;
		case SOUBI_AUSUESUPAAUP:
			type=SP_TYPE;
			break;
		case SOUBI_AUSUKOORIUP:
			type=KOORI_TYPE;
			break;
		case SOUBI_AUSUDORAGONUP:
			type=DRAGON_TYPE;
			break;
		case SOUBI_AUSUAKUUP:
			type=AKU_TYPE;
			break;
		default:
			type=0;
			break;
		}
		break;
	case WAZANO_MEZAMERUPAWAA:
		type=	((sp->psp[client_no].hp_rnd&1)		>>0)|
				((sp->psp[client_no].pow_rnd&1)		<<1)|
				((sp->psp[client_no].def_rnd&1)		<<2)|
				((sp->psp[client_no].agi_rnd&1)		<<3)|
				((sp->psp[client_no].spepow_rnd&1)	<<4)|
				((sp->psp[client_no].spedef_rnd&1)	<<5);

		type=(type*15/63)+1;

		if(type>=HATE_TYPE){
			type++;
		}
		break;
	case WAZANO_WHEZAABOORU:
		if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
		   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
			if(sp->field_condition&FIELD_CONDITION_TENKI){
				if(sp->field_condition&FIELD_CONDITION_AME_ALL){
					type=WATER_TYPE;
				}
				if(sp->field_condition&FIELD_CONDITION_SUNAARASHI_ALL){
					type=IWA_TYPE;
				}
				if(sp->field_condition&FIELD_CONDITION_HARE_ALL){
					type=FIRE_TYPE;
				}
				if(sp->field_condition&FIELD_CONDITION_ARARE_ALL){
					type=KOORI_TYPE;
				}
			}
		}
		break;
	default:
		type=0;
		break;
	}

	return type;
}
#endif //B1366_060815_FIX

