//==============================================================================
/**
 * @file	wazatype_icon.c
 * @brief	Z^CvރACR
 * @author	matsuda
 * @date	2005.10.26()
 */
//==============================================================================
#include "common.h"
#include "system/clact_tool.h"
#include "system/arc_tool.h"
#include "system\arc_util.h"
#include "battle\graphic\batt_obj_def.h"
#include "battle/battle_common.h"
#include "battle/wazatype_icon.h"


//==============================================================================
//	f[^
//==============================================================================
//--------------------------------------------------------------
//	Z^Cv
//--------------------------------------------------------------
///Z^CvCGRID
ALIGN4 static const u32 WazaTypeCgrNo[] = {
	P_ST_TYPE_NORMAL_NCGR_BIN,
	P_ST_TYPE_FIGHT_NCGR_BIN,
	P_ST_TYPE_FLIGHT_NCGR_BIN,
	P_ST_TYPE_POISON_NCGR_BIN,
	P_ST_TYPE_GROUND_NCGR_BIN,
	P_ST_TYPE_ROCK_NCGR_BIN,
	P_ST_TYPE_INSECT_NCGR_BIN,
	P_ST_TYPE_GHOST_NCGR_BIN,
	P_ST_TYPE_STEEL_NCGR_BIN,
	P_ST_TYPE_QUES_NCGR_BIN,
	P_ST_TYPE_FIRE_NCGR_BIN,
	P_ST_TYPE_WATER_NCGR_BIN,
	P_ST_TYPE_GRASS_NCGR_BIN,
	P_ST_TYPE_ELE_NCGR_BIN,
	P_ST_TYPE_ESP_NCGR_BIN,
	P_ST_TYPE_ICE_NCGR_BIN,
	P_ST_TYPE_DRAGON_NCGR_BIN,
	P_ST_TYPE_EVIL_NCGR_BIN,
	P_ST_TYPE_STYLE_NCGR_BIN,
	P_ST_TYPE_BEAUTIFUL_NCGR_BIN,
	P_ST_TYPE_CUTE_NCGR_BIN,
	P_ST_TYPE_INTELLI_NCGR_BIN,
	P_ST_TYPE_STRONG_NCGR_BIN,
};

///Z^CṽpbgItZbgԍ
ALIGN4 static const u8 WazaTypePlttOffset[] = {
	0,	//NORMAL_TYPE
	0,	//BATTLE_TYPE
	1,	//HIKOU_TYPE
	1,	//POISON_TYPE
	0,	//JIMEN_TYPE
	0,	//IWA_TYPE
	2,	//MUSHI_TYPE
	1,	//GHOST_TYPE
	0,	//METAL_TYPE
	2,	//HATE_TYPE
	0,	//FIRE_TYPE
	1,	//WATER_TYPE
	2,	//KUSA_TYPE
	0,	//ELECTRIC_TYPE
	1,	//SP_TYPE
	1,	//KOORI_TYPE
	2,	//DRAGON_TYPE
	0,	//AKU_TYPE
	0,	//ICONTYPE_STYLE
	1,	//ICONTYPE_BEAUTIFUL
	1,	//ICONTYPE_CUTE
	2,	//ICONTYPE_INTELLI
	0,	//ICONTYPE_STRONG
};

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ޖCGRID
ALIGN4 static const u32 WazaKindCgrNo[] = {
	P_ST_BUNRUI_BUTURI_NCGR_BIN,
	P_ST_BUNRUI_TOKUSYU_NCGR_BIN,
	P_ST_BUNRUI_HENKA_NCGR_BIN,
};

///ޖ̃pbgItZbgԍ
ALIGN4 static const u8 WazaKindPlttOffset[] = {
	0,		//KIND_BUTSURI
	1,		//KIND_TOKUSYU
	0,		//KIND_HENNKA
};



//==============================================================================
//
//	Z^CvACR
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   wZ^CvCGRID擾܂
 * @param   waza_type		Z^Cv(NORMAL_TYPE, FIRE_TYPE..A ICONTYPE_???)
 * @retval  CGRID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 WazaTypeIcon_CgrIDGet(int waza_type)
{
	GF_ASSERT(waza_type < NELEMS(WazaTypeCgrNo));
	return WazaTypeCgrNo[waza_type];
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvACR̃pbgID擾܂
 * @retval  pbgID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 WazaTypeIcon_PlttIDGet(void)
{
	return ST_TYPE_NCLR;
}

//--------------------------------------------------------------
/**
 * @brief   wZ^CṽZID擾܂
 * @retval  ZID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 WazaTypeIcon_CellIDGet(void)
{
	return P_ST_TYPE_NORMAL_NCER_BIN;
}

//--------------------------------------------------------------
/**
 * @brief   wZ^CṽZAjID擾܂
 * @retval  ZAjID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 WazaTypeIcon_CellAnmIDGet(void)
{
	return P_ST_TYPE_NORMAL_NANR_BIN;
}

//--------------------------------------------------------------
/**
 * @brief   wZ^CṽpbgԍItZbg擾܂
 * @param   waza_type		Z^Cv(NORMAL_TYPE, FIRE_TYPE..A ICONTYPE_???)
 * @retval  pbgԍ̃ItZbg
 */
//--------------------------------------------------------------
u8 WazaTypeIcon_PlttOffsetGet(int waza_type)
{
	GF_ASSERT(waza_type < NELEMS(WazaTypePlttOffset));
	return WazaTypePlttOffset[waza_type];
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvACR̃A[JCuINDEX擾܂
 * @retval  A[JCuINDEX
 */
//--------------------------------------------------------------
u32 WazaTypeIcon_ArcIDGet(void)
{
	return ARC_BATT_OBJ;
}




//--------------------------------------------------------------
/**
 * @brief   wZ^CṽL\[X[h܂
 *
 * @param   csp				cspւ̃|C^
 * @param   crp				crpւ̃|C^
 * @param   vram_type		NNS_G2D_VRAM_TYPE_2DMAIN
 * @param   waza_type		Z^Cv(NORMAL_TYPE, FIRE_TYPE..A ICONTYPE_???)
 * @param   char_id			o^LID
 */
//--------------------------------------------------------------
void WazaTypeIcon_CharResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, 
	NNS_G2D_VRAM_TYPE vram_type, int waza_type, u32 char_id)
{
	CATS_LoadResourceCharArc(csp, crp, WazaTypeIcon_ArcIDGet(), 
		WazaTypeIcon_CgrIDGet(waza_type), WAZATYPEICON_COMP_CHAR, vram_type, char_id);
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvACR̃pbg[h܂
 *
 * @param   csp			cspւ̃|C^
 * @param   crp			crpւ̃|C^
 * @param   vram_type	NNS_G2D_VRAM_TYPE_2DMAIN
 * @param   pltt_id		o^pbgID
 *
 * Z^CvACRŎgppbgSĂZbg܂B
 */
//--------------------------------------------------------------
void WazaTypeIcon_PlttResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, 
	NNS_G2D_VRAM_TYPE vram_type, u32 pltt_id)
{
	CATS_LoadResourcePlttArc(csp, crp, WazaTypeIcon_ArcIDGet(), WazaTypeIcon_PlttIDGet(), 
		WAZATYPEICON_COMP_PLTT, WTI_PLTT_NUM, vram_type, pltt_id);
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvACR̃pbgpbg[Nփ[h܂
 *
 * @param   PALETTE_FADE_PTR		pbgtF[hVXeւ̃|C^
 * @param   req						NGXgf[^ԍ(FADE_MAIN_BG)
 * @param   csp			cspւ̃|C^
 * @param   crp			crpւ̃|C^
 * @param   vram_type	NNS_G2D_VRAM_TYPE_2DMAIN
 * @param   pltt_id		o^pbgID
 *
 * Z^CvACRŎgppbgSĂZbg܂B
 */
//--------------------------------------------------------------
void WazaTypeIcon_PlttWorkResourceLoad(PALETTE_FADE_PTR pfd, FADEREQ req, CATS_SYS_PTR csp, 
	CATS_RES_PTR crp, NNS_G2D_VRAM_TYPE vram_type, u32 pltt_id)
{
	CATS_LoadResourcePlttWorkArc(pfd, req, csp, crp, 
		WazaTypeIcon_ArcIDGet(), WazaTypeIcon_PlttIDGet(), WAZATYPEICON_COMP_PLTT, 
		WTI_PLTT_NUM, vram_type, pltt_id);
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvACR̃ZƃAj[h܂
 *
 * @param   csp			cspւ̃|C^
 * @param   crp			crpւ̃|C^
 * @param   cell_id		o^ZID
 * @param   anm_id		o^AjID
 *
 * Z^CvACRʂ̃ZƃAj[h܂B
 * Z^CvACR͑SăZƃAjʂȂ̂ŁA1o^ĂOKłB
 * (̃ACR𐶐鎞łASĂœo^ZAAjIDw肷悤ɂ܂)
 */
//--------------------------------------------------------------
void WazaTypeIcon_CellAnmResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, u32 cell_id, u32 anm_id)
{
	CATS_LoadResourceCellArc(csp, crp, WazaTypeIcon_ArcIDGet(), WazaTypeIcon_CellIDGet(), 
		WAZATYPEICON_COMP_CELL, cell_id);
	CATS_LoadResourceCellAnmArc(csp, crp, WazaTypeIcon_ArcIDGet(), WazaTypeIcon_CellAnmIDGet(), 
		WAZATYPEICON_COMP_CELLANM, anm_id);
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvACR̃L\[X܂
 * @param   crp			crpւ̃|C^
 * @param   char_id		LID
 */
//--------------------------------------------------------------
void WazaTypeIcon_CharResourceFree(CATS_RES_PTR crp, u32 char_id)
{
	CATS_FreeResourceChar(crp, char_id);
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvACR̃pbg\[X܂
 * @param   crp			crpւ̃|C^
 * @param   pltt_id		pbgID
 */
//--------------------------------------------------------------
void WazaTypeIcon_PlttResourceFree(CATS_RES_PTR crp, u32 pltt_id)
{
	CATS_FreeResourcePltt(crp, pltt_id);
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvACR̃ZAAj\[X܂
 * @param   crp			crpւ̃|C^
 * @param   char_id		ZID
 * @param   char_id		AjID
 */
//--------------------------------------------------------------
void WazaTypeIcon_CellAnmResourceFree(CATS_RES_PTR crp, u32 cell_id, u32 anm_id)
{
	CATS_FreeResourceCell(crp, cell_id);
	CATS_FreeResourceCellAnm(crp, anm_id);
}


//--------------------------------------------------------------
/**
 * @brief   Z^CvACRAN^[𐶐
 *
 * @param   csp				cspւ̃|C^
 * @param   crp				crpւ̃|C^
 * @param   waza_type		Z^Cv(NORMAL_TYPE, FIRE_TYPE..A ICONTYPE_???)
 * @param   obj_data		AN^[wb_ւ̃|C^
 *
 * @retval  AN^[̃|C^
 */
//--------------------------------------------------------------
CATS_ACT_PTR WazaTypeIcon_ActorCreate(CATS_SYS_PTR csp, CATS_RES_PTR crp, int waza_type, 
	const TCATS_OBJECT_ADD_PARAM_S *obj_data)
{
	CATS_ACT_PTR cap;
	TCATS_OBJECT_ADD_PARAM_S obj_param;
	
	obj_param = *obj_data;
	obj_param.pal = WazaTypeIcon_PlttOffsetGet(waza_type);
	
	cap = CATS_ObjectAdd_S(csp, crp, &obj_param);
	return cap;
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvACRAN^[폜
 * @param   cap		AN^[|C^
 */
//--------------------------------------------------------------
void WazaTypeIcon_ActorDelete(CATS_ACT_PTR cap)
{
	CATS_ActorPointerDelete_S(cap);
}










//==============================================================================
//
//	ރACR
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   wZނCGRID擾܂
 * @param   waza_kind		Z(KIND_BUTURI or KIND_TOKUSYU or KIND_HENNKA)
 * @retval  CGRID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 WazaKindIcon_CgrIDGet(int waza_kind)
{
	GF_ASSERT(waza_kind < NELEMS(WazaKindCgrNo));
	return WazaKindCgrNo[waza_kind];
}

//--------------------------------------------------------------
/**
 * @brief   ZރACR̃pbgID擾܂
 * @retval  pbgID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 WazaKindIcon_PlttIDGet(void)
{
	return ST_TYPE_NCLR;
}

//--------------------------------------------------------------
/**
 * @brief   wZނ̃ZID擾܂
 * @retval  ZID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 WazaKindIcon_CellIDGet(void)
{
	return P_ST_TYPE_NORMAL_NCER_BIN;
}

//--------------------------------------------------------------
/**
 * @brief   wZނ̃ZAjID擾܂
 * @retval  ZAjID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 WazaKindIcon_CellAnmIDGet(void)
{
	return P_ST_TYPE_NORMAL_NANR_BIN;
}

//--------------------------------------------------------------
/**
 * @brief   wZނ̃pbgԍItZbg擾܂
 * @param   waza_kind		Z(KIND_BUTURI or KIND_TOKUSYU or KIND_HENNKA)
 * @retval  pbgԍ̃ItZbg
 */
//--------------------------------------------------------------
u8 WazaKindIcon_PlttOffsetGet(int waza_kind)
{
	GF_ASSERT(waza_kind < NELEMS(WazaKindPlttOffset));
	return WazaKindPlttOffset[waza_kind];
}

//--------------------------------------------------------------
/**
 * @brief   ZރACR̃A[JCuINDEX擾܂
 * @retval  A[JCuINDEX
 */
//--------------------------------------------------------------
u32 WazaKindIcon_ArcIDGet(void)
{
	return ARC_BATT_OBJ;
}




//--------------------------------------------------------------
/**
 * @brief   wZނ̃L\[X[h܂
 *
 * @param   csp				cspւ̃|C^
 * @param   crp				crpւ̃|C^
 * @param   vram_type		NNS_G2D_VRAM_TYPE_2DMAIN
 * @param   waza_kind		Z(KIND_BUTURI or KIND_TOKUSYU or KIND_HENNKA)
 * @param   char_id			o^LID
 */
//--------------------------------------------------------------
void WazaKindIcon_CharResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, 
	NNS_G2D_VRAM_TYPE vram_type, int waza_kind, u32 char_id)
{
	CATS_LoadResourceCharArc(csp, crp, WazaKindIcon_ArcIDGet(), 
		WazaKindIcon_CgrIDGet(waza_kind), WAZAKINDICON_COMP_CHAR, vram_type, char_id);
}

//--------------------------------------------------------------
/**
 * @brief   ZރACR̃pbg[h܂
 *
 * @param   csp			cspւ̃|C^
 * @param   crp			crpւ̃|C^
 * @param   vram_type	NNS_G2D_VRAM_TYPE_2DMAIN
 * @param   pltt_id		o^pbgID
 *
 * ZރACRŎgppbgSĂZbg܂B
 */
//--------------------------------------------------------------
void WazaKindIcon_PlttResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, 
	NNS_G2D_VRAM_TYPE vram_type, u32 pltt_id)
{
	CATS_LoadResourcePlttArc(csp, crp, WazaKindIcon_ArcIDGet(), WazaKindIcon_PlttIDGet(), 
		WAZAKINDICON_COMP_PLTT, WKI_PLTT_NUM, vram_type, pltt_id);
}

//--------------------------------------------------------------
/**
 * @brief   ZރACR̃pbgpbg[Nփ[h܂
 *
 * @param   PALETTE_FADE_PTR		pbgtF[hVXeւ̃|C^
 * @param   req						NGXgf[^ԍ(FADE_MAIN_BG)
 * @param   csp			cspւ̃|C^
 * @param   crp			crpւ̃|C^
 * @param   vram_type	NNS_G2D_VRAM_TYPE_2DMAIN
 * @param   pltt_id		o^pbgID
 *
 * ZރACRŎgppbgSĂZbg܂B
 */
//--------------------------------------------------------------
void WazaKindIcon_PlttWorkResourceLoad(PALETTE_FADE_PTR pfd, FADEREQ req, CATS_SYS_PTR csp, 
	CATS_RES_PTR crp, NNS_G2D_VRAM_TYPE vram_type, u32 pltt_id)
{
	CATS_LoadResourcePlttWorkArc(pfd, req, csp, crp, 
		WazaKindIcon_ArcIDGet(), WazaKindIcon_PlttIDGet(), WAZAKINDICON_COMP_PLTT, 
		WKI_PLTT_NUM, vram_type, pltt_id);
}

//--------------------------------------------------------------
/**
 * @brief   ZރACR̃ZƃAj[h܂
 *
 * @param   csp			cspւ̃|C^
 * @param   crp			crpւ̃|C^
 * @param   cell_id		o^ZID
 * @param   anm_id		o^AjID
 *
 * ZރACRʂ̃ZƃAj[h܂B
 * ZރACR͑SăZƃAjʂȂ̂ŁA1o^ĂOKłB
 * (̃ACR𐶐鎞łASĂœo^ZAAjIDw肷悤ɂ܂)
 */
//--------------------------------------------------------------
void WazaKindIcon_CellAnmResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, u32 cell_id, u32 anm_id)
{
	CATS_LoadResourceCellArc(csp, crp, WazaKindIcon_ArcIDGet(), WazaKindIcon_CellIDGet(), 
		WAZAKINDICON_COMP_CELL, cell_id);
	CATS_LoadResourceCellAnmArc(csp, crp, WazaKindIcon_ArcIDGet(), WazaKindIcon_CellAnmIDGet(), 
		WAZAKINDICON_COMP_CELLANM, anm_id);
}

//--------------------------------------------------------------
/**
 * @brief   ZރACR̃L\[X܂
 * @param   crp			crpւ̃|C^
 * @param   char_id		LID
 */
//--------------------------------------------------------------
void WazaKindIcon_CharResourceFree(CATS_RES_PTR crp, u32 char_id)
{
	CATS_FreeResourceChar(crp, char_id);
}

//--------------------------------------------------------------
/**
 * @brief   ZރACR̃pbg\[X܂
 * @param   crp			crpւ̃|C^
 * @param   pltt_id		pbgID
 */
//--------------------------------------------------------------
void WazaKindIcon_PlttResourceFree(CATS_RES_PTR crp, u32 pltt_id)
{
	CATS_FreeResourcePltt(crp, pltt_id);
}

//--------------------------------------------------------------
/**
 * @brief   ZރACR̃ZAAj\[X܂
 * @param   crp			crpւ̃|C^
 * @param   char_id		ZID
 * @param   char_id		AjID
 */
//--------------------------------------------------------------
void WazaKindIcon_CellAnmResourceFree(CATS_RES_PTR crp, u32 cell_id, u32 anm_id)
{
	CATS_FreeResourceCell(crp, cell_id);
	CATS_FreeResourceCellAnm(crp, anm_id);
}


//--------------------------------------------------------------
/**
 * @brief   ZރACRAN^[𐶐
 *
 * @param   csp				cspւ̃|C^
 * @param   crp				crpւ̃|C^
 * @param   waza_kind		Z(KIND_BUTURI or KIND_TOKUSYU or KIND_HENNKA)
 * @param   obj_data		AN^[wb_ւ̃|C^
 *
 * @retval  AN^[̃|C^
 */
//--------------------------------------------------------------
CATS_ACT_PTR WazaKindIcon_ActorCreate(CATS_SYS_PTR csp, CATS_RES_PTR crp, int waza_kind, 
	const TCATS_OBJECT_ADD_PARAM_S *obj_data)
{
	CATS_ACT_PTR cap;
	TCATS_OBJECT_ADD_PARAM_S obj_param;
	
	obj_param = *obj_data;
	obj_param.pal = WazaKindIcon_PlttOffsetGet(waza_kind);
	
	cap = CATS_ObjectAdd_S(csp, crp, &obj_param);
	return cap;
}

//--------------------------------------------------------------
/**
 * @brief   ZރACRAN^[폜
 * @param   cap		AN^[|C^
 */
//--------------------------------------------------------------
void WazaKindIcon_ActorDelete(CATS_ACT_PTR cap)
{
	CATS_ActorPointerDelete_S(cap);
}

