//==============================================================================
/**
 * @file	wazatype_panel.c
 * @brief	Z^Cṽplf[^̎oȂ
 * @author	matsuda
 * @date	2005.12.02()
 */
//==============================================================================
#include "common.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/palanm.h"
#include "battle/wazatype_panel.h"
#include "graphic\batt_bg_def.h"

//==============================================================================
//	萔`
//==============================================================================
///Z^CvCGRf[^Xɂ邩
#define WAZATYPE_CGR_X_LEN	(18)
///Z^CvCGRf[^ɓĂAj
#define WAZATYPE_CGR_ANM_NUM	(3)
///Z^CvCGRf[^1̃AjXTCY
#define WAZATYPE_CGR_X_ONE	(WAZATYPE_CGR_X_LEN / WAZATYPE_CGR_ANM_NUM)
///Z^CvCGRf[^iɓnăf[^݂Ă邩
#define WAZATYPE_CGR_Y_LEN	(9)


//==============================================================================
//	pbgf[^
//==============================================================================
//̂ߑff[^ŎĂ܂ipbg炽ėeʂȂj
#include "graphic/battle_w_type12_ncl_txt.dat"
#include "graphic/battle_w_type04_ncl_txt.dat"
#include "graphic/battle_w_type14_ncl_txt.dat"
#include "graphic/battle_w_type10_ncl_txt.dat"
#include "graphic/battle_w_type08_ncl_txt.dat"
#include "graphic/battle_w_type02_ncl_txt.dat"
#include "graphic/battle_w_type17_ncl_txt.dat"
#include "graphic/battle_w_type06_ncl_txt.dat"
#include "graphic/battle_w_type13_ncl_txt.dat"
#include "graphic/battle_w_type18_ncl_txt.dat"
#include "graphic/battle_w_type15_ncl_txt.dat"
#include "graphic/battle_w_type16_ncl_txt.dat"
#include "graphic/battle_w_type05_ncl_txt.dat"
#include "graphic/battle_w_type09_ncl_txt.dat"
#include "graphic/battle_w_type03_ncl_txt.dat"
#include "graphic/battle_w_type07_ncl_txt.dat"
#include "graphic/battle_w_type11_ncl_txt.dat"
#include "graphic/battle_w_type01_ncl_txt.dat"
#include "graphic/battle_w_type00_ncl_txt.dat"


//==============================================================================
//	f[^
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   Z^CvCGRf[^
 */
//--------------------------------------------------------------
ALIGN4 static const u16 WazaTypeCgrID[] = {
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
	BATTLE_W_TYPE01_NCGR_BIN,
};

//--------------------------------------------------------------
/**
 * @brief   Z^Cṽpbgf[^
 */
//--------------------------------------------------------------
ALIGN4 static const u16 * const WazaTypePlttAdrs[] = {
	battle_w_type12_ncl,
	battle_w_type04_ncl,
	battle_w_type14_ncl,
	battle_w_type10_ncl,
	battle_w_type08_ncl,
	battle_w_type02_ncl,
	battle_w_type17_ncl,
	battle_w_type06_ncl,
	battle_w_type13_ncl,
	battle_w_type18_ncl,
	battle_w_type15_ncl,
	battle_w_type16_ncl,
	battle_w_type05_ncl,
	battle_w_type09_ncl,
	battle_w_type03_ncl,
	battle_w_type07_ncl,
	battle_w_type11_ncl,
	battle_w_type01_ncl,
};




//--------------------------------------------------------------
/**
 * @brief   Zpl̃OtBbNĂArcID擾
 * @retval  ARC_ID
 */
//--------------------------------------------------------------
int WazaPanel_ArcIDGet(void)
{
	return ARC_BATT_BG;
}

//--------------------------------------------------------------
/**
 * @brief   Zpl̃LN^INDEX擾
 * @param   waza_type		Z^Cv(莝̏ꍇ-1)
 * @retval  w肵Z^CṽLN^INDEX
 */
//--------------------------------------------------------------
u32 WazaPanel_CharIndexGet(int waza_type)
{
	u32 char_index;
	
	if(waza_type != -1){
		char_index = WazaTypeCgrID[waza_type];
	}
	else{
		char_index = BATTLE_W_TYPE00_NCGR_BIN;
	}
	return char_index;
}

//--------------------------------------------------------------
/**
 * @brief   Zpl̃pbgf[^AhX擾
 * @param   waza_type		Z^Cv(莝̏ꍇ-1)
 * @retval  w肵Z^Cṽpbgf[^AhX
 */
//--------------------------------------------------------------
const u16 * WazaPanel_PalDataAdrsGet(int waza_type)
{
	const u16 *pal_data;
	
	if(waza_type != -1){
		pal_data = WazaTypePlttAdrs[waza_type];
	}
	else{
		pal_data = battle_w_type00_ncl;
	}
	return pal_data;
}

//--------------------------------------------------------------
/**
 * @brief   Z^Cvpl̃OtBbN[h
 *
 * @param   bgl				BGLւ̃|C^
 * @param   heap_id			e|Ŏgpq[vID
 * @param   frame_no		[h̃t[
 * @param   trans_pos		[h̓]ʒu(`̍̃LN^ԍ)
 * @param   screen_type		GF_BGL_SCRSIZ_256x256 
 * @param   charcter		WJς݂̃Lf[^ւ̃AhX
 *
 * ]͋Z^CvplƓ`̗̈悪`ŎĂ鎖OłB
 * trans_pos͂̃[hA`̍̃LN^ʒuw肵܂B
 */
//--------------------------------------------------------------
void WazaPanel_CharLoad(GF_BGL_INI *bgl, int heap_id, int frame_no, u32 trans_pos, 
	int screen_type, const u8 *charcter)
{
	u32 y_len;
	int y;
	
	switch(screen_type){
	case GF_BGL_SCRSIZ_256x256:
	case GF_BGL_SCRSIZ_256x512:
		y_len = 32;
		break;
	case GF_BGL_SCRSIZ_512x256:
	case GF_BGL_SCRSIZ_512x512:
		y_len = 64;
		break;
	default:
		GF_ASSERT(0 && "ΉĂȂXN[^Cvł\n");
		return;
	}
	
	//L]
	for(y = 0; y < WAZATYPE_CGR_Y_LEN; y++){
		GF_BGL_LoadCharacter(bgl, frame_no, 
			&charcter[WAZATYPE_CGR_X_LEN * 0x20 * y], 
			WAZATYPE_CGR_X_ONE * 0x20, trans_pos + (y_len*y));
	}
}

//--------------------------------------------------------------
/**
 * @brief   Z^Cvpl̃L]g₷悤ɂ܂Ƃ߂
 *
 * @param   bgl				BGLւ̃|C^
 * @param   waza_type		Z^Cv(莝̏ꍇ-1)
 * @param   heap_id		e|Ŏgpq[vID
 * @param   frame_no		[h̃t[
 * @param   trans_pos		[h̓]ʒu(`̍̃LN^ԍ)
 * @param   screen_type		GF_BGL_SCRSIZ_256x256 
 */
//--------------------------------------------------------------
void WazaPanel_EasyCharLoad(GF_BGL_INI *bgl, int waza_type, int heap_id, int frame_no, 
	u32 trans_pos, int screen_type)
{
	u32 arc_id, char_index;
	void *arc_data;
	NNSG2dCharacterData *char_data;
	
	arc_id = WazaPanel_ArcIDGet();
	char_index = WazaPanel_CharIndexGet(waza_type);

	arc_data = ArcUtil_CharDataGet(arc_id, char_index, 1, &char_data, heap_id);

	WazaPanel_CharLoad(bgl, heap_id, frame_no, trans_pos, screen_type, char_data->pRawData);

	sys_FreeMemoryEz(arc_data);
}

//--------------------------------------------------------------
/**
 * @brief   Z^Cvpl̃L]ŁAZ^CvCGRAăZbg܂B
 * 			(Z^CvWJꍇAWazaPanel_EasyCharLoadɔׂFileOpen
 *			xōςނ悤ɂȂ܂)
 *
 * @param   bgl				BGLւ̃|C^
 * @param   waza_type		Z^Cv(莝̏ꍇ-1)
 * @param   heap_id			e|Ŏgpq[vID
 * @param   frame_no		[h̃t[
 * @param   trans_pos		[h̓]ʒu(`̍̃LN^ԍ)(]Z)
 * @param   trans_num		trans_pos̔z̐
 * @param   screen_type		GF_BGL_SCRSIZ_256x256 
 */
//--------------------------------------------------------------
void WazaPanel_EasyCharLoad_ChainSet(GF_BGL_INI *bgl, int waza_type, int heap_id, int frame_no, 
	const u16 trans_pos[], int trans_num, int screen_type)
{
	u32 arc_id, char_index;
	void *arc_data;
	NNSG2dCharacterData *char_data;
	int i;
	
	arc_id = WazaPanel_ArcIDGet();
	char_index = WazaPanel_CharIndexGet(waza_type);

	arc_data = ArcUtil_CharDataGet(arc_id, char_index, 1, &char_data, heap_id);

	for(i = 0; i < trans_num; i++){
		WazaPanel_CharLoad(bgl, heap_id, frame_no, trans_pos[i], screen_type, char_data->pRawData);
	}

	sys_FreeMemoryEz(arc_data);
}

//--------------------------------------------------------------
/**
 * @brief   Z^Cvpl̃pbg]g₷悤ɂ܂Ƃ߂
 *
 * @param   pfd				pbgtF[hVXeւ̃|C^
 * @param   waza_type		Z^Cv(莝̏ꍇ-1)
 * @param   heap_id			e|Ŏgpq[vID
 * @param   req				NGXgf[^ԍ
 * @param   palette_pos		pbg]ʒu(pbgԍŎw)
 */
//--------------------------------------------------------------
void WazaPanel_EasyPalLoad(PALETTE_FADE_PTR pfd, int waza_type, int heap_id, 
	FADEREQ req, int palette_pos)
{
	const u16 *pal_data;
	
	pal_data = WazaPanel_PalDataAdrsGet(waza_type);
	PaletteWorkSet(pfd, pal_data, req, palette_pos * 16, 0x20);
}

