//=============================================================================
/**
 * @file	comm_info.c
 * @brief	ʐMœeJZbg̊{~ĂNX
 * @author	Katsumi Ohno
 * @date    2005.08.22
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "comm_local.h"

#include "system/gamedata.h"
#include "system/pm_str.h"

#include "communication/comm_info.h"
#include "system/savedata.h"
#include "savedata/randomgroup.h"
#include "savedata/undergrounddata.h"
#include "savedata/wifihistory.h"
#include "wifi/dwc_rapfriend.h"

//==============================================================================
// [N
//==============================================================================

enum _info_e {
    _INFO_EMPTY,      // 
    _INFO_NEW_ENTRY,  // MĉΉĂȂ[U[
    _INFO_ENTRY,      // t o[ɂȂ
    _INFO_ENTRY_MSGSENDED,      // bZ[WI
    _INFO_MAX
};


// MYSTATUSɂȂvf\
typedef struct{
    u8 myRegulation[COMM_SEND_REGULATION_SIZE]; //
    u8 myStatusBuff[COMM_SEND_MYSTATUS_SIZE];  	// ۂmystatus̑傫͎słȂƂ킩Ȃ̂ŏɐ؂Ă
    DWCFriendData friendData;   //ʐMœnp̃thR[h
    STRCODE groupName[PERSON_NAME_SIZE + EOM_SIZE];     //_O[v MYUSE
    u8 mac[WM_SIZE_BSSID];  ///mac
    u8 netID;     /// ID
    u8 my_nation;			///<̍
    u8 my_area;				///<̒n
    u8 myPenalty;
} PlayerInfo;


#define _RESULT_TYPE_WIN  (0)  //
#define _RESULT_TYPE_LOSE  (1) // 
#define _RESULT_TYPE_TRADE  (2) //

typedef struct{
    u16 win;
    u16 lose;
    u16 trade;
} PlayerResult;

typedef struct{
    const REGULATION* pReg;
    SAVEDATA* pSaveData;
    PlayerInfo sPlayerData[COMM_MACHINE_MAX];  // ʐMp info
    MYSTATUS* pMyStatus[COMM_MACHINE_MAX];     // myStatus
    PlayerResult sPlayerResult[COMM_MACHINE_MAX];
    u8 info[COMM_MACHINE_MAX];    /// 
    u8 _infoEnd;
    u8 bNewInfoData;
    u8 nowNetID;
} _COMM_INFO_WORK;

static _COMM_INFO_WORK* _pCommInfo;

#define _INVALID_POKEID (-1)  /// ȃ|PID
#define _ID_STR_LENGTH  (5)  /// IĎ

//--------------------------------------------------------------
/**
 * @brief   ʐMǗ̏
 * @param   pWork       Ŏgp郏[NGA
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoInitialize(SAVEDATA* pSaveData, const REGULATION* pReg)
{
    int i;
    MYSTATUS* pMyStatus = SaveData_GetMyStatus(pSaveData);

    if(_pCommInfo){
        return;
    }
    _pCommInfo = sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_COMM_INFO_WORK));
    MI_CpuClear8(_pCommInfo, sizeof(_COMM_INFO_WORK));
    for(i = 0; i < COMM_MACHINE_MAX ; i++){
        _pCommInfo->pMyStatus[i] = (MYSTATUS*)&_pCommInfo->sPlayerData[i].myStatusBuff[0]; //MyStatus_AllocWork(HEAPID_COMMUNICATION);
        CommInfoDeletePlayer( i );
    }
    _pCommInfo->_infoEnd = FALSE;
    _pCommInfo->bNewInfoData = FALSE;
    _pCommInfo->nowNetID = 0;
    _pCommInfo->pSaveData = pSaveData;
    _pCommInfo->pReg = pReg;

    // MYSTATUSRs[
    MyStatus_Copy( pMyStatus, _pCommInfo->pMyStatus[0]);
}

//--------------------------------------------------------------
/**
 * @brief   ʐMǗ̊J
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoFinalize(void)
{
    int i;

    if(_pCommInfo){
        for(i = 0; i < COMM_MACHINE_MAX ; i++){
            //            sys_FreeMemoryEz(_pCommInfo->pMyStatus[i]);
            _pCommInfo->pMyStatus[i] = NULL;
        }
        if(_pCommInfo){
            sys_FreeMemoryEz(_pCommInfo);
        }
        _pCommInfo = NULL;
    }
}

//--------------------------------------------------------------
/**
 * @brief   ł邩ǂԂ
 * @param   none
 * @retval  ̏ꍇTRUE
 */
//--------------------------------------------------------------

BOOL CommInfoIsInitialize(void)
{
    return (_pCommInfo != NULL);
}



//--------------------------------------------------------------
/**
 * @brief   ID,nameȂǂ𑗐M܂
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------


void CommInfoSendPokeData(void)
{
    u16 netID = CommGetCurrentID();
    MYSTATUS* pMyStatus;
    const STRCODE *pStr;
    RANDOM_GROUP* pRG = SaveData_GetRandomGroup(_pCommInfo->pSaveData);
    WIFI_LIST* pList = SaveData_GetWifiListData(_pCommInfo->pSaveData);
    WIFI_HISTORY* pHistry = SaveData_GetWifiHistory(_pCommInfo->pSaveData);

    pMyStatus = SaveData_GetMyStatus(_pCommInfo->pSaveData);
    MyStatus_Copy( pMyStatus, _pCommInfo->pMyStatus[netID]);
    OS_GetMacAddress(&_pCommInfo->sPlayerData[netID].mac[0]);

    pStr = RandomGroup_GetNamePtr( pRG, RANDOMGROUP_MYUSE, RANDOMGROUP_NAME_GROUP );

    OHNO_PRINT("Rs[TCY  %d \n",sizeof(_pCommInfo->sPlayerData[netID].groupName));
    MI_CpuCopy8(pStr,_pCommInfo->sPlayerData[netID].groupName,
                sizeof(_pCommInfo->sPlayerData[netID].groupName));

    _pCommInfo->sPlayerData[netID].my_nation = WIFIHISTORY_GetMyNation(pHistry);
    _pCommInfo->sPlayerData[netID].my_area = WIFIHISTORY_GetMyArea(pHistry);
    _pCommInfo->sPlayerData[netID].myPenalty = UnderGroundDataIsGoodsSend(_pCommInfo->pSaveData);
    _pCommInfo->sPlayerData[netID].myPenalty = 1 - _pCommInfo->sPlayerData[netID].myPenalty;
    
    DWC_CreateExchangeToken(WifiList_GetMyUserInfo(pList), &_pCommInfo->sPlayerData[netID].friendData);

    MI_CpuClear8(_pCommInfo->sPlayerData[netID].myRegulation, COMM_SEND_REGULATION_SIZE);
    if(_pCommInfo->pReg){
        Regulation_Copy(_pCommInfo->pReg, (REGULATION*)_pCommInfo->sPlayerData[netID].myRegulation);
    }
    CommSendData(CS_COMM_INFO, &_pCommInfo->sPlayerData[netID], sizeof(PlayerInfo));
}

//--------------------------------------------------------------
/**
 * @brief   v[[̃TCYԂ܂
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------
int CommInfoGetPlayerDataSize(void)
{
    return sizeof(PlayerInfo);
}

//--------------------------------------------------------------
/**
 * @brief   infof[^ׂĂƂR}h̎M
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoRecvEnd( int netID, int size, void* pData, void* pWork)
{
    if(_pCommInfo){
        _pCommInfo->_infoEnd = TRUE;
    }
    else{
        OHNO_PRINT("comminfoĂȂ\n");
    }
}


//--------------------------------------------------------------
/**
 * @brief   T[o[݂Ȃ̏񂪑ĂǂmF
 * @param   none
 * @retval  ĂTRUE
 */
//--------------------------------------------------------------
BOOL CommInfoIsInfoCollected(void)
{
    return _pCommInfo->_infoEnd;
}

//--------------------------------------------------------------
/**
 * @brief   MR[obNĂяo܂   CS_COMM_INFO_ARRAY
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoRecvArrayPlayerData( int netID, int size, void* pData, void* pWork)
{
    PlayerInfo* pPlayer = (PlayerInfo*)pData;
    if(!_pCommInfo){
        OHNO_PRINT("comminfoĂȂ\n");
        return;
    }
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if T1346_060825_FIX
    if(!CommIsConnect(netID)){
        return;  //łɐؒf
    }
#endif  //T1651_060825_FIX
// ----------------------------------------------------------------------------
    MI_CpuCopy8( pData, &_pCommInfo->sPlayerData[pPlayer->netID], sizeof(PlayerInfo));
    _pCommInfo->nowNetID = pPlayer->netID;

    if(_pCommInfo->info[_pCommInfo->nowNetID] < _INFO_ENTRY){
        OHNO_PRINT("CommInfo VȃGg[ %d\n", _pCommInfo->nowNetID);
        _pCommInfo->info[_pCommInfo->nowNetID] = _INFO_NEW_ENTRY;  // VȃGg[
        if(CommGetCurrentID() == _pCommInfo->nowNetID){  // g͂łɎtԂɂ
            _pCommInfo->info[_pCommInfo->nowNetID] = _INFO_ENTRY_MSGSENDED;
        }
    }

}

//--------------------------------------------------------------
/**
 * @brief   MR[obNĂяo܂ CS_COMM_INFO
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoRecvPlayerData( int netID, int size, void* pData, void* pWork)
{
    int i;

    if(!_pCommInfo){
        OHNO_SP_PRINT("comminfoĂȂ\n");
        return;
    }
    OHNO_SP_PRINT("CommInfo %d\n", netID);

    MI_CpuCopy8( pData, &_pCommInfo->sPlayerData[netID], sizeof(PlayerInfo));
    CommMPSetBackupMacAddress(&_pCommInfo->sPlayerData[netID].mac[0], netID);

    _pCommInfo->info[netID] = _INFO_NEW_ENTRY;  // VȃGg[
    if(CommGetCurrentID() == netID){  // g͂łɎtԂɂ
        _pCommInfo->info[netID] = _INFO_ENTRY_MSGSENDED;
    }
    else{
        _pCommInfo->bNewInfoData = TRUE;
    }

}

//--------------------------------------------------------------
/**
 * @brief   MyXe[^XM  CS_COMM_MYSTATUS
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

#if 0
void CommInfoRecvMyStatusData( int netID, int size, void* pData, void* pWork)
{
    if(!_pCommInfo){
        OHNO_PRINT("comminfoĂȂ\n");
        return;
    }
    OHNO_SP_PRINT("CommInfoServerM %d \n",netID);

    OHNO_PRINT("CommInfoServer VȃGg[ %d\n", netID);
    OHNO_PRINT("CommInfo mystatusGET %d\n", netID);
    MI_CpuCopy8( pData, _pCommInfo->pMyStatus[netID], MyStatus_GetWorkSize());
    _pCommInfo->info[netID] = _INFO_NEW_ENTRY;  // VȃGg[
    if(CommGetCurrentID() == netID){  // g͂łɎtԂɂ
        _pCommInfo->info[netID] = _INFO_ENTRY_MSGSENDED;
    }
    else{
        _pCommInfo->bNewInfoData = TRUE;
    }
}
#endif

//--------------------------------------------------------------
/**
 * @brief   MyXe[^XM  CS_COMM_MYSTATUS_ARRAY
 * @param   netID           lbg[NID
 * @param   size            Mf[^TCY
 * @param   pData           Mf[^
 * @retval  none
 */
//--------------------------------------------------------------

#if 0
void CommInfoRecvMyStatusArrayData( int netID, int size, void* pData, void* pWork)
{
    if(!_pCommInfo){
        OHNO_PRINT("comminfoĂȂ\n");
        return;
    }
    OHNO_SP_PRINT("CommInfoClientM %d \n",_pCommInfo->nowNetID);
    OHNO_PRINT("CommInfo mystatusArrayGET %d\n", _pCommInfo->nowNetID);
    MI_CpuCopy8(pData, _pCommInfo->pMyStatus[_pCommInfo->nowNetID],
                MyStatus_GetWorkSize());
#ifdef PM_DEBUG
    {
        const STRCODE* pN = MyStatus_GetMyName(_pCommInfo->pMyStatus[_pCommInfo->nowNetID]);
        OHNO_PRINT("%d %d %d %d\n",pN[0],pN[1],pN[2],pN[3]);
    }
#endif
    if(_pCommInfo->info[_pCommInfo->nowNetID] < _INFO_ENTRY){
        OHNO_PRINT("CommInfo VȃGg[ %d\n", _pCommInfo->nowNetID);
        _pCommInfo->info[_pCommInfo->nowNetID] = _INFO_NEW_ENTRY;  // VȃGg[
        if(CommGetCurrentID() == _pCommInfo->nowNetID){  // g͂łɎtԂɂ
            _pCommInfo->info[_pCommInfo->nowNetID] = _INFO_ENTRY_MSGSENDED;
        }
    }

}
#endif

//--------------------------------------------------------------
/**
 * @brief   T[o[q@ɑS̃\[X𑗐M܂
 * @param   none
 * @retval  ԂI^C~OTRUE
 */
//--------------------------------------------------------------

BOOL CommInfoSendArray_ServerSide(void)
{
    int i;
    if(!_pCommInfo->bNewInfoData){
        return FALSE;
    }

    if(!CommIsSendCommand_ServerSize(CS_COMM_INFO_END)){
        OHNO_PRINT("comminfoarray-------q@ɑM\n");
        for(i=0;i<COMM_MACHINE_MAX;i++){
            if(_pCommInfo->info[i] != _INFO_EMPTY){
                OHNO_PRINT("%d 𑗐M\n", i);
                _pCommInfo->sPlayerData[i].netID = i;
                MI_CpuCopy8(_pCommInfo->pMyStatus[i], _pCommInfo->sPlayerData[i].myStatusBuff,MyStatus_GetWorkSize());
                CommSetSendQueue_ServerSide(CS_COMM_INFO_ARRAY,
                                            &_pCommInfo->sPlayerData[i],
                                            sizeof(PlayerInfo));
                //                CommSetSendQueue_ServerSide(CS_COMM_MYSTATUS_ARRAY,
                //                                          _pCommInfo->pMyStatus[i],
                //                                        MyStatus_GetWorkSize());
            }
        }
        // INFOf[^SđI𑗐M ID̃NGXgŏI
        CommSetSendQueue_ServerSide(CS_COMM_INFO_END, NULL,0);
        _pCommInfo->bNewInfoData = FALSE;
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   Vinfof[^ǂ
 * @param   none
 * @retval  Vinfof[^ꍇTRUE
 */
//--------------------------------------------------------------

BOOL CommInfoIsNewInfoData(void)
{
    return _pCommInfo->bNewInfoData;
}

//--------------------------------------------------------------
/**
 * @brief   [Nɂ閼O𓾂܂
 * @param   index       lindexԍ
 * @param   name        l̖Oobt@̃|C^
 * @retval  OTRUE
 */
//--------------------------------------------------------------

BOOL CommInfoGetName(int index,u16* name)
{
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   [NɂlID𕶎œ܂
 * @param   index       lindexԍ
 * @param   idStr       lIDobt@̃|C^
 * @retval  IDTRUE
 */
//--------------------------------------------------------------

BOOL CommInfoGetIDString(int netID, u16* idStr)
{
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   
 * @param   netID           lbg[NID
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoDeletePlayer(int netID)
{
    //    _pCommInfo->sPlayerData[netID].pokeNickName[0] = 0;
    //    _pCommInfo->sPlayerData[netID].pokeID = _INVALID_POKEID;
    MyStatus_Init(_pCommInfo->pMyStatus[ netID ]);
    _pCommInfo->info[ netID ] = _INFO_EMPTY;

}

//--------------------------------------------------------------
/**
 * @brief   VOǂׂ
 * @param   netID           lbg[NID
 * @retval  VȌꍇTRUEԂ
 */
//--------------------------------------------------------------

BOOL CommInfoIsBattleNewName(int netID)
{
    return (_pCommInfo->info[netID] == _INFO_NEW_ENTRY);
}

//--------------------------------------------------------------
/**
 * @brief   VOǂׂ
 * @param   netID           lbg[NID
 * @retval  VȌꍇTRUEԂ
 */
//--------------------------------------------------------------

BOOL CommInfoIsNewName(int netID)
{
    return (_pCommInfo->info[netID] == _INFO_ENTRY) || (_pCommInfo->info[netID] == _INFO_NEW_ENTRY);
}

//--------------------------------------------------------------
/**
 * @brief   VԒԂƂĔF؂
 * @param   netID           lbg[NID
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoSetEntry(int netID)
{
    _pCommInfo->info[netID] = _INFO_ENTRY;
}

//--------------------------------------------------------------
/**
 * @brief   󂯎ƂbZ[W\IƂi[
 * @param   netID           lbg[NID
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoSetMessageEnd(int netID)
{
    _pCommInfo->info[netID] = _INFO_ENTRY_MSGSENDED;
}


//--------------------------------------------------------------
/**
 * @brief   VOǂׂ
 * @param   netID           lbg[NID
 * @retval  VȌꍇ0ȏԂ
 */
//--------------------------------------------------------------

int CommInfoGetNewNameID(void)
{
    int i;

    for(i = 0; i < COMM_MACHINE_MAX ; i++){
        if(_pCommInfo->info[i] == _INFO_NEW_ENTRY){
            return i;
        }
    }
    return INVALID_NETID;
}

//--------------------------------------------------------------
/**
 * @brief   Gg[lA
 * @param   none
 * @retval  num
 */
//--------------------------------------------------------------

int CommInfoGetEntryNum(void)
{
    int i;
    int j = 0;

    for(i = 0; i < COMM_MACHINE_MAX ; i++){
        switch(_pCommInfo->info[i]){
          case _INFO_ENTRY:
          case _INFO_ENTRY_MSGSENDED:
            j++;
            break;
        }
    }
    return j;
}

//--------------------------------------------------------------
/**
 * @brief   ڑɉăf[^
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommInfoFunc(void)
{
    int i;

    if(_pCommInfo){
        if(CommGetConnectNum()==0){
            return;
        }
        for(i = 0; i < COMM_MACHINE_MAX ; i++){
            if( !CommIsConnect(i) && !( (i == COMM_PARENT_ID) && CommGetAloneMode())  ){
                if(_pCommInfo->info[i] != _INFO_EMPTY){
                    CommInfoDeletePlayer(i);
                }
            }
        }
    }
}


//==============================================================================
/**
 *  MyStatusԂ
 * @param   netID   id
 * @retval  MYSTATUS*
 */
//==============================================================================

MYSTATUS* CommInfoGetMyStatus(int netID)
{
    if(!_pCommInfo){
        return NULL;
    }
    switch(_pCommInfo->info[netID]){
      case _INFO_NEW_ENTRY:
      case _INFO_ENTRY:
      case _INFO_ENTRY_MSGSENDED:
        return _pCommInfo->pMyStatus[netID];
    }
    return NULL;
}

//==============================================================================
/**
 * REGULATIONԂ
 * @param   netID   id
 * @retval  REGULATION*
 */
//==============================================================================

const REGULATION* CommInfoGetRegulation(int netID)
{
    if(!_pCommInfo){
        return NULL;
    }
    switch(_pCommInfo->info[netID]){
      case _INFO_NEW_ENTRY:
      case _INFO_ENTRY:
      case _INFO_ENTRY_MSGSENDED:
        return (const REGULATION*)_pCommInfo->sPlayerData[netID].myRegulation;
    }
    return NULL;
}

//==============================================================================
/**
 *  DWCFriendDataԂ
 * @param   netID   id
 * @retval  DWCFriendData*
 */
//==============================================================================

DWCFriendData* CommInfoGetDWCFriendCode(int netID)
{
    if(_pCommInfo->info[netID] != _INFO_EMPTY){
        return &_pCommInfo->sPlayerData[netID].friendData;   //ʐMœnp̃thR[h
    }
    return NULL;
}

//==============================================================================
/**
 *  GroupNameԂ
 * @param   netID   id
 * @retval  STRCODE*
 */
//==============================================================================

STRCODE* CommInfoGetGroupName(int netID)
{
    if(_pCommInfo->info[netID] != _INFO_EMPTY){
        return _pCommInfo->sPlayerData[netID].groupName;
    }
    return NULL;
}

//==============================================================================
/**
 * myNationԂ
 * @param   netID   id
 * @retval  sꍇ͂O
 */
//==============================================================================

int CommInfoGetMyNation(int netID)
{
    if(_pCommInfo->info[netID] != _INFO_EMPTY){
        return _pCommInfo->sPlayerData[netID].my_nation;
    }
    return 0;
}

//==============================================================================
/**
 * myAreaԂ
 * @param   netID   id
 * @retval  sꍇ͂O
 */
//==============================================================================

int CommInfoGetMyArea(int netID)
{
    if(_pCommInfo->info[netID] != _INFO_EMPTY){
        return _pCommInfo->sPlayerData[netID].my_area;
    }
    return 0;
}

//==============================================================================
/**
 * myPenaltyԂ
 * @param   netID   id
 * @retval  sꍇ͂O
 */
//==============================================================================

int CommInfoGetMyPenalty(int netID)
{
    if(_pCommInfo->info[netID] != _INFO_EMPTY){
        return _pCommInfo->sPlayerData[netID].myPenalty;
    }
    return 0;
}




//==============================================================================
/**
 * ڑĂl̃M[Vǂ
 * @param   void
 * @retval  sꍇ͂O
 */
//==============================================================================

BOOL CommInfoRegulationCheck(void)
{
    int i,j;

    for(i = 0; i < COMM_MACHINE_MAX-1 ; i++){
        if( CommIsConnect(i) && (_pCommInfo->info[i] != _INFO_EMPTY)){
            if( CommIsConnect(i+1) && (_pCommInfo->info[i+1] != _INFO_EMPTY)){
                DEBUG_DUMP(_pCommInfo->sPlayerData[i].myRegulation, COMM_SEND_REGULATION_SIZE,"");
                DEBUG_DUMP(_pCommInfo->sPlayerData[i+1].myRegulation, COMM_SEND_REGULATION_SIZE,"");
                for(j = 0;j < COMM_SEND_REGULATION_SIZE ; j++){
                    if(_pCommInfo->sPlayerData[i].myRegulation[j] != _pCommInfo->sPlayerData[i+1].myRegulation[j]){
                        return FALSE;
                    }
                }
            }
        }
    }
    return TRUE;
}

//==============================================================================
/**
 * ̋L^
 * @param   type JEg
 * @param   num  
 * @retval  none
 */
//==============================================================================

static void _commInfoSetResult(int type,int num)
{
    int i;
    int myStandBit,targetBit;

    if(_pCommInfo==NULL){
        return;
    }
    if(type != _RESULT_TYPE_TRADE){
        myStandBit = CommGetStandNo(CommGetCurrentID()) & 0x1;  // ̗
    }

    
    for(i = 0; i < CommGetConnectNum(); i++){
        if( CommIsConnect(i) && (_pCommInfo->info[i] != _INFO_EMPTY)){
            if(type == _RESULT_TYPE_WIN){
                targetBit = CommGetStandNo(i) & 0x1;
                if(myStandBit != targetBit){
                    _pCommInfo->sPlayerResult[i].win += num;
                    OHNO_PRINT(" %d %d %d\n",i,type,num);
                }
            }
            else if(type == _RESULT_TYPE_LOSE){
                targetBit = CommGetStandNo(i) & 0x1;
                if(myStandBit != targetBit){
                    _pCommInfo->sPlayerResult[i].lose += num;
                    OHNO_PRINT("܂ %d %d %d\n",i,type,num);
                }
            }
            else{
                _pCommInfo->sPlayerResult[i].trade += num;
            }
        }
    }
}

//------------------------------------------------------------------
/**
 * $brief   񐔂o^
 * @param   wk
 * @param   seq
 * @retval  int
 */
//------------------------------------------------------------------

void CommInfoWriteResult(SAVEDATA* pSaveData)
{
    WIFI_LIST* pList = SaveData_GetWifiListData(pSaveData);
    int i,ret,pos;

    for(i = 0; i < CommGetConnectNum(); i++){
        DWCFriendData* pFriend = CommInfoGetDWCFriendCode(i);
        if(pFriend == NULL){
            continue;
        }
        ret = dwc_checkfriendByToken(pSaveData, pFriend, &pos);
        switch(ret){
          case DWCFRIEND_INLIST:// c łɁAf[^XgɂB̏ꍇ͉KvȂB
          case DWCFRIEND_OVERWRITE:// c łɁAf[^Xgɂ邪A㏑邱Ƃ]܂ꍇB
            GF_ASSERT(pos >= 0);

            OHNO_PRINT("L^  %d %d  %d %d %d \n",i,pos,
                       _pCommInfo->sPlayerResult[i].win,
                       _pCommInfo->sPlayerResult[i].lose,
                       _pCommInfo->sPlayerResult[i].trade);
            WifiList_SetResult(pList, pos,
                               _pCommInfo->sPlayerResult[i].win,
                               _pCommInfo->sPlayerResult[i].lose,
                               _pCommInfo->sPlayerResult[i].trade);
            break;
        }
    }
    // ܂
    for(i = 0;i < COMM_MACHINE_MAX;i++){
        _pCommInfo->sPlayerResult[i].win = 0;
        _pCommInfo->sPlayerResult[i].lose = 0;
        _pCommInfo->sPlayerResult[i].trade = 0;
    }

}

//------------------------------------------------------------------
/**
 * $brief   ̓o^
 * @param   wk
 * @param   seq
 * @retval  int
 */
//------------------------------------------------------------------

void CommInfoSetBattleResult(SAVEDATA* pSaveData, int bWin )
{
    if(bWin==1){
        _commInfoSetResult(_RESULT_TYPE_WIN, 1);
    }
    else if(bWin == -1){
        _commInfoSetResult(_RESULT_TYPE_LOSE, 1);
    }
    CommInfoWriteResult(pSaveData);
}

void CommInfoSetTradeResult(SAVEDATA* pSaveData, int num)
{
    _commInfoSetResult(_RESULT_TYPE_TRADE, num);
    CommInfoWriteResult(pSaveData);
}

