//=============================================================================
/**
 * @file	comm_mp.c
 * @brief	ʐM̐ڑǗĂNX  comm_system.c 番
            ŏII WIFICuƕɂȂĂ...\

            comm_sys    ---   comm_mp         --   comm_local.c
                         |                     |--  wh.c
                         |
                         |
                         --   comm_wifi      --   comm_local.c
                                              |----wifi.lib

   
 * @author	Katsumi Ohno
 * @date    2006.01.25
 */
//=============================================================================


#include "common.h"
#include "wh_config.h"
#include "wh.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "comm_local.h"

#include "system/pm_str.h"
#include "system/gamedata.h"  //PERSON_NAME_SIZE

#include "comm_ring_buff.h"
#include "system/pm_rtc.h"  //GF_RTC
#include "system/savedata.h"
#include "savedata/regulation.h"

//==============================================================================
// extern錾
//==============================================================================

// RpCɃ[jOôŒ`Ă
#include "communication/comm_system.h"


//==============================================================================
// `
//==============================================================================


#define _PORT_DATA_RETRANSMISSION   (14)    // ؒf܂Ŗđs  gpĂ
#define _PORT_DATA_PARENT           _PORT_DATA_RETRANSMISSION
#define _PORT_DATA_CHILD            _PORT_DATA_RETRANSMISSION

#define _KEEP_CHANNEL_TIME_MAX   (5)

#define _NOT_INIT_BITMAP  (0xffff)   // ڑlŒɎwȂꍇ̒l

typedef enum{    // ؒf
    _DISCONNECT_NONE,
    _DISCONNECT_END,
    _DISCONNECT_SECRET,
    _DISCONNECT_STEALTH,
};

#define _BEACON_SIZE_MAX   MATH_MAX(sizeof(_GF_BSS_MYSTERY),sizeof(_GF_BSS_DATA_INFO))


//Ǘ\̒`
typedef struct{
    u8 mysteryData[MYSTERY_BEACON_DATA_SIZE];
    WMBssDesc sBssDesc[SCAN_PARENT_COUNT_MAX];  ///< e@̏LĂ\
    u8  backupBssid[COMM_MACHINE_MAX][WM_SIZE_BSSID];   // ܂ŐڑĂ
    u16 bconUnCatchTime[SCAN_PARENT_COUNT_MAX]; ///< e@̃r[REȂ+f[^邩ǂ
    void* _pWHWork;                           ///whCugp郏[Ñ|C^
    PMS_DATA pmsData;
    int sBeaconCount;                           ///< r[RJE^
//    MATHRandContext32 sRand;                    ///< weppL[
    u8 bScanCallBack;  ///< ẽXLꍇTRUE, FALSE
    u8 regulationNo;   ///< Q[M[V
#ifdef PM_DEBUG		//DebugROM
    u8 soloDebugNo;
#endif
    /// ----------------------------q@p
    MYSTATUS* pMyStatus;            // ̃Xe[^X
    REGULATION* pRegulation;        // TM[V KvȂꍇNULL
//    u32 wepSeed;
    u32 ggid;
    u16 gameInfoBuff[WM_SIZE_USER_GAMEINFO];
    u16 keepChannelNo;
    u16 errCheckBitmap;      ///< BITMAPHႤƃG[ɂȂ
    u8 channel;
    u8 keepChannelTime;
    u8 disconnectType;    ///< ؒf
    u8 bSetReceiver;
    u8 bEndScan;  // endscan
    u8 bErrorState:1;     ///< G[NĂꍇ̏Ԃ܂
    u8 bErrorDisconnectOther:1;     ///< NƃG[ɂȂ܂
    u8 bErrorNoChild:1;  ///< q@ꍇG[邩ǂ
    u8 bTGIDChange:1;
    u8 bAutoExit:1;
    u8 bEntry:1;   // q@̐VKQ
//    u8 bStalth:1;
} _COMM_WORK;

//==============================================================================
// [N
//==============================================================================

///< [N\̂̃|C^
static _COMM_WORK* _pCommMP = NULL;

// e@ɂȂꍇTGID \̂ɓĂȂ̂
// ʐMCu[؂ƂĂCNg
/// TGIDǗ
static u16 _sTgid = 0;


// WEP Key 쐬p̋ʌieqŋʂ̌gpj
// AvP[VƂɌŗL̂̂Ƃ邱
// ASCII łKv͂ȂACӂ̒̃oCif[^ł悢
//static char* _sSecretKey = " http://www.gamefreak.co.jp/ ";



// R|[lg]I̊mFp
// CNj[R|[lgړƂ͂ړ
static volatile int   startCheck;	

//==============================================================================
// static錾
//==============================================================================

static void _whInitialize(void);
static void _childDataInit(void);
static void _parentDataInit(BOOL bTGIDChange);
static void _commInit(void);
static void _setUserGameInfo( void );
static BOOL _isMachBackupMacAddress(u8* pMac);
static u16 _getServiceBeaconPeriod(u16 serviceNo);

static void _scanCallback(WMBssDesc *bssdesc);
static void _startUpCallback(void *arg, WVRResult result);
static void _indicateCallback(void *arg);
static int _connectNum(void);

//==============================================================================
/**
 * ڑNX̏
 * @param   pMyStatus   MYSTATUS|C^
 * @retval  none
 */
//==============================================================================

void CommMPInitialize(MYSTATUS* pMyStatus)
{
    int i;
    
    if(_pCommMP!=NULL){  // łɏĂꍇreturn
        return;
    }
    _pCommMP = (_COMM_WORK*)sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_COMM_WORK));
    MI_CpuClear8(_pCommMP, sizeof(_COMM_WORK));
    _pCommMP->_pWHWork = sys_AllocMemory(HEAPID_COMMUNICATION, WH_GetHeapSize());
    MI_CpuClear8(_pCommMP->_pWHWork, WH_GetHeapSize());
    _pCommMP->pRegulation = sys_AllocMemory(HEAPID_COMMUNICATION, Regulation_GetWorkSize());
    MI_CpuClear8(_pCommMP->pRegulation, Regulation_GetWorkSize());
    _pCommMP->ggid = _DP_GGID;
    _pCommMP->pMyStatus = pMyStatus;
	// ȈՉb
	PMSDAT_Clear( (PMS_DATA*)&_pCommMP->pmsData );
    // Cu쓮Jn
    _whInitialize();
}

BOOL CommMPIsConnect(void)
{
    if(_pCommMP){
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * r֐
 * @param   pCmp1,pCmp2   rΏ
 * @retval  vTRUE
 */
//==============================================================================

static BOOL _bmemcmp(const u8* pCmp1,const u8* pCmp2, int size)
{
    int i;
    const u8* pc1 = pCmp1;
    const u8* pc2 = pCmp2;

    for(i = 0; i < size; i++){
        if(*pc1 != *pc2){
            return FALSE;
        }
        pc1++;
        pc2++;
    }
    return TRUE;
}

//==============================================================================
/**
 * q@e@ToɌĂ΂R[obN֐
 * e@EтɌĂ΂
 * @param   bssdesc   O[v
 * @retval  none
 */
//==============================================================================

static void DEBUG_MACDISP(char* msg,WMBssDesc *bssdesc)
{
    OHNO_PRINT("%s %02x%02x%02x%02x%02x%02x\n",msg,
               bssdesc->bssid[0],bssdesc->bssid[1],bssdesc->bssid[2],
               bssdesc->bssid[3],bssdesc->bssid[4],bssdesc->bssid[5]);
}

static void _scanCallback(WMBssDesc *bssdesc)
{
    int i;
    _GF_BSS_DATA_INFO* pGF;
    int serviceNo = CommStateGetServiceNo();
    int regulationNo = CommStateGetRegulationNo();
#ifdef PM_DEBUG		//DebugROM
    int soloDebugNo = CommStateGetSoloDebugNo();
#endif

    // catchef[^
    pGF = (_GF_BSS_DATA_INFO*)bssdesc->gameInfo.userGameInfo;
    if(serviceNo == COMM_MODE_POKETCH){  // |Pb`͉łE
    }
    else if(CommLocalIsUnionGroup(pGF->serviceNo) && CommLocalIsUnionGroup(serviceNo)){  // ݂E
    }
    else if(pGF->pause && (pGF->serviceNo == COMM_MODE_UNDERGROUND)){
        OHNO_PRINT("pGF->pause\n");
        return;  // |[Y̐e@͖
    }
    else if(pGF->serviceNo != serviceNo){
//        DEBUG_MACDISP("T[rXقȂꍇ͏EȂ\n",bssdesc);
        return;   // T[rXقȂꍇ͏EȂ
    }
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/16
// T[`[傤r[REȂs̏C
#if AFTERMASTER_070112_POKETCH_ETC
    if((serviceNo != COMM_MODE_POKETCH)&&(pGF->regulationNo != regulationNo)){
        return;   // M[VقȂꍇ͏EȂi|Pb`ȊOj
    }
#else //AFTERMASTER_070112_POKETCH_ETC
    if(pGF->regulationNo != regulationNo){
//        DEBUG_MACDISP("M[VقȂꍇ͏EȂ\n",bssdesc);
        return;   // M[VقȂꍇ͏EȂ
    }
#endif //AFTERMASTER_070112_POKETCH_ETC
// ----------------------------------------------------------------------------
#ifdef PM_DEBUG		//DebugROM
    if(serviceNo != COMM_MODE_POKETCH){
        if(pGF->soloDebugNo != soloDebugNo){
//            DEBUG_MACDISP("fobOقȂꍇ͏EȂx\n",bssdesc);
            return;   // fobOʔԍقȂꍇ͏EȂ
        }
    }
#endif
    
    // ̃[v͓̂Ȃ̂ǂ
    for (i = 0; i < SCAN_PARENT_COUNT_MAX; ++i) {
        if(_pCommMP->bconUnCatchTime[i] == 0 ){
            // e@񂪓ĂȂꍇcontinue
            continue;
        }
        if (_bmemcmp(_pCommMP->sBssDesc[i].bssid, bssdesc->bssid, WM_SIZE_BSSID)) {
#ifdef DEBUG_ONLY_FOR_mori
            OS_TPrintf("r[RXV %02x%02x%02x%02x%02x%02x\n",
                       bssdesc->bssid[0],bssdesc->bssid[1],bssdesc->bssid[2],
                       bssdesc->bssid[3],bssdesc->bssid[4],bssdesc->bssid[5]);
#endif
            // xEꍇɃ^C}[Z
            _pCommMP->bconUnCatchTime[i] = _DEFAULT_TIMEOUT_FRAME;
            // VeۑĂB
            MI_CpuCopy8( bssdesc, &_pCommMP->sBssDesc[i], sizeof(WMBssDesc));

//            DEBUG_DUMP(pGF->regulationBuff, Regulation_GetWorkSize(),"󂯎M");
            return;
        }
    }
    // ̃[v͋󂫂邩ǂ
    for (i = 0; i < SCAN_PARENT_COUNT_MAX; ++i) {
        if(_pCommMP->bconUnCatchTime[i] == 0 ){
            // e@񂪓ĂȂꍇbreak;
            break;
        }
    }
    if(i >= SCAN_PARENT_COUNT_MAX){
        // \̂ς̏ꍇ͐e@EȂ
        // @@OOe@݂ꍇA@\ƂKvƎv
        return;
    }
    // VeۑĂB
#ifdef DEBUG_ONLY_FOR_mori
    OS_TPrintf("VKe@r[RE %02x%02x%02x%02x%02x%02x\n",
               bssdesc->bssid[0],bssdesc->bssid[1],bssdesc->bssid[2],
               bssdesc->bssid[3],bssdesc->bssid[4],bssdesc->bssid[5]);
#endif
    _pCommMP->bconUnCatchTime[i] = _DEFAULT_TIMEOUT_FRAME;
    MI_CpuCopy8( bssdesc, &_pCommMP->sBssDesc[i],sizeof(WMBssDesc));
    _pCommMP->bScanCallBack = TRUE;
}

//------------------------------------------------------------------
/**
 * 쓮䃉Cu̔񓯊IȏIʒmR[obN֐B
 *
 * @param   arg		WVR_StartUpAsyncR[Ɏw肵BgpB
 * @param   result	񓯊֐̏ʁB
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _startUpCallback(void *arg, WVRResult result)
{
    if (result != WVR_RESULT_SUCCESS) {
        OS_TPanic("WVR_StartUpAsync error.[%08xh]\n", result);
    }
    else{
		OS_Printf("WVR Trans VRAM-D.\n");
	}
    startCheck = 2;
}

//------------------------------------------------------------------
/**
 * 쓮䃉Cu̔񓯊IȏIʒmR[obN֐B
 *
 * @param   arg		WVR_StartUpAsyncR[Ɏw肵BgpB
 * @param   result	񓯊֐̏ʁB
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _endCallback(void *arg, WVRResult result)
{
    startCheck = 0;
    sys_SleepOK(SLEEPTYPE_COMM);  // X[v
}

//==============================================================================
/**
 * WVRVRAMDɈړ
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommVRAMDInitialize(void)
{
    //************************************
//	GX_DisableBankForTex();			// eNX`C[W

    sys_SleepNG(SLEEPTYPE_COMM);  // X[v֎~
    // Cu쓮Jn
	// CNj[R|[lgVRAM-Dɓ]
    startCheck = 1;
    if (WVR_RESULT_OPERATING != WVR_StartUpAsync(GX_VRAM_ARM7_128_D, _startUpCallback, NULL)) {
        OS_TPanic("WVR_StartUpAsync failed. \n");
    }
    else{
        OHNO_PRINT("WVRStart\n");
    }
}

//==============================================================================
/**
 * WVRVRAMDɈړI1
 * @param   none
 * @retval  none
 */
//==============================================================================

BOOL CommIsVRAMDInitialize(void)
{
    return (startCheck==2);
}

//==============================================================================
/**
 * WVRVRAMDɈړ͂߂P
 * @param   none
 * @retval  none
 */
//==============================================================================

BOOL CommIsVRAMDStart(void)
{
    return (startCheck!=0);
}

//==============================================================================
/**
 * CNj[J
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommVRAMDFinalize(void)
{
    OHNO_PRINT("VRAMD Finalize\n");
    WVR_TerminateAsync(_endCallback,NULL);  // CNj[ؒf
}


//==============================================================================
/**
 * ʐMԂm点̃R[obN
 * @param   arg WMIndCallback\
 * @retval  none
 */
//==============================================================================
static void _indicateCallback(void *arg)
{
    WMIndCallback *cb;
    cb = (WMIndCallback *)arg;
    if (cb->state == WM_STATECODE_BEACON_RECV) {
        if(_pCommMP){
            _pCommMP->sBeaconCount = 2;
        }
    }
}

//==============================================================================
/**
 * WHCȕ
 * @param   bReInit  ďǂ
 * @param   pLocal  ʐMʍ\
 * @retval  none
 */
//==============================================================================

static void _whInitialize(void)
{
    
    _pCommMP->sBeaconCount = 0;

    
    // 
    {
        u32 addr = (u32)_pCommMP->_pWHWork;
        addr = 32 - (addr % 32) + addr;   //32byteACg
        (void)WH_Initialize((void*)addr);
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if T1657_060818_FIX
#else //T1657_060818_FIX
        (void)WM_SetIndCallback(_indicateCallback);
#endif //T1657_060818_FIX
// ----------------------------------------------------------------------------
    }

    // WH ݒ
    WH_SetGgid(_pCommMP->ggid);

    // WEP Key ̎p̗@̏
//    CommRandSeedInitialize(&_pCommMP->sRand);
}

//==============================================================================
/**
 * q@̎gpĂf[^̏
 * @param   bssdesc   O[v
 * @retval  none
 */
//==============================================================================

void ChildBconDataInit(void)
{
    int i;

    for (i = 0; i < SCAN_PARENT_COUNT_MAX; ++i) {
        _pCommMP->bconUnCatchTime[i] = 0;
    }
    MI_CpuClear8(_pCommMP->sBssDesc,sizeof(WMBssDesc)*SCAN_PARENT_COUNT_MAX);
}

//==============================================================================
/**
 * e@̎gpĂf[^̏
 * @param   bTGIDChange  VK̃Q[̏̏ꍇTRUE Âr[Rł̌듮hߗp
 * @retval  none
 */
//==============================================================================

static void _parentDataInit(BOOL bTGIDChange)
{
    _pCommMP->bTGIDChange = bTGIDChange;
}

//==============================================================================
/**
 * eqʁAʐM̏܂Ƃ߂
 * @param   work_area @VXeŎg[̈
 *                      NULL̏ꍇłɏς݂Ƃē
 * @retval  ɐTRUE
 */
//==============================================================================

static void _commInit(void)
{
    _pCommMP->bScanCallBack = FALSE;
    _pCommMP->bErrorState = FALSE;
    _pCommMP->bErrorNoChild = FALSE;
    
    _pCommMP->disconnectType = _DISCONNECT_NONE;
    _pCommMP->bAutoExit = FALSE;
    _pCommMP->bEndScan = 0;

    _pCommMP->bSetReceiver = FALSE;
    
    return;
}


//==============================================================================
/**
 * ʐMCuɕKvȃ[NTCYԂ
 * @param   none
 * @retval  [NTCY
 */
//==============================================================================
u32 CommGetWorkSize(void)
{
    OHNO_PRINT("_COMM_WORK size %d \n", sizeof(_COMM_WORK));
    return sizeof(_COMM_WORK);
}

//==============================================================================
/**
 * e@̐ڑJns
 * @param   work_area @VXeŎg[̈
 *                      NULL̏ꍇłɏς݂Ƃē
 * @param   serviceNo     Q[̎
 * @param   regulationNo  Q[̎
 * @param   bTGIDChange  VK̃Q[̏̏ꍇTRUE Âr[Rł̌듮hߗp
 * @param  q@󂯕t邩ǂ
 * @retval  ɐTRUE
 */
//==============================================================================
BOOL CommMPParentInit(BOOL bAlloc, BOOL bTGIDChange, BOOL bEntry)
{
    _commInit();
    _parentDataInit(bTGIDChange);

    WH_ParentDataInit();
    if(!_pCommMP->bSetReceiver){
        WH_SetReceiver(CommRecvParentCallback, _PORT_DATA_CHILD);
      _pCommMP->bSetReceiver = TRUE;
    }
    _pCommMP->bEntry = bEntry;

    // dggpœKȃ`l擾ĐڑB񓯊֐
    if(WH_GetSystemState() == WH_SYSSTATE_IDLE){
        if(WH_StartMeasureChannel()){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * q@̐ڑJns
 * @param   work_area @VXeŎg[̈
 *                      NULL̏ꍇ͂łɏς݂ƂĈ
 * @param   serviceNo  Q[̎
 * @param   regulationNo  Q[̎
 * @param   bBconInit  r[Rf[^̂ǂ
 * @retval  ɐTRUE
 */
//==============================================================================
BOOL CommMPChildInit(BOOL bAlloc, BOOL bBconInit)
{
    _commInit();
    if(bBconInit){
        OHNO_PRINT("r[Ȑ\n");
        ChildBconDataInit(); // f[^̏
    }
    if(!_pCommMP->bSetReceiver ){
        WH_SetReceiver(CommRecvCallback, _PORT_DATA_PARENT);
        _pCommMP->bSetReceiver = TRUE;
    }
    // e@X^[g
    if(WH_GetSystemState() == WH_SYSSTATE_IDLE){
        // MACAhXw@@SFFőSĂTɂ
        const u8 sAnyParent[6] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
        if(WH_StartScan(_scanCallback, sAnyParent, _SCAN_ALL_CHANNEL)){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * ʐM؂ւsieq]ɕKvȏj
 * @param   none
 * @retval  ZbgTRUE
 */
//==============================================================================

BOOL CommMPSwitchParentChild(void)
{
    if(!_pCommMP){
        return TRUE;
    }
    switch(_pCommMP->bEndScan){
      case 0:
        if(WH_IsSysStateScan()){
            WH_EndScan();
            _pCommMP->bEndScan = 1;
            break;
        }
        else if(WH_IsSysStateBusy()){  //΂炭҂
        }
        else{
            WH_Finalize();
            _pCommMP->bEndScan = 2;
        }
        break;
      case 1:
        if(!WH_IsSysStateBusy()){
            WH_Finalize();
            _pCommMP->bEndScan = 2;
        }
        break;
      case 2:
        if(WH_IsSysStateIdle()){
            return TRUE;
        }
        if(WH_IsSysStateError()){
            _pCommMP->bEndScan = 1;
        }
        break;
    }
    return FALSE;
}

//==============================================================================
/**
 * ʐMؒfs  ł͂܂ŒʐMI葱ɓ邾
 *  zgɏ͉̂_commEnd
 * @param   none
 * @retval  IɈڂꍇTRUE
 */
//==============================================================================
BOOL CommMPFinalize(void)
{
    if(_pCommMP){
        if(_pCommMP->disconnectType == _DISCONNECT_NONE){
            _pCommMP->disconnectType = _DISCONNECT_END;
            WH_Finalize();
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * ʐMؒfs  [JsȂ
 * @param   ؒf̏ꍇTRUE
 * @retval  none
 */
//==============================================================================
void CommMPStealth(BOOL bStalth)
{
    if(!_pCommMP){
        return;
    }
    if(bStalth){
        _pCommMP->disconnectType = _DISCONNECT_SECRET;
    }
    else{
        _pCommMP->disconnectType = _DISCONNECT_NONE;
        _whInitialize();  // 쓮ĊJ
    }
}

//==============================================================================
/**
 * ʐM̑SĂ
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _commEnd(void)
{
    sys_FreeMemoryEz(_pCommMP->pRegulation);
    sys_FreeMemoryEz(_pCommMP->_pWHWork);
    sys_FreeMemoryEz(_pCommMP);
    _pCommMP = NULL;
}

//==============================================================================
/**
 * TƂłe̐Ԃ
 * @param   none
 * @retval  e@̐
 */
//==============================================================================

int CommMPGetParentCount(void)
{
    int i, cnt;

    if(!CommIsInitialize()){
        return 0;
    }

    cnt = 0;
    for (i = 0; i < SCAN_PARENT_COUNT_MAX; ++i) {
        if(_pCommMP->bconUnCatchTime[i] != 0 ){
            cnt++;
        }
    }
    return cnt;
}

//--------------------------------------------------------------
/**
 * @brief   BmpLisẗʒuBcon݂̑Indexʒu擾
 * @param   index		BmpListʒu
 * @retval  Index
 */
//--------------------------------------------------------------
int CommBmpListPosBconIndexGet(int index)
{
	int i, count;
	
//	for(i = 0; i < SCAN_PARENT_COUNT_MAX; i++){
//		OS_TPrintf("List̃r[R`FbN %d = %d\n", i, _pCommMP->bconUnCatchTime[i]);
//	}
	
	count = 0;
	for(i = 0; i < SCAN_PARENT_COUNT_MAX; i++){
		if(_pCommMP->bconUnCatchTime[i] != 0){
			if(count == index){
				return i;
			}
			count++;
		}
	}
	GF_ASSERT(0 && "ɂ͗Ȃ͂");
	return 0;
}

//==============================================================================
/**
 * e@XgɕωꍇTRUE
 * @param   none
 * @retval  e@XgɕωꍇTRUE ȂFALSE
 */
//==============================================================================

BOOL CommMPIsScanListChange(void)
{
    return _pCommMP->bScanCallBack;
}

//==============================================================================
/**
 * e@̕ωm点tOZbg
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommMPResetScanChangeFlag(void)
{
    _pCommMP->bScanCallBack = FALSE;
}

//==============================================================================
/**
 * ̐e@ƃRlNVĂ̂𓾂
 * @param   index   ẽXgindex
 * @retval  RlNV 0-16
 */
//==============================================================================

int CommMPGetParentConnectionNum(int index)
{
    int cnt;
    _GF_BSS_DATA_INFO* pGF;

    cnt = 0;
    if(_pCommMP->bconUnCatchTime[index] != 0){
        pGF = (_GF_BSS_DATA_INFO*)_pCommMP->sBssDesc[index].gameInfo.userGameInfo;
        if(pGF->connectNum==0){
            return 1;
        }
        return pGF->connectNum;
    }
    return 0;
}

//==============================================================================
/**
 * ڑlɊYeԂ
 * @param   none
 * @retval  eindex
 */
//==============================================================================

static int _getParentNum(int machNum)
{
    int i,num;

    for (i = SCAN_PARENT_COUNT_MAX-1; i >= 0; i--) {
        num = CommMPGetParentConnectionNum(i);
        if((num > machNum) && (num < COMM_MACHINE_MAX)){
            return i;
        }
    }
    return -1;
}

//==============================================================================
/**
 * ɐڑĂlꍇindexԂ
 * @param   none
 * @retval  YindexԂ
 */
//==============================================================================

int CommMPGetFastConnectIndex(void)
{
    int i,num;

    if(CommMPGetParentCount()==0){
        return -1;
    }
    for (i = SCAN_PARENT_COUNT_MAX -1; i >= 0; i--) {
        if(_pCommMP->bconUnCatchTime[i] != 0){
            if(_isMachBackupMacAddress(&_pCommMP->sBssDesc[i].bssid[0])){  // ÂMACɍv
                num = CommMPGetParentConnectionNum(i);
                if(( num > 1) && (num < COMM_MACHINE_MAX)){      // {eɊY ܂Q\
                    return i;
                }
            }
        }
    }
    return -1;
}

//==============================================================================
/**
 * ̃xŌqłl炻indexԂ܂
 * @param   none
 * @retval  YindexԂ
 */
//==============================================================================

int CommMPGetNextConnectIndex(void)
{
    int i;
 
    if(CommMPGetParentCount()==0){  // r[R
        return -1;
    }
    for (i = SCAN_PARENT_COUNT_MAX-1; i >= 0; i--) {
        if(_pCommMP->bconUnCatchTime[i] != 0){
            if(_isMachBackupMacAddress(&_pCommMP->sBssDesc[i].bssid[0])){  // ÂMACɍv
                OHNO_PRINT("̂̐e %d\n",i);
                return i;
            }
        }
    }
    i = _getParentNum(1);
    if(i != -1 ){
        OHNO_PRINT("Ȃ{e %d \n", i);
        return i;
    }
    i = _getParentNum(0);
    if(i != -1){
        OHNO_PRINT("Ȃe %d \n", i);
        return i;
    }
    return i;
}

//==============================================================================
/**
 * e@XgindexɕԂ
 * @param   index      ẽXgindex
 * @param   pMyStatus  i[MYSTATUS̃|C^
 * @retval  none
 */
//==============================================================================

void CommMPGetParentName(int index, MYSTATUS* pMyStatus)
{
    int i, cnt;
    _GF_BSS_DATA_INFO* pGF;

    cnt = 0;
    for (i = 0; i < SCAN_PARENT_COUNT_MAX; ++i) {
        if(_pCommMP->bconUnCatchTime[i] != 0){
            if(index == cnt){
                MyStatus_Copy( CommMPGetBconMyStatus(i), pMyStatus);
                return;
            }
            cnt++;
        }
    }
    OHNO_PRINT("O擾łȂ index = %d\n", index);
}

//==============================================================================
/**
 * e@ۂIDindexɕԂ
 * @param   index   ẽXgindex
 * @retval  pokeID
 */
//==============================================================================

u32 CommMPGetPokeID(int index)
{
    int i, cnt;
    _GF_BSS_DATA_INFO *pGF;

    cnt = 0;
    for (i = 0; i < SCAN_PARENT_COUNT_MAX; ++i) {
        if(_pCommMP->bconUnCatchTime[i] != 0 ){
            if(index == cnt){
                pGF = (_GF_BSS_DATA_INFO*)_pCommMP->sBssDesc[i].gameInfo.userGameInfo;
                return pGF->pokeID;
            }
            cnt++;
        }
    }
    return 0;
}

//==============================================================================
/**
 * q@@MPԂŐڑ
 * @param   index   ẽXgindex
 * @retval  q@ڑe@ɑTRUE
 */
//==============================================================================
BOOL CommMPChildIndexConnect(u16 index)
{
    int serviceNo;
    
    if (WH_GetSystemState() == WH_SYSSTATE_SCANNING) {
        (void)WH_EndScan();
        return FALSE;
    }
    if (WH_GetSystemState() == WH_SYSSTATE_IDLE) {
        OHNO_PRINT("q@ ڑJn WH_ChildConnect\n");
        serviceNo = CommStateGetServiceNo();
        _pCommMP->channel = _pCommMP->sBssDesc[index].channel;
        if(CommLocalIsUnionGroup(serviceNo)){
           WH_ChildConnectAuto(WH_CONNECTMODE_MP_CHILD, _pCommMP->sBssDesc[index].bssid,0);
        }
        else{
            WH_ChildConnect(WH_CONNECTMODE_MP_CHILD, &(_pCommMP->sBssDesc[index]));
        }
//        WH_ChildConnectAuto(WH_CONNECTMODE_MP_CHILD, _pCommMP->sBssDesc[index].bssid,0);
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * r[Rf[^̒mF
 *  ڑԂł̊ԁÅ֐ĂсA^CAEgs
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommMPParentBconCheck(void)
{
    int id;

    for(id = 0; id < SCAN_PARENT_COUNT_MAX; id++){
        if(_pCommMP->bconUnCatchTime[id] == 0 ){
            continue;
        }
        if(_pCommMP->bconUnCatchTime[id] > 0){
            _pCommMP->bconUnCatchTime[id]--;
            if(_pCommMP->bconUnCatchTime[id] == 0){
                OHNO_PRINT("e@Ȃ %d\n", id);
                _pCommMP->bScanCallBack = TRUE;   // f[^ύX̂TRUE
            }
        }
    }
}

//==============================================================================
/**
 *  [U`̐e@ݒ肵܂B
 *  _GF_BSS_DATA_INFO\̂̒g𑗂܂
 *  @param   userGameInfo  [U`̐e@ւ̃|C^
 *  @param   length        [U`̐e@̃TCY
 *  @retval  none
 */
//==============================================================================
static void _setUserGameInfo( void )
{
    u8 macBuff[6];
    MYSTATUS* pMyStatus;
    _GF_BSS_DATA_INFO* pGF;
    _GF_BSS_MYSTERY* pMist;
    int serviceNo = CommStateGetServiceNo();

    pMyStatus = CommMPGetMyStatus();
    if(serviceNo != COMM_MODE_MYSTERY){
        pGF = (_GF_BSS_DATA_INFO*)_pCommMP->gameInfoBuff;

        GF_ASSERT(COMM_SEND_REGULATION_SIZE >= Regulation_GetWorkSize());  // regulation\傫
        GF_ASSERT(COMM_SEND_MYSTATUS_SIZE == MyStatus_GetWorkSize());  // mystatus\傫
        GF_ASSERT(WM_SIZE_USER_GAMEINFO >= _BEACON_SIZE_MAX);  // bconTCYGFr[R傫

        MI_CpuCopy8( pMyStatus, pGF->myStatusBuff, MyStatus_GetWorkSize());
        MI_CpuCopy8( _pCommMP->pRegulation,pGF->regulationBuff, Regulation_GetWorkSize());
        pGF->pokeID = MyStatus_GetID(pMyStatus);
        pGF->serviceNo = CommStateGetServiceNo();
        pGF->regulationNo = CommStateGetRegulationNo();
        // ȈՉb
        MI_CpuCopy8( &_pCommMP->pmsData, &pGF->pmsData, sizeof(PMS_DATA));
#ifdef PM_DEBUG		//DebugROM
        pGF->soloDebugNo = CommStateGetSoloDebugNo();
#endif
        pGF->pause = WHGetParentConnectPause();
    }
    else{
        pMist = (_GF_BSS_MYSTERY*)_pCommMP->gameInfoBuff;

        pMist->pokeID = MyStatus_GetID(pMyStatus);
        pMist->serviceNo = CommStateGetServiceNo();
        pMist->regulationNo = CommStateGetRegulationNo();
#ifdef PM_DEBUG		//DebugROM
        pMist->soloDebugNo = CommStateGetSoloDebugNo();
#endif
        MI_CpuCopy8(_pCommMP->mysteryData, pMist->mysteryData, MYSTERY_BEACON_DATA_SIZE);
    }
    DC_FlushRange(_pCommMP->gameInfoBuff, _BEACON_SIZE_MAX);
    WH_SetUserGameInfo(_pCommMP->gameInfoBuff, _BEACON_SIZE_MAX);
}


//==============================================================================
/**
 *  [U`̐e@ lĎɍXV
 *  _GF_BSS_DATA_INFO\̂̒g𑗂܂
 *  @param   none
 *  @retval  none
 */
//==============================================================================
static void _funcBconDataChange( void )
{
    _GF_BSS_DATA_INFO* pGF = (_GF_BSS_DATA_INFO*)_pCommMP->gameInfoBuff;

    if(_connectNum() != pGF->connectNum){
        pGF->connectNum = _connectNum();
        DC_FlushRange(_pCommMP->gameInfoBuff, _BEACON_SIZE_MAX);
        WH_SetUserGameInfo(_pCommMP->gameInfoBuff, _BEACON_SIZE_MAX);
        WHSetGameInfo(_pCommMP->gameInfoBuff, _BEACON_SIZE_MAX,
                      _pCommMP->ggid,_sTgid);
    }
}

//==============================================================================
/**
 * ʐMCu[̏ԂāA֐
 * VBlankƂ͊֌WȂ̂process̎ɏ΂
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _stateProcess(u16 bitmap)
{
    int state = WH_GetSystemState();
    CommInfoFunc();
    _funcBconDataChange();      // r[R̒g
    if((WH_GetCurrentAid() == COMM_PARENT_ID) && (!CommMPIsChildsConnecting())){
        if(_pCommMP->bErrorNoChild){
            _pCommMP->bErrorState = TRUE;   ///< G[NĂꍇ̏Ԃ܂
//            OHNO_PRINT("G[ NOCHILD \n");
        }
    }
    if(_pCommMP->errCheckBitmap == _NOT_INIT_BITMAP){
        _pCommMP->errCheckBitmap = bitmap;  // ̂Ƃ̐ڑlێ
    }
    if(_pCommMP->bErrorDisconnectOther){ // G[s
        if(_pCommMP->errCheckBitmap > bitmap){  // ؒfꍇK 镪ɂOK
            _pCommMP->bErrorState = TRUE;   ///< G[NĂꍇ̏Ԃ܂
//            OHNO_PRINT("G[ N \n");
        }
    }
    if(WH_ERRCODE_FATAL == WH_GetLastError()){
        CommFatalErrorFunc(0);  // 荞ݒɉʕ\łȂ̂ňړ
    }
    switch (state) {
      case WH_SYSSTATE_STOP:
        if(_pCommMP->disconnectType == _DISCONNECT_END){
            OHNO_SP_PRINT("WHEnd ĂŏI܂\n");
            _commEnd();  // [N牽SĊJ
            return;
        }
        if(_pCommMP->disconnectType == _DISCONNECT_SECRET){
            OHNO_SP_PRINT("WHEnd ĂŎ񂾂ӂJn\n");
            _pCommMP->disconnectType = _DISCONNECT_STEALTH;
            return;
        }
        break;
      case WH_SYSSTATE_IDLE:
        if(_pCommMP->disconnectType == _DISCONNECT_END){
            if(WH_End()){
                return;
            }
        }
        if(_pCommMP->disconnectType == _DISCONNECT_SECRET){
            if(WH_End()){
                return;
            }
        }
        break;
      case WH_SYSSTATE_CONNECT_FAIL:
      case WH_SYSSTATE_ERROR:
        OHNO_PRINT("G[ %d \n",WH_GetLastError());
        if(_pCommMP){
            _pCommMP->bErrorState = TRUE;   ///< G[NĂꍇ̏Ԃ܂
        }
        break;
      case WH_SYSSTATE_MEASURECHANNEL:
        {
            u16 channel;
            // p\ȒԎgp̒Ⴂ`lԂ܂B
            channel = WH_GetMeasureChannel();  //WH_SYSSTATE_MEASURECHANNEL => WH_SYSSTATE_IDLE
            if(_pCommMP->keepChannelTime==0){
                _pCommMP->keepChannelNo = channel;
                _pCommMP->keepChannelTime = _KEEP_CHANNEL_TIME_MAX;
            }
            else{
                _pCommMP->keepChannelTime--;
            }
            channel = _pCommMP->keepChannelNo;  
            if(_pCommMP->bTGIDChange){
                _sTgid++;
            }
            _setUserGameInfo();
//            OHNO_PRINT("e@ڑJn   tgid=%d channel=%d \n",_sTgid, channel);
            (void)WH_ParentConnect(WH_CONNECTMODE_MP_PARENT,
                                   _sTgid, channel,
                                   CommLocalGetServiceMaxEntry(CommStateGetServiceNo()),
                                   _getServiceBeaconPeriod(CommStateGetServiceNo()),
                                   _pCommMP->bEntry);
            _pCommMP->channel = channel;
        }
        break;
      default:
        break;
    }

}

//==============================================================================
/**
 * ʐMCu[̏ԂāA֐
 * VBlankƂ͊֌WȂ̂process̎ɏ΂
 * q@݂͂̐ڑ킩Ȃ̂ŁAʐMʂcommsystemăG[
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommMpProcess(u16 bitmap)
{
    if(_pCommMP){
        _stateProcess(bitmap);
    }
}

//==============================================================================
/**
 * ʐM\ԂȂ̂ǂԂ
 * @param   eq@netID
 * @retval  TRUE  ʐM\    FALSE ʐMؒf
 */
//==============================================================================
static BOOL _isConnect(u16 netID)
{
    if(!_pCommMP){
        return FALSE;
    }
    if (WH_GetSystemState() != WH_SYSSTATE_CONNECTED) {
        return FALSE;
    }
    {
        u16 bitmap = WH_GetBitmap();
        if( bitmap & (1<<netID)){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * ʐM\Ԃ̐lԂ
 * @param   none
 * @retval  ڑl
 */
//==============================================================================
static int _connectNum(void)
{
    int num = 0,i;

    for(i = 0; i < COMM_MACHINE_MAX; i++){
        if(_isConnect(i)){
            num++;
        }
    }
    return num;
}

//==============================================================================
/**
 * ʐMؒf[hɂ͂ǂ
 * @param   none
 * @retval  ڑl
 */
//==============================================================================

BOOL CommMPIsConnectStalth(void)
{
    if(_pCommMP && (_pCommMP->disconnectType == _DISCONNECT_STEALTH)){
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * Ă邩ǂԂ
 * @param   none
 * @retval  IĂTRUE
 */
//==============================================================================
BOOL CommMPIsInitialize(void)
{
    return (_pCommMP!=NULL);
}

//==============================================================================
/**
 * WHCuŁ@ԂIDLEɂȂĂ邩mF
 * @param   none
 * @retval  IDLEɂȂĂ=TRUE
 */
//==============================================================================

BOOL CommMPIsStateIdle(void)
{
    if(_pCommMP){
        return WH_IsSysStateIdle();
    }
    return TRUE;
}


//==============================================================================
/**
 * WHCuŁ@ʐMԂBITmF  q@ȂĂ邩ǂ
 * @param   none
 * @retval  ȂTRUE
 */
//==============================================================================

BOOL CommMPIsChildsConnecting(void)
{
    if(_pCommMP){
        return( WH_GetBitmap() & 0xfffe);
    }
    return FALSE;
}

//==============================================================================
/**
 * e@ǂ
 * @param   none
 * @retval  ꍇTRUE
 */
//==============================================================================

BOOL CommMPParentDisconnect(void)
{
    if(CommMPIsError() && ( WH_ERRCODE_DISCONNECTED == WH_GetLastError())){
        return TRUE;
    }
    return FALSE;
}


//==============================================================================
/**
 * G[Ԃǂ
 * @param   none
 * @retval  G[̎TRUE
 */
//==============================================================================

BOOL CommMPIsError(void)
{
    if(_pCommMP){
        if(_pCommMP->bErrorState){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * q@Ȃ̂G[ɂ邩ǂSET
 * @param   bOn  LTRUE
 * @retval  none
 */
//==============================================================================

void CommMPSetNoChildError(BOOL bOn)
{
    if(_pCommMP){
        _pCommMP->bErrorNoChild = bOn;
    }
}

//==============================================================================
/**
 * N̂G[ɂ邩ǂSET
 * @param   bOn  LTRUE
 * @retval  none
 */
//==============================================================================

void CommMPSetDisconnectOtherError(BOOL bOn)
{
    if(_pCommMP){
        _pCommMP->bErrorDisconnectOther = bOn;
        _pCommMP->errCheckBitmap = _NOT_INIT_BITMAP;
    }
}

//==============================================================================
/**
 * T[rXԍɑΉr[RԊu𓾂܂
 * T[rXԍ include/communication/comm_def.hɂ܂
 * @param   serviceNo T[rXԍ
 * @retval  beaconԊu msec
 */
//==============================================================================

u16 _getServiceBeaconPeriod(u16 serviceNo)
{
    u16 beaconPeriod = WM_GetDispersionBeaconPeriod();
    GF_ASSERT_RETURN(serviceNo < COMM_MODE_MAX, beaconPeriod);

    if(COMM_MODE_UNDERGROUND == serviceNo){
        return beaconPeriod/4;
    }
    if((COMM_MODE_UNION == serviceNo) ||
       (COMM_MODE_PICTURE == serviceNo)){
        return (beaconPeriod / 4);
    }
    return beaconPeriod;
}

//==============================================================================
/**
 * r[Rf[^𓾂
 * @param   index r[Robt@ɑ΂index
 * @retval   WMBssDesc*  r[Robt@|C^
 */
//==============================================================================

WMBssDesc* CommMPGetWMBssDesc(int index)
{
    if(_pCommMP && (_pCommMP->bconUnCatchTime[index]!=0)){
        return &_pCommMP->sBssDesc[index];
    }
    return NULL;
}

//==============================================================================
/**
 * GFr[Rf[^𓾂
 * @param   index r[Robt@ɑ΂index
 * @retval   GF_BSS_DATA_INFO*  r[Robt@|C^
 */
//==============================================================================

_GF_BSS_DATA_INFO* CommMPGetGFBss(int index)
{
    if(_pCommMP && (_pCommMP->bconUnCatchTime[index]!=0)){
        return (_GF_BSS_DATA_INFO*)_pCommMP->sBssDesc[index].gameInfo.userGameInfo;
    }
    return NULL;
}

//==============================================================================
/**
 * r[Rf[^
 * @param    index r[Robt@ɑ΂index
 * @retval   none
 */
//==============================================================================

void CommMPResetWMBssDesc(int index)
{
    if(_pCommMP && (_pCommMP->bconUnCatchTime[index]!=0)){
        _pCommMP->bconUnCatchTime[index] = 0;
    }
}

//==============================================================================
/**
 * r[Rf[^
 * @param    index r[Robt@ɑ΂index
 * @retval   none
 */
//==============================================================================

void CommMPResetGFBss(int index)
{
    if(_pCommMP && (_pCommMP->bconUnCatchTime[index]!=0)){
        _pCommMP->bconUnCatchTime[index] = 0;
    }
}

//==============================================================================
/**
 * ʐMpɎMYSTATUS𓾂
 * @param    none
 * @retval   MYSTATUS*
 */
//==============================================================================

MYSTATUS* CommMPGetMyStatus(void)
{
    return _pCommMP->pMyStatus;
}

//==============================================================================
/**
 * BCONɊ܂܂MYSTATUSԂ
 * @param   index   ẽXgindex
 * @retval  MYSTATUS*
 */
//==============================================================================

MYSTATUS* CommMPGetBconMyStatus(int index)
{
    MYSTATUS* pMyStatus;
    _GF_BSS_DATA_INFO* pGF;
    
    if(_pCommMP->bconUnCatchTime[index] == 0){
        return NULL;
    }
    pGF = (_GF_BSS_DATA_INFO*)_pCommMP->sBssDesc[index].gameInfo.userGameInfo;
    pMyStatus = (MYSTATUS*)&pGF->myStatusBuff[0];
    return pMyStatus;
}

//==============================================================================
/**
 * macAhXobNAbv
 * @param   pMac   mac address
 * @retval  none
 */
//==============================================================================

void CommMPSetBackupMacAddress(u8* pMac, int netID)
{
    if(_pCommMP){
        GF_ASSERT_RETURN(netID < COMM_MACHINE_MAX,);
        MI_CpuCopy8(pMac, _pCommMP->backupBssid[netID], WM_SIZE_BSSID);
    }
}

//==============================================================================
/**
 * obNAbvMACAhXɊY邩ǂ𓾂
 * @param   pMac   mac address
 * @retval  none
 */
//==============================================================================

static BOOL _isMachBackupMacAddress(u8* pMac)
{
    int i;
    
    for(i = 0; i < COMM_MACHINE_MAX; i++){
        if(WM_IsBssidEqual(_pCommMP->backupBssid[i], pMac)){
            return TRUE;
        }
    }
    return FALSE;
}


//==============================================================================
/**
 * ؒf[hɓǂԂ
 * @param   none
 * @retval  ĂȂTRUE
 */
//==============================================================================

BOOL CommMPIsAutoExit(void)
{
    if(_pCommMP){
        return _pCommMP->bAutoExit;
    }
    return FALSE;
}

//==============================================================================
/**
 * ؒf[hON
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommMPSetAutoExit(void)
{
    if(_pCommMP){
        _pCommMP->bAutoExit = TRUE;
    }
}

//==============================================================================
/**
 * BCONPMSf[^ ̊֐CommMPFlashMyBssĂԂƂŔf
 * @param   PMS_DATA
 * @retval  none
 */
//==============================================================================

void CommMPSetMyPMS(PMS_DATA* pPMS)
{
    MI_CpuCopy8( pPMS, &_pCommMP->pmsData, sizeof(PMS_DATA));
}


//==============================================================================
/**
 * BCOÑM[Vf[^ ̊֐CommMPFlashMyBssĂԂƂŔf
 * @param   pRegulation  M[Vf[^\̂̃|C^
 * @retval  none
 */
//==============================================================================

void CommMPSetMyRegulation(void* pRegulation)
{

    MI_CpuCopy8( pRegulation,_pCommMP->pRegulation, Regulation_GetWorkSize());
}

//==============================================================================
/**
 * r[Rf[^Ɍ݂̏󋵂𔽉f
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommMPFlashMyBss(void)
{
    _setUserGameInfo();
    WHSetGameInfo(_pCommMP->gameInfoBuff, _BEACON_SIZE_MAX,
                  _pCommMP->ggid,_sTgid);
}

//==============================================================================
/**
 * Ct^C ܂͌ɖ߂
 * @param   bMinimum TRUEȂ珬
 * @retval  none
 */
//==============================================================================

void CommMPSetLifeTime(BOOL bMinimum)
{
    WHSetLifeTime(bMinimum);
}

//------------------------------------------------------
/**
 * @brief   T[rXԍ̃r[RԂ܂
 * @param   serviceNo   comm_def.hɂT[rXԍ
 * @retval  pҐ
 */
//------------------------------------------------------

int CommMPGetServiceNumber(int serviceNo)
{
    int i,num=0;
    
    for (i = 0; i < SCAN_PARENT_COUNT_MAX; i++) {
        _GF_BSS_DATA_INFO* pGF = CommMPGetGFBss(i);
        if(pGF){
            if( pGF->serviceNo == serviceNo){
                num += pGF->connectNum;
            }
        }
    }
    //
    return num;
}

//------------------------------------------------------
/**
 * @brief   e@łr[R𑗐MIǂ
 * @param   none
 * @retval  M=TRUE
 */
//------------------------------------------------------

BOOL CommMPIsParentBeaconSent(void)
{
    return HWIsParentBeaconSent();
}

//------------------------------------------------------
/**
 * @brief   XLԂǂ
 * @param   none
 * @retval  M=TRUE
 */
//------------------------------------------------------

BOOL CommMPIsChildStateScan(void)
{
    return WH_IsSysStateScan();
}

//------------------------------------------------------
/**
 * @brief   r[Rf[^ɎRɃf[^ڂ܂
 * @param   pData   f[^   COMM_SEND_REGULATION_SIZE܂ł̂܂
 * @retval  none
 */
//------------------------------------------------------

void CommMPSetBeaconTempData(void* pData)
{
    MI_CpuCopy8(pData,_pCommMP->mysteryData,MYSTERY_BEACON_DATA_SIZE);
    CommMPFlashMyBss();
}

//------------------------------------------------------
/**
 * @brief   r[Rf[^f[^o܂
 * @param   index     Ԗڂ̃r[RȂ̂
 * @retval  f[^|C^
 */
//------------------------------------------------------

const void* CommMPGetBeaconTempData(int index)
{
    if(_pCommMP && (_pCommMP->bconUnCatchTime[index]!=0)){
        _GF_BSS_MYSTERY* pMyst;
        pMyst = (_GF_BSS_MYSTERY*)_pCommMP->sBssDesc[index].gameInfo.userGameInfo;
        return pMyst->mysteryData;
    }
    return NULL;
}

//------------------------------------------------------
/**
 * @brief   `lԂ
 * @retval  ڑ`l
 */
//------------------------------------------------------

int CommMPGetChannel(void)
{
    return _pCommMP->channel;
}

//==============================================================================
/**
 * @brief	@r[RMe̎擾
 */
//==============================================================================
void * CommMPGetMyGFBss(void)
{
	if (_pCommMP == NULL) {
		return NULL;
	}
	return _pCommMP->gameInfoBuff;
}

//------------------------------------------------------
/**
 * @brief	r[REẴJEg_E^C}擾
 * @param	index	ʒu
 */
//------------------------------------------------------
int CommMPGetBConUncacheTime(int index)
{
	if (_pCommMP == NULL) {
		return 0;
	}
	return _pCommMP->bconUnCatchTime[index];
}

