//=============================================================================
/**
 * @file	comm_tool.c
 * @brief	ʐMgėp֐
 * @author	Katsumi Ohno
 * @date    2006.03.14
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "system/snd_tool.h"


//ėpf[^̂PpPbg
#define _TEMPDATA_SIZE (70)

//==============================================================================
// static錾
//==============================================================================

typedef struct _COMM_TOOL_WORK_t COMM_TOOL_WORK;


typedef struct{
    u8 no;
    u8 listNo;
}_ListResult;

typedef struct _COMM_TOOL_WORK_t{
    // Xg
    _ListResult listNo[COMM_MACHINE_MAX];     // R}hp
    u8 timingSync[COMM_MACHINE_MAX];     // R}hp
    //------------------  tempf[^pobt@
    u8 tempWork[COMM_MACHINE_MAX][_TEMPDATA_SIZE];
    u8 tempRecv[COMM_MACHINE_MAX];
    //-------------------
    u8 timingSyncEnd;     // R}hp
    u8 timingSyncMy;  // NO
    u8 timingSend;
};

static COMM_TOOL_WORK* _pCT = NULL;  ///<@[N\̂̃|C^


//==============================================================================
/**
 * 
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommToolInitialize(int heapID)
{
    int i;
    
    if(!_pCT){
        _pCT = sys_AllocMemory(heapID,sizeof(COMM_TOOL_WORK));
        MI_CpuFill8(_pCT,0,sizeof(COMM_TOOL_WORK));
    }


    for(i = 0; i< COMM_MACHINE_MAX;i++){
        _pCT->timingSync[i]=0xff;     // R}hp
    }
    _pCT->timingSyncEnd = 0xff;     // R}hp
    _pCT->timingSyncMy = 0xff;
    _pCT->timingSend = FALSE;

}

//==============================================================================
/**
 * J
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommToolFinalize(void)
{
    sys_FreeMemoryEz(_pCT);
    _pCT = NULL;
}

//==============================================================================
/**
 * mF
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

BOOL CommToolIsInitialize(void)
{
    if(_pCT){
        return TRUE;
    }
    return FALSE;
}


//==============================================================================
/**
 * ^C~OR}hM   CS_TIMING_SYNC
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommRecvTimingSync(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    u8 syncNo = pBuff[0];
    u8 sendBuff[2];
    int i;

    if(CommGetCurrentID() == COMM_PARENT_ID){
        sendBuff[0] = netID;
        sendBuff[1] = syncNo;
        CommSendFixSizeData_ServerSide(CS_TIMING_SYNC_INFO, &sendBuff);
        OHNO_PRINT("M %d %d\n",netID,syncNo);
        _pCT->timingSync[netID] = syncNo;     // R}hp
        for(i = 0; i < COMM_MACHINE_MAX; i++){
            if(CommIsConnect(i)){
                if(syncNo != _pCT->timingSync[i]){
                    // ĂȂ
                    return;
                }
            }
        }
        CommSendFixSizeData_ServerSide(CS_TIMING_SYNC_END, &syncNo);
    }
}


//==============================================================================
/**
 * ^C~OR}hINFOM   CS_TIMING_SYNC_INFO
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommRecvTimingSyncInfo(int netID, int size, void* pData, void* pWork)
{
    // q@󋵂cł悤ɃR}hĂ
    u8* pBuff = pData;
    
    _pCT->timingSync[pBuff[0]] = pBuff[1];     // R}hp
}

//==============================================================================
/**
 * ^C~OR}hENDM   CS_TIMING_SYNC_END
 * @param   callbackp
 * @retval  none
 */
//==============================================================================

void CommRecvTimingSyncEnd(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    u8 syncNo = pBuff[0];

    OHNO_PRINT("SR}hM %d %d\n", syncNo);
    _pCT->timingSyncEnd = syncNo;     // R}hp
}

//==============================================================================
/**
 * ^C~OR}h𔭍s
 * @param   no   ^C~O肽ԍ
 * @retval  none
 */
//==============================================================================

void CommTimingSyncStart(u8 no)
{
    OHNO_PRINT("R}hs %d \n",no);
    _pCT->timingSyncMy = no;
    _pCT->timingSend = TRUE;
}

//==============================================================================
/**
 * ^C~OR}h𑗐M
 * @param   no   ^C~O肽ԍ
 * @retval  none
 */
//==============================================================================


#ifdef PM_DEBUG
extern int DebugCommGetNum(int id);
static u8 _keytrg = 0;
#endif

void CommTimingSyncSend(void)
{
    if(_pCT){
        if(_pCT->timingSend){
            if(CommSendFixSizeData(CS_TIMING_SYNC, &_pCT->timingSyncMy)){
                OHNO_PRINT("R}hM %d \n",_pCT->timingSyncMy);
                _pCT->timingSend = FALSE;
            }
        }

#if 0
//#if (defined(DEBUG_ONLY_FOR_ohno) | defined(DEBUG_ONLY_FOR_tomoya_takahashi) | defined(DEBUG_ONLY_FOR_mituhara))
//#ifdef PM_DEBUG
        {
            if((sys.trg == PAD_BUTTON_B) && (_keytrg==3)){
                _keytrg = 4;
                Snd_SePlay(SEQ_SE_DP_DECIDE);
            }
            else if((sys.trg == PAD_BUTTON_B) && (_keytrg==2)){
                _keytrg = 3;
            }
            else if((sys.trg == PAD_BUTTON_R) && (_keytrg==1)){
                _keytrg = 2;
            }
            else if((sys.trg == PAD_BUTTON_L) && (_keytrg==0)){
                _keytrg = 1;
            }
            else if((sys.trg == PAD_BUTTON_START) && (_keytrg < 4)){
                _keytrg = 0;
            }

            if((sys.trg == PAD_BUTTON_L) && (_keytrg==4)){
                GF_ASSERT_MSG(0, "tim %d %d %d %d %d \n %d %d %d %d %d \n %d %d %d %d %d\n",_pCT->timingSyncMy,
                              _pCT->timingSync[0],_pCT->timingSync[1],
                              _pCT->timingSync[2],_pCT->timingSync[3],
                              DebugCommGetNum(0),DebugCommGetNum(1),DebugCommGetNum(2),
                              DebugCommGetNum(3),DebugCommGetNum(4),DebugCommGetNum(5),
                              DebugCommGetNum(6),DebugCommGetNum(7),
                              DebugCommGetNum(8),DebugCommGetNum(9),DebugCommGetNum(10));
                _keytrg = 0;
            }
        }
#endif
    }

}

//==============================================================================
/**
 * ^C~OR}h͂ǂmF
 * @param   no   ͂ԍ
 * @retval  ͂ĂTRUE
 */
//==============================================================================

BOOL CommIsTimingSync(u8 no)
{
    if(_pCT==NULL){
        return TRUE;  // ʐMĂȂꍇĂƂ݂Ȃ
    }
    if(_pCT->timingSyncEnd == no){
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * ^C~OR}h͂ǂmF
 * @param   no   ͂ԍ
 * @retval  ͂ĂTRUE
 */
//==============================================================================

int CommGetTimingSyncNo(int netID)
{
    return _pCT->timingSync[netID];
}

//------------------------------------------------------
/**
 * @brief   IʂM֐
 * @param   R[obN
 * @retval  none
 */
//------------------------------------------------------

void CommRecvListNo(int netID, int size, void* pData, void* pWork)
{
    _ListResult* pRet = pData;

    _pCT->listNo[netID].no = pRet->no;
    _pCT->listNo[netID].listNo = pRet->listNo;
}

//------------------------------------------------------
/**
 * @brief   IʂʐMR}hTCY
 * @param   no        Ij[Nԍ
 * @param   listNo    I  0-255
 * @retval  none
 */
//------------------------------------------------------

int CommGetListNoSize(void)
{
    return sizeof(_ListResult);
}

//------------------------------------------------------
/**
 * @brief   IʂʐM
 * @param   no        Ij[Nԍ
 * @param   listNo    I  0-255
 * @retval  none
 */
//------------------------------------------------------

void CommListSet(u8 no,u8 listNo)
{
    _ListResult ret;

    ret.no = no;
    ret.listNo = listNo;
    CommSendFixSizeData(CS_LIST_NO,&ret);
}

//------------------------------------------------------
/**
 * @brief   Iʂ󂯎
 * @param   recvNetID   ǂ̐l̃f[^҂󂯂̂
 * @param   pBuff       Mobt@
 * @retval  I  -1
 */
//------------------------------------------------------

int CommListGet(int netID, u8 no)
{
    if(!_pCT){
        return INVALID_LIST_NO;
    }
    if(_pCT->listNo[netID].no == no){
        return _pCT->listNo[netID].listNo;
    }
    return INVALID_LIST_NO;
}


//------------------------------------------------------
/**
 * @brief   Iʂ
 * @param   none
 * @retval  none
 */
//------------------------------------------------------

void CommListReset(void)
{
    int i;

    for(i = 0;i < COMM_MACHINE_MAX;i++){
        MI_CpuFill8(&_pCT->listNo[i], 0, sizeof(_ListResult));
    }
}

//==============================================================================
/**
 * ڑɑɑ肽f[^  10byte
 * @param   netID   id   ̗\ID
 * @param   pData   肽f[^
 * @retval  sꍇ͂O
 */
//==============================================================================

void CommToolTempDataReset(void)
{
    int i;
    for(i = 0;i < COMM_MACHINE_MAX;i++){
        _pCT->tempRecv[i] = FALSE;
    }

}

//==============================================================================
/**
 * ڑɑɑ肽f[^  10byte
 * @param   netID   id   ̗\ID
 * @param   pData   肽f[^
 * @retval  sꍇ͂O
 */
//==============================================================================

BOOL CommToolSetTempData(int netID,const void* pData)
{
    if(_pCT){
        MI_CpuCopy8(pData, _pCT->tempWork[netID], _TEMPDATA_SIZE);
        CommSendFixSizeData(CS_TOOL_TEMP, _pCT->tempWork[netID]);
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * ڑɑɑf[^𓾂  10byte
 * @param   netID   id   ̗\ID
 * @retval  sꍇ͂O
 */
//==============================================================================

const void* CommToolGetTempData(int netID)
{
    if(_pCT->tempRecv[netID]){
        return &_pCT->tempWork[netID];
    }
    return NULL;
}

//==============================================================================
/**
 * e|[f[^M
 * @param   netID   id   ̗\ID
 * @retval  sꍇ͂O
 */
//==============================================================================

void CommToolRecvTempData(int netID, int size, void* pData, void* pWork)
{
    _pCT->tempRecv[netID] = TRUE;
    MI_CpuCopy8(pData, _pCT->tempWork[netID], _TEMPDATA_SIZE);
}

//==============================================================================
/**
 * e|[f[^TCYԂ
 * @param   netID   id   ̗\ID
 * @retval  sꍇ͂O
 */
//==============================================================================

int CommToolGetTempDataSize(void)
{
    return _TEMPDATA_SIZE;
}
