//============================================================================================
/**
 * @file	comm_wifihistory.c
 * @bfief	nVo^
 * @author	Akito Mori
 * @date	06.05.02
 */
//============================================================================================

#include "common.h"
#include "communication/communication.h"
#include "communication/comm_wifihistory.h"

//==============================================================================
/**
 * $brief   nVo^
 *
 * @param   wifiHistory		
 *
 * @retval  none		
 */
//==============================================================================
void Comm_WifiHistoryCheck( WIFI_HISTORY *wifiHistory )
{
	int i;
	int Nation,Area,region;
	MYSTATUS *status;
	int num = CommGetConnectNum();

	// fobOog̎MYSTATUSĂȂ̂œo^ׂ͂ĂƂ΂悤ɂ
	if(CommInfoGetMyStatus(0)==NULL){
		return;
	}

	// ڑĂl܂킷
	for(i=0;i<num;i++){
		if(CommGetCurrentID()!=i){
			Nation = CommInfoGetMyNation(i);
			Area   = CommInfoGetMyArea(i);
			status = CommInfoGetMyStatus( i );
			region = MyStatus_GetRegionCode( status );

			// EnR[ho^i{J[gbWp`FbNj
			Comm_WifiHistoryDataSet( wifiHistory, Nation, Area, region );
		}
	}
}

//==============================================================================
/**
 * @brief   ̃J[gbW[WEEnR[hnVo^
 *
 * @param   wifiHistory		
 * @param   Nation		
 * @param   Area		
 * @param   langCode		
 *
 * @retval  none		
 */
//==============================================================================
void Comm_WifiHistoryDataSet( WIFI_HISTORY *wifiHistory, int Nation, int Area, int langCode )
{
	
#if (PM_LANG == LANG_JAPAN)
	// ̃J[gbW{Ȃ̂
	if(langCode==LANG_JAPAN){
		// Ⴄ̒nVR[hĂo^Ȃ
		if(Nation!=WIFI_NATION_JAPAN){
			return;
		}
	}
#endif
	
	// Eno^
//	OS_Printf("no=%d\n", WIFIHISTORY_GetStat(wifiHistory, Nation, Area ));
	if(WIFIHISTORY_GetStat( wifiHistory, Nation, Area )==WIFIHIST_STAT_NODATA){
		WIFIHISTORY_SetStat( wifiHistory, Nation, Area, WIFIHIST_STAT_NEW );
	}
	

}