#ifndef ___MPCONNECT_H___
#define ___MPCONNECT_H___
/**
 *
 * @file mpconnect.h
 * @brief MPʐMCu
 * 
 */
#ifdef __cplusplus
extern "C" {
#endif
  
#include    <nitro/types.h>
#include    <nitro/wm.h>
#include    <nitro/cht.h>

#ifdef PM_DEBUG
#ifndef		DEBUG_MP   
#define		DEBUG_MP	1
#endif
#else
#ifndef		DEBUG_MP   
#define		DEBUG_MP	0
#endif
#endif

#include "mpstruct.h"

  

//#define		MP_DEBUG_PRINT			1
  
/* vgo͗}_~[֐ */
#ifdef  MP_DEBUG_PRINT
#define     MpPrintf			OS_TPrintf
#else
#define     MpPrintf(...)		((void) 0)
#endif

//#define		MP_DEBUG_STATE_PRINT		1

#ifdef  MP_DEBUG_STATE_PRINT
#define     MpStatePrintf		OS_TPrintf
#else
#define     MpStatePrintf(...)		((void) 0)
#endif


#define		MP_ERROR_CODE		(0xFFFFFFFF)

#define		MP_PORT_MIN	(4)  
#define		MP_PORT_MAX	(7)  

/**
 * Cup\
 *
 * ڑIDvȂƂ͒ʐMsȂ
 */
typedef struct {
  u32 game_id		: 8;	/* Q[^CgID */
  u32 game_version	: 4;	/* Q[o[W */
  u32 language		: 4;	/* iOS_LANGUAGEj */
  u32 connect_id	: 16;	/* ڑID */
  const u16* user_id;		/* Q[ł̃vC[ID (15ȓ) */
  const u16* name;		/* Q[ł̃vC[ (15ȓ) */
} MpInitDesc;
  
    
/**
 * ʐM[h`
 */
typedef enum {
  MP_MODE_NONE = 0,
  MP_MODE_CHILD_MP,		/* MPʐMŃf[^𑗐Miq@ɂȂ^ڑ̑Ij */
  MP_MODE_PARENT_MP,		/* MPʐMŃf[^Mie@ɂȂj */
  MP_MODE_MAX
} MP_MODE;  




  
extern void MpProc(void);

  
extern BOOL MpIsConnect(void);


/**
 * f[^]\ȏԂׂ
 *
 * @return ڑTRUEԂ
 */
extern BOOL MpIsDataTrans(void);
  

/**
 * Cugpobt@TCYԂ
 *
 * @return oCg
 */
extern u32 MpGetBufferSize(void);
  
  
/**
 * Cu
 *
 * @param init_desc f[^
 * @param buff Cu̎gpobt@̃AhXw MpGetBufferSize()Ŏ擾TCŸ悪mۂĂKv
 */
extern void MpInit(MpInitDesc* init_desc, void* buff);


/**
 * e@ƂĒʐMJn
 */
extern void MpRequestParent();


/**
 * q@ƂĐe@̃XLJn
 */
extern void MpRequestScan();


/**
 * wڑԍ̐e@̃[U[ID擾
 *
 * @param num e@ԍ
 * @return Oiu16*j
 */
extern u16* MpGetParentListUserID(u32 num);

       
/**
 * wԍ̐e@Ɛڑ\ׂ
 *
 * @param e@ԍ
 * @return \ȏꍇTRUEԂ
 */
extern BOOL MpGetConnectParentEnable(u32 num);


/**
 * wԍ̐e@Ɛڑ ڑs\̏ꍇ͉Ȃ
 *
 * @param num e@ԍ
 */
extern void MpConnectParent(u32 num);


/**
 * e@Ƃ̐ڑ؂ ڑĂȂꍇ͉Ȃ
 */
extern void MpDisConnectParent(void);


/**
 * SĂ̎q@Ƃ̐ڑ؂ ڑĂȂꍇ͉Ȃ
 */
extern void MpDisConnectChild(void);

       
/**
 * ڑς݂̐e@ԍԂ ڑԂɂȂꍇMP_ERROR_CODEԂ
 *
 * @return e@ԍ
 */
extern u32 MpGetConnectParentNum(void);

  
/**
 * wڑԍ̐e@̖O擾
 *
 * @param num e@ԍ
 * @return Oiu16*j
 */
extern u16* MpGetParentListName(u32 num);


/**
 * wMACAhX̎q@ȊOƂ̐ڑ؂ ڑĂȂꍇ͉Ȃ
 *
 * @param num q@MACAhX
 */
extern void MpConnectOnlyChild(u32 num);


/**
 * wԍȊO̎q@Ƃ̐ڑ؂ ڑĂȂꍇ͉Ȃ
 *
 * @param num q@ԍ
 */
extern void MpDataTransOnlyChild(u32 num);
  
  
/**
 * Nx擾
 *
 * @return Nx
 */
extern u32 MpGetConnectLinkLevel(void);


/**
 * ڑ\ȍő吔擾
 *
 * @return ő吔
 */
extern u32 MpGetConnectListMax(void);

  
/**
 * ڑꂽԂ
 *
 * @return ڑ
 */
extern u32 MpGetConnectListNum(void);


/**
 * f[^ʐM\ȐԂ
 *
 * @return ڑ
 */
extern u32 MpGetDataTransListNum(void);
  
  
/**
 * wڑԍMACAhX擾
 *
 * @param num ڑԍ
 * @return MACAhX
 */
extern u32 MpGetListMacAddr(u32 num);
extern u32 MpGetTransMacAddr(u32 num);


/**
 * f[^̑Ms
 */
extern void MpSetSendRedy(void);
  
  
/**
 * [U[f[^̑Ms
 */
extern void MpSetSendUserData(void);

  
/**
 * f[^𑗐Ms
 *
 * @param data f[^Mobt@
 * @param size MTCY
 * @param seq_num ʐMԍ
 */
extern void MpSetSendData(void *data, u32 size, u32 seq_num);


/**
 * f[^Ms
 *
 * @param data f[^Mobt@
 * @param size MTCY
 * @param seq_num ʐMԍ
 */
extern void MpSetRecvData(void *data, u32 size, u32 seq_num);

  
/**
 * [U[f[^̎Mobt@TCYԂ
 *
 * @return oCg
 */
extern u32 MpGetUserDataSize(void);

  
/**
 * f[^̎Ms
 */
extern void MpSetRecvReady(void);


/**
 * [U[f[^̎Ms Mobt@TCYsizeof(MpUserGameInfoData)
 *
 * @param data f[^Mobt@
 */
extern void MpSetRecvUserData(void *data);

  
/**
 * Mf[^̃TCY擾
 *
 * @return MoCg
 */
extern u32 MpGetSendDataSize(void);

       
/**
 * Mf[^̃TCY擾
 *
 * @return MoCg
 */
extern u32 MpGetRecvDataSize(void);

  
/**
 * f[^MIׂ
 *
 * @return IĂꍇTRUEԂ
 */
extern BOOL MpIsSendDataEnd(void);


/**
 * f[^MIׂ
 *
 * @return IĂꍇTRUEԂ
 */
extern BOOL MpIsRecvDataEnd(void);
extern BOOL MpIsRecvDataAcknowledge(void);


/**
 * ڑĂԂׂ
 *
 * @return ڑTRUEԂ
 */
extern BOOL MpIsConnect(void);


/**
 * Cu~v
 */
extern void MpRequestClose(void);


/**
 * Cu~ׂ
 *
 * @return ~ԂɂȂꍇTRUEԂ
 */
extern BOOL MpIsEnd(void);
  
  
#ifdef  __cplusplus
}       /* extern "C" */
#endif

#endif // ___TWL_H___
