/**
 *
 * @file twl_data.c
 * @brief ʐMCu f[^QƊ֐
 * 
 */
#include "mpconfig.h"
#include "mpdata.h"
#include "mpdebug.h"

#if 0
#include "../data/message/message_def.h"
#include "../data/message/wordtbl_def.h"
#endif

static MpInternalData MpData;

#define     DEFAULT_CHAN            1


__attribute__ ((aligned (32))) static WMParentParam MpDefaultParameter = {
  NULL, 0, 0,
  MP_GGID,			/* Q[O[vID */
  0x0000,                       /* temporary ID */
  1,				/* Gg[tO */
  MP_CONNECT_CHILD_MAX,		/* őڑq@ */
  0,                            /* }`u[gtO */
  0,                            /* L[VFAO */
  0,                            /* AMtO */
  MP_DEFAULT_BEACON_PERIOD,	/* beacon Ԋu */
  {0, 0, 0, 0},			/* rdv1 */
  {0, 0, 0, 0, 0, 0, 0, 0},	/* rsv2 */
  0,				/* ڑ`l */
  MP_PARENT_DATA_SIZE,		/* e@Mf[^TCY */
  MP_CHILD_DATA_SIZE		/* q@Mf[^TCY */
};


/**
 * CuŕێWMParentParamԂ
 *
 * @return WMParentParam
 */
WMParentParam *MpGetParentParameter(void) { return &MpDefaultParameter; }


u32 MpGetConnectChildMax(void) { return (u32)MpDefaultParameter.maxEntry; }
void MpSetConnectChildMax(u32 num) { MpDefaultParameter.maxEntry = (u16)num; }



/**
 * Ŏgpf[^Ԃ
 *
 * @return TWL_InternalData
 */
MpInternalData *MpGetInternalData(void)
{
  return &MpData;
}


/**
 * Xe[^XԂ
 *
 * @return MP_STATUS
 */
MP_STATUS MpGetStatus(void) { return (MP_STATUS)MpGetInternalData()->status; }


/**
 * Xe[^Xݒ肷
 *
 * @param status TWL_STATUS 
 */
void MpSetStatus(MP_STATUS status) { MpGetInternalData()->status = (u8)status; }


/**
 * vXe[^XԂ
 *
 * @return MP_STATUS
 */
MP_STATUS MpGetRequestStatus(void) { return (MP_STATUS)MpGetInternalData()->request_status; }


/**
 * vXe[^Xݒ肷
 *
 * @param status TWL_STATUS 
 */
void MpSetRequestStatus(MP_STATUS status) { MpGetInternalData()->request_status = (u8)status; }


/**
 * ʐM[hԂ
 *
 * @return MP_MODE
 */
MP_MODE MpGetMode(void) { return (MP_MODE)MpGetInternalData()->mode; }


/**
 * ʐM[hݒ肷
 *
 * @param mode MP_MODE
 */
void MpSetMode(MP_MODE mode) { MpGetInternalData()->mode = (u8)mode; }


/**
 * ʐM|[gԂ
 *
 * @return port 
 */
u32 MpGetPort(void) { return (u32)MpGetInternalData()->port; }


/**
 * ʐM|[gݒ肷
 *
 * @param port 
 */
void MpSetPort(u32 port) { MpGetInternalData()->port = (u8)port; }


/**
 * ʐM`lԂ
 *
 * @return channel 
 */
u32 MpGetChannel(void) { return (u32)MpGetParentParameter()->channel; }


/**
 * ʐM`lݒ肷
 *
 * @param channel 
 */
void MpSetChannel(u32 channel) { MpGetParentParameter()->channel= (u16)channel; }


/**
 * WMScanParam擾
 *
 * @return WMScanParam
 */
WMScanParam *MpGetScanParameter(void)
{
  return MpGetInternalData()->scan_parameter;
}


/**
 * Mobt@TCYԂ
 *
 * @return obt@TCY
 */
u32 MpGetSendBuffSize(void) { return MpGetInternalData()->send_buff_size; }


/**
 * Mobt@TCYԂ
 *
 * @return obt@TCY
 */
u32 MpGetRecvBuffSize(void) { return MpGetInternalData()->recv_buff_size; }


/**
 * Mobt@̃AhXԂ
 *
 * @return obt@̃AhX
 */
void *MpGetSendBuff(void) { return MpGetInternalData()->send_buff; }


/**
 * Mobt@̃AhXԂ
 *
 * @return obt@̃AhX
 */
void *MpGetRecvBuff(void) {  return MpGetInternalData()->recv_buff; }


/**
 * WMBssDesc̃AhXԂ
 *
 * @return AhX
 */
WMBssDesc *MpGetBssDesc(void) { return MpGetInternalData()->bss_desc; }


/**
 * AIDL^
 *
 * @param aid AID
 */
void MpSetAid(u16 aid) { MpGetInternalData()->aid = aid; }


/**
 * AIDԂ
 *
 * @return AID
 */
u16 MpGetAid(void) { return MpGetInternalData()->aid; }



BOOL MpIsConnectFlag(void) { return MpGetInternalData()->connect_flag; }
void MpSetIsConnectFlag(BOOL flag) { MpGetInternalData()->connect_flag = flag; }
void MpSetDisconnectTrigger(BOOL flag) { MpGetInternalData()->disconnect_trigger = flag; }
BOOL MpGetDisconnectTrigger(void) { return MpGetInternalData()->disconnect_trigger; }


void MpSetIsEnd(BOOL flag) { MpGetInternalData()->is_end_flag = flag; }


/**
 * [hʃf[^̃AhXԂ
 */
MpModeData *MpGetModeData(void) { return &MpGetInternalData()->mode_data; }


/**
 * q@ԗpf[^̃AhXԂ
 */
MpDataChildMP *MpGetDataChildMP(void) { return &MpGetModeData()->child_mp; }


/**
 * e@ԗpf[^̃AhXԂ
 */
MpDataParentMP *MpGetDataParentMP(void) { return &MpGetModeData()->parent_mp; }


/**
 * MpDataChildMP
 */
void MpInitDataChildMP(void)
{
  MpDataChildMP *dcmp = MpGetDataChildMP();

  /* S0NA */
  MI_CpuClear8(dcmp, sizeof(MpDataChildMP));

  dcmp->time_count = 280;
}


/**
 * MpDataParentMP
 */
void MpInitDataParentMP(void)
{
  MpDataParentMP *dpmp = MpGetDataParentMP();

  /* S0NA */
  MI_CpuClear8(dpmp, sizeof(MpDataParentMP));
}


/**
 * MpTransDataԂ
 */
MpTransData *MpGetTransData(void) { return &MpGetInternalData()->trans_data; }


/**
 * MpTransData
 */
void MpInitTransData(void)
{
  MpTransData *trans_data = MpGetTransData();
  trans_data->mode = MP_TRANS_MODE_NONE;
}


/**
 * GGIDԂ
 */
u32 MpGetGameID(void) { return MpGetInternalData()->ggid; }


/**
 *
 */
u16 MpGetFramePeriod(void) { return MpGetInternalData()->frame_period; }


/**
 * vgRIDԂ
 */
u32 MpGetProtocolID(void)
{
  return (u32)MpGetInternalData()->user_game_info.header.data0.protocol_id;
}

/**
 * vgRo[WԂ
 */
u32 MpGetProtocolVersion(void)
{
  return (u32)MpGetInternalData()->user_game_info.header.data0.protocol_version;
}


/**
 * ڑIDԂ
 */
u32 MpGetConnectID(void)
{
  return (u32)MpGetInternalData()->user_game_info.header.data1.connect_id;
}


/**
 * UserGameInfõTCYԂ
 *
 * @return UserGameInfõTCY
 */
u32 MpGetUserGameInfoSize(void)
{
  return sizeof(MpUserGameInfo);
}


/**
 * MpUserGameInfoԂ
 *
 * @return MpUserGameInfõAhX
 */
MpUserGameInfo *MpGetUserGameInfo(void)
{
  return &MpGetInternalData()->user_game_info;
}


/**
 * MpSsidDataԂ
 *
 * @return MpSsidDatãAhX
 */
MpSsidData *MpGetSsidData(void)
{
  return &MpGetInternalData()->ssid_data;
}


/**
 * MACAhXi[z񂩂MpMACAddData𐶐
 *
 * @param mac_arry MACAhXz
 * @return@MpMACAddData
 */
MpMACAddData MpMACAddArrayToMACAddData(u8 *mac_arry)
{
  u32 i;
  MpMACAddData mac_bss;
  
  mac_bss.u.data32 = 0;
  for (i=0; i<MP_SIZE_MAC_DATA; i++) mac_bss.u.data[i] = mac_arry[i + 2];    

  return mac_bss;
}


/**
 * MACAhXi[z񂩂MpMACVendorData𐶐
 *
 * @param mac_arry MACAhXz
 * @return@MpMACVendorData
 */
MpMACVendorData MpMACAddArrayToMACVendorData(u8 *mac_arry)
{
  u32 i;
  MpMACVendorData mac_bss;
  
  mac_bss.u.data16 = 0;
  for (i=0; i<MP_SIZE_MAC_VENDOR_DATA; i++) mac_bss.u.data[i] = mac_arry[i];    

  return mac_bss;
}


/**
 * u32MACAhXڑID𐶐
 *
 * @param mac_addr MACAhX
 * @param high_code [U[R[hʂi[
 * @param low_code [U[R[hʂi[
 */
void MpMACAddressToConnectCode(u32 mac_addr, u32 *high_code, u32* low_code)
{
  *high_code = mac_addr % 10000;
  *low_code = (mac_addr / 10000) % 10000;
}


/**
 * u32MACAhXڑID𕶎ƂĐ
 *
 * @param mac_addr MACAhX
 * @return obt@̃|C^
 */
const u16* MpConnectCodeToString(u32 mac_addr)
{
#if 0
  static u16 string_buff[4+4+2];
  const int num0 = n0_;
  const int hyphen = bou_;
  const int endcode = EOM_;
  int code_count = 0;
  u32 hc,lc;

  MpMACAddressToConnectCode(mac_addr, &hc, &lc);

  //OS_Printf("HightCode %d LowCode %d\n", hc, lc);
  
  string_buff[code_count++] = (u16)((hc / 1000) + num0);
  hc %= 1000;
  string_buff[code_count++] = (u16)((hc / 100) + num0);
  hc %= 100;
  string_buff[code_count++] = (u16)((hc / 10) + num0);
  hc %= 10;
  string_buff[code_count++] = (u16)(hc + num0);

  string_buff[code_count++] = (u16)hyphen;

  string_buff[code_count++] = (u16)((lc / 1000) + num0);
  lc %= 1000;
  string_buff[code_count++] = (u16)((lc / 100) + num0);
  lc %= 100;
  string_buff[code_count++] = (u16)((lc / 10) + num0);
  lc %= 10;
  string_buff[code_count++] = (u16)(lc + num0);

  string_buff[code_count] = (u16)endcode;
  
  return string_buff;
#else
  return (u16 *)NULL;
#endif
}


#if 0
/**
 * ʉʂꂼ̃[U[R[hu32MACAhX𐶐
 *
 * @param high_code [U[R[h
 * @param low_code [U[R[h
 * @return MACAhX
 */
u32 MpUserCodeToMACAddress(u32 high_code, u32 low_code)
{
  return high_code + low_code * 10000;
}
#endif

/**
 * Mf[^̃wb_TCY擾 i݌Œj
 *
 * @return oCg
 */
u32 MpGetSendHeaderSize(void)
{
  return sizeof(MpSendHeader);
}


/**
 * pseedl擾
 *
 * @return seedl
 */
static u32 MpGetSeed()
{
  return  ((u32)(OS_GetTick() + GX_GetVCount()) & 0xFFFFFFFE) + 1;
}


/**
 * ^s
 *
 * @param seed V[h
 * @param size R[ḧ̃TCY
 * @param data R[ḧ̃AhX
 */
static u32 MpEncodeData(u32 seed, u32 size, void* data)
{
  u32 i;
  u32 *target = (u32*)data;
  MATHRandContext16 cont;
  
  MATH_InitRand16(&cont, seed);
  
  for (i=0; i<size/sizeof(u32); i++) {
    (*target) ^= ((MATH_Rand16(&cont, 0) << 16) | MATH_Rand16(&cont, 0));
    target++;
  }

  return cont.x;
}


/**
 * Mpf[^𐶐
 *
 * @param buff f[^𐶐AhX
 * @param data Mpf[^
 * @param data_size Mpf[^̃TCY
 * @param control_code ʐMR[h
 */
void MpSetupSendData(void *buff, void *data, u32 data_size, MP_CONTROL_CODE control_code, u32 seq_num)
{
  MpSendHeader *header = (MpSendHeader *)buff;
  MpUserGameInfo *info = MpGetUserGameInfo();

  header->data0.protocol_id      = info->header.data0.protocol_id;
  header->data0.protocol_version = info->header.data0.protocol_version;
  header->data0.encode_type      = info->header.data0.encode_type;
  header->data0.encode_data      = (u16)MpGetSeed();

  header->data1.game_id          = info->header.data1.game_id;
  header->data1.game_version     = info->header.data1.game_version;
  header->data1.language         = info->header.data1.language;
  header->data1.game_etc         = 0;

  header->data2.sequence_num     = (u8)seq_num;
  header->data2.control_code     = control_code;
  header->data2.crc              = SVC_GetCRC16(0, data, data_size);

  header->data3.header_size      = (u8)MpGetSendHeaderSize();
  header->data3.data_size        = data_size;

  if (data_size)
    MI_CpuCopy8(data, ((u8*)buff) + header->data3.header_size, data_size);

  MpPrintSendHeader(header);	
  
  if ((MP_ENCODE_TYPE)info->header.data0.encode_type == MP_ENCODE_TYPE_TYCHO)
    MpEncodeData(header->data0.encode_data,
		 data_size + header->data3.header_size - sizeof(MpSendHeader0),
		 &header->data1);
  
}


/**
 * Mf[^𕜍
 *
 * @param buff Mf[^
 */
void MpDecodeRecvData(void *buff)
{
  MpSendHeader *header = (MpSendHeader *)buff;
  MpUserGameInfo *info = MpGetUserGameInfo();

  if ((MP_ENCODE_TYPE)header->data0.encode_type == MP_ENCODE_TYPE_TYCHO) {
    u32 seed;

    MpPrintf("MpDecodeRecvData() buff %x  encode seed %d\n", buff, header->data0.encode_data);
    
    /* wb_^f[^TCY擾邽߂MpSendHeader1MpSendHeader3܂ł𕜍 */
    seed = MpEncodeData(header->data0.encode_data,
			sizeof(MpSendHeader1) + sizeof(MpSendHeader2) + sizeof(MpSendHeader3),
			&header->data1);

    MpPrintf("\t header size %d  data size %d\n", header->data3.header_size, header->data3.data_size);

    /* c̃f[^𕜍 */
    MpEncodeData(seed,
		 header->data3.header_size + header->data3.data_size - sizeof(MpSendHeader),
		 (void*)((u32)buff + sizeof(MpSendHeader)));
    
  }
}


/**
 * Mf[^CRC`FbN
 *
 * @return buff Mf[^
 */
BOOL MpCheckRecvData(void *buff)
{
  MpSendHeader *header = (MpSendHeader *)buff;

  u16 crc_val = SVC_GetCRC16(0, ((u8*)buff) + header->data3.header_size, header->data3.data_size);

  if (header->data2.crc == crc_val) return TRUE;
  else return FALSE;
    
}



//
