#ifndef ___MPSTRUCT_H___
#define ___MPSTRUCT_H___
/**
 *
 * @file mpstruct.h
 * @brief MPʐMCu f[^`
 * 
 */
#include "mpconfig.h"
 

#ifdef __cplusplus
extern "C" {
#endif

/* vgRID */
#define		MP_PROTOCOL_ID			(0x0F)

/* vgRo[W */  
#define		MP_PROTOCOL_VERSION		(0x01)
  

#define		MP_RECV_READY_SEND_NUM		(3)
#define		MP_RECV_ACKNOWLEDGE_SEND_NUM	(4)

  
/*  */  
typedef enum {
  MP_ENCODE_TYPE_NONE = 0,
  MP_ENCODE_TYPE_TYCHO,  
  MP_ENCODE_TYPE_NINTENDO_CRYPT,  
  MP_ENCODE_TYPE_END  
} MP_ENCODE_TYPE;

/* ʐMR[h */ 
typedef enum {
  MP_CONTROL_CODE_ACKNOWLEDGE,		/* M */
  MP_CONTROL_CODE_RETRY,		/* đv */
  MP_CONTROL_CODE_DATA_CONTINUALLY,	/* f[^p */
  MP_CONTROL_CODE_DATA_END,		/* f[^I */
  MP_CONTROL_CODE_END
} MP_CONTROL_CODE;  

/* ]f[^wb_0 Ȃ */  
typedef struct {
  u32 protocol_id	: 8;	/* vgRԍ */
  u32 protocol_version	: 4;	/* vgRo[W */
  u32 encode_type	: 4;	/*  MP_ENCODE_TYPE */
  u32 encode_data	: 16;	/* pf[^ */    
} MpSendHeader0;		/* 4byte */

/* ]f[^wb_1  */    
typedef struct {
  u32 game_id		: 8;	/* Q[^CgID */
  u32 game_version	: 4;	/* Q[o[W */
  u32 language		: 4;	/* OS_LANGUAGE */
  u32 game_etc		: 16;	/* Q[⑫ */
} MpSendHeader1;		/* 4byte */
  
/* ]f[^wb_2  */    
typedef struct {
  u32 sequence_num	: 8;	/* ʐMV[PXԍ */
  u32 control_code	: 8;	/* ʐMR[h MP_CONTROL_CODE  */
  u32 crc		: 16;	/* f[^CRC */
} MpSendHeader2;		/* 4byte */  

/* ]f[^wb_3  */    
typedef struct {
  u32 header_size	: 8;	/* wb_[TCY */
  u32 data_size		: 24;	/* f[^TCY */
} MpSendHeader3;		/* 4byte */

/* ]f[^wb_4 gpigpj*/    
typedef struct {
  u32 extend;
} MpSendHeader4;		/* 4byte */

/* ]f[^wb_ */  
typedef struct {
  MpSendHeader0 data0;
  MpSendHeader1 data1;
  MpSendHeader2 data2;
  MpSendHeader3 data3;
} MpSendHeader;			/* 16byte */

/* r[Rf[^wb_0 Ȃ */  
typedef struct {
  u32 protocol_id	: 8;	/* vgRԍ */
  u32 protocol_version	: 4;	/* vgRo[W */
  u32 encode_type	: 4;	/*  MP_ENCODE_TYPE */
  u32 encode_data	: 16;	/* pf[^ */    
} MpBeaconHeader0;		/* 4byte */
  
/* r[Rf[^wb_1 Ȃ */  
typedef struct {
  u32 game_id		: 8;	/* Q[^CgID */
  u32 game_version	: 4;	/* Q[o[W */
  u32 language		: 4;	/* OS_LANGUAGE */
  u32 connect_id	: 16;	/* ڑID */
} MpBeaconHeader1;		/* 4byte */

/* r[Rf[^wb_ */  
typedef struct {
  MpBeaconHeader0 data0;
  MpBeaconHeader1 data1;
} MpBeaconHeader;  
  

/* SSIDf[^wb_0 Ȃ */  
typedef struct {
  u32 protocol_id	: 8;	/* vgRԍ */
  u32 protocol_version	: 4;	/* vgRo[W */
  u32 encode_type	: 4;	/*  MP_ENCODE_TYPE */
  u32 encode_data	: 16;	/* pf[^ */    
} MpSsidHeader0;		/* 4byte */
  
/* SSIDf[^wb_1 Ȃ */  
typedef struct {
  u32 game_id		: 8;	/* Q[^CgID */
  u32 game_version	: 4;	/* Q[o[W */
  u32 language		: 4;	/* OS_LANGUAGE */
  u32 connect_id	: 16;	/* ڑID */
} MpSsidHeader1;		/* 4byte */

/* SSIDf[^wb_ */  
typedef struct {
  MpSsidHeader0 data0;
  MpSsidHeader1 data1;
} MpSsidHeader;			/* 8byte */

  
/* SSIDf[^ */   
typedef struct {
  MpSsidHeader header;
  u8 dummy[24-8];
} MpSsidData;			/* 24byte */
  

/* [U[i[pobt@ */  
#define MP_USERGAMEINFO_NAME_LENGTH	(12)
typedef struct {
  u16 data[MP_USERGAMEINFO_NAME_LENGTH];
} MpUserName;			/* 24byte */

/* WMbssDescɊ܂܂ڑf[^ */  
typedef struct {
  MpUserName name;		/* W[^g[i */
  MpUserName user_id;		/* W[ԍ^g[iԍ */
} MpUserGameInfoData;		/* 48byte */

/* WMbssDescf[^ */  
typedef struct {
  MpBeaconHeader	header;
  MpUserGameInfoData	data;
} MpUserGameInfo;  
  

#define	MP_SIZE_MAC_DATA	(4)	/* ʗpMACAhXTCY */
typedef struct {
  union {
    u8 data[MP_SIZE_MAC_DATA];
    u32 data32;
  } u;
} MpMACAddData;

#define	MP_SIZE_MAC_VENDOR_DATA	(2)	/* MACAhXx_IDTCY */
typedef struct {
  union {
    u8 data[MP_SIZE_MAC_VENDOR_DATA];
    u16 data16;
  } u;
} MpMACVendorData;

  
typedef enum {
  MP_TRANS_MODE_NONE,
  MP_TRANS_MODE_SEND,
  MP_TRANS_MODE_RECV,
  MP_TRANS_MODE_END
} MP_TRANS_MODE;

/* f[^]Xe[^X */
typedef enum {
  MP_TRANS_STATUS_ENABLE,	/*  */
  MP_TRANS_STATUS_WAIT,
  MP_TRANS_STATUS_SUCCESS,
  MP_TRANS_STATUS_READY,
  MP_TRANS_STATUS_END
} MP_TRANS_STATUS;
typedef struct {
  void *org_data;
  void *data;
  void *send_buff;
  void *recv_buff;
  u32 org_size;
  u32 size;
  vu8 mode;
  vu8 state;
  u8 time_out;
  u8 resend_count;
  u8 seq_num;
} MpTransData;

/* q@Xe[^X` */  
typedef enum {
  MP_CHILD_MP_STATUS_READY = 0,
  MP_CHILD_MP_STATUS_SCAN_1,		/* ŏɐe@T邽߂̃Xe[g */
  MP_CHILD_MP_STATUS_SCAN_2,		/* Ie@Ɛڑ邽߂̃Xe[g */
  MP_CHILD_MP_STATUS_MAX
} MP_CHILD_MP_STATUS;
  
/* q@ێe@ */ 
typedef struct {
  MpMACAddData	mac_addr;		/* 4byte */
  MpUserName	name;			/* 24byte */
  MpUserName	user_id;		/* 24byte */
  MpMACVendorData mac_vendor;		/* 2byte */
  u8		link_level;		/* 1byte */
  u8		data_trans_ready;	/* 1byte */
} MpDataConnectionUser;			/* 56byte */
  
/* MPʐMiq@jpf[^` */  
typedef struct {
  MpDataConnectionUser user_list[MP_SIZE_RECEIVE_MP_PARENT_LIST]; /* 56*8byte */
  u16		time_count; 
  u8		scan_retry_count;
  u8		select : 4;	/* CӂɑIe@ԍ iMP_CHILD_MP_STATUS_SCAN_2ł̃XLΏہj */
  u8		status : 4;
} MpDataChildMP;		/* 452byte */

/* e@Xe[^X` */  
typedef enum {
  MP_PARENT_MP_STATUS_READY = 0,
  MP_PARENT_MP_STATUS_SEARCH_CHANNEL,	/* ʐMɎgp`lݒXe[g */  
  MP_PARENT_MP_STATUS_WAIT_CONNECT,	/* ڑĂq@҂Xe[g */
  MP_PARENT_MP_STATUS_MAX
} MP_PARENT_MP_STATUS;

  
/* e@ێq@ */ 
typedef struct {
  MpMACAddData	mac_addr;		/* 4byte */
  MpMACVendorData mac_vendor;		/* 2byte */
  u16		aid;			/* 2byte */
  u8		data_trans_ready;	/* 1byte */
  u8		data_trans_count;	/* 1byte */
  u8		connect_flag;		/* 1byte */
  u8		dummy;			/* 1byte */
} MpDataParentConnectionUser;		/* 12byte */
  
/* MPʐMie@jpf[^` */  
typedef struct {
  MpDataParentConnectionUser user_list[MP_SIZE_RECEIVE_MP_CHILD_LIST]; /* 8*12byte */
  u8 status;
  u8 busy_ratio;
  u16 channel_bitmap;
  u8 channel;
  u8 dummy[3];
} MpDataParentMP;		/* 104byte */

typedef union {
  MpDataParentMP	parent_mp;
  MpDataChildMP		child_mp;
} MpModeData;

/* dggp̍őijl */  
#define MP_MEASURE_BUSYRATIO_MAX	(102)
  

/**
 * Xe[^X`
 */  
typedef enum {
  MP_STATUS_INIT = 0,	/*  */
  MP_STATUS_READY,	/* ҋ@ */
  MP_STATUS_STOP,	/* d */  
  MP_STATUS_IDLE,	/* ACh */  
  MP_STATUS_ERROR,	/* ǂɂȂȂG[ */
  MP_STATUS_BUSY,	/* ԑJڒɂrW[ */
  MP_STATUS_SCAN,	/* e@̃XL iq@pXe[^Xj*/
  MP_STATUS_ENDSCAN,	/* XLI iq@pXe[^Xj*/
  MP_STATUS_PARENT,	/* e@ƂĐڑςݏ */
  MP_STATUS_CHILD,	/* q@ƂĐڑςݏ */
  MP_STATUS_PARENT_MP,	/* e@ƂMPʐM */
  MP_STATUS_CHILD_MP,	/* q@ƂMPʐM */
  MP_STATUS_END,	/* CuI */
  MP_STATUS_MAX
} MP_STATUS;
  

/**
 * ʐMV[PXԍ`
 */  
typedef enum {
  MP_SEQUENCE_APP = 0,		/* AvP[VRɎgpłl */
  MP_SEQUENCE_APP_END	= 0xF0,	/* AvP[VRɎgpłl̍Ō */  
  MP_SEQUENCE_READY	= 0xFD,	/* f[^MV[PX */
  MP_SEQUENCE_USER_DATA	= 0xFE,	/* [U|f[^MV[PX */
  MP_SEQUENCE_END
} MP_SEQUENCE;

  
typedef struct {

  /* ݂̃Xe[^X */
  u8 status;

  /* ύXvXe[^X */
  u8 request_status;
  
  /* ʐM[h */
  u8 mode;

  /* ʐM|[g */
  u8 port;
  
  /* GameID */
  u32 ggid;
  
  /* ڕWXe[^X */
  MP_STATUS target;

  /* AID */
  u16 aid;
  
  /* Q[t[Ԋu */
  u16 frame_period;

  /* IndicationʒmpR[obNݒς݃tO */
  BOOL indication_callback_flag;     

  BOOL connect_flag;
  BOOL disconnect_trigger;
  
  BOOL request_end_flag;
  BOOL is_end_flag;
    
  
  WMScanParam* scan_parameter;
  WMBssDesc* bss_desc;
  
  u32 send_buff_size;
  u32 recv_buff_size;

  void *lib_buff;
  void *send_buff;
  void *recv_buff;

  MpUserGameInfo user_game_info;
  MpSsidData ssid_data;
  
  MpModeData mode_data;
  MpTransData trans_data;
  
} MpInternalData; 
  

  
  
#ifdef  __cplusplus
}       /* extern "C" */
#endif

#endif // ___MPSTRUCT_H___
