/*
  Project:  NitroSDK - wireless_shared - demos - wh
  File:     wh.h

  Copyright 2003-2005 Nintendo.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  Revision 1.19  2005/04/26 02:35:02  terui
  Fix comment

  Revision 1.18  2005/03/25 03:05:28  seiki_masashi
  WEPKey ݒ֐ݒ肷 WH_Set{Parent,Child}WEPKeyGenerator ǉ

  Revision 1.17  2005/03/04 09:18:56  takano_makoto
  WH_SetUserGameInfoǉ

  Revision 1.16  2005/02/28 05:26:35  yosizaki
  do-indent.

  Revision 1.15  2004/12/22 02:49:08  terui
  sNg`bgT[`ɑΉ

  Revision 1.14  2004/12/20 08:31:27  takano_makoto
  WH_InitializegpďZk悤ɕύXB

  Revision 1.13  2004/12/20 07:17:20  takano_makoto
  WHReceiverWHReceiverFuncɕύXAOS_Allocgp̂rAAvɐݒ肷p[^wh_config.hƂĕ

  Revision 1.12  2004/11/16 03:01:11  takano_makoto
  WH_GetCurrentAid֐ǉ

  Revision 1.11  2004/11/08 02:46:17  takano_makoto
  WM_EndScan̑dĂіh~

  Revision 1.10  2004/11/05 04:27:40  sasakis
  r[ʁAe@Iʂ̒ǉƁAɕKvȉiscan֘AȂǁjB

  Revision 1.9  2004/11/02 19:36:19  takano_makoto
  WH_StartMeasureChannel, WH_EndScan̕ԂlBOOLɕύX

  Revision 1.8  2004/11/01 09:38:14  seiki_masashi
  WH_DS_DATA_SIZE  14  12 ɕύX
  Rg̏C

  Revision 1.7  2004/11/01 09:16:47  takano_makoto
  WH֐̕Ԃľ^ύXAWH_SYSSTATE_FATALԂǉ

  Revision 1.6  2004/10/29 02:16:34  takano_makoto
  WH_StartScan̈ύX

  Revision 1.4  2004/10/28 07:11:20  takano_makoto
  WH_Connect̊֐ύX

  Revision 1.3  2004/10/27 02:31:31  takano_makoto
  MeasureChanneln֐̓
  WM_ERRCODE_OPERATINGő҂ׂWM_ERRCODE_SUCCESSŔ肵ĂsC
  ̑s̏C

  Revision 1.2  2004/10/25 02:29:54  seiki_masashi
  eqő呗MTCY WH_CHILD_MAX 𔽉f
  eqő呗MTCY WH_{PARENT,CHILD}_MAX_SIZE ɓ
  Rg̒

  Revision 1.1  2004/10/21 00:41:50  yosizaki
  Initial upload.

 */

/*
  Log : (from multiboot-model)
  Revision 1.6  2004/09/30 08:28:14  yosizaki
  add SDK_MAKEGGID_SYSTEM macro.

  Revision 1.5  2004/09/30 03:58:40  takano_makoto
  WH_SYSSTATE_CONNECT_FAILǉ

  Revision 1.4  2004/09/27 08:34:38  takano_makoto
  WH_ChildConnect, WH_InitializẽC^[tFCXύX

  Revision 1.3  2004/09/17 14:12:45  takano_makoto
  ڑq@̔胋[`ǉ.

  Revision 1.2  2004/09/17 10:29:47  takano_makoto
  WH_PARENT_MAX_SIZE, WH_CHILD_MAX_SIZE`

  Revision 1.1  2004/09/16 14:07:11  takano_makoto
  Initial Update
*/

/*
  Revision 1.15  2004/10/06 05:11:35  sasakis
  Ot\̒ǉȂǁB

  Revision 1.14  2004/10/05 09:21:57  seiki_masashi
  WH_SendData  callback w肷悤ύX
  萔̕ϊ֐ɃG[`FbNǉ

  Revision 1.13  2004/10/01 01:58:54  seiki_masashi
  ʏ MP ʐM֌W̊֐߂܂

  Revision 1.12  2004/09/30 08:46:48  seiki_masashi
  GGID ɊUꂽȒlݒ

  Revision 1.11  2004/09/30 06:26:49  seiki_masashi
  ꎞIɒʏ MP ʐM֌W̊֐폜

  Revision 1.10  2004/09/30 06:20:03  seiki_masashi
  CfgύX

  Revision 1.9  2004/09/30 06:16:38  seiki_masashi
  ŐV SDK ̎dlɏ悤ύX

  Revision 1.8  2004/09/24 09:43:35  sasakis
  ׂoOtBbNXB

  Revision 1.7  2004/09/24 06:12:35  sasakis
  `l蓮I@\ǉB

  Revision 1.6  2004/09/22 09:39:33  sasakis
  foOʂǉB

  Revision 1.5  2004/09/15 10:23:40  sasakis
  dgMxACR̒ǉƁAf[^TCYω̂߂̉ȂǁB

  Revision 1.4  2004/09/10 08:44:52  sasakis
  KChC̒ǉAG[֌W̌ȂǁB

  Revision 1.3  2004/09/08 08:55:35  sasakis
  ؒfXB

  Revision 1.2  2004/09/08 01:52:52  sasakis
  G[Eؒf֌WǁB

  Revision 1.1  2004/09/07 04:59:42  sasakis
  œo^B
*/


#ifndef __WMHIGH_H__
#define __WMHIGH_H__

#include "wh_config.h"

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/10
// GGID ̒` include/communication/ggid.h Ɉړ
#include "communication/ggid.h"
// ----------------------------------------------------------------------------


// WM_InitializegpďꍇOFF
// WM_Init, WM_Enable, WM_PowerOnʂɎgpčׂ䂷KvꍇɂONɐݒ肷B
// #define WH_USE_DETAILED_INITIALIZE

enum
{
    WH_SYSSTATE_STOP,                  // 
    WH_SYSSTATE_IDLE,                  // ҋ@
    WH_SYSSTATE_SCANNING,              // XL
    WH_SYSSTATE_BUSY,                  // ڑƒ
    WH_SYSSTATE_CONNECTED,             // ڑȉԂŒʐM\j
    WH_SYSSTATE_DATASHARING,           // data-sharingLŐڑ
    WH_SYSSTATE_KEYSHARING,            // key-sharingLŐڑ
    WH_SYSSTATE_MEASURECHANNEL,        // `l̓dggp`FbN
    WH_SYSSTATE_CONNECT_FAIL,          // e@ւ̐ڑs
    WH_SYSSTATE_ERROR,                 // G[
    WH_SYSSTATE_FATAL,                 // FATALG[
    WH_SYSSTATE_NUM
};

enum
{
    WH_CONNECTMODE_MP_PARENT,          // e@ MP ڑ[h
    WH_CONNECTMODE_MP_CHILD,           // q@ MP ڑ[h
    WH_CONNECTMODE_KS_PARENT,          // e@ key-sharing ڑ[h
    WH_CONNECTMODE_KS_CHILD,           // q@ key-sharing ڑ[h
    WH_CONNECTMODE_DS_PARENT,          // e@ data-sharing ڑ[h
    WH_CONNECTMODE_DS_CHILD,           // q@ data-sharing ڑ[h
    WH_CONNECTMODE_NUM
};

enum
{
    // ÕG[R[h
    WH_ERRCODE_DISCONNECTED = WM_ERRCODE_MAX,   // eؒfꂽ
    WH_ERRCODE_PARENT_NOT_FOUND,       // eȂ
    WH_ERRCODE_NO_RADIO,               // gps
    WH_ERRCODE_LOST_PARENT,            // e
    WH_ERRCODE_NOMORE_CHANNEL,         // ׂẴ`l̒I
    WH_ERRCODE_FATAL,
    WH_ERRCODE_MAX
};

typedef void (*WHStartScanCallbackFunc) (WMBssDesc *bssDesc);

/* ڑ, ܂͐e@ȂԂrbg}bvl */
#define WH_BITMAP_EMPTY           1

// MR[obN^ (for data-sharing model)
typedef void (*WHSendCallbackFunc) (BOOL result);

// ڑ֐^ (for multiboot model)
typedef BOOL (*WHJudgeAcceptFunc) (WMStartParentCallback *);

// ggidXLR[obN
typedef void (*fGGIDCallBack) (u32 ggid, int serviceNo);

// MR[obN^
typedef void (*WHReceiverFunc) (u16 aid, u16 *data, u16 size);

// WEP Key ֐
typedef u16 (*WHParentWEPKeyGeneratorFunc) (u16* wepkey, const WMParentParam* parentParam);
typedef u16 (*WHChildWEPKeyGeneratorFunc) (u16* wepkey, const WMBssDesc* bssDesc);


typedef void (*WHdisconnectCallBack) (int aid);

extern void HWSetDisconnectCallBack(WHdisconnectCallBack callBack);

// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if T1657_060818_FIX
extern void HWSetConnectCallBack(WHdisconnectCallBack callBack);
#endif
// ----------------------------------------------------------------------------
/**************************************************************************
 * ȉ́AWH ̊eݒlύX֐łB
 **************************************************************************/

/*---------------------------------------------------------------------------*
  Name:         WH_SetGgid

  Description:  Q[O[vIDݒ肵܂B
                e@̐ڑOɌĂяo܂B

  Arguments:    ggid    ݒ肷Q[O[vID.

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern void WH_SetGgid(u32 ggid);

/*---------------------------------------------------------------------------*
  Name:         WH_SetUserGameInfo

  Description:  [U`̐e@ݒ肵܂B
                e@̐ڑOɌĂяo܂B

  Arguments:    userGameInfo  [U`̐e@ւ̃|C^
                length        [U`̐e@̃TCY

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern void WH_SetUserGameInfo( u16* userGameInfo, u16 length );

/*---------------------------------------------------------------------------*
  Name:         WH_SetDebugOutput

  Description:  fobOo͗p̊֐ݒ肵܂B

  Arguments:    func    ݒ肷fobOo͗p̊֐.

  Returns:      None.
 *---------------------------------------------------------------------------*/
void WH_SetDebugOutput(void (*func) (const char *, ...));

/*---------------------------------------------------------------------------*
  Name:         WH_SetParentWEPKeyGenerator

  Description:  WEP Key 𐶐֐ݒ肵܂B
                ̊֐ĂяoƁAڑ̔F؂ WEP g܂B
                Q[AvP[VƂ̃ASY
                ڑOɐeqœ̒lݒ肵܂B
                ̊֐͐e@płB

  Arguments:    func    WEP Key 𐶐֐ւ̃|C^
                        NULL w肷 WEP Key gpȂ

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern void WH_SetParentWEPKeyGenerator(WHParentWEPKeyGeneratorFunc func);

/*---------------------------------------------------------------------------*
  Name:         WH_SetChildWEPKeyGenerator

  Description:  WEP Key 𐶐֐ݒ肵܂B
                ̊֐ĂяoƁAڑ̔F؂ WEP g܂B
                Q[AvP[VƂ̃ASY
                ڑOɐeqœ̒lݒ肵܂B
                ̊֐͎q@płB

  Arguments:    func    WEP Key 𐶐֐ւ̃|C^
                        NULL w肷 WEP Key gpȂ

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern void WH_SetChildWEPKeyGenerator(WHChildWEPKeyGeneratorFunc func);


/**************************************************************************
 * ȉ́A჌C WM CȕԂ擾郉bp[֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
  Name:        WH_GetLinkLevel
  Description: dg̎Mx擾܂B
  Arguments:   none.
  Returns:     WMLinkLevel ̐lԂ܂B
  ---------------------------------------------------------------------- */
extern int WH_GetLinkLevel(void);

/* ----------------------------------------------------------------------
   Name:        WH_GetAllowedChannel
   Description: ڑɎgpo`l̃rbgp^[擾܂B
   Arguments:   none.
   Returns:     channel pattern
   ---------------------------------------------------------------------- */
extern u16 WH_GetAllowedChannel(void);


/**************************************************************************
 * ȉ́AWH ̏Ԃ擾֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
   Name:        WH_GetBitmap
   Description: ڑԂrbgp^[擾܂B
   Arguments:   none.
   Returns:     bitmap pattern
   ---------------------------------------------------------------------- */
extern u16 WH_GetBitmap(void);

/* ----------------------------------------------------------------------
   Name:        WH_GetSystemState
   Description: WH ̓Ԃ擾܂B
   Arguments:   none.
   Returns:     ԁiWH_SYSSTATE_XXXXjB
   ---------------------------------------------------------------------- */
extern int WH_GetSystemState(void);

/* ----------------------------------------------------------------------
   Name:        WH_GetConnectMode
   Description: ڑ擾܂B
   Arguments:   none.
   Returns:     ڑiWH_CONNECTMODE_XX_XXXXjB
   ---------------------------------------------------------------------- */
extern int WH_GetConnectMode(void);

/* ----------------------------------------------------------------------
   Name:        WH_GetLastError
   Description: łŋ߂ɋNG[̃R[h擾܂B
   Arguments:   none.
   Returns:     G[R[hB
   ---------------------------------------------------------------------- */
extern int WH_GetLastError(void);

/*---------------------------------------------------------------------------*
  Name:         WH_PrintBssDesc

  Description:  WMBssDesc \̂̃ofobOo͂B

  Arguments:    info    fobOo͂BssDescւ̃|C^.

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern void WH_PrintBssDesc(WMBssDesc *info);


/**************************************************************************
 * ȉ́A`lɊւ鏈s֐łB
 **************************************************************************/

/*---------------------------------------------------------------------------*
  Name:         WH_StartMeasureChannel

  Description:  gp\ȑS`lœdggp̒Jn܂B
                ƁAgpŒ̃`lŌvZ
                Ԃ WH_SYSSTATE_MEASURECHANNEL Ɉڍs܂B

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern BOOL WH_StartMeasureChannel(void);

/*---------------------------------------------------------------------------*
  Name:         WH_GetMeasureChannel

  Description:  p\ȒԎgp̒Ⴂ`lԂ܂B
                WH_MeasureChannel̓삪WH_SYSSTATE_MEASURECHANNEL
                ɂȂĂKv܂B
                ̊֐R[ƈԎgp̒Ⴂ`lԂ
                WH_SYSSTATE_IDLEԂɑJڂ܂B
                
  Arguments:    None.

  Returns:      Ƃgp̒Ⴂp\ȃ`lԍ.
 *---------------------------------------------------------------------------*/
extern u16 WH_GetMeasureChannel(void);


/**************************************************************************
 * ȉ́AĒʐM\Ԃ܂őJڂ֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
   Name:        WH_Initialize
   Description: ƂsAV[PXJn܂B
   Arguments:   None.
   Returns:     V[PXJnɐΐ^B
   ---------------------------------------------------------------------- */
extern BOOL WH_Initialize(void* pHeap);
/* ----------------------------------------------------------------------
   q[v̈TCYԂ
   ---------------------------------------------------------------------- */
extern int WH_GetHeapSize(void);

/*---------------------------------------------------------------------------*
  Name:         WH_TurnOnPictoCatch

  Description:  sNg`bgT[`@\LɂB
                WH_StartScanɂăXLɁAsNg`bg𔭌ꍇɂ
                R[obN֐Ă΂悤ɂȂB

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern void WH_TurnOnPictoCatch(void);

/*---------------------------------------------------------------------------*
  Name:         WH_TurnOffPictoCatch

  Description:  sNg`bgT[`@\𖳌ɂB
                WH_StartScanɂăXLɁAsNg`bg𔭌ꍇł
                悤ɂȂB

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern void WH_TurnOffPictoCatch(void);

/*---------------------------------------------------------------------------*
  Name:         WH_StartScan

  Description:  e@̃r[R擾֐

  Arguments:    callback - e@ɕԂR[obNݒ肷B
                
                macAddr  - ڑe@MACAhXw
                           0xFFFFFFȂ΂ׂĂ̐e@B
                           
                channel  - e`lw
                           0Ȃ΂ׂẴ`lB

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern BOOL WH_StartScan(WHStartScanCallbackFunc callback, const u8 *macAddr, u16 channel);


/*---------------------------------------------------------------------------*
  Name:         WH_EndScan

  Description:  e@̃r[R擾֐

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern BOOL WH_EndScan(void);

/* ----------------------------------------------------------------------
  Name:        WH_ParentConnect
  Description: ڑV[PXJn܂B
  Arguments:   mode    - WH_CONNECTMODE_MP_PARENT Ȃΐe@ƂMPJnB
                         WH_CONNECTMODE_DS_PARENT Ȃΐe@ƂDataSharingJnB
                         WH_CONNECTMODE_KS_PARENT Ȃΐe@ƂKeySharingJnB
               tgid    - e@ʐMtgid
               channel - e@ʐMchannel
               maxEntry - őtq@
               beaconPeriod - r[RԊu T[rXɂĎw肷
  Returns:     ڑV[PXJnɐΐ^B
  ---------------------------------------------------------------------- */
extern BOOL WH_ParentConnect(int mode, u16 tgid, u16 channel,u16 maxEntry, u16 beaconPeriod,BOOL bEntry);

/* ----------------------------------------------------------------------
  Name:        WH_ChildConnect
  Description: ڑV[PXJn܂B
  Arguments:   mode -    WH_CONNECTMODE_MP_CHILD ȂΎq@ƂMPJnB
                         WH_CONNECTMODE_DS_CHILD ȂΎq@ƂDataSharingJnB
                         WH_CONNECTMODE_KS_CHILD ȂΎq@ƂKeySharingJnB
               bssDesc - ڑe@bssDesc
               
  Returns:     ڑV[PXJnɐΐ^B
  ---------------------------------------------------------------------- */
extern BOOL WH_ChildConnect(int mode, WMBssDesc *bssDesc);

/* ----------------------------------------------------------------------
   Name:        WH_ChildConnectAuto
   Description: q@ڑV[PXJn܂B
                AWH_ParentConnect  WH_ChildConnect Ŏw肷
                eݒ̎ɔC܂B
   Arguments:   mode    - WH_CONNECTMODE_MP_CHILD ȂΎq@ƂMPJnB
                          WH_CONNECTMODE_DS_CHILD ȂΎq@ƂDataSharingJnB
                          WH_CONNECTMODE_KS_CHILD ȂΎq@ƂKeySharingJnB

                macAddr - ڑe@MACAhXw
                          0xFFFFFFȂ΂ׂĂ̐e@B
                          
                channel - e`lw
                          0Ȃ΂ׂẴ`lB

  Returns:     ڑV[PXJnɐΐ^B
   ---------------------------------------------------------------------- */
extern BOOL WH_ChildConnectAuto(int mode, const u8 *macAddr, u16 channel);

/*---------------------------------------------------------------------------*
  Name:         WH_SetJudgeAcceptFunc

  Description:  q@̐ڑ󂯓𔻒肷邽߂̊֐Zbg܂B

  Arguments:    q@̐ڑ֐ݒ.

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern void WH_SetJudgeAcceptFunc(WHJudgeAcceptFunc func);


/**************************************************************************
 * ȉ́AWH_DATA_PORT |[ggp钼ړI MP ʐM̊֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
   Name:        WH_SetReceiver
   Description: WH_DATA_PORT |[gɃf[^MR[obNݒ肵܂B
   Arguments:   proc - f[^MR[obN
                port   f[^M|[g
   Returns:     none.
   ---------------------------------------------------------------------- */
extern void WH_SetReceiver(WHReceiverFunc proc, int port);

/* ----------------------------------------------------------------------
   Name:        WH_SendData
   Description: WH_DATA_PORT |[gɃf[^MJn܂B
               iMPʐMpBf[^VFAOȂǂɌĂԕKv͂܂j
   Arguments:   size - f[^TCY
   Returns:     MJnɐΐ^B
   ---------------------------------------------------------------------- */
extern BOOL WH_SendData(void *data, u16 datasize, int port, WHSendCallbackFunc callback);


/**************************************************************************
 * ȉ́Af[^VFAOʐM𐧌䂷֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
   Name:        WH_GetKeySet
   Description: LL[f[^ǂݏo܂B
   Arguments:   keyset - f[^i[w
   Returns:     ΐ^B
   ---------------------------------------------------------------------- */
extern BOOL WH_GetKeySet(WMKeySet *keyset);

/* ----------------------------------------------------------------------
   Name:        WH_GetSharedDataAdr
  Description: w aid }V瓾f[^̃AhX
                Lf[^̃AhXvZ擾܂B
   Arguments:   aid - }V̎w
   Returns:     s NULL B
   ---------------------------------------------------------------------- */
extern u16 *WH_GetSharedDataAdr(u16 aid);

/* ----------------------------------------------------------------------
   Name:        WH_StepDS
   Description: f[^VFAO̓1i߂܂B
                t[ʐMȂÅ֐t[ĂԕKv
                ܂B
   Arguments:   data - Mf[^
   Returns:     ΐ^B
   ---------------------------------------------------------------------- */
extern BOOL WH_StepDS(void *data);


/**************************************************************************
 * ȉ́AʐMIďԂ܂őJڂ֐łB
 **************************************************************************/

/* ----------------------------------------------------------------------
   Name:        WH_Reset
   Description: ZbgV[PXJn܂B
                ̊֐ĂԂƁȀԂɍ\킸Zbg܂B
        G[̋ApłB
   Arguments:   none.
   Returns:     Jnɐΐ^B
   ---------------------------------------------------------------------- */
extern void WH_Reset(void);

/* ----------------------------------------------------------------------
   Name:        WH_Finalize
   Description: ㏈EIV[PXJn܂B
                ̊֐ĂԂƁȀԂēK؂ȏIV[PX
                s܂B
                ʏ̏Iɂ́iWH_Resetł͂Ȃj̊֐gp܂B
   Arguments:   None.
   Returns:     None.
   ---------------------------------------------------------------------- */
extern void WH_Finalize(void);

/*---------------------------------------------------------------------------*
  Name:         WH_End

  Description:  ʐMIB

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
extern BOOL WH_End(void);

/*---------------------------------------------------------------------------*
  Name:         WH_GetCurrentAid

  Description:  ݂̎AID擾܂B
                q@͐ڑEؒfɕω\܂B

  Arguments:    None.

  Returns:      AID̒l
 *---------------------------------------------------------------------------*/
extern u16 WH_GetCurrentAid(void);

/*---------------------------------------------------------------------------*
  Name:         WH_IsSysStateIdle
  Description:  AChԂɂȂ̂mF
                ̏Ԃɐiނ̂ŁÅmF̂߂ɕKv  k.ohnoǉ
  Arguments:    none
  Returns:      WH_SYSSTATE_IDLEȂTRUE
 *---------------------------------------------------------------------------*/
extern BOOL WH_IsSysStateIdle(void);
extern BOOL WH_IsSysStateBusy(void);
extern BOOL WH_IsSysStateScan(void);

extern void WHSetGameInfo(void* pBuff, int size, int ggid, int tgid);

extern BOOL WHSetEntry(BOOL bEnable);

extern BOOL WHIsSetEntryEnd(void);

extern void WHSetLifeTime(BOOL bMinimum);

extern BOOL HWIsParentBeaconSent(void);

extern void WH_ParentDataInit(void);

extern void WH_SetMaxEntry(int maxEntry);

extern BOOL WH_IsSysStateError(void);

/*---------------------------------------------------------------------------*
  Name:         WHSetGGIDScanCallback
  Description:  GGIDׂ̃R[obNZbg
  Arguments:    R[obN
  Returns:      none
 *---------------------------------------------------------------------------*/

extern void WHSetGGIDScanCallback(fGGIDCallBack callback);

extern void WHParentConnectPause(BOOL bPause);

/*---------------------------------------------------------------------------*
  Name:         WHChildConnectPause
  Description:  e@ɓĂ̂ؒf
  Arguments:    R[obN
  Returns:      none
 *---------------------------------------------------------------------------*/
extern void WHChildConnectPause(BOOL bPause);
extern BOOL WHGetParentConnectPause(void);

/*---------------------------------------------------------------------------*
  Name:         WHParentConnectPauseSystem  VXep
  Description:  e@ɂڑ~߂ ͉
  Arguments:    ~߂ ͉
  Returns:      none
 *---------------------------------------------------------------------------*/

extern void WHParentConnectPauseSystem(BOOL bPause);

#endif
