//==============================================================================
/**
 * @file	actin.h
 * @brief	Z͕̃wb_
 * @author	matsuda
 * @date	2005.11.16()
 */
//==============================================================================
#ifndef __ACTIN_H__
#define __ACTIN_H__

#include "system/procsys.h"
#include "battle/battle_common.h"
#include "system/buflen.h"
#include "contest/contest.h"
#include "system/softsprite.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/gra_tool.h"
#include "system/wordset.h"

#include "contest/actin_ex.h"
#include "contest_order.h"

#include "adv_tool.h"
#include "actin_param.h"
#include "actin_snd_def.h"


//==============================================================================
//	萔`
//==============================================================================
///I^[
#define ACTIN_END_TURN		(4)

///Tuʂ̃T[tF[Xʒu(FX32)
#define ACTIN_SUB_ACTOR_DISTANCE	(BATTLE_SUB_ACTOR_DISTANCE)
///Tuʂ̃T[tF[Xʒu(int)
#define ACTIN_SUB_ACTOR_DISTANCE_INTEGER	(ACTIN_SUB_ACTOR_DISTANCE >> FX32_SHIFT)

///As[ACR1|Cg
#define APPEAL_ICON_ONE_POINT		(10)
///As[ɏoAAs[|CgACR̐(AN^[)
#define APPEAL_POINT_ICON_MAX		(6)
///As[|CgACR̕\T邩(2Tڂ̓n[gAj̎pႤ)
#define APPEAL_POINT_ICON_LOOP		(4)

///{e[Wtő吔
#define VOLTAGE_MAX			(5)
///{e[WP̃|Cg
#define VOLTAGE_ONE_POINT	(10)
///{e[Wő吔t̃|Cg
#define VOLTAGE_POINT_FULL	(VOLTAGE_ONE_POINT * VOLTAGE_MAX)
///{e[WőɒBɉZAPl(R)
#define VOLTAGE_FULL_ADD_AP_SPECIAL		(APPEAL_ICON_ONE_POINT * 8)
///{e[WőɒBɉZAPl(ʂ̐R)
#define VOLTAGE_FULL_ADD_AP				(APPEAL_ICON_ONE_POINT * 5)

///ZGtFNgɏɏoĂ|P̐
#define ACTIN_WAZA_POKEMAX		(2)		//Zo|P{UΏۂƂȂ铧|P

///ϋq̊̃{[Wl
#define ACTIN_AUDIENCE_VOLUME			(70)

///|PʒuX
#define ACTIN_POKEPOS_X		(CONTEST_ATTACK_POKE_X)
///|PʒuY
#define ACTIN_POKEPOS_Y		(CONTEST_ATTACK_POKE_Y)
///|PʒuZ
#define ACTIN_POKEPOS_Z		(CONTEST_ATTACK_POKE_Z)

///|PoʒuX
#define ACTIN_POKEPOS_APPEAR_X	(ACTIN_POKEPOS_X + 40)
///|PoʒuY
#define ACTIN_POKEPOS_APPEAR_Y	(ACTIN_POKEPOS_Y + 60)

///|PINÕEFCg
#define ACTIN_POKEMOVE_IN_BEFORE_WAIT		(10)

///|PIN鎞Aʒu܂łɂړt[
#define ACTIN_POKEMOVE_IN_FRAME	(7)	//(10)
///|PIN鎞̈ړxX(8rbg)
#define ACTIN_POKEMOVE_IN_X		(((ACTIN_POKEPOS_APPEAR_X - ACTIN_POKEPOS_X) << 8) \
									/ ACTIN_POKEMOVE_IN_FRAME)
///|PIN鎞̈ړxY(8rbg)
#define ACTIN_POKEMOVE_IN_Y		(((ACTIN_POKEPOS_APPEAR_Y - ACTIN_POKEPOS_Y) << 8) \
									/ ACTIN_POKEMOVE_IN_FRAME)

///|POUT鎞Aʒu܂łɂړt[
#define ACTIN_POKEMOVE_OUT_FRAME	(7)	//(10)
///|POUT鎞̈ړxX(8rbg)
#define ACTIN_POKEMOVE_OUT_X		(((ACTIN_POKEPOS_APPEAR_X - ACTIN_POKEPOS_X) << 8) \
									/ ACTIN_POKEMOVE_OUT_FRAME)
///|POUT鎞̈ړxY(8rbg)
#define ACTIN_POKEMOVE_OUT_Y		(((ACTIN_POKEPOS_APPEAR_Y - ACTIN_POKEPOS_Y) << 8) \
									/ ACTIN_POKEMOVE_OUT_FRAME)

///u[_[pl1X(LP)
#define BREEDER_PANEL_X_LEN			(10)
///u[_[pl1Y(LP)
#define BREEDER_PANEL_Y_LEN			(6)
///u[_[pl̍XN[ʒu(LN^P)
#define BREEDER_PANEL_SCREEN_START_POS	(0)//(32*32 + 22)

///Z͕僁CʂŎgptHgOAM̍ő吔
#define ACTIN_FONTOAM_MAX_MAIN		(2 * BREEDER_MAX)	//(u[_[{jbNl[)Ql

//--------------------------------------------------------------
//	obt@
//--------------------------------------------------------------
///obt@̃TCY
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/29
// 񂪂͂ݏôŁAobt@TCY{3{Ɋg
#define ACTIN_MESSAGE_BUF_SIZE	(3*160)		///<błPUO
// ----------------------------------------------------------------------------

///Mpobt@TCY
#define TRANSMIT_BUF_SIZE		(512)
///Mpobt@TCY
#define RECEIVE_BUF_SIZE		(TRANSMIT_BUF_SIZE)

//--------------------------------------------------------------
//	bZ[W^O
//--------------------------------------------------------------
///bZ[W^O
enum{
	ATAG_NONE,		///<^OȂ
	ATAG_NOW,		///<݉Z̃|P(jbNl[)
	
	ATAG_MINE,		///<̃jbNl[
	ATAG_ENEMY,		///<G̃jbNl[
	ATAG_WAZA,		///<Z
	ATAG_NUM,		///<1l
	ATAG_JUDGE,		///<R
	
	ATAG_MINE_ENEMY,
	ATAG_MINE_WAZA,
	ATAG_MINE_NUM,
	ATAG_MINE_JUDGE,
	
	ATAG_ENEMY_MINE,
	ATAG_ENEMY_WAZA,
	ATAG_ENEMY_NUM,
	ATAG_ENEMY_JUDGE,
	
	ATAG_WAZA_MINE,
	ATAG_WAZA_ENEMY,
	ATAG_WAZA_NUM,
	ATAG_WAZA_JUDGE,
	
	ATAG_NUM_MINE,
	ATAG_NUM_ENEMY,
	ATAG_NUM_WAZA,
	ATAG_NUM_JUDGE,

	ATAG_JUDGE_MINE,
	ATAG_JUDGE_ENEMY,
	ATAG_JUDGE_WAZA,
	ATAG_JUDGE_NUM,
	
	ATAG_MINE_JUDGE_WAZA,
	
	//R[h
	ATAG_EXCODE_JUDGESUFFER,	///<R[hFR
	
	ATAG_MAX,
};

///bZ[WIDȂ
#define AMSG_ID_NONE		(0xffff)

//--------------------------------------------------------------
//	t[ԍ
//--------------------------------------------------------------
///EBhEEplʂ̃t[
#define ACTIN_FRAME_WIN				(GF_BGL_FRAME1_M)
///GtFNgʂ̃t[
#define ACTIN_FRAME_EFF				(GF_BGL_FRAME2_M)
///ϋq(wi)ʂ̃t[
#define ACTIN_FRAME_AUDIENCE		(GF_BGL_FRAME3_M)

///u[_[plʂ̃t[
#define ACTIN_FRAME_BRDPANEL		(ACTIN_FRAME_EFF)

///EBhEEplʂ̕WXN[WX
#define FRAME_WIN_DEFAULT_X			(0)//(256 + 22*8)
///EBhEEplʂ̕WXN[WY
#define FRAME_WIN_DEFAULT_Y			(0)

///GtFNgʂBG^Cv
enum{
	EFF_BG_TYPE_BRDPANEL,		///<u[_[pl
	EFF_BG_TYPE_EFFECT,			///<ZGtFNgp
};

//--------------------------------------------------------------
//	BMPEBhE
//--------------------------------------------------------------
enum{
	ACTIN_BMPWIN_TALK,		///<bEBhE
#if 0	//u[_[OBJŏo悤ɂ̂łȂȂ 2006.02.02()
	ACTIN_BMPWIN_BREEDER_0,	///<u[_[1̖
	ACTIN_BMPWIN_BREEDER_1,	///<u[_[2̖
	ACTIN_BMPWIN_BREEDER_2,	///<u[_[3̖
	ACTIN_BMPWIN_BREEDER_3,	///<u[_[4̖
#endif

	ACTIN_BMPWIN_MAX,
};

///u[_[ɏbZ[WJ[w(Gp)
#define MSGCOLOR_BREEDERPARAM		(GF_PRINTCOLOR_MAKE(5, 6, 0))
///u[_[ɏbZ[WJ[w(p)
#define MSGCOLOR_BREEDERPARAM_MINE	(GF_PRINTCOLOR_MAKE(1, 2, 0))

//--------------------------------------------------------------
//	BGvCIeB
//--------------------------------------------------------------
///u[_[AjbNl[̃tHgAN^[BGvCIeB
#define ACTIN_BGPRI_BREEDER_PARAM	(0)
///RAN^[BGvCIeB
#define ACTIN_BGPRI_JUDGE	(3)
///As[|CgACRBGvCIeB
#define ACTINSUB_BGPRI_APPEAL_POINT		(0)
///{e[WoBGvCIeB
#define ACTIN_BGPRI_VOLTAGE_EFF			(ACTIN_BGPRI_JUDGE)
///{e[W|CgACRBGvCIeB
#define ACTINSUB_BGPRI_VOLTAGE_POINT		(ACTIN_BGPRI_JUDGE)
///ACRBGvCIeB
#define ACTINSUB_BGPRI_NEXT_ICON		(ACTIN_BGPRI_BREEDER_PARAM)
///RANVACRBGvCIeB
#define ACTIN_BGPRI_JUDGE_REACTION		(ACTIN_BGPRI_JUDGE)

//--------------------------------------------------------------
//	TuʂBGvCIeB
//--------------------------------------------------------------
///Rɂn[gBGvCIeB
#define ACTINSUB_BGPRI_HEART_JUDGE	(1)
///APln[gBGvCIeB
#define ACTINSUB_BGPRI_APP_HEART	(1)

//--------------------------------------------------------------
//	AN^[\tgvCIeB
//--------------------------------------------------------------
enum{
	ACTIN_SOFTPRI_START = 10,

	ACTIN_SOFTPRI_APPEAL_POINT,	///<As[|CgACR
	ACTIN_SOFTPRI_VOLTAGE_EFF,		///<{e[Wo
	ACTIN_SOFTPRI_VOLTAGE_POINT,	///<{e[W|CgACR
	
	ACTIN_SOFTPRI_NEXT_ICON,		///<ACR
	ACTIN_SOFTPRI_BREEDER_PARAM,	///<u[_[AjbNl[̃tHgOAM
	
	ACTIN_SOFTPRI_SPECIAL_HEART = 10000,	///<ʐRɂn[gAN^[
	ACTIN_SOFTPRI_JUDGE_REACTION,	///<RANVACR̃\tgvCIeB
	ACTIN_SOFTPRI_JUDGE_BOX,	///<R{bNX̃AN^[\tgvCIeB
	ACTIN_SOFTPRI_JUDGE,	///<RAN^[̃\tgvCIeB
};

//--------------------------------------------------------------
//	Tuʂ̃AN^[\tgvCIeB
//--------------------------------------------------------------
enum{
	ACTINSUB_SOFTPRI_START = 10,
	
	ACTINSUB_SOFTPRI_HEART_JUDGE = 1000,	///<Rɂn[g
	ACTINSUB_SOFTPRI_APP_HEART,		///<APln[g
};

//--------------------------------------------------------------
//	WFC
//--------------------------------------------------------------
///u[_[pl̃jbNl[{\WX
#define BREEDER_PANEL_NICK_X			(1)
///u[_[pl̃jbNl[{\WY
#define BREEDER_PANEL_NICK_Y			(12)
///u[_[pl̃jbNl[\W̑̃u[_[Ƌ󂯂ԊuY
#define BREEDER_PANEL_NICK_Y_SPACE		(48)
///u[_[pl̐e{\WX
#define BREEDER_PANEL_OYA_X				(BREEDER_PANEL_NICK_X)
///u[_[pl̐e{\WY
#define BREEDER_PANEL_OYA_Y				(BREEDER_PANEL_NICK_Y + 16)
///u[_[pl̐e\W̑̃u[_[Ƌ󂯂ԊuY
#define BREEDER_PANEL_OYA_Y_SPACE		(BREEDER_PANEL_NICK_Y_SPACE)

///R0̍WX
#define JUDGE_POS_X_0		(8*12)
///R0̍WY
#define JUDGE_POS_Y_0		(8*5)
///RƗׂ̐R̊Ԃ̊ԊuX
#define JUDGE_POS_X_SPACE	(4*8)
///RƗׂ̐R̊Ԃ̊ԊuY
#define JUDGE_POS_Y_SPACE	(0)

///R{bNX0̍WX
#define JUDGE_BOX_POS_X_0		(JUDGE_POS_X_0)
///R{bNX0̍WY
#define JUDGE_BOX_POS_Y_0		(8*4)
///R{bNXƗׂ̐R{bNX̊Ԃ̊ԊuX
#define JUDGE_BOX_POS_X_SPACE	(JUDGE_POS_X_SPACE)
///R{bNXƗׂ̐R{bNX̊Ԃ̊ԊuY
#define JUDGE_BOX_POS_Y_SPACE	(JUDGE_POS_Y_SPACE)

///ʐRɂn[g̍WX
#define SPECIAL_HEART_POS_X			(JUDGE_POS_X_0)
///ʐRɂn[g̍WX
#define SPECIAL_HEART_POS_Y			(7*8)
///ʐRɂn[g̍WX
#define SPECIAL_HEART_POS_X_SPACE	(JUDGE_POS_X_SPACE)

///ACR̊{WX
#define NEXT_ICON_POS_X			(8*8)
///ACR̊{WX
#define NEXT_ICON_POS_Y			(5*8 + 2)
///ACR̎̃ACR܂ł̊ԊuY
#define NEXT_ICON_POS_Y_SPACE	(6*8)

///bEBhEJo[ŎgpAN^[
#define WINCOVER_ACT_MAX			(3)

//--------------------------------------------------------------
//	WFTu
//--------------------------------------------------------------
///Rn[g̍WX
#define SUB_HEART_JUDGE_POS_X		(5 * 8)
///Rn[g̍WY
#define SUB_HEART_JUDGE_POS_Y		(0xc * 8)
///Rn[gƗׂ̐Rn[g܂ł̊ԊuX
#define SUB_HEART_JUDGE_POS_X_SPACE	(11 * 8)
///Rn[gƗׂ̐Rn[g܂ł̊ԊuY
#define SUB_HEART_JUDGE_POS_Y_SPACE	(0)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ԑtO
enum{
	AWK_SORT_NONE,			///<ԑȂ
	AWK_SORT_SPECIFY_FIRST,	///<Ԏw(ŏw)
	AWK_SORT_SPECIFY_END,	///<Ԏw(Ōw)
	AWK_SORT_RANDOM,		///<ԃ_
};

///Zʂŕ\郁bZ[W^Cv
enum{
	KOUKA_MSGID_A,
	KOUKA_MSGID_B,
	KOUKA_MSGID_C,
	KOUKA_MSGID_D,
	
	KOUKA_MSGID_SP,
};


//==============================================================================
//	\̒`
//==============================================================================
//--------------------------------------------------------------
//	bZ[W
//--------------------------------------------------------------
///Z僁bZ[Wf[^
typedef struct{
	u16 msg_id;				///<bZ[WID
	u8 msg_tag;				///<^OR[h
	u8 all_put;				///<TRUE:bZ[Wꊇ\
}ACTIN_MESSAGE_PARAM;

///bZ[W^OWJꍇAQƂp[^
typedef struct{
	u8 mine_brd;		///<MINEw肳ĂɎQƂu[_[̔ԍ
	u8 enemy_brd;		///<ENEMYw肳ĂɎQƂu[_[̔ԍ
	u16 wazano;			///<WAZAw肳ĂɎQƂZԍ
	u8 num;				///<NUMw肳Ăɕ\鐔l
	u8 judge_no;		///<JUDGEw肳ĂɎQƂR̔ԍ
}ATAG_PARAM;

//--------------------------------------------------------------
//	Z
//--------------------------------------------------------------
///ZʂɂĔlp[^
typedef struct{
	u16 wazano;				///<Zԍ
	u8 apno;				///<As[ԍ
	u8 judge_no;			///<wRԍ
	u8 base_ap;				///<{APl
	s16 effective_ap;		///<ZʂɂĔAPZl
	
	s8 voltage_add_ap;					///<{e[WɂĔAPZl
	
	u8 judge_suffer;					///<R̐l
	
	u8 str_target_no;	///<WJFZʂ̃^[QbgΏۂɂȂu[_[̔ԍ(ȊO)
	u8 str_number;		///<WJFp[^̐l
	
	ATAG_PARAM tagpara;					///<bZ[W^Op[^
	u8 msg_apno;						///<ZʃbZ[WoꍇA̋ZAPNo
	u8 msg_type;						///<ZʃbZ[W^Cv(KOUKA_MSGID_???)
	
	u8 kouka_occ;
	
	
	s16 base_calc;						///<{l̍v
	s16 app_total;						///<ŏIIȍvAPl
	s16 app_total_before;				///<vZOAP
	s16 app_total_timing_before;		///<S̋ZʔOAPl
	
	
	
	s16 my_effective_ap;				///<̋ZʂɂĔAPZl
	s16 enemy_effective_ap;				///<G̋ZʂɂĔAPZl
	u8 obstruct_apno[BREEDER_MAX];		///<WQĂu[_[̕ɖWQŽʔԍ



	//-- ʃtO --//
	u32 invalid_special:1;				///<1:ʖ
	u32 invalid_voltage_up:1;			///<1:{e[W̑
	u32 invalid_voltage_down:1;			///<1:{e[W̌
	u32 voltage_all_down:1;				///<1:S̃{e[W
	u32 next_sort:2;					///<ԑtO(AWK_SORT_???)
	u32 next_pos:2;						///<ԑ삪LȎAɏԂ
	u32 before_next_sort:2;				///<ZʔȌԑtO(AWK_SORT_???)
	u32 before_next_pos:2;				///<ZʔȌԑ삪LȎAɏԂ
	u32 twice_next_apno:8;				///<ũ^[2{vʔAʔԍ
}AWAZA_PERSONAL;

///ZʂɂĎ̃^[Ɍʂ𔭐p[^
typedef struct{
	u32 waza_repeat:16;					///<JԂoZԍ
	u32 twice_now_apno:8;					///<2{ʂ̌ʔԍ
}AWAZA_SAVE;

///ZʂɂĔp[^
typedef struct{
	AWAZA_PERSONAL personal[BREEDER_MAX];	///<lp[^
	AWAZA_SAVE save[BREEDER_MAX];			///<̃^[ɂep[^
	s8 voltage_before[JUDGE_MAX];		///<As[Õ{e[Wl
	s8 voltage_after[JUDGE_MAX];		///<As[̃{e[Wl
}AWAZA_PARAM;

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///AǏʎ擾p[N
typedef struct{
	u16 wazano[BREEDER_MAX];	///<Zԍ(!!莝̋Zʒuł͂܂!!)
	u8 judge_no[BREEDER_MAX];	///<Rԍ
}ACTIN_AI_ANSWER;

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///CV[PXŎgp郍[J[N
typedef struct{
	u16 seq;
	u16 select_seq;
	s32 work;
}ACTIN_LOCAL_WORK;

///ʏ탁bZ[W(ZʈȊO)
typedef struct{
	ATAG_PARAM a_talk_tagpara;				///<m[}bF^OWJpp[^
	ATAG_PARAM after_a_talk_tagpara;		///<m[}bF^OWJpp[^
	u8 a_talk_id;					///<m[}bID(A_TALK_???)
	u8 after_a_talk_id;				///<|CgZɍsm[}bID(A_TALK_???)

	u8 a_talk_bmpwin_close_wait;	///<bZ[W\ĂEBhE܂łwait
	u8 a_talk_bmpwin_not_close;		///<TRUE:EBhEɏI
}NORMAL_TALK;

///R胁bZ[W\Ɏgpp[^
typedef struct{
	u8 judge_no;		///ΏېRԍ
	u8 suffer_breeder[BREEDER_MAX];		///<ΏېRwĂu[_[(ԕBREEDER_MAX)
	
	u16 dummy;
	u8 dummy2;
}JUDGE_SUFFER_REVIEW;

//--------------------------------------------------------------
/**
 * @brief   Z͕isp[^(݋ZoĂ|P̐isp[^)
 */
//--------------------------------------------------------------
typedef struct{
	u8 now_breeder;					///<ݏɏoĂu[_[̔ԍ
	u8 now_pos;						///<ݏɏoĂu[_[ԖڂɃAs[Ă邩
	u8 judge_no;					///<I񂾐R̔ԍ
	u8 judge_reaction_type;			///<R̃ANV^Cv
	
	u8 judge_select_breeder[JUDGE_MAX][BREEDER_MAX];	///̐Rwu[_[No
	
//	u16 waza_no;					///<Zԍ
//	u8 now_sort[BREEDER_MAX];	///<݂̃^[̃As[(As[Ƀu[_[NoĂ)
	
	//ZʌvZ
//	s8 ap_point;			///<JoZ̊{APl
//	s8 ap_point_calc;		///<JoŽvZ̍ŏIIAPl
//	s8 voltage_now;			///<{e[WvZO̒l
//	s8 voltage_calc;		///<oZɂĕύXꂽ{e[WlAvZ̒l
//	s8 voltage_add_ap;		///<{e[WɂđAPl
//	u8 judge_suffer;		///<wRl
	
	AWAZA_PARAM wazapara;			///<ZʌvZ
//	u8 next_sort[BREEDER_MAX];		///<ԑtO(AWK_SORT_???)
//	u8 next_pos[BREEDER_MAX];		///<ԑ삪LȎAɏԂ
	
	NORMAL_TALK nt;			//ʏ탁bZ[W(ZʈȊO)
	
	union{
		JUDGE_SUFFER_REVIEW jsr;	//R胁bZ[W\Ɏgpp[^
	};
}ACTIN_ADVANCE_PARAM;

//--------------------------------------------------------------
/**
 * @brief   Z͕Q[isp[^
 *
 * ̃p[^ΑSʂč\zo邾̏񂪓Ă܂B
 * ʐM̓T[o[q@̓f[^󂯎鎖ɂȂ܂B
 * {IɃj[ʂ̉ʕÂ悤ȎȂA
 * X̎q@ŒlQƂ鎖͂Ȃ͂łB
 */
//--------------------------------------------------------------
typedef struct{
	u8 turn;						///<݂̌o߃^[
	u8 breeder_sort[BREEDER_MAX];	///<Zo(o鏇Ƀu[_[ԍĂ܂)
	u8 breeder_end_count;			///<sIu[_[̐JEg
	u16 waza_no[BREEDER_MAX];		///<݂̃^[Aeu[_[oZ
	u8 judge_no[BREEDER_MAX];		///<݂̃^[Aeu[_[IRNO
	s16 app_total[BREEDER_MAX];		///<vAPl
	s16 app_turn[BREEDER_MAX];		///<̃^[ŉ҂APl
	s8 voltage_total[JUDGE_MAX];	///<{e[Wv
	u16 waza_history[BREEDER_MAX];	///<Õ^[ŏoZ̗
	AWAZA_PARAM wazapara;			///<ZʌvZʃp[^
}ACTIN_GAME_PARAM;

//--------------------------------------------------------------
/**
 * @brief   ߑMpp[^
 * 
 * T[o[Ƃ̖߂̑MɎgp܂
 */
//--------------------------------------------------------------
typedef struct{
	u8 breeder_no;
	
	u8 buffer[255];					///<e߂Ōʂɓnf[^ςꍇAgp
}ACTIN_ORDER_PARAM;

//--------------------------------------------------------------
/**
 * @brief   Q[ʂ\邽߂ɕKvȃVXef[^ނ\
 *
 * ʐMłSẴ}VŌʂɍ쐬܂
 * eX^btߎMÃ}VXŐ̃[Nobt@nɂȂ܂
 */
//--------------------------------------------------------------
typedef struct{
	CONTEST_GAME_PARAM *c_game;		///<ReXgisp[^(tŊɒʐMς݂̃f[^ւ̃|C^BQƗp)
	
	SOFT_SPRITE_MANAGER	*soft_sprite;
	SOFT_SPRITE *ss[BREEDER_MAX];
	CATS_SYS_PTR		csp;
	CATS_RES_PTR		crp;
	WE_SYS_PTR			wsp;
	GF_BGL_INI *bgl;
	GF_BGL_BMPWIN win[ACTIN_BMPWIN_MAX];
	MSGDATA_MANAGER *actin_msg;		///<Z͕僁bZ[WpbZ[Wf[^}l[W̃|C^
	MSGDATA_MANAGER *breeder_msg;	///<u[_[bZ[Wf[^}l[W̃|C^
	MSGDATA_MANAGER *explain_msg;	///<ZbZ[Wf[^}l[W̃|C^
	MSGDATA_MANAGER *wazakouka_msg;	///<ZʃbZ[Wf[^}l[W̃|C^
	WORDSET *wordset;				///<AllocbZ[WpPobt@ւ̃|C^
	STRBUF *msg_buf;				///<Allocobt@ւ̃|C^
	PALETTE_FADE_PTR pfd;			///<pbgtF[hVXeւ̃|C^
	FONTOAM_SYS_PTR fontoam_sys;	///<tHgOAMVXeւ̃|C^

	EXCHR_PARAM exchr_param[BREEDER_MAX];		///<ZGtFNgpLWJobt@
	EXCHR_PARAM transparent_exchr_param;		///<\tgEFAXvCgp̓WJobt@
	
	CATS_ACT_PTR judge_cap[JUDGE_MAX];			///<RAN^[ւ̃|C^
	CATS_ACT_PTR judge_box_cap[JUDGE_MAX];		///<R{bNXAN^[ւ̃|C^
	CATS_ACT_PTR special_heart_cap;				///<ʐRɂn[g
	CATS_ACT_PTR appeal_point_cap[BREEDER_MAX][APPEAL_POINT_ICON_MAX];
	CATS_ACT_PTR voltage_point_cap[JUDGE_MAX][VOLTAGE_MAX];
	CATS_ACT_PTR nexticon_cap[BREEDER_MAX];			///<ACRAN^[ւ̃|C^
	CATS_ACT_PTR wincover_cap[WINCOVER_ACT_MAX];	///<bEBhEXN[̃Jo[
	CATS_ACT_PTR judge_reaction_icon_cap;		///<RANVACRAN^[
	
	ADV_FONTACT fontact_oya[BREEDER_MAX];		///<ẽtHgAN^[
	ADV_FONTACT fontact_nickname[BREEDER_MAX];	///<jbNl[̃tHgAN^[
	
	u8 talk_msg_index;				///<`惋[`̃CfbNX
}ACTIN_SYSTEM_PARAM;

//--------------------------------------------------------------
/**
 * fobOł̂ݎgp郏[N
 */
//--------------------------------------------------------------
typedef struct{
	GF_BGL_BMPWIN win;
	s16 wazano;
	u8 sub_seq;
}ACTIN_DEBUG_WORK;

//--------------------------------------------------------------
/**
 * @brief   Z͕Ǘ[N
 *
 * Z͕ŜǗ匳̃[NɂȂ܂B
 * ʐMłSẴ}VŌʂɍ쐬܂
 */
//--------------------------------------------------------------
typedef struct{
	CONTEST_SYSTEM *consys;			///<ReXgVXe[Nւ̃|C^
	TCB_PTR update_tcb;
	GF_G3DMAN *g3Dman;
	
	ACTIN_SYSTEM_PARAM sys;			///<Z͕VXef[^p[^
	ACTIN_GAME_PARAM a_game;			///<Q[isp[^
	ACTIN_ADVANCE_PARAM advance;	///<isp[^
	ACTIN_ORDER_PARAM order[BREEDER_MAX];	///<߃p[^
	
	void *aip;						///<TuʐVXe\̂ւ̃|C^
	
	u16 seq;
	u16 tbl_seq_no;					///<CV[PXe[u̔ԍ
	u8 proc_mode;					///<݂̓

	//-- Mobt@ --//
	u32 request_bit;				///<߂oĂrbg
	u8 transmit_buf[TRANSMIT_BUF_SIZE];	///<Mpobt@
	u8 receive_buf[RECEIVE_BUF_SIZE];	///<Mpobt@
	u8 transmit_flag;				///<TRUEFM҂B@FALSE:Vȃf[^Zbg\
	u8 receive_flag;				///<TRUEFf[^M
	
	CONTEST_ORDER_WORK cow;			///<M[N

	ACTIN_LOCAL_WORK local;			///<[J[N
	u8 main_end;					///<TRUE:CI
	
	u8 effect_count;				///<ėpGtFNgJE^[N
	
	u8  hensin_flag[BREEDER_MAX];	///<TRUEFϐg
	
#ifdef PM_DEBUG
	ACTIN_DEBUG_WORK debug;			///<fobOp[N
#endif
}ACTIN_PROC_WORK;


//==============================================================================
//	Of[^錾
//==============================================================================
extern const PROC_DATA ContestActinProcData;

//==============================================================================
//	O֐錾
//==============================================================================
extern PROC_RESULT ActinProc_Init( PROC * proc, int * seq );
extern PROC_RESULT ActinProc_Main( PROC * proc, int * seq );
extern PROC_RESULT ActinProc_End( PROC * proc, int * seq );
extern void ActinBG_BrdPanelSet(ACTIN_PROC_WORK *apw, int eff_bg_type, int disp_set);

//--------------------------------------------------------------
//	actin_waza.c
//--------------------------------------------------------------
extern void AWAZA_WazaParaTurnInit(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp);
extern void AWAZA_WazaParaBreederInit(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, int breeder_no);
extern void AWAZA_WazaParaBreederGameUpdate(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, int breeder_no);
extern void AWAZA_WazaParaTurnGameUpdate(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp);
extern void AWAZA_FirstMsg(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, int breeder_no);
extern void AWAZA_BaseAP(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, int breeder_no);
extern void AWAZA_Kouka(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, 
	int now_breeder, int now_breeder_pos);
extern void AWAZA_KoukaSpecial(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, 
	int now_breeder, int now_breeder_pos);
extern BOOL AWAZA_KoukaAfterTiming(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, int now_breeder, 
	int now_breeder_pos);
extern BOOL AWAZA_KoukaJudgeSufferTiming(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, int now_breeder, 
	int now_breeder_pos);
extern BOOL AWAZA_KoukaEndTiming(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, int now_breeder, 
	int now_breeder_pos);
extern void AWAZA_Voltage(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, int breeder_no, NORMAL_TALK *nt);
extern void AWAZA_JudgeSuffer(ACTIN_PROC_WORK *apw, AWAZA_PARAM *wp, int now_breeder, 
	NORMAL_TALK *nt);
extern void AWAZA_TimingBeforeAppUpdate(AWAZA_PARAM *wp);

//--------------------------------------------------------------
//	actin_ai.c
//--------------------------------------------------------------
extern void ActinAI_Main(ACTIN_PROC_WORK *apw, ACTIN_AI_ANSWER *answer);


#endif	//__ACTIN_H__

