//==============================================================================
/**
 * @file	actin_input.c
 * @brief	Z͕͉ʏ
 * @author	matsuda
 * @date	2005.12.02()
 */
//==============================================================================
#include "common.h"
#include "contest/contest.h"
#include "actin.h"
#include "actin_tcb_pri.h"
#include "battle/battle_common.h"
#include "system/clact_tool.h"
#include "system/palanm.h"

#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/softsprite.h"

#include "system/fontproc.h"
#include "system/msgdata.h"

#include "wazaeffect/battle_particle.h"
#include "system/particle.h"
#include "wazaeffect/we_mana.h"
#include "wazaeffect/we_sys.h"

#include "system/brightness.h"

#include "graphic/contest_bg_def.h"
#include "graphic/contest_obj_def.h"

#include "actin_tool.h"
#include "con_tool.h"
#include "actin_id.h"
#include "actin_input.h"
#include "battle/wazatype_panel.h"
#include "gflib/touchpanel.h"
#include "contype_icon.h"
#include "poketool/waza_tool.h"
#include "aci_tool.h"

#include "system/msgdata_util.h"
#include "system/wordset.h"
#include "system/fontoam.h"
#include "msgdata/msg_cmsg_acting.h"

#include "contest/contest_cursor.h"



//==============================================================================
//	萔`
//==============================================================================
//fobOp`FPS_MSGgpȌ`BOS_MSGΉExpandpӂ܂ł̎b菈
#define S_MSG_DEBUG		(0)

//--------------------------------------------------------------
//	bZ[W֌W
//--------------------------------------------------------------
///S_MSGŎgpԍF|PI(Z͈)̎̃|P
#define S_MSG_POKESELE_NAME		(0)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///XN[obt@ԍ
enum{
	SCRNBUF_BACKGROUND,
	SCRNBUF_TITLE,
	SCRNBUF_COMMAND_WAZA,
	SCRNBUF_COMMAND_JUDGE,
	SCRNBUF_COMMAND_BACKGROUND,
	
	SCRNBUF_MAX,
};

///XN[obt@ɑΉXN[f[^ID
///	SCRNBUFƕт𓯂ɂĂƁII
ALIGN4 static const u16 ScrnArcDataNo[] = {
	CON_SUB_BG_NSCR_BIN,
	CON_TIT_NSCR_BIN,
	CON_WAZA_BUT_NSCR_BIN,
	CON_SINSA_BUT_NSCR_BIN,
	CON_ENGI_SUB_BG_NSCR_BIN,
};


///pbgobt@ԍ
enum{
	PALBUF_TITLE,
	PALBUF_COMMAND,
	
	PALBUF_MAX,
};

///pbgobt@ɑΉXN[f[^ID
///	PALBUFƕт𓯂ɂĂƁII
ALIGN4 static const u16 PaletteArcDataNo[] = {
	CONTEST_SUB_NCLR,
	CON_ENGI_BUT_NCLR,
};

//--------------------------------------------------------------
//	[JTCBvCIeB
//--------------------------------------------------------------
#define VWAIT_TCBPRI_CGRTRANS			(10)
#define VWAIT_TCBPRI_FRAMEVISIBLE		(10)
#define VWAIT_TCBPRI_BACKSCRN_VISIBLE	(10)
#define VWAIT_TCBPRI_CGRPARAM_TRANS		(20)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///AZgpׁ̈AIoȂȂĂ鎞̃pltF[hEVY
#define NOT_TOUCH_WAZA_EVY		(8)
///AZgpׁ̈AIoȂȂĂ鎞̃pltF[hJ[
#define NOT_TOUCH_WAZA_COLOR	(0x6f39)
///AZgpׁ̈AIoȂȂĂZ1Ȃꍇ̏p[^
#define NOT_TOUCH_WAZA_POS_NULL	(0xff)

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///BGwȂ
#define NONE_ID			(0xffff)

///BGgpʐ
#define ACI_BG_NUM		(4)

///Wpbgf[^gp{
#define BASE_PLTT_NUM	(16)

///makedata_nol(gp)
#define MAKEDATA_NO_INIT	(-1)

///ReXg͉ʂŎgpoBGCGRTCY
#define ACI_BG_CGR_SIZE			(0x6000)

///BGXN[̃NAR[h
#define BG_CLEAR_CODE			(0)

///1Ώۖ
#define BLD_PLANE_1		(GX_BLEND_PLANEMASK_BG0)
///2Ώۖ
#define BLD_PLANE_2		(GX_BLEND_BGALL)
///1Ώۖʂɑ΂郿ufBOW
#define BLD_ALPHA_1		(9)
///2Ώۖʂɑ΂郿ufBOW
#define BLD_ALPHA_2		(8)

///ReXgNA^Cv\v[g̃pbgԍ
#define PLATE_PALNO		(2)

///IoȂpl̊G̃pbgԍ
#define ACI_NOT_SELECT_PANEL_PALNO		(0x8)

///R}hIʂ̃obNOEh̃pbgԍ
#define COMMAND_BACKGROUND_PALNO		(0xe)

//--------------------------------------------------------------
//	XN[XN[l
//--------------------------------------------------------------
///TYPE_ABG\Ƀ^b`plꂽYɃXN[l(GtFNg)
#define SCRN_SCROLL_A_EFF_Y				(-2)
///TYPE_ABG\Ƀ^b`plꂽYɃXN[l(GtFNg)
#define SCRN_SCROLL_BACK_A_EFF_Y		(1)

//--------------------------------------------------------------
//	^b`tF[h
//--------------------------------------------------------------
///^b`̃{^tF[hEVY
#define TOUCH_FADE_EVY		(10 << 8)
///^b`̃{^tF[hEVYZl
#define TOUCH_FADE_ADD_EVY	(TOUCH_FADE_EVY / 2)

//--------------------------------------------------------------
//	J[\
//--------------------------------------------------------------
///J[\̃AN^[\tgvCIeB
#define SOFTPRI_CURSOR				(5)
///J[\BGvCIeB
#define BGPRI_CURSOR				(0)

//--------------------------------------------------------------
//	tHgOBJ
//--------------------------------------------------------------
///tHgOBJ̕ԊuX
#define PANEL_MSG_MARGIN		(0)
///tHgOBJ̍őgpOAM
#define PANEL_MSG_MAXOAM		(8)
///tHgOBJ̃AN^[\tgvCIeB
#define PANEL_MSG_SOFTPRI		(100)
///tHgOBJBGvCIeB
#define PANEL_MSG_BGPRI			(0)

enum{
	FONTOAM_LEFT,		///<X[W
	FONTOAM_CENTER,		///<XSW
};

///tHgOBJAN^[[NŎgpŸʒu
enum{
	//WALL
	FA_NO_CONRANK = 0,				///<ReXgN
	FA_NO_CONTYPE,				///<ReXg^Cv
	
	//WAZA
	FA_NO_WAZA_1 = 0,			///<莝Z1
	FA_NO_WAZA_2,				///<莝Z2
	FA_NO_WAZA_3,				///<莝Z3
	FA_NO_WAZA_4,				///<莝Z4
	FA_NO_SETUMEI_1_U,			///<Z1̐i
	FA_NO_SETUMEI_2_U,			///<Z1̐i
	FA_NO_SETUMEI_3_U,			///<Z1̐i
	FA_NO_SETUMEI_4_U,			///<Z1̐i
	FA_NO_SETUMEI_1_D,			///<Z2̐i
	FA_NO_SETUMEI_2_D,			///<Z2̐i
	FA_NO_SETUMEI_3_D,			///<Z2̐i
	FA_NO_SETUMEI_4_D,			///<Z2̐i
	
	//JUDGE
	FA_NO_JUDGE_1 = 0,
	FA_NO_JUDGE_2,
	FA_NO_JUDGE_3,
	FA_NO_JUDGE_MODORU,
	
	FA_NO_MAX = FA_NO_SETUMEI_4_D + 1,		///<tHgOBJxɏoő吔
};

///ZtHgOBJ̕\W
ALIGN4 static const u16 FontWazaPos[][2] = {	//0:X, 1:Y
	{2 * 8 + 3, 4 * 8},		//X͍[W
	{0x12 * 8 + 3, 4 * 8},
	{2 * 8 + 3, 0x10 * 8},
	{0x12 * 8 + 3, 0x10 * 8},
};

///ZtHgOBJ̕\W
ALIGN4 static const u16 FontSetumeiPos[][2][2] = {	//[no][UP,DOWN][X,Y]
	{
		{2 * 8 + 3, 8 * 8},		//X͍[W
		{2 * 8 + 3, 10 * 8},		//X͍[W
	},
	{
		{0x12 * 8 + 3, 8 * 8},
		{0x12 * 8 + 3, 10 * 8},
	},
	{
		{2 * 8 + 3, 0x14 * 8},
		{2 * 8 + 3, 0x16 * 8},
	},
	{
		{0x12 * 8 + 3, 0x14 * 8},
		{0x12 * 8 + 3, 0x16 * 8},
	},
};

///RtHgOBJ̕\W
ALIGN4 static const u16 FontJudgePos[][2] = {	//X,Y
	{5 * 8, 9 * 8},		//X̓Z^[W
	{16 * 8, 9 * 8},
	{0x1b * 8, 9 * 8},
};

///RIʁFuǂṽtHgOBJ\WX(Z^[W)
#define FONT_JUDGE_MODORU_X		(128)
///RIʁFuǂṽtHgOBJ\WY
#define FONT_JUDGE_MODORU_Y		(0x14 * 8 + 4)

///ReXgNtHgOBJ̕\WX
#define FONT_CONRANK_POS_X		(128)
///ReXgNtHgOBJ̕\WY
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_FRANCE, LANG_ITALY) imatake 2007/04/09
// tXƃC^Ał́ANƕ̕\ʒuւ
#if (PM_LANG == LANG_FRANCE) || (PM_LANG == LANG_ITALY)
#define FONT_CONRANK_POS_Y		(8*0x14-1)
#else
#define FONT_CONRANK_POS_Y		(8*0x10-1)
#endif
// ----------------------------------------------------------------------------
///ReXg^CvtHgOBJ̕\WX
#define FONT_CONTYPE_POS_X		(128)
///ReXg^CvtHgOBJ̕\WY
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_FRANCE, LANG_ITALY) imatake 2007/04/09
// tXƃC^Ał́ANƕ̕\ʒuւ
#if (PM_LANG == LANG_FRANCE) || (PM_LANG == LANG_ITALY)
#define FONT_CONTYPE_POS_Y		(8*0x10-1)
#else
#define FONT_CONTYPE_POS_Y		(8*0x14-1)
#endif
// ----------------------------------------------------------------------------

//--------------------------------------------------------------
//	pbg֘A`
//--------------------------------------------------------------
///tHgOBJ̃pbgԍItZbg
enum{
	PALOFS_CONRANK = 0,
	PALOFS_WAZA = 0,
	PALOFS_SETUMEI = 0,
	PALOFS_JUDGE = 0,
};

#define MSGCOLOR_CONRANK		(GF_PRINTCOLOR_MAKE(1, 2, 0))	//FONT_SYSTEMȂ̂ŔwiFw
#define MSGCOLOR_WAZA			(GF_PRINTCOLOR_MAKE(1, 7, 8))
#define MSGCOLOR_SETUMEI		(GF_PRINTCOLOR_MAKE(1, 2, 0))	//FONT_SYSTEMȂ̂ŔwiFw
#define MSGCOLOR_JUDGE			(GF_PRINTCOLOR_MAKE(1, 9, 0xa))

//--------------------------------------------------------------
//	GtFNgTCB
//--------------------------------------------------------------
///pl^b`AGtFNgő҂t[
#define SCRN_TOUCH_WAIT			(0)
///pl^b`AGtFNgő҂t[
#define SCRN_TOUCH_ANM_WAIT		(0)

//--------------------------------------------------------------
//	Z^Cv
//--------------------------------------------------------------
///Z^CṽpbgJnʒu
#define WAZATYPE_START_PALPOS	(4)

//--------------------------------------------------------------
//	APl
//--------------------------------------------------------------
///APln[g̕\W
ALIGN4 static const AppHeartPos[][2] = {	//X, Y
	{7*8 + 4 + 3, 6*8 + 4},
	{0x17*8 + 4 + 3, 6*8 + 4},
	{7*8 + 4 + 3, 0x12*8 + 4},
	{0x17*8 + 4 + 3, 0x12*8 + 4},
};
///APln[gׂ̗̃n[gԂ̃Xy[X
#define APP_HEART_SPACE_X		(8)


//==============================================================================
//	\̒`
//==============================================================================
///Z͓͉ʃJ[\ʒuL
typedef struct{
	s8 waza_x;
	s8 waza_y;
	s8 judge_x;
	s8 judge_y;
}ACI_CURSOR_SAVE;

///J[\ړp[N
typedef struct{
	u8 cursor_on;			///<TRUEFJ[\\
	s8 y_menu;				///<Kwj[̈ʒu(Y)
	s8 x_menu;				///<j[̈ʒu(X)
	
	u8 dummy;
}CURSOR_MOVE;

///XN[͈͎̔w\
typedef struct{
	s32 top;
	s32 bottom;
	s32 left;
	s32 right;
}REWRITE_SCRN_RECT;

///CGR]Ajs͈̔̓f[^
typedef struct{
	u16 dest_x;			///<]XJnʒu(LP)
	u16 dest_y;			///<]YJnʒu(LP)
	u16 src_x;			///<]XJnʒu(LP)
	u16 src_y;			///<]YJnʒu(LP)
	u16 size_x;			///<X]TCY(LP)
	u16 size_y;			///<Y]TCY(LP)
}CGR_TRANS_RECTDATA;

///CGR]Ajs̃p[^
typedef struct{
	TCB_PTR v_tcb;		///<VuN]sTCB̃|C^
	u8 *dest_vram;		///<VRAM]AhX
	void *arc_data;		///<A[JCuLt@C̃|C^
	u8 *raw_data;		///<A[JCuLt@C̃Lf[^擪AhX
	CGR_TRANS_RECTDATA rd;	///<CGR]Ajs͈̔̓f[^
	u16 x_len;			///<Lt@CX(oCgP)
}CGR_TRANS_PARAM;

///paracgr\̂ŎgpAN^[|C^̐
#define PARACGR_CAP_MAX			(3)
///{^̃Ajp^[
#define BUTTON_ANM_NUM			(2)

///GtFNgTCBp̃[N
typedef struct{
	s16 seq;
	s16 wait;
	union{
		struct{		//CGR]p(ėp)
			CATS_ACT_PTR cap[PARACGR_CAP_MAX];	///<ꏏɃXN[AN^[ւ̃|C^

//			CGR_TRANS_PARAM *ctp;
//			const CGR_TRANS_RECTDATA *ctp_rd_ptr[BUTTON_ANM_NUM];
//			u32 transcgr_id[BUTTON_ANM_NUM];
			const s16 *scrn_offset;
			const REWRITE_SCRN_RECT *scrn_range;
			int tp_ret;
			u8 scrnbuf_no;

			u8 fa_no;						///<ΏۃtHgOBJAN^[[N̓Y
		}paracgr;
	};
}ACI_EFFECT_WORK;

///J[GtFNgTCBp̃[N
typedef struct{
	int tp_ret;
	s16 evy;		///<EVYl(8rbg)
	s16 evy_add;	///<EVYZl(8rbg)
	u8 seq;
	u8 pal_pos;	///<tF[hΏۂ̃pbgԍ
}ACI_COLOR_EFF_WORK;

///GtFNgBGp[^
typedef struct{
	const REWRITE_SCRN_RECT *rsr;	///<XN[͈̓f[^ւ̃|C^
	u8 rsr_num;						///<rsrf[^
	s8 add_charname;				///<LN^l[ɑރItZbgl
}EFFBG_WRITE_PARAM;

///tHgAN^[[N
typedef struct{
	FONTOAM_OBJ_PTR fontoam;
	CHAR_MANAGER_ALLOCDATA cma;
	u16 font_len;
}FONT_ACTOR;

///tHgOAM쐬AOBMPw肷ꍇɎgp
typedef struct{
	GF_BGL_BMPWIN bmpwin;
	u16 char_len;
	u16 font_len;
}FONT_EX_BMPWIN;

///`揈ׁ̈A炩߃f[^쐬Ẵׂ[N
typedef struct{
	//tHgOAMɊ֘AtBMPWIN
	FONT_EX_BMPWIN exbmp_waza[WAZA_TEMOTI_MAX];
	FONT_EX_BMPWIN exbmp_explain_u[WAZA_TEMOTI_MAX];
	FONT_EX_BMPWIN exbmp_explain_d[WAZA_TEMOTI_MAX];

	FONT_EX_BMPWIN exbmp_judge[JUDGE_MAX];
	
	u8 ap_no[WAZA_TEMOTI_MAX];
	u8 con_type[WAZA_TEMOTI_MAX];
}MEMORY_DECORD_WORK;

///ReXg͉ʐ䃏[N
typedef struct _ACI_PARAM{
	CONTEST_SYSTEM *consys;
	ACTIN_SYSTEM_PARAM *sys;
	ACTIN_GAME_PARAM *a_game;
	void *scene_work;	///<V[ɈقȂKvƂȂf[^ނւ̃|C^
	TCB_PTR effect_tcb;	///<GtFNgTCBւ̃|C^
	TCB_PTR color_eff_tcb;	///<J[GtFNgTCBւ̃|C^
	EFFBG_WRITE_PARAM ewp;	///<GtFNgBGp[^

	//XN[obt@
	u16 *scrn_buf[SCRNBUF_MAX];	///<XN[obt@
	//pbgobt@
	u16 *pal_buf[PALBUF_MAX];				///<pbgobt@

	//tHgOAM
	FONTOAM_SYS_PTR fontoam_sys;	///<tHgVXeւ̃|C^
	FONT_ACTOR font_actor[FA_NO_MAX];	///<tHgAN^[[N
	
	//ReXg^CvACR
	CATS_ACT_PTR icon_cap[WAZA_TEMOTI_MAX];		///<ReXg^CvACRAN^[|C^
	//Rn[g
	CATS_ACT_PTR special_heart_cap;			///<Rn[g̃AN^[|C^
	//APlEWQln[g
	CATS_ACT_PTR app_heart_cap[WAZA_TEMOTI_MAX][APP_HEART_MAX];	///<APln[g̃AN^[|C^
	
	MEMORY_DECORD_WORK memory_decord;
	void *cgr_arc_data;
	NNSG2dCharacterData *cgr_char_data;
	
	s8 makedata_no;		///<ݎgpĂBgMakeData̔ԍ
	u8 not_touch_pos;	///<AgpsZ̎莝ʒu(sZȂꍇNOT_TOUCH_WAZA_POS_NULL)
	
	ACI_EFFECT_WORK effect_work;	///<GtFNgTCBp[N
	ACI_COLOR_EFF_WORK color_work;	///<J[GtFNgTCBp[N

	ACI_CURSOR_SAVE cursor_save;	///<J[\Z[up[N
	CCURSOR_PTR cursor;			///<J[\[Nւ̃|C^
	CURSOR_MOVE cursor_move;	///<J[\ړp[N
	u8 decend_key;				///<TRUE:{^̂J[\
}ACI_PARAM;

///BG쐬f[^\
typedef struct{
	u16 cgr_id;			///<gpCGR̃A[JCuID
	u16 pal_id;			///<gppbg̃A[JCuID
	union{
		struct{
			u16 scr0_id;
			u16 scr1_id;
			u16 scr2_id;
			u16 scr3_id;
		};
		u16 scr_id[ACI_BG_NUM];		///<gpXN[̃A[JCuID
	};
	union{
		struct{
			u16 pri0;		///<BG0ʂ̃vCIeB
			u16 pri1;		///<BG1ʂ̃vCIeB
			u16 pri2;
			u16 pri3;
		};
		u16 pri[ACI_BG_NUM];		///<BG̃vCIeB
	};
	
	//^b`pl
	const RECT_HIT_TBL *tpd;	///<gp^b`plf[^ւ̃|C^
	const int *tpd_ret;			///<^b`pľ
	const u8 *tpd_pal;			///<^b`̃pl̃pbgԍf[^ւ̃|C^

	//J[\ړ
	int (*cursor_move_func)(ACI_PARAM_PTR, int);	///<L[͂̃R[obN֐
	void (*cursor_save_func)(ACI_PARAM_PTR, int);	///<L[ʒuL̃R[obN֐
	
	//֐|C^
	void (*callback_bg)(ACI_PARAM_PTR, int, int);	///<BGCreateɌĂяo֐
	int (*callback_tp)(ACI_PARAM_PTR, int, int);	///<^b`plɌĂяo֐
}BG_MAKE_DATA;


//==============================================================================
//	vg^Cv錾
//==============================================================================
static void * AINPUT_WorkInit(void);
static void BGCallback_Wall(ACI_PARAM_PTR aci, int select_bg, int force_put);
static void BGCallback_WazaSelect(ACI_PARAM_PTR aci, int select_bg, int force_put);
static void BGCallback_JudgeSelect(ACI_PARAM_PTR aci, int select_bg, int force_put);
static int TPCallback_WazaSelect(ACI_PARAM_PTR aci, int tp_ret, int panel_pal);
static int TPCallback_JudgeSelect(ACI_PARAM_PTR aci, int tp_ret, int panel_pal);
static void Sub_SubHeartJudgeDeleteAll(ACI_PARAM_PTR aci);
static void Sub_AppHeartDeleteAll(ACI_PARAM_PTR aci);
static void Sub_SceneOBJDelete(ACI_PARAM_PTR aci);
static void Sub_ConTypeIconCreateAll(ACI_PARAM_PTR aci, u16 wazano[]);
static void Sub_ConTypeIconDeleteAll(ACI_PARAM_PTR aci);
static void Sub_WazaTypeCGRTrans(ACI_PARAM_PTR aci, int waza_type, int waza_pos);
static void Sub_BackScrnOnlyVisible(void);
static void Sub_TouchEndDelete(ACI_PARAM_PTR aci);
static void EffectTCB_Add(TCB_FUNC func, ACI_PARAM_PTR aci);
static void EffectTCB_Delete(ACI_PARAM_PTR aci);
static void Effect_ButtonDown(TCB_PTR tcb, void *work);
static void Effect_WazaButtonDown(TCB_PTR tcb, void *work);
static void VWait_CgrTrans(TCB_PTR tcb, void *work);
static void VWait_FrameVisibleUpdate(TCB_PTR tcb, void *work);
static void VWait_BackScrnOnlyVisible(TCB_PTR tcb, void *work);
static void Sub_ScrnErase(const REWRITE_SCRN_RECT rsr[], int rsr_num, GF_BGL_INI *bgl, 
	int frame_no, u16 clear_code);
static void Sub_FontOamCreate(ACI_PARAM_PTR aci, FONT_ACTOR *font_actor, const STRBUF *str, 
	FONT_TYPE font_type, GF_PRINTCOLOR color, int pal_offset, int pal_id, 
	int x, int y, int pos_center, FONT_EX_BMPWIN *ex_bmpwin);
static void Sub_FontOamDeleteAll(ACI_PARAM_PTR aci);
void AINPUT_DefaultFrameSet(GF_BGL_INI *bgl);
void AINPUT_FrameExit(GF_BGL_INI *bgl);
void *AINPUT_SystemInit(CONTEST_SYSTEM *consys, ACTIN_SYSTEM_PARAM *sys, ACTIN_GAME_PARAM *a_game);
void AINPUT_SystemFree(ACI_PARAM_PTR aci);
void AINPUT_CreateBG(ACI_PARAM_PTR aci, int select_bg, int force_put, void *scene_work);
int AINPUT_TouchCheck(ACI_PARAM_PTR aci);
BOOL AINPUT_EffectEndCheck(ACI_PARAM_PTR aci);
static void MemoryDecordWorkFree(ACI_PARAM_PTR aci);
static void FontExBmpwin_FontSet(ACI_PARAM_PTR aci, const STRBUF *str, FONT_TYPE font_type,
	FONT_EX_BMPWIN *ex_bmp, GF_PRINTCOLOR color);
static void FontLenGet(const STRBUF *str, FONT_TYPE font_type, int *ret_dot_len, 
	int *ret_char_len);
static void ColorEff_PointFade(TCB_PTR tcb, void *work);
static void ColorEffTCB_PointFadeSet(ACI_PARAM_PTR aci, int pal_pos);
static int CursorCheck(ACI_PARAM_PTR aci);
static int CursorMove_WazaSelect(ACI_PARAM_PTR aci, int init_flag);
static void CursorSave_WazaSelect(ACI_PARAM_PTR aci, int index);
static int CursorMove_JudgeSelect(ACI_PARAM_PTR aci, int init_flag);
static void CursorSave_JudgeSelect(ACI_PARAM_PTR aci, int index);
static u32 CursorMove_KeyCheckMove(CURSOR_MOVE *move, int x_menu_num, int y_menu_num, 
	const u8 *move_data);

//==============================================================================
//	Of[^
//==============================================================================
#include "con_engi_type_ncl_txt.dat"

//==============================================================================
//	f[^
//==============================================================================
///ReXg͉ʗpBGt[\
static const GF_BGL_BGCNT_HEADER AciBgCntDat[] = {
	{//GF_BGL_FRAME0_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x6000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
	{//GF_BGL_FRAME1_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x6800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
	{//GF_BGL_FRAME2_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x7000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
	{//GF_BGL_FRAME3_S
		0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0x7800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
		0, 0, 0, FALSE
	},
};

//============================================================================================
//	^b`pl̈ݒ
//============================================================================================
//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///ZI^b`pl̈ݒ
static const RECT_HIT_TBL WazaSelectTouchData[] = {
	//UP DOWN LEFT RIGHT
	{1*8, 12*8, 1*8, 0xf*8},		//ZP
	{1*8, 12*8, 0x11*8, 0x1f*8},	//ZQ
	{13*8, 0x18*8, 1*8, 0xf*8},		//ZR
	{13*8, 0x18*8, 0x11*8, 0x1f*8},	//ZS
	{ RECT_HIT_END, 0, 0, 0 }
};
///ZI^b`pl̃^b`ʕԎ
static const int WazaSelectTouchRet[NELEMS(WazaSelectTouchData) - 1] = {
	ACTIN_TP_WAZA_1,			//Z1
	ACTIN_TP_WAZA_2,			//Z2
	ACTIN_TP_WAZA_3,			//Z3
	ACTIN_TP_WAZA_4,			//Z4
};
///R}hI^b`pl̊epl̃pbgԍ
ALIGN4 static const u8 WazaSelectPaletteNo[NELEMS(WazaSelectTouchData) - 1] = {
	WAZATYPE_START_PALPOS + 0,		//Z1
	WAZATYPE_START_PALPOS + 1,		//Z2
	WAZATYPE_START_PALPOS + 2,		//Z3
	WAZATYPE_START_PALPOS + 3,		//Z4
};

///J[\ړFZI̐j[̍ő吔
#define CURSOR_WAZA_SELECT_X_MENU_NUM		(2)
///J[\ړFZĨj[̊Kw̐
#define CURSOR_WAZA_SELECT_Y_MENU_NUM		(2)
///ZĨ^b`plINDEX(WazaSelectTouchRet̏)
enum{
	WAZASELE_INDEX_SKILL_1,
	WAZASELE_INDEX_SKILL_2,
	WAZASELE_INDEX_SKILL_3,
	WAZASELE_INDEX_SKILL_4,
};
///J[\ړFZÏړ͈̓f[^
ALIGN4 static const u8 CursorMoveDataWazaSelect[CURSOR_WAZA_SELECT_Y_MENU_NUM][CURSOR_WAZA_SELECT_X_MENU_NUM] = {
	{WAZASELE_INDEX_SKILL_1, WAZASELE_INDEX_SKILL_2},		//ZPAZQ
	{WAZASELE_INDEX_SKILL_3, WAZASELE_INDEX_SKILL_4},		//ZRAZS
};

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///RI^b`pl̈ݒ
static const RECT_HIT_TBL JudgeSelectTouchData[] = {
	//UP DOWN LEFT RIGHT
	{1*8, 0x10*8, 0*8, 10*8},		//RP
	{1*8, 0x10*8, 11*8, 0x15*8},		//RQ
	{1*8, 0x10*8, 0x16*8, 255},		//RR
	{0x11*8, 0x18*8, 0, 255},			//ǂ
	{ RECT_HIT_END, 0, 0, 0 }
};
///RI^b`pl̃^b`ʕԎ
static const int JudgeSelectTouchRet[NELEMS(JudgeSelectTouchData) - 1] = {
	ACTIN_TP_JUDGE_1,		//RP
	ACTIN_TP_JUDGE_2,		//RQ
	ACTIN_TP_JUDGE_3,		//RR
	ACTIN_TP_JUDGE_MODORU,	//ǂ
};
///R}hI^b`pl̊epl̃pbgԍ
ALIGN4 static const u8 JudgeSelectPaletteNo[NELEMS(JudgeSelectTouchData) - 1] = {
	0,		//R1
	1,		//R2
	2,		//R3
	3,		//ǂ
};

///J[\ړFZI̐j[̍ő吔
#define CURSOR_JUDGE_SELECT_X_MENU_NUM		(3)
///J[\ړFZĨj[̊Kw̐
#define CURSOR_JUDGE_SELECT_Y_MENU_NUM		(2)
///ZĨ^b`plINDEX(JudgeSelectTouchRet̏)
enum{
	JUDGESELE_INDEX_1,
	JUDGESELE_INDEX_2,
	JUDGESELE_INDEX_3,
	JUDGESELE_INDEX_CANCEL,
};
///J[\ړFZÏړ͈̓f[^
ALIGN4 static const u8 CursorMoveDataJudgeSelect[CURSOR_JUDGE_SELECT_Y_MENU_NUM][CURSOR_JUDGE_SELECT_X_MENU_NUM] = {
	{JUDGESELE_INDEX_1, JUDGESELE_INDEX_2, JUDGESELE_INDEX_3},		//RPCQCR
	{JUDGESELE_INDEX_CANCEL, JUDGESELE_INDEX_CANCEL, JUDGESELE_INDEX_CANCEL},		//LZ
};


//==============================================================================
//	
//==============================================================================
///BG쐬f[^(̕тǉAύXAINPUT_TYPE_???̒`ύX邱ƁII)
static const BG_MAKE_DATA BgMakeData[] = {
	{//WALL
		CON_SUB_NCGR_BIN,
		PALBUF_TITLE,
		{
			SCRNBUF_TITLE,		//pl
			NONE_ID,		//g
			SCRNBUF_BACKGROUND,		//wi
			NONE_ID,							//gXChp
		},
		{2, 1, 3, 0},
		NULL,				//^b`plf[^
		NULL,				//^b`pl
		NULL,				//^b`pbgԍ
		NULL,				//L[͂̃R[obN֐
		NULL,			///<L[ʒuL̃R[obN֐
		BGCallback_Wall,				//BG쐬̃R[obN֐
		NULL,				//^b`pl̃R[obN֐
	},
	{//HEART_WALL
		CON_BUT_NCGR_BIN,
		PALBUF_COMMAND,
		{
			NONE_ID,		//pl
			NONE_ID,		//g
			SCRNBUF_COMMAND_BACKGROUND,		//wi
			NONE_ID,							//gXChp
		},
		{2, 1, 3, 0},
		NULL,				//^b`plf[^
		NULL,				//^b`pl
		NULL,				//^b`pbgԍ
		NULL,				//L[͂̃R[obN֐
		NULL,			///<L[ʒuL̃R[obN֐
		NULL,				//BG쐬̃R[obN֐
		NULL,				//^b`pl̃R[obN֐
	},
	{//WAZA
		CON_BUT_NCGR_BIN,
		PALBUF_COMMAND,
		{
			SCRNBUF_COMMAND_WAZA,		//pl
			NONE_ID,		//g
			SCRNBUF_COMMAND_BACKGROUND,		//wi
			NONE_ID,							//gXChp
		},
		{2, 1, 3, 0},
		WazaSelectTouchData,				//^b`plf[^
		WazaSelectTouchRet,					//^b`pl
		WazaSelectPaletteNo,				//^b`pbgԍ
		CursorMove_WazaSelect,				//L[͂̃R[obN֐
		CursorSave_WazaSelect,			///<L[ʒuL̃R[obN֐
		BGCallback_WazaSelect,				//BG쐬̃R[obN֐
		TPCallback_WazaSelect,				//^b`pl̃R[obN֐
	},
	{//JUDGE
		CON_BUT_NCGR_BIN,
		PALBUF_COMMAND,
		{
			SCRNBUF_COMMAND_JUDGE,		//pl
			NONE_ID,		//g
			SCRNBUF_COMMAND_BACKGROUND,		//wi
			NONE_ID,							//gXChp
		},
		{2, 1, 3, 0},
		JudgeSelectTouchData,				//^b`plf[^
		JudgeSelectTouchRet,				//^b`pl
		JudgeSelectPaletteNo,				//^b`pbgԍ
		CursorMove_JudgeSelect,				//L[͂̃R[obN֐
		CursorSave_JudgeSelect,			///<L[ʒuL̃R[obN֐
		BGCallback_JudgeSelect,				//BG쐬̃R[obN֐
		TPCallback_JudgeSelect,				//^b`pl̃R[obN֐
	},
};


//==============================================================================
//
//	AN^[wb_
//
//==============================================================================
///ReXg^CvACRFAN^[wb_
static const TCATS_OBJECT_ADD_PARAM_S ConTypeIconObjParam = {
	0, 0, 0,		//x, y, z
	0, 100, 0,		//AjԍAD揇ʁApbgԍ
	NNS_G2D_VRAM_TYPE_2DSUB,		//`GA
	{	//gp\[XIDe[u
		CHARID_CONTYPE_ICON_1,	//L
		PLTTID_OBJ_COMMON_SUB,	//pbg
		CELLID_CONTYPE_ICON,	//Z
		CELLANMID_CONTYPE_ICON,	//ZAj
		CLACT_U_HEADER_DATA_NONE,		//}`Z
		CLACT_U_HEADER_DATA_NONE,		//}`ZAj
	},
	1,			//BGvCIeB
	0,			//Vram]tO
};


//==============================================================================
//
//	Z^Cv
//
//==============================================================================
///Z̋Z^CvL]ʒu(LN^P)
ALIGN4 static const u16 WazaTypeCgrPos[] = {0+1, 6+1, 12+1, 18+1};

///ReXg^CvACR̍W
ALIGN4 static const u16 WazaIconPos[][2] = {	//X, Y
	{4*8 + 4 + 3, 6*8},
	{0x14*8 + 4 + 3, 6*8},
	{4*8 + 4 + 3, 0x12*8},
	{0x14*8 + 4 + 3, 0x12*8},
};

//==============================================================================
//
//	
//
//==============================================================================
///{^̉̃Ajp^[
#define BUTTON_ANM_MAX		(3)

//--------------------------------------------------------------
//	Ȃpl
//--------------------------------------------------------------
///XN[ԍFȂpl@Aj0A
#define SCRN_NO_NOT_TOUCH_0		(0x220)

//--------------------------------------------------------------
//	ZI
//--------------------------------------------------------------
///XN[ԍFZIuZ0vAj0A
#define SCRN_NO_WAZA_SKILL_0_0		(0xc)
///XN[ԍFZIuZ0vAj1A
#define SCRN_NO_WAZA_SKILL_0_1		(0xcc)
///XN[ԍFZIuZ0vAj2A
#define SCRN_NO_WAZA_SKILL_0_2		(0x18c)

///XN[ԍFZIuZ1vAj0A
#define SCRN_NO_WAZA_SKILL_1_0		(0xf)
///XN[ԍFZIuZ1vAj1A
#define SCRN_NO_WAZA_SKILL_1_1		(0xcf)
///XN[ԍFZIuZ1vAj2A
#define SCRN_NO_WAZA_SKILL_1_2		(0x18f)

///XN[ԍFZIuZ2vAj0A
#define SCRN_NO_WAZA_SKILL_2_0		(0x12)
///XN[ԍFZIuZ2vAj1A
#define SCRN_NO_WAZA_SKILL_2_1		(0xd2)
///XN[ԍFZIuZ2vAj2A
#define SCRN_NO_WAZA_SKILL_2_2		(0x192)

///XN[ԍFZIuZ3vAj0A
#define SCRN_NO_WAZA_SKILL_3_0		(0x15)
///XN[ԍFZIuZ3vAj1A
#define SCRN_NO_WAZA_SKILL_3_1		(0xd5)
///XN[ԍFZIuZ3vAj2A
#define SCRN_NO_WAZA_SKILL_3_2		(0x195)

///ZIpl̃{^AjpXN[ItZbgl
ALIGN4 static const s16 WazaButtonScrnOffset[][BUTTON_ANM_MAX] = {
	{//SELECT_SKILL_1
		SCRN_NO_WAZA_SKILL_0_0 - SCRN_NO_WAZA_SKILL_0_0,
		SCRN_NO_WAZA_SKILL_0_1 - SCRN_NO_WAZA_SKILL_0_0,
		SCRN_NO_WAZA_SKILL_0_2 - SCRN_NO_WAZA_SKILL_0_0,
	},
	{//SELECT_SKILL_2
		SCRN_NO_WAZA_SKILL_1_0 - SCRN_NO_WAZA_SKILL_1_0,
		SCRN_NO_WAZA_SKILL_1_1 - SCRN_NO_WAZA_SKILL_1_0,
		SCRN_NO_WAZA_SKILL_1_2 - SCRN_NO_WAZA_SKILL_1_0,
	},
	{//SELECT_SKILL_3
		SCRN_NO_WAZA_SKILL_2_0 - SCRN_NO_WAZA_SKILL_2_0,
		SCRN_NO_WAZA_SKILL_2_1 - SCRN_NO_WAZA_SKILL_2_0,
		SCRN_NO_WAZA_SKILL_2_2 - SCRN_NO_WAZA_SKILL_2_0,
	},
	{//SELECT_SKILL_4
		SCRN_NO_WAZA_SKILL_3_0 - SCRN_NO_WAZA_SKILL_3_0,
		SCRN_NO_WAZA_SKILL_3_1 - SCRN_NO_WAZA_SKILL_3_0,
		SCRN_NO_WAZA_SKILL_3_2 - SCRN_NO_WAZA_SKILL_3_0,
	},
};

///ZIpl̃XN[Aj͈
ALIGN4 static const REWRITE_SCRN_RECT WazaButtonScrnRect[] = {
	{0, 11, 1, 14},
	{0, 11, 0x11, 0x1e},
	{12, 0x17, 1, 14},
	{12, 0x17, 0x11, 0x1e},
};

///ZIplȂ{^ɂ鎞̃XN[ItZbgl
ALIGN4 static const s16 WazaButtonNotTouchScrnOffset[] = {
	SCRN_NO_NOT_TOUCH_0 - SCRN_NO_WAZA_SKILL_0_0,	//SELECT_SKILL_1
	SCRN_NO_NOT_TOUCH_0 - SCRN_NO_WAZA_SKILL_1_0,	//SELECT_SKILL_1
	SCRN_NO_NOT_TOUCH_0 - SCRN_NO_WAZA_SKILL_2_0,	//SELECT_SKILL_1
	SCRN_NO_NOT_TOUCH_0 - SCRN_NO_WAZA_SKILL_3_0,	//SELECT_SKILL_1
};

///ZIplȂ{^ɂ鎞̃XN[Aj͈
ALIGN4 static const REWRITE_SCRN_RECT WazaButtonNotTouchScrnRect[] = {
	{1, 11, 1, 14},
	{1, 11, 0x11, 0x1e},
	{13, 0x17, 1, 14},
	{13, 0x17, 0x11, 0x1e},
};

//--------------------------------------------------------------
//	RI
//--------------------------------------------------------------
///XN[ԍFRIuR0vAj0A
#define SCRN_NO_JUDGE_0_0		(0x0)
///XN[ԍFRIuR0vAj1A
#define SCRN_NO_JUDGE_0_1		(0xc0)
///XN[ԍFRIuR0vAj2A
#define SCRN_NO_JUDGE_0_2		(0x180)

///XN[ԍFRIuR1vAj0A
#define SCRN_NO_JUDGE_1_0		(0x3)
///XN[ԍFRIuR1vAj1A
#define SCRN_NO_JUDGE_1_1		(0xc3)
///XN[ԍFRIuR1vAj2A
#define SCRN_NO_JUDGE_1_2		(0x183)

///XN[ԍFRIuR2vAj0A
#define SCRN_NO_JUDGE_2_0		(0x6)
///XN[ԍFRIuR2vAj1A
#define SCRN_NO_JUDGE_2_1		(0xc6)
///XN[ԍFRIuR2vAj2A
#define SCRN_NO_JUDGE_2_2		(0x186)

///XN[ԍFRIuLZvAj0A
#define SCRN_NO_JUDGE_CANCEL_0	(0x9)
///XN[ԍFRIuLZvAj1A
#define SCRN_NO_JUDGE_CANCEL_1	(0xc9)
///XN[ԍFRIuLZvAj2A
#define SCRN_NO_JUDGE_CANCEL_2	(0x189)

///RIpl̃{^AjpXN[ItZbgl
ALIGN4 static const s16 JudgeButtonScrnOffset[][BUTTON_ANM_MAX] = {
	{//JUDGE_1
		SCRN_NO_JUDGE_0_0 - SCRN_NO_JUDGE_0_0,
		SCRN_NO_JUDGE_0_1 - SCRN_NO_JUDGE_0_0,
		SCRN_NO_JUDGE_0_2 - SCRN_NO_JUDGE_0_0,
	},
	{//JUDGE_2
		SCRN_NO_JUDGE_1_0 - SCRN_NO_JUDGE_1_0,
		SCRN_NO_JUDGE_1_1 - SCRN_NO_JUDGE_1_0,
		SCRN_NO_JUDGE_1_2 - SCRN_NO_JUDGE_1_0,
	},
	{//JUDGE_3
		SCRN_NO_JUDGE_2_0 - SCRN_NO_JUDGE_2_0,
		SCRN_NO_JUDGE_2_1 - SCRN_NO_JUDGE_2_0,
		SCRN_NO_JUDGE_2_2 - SCRN_NO_JUDGE_2_0,
	},
	{//CANCEL
		SCRN_NO_JUDGE_CANCEL_0 - SCRN_NO_JUDGE_CANCEL_0,
		SCRN_NO_JUDGE_CANCEL_1 - SCRN_NO_JUDGE_CANCEL_0,
		SCRN_NO_JUDGE_CANCEL_2 - SCRN_NO_JUDGE_CANCEL_0,
	},
};

///RIpl̃XN[Aj͈
ALIGN4 static const REWRITE_SCRN_RECT JudgeButtonScrnRect[] = {
	{0, 0xf, 0, 9},
	{0, 0xf, 11, 0x14},
	{0, 0xf, 0x16, 0x1f},
	{0x10, 0x17, 0, 0x1f},
};



//==============================================================================
//
//	
//
//==============================================================================

//--------------------------------------------------------------
/**
 * @brief   BIVXe[N̊mۂƏ
 *
 * @retval  mۂBIVXe[Ñ|C^
 */
//--------------------------------------------------------------
static void * AINPUT_WorkInit(void)
{
	ACI_PARAM *aci;

	aci = sys_AllocMemory(HEAPID_ACTIN, sizeof(ACI_PARAM));
	MI_CpuClear8(aci, sizeof(ACI_PARAM));
	
	aci->makedata_no = MAKEDATA_NO_INIT;
	
	return aci;
}

//--------------------------------------------------------------
/**
 * @brief   BG\Wt[\Őݒ肷
 * @param   bgl		BGLf[^
 */
//--------------------------------------------------------------
void AINPUT_DefaultFrameSet(GF_BGL_INI *bgl)
{
	int i;
	
	for(i = 0; i < NELEMS(AciBgCntDat); i++){
		GF_BGL_BGControlSet(bgl, GF_BGL_FRAME0_S + i, &AciBgCntDat[i], GF_BGL_MODE_TEXT);
		GF_BGL_ScrClearCode(bgl, GF_BGL_FRAME0_S + i, BG_CLEAR_CODE);
		GF_BGL_ScrollSet(bgl, GF_BGL_FRAME0_S + i, GF_BGL_SCROLL_X_SET, 0);
		GF_BGL_ScrollSet(bgl, GF_BGL_FRAME0_S + i, GF_BGL_SCROLL_Y_SET, 0);
	}
}

//--------------------------------------------------------------
/**
 * @brief   BGt[I
 * @param   bgl		BGLf[^
 */
//--------------------------------------------------------------
void AINPUT_FrameExit(GF_BGL_INI *bgl)
{
	int i;
	
	for(i = 0; i < NELEMS(AciBgCntDat); i++){
		GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_OFF);
		GF_BGL_BGControlExit(bgl, GF_BGL_FRAME0_S + i);
	}
}

//--------------------------------------------------------------
/**
 * @brief   ReXg͉ʂ̃VXe
 * @param   bgl		BGLf[^
 * @retval  AllocReXg͉ʂ̃VXe[Ñ|C^
 */
//--------------------------------------------------------------
void * AINPUT_SystemInit(CONTEST_SYSTEM *consys, ACTIN_SYSTEM_PARAM *sys, ACTIN_GAME_PARAM *a_game)
{
	ACI_PARAM *aci;
	
	//[Nm
	aci = AINPUT_WorkInit();
	aci->consys = consys;
	aci->sys = sys;
	aci->a_game = a_game;
	
	//t[\ݒ	ł邩͔H
//	AINPUT_DefaultFrameSet(bgl);

	//tHgOAMVXe쐬
	aci->fontoam_sys = FONTOAM_SysInit(FA_NO_MAX, HEAPID_ACTIN);

	//XN[Sǂݍ
	{
		NNSG2dScreenData *scrnData;
		void *arc_data;
		int i;
		
		for(i = 0; i < SCRNBUF_MAX; i++){
			//XN[obt@m
			aci->scrn_buf[i] = sys_AllocMemory(HEAPID_ACTIN, 0x800);

			//XN[ǂݍ
			arc_data = ArcUtil_ScrnDataGet(ARC_CONTEST_BG, ScrnArcDataNo[i], 1, 
				&scrnData, HEAPID_ACTIN);
			MI_CpuCopy32(scrnData->rawData, aci->scrn_buf[i], 0x800);
			sys_FreeMemoryEz(arc_data);
		}
	}

	//pbgǂݍ
	{
		u16 *def_wk;
		PALETTE_FADE_PTR pfd;
		int i;
		
		pfd = aci->sys->pfd;
		
		for(i = 0; i < PALBUF_MAX; i++){
			aci->pal_buf[i] = sys_AllocMemory(HEAPID_ACTIN, 0x200);
			PaletteWorkSet_Arc(pfd, ARC_CONTEST_BG, PaletteArcDataNo[i], HEAPID_ACTIN, 
				FADE_SUB_BG, 0, 0);
			def_wk = PaletteWorkDefaultWorkGet(pfd, FADE_SUB_BG);
			MI_CpuCopy16(def_wk, aci->pal_buf[i], 0x200);
		}
	}

	return aci;
}

//--------------------------------------------------------------
/**
 * @brief   ReXg͉ʂ̃VXe
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
void AINPUT_SystemFree(ACI_PARAM_PTR aci)
{
	int i;
	
	Sub_SceneOBJDelete(aci);
	FONTOAM_SysDelete(aci->fontoam_sys);

	//-- J[\ --//
	CCURSOR_ResourceFree(aci->sys->crp, CHARID_ACTIN_CURSOR, PLTTID_ACTIN_CURSOR,
		CELLID_ACTIN_CURSOR, CELLANMID_ACTIN_CURSOR);
	CCURSOR_ActorDelete(aci->cursor);

	for(i = 0; i < SCRNBUF_MAX; i++){
		sys_FreeMemoryEz(aci->scrn_buf[i]);
	}
	for(i = 0; i < PALBUF_MAX; i++){
		sys_FreeMemoryEz(aci->pal_buf[i]);
	}
	
	MemoryDecordWorkFree(aci);

	sys_FreeMemoryEz(aci);
}

//--------------------------------------------------------------
/**
 * @brief   w^CvBGʂ`
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   select_bg		\BG^Cv(AINPUT_TYPE_???)
 * @param   force_put		TRUE:]AFALSE:ɓf[^]ĂȂē]͂Ȃ
 * @param   work			V[ɈقȂKvȃf[^ւ̃|C^
 */
//--------------------------------------------------------------
void AINPUT_CreateBG(ACI_PARAM_PTR aci, int select_bg, int force_put, void *scene_work)
{
	const BG_MAKE_DATA *bmd, *old_bmd;
	int i;
	GF_BGL_INI *bgl;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	
	aci->scene_work = scene_work;
	bgl = aci->sys->bgl;
	csp = aci->sys->csp;
	crp = aci->sys->crp;
	
	if(aci->makedata_no == MAKEDATA_NO_INIT){
		force_put = TRUE;
		old_bmd = NULL;
	}
	else{
		old_bmd = &BgMakeData[aci->makedata_no];
	}
	bmd = &BgMakeData[select_bg];

	//wiȊO͑SĔ\
//	Sub_BackScrnOnlyVisible();
	
	//eBGʂBGvCIeBXV
	{
		for(i = 0; i < ACI_BG_NUM; i++){
			GF_BGL_PrioritySet(GF_BGL_FRAME0_S + i, bmd->pri[i]);
		}
	}
	
	//PALETTE
//	if(bmd->pal_id != NONE_ID && (force_put == TRUE || bmd->pal_id != old_bmd->pal_id)){
	if(1){
		PaletteWorkSet(aci->sys->pfd, aci->pal_buf[bmd->pal_id], FADE_SUB_BG, 0, 0x200);
	}
	//SCREEN
	for(i = 0; i < ACI_BG_NUM; i++){
		if(bmd->scr_id[i] != NONE_ID 
				&& (force_put == TRUE || bmd->scr_id[i] != old_bmd->scr_id[i])){
			GF_BGL_ScreenBufSet(bgl, GF_BGL_FRAME0_S + i, aci->scrn_buf[bmd->scr_id[i]], 0x800);
			GF_BGL_LoadScreenV_Req(bgl, GF_BGL_FRAME0_S + i);
		}
	}
	
	aci->makedata_no = select_bg;

//	G2S_SetBlendAlpha(BLD_PLANE_1, BLD_PLANE_2, BLD_ALPHA_1, BLD_ALPHA_2);

	Sub_SceneOBJDelete(aci);
	//R[obN֐Ăяo
	if(bmd->callback_bg != NULL){
		bmd->callback_bg(aci, select_bg, force_put);
	}

	//CGR	Vblankœ]܂Ŋmۂ܂܂Ȃ̂ŁAŌɂ
//	if(1){	//CGR]AjsȂLIDłK]ĂȂƃAj߂Ȃ
	if(bmd->cgr_id != NONE_ID && (force_put == TRUE || bmd->cgr_id != old_bmd->cgr_id)){
//		ArcUtil_BgCharSet(ARC_CONTEST_BG, bmd->cgr_id, bgl, GF_BGL_FRAME0_S, 
//			0, ACI_BG_CGR_SIZE, 1, HEAPID_ACTIN);
		aci->cgr_arc_data = ArcUtil_CharDataGet(ARC_CONTEST_BG, bmd->cgr_id, 1, 
			&aci->cgr_char_data, HEAPID_ACTIN);
		VWaitTCB_Add(VWait_CgrTrans, aci, VWAIT_TCBPRI_CGRTRANS);
	}

	VWaitTCB_Add(VWait_FrameVisibleUpdate, aci, VWAIT_TCBPRI_FRAMEVISIBLE);
}

//--------------------------------------------------------------
/**
 * @brief   ^b`plԂ𒲂ׂ
 * @param   aci		BIVXe[Nւ̃|C^
 * @retval  (Ȃ̏ꍇRECT_HIT_NONE)
 */
//--------------------------------------------------------------
int AINPUT_TouchCheck(ACI_PARAM_PTR aci)
{
	int tp_ret, hit, ret, panel_pal;
	const BG_MAKE_DATA *bmd;
	int cursor_check = 0;
	
	GF_ASSERT(aci->makedata_no != MAKEDATA_NO_INIT);
	
	bmd = &BgMakeData[aci->makedata_no];
	if(bmd->tpd == NULL){
		return RECT_HIT_NONE;
	}
	
	GF_ASSERT(bmd->tpd_ret != NULL);
	
	hit = GF_TP_RectHitTrg(bmd->tpd);
	if(hit == RECT_HIT_NONE){
		hit = CursorCheck(aci);
		cursor_check++;
	}
	
	if(hit == RECT_HIT_NONE){
		tp_ret = RECT_HIT_NONE;
		panel_pal = 0xff;
	}
	else{
		tp_ret = bmd->tpd_ret[hit];
		panel_pal = bmd->tpd_pal[hit];
	}
	
	//R[obN֐Ăяo
	if(bmd->callback_tp != NULL){
		tp_ret = bmd->callback_tp(aci, tp_ret, panel_pal);
		if(tp_ret != RECT_HIT_NONE){
			if(bmd->cursor_save_func != NULL){
				bmd->cursor_save_func(aci, hit);
			}
			MI_CpuClear8(&aci->cursor_move, sizeof(CURSOR_MOVE));
			CCURSOR_OFF(aci->cursor);
			if(cursor_check > 0){
				aci->decend_key = TRUE;
			}
			else{
				aci->decend_key = FALSE;
			}
		}
	}
	
	return tp_ret;
}

//--------------------------------------------------------------
/**
 * @brief   GtFNgTCBIĂ邩`FbN
 * @param   aci		BIVXe[Nւ̃|C^
 * @retval  TRUE:IĂB@FALSE:IĂȂ
 */
//--------------------------------------------------------------
BOOL AINPUT_EffectEndCheck(ACI_PARAM_PTR aci)
{
	if(aci->effect_tcb == NULL && aci->color_eff_tcb == NULL){
		return TRUE;
	}
	return FALSE;
}



//==============================================================================
//
//	BG쐬ɌĂ΂R[obN֐
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   AINPUT_TYPE_WALLBGCreateɌĂ΂R[obN֐
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   select_bg		\BG^Cv(AINPUT_TYPE_???)
 * @param   force_put		TRUE:]AFALSE:ɓf[^]ĂȂē]͂Ȃ
 */
//--------------------------------------------------------------
static void BGCallback_Wall(ACI_PARAM_PTR aci, int select_bg, int force_put)
{
	STRBUF *rank_src, *type_src;
	u32 rank_id, type_id;
	
	rank_id = ConTool_GetRankMsgID(aci->sys->c_game->rank, aci->sys->c_game->mode, 
		aci->consys->sio_flag);
	type_id = ConTool_GetTypeMsgID(aci->sys->c_game->type, aci->sys->c_game->mode);
	
	rank_src = MSGMAN_AllocString(aci->sys->actin_msg, rank_id);
	type_src = MSGMAN_AllocString(aci->sys->actin_msg, type_id);
	
	Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_CONRANK], 
		rank_src, FONT_SYSTEM, 
		MSGCOLOR_CONRANK, PALOFS_CONRANK,
		PLTTID_SUB_FONTACT, FONT_CONRANK_POS_X, FONT_CONRANK_POS_Y, FONTOAM_CENTER, NULL);
	Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_CONTYPE], 
		type_src, FONT_SYSTEM, 
		MSGCOLOR_CONRANK, PALOFS_CONRANK,
		PLTTID_SUB_FONTACT, FONT_CONTYPE_POS_X, FONT_CONTYPE_POS_Y, FONTOAM_CENTER, NULL);
	
	STRBUF_Delete(rank_src);
	STRBUF_Delete(type_src);
	
	PaletteWorkSetEx_Arc(aci->sys->pfd, ARC_CONTEST_BG, CONTEST_SUBTIT_NCLR, HEAPID_ACTIN, 
		FADE_SUB_BG, 0x20, PLATE_PALNO * 16, 16 * aci->sys->c_game->type);
}

//--------------------------------------------------------------
/**
 * @brief   AINPUT_TYPE_ABGCreateɌĂ΂R[obN֐
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   select_bg		\BG^Cv(AINPUT_TYPE_???)
 * @param   force_put		TRUE:]AFALSE:ɓf[^]ĂȂē]͂Ȃ
 */
//--------------------------------------------------------------
static void BGCallback_WazaSelect(ACI_PARAM_PTR aci, int select_bg, int force_put)
{
	u16 wazano[WAZA_TEMOTI_MAX], appeal_no[WAZA_TEMOTI_MAX];
	int i;
	STRBUF *waza_src;
	STRBUF *setumei_u_src, *setumei_d_src;
	u32 u_id, d_id;
	MEMORY_DECORD_WORK *mdw;

	mdw = &aci->memory_decord;
	aci->not_touch_pos = NOT_TOUCH_WAZA_POS_NULL;
	
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		wazano[i] = PokeParaGet(aci->sys->c_game->pp[aci->sys->c_game->my_breeder_no], 
			ID_PARA_waza1 + i, NULL);
		if(wazano[i] != 0){
			appeal_no[i] = mdw->ap_no[i];
		}
		else{
			appeal_no[i] = 0;
		}
		
		//Z
		Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_WAZA_1 + i], NULL, FONT_BUTTON, 
			MSGCOLOR_WAZA, PALOFS_WAZA,
			PLTTID_SUB_FONTACT, FontWazaPos[i][0], FontWazaPos[i][1], FONTOAM_LEFT, 
			&mdw->exbmp_waza[i]);
		
		//ZFi
		Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_SETUMEI_1_U + i], 
			NULL, FONT_SYSTEM, MSGCOLOR_SETUMEI, PALOFS_SETUMEI,
			PLTTID_SUB_FONTACT, FontSetumeiPos[i][0][0], FontSetumeiPos[i][0][1], FONTOAM_LEFT,
			&mdw->exbmp_explain_u[i]);
		
		//ZFi
		Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_SETUMEI_1_D + i], 
			NULL, FONT_SYSTEM, MSGCOLOR_SETUMEI, PALOFS_SETUMEI,
			PLTTID_SUB_FONTACT, FontSetumeiPos[i][1][0], FontSetumeiPos[i][1][1], FONTOAM_LEFT,
			&mdw->exbmp_explain_d[i]);
		
		//莝ZȂȂAtHgOBJojbVg
		if(wazano[i] == 0){
			FONTOAM_SetDrawFlag(aci->font_actor[FA_NO_WAZA_1 + i].fontoam, FALSE);
			FONTOAM_SetDrawFlag(aci->font_actor[FA_NO_SETUMEI_1_U + i].fontoam, FALSE);
			FONTOAM_SetDrawFlag(aci->font_actor[FA_NO_SETUMEI_1_D + i].fontoam, FALSE);
		}
	}

	//-- Z^CvCGR] --//
	{
		for(i = 0; i < WAZA_TEMOTI_MAX; i++){
			if(wazano[i] != 0){
				int con_type;
				con_type = mdw->con_type[i];
				Sub_WazaTypeCGRTrans(aci, con_type, i);
			}
			else{
				Sub_WazaTypeCGRTrans(aci, -1, i);
			}
		}
	}

	//-- 2xAgpZ`FbN --//
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		if(wazano[i] != 0 
				&& AT_WazaConsecutiveCheck(aci->a_game, aci->sys->c_game->my_breeder_no, 
				wazano[i]) == FALSE){
			//2xAgpŘAZłȂ̂ȂAÂă^b`oȂ悤ɂ
		//	SoftFadePfd(aci->sys->pfd, FADE_SUB_BG, (WAZATYPE_START_PALPOS + i) * 16, 16, 
		//		NOT_TOUCH_WAZA_EVY, NOT_TOUCH_WAZA_COLOR);
			PaletteWorkSet(aci->sys->pfd, 
				&aci->pal_buf[PALBUF_COMMAND][ACI_NOT_SELECT_PANEL_PALNO * 16], 
				FADE_SUB_BG, (WAZATYPE_START_PALPOS + i) * 16, 0x20);
			
			GF_ASSERT(aci->not_touch_pos == NOT_TOUCH_WAZA_POS_NULL && "2ȏ̋ZAgpsԂɂȂĂ܂");
			aci->not_touch_pos = i;
		}
	}

	//ReXg^CvACR
	Sub_ConTypeIconCreateAll(aci, wazano);
	
	//APlEWQl
	{
		int ap_point;
		int heart_num, loop;
		
		//AN^[Zbg
		for(i = 0; i < WAZA_TEMOTI_MAX; i++){
			if(wazano[i] == 0){
				continue;
			}
			ap_point = ConTool_GetAPWaza_App(appeal_no[i]);
			heart_num = MATH_IAbs(ap_point) / APP_APPEAL_ICON_ONE_POINT;
			GF_ASSERT(heart_num <= APP_HEART_MAX);
			for(loop = 0; loop < heart_num; loop++){
				GF_ASSERT(aci->app_heart_cap[i][loop] == NULL);
				aci->app_heart_cap[i][loop] = ACIT_AppHeartActorSet(
					aci->sys->csp, aci->sys->crp, 
					AppHeartPos[i][0] + APP_HEART_SPACE_X * loop, 
					AppHeartPos[i][1], ap_point);
			}
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   AINPUT_TYPE_BBGCreateɌĂ΂R[obN֐
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   select_bg		\BG^Cv(AINPUT_TYPE_???)
 * @param   force_put		TRUE:]AFALSE:ɓf[^]ĂȂē]͂Ȃ
 */
//--------------------------------------------------------------
static void BGCallback_JudgeSelect(ACI_PARAM_PTR aci, int select_bg, int force_put)
{
	int i;
	GF_BGL_INI *bgl;
	STRBUF *modoru_src;
	MEMORY_DECORD_WORK *mdw;

	mdw = &aci->memory_decord;
	bgl = aci->sys->bgl;

	for(i = 0; i < JUDGE_MAX; i++){
		Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_JUDGE_1 + i], 
			NULL, FONT_BUTTON, MSGCOLOR_JUDGE, PALOFS_JUDGE,
			PLTTID_SUB_FONTACT, FontJudgePos[i][0], FontJudgePos[i][1], FONTOAM_CENTER, 
			&mdw->exbmp_judge[i]);
	}
	
	modoru_src = MSGMAN_AllocString(aci->sys->actin_msg, CAMSG_MODORU);
	Sub_FontOamCreate(aci, &aci->font_actor[FA_NO_JUDGE_1 + i], 
			modoru_src, FONT_BUTTON, 
			MSGCOLOR_JUDGE, PALOFS_JUDGE,
			PLTTID_SUB_FONTACT, FONT_JUDGE_MODORU_X, FONT_JUDGE_MODORU_Y, FONTOAM_CENTER, NULL);
	STRBUF_Delete(modoru_src);
	
	//R̈̃n[gACR
	aci->special_heart_cap = ACIT_SubHeartJudgeActorAdd(aci->sys->csp, 
		aci->sys->crp, aci->sys->c_game->special_judge_no);
}



//==============================================================================
//
//	^b`plɌĂ΂R[obN֐
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   AINPUT_TYPE_AŃ^b`plɌĂяoR[obN֐
 *
 * @param   aci			BIVXe[Nւ̃|C^
 * @param   tp_ret		^b`pl(bmd->tpd_ret̒lRECT_HIT_NONE)
 * @param   panel_pal	pl̃pbgԍ
 * 
 * @retval  tp_retԂ(̒ŕύXKvȂȂAœnꂽl̂܂ܕԂ)
 */
//--------------------------------------------------------------
static int TPCallback_WazaSelect(ACI_PARAM_PTR aci, int tp_ret, int panel_pal)
{
	u32 rd_no;
	int wazano;
	const s16 *scrn_offset;
	const REWRITE_SCRN_RECT *scrn_range;
	
	rd_no = tp_ret;
	switch(tp_ret){
	case RECT_HIT_NONE:
	default:
		return RECT_HIT_NONE;
	case ACTIN_TP_WAZA_1:
	case ACTIN_TP_WAZA_2:
	case ACTIN_TP_WAZA_3:
	case ACTIN_TP_WAZA_4:
		wazano = PokeParaGet(aci->sys->c_game->pp[aci->sys->c_game->my_breeder_no], 
			ID_PARA_waza1 + tp_ret, NULL);
		if(wazano == 0 || aci->not_touch_pos == (tp_ret - ACTIN_TP_WAZA_1)){
			return RECT_HIT_NONE;	//ꂽꏊ̎莝ZȂ
		}
		scrn_offset = WazaButtonScrnOffset[rd_no];
		scrn_range = &WazaButtonScrnRect[rd_no];
		break;
	}
	
	ColorEffTCB_PointFadeSet(aci, panel_pal);
	
	EffectTCB_Add(Effect_WazaButtonDown, aci);
	aci->effect_work.paracgr.scrn_offset = scrn_offset;
	aci->effect_work.paracgr.scrn_range = scrn_range;
	aci->effect_work.paracgr.scrnbuf_no = SCRNBUF_COMMAND_WAZA;
	aci->effect_work.paracgr.tp_ret = tp_ret;
	return tp_ret;
}

//--------------------------------------------------------------
/**
 * @brief   AINPUT_TYPE_BŃ^b`plɌĂяoR[obN֐
 *
 * @param   aci			BIVXe[Nւ̃|C^
 * @param   tp_ret		^b`pl(bmd->tpd_ret̒lRECT_HIT_NONE)
 * @param   panel_pal	pl̃pbgԍ
 * 
 * @retval  tp_retԂ(̒ŕύXKvȂȂAœnꂽl̂܂ܕԂ)
 */
//--------------------------------------------------------------
static int TPCallback_JudgeSelect(ACI_PARAM_PTR aci, int tp_ret, int panel_pal)
{
	int fa_no;
	int special;
	
	switch(tp_ret){
	case RECT_HIT_NONE:
	default:
		return tp_ret;
	case ACTIN_TP_JUDGE_1:
		fa_no = FA_NO_JUDGE_1;
		break;
	case ACTIN_TP_JUDGE_2:
		fa_no = FA_NO_JUDGE_2;
		break;
	case ACTIN_TP_JUDGE_3:
		fa_no = FA_NO_JUDGE_3;
		break;
	case ACTIN_TP_JUDGE_MODORU:
		fa_no = FA_NO_JUDGE_MODORU;
		break;
	}
	
	//RI`FbN
	special = (tp_ret == aci->sys->c_game->special_judge_no) ? TRUE:FALSE;

	ColorEffTCB_PointFadeSet(aci, panel_pal);
	
	EffectTCB_Add(Effect_ButtonDown, aci);
	aci->effect_work.paracgr.scrn_offset = JudgeButtonScrnOffset[tp_ret];
	aci->effect_work.paracgr.scrn_range = &JudgeButtonScrnRect[tp_ret];
	aci->effect_work.paracgr.scrnbuf_no = SCRNBUF_COMMAND_JUDGE;
	aci->effect_work.paracgr.tp_ret = tp_ret;
	aci->effect_work.paracgr.fa_no = fa_no;
	if(special == TRUE){
		aci->effect_work.paracgr.cap[0] = aci->special_heart_cap;
	}

	return tp_ret;
}




//==============================================================================
//
//	Tu֐
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   w͈͂̃XN[obt@wR[hŃNA
 *
 * @param   rsr[]			NA͈
 * @param   rsr_num			rsrf[^
 * @param   bgl				BGLf[^
 * @param   frame_no		t[ԍ
 * @param   clear_code		NA[R[h
 */
//--------------------------------------------------------------
static void Sub_ScrnErase(const REWRITE_SCRN_RECT rsr[], int rsr_num, GF_BGL_INI *bgl, 
	int frame_no, u16 clear_code)
{
	u16 *buf;
	int i, y;
	
	buf = GF_BGL_ScreenAdrsGet(bgl, frame_no);
	GF_ASSERT(buf != NULL);

	for(i = 0; i < rsr_num; i++){
		for(y = rsr[i].top; y <= rsr[i].bottom; y++){
			MI_CpuFill16(&buf[0x20*y + rsr[i].left], clear_code, 
				(rsr[i].right - rsr[i].left + 1) * 2);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   tHgOAM쐬
 *
 * @param   aci			BIVXe[Nւ̃|C^
 * @param   font_actor	tHgOAM֘Ã[N
 * @param   str			
 * @param   font_type	tHg^Cv(FONT_SYSTEM)
 * @param   color		tHgJ[\
 * @param   pal_offset	pbgԍItZbg
 * @param   pal_id		o^JnpbgID
 * @param   x			WX
 * @param   y			WY
 * @param   pos_center  FONTOAM_LEFT(X[W) or FONTOAM_CENTER(XSW)
 * @param   ex_bmpwin	ĂяoŃtHgOAMɊ֘AtBMPWINĂꍇ͂œnB
 *          			NULL̏ꍇ͒ō쐬܂B(ex_bmpwingpꍇstrNULLOK)
 */
//--------------------------------------------------------------
static void Sub_FontOamCreate(ACI_PARAM_PTR aci, FONT_ACTOR *font_actor, const STRBUF *str, 
	FONT_TYPE font_type, GF_PRINTCOLOR color, int pal_offset, int pal_id, 
	int x, int y, int pos_center, FONT_EX_BMPWIN *ex_bmpwin)
{
	FONTOAM_INIT finit;
	GF_BGL_BMPWIN bmpwin;
	CHAR_MANAGER_ALLOCDATA cma;
	int vram_size;
	FONTOAM_OBJ_PTR fontoam;
	GF_BGL_INI *bgl;
	CATS_RES_PTR crp;
	int font_len, char_len;
	
	GF_ASSERT(font_actor->fontoam == NULL);
	
	bgl = aci->sys->bgl;
	crp = aci->sys->crp;
	
	//̃hbgAgpLZo
	if(ex_bmpwin == NULL){
		FontLenGet(str, font_type, &font_len, &char_len);
	}
	else{
		font_len = ex_bmpwin->font_len;
		char_len = ex_bmpwin->char_len;
	}

	//BMP쐬
	if(ex_bmpwin == NULL){
		GF_BGL_BmpWinInit(&bmpwin);
		GF_BGL_BmpWinObjAdd(bgl, &bmpwin, char_len, 16 / 8, 0, 0);
		GF_STR_PrintExpand(&bmpwin, font_type, str, 0, 0, MSG_NO_PUT, color, 
			PANEL_MSG_MARGIN, 0, NULL);
//		GF_STR_PrintColor(&bmpwin, font_type, str, 0, 0, MSG_NO_PUT, color, NULL );
	}
	else{
		bmpwin = ex_bmpwin->bmpwin;
	}

	vram_size = FONTOAM_NeedCharSize(&bmpwin, NNS_G2D_VRAM_TYPE_2DSUB,  HEAPID_ACTIN);
	CharVramAreaAlloc(vram_size, CHARM_CONT_AREACONT, NNS_G2D_VRAM_TYPE_2DSUB, &cma);
	
	//WʒuC
	if(pos_center == FONTOAM_CENTER){
		x -= font_len / 2;
	}
//	y += SUB_SURFACE_Y_INTEGER - 8;
	y += ACTIN_SUB_ACTOR_DISTANCE_INTEGER - 8;
	
	finit.fontoam_sys = aci->fontoam_sys;
	finit.bmp = &bmpwin;
	finit.clact_set = CATS_GetClactSetPtr(crp);
	finit.pltt = CATS_PlttProxy(crp, pal_id);
	finit.parent = NULL;
	finit.char_ofs = cma.alloc_ofs;
	finit.x = x;
	finit.y = y;
	finit.bg_pri = PANEL_MSG_BGPRI;
	finit.soft_pri = PANEL_MSG_SOFTPRI;
	finit.draw_area = NNS_G2D_VRAM_TYPE_2DSUB;
	finit.heap = HEAPID_ACTIN;
	
	fontoam = FONTOAM_Init(&finit);
//	FONTOAM_SetPaletteOffset(fontoam, pal_offset);
	FONTOAM_SetPaletteOffsetAddTransPlttNo(fontoam, pal_offset);
	FONTOAM_SetMat(fontoam, x, y);
	
	//
	if(ex_bmpwin == NULL){
		GF_BGL_BmpWinDel(&bmpwin);
	}
	
	font_actor->fontoam = fontoam;
	font_actor->cma = cma;
	font_actor->font_len = font_len;
}

//--------------------------------------------------------------
/**
 * @brief   ĂtHgOAMSč폜
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_FontOamDeleteAll(ACI_PARAM_PTR aci)
{
	int i;
	
	for(i = 0; i < FA_NO_MAX; i++){
		if(aci->font_actor[i].fontoam != NULL){
			FONTOAM_Delete(aci->font_actor[i].fontoam);
			CharVramAreaFree(&aci->font_actor[i].cma);
			aci->font_actor[i].fontoam = NULL;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   Rn[gSč폜
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_SubHeartJudgeDeleteAll(ACI_PARAM_PTR aci)
{
	if(aci->special_heart_cap != NULL){
		ACIT_SubHeartJudgeActorDel(aci->special_heart_cap);
		aci->special_heart_cap = NULL;
	}
}

//--------------------------------------------------------------
/**
 * @brief   APln[gSč폜
 * @param   aci			BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_AppHeartDeleteAll(ACI_PARAM_PTR aci)
{
	int i, k;
	
	for(k = 0; k < WAZA_TEMOTI_MAX; k++){
		for(i = 0; i < APP_HEART_MAX; i++){
			if(aci->app_heart_cap[k][i] != NULL){
				ACIT_AppHeartActorDel(aci->app_heart_cap[k][i]);
				aci->app_heart_cap[k][i] = NULL;
			}
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACRSĐ
 *
 * @param   aci		BIVXe[Nւ̃|C^
 * @param   wazano[]	莝̋Zԍzւ̃|C^(WAZA_TEMOTI_MAX鎖!)
 */
//--------------------------------------------------------------
static void Sub_ConTypeIconCreateAll(ACI_PARAM_PTR aci, u16 wazano[])
{
	int i;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;
	TCATS_OBJECT_ADD_PARAM_S obj_param;
	int con_type;

	csp = aci->sys->csp;
	crp = aci->sys->crp;

	obj_param = ConTypeIconObjParam;
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		GF_ASSERT(aci->icon_cap[i] == NULL);
		if(wazano[i] != 0){
			con_type = aci->memory_decord.con_type[i];
			
			obj_param.id[CLACT_U_CHAR_RES] = CHARID_CONTYPE_ICON_1 + i;
			obj_param.x = WazaIconPos[i][0];
			obj_param.y = WazaIconPos[i][1];
			aci->icon_cap[i] = ConTypeIcon_ActorCreate(csp, crp, 
				con_type, &obj_param);
			CATS_ObjectPosSetCap_SubSurface(aci->icon_cap[i], obj_param.x, obj_param.y, 
				ACTIN_SUB_ACTOR_DISTANCE);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACRSč폜
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_ConTypeIconDeleteAll(ACI_PARAM_PTR aci)
{
	int i;
	CATS_SYS_PTR csp;
	CATS_RES_PTR crp;

	csp = aci->sys->csp;
	crp = aci->sys->crp;

	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		if(aci->icon_cap[i] != NULL){
			ConTypeIcon_ActorDelete(aci->icon_cap[i]);
			aci->icon_cap[i] = NULL;
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   XN[
 *
 * @param   aci				ACIVXe[Nւ̃|C^
 * @param   scrn_offset		ZXN[l
 * @param   range			XN[͈
 * @param   scrnbuf_no		f[^ƂȂXN[obt@̔ԍ
 * @param   anm_no			Ajԍ
 */
//--------------------------------------------------------------
static void Sub_ScrnOffsetRewrite(ACI_PARAM_PTR aci, const s16 *scrn_offset, 
	const REWRITE_SCRN_RECT *range, int scrnbuf_no, int anm_no)
{
	int x, y;
	GF_BGL_INI *bgl;
	u16 *scrn, *write_scrn;
	u16 *src_scrn, *read_scrn;
	int add_scrn;
	
	bgl = aci->sys->bgl;
	scrn = GF_BGL_ScreenAdrsGet(bgl, ACTINSUB_FRAME_PANEL);
	src_scrn = aci->scrn_buf[scrnbuf_no];
	add_scrn = scrn_offset[anm_no];
	
	for(y = range->top; y <= range->bottom; y++){
		write_scrn = &scrn[y * 32];
		read_scrn = &src_scrn[y * 32];
		for(x = range->left; x <= range->right; x++){
			write_scrn[x] = read_scrn[x] + add_scrn;
		}
	}
	
	GF_BGL_LoadScreenV_Req(bgl, ACTINSUB_FRAME_PANEL);
}

//--------------------------------------------------------------
/**
 * @brief   Z^CvCGRf[^
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   con_type		ReXgZ^Cv(莝̏ꍇ-1)
 * @param   waza_pos		莝̋Z̈ʒu(0`3)
 */
//--------------------------------------------------------------
static void Sub_WazaTypeCGRTrans(ACI_PARAM_PTR aci, int con_type, int waza_pos)
{
#if 0
	GF_BGL_INI *bgl;
	u32 screen_type;
	
	bgl = aci->sys->bgl;
	screen_type = GF_BGL_ScreenTypeGet(bgl, ACTINSUB_FRAME_PANEL);
	
	WazaPanel_EasyCharLoad(bgl, waza_type, HEAPID_ACTIN, ACTINSUB_FRAME_PANEL, 
		WazaTypeCgrPos[waza_pos], screen_type);
	WazaPanel_EasyPalLoad(aci->sys->pfd, waza_type, HEAPID_ACTIN, FADE_SUB_BG, 
		WAZATYPE_START_PALPOS + waza_pos);
#endif
	const u16 * const type_pal_tbl[] = {
		&con_engi_type_ncl[16 * 3],		//CONTYPE_STYLE
		&con_engi_type_ncl[16 * 4],		//CONTYPE_BEAUTIFUL
		&con_engi_type_ncl[16 * 1],		//CONTYPE_CUTE
		&con_engi_type_ncl[16 * 2],		//CONTYPE_CLEVER
		&con_engi_type_ncl[16 * 0],		//CONTYPE_STRONG
	};
	
	if(con_type != -1){
		PaletteWorkSet(aci->sys->pfd, type_pal_tbl[con_type], FADE_SUB_BG, 
			(WAZATYPE_START_PALPOS + waza_pos) * 16, 0x20);
	}
	else{
		Sub_ScrnOffsetRewrite(aci, &WazaButtonNotTouchScrnOffset[waza_pos], 
			&WazaButtonNotTouchScrnRect[waza_pos], SCRNBUF_COMMAND_WAZA, 0);
		PaletteWorkSet(aci->sys->pfd, 
			&aci->pal_buf[PALBUF_COMMAND][ACI_NOT_SELECT_PANEL_PALNO * 16], 
			FADE_SUB_BG, (WAZATYPE_START_PALPOS + waza_pos) * 16, 0x20);
	}
}

//--------------------------------------------------------------
/**
 * @brief   wiȊÕt[SĔ\ɂ
 */
//--------------------------------------------------------------
static void Sub_BackScrnOnlyVisible(void)
{
	int i;
	
	for(i = 0; i < ACI_BG_NUM; i++){
		if(GF_BGL_FRAME0_S + i != ACTINSUB_FRAME_BACK){
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_OFF);
		}
		else{
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_ON);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   pl^b`GtFNgIAwî݂ɂ邽߂̏FX(tHgOBJ̍폜Ƃ)
 * @param   none		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_TouchEndDelete(ACI_PARAM_PTR aci)
{
	Sub_SceneOBJDelete(aci);
//	VWaitTCB_Add(VWait_BackScrnOnlyVisible, aci, VWAIT_TCBPRI_BACKSCRN_VISIBLE);
}

//--------------------------------------------------------------
/**
 * @brief   BG^Cv؂ւ閈ɍ폜Kv̂OBJDelete
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Sub_SceneOBJDelete(ACI_PARAM_PTR aci)
{
	Sub_SubHeartJudgeDeleteAll(aci);
	Sub_AppHeartDeleteAll(aci);
	Sub_ConTypeIconDeleteAll(aci);
	Sub_FontOamDeleteAll(aci);
}



//==============================================================================
//
//	GtFNgTCB
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   GtFNgTCB𐶐
 *
 * @param   func		TCBɃZbg֐|C^
 * @param   aci			BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void EffectTCB_Add(TCB_FUNC func, ACI_PARAM_PTR aci)
{
	GF_ASSERT(aci->effect_tcb == NULL);
	
	MI_CpuClear8(&aci->effect_work, sizeof(ACI_EFFECT_WORK));
	aci->effect_tcb = TCB_Add(func, aci, TCBPRI_AINPUT_EFFECT);
}

//--------------------------------------------------------------
/**
 * @brief   GtFNgTCB폜
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void EffectTCB_Delete(ACI_PARAM_PTR aci)
{
	if(aci->effect_tcb != NULL){
		TCB_Delete(aci->effect_tcb);
		aci->effect_tcb = NULL;
		MI_CpuClear8(&aci->effect_work, sizeof(ACI_EFFECT_WORK));
	}
}


//--------------------------------------------------------------
/**
 * @brief   plL]Ajsď܂B
 *          1̃plɑ΂1̃tHgOBJZbgɂȂĂ̗p̔ėp^XNł
 *
 * @param   tcb		TCBւ̃|C^
 * @param   work	BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Effect_ButtonDown(TCB_PTR tcb, void *work)
{
	ACI_PARAM_PTR aci = work;
	GF_BGL_INI *bgl;
	int x, y;
	int i;
	
	bgl = aci->sys->bgl;
	
	switch(aci->effect_work.seq){
	case 0:
		Sub_ScrnOffsetRewrite(aci, aci->effect_work.paracgr.scrn_offset, 
			aci->effect_work.paracgr.scrn_range, aci->effect_work.paracgr.scrnbuf_no, 2);
		
		FONTOAM_GetMat(aci->font_actor[aci->effect_work.paracgr.fa_no].fontoam, &x, &y);
		FONTOAM_SetMat(aci->font_actor[aci->effect_work.paracgr.fa_no].fontoam, 
			x, y + SCRN_SCROLL_A_EFF_Y);
		
		for(i = 0; i < PARACGR_CAP_MAX; i++){
			if(aci->effect_work.paracgr.cap[i] != NULL){
				CATS_ObjectPosMove(aci->effect_work.paracgr.cap[i]->act, 0, SCRN_SCROLL_A_EFF_Y);
			}
		}
		
		aci->effect_work.seq++;
		break;
	case 1:
		aci->effect_work.wait++;
		if(aci->effect_work.wait <= SCRN_TOUCH_ANM_WAIT){
			break;
		}
		aci->effect_work.wait = 0;
		aci->effect_work.seq++;
		//break;

	case 2:
		Sub_ScrnOffsetRewrite(aci, aci->effect_work.paracgr.scrn_offset, 
			aci->effect_work.paracgr.scrn_range, aci->effect_work.paracgr.scrnbuf_no, 1);
		
		FONTOAM_GetMat(aci->font_actor[aci->effect_work.paracgr.fa_no].fontoam, &x, &y);
		FONTOAM_SetMat(aci->font_actor[aci->effect_work.paracgr.fa_no].fontoam, 
			x, y + SCRN_SCROLL_BACK_A_EFF_Y);
		
		for(i = 0; i < PARACGR_CAP_MAX; i++){
			if(aci->effect_work.paracgr.cap[i] != NULL){
				CATS_ObjectPosMove(aci->effect_work.paracgr.cap[i]->act, 
					0, SCRN_SCROLL_BACK_A_EFF_Y);
			}
		}
		
		aci->effect_work.seq++;
		break;
	default:
		aci->effect_work.wait++;
		if(aci->effect_work.wait > SCRN_TOUCH_WAIT){
			Sub_TouchEndDelete(aci);
			EffectTCB_Delete(aci);
			return;
		}
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   plL]Ajsď܂B
 *          ZIpłB
 *
 * @param   tcb		TCBւ̃|C^
 * @param   work	ACIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void Effect_WazaButtonDown(TCB_PTR tcb, void *work)
{
	ACI_PARAM_PTR aci = work;
	GF_BGL_INI *bgl;
	int x, y;
	int fa_waza, fa_up, fa_down;
	int cap_icon, wazano;
	u16 wazano_array[WAZA_TEMOTI_MAX];
	int i, wazapos;
	
	bgl = aci->sys->bgl;
	
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		wazano_array[i] = PokeParaGet(aci->sys->c_game->pp[aci->sys->c_game->my_breeder_no], 
			ID_PARA_waza1 + i, NULL);
	}

	switch(aci->effect_work.paracgr.tp_ret){
	case ACTIN_TP_WAZA_1:
		fa_waza = FA_NO_WAZA_1;
		fa_up = FA_NO_SETUMEI_1_U;
		fa_down = FA_NO_SETUMEI_1_D;
		cap_icon = 0;
		wazano = wazano_array[0];
		wazapos = 0;
		break;
	case ACTIN_TP_WAZA_2:
		fa_waza = FA_NO_WAZA_2;
		fa_up = FA_NO_SETUMEI_2_U;
		fa_down = FA_NO_SETUMEI_2_D;
		cap_icon = 1;
		wazano = wazano_array[1];
		wazapos = 1;
		break;
	case ACTIN_TP_WAZA_3:
		fa_waza = FA_NO_WAZA_3;
		fa_up = FA_NO_SETUMEI_3_U;
		fa_down = FA_NO_SETUMEI_3_D;
		cap_icon = 2;
		wazano = wazano_array[2];
		wazapos = 2;
		break;
	case ACTIN_TP_WAZA_4:
		fa_waza = FA_NO_WAZA_4;
		fa_up = FA_NO_SETUMEI_4_U;
		fa_down = FA_NO_SETUMEI_4_D;
		cap_icon = 3;
		wazano = wazano_array[3];
		wazapos = 3;
		break;
//	case SELECT_CANCEL:		̏LZ͂Ȃ@2005.12.03(y)
	default:
		fa_waza = 0;
		fa_up = 0;
		fa_down = 0;
		cap_icon = 0;
		wazano = 0;
		break;
	}
	
	switch(aci->effect_work.seq){
	case 0:
		Sub_ScrnOffsetRewrite(aci, aci->effect_work.paracgr.scrn_offset, 
			aci->effect_work.paracgr.scrn_range, aci->effect_work.paracgr.scrnbuf_no, 2);
		
		if(1){	//aci->effect_work.paracgr.tp_ret != SELECT_CANCEL){
			FONTOAM_GetMat(aci->font_actor[fa_waza].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_waza].fontoam, x, y + SCRN_SCROLL_A_EFF_Y);
			FONTOAM_GetMat(aci->font_actor[fa_up].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_up].fontoam, x, y + SCRN_SCROLL_A_EFF_Y);
			FONTOAM_GetMat(aci->font_actor[fa_down].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_down].fontoam, x, y + SCRN_SCROLL_A_EFF_Y);
			if(wazano != 0){
				CATS_ObjectPosMove(aci->icon_cap[cap_icon]->act, 0, SCRN_SCROLL_A_EFF_Y);
				for(i = 0; i < APP_HEART_MAX; i++){
					if(aci->app_heart_cap[wazapos][i] != NULL){
						CATS_ObjectPosMove(aci->app_heart_cap[wazapos][i]->act, 0, 
							SCRN_SCROLL_A_EFF_Y);
					}
				}
			}
		}
		else{
		#if 0	//̂ƂLZȂ 2005.12.02()
			FontOBJ_PosGet(&aci->font_actor[FA_NO_WAZA_MODORU], FONTOBJ_POS_LEFT, &x, &y);
			FontOBJ_PosSet(&aci->font_actor[FA_NO_WAZA_MODORU], FONTOBJ_POS_LEFT, 
				x, y + SCRN_SCROLL_A_EFF_Y);
		#endif
		}
		
		aci->effect_work.seq++;
		break;
	case 1:
		aci->effect_work.wait++;
		if(aci->effect_work.wait <= SCRN_TOUCH_ANM_WAIT){
			break;
		}
		aci->effect_work.wait = 0;
		aci->effect_work.seq++;
		//break;

	case 2:
		Sub_ScrnOffsetRewrite(aci, aci->effect_work.paracgr.scrn_offset, 
			aci->effect_work.paracgr.scrn_range, aci->effect_work.paracgr.scrnbuf_no, 1);
		
		if(1){	//aci->effect_work.paracgr.tp_ret != SELECT_CANCEL){
			FONTOAM_GetMat(aci->font_actor[fa_waza].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_waza].fontoam, x, y + SCRN_SCROLL_BACK_A_EFF_Y);
			FONTOAM_GetMat(aci->font_actor[fa_up].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_up].fontoam, x, y + SCRN_SCROLL_BACK_A_EFF_Y);
			FONTOAM_GetMat(aci->font_actor[fa_down].fontoam, &x, &y);
			FONTOAM_SetMat(aci->font_actor[fa_down].fontoam, x, y + SCRN_SCROLL_BACK_A_EFF_Y);
			if(wazano != 0){
				CATS_ObjectPosMove(aci->icon_cap[cap_icon]->act, 0, SCRN_SCROLL_BACK_A_EFF_Y);
				for(i = 0; i < APP_HEART_MAX; i++){
					if(aci->app_heart_cap[wazapos][i] != NULL){
						CATS_ObjectPosMove(aci->app_heart_cap[wazapos][i]->act, 0, 
							SCRN_SCROLL_BACK_A_EFF_Y);
					}
				}
			}
		}
		else{
		#if 0	//̂ƂLZȂ 2005.12.02()
			FontOBJ_PosGet(&aci->font_actor[FA_NO_WAZA_MODORU], FONTOBJ_POS_LEFT, &x, &y);
			FontOBJ_PosSet(&aci->font_actor[FA_NO_WAZA_MODORU], FONTOBJ_POS_LEFT, 
				x, y + SCRN_SCROLL_BACK_A_EFF_Y);
		#endif
		}
		
		aci->effect_work.seq++;
		break;
	default:
		aci->effect_work.wait++;
		if(aci->effect_work.wait > SCRN_TOUCH_WAIT){
			Sub_TouchEndDelete(aci);
			EffectTCB_Delete(aci);
			return;
		}
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   J[GtFNgTCB𐶐
 *
 * @param   func		TCBɃZbg֐|C^
 * @param   aci			BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ColorEffTCB_Add(TCB_FUNC func, ACI_PARAM_PTR aci)
{
	GF_ASSERT(aci->color_eff_tcb == NULL);
	
	MI_CpuClear8(&aci->color_work, sizeof(ACI_COLOR_EFF_WORK));
	aci->color_eff_tcb = TCB_Add(func, aci, TCBPRI_AINPUT_COLOR_EFFECT);
}

//--------------------------------------------------------------
/**
 * @brief   J[GtFNgTCB폜
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ColorEffTCB_Delete(ACI_PARAM_PTR aci)
{
	if(aci->color_eff_tcb != NULL){
		TCB_Delete(aci->color_eff_tcb);
		aci->color_eff_tcb = NULL;
		MI_CpuClear8(&aci->color_work, sizeof(ACI_COLOR_EFF_WORK));
	}
}

//--------------------------------------------------------------
/**
 * @brief   ̈ʒũJ[tF[h^XN𐶐
 * @param   aci		BIVXe[Nւ̃|C^
 * @param   pal_pos	tF[hpbgԍ
 */
//--------------------------------------------------------------
static void ColorEffTCB_PointFadeSet(ACI_PARAM_PTR aci, int pal_pos)
{
	if(pal_pos == 0xff){
		return;
	}
	
	ColorEffTCB_Add(ColorEff_PointFade, aci);
	aci->color_work.pal_pos = pal_pos;
}

//--------------------------------------------------------------
/**
 * @brief   ̈ʒũJ[tF[h
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void ColorEff_PointFade(TCB_PTR tcb, void *work)
{
	ACI_PARAM_PTR aci = work;
	ACI_COLOR_EFF_WORK *cw;
	PALETTE_FADE_PTR pfd;
	int i, end;
	
	cw = &aci->color_work;
	pfd = aci->sys->pfd;
	end = FALSE;
	
	switch(cw->seq){
	case 0:
		cw->evy = TOUCH_FADE_EVY;
		cw->evy_add = -TOUCH_FADE_ADD_EVY;
		//ŏ̌vZ𑫂ł
		cw->evy -= cw->evy_add;
		
		cw->seq++;
		//break;
	case 1:
		cw->evy += cw->evy_add;
		if(cw->evy_add >= 0 && cw->evy >= (16<<8)){
			cw->evy = 16<<8;
			end = TRUE;
		}
		else if(cw->evy_add < 0 && cw->evy <= 0){
			cw->evy = 0;
			end = TRUE;
		}
		
	#if 1
		//Ŝ𔒂
		SoftFadePfd(pfd, FADE_SUB_BG, cw->pal_pos * 16, 16, cw->evy >> 8, 0x7fff);
	#elif 0
		//ŜÂ
		SoftFadePfd(pfd, FADE_SUB_BG, cw->pal_pos * 16, 16, cw->evy >> 8, 0x0000);
		//g
		SoftFadePfd(pfd, FADE_SUB_BG, cw->pal_pos * 16 + 3, 1, cw->evy >> 8, 0x7fff);
	#else
		SoftFadePfd(pfd, FADE_SUB_BG, cw->pal_pos * 16, 16, (cw->evy >> 8) / 2, 0x7fff);
		//ŜÂ
		SoftFadePfd(pfd, FADE_SUB_BG, cw->pal_pos * 16 + 1, 1, cw->evy >> 8, 0x7b1a);
		//g
		SoftFadePfd(pfd, FADE_SUB_BG, cw->pal_pos * 16 + 0xa, 1, cw->evy >> 8, 0x4634);
	#endif
		if(end == TRUE){
			ColorEffTCB_Delete(aci);
			return;
		}
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   MEMORY_DECORD_WORK
 * @param   aci		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void MemoryDecordWorkFree(ACI_PARAM_PTR aci)
{
	int i, client;

	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		if(aci->memory_decord.exbmp_waza[i].bmpwin.chrbuf != NULL){
			GF_BGL_BmpWinDel(&aci->memory_decord.exbmp_waza[i].bmpwin);
		}
		if(aci->memory_decord.exbmp_explain_u[i].bmpwin.chrbuf != NULL){
			GF_BGL_BmpWinDel(&aci->memory_decord.exbmp_explain_u[i].bmpwin);
		}
		if(aci->memory_decord.exbmp_explain_d[i].bmpwin.chrbuf != NULL){
			GF_BGL_BmpWinDel(&aci->memory_decord.exbmp_explain_d[i].bmpwin);
		}
	}

	for(i = 0; i < JUDGE_MAX; i++){
		if(aci->memory_decord.exbmp_judge[i].bmpwin.chrbuf != NULL){
			GF_BGL_BmpWinDel(&aci->memory_decord.exbmp_judge[i].bmpwin);
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   Zp[^̃f[^ɓWJ
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   wazano			Zԍ̓zւ̃|C^(WAZA_TEMOTI_MAX)
 */
//--------------------------------------------------------------
void AINPUT_WazaParaMemoryDecord(ACI_PARAM_PTR aci, u16 wazano[])
{
	MEMORY_DECORD_WORK *mdw;
	int i;
	STRBUF *wazaname_p;
	STRBUF *setumei_u_src, *setumei_d_src, *judge_src;
	u32 u_id, d_id;
	
	mdw = &aci->memory_decord;
	
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		if(wazano[i] != 0){
			mdw->ap_no[i] = WT_WazaDataParaGet(wazano[i], ID_WTD_ap_no);
			mdw->con_type[i] = WT_WazaDataParaGet(wazano[i], ID_WTD_contype);
		}
		else{
			mdw->ap_no[i] = 0;
			mdw->con_type[i] = 0;
		}
		
		//BMPWINFZ
		wazaname_p = MSGDAT_UTIL_GetWazaName(wazano[i], HEAPID_ACTIN);
		FontExBmpwin_FontSet(aci, wazaname_p, FONT_BUTTON, &mdw->exbmp_waza[i], MSGCOLOR_WAZA);
		STRBUF_Delete(wazaname_p);
		
		//BMPWIN:Z
		ConTool_GetAPSetumeiMsgID(mdw->ap_no[i], &u_id, &d_id);
		setumei_u_src = MSGMAN_AllocString(aci->sys->explain_msg, u_id);
		setumei_d_src = MSGMAN_AllocString(aci->sys->explain_msg, d_id);
		FontExBmpwin_FontSet(aci, setumei_u_src, FONT_SYSTEM, &mdw->exbmp_explain_u[i], 
			MSGCOLOR_SETUMEI);
		FontExBmpwin_FontSet(aci, setumei_d_src, FONT_SYSTEM, &mdw->exbmp_explain_d[i], 
			MSGCOLOR_SETUMEI);
		STRBUF_Delete(setumei_u_src);
		STRBUF_Delete(setumei_d_src);
	}
	
	//R
	for(i = 0; i < JUDGE_MAX; i++){
		judge_src = ADV_MSGDAT_GetJudgeName(aci->sys->c_game->jd[i].name_id, HEAPID_ACTIN);
		FontExBmpwin_FontSet(aci, judge_src, FONT_BUTTON, &mdw->exbmp_judge[i], 
			MSGCOLOR_JUDGE);
		STRBUF_Delete(judge_src);
	}

	//-- łɂŃJ[\ --//
	{
		CCURSOR_ResourceLoad(aci->sys->csp, aci->sys->crp, aci->sys->pfd, 
			CHARID_ACTIN_CURSOR, PLTTID_ACTIN_CURSOR,
			CELLID_ACTIN_CURSOR, CELLANMID_ACTIN_CURSOR);
		aci->cursor = CCURSOR_ActorCreate(aci->sys->csp, aci->sys->crp, HEAPID_ACTIN, 
			CHARID_ACTIN_CURSOR, PLTTID_ACTIN_CURSOR, CELLID_ACTIN_CURSOR, CELLANMID_ACTIN_CURSOR, 
			SOFTPRI_CURSOR, BGPRI_CURSOR);
	}
}

//--------------------------------------------------------------
/**
 * @brief   FONT_EX_BMPWINɑ΂ătHgf[^쐬AZbg
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   str				ւ̃|C^
 * @param   font_type		tHg^Cv
 * @param   ex_bmpwin		f[^
 * @param   color			J[
 */
//--------------------------------------------------------------
static void FontExBmpwin_FontSet(ACI_PARAM_PTR aci, const STRBUF *str, FONT_TYPE font_type, 	
	FONT_EX_BMPWIN *ex_bmp, GF_PRINTCOLOR color)
{
	int font_len, char_len;
	
	FontLenGet(str, font_type, &font_len, &char_len);
	ex_bmp->font_len = font_len;
	ex_bmp->char_len = char_len;
	if(ex_bmp->bmpwin.chrbuf != NULL){
		GF_BGL_BmpWinDel(&ex_bmp->bmpwin);
	}
	GF_BGL_BmpWinInit(&ex_bmp->bmpwin);
	GF_BGL_BmpWinObjAdd(aci->sys->bgl, &ex_bmp->bmpwin, char_len, 16 / 8, 0, 0);
	GF_STR_PrintExpand(&ex_bmp->bmpwin, font_type, str, 0, 0, MSG_NO_PUT, color, 
		PANEL_MSG_MARGIN, 0, NULL);
}

//--------------------------------------------------------------
/**
 * @brief   ̒擾
 *
 * @param   str				ւ̃|C^
 * @param   font_type		tHg^Cv
 * @param   ret_dot_len		hbg
 * @param   ret_char_len	L
 */
//--------------------------------------------------------------
static void FontLenGet(const STRBUF *str, FONT_TYPE font_type, int *ret_dot_len, int *ret_char_len)
{
	int dot_len, char_len;
	
	//̃hbgAgpLZo
	dot_len = FontProc_GetPrintStrWidth(font_type, str, PANEL_MSG_MARGIN);
	char_len = dot_len / 8;
	if(FX_ModS32(dot_len, 8) != 0){
		char_len++;
	}
	
	*ret_dot_len = dot_len;
	*ret_char_len = char_len;
}



//==============================================================================
//
//	L[
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   L[͔菈
 * @param   aci		BIVXe[Nւ̃|C^
 * @retval  (Ȃ̏ꍇRECT_HIT_NONE)
 */
//--------------------------------------------------------------
static int CursorCheck(ACI_PARAM_PTR aci)
{
	CURSOR_MOVE *move;
	const BG_MAKE_DATA *bmd;

	move = &aci->cursor_move;
	bmd = &BgMakeData[aci->makedata_no];
	
	if(bmd->cursor_move_func == NULL){
		return RECT_HIT_NONE;
	}
	
	if(move->cursor_on == FALSE){
		if(aci->decend_key == TRUE || 
				(sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B|PAD_BUTTON_X|PAD_BUTTON_Y
				|PAD_KEY_RIGHT|PAD_KEY_LEFT|PAD_KEY_UP|PAD_KEY_DOWN))){
			if(aci->decend_key == FALSE){
				Snd_SePlay(ASE_CCURSOR_MOVE_SE);	//L[ăJ[\\炷
			}
			move->cursor_on = TRUE;
			aci->decend_key = FALSE;
			bmd->cursor_move_func(aci, TRUE);
		}
		return RECT_HIT_NONE;
	}
	
	return bmd->cursor_move_func(aci, FALSE);
}

//--------------------------------------------------------------
/**
 * @brief   J[\ړFZI
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   init_flag		TRUE:
 *
 * @retval  (Ȃ̏ꍇRECT_HIT_NONE)
 */
//--------------------------------------------------------------
static int CursorMove_WazaSelect(ACI_PARAM_PTR aci, int init_flag)
{
	CURSOR_MOVE *move;
	u32 key;
	const BG_MAKE_DATA *bmd;
	int index, i;
	u8 move_data[CURSOR_WAZA_SELECT_Y_MENU_NUM][CURSOR_WAZA_SELECT_X_MENU_NUM];
	ACI_CURSOR_SAVE *cursor_save;
	u16 wazano[WAZA_TEMOTI_MAX];
	
	cursor_save = &aci->cursor_save;
	move = &aci->cursor_move;
	bmd = &BgMakeData[aci->makedata_no];
	for(i = 0;i < WAZA_TEMOTI_MAX; i++){
		wazano[i] = PokeParaGet(aci->sys->c_game->pp[aci->sys->c_game->my_breeder_no], 
			ID_PARA_waza1 + i, NULL);
	}

	if(init_flag == TRUE){
		move->x_menu = cursor_save->waza_x;
		move->y_menu = cursor_save->waza_y;
		index = CursorMoveDataWazaSelect[move->y_menu][move->x_menu];
		if(wazano[index - WAZASELE_INDEX_SKILL_1] == 0){
			cursor_save->waza_x = 0;
			cursor_save->waza_y = 0;
			move->x_menu = 0;
			move->y_menu = 0;
			index = CursorMoveDataWazaSelect[move->y_menu][move->x_menu];
		}
		CCURSOR_PosSetON_Surface(aci->cursor, bmd->tpd[index].rect.left+8, 
			bmd->tpd[index].rect.right-8, 
			bmd->tpd[index].rect.top+8, bmd->tpd[index].rect.bottom-8,
			ACTIN_SUB_ACTOR_DISTANCE);
		return RECT_HIT_NONE;
	}

	MI_CpuCopy8(CursorMoveDataWazaSelect, move_data, 
		CURSOR_WAZA_SELECT_Y_MENU_NUM * CURSOR_WAZA_SELECT_X_MENU_NUM);
#if 0	//莝ZȂꏊJ[\ړo悤ɕύX 2006.05.27(y)
	for(i = 0; i < WAZA_TEMOTI_MAX; i++){
		if(wazano[i] == 0){
			((u8*)move_data)[i] = 0xff;	//莝ZȂ͔͈͂͂
		}
	}
#endif
	
	key = CursorMove_KeyCheckMove(move, 
		CURSOR_WAZA_SELECT_X_MENU_NUM, CURSOR_WAZA_SELECT_Y_MENU_NUM,
		move_data[0]);
	switch(key){
	case PAD_KEY_UP:
	case PAD_KEY_DOWN:
	case PAD_KEY_LEFT:
	case PAD_KEY_RIGHT:
		index = CursorMoveDataWazaSelect[move->y_menu][move->x_menu];
		CCURSOR_PosSetON_Surface(aci->cursor, bmd->tpd[index].rect.left+8, 
			bmd->tpd[index].rect.right-8, 
			bmd->tpd[index].rect.top+8, bmd->tpd[index].rect.bottom-8,
			ACTIN_SUB_ACTOR_DISTANCE);
		break;
	case PAD_BUTTON_DECIDE:
		return CursorMoveDataWazaSelect[move->y_menu][move->x_menu];
	case PAD_BUTTON_CANCEL:
		break;
	}

	return RECT_HIT_NONE;
}

//--------------------------------------------------------------
/**
 * @brief   J[\ʒuۑFR}hI
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   index			I
 */
//--------------------------------------------------------------
static void CursorSave_WazaSelect(ACI_PARAM_PTR aci, int index)
{
	ACI_CURSOR_SAVE *cursor_save;
	int x, y;

	cursor_save = &aci->cursor_save;
	for(y = 0; y < CURSOR_WAZA_SELECT_Y_MENU_NUM; y++){
		for(x = 0; x < CURSOR_WAZA_SELECT_X_MENU_NUM; x++){
			if(index == CursorMoveDataWazaSelect[y][x]){
				cursor_save->waza_x = x;
				cursor_save->waza_y = y;
				return;
			}
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   J[\ړFRI
 *
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   init_flag		TRUE:
 *
 * @retval  (Ȃ̏ꍇRECT_HIT_NONE)
 */
//--------------------------------------------------------------
static int CursorMove_JudgeSelect(ACI_PARAM_PTR aci, int init_flag)
{
	CURSOR_MOVE *move;
	u32 key;
	const BG_MAKE_DATA *bmd;
	int index, i;
	u8 move_data[CURSOR_JUDGE_SELECT_Y_MENU_NUM][CURSOR_JUDGE_SELECT_X_MENU_NUM];
	ACI_CURSOR_SAVE *cursor_save;
	
	cursor_save = &aci->cursor_save;
	move = &aci->cursor_move;
	bmd = &BgMakeData[aci->makedata_no];

	if(init_flag == TRUE){
		move->x_menu = cursor_save->judge_x;
		move->y_menu = cursor_save->judge_y;
		index = CursorMoveDataJudgeSelect[move->y_menu][move->x_menu];
		CCURSOR_PosSetON_Surface(aci->cursor, bmd->tpd[index].rect.left+8, 
			bmd->tpd[index].rect.right-8, 
			bmd->tpd[index].rect.top+8, bmd->tpd[index].rect.bottom-8,
			ACTIN_SUB_ACTOR_DISTANCE);
		return RECT_HIT_NONE;
	}

	MI_CpuCopy8(CursorMoveDataJudgeSelect, move_data, 
		CURSOR_JUDGE_SELECT_Y_MENU_NUM * CURSOR_JUDGE_SELECT_X_MENU_NUM);
	
	key = CursorMove_KeyCheckMove(move, 
		CURSOR_JUDGE_SELECT_X_MENU_NUM, CURSOR_JUDGE_SELECT_Y_MENU_NUM,
		move_data[0]);
	switch(key){
	case PAD_KEY_UP:
	case PAD_KEY_DOWN:
	case PAD_KEY_LEFT:
	case PAD_KEY_RIGHT:
		index = CursorMoveDataJudgeSelect[move->y_menu][move->x_menu];
		CCURSOR_PosSetON_Surface(aci->cursor, bmd->tpd[index].rect.left+8, 
			bmd->tpd[index].rect.right-8, 
			bmd->tpd[index].rect.top+8, bmd->tpd[index].rect.bottom-8,
			ACTIN_SUB_ACTOR_DISTANCE);
		break;
	case PAD_BUTTON_DECIDE:
		return CursorMoveDataJudgeSelect[move->y_menu][move->x_menu];
	case PAD_BUTTON_CANCEL:
		return JUDGESELE_INDEX_CANCEL;
	}

	return RECT_HIT_NONE;
}

//--------------------------------------------------------------
/**
 * @brief   J[\ʒuۑFR}hI
 * @param   aci				BIVXe[Nւ̃|C^
 * @param   index			I
 */
//--------------------------------------------------------------
static void CursorSave_JudgeSelect(ACI_PARAM_PTR aci, int index)
{
	ACI_CURSOR_SAVE *cursor_save;
	int client_no, x, y;

	if(index == JUDGESELE_INDEX_CANCEL){
		return;
	}
	
	cursor_save = &aci->cursor_save;
	for(y = 0; y < CURSOR_JUDGE_SELECT_Y_MENU_NUM; y++){
		for(x = 0; x < CURSOR_JUDGE_SELECT_X_MENU_NUM; x++){
			if(index == CursorMoveDataJudgeSelect[y][x]){
				cursor_save->judge_x = x;
				cursor_save->judge_y = y;
				return;
			}
		}
	}
}

//--------------------------------------------------------------
/**
 * @brief   L[͂ɂJ[\ړ
 *
 * @param   move			J[\ړp[Nւ̃|C^
 * @param   x_menu_num		̃j[
 * @param   y_menu_num		̃j[
 * @param   move_data		ړf[^ւ̃|C^(ړ悪ꏊȂړȂɕKv)
 *                          ̔肪KvłȂȂNULLOK
 *
 * @retval  ꂽL[
 */
//--------------------------------------------------------------
static u32 CursorMove_KeyCheckMove(CURSOR_MOVE *move, int x_menu_num, int y_menu_num, 
	const u8 *move_data)
{
	int old_y_menu, old_x_menu;
	u32 ret_key;
	
	old_x_menu = move->x_menu;
	old_y_menu = move->y_menu;
	
	if(sys.trg & PAD_KEY_UP){
		move->y_menu--;
		if(move->y_menu < 0){
			move->y_menu = 0;//y_menu_num - 1;
		}
		if(move_data != NULL){
			while(move_data[x_menu_num * move->y_menu + move->x_menu] == 0xff){
				move->y_menu--;
				if(move->y_menu < 0){
					move->y_menu = old_y_menu;
					break;
				}
			}
		}
		ret_key = PAD_KEY_UP;
	}
	else if(sys.trg & PAD_KEY_DOWN){
		move->y_menu++;
		if(move->y_menu >= y_menu_num){
			move->y_menu = y_menu_num - 1;//0;
		}
		if(move_data != NULL){
			while(move_data[x_menu_num * move->y_menu + move->x_menu] == 0xff){
				move->y_menu++;
				if(move->y_menu >= y_menu_num){
					move->y_menu = old_y_menu;
					break;
				}
			}
		}
		ret_key = PAD_KEY_DOWN;
	}
	else if(sys.trg & PAD_KEY_LEFT){
		move->x_menu--;
		if(move->x_menu < 0){
			move->x_menu = 0;//x_menu_num - 1;
		}
		if(move_data != NULL){
			while(move_data[x_menu_num * move->y_menu + move->x_menu] == 0xff){
				move->x_menu--;
				if(move->x_menu < 0){
					move->x_menu = old_x_menu;
					break;
				}
			}
		}
		ret_key = PAD_KEY_LEFT;
	}
	else if(sys.trg & PAD_KEY_RIGHT){
		move->x_menu++;
		if(move->x_menu >= x_menu_num){
			move->x_menu = x_menu_num-1;//0;
		}
		if(move_data != NULL){
			while(move_data[x_menu_num * move->y_menu + move->x_menu] == 0xff){
				move->x_menu++;
				if(move->x_menu >= x_menu_num){
					move->x_menu = old_x_menu;
					break;
				}
			}
		}
		ret_key = PAD_KEY_RIGHT;
	}
	else if(sys.trg & PAD_BUTTON_DECIDE){
		ret_key = PAD_BUTTON_DECIDE;
	}
	else if(sys.trg & PAD_BUTTON_CANCEL){
		ret_key = PAD_BUTTON_CANCEL;
	}
	else{
		return 0;
	}
	
	if(move_data != NULL){
		int old_index, new_index;

		old_index = move_data[x_menu_num * old_y_menu + old_x_menu];
		new_index = move_data[x_menu_num * move->y_menu + move->x_menu];
		
		//J[\ړʒumF
		if(old_index == new_index){
			//ړindexςȂ̂ł΃J[\Ẅړ͂Ȃ
			move->x_menu = old_x_menu;
			move->y_menu = old_y_menu;
		}
	}

	if(move->x_menu != old_x_menu || move->y_menu != old_y_menu){
		Snd_SePlay(ASE_CCURSOR_MOVE_SE);
	}
	else{
		if(ret_key & (PAD_KEY_UP|PAD_KEY_DOWN|PAD_KEY_LEFT|PAD_KEY_RIGHT)){
			return 0;
		}
	}

	return ret_key;
}



//==============================================================================
//
//	VuN
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   CGR]s
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VWait_CgrTrans(TCB_PTR tcb, void *work)
{
	ACI_PARAM_PTR aci = work;

	GF_BGL_LoadCharacter(aci->sys->bgl, GF_BGL_FRAME0_S, aci->cgr_char_data->pRawData, 
		ACI_BG_CGR_SIZE, 0);
	sys_FreeMemoryEz(aci->cgr_arc_data);
	aci->cgr_arc_data = NULL;
	
	TCB_Delete(tcb);
}

//--------------------------------------------------------------
/**
 * @brief   et[Visibleݒs
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		BIVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static void VWait_FrameVisibleUpdate(TCB_PTR tcb, void *work)
{
	ACI_PARAM_PTR aci = work;
	const BG_MAKE_DATA *bmd;
	int i;

	bmd = &BgMakeData[aci->makedata_no];
	
	//eBGʂ̕\E\ݒ
	for(i = 0; i < ACI_BG_NUM; i++){
		if(bmd->scr_id[i] == NONE_ID){
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_OFF);
		}
		else{
			GF_BGL_VisibleSet(GF_BGL_FRAME0_S + i, VISIBLE_ON);
		}
	}
	
	TCB_Delete(tcb);
}

//--------------------------------------------------------------
/**
 * @brief   wiȊÕt[SĂ\ɂ
 *
 * @param   tcb		TCBւ̃|C^
 * @param   work	BIVXe[Nւ̃|C^
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void VWait_BackScrnOnlyVisible(TCB_PTR tcb, void *work)
{
	ACI_PARAM_PTR aci = work;

	Sub_BackScrnOnlyVisible();
	TCB_Delete(tcb);
}

