//==============================================================================
/**
 * @file	con_result.h
 * @brief	ReXgʔ\ʂ̃wb_
 * @author	matsuda
 * @date	2006.03.17()
 */
//==============================================================================
#ifndef __CON_RESULT_H__
#define __CON_RESULT_H__

#include "system/procsys.h"
#include "battle/battle_common.h"
#include "system/buflen.h"
#include "contest/contest.h"
#include "system/softsprite.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/gra_tool.h"
#include "system/wordset.h"
#include "system/clact_tool.h"
#include "contest_order.h"
#include "system/fontoam.h"

#include "adv_tool.h"
#include "res_snd_def.h"



//==============================================================================
//	萔`
//==============================================================================
//--------------------------------------------------------------
//	ʔ\ʂ̉ʃ[h
//--------------------------------------------------------------
///݂̉ʃ[h
enum{
	RESDISP_MODE_ANNOUNCE,		///<AiEX
	RESDISP_MODE_RESULT,		///<ʔ\
};

//--------------------------------------------------------------
//	
//--------------------------------------------------------------
///|PʒuZ(C_T[)
#define CONRES_POKEPOS_Z_MAIN		(APPEAR_Z_TYPE_AA)
///|PʒuZ(obN_T[)
#define CONRES_POKEPOS_Z_SUB			(CONRES_POKEPOS_Z_MAIN - 0x80)

///C_T[̃|Pgk(XY)
#define CONRES_POKEAFF_MAIN		(0x0100)
///obN_T[̃|Pgk(XY)
#define CONRES_POKEAFF_BACK		(0x00c0)	//(0x0080)

///_X僁CʂŎgptHgOAM̍ő吔
#define CONRES_FONTOAM_MAX_MAIN	(10)	// 10 = Ƃ肠K

//--------------------------------------------------------------
//	obt@
//--------------------------------------------------------------
///obt@̃TCY
#define CONRES_MESSAGE_BUF_SIZE	(2*160)		///<błPUO

//--------------------------------------------------------------
//	t[ԍ
//--------------------------------------------------------------
///EBhEEbZ[Wʂ̃t[
#define CONRES_FRAME_WIN				(GF_BGL_FRAME1_M)
///GtFNgʂ̃t[
#define CONRES_FRAME_EFF				(GF_BGL_FRAME2_M)
///wiʂ̃t[
#define CONRES_FRAME_BACKGROUND			(GF_BGL_FRAME3_M)

///TuʁFϋqʂ̃t[
#define CONRES_FRAME_SUB_AUDIENCE		(GF_BGL_FRAME0_S)

///BGԍFEBhE
#define CONRES_BGNO_WIN			(1)
///BGԍFGtFNg
#define CONRES_BGNO_EFF			(2)
///BGԍFwi
#define CONRES_BGNO_BACKGROUND	(3)

///GX_WNDԍFGtFNg
#define CONRES_GX_WND_EFF			(GX_WND_PLANEMASK_BG2)

///<3DʂBGvCIeB
#define CONRES_3DBG_PRIORITY		(1)
///EBhEʂBGvCIeB
#define CONRES_BGPRI_WIN			(2)
///GtFNgʂBGvCIeB
#define CONRES_BGPRI_EFF			(1)
///wiʂBGvCIeB
#define CONRES_BGPRI_BACKGROUND		(3)

///<TuʁFwiʂBGvCIeB
///ϋqʂBGvCIeB
#define CONRES_BGPRI_SUB_AUDIENCE	(3)

//--------------------------------------------------------------
//	bEBhE
//--------------------------------------------------------------
///bEBhẼLN^]ItZbg(LN^P)
#define CONRES_TALKWIN_CGX_OFFSET	(1)
///bEBhEwiF
#define CONRES_TALKWIN_BACK_COLOR	(15)
///bEBhẼpbgԍ
#define CONRES_TALKWIN_PALNO		(14)

//--------------------------------------------------------------
//	BMPEBhE
//--------------------------------------------------------------
///BMPEBhECGXGAJnʒu(ItZbg)
#define RES_BMPWIN_CGX_START			(TALK_WIN_CGX_SIZ + CONRES_TALKWIN_CGX_OFFSET)

#define RES_BMPWIN_TALK_COLOR			(13)
#define RES_BMPWIN_TALK_CGX_OFFSET		(RES_BMPWIN_CGX_START)
#define RES_BMPWIN_TALK_POS_X			(0x2)
#define RES_BMPWIN_TALK_POS_Y			(0x13)
#define RES_BMPWIN_TALK_SIZE_X			(27)
#define RES_BMPWIN_TALK_SIZE_Y			(4)
#define RES_BMPWIN_TALK_CGX_SIZE		(RES_BMPWIN_TALK_SIZE_X * RES_BMPWIN_TALK_SIZE_Y)

#define RES_BMPWIN_NAME_COLOR			(RES_BMPWIN_TALK_COLOR)
#define RES_BMPWIN_NAME_GF_COLOR		(GF_PRINTCOLOR_MAKE(1, 2, 0))
#define RES_BMPWIN_NAME_DOT_OFFSET		(3)

#define RES_BMPWIN_NICK_SIZE_X			(8)
#define RES_BMPWIN_NICK_SIZE_Y			(3)		//\ʒu𐔃hbgɂ炷̂3Lɂ܂
#define RES_BMPWIN_NICK_CGX_SIZE		(RES_BMPWIN_NICK_SIZE_X * RES_BMPWIN_NICK_SIZE_Y)
#define RES_BMPWIN_POS_X_NICK			(6)
#define RES_BMPWIN_POS_Y_NICK			(1)
#define RES_BMPWIN_POS_Y_SPACE_NICK		(4)

#define RES_BMPWIN_OYA_SIZE_X			(8)
#define RES_BMPWIN_OYA_SIZE_Y			(3)		//\ʒu𐔃hbgɂ炷̂3Lɂ܂
#define RES_BMPWIN_OYA_CGX_SIZE			(RES_BMPWIN_OYA_SIZE_X * RES_BMPWIN_OYA_SIZE_Y)
#define RES_BMPWIN_POS_X_OYA			(0x10)
#define RES_BMPWIN_POS_Y_OYA			(RES_BMPWIN_POS_Y_NICK)
#define RES_BMPWIN_POS_Y_SPACE_OYA		(RES_BMPWIN_POS_Y_SPACE_NICK)

#define RES_BMPWIN_NICK_CGX_OFFSET_0	(RES_BMPWIN_TALK_CGX_OFFSET + RES_BMPWIN_TALK_CGX_SIZE)
#define RES_BMPWIN_NICK_CGX_OFFSET_1	(RES_BMPWIN_NICK_CGX_OFFSET_0 + RES_BMPWIN_NICK_CGX_SIZE)
#define RES_BMPWIN_NICK_CGX_OFFSET_2	(RES_BMPWIN_NICK_CGX_OFFSET_1 + RES_BMPWIN_NICK_CGX_SIZE)
#define RES_BMPWIN_NICK_CGX_OFFSET_3	(RES_BMPWIN_NICK_CGX_OFFSET_2 + RES_BMPWIN_NICK_CGX_SIZE)

#define RES_BMPWIN_OYA_CGX_OFFSET_0	(RES_BMPWIN_NICK_CGX_OFFSET_3 + RES_BMPWIN_NICK_CGX_SIZE)
#define RES_BMPWIN_OYA_CGX_OFFSET_1	(RES_BMPWIN_OYA_CGX_OFFSET_0 + RES_BMPWIN_OYA_CGX_SIZE)
#define RES_BMPWIN_OYA_CGX_OFFSET_2	(RES_BMPWIN_OYA_CGX_OFFSET_1 + RES_BMPWIN_OYA_CGX_SIZE)
#define RES_BMPWIN_OYA_CGX_OFFSET_3	(RES_BMPWIN_OYA_CGX_OFFSET_2 + RES_BMPWIN_OYA_CGX_SIZE)

//--------------------------------------------------------------
//	BMPEBhE
//--------------------------------------------------------------
enum{
	CONRES_BMPWIN_TALK,		///<bEBhE
	
	CONRES_BMPWIN_NICK_0,	///<jbNl[
	CONRES_BMPWIN_NICK_1,	///<jbNl[
	CONRES_BMPWIN_NICK_2,	///<jbNl[
	CONRES_BMPWIN_NICK_3,	///<jbNl[

	CONRES_BMPWIN_OYA_0,	///<e
	CONRES_BMPWIN_OYA_1,	///<e
	CONRES_BMPWIN_OYA_2,	///<e
	CONRES_BMPWIN_OYA_3,	///<e
	
	CONRES_BMPWIN_MAX,
};

//--------------------------------------------------------------
//	bZ[W
//--------------------------------------------------------------
///bZ[W^O
enum{
	CRTAG_NONE,		///<^OȂ
	
	CRTAG_RANK,		///<ReXgN
	CRTAG_OYA_NICK,	///<eAjbNl[
	CRTAG_NUM_OYA_NICK,	///<lAeAjbNl[
	
	CRTAG_MAX,
};

//--------------------------------------------------------------
//	AN^[vCIeB
//--------------------------------------------------------------
///ԕ͗lBGvCIeB
#define R_FLOWER_BGPRI				(CONRES_BGPRI_BACKGROUND)
///ԕ͗l̃\tgvCIeB
#define R_FLOWER_SOFTPRI			(200)

///|PACRBGvCIeB
#define R_POKEICON_BGPRI			(CONRES_BGPRI_BACKGROUND)
///|PACR̃\tgvCIeB
#define R_POKEICON_SOFTPRI			(100)

///ӂԂBGvCIeB
#define R_CONFETTI_BGPRI			(CONRES_BGPRI_EFF)
///ӂԂ̃\tgvCIeB
#define R_CONFETTI_SOFTPRI			(20)

///ʃACRBGvCIeB
#define R_RANKING_BGPRI				(CONRES_BGPRI_BACKGROUND)
///ʃACR̃\tgvCIeB
#define R_RANKING_SOFTPRI			(100)

///[^[BGvCIeB
#define R_METER_BGPRI				(CONRES_BGPRI_BACKGROUND)
///[^[̃\tgvCIeB
#define R_METER_SOFTPRI				(110)

//--------------------------------------------------------------
//	_擾֘A
//--------------------------------------------------------------
///1ʂ̓_Ɋeu[_[[^[̃p[Ze[W擾ۂMAXp[Ze[W
#define RES_METER_PERCENT_MAX		(100)
///_[^[őL
#define RES_METER_CHAR_MAX			(24)
///_[^[őhbg
#define RES_METER_DOT_MAX			(RES_METER_CHAR_MAX * 8)

///[^[̃AN^[P̉hbg
#define RES_METER_ACT_SIZE_X		(16)
///[^[AN^[
#define RES_METER_CAP_MAX			(RES_METER_DOT_MAX / RES_METER_ACT_SIZE_X)


//==============================================================================
//	\̒`
//==============================================================================
//--------------------------------------------------------------
//	bZ[W
//--------------------------------------------------------------
///Z僁bZ[Wf[^
typedef struct{
	u16 msg_id;				///<bZ[WID
	u8 msg_tag;				///<^OR[h
}CONRES_MESSAGE_PARAM;

///bZ[W^OWJꍇAQƂp[^
typedef struct{
	u8 mine_brd;		///<MINEw肳ĂɎQƂu[_[̔ԍ
	u8 enemy_brd;		///<ENEMYw肳ĂɎQƂu[_[̔ԍ
	u16 wazano;			///<WAZAw肳ĂɎQƂZԍ
	u8 num;				///<NUMw肳Ăɕ\鐔l
	u8 judge_no;		///<JUDGEw肳ĂɎQƂR̔ԍ
}CRTAG_PARAM;

//--------------------------------------------------------------
//	
//--------------------------------------------------------------

///CV[PXŎgp郍[J[N
typedef struct{
	u16 seq;
	u16 select_seq;
	s32 work;
}CONRES_LOCAL_WORK;

//--------------------------------------------------------------
/**
 * @brief   _Xisp[^(݋ZoĂ|P̐isp[^)
 */
//--------------------------------------------------------------
typedef struct{
	u8 now_breeder;					///<ݏɏoĂu[_[̔ԍ
	u8 now_pos;						///<ݏɏoĂu[_[ԖڂɃAs[Ă邩
	
	u8 victory_breeder;				///<Du[_[̔ԍ
	u8 ranking[BREEDER_MAX];		///<(1ʂ珇Ƀu[_[ԍ܂)
	
	u8 meter_type;					///<L΂[^[^Cv(CONGAME_???)
	
	CRTAG_PARAM a_talk_tagpara;		///<m[}bF^OWJpp[^
	u8 a_talk_id;					///<m[}bID(A_TALK_CONRES_???)
	u8 a_talk_bmpwin_close_wait;	///<bZ[W\ĂEBhE܂łwait
	u8 a_talk_bmpwin_not_close;		///<TRUE:EBhEɏI
	u8 a_talk_bmpwin_not_open;		///<TRUE:EBhE`sȂ
}CONRES_ADVANCE_PARAM;

//--------------------------------------------------------------
/**
 * @brief   _XQ[isp[^
 *
 * ̃p[^ΑSʂč\zo邾̏񂪓Ă܂B
 * ʐM̓T[o[q@̓f[^󂯎鎖ɂȂ܂B
 * {IɃj[ʂ̉ʕÂ悤ȎȂA
 * X̎q@ŒlQƂ鎖͂Ȃ͂łB
 */
//--------------------------------------------------------------
typedef struct{
	CONTEST_SCORE score[BREEDER_MAX];	///<_
	
	u8 breeder_sort[BREEDER_MAX];	///<Zo(o鏇Ƀu[_[ԍĂ܂)
	u8 breeder_end_count;			///<sIu[_[̐JEg

	u8 ranking[BREEDER_MAX];		///<(1ʂ珇Ƀu[_[ԍ܂)
	s16 visual_revise[BREEDER_MAX];	///<rWAQ[FCl
	s16 dance_revise[BREEDER_MAX];	///<_XQ[FCl
	s16 actin_revise[BREEDER_MAX];	///<ZQ[FCl
	s16 total_revise[BREEDER_MAX];	///<Cl
	s16 visual_percent[BREEDER_MAX];	///<rWAQ[FCl
	s16 dance_percent[BREEDER_MAX];	///<_XQ[FCl
	s16 actin_percent[BREEDER_MAX];	///<ZQ[FCl
	s16 total_percent[BREEDER_MAX];	///<Cl1ʂ100%ꍇ̕ϊ
	s16 gauge_dot[BREEDER_MAX];		///<total_percenthbgɕϊ
	s16 visual_dot[BREEDER_MAX];	///<rWAQ[Whbg
	s16 dance_dot[BREEDER_MAX];		///<_XQ[Whbg
	s16 actin_dot[BREEDER_MAX];		///<ZQ[Whbg
}CONRES_GAME_PARAM;

//--------------------------------------------------------------
/**
 * @brief   ߑMpp[^
 * 
 * T[o[Ƃ̖߂̑MɎgp܂
 */
//--------------------------------------------------------------
typedef struct{
	u8 breeder_no;
	
	u8 buffer[255];					///<e߂Ōʂɓnf[^ςꍇAgp
}CONRES_ORDER_PARAM;

//--------------------------------------------------------------
/**
 * @brief   Q[ʂ\邽߂ɕKvȃVXef[^ނ\
 *
 * ʐMłSẴ}VŌʂɍ쐬܂
 * eX^btߎMÃ}VXŐ̃[Nobt@nɂȂ܂
 */
//--------------------------------------------------------------
typedef struct{
	CONTEST_GAME_PARAM *c_game;		///<ReXgisp[^(tŊɒʐMς݂̃f[^ւ̃|C^BQƗp)
	
	SOFT_SPRITE_MANAGER	*soft_sprite;
	SOFT_SPRITE *ss[BREEDER_MAX];
	CATS_SYS_PTR		csp;
	CATS_RES_PTR		crp;
	GF_BGL_INI *bgl;
	GF_BGL_BMPWIN win[CONRES_BMPWIN_MAX];
	MSGDATA_MANAGER *conres_msg;	///<_X僁bZ[WpbZ[W}l[W̃|C^
	WORDSET *wordset;
	STRBUF *msg_buf;				///<Allocobt@ւ̃|C^
	PALETTE_FADE_PTR pfd;			///<pbgtF[hVXeւ̃|C^
	FONTOAM_SYS_PTR fontoam_sys;	///<tHgOAMVXeւ̃|C^
	
	EXCHR_PARAM exchr_param[BREEDER_MAX];		///<ZGtFNgpLWJobt@

	FLOWER_WORK flower;				///<ԕ͗l䃏[N

	TCB_PTR pokeicon_tcb;							///<|PACRAjXV^XN
	CATS_ACT_PTR pokeicon_cap[BREEDER_MAX];			///<|PACRAN^[ւ̃|C^
	CATS_ACT_PTR ranking_cap[BREEDER_MAX];			///<ʃAN^[ւ̃|C^
	CATS_ACT_PTR visual_meter_cap[BREEDER_MAX][RES_METER_CAP_MAX];	///<rWA[^[
	CATS_ACT_PTR dance_meter_cap[BREEDER_MAX][RES_METER_CAP_MAX];	///<_X[^[
	CATS_ACT_PTR actin_meter_cap[BREEDER_MAX][RES_METER_CAP_MAX];	///<Z[^[
	
	u8 talk_msg_index;				///<`惋[`̃CfbNX
}CONRES_SYSTEM_PARAM;

//--------------------------------------------------------------
/**
 * @brief   _XǗ[N
 *
 * _XŜǗ匳̃[NɂȂ܂B
 * ʐMłSẴ}VŌʂɍ쐬܂
 */
//--------------------------------------------------------------
typedef struct _CONRES_PROC_WORK{
	CONTEST_SYSTEM *consys;			///<ReXgVXe[Nւ̃|C^
	TCB_PTR update_tcb;				///<VXeXV
	TCB_PTR vintr_tcb;				///<VuN荞݃^XN
	GF_G3DMAN *g3Dman;
	
	CONRES_SYSTEM_PARAM sys;			///<_XVXef[^p[^
	CONRES_GAME_PARAM r_game;			///<Q[isp[^
	CONRES_ADVANCE_PARAM advance;		///<isp[^
	CONRES_ORDER_PARAM order[BREEDER_MAX];	///<߃p[^
	
	void *flash_eff;				///<J̃tbVGtFNg[N
	
	u16 seq;
	u16 tbl_seq_no;					///<CV[PXe[u̔ԍ
	u8 proc_mode;					///<݂̓

	u8 wnd0_x1;						///<EBhE0X1W
	u8 wnd0_y1;
	u8 wnd0_x2;
	u8 wnd0_y2;

	u8 wnd1_x1;
	u8 wnd1_y1;
	u8 wnd1_x2;
	u8 wnd1_y2;
	
	CONTEST_ORDER_WORK cow;			///<M[N

	CONRES_LOCAL_WORK local;			///<[J[N
	u8 main_end;					///<TRUE:CI
	
	u8 confetti_end;				///<TRUE:ӂԂAN^[폜NGXg
	u8 confetti_count;				///<ӂԂĂ鐔JEg
	
	u8 disp_mode;					///<RESDISP_MODE_???
}CONRES_PROC_WORK;


//==============================================================================
//	O֐錾
//==============================================================================
extern PROC_RESULT ConresProc_Init( PROC * proc, int * seq );
extern PROC_RESULT ConresProc_Main( PROC * proc, int * seq );
extern PROC_RESULT ConresProc_End( PROC * proc, int * seq );

//==============================================================================
//	Of[^錾
//==============================================================================
extern const PROC_DATA ContestResultProcData;



#endif	//__CON_RESULT_H__

