//==============================================================================
/**
 * @file	contype_icon.c
 * @brief	ReXg^CvACR
 * @author	matsuda
 * @date	2005.12.02()
 */
//==============================================================================
#include "common.h"
#include "system/clact_tool.h"
#include "contype_icon.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "contest/graphic/contest_obj_def.h"


//==============================================================================
//	萔`
//==============================================================================
///ReXg^CvACRŎgppbg{
#define CTI_PLTT_NUM		(2)


//==============================================================================
//	f[^
//==============================================================================
///ReXg^CvCGRID
ALIGN4 static const u32 ConTypeCgrNo[] = {
	CTYPE_STYLE_NCGR_BIN,			//CONTYPE_STYLE
	CTYPE_BEAUTIFUL_NCGR_BIN,		//CONTYPE_BEAUTIFUL
	CTYPE_CUTE_NCGR_BIN,			//CONTYPE_CUTE
	CTYPE_CLEVER_NCGR_BIN,			//CONTYPE_CLEVER
	CTYPE_STRONG_NCGR_BIN, 		//CONTYPE_STRONG
};

///ReXg^CṽpbgItZbgԍ
ALIGN4 static const u8 ConTypePlttOffset[] = {
	1,		//CONTYPE_STYLE
	1,		//CONTYPE_BEAUTIFUL
	1,		//CONTYPE_CUTE
	1,		//CONTYPE_CLEVER
	1,		//CONTYPE_STRONG
};



//==============================================================================
//
//	ReXg^CvACR
//
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   wReXg^CvCGRID擾܂
 * @param   con_type		ReXg^Cv(CONTYPE_???)
 * @retval  CGRID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 ConTypeIcon_CgrIDGet(int con_type)
{
	GF_ASSERT(con_type < NELEMS(ConTypeCgrNo));
	return ConTypeCgrNo[con_type];
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACR̃pbgID擾܂
 * @retval  pbgID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 ConTypeIcon_PlttIDGet(void)
{
	return CONTEST_SUB_OBJ_NCLR;
}

//--------------------------------------------------------------
/**
 * @brief   wReXg^CṽZID擾܂
 * @retval  ZID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 ConTypeIcon_CellIDGet(void)
{
	return CTYPE_STYLE_NCER_BIN;
}

//--------------------------------------------------------------
/**
 * @brief   wReXg^CṽZAjID擾܂
 * @retval  ZAjID(ARC̃f[^INDEX)
 */
//--------------------------------------------------------------
u32 ConTypeIcon_CellAnmIDGet(void)
{
	return CTYPE_STYLE_NANR_BIN;
}

//--------------------------------------------------------------
/**
 * @brief   wReXg^CṽpbgԍItZbg擾܂
 * @param   con_type		ReXg^Cv(CONTYPE_???)
 * @retval  pbgԍ̃ItZbg
 */
//--------------------------------------------------------------
u8 ConTypeIcon_PlttOffsetGet(int con_type)
{
	GF_ASSERT(con_type < NELEMS(ConTypePlttOffset));
	return ConTypePlttOffset[con_type];
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACR̃A[JCuINDEX擾܂
 * @retval  A[JCuINDEX
 */
//--------------------------------------------------------------
u32 ConTypeIcon_ArcIDGet(void)
{
	return ARC_CONTEST_OBJ;
}




//--------------------------------------------------------------
/**
 * @brief   wReXg^CṽL\[X[h܂
 *
 * @param   csp				cspւ̃|C^
 * @param   crp				crpւ̃|C^
 * @param   vram_type		NNS_G2D_VRAM_TYPE_2DMAIN
 * @param   con_type		ReXg^Cv(CONTYPE_???)
 * @param   char_id			o^LID
 */
//--------------------------------------------------------------
void ConTypeIcon_CharResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, 
	NNS_G2D_VRAM_TYPE vram_type, int con_type, u32 char_id)
{
	CATS_LoadResourceCharArc(csp, crp, ConTypeIcon_ArcIDGet(), 
		ConTypeIcon_CgrIDGet(con_type), 1, vram_type, char_id);
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACR̃pbg[h܂
 *
 * @param   csp			cspւ̃|C^
 * @param   crp			crpւ̃|C^
 * @param   vram_type	NNS_G2D_VRAM_TYPE_2DMAIN
 * @param   pltt_id		o^pbgID
 *
 * ReXg^CvACRŎgppbgSĂZbg܂B
 */
//--------------------------------------------------------------
void ConTypeIcon_PlttResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, 
	NNS_G2D_VRAM_TYPE vram_type, u32 pltt_id)
{
	CATS_LoadResourcePlttArc(csp, crp, ConTypeIcon_ArcIDGet(), ConTypeIcon_PlttIDGet(), 1, 
		CTI_PLTT_NUM, vram_type, pltt_id);
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACR̃pbgpbg[Nփ[h܂
 *
 * @param   PALETTE_FADE_PTR		pbgtF[hVXeւ̃|C^
 * @param   req						NGXgf[^ԍ(FADE_MAIN_BG)
 * @param   csp			cspւ̃|C^
 * @param   crp			crpւ̃|C^
 * @param   vram_type	NNS_G2D_VRAM_TYPE_2DMAIN
 * @param   pltt_id		o^pbgID
 *
 * ReXg^CvACRŎgppbgSĂZbg܂B
 */
//--------------------------------------------------------------
void ConTypeIcon_PlttWorkResourceLoad(PALETTE_FADE_PTR pfd, FADEREQ req, CATS_SYS_PTR csp, 
	CATS_RES_PTR crp, NNS_G2D_VRAM_TYPE vram_type, u32 pltt_id)
{
	CATS_LoadResourcePlttWorkArc(pfd, req, csp, crp, 
		ConTypeIcon_ArcIDGet(), ConTypeIcon_PlttIDGet(), 0, 
		CTI_PLTT_NUM, vram_type, pltt_id);
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACR̃ZƃAj[h܂
 *
 * @param   csp			cspւ̃|C^
 * @param   crp			crpւ̃|C^
 * @param   cell_id		o^ZID
 * @param   anm_id		o^AjID
 *
 * ReXg^CvACRʂ̃ZƃAj[h܂B
 * ReXg^CvACR͑SăZƃAjʂȂ̂ŁA1o^ĂOKłB
 * (̃ACR𐶐鎞łASĂœo^ZAAjIDw肷悤ɂ܂)
 */
//--------------------------------------------------------------
void ConTypeIcon_CellAnmResourceLoad(CATS_SYS_PTR csp, CATS_RES_PTR crp, u32 cell_id, u32 anm_id)
{
	CATS_LoadResourceCellArc(csp, crp, ConTypeIcon_ArcIDGet(), ConTypeIcon_CellIDGet(), 
		1, cell_id);
	CATS_LoadResourceCellAnmArc(csp, crp, ConTypeIcon_ArcIDGet(), ConTypeIcon_CellAnmIDGet(), 
		1, anm_id);
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACR̃L\[X܂
 * @param   crp			crpւ̃|C^
 * @param   char_id		LID
 */
//--------------------------------------------------------------
void ConTypeIcon_CharResourceFree(CATS_RES_PTR crp, u32 char_id)
{
	CATS_FreeResourceChar(crp, char_id);
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACR̃pbg\[X܂
 * @param   crp			crpւ̃|C^
 * @param   pltt_id		pbgID
 */
//--------------------------------------------------------------
void ConTypeIcon_PlttResourceFree(CATS_RES_PTR crp, u32 pltt_id)
{
	CATS_FreeResourcePltt(crp, pltt_id);
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACR̃ZAAj\[X܂
 * @param   crp			crpւ̃|C^
 * @param   char_id		ZID
 * @param   char_id		AjID
 */
//--------------------------------------------------------------
void ConTypeIcon_CellAnmResourceFree(CATS_RES_PTR crp, u32 cell_id, u32 anm_id)
{
	CATS_FreeResourceCell(crp, cell_id);
	CATS_FreeResourceCellAnm(crp, anm_id);
}


//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACRAN^[𐶐
 *
 * @param   csp				cspւ̃|C^
 * @param   crp				crpւ̃|C^
 * @param   con_type		ReXg^Cv(CONTYPE_???)
 * @param   obj_data		AN^[wb_ւ̃|C^
 *
 * @retval  AN^[̃|C^
 */
//--------------------------------------------------------------
CATS_ACT_PTR ConTypeIcon_ActorCreate(CATS_SYS_PTR csp, CATS_RES_PTR crp, int con_type, 
	const TCATS_OBJECT_ADD_PARAM_S *obj_data)
{
	CATS_ACT_PTR cap;
	TCATS_OBJECT_ADD_PARAM_S obj_param;
	
	obj_param = *obj_data;
	obj_param.pal = ConTypeIcon_PlttOffsetGet(con_type);
	
	cap = CATS_ObjectAdd_S(csp, crp, &obj_param);
	return cap;
}

//--------------------------------------------------------------
/**
 * @brief   ReXg^CvACRAN^[폜
 * @param   cap		AN^[|C^
 */
//--------------------------------------------------------------
void ConTypeIcon_ActorDelete(CATS_ACT_PTR cap)
{
	CATS_ActorPointerDelete_S(cap);
}


