//============================================================================================
/**
 * @file	d_title.c	
 * @brief	fobO^Cgj[
 * @author	Hiroyuki Nakamura
 * @date	05.07.08
 */
//============================================================================================

#ifdef	PM_DEBUG

#include "common.h"
#include "system/fontproc.h"
#include "system/bmp_list.h"
#include "system/lib_pack.h"
#include "system/arc_util.h"
#include "system/wipe.h"
#include "system/snd_tool.h"
#include "demo/title.h"
#include "system/gamestart.h"
//#include "demo/opening/opening_sys.h"
//#include "field/field.h"
#include "poke_test.h"
#include "tr_test.h"

#include "communication/communication.h"
#include "system/main.h"

#include "msgdata/msg_debug_title.h"
#include "msgdata/msg.naix"

#include "wifi/dwc_rap.h"
#include "wifi/dwc_test.h"

#include "system/builddate.h"

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/10/05
// S\EmF郂[hǉ
#include "gflib/strbuf_family.h"
// ----------------------------------------------------------------------------

//============================================================================================
//	overlay`
//============================================================================================

FS_EXTERN_OVERLAY( title );
FS_EXTERN_OVERLAY( title_debug );

//============================================================================================
//	萔`
//============================================================================================
typedef void (*SELECT_FUNC)(SAVEDATA *);

typedef struct {
	GF_BGL_INI * bgl;
	GF_BGL_BMPWIN	win;
	GF_BGL_BMPWIN	datewin;
	BMPLIST_WORK * lw;
	SELECT_FUNC select_func;
	BMP_MENULIST_DATA *bmd;
	u32	end_flg;
}D_TITLE_WORK;

#define	FONT_PAL_NO		( 0 )


#define	HEAPID_DEBUG_TITLE	HEAPID_DEBUG_APPLICATION

//============================================================================================
//	vg^Cv錾
//============================================================================================

static void VramBankSet(void);
static void BgInit( GF_BGL_INI * ini );
static void BmpListCB1( u32 param, u8 mode );
static void BmpListCB2( u8 index, u32 param, u8 y );
static void D_TitleMenuMemFree( GF_BGL_INI * ini );


static void SetFieldDebugStartProc(SAVEDATA * savedata);
static void SetFieldContinueProc(SAVEDATA * savedata);
static void SetDebugPokeGraProc(SAVEDATA * savedata);
static void SetDebugTrGraProc(SAVEDATA * savedata);
static void SetDebugSoundTestProc(SAVEDATA * savedata);
static void SetDebugFightProc(SAVEDATA * savedata);
static void SetTitleProc(SAVEDATA * savedata);
static void SetDebugWiFiProc( SAVEDATA * savedata );
static void SetDebugWiFiTestProc( SAVEDATA * savedata );
static void SetDebugSeletNameProc(SAVEDATA * savedata);
static void SetDebugBreakSaveProc(SAVEDATA * savedata);
static void SetDebugRtcSettingProc(SAVEDATA * savedata);
//static void SetOpeningProc(SAVEDATA * savedata);
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/10/05
// S\EmF郂[hǉ
static void SetDebugCharViewerProc(SAVEDATA * savedata);
static PROC_RESULT DebugCharViewerProc_Init(PROC * proc, int * seq);
static PROC_RESULT DebugCharViewerProc_Main(PROC * proc, int * seq);
static PROC_RESULT DebugCharViewerProc_End (PROC * proc, int * seq);
// ----------------------------------------------------------------------------

//============================================================================================
//	O[oϐ
//============================================================================================

//gmmt@CID𕶎wɎg\̐錾
typedef struct
{
	u32	strID;
	u32	param;
}LIST_DATA;

static const LIST_DATA ListData[] =
{
	//j[́̕Aconvert/message/src/debug_title.gmmɒǉĂ
	{ DT_DEBUGGAME,		(u32)SetFieldDebugStartProc },
	{ DT_CONTINUE,		(u32)SetFieldContinueProc },
	{ DT_SELNAME,		(u32)SetDebugSeletNameProc },
	//{ DT_OPENING,		(u32)SetOpeningProc },
	{ DT_SOUNDTEST,		(u32)SetDebugSoundTestProc },
	{ DT_POKEGRATEST,	(u32)SetDebugPokeGraProc },
	{ DT_TRGRATEST,		(u32)SetDebugTrGraProc },
	{ DT_DEBUGFIGHT,	(u32)SetDebugFightProc },
//	{ DT_WIFI,			(u32)SetDebugWiFiProc },
	{ DT_BREAKSAVE,		(u32)SetDebugBreakSaveProc },
	{ DT_RTC_SETTING,	(u32)SetDebugRtcSettingProc },
	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2007/10/05
	// S\EmF郂[hǉ
	{ DT_FONTVIEWER,	(u32)SetDebugCharViewerProc },
	// ----------------------------------------------------------------------------
	{ DT_MODORU,		(u32)SetTitleProc },
};

static const BMPLIST_HEADER ListHeader = {
	NULL,
	NULL,					// J[\ړƂ̃R[obN֐
	NULL,					// \Ƃ̃R[obN֐
	NULL,					// BMPEBhEf[^
	NELEMS(ListData),		// Xgڐ
	6,						// \ő區ڐ
	0,						// x\wW
	12,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	FONT_SYSTEM,			// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};




//--------------------------------------------------------------------------------------------
/**
 * VRAM
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void VramBankSet(void)
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_C,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_16_F,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0123_E			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

//--------------------------------------------------------------------------------------------
/**
 * BG
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BgInit( GF_BGL_INI * ini )
{
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

	{	// MAIN DISP BG0
		GF_BGL_BGCNT_HEADER MBg0_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd000, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME0_M, &MBg0_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME0_M );
	}

	{	// MAIN DISP BG1
		GF_BGL_BGCNT_HEADER MBg1_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xd800, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_01, 1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME1_M, &MBg1_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME1_M );
	}

	{	// MAIN DISP BG2
		GF_BGL_BGCNT_HEADER MBg2_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_23, 2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME2_M, &MBg2_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME2_M );
	}

	{	// MAIN DISP BG3
		GF_BGL_BGCNT_HEADER MBg3_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_23, 3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_M, &MBg3_Data, GF_BGL_MODE_TEXT );
		GF_BGL_ScrClear( ini, GF_BGL_FRAME3_M );
	}
}


//--------------------------------------------------------------------------------------------
/**
 * J
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void D_TitleMenuMemFree( GF_BGL_INI * ini )
{
	// BGLJ
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME3_M );
/*
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME0_S );
	GF_BGL_BGControlExit( ini, GF_BGL_FRAME1_S );
*/
}
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
//fobOQ[Jn
static void SetFieldDebugStartProc(SAVEDATA * savedata)
{
	Main_SetNextProc(OVERLAY_ID_GAMESTART, &DebugNewGameStartProcData);
}
//lIăfobOQ[Jn
static void SetDebugSeletNameProc(SAVEDATA * savedata)
{
	Main_SetNextProc(FS_OVERLAY_ID(title_debug), &DebugPersonMenuProcData);
}
//ReBj[ŃQ[Jn
static void SetFieldContinueProc(SAVEDATA * savedata)
{
	if (SaveData_GetExistFlag(savedata)) {
		Main_SetNextProc(OVERLAY_ID_GAMESTART, &ContinueGameStartProcData);
	} else {
		Main_SetNextProc(FS_OVERLAY_ID(title), &TitleProcData);
	}
}
//|POtBbNmF
static void SetDebugPokeGraProc(SAVEDATA * savedata)
{
	Main_SetNextProc(FS_OVERLAY_ID(title_debug), &PokeGraTestProcData);
}
//g[i[OtBbNmF
static void SetDebugTrGraProc(SAVEDATA * savedata)
{
	Main_SetNextProc(FS_OVERLAY_ID(title_debug), &TrGraTestProcData);
}
//fobOt@CgJn
static void SetDebugFightProc(SAVEDATA * savedata)
{
	Main_SetNextProc(NO_OVERLAY_ID, &DebugFightProcData);
}
//TEheXgJn
static void SetDebugSoundTestProc(SAVEDATA * savedata)
{
	Main_SetNextProc(FS_OVERLAY_ID(title_debug), &SoundTestProcData);
}
//qsb
static void SetDebugRtcSettingProc(SAVEDATA * savedata)
{
	Main_SetNextProc(FS_OVERLAY_ID(title_debug), &DebugRtcMenuProcData);
}
//^Cgɖ߂
static void SetTitleProc(SAVEDATA * savedata)
{
	Main_SetNextProc(FS_OVERLAY_ID(title), &TitleProcData);
}
//------------------------------------------------------------------
///	Z[uf[^j
//------------------------------------------------------------------
static void SetDebugBreakSaveProc(SAVEDATA * savedata)
{
	SaveData_Erase(savedata);
	Main_SetNextProc(FS_OVERLAY_ID(title), &TitleProcData);
}

//------------------------------------------------------------------
/**
 * @brief	X^[gj[ĂяoWi-Fiݒ
 * @param	NONE
 * @return	NONE
 */
//------------------------------------------------------------------
static PROC_RESULT StartMenuWifiProc_Init(PROC * proc, int * seq)
{
  sys_CreateHeap( HEAPID_BASE_APP, HEAPID_WIFIMENU, 0x41000);
  DwcUtilOverlayCall(((MAINWORK *)PROC_GetParentWork(proc))->savedata, HEAPID_WIFIMENU);
  sys_DeleteHeap(HEAPID_WIFIMENU);
  OS_ResetSystem(0); 
  return PROC_RES_FINISH;
}
static const PROC_DATA StartMenuWifiProcData = {
  StartMenuWifiProc_Init,
  NULL,
  NULL,
  NO_OVERLAY_ID,
};

static void SetDebugWiFiProc( SAVEDATA * savedata )
{
    // Wi-FiĂ
    Main_SetNextProc(NO_OVERLAY_ID, &StartMenuWifiProcData);
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFBMPMENULISTDATA̐
 * @param	bmd		BMP_MENULIST_DATA\̂ւ̃|C^
 */
//--------------------------------------------------------------------------------------------
static	void	BMP_MENULIST_Make(BMP_MENULIST_DATA *bmd)
{
	int				i;
	MSGDATA_MANAGER	*man;

	man=MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,NARC_msg_debug_title_dat,HEAPID_DEBUG_TITLE);

	for(i=0;i<NELEMS(ListData);i++){
		BMP_MENULIST_AddArchiveString(bmd,man,ListData[i].strID,ListData[i].param);
	}

	MSGMAN_Delete(man);
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXF
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugTitleMenuProc_Init(PROC * proc, int * seq)
{
//\[X當\[XÔɑΉo[W
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_DEBUG_TITLE, 0x10000);
	{
		D_TITLE_WORK * wk;

		wk = PROC_AllocWork(proc, sizeof(D_TITLE_WORK), HEAPID_DEBUG_TITLE);

		wk->bgl = GF_BGL_BglIniAlloc( HEAPID_DEBUG_TITLE );

		GF_Disp_GX_VisibleControlInit();
		VramBankSet();
		BgInit( wk->bgl );

		MSG_PrintInit();

		SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PAL_NO * 32, HEAPID_DEBUG_TITLE );

		{
			BMPLIST_HEADER	list_h;

			wk->bmd=BMP_MENULIST_Create(NELEMS(ListData),HEAPID_DEBUG_TITLE);
			BMP_MENULIST_Make(wk->bmd);

			GF_BGL_BmpWinAdd(
				wk->bgl, &wk->win, GF_BGL_FRAME0_M, 1, 1, 14, 12, FONT_PAL_NO, 1 );

			list_h = ListHeader;
			list_h.list = wk->bmd;
			list_h.win = &wk->win;
			wk->lw = BmpListSet( &list_h, 0, 0, HEAPID_DEBUG_TITLE );

		}
		{
			STRBUF * strbuf;
			STRBUF * msg;
			WORDSET * ws;
			ws = WORDSET_Create(HEAPID_DEBUG_TITLE);
			msg = MSGDAT_GetStrDirectAlloc(ARC_MSG, NARC_msg_debug_title_dat,
					DT_BUILDDATE, HEAPID_DEBUG_TITLE);
			GF_BGL_BmpWinAdd(
				wk->bgl, &wk->datewin, GF_BGL_FRAME0_M, 1, 15, 25, 3, FONT_PAL_NO, 1 + 14 * 12);
			GF_BGL_BmpWinDataFill(&wk->datewin, FontHeaderGet(FONT_SYSTEM, FONT_HEADER_B_COLOR));

			// ----------------------------------------------------------------------------
			// localize_spec_mark(LANG_ALL) imatake 2007/03/13
			// rhԂł͂ȂAR}hCw肳ꂽCVS̃^O\悤
			strbuf = STRBUF_Create(TAG_MAXLEN, HEAPID_DEBUG_TITLE);
			getBuildTag(strbuf);
			// ----------------------------------------------------------------------------
			GF_STR_PrintSimple(&wk->datewin, FONT_SYSTEM, strbuf, 0, 0, MSG_ALLPUT, NULL);
			STRBUF_Delete(strbuf);
			STRBUF_Delete(msg);
			WORDSET_Delete(ws);
		}
	}

		WIPE_ResetBrightness( WIPE_DISP_MAIN );
		WIPE_ResetBrightness( WIPE_DISP_SUB );

		GF_Disp_DispOn();

	Snd_BgmChannelSetAndReverbSet( 0 );	//gp\`lAo[uݒ(NA)

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFC
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugTitleMenuProc_Main(PROC * proc, int * seq)
{
	D_TITLE_WORK * wk = PROC_GetWork(proc);
	u32	ret;

	ret = BmpListMain( wk->lw );

	switch( ret ){
	case BMPLIST_NULL:
		break;
	case BMPLIST_CANCEL:
		ret = (u32)SetTitleProc;
	default:
		BMP_MENULIST_Delete(wk->bmd);
		BmpListExit( wk->lw, NULL, NULL );
		GF_BGL_BmpWinOff( &wk->win );
		GF_BGL_BmpWinDel( &wk->win );
		GF_BGL_BmpWinOff( &wk->datewin );
		GF_BGL_BmpWinDel( &wk->datewin);
		D_TitleMenuMemFree( wk->bgl );
		sys_FreeMemoryEz( wk->bgl );
		wk->select_func = (SELECT_FUNC)ret;
		return PROC_RES_FINISH;
	}
	return PROC_RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	^CgvZXFI
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugTitleMenuProc_End(PROC * proc, int * seq)
{
	D_TITLE_WORK * wk = PROC_GetWork(proc);
	wk->select_func(((MAINWORK*)PROC_GetParentWork(proc))->savedata);
	PROC_FreeWork(proc);

	sys_DeleteHeap(HEAPID_DEBUG_TITLE);
	return PROC_RES_FINISH;
}


//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
const PROC_DATA DebugTitleMenuProcData = {
	DebugTitleMenuProc_Init,
	DebugTitleMenuProc_Main,
	DebugTitleMenuProc_End,
	NO_OVERLAY_ID
};


// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/10/05
// S\EmF郂[hǉ
// localize_spec_mark(LANG_ALL) imatake 2007/10/24
// 풓^Cv̕`mFł悤

enum {
	LVW_COLORNUM_PAL = 16,

	LVW_CHARNUM_LINE = 16,
	LVW_LINENUM_PAGE =  8,
	LVW_STRCODE_MIN     = 0x001,
	LVW_STRCODE_MAX     = 0xD70,
	LVW_STRCODE_BASEMAX = 0xD01,
};

enum {
	FONT_SYSTEM_FROM_CARD,
	FONT_TALK_FROM_CARD,
	FONT_BUTTON_FROM_CARD,
	FONT_SYSTEM_ON_MEMORY,
	FONT_TALK_ON_MEMORY,
};

typedef struct {
	MSGDATA_MANAGER *man;
	GF_BGL_INI * bgl;
	GF_BGL_BMPWIN win;
	u16 pltButton[LVW_COLORNUM_PAL];
	u32     fontType;
	STRCODE base;
} D_CHARVIEWER_WORK;

const PROC_DATA DebugCharViewerProcData = {
	DebugCharViewerProc_Init,
	DebugCharViewerProc_Main,
	DebugCharViewerProc_End,
	NO_OVERLAY_ID
};

// {^tHg͔ėppbgȂ̂Œw
static const u16 pltButton[LVW_COLORNUM_PAL] = {
	GX_RGB( 7,19,10), GX_RGB(31,31,31), GX_RGB(28,28,28), GX_RGB( 0, 0, 0),		// wiEEeE | 
	GX_RGB( 0, 0, 0), GX_RGB( 0, 0, 0), GX_RGB( 0, 0, 0), GX_RGB( 0, 0, 0),		//  | E | E | E |
	GX_RGB( 0, 0, 0), GX_RGB( 0, 0, 0), GX_RGB( 0, 0, 0), GX_RGB( 0, 0, 0),		//  | E | E | E |
	GX_RGB( 0, 0, 0), GX_RGB( 0, 0, 0), GX_RGB( 0, 0, 0), GX_RGB(11,11,11),		//  | E | E | EZe
};

static void DrawCharacters(D_CHARVIEWER_WORK * wk, int heapID);

static void SetDebugCharViewerProc(SAVEDATA * savedata)
{
	Main_SetNextProc(FS_OVERLAY_ID(title_debug), &DebugCharViewerProcData);
}

static PROC_RESULT DebugCharViewerProc_Init(PROC * proc, int * seq)
{
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_DEBUG_TITLE, 0x10000);

	{
		D_CHARVIEWER_WORK * wk;

		wk = PROC_AllocWork(proc, sizeof(D_CHARVIEWER_WORK), HEAPID_DEBUG_TITLE);

		wk->man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_title_dat, HEAPID_DEBUG_TITLE);

		FontProc_LoadFont(FONT_BUTTON, HEAPID_DEBUG_TITLE);

		wk->bgl = GF_BGL_BglIniAlloc( HEAPID_DEBUG_TITLE );

		GF_Disp_GX_VisibleControlInit();
		VramBankSet();
		{	// MAIN DISP BG0
			GF_BGL_BGCNT_HEADER MBg0_Data = {
				0, 0, 0x800, 0,
				GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0xd000, GX_BG_CHARBASE_0x00000,
				GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
			};
			GF_BGL_BGControlSet( wk->bgl, GF_BGL_FRAME0_M, &MBg0_Data, GF_BGL_MODE_TEXT );
			GF_BGL_ScrClear( wk->bgl, GF_BGL_FRAME0_M );
		}

		MSG_PrintInit();

		DC_FlushRange(wk->pltButton, sizeof(u16)*LVW_COLORNUM_PAL);
		SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PAL_NO * 32, HEAPID_DEBUG_TITLE );

		GF_BGL_BmpWinAdd(wk->bgl, &wk->win, GF_BGL_FRAME0_M, 0, 0, 32, 24, FONT_PAL_NO, 0);

		wk->fontType = FONT_SYSTEM_FROM_CARD;
		wk->base = LVW_STRCODE_MIN;

		DrawCharacters(wk, HEAPID_DEBUG_TITLE);
	}

	WIPE_ResetBrightness( WIPE_DISP_MAIN );
	WIPE_ResetBrightness( WIPE_DISP_SUB );

	GF_Disp_DispOn();

	Snd_BgmChannelSetAndReverbSet( 0 );	//gp\`lAo[uݒ(NA)

	return PROC_RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	ꗗ\vZXFC
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_CONTINUE	p
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugCharViewerProc_Main(PROC * proc, int * seq)
{
	D_CHARVIEWER_WORK * wk = PROC_GetWork(proc);
	u32	ret;

	if (sys.trg & PAD_BUTTON_START) {
		return PROC_RES_FINISH;
	} else if (sys.trg & PAD_BUTTON_B) {
		if (wk->base == LVW_STRCODE_MIN) {
			wk->base =  LVW_STRCODE_BASEMAX;
		} else {
			wk->base -= LVW_CHARNUM_LINE * LVW_LINENUM_PAGE;
		}
		DrawCharacters(wk, HEAPID_DEBUG_TITLE);
	} else if (sys.trg & PAD_BUTTON_A) {
		if (wk->base == LVW_STRCODE_BASEMAX) {
			wk->base =  LVW_STRCODE_MIN;
		} else {
			wk->base += LVW_CHARNUM_LINE * LVW_LINENUM_PAGE;
		}
		DrawCharacters(wk, HEAPID_DEBUG_TITLE);
	} else if (sys.trg & PAD_BUTTON_SELECT) {
		switch (wk->fontType) {
			case FONT_SYSTEM_FROM_CARD:					// 풓SYSTEM  풓TALK
				wk->fontType = FONT_TALK_FROM_CARD;
				TalkFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PAL_NO * 32, HEAPID_DEBUG_TITLE );
				break;
			case FONT_TALK_FROM_CARD:
				wk->fontType = FONT_BUTTON_FROM_CARD;		// 풓TALK    풓BUTTON
				GX_LoadBGPltt(pltButton, 0, sizeof(u16)*LVW_COLORNUM_PAL);
				break;
			case FONT_BUTTON_FROM_CARD:					// 풓BUTTON  풓SYSTEM
				FontProc_LoadBitData(FONT_SYSTEM, HEAPID_DEBUG_TITLE);
				wk->fontType = FONT_SYSTEM_ON_MEMORY;
				SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PAL_NO * 32, HEAPID_DEBUG_TITLE );
				break;
			case FONT_SYSTEM_ON_MEMORY:					// 풓SYSTEM    풓TALK
				FontProc_UnloadBitData(FONT_SYSTEM);
				FontProc_LoadBitData(FONT_TALK,   HEAPID_DEBUG_TITLE);
				wk->fontType = FONT_TALK_ON_MEMORY;
				TalkFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PAL_NO * 32, HEAPID_DEBUG_TITLE );
				break;
			case FONT_TALK_ON_MEMORY:					// 풓TALK      풓SYSTEM
				FontProc_UnloadBitData(FONT_TALK);
				wk->fontType = FONT_SYSTEM_FROM_CARD;
				SystemFontPaletteLoad( PALTYPE_MAIN_BG, FONT_PAL_NO * 32, HEAPID_DEBUG_TITLE );
				break;
		}
		DrawCharacters(wk, HEAPID_DEBUG_TITLE);
	}

	return PROC_RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	ꗗ\vZXFIifobO^Cg֖߂j
 * @param	proc	vZXւ̃|C^
 * @param	seq		V[PXp[Nւ̃|C^
 * @return	PROC_RES_FINISH		I
 */
//--------------------------------------------------------------------------------------------
static PROC_RESULT DebugCharViewerProc_End(PROC * proc, int * seq)
{
	D_CHARVIEWER_WORK * wk = PROC_GetWork(proc);

	MSGMAN_Delete(wk->man);

	FontProc_UnloadFont(FONT_BUTTON);
	switch (wk->fontType) {
		case FONT_SYSTEM_ON_MEMORY:
			FontProc_UnloadBitData(FONT_SYSTEM);
			break;
		case FONT_TALK_ON_MEMORY:
			FontProc_UnloadBitData(FONT_TALK);
			break;
	}

	GF_BGL_BmpWinOff( &wk->win );
	GF_BGL_BmpWinDel( &wk->win );
	D_TitleMenuMemFree( wk->bgl );
	sys_FreeMemoryEz( wk->bgl );

	Main_SetNextProc(FS_OVERLAY_ID(title), &TitleProcData);
	PROC_FreeWork(proc);

	sys_DeleteHeap(HEAPID_DEBUG_TITLE);
	return PROC_RES_FINISH;
}

static void DrawCharacters(D_CHARVIEWER_WORK * wk, int heapID)
{
	int i, j;
	u32 fontID;
	STRCODE src[LVW_CHARNUM_LINE+1];
	STRCODE strcode = wk->base;
	STRBUF  *strbuf;

	switch (wk->fontType) {
		case FONT_SYSTEM_FROM_CARD:
		case FONT_SYSTEM_ON_MEMORY:
			fontID = FONT_SYSTEM;
			break;
		case FONT_TALK_FROM_CARD:
		case FONT_TALK_ON_MEMORY:
			fontID = FONT_TALK;
			break;
		case FONT_BUTTON_FROM_CARD:
			fontID = FONT_BUTTON;
			break;
	}

	switch (fontID) {
		case FONT_SYSTEM:
		case FONT_TALK:
			GF_BGL_BmpWinDataFill(&wk->win, FontHeaderGet(fontID, FONT_HEADER_B_COLOR));
			break;
		case FONT_BUTTON:
			GF_BGL_BmpWinDataFill(&wk->win, 0);
			break;
	}

	strbuf = STRBUF_Create(64, heapID);

	{
		static const STRCODE figure[] = {
			h_n0_, h_n1_, h_n2_, h_n3_, h_n4_, h_n5_, h_n6_, h_n7_,
			h_n8_, h_n9_, h_A__, h_B__, h_C__, h_D__, h_E__, h_F__,
		};

		STRCODE head = wk->base;
		STRCODE tail = wk->base + LVW_CHARNUM_LINE * LVW_LINENUM_PAGE - 1;

		src[ 0] = figure[(head >> 8) & 0xF];
		src[ 1] = figure[(head >> 4) & 0xF];
		src[ 2] = figure[(head >> 0) & 0xF];
		src[ 3] = h_h__;
		src[ 4] = h_spc_;
		src[ 5] = h_bou_;
		src[ 6] = h_spc_;
		src[ 7] = figure[(tail >> 8) & 0xF];
		src[ 8] = figure[(tail >> 4) & 0xF];
		src[ 9] = figure[(tail >> 0) & 0xF];
		src[10] = h_h__;
		src[11] = EOM_;

		STRBUF_SetStringCode(strbuf, src);
		GF_STR_PrintSimple(&wk->win, fontID, strbuf, 0, 0, MSG_ALLPUT, NULL);
	}

	{
		u32 fontTitleID;

		switch (wk->fontType) {
			case FONT_SYSTEM_FROM_CARD: fontTitleID = DT_SYSTEM_CARD;    break;
			case FONT_TALK_FROM_CARD:   fontTitleID = DT_TALK_CARD;      break;
			case FONT_BUTTON_FROM_CARD: fontTitleID = DT_BUTTON_CARD;    break;
			case FONT_SYSTEM_ON_MEMORY: fontTitleID = DT_SYSTEM_MEMORY;  break;
			case FONT_TALK_ON_MEMORY:   fontTitleID = DT_TALK_MEMORY;    break;
		}

		MSGMAN_GetString(wk->man, fontTitleID, strbuf);
		GF_STR_PrintSimple(&wk->win, fontID, strbuf, 128, 0, MSG_ALLPUT, NULL);
	}

	for (i = 0; i < LVW_LINENUM_PAGE; ++i) {
		for (j = 0; j < LVW_CHARNUM_LINE; ++j) src[j] = strcode++;
		src[LVW_CHARNUM_LINE] = EOM_;
		STRBUF_SetStringCode(strbuf, src);
		GF_STR_PrintSimple(&wk->win, fontID, strbuf, 0, i * 16 + 24, MSG_ALLPUT, NULL);
	}

	STRBUF_Delete(strbuf);
}

// ----------------------------------------------------------------------------

#endif	//PM_DEBUG

