//==============================================================================================
/**
 * @file	opneing_sys.h
 * @brief	I[vjO VXe@
 * @author	Satoshi Nohara
 * @date	2005.12.08
 */
//==============================================================================================
#ifndef _OPENING_SYS_H_
#define _OPENING_SYS_H_

#include "common.h"
#include "system/bmp_menu.h"
#include "system/window.h"
#include "system/procsys.h"
#include "system/wordset.h"
#include "savedata/config.h"
#include "opening_obj.h"


//==============================================================================================
//
//	extern錾
//
//==============================================================================================
extern const PROC_DATA OpeningProcData;				//vZX`f[^

extern PROC_RESULT OpeningProc_Init( PROC * proc, int * seq );
extern PROC_RESULT OpeningProc_Main( PROC * proc, int * seq );
extern PROC_RESULT OpeningProc_End( PROC * proc, int * seq );

//==============================================================================================
//
//	`
//
//==============================================================================================
//rbg}bvID
enum{
	BMPWIN_MENU_1 = 0,
	BMPWIN_GUIDE,
	BMPWIN_MENU_2,
	BMPWIN_OOKIDO,
	BMPWIN_YESNO,
	BMPWIN_IDSEL,
	OPENING_BMPWIN_MAX,								//BMPEBhE̐
};

#define OPENING_MENU_MAX		(4)					//j[̐

#define OP_FRM_FONT				(GF_BGL_FRAME1_M)

//pbg`
#define OP_TALKWIN_PAL			(10)				//bEBhEgppbgio[
#define OP_MENU_PAL				(11)				//j[EBhEgppbgio[
#define OP_MSGFONT_PAL			(12)				//MSGtHggppbgio[
#define OP_FONT_PAL				(13)				//SYSTEMtHggppbgio[

//OBJio[
#define OP_OBJ_HAKASE			(0)
#define OP_OBJ_RIVAL			(1)
#define OP_OBJ_KAGE				(2)

#define OP_VANISH_ON			(0)					//\
#define OP_VANISH_OFF			(1)					//\


//==============================================================================================
//
//	\̐錾
//
//==============================================================================================
typedef struct OPENING_WORK_tag
{
	GF_BGL_INI* bgl;								//BGLf[^
	GF_BGL_BMPWIN bmpwin[OPENING_BMPWIN_MAX];		//BMPEBhEf[^

	MSGDATA_MANAGER* msgman;						//bZ[W}l[W[
	WORDSET* wordset;								//PZbg
	STRBUF* msg_buf;								//bZ[Wobt@|C^
	STRBUF* tmp_buf;								//e|obt@|C^
	STRBUF* menu_buf[OPENING_MENU_MAX];				//j[obt@|C^

	STRCODE str[PERSON_NAME_SIZE + EOM_SIZE];
	PROC* proc;

	CONFIG* config;									//RtBO|C^
	SAVEDATA* sv;									//Z[uf[^|C^

	u16 count;
	u8 sub_seq;
	u8 msg_index;									//bZ[Windex

	u8 sex;											//
	u8 cancel;										//蒼tO
	u8 dmy3;
	u8 dmy4;

	//BMPj[(bmp_menu.h)
	BMPMENU_HEADER MenuH;							//BMPj[wb_[
	BMPMENU_WORK * mw;								//BMPj[[N
	BMPMENU_DATA Data[OPENING_MENU_MAX];			//BMPj[f[^
	u32 ret_work;									//Ip[^

	fx32 ScaleX;
	fx32 ScaleY;

	OPENING_OBJ_WORK ObjWork;

	PALETTE_FADE_PTR pfd;							//pbgtF[h

	TCB_PTR	tcb;									//O͊ĎTCB
}OPENING_WORK;


#endif //_OPENING_SYS_H_


