//============================================================================================
/**
 * @file	title.c
 * @brief	^Cg
 * @author	Hiroyuki Nakamura
 * @date	2005.02.02
 */
//============================================================================================
#include "common.h"
#include "system/palanm.h"
#include "system/lib_pack.h"
#include "system/snd_tool.h"
#include "system/brightness.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/wipe.h"
#include "system/pm_rtc.h"
#include "system/main.h"
#include "system/savedata.h"
#include "system/fontproc.h"

#include "titledemo.naix"
#include "op_demo.naix"
#include "msgdata/msg.naix"

#include "field/field.h"
#include "demo/title.h"
#include "demo/opening/opening_sys.h"

#include "msgdata/msg_title.h"

extern const PROC_DATA BackupEraseProcData;
extern const PROC_DATA BackupLoadProcData;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌ŗp̃wb_t@C

#ifdef PG5_TRIAL

#include "savedata/savedata.h"
#include "field/ev_pokemon.h"
#include "field/location.h"
#include "field/player.h"
#include "field/situation.h"
#include "field/situation_local.h"
#include "field/sysflag.h"
#include "field/syswork.h"
#include "field/zonedata.h"
#include "poketool/pokeparty.h"

#include "battle/attr_def.h"
#include "battle/tokusyu_def.h"
#include "battle/wazano_def.h"
#include "field/mapdefine.h"

#include "msgdata/msg_opening_name.h"

#if PM_LANG==LANG_ENGLISH
#include "resource/eng/trial/trial.naix"
#endif

#endif

// ----------------------------------------------------------------------------

//================================================================
//================================================================
//
//
//		^Cg
//
//
//================================================================
//================================================================
//----------------------------------
//^錾
//----------------------------------
///	Rcfp\
typedef struct TITLE_3DWORK_tag
{
	int	Draw3Dsw;

	NNSG3dRenderObj			rndobj;
	NNSG3dResMdl*			resmdl;
	NNSG3dResFileHeader* 	rfhead;
	void*					resanm;
	NNSG3dAnmObj*			anmobj;
	NNSFndAllocator			allocater;

	VecFx32 trans;			//W
	VecFx32 scale;			//XP[
	VecFx32	rotate;			//]	

	GF_CAMERA_PTR camera_p;

	int		anm_flag;
}TITLE_3DWORK;

///	S]fgp[N\
typedef struct TITLE_LOGODEMO_WORK_tag
{
	int seq;
	TITLE_3DWORK	logo;

}TITLE_LOGODEMO_WORK;

///	^Cgʎgp[N\
typedef struct TITLE_TITLEDEMO_WORK_tag
{
	int seq;
	TITLE_3DWORK	poke;
	u16		wait_counter;
	GF_BGL_BMPWIN	msgwin;

	VecFx32	camera_tpos;
	VecFx32	camera_cpos;

	BOOL	enable_flag;

	VecFx32	cp_st;
	VecFx32	cp_ed;

	VecFx32	tp_st;
	VecFx32	tp_ed;

	VecFx16	lv0;
	VecFx16	lv1;
	u16		l1ef;
	u16		l1efseq;

	fx32	c_speed;

}TITLE_TITLEDEMO_WORK;
			
///	^CgS̐p[N\
typedef struct TITLE_DEMO_WORK_tag
{
	int	heapID; 

	GF_BGL_INI*		bgl;	// BG}l[W
	GF_G3DMAN*		g3Dman;	// 3D}l[W

	TITLE_LOGODEMO_WORK		logoDemo;
	TITLE_TITLEDEMO_WORK	titleDemo;

	u16		next_scene;
	int		enable_counter;
	int		connect_count;
	int		connect_num;

	int		main_timer;
}TITLE_DEMO_WORK;

///	Rc`GWXCb``
typedef enum {
	DRAW3D_DISABLE = 0,	///<`Ȃ
	DRAW3D_BANISH,		///<`Ȃ
	DRAW3D_ENABLE,		///<`
};

typedef enum {
	DRAW3DANM_DISABLE = 0,	///<`Ȃ
	DRAW3DANM_STOP,			///<~`Ȃ
	DRAW3DANM_ENABLE,		///<`
};

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łŃ^Cg炷Q[{҂ɑJڂ邽߂̃V[PX`ǉ

///	JڐV[`
typedef enum {
	SCENE_ID_NOT_DECIDE = 0,		///<JڐV[m
	SCENE_ID_MENU,					///<JڐV[Fʏ탁j[
	SCENE_ID_ERASE,					///<JڐV[FobNAbv
	SCENE_ID_LOOP,					///<JڐV[F^C}[[v
	SCENE_ID_DEBUGMENU,				///<JڐV[FfobOj[
#ifdef PG5_TRIAL
	SCENE_ID_TRIALSTART,			///<JڐV[F̌ŃX^[g
#endif
}SCENE_ID;

// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łŌxESRB[eBO\邽߂̒`ǉ

enum{
	//^Cg
	TITLEDEMO_SEQ_TITLE_LOAD,
	TITLEDEMO_SEQ_TITLE_IN,
	TITLEDEMO_SEQ_TITLE_SOUNDSTART,
	TITLEDEMO_SEQ_TITLE_KEYCHECK,
	TITLEDEMO_SEQ_TITLE_EXITWAIT,
	TITLEDEMO_SEQ_TITLE_EXITWAIT2,
	TITLEDEMO_SEQ_TITLE_EXIT,
#ifdef PG5_TRIAL
	TITLEDEMO_SEQ_TITLE_EXITWAIT_TRIAL,
	TITLEDEMO_SEQ_WARNING_INIT,
	TITLEDEMO_SEQ_WARNING_INITWAIT,
	TITLEDEMO_SEQ_WARNING,
	TITLEDEMO_SEQ_ESRB_INIT,
	TITLEDEMO_SEQ_ESRB_INITWAIT,
	TITLEDEMO_SEQ_ESRB,
	TITLEDEMO_SEQ_ESRB_EXIT,
#endif
};

// ----------------------------------------------------------------------------

//----------------------------------
//֐錾
//----------------------------------
extern void		Main_SetNextProc(FSOverlayID ov_id, const PROC_DATA * proc_data);
FS_EXTERN_OVERLAY( d_startmenu );
FS_EXTERN_OVERLAY( title_debug );
FS_EXTERN_OVERLAY( startmenu );
FS_EXTERN_OVERLAY( title );
extern const PROC_DATA OpDemoProcData;

static PROC_RESULT Title_Init( PROC * proc, int * seq );
static PROC_RESULT Title_Main( PROC * proc, int * seq );
static PROC_RESULT Title_Exit( PROC * proc, int * seq );

static void TitleLogo_Demo_VBlank( void* work );
static void Title_VramBankSet( void );
static void Title2DBgSet( TITLE_DEMO_WORK* wk );
static void Title2DBgRelease( TITLE_DEMO_WORK* wk );

static void Title3D_Init( TITLE_DEMO_WORK* wk );
static void Title3D_Exit( TITLE_DEMO_WORK* wk );
static void Title3D_ModelLoad( TITLE_3DWORK* g3Dwk, int dataID, int texanmID, int heapID);
static void Title3D_ModelRelease( TITLE_3DWORK* g3Dwk );
static void Title3D_Draw( TITLE_3DWORK* g3Dwk );

static BOOL TitleDemoSkipCheck( void );

static BOOL TitleDemo_Init( TITLE_TITLEDEMO_WORK* wk, GF_BGL_INI* bgl,int heapID );
static BOOL TitleDemo_DispOnEffect( TITLE_TITLEDEMO_WORK* wk, GF_BGL_INI* bgl,int heapID );
static BOOL TitleDemo_Main( TITLE_TITLEDEMO_WORK* wk, GF_BGL_INI* bgl,int heapID );
static BOOL TitleDemo_Exit( TITLE_TITLEDEMO_WORK* wk, GF_BGL_INI* bgl,int heapID );

#ifdef PM_DEBUG
static void DebugControl( TITLE_TITLEDEMO_WORK* wk );
#endif

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌ŗp̊֐E萔`

#ifdef PG5_TRIAL

extern const PROC_DATA FirstGameProcData;

void SetTrialPlayFlag(BOOL flag);		// main.c

static void WarningGraphicSet(GF_BGL_INI* ini, int heapID, TITLE_TITLEDEMO_WORK* wk);
static void EsrbGraphicSet(GF_BGL_INI* ini, int heapID, TITLE_TITLEDEMO_WORK* wk);

static int Debug_MakeMyStatus(MYSTATUS * my);
static void SamplePlay_MakePokeData( SAVEDATA* savedata );
static void SamplePlay_MakeStartData( SAVEDATA* savedata );

#endif

// ----------------------------------------------------------------------------

//----------------------------------
//}N錾
//----------------------------------
#define KEYTRG( pattern ) ( ( sys.trg & ( pattern ) ) == ( pattern ) )
#define KEYCNT( pattern ) ( ( sys.cont & ( pattern ) ) == ( pattern ) )

#define VEC_SET( vec, vecx, vecy, vecz ) {					\
	vec.x = vecx;											\
	vec.y = vecy;											\
	vec.z = vecz;											\
}

#define FADE( pattern, col, heapID ) {						\
	WIPE_SYS_Start(	WIPE_PATTERN_WMS,pattern,pattern,col,	\
					WIPE_DEF_DIV,WIPE_DEF_SYNC,heapID);		\
}

#define MAINFRAME_ON( frame )		{ GF_Disp_GX_VisibleControl( frame, VISIBLE_ON ); }
#define MAINFRAME_OFF( frame )		{ GF_Disp_GX_VisibleControl( frame, VISIBLE_OFF ); }
#define SUBFRAME_ON( frame )		{ GF_Disp_GXS_VisibleControl( frame, VISIBLE_ON ); }
#define SUBFRAME_OFF( frame )		{ GF_Disp_GXS_VisibleControl( frame, VISIBLE_OFF ); }

#define FRAME_ALLOFF {				\
	MAINFRAME_OFF( GX_PLANEMASK_BG0 )	\
	MAINFRAME_OFF( GX_PLANEMASK_BG1 )	\
	MAINFRAME_OFF( GX_PLANEMASK_BG2 )	\
	MAINFRAME_OFF( GX_PLANEMASK_BG3 )	\
	SUBFRAME_OFF( GX_PLANEMASK_BG0 )	\
	SUBFRAME_OFF( GX_PLANEMASK_BG1 )	\
	SUBFRAME_OFF( GX_PLANEMASK_BG2 )	\
	SUBFRAME_OFF( GX_PLANEMASK_BG3 )	\
}
		
#define SEQ_RESET(seq)			{ seq = 0; }

#define TITLE_LOGO_FRAME			( GF_BGL_FRAME2_S )
#define TITLE_LOGO2_FRAME			( GF_BGL_FRAME1_S )
#define TITLE_PRSSTART_FRAME		( GF_BGL_FRAME0_S )
#define TITLE_CPRIGHT_FRAME			( GF_BGL_FRAME1_M )

#define TITLE_LOGO_FRAME_ON			{ SUBFRAME_ON( GX_PLANEMASK_BG2 ) }
#define TITLE_LOGO2_FRAME_ON		{ SUBFRAME_ON( GX_PLANEMASK_BG1 ) }
#define TITLE_PRSSTART_FRAME_ON		{ SUBFRAME_ON( GX_PLANEMASK_BG0 ) }
#define TITLE_CPRIGHT_FRAME_ON		{ MAINFRAME_ON( GX_PLANEMASK_BG1 ) }
#define TITLE_LOGO_FRAME_OFF		{ SUBFRAME_OFF( GX_PLANEMASK_BG2 ) }
#define TITLE_LOGO2_FRAME_OFF		{ SUBFRAME_OFF( GX_PLANEMASK_BG1 ) }
#define TITLE_PRSSTART_FRAME_OFF	{ SUBFRAME_OFF( GX_PLANEMASK_BG0 ) }
#define TITLE_CPRIGHT_FRAME_OFF		{ MAINFRAME_OFF( GX_PLANEMASK_BG1 ) }

#define TITLE_LOGO_PALTYPE			( PALTYPE_SUB_BG_EX )
#define TITLE_GF_PALTYPE			( PALTYPE_MAIN_BG )

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌ŗp̒萔`

#ifdef PG5_TRIAL

#define BLINK_COLOR		(*((volatile u16 *)HW_BG_PLTT + 3))		// "Touch the Touch Screen to Continue." ̕`F

enum {
	BRIGHTNESS_MAX			= 31,

	MAIN_TIMER_MAX			= 18*30,		// ^Cg[v܂ł̎ԁi18bj

	TRIAL_FADE_SPEED		= 15,			// tF[hC^AEg̎ԁi0.5bj
	TRIAL_WARNING_FIXTIME	= 45,			// x\ԁi1.5bj
	TRIAL_WARNING_TIME		= 60*30,		// x\ԁi60bj
	TRIAL_ESRB_FIXTIME		=  4*30,		// [eBO\ԁi4bj
};

#else

enum {
	MAIN_TIMER_MAX			= 30*30			// ^Cg[v܂ł̎ԁi30bj
};

#endif

// ----------------------------------------------------------------------------

//=================================================================================================
//
// oqnb`e[u
//
//=================================================================================================
const PROC_DATA TitleProcData = {
	Title_Init,
	Title_Main,
	Title_Exit,
	NO_OVERLAY_ID
};

//================================================================
//----------------------------------
//oqnb
//----------------------------------
static PROC_RESULT Title_Init(PROC * proc, int * seq)
{
	TITLE_DEMO_WORK * wk;
	int	heapID;

#ifdef	PM_DEBUG
	OS_TPrintf("SYSTEM HEAP SIZE = %08x\n", sys_GetHeapFreeSize(HEAPID_BASE_SYSTEM));
#endif
	heapID = HEAPID_TITLE_DEMO;

	WIPE_SetBrightness( WIPE_DISP_MAIN,WIPE_FADE_WHITE );
	WIPE_SetBrightness( WIPE_DISP_SUB,WIPE_FADE_WHITE );

	//J[ʖ
	G2S_BlendNone();
	G2_BlendNone();
	
	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrSet( NULL,NULL );		// HBlankZbg

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane(0);
	GXS_SetVisiblePlane(0);

	sys_KeyRepeatSpeedSet(4,8);
	sys_CreateHeap( HEAPID_BASE_APP, heapID, 0x40000 );

	wk = PROC_AllocWork(proc,sizeof(TITLE_DEMO_WORK),heapID);
	memset(wk,0,sizeof(TITLE_DEMO_WORK));

	wk->heapID = heapID;
	wk->next_scene = SCENE_ID_NOT_DECIDE;
	wk->main_timer = 0;

	Title_VramBankSet();
	Title2DBgSet(wk);
	Title3D_Init(wk);

	sys_VBlankFuncChange(TitleLogo_Demo_VBlank,(void*)wk);
	GF_Disp_DispOn();

	return	PROC_RES_FINISH;
}

//----------------------------------
//oqnbC
//----------------------------------
static PROC_RESULT Title_Main(PROC * proc, int * seq)
{
	TITLE_DEMO_WORK * wk = PROC_GetWork( proc );

	switch(*seq){

	case TITLEDEMO_SEQ_TITLE_LOAD:
		if( TitleDemo_Init( &wk->titleDemo, wk->bgl, wk->heapID ) == TRUE){

			SEQ_RESET(wk->titleDemo.seq)

			if(sys.DS_Boot_Flag == FALSE){		//NȊO͓oJbg
#ifdef PM_DEBUG
				wk->enable_counter = 0;
#else
				wk->enable_counter = 30*1;	//1/30 frame * 1
#endif
				*seq = TITLEDEMO_SEQ_TITLE_SOUNDSTART;
			} else {
				wk->enable_counter = 0;
				sys.DS_Boot_Flag = FALSE;	//u[gtOZbg
				*seq = TITLEDEMO_SEQ_TITLE_IN;
			}
		}
		break;

	case TITLEDEMO_SEQ_TITLE_IN:
		if( TitleDemo_DispOnEffect( &wk->titleDemo, wk->bgl, wk->heapID ) == TRUE){
			SEQ_RESET(wk->titleDemo.seq)
			*seq = TITLEDEMO_SEQ_TITLE_SOUNDSTART;
		}
		break;
			
	case TITLEDEMO_SEQ_TITLE_SOUNDSTART:
		Snd_SceneSet( SND_SCENE_DUMMY );						//yV[Zbg
		Snd_DataSetByScene( SND_SCENE_TITLE, SEQ_TITLE01, 1 );	//^Cg
		*seq = TITLEDEMO_SEQ_TITLE_KEYCHECK;
		break;

	case TITLEDEMO_SEQ_TITLE_KEYCHECK:
		if( wk->enable_counter ){
			wk->enable_counter--;	//삪\ɂȂ܂ł̃EFCgvpJE^

			//Jn̂ݖQb炢܂ŃQ[JnoȂ悤ɂ
			//(AłƑ^Cgʂ𔲂Ă܂̂)
			wk->titleDemo.enable_flag = FALSE;
			TitleDemo_Main( &wk->titleDemo, wk->bgl, wk->heapID );
			break;
		} else {
			wk->titleDemo.enable_flag = TRUE;
			TitleDemo_Main( &wk->titleDemo, wk->bgl, wk->heapID );
		}
		wk->main_timer++;

		if( KEYTRG(PAD_BUTTON_A) || KEYTRG(PAD_BUTTON_START)){
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł̓^Cg炷Q[{҂Ɉڍs
#ifdef PG5_TRIAL
			wk->next_scene = SCENE_ID_TRIALSTART;//̌ŃX^[g
			Snd_BgmFadeOut( 0, 60 );
			Snd_SePlay( SEQ_SE_DP_START );
			*seq = TITLEDEMO_SEQ_TITLE_EXITWAIT_TRIAL;
#else
			wk->next_scene = SCENE_ID_MENU;//Jnj[
			Snd_BgmFadeOut( 0, 60 );
			Snd_SePlay( SEQ_SE_DP_START );
			*seq = TITLEDEMO_SEQ_TITLE_EXITWAIT;
#endif
// ----------------------------------------------------------------------------
			break;
		}
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł̓obNAbv[hɓȂ悤ɕύX
#ifndef PG5_TRIAL
		if( KEYCNT(PAD_BUTTON_B|PAD_KEY_UP|PAD_BUTTON_SELECT) ){
			wk->next_scene = SCENE_ID_ERASE;//obNAbv
			FADE(WIPE_TYPE_FADEOUT,WIPE_FADE_BLACK,wk->heapID)
			*seq = TITLEDEMO_SEQ_TITLE_EXIT;
			break;
		}
#endif
// ----------------------------------------------------------------------------

		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2007/02/09
		// ^Cg^CAEg܂ł̎Ԃ萔\ɒu
		if( wk->main_timer > MAIN_TIMER_MAX ){
			wk->next_scene = SCENE_ID_LOOP;//^CAEg[v
			sys.DS_Boot_Flag = TRUE;	//u[gtOZbg
			TITLE_PRSSTART_FRAME_OFF
			Snd_BgmFadeOut( 0, 60 );
			*seq = TITLEDEMO_SEQ_TITLE_EXITWAIT2;
			break;
		}
		// ----------------------------------------------------------------------------

#ifdef PM_DEBUG
		DebugControl( &wk->titleDemo );

		if( KEYTRG(PAD_BUTTON_SELECT) ){
			wk->next_scene = SCENE_ID_DEBUGMENU;//fobOj[
			FADE(WIPE_TYPE_FADEOUT,WIPE_FADE_BLACK,wk->heapID)
			*seq = TITLEDEMO_SEQ_TITLE_EXIT;
			break;
		}
#endif
		break;
			
	case TITLEDEMO_SEQ_TITLE_EXITWAIT:
		wk->titleDemo.enable_flag = FALSE;
		TitleDemo_Main( &wk->titleDemo, wk->bgl, wk->heapID );

		if( Snd_FadeCheck() == 0 ){
			Snd_BgmStop( SEQ_TITLE01, 0 );	
			FADE(WIPE_TYPE_FADEOUT,WIPE_FADE_BLACK,wk->heapID)
			*seq = TITLEDEMO_SEQ_TITLE_EXIT;
		}
		break;

	case TITLEDEMO_SEQ_TITLE_EXITWAIT2:
		wk->titleDemo.enable_flag = FALSE;
		TitleDemo_Main( &wk->titleDemo, wk->bgl, wk->heapID );

		if( Snd_FadeCheck() == 0 ){
			Snd_BgmStop( SEQ_TITLE01, 0 );	
			FADE(WIPE_TYPE_FADEOUT,WIPE_FADE_WHITE,wk->heapID)
			*seq = TITLEDEMO_SEQ_TITLE_EXIT;
		}
		break;

	case TITLEDEMO_SEQ_TITLE_EXIT:
		if(WIPE_SYS_EndCheck() == TRUE){
			if( TitleDemo_Exit( &wk->titleDemo, wk->bgl, wk->heapID ) == TRUE){
				return	PROC_RES_FINISH;
			}
		}
		break;

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łŌxESRB[eBO\V[PXǉ

#ifdef PG5_TRIAL
	case TITLEDEMO_SEQ_TITLE_EXITWAIT_TRIAL:
		wk->titleDemo.enable_flag = FALSE;
		TitleDemo_Main( &wk->titleDemo, wk->bgl, wk->heapID );

		if( Snd_FadeCheck() == 0 ){
			Snd_BgmStop( SEQ_TITLE01, 0 );
			// ʂtF[hAEg
			WIPE_SYS_Start( WIPE_PATTERN_M, WIPE_TYPE_FADEOUT, 0, WIPE_FADE_BLACK,
			                WIPE_DEF_DIV, WIPE_DEF_SYNC, wk->heapID);
			*seq = TITLEDEMO_SEQ_WARNING_INIT;
		}
		break;
	case TITLEDEMO_SEQ_WARNING_INIT:
		if (WIPE_SYS_EndCheck() == TRUE) {
			// ʂɌx\
			WarningGraphicSet( wk->bgl, wk->heapID, &wk->titleDemo );
			// tF[hCJn
			WIPE_SYS_Start( WIPE_PATTERN_M, WIPE_TYPE_FADEIN, 0, WIPE_FADE_BLACK,
			                TRIAL_FADE_SPEED, WIPE_DEF_SYNC, wk->heapID);
			*seq = TITLEDEMO_SEQ_WARNING_INITWAIT;
		}
		break;
	case TITLEDEMO_SEQ_WARNING_INITWAIT:
		if (WIPE_SYS_EndCheck() == TRUE) {
			wk->main_timer = 0;
			*seq = TITLEDEMO_SEQ_WARNING;
		}
		break;
	case TITLEDEMO_SEQ_WARNING:
		if (wk->main_timer >= TRIAL_WARNING_FIXTIME) {
			// "Touch the Touch Screen to Continue." _ŕ\
			u16 color;
			int bright;
			int fade_frame = (wk->main_timer - TRIAL_WARNING_FIXTIME) % (TRIAL_FADE_SPEED * 2);
			if (fade_frame < TRIAL_FADE_SPEED) {		// tF[hC
				bright = BRIGHTNESS_MAX * (TRIAL_FADE_SPEED - fade_frame) / TRIAL_FADE_SPEED;
			} else {									// tF[hAEg
				bright = BRIGHTNESS_MAX * (fade_frame - TRIAL_FADE_SPEED) / TRIAL_FADE_SPEED;
			}
			color = GX_RGB(bright,bright,bright);
			BLINK_COLOR = color;
			if (wk->main_timer >= TRIAL_WARNING_TIME || sys.cont_org || sys.tp_cont) {
				// ʂtF[hAEg
				WIPE_SYS_Start( WIPE_PATTERN_M, WIPE_TYPE_FADEOUT, 0, WIPE_FADE_BLACK,
				                TRIAL_FADE_SPEED, WIPE_DEF_SYNC, wk->heapID);
				*seq = TITLEDEMO_SEQ_ESRB_INIT;
			}
		}
		wk->main_timer++;
		break;
	case TITLEDEMO_SEQ_ESRB_INIT:
		if (WIPE_SYS_EndCheck() == TRUE) {
			// ʂɃ[eBO\
			EsrbGraphicSet( wk->bgl, wk->heapID, &wk->titleDemo );
			// tF[hCJn
			WIPE_SYS_Start( WIPE_PATTERN_M, WIPE_TYPE_FADEIN, 0, WIPE_FADE_BLACK,
			                TRIAL_FADE_SPEED, WIPE_DEF_SYNC, wk->heapID);
			*seq = TITLEDEMO_SEQ_ESRB_INITWAIT;
		}
		break;
	case TITLEDEMO_SEQ_ESRB_INITWAIT:
		if (WIPE_SYS_EndCheck() == TRUE) {
			wk->main_timer = 0;
			*seq = TITLEDEMO_SEQ_ESRB;
		}
		break;
	case TITLEDEMO_SEQ_ESRB:
		if (wk->main_timer >= TRIAL_ESRB_FIXTIME) {
			// ʂɃtF[hAEg
			WIPE_SYS_Start( WIPE_PATTERN_M, WIPE_TYPE_FADEOUT, WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK,
			                TRIAL_FADE_SPEED, WIPE_DEF_SYNC, wk->heapID);
			*seq = TITLEDEMO_SEQ_ESRB_EXIT;
		}
		wk->main_timer++;
		break;
	case TITLEDEMO_SEQ_ESRB_EXIT:
		if (WIPE_SYS_EndCheck() == TRUE) {
			// ʂ|P̑ŃtF[hAEg
			WIPE_SYS_Start( WIPE_PATTERN_S, WIPE_TYPE_FADEOUT, WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK,
			                WIPE_DEF_DIV, WIPE_DEF_SYNC, wk->heapID);
			*seq = TITLEDEMO_SEQ_TITLE_EXIT;
		}
		break;
#endif

// ----------------------------------------------------------------------------
	}
	return	PROC_RES_CONTINUE;
}

//----------------------------------
//oqnbI
//----------------------------------
static PROC_RESULT Title_Exit(PROC * proc, int * seq)
{
	TITLE_DEMO_WORK * wk = PROC_GetWork( proc );
	int heapID = wk->heapID;
	int next_scene = wk->next_scene;

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg

	Title3D_Exit( wk );
	Title2DBgRelease( wk );
	PROC_FreeWork( proc );				// [NJ

	sys_DeleteHeap( heapID );

	switch ( next_scene ) {
	default:
	case SCENE_ID_MENU:
		Main_SetNextProc( NO_OVERLAY_ID, &BackupLoadProcData );
		break;
	case SCENE_ID_ERASE:
		Main_SetNextProc( NO_OVERLAY_ID, &BackupEraseProcData );
		break;
	case SCENE_ID_LOOP:
		Snd_SceneSet( SND_SCENE_DUMMY );						//yV[Zbg
		Main_SetNextProc( FS_OVERLAY_ID( title ), &OpDemoProcData );
		break;

#ifdef PM_DEBUG
	case SCENE_ID_DEBUGMENU:
		Main_SetNextProc( FS_OVERLAY_ID(title_debug), &DebugTitleMenuProcData );
		break;
#endif

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łŃ^Cg炷Q[ɑJڂ邽߂̃V[PXǉ
#ifdef PG5_TRIAL
	case SCENE_ID_TRIALSTART:
		{
			//|P鏈ăQ[X^[g
			SAVEDATA* savedata = ((MAINWORK *)PROC_GetParentWork(proc))->savedata;
			SamplePlay_MakeStartData( savedata );
		}
		Main_SetNextProc( NO_OVERLAY_ID, &FirstGameProcData );
		SetTrialPlayFlag(TRUE);
		break;
#endif
// ----------------------------------------------------------------------------
	}
	return	PROC_RES_FINISH;
}


//----------------------------------
//uak`mj֐
//----------------------------------
static void TitleLogo_Demo_VBlank(void* work)
{
	TITLE_DEMO_WORK* wk = work;

	GF_BGL_VBlankFunc(wk->bgl);
}


//----------------------------------
//uq`lݒ
//----------------------------------
static void Title_VramBankSet(void)
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł "Demo Version" \̂߂ɃTuOBJVRAM蓖
	GF_BGL_DISPVRAM vramSetTable = {
#ifdef PG5_TRIAL
		GX_VRAM_BG_128_B,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_0123_H,	// Tu2DGWBGgpbg
		GX_VRAM_OBJ_NONE,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_0_A,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0_G				// eNX`pbgXbg
#else
		GX_VRAM_BG_128_B,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_0123_H,	// Tu2DGWBGgpbg
		GX_VRAM_OBJ_NONE,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_NONE,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_0_A,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0_G				// eNX`pbgXbg
#endif
	};
// ----------------------------------------------------------------------------
	GF_Disp_SetBank( &vramSetTable );
}


//----------------------------------
//
//	fXLbv
//
//----------------------------------
static BOOL TitleDemoSkipCheck( void )
{
	if( KEYTRG(PAD_BUTTON_A) || KEYTRG(PAD_BUTTON_START) || KEYTRG(PAD_BUTTON_SELECT) ){
		return TRUE;
	}
	return FALSE;
}


//----------------------------------
//
//	RcI
//
//----------------------------------
static void Title3D_Init( TITLE_DEMO_WORK* wk )
{
	wk->g3Dman = GF_G3DMAN_Init(wk->heapID, 
			GF_G3DMAN_LNK, GF_G3DTEX_128K, GF_G3DMAN_LNK, GF_G3DPLT_64K, NULL );

	// Rcgpʂ̐ݒύX(vCIeB[)
    G2_SetBG0Priority(1);
}

static void Title3D_Exit( TITLE_DEMO_WORK* wk )
{
	GF_G3D_Exit( wk->g3Dman );
}

//----------------------------------
//
//	Rcf[^ǂݍ݁I
//
//----------------------------------
static void Title3D_ModelLoad( TITLE_3DWORK* g3Dwk, int dataID, int texanmID, int heapID)
{
	void*			anm;
    NNSG3dResTex*	tex;

	sys_InitAllocator( &g3Dwk->allocater, heapID, 4 ); 

	g3Dwk->rfhead = ArchiveDataLoadMalloc(ARC_TITLE,dataID,heapID);
	g3Dwk->resanm = ArchiveDataLoadMalloc(ARC_TITLE,texanmID,heapID);
	simple_3DModelSetResFileAlready( &g3Dwk->rndobj, &g3Dwk->resmdl, &g3Dwk->rfhead );

	anm				= NNS_G3dGetAnmByIdx( g3Dwk->resanm, 0 );
	g3Dwk->anmobj	= NNS_G3dAllocAnmObj( &g3Dwk->allocater, anm, g3Dwk->resmdl );
    tex				= NNS_G3dGetTex( g3Dwk->rfhead );
	NNS_G3dAnmObjInit( g3Dwk->anmobj, anm, g3Dwk->resmdl, tex );
	NNS_G3dRenderObjAddAnmObj( &g3Dwk->rndobj, g3Dwk->anmobj );

	{
		//ff[^p[^
		VecFx32 init_trans	= { 0, 0, 0 };
		VecFx32 init_scale	= { FX32_ONE, FX32_ONE, FX32_ONE };
		VecFx32 init_rotate = { 0, 0, 0 };

		g3Dwk->trans	= init_trans;
		g3Dwk->scale	= init_scale;
		g3Dwk->rotate	= init_rotate;
	}
	g3Dwk->anm_flag = DRAW3DANM_DISABLE;
}

static void Title3D_ModelRelease(TITLE_3DWORK* g3Dwk)
{
	NNS_G3dFreeAnmObj( &g3Dwk->allocater, g3Dwk->anmobj ); 
	sys_FreeMemoryEz( g3Dwk->resanm );
	sys_FreeMemoryEz( g3Dwk->rfhead );
}


//----------------------------------
//
//	Rc`֐
//
//----------------------------------
static void Title3D_Draw( TITLE_3DWORK* g3Dwk )
{
	MtxFx33 rotate_tmp = {FX32_ONE,0,0,0,FX32_ONE,0,0,0,FX32_ONE};

	switch( g3Dwk->Draw3Dsw ){

	case DRAW3D_DISABLE:
		break;

	case DRAW3D_BANISH:
		GF_G3X_Reset();
		GF_G3_RequestSwapBuffers(GX_SORTMODE_AUTO,GX_BUFFERMODE_W);
		g3Dwk->Draw3Dsw = DRAW3D_DISABLE;
		break;

	case DRAW3D_ENABLE:
		GF_G3X_Reset();
		GFC_CameraLookAt();

		VecFx32_to_MtxFx33(	&rotate_tmp,&g3Dwk->rotate);

		simple_3DModelDraw(	&g3Dwk->rndobj,
							&g3Dwk->trans,
							&rotate_tmp,
							&g3Dwk->scale);
#if 0
		if( g3Dwk->anm_flag == TRUE ){
			g3Dwk->anmobj->frame += (FX32_ONE);
			if( g3Dwk->anmobj->frame == NNS_G3dAnmObjGetNumFrame( g3Dwk->anmobj )){
				g3Dwk->anmobj->frame = 0;
			}
		}
#else
		switch( g3Dwk->anm_flag ){
		case DRAW3DANM_DISABLE:
			g3Dwk->anmobj->frame = 0;
			break;

		case DRAW3DANM_STOP:
			if( g3Dwk->anmobj->frame == 0 ){
				g3Dwk->anm_flag = DRAW3DANM_DISABLE;
				break;
			}

		case DRAW3DANM_ENABLE:
			g3Dwk->anmobj->frame += (FX32_ONE);
			if( g3Dwk->anmobj->frame == NNS_G3dAnmObjGetNumFrame( g3Dwk->anmobj )){
				g3Dwk->anmobj->frame = 0;
			}
			break;
		}
#endif
		GF_G3_RequestSwapBuffers(GX_SORTMODE_AUTO,GX_BUFFERMODE_W);
		break;
	}
}


//----------------------------------
//
//	QcafI
//
//----------------------------------
static void Title2DBgSet( TITLE_DEMO_WORK* wk )
{
	//BGCupm
	wk->bgl = GF_BGL_BglIniAlloc(wk->heapID);

	{	// BGVXeݒ
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS,GX_BGMODE_0,GX_BGMODE_0,GX_BG0_AS_3D
		};	
		GF_BGL_InitBG( &BGsys_data );
	}

	{	// PRESS START afݒ(0)
		GF_BGL_BGCNT_HEADER PrsSt_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x2800, GX_BG_CHARBASE_0x04000,
			GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, TITLE_PRSSTART_FRAME, &PrsSt_Data, GF_BGL_MODE_TEXT );
	}
	{	// _CEp[S afݒ(1)
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2007/01/31
		// ^CgSCOł̂̂ɍւ
		GF_BGL_BGCNT_HEADER DPlogo_Data = {
			0, 0, 0x0800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0x3000, GX_BG_CHARBASE_0x08000,
			GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
		};
		// ----------------------------------------------------------------------------
		GF_BGL_BGControlSet( wk->bgl, TITLE_LOGO2_FRAME, &DPlogo_Data, GF_BGL_MODE_TEXT );
	}
	{	// ^CgS afݒ(2)
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2007/01/31
		// ^CgSCOł̂̂ɍւ
		GF_BGL_BGCNT_HEADER Titlelogo_Data = {
			0, 0, 0x0800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0x3800, GX_BG_CHARBASE_0x10000,
			GX_BG_EXTPLTT_23, 0, 0, 0, FALSE
		};
		// ----------------------------------------------------------------------------
		GF_BGL_BGControlSet( wk->bgl, TITLE_LOGO_FRAME, &Titlelogo_Data, GF_BGL_MODE_TEXT );
	}
	{	// GAMEFREAK inc afݒ(1)
		GF_BGL_BGCNT_HEADER GF_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x3800, GX_BG_CHARBASE_0x04000,
			GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, TITLE_CPRIGHT_FRAME, &GF_Data, GF_BGL_MODE_TEXT );
	}

	{	// CfBXvCwi afݒ(3)@
		GF_BGL_BGCNT_HEADER BackM_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x2000, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_01, 3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, GF_BGL_FRAME3_M, &BackM_Data, GF_BGL_MODE_TEXT );
	}
	{	// TufBXvCwi afݒ(3)@
		GF_BGL_BGCNT_HEADER BackS_Data = {
			0, 0, 0x800, 0,
			GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x2000, GX_BG_CHARBASE_0x00000,
			GX_BG_EXTPLTT_01, 3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( wk->bgl, GF_BGL_FRAME3_S, &BackS_Data, GF_BGL_MODE_TEXT );
	}
	FRAME_ALLOFF

	GF_BGL_BackGroundColorSet( GF_BGL_FRAME0_M, 0x0000 );	//wiFiCʁj
	GF_BGL_BackGroundColorSet( GF_BGL_FRAME0_S, 0x0000 );	//wiFiTuʁj
}

static void Title2DBgRelease( TITLE_DEMO_WORK* wk )
{
	FRAME_ALLOFF
	GF_BGL_BGControlExit( wk->bgl, TITLE_PRSSTART_FRAME );
	GF_BGL_BGControlExit( wk->bgl, TITLE_LOGO2_FRAME );
	GF_BGL_BGControlExit( wk->bgl, TITLE_LOGO_FRAME );
	GF_BGL_BGControlExit( wk->bgl, TITLE_CPRIGHT_FRAME );

	GF_BGL_BGControlExit( wk->bgl, GF_BGL_FRAME3_M );
	GF_BGL_BGControlExit( wk->bgl, GF_BGL_FRAME3_S );

	sys_FreeMemoryEz( wk->bgl );
}





//=================================================================================================
//
//	^Cg
//
//=================================================================================================
static void Title2DGraphicSet(GF_BGL_INI* ini,int heapID, TITLE_TITLEDEMO_WORK* wk );
static void Title2DGraphicRelease(GF_BGL_INI* ini,int heapID, TITLE_TITLEDEMO_WORK* wk );
static void TitleDemoDataGet( TITLE_TITLEDEMO_WORK* wk );
static void TitleDemoLight1Effect( TITLE_TITLEDEMO_WORK* wk );

//eݒliNitroViewer@Ŏ擾j
#define TD_TITLE_CAMERA_PERSPWAY		(0x0b60)
#define TD_TITLE_CAMERA_CLIP_NEAR		(0)
#define TD_TITLE_CAMERA_CLIP_FAR		(FX32_ONE*100)

#define DOTSIZE							(8)
#define PAL1DATA						(2)
#define PAL1SIZE						(16*PAL1DATA)

#define FLUSH_WIPE_DIV	( 5 )
#define FLUSH_WIPE_SYNC	( 2 )

#define FLUSH_SET( sync, to, from  )	{												\
	ChangeBrightnessRequest( sync, to, from,											\
		( /*GX_BLEND_PLANEMASK_BG0 |*/ GX_BLEND_PLANEMASK_BG1 | GX_BLEND_PLANEMASK_BG2 ),	\
		MASK_MAIN_DISPLAY );															\
	ChangeBrightnessRequest( sync, to, from,											\
		( GX_BLEND_PLANEMASK_BG0 | GX_BLEND_PLANEMASK_BG1 | GX_BLEND_PLANEMASK_BG2 ),	\
		MASK_SUB_DISPLAY );																\
}

#define FLUSH_WAIT	( (IsFinishedBrightnessChg( MASK_MAIN_DISPLAY ) == TRUE )			\
						 &&(IsFinishedBrightnessChg( MASK_SUB_DISPLAY ) == TRUE ) )

#define CAMERA_MOVE( now_pos, to_pos, speed, flag ) {		\
	if( now_pos > to_pos ){									\
		if( ( now_pos - to_pos ) > speed ){					\
			now_pos -= speed;								\
		} else {											\
			now_pos = to_pos;								\
		}													\
		flag = FALSE;										\
	} else if( now_pos < to_pos ){							\
		if( ( to_pos - now_pos ) > speed ){					\
			now_pos += speed;								\
		} else {											\
			now_pos = to_pos;								\
		}													\
		flag = FALSE;										\
	}														\
}

enum{
	TDSEQ_LIGHT1_INIT = 0,
	TDSEQ_LIGHT1_WAIT,
	TDSEQ_LIGHT1_UP,
	TDSEQ_LIGHT1_DOWN,
};
// bZ[WEBhE
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/01/31
// ^CgSCOł̂̂ɍւ
// localize_spec_mark(LANG_KOREA) imatake 2007/12/10
// ؍ł̃Sɂ킹čĒ
static const BMPWIN_DAT TitleMsgWinData =
#if PM_LANG == LANG_KOREA
	{ TITLE_PRSSTART_FRAME,2,17,28,2,2,1 };	//frame,startX,startY,sizeX,sizeY,palnum,cgxnum	
#else
	{ TITLE_PRSSTART_FRAME,2,19,28,2,2,1 };	//frame,startX,startY,sizeX,sizeY,palnum,cgxnum	
#endif
// ----------------------------------------------------------------------------

//----------------------------------
// 
//----------------------------------
static BOOL TitleDemo_Init( TITLE_TITLEDEMO_WORK* wk, GF_BGL_INI* bgl,int heapID )
{
	TitleDemoDataGet( wk );

	Title2DGraphicSet(bgl,heapID,wk);

	if( CasetteVersion == VERSION_DIAMOND ){
		Title3D_ModelLoad( &wk->poke, 
							NARC_titledemo_title_iar_nsbmd, 
							NARC_titledemo_title_iar_nsbta, 
							heapID );
	} else {
		Title3D_ModelLoad( &wk->poke, 
							NARC_titledemo_title_air_nsbmd, 
							NARC_titledemo_title_air_nsbta, 
							heapID );
	}

    G3X_AntiAlias( TRUE );
	G3X_AlphaBlend( TRUE );		// At@uh@I
	{
		//JZbg
		VEC_SET( wk->camera_tpos, wk->tp_st.x, wk->tp_st.y, wk->tp_st.z );
		VEC_SET( wk->camera_cpos, wk->cp_st.x, wk->cp_st.y, wk->cp_st.z );

		wk->poke.camera_p = GFC_AllocCamera(heapID);	//J쐬

		GFC_InitCameraTC( &wk->camera_tpos,&wk->camera_cpos,TD_TITLE_CAMERA_PERSPWAY,
							GF_CAMERA_PERSPECTIV,FALSE,wk->poke.camera_p);

		GFC_SetCameraClip(TD_TITLE_CAMERA_CLIP_NEAR,TD_TITLE_CAMERA_CLIP_FAR,wk->poke.camera_p);
		GFC_SetCameraView(GF_CAMERA_PERSPECTIV,wk->poke.camera_p);
		GFC_AttachCamera(wk->poke.camera_p);
	}
	{
		//CgZbg
		NNS_G3dGlbLightVector(0, wk->lv0.x, wk->lv0.y, wk->lv0.z );
		NNS_G3dGlbLightColor(0, 0x7fff);
		NNS_G3dGlbLightVector(1, wk->lv1.x, wk->lv1.y, wk->lv1.z );
		NNS_G3dGlbLightColor(1, 0x7fff);
	}
	{
		G3X_AntiAlias( TRUE );
	}

	//Rc`XCb`]
	sys.disp3DSW = DISP_3D_TO_SUB;
	GF_Disp_DispSelect();
	wk->poke.Draw3Dsw = DRAW3D_ENABLE;

	return TRUE;
}

//----------------------------------
// 
//----------------------------------
static void Title2DGraphicSetEffect(GF_BGL_INI* ini,int heapID, TITLE_TITLEDEMO_WORK* wk );
enum{
	TDSEQ_TITLE_EF_STARTWAIT = 0,			//JnEFCg
	TDSEQ_TITLE_EF_DISPON,					//`Jn
	TDSEQ_TITLE_EF_FLUSH0_1,				//tbV(ʏ큨)
	TDSEQ_TITLE_EF_FLUSH0_2,				//tbV(ʏ)
	TDSEQ_TITLE_EF_FLUSHWAIT,				//tbVEFCg
	TDSEQ_TITLE_EF_FLUSH1_1,				//tbV(ʏ큨)
	TDSEQ_TITLE_EF_FLUSH1_2,				//tbV(ʏ)
	TDSEQ_TITLE_EF_CAMERAMOVESTART,			//JړJnEGCg
	TDSEQ_TITLE_EF_CAMERAMOVE,				//Jړ
	TDSEQ_TITLE_EF_CAMERAMOVE_END,			//JړI
};

static BOOL TitleDemo_DispOnEffect( TITLE_TITLEDEMO_WORK* wk, GF_BGL_INI* bgl,int heapID )
{
	BOOL result = FALSE;

	if( TitleDemoSkipCheck() == TRUE ){	//XLbv
		WIPE_SYS_ExeEnd();				//Cv
		return TRUE;
	}

	switch(wk->seq){

	case TDSEQ_TITLE_EF_STARTWAIT:
		MAINFRAME_ON(GX_PLANEMASK_BG0)	//Rcʂnm
		MAINFRAME_ON(GX_PLANEMASK_BG3)	//MainDispwinm
		TITLE_LOGO2_FRAME_ON

		wk->l1efseq = TDSEQ_LIGHT1_INIT;
		wk->wait_counter = 15;
		WIPE_SYS_Start(	WIPE_PATTERN_WMS,WIPE_TYPE_FADEIN,WIPE_TYPE_FADEIN,
						WIPE_FADE_WHITE, 15, 3, heapID );

		wk->seq = TDSEQ_TITLE_EF_DISPON;
		break;

	case TDSEQ_TITLE_EF_DISPON:
		if(WIPE_SYS_EndCheck() == TRUE){	//PxύX҂
			if( wk->wait_counter ){
				wk->wait_counter--;
			} else {
				wk->wait_counter = 2;
				wk->seq = TDSEQ_TITLE_EF_FLUSH0_1;
			}		
		}
		break;

	case TDSEQ_TITLE_EF_FLUSH0_1:
		if( FLUSH_WAIT ){	//PxύX҂
			if(wk->wait_counter){
				FLUSH_SET( 10, BRIGHTNESS_WHITE, BRIGHTNESS_NORMAL )
				wk->l1efseq = TDSEQ_LIGHT1_UP;

				wk->wait_counter--;
				wk->seq = TDSEQ_TITLE_EF_FLUSH0_2;
			}else{
				wk->wait_counter = 0;
				wk->seq = TDSEQ_TITLE_EF_FLUSHWAIT;
			}
		}
		break;

	case TDSEQ_TITLE_EF_FLUSH0_2:
		if( FLUSH_WAIT ){	//PxύX҂
			FLUSH_SET( 10, BRIGHTNESS_NORMAL, BRIGHTNESS_WHITE )
			wk->l1efseq = TDSEQ_LIGHT1_DOWN;

			wk->seq = TDSEQ_TITLE_EF_FLUSH0_1;
		}
		break;

	case TDSEQ_TITLE_EF_FLUSHWAIT:
		if( wk->wait_counter ){
			wk->wait_counter--;
		} else {
			wk->wait_counter = 1;
			wk->seq = TDSEQ_TITLE_EF_FLUSH1_1;
		}
		break;

	case TDSEQ_TITLE_EF_FLUSH1_1:
		if(WIPE_SYS_EndCheck() == TRUE){	//PxύX҂
			if(wk->wait_counter){
				WIPE_SYS_Start(	WIPE_PATTERN_WMS,WIPE_TYPE_FADEOUT,WIPE_TYPE_FADEOUT,
								WIPE_FADE_WHITE,FLUSH_WIPE_DIV,FLUSH_WIPE_SYNC,heapID);
				wk->l1efseq = TDSEQ_LIGHT1_UP;

				wk->wait_counter--;
				wk->seq = TDSEQ_TITLE_EF_FLUSH1_2;
			}else{
				wk->wait_counter = 40;
				wk->seq = TDSEQ_TITLE_EF_CAMERAMOVESTART;
			}
		}
		break;

	case TDSEQ_TITLE_EF_FLUSH1_2:
		if(WIPE_SYS_EndCheck() == TRUE){	//PxύX҂
			Title2DGraphicSetEffect(bgl,heapID,wk);
			WIPE_SYS_Start(	WIPE_PATTERN_WMS,WIPE_TYPE_FADEIN,WIPE_TYPE_FADEIN,
							WIPE_FADE_WHITE,16,3,heapID);
			wk->seq = TDSEQ_TITLE_EF_FLUSH1_1;
		}
		break;

	case TDSEQ_TITLE_EF_CAMERAMOVESTART:
		if( wk->wait_counter ){
			wk->wait_counter--;
			if( wk->wait_counter == 15 ){
				wk->poke.anm_flag = DRAW3DANM_ENABLE;
			}
		} else {
			wk->seq = TDSEQ_TITLE_EF_CAMERAMOVE;
		}
		break;

	case TDSEQ_TITLE_EF_CAMERAMOVE:
		{
			BOOL move_flag = TRUE;

			CAMERA_MOVE( wk->camera_tpos.x, wk->tp_ed.x, wk->c_speed, move_flag )
			CAMERA_MOVE( wk->camera_tpos.y, wk->tp_ed.y, wk->c_speed, move_flag )
			CAMERA_MOVE( wk->camera_tpos.z, wk->tp_ed.z, wk->c_speed, move_flag )

			CAMERA_MOVE( wk->camera_cpos.x, wk->cp_ed.x, wk->c_speed, move_flag )
			CAMERA_MOVE( wk->camera_cpos.y, wk->cp_ed.y, wk->c_speed, move_flag )
			CAMERA_MOVE( wk->camera_cpos.z, wk->cp_ed.z, wk->c_speed, move_flag )

			//J̈ʒuƏœ_ݒ
			GFC_SetLookTarget( &wk->camera_tpos, wk->poke.camera_p );
			GFC_SetCameraPos( &wk->camera_cpos, wk->poke.camera_p );

			if( move_flag == TRUE ){
				TITLE_LOGO_FRAME_ON
				TITLE_LOGO2_FRAME_OFF
				TITLE_CPRIGHT_FRAME_ON
				SUBFRAME_ON(GX_PLANEMASK_BG3)
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł "Demo Version" \̂߂ɃTuOBJgp
#ifdef PG5_TRIAL
				SUBFRAME_ON(GX_PLANEMASK_OBJ);
#endif
// ----------------------------------------------------------------------------
				wk->wait_counter = 90;
				wk->poke.anm_flag = DRAW3DANM_STOP;
				wk->seq = TDSEQ_TITLE_EF_CAMERAMOVE_END;
			}
		}
		break;

	case TDSEQ_TITLE_EF_CAMERAMOVE_END:
		if(wk->wait_counter){
			wk->wait_counter--;
		} else {
			result = TRUE;
		}
		break;
	}
	TitleDemoLight1Effect( wk );
	Title3D_Draw(&wk->poke);

	return result;
}

//----------------------------------
// C
//----------------------------------
enum{
	TDSEQ_TITLE_MAIN_DISPON = 0,		//`Jn
	TDSEQ_TITLE_MAIN_CONT,				//Co
};

static BOOL TitleDemo_Main( TITLE_TITLEDEMO_WORK* wk, GF_BGL_INI* bgl,int heapID )
{
	BOOL result = FALSE;

	switch(wk->seq){

	case TDSEQ_TITLE_MAIN_DISPON:
		//ׂĂ̕`nm(XLbv邱Ƃl)
		GFC_SetLookTarget( &wk->tp_ed, wk->poke.camera_p );
		GFC_SetCameraPos( &wk->cp_ed, wk->poke.camera_p );

		MAINFRAME_ON(GX_PLANEMASK_BG0)	//Rcʂnm
		MAINFRAME_ON(GX_PLANEMASK_BG3)	//MainDispwinm
		SUBFRAME_ON(GX_PLANEMASK_BG3)	//SubDispwinm

		TITLE_LOGO_FRAME_ON
		TITLE_LOGO2_FRAME_OFF
		TITLE_CPRIGHT_FRAME_ON

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł "Demo Version" \̂߂ɃTuOBJgp
#ifdef PG5_TRIAL
		SUBFRAME_ON(GX_PLANEMASK_OBJ);
#endif
// ----------------------------------------------------------------------------

		WIPE_ResetBrightness( WIPE_DISP_MAIN );
		WIPE_ResetBrightness( WIPE_DISP_SUB );
		SetBrightness(  BRIGHTNESS_NORMAL, 
						(GX_BLEND_PLANEMASK_BG1|GX_BLEND_PLANEMASK_BG2),
						MASK_MAIN_DISPLAY );
		SetBrightness(  BRIGHTNESS_NORMAL, 
						(GX_BLEND_PLANEMASK_BG0|GX_BLEND_PLANEMASK_BG1|GX_BLEND_PLANEMASK_BG2),
						MASK_SUB_DISPLAY );
		wk->poke.anm_flag = DRAW3DANM_ENABLE;
		NNS_G3dGlbLightColor(1, 0x7fff);

		wk->wait_counter = 0;
		wk->seq = TDSEQ_TITLE_MAIN_CONT;
		break;

	case TDSEQ_TITLE_MAIN_CONT:
		if( wk->enable_flag == TRUE ){
			if(wk->wait_counter == 0 ){
				TITLE_PRSSTART_FRAME_ON
			}else if(wk->wait_counter == 0x10 ){
				TITLE_PRSSTART_FRAME_OFF
			}
		} else {
			TITLE_PRSSTART_FRAME_OFF
		}
		wk->wait_counter++;
		wk->wait_counter&=0x1f;
	
		result = TRUE;
		break;
	}
	Title3D_Draw(&wk->poke);

	return result;
}

//----------------------------------
// I
//----------------------------------
static BOOL TitleDemo_Exit( TITLE_TITLEDEMO_WORK* wk, GF_BGL_INI* bgl,int heapID )
{
	GFC_FreeCamera(wk->poke.camera_p);				//JJ
	Title3D_ModelRelease( &wk->poke );
	Title2DGraphicRelease(bgl,heapID,wk);
	G2_BlendNone();
	G3X_EdgeMarking(FALSE);

	//Rc`XCb`A
	sys.disp3DSW = DISP_3D_TO_MAIN;
	GF_Disp_DispSelect();

	return TRUE;
}

//----------------------------------
// Qcafǂݍ
//----------------------------------
static void Title2DGraphicSet(GF_BGL_INI* ini,int heapID, TITLE_TITLEDEMO_WORK* wk )
{
	{	// wi
		int palIDm,palIDs;

		ArcUtil_BgCharSet//ʃL	(]Ă̂SubDisp)
			(ARC_TITLE,NARC_titledemo_title_back_m_NCGR,ini,GF_BGL_FRAME3_S,0,0,0,heapID);
		ArcUtil_BgCharSet	//ʃL(]Ă̂MainDisp)
			(ARC_TITLE,NARC_titledemo_title_back_s_NCGR,ini,GF_BGL_FRAME3_M,0,0,0,heapID);
		ArcUtil_ScrnSet		//ʃXN[(]Ă̂SubDisp)
			(ARC_TITLE,NARC_titledemo_title_back_m_NSCR,ini,GF_BGL_FRAME3_S,0,0,0,heapID);
		ArcUtil_ScrnSet		//ʃXN[(]Ă̂MainDisp)
			(ARC_TITLE,NARC_titledemo_title_back_s_NSCR,ini,GF_BGL_FRAME3_M,0,0,0,heapID);

		if( CasetteVersion == VERSION_DIAMOND ){
			palIDm = NARC_titledemo_title_back_m_d_NCLR;
			palIDs = NARC_titledemo_title_back_s_d_NCLR;
		} else {
			palIDm = NARC_titledemo_title_back_m_p_NCLR;
			palIDs = NARC_titledemo_title_back_s_p_NCLR;
		}
		ArcUtil_PalSet(ARC_TITLE,palIDm,PALTYPE_SUB_BG,0,0,heapID);		//ʃpbg
		ArcUtil_PalSet(ARC_TITLE,palIDs,PALTYPE_MAIN_BG,0,0,heapID);	//ʃpbg
	}
	{	// S
		int cgxID,palID;

		if( CasetteVersion == VERSION_DIAMOND ){
			cgxID = NARC_titledemo_logo_d_NCGR;
			palID = NARC_titledemo_logo_d_NCLR;
		} else {
			cgxID = NARC_titledemo_logo_p_NCGR;
			palID = NARC_titledemo_logo_p_NCLR;
		}
		ArcUtil_BgCharSet(ARC_TITLE,cgxID,ini,TITLE_LOGO_FRAME,0,0,0,heapID);	//L
		ArcUtil_PalSet(ARC_TITLE,palID,TITLE_LOGO_PALTYPE,EX_PAL_SLOT2_ADRS,0,heapID);
		ArcUtil_ScrnSet		//XN[
			(ARC_TITLE,NARC_titledemo_logo_NSCR,ini,TITLE_LOGO_FRAME,0,0,0,heapID);
	}
	{	// SQimg[j
		ArcUtil_BgCharSet(	ARC_OP_DEMO,NARC_op_demo_g_logo2_NCGR,
							ini,TITLE_LOGO2_FRAME,0,0,0,heapID);	//L
		ArcUtil_PalSet(		ARC_OP_DEMO,NARC_op_demo_g_logo2_NCLR,
							TITLE_LOGO_PALTYPE,EX_PAL_SLOT1_ADRS,0,heapID);
		ArcUtil_ScrnSet		//XN[
			(ARC_OP_DEMO,NARC_op_demo_g_logo_NSCR,ini,TITLE_LOGO2_FRAME,0,0,0,heapID);
	}
	{	// copyright
		ArcUtil_BgCharSet	//L
			(ARC_TITLE,NARC_titledemo_title_cpright_NCGR,ini,TITLE_CPRIGHT_FRAME,0,0,0,heapID);
		ArcUtil_ScrnSet		//XN[
			(ARC_TITLE,NARC_titledemo_title_cpright_NSCR,ini,TITLE_CPRIGHT_FRAME,0,0,0,heapID);
		ArcUtil_PalSet		//pbg(KChEChEp)
			(ARC_TITLE,NARC_titledemo_title_cpright_NCLR,TITLE_GF_PALTYPE,32*1,32*3,heapID);
	}
	GF_BGL_BackGroundColorSet(GF_BGL_FRAME0_M,0x0000);
	GF_BGL_BackGroundColorSet(GF_BGL_FRAME0_S,0x0000);

	{	// KChbZ[W
		MSGDATA_MANAGER*	msg_man;
		STRBUF*				title_str;
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/11/14
		// uotrg@rs`qs@atssnmvŃZ^Oĕ\
		u32 x;
		// ----------------------------------------------------------------------------

		GF_BGL_ClearCharSet( TITLE_PRSSTART_FRAME, 32, 0, heapID );

		msg_man = MSGMAN_Create(MSGMAN_TYPE_DIRECT,ARC_MSG,NARC_msg_title_dat,heapID );
		title_str = STRBUF_Create(64, heapID);

		//bZ[WEChErbg}bv쐬
		GF_BGL_BmpWinAddEx(ini,&wk->msgwin,&TitleMsgWinData );
		//bZ[WEChẼNA bmp,col,startX,startY,sizeX,sizeY
		GF_BGL_BmpWinFill(&wk->msgwin,FBMP_COL_NULL,0,0,28*DOTSIZE,2*DOTSIZE);
		//̎擾i`{^Ăj
		MSGMAN_GetString(msg_man,title_msg_01,title_str);
		//̕\
		// ----------------------------------------------------------------------------
		// localize_spec_mark(LANG_ALL) imatake 2006/11/14
		// uotrg@rs`qs@atssnmvŃZ^Oĕ\
		x = FontProc_GetPrintCenteredPositionX( FONT_SYSTEM, title_str, 1, wk->msgwin.sizx * 8 );
		GF_STR_PrintExpand(&wk->msgwin,FONT_SYSTEM,title_str,x,0,MSG_ALLPUT,
							GF_PRINTCOLOR_MAKE(1, 1, FBMP_COL_NULL),1,0,NULL);
		// ----------------------------------------------------------------------------

		STRBUF_Delete(title_str);
		MSGMAN_Delete(msg_man);
		{
			u16 letter = 0x0015;
			u16 shadow = 0x0015;

			GF_BGL_PaletteSet(TITLE_PRSSTART_FRAME,&letter,PAL1DATA,PAL1SIZE*2 + PAL1DATA*1);
			GF_BGL_PaletteSet(TITLE_PRSSTART_FRAME,&shadow,PAL1DATA,PAL1SIZE*2 + PAL1DATA*2);
		}
	}

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł̓^CgS̏ "Demo Version" \

#ifdef PG5_TRIAL
	{
		// "Demo Version" ̕\
		GXOamAttr oamAttr[4];

		ArcUtil_ObjCharSet(ARC_TRIAL, NARC_trial_demo_version_NCGR, OBJTYPE_SUB, 0, 0, 0, heapID);
		ArcUtil_PalSet(ARC_TRIAL, NARC_trial_demo_version_NCLR, PALTYPE_SUB_OBJ, 0, 0, heapID);

		G2_SetOBJAttr(&oamAttr[0],  64, 8, 0, GX_OAM_MODE_NORMAL, FALSE, GX_OAM_EFFECT_NONE, GX_OAM_SHAPE_32x16, GX_OAM_COLORMODE_16,  0, 0, 0);
		G2_SetOBJAttr(&oamAttr[1],  96, 8, 0, GX_OAM_MODE_NORMAL, FALSE, GX_OAM_EFFECT_NONE, GX_OAM_SHAPE_32x16, GX_OAM_COLORMODE_16,  8, 0, 0);
		G2_SetOBJAttr(&oamAttr[2], 128, 8, 0, GX_OAM_MODE_NORMAL, FALSE, GX_OAM_EFFECT_NONE, GX_OAM_SHAPE_32x16, GX_OAM_COLORMODE_16, 16, 0, 0);
		G2_SetOBJAttr(&oamAttr[3], 160, 8, 0, GX_OAM_MODE_NORMAL, FALSE, GX_OAM_EFFECT_NONE, GX_OAM_SHAPE_32x16, GX_OAM_COLORMODE_16, 24, 0, 0);
		GXS_LoadOAM(oamAttr, 0, sizeof(GXOamAttr)*4);

		OS_TPrintf("hoge.\n");
	}
#endif

// ----------------------------------------------------------------------------
}

static void Title2DGraphicSetEffect(GF_BGL_INI* ini,int heapID, TITLE_TITLEDEMO_WORK* wk )
{
	int cgxID,palID,scrID;

	if( wk->wait_counter == 0 ){
		if( CasetteVersion == VERSION_DIAMOND ){
			cgxID = NARC_op_demo_d_logo01_NCGR;
			palID = NARC_op_demo_d_logo01_NCLR;
			scrID = NARC_op_demo_d_logo01_NSCR;
		} else {
			cgxID = NARC_op_demo_P_logo01_NCGR;
			palID = NARC_op_demo_P_logo01_NCLR;
			scrID = NARC_op_demo_p_logo01_NSCR;
		}
		ArcUtil_BgCharSet( ARC_OP_DEMO, cgxID, ini, TITLE_LOGO2_FRAME, 0, 0, 0, heapID );
		ArcUtil_PalSet(	ARC_OP_DEMO, palID, TITLE_LOGO_PALTYPE, EX_PAL_SLOT1_ADRS, 0, heapID );
		ArcUtil_ScrnSet( ARC_OP_DEMO, scrID, ini, TITLE_LOGO2_FRAME, 0, 0, 0, heapID );
	}
}

static void Title2DGraphicRelease(GF_BGL_INI* ini,int heapID, TITLE_TITLEDEMO_WORK* wk )
{
	GF_BGL_BmpWinDel(&wk->msgwin);
}

//----------------------------------
// CgGtFNg
//----------------------------------
#define LIGHT1_EF_SPEED (2)

static void TitleDemoLight1Effect( TITLE_TITLEDEMO_WORK* wk )
{
	switch( wk->l1efseq ){

	case TDSEQ_LIGHT1_INIT:
		wk->l1ef = 5;
		wk->l1efseq = TDSEQ_LIGHT1_WAIT;
		break;

	case TDSEQ_LIGHT1_WAIT:
		break;

	case TDSEQ_LIGHT1_UP:
		wk->l1ef += LIGHT1_EF_SPEED;
		if( wk->l1ef >= 0x1f ){
			wk->l1ef = 0x1f;
			wk->l1efseq = TDSEQ_LIGHT1_WAIT;
		}
		break;

	case TDSEQ_LIGHT1_DOWN:
		wk->l1ef -= LIGHT1_EF_SPEED;
		if( wk->l1ef <= 5 ){
			wk->l1ef = 5;
			wk->l1efseq = TDSEQ_LIGHT1_WAIT;
		}
		break;
	}
	NNS_G3dGlbLightColor( 1, 
		(((wk->l1ef<<0)&0x001f)|((wk->l1ef<<5)&0x03e0)|((wk->l1ef<<10)&0x7c00)) );
}

//----------------------------------
// o[Wf[^擾
//----------------------------------
//eݒliNitroViewer@Ŏ擾j

//_Ch
#define TD_TITLED_CMR_CPX_ST			(FX32_ONE * 0)
#define TD_TITLED_CMR_CPY_ST			(FX32_ONE * 65)//66)
#define TD_TITLED_CMR_CPZ_ST			(FX32_ONE * 72)//76)
#define TD_TITLED_CMR_TPX_ST			(FX32_ONE * 0)
#define TD_TITLED_CMR_TPY_ST			(FX32_ONE * 90)//128)
#define TD_TITLED_CMR_TPZ_ST			(FX32_ONE * 0)//-88)
	
#define TD_TITLED_CMR_CPX_ED			(FX32_ONE * 195)//332)
#define TD_TITLED_CMR_CPY_ED			(FX32_ONE * 32)//12)
#define TD_TITLED_CMR_CPZ_ED			(FX32_ONE * 246)//163)
#define TD_TITLED_CMR_TPX_ED			(FX32_ONE * -2)//-34)
#define TD_TITLED_CMR_TPY_ED			(FX32_ONE * 124)//122)
#define TD_TITLED_CMR_TPZ_ED			(FX32_ONE * -38)//-75)

#define TD_TITLED_L0_XV					(-2333)//(-1024)
#define TD_TITLED_L0_YV					(2603)//(0)
#define TD_TITLED_L0_ZV					(-2135)//(-4095)
#define TD_TITLED_L1_XV					(-2267)//(-1802)
#define TD_TITLED_L1_YV					(1953)//(2755)
#define TD_TITLED_L1_ZV					(-2797)//(-2438)

#define TD_TITLED_CMR_SPD				(FX32_ONE * 3)

#define TD_TITLED_ECOL_R				(1)
#define TD_TITLED_ECOL_G				(7)
#define TD_TITLED_ECOL_B				(9)

//p[
#define TD_TITLEP_CMR_CPX_ST			(FX32_ONE * -65)
#define TD_TITLEP_CMR_CPY_ST			(FX32_ONE * 41)
#define TD_TITLEP_CMR_CPZ_ST			(FX32_ONE * 19)
#define TD_TITLEP_CMR_TPX_ST			(FX32_ONE * 0)
#define TD_TITLEP_CMR_TPY_ST			(FX32_ONE * 11)
#define TD_TITLEP_CMR_TPZ_ST			(FX32_ONE * 18)
	
#define TD_TITLEP_CMR_CPX_ED			(FX32_ONE * -148)//-168)
#define TD_TITLEP_CMR_CPY_ED			(FX32_ONE * 58)//77)
#define TD_TITLEP_CMR_CPZ_ED			(FX32_ONE * 190)//178)
#define TD_TITLEP_CMR_TPX_ED			(FX32_ONE * 8)//0)
#define TD_TITLEP_CMR_TPY_ED			(FX32_ONE * -5)//-11)
#define TD_TITLEP_CMR_TPZ_ED			(FX32_ONE * 1)//16)

#define TD_TITLEP_L0_XV					(1619)//(4095)
#define TD_TITLEP_L0_YV					(-2276)//(-4095)
#define TD_TITLEP_L0_ZV					(-2296)//(1021)
#define TD_TITLEP_L1_XV					(2331)
#define TD_TITLEP_L1_YV					(-1183)
#define TD_TITLEP_L1_ZV					(3152)

#define TD_TITLEP_CMR_SPD				(FX32_ONE * 3)

#define TD_TITLEP_ECOL_R				(15)
#define TD_TITLEP_ECOL_G				(9)
#define TD_TITLEP_ECOL_B				(15)

static void TitleDemoDataGet( TITLE_TITLEDEMO_WORK* wk )
{
	if( CasetteVersion == VERSION_DIAMOND ){

		VEC_SET( wk->cp_st, TD_TITLED_CMR_CPX_ST, TD_TITLED_CMR_CPY_ST, TD_TITLED_CMR_CPZ_ST )
		VEC_SET( wk->cp_ed, TD_TITLED_CMR_CPX_ED, TD_TITLED_CMR_CPY_ED, TD_TITLED_CMR_CPZ_ED )

		VEC_SET( wk->tp_st, TD_TITLED_CMR_TPX_ST, TD_TITLED_CMR_TPY_ST, TD_TITLED_CMR_TPZ_ST )
		VEC_SET( wk->tp_ed, TD_TITLED_CMR_TPX_ED, TD_TITLED_CMR_TPY_ED, TD_TITLED_CMR_TPZ_ED )

		VEC_SET( wk->lv0, TD_TITLED_L0_XV, TD_TITLED_L0_YV, TD_TITLED_L0_ZV )
		VEC_SET( wk->lv1, TD_TITLED_L1_XV, TD_TITLED_L1_YV, TD_TITLED_L1_ZV )

		wk->c_speed = TD_TITLED_CMR_SPD;

	} else {

		VEC_SET( wk->cp_st, TD_TITLEP_CMR_CPX_ST, TD_TITLEP_CMR_CPY_ST, TD_TITLEP_CMR_CPZ_ST )
		VEC_SET( wk->cp_ed, TD_TITLEP_CMR_CPX_ED, TD_TITLEP_CMR_CPY_ED, TD_TITLEP_CMR_CPZ_ED )

		VEC_SET( wk->tp_st, TD_TITLEP_CMR_TPX_ST, TD_TITLEP_CMR_TPY_ST, TD_TITLEP_CMR_TPZ_ST )
		VEC_SET( wk->tp_ed, TD_TITLEP_CMR_TPX_ED, TD_TITLEP_CMR_TPY_ED, TD_TITLEP_CMR_TPZ_ED )

		VEC_SET( wk->lv0, TD_TITLEP_L0_XV, TD_TITLEP_L0_YV, TD_TITLEP_L0_ZV )
		VEC_SET( wk->lv1, TD_TITLEP_L1_XV, TD_TITLEP_L1_YV, TD_TITLEP_L1_ZV )

		wk->c_speed = TD_TITLEP_CMR_SPD;
	}
	{
		VecFx32 light0vec_tmp, light0vec;

		VEC_Subtract( &wk->tp_ed, &wk->cp_ed, &light0vec_tmp );
		VEC_Normalize( &light0vec_tmp, &light0vec );
		wk->lv0.x = light0vec.x;
		wk->lv0.y = light0vec.y;
		wk->lv0.z = light0vec.z;
	}
}




#ifdef PM_DEBUG
extern void SaveErrorWarningCall( int heapID, int msgID );
//----------------------------------
// fobOp
//----------------------------------
static void DebugControl( TITLE_TITLEDEMO_WORK* wk )
{
#if 0
	if( sys.trg & PAD_BUTTON_Y ){
		SaveErrorWarningCall(0,0);
	}
#endif
}
#endif


// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌ŗp̊֐`

#ifdef PG5_TRIAL

//----------------------------------
// xʓǂݍ
//----------------------------------
static void WarningGraphicSet(GF_BGL_INI* ini,int heapID, TITLE_TITLEDEMO_WORK* wk)
{
	{	// wi
		ArcUtil_BgCharSet	//ʃL(]Ă̂MainDisp)
			(ARC_TRIAL,NARC_trial_seizures_warning_NCGR,ini,GF_BGL_FRAME1_M,0,0,0,heapID);
		ArcUtil_ScrnSet		//ʃXN[(]Ă̂MainDisp)
			(ARC_TRIAL,NARC_trial_seizures_warning_NSCR,ini,GF_BGL_FRAME1_M,0,0,0,heapID);

		ArcUtil_PalSet(ARC_TRIAL,NARC_trial_seizures_warning_NCLR,PALTYPE_MAIN_BG,0,0,heapID);	//ʃpbg
	}
}

//----------------------------------
// [eBOʓǂݍ
//----------------------------------
static void EsrbGraphicSet(GF_BGL_INI* ini, int heapID, TITLE_TITLEDEMO_WORK* wk)
{
	{	// wi
		ArcUtil_BgCharSet	//ʃL(]Ă̂MainDisp)
			(ARC_TRIAL,NARC_trial_esrb_e_NCGR,ini,GF_BGL_FRAME1_M,0,0,0,heapID);
		ArcUtil_ScrnSet		//ʃXN[(]Ă̂MainDisp)
			(ARC_TRIAL,NARC_trial_esrb_e_NSCR,ini,GF_BGL_FRAME1_M,0,0,0,heapID);

		ArcUtil_PalSet(ARC_TRIAL,NARC_trial_esrb_e_NCLR,PALTYPE_MAIN_BG,0,0,heapID);	//ʃpbg
	}
}

static int Debug_MakeMyStatus(MYSTATUS * my)
{
	STRCODE namebuf[PERSON_NAME_SIZE + EOM_SIZE + 8];
	MSGDATA_MANAGER * msgman;
	int name_id, gender;
	u32 ID = gf_mtRand() & 0xffff;
	int i;

	name_id = (CasetteVersion == VERSION_DIAMOND) ? msg_opening_name_01 : msg_opening_name_42;
	gender  = (ID & 1) ? PM_MALE : PM_FEMALE;

	msgman = MSGMAN_Create(	MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_opening_name_dat, HEAPID_BASE_DEBUG);
	MSGMAN_GetStr(msgman, name_id, namebuf);
	MSGMAN_Delete( msgman);

	MyStatus_SetMyName(my, namebuf);
	MyStatus_SetMySex(my, gender);
	MyStatus_SetID(my, ID );
	MyStatus_SetGold(my, 123456);

	// jI[ł̌ڂID琶
//	MyStatus_SetTrainerView(my, UnionView_GetTrainerType( MyStatus_GetID(my), 0, 0 ));	

	return name_id;
}

enum {
	TRIAL_START_ZONE = ZONE_ID_C01,
	TRIAL_START_X    = 177,
	TRIAL_START_Z    = 770,
};

static void SamplePlay_MakeStartData( SAVEDATA* savedata )
{
	MYSTATUS* my;

	SaveData_ClearData( savedata );

	//KɎԃf[^
	my = SaveData_GetMyStatus( savedata );
	Debug_MakeMyStatus( my );

	//X^[gʒuݒ
	{
		SITUATION*		sit = SaveData_GetSituation( savedata );
		LOCATION_WORK*	location =Situation_GetNowLocation(sit); 
		static const LOCATION_WORK StartLocation = {	TRIAL_START_ZONE, DOOR_ID_JUMP_CODE,
														TRIAL_START_X, TRIAL_START_Z, DIR_LEFT };
		PLAYER_SAVE_DATA* jikisave = Situation_GetPlayerSaveData(sit);

		*location = StartLocation;
		Player_SaveDataDashSet( jikisave, TRUE );
	}

	//VXetOZbg
	SysFlag_BagSet( SaveData_GetEventWork(savedata) );	//j[uobOv
	SysWork_FirstPokeNoSet(	SaveData_GetEventWork(savedata),
							MONSNO_HUSIGIDANE );		//j[u|Pv

	//莝|P𐶐i}ӃtÓA}ӂgpłȂ̂ŃZbgȂj
	SamplePlay_MakePokeData( savedata );
}


//=================================================================================================
/**
 * @brief	VŗpF|Pݒ
 */
//=================================================================================================
#define POKEADD( pos, num, lv, waza1, waza2, waza3, waza4, tokusei ){				\
	EvPoke_Add(HEAPID_BASE_DEBUG, savedata, num, lv, 0, place_id, GROUND_ID_FLOOR);	\
	EvPoke_ChangeWaza(temoti, pos, 0, waza1);										\
	EvPoke_ChangeWaza(temoti, pos, 1, waza2);										\
	EvPoke_ChangeWaza(temoti, pos, 2, waza3);										\
	EvPoke_ChangeWaza(temoti, pos, 3, waza4);										\
	poke = PokeParty_GetMemberPointer(temoti, pos);									\
	SPabi = tokusei;																\
	PokeParaPut( poke, ID_PARA_speabino, &SPabi );									\
}

// 
// |Pio[AZbgʁAZbgi
// 𓱂܂
// u32	PokeParaSexChrRndGet(u16 mons_no,u8 sex,u8 chr)

static void SamplePlay_MakePokeData( SAVEDATA* savedata )
{
	POKEPARTY* temoti;
	POKEMON_PARAM* poke;
	LOCATION_WORK  *loc = Situation_GetNowLocation(SaveData_GetSituation(savedata));
	int place_id = ZoneData_GetPlaceNameID(loc->zone_id);
	int	SPabi;

	temoti = SaveData_GetTemotiPokemon(savedata);
	PokeParty_Init( temoti, TEMOTI_POKEMAX );

	//JI(Œ)
	POKEADD(0, MONSNO_RUKARIO, 30, 
			WAZANO_HAKKEI, WAZANO_SAKIDORI, WAZANO_BOONRASSYU, WAZANO_KINZOKUON, 
			TOKUSYU_HUKUTUNOKOKORO )

	//[A(Œ)
	POKEADD(1, MONSNO_ROZERIA, 30, 
			WAZANO_YADORIGINOTANE, WAZANO_MAZIKARURIIHU, WAZANO_KUSABUE, WAZANO_DOKUBARI,
			TOKUSYU_SIZENKAIHUKU )

/*	switch( wk->version ){
	case VERSION_SAMPLE_SUICA:
		switch( wk->pokeTblpattern ){
		case SELECT_PATTERN_A:
			//uC[
			POKEADD(2, MONSNO_BUIZERU, 31, 
					WAZANO_OIUTI, WAZANO_SUPIIDOSUTAA, WAZANO_AKUAJETTO, WAZANO_KOUSOKUIDOU,
					TOKUSYU_SUISUI )
			break;
		case SELECT_PATTERN_B:
			//^}^
			POKEADD(2, MONSNO_TAMANTA, 30, 
					WAZANO_ZUTUKI, WAZANO_KOUSOKUIDOU, WAZANO_TUBASADEUTU, WAZANO_MIZUNOHADOU,
					TOKUSYU_TYOSUI )
			break;
		case SELECT_PATTERN_C:
			//ybv
			POKEADD(2, MONSNO_PERAPPU, 31, 
					WAZANO_UTAU, WAZANO_MIDAREDUKI, WAZANO_TYOUHATU, WAZANO_MONOMANE,
					TOKUSYU_TIDORIASI )
			break;
		case SELECT_PATTERN_D:
			//`FbV
			POKEADD(2, MONSNO_THERISYU, 30, 
					WAZANO_YADORIGINOTANE, WAZANO_MAZIKARURIIHU, 
					WAZANO_NIHONBARE, WAZANO_HANABIRANOMAI,
					TOKUSYU_HURAWAAGIHUTO )
			break;
		case SELECT_PATTERN_E:
			//p`bX
			POKEADD(2, MONSNO_PATIRISSU, 31, 
					WAZANO_AMAERU, WAZANO_SUPIIDOSUTAA, WAZANO_TENSINOKISSU, WAZANO_HOUDEN,
					TOKUSYU_NIGEASI )
			break;
		case SELECT_PATTERN_F:
			//hsI
			POKEADD(2, MONSNO_DORAPION, 40, 
					WAZANO_KAMINARINOKIBA, WAZANO_KOORINOKIBA, WAZANO_HONOONOKIBA, WAZANO_DOKUBISI,
					TOKUSYU_SUNAIPAA )
			break;
		}
		break;
	case VERSION_SAMPLE_TX:
*/		//}ll
		POKEADD(2, MONSNO_MANENE, 30, 
				WAZANO_BARIAA, WAZANO_MANEKKO, WAZANO_MONOMANE, WAZANO_SAIKEKOUSEN,
				TOKUSYU_FIRUTAA )
/*		break;
	case VERSION_SAMPLE_NCL:
		//E\n`
		POKEADD(2, MONSNO_USOHATI, 30, 
				WAZANO_MANEKKO, WAZANO_IWAOTOSI, WAZANO_ZITABATA, WAZANO_DAMASIUTI,
				TOKUSYU_GANZYOU )
		break;
	}
*/
}

#endif

// ----------------------------------------------------------------------------
