//============================================================================================
/**
 * @file	agb_slot_enc.c
 * @brief	`faXbgo[WʃGJEg֘A
 * @author	saitou
 *
 */
//============================================================================================

#include "common.h"
#include "encount_dat.h"

#include "agb_slot_enc.h"

//-----------------------------------------------------------------------------
/**
 * AGBXbgGJEge[uւ
 *
 * @param	*inEncData			GJEgf[^
 * @param	inBookGet			S}ӓtO
 * @param	*outAgbEncMonsNo1	GJEg|P1̖
 * @param	*outAgbEncMonsNo2	GJEg|P2̖
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
void AgbSlotEnc_SetAgbSlotEnc(	const ENCOUNT_DATA *inEncData,
								const BOOL inBookGet,
								int *outAgbEncMonsNo1, int *outAgbEncMonsNo2)
{
	//S}ӓ肵ĂȂ΁AȂ
	if (!inBookGet){
		return;
	}
	
	//AGBXbg̃o[WʂɃGJEgf[^Zbg
	switch(sys.AgbCasetteVersion){		
	case VERSION_SAPPHIRE:
		(*outAgbEncMonsNo1) = inEncData->SapphireEnc[0];
		(*outAgbEncMonsNo2) = inEncData->SapphireEnc[1];
		break;
	case VERSION_RUBY:
		(*outAgbEncMonsNo1) = inEncData->RubyEnc[0];
		(*outAgbEncMonsNo2) = inEncData->RubyEnc[1];
		break;
	case VERSION_EMERALD:
		(*outAgbEncMonsNo1) = inEncData->EmeraldEnc[0];
		(*outAgbEncMonsNo2) = inEncData->EmeraldEnc[1];
		break;
	case VERSION_RED:
		(*outAgbEncMonsNo1) = inEncData->FireEnc[0];
		(*outAgbEncMonsNo2) = inEncData->FireEnc[1];
		break;
	case VERSION_GREEN:
		(*outAgbEncMonsNo1) = inEncData->LeafEnc[0];
		(*outAgbEncMonsNo2) = inEncData->LeafEnc[1];
		break;
	}
}
