/**
 *	@file	btower_scr.c
 *	@brief	og^[@XNvgR}hn
 *	@author	Miyuki Iwasawa
 *	@date	06.04.17
 */

#include "common.h"
#include "savedata/savedata_def.h"
#include "savedata/record.h"
#include "savedata/fnote_mem.h"
#include "system/buflen.h"
#include "savedata/tv_work.h"
#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"
#include "system/procsys.h"
#include "system/gamedata.h"
#include "application/pokelist.h"
#include "fieldsys.h"
#include "sysflag.h"
#include "field/situation.h"
#include "field/situation_local.h"
#include "field/tv_topic.h"
#include "field/tvtopic_extern.h"
#include "ev_mapchange.h"
#include "fielddata/base_goods/goods_id_def.h"
#include "savedata/undergrounddata.h"
#include "savedata/b_tower.h"
#define __B_TOWER_SCR_H_GLOBAL
#include "field/b_tower_scr.h"
#include "field/b_tower_ev.h"
#include "b_tower_fld.h"
#include "field/field_encount.h"

//#include "field/b_tower_deb.h"

///Tu֐vg^Cv
static u16 towerscr_PokeRibbonSet(SAVEDATA* sv,u8 ribbon,BTOWER_SCRWORK* wk);
static u16 towerscr_IfRenshouPrizeGet(BTOWER_SCRWORK* wk);
static void towerscr_SaveMemberPokeData(BTOWER_SCRWORK* wk,SAVEDATA* sv,BTWR_SCORE_POKE_DATA mode);


/**
 *	@brief	vC[hʂ̃o[擾
 *
 *	@param	mode	BTWR_MODE_`
 */
u16	TowerScrTools_GetMemberNum(u16 mode)
{
	switch(mode){
	case BTWR_MODE_SINGLE:
	case BTWR_MODE_WIFI:
	case BTWR_MODE_RETRY:
		return 3;
	case BTWR_MODE_DOUBLE:
		return 4;
	case BTWR_MODE_MULTI:
	case BTWR_MODE_COMM_MULTI:
		return 2;
	}
	return 0;
}

typedef struct POKE_CHK{
	u16	monsno;
	u16	itemno;
}POKE_CHK;

//ރ|P|P`FbN
static BOOL pokechk_CheckSamePoke(POKE_CHK* plist,u16 monsno,u16 itemno,int num)
{
	int i;

	for(i = 0;i < num;i++){
		if(plist[i].monsno == monsno){
			if(itemno == 0){
				continue;
			}
			if(plist[i].itemno == itemno){
				return TRUE;
			}
		}
	}
	return FALSE;
}

//̑gݍ킹Œ\ǂH
static BOOL pokechk_IsEntryPattern(POKE_CHK* plist,int num)
{
	int i,j;

	for(i = 0;i < num-1;i++){
		for(j = i+1;j < num;j++){
			if(plist[i].monsno == plist[j].monsno){
				return FALSE;
			}
			if(plist[i].itemno == 0){
				continue;
			}
			if(plist[i].itemno == plist[j].itemno){
				return FALSE;
			}
		}
	}
	return TRUE;
}

//Q`FbNgݍ킹
static BOOL pokechk_CheckPattern(POKE_CHK* ps,int num,int pokenum,int max)
{
	int i,j,k,l;
	POKE_CHK	pd[4];

	MI_CpuClear8(pd,sizeof(POKE_CHK)*4);
	
	//c|P̒ő
	for(i = 0;i < max;i++){	//̖
		pd[0] = ps[i];
		for(j = i+1;j < pokenum;j++){	//̖
			pd[1] = ps[j];
			if(num == 2){
				if(pokechk_IsEntryPattern(pd,num)){
					return TRUE;
				}
				continue;
			}
			for(k = j+1;k < pokenum;k++){	//R̖
				pd[2] = ps[k];
				if(num == 3){
					if(pokechk_IsEntryPattern(pd,num)){
						return TRUE;
					}
					continue;
				}
				for(l = k+1;l < pokenum;l++){	//S̖
					pd[3] = ps[l];
					if(pokechk_IsEntryPattern(pd,num)){
						return TRUE;
					}
				}
			}
		}
	}
	return FALSE;
}

/**
 *	@brief	og^[@Q\ȃ|P̃`FbN
 *
 *	@param	num		QɕKvȃ|P
 *
 *	@retval	true	Q\
 *	@retval	false	Qs
 */
BOOL TowerScrTools_CheckEntryPokeNum(u16 num,SAVEDATA *savedata)
{
	u8	i,j,ct,pokenum;
	u16	monsno,itemno;
	POKEPARTY	*party;
	POKEMON_PARAM* pp;
	POKE_CHK	ps[6];
	
	party = SaveData_GetTemotiPokemon(savedata);
	pokenum = PokeParty_GetPokeCount(party);

	if(pokenum < num){
		return FALSE;
	}

	for(i = 0,ct = 0;i < pokenum;i++){
		pp = PokeParty_GetMemberPointer(party,i);
		monsno = PokeParaGet(pp,ID_PARA_monsno,NULL);
		itemno = PokeParaGet(pp,ID_PARA_item,NULL);
		
		//^}SłȂ`FbN
		if(PokeParaGet(pp,ID_PARA_tamago_flag,NULL) != 0){
			continue;
		}
		if(BattleTowerExPokeCheck_MonsNo(monsno) == TRUE){
			continue;
		}
		if(pokechk_CheckSamePoke(ps,monsno,itemno,ct) == TRUE){
			//ɑI΂Ă|PƓ
			continue;
		}
		ps[ct].monsno = monsno;
		ps[ct].itemno = itemno;
		ct++;
	}
	if(ct < num){
		return FALSE;
	}
	return pokechk_CheckPattern(ps,num,ct,(ct-num)+1);
}

/**
 *	@brief	Zbgă^Cgɖ߂
 */
void TowerScrTools_SystemReset(void)
{
	OS_ResetSystem(0);
}

/**
 *	@brief	new gameɃvCf[^NA
 */
void TowerScrTools_ClearPlaySaveData(BTLTOWER_PLAYWORK* playSave)
{
	TowerPlayData_Clear(playSave);
}

/**
 * @brief	Z[uf[^LǂԂ
 */
BOOL TowerScrTools_IsSaveDataEnable(BTLTOWER_PLAYWORK* playSave)
{
	return TowerPlayData_GetSaveFlag(playSave);
}

/**
 *	@brief	EopɌ݂̃P[VL
 */
void TowerScrTools_PushNowLocation(FIELDSYS_WORK* fsys)
{
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));

	//݈ʒuڑɐݒ
	SetLocation(sp, fsys->location->zone_id, DOOR_ID_JUMP_CODE,
			Player_NowGPosXGet(fsys->player), Player_NowGPosZGet(fsys->player), DIR_UP);

	//ڑtOON
	SysFlag_CommCounterSet(SaveData_GetEventWork(fsys->savedata));
	
}

/**
 *	@brief	Q[go鎞ɓڑɖ߂
 */
void TowerScrTools_PopNowLocation(FIELDSYS_WORK* fsys)
{
	//ڑtOOff
	SysFlag_CommCounterReset(SaveData_GetEventWork(fsys->savedata));
}

/**
 *	@brief	Q[g̈ʒu擾
 */
void TowerScrTools_GetGateLocation(FIELDSYS_WORK* fsys,u16* x,u16* y)
{
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));

	*x = sp->grid_x;
	*y = sp->grid_z;
}

/**
 *	@brief	vC[hʃR[hZ[uf[^AԂ
 */
u16	TowerScrTools_GetRenshouRecord(SAVEDATA* sv,u16 play_mode)
{
	u16 val;
	if(play_mode == BTWR_MODE_RETRY){
		return 0;
	}
	val = RECORD_Get(SaveData_GetRecord(sv),
			RECID_RENSHOU_SINGLE_CNT+play_mode*2);

	return val;
}

/**
 *	@brief	XRAf[^̃tOԂ
 */
u16 TowerScrTools_GetScoreFlags(SAVEDATA* sv,BTWR_SFLAG_ID flagid)
{
	BTLTOWER_SCOREWORK	*score = SaveData_GetTowerScoreData(sv);

	return (u16)TowerScoreData_SetFlags(score,flagid,BTWR_DATA_get);
}


/**
 *	@brief	Wifiт̖Abv[htO𐧌䂷
 */
void TowerScrTools_SetWifiUploadFlag(SAVEDATA* sv,u8 flag)
{
	BTLTOWER_SCOREWORK	*score = SaveData_GetTowerScoreData(sv);
	
	if(flag == 0){	//Zbg
		TowerScoreData_SetFlags(score,BTWR_SFLAG_WIFI_UPLOAD,BTWR_DATA_reset);
	}else{	//Zbg
		TowerScoreData_SetFlags(score,BTWR_SFLAG_WIFI_UPLOAD,BTWR_DATA_set);
	}
}

/**
 *	@brief	WiFivCт̖Abv[htO擾
 */
u16 TowerScrTools_GetWifiUploadFlag(SAVEDATA* sv)
{
	BTLTOWER_SCOREWORK	*score = SaveData_GetTowerScoreData(sv);
	return (u16)TowerScoreData_SetFlags(score,BTWR_SFLAG_WIFI_UPLOAD,BTWR_DATA_get);
}

/**
 *	@brief	Z[uɎ~߂Ƃ̃G[
 *
 *	@return	vCĂ[hԂ
 */
u16 TowerScrTools_SetNGScore(SAVEDATA* savedata)
{
	u8	play_mode;
	int id;
	BTLTOWER_PLAYWORK* playSave;
	BTLTOWER_SCOREWORK* scoreSave;
//	RECORD*  record;
	
	//Z[uf[^擾
	playSave = SaveData_GetTowerPlayData(savedata);
	scoreSave = SaveData_GetTowerScoreData(savedata);

	//ǂ̃[hvCĂH
	play_mode = (u8)TowerPlayData_Get(playSave,BTWR_PSD_playmode,NULL);
	
	if(play_mode == BTWR_MODE_RETRY){
		return play_mode;
	}
	//R[h풆tO𗎂Ƃ
	TowerScoreData_SetFlags(scoreSave,BTWR_SFLAG_SINGLE_RECORD+play_mode,BTWR_DATA_reset);
	//݂̎񐔃Zbg
	TowerScoreData_SetStage(scoreSave,play_mode,BTWR_DATA_reset);
	if(play_mode != BTWR_MODE_WIFI){
		//vC_V[hЂƂŐi߂
		BtlTower_UpdatePlayRndSeed(savedata);
	}

	OS_Printf("TowerNGScoreSet -> mode = %d\n",play_mode);
	return play_mode;	
}

/**
 *	@brief	WIFĨvC[DLf[^邩ǂ`FbN
 */
u16	TowerScrTools_IsPlayerDataEnable(SAVEDATA* sv)
{
	BTLTOWER_WIFI_DATA	*wifiSave;
	wifiSave = SaveData_GetTowerWifiData(sv);

	return (u16)TowerWifiData_IsPlayerDataEnable(wifiSave);
}

//***************************************************************
//===============================================================
//	[N̏Ɖ
//===============================================================
//***************************************************************
/**
 *	@brief	fsys̃og^[䃏[N|C^
 *			og^[JnɕKĂяo
 */
void TowerScr_WorkClear(BTOWER_SCRWORK** pp)
{
	GF_ASSERT(*pp==NULL && "btower work is reake");
	*pp = NULL;
}

/**
 *	@brief	[NGA擾ď
 *
 *	@param	savedata	Z[uf[^ւ̃|C^
 *	@param	init		[h BTWR_PLAY_NEW:߂ABTWR_PLAY_CONTINE:
 *	@param	playmode	vC[hw:BTWR_MODE_`
 *	
 *	Ȃ炸 TowerScr_WorkRelease()ŗ̈J邱
 */
BTOWER_SCRWORK* TowerScr_WorkInit(SAVEDATA* savedata,u16 init,u16 playmode)
{
	u8 buf8;
	u16	i,chg_flg;
	BTOWER_SCRWORK* wk;
	RECORD	*record;

	//[NGA擾
	HeapStatePush();

	sys_CreateHeapLo(HEAPID_BASE_APP,HEAPID_BTLTOWER_SCR,0x4000);
	wk =  sys_AllocMemory(HEAPID_BTLTOWER_SCR,sizeof(BTOWER_SCRWORK));
	MI_CpuClear8(wk,sizeof(BTOWER_SCRWORK));

	wk->heapID = HEAPID_BTLTOWER_SCR;

	//Z[uf[^擾
	wk->playSave = SaveData_GetTowerPlayData(savedata);
	wk->scoreSave = SaveData_GetTowerScoreData(savedata);

	//}WbNio[ݒ
	wk->magicNo = BTOWER_SCRWORK_MAGIC;

	//Z[utO𖳌ԂɃZbg
	TowerPlayData_SetSaveFlag(wk->playSave,FALSE);
	
	if(init == BTWR_PLAY_NEW){
		wk->play_mode = playmode;
		wk->member_num = (u8)TowerScrTools_GetMemberNum(wk->play_mode);
		wk->now_round = 1;
		wk->now_win = 0;

		for(i = 0;i < BTOWER_STOCK_MEMBER_MAX;i++){
			wk->member[i] = BTWR_NULL_POKE;
		}
		for(i = 0;i < BTOWER_STOCK_TRAINER_MAX;i++){
			wk->trainer[i] = BTWR_NULL_TRAINER;
		}
		//Z[uf[^
		TowerPlayData_Clear(wk->playSave);
		//vC[h͂̎_ŃZ[uf[^ɏo
		buf8 = wk->play_mode;
		TowerPlayData_Put(wk->playSave,BTWR_PSD_playmode,&buf8);

#ifdef BTOWER_AUTO_DEB
		if(wk->play_mode == BTWR_MODE_WIFI){
			OS_Printf(" #WifiTowerStage=%d\n",DebugBTowerAutoStage++);
		}
#endif
	}else{
		//݂̃vCisf[^擾
		wk->play_mode = (u8)TowerPlayData_Get(wk->playSave,BTWR_PSD_playmode,NULL);
		wk->now_round = (u8)TowerPlayData_Get(wk->playSave,BTWR_PSD_round,NULL);
		wk->now_win = wk->now_round-1;

		wk->member_num = (u8)TowerScrTools_GetMemberNum(wk->play_mode);

		//I΂Ă|PNo
		TowerPlayData_Get(wk->playSave,BTWR_PSD_pokeno,wk->member);

		//Iς݂̃g[i[No
		TowerPlayData_Get(wk->playSave,BTWR_PSD_trainer,wk->trainer);

		//vC_V[h擾
		wk->play_rnd_seed = TowerPlayData_Get(wk->playSave,BTWR_PSD_rnd_seed,NULL);
		OS_Printf("TowerContinueRndSeed = %d\n",wk->play_rnd_seed);
		
		if(wk->play_mode == BTWR_MODE_MULTI){
			wk->partner = (u8)TowerPlayData_Get(wk->playSave,BTWR_PSD_partner,NULL);
			//p[gi[g[i[f[^Đ
			TowerPlayData_Get(wk->playSave,BTWR_PSD_pare_poke,&(wk->five_poke[wk->partner]));
			RomBattleTowerPartnerDataMake(wk,&wk->five_data[wk->partner],
				TOWER_FIVE_FIRST+wk->partner,
				TowerPlayData_Get(wk->playSave,BTWR_PSD_pare_itemfix,NULL),
				&(wk->five_poke[wk->partner]),wk->heapID);
		}
	}
	//̐ʂ擾
	wk->my_sex = MyStatus_GetMySex(SaveData_GetMyStatus(savedata));

	//݂̃R[h擾
	if(wk->play_mode != BTWR_MODE_RETRY){
		record = SaveData_GetRecord(savedata);
		//݂̘A͒풆tOon̂Ƃp
		chg_flg = TowerScoreData_SetFlags(wk->scoreSave,
					BTWR_SFLAG_SINGLE_RECORD+wk->play_mode,BTWR_DATA_get);
		if(chg_flg){
			wk->renshou = (u16)RECORD_Get(record,RECID_RENSHOU_SINGLE_CNT+wk->play_mode*2);	
		}
		wk->win_cnt = RECORD_Get(record,RECID_BTOWER_WIN);	
		wk->stage = TowerScoreData_SetStage(wk->scoreSave,wk->play_mode,BTWR_DATA_get);
	}

	return wk;
}

/**
 *	@brief	[NGAJ
 */
void TowerScr_WorkRelease(BTOWER_SCRWORK* wk)
{
	int	heap;

	if(wk == NULL){
		return;
	}
	GF_ASSERT(wk->magicNo == BTOWER_SCRWORK_MAGIC && "btower word is crash");
	heap = wk->heapID;

	MI_CpuClear8(wk,sizeof(BTOWER_SCRWORK));
	sys_FreeMemoryEz(wk);
	wk = NULL;

	HeapStatePop();
	HeapStateCheck(heap);

	sys_DeleteHeap(heap);
}


//***************************************************************
//===============================================================
//	[NɈˑTuc[
//===============================================================
//***************************************************************

/**
 *	@brief	og^[p|PIďo
 */
void TowerScr_SelectPoke(BTOWER_SCRWORK* wk,
		GMEVENT_CONTROL *ev_work,void** proc_wk)
{
	EventCmd_BTowerPokeSelectCall(ev_work,proc_wk,
		PL_MODE_BATTLE_TOWER,PST_MODE_NORMAL,
		wk->member_num,wk->member_num,100,0);
}

/**
 *	@brief	I|P擾
 *	
 *	@retval	TRUE	I
 *	@retval	FALSE	Iɂ߂
 */
BOOL TowerScr_GetEntryPoke(BTOWER_SCRWORK* wk,void** app_work,SAVEDATA* sv)
{
	u16	i = 0;
	PLIST_DATA* pld = *app_work;
	POKEPARTY* party;
	POKEMON_PARAM* pp;

#ifdef BTOWER_AUTO_DEB
	if(pld->ret_mode != 0){
		sys_FreeMemoryEz(*app_work);
		*app_work = NULL;
		return FALSE;
	}
#else	//BTOWER_AUTO_DEB
	//f[^擾
	if(pld->ret_mode != 0 || pld->ret_sel == PL_SEL_POS_EXIT){
		sys_FreeMemoryEz(*app_work);
		*app_work = NULL;
		return FALSE;
	}
#endif	//BTOWER_AUTO_DEB
	party = SaveData_GetTemotiPokemon(sv);
	
	for(i = 0;i < wk->member_num;i++){
		wk->member[i] = pld->in_num[i]-1;
		pp = PokeParty_GetMemberPointer(party,wk->member[i]);
		wk->mem_poke[i] = PokeParaGet(pp,ID_PARA_monsno,NULL);	
		wk->mem_item[i] = PokeParaGet(pp,ID_PARA_item,NULL);	
	}
	//[N̈
	sys_FreeMemoryEz(*app_work);
	*app_work = NULL;
	return TRUE;
}

/**
 *	@brief	Qw肵莝|P̏`FbN
 *
 *	@retval	0	QOK
 *	@retval	1	|P
 *	@retval 2	ACeĂ
 */
int TowerScr_CheckEntryPoke(BTOWER_SCRWORK* wk,SAVEDATA* savedata)
{
	u16	i = 0,j = 0;
	u16	monsno[BTOWER_STOCK_MEMBER_MAX],itemno[BTOWER_STOCK_MEMBER_MAX];
	POKEPARTY* party;
	POKEMON_PARAM* poke;

	party = SaveData_GetTemotiPokemon(savedata);

	for(i = 0;i < wk->member_num;i++){
		poke = PokeParty_GetMemberPointer(party,wk->member[i]);
		monsno[i] = PokeParaGet(poke,ID_PARA_monsno,NULL);
		itemno[i] = PokeParaGet(poke,ID_PARA_item,NULL);

		if(i == 0){
			continue;
		}
		for(j = 0;j < i;j++){
			if(monsno[i] == monsno[j]){
				//|P
				return 1;
			}
			if((itemno[i] != 0) && (itemno[i] == itemno[j])){
				//ACeĂ
				return 2;
			}
		}
	}
	return 0;
}

static BOOL is_trainer_conflict(u16* trainer,u16 id,u16 num)
{
	u16 i;
	for(i = 0;i < num;i++){
		if(trainer[i] == id){
			return TRUE;
		}
	}
	return FALSE;
}

/**
 *	@brief@ΐg[i[NoI
 */
void TowerScr_BtlTrainerNoSet(BTOWER_SCRWORK* wk,SAVEDATA* sv)
{
	int i;
	u16	no,stage;
	
	if(	wk->play_mode == BTWR_MODE_MULTI ||
		wk->play_mode == BTWR_MODE_COMM_MULTI){
		if(wk->play_mode == BTWR_MODE_COMM_MULTI && wk->pare_stage > wk->stage){
			stage = wk->pare_stage;	//ʐMɂ͎񐔂̑قŒI
		}else{
			stage = wk->stage;
		}
		for(i = 0;i < BTOWER_STOCK_TRAINER_MAX;i++){
			do{
				no = BattleTowerTrainerNoGet(wk,stage,i/2,wk->play_mode);
			}while(is_trainer_conflict(wk->trainer,no,i));
#ifdef BTOWER_AUTO_DEB
#if 0
			wk->trainer[i] = DebugBTowerAutoTrainer;
			OS_Printf(" #TowerStage = %d,%d\n",DebugBTowerAutoStage,DebugBTowerAutoTrainer);
			if(DebugBTowerAutoTrainer++ >= 299){
				DebugBTowerAutoTrainer = 0;
				DebugBTowerAutoStage++;
			}
#endif
			wk->trainer[i] = no;
			if(DebugBTowerAutoTrainer++ >= 299){
				DebugBTowerAutoStage++;
			}
			OS_Printf(" #TowerStage = %d,%d\n",DebugBTowerAutoStage,DebugBTowerAutoTrainer);
#else		
			wk->trainer[i] = no;
#endif
		}
	}else{
		for(i = 0;i < (BTOWER_STOCK_TRAINER_MAX/2);i++){
			do{
				no = BattleTowerTrainerNoGet(wk,wk->stage,i,wk->play_mode);
			}while(is_trainer_conflict(wk->trainer,no,i));
#ifdef BTOWER_AUTO_DEB
#if 0
			wk->trainer[i] = DebugBTowerAutoTrainer;
			OS_Printf(" #TowerStage = %d,%d\n",DebugBTowerAutoStage,DebugBTowerAutoTrainer);
			if(DebugBTowerAutoTrainer++ >= 299){
				DebugBTowerAutoTrainer = 0;
				DebugBTowerAutoStage++;
			}
#endif
			if(DebugBTowerAutoTrainer++ >= 299){
				DebugBTowerAutoStage++;
			}
			OS_Printf(" #TowerStage = %d,%d\n",DebugBTowerAutoStage,DebugBTowerAutoTrainer);
			wk->trainer[i] = 25;//no;
#else		
			wk->trainer[i] = no;
#endif
		}
	}
}

/**
 *	@brief	݂̃EhXNvg[NɎ擾
 */
u16	TowerScr_GetNowRound(BTOWER_SCRWORK* wk)
{
	return wk->now_round;
}

/**
 *	@brief	EhCNg
 */
u16	TowerScr_IncRound(BTOWER_SCRWORK* wk)
{
	++wk->now_win;	//CNg

	//_̎XV
	wk->play_rnd_seed = BtlTower_PlayFixRand(wk->play_rnd_seed);

	OS_Printf("TowerRoundInc = %d\n",wk->play_rnd_seed);

	return ++wk->now_round;
}

/**
 *	@brief	7AĂ邩ǂ`FbN
 */
BOOL TowerScr_IsClear(BTOWER_SCRWORK* wk)
{
	if(wk->clear_f){
		return TRUE;
	}
	if(wk->now_round > BTWR_CLEAR_WINCNT){
		//NAtOon
		wk->clear_f = 1;
		return TRUE;
	}
	return FALSE;
}

/**
 *	@brief	vC̘A擾
 */
u16 TowerScr_GetRenshouCount(BTOWER_SCRWORK* wk)
{
	if((u32)wk->renshou+wk->now_win > 0xFFFF){
		return 0xFFFF;
	}else{
		return wk->renshou+wk->now_win;
	}
}

/**
 *	@brief	őAL^XVԑg쐬֐
 */
static void towerscr_MakeTVRenshouMaxUpdate(BTOWER_SCRWORK* wk,FIELDSYS_WORK* fsys,u16 renshou)
{
	POKEPARTY *party;

	if(	wk->play_mode != BTWR_MODE_SINGLE &&
		wk->play_mode != BTWR_MODE_DOUBLE){
		return;
	}
	party = SaveData_GetTemotiPokemon(fsys->savedata);

	if(wk->play_mode == BTWR_MODE_SINGLE){
		TVTOPIC_Entry_Record_BTower(fsys,
			renshou,PokeParty_GetMemberPointer(party,wk->member[0]), TRUE);
	}else{
		TVTOPIC_Entry_Record_BTower(fsys,
			renshou,PokeParty_GetMemberPointer(party,wk->member[0]), FALSE);
	}
}

/**
 *	@brief	7l܂͕̋ʃf[^Z[u
 *
 *	@param	now_renshou	݂̘A
 */
static void towerscr_SetCommonScore(BTOWER_SCRWORK* wk,SAVEDATA* sv,u8 win_f,u16 now_renshou)
{
	u8	buf8;

	switch(wk->play_mode){
	case BTWR_MODE_SINGLE:
		//|Pf[^Zbg
		towerscr_SaveMemberPokeData(wk,sv,BTWR_SCORE_POKE_SINGLE);
	case BTWR_MODE_DOUBLE:
		if(now_renshou >= 7){
			//TVC^r[f[^Zbg(VOƃ_uŎs)
			TVTOPIC_BTowerTemp_Set(SaveData_GetTvWork(sv),win_f,now_renshou);
		}
		break;
	case BTWR_MODE_WIFI:
		//|Pf[^Zbg
		towerscr_SaveMemberPokeData(wk,sv,BTWR_SCORE_POKE_WIFI);
		//XRAo
		TowerPlayData_WifiRecordAdd(wk->playSave,wk->rec_down,wk->rec_turn,wk->rec_damage);

		//vC[ho
		buf8 = wk->play_mode;
		TowerPlayData_Put(wk->playSave,BTWR_PSD_playmode,&buf8);
		//Eho
		buf8 = wk->now_round;
		TowerPlayData_Put(wk->playSave,BTWR_PSD_round,&buf8);
		
		TowerScoreData_SetWifiScore(wk->scoreSave,wk->playSave);
		break;
	default:
		break;
	}

}

/**
 *	@brief	s폈	
 */
void TowerScr_SetLoseScore(BTOWER_SCRWORK* wk,FIELDSYS_WORK* fsys)
{
	u32	ret = 0;
	int	id;
	u16	before,after,chg_flg;
	SAVEDATA* savedata = fsys->savedata;
	RECORD* record = SaveData_GetRecord(savedata);
	
	if(wk->play_mode == BTWR_MODE_RETRY){
		return;
	}
	
	OS_Printf("TowerLoseScoreSet -> mode = %d\n",wk->play_mode);

	id = wk->play_mode*2+RECID_RENSHOU_SINGLE;

	//݂̍őA擾
	before = RECORD_Get(record,id);
	//őAXV
	after = RECORD_SetIfLarge(record,id,wk->renshou+wk->now_win);

	//XVĂ||(L^7̔{&&O̒l)Ȃԑg쐬
	if(after > 1){
		if(	(before < after) ||
			((before == after) && (after%7==0)) ){
			towerscr_MakeTVRenshouMaxUpdate(wk,fsys,after);
		}
	}
	//уj^pɌ݂̘AoĂ
	chg_flg = TowerScoreData_SetFlags(wk->scoreSave,
			BTWR_SFLAG_SINGLE_RECORD+wk->play_mode,BTWR_DATA_get);
	if(chg_flg){	//AL^풆ȂZ
		ret = RECORD_Add(record,id+1,wk->now_win);
	}else{	//O񕉂Ă΃Zbg
		ret = RECORD_Set(record,id+1,wk->now_win);
	}

	//R[h풆tO𗎂Ƃ
	TowerScoreData_SetFlags(wk->scoreSave,BTWR_SFLAG_SINGLE_RECORD+wk->play_mode,BTWR_DATA_reset);

	//׏XV
	RECORD_Add(record,RECID_BTOWER_WIN,wk->now_win);
	//݂̎񐔃Zbg
	TowerScoreData_SetStage(wk->scoreSave,wk->play_mode,BTWR_DATA_reset);
	//og^[ւ̃`Wǉ
	RECORD_Add(SaveData_GetRecord(savedata),RECID_BTOWER_CHALLENGE,1);
	
	//A{炦邩ǂ̃tOZbg
	towerscr_IfRenshouPrizeGet(wk);

	//ʃf[^
	ret+=1;
	if(ret > 9999){
		ret = 9999;	
	}
	towerscr_SetCommonScore(wk,savedata,FALSE,ret);
}

/**
 *	@brief	NA
 */
void TowerScr_SetClearScore(BTOWER_SCRWORK* wk,FIELDSYS_WORK* fsys)
{
	u32	ret = 0;
	int	id;
	void* note;
	u16	before,after,chg_flg;
	RECORD*  record;
	SAVEDATA	*savedata = fsys->savedata;
		
	if(wk->play_mode == BTWR_MODE_RETRY){
		return;
	}
	OS_Printf("TowerClearScoreSet -> mode = %d\n",wk->play_mode);
	
	record = SaveData_GetRecord(savedata);
	id = wk->play_mode*2+RECID_RENSHOU_SINGLE;
	
	//݂̘Ao
	chg_flg = TowerScoreData_SetFlags(wk->scoreSave,
			BTWR_SFLAG_SINGLE_RECORD+wk->play_mode,BTWR_DATA_get);

	if(chg_flg){	//݂AL^풆ȂZ
		ret = RECORD_Add(record,id+1,BTWR_CLEAR_WINCNT);
	}else{	//O񕉂Ăꍇ͈UZbg
		ret = RECORD_Set(record,id+1,BTWR_CLEAR_WINCNT);
	}
	//R[h풆tO𗧂Ă
	TowerScoreData_SetFlags(wk->scoreSave,BTWR_SFLAG_SINGLE_RECORD+wk->play_mode,BTWR_DATA_set);

	//݂̍őA擾
	before = RECORD_Get(record,id);
	//őAXV
	after = RECORD_SetIfLarge(record,id,ret);

	//XVĂԑg쐬
#if 0
	if(before < after){
		towerscr_MakeTVRenshouMaxUpdate(wk,fsys,after);
	}
#endif
	//׏XV
	RECORD_Add(record,RECID_BTOWER_WIN,BTWR_CLEAR_WINCNT);
	//񐔃vX
	TowerScoreData_SetStage(wk->scoreSave,wk->play_mode,BTWR_DATA_inc);
	//og^[ւ̃`Wǉ
	RECORD_Add(record,RECID_BTOWER_CHALLENGE,1);
	//XRAZ
	RECORD_Score_Add(record,SCORE_ID_BTOWER_7WIN);
	
	//A{炦邩ǂ̃tOZbg
	towerscr_IfRenshouPrizeGet(wk);

	//ʃf[^
	towerscr_SetCommonScore(wk,savedata,TRUE,ret);

	//`m[g(ʐM}`&wifî)
	if(	wk->play_mode == BTWR_MODE_COMM_MULTI ||
		wk->play_mode == BTWR_MODE_WIFI){
		note = FNOTE_SioBattleTowerDataMake(wk->heapID);
		FNOTE_DataSave( fsys->fnote,note, FNOTE_TYPE_SIO );
	}
}

/**
 *	@brief	xނƂɌ݂̃vC󋵂Z[uɏo
 */
void TowerScr_SaveRestPlayData(BTOWER_SCRWORK* wk)
{
	u16	i;
	u8	buf8[4];

	//vC[ho
	buf8[0] = wk->play_mode;
	TowerPlayData_Put(wk->playSave,BTWR_PSD_playmode,buf8);
	
	//Eho
	buf8[0] = wk->now_round;
	TowerPlayData_Put(wk->playSave,BTWR_PSD_round,buf8);

	//I񂾃|PNo
	TowerPlayData_Put(wk->playSave,BTWR_PSD_pokeno,wk->member);
	
	//ogяo
	TowerPlayData_WifiRecordAdd(wk->playSave,wk->rec_down,wk->rec_turn,wk->rec_damage);

	//Iꂽg[i[Noo
	TowerPlayData_Put(wk->playSave,BTWR_PSD_trainer,wk->trainer);
	
	//vC_V[hۑ
	TowerPlayData_Put(wk->playSave,BTWR_PSD_rnd_seed,&(wk->play_rnd_seed));
	OS_Printf("TowerRestRndSeed = %d\n",wk->play_rnd_seed);
	
	//Z[utOLԂɃZbg
	TowerPlayData_SetSaveFlag(wk->playSave,TRUE);

	if(wk->play_mode != BTWR_MODE_MULTI){
		return;
	}
	//AI}`[hȂp[gi[oĂ
	buf8[0] = wk->partner;
	TowerPlayData_Put(wk->playSave,BTWR_PSD_partner,buf8);

	//p[gi[̃|Pp[^Ă
	TowerPlayData_Put(wk->playSave,BTWR_PSD_pare_poke,&(wk->five_poke[wk->partner]));
	//ACeŒ肾ǂĂ
	TowerPlayData_Put(wk->playSave,BTWR_PSD_pare_itemfix,&(wk->five_item[wk->partner]));
	//vC_V[hĂ
	
}

/**
 *	@brief	ΐg[i[I
 */
void TowerScr_ChoiceBtlPartner(BTOWER_SCRWORK* wk,SAVEDATA* sv)
{
	int i;
	u16	monsno[2];
	u16	itemno[2];
	
	switch(wk->play_mode){
	case BTWR_MODE_WIFI:
	case BTWR_MODE_RETRY:
		btltower_BtlPartnerSelectWifi(sv,wk->tr_data,wk->now_round-1);
		break;
	case BTWR_MODE_MULTI:
	case BTWR_MODE_COMM_MULTI:
		RomBattleTowerTrainerDataMake(wk,&(wk->tr_data[0]),
			wk->trainer[(wk->now_round-1)*2+0],wk->member_num,NULL,NULL,NULL,wk->heapID);
		
		//X^[Nȍd`FbN
		for(i = 0;i < wk->member_num;i++){
			monsno[i] = wk->tr_data[0].btpwd[i].mons_no;
			itemno[i] = wk->tr_data[0].btpwd[i].item_no;
		}
		RomBattleTowerTrainerDataMake(wk,&(wk->tr_data[1]),
			wk->trainer[(wk->now_round-1)*2+1],wk->member_num,monsno,itemno,NULL,wk->heapID);
		break;
	case BTWR_MODE_DOUBLE:
	case BTWR_MODE_SINGLE:
	default:
		RomBattleTowerTrainerDataMake(wk,&(wk->tr_data[0]),
			wk->trainer[wk->now_round-1],wk->member_num,NULL,NULL,NULL,wk->heapID);
		break;
	}
}

/**
 *	@brief	AI}`yA|PI
 */
void TowerScr_ChoiceBtlSeven(BTOWER_SCRWORK* wk)
{
	int i;

	for(i = 0;i < BTWR_FIVE_NUM;i++){
		wk->five_item[i] = (u8)RomBattleTowerTrainerDataMake(wk,&(wk->five_data[i]),
			TOWER_FIVE_FIRST+i,wk->member_num,wk->mem_poke,wk->mem_item,&(wk->five_poke[i]),wk->heapID);
	}
}

/**
 *	@brief	ΐg[i[OBJR[h擾
 */
u16 TowerScr_GetEnemyObj(BTOWER_SCRWORK* wk,u16 idx)
{
	//g[i[^CvOBJR[h擾Ă
	return BtlTower_TrType2ObjCode(wk->tr_data[idx].bt_trd.tr_type);
}

/**
 *	@brief	퓬Ăяo
 */
void TowerScr_LocalBattleCall(GMEVENT_CONTROL* event,BTOWER_SCRWORK* wk,BOOL* win_flag)
{
	EventCmd_TowerLocalBattle(event,wk,win_flag);
}

/**
 *	@brief	݂̃vC[hԂ
 */
u16	TowerScr_GetPlayMode(BTOWER_SCRWORK* wk)
{
	return wk->play_mode;
}

/**
 *	@brief	[_[NAtO𗧂Ă
 */
void TowerScr_SetLeaderClearFlag(BTOWER_SCRWORK* wk,u16 mode)
{
	wk->leader_f = mode;
}

/**
 *	@brief	[_[NAtO擾
 */
u16	TowerScr_GetLeaderClearFlag(BTOWER_SCRWORK* wk)
{
	return (u16)wk->leader_f;
}

/**
 *	@brief	^[NAɃog|CgZ
 *
 *	@return	VɎ擾og|Cg
 */
u16	TowerScr_AddBtlPoint(BTOWER_SCRWORK* wk)
{
	u16	stage;
	u16	point = 0;
	static const u8	bpoint_wifi[] = {0,
		BTLPOINT_VAL_TOWER_WIFI1,BTLPOINT_VAL_TOWER_WIFI2,BTLPOINT_VAL_TOWER_WIFI3,
		BTLPOINT_VAL_TOWER_WIFI4,BTLPOINT_VAL_TOWER_WIFI5,BTLPOINT_VAL_TOWER_WIFI6,
		BTLPOINT_VAL_TOWER_WIFI7,BTLPOINT_VAL_TOWER_WIFI8,BTLPOINT_VAL_TOWER_WIFI9,
		BTLPOINT_VAL_TOWER_WIFI10,
	};
	static const u8 bpoint_normal[] = {0,
		BTLPOINT_VAL_TOWER_STAGE1,BTLPOINT_VAL_TOWER_STAGE2,BTLPOINT_VAL_TOWER_STAGE3,
		BTLPOINT_VAL_TOWER_STAGE4,BTLPOINT_VAL_TOWER_STAGE5,BTLPOINT_VAL_TOWER_STAGE6,
		BTLPOINT_VAL_TOWER_STAGE7,
	};

	if(wk->play_mode == BTWR_MODE_RETRY){
		return 0;
	}
	if(wk->play_mode == BTWR_MODE_WIFI){
		//N
		point = bpoint_wifi[TowerScoreData_SetWifiRank(wk->scoreSave,BTWR_DATA_get)];
	}else{
		//񐔂
		stage = TowerScoreData_SetStage(wk->scoreSave,wk->play_mode,BTWR_DATA_get);
		if(wk->leader_f){
			point = BTLPOINT_VAL_TOWER_LEADER;
		}else if(stage >= 7){
			point = BTLPOINT_VAL_TOWER_STAGE8;
		}else{
			point = bpoint_normal[stage];
		}
	}
	//og|CgZ
	TowerScoreData_SetBattlePoint(wk->scoreSave,point,BTWR_DATA_add);
	return point;
}

/**
 *	@brief	VOŘÂJ̃gtB[tO𗧂ĂĂ
 */
u16	TowerScr_GoodsFlagSet(BTOWER_SCRWORK* wk,SAVEDATA* sv)
{
	u8	id,fid;
	u16	record,goods,ret;

	record = TowerScrTools_GetRenshouRecord(sv,wk->play_mode);

	if(record < BTWR_50_RENSHOU_CNT){
		return 0;
	}
	if(record >= BTWR_100_RENSHOU_CNT){
		if(TowerScoreData_SetFlags(wk->scoreSave,BTWR_SFLAG_GOLD_GET,BTWR_DATA_get)){
			return 0;
		}
	}else{
		if(TowerScoreData_SetFlags(wk->scoreSave,BTWR_SFLAG_SILVER_GET,BTWR_DATA_get)){
			return 0;
		}
	}
	return 1;
}

/**
 *	@brief	݂WIFIN𑀍삵ĕԂ
 */
u16	TowerScr_SetWifiRank(BTOWER_SCRWORK* wk,SAVEDATA* sv,u8 mode)
{
	u8	ct,rank;
	BTLTOWER_SCOREWORK* score = SaveData_GetTowerScoreData(sv);
	
	static const u8	btower_wifi_rankdown[] = {
	 0,5,4,4,3,3,2,2,1,1,
//	 0,2,1,1,1,1,1,1,1,1,
	};

	switch(mode){
	//Get
	case 0:
		return (u16)TowerScoreData_SetWifiRank(score,BTWR_DATA_get);
	case 1:	//Inc
		//AstO𗎂Ƃ
		TowerScoreData_SetFlags(score,BTWR_SFLAG_WIFI_LOSE_F,BTWR_DATA_reset);
		//݂̃N擾
		rank = TowerScoreData_SetWifiRank(score,BTWR_DATA_get);

		if(rank == 10){	
			return 0;	//オȂ
		}
		//NAbv
		TowerScoreData_SetWifiRank(score,BTWR_DATA_inc);

		//N5ȏɃAbvĂ烊{炦
		if(rank+1 >= 5){
			wk->prize_f = 1;
		}
		return 1;
	case 2:	//dec
		//݂̘As퐔JEg
		ct = TowerScoreData_SetWifiLoseCount(score,BTWR_DATA_inc);
		rank = TowerScoreData_SetWifiRank(score,BTWR_DATA_get);

		if(rank == 1){
			return 0;
		}
		//NʔsJEg`FbN
		if(ct >= btower_wifi_rankdown[rank-1] ){
			//N_E
			TowerScoreData_SetWifiRank(score,BTWR_DATA_dec);
			//As퐔ƘAstOZbg
			TowerScoreData_SetWifiLoseCount(score,BTWR_DATA_reset);
			TowerScoreData_SetFlags(score,BTWR_SFLAG_WIFI_LOSE_F,BTWR_DATA_reset);
			return 1;
		}
		return 0;
	}
	return 0;
}

/**
 *	@brief	[_[|J{
 */
u16 TowerScr_LeaderRibbonSet(BTOWER_SCRWORK* wk,SAVEDATA* sv)
{
	if(wk->play_mode != BTWR_MODE_SINGLE){
		return 0;
	}
	
	//o[Ƀ{Zbg
	switch(wk->leader_f){
	case 1:
		return towerscr_PokeRibbonSet(sv,ID_PARA_sinou_battle_tower_ttwin_first,wk);
	case 2:
		return towerscr_PokeRibbonSet(sv,ID_PARA_sinou_battle_tower_ttwin_second,wk);
	}
	return 0;
}

/**
 *	@brief	tOĂÂJ{	
 */
u16 TowerScr_RenshouRibbonSet(BTOWER_SCRWORK* wk,SAVEDATA* sv)
{
	u8	id,fid;
	u16	record,goods,ret;
	UNDERGROUNDDATA* gSave;

	if(wk->play_mode == BTWR_MODE_RETRY){
		return 0;
	}
	if(!wk->prize_f){
		return 0;
	}
	switch(wk->play_mode){
	case BTWR_MODE_DOUBLE:
		id = ID_PARA_sinou_battle_tower_2vs2_win50;
		break;
	case BTWR_MODE_MULTI:
		id = ID_PARA_sinou_battle_tower_aimulti_win50;
		break;
	case BTWR_MODE_COMM_MULTI:
		id = ID_PARA_sinou_battle_tower_siomulti_win50;
		break;
	case BTWR_MODE_WIFI:
		id = ID_PARA_sinou_battle_tower_wifi_rank5;
		break;
	}
	//o[Ƀ{Zbg
	return towerscr_PokeRibbonSet(sv,id,wk);
}

/**
 *	@biref	vC_V[hXV
 */
u16 TowerScr_PlayRandUpdate(BTOWER_SCRWORK* wk,SAVEDATA* sv)
{
	u8	chg_flg;
	//݃`WpǂH
	chg_flg = TowerScoreData_SetFlags(wk->scoreSave,
			BTWR_SFLAG_SINGLE_RECORD+wk->play_mode,BTWR_DATA_get);
	
	if(!chg_flg){
		//vCXV_V[hl擾&tXVV[hXV
		wk->play_rnd_seed = BtlTower_UpdatePlayRndSeed(sv);
	}else{
		//L^JndayV[h_ɁA݂playV[h擾
		wk->play_rnd_seed = BtlTower_GetContinuePlayRndSeed(sv);
	}
	return (wk->play_rnd_seed/65535);
}

//////////////////////////////////////////////////////////////////////////////
//[J֐Q
//
/**
 *	@brief	|PɃ{@Tu
 */
static u16 towerscr_PokeRibbonSet(SAVEDATA* sv,u8 ribbon,BTOWER_SCRWORK* wk)
{
	u8	flag = 1;
	u8 ct;
	int i;
	POKEPARTY	*party;
	POKEMON_PARAM* pp;
	
	party = SaveData_GetTemotiPokemon(sv);

	ct = 0;
	for(i = 0;i < wk->member_num;i++){
		pp = PokeParty_GetMemberPointer(party,wk->member[i]);
		if(PokeParaGet(pp,ribbon,NULL)){
			continue;	//ɎĂ
		}
		PokeParaPut(pp,ribbon,&flag);
		++ct;
	}
	if(ct == 0){
		//݂ȂĂ
		return FALSE;
	}
	return TRUE;
}

/**
 *	@brief	ÂJ{炦邩ǂ̃tO𗧂ĂĂ
 */
static u16 towerscr_IfRenshouPrizeGet(BTOWER_SCRWORK* wk)
{
	u16 win;
	if(	wk->play_mode == BTWR_MODE_RETRY ||
		wk->play_mode == BTWR_MODE_SINGLE ||
		wk->play_mode == BTWR_MODE_WIFI){
		return 0;
	}
	win = wk->renshou+wk->now_win;

	//50Aȏł炦
	if(win < BTWR_50_RENSHOU_CNT){
		return 0;
	}
	//prize gettO𗧂ĂĂ
	wk->prize_f = 1;
	return 1;
}


/**
 *	@brief	Q|P̃p[^B_TOWER_POKEMON^ɃpbN
 */
static void towerscr_PokeDataPack(B_TOWER_POKEMON* dat,POKEMON_PARAM* pp)
{
	int i;
	
	//mons_no/form_no/item_no
	dat->mons_no = PokeParaGet(pp,ID_PARA_monsno,NULL);
	dat->form_no = PokeParaGet(pp,ID_PARA_form_no,NULL);
	dat->item_no = PokeParaGet(pp,ID_PARA_item,NULL);

	//waza/pp_count
	for(i = 0;i < WAZA_TEMOTI_MAX;i++){
		dat->waza[i] = PokeParaGet(pp,ID_PARA_waza1+i,NULL);
		dat->pp_count |= ((PokeParaGet(pp,ID_PARA_pp_count1+i,NULL)) << (i*2));
	}
	//country,id,personal
	dat->country_code = PokeParaGet(pp,ID_PARA_country_code,NULL);
	dat->id_no = PokeParaGet(pp,ID_PARA_id_no,NULL);
	dat->personal_rnd = PokeParaGet(pp,ID_PARA_personal_rnd,NULL);

	//power_rnd
	dat->power_rnd = PokeParaGet(pp,ID_PARA_power_rnd,NULL);

	//exp
	for(i = 0;i < 6;i++){
		dat->exp[i] = PokeParaGet(pp,ID_PARA_hp_exp+i,NULL);
	}
	//tokusei,natukido
	dat->tokusei = PokeParaGet(pp,ID_PARA_speabino,NULL);
	dat->natuki = PokeParaGet(pp,ID_PARA_friend,NULL);
	
	//jbNl[
	PokeParaGet(pp,ID_PARA_nickname,dat->nickname);
}

/**
 *	@brief	Q|P̃p[^ۑ
 */
static void towerscr_SaveMemberPokeData(BTOWER_SCRWORK* wk,SAVEDATA* sv,BTWR_SCORE_POKE_DATA mode)
{
	int i = 0;
	B_TOWER_POKEMON* dat;
	POKEPARTY	*party;
	POKEMON_PARAM* pp;
	
	dat = sys_AllocMemoryLo(wk->heapID,sizeof(B_TOWER_POKEMON)*3);
	MI_CpuClear8(dat,sizeof(B_TOWER_POKEMON)*3);

	party = SaveData_GetTemotiPokemon(sv);
	for(i = 0;i < 3;i++){
		pp = PokeParty_GetMemberPointer(party,wk->member[i]);
		towerscr_PokeDataPack(&(dat[i]),pp);	
	}
	TowerScoreData_SetUsePokeData(wk->scoreSave,mode,dat);

	MI_CpuClear8(dat,sizeof(B_TOWER_POKEMON)*3);
	sys_FreeMemoryEz(dat);
}
