/**
 *	@file	btower_scr.h
 *	@brief	og^[@XNvgn
 *	@author	Miyuki Iwasawa
 *	@date	06.04.17
 */

#ifndef __H_B_TOWER_SCR_H__
#define __H_B_TOWER_SCR_H__

#ifdef GLOBAL
#undef GLOBAL
#endif

#ifdef __B_TOWER_SCR_H_GLOBAL
#define GLOBAL	/***/
#else
#define GLOBAL	extern
#endif

#include "b_tower_scr_def.h"
#include "battle/battle_common.h"
#include "battle/b_tower_data.h"

///og^[@XNvg[N
typedef struct _BTOWER_SCRWORK{
	int	magicNo;	///<}WbNio[
	int	heapID;	///<q[v
	u32	play_rnd_seed;	///<vCp_V[h
	u8	now_round;	///<݉lځH
	u8	now_win;	///<݉lɏH
	u8	member_num;	///<o[
	u8	play_mode;	///<vCf[^

	u8	clear_f:1;	///<NAtO
	u8	leader_f:2;	///<^CN[2
	u8	retire_f:1;	///<^CAtO
	u8	prize_f:1;	///<JtO
	u8	partner:3;	///<p[gi[No

	u8	my_sex;			///<̐
	u8	pare_sex;		///<ƃp[gi[̐
	u16	pare_stage;		///<ʐM}`p[gi[̎
	u16	pare_poke[2];	///<ʐM}`p[gi[|PNo
	
	u16	renshou;	///<݂̘A
	u16	stage;		///<݂̎
	u32	win_cnt;	///<݂܂ł̑

	u16	rec_turn;	///<^[
	u16	rec_damage;	///<H_[W
	u16	rec_down;	///<|P̃_E

	u8	member[BTOWER_STOCK_MEMBER_MAX];	///<I񂾃|P̎莝No
	u16	mem_poke[BTOWER_STOCK_MEMBER_MAX];	///<I񂾃|Pmonsno
	u16	mem_item[BTOWER_STOCK_MEMBER_MAX];	///<I񂾃|P̃ACeno
	u16	trainer[BTOWER_STOCK_TRAINER_MAX];	///<ΐg[i[No

	//݂̃P[VLĂ
	LOCATION_WORK	now_location;

	BTLTOWER_PLAYWORK*	playSave;	///<Z[uf[^ւ̃|C^
	BTLTOWER_SCOREWORK*	scoreSave;	///<Z[uf[^ւ̃|C^

	//ΐ푊f[^i[ꏊ
	B_TOWER_PARTNER_DATA	tr_data[2];
	
	//5lOIf[^i[ꏊ
	B_TOWER_PARTNER_DATA	five_data[BTWR_FIVE_NUM];

	//5lOI|Pp[^i[ꏊ
	B_TOWER_PAREPOKE_PARAM	five_poke[BTWR_FIVE_NUM];

	//5lOI|PACefixtO
	u8						five_item[BTWR_FIVE_NUM];

	//ʐMpf[^obt@
	u16	send_buf[35];
	u16	recv_buf[35];
}BTOWER_SCRWORK;


///XNvgR}hĂяo[`Q
///////////////////////////////////////////////////////
/**
 *	@brief	vC[hʂ̃o[擾
 */
GLOBAL u16	TowerScrTools_GetMemberNum(u16 mode);

/**
 *	@brief	og^[@Q\ȃ|P̃`FbN
 *
 *	@param	num		QɕKvȃ|P
 *
 *	@retval	true	Q\
 *	@retval	false	Qs
 */
GLOBAL BOOL TowerScrTools_CheckEntryPokeNum(u16 num,SAVEDATA *savedata);

/**
 *	@brief	Zbgă^Cgɖ߂
 */
GLOBAL void TowerScrTools_SystemReset(void);

/**
 *	@brief	new gameɃvCf[^NA
 */
GLOBAL void TowerScrTools_ClearPlaySaveData(BTLTOWER_PLAYWORK* playSave);

/**
 * @brief	Z[uf[^LǂԂ
 */
GLOBAL BOOL TowerScrTools_IsSaveDataEnable(BTLTOWER_PLAYWORK* playSave);

/**
 *	@brief	EopɌ݂̃P[VL
 */
GLOBAL void TowerScrTools_PushNowLocation(FIELDSYS_WORK* fsys);

/**
 *	@brief	Q[go鎞ɓڑɖ߂
 */
GLOBAL void TowerScrTools_PopNowLocation(FIELDSYS_WORK* fsys);

/**
 *	@brief	Q[g̈ʒu擾
 */
GLOBAL void TowerScrTools_GetGateLocation(FIELDSYS_WORK* fsys,u16* x,u16* y);

/**
 *	@brief	vC[hʃR[hZ[uf[^AԂ
 */
GLOBAL u16	TowerScrTools_GetRenshouRecord(SAVEDATA* sv,u16 play_mode);

/**
 *	@brief	XRAf[^̃tOԂ
 */
GLOBAL u16 TowerScrTools_GetScoreFlags(SAVEDATA* sv,BTWR_SFLAG_ID flagid);

/**
 *	@brief	Wifiт̖Abv[htO𐧌䂷
 */
GLOBAL void TowerScrTools_SetWifiUploadFlag(SAVEDATA* sv,u8 flag);

/**
 *	@brief	WiFivCт̖Abv[htO擾
 */
GLOBAL u16 TowerScrTools_GetWifiUploadFlag(SAVEDATA* sv);

/**
 *	@brief	Z[uɎ~߂Ƃ̃G[
 *
 *	@return	vCĂ[hԂ
 */
GLOBAL u16 TowerScrTools_SetNGScore(SAVEDATA* savedata);

/**
 *	@brief	WIFĨvC[DLf[^邩ǂ`FbN
 */
GLOBAL u16	TowerScrTools_IsPlayerDataEnable(SAVEDATA* sv);


//*****************************************************
//=====================================================
//[N̏Ɖ
//=====================================================
//*****************************************************
/**
 *	@brief	fsys̃og^[䃏[N|C^
 *			og^[JnɕKĂяo
 */
GLOBAL void TowerScr_WorkClear(BTOWER_SCRWORK** pp);

/**
 *	@brief	[NGA擾ď
 *
 *	@param	savedata	Z[uf[^ւ̃|C^
 *	@param	init		[h BTWR_PLAY_NEW:߂ABTWR_PLAY_CONTINE:
 *	@param	playmode	vC[hw BTWR_MODE_`
 *	
 *	Ȃ炸 TowerScr_WorkRelease()ŗ̈J邱
 */
GLOBAL BTOWER_SCRWORK* TowerScr_WorkInit(SAVEDATA* savedata,u16 init,u16 playmode);

/**
 *	@brief	[NGAJ
 */
GLOBAL void TowerScr_WorkRelease(BTOWER_SCRWORK* wk);


/**
 *	@brief	og^[p|PIďo
 */
GLOBAL void TowerScr_SelectPoke(BTOWER_SCRWORK* wk,
				GMEVENT_CONTROL *ev_work,void** proc_wk);

/**
 *	@brief	I|P擾
 *	
 *	@retval	TRUE	I
 *	@retval	FALSE	Iɂ߂
 */
GLOBAL BOOL TowerScr_GetEntryPoke(BTOWER_SCRWORK* wk,void** app_work,SAVEDATA* sv);

/**
 *	@brief	Qw肵莝|P̏`FbN
 *
 *	@retval	0	QOK
 *	@retval	1	|P
 *	@retval 2	ACeĂ
 */
GLOBAL int TowerScr_CheckEntryPoke(BTOWER_SCRWORK* wk,SAVEDATA* savedata);

/**
 *	@brief@ΐg[i[NoI
 */
GLOBAL void TowerScr_BtlTrainerNoSet(BTOWER_SCRWORK* wk,SAVEDATA* sv);

/**
 *	@brief	݂̃EhXNvg[NɎ擾
 */
GLOBAL u16	TowerScr_GetNowRound(BTOWER_SCRWORK* wk);

/**
 *	@brief	EhCNg
 */
GLOBAL u16	TowerScr_IncRound(BTOWER_SCRWORK* wk);

/**
 *	@brief	7AĂ邩ǂ`FbN
 */
GLOBAL BOOL TowerScr_IsClear(BTOWER_SCRWORK* wk);

/**
 *	@brief	݂̘A擾
 */
GLOBAL u16 TowerScr_GetRenshouCount(BTOWER_SCRWORK* wk);

/**
 *	@brief	s폈	
 */
GLOBAL void TowerScr_SetLoseScore(BTOWER_SCRWORK* wk,FIELDSYS_WORK* fsys);

/**
 *	@brief	NA
 */
GLOBAL void TowerScr_SetClearScore(BTOWER_SCRWORK* wk,FIELDSYS_WORK* fsys);


/**
 *	@brief	xނƂɌ݂̃vC󋵂Z[uɏo
 */
GLOBAL void TowerScr_SaveRestPlayData(BTOWER_SCRWORK* wk);


/**
 *	@brief	ΐg[i[I
 */
GLOBAL void TowerScr_ChoiceBtlPartner(BTOWER_SCRWORK* wk,SAVEDATA* sv);
/**
 *	@brief	AI}`yA|PI
 */
GLOBAL void TowerScr_ChoiceBtlSeven(BTOWER_SCRWORK* wk);

/**
 *	@brief	ΐg[i[OBJR[h擾
 */
GLOBAL u16 TowerScr_GetEnemyObj(BTOWER_SCRWORK* wk,u16 idx);

/**
 *	@brief	퓬Ăяo
 */
GLOBAL void TowerScr_LocalBattleCall(GMEVENT_CONTROL* event,BTOWER_SCRWORK* wk,BOOL* win_flag);

/**
 *	@brief	݂̃vC[hԂ
 */
GLOBAL u16	TowerScr_GetPlayMode(BTOWER_SCRWORK* wk);

/**
 *	@brief	[_[NAtO𗧂Ă
 */
GLOBAL void TowerScr_SetLeaderClearFlag(BTOWER_SCRWORK* wk,u16 mode);

/**
 *	@brief	[_[NAtO擾
 */
GLOBAL	u16	TowerScr_GetLeaderClearFlag(BTOWER_SCRWORK* wk);

/**
 *	@brief	^[NAɃog|CgZ
 *
 *	@return	VɎ擾og|Cg
 */
GLOBAL u16	TowerScr_AddBtlPoint(BTOWER_SCRWORK* wk);

/**
 *	@brief	VOŘÂJ̃gtB[tO𗧂ĂĂ
 */
GLOBAL	u16	TowerScr_GoodsFlagSet(BTOWER_SCRWORK* wk,SAVEDATA* sv);

/**
 *	@brief	݂WIFIN𑀍삵ĕԂ
 */
GLOBAL u16	TowerScr_SetWifiRank(BTOWER_SCRWORK* wk,SAVEDATA* sv,u8 mode);


/**
 *	@brief	[_[|J{
 */
GLOBAL u16 TowerScr_LeaderRibbonSet(BTOWER_SCRWORK* wk,SAVEDATA* sv);

/**
 *	@brief	ÂJ{	
 */
GLOBAL u16 TowerScr_RenshouRibbonSet(BTOWER_SCRWORK* wk,SAVEDATA* sv);

/**
 *	@biref	vC_V[hXV
 */
GLOBAL u16 TowerScr_PlayRandUpdate(BTOWER_SCRWORK* wk,SAVEDATA* sv);



#endif	//__H_BTOWER_SCR_H__

