//============================================================================================
/**
 * @file	board.c
 * @brief	Ŕ
 * @author	Hiroyuki Nakamura
 * @date	2005.10.25
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "fieldmap.h"
#include "talk_msg.h"

#include "system/window.h"

#define	BOARD_H_GLOBAL
#include "board.h"


//============================================================================================
//	萔`
//============================================================================================
/// Ŕ[N
struct _BOARD_WORK {
	GF_BGL_BMPWIN	win;	// BMPEBhE
	u16	map;				// }bvIDiOtBbNIDj
	u8	type;				// Ŕ^Cv
	u8	req:7;				// NGXg
	u8	flg:1;				// 쐬tO
};

#define	BOARD_INIT_SCROLL_Y	( -48 )		///< 쐬̏YXN[l
#define	BOARD_SCROLL_VAL	( 16 )		///< 1sync ̃XN[l
#define	BOARD_WIN_PX		( 0 )		///< EBhE`XW
#define	BOARD_WIN_PY		( 18 )		///< EBhE`YW
#define	BOARD_WIN_SX		( 32 )		///< EBhEXTCY
#define	BOARD_WIN_SY		( 6 )		///< EBhEYTCY


//============================================================================================
//	vg^Cv錾
//============================================================================================
static void BoardMake( FIELDSYS_WORK * repw );
static void BoardDelete( FIELDSYS_WORK * repw );
static BOOL BoarsScroll_Up( FIELDSYS_WORK * repw );
static BOOL BoarsScroll_Down( FIELDSYS_WORK * repw );


//--------------------------------------------------------------------------------------------
/**
 * Ŕ[Nm
 *
 * @param	heap	q[vID
 *
 * @return	mۂ[N
 */
//--------------------------------------------------------------------------------------------
void * BoardWorkAlloc( u32 heap )
{
	void * buf = sys_AllocMemory( heap, sizeof(BOARD_WORK) );
	memset( buf, 0, sizeof(BOARD_WORK) );
	return buf;
}

//--------------------------------------------------------------------------------------------
/**
 * Ŕ[N
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BoardWorkDelete( BOARD_WORK * wk )
{
	if( wk->flg != 0 ){
		GF_BGL_BmpWinDel( &wk->win );
	}
	sys_FreeMemoryEz( wk );
}

//--------------------------------------------------------------------------------------------
/**
 * Ŕf[^Zbg
 *
 * @param	wk		[N
 * @param	type	Ŕ^Cv
 * @param	map		}bvIDiOtBbNIDj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BoardDataSet( BOARD_WORK * wk, u16 type, u16 map )
{
	wk->type = type;
	wk->map  = map;
}

//--------------------------------------------------------------------------------------------
/**
 * ŔNGXgs
 *
 * @param	wk		[N
 * @param	req		NGXg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BoardSetRequest( BOARD_WORK * wk, u8 req )
{
	wk->req = req;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FBMPEBhEf[^
 *
 * @param	wk		[N
 *
 * @return	BMPEBhEf[^
 */
//--------------------------------------------------------------------------------------------
GF_BGL_BMPWIN * BoardWinGet( BOARD_WORK * wk )
{
	return &wk->win;
}

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FŔ^Cv
 *
 * @param	wk		[N
 *
 * @return	Ŕ^Cv
 */
//--------------------------------------------------------------------------------------------
u8 BoardTypeGet( BOARD_WORK * wk )
{
	return wk->type;
}

//--------------------------------------------------------------------------------------------
/**
 * ŔI`FbN
 *
 * @param	wk		[N
 *
 * @retval	"TRUE = I"
 * @retval	"FALSE = 쒆"
 */
//--------------------------------------------------------------------------------------------
BOOL BoardReqEndCheck( BOARD_WORK * wk )
{
	if( wk->req == BOARD_REQ_WAIT ){
		return TRUE;
	}
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * ŔC
 *
 * @param	repw	tB[h[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BoardMain( FIELDSYS_WORK * repw )
{
	BOARD_WORK * wk = repw->board;

	switch( wk->req ){
	case BOARD_REQ_WAIT:	// ҋ@
		break;

	case BOARD_REQ_ADD:		// ŔEBhE쐬
		BoardMake( repw );
		wk->req = BOARD_REQ_WAIT;
		break;

	case BOARD_REQ_DOWN:	// ŔEBhE
		if( BoarsScroll_Down( repw ) == 1 ){
			wk->req = BOARD_REQ_WAIT;
		}
		break;

	case BOARD_REQ_UP:		// ŔEBhEグ
		if( BoarsScroll_Up( repw ) == 1 ){
			wk->req = BOARD_REQ_WAIT;
		}
		break;

	case BOARD_REQ_DEL:		// ŔEBhEj
		BoardDelete( repw );
		wk->req = BOARD_REQ_WAIT;
		break;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * NGXg𑦎s
 *
 * @param	repw	tB[h[N
 * @param	req		NGXg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void BoardSetDirect( FIELDSYS_WORK * repw, u8 req )
{
	BoardSetRequest( repw->board, req );
	BoardMain( repw );
}


//--------------------------------------------------------------------------------------------
/**
 * Ŕ쐬
 *
 * @param	repw	tB[h[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BoardMake( FIELDSYS_WORK * repw )
{
	GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_SET, BOARD_INIT_SCROLL_Y );

	// Ŕ쐬
	if( repw->board->flg == 0 ){
		FldBoardBmpAdd( repw->bgl, &repw->board->win, repw->board->type, FLD_MBGFRM_FONT );
		repw->board->flg = 1;
	}
	FldBoardWinPut( &repw->board->win, repw->board->type, repw->board->map );
}

//--------------------------------------------------------------------------------------------
/**
 * Ŕ폜
 *
 * @param	repw	tB[h[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BoardDelete( FIELDSYS_WORK * repw )
{
	if( repw->board->flg == 0 ){ return; }	// Ŕ쐬

	GF_BGL_BmpWinDel( &repw->board->win );
	GF_BGL_ScrFill(
		repw->bgl, FLD_MBGFRM_FONT, 0,
		BOARD_WIN_PX, BOARD_WIN_PY, BOARD_WIN_SX, BOARD_WIN_SY, GF_BGL_SCRWRT_PALNL );
	GF_BGL_LoadScreenReq( repw->bgl, FLD_MBGFRM_FONT );
	GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_SET, 0 );

	repw->board->flg = 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ŔXN[C
 *
 * @param	repw	tB[h[N
 *
 * @retval	"1 = I"
 * @retval	"0 = XN["
 */
//--------------------------------------------------------------------------------------------
static BOOL BoarsScroll_Up( FIELDSYS_WORK * repw )
{
	int	scroll = GF_BGL_ScrollGetY( repw->bgl, FLD_MBGFRM_FONT );

	if( scroll == 0 ){ return 1; }

	if( !( scroll > BOARD_INIT_SCROLL_Y && scroll < 0 ) ){
		GF_BGL_ScrollSet(
			repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_SET, BOARD_INIT_SCROLL_Y );
	}

	GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_INC, BOARD_SCROLL_VAL );

	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * ŔXN[AEg
 *
 * @param	repw	tB[h[N
 *
 * @retval	"1 = I"
 * @retval	"0 = XN["
 */
//--------------------------------------------------------------------------------------------
static BOOL BoarsScroll_Down( FIELDSYS_WORK * repw )
{
	int	scroll = GF_BGL_ScrollGetY( repw->bgl, FLD_MBGFRM_FONT );

	if( scroll == BOARD_INIT_SCROLL_Y ){
		GF_BGL_ScrFill(
			repw->bgl, FLD_MBGFRM_FONT, 0,
			BOARD_WIN_PX, BOARD_WIN_PY, BOARD_WIN_SX, BOARD_WIN_SY, GF_BGL_SCRWRT_PALNL );
		GF_BGL_LoadScreenReq( repw->bgl, FLD_MBGFRM_FONT );
		GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_SET, 0 );
		return 1;
	}

	if( !( scroll > BOARD_INIT_SCROLL_Y && scroll < 0 ) ){
		GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_SET, 0 );
	}

	GF_BGL_ScrollSet( repw->bgl, FLD_MBGFRM_FONT, GF_BGL_SCROLL_Y_DEC, BOARD_SCROLL_VAL );

	return 0;
}
