//============================================================================================
/**
 * @file	board.h
 * @brief	Ŕ
 * @author	Hiroyuki Nakamura
 * @date	2005.10.25
 */
//============================================================================================
#ifndef BOARD_H
#define BOARD_H
#undef GLOBAL
#ifdef BOARD_H_GLOBAL
#define GLOBAL	/*	*/
#else
#define GLOBAL	extern
#endif


//============================================================================================
//	萔`
//============================================================================================
#define	BOARD_REQ_WAIT	( 0 )	///< ŔNGXgFҋ@
#define	BOARD_REQ_ADD	( 1 )	///< ŔNGXgFŔEBhE쐬
#define	BOARD_REQ_DOWN	( 2 )	///< ŔNGXgFŔEBhE
#define	BOARD_REQ_UP	( 3 )	///< ŔNGXgFŔEBhEグ
#define	BOARD_REQ_DEL	( 4 )	///< ŔNGXgFŔEBhEj


#ifndef	__ASM_NO_DEF_	// ȍ~́AAZuł͖

typedef	struct _BOARD_WORK BOARD_WORK;


//============================================================================================
//	vg^Cv錾
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * Ŕ[Nm
 *
 * @param	heap	q[vID
 *
 * @return	mۂ[N
 */
//--------------------------------------------------------------------------------------------
GLOBAL void * BoardWorkAlloc( u32 heap );

//--------------------------------------------------------------------------------------------
/**
 * Ŕ[N
 *
 * @param	wk		[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BoardWorkDelete( BOARD_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * Ŕf[^Zbg
 *
 * @param	wk		[N
 * @param	type	Ŕ^Cv
 * @param	map		}bvIDiOtBbNIDj
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BoardDataSet( BOARD_WORK * wk, u16 type, u16 map );

//--------------------------------------------------------------------------------------------
/**
 * ŔNGXgs
 *
 * @param	wk		[N
 * @param	req		NGXg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BoardSetRequest( BOARD_WORK * wk, u8 req );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FBMPEBhEf[^
 *
 * @param	wk		[N
 *
 * @return	BMPEBhEf[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL GF_BGL_BMPWIN * BoardWinGet( BOARD_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * f[^擾FŔ^Cv
 *
 * @param	wk		[N
 *
 * @return	Ŕ^Cv
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 BoardTypeGet( BOARD_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ŔI`FbN
 *
 * @param	wk		[N
 *
 * @retval	"TRUE = I"
 * @retval	"FALSE = 쒆"
 */
//--------------------------------------------------------------------------------------------
GLOBAL BOOL BoardReqEndCheck( BOARD_WORK * wk );

//--------------------------------------------------------------------------------------------
/**
 * ŔC
 *
 * @param	repw	tB[h[N
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BoardMain( FIELDSYS_WORK * repw );

//--------------------------------------------------------------------------------------------
/**
 * NGXg𑦎s
 *
 * @param	repw	tB[h[N
 * @param	req		NGXg
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void BoardSetDirect( FIELDSYS_WORK * repw, u8 req );


#endif	__ASM_NO_DEF_

#undef GLOBAL
#endif	/* BOARD_H */
