//============================================================================================
/**
 * @file	btl_searcher.c
 * @bfief	ogT[`[
 * @author	Satoshi Nohara
 * @date	06.04.26
 */
//============================================================================================
#include "common.h"
#include "gflib/msg_print.h"

#include "system/lib_pack.h"
#include "system/snd_tool.h"

#include "fieldmap.h"
#include "fieldsys.h"
#include "zonedata.h"
#include "mapdefine.h"

#include "itemtool/itemsym.h"							//
#include "battle/trno_def.h"

#include "field/eventflag.h"							//
#include "field/evwkdef.h"								//

#include "script.h"										//
#include "syswork.h"
#include "sysflag.h"
#include "eventdata.h"
#include "fieldobj_code.h"
#include "btl_searcher.h"


//==============================================================================================
//
//	`
//
//==============================================================================================
//#define BS_LEVEL_MAX		(5)				//Đ̍ő僌x
#define BS_LEVEL_MAX		(6)				//Đ̍ő僌x

#define REMATCH_DATA_END	(0)				//Đf[^Ȃ
#define REMATCH_DATA_DUMMY	(0xffff)		//Đf[^_~[(̃xɂ悤ɂ)

#define	BS_RAND_NOSET		(50)			//TO̊mōĐg[i[ZbgȂ
#define	NOT_EXIST_OFS		(-1)			//Đf[^݂Ȃꍇ

//͈
#define BS_SEARCH_SX		(7)				//͈
#define BS_SEARCH_TOP		(7)				//͈(lʏ)
#define BS_SEARCH_BOTTOM	(6)				//͈(lʉ)

#define	BS_FLDOBJ_MAX		(64)			//FIELD_OBJ_PTR̍ő吔(vmFI)

//g[i[T[`gp`FbN
enum{
	BS_NO_BATTERY = 0,						//obe[܂ĂȂ
	BS_NO_TRAINER,							//ʓɃg[i[Ȃ
	BS_OK_BATTERY,							//obe[܂ĂāAʓɃg[i[
};

//V[PXio[`
enum{
	BS_SEQ_INIT = 0,
	BS_SEQ_START,
	BS_SEQ_OK_BATTERY,
	BS_SEQ_OK_BATTERY_ANM_WAIT,
	BS_SEQ_OK_BATTERY_LOTTERY,
	BS_SEQ_OK_BATTERY_LOTTERY_ANM_WAIT,
	BS_SEQ_NO_BATTERY,
	BS_SEQ_NO_TRAINER,
	BS_SEQ_EXIT,
};

//ZbgɂȂĂg[i[̃|C^擾鎞̃[h
#define BS_2VS2_MV_REWAR_CHK_ON		(0)		//Đ퓮R[h̃`FbN
#define BS_2VS2_MV_REWAR_CHK_OFF	(1)		//Đ퓮R[h̃`FbNȂ


//==============================================================================================
//
//	\
//
//==============================================================================================
//f[^\(btl_searcher.datŎgp)
typedef struct {
	u16 id[BS_LEVEL_MAX];					//ID
}REMATCH_DATA;
#include "../fielddata/btl_searcher/rematch.dat"

//VXe\
typedef struct{
	u32	seq;

	FIELDSYS_WORK* fsys;					//FIELDSYS_WORK^̃|C^
	EVENTWORK* ev;							//EVENTWORK^̃|C^

	const REMATCH_DATA* data;				//Đf[^̃|C^(rematch.dat)

	FIELD_OBJ_PTR fldobj[BS_FLDOBJ_MAX];	//

	u16	fldobj_max;							//ő吔
	u16 anm_count;							//Ajo^JEg

	u16* ret_wk;							//ʂԂ[Nւ̃|C^
	WORDSET* wordset;						//PZbg
}BS_SYS;

//Aj[VIĎ[N
typedef struct{
	TCB_PTR	tcb;					//TCB
	TCB_PTR	anm_tcb;				//Aj[VTCB
	BS_SYS* bs_sys;					//BS_SYS̃|C^
}BS_ANM_WORK;


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
void EventCmd_BtlSearcher(GMEVENT_CONTROL* event,WORDSET* wordset,u16* ret_wk);	//scrcmd.c
u16 BS_TrainerIDCheck( FIELDSYS_WORK* fsys, FIELD_OBJ_PTR fldobj, u16 tr_id );	//scrcmd.c
BOOL BS_StepCountUp( FIELDSYS_WORK* fsys );										//ev_check.c
static BOOL BS_HideMoveCodeCheck( u32 code );

static BOOL GMEVENT_StartBtlSearcher( GMEVENT_CONTROL* event );
static int BS_UseChk( BS_SYS* bs_sys );
static void BS_SeqChange( BS_SYS* bs_sys, u32 seq );
static void BS_FldObjDataSet( BS_SYS* bs_sys );

//Aj֘A
static void BS_FldObjAnmSet( BS_SYS* bs_sys );
static void BS_AnmSet( BS_SYS* bs_sys, FIELD_OBJ_PTR fldobj, const FIELD_OBJ_ACMD_LIST *list );
static void BS_AnmSetTCB( BS_SYS* bs_sys, TCB_PTR anm_tcb );
static void BS_AnmMainTCB( TCB_PTR tcb, void* wk );
static BOOL BS_AnmWait( BS_SYS* bs_sys );

static BOOL BS_Lottery( BS_SYS* bs_sys );
static u16 BS_TrainerIdGetByScriptId( FIELD_OBJ_PTR fldobj );

static void BS_RevengeMoveCodeClear( FIELDSYS_WORK* fsys );
static u16 BS_RevengeDataIndexGet( FIELDSYS_WORK* fsys, u16 tr_id );
static u16 BS_RevengeDataLevelGet( FIELDSYS_WORK* fsys, u16 index );
static u16 BS_RevengeDataLevelEventCheck( FIELDSYS_WORK* fsys, u16 index, u16 level );
static u16 BS_RevengeDataLevelEventCheckSub( u16 index, u16 level );
static u16 BS_RevengeTrainerIDGet( u16 index, u16 level );
static BOOL BS_RevengeMoveCodeCheck( FIELD_OBJ_PTR fldobj );
static void BS_MvSet( FIELD_OBJ_PTR fldobj, u16 code );
void BS_MvReWarClearDirMvSet( FIELDSYS_WORK* fsys, FIELD_OBJ_PTR fldobj );
static BOOL BS_StatusBitCheckMove( FIELDSYS_WORK* fsys );
static FIELD_OBJ_PTR BS_2vs2TrPtrGet( FIELDSYS_WORK* fsys, FIELD_OBJ_PTR search_obj, int mode );


//==============================================================================================
//
//	Aj[Vf[^
//
//==============================================================================================
//]Aj
static const FIELD_OBJ_ACMD_LIST ps_anm_1[] = {
	{ AC_STAY_WALK_D_8F, 1 },
	{ AC_WAIT_4F, 1 },
	{ AC_DIR_R, 1 },
	{ AC_WAIT_4F, 1 },
	{ AC_DIR_U, 1 },
	{ AC_WAIT_4F, 1 },
	{ AC_DIR_L, 1 },
	{ AC_WAIT_4F, 1 },
	{ AC_DIR_D, 1 },
	{ AC_WAIT_4F, 1 },
	{ ACMD_END, 0 },
};

//Đ\Aj
static const FIELD_OBJ_ACMD_LIST ps_anm_ok[] = {
	{ AC_DIR_D, 1 },
	{ AC_MARK_SAISEN, 1 },
	{ ACMD_END, 0 },
};

//킪܂Aj
static const FIELD_OBJ_ACMD_LIST ps_anm_first[] = {
	{ AC_MARK_GYOE, 1 },
	{ ACMD_END, 0 },
};

//ȂAj
static const FIELD_OBJ_ACMD_LIST ps_anm_ng[] = {
	{ AC_WAIT_8F, 1 },
	{ ACMD_END, 0 },
};


//==============================================================================================
//
//	ACegpŌĂ΂
//
//==============================================================================================

//----------------------------------------------------------------------------------------------
/**
 * CxgĂяo
 * 
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	wordset		WORDSET^̃|C^
 * @param	ret_wk		ʂԂ[Nւ̃|C^
 *
 * @retval	none
 */
//----------------------------------------------------------------------------------------------
void EventCmd_BtlSearcher( GMEVENT_CONTROL* event, WORDSET* wordset, u16* ret_wk )
{
	BS_SYS* bs_sys;
	FIELDSYS_WORK* fsys	= FieldEvent_GetFieldSysWork( event );

	//VXe[Nm
	bs_sys = sys_AllocMemory( HEAPID_FIELD, sizeof(BS_SYS) );
	if( bs_sys == NULL ){
		GF_ASSERT( (0) && "mێsI" );
		return;
	}

	//
	memset( bs_sys, 0, sizeof(BS_SYS) );
	bs_sys->fsys	= fsys;
	bs_sys->ev		= SaveData_GetEventWork( fsys->savedata );
	bs_sys->ret_wk	= ret_wk;
	bs_sys->wordset	= wordset;

	FieldEvent_Call( event, GMEVENT_StartBtlSearcher, bs_sys );
	return;
}

//----------------------------------------------------------------------------------------------
/**
 * CxgC
 * 
 * @param	event		Cxg䃏[Nւ̃|C^
 *
 * @retval	"FALSE=pATRUE=I"
 */
//----------------------------------------------------------------------------------------------
static BOOL GMEVENT_StartBtlSearcher( GMEVENT_CONTROL* event )
{
	s32 num,keta;
	int ret;
	BS_SYS* bs_sys = FieldEvent_GetSpecialWork( event );

	switch( bs_sys->seq ){

	//ObhɎ܂܂ő҂
	case BS_SEQ_INIT:
		if( BS_StatusBitCheckMove(bs_sys->fsys) == TRUE ){
			BS_SeqChange( bs_sys, BS_SEQ_START );
		}
		break;

	//Jn
	case BS_SEQ_START:

		//ʓɂg[i[̃f[^Zbg
		BS_FldObjDataSet( bs_sys );

		ret = BS_UseChk( bs_sys );

		//obe[܂ĂāAʓɃg[i[
		if( ret == BS_OK_BATTERY ){
			*bs_sys->ret_wk = 0;
			BS_SeqChange( bs_sys, BS_SEQ_OK_BATTERY );
		}else if( ret == BS_NO_BATTERY ){
			*bs_sys->ret_wk = 1;
			BS_SeqChange( bs_sys, BS_SEQ_NO_BATTERY );
		}else{
			*bs_sys->ret_wk = 2;
			BS_SeqChange( bs_sys, BS_SEQ_NO_TRAINER );
		}
		break;

	//obe[܂ĂāAʓɃg[i[
	case BS_SEQ_OK_BATTERY:
		Snd_SePlay( SE_BTL_SEARCHER );							//sbsbs
		SysWork_BtlSearcherBatterySet( bs_sys->ev, 0 );			//obe[NA
		//BS_FldObjAnmSet( bs_sys );							//]AjZbg
		BS_SeqChange( bs_sys, BS_SEQ_OK_BATTERY_ANM_WAIT );
		break;

	//g[i[̉]AjI҂
	case BS_SEQ_OK_BATTERY_ANM_WAIT:
		if( BS_AnmWait(bs_sys) == 0 ){
			BS_SeqChange( bs_sys, BS_SEQ_OK_BATTERY_LOTTERY );
		}
		break;

	//Đ̒Is
	case BS_SEQ_OK_BATTERY_LOTTERY:
		if( BS_Lottery(bs_sys) == 0 ){
			*bs_sys->ret_wk = 3;
		}
		BS_SeqChange( bs_sys, BS_SEQ_OK_BATTERY_LOTTERY_ANM_WAIT );
		break;

	//Đ\A܂AȂAj҂
	case BS_SEQ_OK_BATTERY_LOTTERY_ANM_WAIT:
		if( BS_AnmWait(bs_sys) == 0 ){
			BS_SeqChange( bs_sys, BS_SEQ_EXIT );
		}
		break;

	//obe[܂ĂȂ
	case BS_SEQ_NO_BATTERY:

		//Ȃobe[ʂobt@ɃZbg
		num = ( BS_BATTERY_MAX - SysWork_BtlSearcherBatteryGet(bs_sys->ev) );

		//擾
		if( (num / 10) == 0 ){
			keta = 1;
		}else if( (num / 100) == 0 ){
			keta = 2;
		}else{
			keta = 3;
		}

		WORDSET_RegisterNumber( bs_sys->wordset, 0, num, keta,
								NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT);

		BS_SeqChange( bs_sys, BS_SEQ_EXIT );
		break;

	//ʓɃg[i[Ȃ
	case BS_SEQ_NO_TRAINER:
		BS_SeqChange( bs_sys, BS_SEQ_EXIT );
		break;

	//I
	case BS_SEQ_EXIT:
		sys_FreeMemoryEz( bs_sys );
		return TRUE;
	};

	return FALSE;
}

//----------------------------------------------------------------------------------------------
/**
 * V[PXύX
 *
 * @param   bs_sys		BS_SYS^̃|C^
 * @param   seq			ZbgV[PX
 *
 * @retval	none
 */
//----------------------------------------------------------------------------------------------
static void BS_SeqChange( BS_SYS* bs_sys, u32 seq )
{
	bs_sys->seq = seq;
	return;
}

//----------------------------------------------------------------------------------------------
/**
 * ogT[`[gp`FbN
 *
 * @param   bs_sys		BS_SYS^̃|C^
 *
 * @retval	BS_NO_BATTERY	obe[܂ĂȂ
 * @retval	BS_NO_TRAINER	ʓɃg[i[Ȃ
 * @retval	BS_OK_BATTERY	obe[܂ĂāAʓɃg[i[
 */
//----------------------------------------------------------------------------------------------
static int BS_UseChk( BS_SYS* bs_sys )
{
	//obeJE^[܂Ă邩	
	if( SysWork_BtlSearcherBatteryGet(bs_sys->ev) == BS_BATTERY_MAX ){

		//ʓɃg[i[邩
		if( bs_sys->fldobj_max == 0 ){
			//ʓɃg[i[Ȃ
			return BS_NO_TRAINER;
		}

		//obe[܂ĂāAʓɃg[i[
		return BS_OK_BATTERY;
	}

	//obe[s
	return BS_NO_BATTERY;
}

//----------------------------------------------------------------------------------------------
/**
 * ogT[`[VXeɉʓɂg[i[̃f[^Zbg
 *
 * @param   bs_sys		BS_SYS^̃|C^
 *
 * @retval	none
 */
//----------------------------------------------------------------------------------------------
static void BS_FldObjDataSet( BS_SYS* bs_sys )
{
	int x,z;
	u32 event_type;

	int	hero_gx,hero_gz,i,count;
	int l,r,u,d;
	FIELD_OBJ_PTR fldobj;

	u32 obj_max = EventData_GetNpcCount( bs_sys->fsys );

	//
	count = 0;

	for( i=0; i < obj_max ;i++ ){
		bs_sys->fldobj[i] = NULL;
	}

	//l̈ʒu擾
	hero_gx = Player_NowGPosXGet( bs_sys->fsys->player );
	hero_gz = Player_NowGPosZGet( bs_sys->fsys->player );

	//͈͂Zbg(3D͈ӎ̊ȈՔ)
	l = hero_gx - BS_SEARCH_SX;
	r = hero_gx + BS_SEARCH_SX;
	u = hero_gz - BS_SEARCH_TOP;
	d = hero_gz + BS_SEARCH_BOTTOM;

	//␳
	if( l < 0 ){ l = 0; }
	//if( r < 0 ){ 0 };
	if( u < 0 ){ u = 0; }
	//if( d < 0 ){ 0 };

	//OBJf[^T[`
	for( i=0; i < obj_max ;i++ ){

		//tB[hOBJ̃|C^擾
		fldobj	= FieldOBJSys_OBJIDSearch( bs_sys->fsys->fldobjsys, i );
		if( fldobj == NULL ){
			continue;
		}

		//Cxg^Cvg[i[`FbN
		event_type = FieldOBJ_EventTypeGet( fldobj );

		switch( event_type ){
		case EV_TYPE_TRAINER:
		case EV_TYPE_TRAINER_EYEALL:
		case EV_TYPE_TRAINER_KYORO:
		case EV_TYPE_TRAINER_SPIN_STOP_L:
		case EV_TYPE_TRAINER_SPIN_STOP_R:
		case EV_TYPE_TRAINER_SPIN_MOVE_L:
		case EV_TYPE_TRAINER_SPIN_MOVE_R:

			//͈͓ɂ邩`FbN
			x = FieldOBJ_NowPosGX_Get( fldobj );
			z = FieldOBJ_NowPosGZ_Get( fldobj );
			if( (x >= l) && (x <= r) && (z >= u) && (z <= d) ){

				//R[hBꖪ`FbN
				if( BS_HideMoveCodeCheck(FieldOBJ_MoveCodeGet(fldobj)) == FALSE ){
					//OS_Printf( "id = %d\n", i );
					//OS_Printf( "event_type = %d\n", event_type );

					//VXe[NɃZbg
					bs_sys->fldobj[count] = fldobj;
					count++;
				}
			}
		};
	}

	bs_sys->fldobj_max = count;
	return;
}

//----------------------------------------------------------------------------------------------
/**
 * R[hBꖪ`FbN
 *
 * @param   code	R[h
 *
 * @retval	"FALSE=ႤATRUE=Bꖪ"
 */
//----------------------------------------------------------------------------------------------
static BOOL BS_HideMoveCodeCheck( u32 code )
{
	switch( code ){
	case MV_HIDE_SNOW:		//Bꖪ@
	case MV_HIDE_SAND:		//Bꖪ@
	case MV_HIDE_GRND:		//Bꖪ@y
	case MV_HIDE_KUSA:		//Bꖪ@
		return TRUE;
	};

	return FALSE;
}


//==============================================================================================
//
//	ړŌĂ΂(ev_check.c)
//
//==============================================================================================

//----------------------------------------------------------------------------------------------
/**
 * JEg
 *
 * @param   fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	"FALSE	Ȃ"
 */
//----------------------------------------------------------------------------------------------
BOOL BS_StepCountUp( FIELDSYS_WORK* fsys )
{
	EVENTWORK* ev		= SaveData_GetEventWork( fsys->savedata );
	u16 battery_count	= SysWork_BtlSearcherBatteryGet( ev );
	u16 clear_count		= SysWork_BtlSearcherClearGet( ev );

	//ogT[`[Ă
	if( MyItem_CheckItem( SaveData_GetMyItem(fsys->savedata),
							ITEM_BATORUSAATYAA,1,HEAPID_FIELD) == TRUE ){

		//obe[𒙂߂
		if( battery_count < BS_BATTERY_MAX ) {
			battery_count++;
			SysWork_BtlSearcherBatterySet( ev, battery_count );
		}
	}

	//obe[gpĂ
	if( SysFlag_BtlSearcherUseCheck(ev) == TRUE ){

		//NAJE^[܂ĂȂ
		if( clear_count < BS_CLEAR_MAX ){
			clear_count++;
			SysWork_BtlSearcherClearSet( ev, clear_count );
		}
		
		//NAJE^[܂Ă
		if( clear_count == BS_CLEAR_MAX ){
			Sys_BtlSearcherReset( ev );					//sys_work.c
			BS_RevengeMoveCodeClear( fsys );			//Đ퓮R[hNA
		}
	}

	//OS_Printf( "battery_count = %d\n", battery_count );
	//OS_Printf( "clear_count = %d\n", clear_count );
	return FALSE;		//Ȃ
}

//----------------------------------------------------------------------------------------------
/**
 * Đ퓮R[hNA
 *
 * @param   fsys		FIELDSYS_WORK^̃|C^
 *
 * @retval  none
 */
//----------------------------------------------------------------------------------------------
static void BS_RevengeMoveCodeClear( FIELDSYS_WORK* fsys )
{
	int i;
	FIELD_OBJ_PTR fldobj;
	u32 obj_max = EventData_GetNpcCount( fsys );

	//OBJf[^T[`
	for( i=0; i < obj_max ;i++ ){

		//tB[hOBJ̃|C^擾
		fldobj	= FieldOBJSys_OBJIDSearch( fsys->fldobjsys, i );
		if( fldobj == NULL ){
			continue;
		}

		//R[hĐ킩`FbN
		if( FieldOBJ_MoveCodeGet(fldobj) == MV_REWAR ){
			BS_MvSet( fldobj, MV_DIR_RND );		//u_ɕؑցvɕύX
		}
	}

	return;
}


//==============================================================================================
//
//	Aj֘A
//
//==============================================================================================

//----------------------------------------------------------------------------------------------
/**
 * tB[hOBJ̃AjZbg
 *
 * @param   bs_sys		BS_SYS^̃|C^
 *
 * @retval	none
 */
//----------------------------------------------------------------------------------------------
static void BS_FldObjAnmSet( BS_SYS* bs_sys )
{
	int i;

	for( i=0; i < bs_sys->fldobj_max ;i++ ){
		BS_AnmSet( bs_sys, bs_sys->fldobj[i], ps_anm_1 );		//]AjZbg
	}

	return;
}

//----------------------------------------------------------------------------------------------
/**
 * AjZbg
 *
 * @param   bs_sys		BS_SYS^̃|C^
 * @param   fldobj		FIELD_OBJ_PTR
 *
 * @retval	none
 */
//----------------------------------------------------------------------------------------------
static void BS_AnmSet( BS_SYS* bs_sys, FIELD_OBJ_PTR fldobj, const FIELD_OBJ_ACMD_LIST *list )
{
	TCB_PTR anm_tcb;

	//Aj[VR}hXgZbg
	anm_tcb = FieldOBJ_AcmdListSet( fldobj, list );

	//Aj[V̐𑫂
	bs_sys->anm_count++;

	BS_AnmSetTCB( bs_sys, anm_tcb );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	AjIĎTCB Zbg
 *
 * @param	bs_sys	BS_SYS^̃|C^
 * @param	anm_tcb	TCB_PTR^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void BS_AnmSetTCB( BS_SYS* bs_sys, TCB_PTR anm_tcb )
{
	BS_ANM_WORK* ps_anm_wk = NULL;

	ps_anm_wk = sys_AllocMemory( HEAPID_FIELD, sizeof(BS_ANM_WORK) );
	if( ps_anm_wk == NULL ){
		GF_ASSERT( (0) && "scrcmd.c mێsI" );
		return;
	}

	ps_anm_wk->bs_sys	= bs_sys;
	ps_anm_wk->anm_tcb	= anm_tcb;
	ps_anm_wk->tcb		= TCB_Add( BS_AnmMainTCB, ps_anm_wk, 0 );
	return;
}

//----------------------------------------------------------------------------------------------
/**
 * @brief	AjIĎTCB C
 *
 * @param	tcb		TCB_PTR
 * @param	wk		[ÑAhX
 *
 * @retval	none
 */
//----------------------------------------------------------------------------------------------
static void BS_AnmMainTCB( TCB_PTR tcb, void* wk )
{
	BS_ANM_WORK *swk = (BS_ANM_WORK *)wk;

	//IĂ
	if( FieldOBJ_AcmdListEndCheck( swk->anm_tcb ) == TRUE ){

		//Aj[V̊Ǘ
		if( swk->bs_sys->anm_count == 0 ){
			GF_ASSERT( (0) && "Aj[V̊ǗsłI" );
		}

		swk->bs_sys->anm_count--;

		FieldOBJ_AcmdListEnd( swk->anm_tcb );

		TCB_Delete( swk->tcb );
		sys_FreeMemory( HEAPID_FIELD, wk );
	}

	return;
}

//----------------------------------------------------------------------------------------------
/**
 * @brief	AjI`FbN
 *
 * @param	tcb		TCB_PTR
 * @param	wk		[ÑAhX
 *
 * @retval	"0=IA1=p"
 */
//----------------------------------------------------------------------------------------------
static BOOL BS_AnmWait( BS_SYS* bs_sys )
{
	return bs_sys->anm_count;
}


//==============================================================================================
//
//	I֘A
//
//==============================================================================================

//----------------------------------------------------------------------------------------------
/**
 * ĐԂɂ邩̒Is
 *
 * @param   bs_sys		BS_SYS^̃|C^
 *
 * @retval	"0 = Pl킦Ԃ̃g[i[ȂA1 = 킦Ԃ̃g[i["
 */
//----------------------------------------------------------------------------------------------
static BOOL BS_Lottery( BS_SYS* bs_sys )
{
	EVENTWORK* ev = SaveData_GetEventWork( bs_sys->fsys->savedata );
	FIELD_OBJ_PTR tr_2vs2;
	u16 tr_id;
	int i,flag;

	flag = 0;	//ĐɂȂg[i[tO

	for( i=0; i < bs_sys->fldobj_max ;i++ ){

		//g[i[IDɏĂ邩`FbN
		tr_id = BS_TrainerIdGetByScriptId( bs_sys->fldobj[i] );
		if( CheckEventFlagTrainer(bs_sys->fsys, tr_id) == FALSE ){		//ĂȂ
			BS_AnmSet( bs_sys, bs_sys->fldobj[i], ps_anm_first );		//܂AjZbg
			//Snd_SePlay( SE_MARK_GYOE );
			flag = 1;
		}else{

			//TO̊mōĐg[i[ɂȂ
			//R[hĐɂȂĂȂ(2vs2͍ĐɂȂĂ邱Ƃ)
			//gf_srand( sys.vsync_counter );
			if( ((gf_rand() % 100) < BS_RAND_NOSET) && 
				(BS_RevengeMoveCodeCheck(bs_sys->fldobj[i]) == FALSE) ){

				BS_MvSet( bs_sys->fldobj[i], MV_REWAR );				//Đ퓮R[hɕύX
				BS_AnmSet( bs_sys, bs_sys->fldobj[i], ps_anm_ok );		//Đ\AjZbg

#if 1
				//ZbgɂȂĂg[i[̃|C^擾čĐZbg
				tr_2vs2 = BS_2vs2TrPtrGet(bs_sys->fsys, bs_sys->fldobj[i], BS_2VS2_MV_REWAR_CHK_ON);
				if( tr_2vs2 != NULL ){
					BS_MvSet( tr_2vs2, MV_REWAR );						//Đ퓮R[hɕύX
					BS_AnmSet( bs_sys, tr_2vs2, ps_anm_ok );			//Đ\AjZbg
				}
#endif

				//Snd_SePlay( SE_MARK_GYOE );
				flag = 1;
				SysFlag_BtlSearcherUseSet( ev );
			
			//Đg[i[ɂȂȂ
			}else{
				//BS_MvSet( bs_sys->fldobj[i], MV_DOWN );				//ʌŒɕύX
				//BS_AnmSet( bs_sys, bs_sys->fldobj[i], ps_anm_ng );	//ȂAjZbg
			}
		}
	}

	return flag;
}

//----------------------------------------------------------------------------------------------
/**
 * XNvgIDAg[i[ID擾
 *
 * @param   fldobj		FIELD_OBJ_PTR
 *
 * @retval  "g[i[ID"
 */
//----------------------------------------------------------------------------------------------
static u16 BS_TrainerIdGetByScriptId( FIELD_OBJ_PTR fldobj )
{
	u32 script_id = FieldOBJ_EventIDGet( fldobj );
	return GetTrainerIdByScriptId( script_id );
}


//==============================================================================================
//
//	g[i[b֘A(trainer.ev)
//
//==============================================================================================

//----------------------------------------------------------------------------------------------
/**
 * FIELD_OBJ_PTR̍Đg[i[ID擾
 *
 * @param   fsys		FIELDSYS_WORK^̃|C^
 * @param   fldobj		FIELD_OBJ_PTR
 * @param   tr_id		g[i[ID
 *
 * @retval  "0 = f[^ȂA0ȊO = g[i[ID"
 *
 * @li		"g[i[ID = 0 = "ƂĈĂ(Đf[^e[uɊ܂܂ĂȂ̂OK)
 */
//----------------------------------------------------------------------------------------------
u16 BS_TrainerIDCheck( FIELDSYS_WORK* fsys, FIELD_OBJ_PTR fldobj, u16 tr_id )
{
	u16 index,level,ret;

	//Đ퓮R[h`FbN
	if( BS_RevengeMoveCodeCheck(fldobj) == FALSE ){
		return 0;
	}

	//f[^CfbNX擾
	index = BS_RevengeDataIndexGet( fsys, tr_id );
	if( index == 0xff ){
		return 0;
	}

	//f[^x擾
	level = BS_RevengeDataLevelGet( fsys, index );
	//OS_Printf( "level = %d\n", level );

	//Cxgis`FbNɂčĐ탌x𒲐
	level = BS_RevengeDataLevelEventCheck( fsys, index, level );
	//OS_Printf( "level = %d\n", level );

	//Đg[i[ID擾
	ret = BS_RevengeTrainerIDGet( index, level );
	//OS_Printf( "ret = %d\n", ret );

	return ret;
}

//----------------------------------------------------------------------------------------------
/**
 * Đf[^e[ũCfbNX擾
 *
 * @param   fsys		FIELDSYS_WORK^̃|C^
 * @param   tr_id		g[i[ID
 *
 * @retval  "0xffȊO = CfbNXA0xff = Ȃ"
 */
//----------------------------------------------------------------------------------------------
static u16 BS_RevengeDataIndexGet( FIELDSYS_WORK* fsys, u16 tr_id )
{
	int i,level;
	//REMATCH_DATA* data = bs_sys->data;
	const REMATCH_DATA* data = RematchDataTbl;

	//Đg[i[f[^
	for( i=0; i < REMATCH_DATA_MAX; i++ ){

		//g[i[IDT
		if( data[i].id[0] != tr_id ){
			continue;
		}

		//g[i[ID
		return i;
	}

	return 0xff;
}

//----------------------------------------------------------------------------------------------
/**
 * Đ탌x擾
 *
 * @param   fsys		FIELDSYS_WORK^̃|C^
 * @param   index		Đf[^e[ũCfbNX
 *
 * @retval  "x"
 */
//----------------------------------------------------------------------------------------------
static u16 BS_RevengeDataLevelGet( FIELDSYS_WORK* fsys, u16 index )
{
	int i,level;
	//REMATCH_DATA* data = bs_sys->data;
	const REMATCH_DATA* data = RematchDataTbl;

	//Đ탌x
	for( level = 1; level < BS_LEVEL_MAX; level++ ){

		//Đf[^Ȃ`FbN
		if( data[index].id[level] == REMATCH_DATA_END ){
			return (level - 1);
		}

		//Đf[^_~[`FbN
		if( data[index].id[level] != REMATCH_DATA_DUMMY ){

			//̃x͑ΐ킵ĂȂ`FbN
			if( CheckEventFlagTrainer(fsys, data[index].id[level]) == FALSE ){
				return (level);
			}
		}
	}

	//xō
	return (level - 1);
}

//----------------------------------------------------------------------------------------------
/**
 * Cxgis`FbNɂčĐ탌x𒲐
 *
 * @param   fsys	FIELDSYS_WORK^̃|C^
 * @param   index	Đf[^e[ũCfbNX
 * @param   level	Đ탌x
 *
 * @retval	"̍Đx"
 *
 * is`FbN͂܂Ȃ̂ŉłI
 */
//----------------------------------------------------------------------------------------------
static u16 BS_RevengeDataLevelEventCheck( FIELDSYS_WORK* fsys, u16 index, u16 level )
{
	EVENTWORK* ev = SaveData_GetEventWork( fsys->savedata );
	u16 ret = level;

	switch( level ){

	case 0:
		break;

	default:

		if( SysFlag_BsLvCheck(ev,level) == FALSE ){
			ret = BS_RevengeDataLevelEventCheckSub( index, level );
		}
		break;

	};

	return ret;
}

//----------------------------------------------------------------------------------------------
/**
 * REMATCH_DATA_DUMMY`FbNčĐ탌x
 *
 * @param   index	Đf[^e[ũCfbNX
 * @param   level	Đ탌x
 *
 * @retval	"̍Đx"
 */
//----------------------------------------------------------------------------------------------
static u16 BS_RevengeDataLevelEventCheckSub( u16 index, u16 level )
{
	u16 i;
	const REMATCH_DATA* data = RematchDataTbl;

	//Đf[^_~[`FbN
	for( i=(level-1); i > 0; i-- ){

		if( data[index].id[i] != REMATCH_DATA_DUMMY ){
			return i;
		}
	}

	return 0;			//x0
}

//----------------------------------------------------------------------------------------------
/**
 * Đg[i[ID擾
 *
 * @param   index			Đf[^e[ũCfbNX
 * @param   level			Đf[^e[ũx
 *
 * @retval  "Đg[i[ID"
 */
//----------------------------------------------------------------------------------------------
static u16 BS_RevengeTrainerIDGet( u16 index, u16 level )
{
	//REMATCH_DATA* data = bs_sys->data;
	const REMATCH_DATA* data = RematchDataTbl;
	return data[index].id[level];
}

//----------------------------------------------------------------------------------------------
/**
 * Đ퓮R[h`FbN
 *
 * @param   fldobj		FIELD_OBJ_PTR
 *
 * @retval  "TRUE = Đ퓮R[hAFALSE = "
 */
//----------------------------------------------------------------------------------------------
static BOOL BS_RevengeMoveCodeCheck( FIELD_OBJ_PTR fldobj )
{
	//OS_Printf( "mv_code = %d\n", FieldOBJ_MoveCodeGet(fldobj) );
	//OS_Printf( "obj_id = %d\n", FieldOBJ_OBJIDGet(fldobj) );

	if( FieldOBJ_MoveCodeGet(fldobj) == MV_REWAR ){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------------------------
/**
 * R[hZbg
 *
 * @param   fldobj		FIELD_OBJ_PTR
 * @param   code		R[h
 *
 * @retval  none
 */
//----------------------------------------------------------------------------------------------
static void BS_MvSet( FIELD_OBJ_PTR fldobj, u16 code )
{
	//FieldOBJ_MoveCodeSet( fldobj, code );
	FieldOBJ_MoveCodeChange( fldobj, code );
	return;
}

//----------------------------------------------------------------------------------------------
/**
 * Đ퓮R[hA݌ĂŒ̓R[hZbg(퓬ɌĂ΂)
 *
 * @param   fldobj		FIELD_OBJ_PTR
 *
 * @retval  none
 */
//----------------------------------------------------------------------------------------------
void BS_MvReWarClearDirMvSet( FIELDSYS_WORK* fsys, FIELD_OBJ_PTR fldobj )
{
	FIELD_OBJ_PTR tr_2vs2;
	u32 code;
	int dir;
	
	//s`FbN
	if( fldobj == NULL ){
		return;
	}

#if 0
	//R[hĐ킩`FbN
	if( FieldOBJ_MoveCodeGet(fldobj) != MV_REWAR ){
		return;
	}
#endif

	//\擾
	dir = FieldOBJ_DirDispGet( fldobj );

	if( dir == DIR_UP ){
		code = MV_UP;
	}else if( dir == DIR_DOWN ){
		code = MV_DOWN;
	}else if( dir == DIR_LEFT ){
		code = MV_LEFT;
	}else{
		code = MV_RIGHT;
	}

#if 1
	//2vs2̎̓ZbgɂȂĂg[i[̓R[hƂKvI
	tr_2vs2 = BS_2vs2TrPtrGet( fsys, fldobj, BS_2VS2_MV_REWAR_CHK_OFF );
	if( tr_2vs2 != NULL ){
		BS_MvSet( tr_2vs2, code );
	}
#endif

	BS_MvSet( fldobj, code );
	return;
}


//==============================================================================================
//
//	`FbN
//
//==============================================================================================

//----------------------------------------------------------------------------------------------
/**
 * ObhɎ܂܂ő҂
 *
 * @param   fsys		FIELDSYS_WORK^̃|C^
 *
 * @retval  "TRUE = IAFALSE = ړ"
 */
//----------------------------------------------------------------------------------------------
static BOOL BS_StatusBitCheckMove( FIELDSYS_WORK* fsys )
{
	int i,flag;
	FIELD_OBJ_PTR fldobj;
	u32 obj_max = EventData_GetNpcCount( fsys );

	flag = 0;	//NA

	//OS_Printf( "*******Obh`FbN*******\n" );

	//OBJf[^T[`
	for( i=0; i < obj_max ;i++ ){

		//tB[hOBJ̃|C^擾
		fldobj	= FieldOBJSys_OBJIDSearch( fsys->fldobjsys, i );
		if( fldobj == NULL ){
			continue;
		}

		//ړ쒆`FbN
		if( FieldOBJ_StatusBitCheck_Move(fldobj) == TRUE ){
			//OS_Printf( "no = %d = 쒆\n", i );
			FieldOBJ_MovePauseClear( fldobj );
			flag = 1;							//IĂȂ̂ŃtOON
		}else{
			//OS_Printf( "no = %d = I\n", i );
			FieldOBJ_MovePause( fldobj );		//|[Y
		}
	}

	if( flag == 0 ){
		return TRUE;
	}else{
		return FALSE;
	}
}

//----------------------------------------------------------------------------------------------
/**
 * ZbgɂȂĂg[i[̃|C^擾
 *
 * @param   fsys			FIELDSYS_WORK^̃|C^
 * @param   search_scr_id	T[`XNvgID
 * @param   search_tr_id	T[`g[i[ID
 *
 * @retval "NULL=ȂANULLȊO=Zbg̃g[i[FIELD_OBJ_PTR"
 *
 * [h
 * BS_2VS2_MV_REWAR_CHK_ON		(0)		//Đ퓮R[h̃`FbN
 * BS_2VS2_MV_REWAR_CHK_OFF		(1)		//Đ퓮R[h̃`FbNȂ
 */
//----------------------------------------------------------------------------------------------
static FIELD_OBJ_PTR BS_2vs2TrPtrGet( FIELDSYS_WORK* fsys, FIELD_OBJ_PTR search_obj, int mode )
{
	FIELD_OBJ_PTR fldobj;
	u32 i,event_type,scr_id,tr_id;
	u32 obj_max			= EventData_GetNpcCount( fsys );
	u16 search_scr_id	= FieldOBJ_EventIDGet( search_obj );			//XNvgID擾
	u16 search_tr_id	= GetTrainerIdByScriptId( search_scr_id );		//g[i[ID擾

	//VOog^Cv͉̎ȂI
	if( CheckTrainer2vs2Type(search_tr_id) == 0 ){
		return NULL;
	}

	//oq̕Е͈͂ɓĂȂ̂ŁA][ST[`I
	for( i=0; i < obj_max ;i++ ){

		//tB[hOBJ̃|C^擾
		fldobj	= FieldOBJSys_OBJIDSearch( fsys->fldobjsys, i );
		if( fldobj == NULL ){
			continue;
		}

#if 1
		if(  mode == BS_2VS2_MV_REWAR_CHK_ON ){			//Đ퓮R[h̃`FbN

			//R[hĐɂȂĂOBJ͉Ȃ
			if( FieldOBJ_MoveCodeGet(fldobj) == MV_REWAR ){
				continue;
			}
		}
#endif

		//Cxg^Cvg[i[`FbN
		event_type = FieldOBJ_EventTypeGet( fldobj );

		switch( event_type ){
		case EV_TYPE_TRAINER:
		case EV_TYPE_TRAINER_EYEALL:
		case EV_TYPE_TRAINER_KYORO:
		case EV_TYPE_TRAINER_SPIN_STOP_L:
		case EV_TYPE_TRAINER_SPIN_STOP_R:
		case EV_TYPE_TRAINER_SPIN_MOVE_L:
		case EV_TYPE_TRAINER_SPIN_MOVE_R:

			//OS_Printf( "id = %d\n", i );
			//OS_Printf( "event_type = %d\n", event_type );

			scr_id	= FieldOBJ_EventIDGet( fldobj );			//XNvgID擾
			tr_id	= GetTrainerIdByScriptId( scr_id );			//g[i[ID擾

			//XNvgIDł͂ȂAg[i[IDɂȂĂg[i[T
			if( (search_scr_id != scr_id) && (search_tr_id == tr_id) ){
				return fldobj;	//I
			}
		};
	}

	return NULL;
}




