//============================================================================================
/**
 * @file	calendar_enc.c
 * @brief	J_[݂̃GJEg
 * @author	Nozomu Saito
 * @date	2006.05.16
 */
//============================================================================================
#include "common.h"
#include "system/pm_rtc.h"

#include "calendar_enc.h"

#define DAY_DATA(day,prob_no)		( (day<<8) | (prob_no&0xff) )
#define GET_DAY(data)				( (data>>8)&0xff )
#define GET_PROB_NO(data)			( data&0xff )

enum {
	JAN_DAT_MAX = 4,
	FEB_DAT_MAX = 4,
	MAR_DAT_MAX = 4,
	APR_DAT_MAX = 3,
	MAY_DAT_MAX = 6,
	JUN_DAT_MAX = 2,
	JUL_DAT_MAX = 4,
	AUG_DAT_MAX = 7,
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/07
// GJEg̓t911O
	SEP_DAT_MAX = 3,
// ----------------------------------------------------------------------------
	OCT_DAT_MAX = 4,
	NOV_DAT_MAX = 5,
	DEC_DAT_MAX = 7,
};

#define MONTH_NUM	(12)


typedef u16 CAL_ENC_DAY_DATA;

//1
static const CAL_ENC_DAY_DATA JanData[JAN_DAT_MAX] = {
	DAY_DATA( 1,3),			//U		New Year's DayikāECMEC^EXEtEhj
	DAY_DATA( 6,2),			//			̏jiC^jE匰߁iXjEOihj
	DAY_DATA(11,2),			//J
	DAY_DATA(12,4)			//o^Cf[	Valentine's Dayikāj
};

//2
static const CAL_ENC_DAY_DATA FebData[FEB_DAT_MAX] = {
	DAY_DATA( 3,2),			//ߕ
	DAY_DATA(11,2),			//LO
	DAY_DATA(12,2),			//			J[̒aikāj
	DAY_DATA(14,0)			//
};

//3
static const CAL_ENC_DAY_DATA MarData[MAR_DAT_MAX] = {
	DAY_DATA( 3,2),			//ЂȍՂ
	DAY_DATA(17,2),			//			ZgpgbN̓ikāj
	DAY_DATA(21,3),			//t̓
	DAY_DATA(25,2)			//			jiXj
};

//4
static const CAL_ENC_DAY_DATA AprData[APR_DAT_MAX] = {
	DAY_DATA( 1,2),			//w
	DAY_DATA(25,2),			//			C^ALOiC^j
	DAY_DATA(29,2),			//݂ǂ̓
};

//5
static const CAL_ENC_DAY_DATA MayData[MAY_DAT_MAX] = {
	DAY_DATA( 1,0),			//lx		[f[(܌)ikāECMEC^EXEtEhj
	DAY_DATA( 3,2),			//@LO
	DAY_DATA( 4,0),			//̋x
	DAY_DATA( 5,2),			//ǂ̓
	DAY_DATA( 8,2),			//			񎟑ILOitj
	DAY_DATA(29,2),			//			zCbg}f[iCMj
};

//6
static const CAL_ENC_DAY_DATA JunData[JUN_DAT_MAX] = {
	DAY_DATA( 2,2),			//			aLOiC^j
	DAY_DATA(21,2),			//DUMMY
};

//7
static const CAL_ENC_DAY_DATA JulData[JUL_DAT_MAX] = {
	DAY_DATA( 4,2),			//			ƗLOikāj
	DAY_DATA( 7,4),			//[
	DAY_DATA(14,2),			//			vLO(p)itj
	DAY_DATA(24,2)			//DUMMY
};

//8
static const CAL_ENC_DAY_DATA AugData[AUG_DAT_MAX] = {
	DAY_DATA( 6,3),			//L
	DAY_DATA( 9,3),			//茴
	DAY_DATA(13,1),			//~
	DAY_DATA(14,1),			//~
	DAY_DATA(15,2),			//~EILO	폸VՁiC^EXjEꏸՁitjE}AVՁihj
	DAY_DATA(16,1),			//~
	DAY_DATA(28,2),			//			T}[oNzf[iCMj
};

//9
static const CAL_ENC_DAY_DATA SepData[SEP_DAT_MAX] = {
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2006/11/07
// GJEg̓t911O
// ----------------------------------------------------------------------------
	DAY_DATA(15,2),			//\ܖ
	DAY_DATA(20,2),			//
	DAY_DATA(23,3)			//H̓
};

//10
static const CAL_ENC_DAY_DATA OctData[OCT_DAT_MAX] = {
	DAY_DATA( 3,2),			//			hCc̓ihj
	DAY_DATA(12,2),			//			CXpjAf[iXj
	DAY_DATA(30,2),			//
	DAY_DATA(31,0)			//			nEB[ikājE@vLOihj
};

//11
static const CAL_ENC_DAY_DATA NovData[NOV_DAT_MAX] = {
	DAY_DATA( 1,2),			//			l̓iC^EXyEhjEl̏jitj
	DAY_DATA( 3,1),			//̓
	DAY_DATA(11,2),			//			ޖRl̓ikājEꎟxLOitj
	DAY_DATA(16,2),			//			܍߂̓ihj
	DAY_DATA(23,0)			//ΘJӂ̓
};

//12
static const CAL_ENC_DAY_DATA DecData[DEC_DAT_MAX] = {
	DAY_DATA( 6,2),			//			@̓iXj
	DAY_DATA( 8,2),			//			ꖳ߂̌h̓iC^jEق̓iXjEꖳCٍՁihj
	DAY_DATA(23,2),			//Vca
	DAY_DATA(24,2),			//NX}XCu	NX}XikāECMEC^EXEtEhj
	DAY_DATA(25,1),			//NX}X	NX}XikāECMEC^EXEtEhj
	DAY_DATA(26,0),			//			{NVOf[iCMjEXe[t@m̓iC^j
	DAY_DATA(31,1),			//A
};

typedef struct CAL_ENC_MONTH_DATA_tag{
	int Num;
	const CAL_ENC_DAY_DATA *DayData;
}CAL_ENC_MONTH_DATA;


static const CAL_ENC_MONTH_DATA CalEncMonthData[MONTH_NUM] = {
	{JAN_DAT_MAX,JanData},{FEB_DAT_MAX,FebData},{MAR_DAT_MAX,MarData},
	{APR_DAT_MAX,AprData},{MAY_DAT_MAX,MayData},{JUN_DAT_MAX,JunData},
	{JUL_DAT_MAX,JulData},{AUG_DAT_MAX,AugData},{SEP_DAT_MAX,SepData},
	{OCT_DAT_MAX,OctData},{NOV_DAT_MAX,NovData},{DEC_DAT_MAX,DecData}
};

static const int ProbTbl[] = 
{
	0,-5,5,-10,10
};
/**
static void DebugPrint(void);
*/
//-----------------------------------------------------------------------------
/**
 * ɂɂmvZ
 *
 * @param	inProb			݃GJEgm
 * @param	inPenalty		yieB[
 *
 * @return	int				GJEgm
 */
//-----------------------------------------------------------------------------
int CalEnc_GetProb(const int inProb, const BOOL inPenalty)
{
	u8 i;
	int prob;
	RTCDate date;
	const CAL_ENC_MONTH_DATA * data;

	//ԕsύXꂽꍇ́AȂ
	if (inPenalty){
		return inProb;
	}
	
	if (inProb == 0){
		return 0;
	}

//	DebugPrint();
	
	GF_RTC_GetDate(&date);

	GF_ASSERT(date.month>0);
	GF_ASSERT(date.month<=12);

	data = &(CalEncMonthData[date.month-1]);

	for(i=0;i<data->Num;i++){
		if ( date.day == GET_DAY(data->DayData[i]) ){
			prob = inProb + ProbTbl[ GET_PROB_NO(data->DayData[i]) ];
			if (prob < 0){
				prob = 1;
			}
			return prob;
		}
	}
	return inProb;
}

/**
static void DebugPrint(void)
{
	int i,j;
	const CAL_ENC_MONTH_DATA * data;
	for(j=0;j<MONTH_NUM;j++){
		data = &(CalEncMonthData[j]);
		OS_Printf("Month:%d DayNum:%d\n",j+1,data->Num);
		for(i=0;i<data->Num;i++){
			OS_Printf(" Day:%d Prob:%d\n",GET_DAY(data->DayData[i]),GET_PROB_NO(data->DayData[i]));
		}
	}
}
*/
