//=============================================================================
/**
 * @file	comm_field_state.c
 * @brief	ʐMԂǗT[rX  ʐM̏ʂɂ
 *          XbĥЂƂƂēA̒ʐMԂ⑼̋@
 *          JnIǗ
 *          tB[hŒڊǗ̂communicationfieldɈړ 2005.09.28
 * @author	Katsumi Ohno
 * @date    2005.08.02
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "system/gamedata.h"
#include "system/pm_str.h"

#include "comm_field_state.h"
#include "underground/ug_manager.h"
#include "field/field.h"
#include "fieldsys.h"
#include "comm_command_field.h"
#include "comm_direct_counter.h"
#include "comm_vsroom.h"
#include "sysflag.h"

#include "script.h"							//StartFieldScript
#include "..\fielddata\script\common_scr_def.h"		//SCRID_TRAINER_MOVE_SCRIPT
#include "..\fielddata\script\connect_def.h"		//SCRID_CONNECT_COLOSSEUM
#include "../fielddata/script/battle_room_def.h"
#include "savedata/trainercard_data.h"
#include "application/trainer_card.h"
#include "tr_card_setup.h"
#include "system/wipe.h"
#include "system/pm_overlay.h"
#include "system/brightness.h"

#include "field/union_beacon_tool.h"
#include "field_encount.h"

#ifdef PM_DEBUG
#include "d_ohno.h"
#include "fld_debug.h"
#endif
//==============================================================================
//	^錾
//==============================================================================
// R[obN֐̏
typedef void (*PTRStateFunc)(void);

#define _TRAINER_CARD_NUM_MAX (4)

//==============================================================================
// [N
//==============================================================================

typedef struct{
    TR_CARD_DATA* pTRCard[_TRAINER_CARD_NUM_MAX];  // g[i[J[hMobt@̃|C^
    u8 bTRCard[_TRAINER_CARD_NUM_MAX];
    COMM_MESSAGE* pCMess;
    FIELDSYS_WORK* pFSys;
    MATHRandContext32 sRand; ///< eq@lSVG[VpL[
    PTRStateFunc state;
    TCB_PTR pTcb;
    u16 timer;
    u8 connectIndex;   // q@ڑe@indexԍ
    u8 bStalth;
    u8 bStateNoChange;
    u8 bUGOverlay;
    u8 bReturnBattle; // og߂Ăꍇ͂P Ăꍇ͂O
    u8 bBattleMoveRoom; // JnʒuɂƂM

    POKEPARTY*  party;	// ~bNXogpp[eB

#ifdef PM_DEBUG		// Debug ROM
    u16 debugTimer;
#endif
} _COMM_FSTATE_WORK;

static _COMM_FSTATE_WORK* _pCommFState = NULL;  ///<@[N\̂̃|C^

//==============================================================================
// `
//==============================================================================
#define _START_TIME (50)     // Jn
#define _CHILD_P_SEARCH_TIME (12) ///q@ƂĐeT
#define _PARENT_WAIT_TIME (40) ///eƂĂ̂т҂
#define _FINALIZE_TIME (2)
#define _EXIT_SENDING_TIME (5)
#define _PARENT_END_TIME (2)
#define _SEND_NAME_TIME (10)
#define _PARENTSCAN_PA (3)  // e@ƂČm1/3

#define _TCB_COMMCHECK_PRT   (10)    ///< tB[hʐM̊Ď[`PRI


//==============================================================================
// static錾
//==============================================================================

// Xe[g̏

static void _commStateInitialize(FIELDSYS_WORK* pFSys);  // 
static void _commCheckFunc(TCB_PTR tcb, void* work);  // Xe[gsĂ^XN
static void _changeState(PTRStateFunc state, int time);  // Xe[gύX
static void _changeStateDebug(PTRStateFunc state, int time, int line);  // Xe[gύX

#ifdef PM_DEBUG
#if 1
#define   _CHANGE_STATE(state, time)  _changeStateDebug(state, time, __LINE__)
#else
#define   _CHANGE_STATE(state, time)  _changeState(state, time)
#endif
#else  //PM_DEBUG
#define   _CHANGE_STATE(state, time)  _changeState(state, time)
#endif //PM_DEBUG


// n֘AXe[g
static void _underStart(void);           //  + VXȅ
static void _underOpenning(void);       //Cxg
static void _underConnecttingAloneSend(void);  // ]
static void _underConnectting(void);     // ڑ
static void _underChildConnecting(void);   // q@e@ɐڑ
static void _underChildConnectInfoWait(void);  // q@ƂĐڑ infoW
static void _underChildConnectFlagWait(void);
static void _underChildConnectSecret(void);    // q@ƂĐڑ
static void _underChildConnectDig(void);    // q@ƂĐڑ
static void _underChildConnect(void);    // q@ƂĐڑ
static void _underChildConnect_JumpFieldStart(void);    // q@ƂĐڑ JumpJn
static void _underChildConnect_JumpField(void);    // q@ƂĐڑ Jump
static void _underChildConnect_JumpFieldEnd(void);    // q@ƂĐڑ Jump
static void _underParentRestart(void);
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if (T1645_060815_FIX|T1644_060816_FIX)
static void _underParentRestartAloneWait(void);
#endif //(T1645_060815_FIX|T1644_060816_FIX)
// ----------------------------------------------------------------------------
static void _underChildRestart(void);
static void _underChildRestart_Base(void);
static void _underChildStalth(void);

static void _underParentWait(void);      // e@Ƃđҋ@
static void _underParentConnect(void);   // e@ƂĐڑ
static void _underParentConnect_JumpFieldStart(void);  // e@ƂĐڑ JumpJn
static void _underParentConnect_JumpField(void);  // e@ƂĐڑ Jump
static void _underParentConnect_JumpFieldEnd(void);  // e@ƂĐڑ JumpI
static void _stateUnderGroundConnectEnd(void);  // nؒf

static void _underSoloConnect_JumpFieldStart(void);    // solo@ƂĐڑ JumpJn
static void _underSoloConnect_JumpField(void);    // solo@ƂĐڑ Jump
static void _underSoloConnect_JumpFieldEnd(void);    // solo@ƂĐڑ Jump
static void _underStalthConnect_JumpFieldStart(void);    // stalth@ƂĐڑ JumpJn
static void _underStalthConnect_JumpField(void);    // stalth@ƂĐڑ Jump
static void _underStalthConnect_JumpFieldEnd(void);    // stalth@ƂĐڑ Jump

static void _underChildStalthDeadLoop(void);


// og֘AXe[g
static void _battleParentInit(void);     // 퓬pe@Ƃď
static void _battleParentWaiting(void);  // 퓬pe@Ƃđҋ@

static void _battleChildInit(void);     // 퓬pq@Ƃď
static void _battleChildBconScanning(void);  // 퓬pq@ƂĐe@I
static void _battleChildConnecting(void);  // ڑ炢
static void _battleChildSendName(void);  // ̖O݂ȂɑM
static void _battleChildWaiting(void);  // _CNgpq@ҋ@
static void _battleMoveRoomEnter(void); // 퓬O̕ɓđҋ@
static void _battleMoveRoomEnter2(void); // 퓬O̕ɓđҋ@
static void _battleMoveRoomReturn(void); // 퓬O̕ɓđҋ@
static void _battleMoveRoomReturn2(void); // 퓬O̕ɓđҋ@
static void _battleMoveRoomReturn3(void); // 퓬O̕ɓđҋ@
static void _battleMoveRoomWait(void);
static void _battleMoveRoom(void); // 퓬O̕ɓđҋ@
static void _battleChildReTry(void);   // q@𒆒f
static void _battleChildReInit(void);   // q@ċN
static void _battleMoveRoomEnd_Tim(void);   //og[I 퓬Jn
static void _battleMoveRoomEnd(void);   //og[I 퓬Jn
static void _battleQuit(void);   //og[I
static void _trCardCopyEnd(void);
static void _dsChangeTiming(void);
static void _trCardCopyStart(void);
static void _dsChangeEndWaitStart(void);
static void _dsChangeEndWaitEnd(void);

// ̑ʓIȃXe[g
static void _stateNone(void);            // Ȃ
static void _stateConnectError(void);    // ڑG[
static void _stateEnd(void);             // I
static void _stateConnectEnd(void);      // ؒfJn
static void _directEndTiming(void);
static void _directEndNoTiming(void);
static void _stateConnectAutoEnd(void);  // ؒfJn
static void _underChildRebootFunc(void);

#ifdef PM_DEBUG		// Debug ROM
static void _debugTimerStart(void);   // fobOp
static void _debugTimerDisp(char* msg);
#else
static void _debugTimerStart(void){}   // fobOp
static void _debugTimerDisp(char* msg){}
#endif


//==============================================================================
/**
 * ʐMǗXe[g̏
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _commStateInitialize(FIELDSYS_WORK* pFSys)
{
    void* pWork;

    if(_pCommFState!=NULL){   // łɓ쒆̏ꍇKvȂ
        return;
    }
    CommCommandFieldInitialize((void*)pFSys);
    // 
    _pCommFState = (_COMM_FSTATE_WORK*)sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_COMM_FSTATE_WORK));
    MI_CpuFill8(_pCommFState, 0, sizeof(_COMM_FSTATE_WORK));
//    _pCommFState->state = NULL;   // Ȃ
    _pCommFState->timer = _START_TIME;
    _pCommFState->pTcb = TCB_Add(_commCheckFunc, NULL, _TCB_COMMCHECK_PRT);
    _pCommFState->pFSys = pFSys;
    _pCommFState->party = NULL;
//    _pCommFState->bStalth = FALSE;
//    _pCommFState->bUGOverlay = FALSE;
//    _pCommFState->bStateNoChange = FALSE;
    _debugTimerStart();
    CommRandSeedInitialize(&_pCommFState->sRand);
}

//==============================================================================
/**
 * ʐMǗXe[g̏I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateFinalize(void)
{
    void* pWork;
    int i;

    if(_pCommFState==NULL){  // łɏIĂ
        return;
    }
    TCB_Delete(_pCommFState->pTcb);

    for(i = 0;i < _TRAINER_CARD_NUM_MAX; i++){
        if(_pCommFState->pTRCard[i]){
            sys_FreeMemoryEz(_pCommFState->pTRCard[i]);
        }
//        sys_DeleteHeap(HEAPID_VSROOM);
    }

    if( _pCommFState->party )
    {
		sys_FreeMemoryEz( _pCommFState->party );
	}

    sys_FreeMemoryEz(_pCommFState);
//    sys_DeleteHeap(HEAPID_COMMUNICATION);
    _pCommFState = NULL;
}

//==============================================================================
/**
 * nɂ͂̒ʐM
 * @param   pFSys FIELDSYS_WORK
 * @retval  none
 */
//==============================================================================

void CommFieldStateEnterUnderGround(FIELDSYS_WORK* pFSys)
{
    if(_pCommFState!=NULL){ // ȂĂꍇ͏O
        return;
    }
    // ڑs
    CommStateEnterUnderGround(GameSystem_GetSaveData(pFSys));
    _commStateInitialize(pFSys);
    sys_CreateHeap( HEAPID_BASE_APP, HEAPID_UNDERGROUND, 0xe800 );  //ObYj[łȂm
    if(!SysFlag_UgFirstCheck(SaveData_GetEventWork(_pCommFState->pFSys->savedata))){
        OS_TPrintf("nCxg\n");
        CommStateSetFirstEvent();
    }

}

//==============================================================================
/**
 * nɂ͂āAtB[hnɕς̏
 * @param   pFSys FIELDSYS_WORK
 * @retval  none
 */
//==============================================================================

void CommFieldStateArrivalUnderGround(void)
{
    _pCommFState->bUGOverlay = TRUE;
    RECORD_Score_Add(SaveData_GetRecord(_pCommFState->pFSys->savedata), SCORE_ID_MINE_IN);

    CommUnderOptionInitialize(_pCommFState->pFSys);  // nT[rX̋N

#ifdef PM_DEBUG
    if(DebugOhnoGetCommDebugDisp()){
        DebugIchiCheckOn(_pCommFState->pFSys);
    }
#endif
    
    _CHANGE_STATE(_underStart, 0);
}

//==============================================================================
/**
 * noꍇ̒ʐM
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateExitUnderGround(void)
{
    if(_pCommFState==NULL){  // łɏIĂ
        return;
    }
    // ؒfXe[gɈڍs  ɐ؂Ȃ
    
    _CHANGE_STATE(_stateUnderGroundConnectEnd, 3);
}

//==============================================================================
/**
 * nʐM~ɂꍇ̒ʐM
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateStalthUnderGround(void)
{
    OHNO_PRINT("stalth \n");
//    CommUnderOptionFinalize();  // ͂@@OO
    CommStateUnderGroundOfflineSecretBase();
    _CHANGE_STATE(_underChildStalth, 0);
}

//==============================================================================
/**
 * nĐڑꍇ̏
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underStalthEndCheck(void)
{
    if(!CommMPIsConnectStalth()){
        CommSecretBaseInfoJumpEnd();
        _CHANGE_STATE(_underStart,0);
    }

}


void CommFieldStateUnderGroundReConnect(void)
{
//    CommSecretBaseInfoChildSendStart();
    //_underChildConnect_JumpFieldEnd();
    CommStateUnderGroundOnlineSecretBase();  // ʐMԂONLINEɂǂ

    _CHANGE_STATE(_underStalthEndCheck,0);
//    _CHANGE_STATE(_underStart,1)
    
//    CommTrapInfoChildSendStart();  //TrapgɑMJn
//    _CHANGE_STATE(_underConnectting, _CHILD_P_SEARCH_TIME*2);
}

//==============================================================================
/**
 * nJUMPꍇ̒ʐM
 * @param   none
 * @retval  none
 */
//==============================================================================

BOOL CommStateJumpUnderGround(void)
{
    int i;
    u32 stateAddr = (u32)_pCommFState->state;
    u32 parentAddr = (u32)_underParentConnect;
    u32 childAddr = (u32)_underChildConnect;
    u32 soloAddr = (u32)_underConnectting;
    u32 stalthAddr = (u32)_underChildStalthDeadLoop;
    u32 jumpState[] = {
        (u32)_underParentConnect_JumpFieldStart,
        (u32)_underChildConnect_JumpFieldStart,
        (u32)_underSoloConnect_JumpFieldStart,
        (u32)_underStalthConnect_JumpFieldStart,
    };


    
    if(stateAddr == parentAddr){
        _CHANGE_STATE(_underParentConnect_JumpFieldStart, 0);
        return TRUE;
    }
    else if(childAddr == stateAddr){
        _CHANGE_STATE(_underChildConnect_JumpFieldStart, 0);
        return TRUE;
    }
    else if(soloAddr == stateAddr){
        _CHANGE_STATE(_underSoloConnect_JumpFieldStart, 0);
        return TRUE;
    }
    else if(stalthAddr == stateAddr){
        _CHANGE_STATE(_underStalthConnect_JumpFieldStart, 0);
        return TRUE;
    }
    for(i = 0 ; i < NELEMS(jumpState); i++){
        if(jumpState[i] == stateAddr){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * nJUMPIꍇ̏ Xe[gActiveԂɂȂ
 * @param   none
 * @retval  none
 */
//==============================================================================

BOOL CommStateJumpEndUnderGround(void)
{
    u32 stateAddr = (u32)_pCommFState->state;
    u32 parentAddr = (u32)_underParentConnect_JumpField;
    u32 childAddr = (u32)_underChildConnect_JumpField;
    u32 soloAddr = (u32)_underSoloConnect_JumpField;
    u32 stalthAddr = (u32)_underStalthConnect_JumpField;

    if(stateAddr == parentAddr){
        _CHANGE_STATE(_underParentConnect_JumpFieldEnd, 0);
        return TRUE;
    }
    else if(childAddr == stateAddr){
        _CHANGE_STATE(_underChildConnect_JumpFieldEnd, 0);
        return TRUE;
    }
    else if(soloAddr == stateAddr){
        _CHANGE_STATE(_underSoloConnect_JumpFieldEnd, 0);
        return TRUE;
    }
    else if(stalthAddr == stateAddr){
        _CHANGE_STATE(_underStalthConnect_JumpFieldEnd, 0);
        return TRUE;
    }
    {
//        GF_ASSERT(0 && "zOstate:vC");
    }
    return FALSE;
}

//==============================================================================
/**
 * ړ\Xe[gȂ̂ǂԂ
 * @param   none
 * @retval  ړ\ȂTRUE
 */
//==============================================================================

BOOL CommIsUnderGroundMoveState(void)
{
    int i;
    u32 funcTbl[]={
        (u32)_battleMoveRoom,
        (u32)_underChildConnect,
        (u32)_underParentConnect,
        (u32)_underChildConnectInfoWait,
        (u32)_underChildConnectFlagWait,
        (u32)_underChildConnectSecret,
        (u32)_underChildConnectDig,
        (u32)_underChildConnect_JumpFieldStart,
        (u32)_underChildConnect_JumpField,
        (u32)_underChildConnect_JumpFieldEnd,
        (u32)_underParentConnect_JumpFieldStart,
        (u32)_underParentConnect_JumpField,
        (u32)_underParentConnect_JumpFieldEnd,
        0,
    };
    u32 stateAddr = (u32)_pCommFState->state;

    if(_pCommFState==NULL){  // łɏIĂ
        return FALSE;
    }
    for(i = 0; funcTbl[i] != 0; i++ ){
        if(stateAddr == funcTbl[i]){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * og̐eƂĂ̒ʐMJn
 * @param   serviceNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================

void CommFieldStateEnterBattleParent(FIELDSYS_WORK* pFSys, int serviceNo, int regulationNo)
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
#ifdef PM_DEBUG
    CommStateEnterBattleParent(GameSystem_GetSaveData(pFSys), serviceNo, regulationNo, pFSys->regulation,FALSE, SOLO_DEBUG_NO);
#else
    CommStateEnterBattleParent(GameSystem_GetSaveData(pFSys), serviceNo, regulationNo, pFSys->regulation,FALSE);
#endif
    _commStateInitialize(pFSys);
    _CHANGE_STATE(_battleParentInit, 0);
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMJn
 * @param   serviceNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================

void CommFieldStateEnterBattleChild(FIELDSYS_WORK* pFSys, int serviceNo, int regulationNo)
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
    // ʐMq[v쐬
#ifdef PM_DEBUG
    CommStateEnterBattleChild(GameSystem_GetSaveData(pFSys), serviceNo, regulationNo,pFSys->regulation, FALSE, SOLO_DEBUG_NO);
#else
    CommStateEnterBattleChild(GameSystem_GetSaveData(pFSys), serviceNo, regulationNo,pFSys->regulation, FALSE);
#endif
    _commStateInitialize(pFSys);
    _CHANGE_STATE(_battleChildInit, 0);
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMJn
 * @param   connectIndex ڑe@Index
 * @retval  none
 */
//==============================================================================

void CommFieldStateConnectBattleChild(int connectIndex)
{
    _pCommFState->connectIndex = connectIndex;
    _CHANGE_STATE(_battleChildConnecting, 0);
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMċN
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateRebootBattleChild(void)
{
    _CHANGE_STATE(_battleChildReTry, 0);
}

//==============================================================================
/**
 * ogɈړł镔ɓ鎞̏
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateEnterBattleRoom(FIELDSYS_WORK* pFSys)
{
    OHNO_PRINT("ɓ\n");
    WIPE_SetWndMask(WIPE_DISP_MAIN,WIPE_FADE_BLACK);
    WIPE_SetWndMask(WIPE_DISP_SUB,WIPE_FADE_BLACK);
    CommStateSetErrorCheck(TRUE,TRUE);

    if(!CommStateIsInitialize()){  // ʐMԂŖȂI
        return;
    }
    if(_pCommFState==NULL){// ĂȂꍇ삳
        _commStateInitialize(pFSys);
        _pCommFState->bReturnBattle = TRUE;
    }
    else{
        _pCommFState->bReturnBattle = FALSE;
    }
    _pCommFState->bBattleMoveRoom = FALSE;

    {  // g[i[J[h̃f[^
        int i,id = CommGetCurrentID();
        MYSTATUS *my_st = CommInfoGetMyStatus(CommGetCurrentID());
        for(i = 0; i < CommGetConnectNum(); i++){
            if(_pCommFState->pTRCard[i]==NULL){
                _pCommFState->pTRCard[i] = sys_AllocMemory(HEAPID_BASE_SYSTEM,sizeof(TR_CARD_DATA));
            }
        }
        TRCSET_MakeTrainerInfo( BADGE_BRUSH_OFF, TIME_UPDATE_OFF, GYM_READER_MASK_NONE, UNION_TR_NONE,
//                                UnionView_GetTrainerInfo( MyStatus_GetMySex(my_st),
//                                                          MyStatus_GetTrainerView(my_st), UNIONVIEW_ICONINDEX ),
                                _pCommFState->pFSys,
                                _pCommFState->pTRCard[id] );
    }
    CommTimingSyncStart(DBC_TIM_BATTLE_TR);
    _CHANGE_STATE(_trCardCopyStart, 0);
}

//==============================================================================
/**
 * f[^Rs[Iǂ
 * @param   none
 * @retval  none
 */
//==============================================================================

BOOL CommFieldStateIsCopyEnd(void)
{
    if(_pCommFState->state == _trCardCopyStart){
        return FALSE;
    }
    if(_pCommFState->state == _trCardCopyEnd){
        return FALSE;
    }
    return TRUE;
}

//==============================================================================
/**
 * og̒ʐMI葱
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateExitBattle(void)
{
    if(_pCommFState==NULL){
        return;      // łɏIĂꍇ͏O
    }
    CommStateSetErrorCheck(FALSE,FALSE);
    _CHANGE_STATE(_directEndNoTiming, _EXIT_SENDING_TIME);
}


//==============================================================================
/**
 * og̒ʐMI葱  ŌɓďI
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFieldStateExitBattleTiming(void)
{
    if(_pCommFState==NULL){
        return;      // łɏIĂꍇ͏O
    }
    CommTimingSyncStart(DBC_TIM_BATTLE_EXIT2);
    _CHANGE_STATE(_directEndTiming, _EXIT_SENDING_TIME);
}




//==============================================================================
/**
 * ʐMǗXe[g̏
 * @param
 * @retval  none
 */
//==============================================================================

void _commCheckFunc(TCB_PTR tcb, void* work)
{
#ifdef PM_DEBUG
    _pCommFState->debugTimer++;
#endif

    if(_pCommFState==NULL){
        TCB_Delete(tcb);
    }
    else{
        if(_pCommFState->state != NULL){
            PTRStateFunc state = _pCommFState->state;
            if(!_pCommFState->bStateNoChange){
                state();
            }
        }
    }
}

//==============================================================================
/**
 * ʐMǗXe[g̕ύX
 * @param   state  ςXe[g̊֐
 * @param   time   Xe[gێ
 * @retval  none
 */
//==============================================================================

static void _changeState(PTRStateFunc state, int time)
{
    _pCommFState->state = state;
    _pCommFState->timer = time;
}

#ifdef PM_DEBUG
static void _changeStateDebug(PTRStateFunc state, int time, int line)
{
    OHNO_PRINT("CF field_state: %d %d\n",line, CommGetCurrentID());
    _changeState(state, time);
}
#endif

//==============================================================================
/**
 * nX^[g
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underStart(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    if(!CommIsInitialize()){
        return;  //
    }
//    if(!CommGetAloneMode()){   // alone[h̏ꍇ
//        return;
//    }    
    CommUnderOptionReInit(_pCommFState->pFSys);  // nT[rXēx

    // gɂ񑗂
    CommInfoSendPokeData();
    CommPlayerSendPos(FALSE);
    CommTrapInfoChildSendStart();  //TrapgɑMJn
    CommSecretBaseInfoChildSendStart(); // ̔閧nf[^̐eɑMJn

    if(!SysFlag_UgFirstCheck(SaveData_GetEventWork(_pCommFState->pFSys->savedata))){
        // Ђ傤悤Xe[g
        _CHANGE_STATE(_underOpenning, 0);
    }
    else{
        CommPlayerFirstMoveEnable();
        _CHANGE_STATE(_underConnecttingAloneSend, _CHILD_P_SEARCH_TIME*2);
    }
}

//==============================================================================
/**
 * openiingI܂łȂɂȂ  ȂȂ悤ɂ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underOpenning(void)
{
    if(!SysFlag_UgFirstCheck(SaveData_GetEventWork(_pCommFState->pFSys->savedata))){
        return;
    }
    CommStateUnderRestart();
    CommPlayerFirstMoveEnable();
    
    _CHANGE_STATE(_underConnectting, _CHILD_P_SEARCH_TIME*2);
}



//==============================================================================
/**
 * ŎɃf[^𑗐MI܂ő҂
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underConnecttingAloneSend(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    _CHANGE_STATE(_underConnectting, _CHILD_P_SEARCH_TIME*2);
}

//==============================================================================
/**
 * lbg[NȂ܂őҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underConnectting(void)
{
    CommUnderProcess();

    CommPlayerFirstMoveEnable();
    
    if(CommIsUnderGroundConnectingState()){  // ڑ܂ŌĂё
        if(CommGetCurrentID() == COMM_PARENT_ID){
            OHNO_PRINT("eɂȂ\n");
            CommSecretBaseInfoParentDel();

            _CHANGE_STATE(_underParentWait, 60);
        }
        else{
            OHNO_PRINT("qɂȂ\n");
            _CHANGE_STATE(_underChildConnecting, 120);
        }
    }
}

//==============================================================================
/**
 * q@ƂȂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _underChildConnecting(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
    }

    if(CommMPParentDisconnect() || CommIsError() || (_pCommFState->timer==0) ){
        CommStateUnderRestart();
        _CHANGE_STATE(_underChildRestart, 0);  // q@ɂȂOɃG[ɂȂ
    }
    else if(CommIsConnect(CommGetCurrentID())){   // gڑĂ邱ƂmFł
        if(_pCommFState->timer!=0){
            _pCommFState->timer--;
            if(CommGetSendRestSize() != COMM_COMMAND_SEND_SIZE_MAX){  // ɂȂ܂ő҂ ^C}[
                return;
            }
        }
        UgMgrForceExitNowTCB();
        CommPlayerMyDataCopy( COMM_PARENT_ID );  // ef[^玩Ă
        CommTrapRecvForceEnd(COMM_PARENT_ID,0,NULL,NULL);  // 㩂~߂
        UgTrapForceExit(COMM_PARENT_ID,TRUE);
        CommInfoDeletePlayer(COMM_PARENT_ID);   // êł
        CommPlayerDestroy( COMM_PARENT_ID, FALSE, FALSE );
//        CommPlayerSendPos(FALSE);
        //_debugTimerDisp("q@ڑ----!!!-----");
        OHNO_PRINT("q@ɂȂ %d \n",CommGetCurrentID());
        CommPlayerFirstMoveDisable();
        _CHANGE_STATE(_underChildConnectInfoWait, 10);
        return;
    }
//    _pCommFState->timer--;
}

//==============================================================================
/**
 * e@ɂȂAq@ڑĂ̂҂
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentWait(void)
{
    CommUnderProcess();

    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
    }

    if(CommIsChildsConnecting() || (_pCommFState->timer==0)){
        // ȊOȂe@Œ
        // ͎q@ؒfĂ܂ꍇ̃^CAEgG[IɈړ
        if(UgMgrForceExitNowTCB()){
            CommPlayerHoldEnd();
        }
        _debugTimerDisp("e@ڑ");
//        CommInfoSendPokeData();
        CommPlayerSendPos(FALSE);
//        CommTrapInfoChildSendStart();  //TrapgɑMJn
        CommPlayerNowFlagSend();
        CommSecretBaseInfoChildSendStart(); // ̔閧nf[^̐eɑMJn
//        UgDigFossilPlayerInit();
        UgInitialDataSend();   // ΁{GXP[vꏊ𑗐M
        _CHANGE_STATE(_underParentConnect, 0);
        return;
    }

}

//==============================================================================
/**
 * e@ƂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentConnect(void)
{
    CommUnderProcess();

    // Sڑ؂ꂽ珄ɖ߂邪Cxg͋֎~
//    if((_pCommFState->pFSys->event != NULL) || UgSecretBaseIsMoveTickets()){  // nړCxgɃXe[gς̂͋֎~
    if(_pCommFState->pFSys->event != NULL){  // nړCxgɃXe[gς̂͋֎~
        return;
    }

    if(CommIsError() || !CommMPIsChildsConnecting() || ((!CommIsConnect(CommGetCurrentID()) && !CommGetAloneMode())) ){

        OHNO_PRINT("Ȃq@ؒf %d %d\n",CommIsError(),CommMPIsChildsConnecting());
        
        // 閧n߂EChEoĂƐe@̈ړtOĂ̂łŃZbg
        UgSecretBaseResetPlayer(COMM_PARENT_ID); // CxgĂȂȂ烊Zbg

        CommPlayerParentFlagDataReset();
        UgSecretBaseErrorMoveTickets();
        CommSendFixData(CF_TRAP_END_FORCE);    // T[o[
        UgTrapForceExit(CommGetCurrentID(),TRUE);
        UgMgrForceExitNowTCB();
        CommStateUnderParentRestart();
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if (T1645_060815_FIX | T1644_060816_FIX)
        _CHANGE_STATE(_underParentRestartAloneWait, 0);
#else // (T1645_060815_FIX | T1644_060816_FIX)
        _CHANGE_STATE(_underParentRestart, 1);
#endif // (T1645_060815_FIX | T1644_060816_FIX)
// ----------------------------------------------------------------------------
    }
}

//==============================================================================
/**
 * e@ƂĐڑ   閧nւ̈ړJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentConnect_JumpFieldStart(void)
{
    //CommSecretBaseInfoReset();
    //CommTrapInfoReset();
    CommPlayerManagerReset();
    _CHANGE_STATE(_underParentConnect_JumpField, 0);
}

//==============================================================================
/**
 * e@ƂĐڑ   閧nւ̈ړ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentConnect_JumpField(void)
{
    CommUnderProcess();
}

//==============================================================================
/**
 * e@ƂĐڑ   閧nւ̈ړI
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentConnect_JumpFieldEnd(void)
{
    CommSecretBaseInfoJumpEnd();
    //CommSecretBaseInfoReboot();
    //CommTrapInfoReboot();
    CommPlayerManagerReboot();

#ifdef PM_DEBUG
    if(DebugOhnoGetCommDebugDisp()){
        DebugIchiCheckOn(_pCommFState->pFSys);
    }
#endif
    _CHANGE_STATE(_underParentConnect, 0);
}

//==============================================================================
/**
 * q@ƂĐڑĂā@infof[^W߂ĂƂ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnectInfoWait(void)
{
    if(_pCommFState->timer == 9){
        CommInfoSendPokeData();  //infof[^𑗂
        UgInitialDataSend();   // ΁{GXP[vꏊ𑗐M
    }
    if(_pCommFState->timer == 1){
        //UgDigFossilPlayerInit();// Ό@Ă邩ǂ𑗂
        CommPlayerSendPosServer(FALSE);  //eXg
    }
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    if(CommInfoIsInfoCollected()){
        _debugTimerDisp("infof[^M");
        CommPlayerNowFlagSend();
        _CHANGE_STATE(_underChildConnectFlagWait,200);
        return;
    }
    _underChildConnect();
}


//==============================================================================
/**
 * q@ƂĐڑĂā@n^f[^𑗂鏊
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnectFlagWait(void)
{
    if(CommPlayerIsNowFlagDataEnd()){
        CommTrapInfoChildSendStart();  // 㩏񑗐M
        _CHANGE_STATE(_underChildConnectSecret,0);
    }
    else{
        _underChildConnect();
        if(_pCommFState->timer!=0){
            _pCommFState->timer--;
        }
        else{
            // ^CAEgɂؒf
            OHNO_PRINT("ƂĂȂ\n");
            _underChildRebootFunc();
        }
    }
}

//==============================================================================
/**
 * q@ƂĐڑ  㩑M
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnectSecret(void)
{
    if(CommTrapInfoIsParentRecv()){
        _debugTimerDisp("e@㩃f[^͂炵");
        CommTrapInfoResetParentRecv();
        CommSecretBaseInfoChildSendStart(); // q@̔閧nf[^MJn
        _CHANGE_STATE(_underChildConnectDig,0);
        return;
    }
    _underChildConnect();
}

//==============================================================================
/**
 * q@ƂĐڑ 閧nM
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnectDig(void)
{
    if(CommSecretBaseInfoIsPosRecv()){
        _debugTimerDisp("閧n̈ʒu");
        CommSecretBaseResetPosRecv();
     //   CommPlayerSetMoveControl(TRUE);
        CommPlayerSendPos(TRUE);  // Loׂɂ񑗂@eXg
        CommSendFixData(CF_PLAYER_INIT_END);  // 𑗐M
        _CHANGE_STATE(_underChildConnect,0);
        return;
    }
    _underChildConnect();
}

// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if (T1645_060815_FIX | T1644_060816_FIX)

//==============================================================================
/**
 * e@ƂĐؒf
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentRestartAloneWait(void)
{
    if(!CommGetAloneMode()){
        OHNO_PRINT("s wait\n");
        return;
    }
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if T1644_060816_FIX
    CommPlayerSetMoveControl_Server(COMM_PARENT_ID,FALSE);
    _CHANGE_STATE(_underParentRestart,30);
#else //T1644_060816_FIX
    _CHANGE_STATE(_underParentRestart,10);
#endif  //T1644_060816_FIX
// ----------------------------------------------------------------------------

}

//==============================================================================
/**
 * e@ƂĐؒf̂҂
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentRestart(void)
{
// ----------------------------------------------------------------------------
// localize_spec_mark(JP_VER10) imatake 2006/12/01
#if T1644_060816_FIX
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
#else //T1644_060816_FIX
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        if(!CommIsEmptyQueue()){
            OHNO_PRINT("not e\n");
            return;
        }
    }
#endif //T1644_060816_FIX
// ----------------------------------------------------------------------------
    if(CommGetCurrentID() == COMM_PARENT_ID){  // eɂȂ
        OHNO_PRINT("ăX^[g\n");
        _CHANGE_STATE(_underStart, 0);
    }
}

#else  //(T1645_060815_FIX | T1644_060816_FIX)

//==============================================================================
/**
 * e@ƂĐؒf
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentRestart(void)
{
//    if(CommIsUnderResetState()){
  //      return;
 //   }
//    if(!CommIsConnect(CommGetCurrentID()) && !CommGetAloneMode()){
    if(!CommGetAloneMode()){
        OHNO_PRINT("s wait\n");
        return;
    }
    if(!CommIsEmptyQueue()){
        OHNO_PRINT("not e\n");
        return;
    }
    
    if(CommGetCurrentID() == COMM_PARENT_ID){  // eɂȂ
        OHNO_PRINT("ăX^[g\n");
        _CHANGE_STATE(_underStart, 0);
    }
}

#endif //(T1645_060815_FIX | T1644_060816_FIX)
// ----------------------------------------------------------------------------

//==============================================================================
/**
 * q@ƂĐؒf
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildRestart(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    if(CommGetCurrentID() == COMM_PARENT_ID){  // eɂȂ
        OHNO_PRINT("ăX^[g\n");
        _CHANGE_STATE(_underStart, 0);
    }
}

static void _underChildRestart_Base(void)
{
    if(_pCommFState->pFSys->event == NULL ){  // nړCxgI
        CommStateUnderRestart();  // n̒ʐMeq؂ւ
        _CHANGE_STATE(_underChildRestart, 0);
    }
}



static void _underChildStalthDeadLoop(void)
{
    CommUnderProcess();
}

static void _underChildStalth(void)
{
    if(CommGetCurrentID() == COMM_PARENT_ID){
//        CommUnderOptionInitialize(_pCommFState->pFSys);  // nT[rX̋N

        CommUnderOptionReInit(_pCommFState->pFSys);  // nT[rXēx

        // gɂ񑗂
        CommInfoSendPokeData();
        CommPlayerSendPos(FALSE);
        CommTrapInfoChildSendStart();  //TrapgɑMJn
        CommSecretBaseInfoChildSendStart(); // ̔閧nf[^̐eɑMJn
        _CHANGE_STATE(_underChildStalthDeadLoop, 0);
    }
}

//==============================================================================
/**
 * q@ƂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================



//==============================================================================
/**
 * q@ƂĐڑ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildRebootFunc(void)
{
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/10
// @ĂȂeɁA@o|̃bZ[Wo邱Ƃ
// s̏C𔽉f
	
#if AFTER_MASTER_070202_FOSSILLOG_FIX
    UgTrapForceExit(CommGetCurrentID(),TRUE);
    UgSecretBaseRemovePlayer_Client(CommGetCurrentID(),TRUE);
    UgDigFossilDeleteLog();
    CommPlayerManagerStop();  // ړ~
    UgMgrForceExitNowTCB();   // o^CxgI
    CommStateUnderRestart();  // n̒ʐMeq؂ւ
    CommPlayerFlagChange();   // ̃n^}ւ
    _CHANGE_STATE(_underChildRestart, 0);//
#else
    UgTrapForceExit(CommGetCurrentID(),TRUE);
    if(UgSecretBaseRemovePlayer_Client(CommGetCurrentID(),TRUE)){
        CommPlayerManagerStop();  // ړ~
        UgMgrForceExitNowTCB();   // o^CxgI
        CommStateUnderRestart();  // n̒ʐMeq؂ւ
        CommPlayerFlagChange();   // ̃n^}ւ
        _CHANGE_STATE(_underChildRestart, 0);//
    }
    else{
        OHNO_PRINT("ؒfċN %d\n",CommGetCurrentID());
        CommPlayerManagerStop();  // ړ~
        UgMgrForceExitNowTCB();   // o^CxgI
        CommStateUnderRestart();  // n̒ʐMeq؂ւ
        CommPlayerFlagChange();   // ̃n^}ւ
        _CHANGE_STATE(_underChildRestart, 0);
    }
#endif

// ----------------------------------------------------------------------------
}


static void _underChildConnect(void)
{
    CommUnderProcess();

    CommPlayerFirstMoveEnable();
    
    // e@ȂȂIĕʐeTɂ
    if(_pCommFState->pFSys->event != NULL ){  // nړCxgɃXe[gς̂͋֎~
        return;
    }
    if(CommMPParentDisconnect() || CommIsError()){
        _underChildRebootFunc();  // ċN
    }
}

//==============================================================================
/**
 * q@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnect_JumpFieldStart(void)
{
    //CommSecretBaseInfoReset();
    //CommTrapInfoReset();
    CommPlayerManagerReset();
    _CHANGE_STATE(_underChildConnect_JumpField,0);
}

//==============================================================================
/**
 * q@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnect_JumpField(void)
{
    // o邾Ȃ
    UgSecretBaseErrorDisconnectTickets();
}

//==============================================================================
/**
 * q@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underChildConnect_JumpFieldEnd(void)
{
    CommSecretBaseInfoJumpEnd();
 //   CommSecretBaseInfoReboot();
//    CommTrapInfoReboot();
    CommPlayerManagerReboot();
#ifdef PM_DEBUG
    if(DebugOhnoGetCommDebugDisp()){
        DebugIchiCheckOn(_pCommFState->pFSys);
    }
#endif

    if(CommMPParentDisconnect() || CommIsError()){
        OHNO_PRINT("ؒfċN %d\n",CommGetCurrentID());
        
        CommSecretBaseInfoReInit();  // 
        CommPlayerManagerStop();  // ړ~
        UgMgrForceExitNowTCB();   // o^CxgI
        CommStateUnderRestart();  // n̒ʐMeq؂ւ
        CommPlayerFlagChange();   // ̃n^}ւ
        _CHANGE_STATE(_underChildRestart, 0);
    }
    else{
        _CHANGE_STATE(_underChildConnect, 0);
    }
}



//==============================================================================
/**
 * solo@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underSoloConnect_JumpFieldStart(void)
{
    CommPlayerManagerReset();
    _CHANGE_STATE(_underSoloConnect_JumpField,0);
}

//==============================================================================
/**
 * solo@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underSoloConnect_JumpField(void)
{
}

//==============================================================================
/**
 * solo@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underSoloConnect_JumpFieldEnd(void)
{
    CommSecretBaseInfoJumpEnd();
    CommPlayerManagerReboot();
#ifdef PM_DEBUG
    if(DebugOhnoGetCommDebugDisp()){
        DebugIchiCheckOn(_pCommFState->pFSys);
    }
#endif
    _CHANGE_STATE(_underConnectting, 0);
}

//==============================================================================
/**
 * stalth@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underStalthConnect_JumpFieldStart(void)
{
    CommPlayerManagerDeletePlayers();
    _CHANGE_STATE(_underStalthConnect_JumpField,0);
}

//==============================================================================
/**
 * stalth@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underStalthConnect_JumpField(void)
{
}

//==============================================================================
/**
 * solo@ƂĐڑ@@@JUMP
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underStalthConnect_JumpFieldEnd(void)
{
    CommSecretBaseInfoJumpEnd();
    CommPlayerManagerReboot();
#ifdef PM_DEBUG
    if(DebugOhnoGetCommDebugDisp()){
        DebugIchiCheckOn(_pCommFState->pFSys);
    }
#endif
    _CHANGE_STATE(_underChildStalthDeadLoop, 0);
}


//==============================================================================
/**
 * e@Ƃďs
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentInit(void)
{
    if(!CommIsConnect(CommGetCurrentID())){
//    if(!CommIsVRAMDInitialize()){
        return;
    }
    CommChildListWindowOpen();
    CommInfoSendPokeData();
    _CHANGE_STATE(_battleParentWaiting, 0);
}

//==============================================================================
/**
 * e@Ƃđҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentWaiting(void)
{
  //  if(CommGetCurrentID() == COMM_PARENT_ID){
    //    CommInfoSendArray_ServerSide();  // q@₢킹info𑗐M
   // }
}

//==============================================================================
/**
 * q@̏
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildInit(void)
{
    if(!CommIsVRAMDInitialize()){
        return;
    }
    
    CommParentSelectParentWindowOpen();
    _CHANGE_STATE(_battleChildBconScanning, 0);
}

//==============================================================================
/**
 * q@ҋ@  e@r[RW
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildBconScanning(void)
{
//    CommParentBconCheck();
}

//==============================================================================
/**
 * q@ҋ@  e@ɋ炢
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildConnecting(void)
{
    CommStateConnectBattleChild(_pCommFState->connectIndex);
    _CHANGE_STATE(_battleChildSendName, 0);
}

//==============================================================================
/**
 * q@ҋ@  e@ɏ𑗐M
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildSendName(void)
{
    if(!CommIsBattleConnectingState()){
        return;
    }
    CommInfoSendPokeData();
    _CHANGE_STATE(_battleChildWaiting, 0);
}

//==============================================================================
/**
 * q@ҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildWaiting(void)
{
    //Exit󂯎q@ؒf
}



//==============================================================================
/**
 * q@enter  ړ[ɖ߂Ă
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomReturn(void)
{
    void* pWork;
    if(CommIsTimingSync(DBC_TIM_BATTLE_DSEND)){
        pWork = sys_AllocMemory(HEAPID_COMMUNICATION, CommPlayerGetWorkSize());
        CommPlayerManagerInitialize(pWork, _pCommFState->pFSys, FALSE);
        CommPlayerFirstMoveEnable();
        CommDisableSendMoveData();  // ړ֎~
        CommTimingSyncStart(DBC_TIM_BATTLE_PAUSE);
        _CHANGE_STATE(_battleMoveRoomReturn2, 0);
        return;
    }
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
    }
    else{
        _pCommFState->timer=30;
        CommTimingSyncStart(DBC_TIM_BATTLE_DSEND);
    }
}

//==============================================================================
/**
 * q@ҋ@  ړ[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomReturn2(void)
{
    if(CommGetCurrentID() == COMM_PARENT_ID){
        CommInfoSendArray_ServerSide();  // q@₢킹info𑗐M
    }
    if(CommIsTimingSync(DBC_TIM_BATTLE_PAUSE)){
        
        WIPE_SYS_Start(
            WIPE_PATTERN_WMS, WIPE_TYPE_FADEIN,
            WIPE_TYPE_FADEIN, WIPE_FADE_BLACK, COMM_BRIGHTNESS_SYNC, 1, HEAPID_FIELD );

        WIPE_ResetWndMask(WIPE_DISP_MAIN);
        WIPE_ResetWndMask(WIPE_DISP_SUB);

        CommPlayerManagerReboot();
        CommPlayerSendPos(FALSE);
        _CHANGE_STATE(_battleMoveRoomReturn3,1);
    }
}

static void _battleMoveRoomReturn4(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    if(CommIsTimingSync(DBC_TIM_BATTLE_BACK)){
        CommEnableSendMoveData();  // ړOK
        _CHANGE_STATE(_battleMoveRoomWait,0);
    }
}


static void _battleMoveRoomReturn3(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    if(CommGetCurrentID() == COMM_PARENT_ID){
        if(FALSE == CommPlayerMoveBattlePos()){
            return;
        }
        CommTimingSyncStart(DBC_TIM_BATTLE_BACK);
    }
    else{
        CommTimingSyncStart(DBC_TIM_BATTLE_BACK);
    }
    _CHANGE_STATE(_battleMoveRoomReturn4,20);
}


//==============================================================================
/**
 * q@enter  ړ[ɂ͂Ă
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomEnter(void)
{
    void* pWork;

    if(CommIsTimingSync(DBC_TIM_BATTLE_DSEND)){
        pWork = sys_AllocMemory(HEAPID_COMMUNICATION, CommPlayerGetWorkSize());
        CommPlayerManagerInitialize(pWork, _pCommFState->pFSys, FALSE);
        CommPlayerFirstMoveEnable();
        CommTimingSyncStart(DBC_TIM_BATTLE_PAUSE);
        _CHANGE_STATE(_battleMoveRoomEnter2, 0);
        return;
    }

    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
    }
    else{
        _pCommFState->timer=30;
        CommTimingSyncStart(DBC_TIM_BATTLE_DSEND);
    }
    
}

//==============================================================================
/**
 * q@ҋ@  ړ[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomEnter2(void)
{
    if(CommGetCurrentID() == COMM_PARENT_ID){
        CommInfoSendArray_ServerSide();  // q@₢킹info𑗐M
    }
    if(CommIsTimingSync(DBC_TIM_BATTLE_PAUSE)){
        CommPlayerManagerReboot();
        CommPlayerSendPos(FALSE);
        {
            u8 bit = TRUE;
            CommSendFixSizeData(CF_DIRECT_START_SET,&bit);
        }

        WIPE_SYS_Start(
            WIPE_PATTERN_WMS, WIPE_TYPE_FADEIN,
            WIPE_TYPE_FADEIN, WIPE_FADE_BLACK, COMM_BRIGHTNESS_SYNC, 1, HEAPID_FIELD );
        WIPE_ResetWndMask(WIPE_DISP_MAIN);
        WIPE_ResetWndMask(WIPE_DISP_SUB);

        _CHANGE_STATE(_battleMoveRoom,0);
    }
}


static void _exitCheck(void)
{
    int i,k;

    for(i = 0;i < CommGetConnectNum();i++){
        if(i != CommGetCurrentID()){
            if(CommGetTimingSyncNo(i) == DBC_TIM_BATTLE_EXIT){
                if(_pCommFState->pFSys->event==NULL){
                    for(k = 0;k < _TRAINER_CARD_NUM_MAX; k++){
                        if(_pCommFState->pTRCard[k]){
                            sys_FreeMemoryEz(_pCommFState->pTRCard[k]);
                            _pCommFState->pTRCard[k]=NULL;
                        }
                    }
                    EventSet_Script( _pCommFState->pFSys, SCRID_BATTLE_ROOM_FORCEEND, NULL );
                }
            }
        }
    }
    CommErrorCheck(HEAPID_FIELD,_pCommFState->pFSys->bgl);
}


//==============================================================================
/**
 *  ړ[  LZAS̃R[obN
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomWait(void)
{
    if(!CommPlayerCheckBattleJump()){
        _pCommFState->bBattleMoveRoom = FALSE;
        {
            u8 bit = TRUE;
            CommSendFixSizeData(CF_DIRECT_START_SET,&bit);
        }
        _CHANGE_STATE(_battleMoveRoom, 0);
    }
    _exitCheck();  // ĂɏI錟
}

// X^[gC̏IR[obN
static void _startLineCallBack(BOOL bStart, const POKEPARTY* party)
{
	if( party )
	{
		_pCommFState->party = PokeParty_AllocPartyWork( HEAPID_WORLD );
		PokeParty_Copy( party, _pCommFState->party );
    }

    if(bStart){
        _CHANGE_STATE(_battleMoveRoomEnd_Tim, 3);
    }
    else{  // Ǔꍇ
        {
            u8 bit = 3;
            CommSendFixSizeData(CF_DIRECT_START_SET,&bit);
        }
        _CHANGE_STATE(_battleMoveRoomWait, 0);
    }
}

//==============================================================================
/**
 * q@ҋ@  ړ[
    ]đҋ@CxgN
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomNop(void)
{
    // X^[gCR[obN̕Ԏ҂
    _CHANGE_STATE(_battleMoveRoomWait,0);
}


static void _battleMoveRoomEventSet(void)
{
    if(CommSysIsMoveKey() || (0 != CommPlayerGetWalkCount(CommGetCurrentID()))){
        return;
    }

    if(_pCommFState->timer != 0){
        _pCommFState->timer--;
        return;
    }
    CommPlayerHold();
    EventCmd_StartLine(_pCommFState->pFSys, _startLineCallBack);

    _CHANGE_STATE(_battleMoveRoomNop,0);
}

//==============================================================================
/**
 * q@ҋ@  ړ[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoom(void)
{
    if( _pCommFState->bBattleMoveRoom ){  // JnʒuɂƂM
        _CHANGE_STATE(_battleMoveRoomEventSet, 5);  // ړAX^[gCCxg
        {
            u8 bit = FALSE;
            CommSendFixSizeData(CF_DIRECT_START_SET,&bit);
        }
    }
    _exitCheck();
}

//CF_DIRECT_STARTPOS
void CommDirectRecvStartPos(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;

    if(pBuff[0] == CommGetCurrentID()){
        _pCommFState->bBattleMoveRoom = TRUE;
    }
}

BOOL CommDirectIsMoveState(void)
{
    if(_pCommFState ){
        if((_pCommFState->state == _battleMoveRoom) ||
           (_pCommFState->state == _battleMoveRoomWait)){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * q@ҋ@  ړ[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomEnd(void)
{
    BOOL bDSMode = TRUE;
    int type;
    u8 sel[6];

    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    type = FIGHT_TYPE_1vs1_SIO;
    switch(CommStateGetServiceNo()){
      case COMM_MODE_BATTLE_MULTI:
      case COMM_MODE_BATTLE_MIX_2ON2:
        type = FIGHT_TYPE_MULTI_SIO;
        break;
      case COMM_MODE_BATTLE_DOUBLE:
        type = FIGHT_TYPE_2vs2_SIO;
        break;
    }
    CommStateGetPokemon(sel);

	if( _pCommFState->party == NULL )
	{
		EventSet_CommDirectBattle(_pCommFState->pFSys,sel, type);
	}
	else
	{
		EventSet_CommDirectMixBattle( _pCommFState->pFSys, _pCommFState->party, type );
		sys_FreeMemoryEz( _pCommFState->party );
		_pCommFState->party = NULL;
	}

//    EventSet_Script( _pCommFState->pFSys, SCRID_CONNECT_COLOSSEUM_BATTLE_START, NULL );
//    CommPlayerManagerFinalize(FALSE);
//    CommSendFixSizeData(CS_DSMP_CHANGE, &bDSMode);  //og[hɕύX
    _stateFinalize();
}



//==============================================================================
/**
 * q@ҋ@  ړ[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomEnd_4(void)
{
    if(CommIsTransmissonDSType()){
        if(_pCommFState->timer!=0){
            _pCommFState->timer--;
        }
        if(_pCommFState->timer  == 90){
            CommTimingSyncStart(DBC_TIM_BATTLE_DSOK);
        }
        if(CommIsTimingSync(DBC_TIM_BATTLE_DSOK)){
            _CHANGE_STATE(_battleMoveRoomEnd,0);
        }
    }
}

//==============================================================================
/**
 * q@ҋ@  ړ[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomEnd_3(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    CommSetTransmissonTypeDS();
    _CHANGE_STATE(_battleMoveRoomEnd_4,120);
}

//==============================================================================
/**
 * q@ҋ@  ړ[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomEnd_2(void)
{
    BOOL bDSMode = TRUE;

    if(CommIsTimingSync(DBC_TIM_BATTLE_MPDS)){
//        if(CommGetCurrentID() == COMM_PARENT_ID){
//            CommSendFixSizeData(CS_DSMP_CHANGE, &bDSMode);  //og[hɕύX
//        }
        _CHANGE_STATE(_battleMoveRoomEnd_3,2);
    }
}

//==============================================================================
/**
 * q@ҋ@  ړ[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleMoveRoomEnd_Tim(void)
{
    BOOL bDSMode = TRUE;

    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    CommPlayerManagerFinalize(FALSE);
    CommTimingSyncStart(DBC_TIM_BATTLE_MPDS);
    _CHANGE_STATE(_battleMoveRoomEnd_2,0);
}

//==============================================================================
/**
 * G[ɂog̋I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleQuit(void)
{
}

//==============================================================================
/**
 * q@I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildReTry(void)
{
    CommStateRebootBattleChild();
    _CHANGE_STATE(_battleChildReInit, _FINALIZE_TIME);
}

//==============================================================================
/**
 * q@IċN
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildReInit(void)
{
    if(!CommMPIsStateIdle()){  /// IƏIĂ邱ƂmF
        return;
    }
    _CHANGE_STATE(_battleChildSendName, _SEND_NAME_TIME);
}






void CommDCRecvTrainerCard(int netID ,int size, void* pBuff, void* pWork )
{
    OHNO_SP_PRINT("CommDCRecvTrainerCard %d\n",netID);
    _pCommFState->bTRCard[netID] = TRUE;
}

u8* CommDCGetTrainerCardRecvBuff( int netID, void* pWork, int size)
{
    GF_ASSERT_RETURN(netID < _TRAINER_CARD_NUM_MAX,NULL);
    return (u8*)_pCommFState->pTRCard[netID];
}





//==============================================================================
/**
 * f[^VFAOɃg[i[J[hRs[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _trCardCopyStart(void)
{
    int i,id = CommGetCurrentID();

    if(CommIsTimingSync(DBC_TIM_BATTLE_TR)){
        CommSendHugeData(CF_TRAINER_CARD, _pCommFState->pTRCard[id], sizeof(TR_CARD_DATA));
        _CHANGE_STATE(_trCardCopyEnd,0);
    }
}

//==============================================================================
/**
 * f[^VFAOɃg[i[J[hRs[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _trCardCopyEnd(void)
{
    int i;

    for(i = 0; i < CommGetConnectNum(); i++){
        if(!_pCommFState->bTRCard[i]){
            return;
        }
    }
    CommTimingSyncStart(DBC_TIM_BATTLE_DSCHANGE);
    _CHANGE_STATE(_dsChangeTiming,0);
}


static void _dsChangeEndWaitStart_3(void)
{

    if(!CommIsTransmissonDSType()){
        if(_pCommFState->timer!=0){
            _pCommFState->timer--;
        }
        if(_pCommFState->timer  == 90){
            CommTimingSyncStart(DBC_TIM_BATTLE_MPOK);
        }
        if(CommIsTimingSync(DBC_TIM_BATTLE_MPOK)){
            _CHANGE_STATE(_dsChangeEndWaitStart,0);
        }
    }


}


static void _dsChangeEndWaitStart_2(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    CommSetTransmissonTypeMP();
    _CHANGE_STATE(_dsChangeEndWaitStart_3,120);
}

static void _dsChangeTiming(void)
{
    if(CommIsTimingSync(DBC_TIM_BATTLE_DSCHANGE)){
        _CHANGE_STATE(_dsChangeEndWaitStart_2,2);
    }
}

static void _dsChangeEndWaitStart(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    CommTimingSyncStart(DBC_TIM_BATTLE_DSEND);
    if(_pCommFState->bReturnBattle){
        _CHANGE_STATE(_battleMoveRoomReturn, 30);
    }
    else{
        _CHANGE_STATE(_battleMoveRoomEnter, 30);
    }
}


//==============================================================================
/**
 * ȂXe[g
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateNone(void)
{
    // ȂɂĂȂ
}

//==============================================================================
/**
 * @brief G[
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateConnectError(void)
{
}

//==============================================================================
/**
 * @brief  I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateEnd(void)
{
    if(CommIsInitialize()){
        return;
    }
    _stateFinalize();
}

//==============================================================================
/**
 * @brief  nEJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateUnderGroundConnectEnd(void)
{
    if(_pCommFState->timer != 0){
        _pCommFState->timer--;
        return;
    }

    CommUnderOptionFinalize();
    CommStateExitUnderGround();

    sys_DeleteHeap(HEAPID_UNDERGROUND);

    _pCommFState->bUGOverlay = FALSE; // n~߂

    _stateFinalize();   // state͂ŏI ʐM͌ォ؂
}

//==============================================================================
/**
 * @brief  IJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _directEndTiming(void)
{
    if(CommIsTimingSync(DBC_TIM_BATTLE_EXIT2)){
        CommStateSetErrorCheck(FALSE,FALSE);
        OHNO_PRINT("I---\n");
        CommPlayerManagerFinalize(TRUE);
        _CHANGE_STATE(_stateConnectAutoEnd, _EXIT_SENDING_TIME);
    }
}

//==============================================================================
/**
 * @brief  IJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _directEndNoTiming(void)
{
    CommPlayerManagerFinalize(TRUE);
    _CHANGE_STATE(_stateConnectAutoEnd, _EXIT_SENDING_TIME);
}

//==============================================================================
/**
 * @brief  IJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateConnectAutoEnd(void)
{
    if(_pCommFState->timer != 0){
        _pCommFState->timer--;
        return;
    }
//    if(CommIsConnect(CommGetConnectNum())){
//        CommSendFixData(CS_AUTO_EXIT);
  //  }
    //else{
        CommStateExitBattle();
        _CHANGE_STATE(_stateFinalize, 0);
   // }
}

//==============================================================================
/**
 * @brief  IJn
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _stateConnectEnd(void)
{
    if(_pCommFState->timer != 0){
        _pCommFState->timer--;
        return;
    }
    // ؒf
    CommFinalize();
    _CHANGE_STATE(_stateEnd, 0);
}

#ifdef PM_DEBUG
static void _debugTimerStart(void)
{
    _pCommFState->debugTimer=0;
}

static void _debugTimerDisp(char* msg)
{
    OHNO_PRINT("%s Jn %d sync ܂\n", msg, _pCommFState->debugTimer * 2);
}

#endif


#ifdef PM_DEBUG


static BOOL GMEVENT_BattleDebug(GMEVENT_CONTROL * event)
{
    if(CommIsInitialize()){
        return FALSE;
    }
    return TRUE;
}

//==============================================================================
/**
 * q@ҋ@  e@ɏ𑗐M
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildWaiting_Debug(void)
{
    
    OHNO_PRINT("ڑ CommGetConnectNum=%d CommMPGetServiceNo=%d \n",CommGetConnectNum(),CommStateGetServiceNo() );
    if(CommGetConnectNum() == (CommGetMaxEntry(CommStateGetServiceNo()))){
        CommDirectConnect_Debug();
        _CHANGE_STATE(_battleChildWaiting, 0);
    }
}

//==============================================================================
/**
 * q@ҋ@  e@ɏ𑗐M
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildSendName_Debug(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    if(!CommIsConnect(CommGetCurrentID())){
        return;
    }
    CommInfoSendPokeData();
    _CHANGE_STATE(_battleChildWaiting_Debug, 0);
}

//==============================================================================
/**
 * q@ҋ@  e@ɋ炢ifobOj
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleChildConnecting_Debug(void)
{
    if(CommMPGetGFBss(_pCommFState->connectIndex)!=NULL){
        CommStateConnectBattleChild(_pCommFState->connectIndex);  // ڑ
        _CHANGE_STATE(_battleChildSendName_Debug, _SEND_NAME_TIME);
    }
}

//==============================================================================
/**
 * og̎qƂĂ̒ʐMJn
 * @param   connectIndex ڑe@Index
 * @retval  none
 */
//==============================================================================

void CommFieldStateConnectBattleChild_Debug( FIELDSYS_WORK* pFSys, int serviceNo, int regulationNo, int connectIndex)
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
#ifdef PM_DEBUG
    CommStateEnterBattleChild(GameSystem_GetSaveData(pFSys), serviceNo, regulationNo, pFSys->regulation,FALSE, SOLO_DEBUG_NO + COMMDIRECT_DEBUG_NO);
#else
    CommStateEnterBattleChild(GameSystem_GetSaveData(pFSys), serviceNo, regulationNo, pFSys->regulation,FALSE);
#endif
    _commStateInitialize(pFSys);
    _pCommFState->connectIndex = connectIndex;
    _CHANGE_STATE(_battleChildConnecting_Debug, 0);
}


//==============================================================================
/**
 * e@Ƃđҋ@
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentWaiting_Debug(void)
{
    if(CommIsChildsConnecting()){
        OHNO_PRINT("ڑ CommGetConnectNum=%d CommMPGetServiceNo=%d \n",CommGetConnectNum(),CommStateGetServiceNo() );
        if(CommGetConnectNum() == (CommGetMaxEntry(CommStateGetServiceNo()))){
            CommDirectConnect_Debug();
            _CHANGE_STATE(_battleParentWaiting, 0);
        }
    }
}

//==============================================================================
/**
 * q@ҋ@  e@I
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentSendName_Debug(void)
{
    if(_pCommFState->timer!=0){
        _pCommFState->timer--;
        return;
    }
    if(!CommIsConnect(CommGetCurrentID())){
        return;
    }
    CommInfoSendPokeData();
    _CHANGE_STATE(_battleParentWaiting_Debug, 0);
}

//==============================================================================
/**
 * e@Ƃďs
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _battleParentInit_Debug(void)
{
    MYSTATUS* pMyStatus;
    
    if(!CommIsVRAMDInitialize()){
        return;
    }
    _CHANGE_STATE(_battleParentSendName_Debug, _SEND_NAME_TIME);
}

//==============================================================================
/**
 * og̐eƂĂ̒ʐMJn
 * @param   pFSys  tB[h\
 * @param   serviceNo  ʐMT[rXԍ
 * @param   regulationNo  ʐMT[rXԍ
 * @retval  none
 */
//==============================================================================

void CommFieldStateEnterBattleParent_Debug(FIELDSYS_WORK* pFSys, int serviceNo, int regulationNo)
{
    if(CommIsInitialize()){
        return;      // ȂĂꍇ͏O
    }
#ifdef PM_DEBUG
    CommStateEnterBattleParent(GameSystem_GetSaveData(pFSys), serviceNo, regulationNo,pFSys->regulation, FALSE,
                               SOLO_DEBUG_NO + COMMDIRECT_DEBUG_NO);
#else
    CommStateEnterBattleParent(GameSystem_GetSaveData(pFSys), serviceNo, regulationNo,pFSys->regulation, FALSE);
#endif
    _commStateInitialize(pFSys);
    _CHANGE_STATE(_battleParentInit_Debug, 0);

}

#endif


//==============================================================================
/**
 * @brief   ZbgAbv閧nObYf[^Ԃ
 * @param   sv  SAVEDATA*
 * @retval  SECRETBASEDATA*
 */
//==============================================================================

SECRETBASEDATA* CommUgSetupSecretBaseData(SAVEDATA * sv)
{
    if(!_pCommFState || !_pCommFState->bUGOverlay){
        return NULL;
    }
    return UgManUgSetupSecretBaseData(sv);
}



BOOL CommFieldStateIsUnder(void)
{
    if(_pCommFState && _pCommFState->bUGOverlay){
        return TRUE;
    }
    return FALSE;
}

void CommStateFieldUnderOptionReset(void)
{
    if(_pCommFState && _pCommFState->bUGOverlay){
       // CommSystemRecvStop(TRUE);
    //    OHNO_PRINT("ʐM~߂܂\n");
        CommUnderOptionReset();
    }
}

void CommStateFieldUnderOptionReboot(void)
{
    if(_pCommFState && _pCommFState->bUGOverlay){
        CommUnderOptionReboot();
   //    OHNO_PRINT("ʐM܂\n");
       // CommSystemRecvStop(FALSE);
    }
}

