//=============================================================================
/**
 * @file	comm_union.c
 * @brief	jI[䏈
 * @author	Akito Mori
 * @date    2005.12.10
 */
//=============================================================================

//#define OEKAKI_ONLY_TALK
//#define	RECORD_ONLY_TALK

#include "common.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "communication/wh_config.h"
#include "communication/wh.h"
#include "fieldsys.h"
#include "field/field.h"
#include "../fielddata/script/connect_def.h"
#include "../fielddata/script/union_def.h"
#include "system/wordset.h"
#include "system/pms_data.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_trtype.h"
#include "msgdata/msg_union.h"

#include "comm_command_field.h"
#include "comm_union_def.h"
#include "script.h"
#include "comm_union_beacon.h"
#include "application/trainer_card.h"
#include "tr_card_setup.h"
#include "field/union_beacon_tool.h"


#include "../application/oekaki/comm_command_oekaki.h"


#define UNION_PRINT_ON

#ifdef UNION_PRINT_ON

#define PRINT( str ) 			OS_Printf( str )
#define PRINT2( str , param) 	OS_Printf( str , param )

#else

#define PRINT( str ) 
#define PRINT2( str , param) 


#endif

//==============================================================================
//	萔錾
//==============================================================================
#define TALK_OBJ_MAX			( 10 )
#define SUB_OBJ_MAX				( TALK_OBJ_MAX*4 )
#define _PARENT_WAIT_TIME 	 	( 40 ) ///eƂĂ̂т҂
#define _CHILD_P_SEARCH_TIME 	( 12 )
#define _FINALIZE_TIME 			(  2 )
#define _EXIT_SENDING_TIME 		(  5 )
#define _CONNECT_RETRY_NUM 		(  2 )
#define _CHILD_CONNECT_WAIT		( 3*60 )

#define PARENT_UNIONROOM_TGID	( 0x1234 )

#define UNION_CHILD_STATUS_SEND_RETRY_WAIT	( 120 )

enum{
	NO_OBJ=0,
	FALL_OBJ,
	TALKOK_OBJ,
	RISE_OBJ,
};

#define START_TIME ( 40 )
#define _TCB_UNIONSTATE_PRT   (10)    ///< tB[hʐM̊Ď[`PRI

enum{
	DS_CONNECT_START=1,
	MP_CONNECT_START,
};

//==============================================================================
//	^錾
//==============================================================================

// R[obN֐̏
typedef void (*PUnionRoomFunc)(COMM_UNIONROOM_WORK *cuw);


// bOBJ̍\
typedef struct{
	u16 arrow;
	u16 status;
}MAIN_OBJ_CONT;

// bOBJ̎ɂTuOBJ̍\
typedef struct{
	u16 arrow;
	u16 status;
}SUB_OBJ_CONT;

// jI[p[N\
struct COMM_UNIONROOM_WORK{
	FIELDSYS_WORK		*fsys;
	SAVEDATA			*savedata;
	MYSTATUS			*mystatus;
	
	TCB_PTR	           UnionStateTask;
	PUnionRoomFunc     state;
	int                timer;

	u32					CommConnectId;				// ڑɂOBJID
	u32					CommConnectResult;			// ڑʂԂ
	int 				CommConnectStartFlag;
	int 				CommConnectStartWait;
	int					CommConnectRetry;
	int					CommNextProcOn;
	u32					CommChildSelectEvent;
	u32					ScriptSelectWork;			// Iʂۑ
	u32					InviteWork;					// ʐMŒ񎦂ꂽeۑ
	u32					ScriptYesNoWork;			// ͂Ěʂۑ

	u32					UnionEventWork;				// seiJ[hE퓬EE`bgj
	u32					UnionEndConnectFlag;		// ʐMI
	
	MAIN_OBJ_CONT	   MainObjCont[TALK_OBJ_MAX];		// bPOl
	SUB_OBJ_CONT	   SubObjCont[SUB_OBJ_MAX];		// C̎ɂSliPOj
	WMBssDesc		   *UnionBeaconTbl[SCAN_PARENT_COUNT_MAX];

	MATHRandContext32  pRand;						// WEPL[
	int connectIndex;

	int objwork;
	int objwait;

	u16 busyflag;
	u8  battleSelect[2];							// 퓬Õ|PXǧʂM

	PMS_DATA			MyPmsData;					// X^[gj[́u`bgvŊȈՉbݒ肵ꍇ
	BOOL				MyPmsPutFlag;				// ̗̈ɍ쐬ȈՉbRs[

	TR_CARD_DATA 		*my_trcard;					// ̃g[i[J[h
	TR_CARD_DATA 		*recv_trcard[2];			// ̃g[i[J[h

#ifdef PM_DEBUG
    u32					debugTimer;
#endif
};


/*** ֐vg^Cv ***/
static COMM_UNIONROOM_WORK* _commStateInitialize(FIELDSYS_WORK* fsys);
static void _UnionStart(COMM_UNIONROOM_WORK *cuw);
static void _UnionRestart( COMM_UNIONROOM_WORK *cuw );
static void _changeState(COMM_UNIONROOM_WORK *cuw, PUnionRoomFunc state, int time);
static void _stateConnectEnd(COMM_UNIONROOM_WORK *cuw);
static void _stateEnd(COMM_UNIONROOM_WORK *cuw);
static void CommStateFinalize(COMM_UNIONROOM_WORK *cuw);
static void _underChildConnecting(COMM_UNIONROOM_WORK *cuw);
static void _underParentInfoSend(COMM_UNIONROOM_WORK *cuw);
static void _underParentConnect(COMM_UNIONROOM_WORK *cuw);
static void _underChildSelectWait(COMM_UNIONROOM_WORK *cuw);
static void _underChildInfoSendSuccess( COMM_UNIONROOM_WORK *cuw );
static void _ConnectInfoClear( COMM_UNIONROOM_WORK *cuw );
static void _underChildEndEventState( COMM_UNIONROOM_WORK *cuw );
static void CommUnion_EventFlagClear( COMM_UNIONROOM_WORK *cuw);
static int  MyStatusCheck( void );
static int GetGroupTalk_ListenNo( COMM_UNIONROOM_WORK *cuw, int no );
static int GetStartTalk_No(int event, int sex, WORDSET *wordset );
static void _UnionBeaconSet( COMM_UNIONROOM_WORK *cuw );


static void UnionBeaconClear( UNION_BEACON_STATE *beacon );






//==============================================================================
/**
 * jI[ɂ͂̒ʐM
 * @param   pFSys FIELDSYS_WORK
 * @retval  none
 */
//==============================================================================
COMM_UNIONROOM_WORK *Comm_UnionRoomInit(FIELDSYS_WORK* fsys)
{

	COMM_UNIONROOM_WORK *cuw = NULL;

	GF_ASSERT(fsys!=NULL && "fsysNULL");

    if(fsys->union_work!=NULL){ // ȂĂꍇ͏O
        return NULL;
    }
    // ʐMq[v쐬
    if(sys_CreateHeapLo( HEAPID_BASE_APP, HEAPID_UNIONROOM, 0xa80 )){
		OS_Printf("HEAPID_UNION 쐬\n");
	}

	// jI[[Nm
    cuw = _commStateInitialize(fsys);
	if(cuw==NULL){
		cuw = fsys->union_work;
	}

	// tB[hpʐMR}hR[obNݒ
    CommCommandFieldInitialize((void*)fsys);

	// ʐMڑlQlɐ
    CommStateSetLimitNum(2);
	

//  CommStateUnionBconCollection( SaveData_GetMyStatus(GameSystem_GetSaveData(fsys)) );

    // nXe[g̑Jڂ̂ߏ
	PRINT("Unionq@Jn\n");
    _changeState(cuw, _UnionBeaconSet, START_TIME);
	OS_Printf("sizeof(MYSTATUS)=%d \n",MyStatus_GetWorkSize());

	OS_Printf("COMM_UNIONROOM_WORK =%d \n",sizeof(COMM_UNIONROOM_WORK));

	return cuw;
}
#ifdef PM_DEBUG

static COMM_UNIONROOM_WORK *debug_cuw;

#endif
//==============================================================================
/**
 * jI[oƂ
 *
 * @param   fsys		
 *
 * @retval  none		
 */
//==============================================================================
void Comm_UnionFinalize(FIELDSYS_WORK *fsys)
{
    if(fsys->union_work==NULL){  // łɏIĂ
       return;
    }
    _changeState(fsys->union_work, _stateConnectEnd, _EXIT_SENDING_TIME);
}


//------------------------------------------------------------------
/**
 * jI[V[PX
 *
 * @param   fsys		
 *
 * @retval  COMM_UNIONROOM_WORK*		
 */
//------------------------------------------------------------------
static COMM_UNIONROOM_WORK* _commStateInitialize(FIELDSYS_WORK* fsys)
{
    void* pWork;
	SAVEDATA *savedata;
	COMM_UNIONROOM_WORK *cuw = NULL;

    if(fsys->union_work!=NULL){   // łɃjI쒆̏ꍇ͌̃mۏKvȂ
        return NULL;
    }
	savedata    = GameSystem_GetSaveData(fsys);

    // UNION[BCONWJn
    CommStateUnionBconCollection( savedata );


    // 
    cuw = (COMM_UNIONROOM_WORK*)sys_AllocMemory(HEAPID_UNIONROOM, sizeof(COMM_UNIONROOM_WORK));
	MI_CpuClear8(cuw, sizeof(COMM_UNIONROOM_WORK) );
    cuw->state = NULL;   // Ȃ
    cuw->timer = START_TIME;
    cuw->UnionStateTask = TCB_Add(_commCheckFunc, cuw, _TCB_UNIONSTATE_PRT);
    cuw->fsys     = fsys;
	cuw->savedata = savedata;
	cuw->mystatus    = SaveData_GetMyStatus(savedata);
//	cuw->partner_trcard = (TR_CARD_DATA*)sys_AllocMemory(HEAPID_BASE_SYSTEM, 1624+16);
//	cuw->my_trcard      = (TR_CARD_DATA*)sys_AllocMemory(HEAPID_BASE_SYSTEM, 1624+16);
	

	CommUnion_EventFlagClear(cuw);

//    _debugTimerStart();
    CommRandSeedInitialize(&cuw->pRand);

#ifdef PM_DEBUG
	debug_cuw = cuw;
#endif
	return cuw;
}	



//------------------------------------------------------------------
/**
 * @brief   jI[JnɃr[R
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _UnionBeaconSet( COMM_UNIONROOM_WORK *cuw )
{
	PMS_DATA pmsdata;

	if(CommMPIsInitialize()){
		// jI[ftHgbZbg
		PMSDAT_SetupDefaultUnionMessage( &pmsdata );
		// r[Rf[^ɔf
		Union_PMSReWrite( &pmsdata );		
		Union_SetMyPmsData( cuw, &pmsdata );		// jI[NŕۑĂʂɕ\
	    _changeState(cuw, _UnionStart, START_TIME);
	}
}

static int debug_parent;

//==============================================================================
/**
 * jI[X^[gyjI^XNJځz
 * @param   none
 * @retval  none
 */
//==============================================================================

#define _FIRST_SEND	( 0 )

static void _UnionStart(COMM_UNIONROOM_WORK *cuw)
{
	// e@ڑꂽH
    if(CommStateIsUnionParentConnectSuccess()){
        OS_TPrintf("e@ڑ\n");
		debug_parent = 0;
		_changeState(cuw, _underParentInfoSend, _FIRST_SEND);
        return;
    }

	// bn߂H
    if(cuw->CommConnectStartFlag!=0){
        cuw->CommConnectRetry = _CONNECT_RETRY_NUM;
        /// indexŐڑJn܂
		if(cuw->CommConnectStartFlag == DS_CONNECT_START){
				if(cuw->CommChildSelectEvent==UNION_CHILD_SELECT_RECORD){
					// R[hR[i[q@ڑJn
					CommStateUnionRecordCornerChild(cuw->CommConnectId);
				}else {
					// ʏq@ڑJn
			        CommStateUnionConnectStart(cuw->CommConnectId);   
				}
		}else if(cuw->CommConnectStartFlag == MP_CONNECT_START){
            // ʐMR}hXgpɕύX
            CommCommandOekakiBoardInitialize( NULL );
			CommStateUnionPictureBoardChild(cuw->CommConnectId);
		}
		
        _changeState(cuw, _underChildConnecting, _CHILD_P_SEARCH_TIME);
		return;
	}
}

//------------------------------------------------------------------
/**
 * $brief   ʐMIؒfVт߂ĂƂ̃V[PX
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _UnionRestart( COMM_UNIONROOM_WORK *cuw )
{
	// ʐMVXeĊJ܂
    if(CommStateUnionIsRestartSuccess()==TRUE){
		
	    // tB[hpʐMR}hR[obNɖ߂
    	CommCommandFieldInitialize((void*)cuw->fsys);

        _changeState(cuw, _UnionStart, _FINALIZE_TIME);
		
	}
}

//------------------------------------------------------------------
/**
 * $brief   ݎq@lڑĂ邩H
 *
 * @param   none		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int MyStatusCheck( void )
{
	int i,result;
	MYSTATUS *status;

	result = 0;

	// 1`SȂ̂Ŏq@̃Xe[^XM̂m
	for(i=1;i<5;i++){
		status = CommInfoGetMyStatus(i);
		if(status!=NULL){
			result++;
		}
	}

	// Nq@炫H
	return (result>=1);
}


//==============================================================================
/**
 * e@ɂȂ byjI^XNJځz
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentInfoSend(COMM_UNIONROOM_WORK *cuw)
{
    if(cuw->timer>0){
        cuw->timer--;
        return;
    }
	
	OS_Printf("e@ڑ%d\n", debug_parent);
	debug_parent++;
    if(CommIsChildsConnecting() && MyStatusCheck()==1){   // 
		// e̊{f[^M
        CommInfoSendPokeData();
		
		// q@Ȃ̂G[ɂ邩ǂSET
        CommStateSetErrorCheck(TRUE,TRUE);

		// fsysNULL̂ƂB
		// e@ƂĂ̐ڑCxgJn
//		EventSet_Script( cuw->fsys, SCRID_CONNECT_UNION_RECEIVE_OBJ, NULL );

		// up[eB[ɂȂvr[Rɕς
		Union_BeaconChange( UNION_PARENT_MODE_PARTY );
		_changeState(cuw,_underParentConnect, _FIRST_SEND);
	}

	// ؒfĂ猳ɂǂ
	if(CommStateIsUnionParentConnectSuccess()==0){
    	CommStateUnionBconCollectionRestart();
		CommUnion_EventFlagClear(cuw);
		Union_BeaconChange( UNION_PARENT_MODE_FREE );
	    _changeState(cuw,_UnionRestart, _FINALIZE_TIME);
		
	}

}


//------------------------------------------------------------------
/**
 * $brief   e@ڑ(Ƃ̓R[obNɂ܂j
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _underParentConnect(COMM_UNIONROOM_WORK *cuw)
{
    if(CommIsChildsConnecting()){   // ȊOȂe@Œ
		
	}else{
	
	}

	// ؒf̂Ō̑ɖ߂
    if(0 == CommIsChildsConnecting()){
		// ڑŝŁAIČ̐eq؂ւ̗ɖ߂
//    	CommCommandFieldInitialize((void*)cuw->fsys);
		OS_TPrintf("q@؂ꂽ bitmap=%02x status=%d connectnum=%d childconnect=%d\n", WH_GetBitmap(), MyStatusCheck(), CommGetConnectNum(), CommIsChildsConnecting());
    	CommStateUnionBconCollectionRestart();
		CommUnion_EventFlagClear(cuw);
		Union_BeaconChange( UNION_PARENT_MODE_FREE );
	    _changeState(cuw,_UnionRestart, _FINALIZE_TIME);
    }


}

//==============================================================================
/**
 * ʐMǗXe[g̕ύX
 * @param   state  ςXe[g̊֐
 * @param   time   Xe[gێ
 * @retval  none
 */
//==============================================================================

static void _changeState(COMM_UNIONROOM_WORK *cuw, PUnionRoomFunc state, int time)
{
	
    cuw->state = state;
    cuw->timer = time;
}

//==============================================================================
/**
 * ʐMǗXe[g̏
 * @param
 * @retval  none
 */
//==============================================================================

static WMBssDesc *debugBsstable[16];

void _commCheckFunc(TCB_PTR tcb, void* work)
{
	COMM_UNIONROOM_WORK *cuw = (COMM_UNIONROOM_WORK*)work;
#ifdef PM_DEBUG
    cuw->debugTimer++;
#endif

#ifdef PM_DEBUG

	if(sys.trg&PAD_BUTTON_START){
		UNION_BEACON_STATE state;
//		if(cuw->busyflag = UNION_PARENT_MODE_FREE){
//			cuw->busyflag = UNION_PARENT_MODE_BUSY;

//			MI_CpuClear8(&state, sizeof(UNION_BEACON_STATE) );
//			state.c_face[0] = 1;
//			state.mode      = UNION_PARENT_MODE_BUSY;

//		}else{
//			cuw->busyflag = UNION_PARENT_MODE_FREE;
//			state.mode = UNION_PARENT_MODE_FREE;
//		}
//		CommMPSetMyRegulation(&state);	// uZvɃr[R
//		CommMPFlashMyBss();
	}

	if(sys.trg&PAD_BUTTON_SELECT){
		OS_Printf("̍ԍ %d \n",MyStatus_GetRegionCode( cuw->mystatus ));
	}
#endif

    if(cuw==NULL){
        TCB_Delete(tcb);
    }
    else{
		int i;
		WMBssDesc *tmp;

		for(i=0;i<SCAN_PARENT_COUNT_MAX;i++){
			cuw->UnionBeaconTbl[i] = CommMPGetWMBssDesc(i);
			debugBsstable[i]       = cuw->UnionBeaconTbl[i]; 
		}


        if(cuw->state != NULL){
            cuw->state(cuw);
        }
    }
}


//==============================================================================
/**
 * @brief  IJn
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _stateConnectEnd(COMM_UNIONROOM_WORK *cuw)
{
    if(cuw->timer != 0){
        cuw->timer--;
        return;
    }
    // ؒf
    CommStateExitUnion();
    _changeState(cuw,_stateEnd, 0);
}

//------------------------------------------------------------------
/**
 * ʐMIV[PX
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _stateEnd(COMM_UNIONROOM_WORK *cuw)
{
    if(CommIsInitialize()){
        return;
    }
    CommStateFinalize(cuw);
}

//==============================================================================
/**
 * q@ƂȂĐڑyjI^XNJځz
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _underChildConnecting(COMM_UNIONROOM_WORK *cuw)
{
    if(1 == CommStateIsUnionConnectSuccess()){
        
//      CommStateSetErrorCheck(TRUE,TRUE);

		// ڑȂe@ɏ𑗂
        CommInfoSendPokeData();
		_changeState(cuw,_underChildInfoSendSuccess, 3);
        OS_TPrintf("e@ɐڑ̂Ŏq@񑗐M\n");
        return;
    }else if(CommIsChildsConnecting()){   
		// tɐeƂČqB(j
		cuw->CommConnectStartFlag = 0;
		cuw->CommConnectResult    = UNION_CONNECT_PARENT;
		
        OS_TPrintf("ڑɂ肪e@ڑ\n");
        _changeState(cuw,_underParentInfoSend, 0);
	}
    if(0 == CommStateIsUnionConnectSuccess()){
		// ڑҋ@
        OS_TPrintf("ڑȂ\n");
        return;
    }
	// ڑŝŁACxg̏I҂Č̐eq؂ւ̗ɖ߂
   	_changeState(cuw,_underChildEndEventState, _FINALIZE_TIME);
	cuw->CommConnectStartWait = 0;
	cuw->CommConnectResult    = UNION_CONNECT_FAILED;
	cuw->CommConnectStartFlag = 0;
	cuw->UnionEndConnectFlag  = 0;
}

//------------------------------------------------------------------
/**
 * @brief   q@ڑɎsCxgI҂
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _underChildEndEventState( COMM_UNIONROOM_WORK *cuw )
{
	if(!FieldEvent_Check(cuw->fsys)){

	    CommStateUnionBconCollectionRestart();
		CommUnion_EventFlagClear(cuw);
		Union_BeaconChange( UNION_PARENT_MODE_FREE );
   		_changeState(cuw,_UnionRestart, _FINALIZE_TIME);

	}
	
}

//------------------------------------------------------------------
/**
 * @brief   q@̏񑗐M
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _underChildInfoSendSuccess( COMM_UNIONROOM_WORK *cuw )
{

	// ڑ
    if(1 == CommStateIsUnionConnectSuccess()){
		if(CommInfoGetMyStatus(CommGetCurrentID())!=NULL){
			PRINT("ڑIIII\n");
			cuw->CommConnectStartFlag = 0;
			cuw->CommConnectResult    = UNION_CONNECT_SUCCESS;
			cuw->UnionEndConnectFlag  = 0;

	        CommStateSetErrorCheck(TRUE,TRUE);
			_changeState(cuw,_underChildSelectWait, 3);
		}
		OS_Printf("q@ڑ\n");
    }else if(0 == CommStateIsUnionConnectSuccess()){
	// ڑ؂ꂽ
		
		OS_Printf("ڑ؂ꂽǂăCxgȂH\n");
		
    	//CommCommandFieldInitialize((void*)cuw->fsys);
	    CommStateUnionBconCollectionRestart();
		CommUnion_EventFlagClear(cuw);
    	_changeState(cuw,_UnionRestart, _FINALIZE_TIME);

		cuw->CommConnectStartWait = 0;
		cuw->CommConnectResult    = UNION_CONNECT_FAILED;
		cuw->CommConnectStartFlag = 0;
		cuw->UnionEndConnectFlag  = 0;
	}
	
}

//------------------------------------------------------------------
/**
 * $brief   q@ƂĒʐMڑ̓R[obN֐
 *          邱Ƃ̂ŁAؒf͌n悤ɂyjI^XNJځz
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void  _underChildSelectWait(COMM_UNIONROOM_WORK *cuw)
{
//    if(cuw->timer==1){
//        CommInfoSendPokeData();
//    }

    if(0 == CommStateIsUnionConnectSuccess()){
    	//CommCommandFieldInitialize((void*)cuw->fsys);
	    CommStateUnionBconCollectionRestart();
		CommUnion_EventFlagClear(cuw);
    	_changeState(cuw,_UnionRestart, _FINALIZE_TIME);
		return ;
	}
    // ڑ^CAEg
//    if(cuw->timer!=0){
//        cuw->timer--;
//        return;
//    }
}

//------------------------------------------------------------------
/**
 * jIʐMp[N
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CommStateFinalize(COMM_UNIONROOM_WORK *cuw)
{
    void* pWork;

    if(cuw==NULL){  // łɏIĂ
        return;
    }
    TCB_Delete(cuw->UnionStateTask);
//    sys_FreeMemoryEz(cuw->partner_trcard);
  //  sys_FreeMemoryEz(cuw->my_trcard);
    sys_FreeMemoryEz(cuw);
    sys_DeleteHeap(HEAPID_UNIONROOM);
//    cuw = NULL;
}



//==============================================================================
/**
 * COMM_UNIONROOM_WORKĂFIELDSYS_WORK̃|C^Ԃ
 *
 * @param   cuw		
 *
 * @retval  FIELDSYS_WORK*		
 */
//==============================================================================
FIELDSYS_WORK* Union_FielsSysPtrGet(COMM_UNIONROOM_WORK *cuw)
{
	return cuw->fsys;
}

//==============================================================================
/**
 * ʐM擾r[R̃|C^Ԃ(comm_union_view.cp)
 *
 * @param   cuw		
 * @param   no		
 *
 * @retval  WMBssDesc*		
 */
//==============================================================================
WMBssDesc* Union_BeaconPtrGet(COMM_UNIONROOM_WORK *cuw, int no)
{
	return cuw->UnionBeaconTbl[no];
}

//==============================================================================
/**
 * $brief   
 *
 * @param   cuw		
 *
 * @retval  int		
 */
//==============================================================================
int Union_ConnectIndexGet(COMM_UNIONROOM_WORK *cuw)
{
	return cuw->connectIndex;
}

static UNION_BEACON_STATE *debug_beacon;

//==============================================================================
/**
 * bOBJIDĐڑ̂߂ɏƂĎg
 *
 * @param   cuw			COMM_UNIONROOM_WORK
 * @param   no			OBJID(Ƃ-1j
 *
 * @retval  int			ʐMJnł邩HǂԂ
 *						UNION_PARENT_CONNECT_OK:b|ʐMł
 *						UNION_PARENT_OEKAKI_OK:GʐMł
 *						UNION_PARENT_CONNECT_NG:ʐMłȂ
 */
//==============================================================================
int Union_ConnectIdSet( COMM_UNIONROOM_WORK *cuw, int no )
{
	MYSTATUS *status;
	_GF_BSS_DATA_INFO *gfbssdata;
	UNION_BEACON_STATE *beaconState;
	// XNvǵ{Pł̂łP
	no--;
	
	status       = CommMPGetBconMyStatus( no );

	// b|O[NNA
	Union_CommWorkClear( cuw );

	// statusNULLꍇ͘b|Ɏsi߂񂢂񂾁j
	if(status==NULL){
		return UNION_PARENT_CONNECT_NG;
	}

	gfbssdata    = (_GF_BSS_DATA_INFO *)cuw->UnionBeaconTbl[no]->gameInfo.userGameInfo;
	beaconState  = (UNION_BEACON_STATE *)gfbssdata->regulationBuff;
	debug_beacon = beaconState;

	OS_Printf("r[R%d \n",beaconState->mode);

#ifdef OEKAKI_ONLY_TALK
	return UNION_PARENT_OEKAKI_OK;
#endif

	switch(beaconState->mode){
	case UNION_PARENT_MODE_FREE:
		return UNION_PARENT_CONNECT_OK;
		break;
	case UNION_PARENT_MODE_OEKAKI_FREE:
		return UNION_PARENT_OEKAKI_OK;
		break;
	case UNION_PARENT_MODE_RECORD_FREE:
		return UNION_PARENT_RECORD_OK;
		break;
	case UNION_PARENT_MODE_GURUGURU_FREE:
		return UNION_PARENT_GURUGURU_OK;
		break;
	case UNION_PARENT_MODE_BUSY:		case UNION_PARENT_MODE_CARDNOW:	case UNION_PARENT_MODE_BATTLENOW:
	case UNION_PARENT_MODE_TRADENOW:	case UNION_PARENT_MODE_OEKAKINOW: case UNION_PARENT_MODE_PARTY:
		return UNION_PARENT_CONNECT_NG;
		break;
	}
	return UNION_PARENT_CONNECT_NG;
}


//==============================================================================
/**
 * $brief   ̃r[RԂmFŐڑɍs
 *
 * @param   cuw		
 * @param   no		OBJIDi{PĂ̂-1Ĉj
 *
 * @retval  int		UNION_CONNECT_OKUNION_CONNECT_NG
 */
//==============================================================================
int Union_ConnectStart( COMM_UNIONROOM_WORK *cuw, int objno, u16 type )
{
	MYSTATUS *status;
	_GF_BSS_DATA_INFO *gfbssdata;
	UNION_BEACON_STATE *beaconState;
	// XNvǵ{Pł̂łP
	objno--;
	
	status      = CommMPGetBconMyStatus( objno );
	gfbssdata   = (_GF_BSS_DATA_INFO *)cuw->UnionBeaconTbl[objno]->gameInfo.userGameInfo;
	beaconState = (UNION_BEACON_STATE *)gfbssdata->regulationBuff;
	debug_beacon = beaconState;


	// ̒ʐMԂmFĐڑONNG𔻒f
	switch(beaconState->mode){
	// t[ER[hR[i[WE邮W̏ꍇ̓f[^VFAOʐM
	case UNION_PARENT_MODE_GURUGURU_FREE:
		if(type!=UNION_PARENT_GURUGURU_OK){
			return UNION_PARENT_CONNECT_NG;
		}
		cuw->CommChildSelectEvent = UNION_CHILD_SELECT_GURUGURU;
		cuw->CommConnectId        = objno;
		cuw->CommConnectStartFlag = MP_CONNECT_START;
		cuw->CommConnectStartWait = 0;
		cuw->CommConnectResult    = UNION_CONNECT_BUSY;
		return UNION_PARENT_CONNECT_OK;
		break;
	case UNION_PARENT_MODE_RECORD_FREE:
		if(type!=UNION_PARENT_RECORD_OK){
			return UNION_PARENT_CONNECT_NG;
		}
		cuw->CommChildSelectEvent = UNION_CHILD_SELECT_RECORD;
		cuw->CommConnectId        = objno;
		cuw->CommConnectStartFlag = DS_CONNECT_START;
		cuw->CommConnectStartWait = 0;
		cuw->CommConnectResult    = UNION_CONNECT_BUSY;
		return UNION_PARENT_CONNECT_OK;
		break;
	case UNION_PARENT_MODE_FREE:
		if(type!=UNION_PARENT_CONNECT_OK){
			return UNION_PARENT_CONNECT_NG;
		}
		cuw->CommConnectId        = objno;
		cuw->CommConnectStartFlag = DS_CONNECT_START;
		cuw->CommConnectStartWait = 0;
		cuw->CommConnectResult    = UNION_CONNECT_BUSY;
		return UNION_PARENT_CONNECT_OK;
		break;
	// W̏ꍇMPʐM
	case UNION_PARENT_MODE_OEKAKI_FREE:
		if(type!=UNION_PARENT_OEKAKI_OK){
			return UNION_PARENT_CONNECT_NG;
		}
		cuw->CommConnectId        = objno;
		cuw->CommConnectStartFlag = MP_CONNECT_START;
		cuw->CommConnectStartWait = 0;
		cuw->CommConnectResult    = UNION_CONNECT_BUSY;
		return UNION_PARENT_CONNECT_OK;
		break;
	// ʐM̏ꍇ͎󂯓ԂɖƂ͐ڑȂ
	case UNION_PARENT_MODE_BUSY:		case UNION_PARENT_MODE_CARDNOW:	case UNION_PARENT_MODE_BATTLENOW:
	case UNION_PARENT_MODE_TRADENOW:	case UNION_PARENT_MODE_OEKAKINOW: case UNION_PARENT_MODE_PARTY:
		return UNION_PARENT_CONNECT_NG;
		break;

	}
	GF_ASSERT(0);

	return 0;
}

//==============================================================================
/**
 * bŐڑĂ݂ʂԂ
 *
 * @param   cuw		COMM_UNIONROOM_WORK
 *
 * @retval  u32		0:r	1:	2:s	3:eɂȂ
 */
//==============================================================================
u32 Union_ConnectResultGet(COMM_UNIONROOM_WORK *cuw )
{
	return cuw->CommConnectResult;
}



//==============================================================================
/**
 * XNvgɃjI[seԂ
 *
 * @param   cuw		
 *
 * @retval  u32		
 */
//==============================================================================
u32 Union_ParentStartCommandSet( COMM_UNIONROOM_WORK *cuw )
{
//	u8 start;
//	if(cuw->CommNextProcOn){
//		cuw->CommNextProcOn = 0;
//		start = 1;
//		return cuw->UnionEventWork;
//	}

	// ʐMqĂԂ͐e@̃R}hԂAؒfꂽꍇ͂ɏIn
	if(cuw->UnionEndConnectFlag){
		return UNION_CHILD_SELECT_CANCEL;
	}

	if(CommGetConnectNum()<2){
		return UNION_CHILD_SELECT_CANCEL;
	}

	if(CommGetCurrentID()==0){
		// e@ڑ̎̐ڑmF
		if(CommStateIsUnionParentConnectSuccess()==TRUE){
			return cuw->UnionEventWork;
		}
	}else{
		// q@ڑ̎̐ڑmF
		if(CommStateIsUnionConnectSuccess()==TRUE){
			return cuw->UnionEventWork;
		}
	}
	return UNION_CHILD_SELECT_CANCEL;
	
}


//==============================================================================
/**
 * q@̑IeXNvgɒʒm
 *
 * @param   cuw		
 *
 * @retval  u32		
 */
//==============================================================================
u32 Union_ChildSelectCommandSet( COMM_UNIONROOM_WORK *cuw )
{
	OS_TPrintf("e@q@̑I҂ ڑ=%d\n",CommStateIsUnionParentConnectSuccess());

	// e@ڑ̎̐ڑmF
	if(CommStateIsUnionParentConnectSuccess()==TRUE){
		return cuw->CommChildSelectEvent;
	}
	
	// qĂȂ̂ŁALZ
	return UNION_CHILD_SELECT_CANCEL;
}
//==============================================================================
/**
 * XNvgŏꂽǏʂ炤
 *
 * @param   cuw			COMM_UNIONROOM_WORK
 * @param   var			XNvgsI̎
 * @param   result		ʁiIɂĈႤj
 *
 * @retval  none		
 */
//==============================================================================
void Union_ScriptResultGet( COMM_UNIONROOM_WORK *cuw, int var, u32 result)
{
	u8 command = (u8)result;
	
	switch(var){
	case 0:
		if(cuw->UnionEndConnectFlag==0){
			PRINT2("Ie%d\n",result);
			cuw->ScriptSelectWork = command;
			CommSendData(CU_PLAYER_SELECT,&command,1);
		}
		break;
	case 1:
		// ê͂Eɂ
		if(result==0){
			u8 start = cuw->CommChildSelectEvent;
			CommSendData_ServerSide(CU_START_NEXT, &start, 1);
			cuw->ScriptYesNoWork = result;
		}else{
			u8 start = UNION_CHILD_SELECT_CANCEL;					//e@͂I񂾂̂ŁuLZv𑗐M
			CommSendData_ServerSide(CU_START_NEXT, &start, 1);
			cuw->ScriptYesNoWork = result;
		}
		break;
	}
}


















//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// comm_command_field.cɓo^ĂʐMR[obN֐Q
//------------------------------------------------------------------------------


void CommUnionRecvStatus(int netID, int size, void* pBuff, void* pWork)
{
	PRINT("Xe[^XM\n");
}

void CommUnionRecvTalk(int netID, int size, void* pBuff, void* pWork)
{
	PRINT2("%d̉bM\n",netID);	
}


//==============================================================================
/**
 * $brief   eCGXi͂ĂȂj
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionRecvYes(int netID, int size, void* pBuff, void* pWork)
{
	PRINT2("%d  xdr\n",netID);	
	
}
//==============================================================================
/**
 * $brief   emnƌĂƂ̃R[obN
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionRecvNo(int netID, int size, void* pBuff, void* pWork)
{
	FIELDSYS_WORK *fsys = (FIELDSYS_WORK *)pWork;

	PRINT2("%d  mn\n",netID);
	// LẐŐؒfEr[RW֕A
	//	CommStateExitUnion();
   	_changeState(fsys->union_work, _UnionStart, _FINALIZE_TIME);
	CommUnion_EventFlagClear(fsys->union_work);

}

static int debug_union_select;

//==============================================================================
/**
 * q@̑IeM
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionRecvSelect(int netID, int size, void* pBuff, void* pWork)
{
	FIELDSYS_WORK *fsys = (FIELDSYS_WORK *)pWork;
	u8 *no = (u8*)pBuff;
	
	// IR}h󂯎ĂȂΑICxg̗p
	if(fsys->union_work->UnionEndConnectFlag==0){
		fsys->union_work->CommChildSelectEvent = *no;
		debug_union_select = *no;
	}

	PRINT("IM\n");
	

}

//==============================================================================
/**
 * X^[gf[^MR[obN
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionStartNext(int netID ,int size, void* pBuff, void* pWork)
{
	FIELDSYS_WORK *fsys = (FIELDSYS_WORK *)pWork;
	u8 *no = (u8*)pBuff;
	
	PRINT("CxgJnR}h\n");

	// CxgJntOĂie@ɃCxgJnR}h𔭍sj
	fsys->union_work->CommNextProcOn = 1;

	// e@JnCxg̎ނĂie@ɂ͂j
	fsys->union_work->UnionEventWork = *no;

	if(*no == UNION_CHILD_SELECT_OEKAKI){
		CommStateUnionPictureBoardChange();
//		_changeState(fsys->union_work, _UnionRestart, 0);
	}

}

//==============================================================================
/**
 * ʐMIf[^MR[obN
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionEndConnect(int netID ,int size, void* pBuff, void* pWork)
{
	FIELDSYS_WORK *fsys = (FIELDSYS_WORK *)pWork;

	// ʐMIR}h
	fsys->union_work->UnionEndConnectFlag = 1;

	OS_TPrintf("e@IR}h󂯎\n");
}


//==============================================================================
/**
 * @brief   ڑItOԂ
 *
 * @param   cuw		
 *
 * @retval  int		
 */
//==============================================================================
int Union_CancelRecv( COMM_UNIONROOM_WORK *cuw )
{
	return cuw->UnionEndConnectFlag;
}

//==============================================================================
/**
 * @brief   e@LZ𑗐M
 *
 * @param   core->fsys->union_work		
 *
 * @retval  none		
 */
//==============================================================================
int Union_ParentSendCancel( COMM_UNIONROOM_WORK *cuw, int mes )
{
	// q@̃CxgIĂȂΑM
	if(cuw->CommChildSelectEvent==0){
		CommSendData( CU_END_CONNECT_SERVER, NULL, 0);
		return mes;
	}

	return 0;
}

//==============================================================================
/**
 * $brief   g[i[J[hf[^̃Rs[
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionRecvTrainerCard(int netID ,int size, void* pBuff, void* pWork )
{
	FIELDSYS_WORK *fsys      = (FIELDSYS_WORK *)pWork;
	TR_CARD_DATA  *trcard    = (TR_CARD_DATA*)pBuff;
	MYSTATUS	  *friend    = CommInfoGetMyStatus(CommGetCurrentID()^1);
	void          *fnoteWork;

//	OS_Printf("id = %d  size = %d ",netID, size);
	// ƈႤhc̐l̃g[i[J[hf[^Rs[
//	if(netID!=CommGetCurrentID()){
//		MI_CpuCopyFast( pBuff, fsys->union_work->recv_trcard[ne,  size );
//	}

	{
		int i,tmp=0;
		u8 *p = (u8*)pBuff;
		for(i=0;i<sizeof(TR_CARD_DATA);i++){
			tmp ^= p[i];
		}
		OS_Printf(" recv id = %d  xor %d \n", netID, tmp);
	}
	trcard->reached = 1;

	// `m[g
	if(netID!=CommGetCurrentID()){
		fnoteWork = FNOTE_SioUnionGreetDataMake(  (STRCODE*)MyStatus_GetMyName(friend),  MyStatus_GetMySex(friend), HEAPID_UNIONROOM );
		FNOTE_DataSave( fsys->fnote, fnoteWork, FNOTE_TYPE_SIO );
	}
}


//------------------------------------------------------------------
/**
 * $brief   g[i[J[hf[^MR[obN֐
 *
 * @param   netID		
 * @param   pWork		
 * @param   size		
 *
 * @retval  u8*		
 */
//------------------------------------------------------------------
u8* getTrainerCardRecvBuff( int netID, void* pWork, int size)
{
	FIELDSYS_WORK *fsys       = (FIELDSYS_WORK *)pWork;
	COMM_UNIONROOM_WORK *cuw  = fsys->union_work;

	
	return (u8*)cuw->recv_trcard[netID];
}


//------------------------------------------------------------------
/**
 * $brief   퓬O|PXgʎ擾֐
 *
 * @param   netID		
 * @param   pWork		
 * @param   size		
 *
 * @retval  u8*		
 */
//------------------------------------------------------------------
void CommUnionRecvBattlePokeListResult(int netID ,int size, void* pBuff, void* pWork )
{
	FIELDSYS_WORK *fsys       = (FIELDSYS_WORK *)pWork;
	COMM_UNIONROOM_WORK *cuw  = fsys->union_work;
	u8 *result				  = (u8*)pBuff;

	OS_TPrintf("id = %d   %d\n", netID, *result);

	cuw->battleSelect[netID] = *result;

}



//==============================================================================
/**
 * @brief   퓬O|PXgĂ񂾌ʂ͂ǂH
 *
 * @param   cuw		
 *
 * @retval  u16		
 */
//==============================================================================
u16  Union_GetBattleStartCheckResult( COMM_UNIONROOM_WORK *cuw )
{
	int myid = CommGetCurrentID();
	
	// LZ
	if(cuw->battleSelect[myid]==UNION_BATTLE_POKELIST_NG){
		return UNION_BATTLE_MY_CANCEL;
	}

	// ɃLZꂽ
	if(cuw->battleSelect[myid^1]==UNION_BATTLE_POKELIST_NG){
		return UNION_BATTLE_PARTNER_CANCEL;
	}

	// oOK
	return UNION_BATTLE_OK;
}

//==============================================================================
/**
 * @brief   jI[Õ|PXg̑Iʂ𑗐M
 *
 * @param   result		
 *
 * @retval  none		
 */
//==============================================================================
void Union_BattlePokeListResult( int result )
{
	u8	command = result;
	CommSendData( CU_BATTLE_PLIST_RET,&command, 1 );
}






//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// jI[pc[
//------------------------------------------------------------------------------


#define TALK_CARD_MAX		( 2 )
#define TALK_TRADE_MAX		( 2 )
#define TALK_BATTLE_MAX		( 4 )
#define TALK_OEKAKI_MAX		( 4 )
#define TALK_RECORD_MAX		( 4 )
#define TALK_GURUGURU_MAX	( 4 )

static const talk_table_card[TALK_CARD_MAX][2]={
	{	msg_union_talkboy_01_03,msg_union_talkgirl_01_03},
	{	msg_union_talkboy_01_04,msg_union_talkgirl_01_04},
};
static const talk_table_oekaki[TALK_OEKAKI_MAX][2]={
	{	msg_union_talkboy_02_09,msg_union_talkgirl_02_09},
	{	msg_union_talkboy_02_10,msg_union_talkgirl_02_10},
	{	msg_union_talkboy_02_11,msg_union_talkgirl_02_11},
	{	msg_union_talkboy_02_12,msg_union_talkgirl_02_12},
};
static const talk_table_battle[TALK_BATTLE_MAX][2]={
	{	msg_union_talkboy_03_05,msg_union_talkgirl_03_05},
	{	msg_union_talkboy_03_06,msg_union_talkgirl_03_06},
	{	msg_union_talkboy_03_07,msg_union_talkgirl_03_07},
	{	msg_union_talkboy_03_08,msg_union_talkgirl_03_08},
};
static const talk_table_trade[TALK_TRADE_MAX][2]={
	{	msg_union_talkboy_04_04,msg_union_talkgirl_04_04},
	{	msg_union_talkboy_04_05,msg_union_talkgirl_04_05},
};
static const talk_table_record[TALK_RECORD_MAX][2]={
	{	msg_union_talkboy_06_09,msg_union_talkgirl_06_09},
	{	msg_union_talkboy_06_10,msg_union_talkgirl_06_10},
	{	msg_union_talkboy_06_11,msg_union_talkgirl_06_11},
	{	msg_union_talkboy_06_12,msg_union_talkgirl_06_12},
};
static const talk_table_guruguru[TALK_GURUGURU_MAX][2]={
	{	msg_union_talkboy_07_10,msg_union_talkgirl_07_10},
	{	msg_union_talkboy_07_11,msg_union_talkgirl_07_11},
	{	msg_union_talkboy_07_12,msg_union_talkgirl_07_12},
	{	msg_union_talkboy_07_13,msg_union_talkgirl_07_13},
};
// Q[JñbZ[W
static const talk_start_table[][2]={
	{ msg_union_talkboy_01_03,msg_union_talkgirl_01_03,},	// J[h
	{ msg_union_talkboy_03_02,msg_union_talkgirl_03_02,},	// 
	{ msg_union_talkboy_04_02,msg_union_talkgirl_04_02,},	// 
	{ msg_union_talkboy_02_02,msg_union_talkgirl_02_02,},	// v
	{ msg_union_talkboy_06_02,msg_union_talkgirl_06_02,},	// R[hv
	{ msg_union_talkboy_07_02,msg_union_talkgirl_07_02,},	// 邮v
};
// bƂ
static const talk_start_child_table[2]={
	msg_union_talkboy_00_02,msg_union_talkgirl_00_02
};
// bςƂ
static const talk_failed_child_table[2]={
	msg_union_talkboy_00_05,msg_union_talkgirl_00_05
};

// VтfꂽƂ
static const talk_failed_table[][2]={
	{msg_union_talkboy_01_02,msg_union_talkgirl_01_02},
	{msg_union_talkboy_02_03,msg_union_talkgirl_02_03},
	{msg_union_talkboy_03_03,msg_union_talkgirl_03_03},
	{msg_union_talkboy_04_03,msg_union_talkgirl_04_03},
	{msg_union_talkboy_07_03,msg_union_talkgirl_07_03},
	{msg_union_talkboy_06_03,msg_union_talkgirl_06_03},
};

// 𖞂ĂȂ̂ŁAUȂ
static const event_reject_table[][2]={
	{msg_union_talkboy_03_04,msg_union_talkgirl_03_04},	// LV30ȉQCȂ̂őΐłȂ
	{msg_union_talkboy_04_06,msg_union_talkgirl_04_06},	// 2CȏĂȂ̂ŌłȂ
	{msg_union_talkboy_07_04,msg_union_talkgirl_07_04},	// ^}SĂȂ̂ł邮łȂ
};

static const talk_anster_wait_table[][2]={
	{ msg_union_talkboy_01_01,msg_union_talkgirl_01_01,},	// J[h
	{ msg_union_talkboy_03_01,msg_union_talkgirl_03_01,},	// 
	{ msg_union_talkboy_04_01,msg_union_talkgirl_04_01,},	// 
	{ msg_union_talkboy_02_01,msg_union_talkgirl_02_01,},	// v
	{ msg_union_talkboy_06_01,msg_union_talkgirl_06_01,},	// R[hv
	{ msg_union_talkboy_07_01,msg_union_talkgirl_07_01,},	// 邮v

};
static const talk_joinus_table[][2]={
	{ msg_union_talkboy_02_05,msg_union_talkgirl_02_05,},	// v
	{ msg_union_talkboy_06_05,msg_union_talkgirl_06_05,},	// R[hv
	{ msg_union_talkboy_07_05,msg_union_talkgirl_07_05,},	// 邮v
};
static const talk_join_success_table[][2]={
	{ msg_union_talkboy_02_07,msg_union_talkgirl_02_07,},	// v
	{ msg_union_talkboy_06_07,msg_union_talkgirl_06_07,},	// R[hv
	{ msg_union_talkboy_07_07,msg_union_talkgirl_07_07,},	// 邮v
};
static const talk_join_no_table[][2]={
	{ msg_union_talkboy_02_06,msg_union_talkgirl_02_06,},	// v
	{ msg_union_talkboy_06_06,msg_union_talkgirl_06_06,},	// R[hv
	{ msg_union_talkboy_07_06,msg_union_talkgirl_07_06,},	// 邮v
};
// قɂȂɂH
static const int talk_next_selct_table[]={
	msg_union_talkboy_00_04,msg_union_talkgirl_00_04
};

//܂Ă
static const int talk_connect_cancel_table[2]={
	msg_union_talkboy_05_01,msg_union_talkgirl_05_01
};

static const int talk_connect_canceled_table[2]={
	msg_union_talkboy_00_03,msg_union_talkgirl_00_03
};

// SXYłOBJ̔zuȂ̂ŕ␳pe[u
const u16 Union_GroupObjTable[]={
	10,14,18,22,26,30,34,38,42,46
};

//------------------------------------------------------------------
/**
 * @brief   bOBJ̐e@IDԂ
 *
 * @param   no		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int ChildToParentNo(int no)
{
	int i,r,result;
	for(i=0;i<TALK_OBJ_MAX;i++){
		if(Union_GroupObjTable[i]<=no && (Union_GroupObjTable[i]+4)>no){
			return i;
		}
	}
	return -1;
}


//------------------------------------------------------------------
/**
 * $brief   ڑɂ͂ȂȂƂ̉bԍ擾
 *
 * @param   cuw		
 * @param   no		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int GetGroupTalk_ListenNo( COMM_UNIONROOM_WORK *cuw, int no )
{
	int sex,target;
	MYSTATUS *status;
	_GF_BSS_DATA_INFO *gfbssdata;
	UNION_BEACON_STATE *beaconState;

	// 10ȏ͎q@Ȃ̂ŁAe@̉bɂԂ炳悤ɂ
	if(no>9){
		// N̎q@
		target = ChildToParentNo( no );
		GF_ASSERT( no!=-1 && "q@OBJID͐e@ЂȂ" );
		OS_Printf("֕Ԏ %d   %d\n",no, target);
	}else{
		target = no;
	}
	
	// b擾Jn
	status      = CommMPGetBconMyStatus( target );
	gfbssdata   = (_GF_BSS_DATA_INFO *)cuw->UnionBeaconTbl[target]->gameInfo.userGameInfo;
	beaconState = (UNION_BEACON_STATE *)gfbssdata->regulationBuff;

	// r[R񂪖
	if(status==NULL){
		return msg_union_talkboy_00_05;
	}

	// e̎̂͐e̐ʁAq͎̎q̐
	if(no>9){
		sex = beaconState->c_face[(no-10)%4];
		sex = sex>>7;	// ŏʂ
	}else{
		sex = MyStatus_GetMySex(status);
	}
	
	OS_Printf("Ԏ[h %d \n",beaconState->mode);
	switch(beaconState->mode){
	// Ƃ肱ݒ̂悤c
	case UNION_PARENT_MODE_BUSY:
	case UNION_PARENT_MODE_PARTY:

//		OS_Printf("ԍ = %d   n = %d \n",beaconState->nation, beaconState->city);

		return talk_failed_child_table[sex];
		break;
	case UNION_PARENT_MODE_CARDNOW:
		return talk_table_card[gf_rand()%TALK_CARD_MAX][sex];
		break;
	case UNION_PARENT_MODE_BATTLENOW:
		return talk_table_battle[gf_rand()%TALK_BATTLE_MAX][sex];
		break;
	case UNION_PARENT_MODE_TRADENOW: 
		return talk_table_trade[gf_rand()%TALK_TRADE_MAX][sex];
		break;
	
	
	case UNION_PARENT_MODE_OEKAKINOW:
	case UNION_PARENT_MODE_OEKAKI_FREE:
		return talk_table_oekaki[gf_rand()%TALK_OEKAKI_MAX][sex];
		break;
	case UNION_PARENT_MODE_RECORDNOW:
	case UNION_PARENT_MODE_RECORD_FREE:
		return talk_table_record[gf_rand()%TALK_RECORD_MAX][sex];
		break;
	case UNION_PARENT_MODE_GURUGURUNOW:
	case UNION_PARENT_MODE_GURUGURU_FREE:
		return talk_table_guruguru[gf_rand()%TALK_GURUGURU_MAX][sex];
		break;
	}
	// e@̐ڑ[h
	return msg_union_talkboy_00_05;

}


//==============================================================================
/**
 * $brief   J[hO̕ݒiEnQƂĔ肷j
 *
 * @param   wordset		
 *
 * @retval  int		
 */
//==============================================================================
int Union_GetCardTalkNo( WORDSET *wordset )
{
	u8 myNation,partnerNation;
	u8 myArea,  partnerArea; 

	//Ƒ̍EZn𓾂
	myNation      = CommInfoGetMyNation(CommGetCurrentID());
	partnerNation = CommInfoGetMyNation(CommGetCurrentID()^1);
	myArea        = CommInfoGetMyArea(CommGetCurrentID());
	partnerArea   = CommInfoGetMyArea(CommGetCurrentID()^1);

	OS_Printf("̍   %d ̍   %d\n",myNation, partnerNation);
	OS_Printf("̒n %d ̒n %d\n",myArea, partnerArea);

	// 肪͂ĂȂ
	if(partnerNation==0){
		return msg_union_connect_01_02_3;
	}

	// ԍ݂Ăꍇ͕Zbg
	if(partnerNation!=0){
		WORDSET_RegisterCountryName( wordset, 3, partnerNation );

		// nԍ݂Ăꍇ͕Zbg
		if(partnerArea!=0){
			WORDSET_RegisterLocalPlaceName( wordset, 4, partnerNation, partnerArea );
		}

	}

	// \񔻒
	
	// Ⴄ
	if(myNation!=partnerNation){
		// n悪Ȃ
		if(partnerArea==0){
			return msg_union_connect_01_02_1;
		}
		// n悪Ȃ
		if(myArea==partnerArea){
			return msg_union_connect_01_02_1; 
		}
		// n悪Ⴄ
		return msg_union_connect_01_02;
	}

	// 
	if(myArea!=partnerArea){
		// n悪Ⴄ
		return msg_union_connect_01_02_2;
	}
	
	//n悪
	return msg_union_connect_01_02_3;

}

//------------------------------------------------------------------
/**
 * $brief   Vюn߂Ƃ̉biJ[h̎ZłꏊɑΉj
 *
 * @param   event		jIsV
 * @param   sex			
 *
 * @retval  int			bԍ
 */
//------------------------------------------------------------------
static int GetStartTalk_No(int event, int sex, WORDSET *wordset )
{
	
	// J[hȂƂ̓e[u炻ꂼQƂ
	if( event!=(UNION_CHILD_SELECT_CARD-1) ){
		OS_Printf("eventno = %d \n", event);
		return talk_start_table[event][sex];
	}

	// J[hOɍEn񂩂画肵ĕݒ肷
	return Union_GetCardTalkNo( wordset );

}
//==============================================================================
/**
 * $brief   b|ŒʐMڑłȂɏob̃CfbNXn
 *
 * @param   cuw		jI[N
 * @param   no		bΏۂOBJ̔ԍ
 *
 * @retval  int		bZ[WCfbNX
 */
//==============================================================================
int Union_GetTalkNumber( COMM_UNIONROOM_WORK *cuw, int no, int mode, WORDSET *wordset )
{
	int sex;
	MYSTATUS *status;

	// XNvǵ{Pł̂łP
	no--;

	OS_Printf("b擾s OBJNO = %d  mode=%d  ScriptWork=%d \n",no,mode,cuw->ScriptSelectWork-1);

	// ڑ͂łȂO[vƂ̉b
	if(mode==UNION_NO_CONNECT_TALK){
		return GetGroupTalk_ListenNo( cuw, no );
	}

	status = CommMPGetBconMyStatus( no );
	sex    = MyStatus_GetMySex(status);

	switch(mode){
	// ڑŁAse܂̉b
	case UNION_CONNECTED_START_TALK:
		return GetStartTalk_No( cuw->ScriptSelectWork-1, sex, wordset );
//		return talk_start_table[cuw->ScriptSelectWork-1][sex];
		break;

	// bŐڑłƂiq@Łj
	case UNION_CONNECT_SUCCESS_TALK:
		return talk_start_child_table[sex];
		break;
	// E񓙂ƂɗZt(q@Łj
	case UNION_CONNECT_ANSWER_WAIT:
		// ɃLZĂ
		if(cuw->ScriptSelectWork==0){
			OS_Printf("LZĂ̂ŃXLbv\n");
			return 0;
		}
		// ̑ILɂȂĂ
		return talk_anster_wait_table[cuw->ScriptSelectWork-1][sex];
		break;

	//|PQCȏ㎝ĂȂƌ͂łȂ
	case UNION_CONNECT_BATTLE_REJECT:
	case UNION_CONNECT_TRADE_REJECT:
	case UNION_CONNECT_GURUGURU_REJECT:
		return event_reject_table[mode-UNION_CONNECT_BATTLE_REJECT][sex];
		break;
	// u[A܂͂邢񂾁A܂xˁv
	case UNION_TALK_CANCEL_CARD:	case UNION_TALK_CANCEL_OEKAKI:
	case UNION_TALK_CANCEL_BATTLE:	case UNION_TALK_CANCEL_TRADE:
	case UNION_TALK_CANCEL_GURUGURU:	case UNION_TALK_CANCEL_RECORD:
		return talk_failed_table[mode-UNION_TALK_CANCEL_CARD][sex];
		break;

	// uɁȂHv
	case  UNION_JOIN_OEKAKI_TALK:
	case  UNION_JOIN_RECORD_TALK:
	case  UNION_JOIN_GURUGURU_TALK:
		return talk_joinus_table[mode-UNION_JOIN_OEKAKI_TALK][sex];
		break;

	// uA͂ĂȂIv
	case  UNION_SUCCESS_OEKAKI_JOIN:
	case  UNION_SUCCESS_RECORD_JOIN	:
	case  UNION_SUCCESS_GURUGURU_JOIN:
		return talk_join_success_table[mode-UNION_SUCCESS_OEKAKI_JOIN][sex];
		break;

	// uA܂Ăˁcv
	case  UNION_JOIN_OEKAKI_NO:
	case  UNION_JOIN_RECORD_NO:
	case  UNION_JOIN_GURUGURU_NO:
		return talk_join_no_table[mode-UNION_JOIN_OEKAKI_NO][sex];
		break;

	// قɂȂɂH
	case UNION_SELECT_NEXT_TALK:
		return talk_next_selct_table[sex];
		break;

	// uȂɂȂ܂Ăv
	case UNION_TALK_CONNECT_CANCEL:
		return talk_connect_cancel_table[sex];
		break;

	// uA߂悤邩v
	case UNION_TALK_CONNECT_CANCELED:
		return talk_connect_canceled_table[sex];
		break;

	}
	
	// ܂ō~Ă鎖Ă͂Ȃ
	GF_ASSERT(0);
	return msg_union_talkboy_00_05;

}


//------------------------------------------------------------------
/**
 * $brief   ڑ̗FB̎pr[R쐬
 *
 * @param   state	
 * @param   num		ڑl
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void ConnectChildViewSet( UNION_BEACON_STATE  *state, int num )
{
	MYSTATUS *friendstatus;
	int i,count=0;

	// 2lڑłID1ȂȂ
	for(i=1;i<UNION_CONNECT_CHILD_MAX+1;i++){
		int pos = i-1;
		friendstatus = CommInfoGetMyStatus(i);
		
		if(friendstatus!=NULL){
			state->c_id[pos]   = MyStatus_GetID( friendstatus );
			state->c_face[pos] = MyStatus_GetTrainerView( friendstatus ) | (MyStatus_GetMySex( friendstatus )<<7);
		}else{
			state->c_id[pos]   = 0;
			state->c_face[pos] = 0;
		}
	}
}

//------------------------------------------------------------------
/**
 * $brief   ݍsĂr[Rɏ
 *
 * @param   flag		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
void Union_BeaconChange( int flag )
{
	UNION_BEACON_STATE state;

	MI_CpuClear8( &state, sizeof(UNION_BEACON_STATE) );
	switch(flag){
	// b\
	case UNION_PARENT_MODE_FREE:
		break;
	// j[Jđ肪łȂ
	case UNION_PARENT_MODE_BUSY:
		break;
	// bɐA2lڑɂȂ
	case UNION_PARENT_MODE_PARTY:	
		ConnectChildViewSet( &state, 2 );
		break;
	// ݌ʂɂîłqȂj
	case UNION_PARENT_MODE_TRADENOW:
	case UNION_PARENT_MODE_CARDNOW:
	case UNION_PARENT_MODE_BATTLENOW:
		ConnectChildViewSet( &state, 2 );
		break;

	// ݂{[hɂāAł5l܂ĂîłqȂj
	case UNION_PARENT_MODE_OEKAKINOW:
		ConnectChildViewSet( &state, 5 );
		break;
	// ݂G{[hɂĂ܂󂫂̂ŁAb
	case UNION_PARENT_MODE_OEKAKI_FREE:
		ConnectChildViewSet( &state, 4 );
		break;

	// ݃R[hR[i[ɂāAł5l܂ĂîłqȂj
	case UNION_PARENT_MODE_RECORDNOW:
		ConnectChildViewSet( &state, 5 );
		break;
	// ݃R[hR[i[ɂĂ܂󂫂̂ŁAb
	case UNION_PARENT_MODE_RECORD_FREE:
		ConnectChildViewSet( &state, 4 );
		break;

	// ݂邮ɂāAł5l܂ĂîłqȂj
	case UNION_PARENT_MODE_GURUGURUNOW:
		ConnectChildViewSet( &state, 4 );
		break;
	// ݂邮ɂĂ܂󂫂̂ŁAb
	case UNION_PARENT_MODE_GURUGURU_FREE:
		ConnectChildViewSet( &state, 4 );
		break;
	}
	state.mode    = flag;

	CommMPSetMyRegulation(&state);	// r[R
	CommMPFlashMyBss();
	
}


//==============================================================================
// jI[̍̐ĺu͂ȂvỈbee[u
//==============================================================================
static const int InfomationTalkTable[]={
	msg_union_info_02_04,
	msg_union_info_02_05,
	msg_union_info_02_06,
	msg_union_info_02_07,
	msg_union_info_02_08,
	msg_union_info_02_09,
	msg_union_info_02_10,
	msg_union_info_02_11,
	msg_union_info_02_12,
	msg_union_info_02_13,
	msg_union_info_02_14,
	msg_union_info_02_15,
	msg_union_info_02_16,
	msg_union_info_02_17,
	msg_union_info_02_18,
	msg_union_info_02_19,
	msg_union_info_02_20,
	msg_union_info_02_21,
	msg_union_info_02_22,
	msg_union_info_02_23,
};

// ȈՉb̃jI[p̏
#define PMS_DATA_UNION_TALK_NO_MAX		( 20 )

//==============================================================================
/**
 * $brief   jI[̍̐le߂
 *
 * @param   cuw		
 *
 * @retval  int		ΉbZ[WNOԂ
 */
//==============================================================================
int Union_GetInfomationTalkNo( COMM_UNIONROOM_WORK *cuw,  WORDSET *wordset )
{
	int i,ret=0,pmsid;
	PMS_WORD pmsword;

	// jI[Ńr[Rł邩H
	for(i=0;i<10;i++){
		if(cuw->UnionBeaconTbl[i]!=NULL){
			ret++;
		}
	}
	
	// ꂩ
	if(ret!=0){
		// uƂIvƏI
		return msg_union_info_02_01;
	}

	// NȂ̂ŊȈՉbɍs
	
	OS_Printf("ȈՉbhc = %d\n",PMSDAT_GetSentenceType( &cuw->MyPmsData ));

	// Lȕ͂H
	if(!PMSDAT_IsEnabled( &cuw->MyPmsData )){
		
		return msg_union_info_02_02;
	}
	
	// jIbH
	if(PMSDAT_GetSentenceType( &cuw->MyPmsData )!=PMS_TYPE_UNION){
		// jIbȂ

		//g[i[̌ڕi[
		int view_type = MyStatus_GetTrainerView(cuw->mystatus);
		int sex       = MyStatus_GetMySex(cuw->mystatus);
		
		WORDSET_RegisterTrTypeName( wordset, 0, UnionView_GetTrainerInfo( sex, view_type, UNIONVIEW_MSGTYPE) );

		return msg_union_info_02_03;
	}
	
	pmsid = PMSDAT_GetSentenceID( &cuw->MyPmsData );
	
	// jIb͂QO炵̂ŁAĂ␳
	if(pmsid >= PMS_DATA_UNION_TALK_NO_MAX){
		pmsid = 0;
	}
	
	// ƊȈՉbPꂪĂȂΓo^
	// (jIbɂ͒Pꂪ݂̂j
	if((pmsword=PMSDAT_GetWordNumber( &cuw->MyPmsData, 0 ))!=PMS_WORD_NULL){
		// ȈՉbti[
//		WORDSET_RegisterTrTypeName( wordset, 0, PMSDAT_GetWordNumber( &cuw->MyPmsData, 0 ) );
		WORDSET_RegisterPMSWord( wordset, 0, pmsword );
	}
	
	// jIbԍɑΉbZ[WNOԂ
	return InfomationTalkTable[ pmsid ];
}


//------------------------------------------------------------------
/**
 * $brief   e@̎̎胁o[\r[RNA
 *
 * @param   beacon		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionBeaconClear( UNION_BEACON_STATE *beacon )
{
	int i;
	beacon->mode = 0;
	for(i=0;i<4;i++){
		beacon->c_id[i]     = 0;
		beacon->c_face[i]   = 0;
		beacon->c_rom[i]    = 0;
		beacon->c_region[i] = 0;
	}
}

//==============================================================================
/**
 * $brief   jI[ŃX^[gj[`bgǉꂽ̏
 *
 * @param   cuw		
 * @param   pms		u`bgvj[ō쐬ȈՉb
 *
 * @retval  none
 */
//==============================================================================
void Union_SetMyPmsData( COMM_UNIONROOM_WORK *cuw, PMS_DATA *pms )
{
	PMSDAT_Copy( &cuw->MyPmsData, pms  );
	cuw->MyPmsPutFlag = 1;
}

//==============================================================================
/**
 * $brief   ō쐬ȈՉbʂQƂ悤ɂ
 *
 * @param   cuw			
 *
 * @retval  PMS_DATA *	ō쐬ȈՉb
 */
//==============================================================================
PMS_DATA * Union_GetMyPmsData( COMM_UNIONROOM_WORK *cuw )
{
	if(cuw->MyPmsPutFlag==0){
		return NULL;
	}
	cuw->MyPmsPutFlag = 0;
	return &cuw->MyPmsData;
}


//==============================================================================
/**
 * $brief   jI[ŎgpbpɃg[i[Zbg
 *          ̖OZbg
 *
 * @param   wordset		WORDSETւ̃|C^
 * @param   type		UNION_TRAINER_REGIST_CHILD:ubpv	1:ubpv
 * @param   no			ubpv̎Ɏw肵ĂOBJ炤߂ɕKv
 *
 * @retval  none		
 */
//==============================================================================
void Union_TrainerNameRegist( WORDSET *wordset, int type, int no, MYSTATUS *mystatus, PMSW_SAVEDATA *pmssave )
{
	MYSTATUS *status;
	STRBUF   *greeting;
	MSGDATA_MANAGER*  msgman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_union_dat, HEAPID_FIELD );
	int      region,msgno;

	OS_Printf("NameRegist type=%d objid=%d\n",type, no);
	no--;		// XNvǵ{Pł̂łP
	
	// b̓r[RMYSTATUS擾
	if(type==UNION_TALK_CHILD){
		status      = CommMPGetBconMyStatus( no );
	}else{
	// b͐ڑς݂Ȃ̂ConnectID^1MYSTATUS擾
		status = CommInfoGetMyStatus(CommGetCurrentID()^1);

	}

//	OS_Printf("Oo^@%d\n", type);
//	GF_ASSERT(status!=NULL && "擾MYSTATUSNULL");

	if(status==NULL){
		return;
	}

	// g[i[o^
	WORDSET_RegisterPlayerName( wordset, 0, status );		// ̖Oo^
	WORDSET_RegisterPlayerName( wordset, 1, mystatus );		// ̖Oo^

	// R[h擾
	region   = MyStatus_GetRegionCode( status );

	OS_Printf("ԍ %d \n", region);

	// eJ[gbWɂ킹ĊȈՉbtOǉ
	if(region>=LANG_JAPAN && region <=LANG_SPAIN){
		static const int AisatsuFlagTable[] = {
			PMSW_AISATSU_JP,	// {
			PMSW_AISATSU_EN,	// p
			PMSW_AISATSU_FR,	// tX
			PMSW_AISATSU_IT,	// C^A
			PMSW_AISATSU_GE,	// hCc
			-1,					// io[
			PMSW_AISATSU_SP,	// XyC
		};

		u16 lang = region - LANG_JAPAN;
		if( (lang < NELEMS(AisatsuFlagTable)) && (AisatsuFlagTable[lang] >= 0) )
		{
			PMSW_SetAisatsuFlag( pmssave,  AisatsuFlagTable[lang] );
			OS_Printf("ȈՉb %d@ǉ\n", PMSW_AISATSU_JP+( region - LANG_JAPAN ) );
		}
	}

	OS_Printf("NAtO = %d, S}ӃtO = %d\n", MyStatus_GetDpClearFlag(status),MyStatus_GetDpZenkokuFlag(status));

	// ̌ɂĈAς
	switch(region){
	case LANG_JAPAN: 	msgno = msg_union_greeting_01;	break;
	case LANG_ENGLISH: 	msgno = msg_union_greeting_02;	break;
	case LANG_FRANCE: 	msgno = msg_union_greeting_03;	break;
	case LANG_ITALY	: 	msgno = msg_union_greeting_04;	break;
	case LANG_GERMANY: 	msgno = msg_union_greeting_05;	break;
	case LANG_SPAIN	: 	msgno = msg_union_greeting_06;	break;
	default:
		msgno = msg_union_greeting_07;
	}
	greeting = MSGMAN_AllocString( msgman, msgno );

	// éuɂ́vi[
	WORDSET_RegisterWord( wordset, 2, greeting, 0, 1, region );

	sys_FreeMemoryEz(greeting);
	MSGMAN_Delete( msgman );
}

//==============================================================================
/**
 * $brief   jI[ŊȈՉbibOKȂƎv̂łPŁj
 *
 * @param   pms		
 *
 * @retval  none		
 */
//==============================================================================
void Union_PMSReWrite( PMS_DATA *pms )
{
	UNION_BEACON_STATE state;

	UnionBeaconClear( &state );
	state.mode = UNION_PARENT_MODE_FREE;
	

	CommMPSetMyPMS( pms );
	CommMPSetMyRegulation(&state);	// r[R
	CommMPFlashMyBss();
	
}

//==============================================================================
/**
 * $brief   E񂩂߂ĂpɃ[NĂ
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//==============================================================================
void Union_CommWorkClear( COMM_UNIONROOM_WORK *cuw)
{
	cuw->CommChildSelectEvent = 0;
	cuw->UnionEventWork       = 0;
	cuw->UnionEndConnectFlag  = 0;
}
//------------------------------------------------------------------
/**
 * $brief   jI[ʐMJnp̃[NNA
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CommUnion_EventFlagClear( COMM_UNIONROOM_WORK *cuw)
{
	cuw->CommConnectStartFlag = 0;
	cuw->CommConnectStartWait = 0;
	cuw->CommNextProcOn       = 0;
	cuw->CommChildSelectEvent = 0;
	cuw->UnionEventWork       = 0;
	cuw->busyflag			  = 0;
	cuw->MyPmsPutFlag         = 0;
	cuw->UnionEndConnectFlag  = 0;
}

//==============================================================================
/**
 * $brief   g[i[J[ḧalloc
 *
 * @param   cuw		
 *
 * @retval  void *		
 *
 *  g[i[J[hmۂ̈悪HEAPID_UNIONROOMȂ̂ŁA
 *  BASE_SYSTEM鎖ɂB
 *  ʃAvւ̉e|̂ŁAg[i[J[h钼OɊmۂ
 *  J[h{ɉ
 */
//==============================================================================
void *Union_TrainerCardWorkInit( COMM_UNIONROOM_WORK *cuw )
{
	cuw->my_trcard      = TRCSET_AllocTrainerCardData( HEAPID_BASE_SYSTEM );
	cuw->recv_trcard[0] = TRCSET_AllocTrainerCardData( HEAPID_BASE_SYSTEM );
	cuw->recv_trcard[1] = TRCSET_AllocTrainerCardData( HEAPID_BASE_SYSTEM );

	TRCSET_MakeTrainerInfo( 0, 0, 0,
							UnionView_GetTrainerInfo( MyStatus_GetMySex(cuw->mystatus),
												MyStatus_GetTrainerView(cuw->mystatus), UNIONVIEW_ICONINDEX ),
							cuw->fsys, cuw->my_trcard );

	OS_Printf("my_trcard = %08x\n",cuw->my_trcard);
	OS_Printf("trcard[0] = %08x\n",cuw->recv_trcard[0]);
	OS_Printf("trcard[1] = %08x\n",cuw->recv_trcard[1]);

	//̂hcƈႤobt@Ԃĩg[i[J[hĎł悤Ɂj
	return (void*)cuw->recv_trcard[CommGetCurrentID()^1];
}


//==============================================================================
/**
 * $brief   g[i[J[ĥ߂Ɋmۂ̈
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//==============================================================================
void Union_trainerCardWorkFree( COMM_UNIONROOM_WORK *cuw )
{
    sys_FreeMemoryEz(cuw->recv_trcard[0]);
    sys_FreeMemoryEz(cuw->recv_trcard[1]);
    sys_FreeMemoryEz(cuw->my_trcard);

}


//==============================================================================
/**
 * $brief   g[i[J[hf[^𑗐M
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//==============================================================================
void Union_SendTrainerCardData( COMM_UNIONROOM_WORK *cuw )
{

	// eM
//	if(CommGetCurrentID()==0){
		CommSendHugeData( CU_TRAINER_CARD, cuw->my_trcard, sizeof(TR_CARD_DATA) );

		OS_Printf("send size = %d   xor = %d\n",sizeof(TR_CARD_DATA), cuw->my_trcard->_xor);
//	}

}


