//==============================================================================
/**
 * @file	d_goto.c
 * @brief	㓡pfobOpt@C
 * @author	goto
 * @date	2005.06.20()
 */
//==============================================================================
#ifdef PM_DEBUG

#include "common.h"
#include "system/pm_overlay.h"
#include "system/test_overlay.h"

#include "system/bmp_list.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "system/fontproc.h"
#include "contest/contest.h"

#include "script.h"

#include "system/fontproc.h"
#include "system/msgdata.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_debug_goto.h"

extern void DebugGotoMenuInit(FIELDSYS_WORK* fsys);

extern void CustomBallEdit_Start(FIELDSYS_WORK *fsys);

//==============================================================================
//	I[o[CIDextern錾
//==============================================================================
/* overlay id in *.lcf */
FS_EXTERN_OVERLAY(test_first);
FS_EXTERN_OVERLAY(test_second);
FS_EXTERN_OVERLAY(test_itcm);
FS_EXTERN_OVERLAY(test_second_abc);


//==============================================================================
//	\̐錾
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   㓡fobOp\
 */
//--------------------------------------------------------------
typedef struct{
	FIELDSYS_WORK *fsys;
	BMPLIST_WORK *lw;
	BMP_MENULIST_DATA *listmenu;
	GF_BGL_BMPWIN bmpwin;
	s16 wait;
	u8 main_seq;
}DGOTO_WORK;


//==============================================================================
//	^錾
//==============================================================================
typedef void (*pDMFunc)(DGOTO_WORK *);


//==============================================================================
//	vg^Cv錾
//==============================================================================
static void DG_MenuMain(TCB_PTR tcb, void *work);
static void DG_MenuExit(DGOTO_WORK *dm);
static void DG_CustomStart(DGOTO_WORK *dm);
static void DG_CustomStart2(DGOTO_WORK *dm);
static void DG_SealAdd(DGOTO_WORK *dm);
static void DG_EggDemoNormal(DGOTO_WORK *dm);
static void DG_EggDemoSpecial(DGOTO_WORK *dm);


//==============================================================================
//	fobOj[Xgpf[^
//==============================================================================
///fobOj[̍
static const struct {
	
	u32  str_id;
	u32  param;
	
} DebugMenuParamList[] = {
	
	{ dmg_01,		(u32)DG_CustomStart		},
	{ dmg_01_01,	(u32)DG_CustomStart2	},
	{ dmg_02,		(u32)DG_SealAdd			},
	{ dmg_03,		(u32)DG_EggDemoNormal	},
	{ dmg_04,		(u32)DG_EggDemoSpecial	},
	
};


#define LIST_MENU_MAX		(NELEMS(DebugMenuParamList))

///fobOj[̃Xg
static const BMPLIST_HEADER DebugMenuListHeader = {
	NULL,			// \f[^|C^
	NULL,					// J[\ړƂ̃R[obN֐
	NULL,					// \Ƃ̃R[obN֐
	NULL,
	LIST_MENU_MAX,	// Xgڐ
	LIST_MENU_MAX,						// \ő區ڐ
	0,						// x\wW
	8,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_WHITE,			// F
	FBMP_COL_BLACK,			// wiF
	FBMP_COL_BLK_SDW,		// eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	FONT_SYSTEM,				// w
	0,						// afJ[\(allow)\tO(0:ON,1:OFF)
};

#define DGOTO_HEAP	(HEAPID_BASE_DEBUG)

void DebugGotoMenuInit(FIELDSYS_WORK* fsys)
{
	DGOTO_WORK *dm;
	BMPLIST_HEADER list_h;
	
	dm = sys_AllocMemory(DGOTO_HEAP, sizeof(DGOTO_WORK));
	memset(dm, 0, sizeof(DGOTO_WORK));
	
	//BMPEBhE
	GF_BGL_BmpWinAdd(fsys->bgl, &dm->bmpwin, 
		FLD_MBGFRM_FONT, 1, 1, 15, 24, 13, 1);
	dm->fsys = fsys;
	
	dm->listmenu = BMP_MENULIST_Create(LIST_MENU_MAX, DGOTO_HEAP);

	//񃊃Xg쐬
	{
		MSGDATA_MANAGER *man;
		STRBUF * str_buf;
		int i;
		
		man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, 
			NARC_msg_debug_goto_dat, DGOTO_HEAP);
		
		for(i = 0; i < LIST_MENU_MAX; i++){
			BMP_MENULIST_AddArchiveString(dm->listmenu, man, DebugMenuParamList[i].str_id, 
				DebugMenuParamList[i].param);
		}
		
		MSGMAN_Delete(man);
	}
	
	list_h = DebugMenuListHeader;
	list_h.win = &dm->bmpwin;
    list_h.list = dm->listmenu;
	dm->lw = BmpListSet(&list_h, 0, 0, DGOTO_HEAP);
	
	GF_BGL_BmpWinOn(&dm->bmpwin);
	
	TCB_Add(DG_MenuMain, dm, 10);
//	FieldSystemProc_SeqHoldEnd();
}

//--------------------------------------------------------------
/**
 * @brief   㓡pfobOj[XgI
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		fobOp㓡[Nւ̃|C^
 */
//--------------------------------------------------------------
static void DG_MenuMain(TCB_PTR tcb, void *work)
{
	DGOTO_WORK *dm = work;
	u32	ret;

	ret = BmpListMain(dm->lw);
	switch(dm->main_seq){
	case 0:
		dm->main_seq++;
		break;
	case 1:
		switch(ret){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
			DG_MenuExit(dm);
			TCB_Delete(tcb);
			sys_FreeMemoryEz(dm);
			FieldSystemProc_SeqHoldEnd();
			return;
		default:
			{
				pDMFunc func = (pDMFunc)ret;

				DG_MenuExit(dm);
				TCB_Delete(tcb);
				func(dm);
				sys_FreeMemoryEz(dm);
				return;
			}
			break;
		}
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   㓡pfobOj[Xg
 * @param   dm		fobOp㓡[Nւ̃|C^
 */
//--------------------------------------------------------------
static void DG_MenuExit(DGOTO_WORK *dm)
{
	BMP_MENULIST_Delete(dm->listmenu);
	BmpListExit(dm->lw, NULL, NULL);

	GF_BGL_BmpWinOff(&dm->bmpwin);
	GF_BGL_BmpWinDel(&dm->bmpwin);
}


#include "savedata/custom_ball.h"
#include "src/demo/egg/egg.h"
static void DG_CustomStart(DGOTO_WORK *dm)
{

	CustomBallEdit_Start(dm->fsys);
	
}

static void DG_CustomStart2(DGOTO_WORK *dm)
{
	Debug_CB_SaveData_Sample(CB_SaveData_AllDataGet(dm->fsys->savedata), 1);
	
	CustomBallEdit_Start(dm->fsys);
	
}

static void DG_SealAdd(DGOTO_WORK *dm)
{
	Debug_CB_SaveData_Sample(CB_SaveData_AllDataGet(dm->fsys->savedata), 0);
	
	CustomBallEdit_Start(dm->fsys);
}


static void DG_EggDemoNormal(DGOTO_WORK *dm)
{
	DebugEGG_DemoStart(dm->fsys);
}


static void DG_EggDemoSpecial(DGOTO_WORK *dm)
{
	DebugEGG_DemoStartMana(dm->fsys);
}

#endif