//============================================================================================
/**
 * @file	div_map.c
 * @brief	}bv
 * @author	Nozomu Saito
 * @date	2005.05.06
 */
//============================================================================================
#include "common.h"
#include "div_map_cont_def.h"
#include "fieldsys.h"
#include "worldmap.h"	//<<20060113add
#include "fieldmap_mem.h"
//#include "sp_attribute_def.h"

#include "debug_saito.h"
#include "fld_debug.h"

#include "system/arc_tool.h"
#include "communication/communication.h" // ʐMG[֌W

#define BLOCK_GRID_SIZE_X	(BLOCK_GRID_W)	//1ubN̉Obh
#define BLOCK_GRID_SIZE_Z	(BLOCK_GRID_H)	//1ubN̏cObh

#define HARF_GRID_SIZE	(ONE_GRID_SIZE/2)
#define NON_BLOCK	(-1)

#define MODEL_SET_DIV_SIZE	( 0xe000 )
#define MAP_ARC_NO_DATA		( 0xffff )

#define DIV_CALL_BACK

enum {
	MODELSET_TASK_SEQ_INIT = 0,
	MODELSET_TASK_SEQ_MODEL_LOAD,
	MODELSET_TASK_SEQ_TEXTURE_BIND,
	MODELSET_TASK_SEQ_RESOUCE_SET,
	MODELSET_TASK_SEQ_RENDER_OBJ,
	MODELSET_TASK_SEQ_EXIT
};

typedef struct DIV_FUNC_LIST_tag const * DFL_CONST_PTR;

typedef struct MAP_LOAD_TASK_COUNTER_tag
{
	int BlockLoadTaskCounter;
	int BlockHeightLoadTaskCounter;
	
}MAP_LOAD_TASK_COUNTER;

//ubNXgf[^
typedef struct BLOCK_NODE_tag{
	u16 Attribute[32*32];				//Agr[g
	NNSG3dRenderObj		FloorData;		//n`f[^_[nai
	NNSG3dResFileHeader	*FloorResFile;	//n`f[^\[Xwb_[
	u8				*HeightMem;			//f[^|C^
	MHI_PTR			MapHeightInfo;		//f[^ւ̃|C^
	int BlockIndex;						//ubNCfbNX
	BOOL DrawOKFlg;						//`拖tO
	M3DOL_PTR	ObjDataList;			//zufnaiXg
}BLOCK_NODE;

typedef struct MAP_LOAD_BLOCK_ST_tag
{
	BLOCK_NODE *Node[2];	//ǂݍݑΏۃubNf[^ւ̃|C^
	
	TCB_PTR	RandTask;		//n`[h^XN|C^
	TCB_PTR	HeightTask;		//[h^XN|C^
	MAP_LOAD_TASK_COUNTER	TaskCnter;	//n`[h^XNA[h^XÑJE^
	int Block[2];		//ǂݍݑΏۃubNCfbNX
	u8 Index[2];		//ǂݍݑΏۃ[JubNCfbNX

	u8 TotalCount;		//ǂݍݏIJEg0`2
	BOOL BlockLoadOK;	//ǂݍ݂̃tO
	
}MAP_LOAD_BLOCK_ST;

typedef void (*DIV_FIRST_FUNC)(	DMC_PTR outDivMapCont,
								const int inGridX, 
								const int inGridZ,
								const int inMapGridW);
typedef void (*DIV_LOAD_FUNC)(	const u8 inCount,
								const MAP_RESOURCE_PTR inMapResource,
								const WORLD_MAP_PTR inWorld,
								const int inMapW,
								const int inMapH,
								DMC_PTR inDivMapCont,
								MAP_LOAD_BLOCK_ST *ioMLBS);


typedef struct DIV_FUNC_LIST_tag{
	DIV_FIRST_FUNC	DivFirstFunc;
	DIV_LOAD_FUNC	DivLoadFunc;
}DIV_FUNC_LIST;

typedef struct BLOCK_LOAD_tag
{
	MAP_LOAD_BLOCK_ST	MLBS;
	BOOL	Moving;		//ғtO
	u8		LoadDir;	//[h
}MAP_LOAD_BLOCK_CONT;

typedef struct STOCK_LOAD_DATA_tag
{
	BLOCK_NODE *Node[2];
	BOOL	Valid;
	u8		LoadDir;	//[h
	int Block[2];
	u8 Index[2];
}STOCK_LOAD_DATA;

typedef struct DIV_MAP_CHECK_tag
{
	VecFx32 OldPoint;
	VecFx32 const *TargetPoint;
	fx32 const *LargeVal;
	fx32 const *SmallVal;
	BOOL Moving;
	u8 Dir;
	BOOL Valid;
}DIV_MAP_CHECK;

typedef struct DIV_MAP_LOAD_CONT_tag
{
	FMM_PTR FldMapMem;
	MAP_LOAD_BLOCK_CONT MLBC[2];		//[hNGXgǗf[^
	STOCK_LOAD_DATA Stock;				//[hNGXgXgbN
	BOOL LocalFreeIndexTable[4];		//\e[u
	BLOCK_NODE *BlockNodeList[4];		//@̎4ubÑf[^ւ̃|C^

	u8 MovingNum;	//ғ
	u8 BlankNo;			//0or1			[hNGXgǗ󂫔ԍ
	u8 NowMovingNo;		//0or1			[hNGXgǗԍ
	u32 NowBlockIndex;		
	u32 NowGridNo;				//݂̎@Obhio[
	u8 NowLocalIndex;			//݃[JCfbNX
	u8 NowPosInBlock;	//0`3
	BOOL FreeRequest;
	int LoadSeq;
	MAP_RESOURCE_PTR MapResource;
	WORLD_MAP_PTR World;
	//L3̕ϐworld\̂̃|C^擾\łAANZXpɂɔ邽߁A
	//̒iKłɒli[Ag܂B
	//̕ϐ̒l̓}bv؂ւȂύX͂܂B(sȂ)
	int MapW;
	int MapH;
	int MapGridW;

	DIV_MAP_CHECK MapCheck;
	FLD_3D_ANM_MNG_PTR Field3DAnmPtr;
	DFL_CONST_PTR	FuncList;
	ARCHANDLE *ArcHandle;		//A[JCunh
#ifdef DIV_CALL_BACK
	//R[obN֐
	DIV_LOAD_CALL_BACK CallBack;
	//R[obN[N
	void *CallBackWork;
#endif	
}DIV_MAP_LOAD_CONT;

typedef struct DATA_OFS_SIZE_tsg
{
	int AttrSize;
	int MapSize;
	int HeightSize;
	int ObjSize;
}DATA_OFS_SIZE;

#ifdef PM_DEBUG
static BOOL DebugOutRangeFlg = TRUE;
#endif


//////////////////////////////////////////////////////////////////////////////////
//	O錾
//////////////////////////////////////////////////////////////////////////////////
static TCB_PTR Set3DModelTask(	ARCHANDLE *inHandle,
								const int inSize,
								NNSG3dRenderObj* object_p,
								NNSG3dResFileHeader** resFile,
								NNSG3dResTex* pTexture,
								BOOL *ioDrawOKFlg,
								int *inEndFlg);
static NNSG3dResMdl* Set3DModel(	ARCHANDLE *ioHandle,
									const int inSize,
									NNSG3dRenderObj* object_p,
									NNSG3dResFileHeader** resFile,
									NNSG3dResTex* pTexture);
static void StopMapLoadTaskRequest(TCB_PTR tcb);
static void InitMapLoadCont(DMC_PTR outDivMapCont);
static void LoadFirstBlock(	DMC_PTR outDivMapCont,
							const int inGridX, 
							const int inGridZ,
							const int inMapGridW);
static void LoadFirstBlockForUnder(	DMC_PTR outDivMapCont,
									const int inGridX, 
									const int inGridZ,
									const int inMapGridW);
static void AllocBlockList(DMC_PTR outDivMapCont);
static void AllocBlockListForUnder(DMC_PTR outDivMapCont);
static void	LoadStopReqest(DMC_PTR ioDivMapCont,const u8 inNo);
static BOOL BlockLoadReqest( DMC_PTR ioDivMapCont,
								const int inBlock1,
								const int inBlock2,
								const u8 inIdx1,
								const u8 inIdx2,
								const u8 inBlankNo,
								const u8 inDir);
static void GetMapArcLoadOffset(ARCHANDLE *ioHandle, const int inArcIndex, DATA_OFS_SIZE *outData);
static void LoadBlock(const u8 inCount,
		const MAP_RESOURCE_PTR inMapResource,
		const WORLD_MAP_PTR inWorld,
		const int inMapW,
		const int inMapH,
		DMC_PTR inDivMapCont,
		MAP_LOAD_BLOCK_ST *ioMLBS);
static void LoadBlockForUnder(const u8 inCount,
		const MAP_RESOURCE_PTR inMapResource,
		const WORLD_MAP_PTR inWorld,
		const int inMapW,
		const int inMapH,
		DMC_PTR inDivMapCont,
		MAP_LOAD_BLOCK_ST *ioMLBS);
static void LoadBlockQuick(	const int inBlockIndex,
							const u8 inLocalIndex,
							const MAP_RESOURCE_PTR inMapResource,
							const WORLD_MAP_PTR inWorld,
							const int inMapW,
							const int inMapH,
							const BOOL inLightValid,
							DMC_PTR outDivMapCont);
static void LoadBlockQuickForUnder(	const int inBlockIndex,
									const u8 inLocalIndex,
									const MAP_RESOURCE_PTR inMapResource,
									const WORLD_MAP_PTR inWorld,
									const int inMapW,
									const int inMapH,
									const BOOL inLightValid,
									DMC_PTR outDivMapCont);
static void UpdateBlockList(const int inBlockIndex, const u8 inDirection, DMC_PTR ioDivMapCont);
static void FreeAndMoveNode(const u8 inFreeNo1,
							const u8 inFreeNo2,
							const u8 inMoveNo1,
							const u8 inMoveNo2,
							DMC_PTR ioDivMapCont);
static void FreeBlock(const u8 inLocalIndex, DMC_PTR outDivMapCont);

static void DrawBlock(	const u8 inLocalIndex,
						DMC_CONST_PTR inDivMapCont,
						const GLST_DATA_PTR	glst_data);
static BOOL CompLoadDirection(const u8 inDir, DMC_CONST_PTR inDivMapCont, u8* outNo);
static BOOL BlockLoadReqestForStock(DMC_PTR ioDivMapCont);
static BOOL IsFinishedLoadBlock(DMC_CONST_PTR inDivMapCont);
static void ClearLocalFreeIndexTable(DMC_PTR outDivMapCont);
static void MarkLocalFreeIndexTableByDir(const u8 inDir,DMC_PTR outDivMapCont);



static u8 CalcLocalIdxFromPosInBlock(const u8 inPosInBlock);
static u32 GetNextGridNo(	const u8 inDirection,
							const int inMapH,
							const int inMapGridW,
							const int inNowGridNo);

static u8 GetNextPosInBlock(const u8 inDirection, const int inNowPosInBlock);
static void UpdateNowLocalIndexForAfterLoad(const u8 inDirection,
											const int inNowPosInBlock,
											u8 *outNowLocalIndex);

static void AddMapLoad(const int inBlock1,
					const int inBlock2,
					const u8 inIdx1,
					const u8 inIdx2,
					const u8 inDir,
					DMC_PTR ioDivMapCont);
static int CalcGridNoFromGridXZ(const int inGridX, const int inGridZ, const int inMapGridW);
static void AddMapLoadForStock(DMC_PTR ioDivMapCont);
							
static void UpdateNowData(const int inGridX, const int inGridZ, DMC_PTR outDivMapCont);
static void CalcMapOffset3D(	const int inBlockIndex,
								const int inMapW,
								const WORLD_MAP_PTR inWorld,
								VecFx32 *outTrans);

///////////////////////////////////////////////////////
//	X^eBbNϐ
///////////////////////////////////////////////////////

static const DIV_FUNC_LIST DivGroundFunc = 
{
	LoadFirstBlock,
	LoadBlock
};

static const DIV_FUNC_LIST DivUnderFunc = 
{
	LoadFirstBlockForUnder,
	LoadBlockForUnder
};

//--------------------------------------------------------------------------------------------
/**
 * `FbNc
 *
 * @param	inBlockIdx1		ubNCfbNX1
 * @param	inBlockIdx2		ubNCfbNX2
 * @param	inMapW			}bv
 *
 * @return	BOOL			TRUE:c`FbNnj		FALSE:c`FbNmf
 */
//--------------------------------------------------------------------------------------------
static BOOL CheckColumnBlockIndex(const int inBlockIdx1,
								const int inBlockIdx2,
								const int inMapW)
{
	if (inBlockIdx1%inMapW != inBlockIdx2%inMapW){
		return FALSE;
	}else{
		return TRUE;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * `FbN
 *
 * @param	inBlockIdx1		ubNCfbNX1
 * @param	inBlockIdx2		ubNCfbNX2
 * @param	inMapW			}bv
 *
 * @return	BOOL			TRUE:`FbNnj		FALSE:`FbNmf
 */
//--------------------------------------------------------------------------------------------
static BOOL CheckRowBlockIndex(const int inBlockIdx1,
								const int inBlockIdx2,
								const int inMapW)
{
	if (inBlockIdx1/inMapW != inBlockIdx2/inMapW){
		return FALSE;
	}else{
		return TRUE;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * [h^XÑio[(0or1)gp^XN~NGXg
 *
 * @param	ioDivMapCont	}bv\̃|C^
 * @param	inNo			~NGXgio[i0nq1j
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void	LoadStopReqest(DMC_PTR ioDivMapCont,const u8 inNo)
{
	u8 idx;
	u8 i;

	if (ioDivMapCont->MLBC[inNo].MLBS.TaskCnter.BlockLoadTaskCounter != 0){
		//n`f[^[h~NGXg
		StopMapLoadTaskRequest(ioDivMapCont->MLBC[inNo].MLBS.RandTask);
#ifdef DIV_MAP_LOAD_DEBUG		
		OS_Printf("n`\n");
#endif		
	}
	if (ioDivMapCont->MLBC[inNo].MLBS.TaskCnter.BlockHeightLoadTaskCounter != 0){
		//f[^[h~NGXg
		StopHeightLoadTaskRequest(ioDivMapCont->MLBC[inNo].MLBS.HeightTask);
#ifdef DIV_MAP_LOAD_DEBUG
		OS_Printf("\n");
#endif
	}
	ioDivMapCont->MLBC[inNo].MLBS.BlockLoadOK = TRUE;
#if 0
	//A[JCunh
	if (ioDivMapCont->ArcHandle != NULL){
		ArchiveDataHandleClose( ioDivMapCont->ArcHandle );
		ioDivMapCont->ArcHandle = NULL;
	}
#endif	
}

//--------------------------------------------------------------------------------------------
/**
 * ubNf[^gpA^XN̒~NGXg
 *
 * @param	*inMLBS		[hubNf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void	LoadTaskStopReqestByMLBS(MAP_LOAD_BLOCK_ST *inMLBS)
{
	if (inMLBS->TaskCnter.BlockLoadTaskCounter != 0){
		//n`f[^[h~NGXg
		StopMapLoadTaskRequest(inMLBS->RandTask);
	}
	if (inMLBS->TaskCnter.BlockHeightLoadTaskCounter != 0){
		//f[^[h~NGXg
		StopHeightLoadTaskRequest(inMLBS->HeightTask);
	}

	//̃^XNɉ悤ɁAŃJE^NAĂ
	inMLBS->TaskCnter.BlockLoadTaskCounter = 0;
	inMLBS->TaskCnter.BlockHeightLoadTaskCounter = 0;
	
	//inMLBS->StopFlg = TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * ubNObh犄o
 *
 * @param	inGridX			ObhwW
 * @param	inGridZ			ObhyW
 * @param	inMapW			}bv
 * @param	inMapH			}bvc
 * @param	inMapGridW		}bvObh
 * @param	*outBlockTbl	ubNe[u
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void MakeStartBlockTbl(	const int inGridX,
								const int inGridZ,
								const int inMapW,
								const int inMapH,
								const int inMapGridW,
								int *outBlockTbl)
{
	int grid_no;
	u8 pos_in_block;
	int block_index;
	int block_w, block_h;
	//4ubN̍̃CfbNXZo
	block_w = (inGridX / BLOCK_GRID_SIZE_X);
	block_h = (inGridZ / BLOCK_GRID_SIZE_Z);

	grid_no = CalcGridNoFromGridXZ(inGridX,inGridZ,inMapGridW);
	pos_in_block = CalcPositionInBlockFromGridNo(grid_no,inMapGridW);

	block_index = (block_h*inMapW)+block_w;
	
	switch(pos_in_block){
	case 0:		//
		//̓[J3
		outBlockTbl[3] = block_index;
		outBlockTbl[0] = block_index-inMapW-1;
		outBlockTbl[1] = block_index-inMapW;
		outBlockTbl[2] = block_index-1;
		//ׂ̃ubN𒲂ׂ
		if(block_w-1<0){
			//͔͈͊O
			//͈̏͊Ô͂
			outBlockTbl[0] = NON_BLOCK;
			outBlockTbl[2] = NON_BLOCK;
		}
		//̃ubN𒲂ׂ
		if(block_h-1<0){
			//͔͈͊O
			outBlockTbl[1] = NON_BLOCK;
		}
///		block_w--;
///		block_h--;
		break;
	case 1:		//E
		//̓[J2
		outBlockTbl[2] = block_index;
		outBlockTbl[0] = block_index-inMapW;
		outBlockTbl[1] = block_index-inMapW+1;
		outBlockTbl[3] = block_index+1;
		//ẼׂubN𒲂ׂ
		if(block_w+1>=inMapW){
			//E͔͈͊O
			//͈̏͊Ô͂
			outBlockTbl[1] = NON_BLOCK;
			outBlockTbl[3] = NON_BLOCK;
		}
		//̃ubN𒲂ׂ
		if(block_h-1<0){
			//͔͈͊O
			outBlockTbl[0] = NON_BLOCK;
		}
///		block_h--;
		break;
	case 2:		//
		//̓[J1
		outBlockTbl[1] = block_index;
		outBlockTbl[0] = block_index-1;
		outBlockTbl[2] = block_index+inMapW-1;
		outBlockTbl[3] = block_index+inMapW;
		//ׂ̃ubN𒲂ׂ
		if(block_w-1<0){
			//͔͈͊O
			//͈̉͊Ô͂
			outBlockTbl[0] = NON_BLOCK;
			outBlockTbl[2] = NON_BLOCK;
		}
		//̃ubN𒲂ׂ
		if(block_h+1>inMapH){
			//͔͈͊O
			outBlockTbl[3] = NON_BLOCK;
		}
///		block_w--;
		break;
	case 3:		//E
		//̓[J0
		outBlockTbl[0] = block_index;
		outBlockTbl[1] = block_index+1;
		outBlockTbl[2] = block_index+inMapW;
		outBlockTbl[3] = block_index+inMapW+1;
		//ẼׂubN𒲂ׂ
		if(block_w+1>=inMapW){
			//E͔͈͊O
			//͈̉͊Ô͂
			outBlockTbl[1] = NON_BLOCK;
			outBlockTbl[3] = NON_BLOCK;
		}
		//̃ubN𒲂ׂ
		if(block_h+1>inMapH){
			//͔͈͊O
			outBlockTbl[0] = NON_BLOCK;
		}
		break;
	default:
		GF_ASSERT(0&&"ERROR:POS_IN_BLOCK");
	}
	
#ifdef DEBUG_ONLY_FOR_saitou
	OS_Printf("local_print block_wh=%d,%d\n",block_w,block_h);
	OS_Printf("local_print start_blocks=%d,%d,%d,%d\n",
			outBlockTbl[0],outBlockTbl[1],outBlockTbl[2],outBlockTbl[3]);
#endif //DEBUG_ONLY_FOR_saitou	
}

//--------------------------------------------------------------------------------------------
/**
 * 4ubÑm
 *
 * @param	outDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void AllocBlockList(DMC_PTR outDivMapCont)
{
	u8 i;
	for (i=0;i<4;i++){
		BLOCK_NODE *node = NULL;
		node = sys_AllocMemory( HEAPID_FIELD, sizeof(BLOCK_NODE) );
		outDivMapCont->BlockNodeList[i] = node;
		outDivMapCont->BlockNodeList[i]->DrawOKFlg = FALSE;

		//mۂ(n`)ƃ|C^oCh
		BindGroundMem(i, outDivMapCont->FldMapMem, (void**)&(outDivMapCont->BlockNodeList[i]->FloorResFile));
		BindHeightMem(i, outDivMapCont->FldMapMem, (void**)&(outDivMapCont->BlockNodeList[i]->HeightMem));

		//3DOBJ̃AP[V
		outDivMapCont->BlockNodeList[i]->ObjDataList =  M3DO_AllocMap3DObjList(HEAPID_FIELD);
		outDivMapCont->BlockNodeList[i]->BlockIndex = NON_BLOCK;
		//Agr[gNA
		MI_CpuFillFast(outDivMapCont->BlockNodeList[i]->Attribute, 0xffffffff, 2*32*32 );
	}
	
	//BlockNodeList = sys_AllocMemory( HEAPID_FIELD, sizeof(BLOCK_NODE)*9 );
}

//--------------------------------------------------------------------------------------------
/**
 * 4ubÑmہinj
 *
 * @param	outDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void AllocBlockListForUnder(DMC_PTR outDivMapCont)
{
	u8 i;
	for (i=0;i<4;i++){
		BLOCK_NODE *node = NULL;
		node = sys_AllocMemory( HEAPID_FIELD, sizeof(BLOCK_NODE) );
		outDivMapCont->BlockNodeList[i] = node;
		outDivMapCont->BlockNodeList[i]->DrawOKFlg = FALSE;
		//mۂ(n`)ƃ|C^oCh
		BindGroundMem(i, outDivMapCont->FldMapMem, (void**)&(outDivMapCont->BlockNodeList[i]->FloorResFile));
		///BindHeightMem(i, outDivMapCont->FldMapMem, (void**)&(outDivMapCont->BlockNodeList[i]->HeightMem));
		//3DOBJ̃AP[V
		outDivMapCont->BlockNodeList[i]->ObjDataList =  M3DO_AllocMap3DObjList(HEAPID_FIELD);
		outDivMapCont->BlockNodeList[i]->BlockIndex = NON_BLOCK;
		//n͐pɃAgr[gf[^̂ŁANAȂ
	}
	
	//BlockNodeList = sys_AllocMemory( HEAPID_FIELD, sizeof(BLOCK_NODE)*9 );
}

//--------------------------------------------------------------------------------------------
/**
 * A[JCuItZbg擾
 *
 * @param	ioHandle		A[JCunh
 * @param	inArcIndex		A[JCuCfbNX
 * @param	outData			擾f[^i[obt@
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void GetMapArcLoadOffset(ARCHANDLE *ioHandle, const int inArcIndex, DATA_OFS_SIZE *outData)
{
	void *raw_data;
	int *data;
	int size = sizeof(int)*4;	//4oCgS
	

	if (ioHandle != NULL){
		raw_data = sys_AllocMemoryLo(HEAPID_FIELD, size);
		ArchiveDataLoadOfsByHandle( ioHandle, inArcIndex, 0, size, raw_data );
	}else{
		GF_ASSERT(0&&"ERROR:ArcHandle is NULL!\n");
		raw_data = ArchiveDataLoadMallocOfsLo(ARC_FIELD_MAP_DATA,inArcIndex,HEAPID_FIELD,0,size);
	}
	
	data = &((int*)(raw_data))[0];
	
	outData->AttrSize = *data;
	data++;
	outData->ObjSize = *data;
	data++;
	outData->MapSize = *data;
	data++;
	outData->HeightSize = *data;
	
	
	sys_FreeMemoryEz(raw_data);
#ifdef DEBUG_ONLY_FOR_saitou
	OS_Printf("local_print arc_size = %x,%x,%x,%x\n",
			outData->AttrSize,outData->ObjSize,outData->MapSize,outData->HeightSize);
#endif
}

//--------------------------------------------------------------------------------------------
/**
 * ubNf[^[h̓o^
 *
 * @param	inCount			o^ꏊi0nq1j
 * @param	inMapResource	}bv\[X
 * @param	inWorld			[h|C^
 * @param	inMapW			}bv
 * @param	inMapH			}bvc
 * @param	inDivMapCont	}bv\̃|C^
 * @param	*ioMLBS			[hubNf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void LoadBlock(	const u8 inCount,
						const MAP_RESOURCE_PTR inMapResource,
						const WORLD_MAP_PTR inWorld,
						const int inMapW,
						const int inMapH,
						DMC_PTR inDivMapCont,
						MAP_LOAD_BLOCK_ST *ioMLBS)
{
	int block_index;
	u8 local_index;
	int arc_index;
	DATA_OFS_SIZE data;
	block_index = ioMLBS->Block[inCount];
	
	if (block_index<0 || block_index>=inMapW*inMapH){
#ifdef DEBUG_ONLY_FOR_saitou		
		OS_Printf("BLOCK_LOAD_ERROR:INDEX_OVER %d\n",block_index);
#endif		
		return;
	}


	//A[JCuCfbNX擾
	arc_index = GetWorldMapArcIdx(block_index, inWorld);
#ifdef DEBUG_ONLY_FOR_saitou	
	OS_Printf("local_print A[JCuԍ%d\n",arc_index);
#endif	
	if (arc_index == MAP_ARC_NO_DATA){
		return;
	}
#if 0
	GF_ASSERT(inDivMapCont->ArcHandle==NULL&&"nhY");
	//A[JCunh̎擾
	inDivMapCont->ArcHandle = ArchiveDataHandleOpen( ARC_FIELD_MAP_DATA, HEAPID_FIELD );
#endif	
	GetMapArcLoadOffset(inDivMapCont->ArcHandle, arc_index, &data);

	//Agr[g[h
	{
		void *mem;
		mem = &(ioMLBS->Node[inCount]->Attribute[0]);
		ArchiveDataLoadByHandleContinue( inDivMapCont->ArcHandle, data.AttrSize, mem );
#ifdef DEBUG_ONLY_FOR_saitou
		OS_Printf("local_print Agr[g[h\n");
#endif
	}

	//3DOBJ[h
	M3DO_LoadArc3DObjData(	inDivMapCont->ArcHandle,
							data.ObjSize,
							inMapResource,
							ioMLBS->Node[inCount]->ObjDataList,
							inDivMapCont->Field3DAnmPtr);
	
	//n`[h
	{
		//ғ^XNǉ
		ioMLBS->TaskCnter.BlockLoadTaskCounter++;
#ifdef PM_DEBUG
		{
			if (data.MapSize > 0xf000){
				OS_Printf("A[JCu%d:n`fTCYI[o[ł:%d\n",arc_index,data.MapSize);
				GF_ASSERT(0);
			}
		}
#endif			
		ioMLBS->RandTask = Set3DModelTask(	inDivMapCont->ArcHandle,
											data.MapSize,
											&ioMLBS->Node[inCount]->FloorData,
											&(ioMLBS->Node[inCount]->FloorResFile),
											GetMapResourceTexturePTR(inMapResource),
											&(ioMLBS->Node[inCount]->DrawOKFlg),
											&ioMLBS->TaskCnter.BlockLoadTaskCounter);

		
	}

	//[h	
	{
		//ғ^XNǉ
		ioMLBS->TaskCnter.BlockHeightLoadTaskCounter++;
		ioMLBS->HeightTask = SetupHeightDataArcTask(inDivMapCont->ArcHandle,
													data.HeightSize,
													ioMLBS->Node[inCount]->MapHeightInfo,
													&ioMLBS->TaskCnter.BlockHeightLoadTaskCounter,
													&ioMLBS->Node[inCount]->HeightMem,
													&ioMLBS->TaskCnter.BlockLoadTaskCounter);
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ubNf[^[h̓o^inj
 *
 * @param	inCount			o^ꏊi0nq1j
 * @param	inMapResource	}bv\[X
 * @param	inWorld			[h|C^
 * @param	inMapW			}bv
 * @param	inMapH			}bvc
 * @param	inDivMapCont	}bv\̃|C^
 * @param	*ioMLBS			[hubNf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void LoadBlockForUnder(	const u8 inCount,
								const MAP_RESOURCE_PTR inMapResource,
								const WORLD_MAP_PTR inWorld,
								const int inMapW,
								const int inMapH,
								DMC_PTR inDivMapCont,
								MAP_LOAD_BLOCK_ST *ioMLBS)
{
	int block_index;
	u8 local_index;
	int arc_index;
	DATA_OFS_SIZE data;
	block_index = ioMLBS->Block[inCount];
	
	if (block_index<0 || block_index>=inMapW*inMapH){
#ifdef	DIV_MAP_LOAD_BORDER_PRINT_ON
		OS_Printf("BLOCK_LOAD_ERROR:INDEX_OVER %d\n",block_index);
#endif
		return;
	}

	//A[JCuCfbNX擾
	arc_index = GetWorldMapArcIdx(block_index, inWorld);
#ifdef DEBUG_ONLY_FOR_saitou	
	OS_Printf("local_print A[JCuԍ%d\n",arc_index);
#endif	
	if (arc_index == MAP_ARC_NO_DATA){
		return;
	}
#if 0	
	GF_ASSERT(inDivMapCont->ArcHandle==NULL&&"nhY");
	//A[JCunh̎擾
	inDivMapCont->ArcHandle = ArchiveDataHandleOpen( ARC_FIELD_MAP_DATA, HEAPID_FIELD );
#endif	
	GetMapArcLoadOffset(inDivMapCont->ArcHandle, arc_index, &data);

	{
		u8 temp[0x800];
		//Agr[g͔΂
		///ArchiveDataSeekByHandle( inDivMapCont->ArcHandle, 0x800+0x10 );
		ArchiveDataLoadByHandleContinue( inDivMapCont->ArcHandle, 0x800, temp );
	}
	//3DOBJ[h
	M3DO_LoadArc3DObjData(	inDivMapCont->ArcHandle,
							data.ObjSize,
							inMapResource,
							ioMLBS->Node[inCount]->ObjDataList,
							inDivMapCont->Field3DAnmPtr);
	
	//n`[h
	{
		//ғ^XNǉ
		ioMLBS->TaskCnter.BlockLoadTaskCounter++;
#ifdef PM_DEBUG
		{
			if (data.MapSize > 0xf000){
				OS_Printf("A[JCu%d:n`fTCYI[o[ł:%d\n",arc_index,data.MapSize);
				GF_ASSERT(0);
			}
		}
#endif			
		ioMLBS->RandTask = Set3DModelTask(	inDivMapCont->ArcHandle,
											data.MapSize,
											&ioMLBS->Node[inCount]->FloorData,
											&(ioMLBS->Node[inCount]->FloorResFile),
											GetMapResourceTexturePTR(inMapResource),
											&(ioMLBS->Node[inCount]->DrawOKFlg),
											&ioMLBS->TaskCnter.BlockLoadTaskCounter);

		
	}
	//͓ǂ܂Ȃ		
}

//--------------------------------------------------------------------------------------------
/**
 * ubÑ[h1sync^(ꊇǂݍ݂̂߁AubNAEgɎgp)
 *
 * @param	inBlockIndex	ubNCfbNX
 * @param	inLocalIndex	0`3[JCfbNX
 * @param	inMapResource	}bv\[X
 * @param	inWorld			[h|C^
 * @param	inMapW			}bv
 * @param	inMapH			}bvc
 * @param	inLightValid	CgtO
 * @param	outDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void LoadBlockQuick(	const int inBlockIndex,
							const u8 inLocalIndex,
							const MAP_RESOURCE_PTR inMapResource,
							const WORLD_MAP_PTR inWorld,
							const int inMapW,
							const int inMapH,
							const BOOL inLightValid,
							DMC_PTR outDivMapCont)
{
	int arc_index;
	NNSG3dResMdl* model;			// f
	DATA_OFS_SIZE data;
	
	if (inBlockIndex<0 || inBlockIndex>=inMapW*inMapH){
#ifdef	DIV_MAP_LOAD_BORDER_PRINT_ON		
		OS_Printf("BLOCK_LOAD_ERROR:INDEX_OVER\n");
#endif		
		return;
	}

	//A[JCuCfbNX擾
	arc_index = GetWorldMapArcIdx(inBlockIndex, inWorld);
#ifdef DEBUG_ONLY_FOR_saitou
	OS_Printf("local_print A[JCuԍ%d\n",arc_index);
#endif	
	if (arc_index == MAP_ARC_NO_DATA){
		return;
	}
	//A[JCunh̎擾
///	outDivMapCont->ArcHandle = ArchiveDataHandleOpen( ARC_FIELD_MAP_DATA, HEAPID_FIELD );
	
	GetMapArcLoadOffset(outDivMapCont->ArcHandle, arc_index, &data);

	//Agr[g[h
	{
		void *mem;
		mem = &(outDivMapCont->BlockNodeList[inLocalIndex]->Attribute[0]);

		ArchiveDataLoadByHandleContinue( outDivMapCont->ArcHandle, data.AttrSize, mem );
	}

	//3DOBJ[h
	M3DO_LoadArc3DObjData(	outDivMapCont->ArcHandle,
							data.ObjSize,
							inMapResource,
							outDivMapCont->BlockNodeList[inLocalIndex]->ObjDataList,
							outDivMapCont->Field3DAnmPtr);
	
	//n`[h
	{
		model = Set3DModel(	outDivMapCont->ArcHandle,
							data.MapSize,
							&outDivMapCont->BlockNodeList[inLocalIndex]->FloorData,
							&(outDivMapCont->BlockNodeList[inLocalIndex]->FloorResFile),
							GetMapResourceTexturePTR(inMapResource));

		if (inLightValid == TRUE){
			//O[oXe[ggp
			SetGlbLightMdl(model);
		}

		outDivMapCont->BlockNodeList[inLocalIndex]->DrawOKFlg = TRUE;	
	}

	//[h
	{
		SetupHeightDataArc(	outDivMapCont->ArcHandle,
							data.HeightSize,
							outDivMapCont->BlockNodeList[inLocalIndex]->MapHeightInfo,
							outDivMapCont->BlockNodeList[inLocalIndex]->HeightMem);
	}
#if 0
	//A[JCunh̉
	ArchiveDataHandleClose( outDivMapCont->ArcHandle );
	outDivMapCont->ArcHandle = NULL;
#endif	
	outDivMapCont->BlockNodeList[inLocalIndex]->BlockIndex = inBlockIndex;

	//R[obNĂяo
	if (outDivMapCont->CallBack!=NULL){
		outDivMapCont->CallBack(	outDivMapCont->CallBackWork,
									inBlockIndex,
									outDivMapCont->BlockNodeList[inLocalIndex]->ObjDataList);
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ubÑ[h1sync^(ꊇǂݍ݂̂߁AubNAEgɎgp)np
 *
 * @param	inBlockIndex	ubNCfbNX
 * @param	inLocalIndex	0`3@[JCfbNX
 * @param	inMapResource	}bv\[X
 * @param	inWorld			[h|C^
 * @param	inMapW			}bv
 * @param	inMapH			}bvc
 * @param	inLightValid	CgtO
 * @param	outDivMapCont	}bv\̃|C^
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void LoadBlockQuickForUnder(	const int inBlockIndex,
									const u8 inLocalIndex,
									const MAP_RESOURCE_PTR inMapResource,
									const WORLD_MAP_PTR inWorld,
									const int inMapW,
									const int inMapH,
									const BOOL inLightValid,
									DMC_PTR outDivMapCont)
{
	int arc_index;
	DATA_OFS_SIZE data;
	NNSG3dResMdl* model;			// f
	if (inBlockIndex<0 || inBlockIndex>=inMapW*inMapH){
		return;
	}

	//A[JCuCfbNX擾
	arc_index = GetWorldMapArcIdx(inBlockIndex, inWorld);
#ifdef DEBUG_ONLY_FOR_saitou
	OS_Printf("local_print A[JCuԍ%d\n",arc_index);
#endif
	if (arc_index == MAP_ARC_NO_DATA){
		return;
	}
	//A[JCunh̎擾
///	outDivMapCont->ArcHandle = ArchiveDataHandleOpen( ARC_FIELD_MAP_DATA, HEAPID_FIELD );
	
	GetMapArcLoadOffset(outDivMapCont->ArcHandle, arc_index, &data);

	{
		u8 temp[0x800];
		//Agr[g͔΂
		///ArchiveDataSeekByHandle( outDivMapCont->ArcHandle, 0x800+0x10 );
		ArchiveDataLoadByHandleContinue( outDivMapCont->ArcHandle, 0x800, temp );
	}

	//3DOBJ[h
	M3DO_LoadArc3DObjData(	outDivMapCont->ArcHandle,
							data.ObjSize,
							inMapResource,
							outDivMapCont->BlockNodeList[inLocalIndex]->ObjDataList,
							outDivMapCont->Field3DAnmPtr);
	
	//n`[h
	{
		model = Set3DModel(	outDivMapCont->ArcHandle,
							data.MapSize,
							&outDivMapCont->BlockNodeList[inLocalIndex]->FloorData,
							&(outDivMapCont->BlockNodeList[inLocalIndex]->FloorResFile),
							GetMapResourceTexturePTR(inMapResource));

		if (inLightValid == TRUE){
			//O[oXe[ggp
			SetGlbLightMdl(model);
		}

		outDivMapCont->BlockNodeList[inLocalIndex]->DrawOKFlg = TRUE;	
	}

	//ǂ܂Ȃ
#if 0
	//A[JCunh̉
	ArchiveDataHandleClose( outDivMapCont->ArcHandle );
	outDivMapCont->ArcHandle = NULL;
#endif	
	outDivMapCont->BlockNodeList[inLocalIndex]->BlockIndex = inBlockIndex;
}

//--------------------------------------------------------------------------------------------
/**
 * ubN[h^XNғ`FbN
 *
 * @param	*inTaskCnter	^XNJE^
 *
 * @return	BOOL		TRUE:I	FALSE:ғ
 */
//--------------------------------------------------------------------------------------------
static BOOL CheckBlockLoadTaskCounter(const MAP_LOAD_TASK_COUNTER *inTaskCnter)
{
	if ((inTaskCnter->BlockLoadTaskCounter == 0)&&(inTaskCnter->BlockHeightLoadTaskCounter == 0) ){
		return TRUE;
	}
	else{
		return FALSE;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * }bv[hNGXg֐
 *
 * @param	ioDivMapCont	}bv\̃|C^
 * @param	inBlock1		1[hubNCfbNX
 * @param	inBlock2		2[hubNCfbNX
 * @param	inIdx1			1[h[JCfbNX(0`3)
 * @param	inIdx2			2[h[JCfbNX(0`3)
 * @param	inBlankNo		o^󂫏ꏊi0nq1j
 * @param	inDir			[h
 *
 * @return	BOOL		o^L	TRUE:	FALSE:s
 */
//--------------------------------------------------------------------------------------------
static BOOL BlockLoadReqest( DMC_PTR ioDivMapCont,
								const int inBlock1,
								const int inBlock2,
								const u8 inIdx1,
								const u8 inIdx2,
								const u8 inBlankNo,
								const u8 inDir)
{
	//ғɓo^悤ƂĂ̂ŃG[Ƃ
	GF_ASSERT((ioDivMapCont->MLBC[inBlankNo].Moving == FALSE)&&"ERROR:ғȂ̂ɓo^悤ƂĂ");
	
	//ғɂ
	ioDivMapCont->MLBC[inBlankNo].Moving = TRUE;

	//[hۑ
	ioDivMapCont->MLBC[inBlankNo].LoadDir = inDir;
	
	ioDivMapCont->MLBC[inBlankNo].MLBS.Block[0] = inBlock1;
	ioDivMapCont->MLBC[inBlankNo].MLBS.Block[1] = inBlock2;
	ioDivMapCont->MLBC[inBlankNo].MLBS.Index[0] = inIdx1;
	ioDivMapCont->MLBC[inBlankNo].MLBS.Index[1] = inIdx2;
	
	ioDivMapCont->MLBC[inBlankNo].MLBS.Node[0] = ioDivMapCont->BlockNodeList[inIdx1];
	ioDivMapCont->MLBC[inBlankNo].MLBS.Node[1] = ioDivMapCont->BlockNodeList[inIdx2];

	ioDivMapCont->MLBC[inBlankNo].MLBS.TotalCount = 0;
	ioDivMapCont->MLBC[inBlankNo].MLBS.BlockLoadOK = FALSE;

	//ғ[_[ȂȂ烍[hNGXg
	//ғ[_[ȂAo^
	if (ioDivMapCont->MovingNum == 0){		
		ioDivMapCont->LoadSeq = DML_LOAD_BLOCK;
	}

	ioDivMapCont->BlockNodeList[inIdx1]->BlockIndex = inBlock1;
	ioDivMapCont->BlockNodeList[inIdx2]->BlockIndex = inBlock2;
	
	ioDivMapCont->MovingNum++;
	ioDivMapCont->BlankNo = (ioDivMapCont->BlankNo+1)%2;
	
	return TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * CV[PX֐
 *
 * @param	fsys			tB[hVXe|C^
 * @param	ioDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void DivMapLoadMain(FIELDSYS_WORK *fsys, DMC_PTR ioDivMapCont)
{
#ifdef DEBUG_ONLY_FOR_saitou
static test_sync_count_flg = FALSE;
static test_sync_counter = 0;
#endif
	u8 my_dir;
	MAP_LOAD_BLOCK_ST *mlbs;
	DIV_MAP_CHECK	*dmc;
	mlbs = &ioDivMapCont->MLBC[ioDivMapCont->NowMovingNo].MLBS;
	dmc = &ioDivMapCont->MapCheck;
#ifdef DEBUG_ONLY_FOR_saitou	
if (test_sync_count_flg){
	test_sync_counter++;
}
#endif
	if (dmc->Valid == TRUE){

		//݈ړ
		if (dmc->Moving){	//WƌݍW̍A1ObhɂȂ𔻒
			
			GF_ASSERT((*dmc->SmallVal)<=(*dmc->LargeVal)&&"ERROR:ls");

			if ( (*dmc->LargeVal) - (*dmc->SmallVal) >= (FX32_ONE *ONE_GRID_SIZE) ){
				int grid_x,grid_z;
				//͊OlMpčs܂
				//1Obhړ
				GetGridXZ(dmc->TargetPoint->x, dmc->TargetPoint->z, &grid_x, &grid_z);	
				UpdateNowData(grid_x, grid_z, ioDivMapCont);//f[^XV
				dmc->OldPoint = *dmc->TargetPoint;
                if(!(dmc->OldPoint.z%(FX32_ONE*8)==0)){  // ʐMɂ̓G[ɂ
                    if(CommStateSetError(COMM_ERROR_RESET_SAVEPOINT)){
                        return;
                    }
                }
				GF_ASSERT(dmc->OldPoint.z%(FX32_ONE*8)==0&&"ObhPʂ̈ړȂĂȂ");
				dmc->Moving = FALSE;
				dmc->LargeVal = NULL;
				dmc->SmallVal = NULL;
			}
		}else{	//oChĂW̓n߂o
			if ( (dmc->OldPoint.x != dmc->TargetPoint->x)&&
					(dmc->OldPoint.z != dmc->TargetPoint->z) ){
				//AὠG[Ƃ
				GF_ASSERT(0&&"ERRORFXZω");				
			}else if ( (dmc->OldPoint.x == dmc->TargetPoint->x)&&
						(dmc->OldPoint.z == dmc->TargetPoint->z) ){
				;//Ȃ
			}else{	//XZǂ炩̕ωꍇ
				dmc->Moving = TRUE;
				if (dmc->OldPoint.x != dmc->TargetPoint->x){	//Xω
					if (dmc->OldPoint.x > dmc->TargetPoint->x){
						//Ŵق傫Ɉړ
						dmc->LargeVal = &dmc->OldPoint.x;
						dmc->SmallVal = &dmc->TargetPoint->x;
						dmc->Dir = MAP_LOAD_LEFT;
					}else{
						//EɈړ
						dmc->LargeVal = &dmc->TargetPoint->x;
						dmc->SmallVal = &dmc->OldPoint.x;
						dmc->Dir = MAP_LOAD_RIGHT;
					}
                    if(!(dmc->OldPoint.x%(FX32_ONE*8)==0)){  // ʐMɂ̓G[ɂ
                        if(CommStateSetError(COMM_ERROR_RESET_SAVEPOINT)){
                            return;
                        }
                    }
                    GF_ASSERT(dmc->OldPoint.x%(FX32_ONE*8)==0&&"xWObhPʂ̈ړł͂Ȃ");
				}
				else{	//Zω
					if (ioDivMapCont->MapCheck.OldPoint.z >	ioDivMapCont->MapCheck.TargetPoint->z){
						//Ŵق傫Ɉړ
						dmc->LargeVal = &dmc->OldPoint.z;
						dmc->SmallVal = &dmc->TargetPoint->z;
						dmc->Dir = MAP_LOAD_UP;
					}else{
						//Ɉړ
						dmc->LargeVal = &dmc->TargetPoint->z;
						dmc->SmallVal = &dmc->OldPoint.z;
						dmc->Dir = MAP_LOAD_DOWN;
					}
                    if(!(dmc->OldPoint.z%(FX32_ONE*8)==0)){  // ʐMɂ̓G[ɂ
                        if(CommStateSetError(COMM_ERROR_RESET_SAVEPOINT)){
                            return;
                        }
                    }
					GF_ASSERT(dmc->OldPoint.z%(FX32_ONE*8)==0&&"zWObhPʂ̈ړł͂Ȃ");
				}
				//[hNGXg
				DivMapLoad_UpdateBlockData(dmc->Dir,ioDivMapCont);
			}
		}
	
	}//end if(dmc->Valid == TRUE)
	
	switch(ioDivMapCont->LoadSeq){
	case DML_LOAD_BLOCK:	//ubÑ[h
#ifdef DIV_MAP_LOAD_DEBUG
		OS_Printf("[hJn\n");
#endif
		///OS_Printf("~mF%d\n",mlbs->Index[mlbs->TotalCount]);
		//NGXg~ĂȂȂA[h
		if (ioDivMapCont->LocalFreeIndexTable[mlbs->Index[mlbs->TotalCount]] == TRUE){
#ifdef DIV_MAP_LOAD_DEBUG			
			OS_Printf("NGXgĂ̂ŁA[hȂ\n");
#endif
			;
		}else{
#ifdef DIV_MAP_LOAD_DEBUG
			OS_Printf("g[^%d,[JCfbNX%d:[h\n",mlbs->TotalCount+1,mlbs->Index[mlbs->TotalCount]);
			OS_Printf("%d:ݓǂݍ݈ʒu\n",ioDivMapCont->NowMovingNo);
#endif
			ioDivMapCont->FuncList->DivLoadFunc(	mlbs->TotalCount,
												ioDivMapCont->MapResource,
												ioDivMapCont->World,
												ioDivMapCont->MapW,
												ioDivMapCont->MapH,
												ioDivMapCont,
												mlbs);
#ifdef DEBUG_ONLY_FOR_saitou			
			test_sync_count_flg = TRUE;
			test_sync_counter = 1;
#endif
		}
		mlbs->TotalCount++;
		
		ioDivMapCont->LoadSeq = DML_LOAD_WAIT;
		break;
	case DML_LOAD_WAIT:		//ubN[hI҂
		if (ioDivMapCont->LocalFreeIndexTable[mlbs->Index[mlbs->TotalCount-1]] == TRUE){
#ifdef DIV_MAP_LOAD_DEBUG
			OS_Printf("%d,%d:NGXgĂ̂ŁA\n",mlbs->Index[mlbs->TotalCount-1],mlbs->TotalCount);
#endif
			LoadTaskStopReqestByMLBS(mlbs);
			ioDivMapCont->LocalFreeIndexTable[mlbs->Index[mlbs->TotalCount-1]] = FALSE;
		}
		if ((mlbs->TotalCount <=2)&&(CheckBlockLoadTaskCounter(&mlbs->TaskCnter) == TRUE)){
			if (mlbs->TotalCount>=2){
#ifdef DIV_MAP_LOAD_DEBUG
				OS_Printf("%d:2ߓǂݍݏI\n",mlbs->TotalCount);
#endif
				mlbs->BlockLoadOK = TRUE;	//ǂݍݏI
				//2̃ubN[hÎŁAςݍ܂ĂubN[h邩𒲂ׂ
				//ς܂Ăꍇ͏
///		MapLoadCont.MLBC[MapLoadCont.NowMovingTaskNo].MLBS.Node[0]->DrawOKFlg = TRUE;
///		MapLoadCont.MLBC[MapLoadCont.NowMovingTaskNo].MLBS.Node[1]->DrawOKFlg = TRUE;
				
			}else{
#ifdef DIV_MAP_LOAD_DEBUG
				OS_Printf("%d:1ߓǂݍݏI\n",mlbs->TotalCount);
#endif
				ioDivMapCont->LoadSeq = DML_LOAD_BLOCK;
#ifdef DIV_MAP_LOAD_DEBUG	
				OS_Printf("1ڃ[hI@mlbs->LoadTime = %d\n",mlbs->DebugLoadTimer);
#endif				
			}
#if 0			
			//ǂݍ݂ÎŃA[JCunh
			if (ioDivMapCont->ArcHandle != NULL){
				ArchiveDataHandleClose( ioDivMapCont->ArcHandle );
				ioDivMapCont->ArcHandle = NULL;
			}
#endif			
			if (/*mlbs->Node[mlbs->TotalCount-1]->FloorResFile != NULL*/mlbs->Node[mlbs->TotalCount-1]->DrawOKFlg == TRUE){
				NNSG3dResMdlSet* pMdlSet = NNS_G3dGetMdlSet(mlbs->Node[mlbs->TotalCount-1]->FloorResFile);
				NNSG3dResMdl* model = NNS_G3dGetMdlByIdx(pMdlSet, 0);
				if (MAPRES_IsValidLight(ioDivMapCont->MapResource) == TRUE){
					//O[oXe[ggp
					SetGlbLightMdl(model);
				}
			}
#ifdef DIV_CALL_BACK	
			//ŃR[obN
			if (ioDivMapCont->CallBack!=NULL){
				//}gbNXTCYāAI[o[ĂR[Ȃ
				if (0<=mlbs->Node[mlbs->TotalCount-1]->BlockIndex &&
					mlbs->Node[mlbs->TotalCount-1]->BlockIndex<ioDivMapCont->MapW*ioDivMapCont->MapH){
					ioDivMapCont->CallBack(	ioDivMapCont->CallBackWork,
											mlbs->Node[mlbs->TotalCount-1]->BlockIndex,
											mlbs->Node[mlbs->TotalCount-1]->ObjDataList);
				}
			}
#endif
#ifdef DEBUG_ONLY_FOR_saitou			
			//VN\
			OS_Printf("local_print [hvVN%d\n",test_sync_counter);
			test_sync_counter = 0;
			test_sync_count_flg = FALSE;
#endif			
		}
		break;
	case DML_NONE:			//
		break;
	case DML_FREE_WAIT:		//ubN[h҂
		if ( CheckBlockLoadTaskCounter(&mlbs->TaskCnter)==TRUE ){
			//[hĎ΁A^XNImFł
			ioDivMapCont->MovingNum = 0;
#if 0			
			//ǂݍ݂ÎŃA[JCunh
			if (ioDivMapCont->ArcHandle != NULL){
				ArchiveDataHandleClose( ioDivMapCont->ArcHandle );
				ioDivMapCont->ArcHandle = NULL;
			}
#endif			
		}
		break;
	}

	//ғĂ̂ȂȂ
	if (ioDivMapCont->MovingNum == 0){
		ioDivMapCont->NowMovingNo = 0;
		ioDivMapCont->BlankNo = 0;
		ioDivMapCont->LoadSeq = DML_NONE;		//V[PX
		return;
	}

	//ubN[hIĎ
	if ( IsFinishedLoadBlock(ioDivMapCont) == TRUE){
		//ғtOƂ
		ioDivMapCont->MLBC[ioDivMapCont->NowMovingNo].Moving = FALSE;

		//ubN}[LONA
		ClearLocalFreeIndexTable(ioDivMapCont);
		
		ioDivMapCont->MovingNum--;		//ǗZ
	
		ioDivMapCont->NowMovingNo = (ioDivMapCont->NowMovingNo+1)%2;	//ғԍXV

		//ғ҂ubN[hȂA[hJn
		if (ioDivMapCont->MovingNum != 0){
#ifdef DIV_MAP_LOAD_DEBUG
			OS_Printf("[hJn\n");
#endif
			//MapLoadCont.MLBC[MapLoadCont.NowMovingNo].MLBS.ReadStartOK = TRUE;

			ioDivMapCont->LoadSeq = DML_LOAD_BLOCK;		//[hV[PX

		}else{
			ioDivMapCont->NowMovingNo = 0;
			ioDivMapCont->BlankNo = 0;
			ioDivMapCont->LoadSeq = DML_NONE;		//V[PX
		}

		//XgbNꍇ͗DIɓo^
		if (ioDivMapCont->Stock.Valid == TRUE){
			BOOL rc;
			ioDivMapCont->Stock.Valid = FALSE;
			//XgbNAǂݍ܂ȂĂ[JCfbNX肷
			MarkLocalFreeIndexTableByDir(ioDivMapCont->Stock.LoadDir,ioDivMapCont);
			
			AddMapLoadForStock(ioDivMapCont);
		}
		
	}
}

//--------------------------------------------------------------------------------------------
/**
 * }bv[hǉ
 *
 * @param	inBlock1		1[hubNCfbNX
 * @param	inBlock2		2[hubNCfbNX
 * @param	inIdx1			1[h[JCfbNX(0`3)
 * @param	inIdx2			2[h[JCfbNX(0`3)
 * @param	inDir			[h
 * @param	ioDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void AddMapLoad( const int inBlock1,
						const int inBlock2,
						const u8 inIdx1,
						const u8 inIdx2,
						const u8 inDir,
						DMC_PTR ioDivMapCont)
{
	int i;
	u8 no;
	BOOL rc;
	
#ifdef DEBUG_ONLY_FOR_saitou
	if (ioDivMapCont->MovingNum>=2){
		OS_Printf("local_print 3\n");
	}
#endif
	GF_ASSERT((ioDivMapCont->Stock.Valid != TRUE)&&"XgbN܂Ă");
	//݃NGXĝĂ郍[hƉғ^XN̕r
	if ( CompLoadDirection(inDir, ioDivMapCont, &no) == TRUE ){
		//[hƃNGXg΂Ȃ΁A[h~
#ifdef DIV_MAP_LOAD_DEBUG
		OS_Printf("no:%d",no);
#endif
		LoadStopReqest(ioDivMapCont,no);
		//󂫂Ȃꍇ
		if (ioDivMapCont->MovingNum>=2){
			ioDivMapCont->Stock.Valid = TRUE;
			ioDivMapCont->Stock.Block[0] = inBlock1;
			ioDivMapCont->Stock.Block[1] = inBlock2;
			ioDivMapCont->Stock.Index[0] = inIdx1;
			ioDivMapCont->Stock.Index[1] = inIdx2;
			ioDivMapCont->Stock.Node[0] = ioDivMapCont->BlockNodeList[inIdx1];
			ioDivMapCont->Stock.Node[1] = ioDivMapCont->BlockNodeList[inIdx2];
			ioDivMapCont->Stock.LoadDir = inDir;
			
			ioDivMapCont->BlockNodeList[inIdx1]->BlockIndex = inBlock1;
			ioDivMapCont->BlockNodeList[inIdx2]->BlockIndex = inBlock2;

		}else{
			rc = BlockLoadReqest(ioDivMapCont,inBlock1,inBlock2,inIdx1,inIdx2,ioDivMapCont->BlankNo,inDir);
			if (rc == FALSE){
				//󂫂ȂꍇiNGXg~^XN܂3ځjANGXgҋ@ԂɂƂ
#ifdef DEBUG_ONLY_FOR_saitou
				OS_Printf("local_print ERROR:3\n");
#endif				
			}
		}
	}else{
		//΂łȂꍇANGXgǉ
		//󂢂ĂǗ^XNɓo^
		rc = BlockLoadReqest(ioDivMapCont,inBlock1,inBlock2,inIdx1,inIdx2,ioDivMapCont->BlankNo,inDir);
#ifdef DIV_MAP_LOAD_DEBUG
		OS_Printf("%dɃ^XNo^\n",MapLoadCont.BlankNo);
#endif
		//Ǘ^XNςȂ̂ɁANGXgꍇAG[ƂƂ
		GF_ASSERT((rc==TRUE)&&"ERROR:Ǘ^XNς");
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ubNf[^̉(ړ)
 *
 * @param	inLocalIndex	郍[JCfbNXi0`3j
 * @param	outDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void FreeBlock(const u8 inLocalIndex, DMC_PTR outDivMapCont)
{
	outDivMapCont->BlockNodeList[inLocalIndex]->DrawOKFlg = FALSE;
	SetInvalidHeightData(outDivMapCont->BlockNodeList[inLocalIndex]->MapHeightInfo);
//	ClearFldMapMem(inLocalIndex, outDivMapCont->FldMapMem);
	
	//3DOBJf[^(ۂɂ́Af[^ł͂ȂAǗ̃NA)
	M3DO_CleanMap3DObjList(outDivMapCont->BlockNodeList[inLocalIndex]->ObjDataList);
	outDivMapCont->BlockNodeList[inLocalIndex]->BlockIndex = NON_BLOCK;

	//Agr[gNA
	MI_CpuFillFast(outDivMapCont->BlockNodeList[inLocalIndex]->Attribute, 0xffffffff, 2*32*32 );
	
	//ubN}[LO
	outDivMapCont->LocalFreeIndexTable[inLocalIndex] = TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * ubNf[^m[h̉
 *
 * @param	inFreeNo1		ubNm[hio[P
 * @param	inFreeNo2		ubNm[hio[Q
 * @param	inMoveNo1		VKǂݍ݃ubNm[hio[P
 * @param	inMoveNo2		VKǂݍ݃ubNm[hio[Q
 * @param	ioDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void FreeAndMoveNode(const u8 inFreeNo1,
							const u8 inFreeNo2,
							const u8 inMoveNo1,
							const u8 inMoveNo2,
							DMC_PTR ioDivMapCont)
{
	BLOCK_NODE *TempNode[2];
	//inFreeNo1,inFreeNo2
	FreeBlock(inFreeNo1,ioDivMapCont);
	FreeBlock(inFreeNo2,ioDivMapCont);
	//m[h1ދ
	TempNode[0] = ioDivMapCont->BlockNodeList[inFreeNo1];
	TempNode[1] = ioDivMapCont->BlockNodeList[inFreeNo2];
	//c2̃e[uړ
	ioDivMapCont->BlockNodeList[inFreeNo1] = ioDivMapCont->BlockNodeList[inMoveNo1];
	ioDivMapCont->BlockNodeList[inFreeNo2] = ioDivMapCont->BlockNodeList[inMoveNo2];
	//ދm[hVǂݍ݈ʒuɖ߂
	ioDivMapCont->BlockNodeList[inMoveNo1] = TempNode[0];
	ioDivMapCont->BlockNodeList[inMoveNo2] = TempNode[1];
}

//--------------------------------------------------------------------------------------------
/**
 * ubNXV
 *
 * @param	inBlockIndex	ubNCfbNX
 * @param	inDirection		XV
 * @param	ioDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void UpdateBlockList(const int inBlockIndex, const u8 inDirection, DMC_PTR ioDivMapCont)
{
	u8 i,j;
	int block1,block2;
	int old_block;
	int idx1,idx2;
	switch(inDirection){
	case MAP_LOAD_UP:	//@Ɉړ(20A31)
		//2,30,1ړ
		FreeAndMoveNode(2,3,0,1,ioDivMapCont);

		//@̂ubNCfbNXL[ɂāA0,1ɂ͂ubNZo
		//20A31ŏꍇ

		if (/*ɂꍇ*/ioDivMapCont->NowPosInBlock == 2){
			block1 = inBlockIndex - ioDivMapCont->MapW;
			block2 = inBlockIndex - ioDivMapCont->MapW - 1;
			idx1 = 1;
			idx2 = 0;
			//`FbN
			if (block1<0){	//͈͊O
				//^̃ubN̓}gbNXɂ͂
				block1 = NON_BLOCK;
				block2 = NON_BLOCK;
			}else{
				//Qڂ̃ubN̓}gNXAǂݍ񂾂QubŃAsɂ͂
				if ( (block2<0)||(!CheckRowBlockIndex(block1,block2,ioDivMapCont->MapW)) ){	//͈͊O
					block2 = NON_BLOCK;
				}
			}
		}else if(/*Eɂꍇ*/ioDivMapCont->NowPosInBlock == 3){
			block1 = inBlockIndex - ioDivMapCont->MapW;
			block2 = inBlockIndex - ioDivMapCont->MapW + 1;
			idx1 = 0;
			idx2 = 1;
			//`FbN
			if (block1<0){	//͈͊O
				//^̃ubN̓}gbNXɂ͂
				block1 = NON_BLOCK;
				block2 = NON_BLOCK;
			}else{
				//ǂݍ񂾂QubŃAsɂ͂
				if ( !CheckRowBlockIndex(block1,block2,ioDivMapCont->MapW) ){	//͈͊O
					block2 = NON_BLOCK;
				}
			}
		}else{
			GF_ASSERT(0&&"ERROR:ړubNvZs");
		}
/**
		//`FbN
		if ( (block1<0)||(ioDivMapCont->MapW*ioDivMapCont->MapH<=block1) ){
			//͈͊O
			block1 = -1;
			block2 = -2;
		}
*/
		//0,1̐VK[h
		AddMapLoad(block1,block2,idx1,idx2,inDirection,ioDivMapCont);
		
		break;
	case MAP_LOAD_LEFT:	//@Ɉړ
		//1,30,2ړ
		FreeAndMoveNode(1,3,0,2,ioDivMapCont);
		
		//@̂ubNCfbNXL[ɂāA0,2ɂ͂ubNZo
		//10A32ŏꍇ

		if (/*Eɂꍇ*/ioDivMapCont->NowPosInBlock == 1){
			block1 = inBlockIndex - 1;
			block2 = inBlockIndex - ioDivMapCont->MapW - 1;
			idx1 = 2;
			idx2 = 0;
			//@̂c̃ubNCfbNXۑ(ړ̂)
///			old_block = ioDivMapCont->BlockNodeList[3]->BlockIndex;
			//`FbN
			if ( (block1<0)||(!CheckRowBlockIndex(block1,inBlockIndex,ioDivMapCont->MapW)) ){
				//ǂݍ񂾍ׂ̃ubŃA}gNXA܂łubNƓŝ͂
				block1 = NON_BLOCK;
				block2 = NON_BLOCK;
			}
			if ( (block2<0)||
					(!CheckColumnBlockIndex(block1,block2,ioDivMapCont->MapW)) ){
				//2ڂ̃ubŃA}gNXAǂݍ񂾂QubŃAɂ͂
				block2 = NON_BLOCK;
			}
		}else if(/*Eɂꍇ*/ioDivMapCont->NowPosInBlock == 3){
			block1 = inBlockIndex - 1;
			block2 = inBlockIndex + ioDivMapCont->MapW - 1;
			idx1 = 0;
			idx2 = 2;
			//@̂c̃ubNCfbNXۑ(ړ̂)
///			old_block = ioDivMapCont->BlockNodeList[1]->BlockIndex;
			//`FbN
			if ( (block1<0)||(!CheckRowBlockIndex(block1,inBlockIndex,ioDivMapCont->MapW)) ){
				//ǂݍ񂾍ׂ̃ubŃA}gNXA܂łubNƓŝ͂
				block1 = NON_BLOCK;
				block2 = NON_BLOCK;
			}
			if ( (ioDivMapCont->MapW*ioDivMapCont->MapH<=block2)||
					(!CheckColumnBlockIndex(block1,block2,ioDivMapCont->MapW)) ){
				//2ڂ̃ubŃA}gNXAǂݍ񂾂QubŃAɂ͂
				block2 = NON_BLOCK;
			}
		}else{
			GF_ASSERT(0&&"ERROR:ړubNvZs");
		}
		AddMapLoad(block1,block2,idx1,idx2,inDirection,ioDivMapCont);
/**		
#ifdef DIV_MAP_LOAD_DEBUG
		OS_Printf("load_block:%d,%d\nold:%d,%d\n",block1,block2,old_block1,old_block2);
#endif
		//VKǂݍ݃ubN̐`FbN(ړ̂)
		if (CheckSideBlockIndex(block1,old_block,ioDivMapCont->MapW)==TRUE){
			AddMapLoad(block1,block2,idx1,idx2,inDirection,ioDivMapCont);
		}else{
#ifdef	DEBUG_ONLY_FOR_saitou			
			OS_Printf("local_print ʍ[Ȃ̂Ń[hȂ\n");
#endif			
			ioDivMapCont->LocalFreeIndexTable[1] = FALSE;
			ioDivMapCont->LocalFreeIndexTable[3] = FALSE;
		}
*/		
		break;
	case MAP_LOAD_RIGHT: //@EɈړ
		//0,21,3ړ
		FreeAndMoveNode(0,2,1,3,ioDivMapCont);
		
		//@̂ubNCfbNXL[ɂāA1,3ɂ͂ubNZo
		//01A23ŏꍇ

		if (/*ɂꍇ*/ioDivMapCont->NowPosInBlock == 0){
			block1 = inBlockIndex + 1;
			block2 = inBlockIndex - ioDivMapCont->MapW + 1;
			idx1 = 3;
			idx2 = 1;
			//@̂c̃ubNCfbNXۑ(ړ̂)
///			old_block = ioDivMapCont->BlockNodeList[2]->BlockIndex;
			//`FbN
			if ( (ioDivMapCont->MapW*ioDivMapCont->MapH<=block1)||
					(!CheckRowBlockIndex(block1,inBlockIndex,ioDivMapCont->MapW)) ){
				//ǂݍ񂾉ẼׂubŃA}gNXA܂łubNƓŝ͂
				block1 = NON_BLOCK;
				block2 = NON_BLOCK;
			}
			if ( (ioDivMapCont->MapW*ioDivMapCont->MapH<=block2)||
					(!CheckColumnBlockIndex(block1,block2,ioDivMapCont->MapW)) ){
				//2ڂ̃ubN̓}gNXAǂݍ񂾂QubŃAɂ͂
				block2 = NON_BLOCK;
			}
		}else if(/*ɂꍇ*/ioDivMapCont->NowPosInBlock == 2){
			block1 = inBlockIndex + 1;
			block2 = inBlockIndex + ioDivMapCont->MapW + 1;
			idx1 = 1;
			idx2 = 3;
			//@̂c̃ubNCfbNXۑ(ړ̂)
///			old_block = ioDivMapCont->BlockNodeList[0]->BlockIndex;
			//`FbN
			if ( (ioDivMapCont->MapW*ioDivMapCont->MapH<=block1)||
					(!CheckRowBlockIndex(block1,inBlockIndex,ioDivMapCont->MapW)) ){
				//ǂݍ񂾉ẼׂubŃA}gNXA܂łubNƓŝ͂
				block1 = NON_BLOCK;
				block2 = NON_BLOCK;
			}
			if ( (block2<0)||
					(!CheckColumnBlockIndex(block1,block2,ioDivMapCont->MapW)) ){
				//2ڂ̃ubN̓}gNXAǂݍ񂾂QubŃAɂ͂
				block2 = NON_BLOCK;
			}
		}else{
			OS_Printf("ERROR:EړubNvZs\n");
		}
		AddMapLoad(block1,block2,idx1,idx2,inDirection,ioDivMapCont);
/**		
		//VKǂݍ݃ubN̐`FbN(ړ̂)
#ifdef DIV_MAP_LOAD_DEBUG
		OS_Printf("load_block:%d,%d\nold:%d,%d\n",block1,block2,old_block1,old_block2);
#endif
		
		if (CheckSideBlockIndex(block1,old_block,ioDivMapCont->MapW)==TRUE){
			AddMapLoad(block1,block2,idx1,idx2,inDirection,ioDivMapCont);
		}else{
#ifdef	DEBUG_ONLY_FOR_saitou		
			OS_Printf("local_print ʉE[Ȃ̂Ń[hȂ\n");
#endif			
			ioDivMapCont->LocalFreeIndexTable[0] = FALSE;
			ioDivMapCont->LocalFreeIndexTable[2] = FALSE;
		}
*/		
		break;
	case MAP_LOAD_DOWN: //@Ɉړ
		//0,12,3ړ
		FreeAndMoveNode(0,1,2,3,ioDivMapCont);
		
		//@̂ubNCfbNXL[ɂāA2,3ɂ͂ubNZo
		//02A13ŏꍇ

		if (/*ɂꍇ*/ioDivMapCont->NowPosInBlock == 0){
			block1 = inBlockIndex + ioDivMapCont->MapW;
			block2 = inBlockIndex + ioDivMapCont->MapW - 1;
			idx1 = 3;
			idx2 = 2;
			//`FbN
			if (ioDivMapCont->MapW*ioDivMapCont->MapH<=block1){	//͈͊O
				//^ubN̓}gNXɂ͂
				block1 = NON_BLOCK;
				block2 = NON_BLOCK;
			}else{
				//ǂݍ񂾂QubŃAsɂ͂
				if ( !CheckRowBlockIndex(block1,block2,ioDivMapCont->MapW) ){	//͈͊O
					block2 = NON_BLOCK;
				}
			}
		}else if(/*Eɂꍇ*/ioDivMapCont->NowPosInBlock == 1){
			block1 = inBlockIndex + ioDivMapCont->MapW;
			block2 = inBlockIndex + ioDivMapCont->MapW + 1;
			idx1 = 2;
			idx2 = 3;
			//`FbN
			if (ioDivMapCont->MapW*ioDivMapCont->MapH<=block1){	//͈͊O
				//^ubN̓}gNXɂ͂
				block1 = NON_BLOCK;
				block2 = NON_BLOCK;
			}else{
				//2߂̃ubN̓}gNXŁAǂݍ񂾂QubŃAsɂ͂
				if ( (ioDivMapCont->MapW*ioDivMapCont->MapH<=block2)||
						(!CheckRowBlockIndex(block1,block2,ioDivMapCont->MapW)) ){	//͈͊O
					block2 = NON_BLOCK;
				}
			}
		}else{
			GF_ASSERT(0&&"ERROR:ړubNvZs");
		}
/**		
		//`FbN
		if ( (block1<0)||(ioDivMapCont->MapW*ioDivMapCont->MapH<=block1) ){
			//͈͊O
			block1 = -1;
			block2 = -2;
		}
*/
		//2,3̐VK[h
		AddMapLoad(block1,block2,idx1,idx2,inDirection,ioDivMapCont);
		break;
	default:
		GF_ASSERT(0&&"ERROR:ubN̉ƍ쐬Ɏs");
		break;
	};
#ifdef DEBUG_ONLY_FOR_saitou
	OS_Printf("local_print_new_4_block:%d,%d,%d,%d",
			ioDivMapCont->BlockNodeList[0]->BlockIndex,
			ioDivMapCont->BlockNodeList[1]->BlockIndex,
			ioDivMapCont->BlockNodeList[2]->BlockIndex,
			ioDivMapCont->BlockNodeList[3]->BlockIndex );
#endif	
}

//--------------------------------------------------------------------------------------------
/**
 * ubN`
 *
 * @param	inLocalIndex	`惍[JCfbNX(0`3)
 * @param	inDivMapCont	}bv\̃|C^
 * @param	glst_data		O[oXe[g|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void DrawBlock(	const u8 inLocalIndex,
						DMC_CONST_PTR inDivMapCont,
						const GLST_DATA_PTR	glst_data)
{
	VecFx32 trans = {0, 0, 0};
	CalcMapOffset3D(	inDivMapCont->BlockNodeList[inLocalIndex]->BlockIndex,
						inDivMapCont->MapW,
						inDivMapCont->World,
						&trans);

//Rc`
	if (inDivMapCont->BlockNodeList[inLocalIndex]->DrawOKFlg == TRUE){
		VecFx32 scale = {FX32_ONE, FX32_ONE, FX32_ONE};
		MtxFx33 rot	  = {FX32_ONE,0,0,0,FX32_ONE,0,0,0,FX32_ONE};
#ifdef PM_DEBUG		
		if (DebugOutRangeFlg == TRUE){
			simple_3DModelDraw(&(inDivMapCont->BlockNodeList[inLocalIndex]->FloorData),
								&trans,
								&rot,
								&scale);
		}else{
			if (GetInvalidHeightDataFlg(inDivMapCont->BlockNodeList[inLocalIndex]->MapHeightInfo)
																						== TRUE){
				simple_3DModelDraw(&(inDivMapCont->BlockNodeList[inLocalIndex]->FloorData),
									&trans,
									&rot,
									&scale);
			}
		}
#else
		simple_3DModelDraw(&(inDivMapCont->BlockNodeList[inLocalIndex]->FloorData),
							&trans,
							&rot,
							&scale);
#endif
	}

	if(inDivMapCont->BlockNodeList[inLocalIndex]->DrawOKFlg == TRUE){
			M3DO_DrawMap3DObj(	&trans,
								inDivMapCont->MapResource,
								MAPRES_IsValidLight(inDivMapCont->MapResource),
								glst_data,
								inDivMapCont->BlockNodeList[inLocalIndex]->ObjDataList);
	}
}

//--------------------------------------------------------------------------------------------
/**
 * Obhio[ubNCfbNX擾
 *
 * @param	inGridNo	Obhio[
 * @param	inmaW		}bv
 * @pram	inMapGridW	}bvObh
 *
 * @return	int			ubNCfbNX
 */
//--------------------------------------------------------------------------------------------
static int GetBlockIdxFromGridNo(const u32 inGridNo, const int inMapW, const int inMapGridW)
{
	u32	grid_x,grid_z;
	u32 block_x,block_z;
	int block_index;
	
	grid_x = inGridNo%inMapGridW;
	grid_z = inGridNo/inMapGridW;
	block_x = grid_x / BLOCK_GRID_SIZE_X;
	block_z = grid_z / BLOCK_GRID_SIZE_Z;

	block_index = block_x+block_z*inMapW;
	return block_index;
}

//--------------------------------------------------------------------------------------------
/**
 * ObhWɁAݗĂObhio[Ԃ
 *
 * @param	inGeidX		ObhWw
 * @param	inGridZ		ObhWy
 * @param	inMapGridW	}bvObh
 *
 * @return	int	Obhio[
 */
//--------------------------------------------------------------------------------------------
static int CalcGridNoFromGridXZ(const int inGridX, const int inGridZ, const int inMapGridW)
{
	int grid_no;
	grid_no = inGridX + (inGridZ * inMapGridW);
	return grid_no;
}

//--------------------------------------------------------------------------------------------
/**
 * GAObhio[GAubNCfbNXZo
 *
 * @param	inGridNo		Obhio[
 * @param	inMapW			}bv
 * @param	inMapGridW		}bvObh
 *
 * @return	u32				ubNCfbNX
 */
//--------------------------------------------------------------------------------------------
static u32 GetBlockIndexFromGridNo(const u32 inGridNo, const int inMapW, const int inMapGridW)
{
	u32	grid_x,grid_z;
	u32 block_x,block_z;
	u32 block_index;
	
	grid_x = inGridNo%inMapGridW;
	grid_z = inGridNo/inMapGridW;
	block_x = grid_x / BLOCK_GRID_SIZE_X;
	block_z = grid_z / BLOCK_GRID_SIZE_Z;

	block_index = block_x+block_z*inMapW;
	return block_index;
}

//--------------------------------------------------------------------------------------------
/**
 * ubNʒu烍[JCfbNXvZi0`3j
 *
 * @param	inPosInBlock	ubNʒu(0`3)
 *
 * @return	u8				[JCfbNXi0`3j
 */
//--------------------------------------------------------------------------------------------
static u8 CalcLocalIdxFromPosInBlock(const u8 inPosInBlock)
{
	//
	if (inPosInBlock == 0){
		return 3;
	}else if (inPosInBlock == 1){
		return 2;
	}else if(inPosInBlock == 2){
		return 1;
	}else if (inPosInBlock == 3){
		return 0;
	}else{
		GF_ASSERT(0&&"ERROR:ubNʒus");
	}
	return 0;
}

//--------------------------------------------------------------------------------------------
/**
 * iƂĂ1Obh̃Obhio[擾
 *
 * @param	inDirection		
 * @param	inMapH			}bvc
 * @param	inMapGridW		}bvObh
 * @param	inNowGridNo		݃ObhCfbNX
 *
 * @return	u32				Obhio[
 */
//--------------------------------------------------------------------------------------------
static u32 GetNextGridNo(	const u8 inDirection,
							const int inMapH,
							const int inMapGridW,
							const int inNowGridNo)
{
	u32 grid_next;
	u32 next_block;
	int check;
	
	//݃Obhɂ킹āAObhvZ
	switch(inDirection){
	case  MAP_LOAD_RIGHT:		//E
		check = (inNowGridNo%inMapGridW)+1;
		if ( check >= inMapGridW ){
			OS_Printf("ERROR:EREA_RIGHT_OVER!!\n");
			return inNowGridNo;
		}
		grid_next = inNowGridNo + 1;	
		break;
	case MAP_LOAD_DOWN:			//
		check = inNowGridNo+inMapGridW;
		if (check >= inMapH*BLOCK_GRID_SIZE_Z*inMapGridW){
			OS_Printf("ERROR:EREA_DOWN_OVER!!\n");
			return inNowGridNo;
		}
		grid_next = inNowGridNo + inMapGridW;
		break;
	case MAP_LOAD_LEFT:			//
		check = (inNowGridNo%inMapGridW)-1;
		if ( check < 0 ){
			OS_Printf("ERROR:EREA_LEFT_OVER!!\n");
			return inNowGridNo;
		}
		grid_next = inNowGridNo - 1;
		break;
	case MAP_LOAD_UP:			//
		check = inNowGridNo-inMapGridW;
		if (check < 0 ){
			OS_Printf("ERROR:EREA_UP_OVER!!\n");
			return inNowGridNo;
		}
		grid_next = inNowGridNo - inMapGridW;
		break;
	default:
		GF_ASSERT(0&&"ERROR:NO_DIRECTION!!");
		return 0;
	}
	
	return  grid_next;
}


//--------------------------------------------------------------------------------------------
/**
 * is疢̃ubNʒu擾(ubNȓɂƂ̂ݎgp)
 *
 * @param	inDirection		
 * @param	inNowPosInBlock	݃ubN̂ǂɂ邩i0`3j
 *
 * @return	u8				ubNʒu(0`3)
 */
//--------------------------------------------------------------------------------------------
static u8 GetNextPosInBlock(const u8 inDirection, const int inNowPosInBlock)
{
	u8 pos;
	switch(inDirection){
	case MAP_LOAD_UP:
		pos = inNowPosInBlock-2;
		break;
	case MAP_LOAD_DOWN:
		pos = inNowPosInBlock+2;
		break;
	case MAP_LOAD_LEFT:
		pos = inNowPosInBlock-1;
		break;
	case MAP_LOAD_RIGHT:
		pos = inNowPosInBlock+1;
		break;
	}
	return pos;
}

//--------------------------------------------------------------------------------------------
/**
 * [JCfbNXXV
 *
 * @param	inDirection			XV
 * @param	inNowPosInBlock		݃ubN̂ǂɂ邩i0`3j
 * @param	outNowLocalIndex	[JCfbNXi[obt@
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void UpdateNowLocalIndexForAfterLoad(const u8 inDirection,
											const int inNowPosInBlock,
											u8 *outNowLocalIndex)
{
	u8 pos;
	u8 local_index;
	
	pos = GetNextPosInBlock(inDirection,inNowPosInBlock);
	
	if (inNowPosInBlock<pos){
		if (pos - inNowPosInBlock == 1){
			local_index = (*outNowLocalIndex)-1;			//E
		}else if(pos - inNowPosInBlock == 2){
			local_index = (*outNowLocalIndex)-2;			//
		}else{
			GF_ASSERT(0&&"ERROR:LOCAL_INDEX_ERROR!");
		}
	}else if(inNowPosInBlock>pos){
		if (inNowPosInBlock - pos == 1){
			local_index = (*outNowLocalIndex)+1;			//E
		}else if(inNowPosInBlock - pos == 2){
			local_index = (*outNowLocalIndex)+2;			//
		}else{
			GF_ASSERT(0&&"ERROR:LOCAL_INDEX_ERROR!");
		}
	}else{
		//[JCfbNX̍XVȂ;
		GF_ASSERT(0&&"ERROR:LOCAL_INDEX_NO_UPDATE!");
	}

	(*outNowLocalIndex) = local_index;
}

//--------------------------------------------------------------------------------------------
/**
 * ΂̕Ԃ
 *
 * @param	inDir	w
 *
 * @return	u8		w̋t
 */
//--------------------------------------------------------------------------------------------
static u8 GetRevDir(const u8 inDir)
{
	switch(inDir){
	case MAP_LOAD_UP:
		return MAP_LOAD_DOWN;
	case MAP_LOAD_DOWN:
		return MAP_LOAD_UP;
	case MAP_LOAD_RIGHT:
		return MAP_LOAD_LEFT;
	case MAP_LOAD_LEFT:
		return MAP_LOAD_RIGHT;
	default:
		GF_ASSERT(0&&"ERROR:͎ʂłȂ");
		return 0;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * [hƉғ[_̕r
 *
 * @param	inDir			
 * @param	inDivMapCont	}bv\̃|C^
 * @param	*outNo			o^ԍi0nq1j
 *
 * @return	BOOL	Ε̗L
 */
//--------------------------------------------------------------------------------------------
static BOOL CompLoadDirection(const u8 inDir, DMC_CONST_PTR inDivMapCont, u8* outNo)
{
	int i;
#ifdef DIV_MAP_LOAD_DEBUG	
	OS_Printf("r%d\n",inDir);
#endif	
	//݃NGXĝĂ郍[hƉғ^XN̕r
	for (i=0;i<2;i++){
#ifdef DIV_MAP_LOAD_DEBUG		
		OS_Printf("^XNǗ%d",inDivMapCont->MLBC[i].LoadDir);
#endif
		//^XNғH
		if (inDivMapCont->MLBC[i].Moving == TRUE){
			if (GetRevDir(inDir) == inDivMapCont->MLBC[i].LoadDir){
				*outNo = i;
				return TRUE;	//Ε
			}
		}
	}

	//ΕȂ
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * XgbNpubN[hNGXg
 * [hEŃubNf[^o^ہAς܂ĂāA[hɂłȂƂf[^XgbN܂
 * ̃XgbNꂽf[^鏈
 * 
 *
 * @param	ioDivMapCont	}bv\̃|C^
 *
 * @return	BOOL	o^L	TRUE:@FALSE:s
 */
//--------------------------------------------------------------------------------------------
static BOOL BlockLoadReqestForStock(DMC_PTR ioDivMapCont)
{
	STOCK_LOAD_DATA *stock = &ioDivMapCont->Stock;
	
	if (ioDivMapCont->MLBC[ioDivMapCont->BlankNo].Moving != FALSE){
		//ғ^XNɓo^悤ƂĂ̂ŃG[Ƃ
		GF_ASSERT(0&&"ERROR:ғȂ̂ɓo^悤ƂĂ");
	}

	//ғɂ
	ioDivMapCont->MLBC[ioDivMapCont->BlankNo].Moving = TRUE;

	//[hۑ
	ioDivMapCont->MLBC[ioDivMapCont->BlankNo].LoadDir = stock->LoadDir;
	
	ioDivMapCont->MLBC[ioDivMapCont->BlankNo].MLBS.Block[0] = stock->Block[0];
	ioDivMapCont->MLBC[ioDivMapCont->BlankNo].MLBS.Block[1] = stock->Block[1];
	ioDivMapCont->MLBC[ioDivMapCont->BlankNo].MLBS.Index[0] = stock->Index[0];
	ioDivMapCont->MLBC[ioDivMapCont->BlankNo].MLBS.Index[1] = stock->Index[1];
	
	ioDivMapCont->MLBC[ioDivMapCont->BlankNo].MLBS.Node[0] = stock->Node[0];
	ioDivMapCont->MLBC[ioDivMapCont->BlankNo].MLBS.Node[1] = stock->Node[1];

	ioDivMapCont->MLBC[ioDivMapCont->BlankNo].MLBS.TotalCount = 0;
	ioDivMapCont->MLBC[ioDivMapCont->BlankNo].MLBS.BlockLoadOK = FALSE;
	
	return TRUE;
}

//--------------------------------------------------------------------------------------------
/**
 * XgbNp}bv[h
 *
 * @param	ioDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void AddMapLoadForStock(DMC_PTR ioDivMapCont)
{
	int i;
	BOOL rc;
	STOCK_LOAD_DATA *stock = &ioDivMapCont->Stock;
	if (ioDivMapCont->MovingNum>=2){
		GF_ASSERT(0&&"ERROR:3");
	}
	rc = BlockLoadReqestForStock(ioDivMapCont/*stock,ioDivMapCont->BlankNo*/);
#ifdef DIV_MAP_LOAD_DEBUG	
	OS_Printf("XgbN%dɃ^XNo^\n",ioDivMapCont->BlankNo);
#endif
	//Ǘ^XNςȂ̂ɁANGXgꍇAG[ƂƂ
	GF_ASSERT((rc == TRUE)&&"ERROR:Ǘ^XNς");
	
	stock->Node[0]->BlockIndex = stock->Block[0];
	stock->Node[1]->BlockIndex = stock->Block[1];
		
	ioDivMapCont->MovingNum++;
	ioDivMapCont->BlankNo = (ioDivMapCont->BlankNo+1)%2;
}

//--------------------------------------------------------------------------------------------
/**
 * [hIĎ֐
 *
 * @param	inDivMapCont	}bv\̃|C^
 *
 * @return	BOOL		TRUE:I@FALSE:[hp
 */
//--------------------------------------------------------------------------------------------
static BOOL IsFinishedLoadBlock(DMC_CONST_PTR inDivMapCont)
{
	return inDivMapCont->MLBC[inDivMapCont->NowMovingNo].MLBS.BlockLoadOK;
}

//--------------------------------------------------------------------------------------------
/**
 * t[ubNǗe[uNA
 *
 * @param	outDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ClearLocalFreeIndexTable(DMC_PTR outDivMapCont)
{
	u8 i;
	for(i=0;i<4;i++){
		outDivMapCont->LocalFreeIndexTable[i] = FALSE;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * t[ubN}[LO
 *
 * @param	inDir	
 * @param	outDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void MarkLocalFreeIndexTableByDir(const u8 inDir, DMC_PTR outDivMapCont)
{
	switch(inDir){
	case MAP_LOAD_UP:
		outDivMapCont->LocalFreeIndexTable[2] = TRUE;
		outDivMapCont->LocalFreeIndexTable[3] = TRUE;
		break;
	case MAP_LOAD_RIGHT:
		outDivMapCont->LocalFreeIndexTable[0] = TRUE;
		outDivMapCont->LocalFreeIndexTable[2] = TRUE;
		break;
	case MAP_LOAD_DOWN:
		outDivMapCont->LocalFreeIndexTable[0] = TRUE;
		outDivMapCont->LocalFreeIndexTable[1] = TRUE;
		break;
	case MAP_LOAD_LEFT:
		outDivMapCont->LocalFreeIndexTable[1] = TRUE;
		outDivMapCont->LocalFreeIndexTable[3] = TRUE;
		break;
	}
}

//==============================================================================
/**
 * GAf[^̃[h
 *
 * @param	outDivMapCont	}bv\̃|C^
 * @param   inGridX		ObhWw
 * @param	inGridZ		ObhWy
 * @param	inMapGridW	}bvObh
 * 
 * @retval  none		
 */
//==============================================================================
static void LoadFirstBlock(	DMC_PTR outDivMapCont,
							const int inGridX, 
							const int inGridZ,
							const int inMapGridW)
{
	u8 i;
	int start_block[4];

	//4ubÑf[^Ǎm
	AllocBlockList(outDivMapCont);

	//ubNObh犄o
	MakeStartBlockTbl(	inGridX, inGridZ,
						outDivMapCont->MapW,
						outDivMapCont->MapH,
						inMapGridW, start_block	);

	for(i=0;i<4;i++){
		//f[^Ǘ\̃m
		outDivMapCont->BlockNodeList[i]->MapHeightInfo = AllocMapHeightInfo();
		InitHeightData(outDivMapCont->BlockNodeList[i]->MapHeightInfo);	//f[^Ǘ\̏
		LoadBlockQuick(	start_block[i],
						i,
						outDivMapCont->MapResource,
						outDivMapCont->World,
						outDivMapCont->MapW,
						outDivMapCont->MapH,
						MAPRES_IsValidLight(outDivMapCont->MapResource),
						outDivMapCont);//4ubÑf[^ǂݍ
		/**
		//R[obNĂяo
		if (outDivMapCont->CallBack!=NULL){
			outDivMapCont->CallBack(	outDivMapCont->CallBackWork,
										start_block[i],
										outDivMapCont->BlockNodeList[i]->ObjDataList);
		}*/
	}
}

//==============================================================================
/**
 * GAf[^̃[h
 *
 * @param	outDivMapCont	}bv\̃|C^
 * @param   inGridX		ObhWw
 * @param	inGridZ		ObhWy
 * @param	inMapGridW	}bvObh
 * 
 * @retval  none		
 */
//==============================================================================
static void LoadFirstBlockForUnder(	DMC_PTR outDivMapCont,
									const int inGridX, 
									const int inGridZ,
									const int inMapGridW)
{
	u8 i;
	int start_block[4];
	
	//4ubÑf[^Ǎm
	AllocBlockListForUnder(outDivMapCont);

	//ubNObh犄o
	MakeStartBlockTbl(	inGridX, inGridZ,
						outDivMapCont->MapW,
						outDivMapCont->MapH,
						inMapGridW, start_block);

	for(i=0;i<4;i++){
		//f[^Ǘ\NULLZbg
		outDivMapCont->BlockNodeList[i]->MapHeightInfo = NULL;
		LoadBlockQuickForUnder(	start_block[i],
								i,
								outDivMapCont->MapResource,
								outDivMapCont->World,
								outDivMapCont->MapW,
								outDivMapCont->MapH,
								MAPRES_IsValidLight(outDivMapCont->MapResource),
								outDivMapCont);//4ubÑf[^ǂݍ
	}
}


//==============================================================================
/**
 * 
 *
 * @param	outDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//==============================================================================
static void InitMapLoadCont(DMC_PTR outDivMapCont)
{
	int i;

	outDivMapCont->NowMovingNo = 0;
	outDivMapCont->BlankNo = 0;
	outDivMapCont->MovingNum = 0;
	for(i=0;i<2;i++){
		outDivMapCont->MLBC[i].Moving = FALSE;
		outDivMapCont->MLBC[i].MLBS.BlockLoadOK = TRUE;
	}
	ClearLocalFreeIndexTable(outDivMapCont);
}

//==============================================================================
/**
 * WŌݏXV
 *
 * @param   inGridX		ObhWw
 * @param	inGridZ		ObhWy
 * @param	ioDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//==============================================================================
static void UpdateNowData(const int inGridX, const int inGridZ, DMC_PTR outDivMapCont)
{
	outDivMapCont->NowGridNo = CalcGridNoFromGridXZ(inGridX,inGridZ,outDivMapCont->MapGridW);
	outDivMapCont->NowPosInBlock = CalcPositionInBlockFromGridNo(outDivMapCont->NowGridNo,
													outDivMapCont->MapGridW);
	outDivMapCont->NowLocalIndex = CalcLocalIdxFromPosInBlock(outDivMapCont->NowPosInBlock);
	outDivMapCont->NowBlockIndex = GetBlockIndexFromGridNo(outDivMapCont->NowGridNo,
															outDivMapCont->MapW,
															outDivMapCont->MapGridW);
#ifdef DIV_MAP_LOAD_DEBUG
	OS_Printf("Now=%d,%d,%d,%d\n",	outDivMapCont->NowGridNo,
									outDivMapCont->NowPosInBlock,
									outDivMapCont->NowLocalIndex,
									outDivMapCont->NowBlockIndex);
#endif
}

//==============================================================================
/**
 * ubNCfbNXn`ItZbgvZ(x[X߂)
 *
 * @param   inBlockIndex	ubNCfbNX
 * @param	inMapW			}bv
 * @param	inWorld			[h\̂ւ̃|C^
 * @param	outTrans		i[W
 * 
 * @return	none
 */
//==============================================================================
static void CalcMapOffset3D(	const int inBlockIndex,
								const int inMapW,
								const WORLD_MAP_PTR inWorld,
								VecFx32 *outTrans)
{
	u16 x_ofs;
	u16 z_ofs;
	outTrans->x = (BLOCK_GRID_SIZE_X/2)*ONE_GRID_SIZE*FX32_ONE;
	outTrans->z = (BLOCK_GRID_SIZE_Z/2)*ONE_GRID_SIZE*FX32_ONE;

	if (inBlockIndex == NON_BLOCK){
		return ;
	}
	
	x_ofs = inBlockIndex % inMapW;
	z_ofs = inBlockIndex / inMapW;
	{
		int height_base;
		int w;
		u16 matrix_id;
		w = GetWorldMapMatrixW(inWorld);
		matrix_id = GetWorldMatrixID(inWorld);
		height_base = GetHeightBaseFromMatrixID(inWorld, matrix_id, x_ofs, z_ofs, w);
		outTrans->y = height_base*HARF_GRID_SIZE*FX32_ONE;
	}
	outTrans->x += x_ofs*BLOCK_GRID_SIZE_X*ONE_GRID_SIZE*FX32_ONE;
	outTrans->z += z_ofs*BLOCK_GRID_SIZE_Z*ONE_GRID_SIZE*FX32_ONE;
}


//-----------------------------------------------------------------------------------------
//	ANZX֐
//-----------------------------------------------------------------------------------------
//==============================================================================
/**
 * 
 *
 * @param   world			[h\̃|C^
 * @param	mapresource		}bv\[X
 * @param	inFld3DAnmPtr	tB[h3cAj|C^
 * @param	inMode			ǂݍ݃[h
 * 
 * @retval  DMC_PTR			}bv\̃|C^		
 */
//==============================================================================
DMC_PTR InitDivMap(	WORLD_MAP_PTR world,
					MAP_RESOURCE_PTR mapresource,
					FLD_3D_ANM_MNG_PTR inFld3DAnmPtr,
					const DIV_MAP_MODE inMode )
{
	DMC_PTR map_cont_ptr;
	BOOL height_data_valid;

	//}bvRg[f[^m
	map_cont_ptr = sys_AllocMemory( HEAPID_FIELD, sizeof(DIV_MAP_LOAD_CONT) );
	//mۗ̈̃N[
	MI_CpuClear8( map_cont_ptr, sizeof(DIV_MAP_LOAD_CONT));

	//[h
	if (inMode == DIV_MAP_MODE_GROUND){				//n
		map_cont_ptr->FuncList = &DivGroundFunc;
		height_data_valid = TRUE;
	}else if(inMode == DIV_MAP_MODE_UNDER){			//n
		map_cont_ptr->FuncList = &DivUnderFunc;
		height_data_valid = FALSE;
	}else{
		GF_ASSERT(0&&"ERROR:}bvłȂ");
	}
	
	//}bvgp郁in`f[^jm
	map_cont_ptr->FldMapMem = AllocFldMapMem(height_data_valid);
	//tB[hʃ\[X̃|C^Zbg
	map_cont_ptr->MapResource = mapresource;
	map_cont_ptr->World = world;
	
	//}bvcZbg
	map_cont_ptr->MapW = GetWorldMapMatrixW(world);
	map_cont_ptr->MapH = GetWorldMapMatrixH(world);
	map_cont_ptr->MapGridW = map_cont_ptr->MapW*BLOCK_GRID_W;

	//tB[h3cAj}l[W|C^Zbg
	map_cont_ptr->Field3DAnmPtr = inFld3DAnmPtr;

	map_cont_ptr->MapCheck.Valid = TRUE;
		
	//}bvǗ^XN
	InitMapLoadCont(map_cont_ptr);
/**
	//}bvZbgAbvA[h炤
	map_cont_ptr->FuncList = ioFuncList;
*/	

	map_cont_ptr->FreeRequest = FALSE;

	map_cont_ptr->LoadSeq = DML_NONE;
	//A[JCunh̎擾
	map_cont_ptr->ArcHandle = ArchiveDataHandleOpen( ARC_FIELD_MAP_DATA, HEAPID_FIELD );

#ifdef DIV_CALL_BACK
	//R[obN
	map_cont_ptr->CallBack = NULL;
#endif
	
#ifdef PM_DEBUG
	DebugOutRangeFlg = TRUE;
#endif
	
	return map_cont_ptr; 
}

//==============================================================================
/**
 * }bvǂݍ
 *
 * @param	outDivMapCont	}bv\̃|C^
 * @param   x				W
 * @param	z				W
 * 
 * @retval  none		
 */
//==============================================================================
void LoadDivMap(DMC_PTR outDivMapCont, const int x, const int z)
{
	//4ubN[h
/*
	DivMapLoad_LoadErea(outDivMapCont,
						x,
						z,
						outDivMapCont->MapW,
						outDivMapCont->MapGridW,
						inLightValid);<<table_func	
*/
	outDivMapCont->FuncList->DivFirstFunc(	outDivMapCont,
											x,
											z,
											outDivMapCont->MapGridW);
	//@̏Obho^
	UpdateNowData(x,z,outDivMapCont);
}

//==============================================================================
/**
 * ubNf[^̍XVi@AoƂɌĂԁj
 *
 * @param	inDirection		
 * @param	ioDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//==============================================================================
void DivMapLoad_UpdateBlockData(const u8 inDirection, DMC_PTR ioDivMapCont)
{
	int next_block;
	u32 next_grid;
	u8 pos;
	
	next_grid = GetNextGridNo(	inDirection,
								ioDivMapCont->MapH,
								ioDivMapCont->MapGridW,
								ioDivMapCont->NowGridNo);

	next_block = GetBlockIdxFromGridNo(next_grid,ioDivMapCont->MapW, ioDivMapCont->MapGridW);
	pos = CalcPositionInBlockFromGridNo(next_grid,ioDivMapCont->MapGridW);
	//ubNԈړs邩`FbN
	if (ioDivMapCont->NowBlockIndex != next_block){
		return;	//ubNԈړ̏ꍇ̓[hȂ
	}else{	//ubNړ
		if (ioDivMapCont->NowPosInBlock != pos){	//ubNʒuقȂ
			//ubN[h
			UpdateBlockList(next_block, inDirection, ioDivMapCont);
			//ubNXVŝŁA[JCfbNXXV
			UpdateNowLocalIndexForAfterLoad(inDirection,
											ioDivMapCont->NowPosInBlock,
											&(ioDivMapCont->NowLocalIndex));
		}
	}
}

//==============================================================================
/**
 * ubN`֐
 *
 * @param	inDivMapCont	}bv\̃|C^
 * @param	glst_data		O[oXe[gf[^|C^
 *
 * @return	none
 */
//==============================================================================
void DrawAroundBlock(	DMC_CONST_PTR inDivMapCont,
						const GLST_DATA_PTR glst_data)
{
	static u8 debug_trg_alias = 0;
	
	u8 i;
	u8 draw = 0;	//`悷郍[JubNCfbNXzƂĎe[u̎QƃCfbNX

	//4ubN̕`
	for(i=0;i<4;i++){
		///debag_count_b[i] = 0;
		if (inDivMapCont->BlockNodeList[i]->BlockIndex != NON_BLOCK){
			DrawBlock(i,inDivMapCont,glst_data);
		}
	}
	
#ifdef DEBUG_ONLY_FOR_saitou	
	
	if (sys.trg & PAD_BUTTON_L){
/**		
		OS_Printf("ALL_MODEL:%d\n",debag_all_count);
		OS_Printf("DRAW_MODEL:%d\n",debag_draw_count);		
		OS_Printf("DRAW_MODEL_B:%d,%d,%d,%d\n",
				debag_count_b[0],debag_count_b[1],debag_count_b[2],debag_count_b[3]);
*/
//fobOpvg
		OS_Printf("0:WorldHeap = %ld\n",sys_GetHeapFreeSize(HEAPID_WORLD));
		OS_Printf("1:FieldHeap = %ld\n",sys_GetHeapFreeSize(HEAPID_FIELD));
	}

#endif
}

//==============================================================================
/**
 * iƂĂ1Obh̃ObhGA𔻒肷
 *
 * @param	inDirction	
 * @param	inDivMapCont	}bv\̃|C^
 * @param	*outGrid	iƂĂ1Obh̃Obh
 * @return	BOOL	TRUE:GA	FALSE:GAO
 */
//==============================================================================
BOOL CheckNextGridIO(const u8 inDirection, DMC_CONST_PTR inDivMapCont, int *outGrid)
{
	int next_grid;
	
	//݃Obhɂ킹āAObhvZ
	switch(inDirection){
	case  MAP_LOAD_RIGHT:		//E
		next_grid = (inDivMapCont->NowGridNo%inDivMapCont->MapGridW)+1;
		if ( next_grid >= inDivMapCont->MapGridW ){
			return FALSE;
		}
		*outGrid = inDivMapCont->NowGridNo+1;
		break;
	case MAP_LOAD_DOWN:			//
		*outGrid = inDivMapCont->NowGridNo+inDivMapCont->MapGridW;
		if (*outGrid >= inDivMapCont->MapH*BLOCK_GRID_SIZE_Z*inDivMapCont->MapGridW){
			return FALSE;
		}
		break;
	case MAP_LOAD_LEFT:			//
		next_grid = (inDivMapCont->NowGridNo%inDivMapCont->MapGridW)-1;
		if ( next_grid < 0 ){
			return FALSE;
		}
		*outGrid = inDivMapCont->NowGridNo-1;
		break;
	case MAP_LOAD_UP:			//
		*outGrid = inDivMapCont->NowGridNo-inDivMapCont->MapGridW;
		if (*outGrid < 0 ){
			return FALSE;
		}
		break;
	default:
		GF_ASSERT(0&&"ERROR:NO_DIRECTION!!");
	}
	return  TRUE;
}

//==============================================================================
/**
 * WɁAݗĂObhXZԂ
 *
 * @param   inX				Ww
 * @param	inZ				Wy
 * @param   outGridX		ObhWw
 * @param	outGridZ		ObhWy
 *
 * @return	none
 */
//==============================================================================
void GetGridXZ(fx32 inX, fx32 inZ, int *outGridX, int *outGridZ)
{
	*outGridX = inX/(ONE_GRID_SIZE*FX32_ONE);
	*outGridZ = inZ/(ONE_GRID_SIZE*FX32_ONE);
}

//==============================================================================
/**
 * mۃ̉
 *
 * @param	ioDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//==============================================================================
void DivMapLoad_FreeMap(DMC_PTR ioDivMapCont)
{
	u8 i;

	//LbVNA
	ClearFileCache();
	
#ifdef LINK_VRAM_MANAGER
	NNS_GfdResetLnkTexVramState();
	NNS_GfdResetLnkPlttVramState();
#else
	//eNX`ApbgJ
	NNS_GfdResetFrmTexVramState();
	NNS_GfdResetFrmPlttVramState();
#endif

	//[h^XN~NGXg
	for(i=0;i<2;i++){
		LoadTaskStopReqestByMLBS(&ioDivMapCont->MLBC[i].MLBS);
	}
#if 0
	//A[JCunh
	if (ioDivMapCont->ArcHandle != NULL){
		ArchiveDataHandleClose( ioDivMapCont->ArcHandle );
		ioDivMapCont->ArcHandle = NULL;
	}
#endif
	//ubNf[^(n`f[^̉A}bvf[^J܂)
	for (i=0;i<4;i++){
		ioDivMapCont->BlockNodeList[i]->DrawOKFlg = FALSE;

		FreeMapHeightInfo(ioDivMapCont->BlockNodeList[i]->MapHeightInfo);
		//3DOBJ
		M3DO_FreeMap3DObjList(ioDivMapCont->BlockNodeList[i]->ObjDataList );
		sys_FreeMemoryEz( ioDivMapCont->BlockNodeList[i] );
		ioDivMapCont->BlockNodeList[i] = NULL;
	}

	ioDivMapCont->LoadSeq = DML_FREE_WAIT;
	ioDivMapCont->FreeRequest = TRUE;

	ioDivMapCont->MapCheck.Valid = FALSE;
}

//==============================================================================
/**
 * mۃ̉
 *
 * @param	outDivMapCont	}bv\̃|C^
 *
 * @return	none
 */
//==============================================================================
void FreeDivMapCont(DMC_PTR outDivMapCont)
{
	//A[JCunhN[Y
	ArchiveDataHandleClose( outDivMapCont->ArcHandle );	
	//}bv
	FreeFldMapMem(outDivMapCont->FldMapMem);
	//}bvǗf[^
	sys_FreeMemoryEz( (void *)outDivMapCont );
	///outDivMapCont = NULL;
}

//==============================================================================
/**
 * mۃ̉҂
 *
 * @param	inDivMapCont	}bv\̃|C^
 *
 * @return	BOOL		TRUE:I		FALSE:҂
 */
//==============================================================================
BOOL WaitMapFree(DMC_CONST_PTR inDivMapCont)
{
	if ( (inDivMapCont->FreeRequest == TRUE) && (inDivMapCont->MovingNum == 0) ){
		return TRUE;
	}else{
		return FALSE;
	}
}

//==============================================================================
/**
 * W̃oCh
 *
 * @param	*inTarget	W
 * @param   outDivMapCont@}bv\
 *
 * @return	none
 */
//==============================================================================
void DivMapBindTarget(VecFx32 const *inTarget, DMC_PTR outDivMapCont)
{
	outDivMapCont->MapCheck.OldPoint = *inTarget;
	outDivMapCont->MapCheck.TargetPoint = inTarget;
}

//==============================================================================
/**
 * W̐؂藣
 *
 * @param   outDivMapCont@}bv\
 *
 * @return	none
 */
//==============================================================================
void DivMapPurgeTarget(DMC_PTR outDivMapCont)
{
	outDivMapCont->MapCheck.TargetPoint = NULL;
}

//==============================================================================
/**
 * w胍[JubNCfbNXIuWFNg\̃XgԂ
 *
 * @param	inIdx			[JCfbNX
 * @param   inDivMapCont	}bv\
 * @param	outObjList		OBJXg|C^
 *
 * @return	none
 */
//==============================================================================
void Get3DObjListFromLocalIdx(const u8 inIdx, DMC_CONST_PTR inDivMapCont, M3DOL_PTR *outObjList)
{
	*outObjList = inDivMapCont->BlockNodeList[inIdx]->ObjDataList;
}

//==============================================================================
/**
 * ݂̃[JubNCfbNX擾
 *
 * @param   inDivMapCont@}bv\
 *
 * @return	u8		݂̃[JubNCfbNX
 */
//==============================================================================
u8 GetNowLocalIndex(DMC_CONST_PTR inDivMapCont)
{
	return inDivMapCont->NowLocalIndex;
}

//==============================================================================
/**
 * ݂̃ubNCfbNX擾
 *
 * @param   inDivMapCont@}bv\
 *
 * @return	int		݂̃ubNCfbNX
 */
//==============================================================================
int GetNowBlockIndex(DMC_CONST_PTR inDivMapCont)
{
	return inDivMapCont->NowBlockIndex;
}

//--------------------------------------------------------------------------------------------
/**
 * ݃ObhCfbNXAubN̂ǂ̈ʒui4Ƃjɂ邩vZ
 *
 * @param	inGridNo	Obhio[
 * @param	inMapGridW	}bvObh
 *
 * @return	u8			ubNʒu(0`3)
 */
//--------------------------------------------------------------------------------------------
u8 CalcPositionInBlockFromGridNo(const u32 inGridNo, const int inMapGridW)
{
	u8 pos;
	int pos_x,pos_z;
	int line_z;
	pos_x = inGridNo%BLOCK_GRID_SIZE_X;
	line_z = inGridNo/inMapGridW;
	pos_z = line_z%BLOCK_GRID_SIZE_Z;
	if (pos_x < BLOCK_GRID_SIZE_X/2){
		if (pos_z < BLOCK_GRID_SIZE_Z/2){
			pos = 0;	//ubN
		}else{
			pos = 2;	//ubN
		}
	}else{
		if (pos_z < BLOCK_GRID_SIZE_Z/2){
			pos = 1;	//ubNE
		}else{
			pos = 3;	//ubNE
		}
	}
	return pos;
}

//--------------------------------------------------------------------------------------------
/**
 * ubNCfbNX烍[JCfbNXvZi㉺Ê݁j
 *
 * @param	inBlockIndex	ubNCfbNX
 * @param	inPosInBlock	ubNʒu(0`3)
 * @param	inDivMapCont	}bv\̃|C^
 *
 * @return	u8				[JCfbNX
 */
//--------------------------------------------------------------------------------------------
u8 CalcLocalIdxFromBlockIdx(const int inBlockIndex, const u8 inPosInBlock, DMC_CONST_PTR inDivMapCont)
{
	u8 local_index;
#ifdef DIV_MAP_LOAD_DEBUG	
	OS_Printf("inPosInBlock=%d\n",inPosInBlock);
#endif
	if (inDivMapCont->NowBlockIndex == inBlockIndex){
		return inDivMapCont->NowLocalIndex;
	}

	GF_ASSERT(inBlockIndex!=NON_BLOCK);
	
	switch (inDivMapCont->NowLocalIndex){
	case 0:															//@ɂƂ
		//MapWP̂ƂlD悵Ĕ肷
		if(inBlockIndex - inDivMapCont->NowBlockIndex == inDivMapCont->MapW){
			local_index = inDivMapCont->NowLocalIndex+2;			//
		}else if ( (inBlockIndex - inDivMapCont->NowBlockIndex == 1) &&
				(CheckRowBlockIndex( inDivMapCont->NowBlockIndex, inBlockIndex, inDivMapCont->MapW)) ){
			//тł΁Anj
			local_index = inDivMapCont->NowLocalIndex+1;			//E
		}else if ( (inBlockIndex - inDivMapCont->NowBlockIndex == inDivMapCont->MapW+1) &&
				(!CheckRowBlockIndex( inDivMapCont->NowBlockIndex, inBlockIndex, inDivMapCont->MapW)) ){
			//тłȂ΁@nj
			local_index = inDivMapCont->NowLocalIndex+3;			//E
		}else{
			local_index = 4;		//ʕs
		}
		break;
	case 1:															//@EɂƂ
		//MapWP̂ƂlD悵Ĕ肷
		if(inBlockIndex - inDivMapCont->NowBlockIndex == inDivMapCont->MapW){
			local_index = inDivMapCont->NowLocalIndex+2;			//
		}else if ( (inDivMapCont->NowBlockIndex - inBlockIndex == 1) &&
				(CheckRowBlockIndex( inDivMapCont->NowBlockIndex, inBlockIndex, inDivMapCont->MapW)) ){
			//тł΁Anj
			local_index = inDivMapCont->NowLocalIndex-1;			//
		}else if ( (inBlockIndex - inDivMapCont->NowBlockIndex == inDivMapCont->MapW-1) &&
				(!CheckRowBlockIndex( inDivMapCont->NowBlockIndex, inBlockIndex, inDivMapCont->MapW)) ){
			//тłȂ΁@nj
			local_index = inDivMapCont->NowLocalIndex+1;			//
		}else{
			local_index = 4;		//ʕs

		}
		break;
	case 2:															//@ɂƂ
		//MapWP̂ƂlD悵Ĕ肷
		if (inDivMapCont->NowBlockIndex - inBlockIndex == inDivMapCont->MapW){
			local_index = inDivMapCont->NowLocalIndex-2;			//
		}else if( (inDivMapCont->NowBlockIndex - inBlockIndex == inDivMapCont->MapW-1) &&
				(!CheckRowBlockIndex( inDivMapCont->NowBlockIndex, inBlockIndex, inDivMapCont->MapW)) ){
			//тłȂ΁Anj
			local_index = inDivMapCont->NowLocalIndex-1;			//E
		}else if ( (inBlockIndex - inDivMapCont->NowBlockIndex == 1) &&
				(CheckRowBlockIndex( inDivMapCont->NowBlockIndex, inBlockIndex, inDivMapCont->MapW)) ){
			//тł΂nj
			local_index = inDivMapCont->NowLocalIndex+1;			//E
		}else{
			local_index = 4;		//ʕs

		}
		break;
	case 3:															//@EɂƂ
		//MapWP̂ƂlD悵Ĕ肷
		if(inDivMapCont->NowBlockIndex - inBlockIndex == inDivMapCont->MapW){
			local_index = inDivMapCont->NowLocalIndex-2;			//
		}else if ( (inDivMapCont->NowBlockIndex - inBlockIndex == inDivMapCont->MapW+1) &&
				(!CheckRowBlockIndex( inDivMapCont->NowBlockIndex, inBlockIndex, inDivMapCont->MapW)) ){
			//тłȂ΁Anj
			local_index = inDivMapCont->NowLocalIndex-3;			//
		}else if ( (inDivMapCont->NowBlockIndex- inBlockIndex == 1) &&
				(CheckRowBlockIndex( inDivMapCont->NowBlockIndex, inBlockIndex, inDivMapCont->MapW)) ){
			//тł΂nj
			local_index = inDivMapCont->NowLocalIndex-1;			//
		}else{
			local_index = 4;		//ʕs

		}
		break;
	default:
		local_index = 4;		//ʕs

	}
	
	return local_index;
}

//==============================================================================
/**
 * [JCfbNXubNCfbNX擾
 *
 * @param   inDivMapCont@}bv\
 * @param	inLocalIndex@[JCfbNX
 *
 * @return	int		ubNCfbNX
 */
//==============================================================================
int GetBlockIndexFromLocalIndex(DMC_CONST_PTR inDivMapCont, const u8 inLocalIndex)
{
	GF_ASSERT(inLocalIndex<4);
	return inDivMapCont->BlockNodeList[inLocalIndex]->BlockIndex;
}

//==============================================================================
/**
 * ubNO
 *
 * @param   inDivMapCont	}bv\
 * @param	inGridX			ObhwW
 * @param	inGridZ			ObhyW
 * @param	outLocalIndex	[JCfbNXi[obt@
 *
 * @return	BOOL			TRUE:@ FALSE:O
 */
//==============================================================================
BOOL CheckFourBlockIO(DMC_CONST_PTR inDivMapCont, const int inGridX, const int inGridZ, u8 *outLocalIndex)
{
	u32 block_x,block_z;
	u32 block_index;
	u32 local_index;

	u32 grid_no;
	u8 pos_in_block;
	
	block_x = inGridX / BLOCK_GRID_W;
	block_z = inGridZ / BLOCK_GRID_H;
	block_index = block_x+(block_z*inDivMapCont->MapW);

    if(!(block_index < inDivMapCont->MapW*inDivMapCont->MapH)){
        if(CommStateSetError(COMM_ERROR_RESET_SAVEPOINT)){
            return FALSE;
        }
    }
	GF_ASSERT(block_index < inDivMapCont->MapW*inDivMapCont->MapH);
	
	grid_no = inGridX+(inGridZ*inDivMapCont->MapGridW);
	pos_in_block = CalcPositionInBlockFromGridNo(grid_no,inDivMapCont->MapGridW);
	local_index = CalcLocalIdxFromBlockIdx(block_index,pos_in_block,inDivMapCont);

	if (outLocalIndex != NULL){
		*outLocalIndex = local_index;
	}
	
	if (local_index>3){
		return FALSE;
	}else{
		return TRUE;
	}
}

//==============================================================================
/**
 * }bv\̂āA擾
 *
 * @param   inDivMapCont	}bv\
 * @param	inLocalIndex	[JCfbNX
 *
 * @return	MHI_CONST_PTR	
 */
//==============================================================================
MHI_CONST_PTR GetDivMapHeightInfo(DMC_CONST_PTR inDivMapCont, const u8 inLocalIndex)
{
	return inDivMapCont->BlockNodeList[inLocalIndex]->MapHeightInfo;
}

//==============================================================================
/**
 * }bv\̂āAAgr[g擾
 *
 * @param   inDivMapCont	}bv\
 * @param	inLocalIndex	[JCfbNX
 *
 * @return	u16				Agr[g
 */
//==============================================================================
u16 const *GetDivMapAttribute(DMC_CONST_PTR inDivMapCont, const u8 inLocalIndex)
{
	return inDivMapCont->BlockNodeList[inLocalIndex]->Attribute;
}

#ifdef DIV_CALL_BACK
//==============================================================================
/**
 * ubN[h̃R[obN֐̃Zbg
 *
 * @param   outDivMapCont	}bv\
 * @param	call_back		R[obN
 * @param	waork			R[obNp[N
 *
 * @return	none
 */
//==============================================================================
void DIVM_SetLoadCallBack( DMC_PTR outDivMapCont, DIV_LOAD_CALL_BACK call_back, void *work )
{
	outDivMapCont->CallBack = call_back;
	outDivMapCont->CallBackWork = work;
}
#endif

typedef struct MODEL_SET_DAT_tsg
{
	ARCHANDLE *ArcHandle;
	int DataSize;
	NNSG3dRenderObj* Object_p;
	NNSG3dResFileHeader** ResFile;
	NNSG3dResTex*        Texture;
	u8 SetSeq;
	BOOL	*DrawOK;
	BOOL	StopFlg;
	int * EndFlg;

	u32 data_trans_offset;
}MODEL_SET_DAT;

//==============================================================================
/**
 * [h^XN~NGXg
 *
 * @param   tcb				^XN|C^
 *
 * @return	none
 */
//==============================================================================
static void StopMapLoadTaskRequest(TCB_PTR tcb)
{
	MODEL_SET_DAT *model_set_dat;
	model_set_dat = (MODEL_SET_DAT*)TCB_GetWork(tcb);
	model_set_dat->StopFlg = TRUE;
}

//==============================================================================
/**
 * n`f̃Zbg^XN
 * 
 * @param   tcb
 * @param	work
 *
 * @return	none
 */
//==============================================================================
static void SetModel(TCB_PTR tcb,void* work)
{
	int i;
	MODEL_SET_DAT *model_set_dat;
	BOOL status;
	int read_size;
	void *mem;
	
	model_set_dat = (MODEL_SET_DAT*)work;
	

	if (model_set_dat->StopFlg == TRUE){
		//f
		model_set_dat->SetSeq = MODELSET_TASK_SEQ_EXIT;
	}
	switch(model_set_dat->SetSeq){

	case MODELSET_TASK_SEQ_INIT:

		model_set_dat->data_trans_offset = 0;
		if (model_set_dat->DataSize<=MODEL_SET_DIV_SIZE){
			//ʈȉ̏ꍇ
			read_size = model_set_dat->DataSize;
			model_set_dat->SetSeq = MODELSET_TASK_SEQ_TEXTURE_BIND;
		}else{
			//ʂ傫ꍇ
			read_size = MODEL_SET_DIV_SIZE;
			model_set_dat->SetSeq = MODELSET_TASK_SEQ_MODEL_LOAD;
		}

		mem = &((u8*)(*model_set_dat->ResFile))[model_set_dat->data_trans_offset];
		ArchiveDataLoadByHandleContinue( model_set_dat->ArcHandle, read_size, mem );
		model_set_dat->data_trans_offset+=read_size;
		
		break;

	case MODELSET_TASK_SEQ_MODEL_LOAD:
		{
			int end;
			read_size = model_set_dat->DataSize-model_set_dat->data_trans_offset;
			if (read_size>MODEL_SET_DIV_SIZE){
				//ʂ傫ꍇ
				read_size = MODEL_SET_DIV_SIZE;
				//p
				end = 0;
			}else{
				//ǂݍŏI
				end = 1;
			}
			mem = &((u8*)(*model_set_dat->ResFile))[model_set_dat->data_trans_offset];
			ArchiveDataLoadByHandleContinue( model_set_dat->ArcHandle, read_size, mem );

			if (end){
				model_set_dat->SetSeq = MODELSET_TASK_SEQ_TEXTURE_BIND;
			}else{
				model_set_dat->data_trans_offset+=read_size;
			}
		}
		
		break;

	case MODELSET_TASK_SEQ_TEXTURE_BIND:
		if(model_set_dat->Texture != NULL){
			// eNX`VramɓWJĂ邩`FbN
			if(TexKeyLive(model_set_dat->Texture) == TRUE){	
				//eNX`oCh
				status = BindTexture(*model_set_dat->ResFile, model_set_dat->Texture);
				NNS_G3D_ASSERTMSG(status, "BindTexture failed");
			}else{
				OS_Printf("eNX`WJĂȂ");
			}
		}
		model_set_dat->SetSeq = MODELSET_TASK_SEQ_RESOUCE_SET;
		break;

	case MODELSET_TASK_SEQ_RESOUCE_SET:
		{
#if 0			
			NNSG3dResMdlSet* pMdlSet = NNS_G3dGetMdlSet(*model_set_dat->ResFile);
			model_set_dat->EntryModelNum = pMdlSet->dict.numEntry; 
			for(i=0;i<model_set_dat->EntryModelNum;i++){
				model_set_dat->Model = NNS_G3dGetMdlByIdx(pMdlSet, i);
				SDK_ASSERTMSG(model_set_dat->Model, "load failed");
				NNS_G3dRenderObjInit(&model_set_dat->Object_p[i], model_set_dat->Model);
			}
#else
			NNSG3dResMdlSet* pMdlSet = NNS_G3dGetMdlSet(*model_set_dat->ResFile);
			NNSG3dResMdl *model;
			
			GF_ASSERT(pMdlSet->dict.numEntry==1&&"fZbg̒ɕf");
			
			model = NNS_G3dGetMdlByIdx(pMdlSet, 0);
			GF_ASSERT(model&&"load failed");
			NNS_G3dRenderObjInit(model_set_dat->Object_p, model);
#endif			
		}
		*model_set_dat->DrawOK = TRUE;

		model_set_dat->SetSeq = MODELSET_TASK_SEQ_EXIT;
		break;
	case MODELSET_TASK_SEQ_EXIT:
		*model_set_dat->EndFlg = 0;
		sys_FreeMemoryEz( (void*)(work) );
		TCB_Delete(tcb);
		return;
	}
}

//==============================================================================
/**
 * }bv[h^XN
 *
 * @param   inHandle		A[JCunh
 * @param	inSize			f[^TCY
 * @param	object_p		_[nai|C^
 * @param	resFile			\[Xt@C
 * @param	pTexture		eNX`
 * @param	ioDrawOKFlg		`拖tO
 * @param	inEndFlg		^XNItO
 *
 * @return	TCB_PTR			^XN|C^
 */
//==============================================================================
TCB_PTR Set3DModelTask(	ARCHANDLE *inHandle,
						const int inSize,
						NNSG3dRenderObj* object_p,
						NNSG3dResFileHeader** resFile,
						NNSG3dResTex* pTexture,
						BOOL *ioDrawOKFlg,
						int *inEndFlg) 
{
	TCB_PTR	_tcb;
	MODEL_SET_DAT *work;
	work = (MODEL_SET_DAT *)sys_AllocMemoryLo( HEAPID_FIELD, sizeof(MODEL_SET_DAT) );
	
	work->ArcHandle = inHandle;
	work->DataSize = inSize;
	
	work->Object_p = &object_p[0];
	work->ResFile = resFile;
	work->Texture = pTexture;
	work->SetSeq = 0;
	work->DrawOK = ioDrawOKFlg;
	*work->DrawOK = FALSE;
	work->EndFlg = inEndFlg;
	work->StopFlg = FALSE;
	
	_tcb = TCB_Add(SetModel, work, 1);
	return _tcb;
}

//==============================================================================
/**
 * ftHgZbgAbvsȂfǂݍ݊֐
 *
 * @param   ioHandle		A[JCunh
 * @param	inSize			f[^TCY
 * @param	object_p		_[nai|C^
 * @param	resFile			\[Xt@C
 * @param	pTexture		eNX`
 *
 * @return	NNSG3dResMdl	f|C^
 */
//==============================================================================
NNSG3dResMdl* Set3DModel(	ARCHANDLE *ioHandle,
							const int inSize,
							NNSG3dRenderObj* object_p,
							NNSG3dResFileHeader** resFile,
							NNSG3dResTex* pTexture)
{
	BOOL status;
	NNSG3dResMdl* model;

	ArchiveDataLoadByHandleContinue( ioHandle, inSize, *(resFile) );
	
	if(pTexture != NULL){
		if(TexKeyLive(pTexture) == TRUE){	// eNX`VramɓWJĂ邩`FbN
			//eNX`oCh
			status = BindTexture(*resFile, pTexture);
			NNS_G3D_ASSERTMSG(status, "BindTexture failed");
			GF_ASSERT(status&&"BindTexture failed");
		}else{
			OS_Printf("eNX`WJĂȂ");
		}
	}

	{
		u8 i;
		u16 entry_model_num;
		NNSG3dResMdlSet* pMdlSet = NNS_G3dGetMdlSet(*resFile);

		GF_ASSERT(pMdlSet->dict.numEntry==1&&"fZbg̒ɕf");

		model = NNS_G3dGetMdlByIdx(NNS_G3dGetMdlSet(*resFile), 0);
		GF_ASSERT(model&&"load failed");
		NNS_G3dRenderObjInit(object_p, model);
/**		
		entry_model_num = pMdlSet->dict.numEntry;
		for(i=0;i<entry_model_num;i++){
			model = NNS_G3dGetMdlByIdx(NNS_G3dGetMdlSet(*resFile), i);
			SDK_ASSERTMSG(model, "load failed");
			GF_ASSERT(model&&"load failed");
			NNS_G3dRenderObjInit(&object_p[i], model);
		}
*/		
	}

	return model;
}

#ifdef PM_DEBUG
void SetDebugOutRangeFlg(void)
{
	DebugOutRangeFlg = (DebugOutRangeFlg+1)%2;
}
#endif
