//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		ecnt_tomo.c
 *@brief	GJEg
 *@author	tomoya takahashi
 *@data		2005.07.28
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include "common.h"
#include "system/lib_pack.h"
#include "system/brightness.h"
#include "fieldsys.h"
#include "fieldmap_work.h"
#include "field_event.h"
#include "fld_motion_bl.h"
#include "encount_effect_def.h"
#include "system/wipe.h"

#define	__ECNT_TOMO_H_GLOBAL
#include "ecnt_tomo.h"
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-------------------------------------
//	[Vu[p
//=====================================
#define MSBL00_ROTA_START	(64)		// ]x
#define	MSBL00_ROTA_ADD		(48)		// ]x
#define MSBL00_ROTA_COUNT	(40)		// ]Ă鎞
#define MSBL00_MSBLFADE_COUNT	(16)	// [Vu[Wɂ蔒Ă
#define MSBL00_DIST_START	(FX32_ONE)				// ߂Âx
#define MSBL00_DIST_ADD		(FX32_CONST(0.90f))		// l
#define	MSBL00_CAMERA_IN_TIMING		(20)			// J߂Â͂߂^C~O
#define MSBL00_FADEOUT_DIV			( 8 )
#define MSBL00_FADEOUT_SYNC			( 1 )
enum{
	MSBL00_START_EFFECT,	// GtFNgX^[g
	MSBL00_FLASH_INIT,		// ŏ̃sJsJJn
	MSBL00_FLASH_WAIT,		// ŏ̃sJsJI҂
	MSBL00_MOTION_INIT,		// [Vu[
	MSBL00_CAMERA_ROTA,		// J]
	MSBL00_FADE_OUT,		// tF[hAEg
	MSBL00_END_WAIT,		// I܂ő҂
	MSBL00_END_EFFECT		// I
};

//-------------------------------------
//	[Vu[01p
//=====================================
enum{
	MSBL01_START_EFFECT,	// GtFNgX^[g
	MSBL01_FLASH_INIT,		// ŏ̃sJsJJn
	MSBL01_FLASH_WAIT,		// ŏ̃sJsJI҂
	MSBL01_MOTION_INIT,		// [Vu[
	MSBL01_MOTION,			// J𓮂
	MSBL01_FADE_OUT,		// ubNtF[hAEg
	MSBL01_END_WAIT,		// I܂ő҂
	MSBL01_END_EFFECT		// I
};

#define MSBL01_CAMERA_SHIFT_INIT	(FX32_CONST(1.0f))	// JVtg̍ŏ̋
#define MSBL01_CAMERA_SHIFT_ADD		(FX32_CONST(24.0f))	//JVtg̉l
#define MSBL01_CAMERA_COUNT_ADD		(8192)
#define MSBL01_END_COUNT			(40)
#define MSBL01_FADEOUT_DIV			( 8 )
#define MSBL01_FADEOUT_SYNC			( 1 )

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------


//-------------------------------------
//	[Vu[\
//=====================================
typedef struct{
	FLD_MOTION_BL_DATA_PTR	motion;
	GF_CAMERA_PTR	camera;				// Jf[^
	u16				camera_rota;		// J]p
	u16				camera_rota_add;	// ̉]x
	fx32			camera_dist;		// J
	fx32			camera_dist_add;	// ĴÂx
	int				count;				// ł̃JE^

	/* OBJ */
} MSBL00_WORK;

//-------------------------------------
//
//	[Vu[01\
//
//=====================================
typedef struct{
	FLD_MOTION_BL_DATA_PTR	motion;

	GF_CAMERA_PTR	camera;				// Jf[^
	VecFx32			camera_shift;		// JVtg
	fx32			camera_mv;			// Jړx
	int				camera_count;		// JGtFNgpJE^
	int				count;				// eł̃JE^
	
	/* OBJ */
} MSBL01_WORK;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------



//----------------------------------------------------------------------------
/**
 *
 *@brief	[Vu[]GJEg
 *
 *@param	tcb		^XN|C^
 *@param	*work	[N|C^
 *
 *@return	none
 *
 * GtFNg̗
 *
 * 1:TuʃubNAEg
 * 2:CʂɃ[Vu[
 * 3:J̏]
 * 4:ǂǂ񑁂Ȃ
 * 5:傫ȃX^[{[BGoBiPTt[j
 * 
 *
 */
//-----------------------------------------------------------------------------
void EncountEffectMotionBl00(TCB_PTR tcb, void *work)
{
	ENCOUNT_EFFECT_WORK *eew = work;
	MSBL00_WORK* task_w = eew->work;
	int add_num;

	switch(eew->seq){
	case MSBL00_START_EFFECT:	// 
		eew->work = sys_AllocMemory(HEAPID_FIELD, sizeof(MSBL00_WORK));
		memset( eew->work, 0, sizeof(MSBL00_WORK) );
		
		GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG1, VISIBLE_OFF);
		GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG2, VISIBLE_OFF);
		GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG3, VISIBLE_OFF);
		
		eew->seq++;
		break;
		
	case MSBL00_FLASH_INIT:		// ŏ̃sJsJ\
		EncountFlashTask(MASK_MAIN_DISPLAY, 16, -16,  &eew->wait, 2);

		eew->seq++;
		break;

	case MSBL00_FLASH_WAIT:
		if(eew->wait){
			eew->wait = 0;

			eew->seq++;
		}
		break;

	case MSBL00_MOTION_INIT:	// [Vu[gp鏀
		task_w->motion = FLDMotionBl_Init(4, 15);
		

		// J]̏
		task_w->camera				= GFC_AllocCamera(HEAPID_FIELD);		// J쐬
		GFC_CopyCamera(eew->fsw->camera_ptr, task_w->camera);	// JRs[
		GFC_AttachCamera(task_w->camera);
		task_w->camera_rota_add		= MSBL00_ROTA_START;
		task_w->count				= MSBL00_ROTA_COUNT;
		task_w->camera_dist			= GFC_GetCameraDistance(task_w->camera);
		task_w->camera_dist_add		= MSBL00_DIST_START;
		eew->seq++;
		break;
		
	case MSBL00_CAMERA_ROTA:	// J]

		// ]pɑl␳ĩJ̊pxł܂Ȃ̂ŒӁIIj
		// ȕ␳Ȃ̂ŁAJ̊pxŁA蒼KvII
		add_num = FX_Mul(FX_SinIdx(task_w->camera_rota), (task_w->camera_rota_add*4)<<FX32_SHIFT) >> FX32_SHIFT;
		if(add_num < 0){		// }CiXvXɂ
			add_num *= -1;
		}

		// ␳l{ޒl𑫂
		task_w->camera_rota += add_num + task_w->camera_rota_add;

		// 
		task_w->camera_rota_add += MSBL00_ROTA_ADD;
		
		{
			VecFx32	vect;
			vect.x = FX_SinIdx(task_w->camera_rota);
			vect.y = FX_CosIdx(task_w->camera_rota);
			vect.z = 0;
			GFC_SetCamUp(&vect, task_w->camera);
		}

		// JXɂ
		if(task_w->count <= MSBL00_CAMERA_IN_TIMING){
			task_w->camera_dist -= task_w->camera_dist_add;
			task_w->camera_dist_add += MSBL00_DIST_ADD;
			GFC_SetCameraDistance(task_w->camera_dist, task_w->camera);
		}

		if(task_w->count < MSBL00_MSBLFADE_COUNT){
			FLDMotionBl_ParamChg(task_w->motion, 2, 16);
		}
		
		task_w->count--;
		if(task_w->count < 0){
			FLDMotionBl_ParamChg(task_w->motion, 0, 16);
			eew->seq++;
		}
		break;

	
	
	case MSBL00_FADE_OUT:		// BG`
		WIPE_SYS_Start( WIPE_PATTERN_M, WIPE_TYPE_FADEOUT, WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK, MSBL00_FADEOUT_DIV, MSBL00_FADEOUT_SYNC, HEAPID_FIELD );

		eew->seq++;
		break;
		
	
	
	case MSBL00_END_WAIT:
		if( WIPE_SYS_EndCheck() ){
			eew->wait = 0;

			// ɖ߂
			FLDMotionBl_Delete(&task_w->motion);
			GFC_PurgeCamera();				// J蓖ăt[
			GFC_AttachCamera(eew->fsw->camera_ptr);
			GFC_FreeCamera(task_w->camera);	// Jj

			// uCglX
			G2_BlendNone();
			
			eew->seq++;
		}
		break;

	
	case MSBL00_END_EFFECT:		// n
		
		if(eew->end != NULL){
			*(eew->end) = TRUE;		// ^XNI
		}
		sys_FreeMemory(HEAPID_FIELD, eew->work);
		PMDS_taskDel(tcb);	//^XNI
		WIPE_SetBrightness( WIPE_DISP_SUB, WIPE_FADE_BLACK );
		break;
	}	
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	[Vu[uGJEg
 *
 *@param	tcb		^XN|C^
 *@param	*work	[N|C^
 *
 *@return	none
 *
 * GtFNg̗
 *
 * 1:[Vu[
 * 2:JԂꂳ
 * 3:ubNAEg
 *
 */
//-----------------------------------------------------------------------------
void EncountEffectMotionBl01(TCB_PTR tcb, void *work)
{
	ENCOUNT_EFFECT_WORK *eew = work;
	MSBL01_WORK* task_w = eew->work;
	VecFx32 shift_num;
	VecFx32 set_num;

	switch(eew->seq){
	case MSBL01_START_EFFECT:	// 
		eew->work = sys_AllocMemory(HEAPID_FIELD, sizeof(MSBL01_WORK));
		memset( eew->work, 0, sizeof(MSBL01_WORK) );
		
		GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG1, VISIBLE_OFF);
		GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG2, VISIBLE_OFF);
		GF_Disp_GX_VisibleControl(GX_PLANEMASK_BG3, VISIBLE_OFF);
		
		eew->seq++;
		break;

	case MSBL01_FLASH_INIT:		// ŏ̃sJsJ\
		EncountFlashTask(MASK_MAIN_DISPLAY, 16, -16,  &eew->wait, 2);

		eew->seq++;
		break;

	case MSBL01_FLASH_WAIT:
		if(eew->wait){
			eew->wait = 0;

			eew->seq++;
		}
		break;


	case MSBL01_MOTION_INIT:	// [Vu[gp鏀
	
		task_w->motion = FLDMotionBl_Init(2, 14);
		
		// Jړ̏
		task_w->camera				= GFC_AllocCamera(HEAPID_FIELD);		// J쐬
		GFC_CopyCamera(eew->fsw->camera_ptr, task_w->camera);	// JRs[
		GFC_AttachCamera(task_w->camera);
		task_w->camera_mv	= MSBL01_CAMERA_SHIFT_INIT;
		task_w->camera_count= 0;
		task_w->count		= MSBL01_END_COUNT;
		eew->seq++;
		break;
		
		
	case MSBL01_MOTION:	// Jړ
		
		// ړ
		shift_num.x = FX_SinIdx(task_w->camera_count);
		shift_num.x = FX_Mul(shift_num.x, task_w->camera_mv);
		shift_num.y = 0;
		shift_num.z = 0;

		set_num.x =	shift_num.x - task_w->camera_shift.x;
		set_num.y =	shift_num.y - task_w->camera_shift.y;
		set_num.z =	shift_num.z - task_w->camera_shift.z;
		
		// ݒ
		GFC_ShiftCamera(&set_num, task_w->camera);

		// JEg
		task_w->camera_count += MSBL01_CAMERA_COUNT_ADD;
		if(task_w->camera_count >= 0x10000){
			task_w->camera_count = 0;
			task_w->camera_mv += MSBL01_CAMERA_SHIFT_ADD;
		}
		
		// ړۑiŌɌɖ߂߁j
		task_w->camera_shift.x = shift_num.x;
		task_w->camera_shift.y = shift_num.y;
		task_w->camera_shift.z = shift_num.z;
		
		
		task_w->count--;
		if(task_w->count < 0){
			eew->seq++;
		}
		break;

	
	
	case MSBL01_FADE_OUT:		// tF[hAEg
		//BGʂɃJbg
		ENC_BG_Cut_Start( eew );
		
		//ubNAEg
		WIPE_SYS_Start( WIPE_PATTERN_M, WIPE_TYPE_FADEOUT, WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK, MSBL01_FADEOUT_DIV, MSBL01_FADEOUT_SYNC, HEAPID_FIELD );
		eew->seq++;
		break;
		
	
	
	case MSBL01_END_WAIT:
		if((ENC_HBlankEndCheck(eew) == TRUE) && ( WIPE_SYS_EndCheck() == TRUE )){
			// ɖ߂
			FLDMotionBl_Delete(&task_w->motion);
			GFC_PurgeCamera();				// J蓖ăt[
			GFC_AttachCamera(eew->fsw->camera_ptr);
			GFC_FreeCamera(task_w->camera);	// Jj

			// uCglX
			G2_BlendNone();
			
			eew->seq++;
		}
		break;

	
	case MSBL01_END_EFFECT:		// n
		
		G2_SetBG0Offset(0, 0);
		G2_SetBG1Offset(0, 0);
		G2_SetBG2Offset(0, 0);
		G2_SetBG3Offset(0, 0);
		
		if(eew->end != NULL){
			*(eew->end) = TRUE;		// ^XNI
		}
		sys_FreeMemory(HEAPID_FIELD, eew->work);
		PMDS_taskDel(tcb);	//^XNI
		WIPE_SetBrightness( WIPE_DISP_SUB, WIPE_FADE_BLACK );
		break;
	}	
}
