//============================================================================================
/**
 * @file	encount_effect.c
 * @bfief	GJEg
 * @author	GAME FREAK inc.
 */
//============================================================================================
#include "common.h"
#include "system/lib_pack.h"
#include "system/brightness.h"
#include "field_event.h"
#include "motion_bl.h"
#include "system/arc_util.h"

#include "fieldmap_work.h"
#include "fieldsys.h"

#include "battle/attr_def.h"
#include "ev_pokemon.h"

#include "system/palanm.h"


#define __ENCOUNT_EFFECT_H_GLOBAL__
#include "encount_effect.h"
#define __ECCOUNT_EFFECT_DEF_H_GLOBAL
#define __ECCOUNT_EFFECT_DEF_H_GLOBAL_VAL
#include "encount_effect_def.h"

#include "ecnt_tomo.h"
#include "encount_effect_sub.h"


//-----------------------------------------------------------------------------
//
// GJEgp֐e[u
//
//=============================================================================
static const TCB_FUNC EncountEffectTask[] ={

	EncountEffect_Field_GrassLevelLow,
	EncountEffect_Field_GrassLevelHigh,
	EncountEffect_Field_WaterLevelLow,
	EncountEffect_Field_WaterLevelHigh,
	EncountEffect_Field_DanLevelLow,
	EncountEffect_Field_DanLevelHigh,
	EncountEffect_Trainer_GrassLevelLow,
	EncountEffect_Trainer_GrassLevelHigh,
	EncountEffect_Trainer_WaterLevelLow,
	EncountEffect_Trainer_WaterLevelHigh,
	EncountEffect_Trainer_DanLevelLow,
	EncountEffect_Trainer_DanLevelHigh,

	EncountEffect_SPTR_IwaGym,			// NKlW
	EncountEffect_SPTR_KusaGym,         // nN^CW
	EncountEffect_SPTR_MizuGym,         // mZW
	EncountEffect_SPTR_KakutouGym,      // goW
	EncountEffect_SPTR_GoosutoGym,      // XKgW
	EncountEffect_SPTR_KooriGym,        // LbTLW
	EncountEffect_SPTR_HaganeGym,       // ~IW
	EncountEffect_SPTR_DenkiGym,        // iMTW

	EncountEffect_SPTR_Siten00,
	EncountEffect_SPTR_Siten01,
	EncountEffect_SPTR_Siten02,
	EncountEffect_SPTR_Siten03,

	EncountEffect_SPTR_Chanpion,

	EncountEffect_Legend_Normal,
	EncountEffect_Legend_Package,
	
	EncountEffect_Ginga_Normal,
	EncountEffect_Ginga_Special,

	EncountEffect_Special_Tower,
	EncountEffect_Special_Double,

	
/*	EncountEffectMotionBl00,
	EncountEffectMotionBl01,//*/

};

//-------------------------------------
//	
//	rbg}bv
//	
//=====================================
// rbg}bvEBhEhԂIuWFNg
typedef struct _ENC_BMP_FILL_OBJ{
	ENC_MOVE_WORK move_x;
	ENC_MOVE_WORK move_y;
	GF_BGL_BMPWIN* p_bmp;
	u8 width;
	u8 height;
	u8 move_flg;
	u8 col;
} ;

// rbg}bvEBhEubNhԂIuWFNg
typedef struct _ENC_BMP_FILL_BLOCK{
	ENC_MOVE_WORK move_x;
	ENC_MOVE_WORK move_y;
	GF_BGL_BMPWIN* p_bmp;
	u8 width;
	u8 height;
	u8 move_flg;
	u8 col;
} ;

static void ENC_BMP_Fill( GF_BGL_BMPWIN* p_bmp, s32 top, s32 bottom, s32 left, s32 right, u8 col );

// rbg}bvubNߐsVXe
#define ENCOUNT_BLOCK_MOVE_WIDTH	( 32 )	// ubNTCY
#define ENCOUNT_BLOCK_MOVE_HEIGHT	( 32 )	// ubNTCY
#define ENCOUNT_BLOCK_MOVE_MAT_Y	( -16 )	// JnW
#define ENCOUNT_BLOCK_MOVE_MOVE_Y	( 192 + ENCOUNT_BLOCK_MOVE_MAT_Y )	// ړ
#define ENCOUNT_BLOCK_MOVE_OBJNUM	( 48 )	// xubNŖ߂
#define ENCOUNT_BLOCK_MOVE_X_NUM	( 8 )	// ̐
#define ENCOUNT_BLOCK_MOVE_Y_NUM	( 6 )	// c̐
static const u8 ENCOUNT_BLOCK_MOVE_MoveParam[ ENCOUNT_BLOCK_MOVE_X_NUM ] = {	// oĂxW̏ԃe[u
	 0, 2, 5, 7, 1, 6, 3, 4 
};
typedef struct _ENC_BMP_FILL_BLOCK_MOVE{
	GF_BGL_BMPWIN* p_bmp;
	ENC_BMP_FILL_BLOCK* p_block[ ENCOUNT_BLOCK_MOVE_OBJNUM ];
	u8	block_count;
	u8	block_end_count;
	u8	move_sync;
	u8	start_sync;
	s8	wait;
	u8	col;
	u8	init_flg;
	u8	dummy[1];
};

// ~`rbg}bvhԂ
typedef struct _ENC_BMP_CIRCLE_FILL{
	GF_BGL_BMPWIN* p_bmp;
	ENC_MOVE_WORK rota;
	u8 move_flg;
	u8 col;
	u8 dummy[2];
};
static void EncBmpCircleFill_Fill( GF_BGL_BMPWIN* p_bmp, u16 last_rota, u16 now_rota, u8 col );

// tbVAEg@IuWF
#define ENC_BMP_FLASH_CIRCLE_NUM	( 8 )
static const u16 FlashOutParam[8][2] = {
	{ 0, 23 },
	{ 45, 22 },
	{ 45, 68 },
	{ 90, 67 },		// ͌Œ@ꂶȂƂ܂Ȃ
	{ 91, 113 },	// ͌Œ@ꂶȂƂ܂Ȃ
	{ 135, 112 },
	{ 135, 158 },
	{ 180, 157 },
};
typedef struct _ENC_BMP_FLASH_OUT {
	ENC_BMP_CIRCLE_FILL* p_circle[ ENC_BMP_FLASH_CIRCLE_NUM ];
	u8 move_flg;
	u8 dummy[3];
};


//-------------------------------------
//	
//	ײȽ֌W
//	
//=====================================

static void ENC_BrightnessVset( TCB_PTR tcb, void* work );

//-------------------------------------
//
//	ŏ̃sJsJ̃^XN
//
//=====================================
typedef struct{
	int seq;
	u32 flash_num;
	int count;
	int disp;		// ʎw
	u32 end_bright;
	u32 sub_bright;
	BR_BRIGHTNESS_FADE br_main;
	BR_BRIGHTNESS_FADE br_sub;
	BOOL* end;		// Ip
} BR_FLASH_TASK;
#define FLASH_EFF_SYNC_SUB	( 8 )
#define FLASH_EFF_SYNC_ONE	( 3 )

// JnGtFNg^XNiŏ̌̂Ȃǂ𐧌j
static void BR_FlashTask(TCB_PTR tcb, void *work);
enum{
	FADE_SUB_EFFECT,
	FADE_EFFECT,
	FADE_WAIT,
	FADE_RET_EFFECT,
	FADE_RET_WAIT,
	END_EFFECT,
};

//-------------------------------------
//
//	HuNp
//
//=====================================
//---------------------------
// BGɊHBlankp
//===========================
typedef struct {
	int x;			// ̈ړʒu
	int speed;		// x
	BOOL* end_check;// I`FbN
} ENC_HB_BG_CUT;
#define ENC_HB_BG_CUT_ST	(100)		// x
#define ENC_HB_BG_CUT_END_X	(25000)
static void ENC_BG_Cut_HBlank(FIELD_HBLANK_OBJ* p_hobj, void* p_work);

//-------------------------------------
//	hbgƂɍEɕĈړ
//=====================================
typedef struct _ENC_HB_BG_SLICE{
	ENC_ADDMOVE_WORK_FX move_x;
	u32 dot;
	u32 seq;
	FIELD_HBLANK_SYS* p_hsys;
	FIELD_HBLANK_OBJ* p_hobj;
	TCB_PTR tcb;
	BOOL* end_check;// I`FbN
} ;
#define END_HB_BG_SLICE_TCB_PRI	( 1024 )
#define END_HB_BG_SLICE_INIT_TCB_PRI	( 1024 )
static void ENC_BG_Slice_SetUp_Tcb( TCB_PTR tcb, void* p_work );
static void ENC_BG_Slice_Tcb( TCB_PTR tcb, void* p_work );
static void ENC_BG_Slice_HBlank(FIELD_HBLANK_OBJ* p_hobj, void* p_work);
static void ENC_BG_Slice_End( ENC_HB_BG_SLICE* p_work );


//-------------------------------------
// EBhEŎ΂߂ɉʂBĂ
//=====================================
typedef struct _ENC_HB_BG_WND_SLANT{
	ENC_ADDMOVE_WORK_FX move_x;
	ENC_ADDMOVE_WORK_FX move_y;
	u32 cut_y;
	u32 seq;
	FIELD_HBLANK_SYS* p_hsys;
	FIELD_HBLANK_OBJ* p_hobj;
	TCB_PTR tcb;
	BOOL* end_check;// I`FbN
};
#define END_HB_BG_WND_SLANT_TCB_PRI	( 1024 )
#define END_HB_BG_WND_SLANT_INIT_TCB_PRI	( 1024 )
#define END_HB_BG_WND_SLANT_CUT_Y	( 96 )
#define END_HB_BG_WND_SLANT_MOVE_X	( 255*FX32_ONE )
#define END_HB_BG_WND_SLANT_MOVE_Y	( 96*FX32_ONE )
static void ENC_BG_WndSlant_SetUp_Tcb( TCB_PTR tcb, void* p_work );
static void ENC_BG_WndSlant_Tcb( TCB_PTR tcb, void* p_work );
static void ENC_BG_WndSlant_HBlank(FIELD_HBLANK_OBJ* p_hobj, void* p_work);
static void ENC_BG_WndSlant_End( ENC_HB_BG_WND_SLANT* p_work );

// JbgCp@WOUOEBhE
typedef struct _ENC_HB_BG_WND_ZIGUZAGU{
	ENC_MOVE_WORK move_x;
	u32 seq;
	u8  ziguzagu_buf[ 192 ];
	FIELD_HBLANK_SYS* p_hsys;
	FIELD_HBLANK_OBJ* p_hobj;
	TCB_PTR tcb;
	BOOL* end_check;// I`FbN
} ;
#define ENC_BG_WND_ZIGUZAGU_MOVE_S		( 0 )
#define ENC_BG_WND_ZIGUZAGU_MOVE_E		( 255 )
#define END_HB_BG_WND_ZIGUZAGU_TCB_PRI	( 1024 )
#define END_HB_BG_WND_ZIGUZAGU_INIT_TCB_PRI	( 1024 )
static void ENC_BG_WndZiguzagu_SetUp_Tcb( TCB_PTR tcb, void* p_work );
static void ENC_BG_WndZiguzagu_Tcb( TCB_PTR tcb, void* p_work );
static void ENC_BG_WndZiguzagu_HBlank(FIELD_HBLANK_OBJ* p_hobj, void* p_work);
static void ENC_BG_WndZiguzagu_End( ENC_HB_BG_WND_ZIGUZAGU* p_work );



//-------------------------------------
//	OtBbN
//=====================================
#define ENC_BG_AFFINCONT_TASK	( 1024 )
static void ENC_BG_AffinContSetTcb( TCB_PTR tcb, void* work );

// OAM
static void ENC_OAM_TransOamPltt( CLACT_WORK_PTR clact, void* data, u32 size );
static void ENC_OAM_TransOamChar( CLACT_WORK_PTR clact, void* data, u32 size );
#define ENC_OAM_TR_CHAR_SIZE_X	( 64 )	// OAMLN^PʃTCY
#define ENC_OAM_TR_CHAR_SIZE_Y	( 64 )	// OAMLN^PʃTCY
#define ENC_OAM_TR_CHAR_ONELINE	( 8*8 )
#define ENC_OAM_TR_CHAR_BUFF_SIZE 	( 0x800 )// LN^obt@TCY
#define ENC_OAM_TR_CHAR_CUT_Y	( 0 )	// ꂾ炵Ƃ납甲o
static void* ENC_OAM_TrCharMake( const NNSG2dCharacterData* cp_chardata, u32 heap, u32* p_size, u32 ofs_cx );

static void ENC_WND_SetWndPositionVWait( TCB_PTR tcb, void* p_work );


//----------------------------------------------------------------------------
/**
 *
 *@brief	GJEgGtFNgJn
 *
 *@param	No		GJEgGtFNgNO
 *@param	*fsw	tB[hVXe[Ñ|C^
 *@param	end		I`FbNp@TRUEFI 
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void EncountEffectStart(int No, FIELDSYS_WORK *fsw, BOOL* end )
{
	TCB_PTR tcb;
	ENCOUNT_EFFECT_WORK *eew;
	tcb = PMDS_taskAdd(EncountEffectTask[No], sizeof(ENCOUNT_EFFECT_WORK), TCB_TSK_PRI, HEAPID_FIELD);
	eew = TCB_GetWork(tcb);
	eew->fsw = fsw;
	eew->end = end;		// ItOݒ
	if(eew->end != NULL){
		*(eew->end) = FALSE;
	}
	eew->hblank_flg = FALSE;
}





//-----------------------------------------------------------------------------
//
//	ŏ̃sJsJp^XNJn֐
//
//=============================================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	ŏ̃tbV̕\^XNs
 *					
 *@param	disp	Cʂɂ:MASK_MAIN_DISPLAY
 *					Tuʂɂ:MASK_SUB_DISPLAY
 *					ʂɂ:MASK_DOUBLE_DISPLAY
 *
 *@param	end		ITRUEԂtO
 *@param	flash_num	tbV
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void EncountFlashTask(int disp, u32 bright_color, u32 sub_bright_color, BOOL* end, u32 flash_num )
{
	TCB_PTR tcb;
	BR_FLASH_TASK *eew;

	eew = sys_AllocMemory( HEAPID_FIELD, sizeof(BR_FLASH_TASK) );
	memset( eew, 0, sizeof(BR_FLASH_TASK) );
	TCB_Add( BR_FlashTask, eew, TCB_TSK_PRI );
	
	eew->end = end;		// ItOݒ
	if(eew->end != NULL){
		*(eew->end) = FALSE;
	}
	eew->disp = disp;
	eew->end_bright = bright_color;
	eew->sub_bright = sub_bright_color;
	eew->flash_num	= flash_num;
}

//------------------------------------------------------------------
/**
 * 
 * GtFNg
 *
 * ŏ̃sJsJ\
 * 
 * @param   tcb		^XN|C^
 * @param   work	[N|C^
 *
 * @retval  none		
 *
 * sJsJ@20VNgp
 */
//------------------------------------------------------------------
static void BR_FlashTask(TCB_PTR tcb, void *work)
{
	BR_FLASH_TASK *eew = work;

	switch(eew->seq){
	case FADE_SUB_EFFECT:
		if(eew->disp == MASK_MAIN_DISPLAY){
			//ubNAEg
//			ChangeBrightnessRequest( 40,-16,0, eew->plane, MASK_SUB_DISPLAY);
			ENC_ChangeMstBrightness( &eew->br_sub, 0, eew->sub_bright, MASK_SUB_DISPLAY, FLASH_EFF_SYNC_SUB );
		}else{
			if(eew->disp == MASK_SUB_DISPLAY){
				//ubNAEg
//				ChangeBrightnessRequest(40,-16,0, eew->plane, MASK_MAIN_DISPLAY);
				ENC_ChangeMstBrightness( &eew->br_sub, 0, eew->sub_bright, MASK_MAIN_DISPLAY, FLASH_EFF_SYNC_SUB );
			}
		}
		eew->seq++;
		break;

	case FADE_EFFECT:
		//zCgAEg
//		ChangeBrightnessRequest(4,16,0,eew->plane,eew->disp);
		ENC_ChangeMstBrightness( &eew->br_main, 0, eew->end_bright, eew->disp, FLASH_EFF_SYNC_ONE );
		eew->seq++;
		break;
		
	case FADE_WAIT:
		if( ENC_ChangeMstBrightnessMain( &eew->br_main ) ){
			eew->seq++;
		}
		break;
	case FADE_RET_EFFECT:
		//zCgC
//		ChangeBrightnessRequest(4,0,16,eew->plane,eew->disp);
		ENC_ChangeMstBrightness( &eew->br_main, eew->end_bright, 0, eew->disp, FLASH_EFF_SYNC_ONE );
		eew->seq++;
		break;
		
	case FADE_RET_WAIT:
		if( ENC_ChangeMstBrightnessMain( &eew->br_main ) ){
			
			eew->count++;
			if(eew->count==eew->flash_num){
				eew->seq = END_EFFECT;
			}else{
				eew->seq = FADE_EFFECT;
			}
		}
		break;
	case END_EFFECT:		// CGtFNgɈړ
		eew->seq = 0;
		eew->count = 0;

		if(eew->end != NULL){
			*(eew->end) = TRUE;		// ^XNI
		}

		TCB_Delete(tcb);	//^XNI
		sys_FreeMemoryEz( eew );
		return ;
	}

	// TuʃtF[h
	ENC_ChangeMstBrightnessMain( &eew->br_sub );
}


//----------------------------------------------------------------------------
//
//
//	GtFNgpHuN֐S
//
//
//============================================================================
// HuNI`FbN
//----------------------------------------------------------------------------
/**
 *	@brief	HuNI`FbN
 *	@param	p_work 
 *	@return
 */
//-----------------------------------------------------------------------------
BOOL ENC_HBlankEndCheck( ENCOUNT_EFFECT_WORK* p_work )
{
	return p_work->hblank_flg;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	BGʂSĉɃJbgX^[g
 *
 *@param	p_ew	̪ă[N
 *
 *@return	none
 */
//-----------------------------------------------------------------------------
void ENC_BG_Cut_Start(ENCOUNT_EFFECT_WORK* p_ew)
{
	ENC_HB_BG_CUT* p_work;

	p_work = sys_AllocMemory( HEAPID_FIELD, sizeof(ENC_HB_BG_CUT) );
	memset( p_work, 0, sizeof(ENC_HB_BG_CUT) );
	FLDHBLANK_OBJ_Add( p_ew->fsw->fldmap->hblanksys, ENC_BG_Cut_HBlank, p_work );
	p_ew->hblank_flg = FALSE;
	p_work->end_check = &p_ew->hblank_flg;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	BGʂSĉɃJbg
 *
 *@param	p_hobj	huNIuWFNg
 *@param	p_work	[N
 *
 *@return	none
 */
//-----------------------------------------------------------------------------
static void ENC_BG_Cut_HBlank(FIELD_HBLANK_OBJ* p_hobj, void* p_work)
{
	ENC_HB_BG_CUT* hbw = (ENC_HB_BG_CUT*)p_work;
	int v_count;		// VJEg
	int	x_num;			// BGItZbgɐݒ肷l

	// VJE^擾AO͈̎ړlvZ
	v_count = GX_GetVCount();
	if(v_count == 0){

		if((hbw->x + hbw->speed) <= ENC_HB_BG_CUT_END_X){
			hbw->x += hbw->speed;			// ړ
			hbw->speed += ENC_HB_BG_CUT_ST;	// 
		}else{
			
			*hbw->end_check = TRUE;
			FLDHBLANK_OBJ_Delete( p_hobj );
			sys_FreeMemoryEz( p_work );
			return ;
		}
	}

	// 96A96ȏEɈړ
	x_num = hbw->x / 100;
	if(v_count >= 96){
		x_num = -x_num;
	}
	G2_SetBG0Offset(x_num, 0);
	G2_SetBG1Offset(x_num, 0);
	G2_SetBG2Offset(x_num, 0);
	G2_SetBG3Offset(x_num, 0);
}



//----------------------------------------------------------------------------
/**
 *	@brief	쏉
 *
 *	@param	p_work			샏[N
 *	@param	s_x				JnxW
 *	@param	e_x				IxW
 *	@param	count_max		JEgől
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_MoveReq( ENC_MOVE_WORK* p_work, int s_x, int e_x, int count_max )
{
	p_work->x = s_x;
	p_work->s_x = s_x;
	p_work->dis_x = e_x - s_x;
	p_work->count_max = count_max;
	p_work->count = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	상C
 *
 *	@param	p_work	[N
 *
 *	@retval	TRUE	I
 *	@retval FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ENC_MoveMain( ENC_MOVE_WORK* p_work )
{
	int w_x;

	// ݍW擾
	w_x = p_work->dis_x * p_work->count;
	w_x = w_x / p_work->count_max;

	
	p_work->x = w_x + p_work->s_x;

	if( (p_work->count + 1) <= p_work->count_max ){
		p_work->count++;
		return FALSE;
	}

	p_work->count = p_work->count_max;
	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	쏉
 *
 *	@param	p_work			샏[N
 *	@param	s_x				JnxW
 *	@param	e_x				IxW
 *	@param	count_max		JEgől
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_MoveReqFx( ENC_MOVE_WORK_FX* p_work, fx32 s_x, fx32 e_x, int count_max )
{
	p_work->x = s_x;
	p_work->s_x = s_x;
	p_work->dis_x = e_x - s_x;
	p_work->count_max = count_max;
	p_work->count = 0;
}

//----------------------------------------------------------------------------
/**
 *	@brief	상C
 *
 *	@param	p_work	[N
 *
 *	@retval	TRUE	I
 *	@retval FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ENC_MoveMainFx( ENC_MOVE_WORK_FX* p_work )
{
	fx32 w_x;

	// ݍW擾
	w_x = FX_Mul( p_work->dis_x, p_work->count << FX32_SHIFT );
	w_x = FX_Div( w_x, p_work->count_max << FX32_SHIFT );
	
	p_work->x = w_x + p_work->s_x;

	if( (p_work->count + 1) <= p_work->count_max ){
		p_work->count++;
		return FALSE;
	}

	p_work->count = p_work->count_max;
	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	ėp@
 *
 *	@param	p_work	[N
 *	@param	s_x		JnW
 *	@param	e_x		IW
 *	@param	s_s		Jnx
 *	@param	count_max l
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_AddMoveReqFx( ENC_ADDMOVE_WORK_FX* p_work, fx32 s_x, fx32 e_x, fx32 s_s, int count_max )
{
	fx32 t_x_t;	// ^ĈQ
	fx32 vot;	// x^C
	fx32 dis;
	fx32 a;

	dis = e_x - s_x;
	
	// l߂
	// a = 2(x - vot)/(t*t)
	t_x_t = (count_max * count_max) << FX32_SHIFT;
	vot = FX_Mul( s_s, count_max * FX32_ONE );
	vot = dis - vot;
	vot = FX_Mul( vot, 2*FX32_ONE );
	a = FX_Div( vot, t_x_t );

	p_work->x = s_x;
	p_work->s_x = s_x;
	p_work->s_s = s_s;
	p_work->s_a = a;
	p_work->count = 0;
	p_work->count_max = count_max;
}

//----------------------------------------------------------------------------
/**
 *	@brief	상C
 *
 *	@param	p_work	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ENC_AddMoveMainFx( ENC_ADDMOVE_WORK_FX* p_work )
{
	fx32 dis;
	fx32 t_x_t;
	fx32 calc_work;
	fx32 vot;
	
	// x^
	// dis = vot + 1/2( a*(t*t) )
	vot = FX_Mul( p_work->s_s, p_work->count << FX32_SHIFT );
	t_x_t = (p_work->count * p_work->count) << FX32_SHIFT;
	calc_work = FX_Mul( p_work->s_a, t_x_t );
	calc_work = FX_Div( calc_work, 2*FX32_ONE );	// 1/2(a*(t*t))
	dis = vot + calc_work;	///<ړ

	p_work->x = p_work->s_x + dis;


	if( (p_work->count + 1) <= p_work->count_max ){
		p_work->count++;
		return FALSE;
	}

	p_work->count = p_work->count_max;
	return TRUE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	ϽuCglXݒ
 *
 *	@param	disp	
 *	@param	no		l
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_SetMstBrightness( int disp, int no )
{
	// uCglX
	if( disp == MASK_MAIN_DISPLAY ){
		GX_SetMasterBrightness(no);
	}else{
		GXS_SetMasterBrightness(no);
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	ϽuCglXύX@tF[hf[^i[
 *
 *	@param	p_data		i[
 *	@param	start		Jnl
 *	@param	end			Il
 *	@param	disp		
 *	@param	sync		VN
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_ChangeMstBrightness( BR_BRIGHTNESS_FADE* p_data, int start, int end, int disp, int sync )
{
	p_data->disp = disp;
	ENC_MoveReq( &p_data->brightness, start, end, sync );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ϽuCglXύX@tF[hC
 *
 *	@param	p_data	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ENC_ChangeMstBrightnessMain( BR_BRIGHTNESS_FADE* p_data )
{
	BOOL result;
	result = ENC_MoveMain( &p_data->brightness );
	
	// VuNԒɐݒ肵ȂƂꂢɃtF[hȂ
	VWaitTCB_Add( ENC_BrightnessVset, p_data, TCB_VWAIT_BR_TSK_PRI );
	return result;
}

//----------------------------------------------------------------------------
/**
 *	@brief	VuNԒײȽlݒ肷^XN
 *
 *	@param	tcb		TCB[N
 *	@param	work	[N
 *
 *	@return	none
 *	VuNԒɐݒ肵ȂƂꂢɃtF[hȂ
 */
//-----------------------------------------------------------------------------
static void ENC_BrightnessVset( TCB_PTR tcb, void* work )
{
	BR_BRIGHTNESS_FADE* p_data = work;
	ENC_SetMstBrightness( p_data->disp, p_data->brightness.x );
	TCB_Delete( tcb );
}


//----------------------------------------------------------------------------
/**
 *	@brief	[N쐬
 *
 *	@param	none
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
ENC_HB_BG_SLICE* ENC_BG_Slice_Alloc( void )
{
	ENC_HB_BG_SLICE* p_work;
	
	p_work = sys_AllocMemory( HEAPID_FIELD, sizeof(ENC_HB_BG_SLICE) );
	memset( p_work, 0, sizeof(ENC_HB_BG_SLICE) );

	// EBhE}XNݒ
	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 | GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_BG3 | GX_WND_PLANEMASK_OBJ, TRUE );	
	G2_SetWnd1InsidePlane( GX_WND_PLANEMASK_NONE, FALSE );	

	return p_work;
}

//----------------------------------------------------------------------------
/**
 *	@brief	j
 *
 *	@param	p_work 
 *
 *	@return none	
 */
//-----------------------------------------------------------------------------
void ENC_BG_Slice_Delete( ENC_HB_BG_SLICE* p_work )
{
	if( p_work->p_hobj != NULL ){
		ENC_BG_Slice_End( p_work );
	}

	// EBhE}XNj
	GX_SetVisibleWnd( GX_WNDMASK_NONE );

	sys_FreeMemoryEz( p_work );
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGSliceJn
 *
 *	@param	p_ew	GtFNg[N
 *	@param	p_eff	BGXCX
 *	@param	dot		hbg	1hbgƂȂ1
 *	@param	sync	GtFNgVN
 *	@param	s_x		Jnxl
 *	@param	e_x		IXl
 *	@param	s_s		x
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
void ENC_BG_Slice_Start( ENCOUNT_EFFECT_WORK* p_ew, ENC_HB_BG_SLICE* p_eff, u8 dot, u32 sync, int s_x, int e_x, fx32 s_s )
{
	// Jnς
	GF_ASSERT( p_eff->p_hobj == NULL );
	
	p_ew->hblank_flg	= FALSE;
	p_eff->p_hsys		= p_ew->fsw->fldmap->hblanksys;
	p_eff->dot			= dot;
	p_eff->seq			= 0;
	p_eff->end_check	= &p_ew->hblank_flg;
	ENC_AddMoveReqFx( &p_eff->move_x, s_x, e_x, s_s, sync );

	if( s_x >= 0 ){
		G2_SetWnd0Position( 0, 0, 255 - s_x, 192 );
		G2_SetWnd1Position( 0, 0, 1 + s_x, 192 );	// +1ȂƂȂ
	}else{
		G2_SetWnd0Position( 0, 0, 255 + s_x, 192 );
		G2_SetWnd1Position( 0, 0, 1 - s_x, 192 );	// +1ȂƂȂ
	}
	
	// ^XNo^֐
	VWaitTCB_Add( ENC_BG_Slice_SetUp_Tcb, p_eff, END_HB_BG_SLICE_INIT_TCB_PRI );
}

// ݒ֐
static void ENC_BG_Slice_SetUp_Tcb( TCB_PTR tcb, void* p_work )
{
	ENC_HB_BG_SLICE* p_eff = p_work;

	p_eff->tcb = VWaitTCB_Add( ENC_BG_Slice_Tcb, p_eff, END_HB_BG_SLICE_TCB_PRI );
	p_eff->p_hobj = FLDHBLANK_OBJ_Add( p_eff->p_hsys, ENC_BG_Slice_HBlank, p_eff );

	TCB_Delete( tcb );
}


//----------------------------------------------------------------------------
/**
 *	@brief	Jbgp[^ύX֐
 *
 *	@param	p_ew	[N
 *	@param	p_work	[N
 *	@param	dot		hbg
 *	@param	sync	VN
 *	@param	s_x		Jnʒu
 *	@param	e_x		Iʒu
 *	@param	s_s		x
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_BG_Slice_Change( ENCOUNT_EFFECT_WORK* p_ew, ENC_HB_BG_SLICE* p_work, u8 dot, u32 sync, int s_x, int e_x, fx32 s_s )
{
	// Iς݂ȂG[
	GF_ASSERT( ENC_HBlankEndCheck( p_ew ) == FALSE );	

	p_work->dot			= dot;
	p_work->seq			= 0;
	ENC_AddMoveReqFx( &p_work->move_x, s_x, e_x, s_s, sync );
}


//----------------------------------------------------------------------------
/**
 *	@brief	BGXCX^XN
 *
 *	@param	tcb		TCB[N
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ENC_BG_Slice_Tcb( TCB_PTR tcb, void* p_work )
{
	ENC_HB_BG_SLICE* p_data = p_work;
	s32 num;
	
	switch( p_data->seq ){
	case 0:
		if( ENC_AddMoveMainFx( &p_data->move_x ) ){
			p_data->seq ++;
		}
		num = p_data->move_x.x >> FX32_SHIFT;
		if( num >= 0 ){
			G2_SetWnd0Position( 0, 0, 255 - num, 192 );
			G2_SetWnd1Position( 0, 0, 1 + num, 192 );	// +1ȂƂȂ
		}else{
			G2_SetWnd0Position( 0, 0, 255 + num, 192 );
			G2_SetWnd1Position( 0, 0, 1 - num, 192 );	// +1ȂƂȂ
		}
		break;

	case 1:	// HuNŏ̒lf̂łPVN҂@I
		ENC_BG_Slice_End( p_work );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGXCXI
 *
 *	@param	p_work [N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ENC_BG_Slice_End( ENC_HB_BG_SLICE* p_work )
{
	// EBhE}XNݒ
	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 | GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_BG3 | GX_WND_PLANEMASK_OBJ, TRUE );	
	G2_SetWndOutsidePlane( GX_WND_PLANEMASK_NONE, FALSE );	
	G2_SetWnd0Position( 0,0,0,0 );
	GX_SetVisibleWnd( GX_WNDMASK_W0 );
	
	*(p_work->end_check) = TRUE;
	FLDHBLANK_OBJ_Delete( p_work->p_hobj );
	p_work->p_hobj = NULL;
	TCB_Delete( p_work->tcb );
	p_work->tcb = NULL;
}


//----------------------------------------------------------------------------
/**
 *	@brief	BGXCX@HuNR[obN
 *
 *	@param	p_hobj	IuWFNg
 *	@param	p_work	[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ENC_BG_Slice_HBlank(FIELD_HBLANK_OBJ* p_hobj, void* p_work)
{
	ENC_HB_BG_SLICE* p_data = p_work;
	int v_count;		// VJEg
	int	x_num;			// BGItZbgɐݒ肷l

	// VJE^擾AO͈̎ړlvZ
	v_count = GX_GetVCount();
	
	if( ((v_count / p_data->dot) % 2) == 0 ){
		x_num = p_data->move_x.x >> FX32_SHIFT;
	}else{
		x_num = -p_data->move_x.x >> FX32_SHIFT;
	}
	G2_SetBG0Offset(x_num, 0);
	G2_SetBG1Offset(x_num, 0);
	G2_SetBG2Offset(x_num, 0);
	G2_SetBG3Offset(x_num, 0);

	if( x_num >= 0 ){
		GX_SetVisibleWnd( GX_WNDMASK_W0 );
		G2_SetWndOutsidePlane( GX_WND_PLANEMASK_NONE, FALSE );	
	}else{
		GX_SetVisibleWnd( GX_WNDMASK_W1 );
		G2_SetWndOutsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 | GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_BG3 | GX_WND_PLANEMASK_OBJ, TRUE );	
	}
}


//----------------------------------------------------------------------------
/**
 *		yEBhE΂߃Jbgz
 *	@brief		[Nm
 */
//-----------------------------------------------------------------------------
ENC_HB_BG_WND_SLANT* ENC_BG_WndSlant_Alloc( void )
{
	ENC_HB_BG_WND_SLANT* p_work;

	p_work = sys_AllocMemory( HEAPID_FIELD, sizeof(ENC_HB_BG_WND_SLANT) );
	memset( p_work, 0, sizeof(ENC_HB_BG_WND_SLANT) );
	
	// EBhE}XNݒ
	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 | GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_BG3 | GX_WND_PLANEMASK_OBJ, TRUE );	
	G2_SetWnd1InsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 | GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_BG3 | GX_WND_PLANEMASK_OBJ, TRUE );	
	G2_SetWndOutsidePlane( GX_WND_PLANEMASK_NONE, FALSE );	

	return p_work;
}

//----------------------------------------------------------------------------
/**
 *		yEBhE΂߃Jbgz
 *	@brief		[Nj
 */
//-----------------------------------------------------------------------------
void ENC_BG_WndSlant_Delete( ENC_HB_BG_WND_SLANT* p_work )
{
	if( p_work->p_hobj != NULL ){
		ENC_BG_WndSlant_End( p_work );
	}

	// EBhE}XNj
	GX_SetVisibleWnd( GX_WNDMASK_NONE );

	sys_FreeMemoryEz( p_work );
}

//----------------------------------------------------------------------------
/**
 *		yEBhE΂߃Jbgz
 *	@brief	Jn
 *
 *	@param	p_ew		GJEgGtFNg[N
 *	@param	p_eff		GtFNg[N
 *	@param	sync		VN
 *	@param	x_ss		Xx
 *	@param	y_ss		Yx
 */
//-----------------------------------------------------------------------------
void ENC_BG_WndSlant_Start( ENCOUNT_EFFECT_WORK* p_ew, ENC_HB_BG_WND_SLANT* p_eff, u32 sync, fx32 x_ss, fx32 y_ss )
{
	// Jnς
	GF_ASSERT( p_eff->p_hobj == NULL );
	
	p_ew->hblank_flg	= FALSE;
	p_eff->p_hsys		= p_ew->fsw->fldmap->hblanksys;
	p_eff->cut_y		= END_HB_BG_WND_SLANT_CUT_Y;
	p_eff->seq			= 0;
	p_eff->end_check	= &p_ew->hblank_flg;
	ENC_AddMoveReqFx( &p_eff->move_x, 0, END_HB_BG_WND_SLANT_MOVE_X, x_ss, sync );
	ENC_AddMoveReqFx( &p_eff->move_y, 0, END_HB_BG_WND_SLANT_MOVE_Y, y_ss, sync );

	G2_SetWnd0Position( 0, 0, 255, 192 );
	G2_SetWnd1Position( 0, 0, 255, 192 );
	
	// ^XNo^֐
	VWaitTCB_Add( ENC_BG_WndSlant_SetUp_Tcb, p_eff, END_HB_BG_WND_SLANT_INIT_TCB_PRI );
}

//----------------------------------------------------------------------------
/**
 *		yEBhE΂߃Jbgz
 *	@brief	ZbgAbv^XN
 */
//-----------------------------------------------------------------------------
static void ENC_BG_WndSlant_SetUp_Tcb( TCB_PTR tcb, void* p_work )
{
	ENC_HB_BG_WND_SLANT* p_eff = p_work;

	p_eff->tcb = VWaitTCB_Add( ENC_BG_WndSlant_Tcb, p_eff, END_HB_BG_WND_SLANT_TCB_PRI );
	p_eff->p_hobj = FLDHBLANK_OBJ_Add( p_eff->p_hsys, ENC_BG_WndSlant_HBlank, p_eff );

	TCB_Delete( tcb );
}

//----------------------------------------------------------------------------
/**
 *		yEBhE΂߃Jbgz
 *	@brief	^XN
 */
//-----------------------------------------------------------------------------
static void ENC_BG_WndSlant_Tcb( TCB_PTR tcb, void* p_work )
{
	ENC_HB_BG_WND_SLANT* p_data = p_work;
	s32 x_num;
	s32 y_num;
	
	switch( p_data->seq ){
	case 0:
		ENC_AddMoveMainFx( &p_data->move_y );
		if( ENC_AddMoveMainFx( &p_data->move_x ) ){
			p_data->seq ++;
		}
		x_num = p_data->move_x.x >> FX32_SHIFT;
		y_num = p_data->move_y.x >> FX32_SHIFT;
		G2_SetWnd0Position( 0, 0, 255 - x_num, 96 - y_num );
		G2_SetWnd1Position( x_num, 96 + y_num, 255, 192);
		break;

	case 1:	// HuNŏ̒lf̂łPVN҂@I
		ENC_BG_WndSlant_End( p_work );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *		yEBhE΂߃Jbgz
 *	@brief	HuN֐
 */
//-----------------------------------------------------------------------------
static void ENC_BG_WndSlant_HBlank(FIELD_HBLANK_OBJ* p_hobj, void* p_work)
{
	ENC_HB_BG_WND_SLANT* p_data = p_work;
	int v_count;		// VJEg
	int	x_num;			// BGItZbgɐݒ肷l
	int	y_num;			// BGItZbgɐݒ肷l

	// VJE^擾AO͈̎ړlvZ
	v_count = GX_GetVCount();
	
	if( v_count <= p_data->cut_y ){
		GX_SetVisibleWnd( GX_WNDMASK_W0 );
	}else{
		GX_SetVisibleWnd( GX_WNDMASK_W1 );
	}
}

//----------------------------------------------------------------------------
/**
 *		yEBhE΂߃Jbgz
 *	@brief	I֐
 */
//-----------------------------------------------------------------------------
static void ENC_BG_WndSlant_End( ENC_HB_BG_WND_SLANT* p_work )
{
	// EBhE}XNݒ
	G2_SetWnd0InsidePlane( GX_WND_PLANEMASK_BG0 | GX_WND_PLANEMASK_BG1 | GX_WND_PLANEMASK_BG2 | GX_WND_PLANEMASK_BG3 | GX_WND_PLANEMASK_OBJ, TRUE );	
	G2_SetWndOutsidePlane( GX_WND_PLANEMASK_NONE, FALSE );	
	G2_SetWnd0Position( 0,0,0,0 );
	GX_SetVisibleWnd( GX_WNDMASK_W0 );
	
	*(p_work->end_check) = TRUE;
	FLDHBLANK_OBJ_Delete( p_work->p_hobj );
	p_work->p_hobj = NULL;
	TCB_Delete( p_work->tcb );
	p_work->tcb = NULL;
}




//----------------------------------------------------------------------------
/**
 *	@brief	AtBBGݒ
 *
 *	@param	p_bgl	BGL
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_BG_SetAffineCont( GF_BGL_INI* p_bgl )
{
	VWaitTCB_Add( ENC_BG_AffinContSetTcb, p_bgl, ENC_BG_AFFINCONT_TASK );
}

//----------------------------------------------------------------------------
/**
 *	@brief		ӂBGݒ
 */
//-----------------------------------------------------------------------------
static void ENC_BG_AffinContSetTcb( TCB_PTR tcb, void* work )
{
	GF_BGL_INI* p_bgl = work;

	{
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS,GX_BGMODE_1,GX_BGMODE_0, GX_BG0_AS_3D
		};
		GF_BGL_InitBG(&BGsys_data);
	}

	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );	

	{	// MAIN DISPiGtFNgPj
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlExit( p_bgl, GF_BGL_FRAME1_M );
		GF_BGL_BGControlSet( p_bgl, GF_BGL_FRAME1_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( GF_BGL_FRAME1_M, 32, 0, HEAPID_FIELD );
		GF_BGL_ScrClear( p_bgl, GF_BGL_FRAME1_M );
		// \OFF
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	}

	{	// MAIN DISPiGtFNgQj
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x08000, GX_BG_EXTPLTT_23,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlExit( p_bgl, GF_BGL_FRAME2_M );
		GF_BGL_BGControlSet( p_bgl, GF_BGL_FRAME2_M, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( GF_BGL_FRAME2_M, 32, 0, HEAPID_FIELD );
		GF_BGL_ScrClear( p_bgl, GF_BGL_FRAME2_M );
		// \OFF
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
	}

	{	// AtBBG
		GF_BGL_BGCNT_HEADER AffBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_256,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_23,
			0, TRUE, 0, FALSE
		};
		GF_BGL_BGControlExit( p_bgl, ENC_BG_AFFINE_FRAME );
		GF_BGL_BGControlSet( p_bgl, ENC_BG_AFFINE_FRAME, &AffBgCntDat, GF_BGL_MODE_AFFINE );
		GF_BGL_ClearCharSet( ENC_BG_AFFINE_FRAME, 32, 0, HEAPID_FIELD );
		GF_BGL_ScrClear( p_bgl, ENC_BG_AFFINE_FRAME );

		// \OFF
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );
	}

	TCB_Delete( tcb );
}


//----------------------------------------------------------------------------
/**
 *	@brief	AtBBGݒ
 *
 *	@param	scrn_idx		XN[CfbNX
 *	@param	char_idx		LN^CfbNX
 *	@param	pltt_idx		pbgCfbNX
 *	@param	p_bgl			BGL
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_BG_SetAffineBG( u32 scrn_idx, u32 char_idx, u32 pltt_idx, GF_BGL_INI* p_bgl )
{

	// OtBbNǂݍ
	ArcUtil_PalSet( ARC_ENCOUNTEFFECT, pltt_idx, PALTYPE_MAIN_BG, 0, 0, HEAPID_FIELD );
	ArcUtil_BgCharSet( ARC_ENCOUNTEFFECT, char_idx, p_bgl, ENC_BG_AFFINE_FRAME, 0, 0, FALSE, HEAPID_FIELD );
	ArcUtil_ScrnSet( ARC_ENCOUNTEFFECT, scrn_idx, p_bgl, ENC_BG_AFFINE_FRAME, 0, 0, FALSE, HEAPID_FIELD );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ʏBGݒ
 *
 *	@param	scrn_idx	XN[CfbNX
 *	@param	char_idx	LN^CfbNX
 *	@param	pltt_idx	pbgCfbNX
 *	@param	pltt_no		pbgio[
 *	@param	pltt_num	pbg
 *	@param	p_bgl		BGL
 *	@param	frame		BGt[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_BG_SetNormalBG( u32 scrn_idx, u32 char_idx, u32 pltt_idx, u32 pltt_no, u32 pltt_num, GF_BGL_INI* p_bgl, u32 frame )
{
	void* buff;
	NNSG2dScreenData* p_scrn;
	
	// OtBbNǂݍ
	ArcUtil_PalSet( ARC_ENCOUNTEFFECT, pltt_idx, PALTYPE_MAIN_BG, pltt_no*32, pltt_num*32, HEAPID_FIELD );
	ArcUtil_BgCharSet( ARC_ENCOUNTEFFECT, char_idx, p_bgl, frame, 0, 0, FALSE, HEAPID_FIELD );

	// XN[f[^ǂݍ
	buff = ArcUtil_ScrnDataGet( ARC_ENCOUNTEFFECT, scrn_idx, FALSE, &p_scrn, HEAPID_FIELD );
	
	// XN[f[^
	GF_BGL_ScrWrite( p_bgl, frame,
			p_scrn->rawData, 0, 0,
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8 );

	// pbg킹
	GF_BGL_ScrPalChange( p_bgl, frame,
			0, 0, 
			p_scrn->screenWidth / 8, p_scrn->screenHeight / 8,
			pltt_no );

	sys_FreeMemoryEz( buff );

	// XN[f[^]
	GF_BGL_LoadScreenV_Req( p_bgl, frame );
}

//----------------------------------------------------------------------------
/**
 *	@brief		AtBXN[ݒ^XN
 */
//-----------------------------------------------------------------------------
static void ENC_BG_SetAffineMtxTcb( TCB_PTR tcb, void* p_work )
{
	ENC_BG_SET_AFFINEPARAM* p_data = p_work;

	GF_BGL_AffineScrollSet( p_data->p_bgl, p_data->frame, 
			GF_BGL_SCROLL_X_SET, p_data->sc_x,
			&p_data->mtx, p_data->cx, p_data->cy );

	TCB_Delete( tcb );
}

//----------------------------------------------------------------------------
/**
 *	@brief	AtBf[^ݒ֐
 *
 *	@param	p_bgl		BGL
 *	@param	frame		t[
 *	@param	scale_x		gkx
 *	@param	scale_y		gky
 *	@param	rota		]
 *	@param	cx			SX@ihbgPʁj
 *	@param	cy			SY@ihbgPʁj
 *	@param	sc_x		XN[W
 *	@param	sc_y		XN[W
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_BG_SetAffineMtx( ENC_BG_SET_AFFINEPARAM* p_work, GF_BGL_INI* p_bgl, u32 frame, fx32 scale_x, fx32 scale_y, u16 rota, int cx, int cy, int sc_x )
{
	
	MTX_Identity22( &p_work->mtx );

	// g]s쐬
	MTX_Rot22( &p_work->mtx, FX_SinIdx( rota ), FX_CosIdx( rota ) );
	MTX_ScaleApply22( &p_work->mtx, &p_work->mtx, FX_Div( FX32_ONE, scale_x ), FX_Div( FX32_ONE, scale_y ) );

	p_work->p_bgl	= p_bgl;
	p_work->frame	= frame;
	p_work->cx		= cx;
	p_work->cy		= cy;
	p_work->sc_x	= sc_x;
	VWaitTCB_Add( ENC_BG_SetAffineMtxTcb, p_work, ENC_BG_SET_AFFINE_MTX_PRI );
}


//-----------------------------------------------------------------------------
/**
 *
 *		OAMݒ֘A
 *
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	ZAN^[ZbgȂǍ쐬
 *
 *	@param	p_sys		[N
 *	@param	work_num	[N
 *	@param	res_num		\[X
 */
//-----------------------------------------------------------------------------
void ENC_CLACT_Init( ENC_CLACT_SYS* p_sys, int work_num, int res_num )
{
	int i;
	
	// ZAN^[Zbg쐬
	p_sys->cas = CLACT_U_SetEasyInit( work_num, &p_sys->renddata, HEAPID_FIELD );

	// \[X}l[W쐬
	for( i=0; i<4; i++ ){
		p_sys->resMan[i] = CLACT_U_ResManagerInit( res_num, i, HEAPID_FIELD );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	VXej
 *
 *	@param	p_sys	VXe[N
 */
//-----------------------------------------------------------------------------
void ENC_CLACT_Delete( ENC_CLACT_SYS* p_sys )
{
	int i;
	
	CLACT_DestSet( p_sys->cas );
	
	for( i=0; i<4; i++ ){
		CLACT_U_ResManagerDelete( p_sys->resMan[i] );
	}
}


//----------------------------------------------------------------------------
/**
 *	@brief	Pȃ\[Xǂݍ
 *
 *	@param	p_sys		ǗVXe
 *	@param	p_work		f[^i[
 *	@param	pltt_idx	pbg
 *	@param	pltt_num	pbgǂݍݐ
 *	@param	char_idx	LN^
 *	@param	cel_idx		Z
 *	@param	anm_idx		Aj
 *	@param	cont_id		ǗID
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_CLACT_ResLoadEasy( ENC_CLACT_SYS* p_sys, ENC_CLACT_RES_WORK* p_work, u32 pltt_idx, u32 pltt_num, u32 char_idx, u32 cel_idx, u32 anm_idx, u32 cont_id )
{
	// LN^
	p_work->resobj[0] = CLACT_U_ResManagerResAddArcChar_AllocType( p_sys->resMan[0],
			ARC_ENCOUNTEFFECT, char_idx, FALSE, cont_id,
			NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_FIELD, ALLOC_BOTTOM );

	// pbg
	p_work->resobj[1] = CLACT_U_ResManagerResAddArcPltt( p_sys->resMan[1],
			ARC_ENCOUNTEFFECT, pltt_idx, FALSE, cont_id,
			NNS_G2D_VRAM_TYPE_2DMAIN, pltt_num, HEAPID_FIELD );

	// Z
	p_work->resobj[2] = CLACT_U_ResManagerResAddArcKindCell( p_sys->resMan[2],
			ARC_ENCOUNTEFFECT, cel_idx, FALSE, cont_id,
			CLACT_U_CELL_RES, HEAPID_FIELD );

	// Aj
	p_work->resobj[3] = CLACT_U_ResManagerResAddArcKindCell( p_sys->resMan[3],
			ARC_ENCOUNTEFFECT, anm_idx, FALSE, cont_id,
			CLACT_U_CELLANM_RES, HEAPID_FIELD );


	// Vram]
	CLACT_U_CharManagerSetAreaCont( p_work->resobj[0] );	
	CLACT_U_ResManagerResOnlyDelete( p_work->resobj[0] );
	CLACT_U_PlttManagerSetCleanArea( p_work->resobj[1] );	
//	CLACT_U_ResManagerResOnlyDelete( p_work->resobj[1] );
//	pbg͔jȂArŃpbgύX邱Ƃ邽

	// wb_[쐬
	CLACT_U_MakeHeader( &p_work->head,
			cont_id, cont_id, cont_id, cont_id,
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
			0, 0,
			p_sys->resMan[0], p_sys->resMan[1], 
			p_sys->resMan[2], p_sys->resMan[3], NULL, NULL );
}

//----------------------------------------------------------------------------
/**
 *	@brief	P\[Xj
 *
 *	@param	p_sys	VXe[N
 *	@param	p_work	[N
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_CLACT_ResDeleteEasy( ENC_CLACT_SYS* p_sys, ENC_CLACT_RES_WORK* p_work )
{
	int i;
	CLACT_U_CharManagerDelete( p_work->resobj[0] );
	CLACT_U_PlttManagerDelete( p_work->resobj[1] );

	// \[XSj
	for( i=0; i<4; i++ ){
		CLACT_U_ResManagerResDelete( p_sys->resMan[i], p_work->resobj[i] );
	}
}

//----------------------------------------------------------------------------
/**
 *	@brief	J[pbgύX
 *
 *	@param	clact		ZAN^[[N
 *	@param	p_work		[N
 */
//-----------------------------------------------------------------------------
void ENC_CLACT_ResColorChange( CLACT_WORK_PTR clact, u32 heap, u32 tr_type, u8 evy, u16 next_rgb )
{
	SOFT_SPRITE_ARC ssa;
	NNSG2dPaletteData* p_pltt;
	void* p_pltt_buff;
	u16* dest;

	TrTypeGraArcDataGet( &ssa, tr_type );

	// f[^쐬
	dest = sys_AllocMemory( heap, 32 );

	// LN^ƃpbg擾
	p_pltt_buff = ArcUtil_PalDataGet( ssa.arc_no, ssa.index_pal, &p_pltt, heap );

	SoftFade( p_pltt->pRawData, dest, 16, evy, next_rgb );

	// pbg]
	ENC_OAM_TransOamPltt( clact, dest, 32 );

	sys_FreeMemoryEz( dest );
	sys_FreeMemoryEz( p_pltt_buff );
}


//----------------------------------------------------------------------------
/**
 *	@brief	AN^[o^
 *
 *	@param	p_sys		VXe[N
 *	@param	p_work		\[X[N
 *	@param	x			W
 *	@param	y			W
 *	@param	z			W
 *	@param	pri			D揇
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
CLACT_WORK_PTR ENC_CLACT_Add( ENC_CLACT_SYS* p_sys, ENC_CLACT_RES_WORK* p_work, fx32 x, fx32 y, fx32 z, int pri )
{
	CLACT_ADD_SIMPLE add;
	CLACT_WORK_PTR act;

	add.ClActSet	= p_sys->cas;
	add.ClActHeader	= &p_work->head;
	add.mat.x		= x;
	add.mat.y		= y;
	add.mat.z		= z;
	add.pri			= pri;
	add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
	add.heap		= HEAPID_FIELD;

	act = CLACT_AddSimple( &add );
	GF_ASSERT( act );
	return act;
} 

//----------------------------------------------------------------------------
/**
 *	@brief	xNg쐬
 *
 *	@param	x	l
 *	@param	y	l
 *	@param	z	l
 *
 *	@return	xNg
 */
//-----------------------------------------------------------------------------
VecFx32 ENC_MakeVec( fx32 x, fx32 y, fx32 z )
{
	VecFx32 vec;
	vec.x = x;
	vec.y = y;
	vec.z = z;
	return vec;
}

//----------------------------------------------------------------------------
/**
 *	@brief	OAM̃LN^ƃpbgg[i[̎҂ɂ
 *
 *	@param	clact		Zf[^
 *	@param	heap		q[v
 *	@param	tr_type		g[i[^Cv
 *
 *	@param ofs_cx		؂XLN^ItZbgl
 */
//-----------------------------------------------------------------------------
void ENC_CLACT_ResSetSoftSpriteDataTrOam( CLACT_WORK_PTR clact, u32 heap, u32 tr_type, u8 evy, u16 next_rgb, u32 ofs_cx )
{
	SOFT_SPRITE_ARC ssa;
	void* p_char;
	NNSG2dCharacterData* p_chardata;
	u32* p_charbuff; 
	u32 size;
		
	TrTypeGraArcDataGet( &ssa, tr_type );

	// LN^ƃpbg擾
	p_char = ArcUtil_CharDataGet( ssa.arc_no, ssa.index_chr, FALSE, &p_chardata, heap );

	// 
	SoftSpriteChrMask( (u8*)p_chardata->pRawData );

	// pbg͂̏ōs
	ENC_CLACT_ResColorChange( clact, heap, tr_type, evy, next_rgb );
	
	// OAMpLN^f[^
	p_charbuff = ENC_OAM_TrCharMake( p_chardata, heap, &size, ofs_cx );

	// LN^]
	ENC_OAM_TransOamChar( clact, p_charbuff, size );

	sys_FreeMemoryEz( p_charbuff );
	sys_FreeMemoryEz( p_char );
}

//----------------------------------------------------------------------------
/**
 *	@brief	JbgpOAMLN^̐
 *
 *	@param	p_chardata		\tgEFAXvCgpLN^f[^
 *	@param	heap			q[v
 *	@param	ofs_cx			ꂾ炵Ƃ납甲o
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void* ENC_OAM_TrCharMake( const NNSG2dCharacterData* cp_chardata, u32 heap, u32* p_size, u32 ofs_cx )
{
	u32 * p_charbuff;
	int i, j;
	int char_idx;
	int raw_char_idx;
	const u32 * cp_char_raw = cp_chardata->pRawData; 

	p_charbuff = sys_AllocMemory( heap, ENC_OAM_TR_CHAR_BUFF_SIZE );


	for( i=0; i<ENC_OAM_TR_CHAR_SIZE_Y; i++ ){
		raw_char_idx = ((i+ENC_OAM_TR_CHAR_CUT_Y) * cp_chardata->W );
		char_idx = ((i/8)*ENC_OAM_TR_CHAR_ONELINE) + (i%8);

		for( j=0; j<ENC_OAM_TR_CHAR_SIZE_X / 8; j++ ){
			p_charbuff[ char_idx + (j*8) ] = cp_char_raw[ raw_char_idx + j + ofs_cx ];
		}
	}

	*p_size = ENC_OAM_TR_CHAR_BUFF_SIZE;

	return p_charbuff;
}

//----------------------------------------------------------------------------
/**
 *	@brief		OAM̃pbgē]
 *
 */
//-----------------------------------------------------------------------------
static void ENC_OAM_TransOamPltt( CLACT_WORK_PTR clact, void* data, u32 size )
{
	NNSG2dImagePaletteProxy * pltt;

	pltt = CLACT_PaletteProxyGet( clact );
	DC_FlushRange( data, size );
	GX_LoadOBJPltt( 
			data,
			NNS_G2dGetImagePaletteLocation( pltt, NNS_G2D_VRAM_TYPE_2DMAIN ),
			size );
}

//----------------------------------------------------------------------------
/**
 *	@brief		LN^f[^ē]
 */
//-----------------------------------------------------------------------------
static void ENC_OAM_TransOamChar( CLACT_WORK_PTR clact, void* data, u32 size )
{
	NNSG2dImageProxy * p_char;

	p_char = CLACT_ImageProxyGet( clact );
	DC_FlushRange( data, size );
	GX_LoadOBJ( 
			data,
			NNS_G2dGetImageLocation( p_char, NNS_G2D_VRAM_TYPE_2DMAIN ),
			size );
}

//----------------------------------------------------------------------------
/**
 *		yrbg}bvEBhEhԂIuWFNgz
 *	@brief	[N̊m
 *
 *	@param	heapID	q[vID
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
ENC_BMP_FILL_OBJ* ENC_BMP_FillObjAlloc( u32 heapID )
{
	ENC_BMP_FILL_OBJ* p_work;

	p_work = sys_AllocMemory( heapID, sizeof(ENC_BMP_FILL_OBJ) );
	memset( p_work, 0, sizeof(ENC_BMP_FILL_OBJ) );
	return p_work;
}

//----------------------------------------------------------------------------
/**
 *		yrbg}bvEBhEhԂIuWFNgz
 *	@brief	[Nj
 *
 *	@param	p_work	[N
 */
//-----------------------------------------------------------------------------
void ENC_BMP_FillObjDelete( ENC_BMP_FILL_OBJ* p_work )
{
	sys_FreeMemoryEz( p_work );
}

//----------------------------------------------------------------------------
/**
 *		yrbg}bvEBhEhԂIuWFNgz
 *	@brief	Jn
 *
 *	@param	p_work		[N
 *	@param	s_x			hԂJnW
 *	@param	e_x			hԂIW
 *	@param	s_y			hԂJnW
 *	@param	e_y			hԂIW
 *	@param	sync		VN
 *	@param	p_bmp		rbg}bv
 *	@param	width		
 *	@param	height		
 *	@param	col			hԂpbgԍ
 */
//-----------------------------------------------------------------------------
void ENC_BMP_FillObjStart( ENC_BMP_FILL_OBJ* p_work, int s_x, int e_x, int s_y, int e_y, int sync, GF_BGL_BMPWIN* p_bmp, u32 width, u32 height, u8 col )
{
	GF_ASSERT( p_work->move_flg == FALSE );

	// p[^
	ENC_MoveReq( &p_work->move_x, s_x, e_x, sync );
	ENC_MoveReq( &p_work->move_y, s_y, e_y, sync );

	// ̑p[^
	p_work->p_bmp	= p_bmp;	// hԂrbg}bv
	p_work->width	= width;	// hԂ
	p_work->height	= height;	// hԂ
	p_work->col		= col;		// hԂJ[ԍ

	p_work->move_flg = TRUE;
}

//----------------------------------------------------------------------------
/**
 *		yrbg}bvEBhEhԂIuWFNgz
 *	@brief	C
 *
 *	@param	p_work	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ENC_BMP_FillObjMain( ENC_BMP_FILL_OBJ* p_work )
{
	BOOL result;
	s16 top, bottom, left, right;
	if( p_work->move_flg == FALSE ){
		return TRUE;
	}
	
	result = ENC_MoveMain( &p_work->move_x );
	ENC_MoveMain( &p_work->move_y );

	left = p_work->move_x.x - (p_work->width/2);
	top = p_work->move_y.x - (p_work->height/2);
	right = left + p_work->width;
	bottom = top + p_work->height;

	// rbg}bvhԂ
	ENC_BMP_Fill( p_work->p_bmp, top, bottom, left, right, p_work->col );

	return result;
}


//----------------------------------------------------------------------------
/**
 *		yrbg}bvubNhԂIuWFNgz
 *	@brief	[N̊m
 *
 *	@param	heapID	q[vID
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
ENC_BMP_FILL_BLOCK* ENC_BMP_FillBlockAlloc( u32 heapID )
{
	ENC_BMP_FILL_BLOCK* p_work;

	p_work = sys_AllocMemory( heapID, sizeof(ENC_BMP_FILL_BLOCK) );
	memset( p_work, 0, sizeof(ENC_BMP_FILL_BLOCK) );
	return p_work;
}

//----------------------------------------------------------------------------
/**
 *		yrbg}bvubNhԂIuWFNgz
 *	@brief	[Nj
 *
 *	@param	p_work	[N
 */
//-----------------------------------------------------------------------------
void ENC_BMP_FillBlockDelete( ENC_BMP_FILL_BLOCK* p_work )
{
	sys_FreeMemoryEz( p_work );
}

//----------------------------------------------------------------------------
/**
 *		yrbg}bvubNhԂIuWFNgz
 *	@brief	Jn
 *
 *	@param	p_work		[N
 *	@param	s_x			hԂJnW
 *	@param	e_x			hԂIW
 *	@param	s_y			hԂJnW
 *	@param	e_y			hԂIW
 *	@param	sync		VN
 *	@param	p_bmp		rbg}bv
 *	@param	width		
 *	@param	height		
 *	@param	col			hԂpbgԍ
 */
//-----------------------------------------------------------------------------
void ENC_BMP_FillBlockStart( ENC_BMP_FILL_BLOCK* p_work, int s_x, int e_x, int s_y, int e_y, int sync, GF_BGL_BMPWIN* p_bmp, u32 width, u32 height, u8 col )
{
	GF_ASSERT( p_work->move_flg == FALSE );

	// p[^
	ENC_MoveReq( &p_work->move_x, s_x, e_x, sync );
	ENC_MoveReq( &p_work->move_y, s_y, e_y, sync );

	// ̑p[^
	p_work->p_bmp	= p_bmp;	// hԂrbg}bv
	p_work->width	= width;	// hԂ
	p_work->height	= height;	// hԂ
	p_work->col		= col;		// hԂJ[ԍ

	p_work->move_flg = TRUE;
}

//----------------------------------------------------------------------------
/**
 *		yrbg}bvubNhԂIuWFNgz
 *	@brief	C
 *
 *	@param	p_work	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ENC_BMP_FillBlockMain( ENC_BMP_FILL_BLOCK* p_work )
{
	BOOL result;
	s16 top, bottom, left, right;
	if( p_work->move_flg == FALSE ){
		return TRUE;
	}

	// 1O
	left = p_work->move_x.x - (p_work->width/2);
	top = p_work->move_y.x - (p_work->height/2);
	right = left + p_work->width;
	bottom = top + p_work->height;
	ENC_BMP_Fill( p_work->p_bmp, top, bottom, left, right, 0 );
	
	result = ENC_MoveMain( &p_work->move_x );
	ENC_MoveMain( &p_work->move_y );

	left = p_work->move_x.x - (p_work->width/2);
	top = p_work->move_y.x - (p_work->height/2);
	right = left + p_work->width;
	bottom = top + p_work->height;

	ENC_BMP_Fill( p_work->p_bmp, top, bottom, left, right, p_work->col );

	return result;
}

//----------------------------------------------------------------------------
/**
 *	@brief	rbg}bvEBhEhԂ@`
 *
 *	@param	p_bmp		[N
 *	@param	top			
 *	@param	bottom		
 *	@param	left		
 *	@param	right		E
 *	@param	col			J[ԍ
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void ENC_BMP_Fill( GF_BGL_BMPWIN* p_bmp, s32 top, s32 bottom, s32 left, s32 right, u8 col )
{
	// ʊO`FbN
	if( (right <= 0) || (bottom <= 0) ){
		return ;
	}

	// ꏏȂ`悵Ȃ
	if( (left == right) || (top == bottom) ){
		return ;
	}
	
	if( left < 0 ){
		left = 0;
	}
	if( right > 256 ){
		right = 256;
	}
	if( top < 0 ){
		top = 0;
	}
	if( bottom > 256 ){
		bottom = 256;
	}

	// rbg}bvhԂ
	GF_BGL_BmpWinFill( p_bmp, col,
			left,
			top,
			right - left,
			bottom - top );
}


//----------------------------------------------------------------------------
/**
 *	@brief	[Nm
 *
 *	@param	heapID	q[v
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
ENC_BMP_FILL_BLOCK_MOVE* ENC_BMP_FillBlockMoveAlloc( u32 heapID )
{
	ENC_BMP_FILL_BLOCK_MOVE* p_work;
	int i;

	p_work = sys_AllocMemory( HEAPID_FIELD, sizeof(ENC_BMP_FILL_BLOCK_MOVE) );
	memset( p_work, 0, sizeof(ENC_BMP_FILL_BLOCK_MOVE) );

	// IuWFNg쐬
	for( i=0; i<ENCOUNT_BLOCK_MOVE_OBJNUM; i++ ){
		p_work->p_block[i] = ENC_BMP_FillBlockAlloc( heapID );
	}
	return p_work;
}

//----------------------------------------------------------------------------
/**
 *	@brief	[Nj
 *
 *	@param	p_work	[N
 */
//-----------------------------------------------------------------------------
void ENC_BMP_FillBlockMoveDelete( ENC_BMP_FILL_BLOCK_MOVE* p_work )
{
	int i;
	
	// ubNIuWFj
	for( i=0; i<ENCOUNT_BLOCK_MOVE_OBJNUM; i++ ){
		ENC_BMP_FillBlockDelete( p_work->p_block[i] );
	}
	sys_FreeMemoryEz( p_work );
}

//----------------------------------------------------------------------------
/**
 *	@brief	Jn
 *	
 *	@param	p_work	[N
 *	@param	sync	P̃IuWFVN
 *	@param	start	P̃IuWF˃^C~O
 *	@param	p_bmp	rbg}bv
 *	@param	col		J[
 */
//-----------------------------------------------------------------------------
void ENC_BMP_FillBlockMoveStart( ENC_BMP_FILL_BLOCK_MOVE* p_work, u8 sync, u8 start, GF_BGL_BMPWIN* p_bmp, u8 col )
{
	p_work->p_bmp		= p_bmp;
	p_work->col			= col;
	p_work->move_sync	= sync;
	p_work->start_sync	= start;
	p_work->block_count = 0;
	p_work->block_end_count = 0;
	p_work->wait		= 0;
	p_work->init_flg	= 1;
}

//----------------------------------------------------------------------------
/**
 *	@brief	C֐
 *
 *	@param	p_work	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ENC_BMP_FillBlockMoveMain( ENC_BMP_FILL_BLOCK_MOVE* p_work )
{
	int x, s_y, e_y;
	int i;
	BOOL result;
	
	if( p_work->init_flg == 0 ){
		return TRUE;
	}
	
	// ˕
	if( p_work->block_count < ENCOUNT_BLOCK_MOVE_OBJNUM ){
		p_work->wait --;
		if( p_work->wait <= 0 ){
			p_work->wait = p_work->start_sync;

			x = ENCOUNT_BLOCK_MOVE_MoveParam[ p_work->block_count % ENCOUNT_BLOCK_MOVE_X_NUM ];
			x = (ENCOUNT_BLOCK_MOVE_WIDTH/2) + (x * ENCOUNT_BLOCK_MOVE_WIDTH);
			s_y = ENCOUNT_BLOCK_MOVE_MAT_Y - ((p_work->block_count/ENCOUNT_BLOCK_MOVE_X_NUM) * ENCOUNT_BLOCK_MOVE_HEIGHT);
			e_y = ENCOUNT_BLOCK_MOVE_MOVE_Y - ((p_work->block_count/ENCOUNT_BLOCK_MOVE_X_NUM) * ENCOUNT_BLOCK_MOVE_HEIGHT);
			// 
			ENC_BMP_FillBlockStart( 
					p_work->p_block[ p_work->block_count ],
					x, x,
					s_y, e_y,
					p_work->move_sync, p_work->p_bmp,
					ENCOUNT_BLOCK_MOVE_WIDTH, ENCOUNT_BLOCK_MOVE_HEIGHT,
					p_work->col );

			p_work->block_count ++;
		}
	}
	

	// 
	for( i=p_work->block_end_count; i<p_work->block_count; i++ ){
		result = ENC_BMP_FillBlockMain( p_work->p_block[i] );
		if( result == TRUE ){
			p_work->block_end_count++;
		}
	}

	// SI`FbN
	if( (p_work->block_end_count >= ENCOUNT_BLOCK_MOVE_OBJNUM) &&
		(result == TRUE) ){
		p_work->init_flg = FALSE;
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *		y~`@BMP@hԂIuWFz
 *	@brief	[Nm
 *
 *	@param	heapID	q[vID
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
ENC_BMP_CIRCLE_FILL* ENC_BMP_CircleFillAlloc( u32 heapID )
{
	ENC_BMP_CIRCLE_FILL* p_work;

	p_work = sys_AllocMemory( heapID, sizeof(ENC_BMP_CIRCLE_FILL) );
	memset( p_work, 0, sizeof(ENC_BMP_CIRCLE_FILL) );
	return p_work;
}

//----------------------------------------------------------------------------
/**
 *		y~`@BMP@hԂIuWFz
 *	@brief	[Nj
 *
 *	@param	p_work	[N
 */
//-----------------------------------------------------------------------------
void ENC_BMP_CircleFillDelete( ENC_BMP_CIRCLE_FILL* p_work )
{
	sys_FreeMemoryEz( p_work );
}

//----------------------------------------------------------------------------
/**
 *		y~`@BMP@hԂIuWFz
 *	@brief	GtFNgJn
 *
 *	@param	p_work	[N
 *	@param	sync	VN
 *	@param	s_rota	Jn]p		(]ĔΑ쐬邽 0`179̊px)
 *	@param	e_rota	I]p		(]ĔΑ쐬邽 0`179̊px)
 *	@param	p_bmp	rbg}bv
 *	@param	col		hԂJ[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_BMP_CircleFillStart( ENC_BMP_CIRCLE_FILL* p_work, u8 sync, u16 s_rota, u16 e_rota, GF_BGL_BMPWIN* p_bmp, u8 col )
{
	p_work->p_bmp		= p_bmp;
	p_work->col			= col;
	p_work->move_flg	= 1;
	ENC_MoveReq( &p_work->rota, s_rota, e_rota, sync );
}

//----------------------------------------------------------------------------
/**
 *		y~`@BMP@hԂIuWFz
 *	@brief	C֐
 *
 *	@param	p_work	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ENC_BMP_CircleFillMain( ENC_BMP_CIRCLE_FILL* p_work )
{
	BOOL result;
	u16 last_rota;
	
	if( p_work->move_flg == 0 ){
		return TRUE;
	}

	// O̊px
	last_rota = p_work->rota.x;

	// s
	result = ENC_MoveMain( &p_work->rota );

	// `揈
	EncBmpCircleFill_Fill( p_work->p_bmp, last_rota, p_work->rota.x, p_work->col );	

	if( result == TRUE ){
		p_work->move_flg = 0;
		return TRUE;
	}
	return FALSE;
}

// ^WFgvZ
static inline fx32 getTanX( u16 rota )
{
	return FX_Div(FX_SinIdx(rota), FX_CosIdx(rota));
}

//----------------------------------------------------------------------------
/**
 *		y~`@BMP@hԂIuWFz
 *	@brief	~`@rbg}bvhԂ@
 *
 *	@param	p_bmp		rbg}bvEBhE
 *	@param	last_rota	O̊px
 *	@param	now_rota	̊px
 *	@param	col			J[
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
static void EncBmpCircleFill_Fill( GF_BGL_BMPWIN* p_bmp, u16 last_rota, u16 now_rota, u8 col )
{
	int now_x, last_x, tmp;
	int re_now_x, re_last_x;	// tbv
	int i;
	int y;
	fx32 now_tan_x, last_tan_x;

	// ^WFgl߂
	now_tan_x = getTanX( now_rota );
	last_tan_x = getTanX( last_rota );

	// ełXW߂̒lœhԂ
	for( i=0; i<96; i++ ){

		y = 95 - i;

		now_x = FX_Mul( now_tan_x, y*FX32_ONE ) >> FX32_SHIFT;
		last_x = FX_Mul( last_tan_x, y*FX32_ONE ) >> FX32_SHIFT;

		// SW̒lɂ
		re_now_x = 128 + now_x;
		re_last_x = 128 + last_x;
		now_x = 128 - now_x;
		last_x = 128 - last_x;

		//@傤𐮂
		if( last_x > now_x ){
			tmp = last_x;
			last_x = now_x;
			now_x = tmp;
		}
		if( re_last_x > re_now_x ){
			tmp = re_last_x;
			re_last_x = re_now_x;
			re_now_x = tmp;
		}

//		OS_Printf( "left %d right %d now_rota %d last_rota %d\n", last_x, now_x, now_rota / 182, last_rota / 182 );

		
		
		ENC_BMP_Fill( p_bmp, i, i+1, last_x, now_x+1, col );
		ENC_BMP_Fill( p_bmp, 191 - i, 192 - i, re_last_x, re_now_x+1, col );
	}
}


//----------------------------------------------------------------------------
/**
 *		ytbVAEgz
 *	@brief	[Nm
 *	
 *	@param	heapID	q[vID
 *
 *	@return	[N
 */
//-----------------------------------------------------------------------------
ENC_BMP_FLASH_OUT* ENC_BMP_FlashOutAlloc( u32 heapID )
{
	ENC_BMP_FLASH_OUT* p_work;
	int i;

	p_work = sys_AllocMemory( heapID, sizeof(ENC_BMP_FLASH_OUT) );
	memset( p_work, 0, sizeof(ENC_BMP_FLASH_OUT) );
	
	for( i=0; i<ENC_BMP_FLASH_CIRCLE_NUM; i++ ){
		p_work->p_circle[i] =  ENC_BMP_CircleFillAlloc( heapID );
	}
	
	return p_work;
}

//----------------------------------------------------------------------------
/**
 *		ytbVAEgz
 *	@brief	[Nj
 *
 *	@param	p_work [N
 */
//-----------------------------------------------------------------------------
void ENC_BMP_FlashOutDelete( ENC_BMP_FLASH_OUT* p_work )
{
	int i;

	for( i=0; i<ENC_BMP_FLASH_CIRCLE_NUM; i++ ){
		ENC_BMP_CircleFillDelete( p_work->p_circle[i] );
	}
	sys_FreeMemoryEz( p_work );
}

//----------------------------------------------------------------------------
/**
 *		ytbVAEgz
 *	@brief	GtFNgJn
 *
 *	@param	p_work	[N
 *	@param	sync	VN
 *	@param	p_bmp	rbg}bv
 *	@param	col		hԂJ[ԍ
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_BMP_FlashOutStart( ENC_BMP_FLASH_OUT* p_work, u8 sync, GF_BGL_BMPWIN* p_bmp, u8 col )
{
	int i;

	// hԂIuWFNg
	for( i=0; i<ENC_BMP_FLASH_CIRCLE_NUM; i++ ){
		ENC_BMP_CircleFillStart( p_work->p_circle[i],
				sync, 
				FX_GET_ROTA_NUM( FlashOutParam[i][0] ), 
				FX_GET_ROTA_NUM( FlashOutParam[i][1] ), 
				p_bmp,
				col );
	}
	p_work->move_flg = 1;

	// ŏ93  99hbghԂ
	ENC_BMP_Fill( p_bmp, 93, 99, 0, 256, col );
}

//----------------------------------------------------------------------------
/**
 *		ytbVAEgz
 *	@brief	tbVAEgC
 *
 *	@param	p_work	[N
 *
 *	@retval	TRUE	I
 *	@retval	FALSE	r
 */
//-----------------------------------------------------------------------------
BOOL ENC_BMP_FlashOutMain( ENC_BMP_FLASH_OUT* p_work )
{
	int i;
	BOOL result;
	
	if( p_work->move_flg == 0 ){
		return TRUE;
	}

	for( i=0; i<ENC_BMP_FLASH_CIRCLE_NUM; i++ ){
		result = ENC_BMP_CircleFillMain( p_work->p_circle[i] );
	}

	if( result == TRUE ){
		p_work->move_flg = 0;
		return TRUE;
	}
	return FALSE;
}



//----------------------------------------------------------------------------
/**
 *	yWOUOEBhEz
 *	@brief	EBhE
 */
//-----------------------------------------------------------------------------
ENC_HB_BG_WND_ZIGUZAGU* ENC_BG_WndZiguzagu_Alloc( void )
{
	ENC_HB_BG_WND_ZIGUZAGU* p_work;

	p_work = sys_AllocMemory( HEAPID_FIELD, sizeof(ENC_HB_BG_WND_ZIGUZAGU) );
	memset( p_work, 0, sizeof(ENC_HB_BG_WND_ZIGUZAGU) );

	return p_work;
}

//----------------------------------------------------------------------------
/**
 *	yWOUOEBhEz
 *	@brief	[N̔j
 *
 *	@param	p_work 
 */
//-----------------------------------------------------------------------------
void ENC_BG_WndZiguzagu_Delete( ENC_HB_BG_WND_ZIGUZAGU* p_work )
{
	if( p_work->tcb != NULL ){
		ENC_BG_WndZiguzagu_End( p_work );	
	}
	sys_FreeMemoryEz( p_work );
}

//----------------------------------------------------------------------------
/**
 *	yWOUOEBhEz
 *	@brief	֐Jn
 *
 *	@param	p_ew		GJEgGtFNg[N
 *	@param	p_eff		GtFNg[N
 *	@param	sync		VN
 *	@param	dot			E؂ւhbg
 *	@param	width		E
 *	@param	wnd_msgk_in		EBhE}XN	
 *	@param	wnd_msgk_out	EBhE}XN	O
 */
//-----------------------------------------------------------------------------
void ENC_BG_WndZiguzagu_Start( ENCOUNT_EFFECT_WORK* p_ew, ENC_HB_BG_WND_ZIGUZAGU* p_eff, u32 sync, u32 dot, u32 width, u32 wnd_msk_in, u32 wnd_msk_out )
{
	int i;
	int count;
	int set_w;
	
	// Jnς
	GF_ASSERT( p_eff->tcb == NULL );

	p_ew->hblank_flg	= FALSE;
	p_eff->p_hsys		= p_ew->fsw->fldmap->hblanksys;
	p_eff->seq			= 0;
	p_eff->end_check	= &p_ew->hblank_flg;
	ENC_MoveReq( &p_eff->move_x, ENC_BG_WND_ZIGUZAGU_MOVE_S, ENC_BG_WND_ZIGUZAGU_MOVE_E, sync );
	
	// WOUO쐬
	for( i=0; i<192; i++ ){
		// ݒ蕝߂
		count = i % dot;
		set_w = count * width;
		set_w = set_w / dot;

		// WOUOɐݒ
		if( ((i/dot) % 2) == 0 ){
			p_eff->ziguzagu_buf[ i ] = set_w;
		}else{
			p_eff->ziguzagu_buf[ i ] = width - set_w;
		}
	}

	// EBhE}XNݒ
	G2_SetWnd0InsidePlane( wnd_msk_in, TRUE );
	G2_SetWndOutsidePlane( wnd_msk_out, FALSE );	
	G2_SetWnd0Position( 0, 0, 0, 192 );
	GX_SetVisibleWnd( GX_WNDMASK_W0 );

	// ^XN
	VWaitTCB_Add( ENC_BG_WndZiguzagu_SetUp_Tcb, p_eff, END_HB_BG_WND_ZIGUZAGU_INIT_TCB_PRI );
}

//----------------------------------------------------------------------------
/**
 *	yWOUOEBhEz
 *	@brief	WOUO^XN
 */
//-----------------------------------------------------------------------------
static void ENC_BG_WndZiguzagu_SetUp_Tcb( TCB_PTR tcb, void* p_work )
{
	ENC_HB_BG_WND_ZIGUZAGU* p_eff = p_work;

	
	// HuN֐o^
	p_eff->p_hobj = FLDHBLANK_OBJ_Add( p_eff->p_hsys, ENC_BG_WndZiguzagu_HBlank, p_eff );

	
	p_eff->tcb = VWaitTCB_Add( ENC_BG_WndZiguzagu_Tcb, p_eff, END_HB_BG_WND_ZIGUZAGU_TCB_PRI );

	TCB_Delete( tcb );
}

//----------------------------------------------------------------------------
/**
 *	yWOUOEBhEz
 *	@brief	C^XN
 */
//-----------------------------------------------------------------------------
static void ENC_BG_WndZiguzagu_Tcb( TCB_PTR tcb, void* p_work )
{
	ENC_HB_BG_WND_ZIGUZAGU* p_eff = p_work;
	BOOL result;

	switch( p_eff->seq ){
	case 0:
		result = ENC_MoveMain( &p_eff->move_x );
		if( result == TRUE ){
			p_eff->seq++;
		}
		break;

	case 1:
		ENC_BG_WndZiguzagu_End( p_eff );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *	yWOUOEBhEz
 *	@brief	HuN֐
 */	
//-----------------------------------------------------------------------------
static void ENC_BG_WndZiguzagu_HBlank(FIELD_HBLANK_OBJ* p_hobj, void* p_work)
{
	ENC_HB_BG_WND_ZIGUZAGU* p_eff = p_work;
	int set_x;
	int v_count;		// VJEg

	// VJE^擾AO͈̎ړlvZ
	v_count = GX_GetVCount();
	
	if( v_count < 192 ){
		set_x = p_eff->ziguzagu_buf[v_count] + p_eff->move_x.x;
		if( set_x > 255 ){
			set_x = 255;
		}
		G2_SetWnd0Position( 0, 0, set_x, 192 );
	}
}

//----------------------------------------------------------------------------
/**
 *	yWOUOEBhEz
 *	@brief	I
 */
//-----------------------------------------------------------------------------
static void ENC_BG_WndZiguzagu_End( ENC_HB_BG_WND_ZIGUZAGU* p_work )
{
	// EBhE}XNj
	GX_SetVisibleWnd( GX_WNDMASK_NONE );
	
	*(p_work->end_check) = TRUE;
	FLDHBLANK_OBJ_Delete( p_work->p_hobj );
	p_work->p_hobj = NULL;
	TCB_Delete( p_work->tcb );
	p_work->tcb = NULL;
}




//----------------------------------------------------------------------------
/**
 *	@brief	GJEgGtFNgio[擾֐
 *
 *	@param	data	f[^
 *
 *	@return	GJEgGtFNgio[
 *
 *
 *	Ή
 *		ʐM@og^[
 *		_uog
 *		쐶
 *		g[i[
 *
 *	Ή
 *		g[i[
 *		|P
 */
//-----------------------------------------------------------------------------
#define ENCEFF_FIELD	(0)	// 쐶
#define ENCEFF_TRAINER	(1)	// TRAINER
#define ENCEFF_GRASS	(0)	// 
#define ENCEFF_WATER	(1)	// 
#define ENCEFF_DAN		(2)	// _W
u32 ENCEFF_GetEffectNo( const BATTLE_PARAM * p_battleparam )
{
	int lv;
	int area;
	int type;
	POKEMON_PARAM* p_my_poke;
	POKEMON_PARAM* p_enemy_poke;
	int mypoke_lev, enemypoke_lev;

	// og߂̂𕪊򂳂
	if( p_battleparam->fight_type & FIGHT_TYPE_TRAINER ){
		
		type = ENCEFF_TRAINER;
		
	}else if( (p_battleparam->fight_type & (FIGHT_TYPE_MOVE|FIGHT_TYPE_SAFARI|FIGHT_TYPE_POKE_PARK|FIGHT_TYPE_GET_DEMO)) ||
		(p_battleparam->fight_type == FIGHT_TYPE_YASEI) ){		// 쐶0Ȃ̂&ŎȂ߂
		
		type = ENCEFF_FIELD;
	}else{

		GF_ASSERT( 0 );	// ΉĂ܂B
		type = 0;
	}

	// tB[hi쐶j@g[i[̂Ƃ́Axƒn`
	// GtFNgς
	// x`FbN
	p_my_poke = EvPoke_GetLivingPokemonTop( p_battleparam->poke_party[CLIENT_NO_MINE] );
	p_enemy_poke = EvPoke_GetLivingPokemonTop( p_battleparam->poke_party[CLIENT_NO_ENEMY] );
	mypoke_lev = PokeParaGet( p_my_poke, ID_PARA_level, NULL );
	enemypoke_lev = PokeParaGet( p_enemy_poke, ID_PARA_level, NULL );
	lv = enemypoke_lev - mypoke_lev;
	
	// GA`FbN
	switch( p_battleparam->ground_id ){
	case GROUND_ID_GRAVEL:
	case GROUND_ID_SANDS:
	case GROUND_ID_LAWN:
	case GROUND_ID_POOL:
	case GROUND_ID_ROCK:
	case GROUND_ID_SNOW:
	case GROUND_ID_ICE:
	case GROUND_ID_BOG:
	case GROUND_ID_BRIDGE:
	case GROUND_ID_FLOOR:
	case GROUND_ID_ALL:
		area = ENCEFF_GRASS * 2;	// lowhi邩
		break;
	case GROUND_ID_WATER:
		area = ENCEFF_WATER * 2;	// lowhi邩
		break;
	case GROUND_ID_CAVE:
		area = ENCEFF_DAN * 2;	// lowhi邩
		break;
	}
	if( lv > 0 ){
		area ++;	// hiȂ̂
	}

	return (type*6) + area;
} 


//----------------------------------------------------------------------------
/**
 *	@brief	OAMʂEBhE`Őݒ@gk\
 *
 *	@param	y		S
 *	@param	scale	gkl
 *	@param	height@
 *	@param	bottom_yӂ܂ł̒	ӂ̔菬Ƃ邽
 *	@param	wndno	gpEBhE
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ENC_WND_SetScaleWnd( fx32 y, int bottom_y, fx32 scale, int height, int wndno, ENC_WND_SETPOSITION* p_work )
{
	int c_y;
	int set_height;

	c_y = (y>>FX32_SHIFT);

	set_height = FX_Mul( height*FX32_ONE, scale ) >> FX32_SHIFT;
	set_height /= 2;

	p_work->x1 = 0;
	p_work->x2 = 255;
	p_work->y1 = c_y - set_height;
	p_work->y2 = bottom_y;

	VWaitTCB_Add( ENC_WND_SetWndPositionVWait, p_work, ENC_SET_WND_SCALE_TCB_PRI );
}
//----------------------------------------------------------------------------
/**
 *	@brief	c[@g嗦̒ӂ̍߂
 *
 *	@param	scale			gkl
 *	@param	c_y				SYW
 *	@param	half_height		ӂւ̃TCY
 *
 *	@return		ӍW
 */
//-----------------------------------------------------------------------------
int ENC_WND_SetScaleWndToolMakeBottomY( fx32 scale, int c_y, int half_height )
{
	half_height = FX_Mul( half_height * FX32_ONE, scale ) >> FX32_SHIFT;

	return c_y + half_height;
}

//----------------------------------------------------------------------------
/**
 *	@brief	EBhE|WV@VuNݒ
 */
//-----------------------------------------------------------------------------
static void ENC_WND_SetWndPositionVWait( TCB_PTR tcb, void* p_work )
{
	ENC_WND_SETPOSITION* p_data = p_work;

	if( p_data->wnd_no == 0 ){
		// VuNԂɐݒ
		G2_SetWnd0Position( p_data->x1, p_data->y1, p_data->x2, p_data->y2  );
	}else{
		// VuNԂɐݒ
		G2_SetWnd1Position( p_data->x1, p_data->y1, p_data->x2, p_data->y2  );
	}

	TCB_Delete( tcb );
}


//----------------------------------------------------------------------------
/**
 *	@brief	VuNMasterPxݒ֐
 */
//-----------------------------------------------------------------------------
static void EncSetMstBrightnessSetVTcb( TCB_PTR tcb, void* p_work )
{
	int * p_data = p_work;
	GX_SetMasterBrightness( *p_data );
	TCB_Delete(tcb);
}

//----------------------------------------------------------------------------
/**
 *	@brief	VuNMasterPxݒ֐
 *	@param	p_setnum	ݒ萔Qƃ|C^
 */
//-----------------------------------------------------------------------------
void ENC_SetMasterBrightnessVblank( int* p_setnum )
{
	VWaitTCB_Add( EncSetMstBrightnessSetVTcb, p_setnum, ENC_SET_MSTBRI_TCB_PRI );	
}
