//============================================================================================
/**
 * @file	encount_set.c
 * @brief	GJEg֘A

 * @author	saitou
 *
 * 2005.12.18	field_encount.cGJEg蕔ړ
 */
//============================================================================================
#include "encount_set.h"
#include "syswork.h"
#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"
#include "eventdata.h"
#include "honey_tree_enc.h"

#include "field_encount.h"
#include "battle/tokusyu_def.h"

#include "system/pm_rtc.h"
#include "system/timezone.h"
#include "sysflag.h"
#include "system/zukanwork.h"
#include "debug_saito.h"

#include "situation_local.h"

#include "enc_tbl_change_def.h"
#include "arc/encdata_ex.naix"

#include "savedata/encount.h"
#include "move_pokemon_def.h"
#include "move_pokemon.h"
#include "encount_define.h"

#include "generate_zone.h"
#include "calendar_enc.h"
#include "sp_fishing_enc.h"

#include "weather_sys.h"
#include "fieldmap_work.h"
#include "field_fishing.h"
#include "ev_time.h"

#include "zonedata.h"

#include "battle/battle_server.h"	//for	FormChange
#include "ev_pokemon.h"
#include "itemtool/itemsym.h"		//for ITEM_KIYOMENOOHUDAEITEM_KIYOMENOOKOU
#include "savedata/vidro_type.h"

#include "safari_enc.h"
#include "agb_slot_enc.h"

#include "poketool/tr_tool.h"
#include "battle/trno_def.h"		//BTFIVȆ̂߂̎bȂ͂ by soga

//============================================================================================
//============================================================================================


#define	WALK_COUNT_GLOBAL	( 8 )		// GJEgȂ̊{l
#define	WALK_NEXT_PERCENT	( 5 )		// JEgsŎ̏ɐiފm
#define	NEXT_PERCENT	( 40 )		// GJEgɈڍs{m
#define CYCLE_PERCENT		( 30 )	//]ԂɏĂƂ̉Zm
#define LONG_GRASS_PERCENT		( 30 )	//̒ɂƂ̉Zm

#define	CALC_SHIFT			( 8 )		// vZVtgl

#define ENC_MONS_NUM_MAX	ENC_MONS_NUM_NORMAL

#define ROD_TYPE_NONE	(0xff)		//me[uw薳
#define WEATHER_NONE	(0xff)		//VCw薳

#ifdef PM_DEBUG

u8 DebugFishProbFlg = 0;

#endif

typedef struct SWAY_ENC_INFO_tag
{
	int Table;
	BOOL Decide;
	BOOL Rare;
	BOOL Enc;
}SWAY_ENC_INFO;

typedef struct ENC_COMMON_DATA_tag
{
	int MonsNo;
	u16 LvMax;
	u16 LvMin;
}ENC_COMMON_DATA;

typedef struct ENC_FLD_SPA_tag
{
	u32 TrainerID;			//g[i[hc
	BOOL SprayCheck;		//Xv[`FbN邩̃tO	TRUE:`FbN
	BOOL EncCancelSpInvalid;//퓬	TRUE:	FALSE:L		(ł́A܂E܂~cp)
	u8	 SpMyLv;			//Xv[`FbNɎgx
	u8	 Egg;				//^}StO
	u8	 Spa;				//
	u8   FormProb[2];		//V[EVEV[hSptHύXm@0FV[EV@1FV[hS
	u8	 AnnoonTblType;		//Am[e[u^Cv
}ENC_FLD_SPA;

static BOOL MapEncountCheck( FIELDSYS_WORK * fsys, const u32 map_encount, const u8 attr );
static u8 EncountAttributeCheck( FIELDSYS_WORK * fsys, u8 attr, u8 *outEncLocation );
static BOOL	EncountWalkCheck( FIELDSYS_WORK * fsys, u32 per );
static BOOL EncountCheckMain( FIELDSYS_WORK * fsys, u32 per );

static BOOL CheckFixTypeEcnt(	POKEMON_PARAM *inPokeParam,
							const ENC_FLD_SPA *inFldSpa,
							const ENC_COMMON_DATA *inData,
							const u8 inListNum,
							const u8 type, const u8 tokusei,u8 * outNo);
static BOOL CheckEcntCancelByLv( const ENC_FLD_SPA *inFldSpa, POKEMON_PARAM *inMyPokeParam, const u8 inEneLv);
static int GetEncountProbGround(FIELDSYS_WORK * fsys);
static int GetEncountProbWater(FIELDSYS_WORK * fsys);
static int GetEncountProbFishing(FIELDSYS_WORK * fsys, const FISHINGROD_TYPE inRodType);
static BOOL WildEncSingle(FIELDSYS_WORK * fsys,
							POKEMON_PARAM *poke_param,
							BATTLE_PARAM * param,
							ENCOUNT_DATA *data,
							ENC_COMMON_DATA *enc_data,
							const ENC_FLD_SPA *inFldSpa,
							const SWAY_ENC_INFO *inSwayEncInfo );
static BOOL WildEncDouble(	FIELDSYS_WORK * fsys,
							POKEMON_PARAM *poke_param,
							BATTLE_PARAM * param,
							ENC_COMMON_DATA *enc_data,
							const ENC_FLD_SPA *inFldSpa );
static BOOL WildWaterEncSingle(	FIELDSYS_WORK * fsys,
								POKEMON_PARAM *poke_param,
								BATTLE_PARAM * param,
								ENC_COMMON_DATA *enc_data,
								const ENC_FLD_SPA *inFldSpa );
static BOOL FishingEncSingle(	FIELDSYS_WORK * fsys,
								POKEMON_PARAM *poke_param,
								BATTLE_PARAM * battle_param,
								ENC_COMMON_DATA *inData,
								const ENC_FLD_SPA *inFldSpa,
								const FISHINGROD_TYPE inRodType );
static BOOL SetEncountData(	POKEMON_PARAM *param,
							const FISHINGROD_TYPE inRodType,
							const ENC_FLD_SPA *inFldSpa,
							const ENC_COMMON_DATA *inData,
							const u8 location,
							const int inTarget,
							BATTLE_PARAM *outBattleParam);
static BOOL SetSwayEncountData(	FIELDSYS_WORK * fsys,
								POKEMON_PARAM *param,
								const ENC_FLD_SPA *inFldSpa,
								const ENC_COMMON_DATA *inData,
								const int inTarget,
								BATTLE_PARAM *outBattleParam,
								const int inMonsNo, const int inLv);
static BOOL SetEncountDataDecideMons(	const int inMonsNo, const int inLv,
										const int inTarget,
										const BOOL inRare,
										const u32 inTrainerID,
										const ENC_FLD_SPA *inSpa,
										POKEMON_PARAM *param,
										BATTLE_PARAM *outBattleParam);

static u8 ChangeEncProb(	const BOOL IsFishing,
							const u8 inProb,
							const ENC_FLD_SPA *inFldSpa,
							const u32 inWeatherCode,
							POKEMON_PARAM *inPokeParam	);

static void SetFieldBattleParam(FIELDSYS_WORK * fsys, const BOOL inSafariFlg, BATTLE_PARAM **param);
static void SetSfariMonster(FIELDSYS_WORK * fsys, const BOOL inSafariFlg, const BOOL inBookGet, ENC_COMMON_DATA *enc_data);

static BOOL CheckSpray(const u8 inEneLv, const ENC_FLD_SPA *inSpa);
static void SetMovePokemon(const u32 inTrainerID, MPD_PTR mpd, BATTLE_PARAM *outBattleParam);
static BOOL CheckMovePokeEnc(FIELDSYS_WORK * fsys, MPD_PTR *outMpd);
static BOOL AddPokemonParam(const int inTarget, const ENC_FLD_SPA *inFldSpa,
							POKEMON_PARAM *ioPokeParam, BATTLE_PARAM *ioBattleParam );
static u8 GetMaxLvMonsTblNo(const ENC_COMMON_DATA *inEncCommonData, const ENC_FLD_SPA *inFldSpa, const u8 inTblNo);
static void SetSpaStruct(FIELDSYS_WORK *fsys, POKEMON_PARAM *inPokeParam, ENCOUNT_DATA* inData, ENC_FLD_SPA *outSpa  );
static void ChangeEncProbByEquipItem( POKEMON_PARAM *inMyPokeParam, u8 *ioPer );
static void ChangeEncProbByVidro( FIELDSYS_WORK *fsys, u8 *ioPer );

typedef struct ANNOON_TABLE_tag
{
	int Num;
	const u8 *Tbl;
}ANNOON_TABLE;

static const u8 Tbl1[] = {
	UNK_A, UNK_B, UNK_C, UNK_G, UNK_H,
	UNK_J, UNK_K, UNK_L, UNK_M, UNK_O,
	UNK_P, UNK_Q, UNK_S, UNK_T, UNK_U,
	UNK_V, UNK_W, UNK_X, UNK_Y, UNK_Z,
};

static const u8 Tbl2[] = {
	UNK_F, 
};

static const u8 Tbl3[] = {
	UNK_R, 
};

static const u8 Tbl4[] = {
	UNK_I, 
};

static const u8 Tbl5[] = {
	UNK_N, 
};

static const u8 Tbl6[] = {
	UNK_E, 
};

static const u8 Tbl7[] = {
	UNK_D, 
};

static const u8 Tbl8[] = {
	UNK_ENC, UNK_QUE, 
};

static const ANNOON_TABLE ANNOON_Table[] = {
	{ 20, Tbl1 },
	{ 1 , Tbl2 },
	{ 1 , Tbl3 },
	{ 1 , Tbl4 },
	{ 1 , Tbl5 },
	{ 1 , Tbl6 },
	{ 1 , Tbl7 },
	{ 2 , Tbl8 },
};

//-----------------------------------------------------------------------------
/**
 * ԑуGJEge[uւ
 *
 * @param	inEncData			GJEgf[^|C^
 * @param	*outTZEncMonsNo1	GJEg|P1̖
 * @param	*outTZEncMonsNo2	GJEg|P2̖
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
void EncSet_SetTimeZoneEnc(const ENCOUNT_DATA *inEncData, int *outTZEncMonsNo1, int *outTZEncMonsNo2)
{
	int time_zone;
	time_zone = GF_RTC_GetTimeZone();
	if ( (time_zone == TIMEZONE_NOON)||(time_zone == TIMEZONE_EVENING) ){
		(*outTZEncMonsNo1) = inEncData->NoonEnc[0];
		(*outTZEncMonsNo2) = inEncData->NoonEnc[1];
	}else if( (time_zone == TIMEZONE_NIGHT)||(time_zone == TIMEZONE_MIDNIGHT) ){
		(*outTZEncMonsNo1) = inEncData->NightEnc[0];
		(*outTZEncMonsNo2) = inEncData->NightEnc[1];
	}
}
#if 0
//-----------------------------------------------------------------------------
/**
 * Tt@GJEge[uւ
 *
 * @param	inRandomSeed		_̎
 * @param	inBookComp			S}ӊtO
 * @param	*outSafEncMonsNo1	GJEg|P1̖
 * @param	*outSafEncMonsNo2	GJEg|P2̖
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
void EncSet_SetSafariEnc(	const int inRandomSeed, const BOOL inBookComp,
							int *outSafEncMonsNo1, int *outSafEncMonsNo2	)
{
	int *tbl;
	int arc_idx;
	u16 tblno1,tblno2;
	
	//S}ӊǂŁAe[uς
	if(inBookComp){
		arc_idx = NARC_encdata_ex_safari_af_bin;
	}else{
		arc_idx = NARC_encdata_ex_safari_bef_bin;
	}
	//Tt@GJEge[u擾
	tbl = ArchiveDataLoadMallocLo(ARC_ENCDATA_EX, arc_idx, HEAPID_FIELD);
	//_̎ɃTt@GJEge[u2̑Io
	
	/* ---Io@--- */
	/*Tt@_̎̏2oCgƉ2oCg*/
	/*Tt@e[uŊ]Io|Pe[uԍƂ*/
	/*̌ʁA2̒lꍇ́Al1l2ڂ̃e[uԍƂ*/
	/*Io2̔ԍe[u̍Ō̔ԍꍇAЕ́Ae[u̎n߂̔ԍƂȂ*/
	
	tblno1 = ( (inRandomSeed >> 16) & 0xffff );
	tblno2 = ( inRandomSeed & 0xffff );

	tblno1 %= SAFARI_TBL_MAX;
	tblno2 %= SAFARI_TBL_MAX;

	if (tblno1 == tblno2){
		tblno2 = (tblno2+1)%SAFARI_TBL_MAX;
	}
	
	(*outSafEncMonsNo1) = tbl[tblno1];
	(*outSafEncMonsNo2) = tbl[tblno2];

	sys_FreeMemoryEz(tbl);
}
#endif

//-----------------------------------------------------------------------------
/**
 * ʔGJEge[uւ
 *
 * @param	fsys				tB[hVXe|C^
 * @param	inEncData			GJEgf[^|C^
 * @param	*outGeneEncMonsNo1	GJEg|P1̖
 * @param	*outGeneEncMonsNo2	GJEg|P2̖
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static void EncSet_SetGeneEnc(	FIELDSYS_WORK * fsys,
								const ENCOUNT_DATA *inEncData,
								int *outGeneEncMonsNo1, int *outGeneEncMonsNo2)
{
	u32 rnd_seed;
	ENC_SV_PTR data;
	data = EncDataSave_GetSaveDataPtr(fsys->savedata);
	
	//ʔH
	if ( EncDataSave_IsGenerate( data ) ){
		//_̎ɑʔꏊo2̍ւ
		rnd_seed = EncDataSave_GetRandSeed(data, ENC_RND_SEED_GENERATE);
		if ( fsys->location->zone_id == GenerateZone_GetZone(rnd_seed)){
			(*outGeneEncMonsNo1) = inEncData->GenerateEnc[0];
			(*outGeneEncMonsNo2) = inEncData->GenerateEnc[1];
		}
	}
}

//-----------------------------------------------------------------------------
/**
 * RGJEge[uւ
 *
 * @param	fsys				tB[hVXe|C^
 * @param	inBookGet			S}ӓtO
 * @param	*outHillEncMonsNo1	GJEg|P1̖
 * @param	*outHillEncMonsNo2	GJEg|P2̖
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static void EncSet_SetHillBackEnc(	FIELDSYS_WORK * fsys, const BOOL inBookGet,
									int *outHillEncMonsNo1, int *outHillEncMonsNo2)
{
	int *tbl;
	u16 idx1,idx2;
	
	//RH
	if ( ZoneData_IsHillBackZone( fsys->location->zone_id ) ){
		EncDataSave_GetHillBackPokeIdx(fsys->savedata, &idx1, &idx2);
		//S}ӓ肵Ă邩H
		if ( inBookGet ){
			//RGJEge[u擾
			tbl = ArchiveDataLoadMallocLo(ARC_ENCDATA_EX, NARC_encdata_ex_mnt_af_bin, HEAPID_FIELD);
		
			//2̍ւ
			if (idx1 != HILL_BACK_POKE_NONE){
				(*outHillEncMonsNo1) = tbl[idx1];
			}
			if (idx2 != HILL_BACK_POKE_NONE){
				(*outHillEncMonsNo2) = tbl[idx2];
			}
			sys_FreeMemoryEz(tbl);
		}
	}
}
//============================================================================================
//
//
//					GJEg菈
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * Q΂Q쐶̂Ƃ͗hꑐGJEg͂ȂdlA`FbN͒ʂĂ܂
 *
 * @param	fsys			tB[hVXe|C^
 *
 * @return	BOOL			TRUE:GJEg		FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
BOOL FieldEncount_Check(FIELDSYS_WORK * fsys)
{
	BATTLE_PARAM * param;
	POKEMON_PARAM *poke_param;
	int x, z;
	u8	attr;
	u8 enc_location;	//GJEgn`inォォj
	BOOL rc;
	BOOL result;
	BOOL companion;
	BOOL safari_flg;	//Tt@tO

	SWAY_ENC_INFO sway_enc_info;
	
	POKEPARTY *my_party;
	ENCOUNT_DATA *data;
	ENC_COMMON_DATA enc_data[ENC_MONS_NUM_MAX];
	
	ENC_FLD_SPA f_spa;
	
	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );
	
	attr = (u8)GetAttributeLSB( fsys, x, z );

	{
		u8	prob;
		// GJEgAgr[g`FbN
		prob = EncountAttributeCheck( fsys, attr, &enc_location );
		if( prob == 0 ){
			return FALSE;		//GJEgAgr[gł͂Ȃ ͊m0
		}

		//莝p[eB擾
		my_party = SaveData_GetTemotiPokemon(fsys->savedata);
		
		data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);
		poke_param = PokeParty_GetMemberPointer(my_party, 0);	//擪|P擾
		
		SetSpaStruct(fsys, poke_param, data, &f_spa  );

		{
			//Xv[gpȂ΃Xv[`FbN
			if ( !EncDataSave_CanUseSpray( EncDataSave_GetSaveDataPtr(fsys->savedata) ) ){
				POKEMON_PARAM *spray_poke_param;
				OS_Printf("supure-chekku\n");
				spray_poke_param = EvPoke_GetLivingPokemonTop(my_party);
				//Xv[`FbN
				f_spa.SprayCheck = TRUE;
				//Xv[`FbNɎgx擾
				f_spa.SpMyLv = PokeParaGet(spray_poke_param, ID_PARA_level, NULL);
			}
		}
		
		//ɂăGJEgmύX
		prob = ChangeEncProb(	FALSE, prob, &f_spa,
								Situation_GetWeatherID(SaveData_GetSituation(fsys->savedata)),
								poke_param	);
		//r[hɂmύX
		ChangeEncProbByVidro( fsys, &prob );
		
		//ACei߂̂ӂjɂmϓ
		ChangeEncProbByEquipItem( poke_param, &prob );
		
		if( MapEncountCheck( fsys, prob, attr ) == FALSE ){
			rc = FALSE;
		}else{
			rc = TRUE;
		}
	}

	memset( &sway_enc_info, 0, sizeof(SWAY_ENC_INFO) );

	//ꑐGJEg`FbN
	//ꑐɃqbgAO`FbNŁAGJEgȂƂĂGJEg
	if ( !SwayGrass_CheckSpEncount(x, z, fsys, fsys->SwayGrass,
									&sway_enc_info.Table,
									&sway_enc_info.Decide,
									&sway_enc_info.Rare) ){
		sway_enc_info.Enc = FALSE;		//ꑐGJEgs
	}else{
		sway_enc_info.Enc = TRUE;		//ꑐGJEg
		rc = TRUE;
	}

	if (rc == FALSE){
		return FALSE;
	}

	//A
	if (!SysFlag_PairCheck(SaveData_GetEventWork(fsys->savedata))){	//ʏ
		companion = FALSE;
	}else{	//A
		//ogp[^̃AP[Vƃ|Pp[eB̏
		companion = TRUE;
	}

	//ړ|P`FbN(AAhꑐGJEg̓`FbNȂ)
	if ( (!companion)&&(sway_enc_info.Enc==FALSE) ){
		MPD_PTR mpd;
		//ړ|PGJEg`FbN
		if ( CheckMovePokeEnc(fsys, &mpd) ){
			//Xv[`FbN
			if ( !CheckSpray( EncDataSave_GetMovePokeDataParam(mpd, MP_PARAM_LV),  &f_spa ) ){
				//ogp쐬
				param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_MOVE);	//t@Cg^Cv͈ړ|Pp
				//莝|PȂǃZbg
				BattleParam_SetParamByGameData(param, fsys);
				//p[^Zbg
				SetMovePokemon(f_spa.TrainerID, mpd, param);
				//GJEgꍇ́AꑐNA
				SwayGrass_InitSwayGrass(fsys->SwayGrass);
				FieldEncount_Set(fsys, param);		//ړ|PƃGJEg
				return TRUE;
			}else{
				return FALSE;		//Xv[Ő퓬(ogp쐬OȂ̂ŉȂĂnj)
			}
		}
	}

	//ogp̍쐬
	if (!companion){
		//Tt@tO擾
		safari_flg = SysFlag_SafariCheck(SaveData_GetEventWork(fsys->savedata));
		SetFieldBattleParam(fsys, safari_flg, &param);
	}else{
		param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_2vs2_YASEI);	//t@Cg^Cv͌Œ
	}
	
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);
	
	//n㐅㕪
	if (enc_location == GROUND_ENCOUNT){			//n
		//ʃGJEgf[^쐬
		int i;
		BOOL book_get;
		for(i=0;i<ENC_MONS_NUM_NORMAL;i++){
			enc_data[i].MonsNo = data->NormalEnc[i].MonsterNo;
			enc_data[i].LvMax = data->NormalEnc[i].Level;
			enc_data[i].LvMin = data->NormalEnc[i].Level;
		}

		//S}ӓtO擾
		book_get = ZukanWork_GetZenkokuZukanFlag(
								SaveData_GetZukanWork(GameSystem_GetSaveData(fsys)));
		
		//e[u
		EncSet_SetTimeZoneEnc( data, &enc_data[TIME_ENC_1].MonsNo, &enc_data[TIME_ENC_2].MonsNo);
		//ʔe[u
		EncSet_SetGeneEnc(fsys, data, &enc_data[GENE_ENC_1].MonsNo, &enc_data[GENE_ENC_2].MonsNo);
		//Re[u
		EncSet_SetHillBackEnc(	fsys, book_get, &enc_data[SP_ENC_1].MonsNo, &enc_data[SP_ENC_2].MonsNo);
		//AGBXbge[u
		AgbSlotEnc_SetAgbSlotEnc(data, book_get, &enc_data[AGB_ENC_1].MonsNo, &enc_data[AGB_ENC_2].MonsNo);

		if (!companion){
			//Tt@g̃Zbg
			SetSfariMonster(fsys, safari_flg, book_get, enc_data);
			//VOZbg
			result = WildEncSingle(	fsys, poke_param, param, data, enc_data, &f_spa,
							&sway_enc_info );
		}else{
			//|PZbg
			{
				//{͘AĂܐlOID by soga 2006.06.20
				param->trainer_id[CLIENT_NO_MINE2] =
					SysWork_PairTrainerIDGet( SaveData_GetEventWork(fsys->savedata) ); //BTFIVE1_01
				TT_EncountTrainerDataMake(param,fsys->savedata,HEAPID_WORLD);
			}
			result = WildEncDouble(	fsys, poke_param, param, enc_data, &f_spa );
		}
	}else if(enc_location == WATER_ENCOUNT){		//
		//ʃGJEgf[^쐬
		int i;
		for(i=0;i<ENC_MONS_NUM_SEA;i++){
			enc_data[i].MonsNo = data->EncSea[i].MonsterNo;
			enc_data[i].LvMax = data->EncSea[i].MaxLevel;
			enc_data[i].LvMin = data->EncSea[i].MinLevel;
		}
		result = WildWaterEncSingle(	fsys, poke_param, param, enc_data, &f_spa);
	}else{
		GF_ASSERT(0&&"GJEgP[Vs");
		BattleParam_Delete(param);	//ogp
		return FALSE;
	}

	if (result){
		FieldEncount_Set(fsys, param);
	}else{
		rc = FALSE;
	}

	GF_ASSERT( sys_CheckHeapSafe( HEAPID_FIELD ) );
	GF_ASSERT( sys_CheckHeapSafe( HEAPID_WORLD ) );

	if (rc == FALSE){
		BattleParam_Delete(param);	//ogp
	}
	//JEgNA
	fsys->encount.walk_count = 0;
	
	return rc;
}

//-----------------------------------------------------------------------------
/**
 * ނGJEg
 * Tt@ɂƂĂAނł͓ĝŁATt@X^[̃Zbg͍sȂ
 *
 * @param	fsys				tB[hVXe|C^
 * @param	inRodtype			ނ
 * @param	outBattleParam		ogp[^̃|C^̃|C^
 *
 * @return	BOOL				TRUE:GJEg		FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
BOOL SetFishingEncount( FIELDSYS_WORK * fsys, const FISHINGROD_TYPE inRodType, BATTLE_PARAM **outBattleParam )
{
	POKEMON_PARAM *poke_param;
	POKEPARTY *my_party;
	BOOL safari_flg;		//Tt@tO

	ENC_COMMON_DATA enc_data[ENC_MONS_NUM_MAX];
	ENC_FLD_SPA f_spa;		//\

	{
		u8 prob;
#ifdef PM_DEBUG
		if (DebugFishProbFlg){
			prob = 100;
		}else{
			// GJEg
			prob = GetEncountProbFishing(fsys, inRodType);
		}
#else
		// GJEg
		prob = GetEncountProbFishing(fsys, inRodType);
#endif
		if(  prob == 0 ){
			return FALSE;		//m0
		}

		//莝|Pp[eB擾
		my_party = SaveData_GetTemotiPokemon(fsys->savedata);
		poke_param = PokeParty_GetMemberPointer(my_party, 0);	//擪|P擾	
		SetSpaStruct(fsys, poke_param, NULL, &f_spa);

		//ɂăGJEgύX
		prob = ChangeEncProb(	TRUE, prob, &f_spa,
								Situation_GetWeatherID(SaveData_GetSituation(fsys->savedata)),
								poke_param	);
		//mŃGJEg
		if (gf_p_rand(100) >= prob){
			return FALSE;		//GJEgȂ
		}
	}
	//Tt@tO擾
	safari_flg = SysFlag_SafariCheck(SaveData_GetEventWork(fsys->savedata));

	//ogp[^Zbg
	SetFieldBattleParam(fsys, safari_flg, outBattleParam);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(*outBattleParam, fsys);
	//p̐ݒ
	BattleParam_SetFisingParam(*outBattleParam);


	if ( (ZoneData_IsSpFishingZone(fsys->location->zone_id))&&
			 SpFishing_CheckPoint(fsys) ){
		//ނf[^쐬
		u8 i;
		int monsno;
		u8 max,min;
		SpFishing_GetMaxMinLv(&max, &min);
		SpFishing_GetMonsNo(&monsno);
		
		for(i=0;i<ENC_MONS_NUM_FISH;i++){
			enc_data[i].MonsNo = monsno;
			enc_data[i].LvMax = max;
			enc_data[i].LvMin = min;
		}
	}else{
		//ʃGJEgf[^쐬
		{
			NON_GROUND_ENC_MONSTER_DAT *enc_fish;
			u8 i;
			ENCOUNT_DATA *data;

			data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);
			//V[EVEV[hStHύXmZbg<<ނł͏oȂ̂ŃZbgsv

			//ނƕʂɃf[^쐬
			switch(inRodType){
			case FISHINGROD_BAD:		//{
				enc_fish = data->EncFish1;
				break;
			case FISHINGROD_GOOD:		//
				enc_fish = data->EncFish2;
				break;
			case FISHINGROD_GREAT:		//
				enc_fish = data->EncFish3;
				break;
			}
		
			for(i=0;i<ENC_MONS_NUM_FISH;i++){
				enc_data[i].MonsNo = enc_fish[i].MonsterNo;
				enc_data[i].LvMax = enc_fish[i].MaxLevel;
				enc_data[i].LvMin = enc_fish[i].MinLevel;
			}	
		}
	}

	//ނGJEg
	{
		BOOL rc;
		rc = FishingEncSingle( fsys, poke_param, *outBattleParam, enc_data, &f_spa, inRodType );
		if (!rc){
			return FALSE;
		}
	}
	
	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 * ÂEÂGJEg
 *
 * @param	fsys				tB[hVXe|C^
 * @param	event			Cxg|C^
 *
 * @return	BOOL			TRUE:GJEg		FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
BOOL SetSweetEncount(FIELDSYS_WORK * fsys, GMEVENT_CONTROL * event)
{
	BATTLE_PARAM * param;
	POKEMON_PARAM *poke_param;
	int x, z;
	u8	attr;
	u8 enc_location;	//GJEgn`inォォj
	BOOL companion;
	BOOL safari_flg;	//Tt@tO
	BOOL result;
	SWAY_ENC_INFO sway_enc_info;
	
	POKEPARTY *my_party;
	ENCOUNT_DATA *data;
	ENC_COMMON_DATA enc_data[ENC_MONS_NUM_MAX];
	ENC_FLD_SPA f_spa;		//\

	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );

	
	attr = (u8)GetAttributeLSB( fsys, x, z );
	
	{
		u8	prob;
		prob = EncountAttributeCheck( fsys, attr, &enc_location );
		if( prob == 0 ){
			return FALSE;		//GJEgAgr[gł͂Ȃ ͊m0
		}
	}
	
	//莝p[eB擾
	my_party = SaveData_GetTemotiPokemon(fsys->savedata);

	data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);
	poke_param = PokeParty_GetMemberPointer(my_party, 0);	//擪|P擾
	SetSpaStruct(fsys, poke_param, data, &f_spa);
	//Xv[`FbNȂ
	f_spa.SprayCheck = FALSE;
	//GJEgLZ
	f_spa.EncCancelSpInvalid = TRUE;

	memset( &sway_enc_info, 0, sizeof(SWAY_ENC_INFO) );
	
	//A
	if (!SysFlag_PairCheck(SaveData_GetEventWork(fsys->savedata))){	//ʏ
		companion = FALSE;
	}else{	//A
		companion = TRUE;
	}

	//ړ|P`FbN(A̓`FbNȂB܂ŗhꑐ͖̂ŁA`FbN͏Ȃ)
	if (!companion){
		MPD_PTR mpd;
		//ړ|PGJEg`FbN
		if ( CheckMovePokeEnc(fsys, &mpd) ){
			//ŃGJEgȂ̂ŃXv[`FbNȂ
			//ogp쐬
			param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_MOVE);	//t@Cg^Cv͈ړ|Pp
			//莝|PȂǃZbg
			BattleParam_SetParamByGameData(param, fsys);
			//p[^Zbg
			SetMovePokemon(f_spa.TrainerID,mpd, param);
			//GJEgꍇ́AꑐNA
			SwayGrass_InitSwayGrass(fsys->SwayGrass);
			FieldEncount_Change(fsys, event, param);		//ړ|PƃGJEg
			return TRUE;
		}
	}

	//ogp̍쐬
	if (!companion){
		//Tt@tO擾
		safari_flg = SysFlag_SafariCheck(SaveData_GetEventWork(fsys->savedata));
		SetFieldBattleParam(fsys, safari_flg, &param);
	}else{
		param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_2vs2_YASEI);	//t@Cg^Cv͌Œ
	}
	
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);

	//n㐅㕪
	if (enc_location == GROUND_ENCOUNT){			//n
		//ʃGJEgf[^쐬
		int i;
		BOOL book_get;
		for(i=0;i<ENC_MONS_NUM_NORMAL;i++){
			enc_data[i].MonsNo = data->NormalEnc[i].MonsterNo;
			enc_data[i].LvMax = data->NormalEnc[i].Level;
			enc_data[i].LvMin = data->NormalEnc[i].Level;
		}

		//S}ӓtO擾
		book_get = ZukanWork_GetZenkokuZukanFlag(
								SaveData_GetZukanWork(GameSystem_GetSaveData(fsys)));

		//e[u
		EncSet_SetTimeZoneEnc( data, &enc_data[TIME_ENC_1].MonsNo, &enc_data[TIME_ENC_2].MonsNo);
		//ʔe[u
		EncSet_SetGeneEnc(fsys, data, &enc_data[GENE_ENC_1].MonsNo, &enc_data[GENE_ENC_2].MonsNo);
		//Re[u
		EncSet_SetHillBackEnc(	fsys, book_get, &enc_data[SP_ENC_1].MonsNo, &enc_data[SP_ENC_2].MonsNo);
		//AGBXbge[u
		AgbSlotEnc_SetAgbSlotEnc(data, book_get, &enc_data[AGB_ENC_1].MonsNo, &enc_data[AGB_ENC_2].MonsNo);
		
		if (!companion){
			//Tt@g̃Zbg
			SetSfariMonster(fsys, safari_flg, book_get, enc_data);
			//VOZbg
			result = WildEncSingle(	fsys, poke_param, param, data, enc_data, &f_spa,
							&sway_enc_info );
		}else{
			//|PZbg
			{
				//{͘AĂܐlOID by soga 2006.06.20
				param->trainer_id[CLIENT_NO_MINE2] = 
					SysWork_PairTrainerIDGet( SaveData_GetEventWork(fsys->savedata) ); //BTFIVE1_01;
				TT_EncountTrainerDataMake(param,fsys->savedata,HEAPID_WORLD);
			}
			result = WildEncDouble(	fsys, poke_param, param, enc_data, &f_spa );
		}
	}else if(enc_location == WATER_ENCOUNT){		//
		//ʃGJEgf[^쐬
		int i;
		for(i=0;i<ENC_MONS_NUM_SEA;i++){
			enc_data[i].MonsNo = data->EncSea[i].MonsterNo;
			enc_data[i].LvMax = data->EncSea[i].MaxLevel;
			enc_data[i].LvMin = data->EncSea[i].MinLevel;
		}
		result = WildWaterEncSingle(	fsys, poke_param, param, enc_data, &f_spa);
	}else{
		GF_ASSERT(0&&"GJEgP[Vs");
		return FALSE;
	}

	if (result){
		FieldEncount_Change(fsys, event, param);
	}else{
		GF_ASSERT(0);
	}
	//JEgNA
	fsys->encount.walk_count = 0;
	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 * oK`GJEg
 *
 * @param	fsys				tB[hVXe|C^
 * @param	outBattleParam		ogp[^̃|C^̃|C^
 *
 * @return	BOOL		TRUE:GJEg	FALSE:GJEgs
 */
//-----------------------------------------------------------------------------
BOOL SetKeyRandEncount( FIELDSYS_WORK * fsys, BATTLE_PARAM **outBattleParam )
{
	POKEMON_PARAM *poke_param;
	int x, z;
	u8	attr;
	u8 enc_location;	//GJEgn`inォォj
	BOOL rc;
	BOOL result;
	BOOL companion;
	BOOL safari_flg;	//Tt@tO

	SWAY_ENC_INFO sway_enc_info;
	
	POKEPARTY *my_party;
	ENCOUNT_DATA *data;
	ENC_COMMON_DATA enc_data[ENC_MONS_NUM_MAX];
	
	ENC_FLD_SPA f_spa;

	*outBattleParam = NULL;
	
	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );
	
	attr = (u8)GetAttributeLSB( fsys, x, z );

	{
		u8	prob;
		// GJEgAgr[g`FbN
		prob = EncountAttributeCheck( fsys, attr, &enc_location );
		if( prob == 0 ){
			return FALSE;		//GJEgAgr[gł͂Ȃ ͊m0
		}

		//莝p[eB擾
		my_party = SaveData_GetTemotiPokemon(fsys->savedata);
		
		data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);
		poke_param = PokeParty_GetMemberPointer(my_party, 0);	//擪|P擾
		
		SetSpaStruct(fsys, poke_param, data, &f_spa  );

		{
			//Xv[gpȂ΃Xv[`FbN
			if ( !EncDataSave_CanUseSpray( EncDataSave_GetSaveDataPtr(fsys->savedata) ) ){
				POKEMON_PARAM *spray_poke_param;
				OS_Printf("supure-chekku\n");
				spray_poke_param = EvPoke_GetLivingPokemonTop(my_party);
				//Xv[`FbN
				f_spa.SprayCheck = TRUE;
				//Xv[`FbNɎgx擾
				f_spa.SpMyLv = PokeParaGet(spray_poke_param, ID_PARA_level, NULL);
			}
		}
		
		//ɂăGJEgmύX
		prob = ChangeEncProb(	FALSE, prob, &f_spa,
								Situation_GetWeatherID(SaveData_GetSituation(fsys->savedata)),
								poke_param	);
		//r[hɂmύX
		ChangeEncProbByVidro( fsys, &prob );
		
		//ACei߂̂ӂjɂmϓ
		ChangeEncProbByEquipItem( poke_param, &prob );
		
		if( MapEncountCheck( fsys, prob, attr ) == FALSE ){
			rc = FALSE;
		}else{
			rc = TRUE;
		}
	}

	memset( &sway_enc_info, 0, sizeof(SWAY_ENC_INFO) );
	sway_enc_info.Enc = FALSE;		//ꑐGJEgmɕs
	
	//A
	if (!SysFlag_PairCheck(SaveData_GetEventWork(fsys->savedata))){	//ʏ
		companion = FALSE;
	}else{	//A
		//ogp[^̃AP[Vƃ|Pp[eB̏
		companion = TRUE;
	}

	//ړ|P`FbN(A̓`FbNȂBoK`ŗhꑐ͂Ȃ̂ŁA`FbN͏Ȃ)
	if (!companion){
		MPD_PTR mpd;
		//ړ|PGJEg`FbN
		if ( CheckMovePokeEnc(fsys, &mpd) ){
			//Xv[`FbN
			if ( !CheckSpray( EncDataSave_GetMovePokeDataParam(mpd, MP_PARAM_LV),  &f_spa ) ){
				//ogp쐬
				*outBattleParam = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_MOVE);	//t@Cg^Cv͈ړ|Pp
				//莝|PȂǃZbg
				BattleParam_SetParamByGameData(*outBattleParam, fsys);
				//p[^Zbg
				SetMovePokemon(f_spa.TrainerID,mpd, *outBattleParam);
				//GJEgꍇ́AꑐNA
				SwayGrass_InitSwayGrass(fsys->SwayGrass);
				return TRUE;
			}else{
				return FALSE;		//Xv[Ő퓬(ogp쐬OȂ̂ŉȂĂnj)
			}
		}
	}

	//ogp̍쐬
	if (!companion){
		//Tt@tO擾
		safari_flg = SysFlag_SafariCheck(SaveData_GetEventWork(fsys->savedata));
		SetFieldBattleParam(fsys, safari_flg, outBattleParam);
	}else{
		*outBattleParam = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_2vs2_YASEI);	//t@Cg^Cv͌Œ
	}
	
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(*outBattleParam, fsys);
	
	//n㐅㕪	ヌoK`͖낤B
	if (enc_location == GROUND_ENCOUNT){			//n
		//ʃGJEgf[^쐬
		int i;
		BOOL book_get;
		for(i=0;i<ENC_MONS_NUM_NORMAL;i++){
			enc_data[i].MonsNo = data->NormalEnc[i].MonsterNo;
			enc_data[i].LvMax = data->NormalEnc[i].Level;
			enc_data[i].LvMin = data->NormalEnc[i].Level;
		}

		//S}ӓtO擾
		book_get = ZukanWork_GetZenkokuZukanFlag(
								SaveData_GetZukanWork(GameSystem_GetSaveData(fsys)));
		
		//e[u
		EncSet_SetTimeZoneEnc( data, &enc_data[TIME_ENC_1].MonsNo, &enc_data[TIME_ENC_2].MonsNo);
		//ʔe[u
		EncSet_SetGeneEnc(fsys, data, &enc_data[GENE_ENC_1].MonsNo, &enc_data[GENE_ENC_2].MonsNo);
		//Re[u
		EncSet_SetHillBackEnc(	fsys, book_get, &enc_data[SP_ENC_1].MonsNo, &enc_data[SP_ENC_2].MonsNo);
		//AGBXbge[u
		AgbSlotEnc_SetAgbSlotEnc(data, book_get, &enc_data[AGB_ENC_1].MonsNo, &enc_data[AGB_ENC_2].MonsNo);

		if (!companion){
			//Tt@g̃Zbg
			SetSfariMonster(fsys, safari_flg, book_get, enc_data);
			//VOZbg
			result = WildEncSingle(	fsys, poke_param, *outBattleParam, data, enc_data, &f_spa,
							&sway_enc_info );
		}else{
			{
				//{͘AĂܐlOID by soga 2006.06.20
				(*outBattleParam)->trainer_id[CLIENT_NO_MINE2] =
					SysWork_PairTrainerIDGet( SaveData_GetEventWork(fsys->savedata) ); //BTFIVE1_01
				TT_EncountTrainerDataMake(*outBattleParam,fsys->savedata,HEAPID_WORLD);
			}
			result = WildEncDouble(	fsys, poke_param, *outBattleParam, enc_data, &f_spa );
		}
	}else{
		GF_ASSERT(0&&"GJEgP[Vs");
		BattleParam_Delete(*outBattleParam);	//ogp
		return FALSE;
	}

	if (!result){
		rc = FALSE;
	}

	GF_ASSERT( sys_CheckHeapSafe( HEAPID_FIELD ) );
	GF_ASSERT( sys_CheckHeapSafe( HEAPID_WORLD ) );

	if (rc == FALSE){
		BattleParam_Delete(*outBattleParam);	//ogp
	}else{
		//JEgNA
		fsys->encount.walk_count = 0;
	}
	return rc;
}


//-----------------------------------------------------------------------------
/**
 * 쐶VOZbgAbv
 *
 * @param	fsys				tB[hVXe|C^
 * @param	poke_param			|Pp
 * @param	param				ogp
 * @param	data				GJEgf[^
 * @param	enc_data			ʃGJEgf[^e[u
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 * @param	inSwayEncInfo		hꑐf[^ւ̃|C^
 *
 * @return	BOOL	TRUE:GJEg	FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
static BOOL WildEncSingle(FIELDSYS_WORK * fsys,
							POKEMON_PARAM *poke_param,
							BATTLE_PARAM * param,
							ENCOUNT_DATA *data,
							ENC_COMMON_DATA *enc_data,
							const ENC_FLD_SPA *inFldSpa,
							const SWAY_ENC_INFO *inSwayEncInfo )
{
	BOOL rc;
	//hꑐǂŕ
	if (inSwayEncInfo->Enc){	//hꑐGJEg
		int monsno,lv;
		//ꑐpe[uɏ
		if (inSwayEncInfo->Table == SWAY_GRASS_ENC_SP){
			enc_data[SWAY_ENC_1].MonsNo = data->SwayEnc[0];
			enc_data[SWAY_ENC_2].MonsNo = data->SwayEnc[1];
			enc_data[SWAY_ENC_3].MonsNo = data->SwayEnc[2];
			enc_data[SWAY_ENC_4].MonsNo = data->SwayEnc[3];
		}

		//hꑐO|P擾i񎞂́A0Ăj
		SwayGrass_GetEncMonsNoLv(fsys->SwayGrass, &monsno, &lv);
		//GJEg郂X^[肵Ăꍇ
		if (inSwayEncInfo->Decide == TRUE)	{
			MYSTATUS *my_st;
			//g[i[hc擾
			my_st = SaveData_GetMyStatus(GameSystem_GetSaveData(fsys));
			//w|P100GJEg
			rc = SetEncountDataDecideMons(	monsno, lv,
											POKEPARTY_ENEMY,
											inSwayEncInfo->Rare,
											MyStatus_GetID(my_st),//g[i[hc
											inFldSpa,
											poke_param,
											param );
		}else{	//肵ĂȂꍇA͏
			//GJEgf[^Zbg
			rc = SetSwayEncountData(fsys, poke_param, inFldSpa, enc_data, POKEPARTY_ENEMY,
									param,  monsno, lv);
		}
		
		if (rc){
			//hꑐꏊ
			{
				int x,z;
				//@̈ʒu擾
				x = Player_NowGPosXGet(fsys->player);
				z = Player_NowGPosZGet(fsys->player);
				SwayGrass_SearchSwayGrass(fsys, x, z, fsys->SwayGrass);
			}
		}
	}else{			//ʏ
		rc = SetEncountData(poke_param, ROD_TYPE_NONE, inFldSpa, enc_data,
							GROUND_ENCOUNT, POKEPARTY_ENEMY,
							param);
		if (rc){
			//ʏGJEgꍇ́Aꑐ񓙂NA
			SwayGrass_InitSwayGrass(fsys->SwayGrass);
		}
	}
	return rc;
}

//-----------------------------------------------------------------------------
/**
 * 쐶_uZbgAbv
 *
 * @param	fsys				tB[hVXe|C^
 * @param	poke_param			|Pp
 * @param	param				ogp
 * @param	enc_data			ʃGJEgf[^e[u
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 *
 * @return	BOOL	TRUE:GJEg	FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
static BOOL WildEncDouble(	FIELDSYS_WORK * fsys,
							POKEMON_PARAM *poke_param,
							BATTLE_PARAM * param,
							ENC_COMMON_DATA *enc_data,
							const ENC_FLD_SPA *inFldSpa )
{
	BOOL rc;
	{
		{
			//GJEgf[^Zbg
			rc = SetEncountData(	poke_param, ROD_TYPE_NONE, inFldSpa, enc_data,
									GROUND_ENCOUNT, POKEPARTY_ENEMY,
									param );
			if (!rc){
				return FALSE;
			}
			
			rc = SetEncountData(	poke_param, ROD_TYPE_NONE, inFldSpa, enc_data,
									GROUND_ENCOUNT, POKEPARTY_ENEMY_PAIR,
									param );
		}
		
	}
	return rc;
}

//-----------------------------------------------------------------------------
/**
 * 쐶VOZbgAbv
 *
 * @param	fsys				tB[hVXe|C^
 * @param	poke_param			|Pp
 * @param	param				ogp
 * @param	enc_data			ʃGJEgf[^e[u
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 *
 * @return	BOOL	TRUE:GJEg	FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
static BOOL WildWaterEncSingle(	FIELDSYS_WORK * fsys,
								POKEMON_PARAM *poke_param,
								BATTLE_PARAM * param,
								ENC_COMMON_DATA *enc_data,
								const ENC_FLD_SPA *inFldSpa )
{
	BOOL rc;

	{
		//GJEgf[^Zbg
		rc = SetEncountData(	poke_param, ROD_TYPE_NONE, inFldSpa, enc_data,
								WATER_ENCOUNT, POKEPARTY_ENEMY,
								param );
	}
	return rc;
}

//-----------------------------------------------------------------------------
/**
 * ނ
 *
 * @param	fsys				tB[hVXe|C^
 * @param	poke_param			|Pp
 * @param	battle_param		ogp
 * @param	inData				GJEgf[^
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 * @param	inRodType			ފ
 *
 * @return	BOOL	TRUE:GJEg	FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
static BOOL FishingEncSingle(	FIELDSYS_WORK * fsys,
								POKEMON_PARAM *poke_param,
								BATTLE_PARAM * battle_param,
								ENC_COMMON_DATA *inData,
								const ENC_FLD_SPA *inFldSpa,
								const FISHINGROD_TYPE inRodType )
{
	BOOL rc;
	rc = SetEncountData(poke_param, inRodType, inFldSpa, inData,
						FISHING_ENCOUNT, POKEPARTY_ENEMY,
						battle_param );
	return rc;
}

//-----------------------------------------------------------------------------
/**
 * GJEg`FbNi֘Aj
 *
 * @param	fsys				tB[hVXe|C^
 * @param	per			GJEgm
 * @param	attr				Agr[g
 *
 * @return	BOOL	TRUE:GJEg	FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
static BOOL MapEncountCheck( FIELDSYS_WORK * fsys, const u32 per, const u8 attr )
{
	u8 next_base;
	u32 map_encount;
	
	//100%
	if (per>100){
		map_encount = 100;
	}
	map_encount = per << CALC_SHIFT;

	// GJEg
	if( EncountWalkCheck( fsys, map_encount ) == FALSE ){
		fsys->encount.walk_count++;			// JEg{
		// 5%Ŏ̏
		if( ( gf_p_rand(100) ) >= WALK_NEXT_PERCENT ){
			return FALSE;
		}
	}

	next_base = NEXT_PERCENT;	//{40

	//̏ꍇ+30
	if ( MATR_IsLongGrass(attr) ){
		next_base += LONG_GRASS_PERCENT;
	}else{
		//]ԂɏĂȂ+30
		if ( Player_FormGet( fsys->player ) == HERO_FORM_CYCLE ){
			next_base += CYCLE_PERCENT;
		}
	}
	//tɂmϓ
	next_base = CalEnc_GetProb(next_base, EVTIME_IsPenaltyMode(fsys));

	//100%
	if (next_base>100){
		next_base = 100;
	}

	// next_base%Ŏ̏i{60%ŏł؂)
	if( ( gf_p_rand(100) ) < next_base  ){
		// C
		if( EncountCheckMain( fsys, per ) ){
			return TRUE;
		}	
	}
	return FALSE;
	
}

//-----------------------------------------------------------------------------
/**
 * mԂ
 *
 * @param	fsys				tB[hVXe|C^
 * @param	attr				Agr[g
 * @param	outEncLocation		GJEgꏊi[obt@
 *
 * @return	u8					m
 */
//-----------------------------------------------------------------------------
static u8 EncountAttributeCheck( FIELDSYS_WORK * fsys, u8 attr, u8 *outEncLocation  )
{
	if (MATR_IsEncount(attr)){
		if (MATR_IsWater(attr)){			//
			(*outEncLocation) = WATER_ENCOUNT;
			return GetEncountProbWater( fsys );
		}else{								//
			(*outEncLocation) = GROUND_ENCOUNT;
			return GetEncountProbGround( fsys );
		}
	}
	return 0;
}

//-----------------------------------------------------------------------------
/**
 * k`FbN
 *
 * @param	fsys	tB[hVXe|C^
 * @param	per		m
 *
 * @return	BOOL	
 */
//-----------------------------------------------------------------------------
static BOOL	EncountWalkCheck( FIELDSYS_WORK * fsys, u32 per )
{
	per = (per/10)>>CALC_SHIFT;
	if (per > WALK_COUNT_GLOBAL) {
		per = WALK_COUNT_GLOBAL;
	}
	per = WALK_COUNT_GLOBAL - ( per );

	if( fsys->encount.walk_count >= per ){
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * GJEg`FbN
 *
 * @param	fsys	tB[hVXe|C^
 * @param	per		m
 *
 * @return	BOOL	TRUE:GJEg	FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
static BOOL EncountCheckMain( FIELDSYS_WORK * fsys, u32 per )
{
	if ( gf_p_rand(100) >= per ){
		return FALSE;
	}else{
		return TRUE;
	}
}

//-----------------------------------------------------------------------------
/**
 * _|PZbgiނ//Aj
 *
 * @return	u8 GJEgf[^̃e[uԍ
 */
//-----------------------------------------------------------------------------
static u8 RandamPokeSet(void)
{
	u8	i;

	i = gf_p_rand(100);

	if( i < 20 )			return	0;		// 20%
	if( i >= 20 && i < 40 )	return	1;		// 20%
	if( i >= 40 && i < 50 )	return	2;		// 10%
	if( i >= 50 && i < 60 )	return	3;		// 10%
	if( i >= 60 && i < 70 )	return	4;		// 10%
	if( i >= 70 && i < 80 )	return	5;		// 10%
	if( i >= 80 && i < 85 )	return	6;		//  5%
	if( i >= 85 && i < 90 )	return	7;		//  5%
	if( i >= 90 && i < 94 )	return	8;		//  4%
	if( i >= 94 && i < 98 )	return	9;		//  4%
	if( i == 98 )			return	10;		//  1%
	return	11;								//  1%
}

//-----------------------------------------------------------------------------
/**
 * _|PZbgij
 *
 * @return	u8 GJEgf[^̃e[uԍ
 */
//-----------------------------------------------------------------------------
static u8 RandamPokeSetNoGround(void)
{
	u8	i;

	i = gf_p_rand(100);

	if( i < 60 )			return	0;		// 60%
	if( i >= 60 && i < 90 )	return	1;		// 30%
	if( i >= 90 && i < 95 )	return	2;		//  5%
	if( i >= 95 && i < 99 )	return	3;		//  4%
	return	4;								//  1%
}

//-----------------------------------------------------------------------------
/**
 * _|PZbgiނj
 *
 * @param	inFishingRod		ފ
 *
 * @return	u8		GJEgf[^̃e[uԍ		
 */
//-----------------------------------------------------------------------------
static u8 RandamPokeSetFishing( const FISHINGROD_TYPE inFishingRod )
{
	u8	i;
	u8	p = 0;

	i = gf_p_rand(100);

	switch( inFishingRod ){
	case FISHINGROD_BAD:		// {̒ފ
		if		( i < 60 )	p = 0;	// 60%
		else if ( i < 90 )	p = 1;	// 30%
		else if ( i < 95 )	p = 2;	// 5%
		else if ( i < 99 )	p = 3;	// 4%	
		else				p = 4;	// 1%
		break;
	case FISHINGROD_GOOD:		// ǂފ
		if		( i < 40 )	p = 0;	// 40%
		else if ( i < 80 )	p = 1;	// 40%
		else if ( i < 95 )	p = 2;	// 15%
		else if ( i < 99 )	p = 3;	// 4%
		else				p = 4;	// 1%
		break;
	case FISHINGROD_GREAT:		// ފ
		if		( i < 40 )	p = 0;	// 40%
		else if ( i < 80 )	p = 1;	// 40%
		else if ( i < 95 )	p = 2;	// 15%
		else if ( i < 99 )	p = 3;	// 4%
		else				p = 4;	// 1%
		break;
	default:
		GF_ASSERT(0&&"unknown fishing rod");
	}

	return	p;
}

//-----------------------------------------------------------------------------
/**
 * ACeɂGJEgω
 *
 * @param	inMyPokeParam	莝擪|P
 * @param	ioPer			m
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static void ChangeEncProbByEquipItem( POKEMON_PARAM *inMyPokeParam, u8 *ioPer )
{
	u16 item;
	item = PokeParaGet( inMyPokeParam, ID_PARA_item, NULL );
	// 擪̃|Pu߂̂ӂvEu߂̂v𑕔ĂꍇA2/3
	if( (item == ITEM_KIYOMENOOHUDA)||
		(item == ITEM_KIYOMENOOKOU) ){
		(*ioPer) = ( (*ioPer) * 2 ) / 3;
	}
}

//-----------------------------------------------------------------------------
/**
 * r[hGJEgω
 *
 * @param	fsys		tB[hVXe|C^
 * @param	ioPer		m
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static void ChangeEncProbByVidro( FIELDSYS_WORK *fsys, u8 *ioPer )
{
	u8 type;
	//Z[uf[^r[h^Cv擾
	type = EncDataSave_GetVidro( EncDataSave_GetSaveDataPtr(fsys->savedata) );
	if( type == VIDRO_BLACK ){			//u낢r[hvgpĂꍇA1/2{
		(*ioPer)/=2;
//		OS_Printf("gp%d\n",(*ioPer));
	}else if (type == VIDRO_WHITE){		//u낢r[hvgpĂꍇA1.5{
		(*ioPer) = (*ioPer) + ((*ioPer)/2);
//		OS_Printf("gp%d\n",(*ioPer));
	}
}

//-----------------------------------------------------------------------------
/**
 * iݒ
 *
 * @param	inPokeParam			|Pp
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 *
 * @return	u8					i
 */
//-----------------------------------------------------------------------------
static u8 GetEncountChar(POKEMON_PARAM *inPokeParam, const ENC_FLD_SPA *inFldSpa)
{
	u32	type;

	//VN̓ɂGJEg|P̐i𓯂ɂȂ₷
	// 擪̃|P^}SłȂ
	if( inFldSpa->Egg == 0 ){
		if( inFldSpa->Spa == TOKUSYU_SINKURO ){	//VN
			if ( gf_p_rand(2) == 0 ){//Kp@m1/2
				type = (u32)PokeParaGet( inPokeParam, ID_PARA_personal_rnd, NULL );
				type = type % 25;
				return (u8)type;
			}
		}
	}
	
	return gf_p_rand(25);	// _Ō
	
}

//-----------------------------------------------------------------------------
/**
 * xݒ
 *
 * @param	inData			ʃGJEgf[^e[u
 * @param	inFldSpa		`FbNEtHύXp\̂ւ̃|C^
 *
 * @return	u8				x
 */
//-----------------------------------------------------------------------------
static u8 SetEncountPokeLv( const ENC_COMMON_DATA *inData, const ENC_FLD_SPA *inFldSpa )
{
	u8	size;
	u8	plus;
	u8	min, max;
	u8	spa;

	// Max Lv  Min Lv 菬ꍇ̏C
	if( inData->LvMax >= inData->LvMin ){
		min = inData->LvMin;
		max = inData->LvMax;
	}else{
		min = inData->LvMax;
		max = inData->LvMin;
	}

	size = max - min + 1;		// ␳TCY
	plus = gf_rand() % size;	// ␳l

	//u邫vuvbV[vu͂肫v̓`FbNx̍|PƂTŃGJEg
	// 擪̃|P^}SłȂ
	if( inFldSpa->Egg == 0 ){
		if( (inFldSpa->Spa == TOKUSYU_HARIKIRI)||
			(inFldSpa->Spa == TOKUSYU_YARUKI)||
			(inFldSpa->Spa == TOKUSYU_PURESSYAA) ){
			// 1/2œ
			if( gf_p_rand(2) == 0 ){
				return 	( min + plus );		// 
			}
			return	( max );	//Bxmaxɂ
		}
	}

	return	( min + plus );		// GJEgx
}

//-----------------------------------------------------------------------------
/**
 * GJEg|PZbgiAj
 *
 * @param	poke				X^[io[
 * @param	lv					x
 * @param	inTarget			ǉΏ
 * @param	inTrainerID			g[i[hc
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 * @param	inPokeParam			|Ppij
 * @param	outBattleParam		ogp|C^
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static void EncountParamSetRare(	const u16 poke, const u8 lv, const int inTarget,
									const u32 inTrainerID, const ENC_FLD_SPA *inFldSpa,
									POKEMON_PARAM *inPokeParam, BATTLE_PARAM *outBattleParam )
{
	BOOL rc;
	u32 rnd_val;
	BOOL sp_use;	//Kp邩H
	u8 my_poke_sex;
	u8 my_poke_chr;
	
	POKEMON_PARAM *poke_param;
	poke_param = PokemonParam_AllocWork(HEAPID_WORLD);
	PokeParaInit(poke_param);

	sp_use = FALSE;

	//`FbN	AƂȂhc͕ɁA𔽉f
	//`FbŃA{fBƃVN
	if (inFldSpa->Egg == 0){
		if (inFldSpa->Spa == TOKUSYU_MEROMEROBODHI){
			//GJEg|P̐ʃxNg𒲂ׂ
			u32 sex_vec;
			sex_vec = PokePersonalParaGet( poke, ID_PER_sex );
			switch(sex_vec){
			case    MONS_MALE:
			case    MONS_FEMALE:
			case    MONS_UNKNOWN:
					break;		//ʖ́AŒ̏ꍇ́AȂ
			default:
				// 2/3œ
				if( gf_p_rand(3) > 0 ){
					my_poke_sex = PokeParaGet(inPokeParam, ID_PARA_sex, NULL);//PokeSexGet(inPokeParam);
					sp_use = TRUE;
				}
			}
		}else if (inFldSpa->Spa == TOKUSYU_SINKURO){
			if ( gf_p_rand(2) == 0 ){//Kp@m1/2
				my_poke_chr = PokeSeikakuGet(inPokeParam);
				sp_use = TRUE;
			}
		}
	}

	//A擾
	rnd_val = PokeRareRndGet(inTrainerID);

	if (sp_use){//Kpꍇ
		u8 sex,chr;
		do{
			if (inFldSpa->Spa == TOKUSYU_MEROMEROBODHI){
				//̐ʂ擾iʖ͏ŒeĂ̂ŕKY͂j
				sex = PokeSexGetMonsNo(poke, rnd_val);
				GF_ASSERT(sex!=PARA_UNK&&"ERROR:ENCOUNT_SEX_ERROR");
				//̐ʂƔri{fBĂ|P͕Kʂ邱ƂOƂj
				if (sex != my_poke_sex){
					break;	//ِȂ̂ŏI
				}else{
					rnd_val = PokeRareRndGet(inTrainerID);	//AĎ擾
				}
			}else if (inFldSpa->Spa == TOKUSYU_SINKURO){
				//̐i擾
				chr = PokeSeikakuGetRnd(rnd_val);
				//̐iƔr
				if (chr == my_poke_chr){
					break;	//iȂ̂ŏI
				}else{
					rnd_val = PokeRareRndGet(inTrainerID);	//AĎ擾
				}
				

			}
		}while(1);
	}
	
	PokeParaSet(poke_param, poke, lv, POW_RND, RND_SET, rnd_val, ID_SET, inFldSpa->TrainerID);
	rc = AddPokemonParam(inTarget, inFldSpa, poke_param, outBattleParam);
	GF_ASSERT(rc&&"|P̒ǉɎs");
	sys_FreeMemoryEz(poke_param);

	OS_Printf("RARE_POKEMON_ENCOUNT!!!!!\n");
}

//-----------------------------------------------------------------------------
/**
 * GJEg|PZbg
 *
 * @param	poke				X^[io[
 * @param	lv					x
 * @param	inTarget			ǉΏ
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 * @param	inPokeParam			|Ppij
 * @param	outBattleParam		ogp|C^
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static void EncountParamSet(u16 poke, u8 lv, const int inTarget, const ENC_FLD_SPA *inFldSpa,
							POKEMON_PARAM *inPokeParam, BATTLE_PARAM *outBattleParam )
{
	u8 valid_flg;	//L`FbNtO
	u8 sex;
	BOOL rc;
	POKEMON_PARAM *poke_param;
	poke_param = PokemonParam_AllocWork(HEAPID_WORLD);
	PokeParaInit(poke_param);

	valid_flg = 1;

	//GJEg|P̐ʃxNg𒲂ׂ
	{
		u32 sex_vec;
		sex_vec = PokePersonalParaGet( poke, ID_PER_sex );
		switch(sex_vec){
        case    MONS_MALE:
        case    MONS_FEMALE:
        case    MONS_UNKNOWN:
			valid_flg = 0;
		}
	}

	if (valid_flg){//Io|PʂȂÁAŒ̏ꍇ́A`FbNȂ
		//擪|P̓{fB̂Ƃِ͈o₷Ȃ
		// 擪̃|P^}SłȂ
		if( inFldSpa->Egg == 0 ){
			if( inFldSpa->Spa == TOKUSYU_MEROMEROBODHI ){
				// 2/3œ
				if( gf_p_rand(3) > 0 ){
					sex = PokeParaGet(inPokeParam, ID_PARA_sex, NULL);//PokeSexGet(inPokeParam);
					//ِ𔭐
					if (sex == PARA_FEMALE){
						sex = PARA_MALE;
						OS_Printf("XȂ̂ŃIXZbg\n");
					}else if (sex == PARA_MALE){
						sex = PARA_FEMALE;
						OS_Printf("IXȂ̂ŃXZbg\n");
					}else{			GF_ASSERT(0&&"ʕs");
					}
					PokeParaSetSexChr(poke_param, poke, lv, POW_RND, sex, GetEncountChar(inPokeParam, inFldSpa), 0);
					PokeParaPut(poke_param, ID_PARA_id_no, &inFldSpa->TrainerID);
#if 0	//fobOp
					{
						u8 d_sex;
						d_sex = PokeParaGet(inPokeParam, ID_PARA_sex, NULL);//PokeSexGet(poke_param);
						if (d_sex == PARA_FEMALE){
							OS_Printf("X\n");
						}else if (d_sex == PARA_MALE){
							OS_Printf("IX\n");
						}else{
							GF_ASSERT(0&&"Zbgʕs");
						}
					}
#endif				
					rc = AddPokemonParam(inTarget, inFldSpa, poke_param, outBattleParam);
					GF_ASSERT(rc&&"|P̒ǉɎs");
					sys_FreeMemoryEz(poke_param);
					return;
				}
			}
		}
	}

	PokeParaSetChr( poke_param, poke, lv, POW_RND, GetEncountChar(inPokeParam, inFldSpa) );
	PokeParaPut(poke_param, ID_PARA_id_no, &inFldSpa->TrainerID);
	rc = AddPokemonParam(inTarget, inFldSpa, poke_param, outBattleParam);
	GF_ASSERT(rc&&"|P̒ǉɎs");
	sys_FreeMemoryEz(poke_param);
}

#ifdef PM_DEBUG
//----------------------------------------------------
//	fobOGJEg|PZbg
//	 : u16 poke = |PID
//		   u8 lv    = GJEgLv
//----------------------------------------------------
static void DebugEncountParamSet(	u16 poke, u8 lv, const int inTarget,
									BATTLE_PARAM *outBattleParam )
{
	u16 monsno;
	u32 rnd;
	u8 sex;
	u8 spa;
	BOOL rc;
	POKEMON_PARAM *poke_param;
	poke_param = PokemonParam_AllocWork(HEAPID_WORLD);
	PokeParaInit(poke_param);
	
	PokeParaSetChr( poke_param, poke, lv, POW_RND, (gf_p_rand(25)) );
	rc = PokeParty_Add(outBattleParam->poke_party[inTarget], poke_param);
	GF_ASSERT(rc&&"|P̒ǉɎs");
	sys_FreeMemoryEz(poke_param);
}
#endif

//-----------------------------------------------------------------------------
/**
 * GJEgf[^Zbg
 *
 * @param	param				X^[io[
 * @param	inRodType					x
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 * @param	inData				ʃGJEgf[^e[u
 * @param	location			ꏊ
 * @param	intarget			ǉΏ
 * @param	outBattleParam		ogp|C^
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static BOOL SetEncountData(	POKEMON_PARAM *param,
							const FISHINGROD_TYPE inRodType,
							const ENC_FLD_SPA *inFldSpa,
							const ENC_COMMON_DATA *inData,
							const u8 location,
							const int inTarget,
							BATTLE_PARAM *outBattleParam)
{
	BOOL result;
	u8	no = 0;
	u8	lv = 0;
	
	// GJEg|P
	switch( location ){
	case GROUND_ENCOUNT:	// n
		//傭ɂA͂˃^CṽGJEǧ
		result = CheckFixTypeEcnt(	param, inFldSpa, inData,
									ENC_MONS_NUM_NORMAL, METAL_TYPE,TOKUSYU_ZIRYOKU, &no);
		if (result == FALSE){
			//ł񂫓ɂAł񂫃^CṽGJEǧ
			result = CheckFixTypeEcnt(	param, inFldSpa, inData,
										ENC_MONS_NUM_NORMAL, ELECTRIC_TYPE,TOKUSYU_SEIDENKI, &no);
			if (result == FALSE){
				//ɂw^CvƂ̃GJEgɎsBʏ̃GJEg
				no = RandamPokeSet();
				//OS_Printf("enc_random = %d\n",no);				
			}
		}
		//Bɂő僌x|PIo(n)
		no = GetMaxLvMonsTblNo(inData, inFldSpa, no);
		lv = inData[no].LvMax;
		break;
	case WATER_ENCOUNT:		// 
		//傭ɂA͂˃^CṽGJEǧ
		result = CheckFixTypeEcnt(	param, inFldSpa, inData,
									ENC_MONS_NUM_SEA, METAL_TYPE,TOKUSYU_ZIRYOKU, &no);
		//ł񂫓ɂAł񂫃^CṽGJEǧ
		result = CheckFixTypeEcnt(	param, inFldSpa, inData,
									ENC_MONS_NUM_SEA, ELECTRIC_TYPE,TOKUSYU_SEIDENKI, &no);
		if (result == FALSE){
			//ɂw^CvƂ̃GJEgɎsBʏ̃GJEg
			no = RandamPokeSetNoGround();
		}
		//xZbg
		lv = SetEncountPokeLv( &inData[no], inFldSpa );
		break;
	case FISHING_ENCOUNT:	//ނ
		//傭ɂA͂˃^CṽGJEǧ
		result = CheckFixTypeEcnt(	param, inFldSpa, inData,
									ENC_MONS_NUM_FISH, METAL_TYPE,TOKUSYU_ZIRYOKU, &no);
		//ł񂫓ɂAł񂫃^CṽGJEǧ
		result = CheckFixTypeEcnt(	param, inFldSpa, inData,
									ENC_MONS_NUM_FISH, ELECTRIC_TYPE,TOKUSYU_SEIDENKI, &no);
		if (result == FALSE){
			//ɂw^CvƂ̃GJEgɎsBʏ̃GJEg
			no = RandamPokeSetFishing(inRodType);
		}
		//xZbg
		lv = SetEncountPokeLv( &inData[no], inFldSpa );
		break;
	default:
		GF_ASSERT(0);
	}

	//ɂ郌x퓬
	if( CheckEcntCancelByLv( inFldSpa, param, lv )){
		return FALSE;
	}

	// Xv[`FbN Lv̒Ⴂ|P̓GJEgȂ
	if( CheckSpray(lv, inFldSpa) == TRUE ){
		return FALSE;		//Xv[Ő퓬
	}
	
	// GJEg|PZbg
	EncountParamSet( inData[no].MonsNo, lv, inTarget, inFldSpa, param, outBattleParam );
	return	TRUE;
}

//-----------------------------------------------------------------------------
/**
 * GJEgf[^Zbgi|Pwj
 *
 * @param	inMonsNo			X^[io[
 * @param	inLv				x
 * @param	inTarget			ǉΏ
 * @param	inRare				AtO
 * @param	inTrainerID			g[i[hc
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 * @param	param				|Ppij
 * @param	outBattleParam		ogp|C^
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static BOOL SetEncountDataDecideMons(	const int inMonsNo, const int inLv,
										const int inTarget,
										const BOOL inRare,
										const u32 inTrainerID,
										const ENC_FLD_SPA *inFldSpa,
										POKEMON_PARAM *param,
										BATTLE_PARAM *outBattleParam)
{
	u8	lv = 0;

	GF_ASSERT(inMonsNo != 0);
	
	//GJEg|PłɌ܂Ă̂ŁA傭Ał񂫓͖
	//邫A͂肫AvbV[ɂAxϓsȂ
	lv = inLv;

	//Xv[`FbN
	
	// GJEg|PZbg
	if (inRare){
		EncountParamSetRare(inMonsNo, lv, inTarget, inTrainerID,
							inFldSpa, param, outBattleParam );
	}else{
		EncountParamSet( inMonsNo, lv, inTarget, inFldSpa, param, outBattleParam );
	}
	return	TRUE;
}

//-----------------------------------------------------------------------------
/**
 * GJEgf[^Zbgihꑐj
 *
 * @param	fsys				tB[hVXe|C^
 * @param	param				|Pp
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 * @param	inData				ʃGJEf[^e[u
 * @param	inTartget			ǉΏ
 * @param	outBattleParam		ogp|C^
 * @param	inMonsNo			X^[io[
 * @param	inLv				x
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static BOOL SetSwayEncountData(	FIELDSYS_WORK * fsys,
								POKEMON_PARAM *param,
								const ENC_FLD_SPA *inFldSpa,
								const ENC_COMMON_DATA *inData,
								const int inTarget,
								BATTLE_PARAM *outBattleParam,
								const int inMonsNo, const int inLv)
{
	u8 result;
	u8	no = 0;
	u8	lv = 0;

	int monsno;
	
	// GJEg|P
	//傭ɂA͂˃^CṽGJEǧ
	result = CheckFixTypeEcnt(	param, inFldSpa, inData,
								ENC_MONS_NUM_NORMAL, METAL_TYPE,TOKUSYU_ZIRYOKU, &no);
	if (result == FALSE){
		//ł񂫓ɂAł񂫃^CṽGJEǧ
		result = CheckFixTypeEcnt(	param, inFldSpa, inData,
									ENC_MONS_NUM_NORMAL, ELECTRIC_TYPE,TOKUSYU_SEIDENKI, &no);
		if (result == FALSE){
			//ɂw^CvƂ̃GJEgɎsBʏ̃GJEg
			no = RandamPokeSet();
		}
	}
	lv = inData[no].LvMax;
	monsno = inData[no].MonsNo;

	//񂩁H
	if (inMonsNo == 0){	//
		//ꑐGJEgƂāAGJEgꍇ́AZbg|PL
		SwayGrass_SetEncMonsNoLv(fsys->SwayGrass, monsno, lv);
		//A̍XV<<dlύX 2006/0519 add@񂩂XViɂ͘Ał͂ȂĐ퓬ɂȂj
		SwayGrass_UpDateChain(fsys);
	}else{			//񂶂Ȃ
		//hꑐnYǓ|P̏ꍇ͘A𕜊
		if (monsno == inMonsNo ){
			monsno = inMonsNo;
			lv = inLv;
			//A̍XV
			SwayGrass_UpDateChain(fsys);
		}else{
			//nYȂ̂ŗhꑐI
			SwayGrass_InitSwayGrass(fsys->SwayGrass);
		}
	}

	//Xv[`FbN
	
	// GJEg|PZbg
	EncountParamSet( monsno, lv, inTarget, inFldSpa, param, outBattleParam );
	return	TRUE;
}

//-----------------------------------------------------------------------------
/**
 * GJEgf[^Zbgihj
 *
 * @param	fsys				tB[hVXe|C^
 * @param	outBattleParam		ogp|C^
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
void SetHoneyTreeEncountData(FIELDSYS_WORK *fsys, BATTLE_PARAM *outBattleParam)
{
	POKEMON_PARAM *param;
	int monsno;
	ENC_FLD_SPA f_spa;		//\
	u8 lv;
	
	monsno = HTE_GetHoneyTreeMonster(fsys);
	//擪|P̃^}S`FbN
	{	
		POKEPARTY *my_party;
		my_party = SaveData_GetTemotiPokemon(fsys->savedata);
		param = PokeParty_GetMemberPointer(my_party, 0);	//擪|P擾
		SetSpaStruct(fsys, param, NULL, &f_spa );
	}

	//xݒi5`15j
	{
		u8 plus = HONEY_TREE_LV_MAX-HONEY_TREE_LV_MIN+1;
		lv = HONEY_TREE_LV_MIN + gf_p_rand(plus);

		//u邫vuvbV[vu͂肫v̓`FbNx̍|PƂTŃGJEg
		// 擪̃|P^}SłȂ
		if( f_spa.Egg == 0 ){
			if( (f_spa.Spa == TOKUSYU_HARIKIRI)||
				(f_spa.Spa == TOKUSYU_YARUKI)||
				(f_spa.Spa == TOKUSYU_PURESSYAA) ){
				// 1/2œ
				if( gf_p_rand(2) == 0 ){
					;		// 
				}else{
					lv = HONEY_TREE_LV_MAX;	//Bxmaxɂ
				}
			}
		}
	}

	//Xv[`FbN
	
	//؃AjtOIt
	HTE_ResetAnimeFlg(fsys);
	outBattleParam->battle_status_flag |= BATTLE_STATUS_FLAG_MITSUNURI_BATTLE;
	
	EncountParamSet( monsno, lv, POKEPARTY_ENEMY, &f_spa, param, outBattleParam );
	return;
}

//-----------------------------------------------------------------------------
/**
 * GJEgf[^ZbgiCxgj
 *
 * @param	fsys				tB[hVXe|C^
 * @param	monsno				X^[io[
 * @param	level				x
 * @param	outBattleParam		ogp|C^
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
void SetWildEncountData(FIELDSYS_WORK *fsys, u16 monsno, u8 level,BATTLE_PARAM *outBattleParam)
{
	POKEMON_PARAM *param;
	ENC_FLD_SPA f_spa;		//\
	//擪|P̃^}S`FbN
	{	
		POKEPARTY *my_party;
		my_party = SaveData_GetTemotiPokemon(fsys->savedata);
		param = PokeParty_GetMemberPointer(my_party, 0);	//擪|P擾

		SetSpaStruct(fsys, param, NULL, &f_spa );
	}
	
	/*-B̔-*/
	/*-CxgĂ΂쐶́A-*/
	/*-{fB[AVNAӂ-*/
	/*-3@\-*/
	EncountParamSet( monsno, level, POKEPARTY_ENEMY, &f_spa, param, outBattleParam );
	return;
}

//-----------------------------------------------------------------------------
/**
 * GJEg邩ǂԂi][̃GJEgtO͔肵Ȃj
 *
 * @param	fsys				tB[hVXe|C^
 * @param	attr				Agr[g
 *
 * @return	BOOL				TRUE: GJEg	FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
BOOL EncSet_CheckEncount( FIELDSYS_WORK * fsys, u8 attr  )
{
	int prob = 0;
	
	if (MATR_IsEncount(attr)){
		if (MATR_IsWater(attr)){			//
			prob = GetEncountProbWater( fsys );
		}else{								//
			prob = GetEncountProbGround( fsys );
		}
	}
	
	if (prob){
		return TRUE;
	}else{
		return FALSE;
	}
}

#ifdef PM_DEBUG
//----------------------------------------------------
//	m[}
//	   : ENCOUNT_DATA * inData = GJEgf[^
//			 u8 id             = GJEgn`
//			 u8 sp_check       = `FbN
//	߂l : TRUE = ENCOUNT@FALSE = NOT ENCOUNT
//----------------------------------------------------
BOOL DebugSetEncountData(	const ENCOUNT_DATA * inData,
							const u8 id,
							BATTLE_PARAM *outBattleParam)
{
	DebugEncountParamSet( 1, 10, POKEPARTY_ENEMY, outBattleParam );//擪̓^}Sł͂ȂƂ

	return	TRUE;
}
#endif

//-----------------------------------------------------------------------------
/**
 * nGJEgԂ
 *
 * @param	fsys				tB[hVXe|C^
 *
 * @return	int					m
 */
//-----------------------------------------------------------------------------
static int GetEncountProbGround(FIELDSYS_WORK * fsys)
{
	ENCOUNT_DATA *data;
	data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);
	return data->EncProbGround;
}

//-----------------------------------------------------------------------------
/**
 * GJEgԂ
 *
 * @param	fsys				tB[hVXe|C^
 *
 * @return	int					m
 */
//-----------------------------------------------------------------------------
static int GetEncountProbWater(FIELDSYS_WORK * fsys)
{
	ENCOUNT_DATA *data;
	data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);
	return data->EncProbSea;
}

//-----------------------------------------------------------------------------
/**
 * ނGJEgԂ
 *
 * @param	fsys				tB[hVXe|C^
 * @param	inRodType			ފ
 *
 * @return	int					m
 */
//-----------------------------------------------------------------------------
static int GetEncountProbFishing(FIELDSYS_WORK * fsys, const FISHINGROD_TYPE inRodType)
{
	ENCOUNT_DATA *data;
	data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);
	switch(inRodType){
	case FISHINGROD_BAD:				//{ފ
		return data->EncProbFish1;
	case FISHINGROD_GOOD:				//ފ
		return data->EncProbFish2;
	case FISHINGROD_GREAT:				//ފ
		return data->EncProbFish3;
	default:
		GF_ASSERT(0);
		return 0;
	}
}

//-----------------------------------------------------------------------------
/**
 * w^Cṽ|PƃGJEg
 *
 * @param	inData			ʃGJEgf[^e[u
 * @param	inListNum		Xg
 * @param	type			^Cv
 * @param	outNo			e[uԍi[obt@
 *
 * @return	BOOL		TRUE:	FALSE:s
 */
//-----------------------------------------------------------------------------
static BOOL FixPokeSet(const ENC_COMMON_DATA *inData, const u8 inListNum, const u8 type, u8 * outNo)
{
	u8 same_type[ENC_MONS_NUM_MAX];	//w肵^CvƓ^Cṽ|P̃GJEgXg
	u8 cnt;				//Gg[
	u8 i;
	u8 type1,type2;
	//
	for (i=0;i<ENC_MONS_NUM_MAX;i++){
		same_type[i] = 0;
	}
	cnt = 0;
	
	//w^CvƃGJEgXg̃|P̃^Cvr
	for (i=0;i<inListNum;i++){
		type1 = PokePersonalParaGet( inData[i].MonsNo, ID_PER_type1 );
		type2 = PokePersonalParaGet( inData[i].MonsNo, ID_PER_type2 );
		if ( (type1 == type)||(type2 == type) ){
			//^CvȂ烊XgɃGg[
			same_type[cnt++] = i; 
		}
	}
	//GJEgXgɎw^CvȂÁAXg͑SĎw^CvȂ畁ʂɃGJEg
	if ( (cnt == 0)||(cnt==inListNum) ){
		return FALSE;
	}
	*outNo = same_type[gf_rand()%cnt];//w^Cṽ|Po(m)
	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 * w^Cṽ|PƃGJEg
 *
 * @param	inPokeParam		|Pp
 * @param	inFldSpa		`FbNEtHύXp\̂ւ̃|C^
 * @param	inData			ʃGJEgf[^e[u
 * @param	inListNum		Xg
 * @param	type			^Cv
 * @param	tokusei			
 * @param	outNo			e[uԍi[obt@
 *
 * @return	BOOL		TRUE:	FALSE:s
 */
//-----------------------------------------------------------------------------
static BOOL CheckFixTypeEcnt(	POKEMON_PARAM *inPokeParam,
							const ENC_FLD_SPA *inFldSpa,
							const ENC_COMMON_DATA *inData,
							const u8 inListNum,
							const u8 type, const u8 tokusei,u8 * outNo)
{
	// 擪̃|P^}SłȂ
	if( inFldSpa->Egg == 0 ){
		if( inFldSpa->Spa == tokusei ){
			// 1/2œ
			if( gf_p_rand(2) == 0 ){
				return FixPokeSet(inData, inListNum, type, outNo);
			}
		}
	}
	//Ȃ
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * GJEgύX
 *
 * @param	IsFishing		ނ肩ǂ
 * @param	inProb			m
 * @param	inFldSpa		`FbNEtHύXp\̂ւ̃|C^
 * @param	inWeatherCode	VC
 * @param	inPokeParam		|Pp
 *
 * @return	u8				m
 */
//-----------------------------------------------------------------------------
static u8 ChangeEncProb(	const BOOL inIsFishing,
							const u8 inProb,
							const ENC_FLD_SPA *inFldSpa,
							const u32 inWeatherCode,
							POKEMON_PARAM *inPokeParam	)
{
	int prob;

	prob = inProb;
	// 擪̃|P^}SłȂ
	if( inFldSpa->Egg == 0 ){
		if (inIsFishing){		//ނ
			//イ΂A˂񂿂ႭȂGJEg2{
			if( (inFldSpa->Spa == TOKUSYU_NENTYAKU)||(inFldSpa->Spa == TOKUSYU_KYUUBAN) ){
				prob*2;
			}
		}else{					//ނȊO
			//肶Am[K[hȂGJEg2{
			//AȂȂ1/2
			//ᒆA䂫Ȃ1/2
			//낢Ȃ1/2
			//͂₠Ȃ1/2
			if( (inFldSpa->Spa == TOKUSYU_ARIZIGOKU)||
				(inFldSpa->Spa == TOKUSYU_NOOGAADO)||
				(inFldSpa->Spa == TOKUSYU_HAKKOU) ){	//͉Bł͂܂
				prob*=2;
			}else if(inFldSpa->Spa == TOKUSYU_SUNAGAKURE){
				//V`FbN()
				if(inWeatherCode == WEATHER_SYS_SANDSTORM){
					prob/=2;
				}
			}else if(inFldSpa->Spa == TOKUSYU_YUKIGAKURE){
				//V`FbNiAAҐj
				if ( (inWeatherCode == WEATHER_SYS_SNOW)||
					 (inWeatherCode == WEATHER_SYS_SNOWSTORM)||
					 (inWeatherCode == WEATHER_SYS_SNOWSTORM_H) ){
					prob/=2;
				}
			}else if( (inFldSpa->Spa == TOKUSYU_SIROIKEMURI)||
					  (inFldSpa->Spa == TOKUSYU_HAYAASI)||
					  (inFldSpa->Spa == TOKUSYU_AKUSYUU) ){		//L͉Bł͂܂
				prob/=2;
			}
		}

		if (prob>100){		//100%@100%ɂ
			prob = 100;
		}
	}
	
	return prob;
}

//-----------------------------------------------------------------------------
/**
 * xɂ퓬iBj
 *
 * @param	inFldSpa		`FbNEtHύXp\̂ւ̃|C^
 * @param	inMyPokeParam	|Pp
 * @param	inEneLv			̃x
 *
 * @return	BOOL	TRUE:𐬌	FALSE:s
 */
//-----------------------------------------------------------------------------
static BOOL CheckEcntCancelByLv( const ENC_FLD_SPA *inFldSpa, POKEMON_PARAM *inMyPokeParam, const u8 inEneLv)
{
	u8 my_poke_lv;
	//LZꍇ͉Ȃ
	if ( inFldSpa->EncCancelSpInvalid ){
		return FALSE;
	}
	
	if (inFldSpa->Egg == 0){
		if( (inFldSpa->Spa == TOKUSYU_SURUDOIME)||(inFldSpa->Spa == TOKUSYU_IKAKU) ){//ǂ߁A
			//莝̃x擾
			my_poke_lv = PokeParaGet(inMyPokeParam, ID_PARA_level, NULL);
			//莝xTȉ̂Ƃ͓
			if (my_poke_lv<=5){
				return FALSE;		//퓬Ȃ
			}
			// LV莝LV-T
			if( inEneLv <= my_poke_lv-5 ){
				// 1/2ŃGJEg
				if (gf_p_rand(2) == 0){
					return TRUE;		//퓬
				}
			}
		}
	}

	return FALSE;		//퓬Ȃ
}

//-----------------------------------------------------------------------------
/**
 * t@Cg^Cv̌
 *
 * @param	fsys			tB[hVXe|C^
 * @param	inSafariFlg		Tt@tO
 * @param	param			ogp
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static void SetFieldBattleParam(FIELDSYS_WORK * fsys, const BOOL inSatafiFlg, BATTLE_PARAM **param)
{
	if (!inSatafiFlg){
		//ogp[^̃AP[Vƃ|Pp[eB̏(쐶)
		(*param) = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_1vs1_YASEI);
	}else {		//Tt@tOȂ
		//ogp[^̃AP[Vƃ|Pp[eB̏(Tt@)
		u16 * ball = Situation_GetSafariBallCount(SaveData_GetSituation(fsys->savedata));
		(*param) = BattleParam_CreateForSafari(HEAPID_WORLD, *ball);
	}
}

//-----------------------------------------------------------------------------
/**
 * Tt@gX^[̃Zbg
 *
 * @param	fsys			tB[hVXe|C^
 * @param	inSafariFlg		Tt@tO
 * @param	inBookGet		S}ӓtO
 * @param	enc_data		ʃGJEgf[^e[u
 *
 * @return	none
 */
//-----------------------------------------------------------------------------

static void SetSfariMonster(FIELDSYS_WORK * fsys, const BOOL inSafariFlg, const BOOL inBookGet, ENC_COMMON_DATA *enc_data)
{
	if (inSafariFlg){	//Tt@tOȂ
		//Tt@g̃|PZbg
		SafariEnc_SetSafariEnc(	EncDataSave_GetRandSeed(
								EncDataSave_GetSaveDataPtr(fsys->savedata), ENC_RND_SEED_SAFARI),
								inBookGet,
								fsys->location->zone_id,
								&enc_data[SP_ENC_1].MonsNo, &enc_data[SP_ENC_2].MonsNo);
	}
}

//-----------------------------------------------------------------------------
/**
 * Xv[`FbN
 *
 * @param	inEneLv		x
 * @param	inFldSpa	`FbNEtHύXp\̂ւ̃|C^
 *
 * @return	BOOL	TRUE:Xv[	FALSE:Xv[s
 */
//-----------------------------------------------------------------------------
static BOOL CheckSpray(const u8 inEneLv, const ENC_FLD_SPA *inSpa)
{
	if (inSpa->SprayCheck){
		//xr
		if (inSpa->SpMyLv > inEneLv){
			OS_Printf("Xv[ʔ\n");
			return TRUE;
		}
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * ړ|PGZbg
 *
 * @param	inTrainerID		g[i[hc
 * @param	mpd				ړ|Pf[^|C^
 * @param	outBattleParam	ogp
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static void SetMovePokemon(const u32 inTrainerID, MPD_PTR mpd, BATTLE_PARAM *outBattleParam)
{
	int monsno;
	u8 lv;
	u32 pow_rnd;
	u32 per_rnd;
	u32 cond;
	u16 hp;
	
	BOOL rc;
	POKEMON_PARAM *poke_param;
	
	poke_param = PokemonParam_AllocWork(HEAPID_FIELD);
	
	monsno = EncDataSave_GetMovePokeDataParam(mpd, MP_PARAM_MONSNO);
	lv = EncDataSave_GetMovePokeDataParam(mpd, MP_PARAM_LV);
	pow_rnd = EncDataSave_GetMovePokeDataParam(mpd, MP_PARAM_POW_RND);
	per_rnd = EncDataSave_GetMovePokeDataParam(mpd, MP_PARAM_PER_RND);
	cond = EncDataSave_GetMovePokeDataParam(mpd, MP_PARAM_COND);
	hp = EncDataSave_GetMovePokeDataParam(mpd, MP_PARAM_HP);

	PokeParaSetPowRnd( poke_param, monsno, lv, pow_rnd, per_rnd );
	
	PokeParaPut( poke_param, ID_PARA_id_no, &inTrainerID );		// hc
	PokeParaPut( poke_param, ID_PARA_condition, &cond );		// RfBV
	PokeParaPut( poke_param, ID_PARA_hp,        &hp );		// HP

	//ACeĂȂ̂ŁAڃAbh
	rc = PokeParty_Add(outBattleParam->poke_party[POKEPARTY_ENEMY], poke_param);
	GF_ASSERT(rc&&"|P̒ǉɎs");
	sys_FreeMemoryEz(poke_param);
}

//-----------------------------------------------------------------------------
/**
 * ړ|PGJEg`FbN
 *
 * @param	fsys			tB[hVXe|C^
 * @param	outMpd			ړ|Pf[^|C^
 *
 * @return	BOOL	TRUE:GJEg	FALSE:GJEgȂ
 */
//-----------------------------------------------------------------------------
static BOOL CheckMovePokeEnc(FIELDSYS_WORK * fsys, MPD_PTR *outMpd)
{
	ENC_SV_PTR data;
	MPD_PTR temp[MOVE_POKE_MAX];
	u8 enc_count;
	u8 i;
	int zone;

	//ꏊɂړ|P擾
	enc_count = 0;
	data = EncDataSave_GetSaveDataPtr(fsys->savedata);
	for(i=0;i<MOVE_POKE_MAX;i++){
		zone = MP_GetMovePokeZone(EncDataSave_GetMovePokeZoneIdx(data,i));
		if( EncDataSave_IsMovePokeValid(data,i)&&
				(zone == fsys->location->zone_id) ){
			temp[enc_count] = EncDataSave_GetMovePokeDataPtr(data, i);
			enc_count++;
		}
	}

	if (enc_count == 0){
		return FALSE;			//ړ|PȂ
	}else{
		//ꍇA5ŃGJEg
		if ( gf_p_rand(2) == 0 ){
			return FALSE;
		}
	}
	
	if (enc_count>1){
		//_őIo
		(*outMpd)  = temp[ gf_p_rand(enc_count) ];
	}else{
		//1CȂ̂Ŋm
		(*outMpd)  = temp[0];
	}

	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 * 퓬|Pogpɒǉ
 *
 * @param	inTarget			ǉΏ
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 * @param	ioPokeParam			|Pp
 * @param	ioBattleParam		ogp
 *
 * @return	BOOL		|Pp[eBǉ
 */
//-----------------------------------------------------------------------------
static BOOL AddPokemonParam(const int inTarget, const ENC_FLD_SPA *inFldSpa,
							POKEMON_PARAM *ioPokeParam, BATTLE_PARAM *ioBattleParam )
{
	int range = ITEM_RANGE_NORMAL;
	//ӂ`FbN
	if (inFldSpa->Egg == 0){
		if (inFldSpa->Spa == TOKUSYU_HUKUGAN){
			range = ITEM_RANGE_HUKUGAN;
		}
	}
	
	PokeItemSet(ioPokeParam, ioBattleParam->fight_type , range);

	//tHύX
	{
		u8 change_flg;
		u8 form_no;
		int monsno;
		change_flg = 0;
		monsno = PokeParaGet( ioPokeParam, ID_PARA_monsno, NULL );
		//tHύXf[^͊mœĂ邪AAω邩Ȃ̂QȂ̂ŁA0łȂ΁AύX
		if (monsno == MONSNO_SIIUSI ){
			change_flg = 1;
			if (!inFldSpa->FormProb[0]){
				form_no = FORMNO_SII_WEST;	//ftHg
				OS_Printf("\n");
			}else{
				form_no = FORMNO_SII_EAST;	//tHύX
				OS_Printf("\n");
			}
		}else if(monsno == MONSNO_SIIDORUGO){
			change_flg = 1;
			if (!inFldSpa->FormProb[1]){
				form_no = FORMNO_SII_WEST;	//ftHg
			}else{
				form_no = FORMNO_SII_EAST;	//tHύX
			}
		}else if(monsno == MONSNO_ANNOON){
			u8 num;
			change_flg = 1;
			//o^Cv擾
			num = ANNOON_Table[ inFldSpa->AnnoonTblType ].Num;
			form_no = ANNOON_Table[ inFldSpa->AnnoonTblType ].Tbl[ gf_rand()%num ];
		}

		if (change_flg){
			PokeParaPut(ioPokeParam,ID_PARA_form_no,(u8 *)&form_no);
		}

	}
	return PokeParty_Add(ioBattleParam->poke_party[inTarget], ioPokeParam);
}

//-----------------------------------------------------------------------------
/**
 * n폈Fw肵e[uԍ̎|P̒ňԃx̍e[uԍԂ(B)

 *
 * @param	inEncCommonData		ʃGJEgf[^e[u
 * @param	inFldSpa			`FbNEtHύXp\̂ւ̃|C^
 * @param	inTblNo				e[uio[
 *
 * @return	u8					ύXe[uio[
 */
//-----------------------------------------------------------------------------
static u8 GetMaxLvMonsTblNo(const ENC_COMMON_DATA *inEncCommonData, const ENC_FLD_SPA *inFldSpa, const u8 inTblNo)
{
	u8 tbl_no;
	u8 i;
	if (inFldSpa->Egg == 0){
		//邫A͂肫AvbV[ `FbNx̍|PƂTŃGJEg
		if ( (inFldSpa->Spa == TOKUSYU_YARUKI)||
			 (inFldSpa->Spa == TOKUSYU_HARIKIRI)||
			 (inFldSpa->Spa == TOKUSYU_PURESSYAA) ){
			
			//5Ŕ
			if (gf_p_rand(2) == 0){
				return inTblNo;			//
			}
			
			//e[uԍۑ
			tbl_no = inTblNo;
			//X^[io[̃e[u
			for(i=0;i<ENC_MONS_NUM_NORMAL;i++){
				if (inEncCommonData[i].MonsNo == inEncCommonData[tbl_no].MonsNo){ //X^[io[H
					//xr
					if (inEncCommonData[i].LvMax > inEncCommonData[tbl_no].LvMax){
						//e[uԍ̍XV
						tbl_no = i;
					}
				}
			}
			return tbl_no;
		}
	}

	return inTblNo;
}

//-----------------------------------------------------------------------------
/**
 * AXv[`FbNȂǂ̏Wvč\̂ɃZbg

 *
 * @param	fsys			tB[hVXe|C^
 * @param	inPokeParam		̃|Pp
 * @param	inData			GJEgf[^
 * @param	outSpa			\̃|C^
 *
 * @return	none
 */
//-----------------------------------------------------------------------------
static void SetSpaStruct(FIELDSYS_WORK *fsys, POKEMON_PARAM *inPokeParam, ENCOUNT_DATA* inData, ENC_FLD_SPA *outSpa  )
{
	//擪|P̃^}S`FbN
	if( PokeParaGet( inPokeParam, ID_PARA_tamago_flag, NULL ) == 0 ){
		// 擪̃|P^}SłȂ
		outSpa->Egg = 0;
		outSpa->Spa = PokeParaGet(inPokeParam, ID_PARA_speabino, NULL);	// \͎擾
	}else{
		// 擪̃|P^}S
		outSpa->Egg = 1;
		outSpa->Spa = TOKUSYU_MAX;
	}

	outSpa->SpMyLv = 0;
	outSpa->SprayCheck = FALSE;
	outSpa->EncCancelSpInvalid = FALSE;
	
	if (inData != NULL){
		//V[EVEV[hStHύXmZbg
		outSpa->FormProb[0] = inData->FormProb[0];	//V[EV
		outSpa->FormProb[1] = inData->FormProb[1];	//V[hS
		//Am[
		if (inData->AnnoonTable != 0){
			GF_ASSERT(inData->AnnoonTable<=8&&"annoon_table_over");
			//Am[e[u^CvZbg
			outSpa->AnnoonTblType = inData->AnnoonTable-1;
		}else{
			outSpa->AnnoonTblType = 0;
		}
	}
	//g[i[hc̃Zbg
	outSpa->TrainerID = MyStatus_GetID( SaveData_GetMyStatus(fsys->savedata) );
	
}

#ifdef PM_DEBUG

//-----------------------------------------------------------------------------
/**
 * ނGJEg
 * Tt@ɂƂĂAނł͓ĝŁATt@X^[̃Zbg͍sȂ
 *
 * @param	fsys				tB[hVXe|C^
 * @param	inRodtype			ނ
 *
 * @return	BOOL
 */
//-----------------------------------------------------------------------------
BOOL DebugSetFishingEncount( FIELDSYS_WORK * fsys, const u8 inRodType )
{
	BATTLE_PARAM * battle_param;
	POKEMON_PARAM *poke_param;
	POKEPARTY *my_party;
	BOOL safari_flg;		//Tt@tO

	ENC_COMMON_DATA enc_data[ENC_MONS_NUM_MAX];
	ENC_FLD_SPA f_spa;		//\

	{
		u8 prob;
#ifdef PM_DEBUG
		if (DebugFishProbFlg){
			prob = 100;
		}else{
			// GJEg
			prob = GetEncountProbFishing(fsys, inRodType);
		}
#else
		// GJEg
		prob = GetEncountProbFishing(fsys, inRodType);
#endif
		if(  prob == 0 ){
			return FALSE;		//m0
		}

		//莝|Pp[eB擾
		my_party = SaveData_GetTemotiPokemon(fsys->savedata);
		poke_param = PokeParty_GetMemberPointer(my_party, 0);	//擪|P擾
		SetSpaStruct(fsys, poke_param, NULL, &f_spa );
	
		//ނł́AXv[`FbNȂ
	
		//ɂăGJEgύX
		prob = ChangeEncProb(	TRUE, prob, &f_spa,
								Situation_GetWeatherID(SaveData_GetSituation(fsys->savedata)),
								poke_param	);
		//mŃGJEg
		if (gf_p_rand(100) >= prob){
			return FALSE;		//GJEgȂ
		}
	}
	//Tt@tO擾
	safari_flg = SysFlag_SafariCheck(SaveData_GetEventWork(fsys->savedata));

	//ogp[^Zbg
	SetFieldBattleParam(fsys, safari_flg, &battle_param);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(battle_param, fsys);


	if ( (ZoneData_IsSpFishingZone(fsys->location->zone_id))&&
			 SpFishing_CheckPoint(fsys) ){
		//ނf[^쐬
		u8 i;
		int monsno;
		u8 max,min;
		SpFishing_GetMaxMinLv(&max, &min);
		SpFishing_GetMonsNo(&monsno);
		
		for(i=0;i<ENC_MONS_NUM_FISH;i++){
			enc_data[i].MonsNo = monsno;
			enc_data[i].LvMax = max;
			enc_data[i].LvMin = min;
		}
	}else{
		//ʃGJEgf[^쐬
		{
			NON_GROUND_ENC_MONSTER_DAT *enc_fish;
			u8 i;
			ENCOUNT_DATA *data;

			data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);	
		
			//ނƕʂɃf[^쐬
			switch(inRodType){
			case FISHINGROD_BAD:		//{
				enc_fish = data->EncFish1;
				break;
			case FISHINGROD_GOOD:		//
				enc_fish = data->EncFish2;
				break;
			case FISHINGROD_GREAT:		//
				enc_fish = data->EncFish3;
				break;
			}
		
			for(i=0;i<ENC_MONS_NUM_FISH;i++){
				enc_data[i].MonsNo = enc_fish[i].MonsterNo;
				enc_data[i].LvMax = enc_fish[i].MaxLevel;
				enc_data[i].LvMin = enc_fish[i].MinLevel;
			}	
		}
	}

	//ނGJEg
	{
		BOOL rc;
		rc = FishingEncSingle( fsys, poke_param, battle_param, enc_data, &f_spa, inRodType );
		if (!rc){
			return FALSE;
		}
	}
	
	return TRUE;
}

#endif


