//============================================================================================
/**
 * @file	ev_check.h
 * @brief	Cxg`FbNVXe
 * @author	Sousuke Tamada
 * @date	01.03.29
 *
 * 05.07.04 Hiroyuki Nakamura
 */
//============================================================================================
#ifndef __EV_CHECK_H__
#define __EV_CHECK_H__

#include "field_common.h"



//=========================================================================
//	`
//=========================================================================

/* Cxg`FbNNGXg\ */
typedef struct {
	u16	TalkCheck:1;
	u16	StepCheck:1;
	u16	MenuOpen:1;
	u16	CnvButton:1;
	u16	MatCheck:1;
	u16	PushCheck:1;
	u16	MoveCheck:1;
	u16	FloatCheck:1;

	u16	DebugMenu:1;
	u16	DebugBattle:1;
	u16	DebugHook:1;
	u16 DebugKeyPush:1;
	u16	:4;

	u8	Site;
	s8	PushSite;
	u16 trg;
	u16 cont;
}EV_REQUEST;


//=========================================================================
//	֐vg^Cv
//=========================================================================

//CxgN`FbÑNGXgZbg
extern void SetRequest( EV_REQUEST * req, FIELDSYS_WORK * repw, u16 trg, u16 cont );

//CxgN`FbNC
extern int CheckRequest(const EV_REQUEST * req, FIELDSYS_WORK * repw);
// Yz̃CxgN
extern BOOL CheckRequestUG( EV_REQUEST * req, FIELDSYS_WORK * repw );
// ΐ펞̃CxgN
extern BOOL CheckRequestVSRoom( EV_REQUEST * req, FIELDSYS_WORK * repw );
// jI[ł̃CxgN`FbN
extern BOOL CheckRequestUnion(const EV_REQUEST * req, FIELDSYS_WORK * repw);
//og^[pCxgN`FbN
extern int CheckRequestBTower(const EV_REQUEST * req, FIELDSYS_WORK * repw);


#endif	/*__EV_CHECK_H__*/

