//============================================================================================
/**
 * @file	ev_gameover.c
 * @brief
 * @date	2006.04.18
 * @author	tamada GAME FREAK inc.
 *
 * scr_tool.c,field_encount.cQ[I[o[Ăčč\
 */
//============================================================================================

#include "common.h"
#include "fieldsys.h"
#include "field_event.h"

#include "ev_mapchange.h"

#include "system/snd_tool.h"
#include "fld_bgm.h"

#include "system/window.h"
#include "system/wipe.h"

#include "mapdata_warp.h"			//WARPDATA_GetRevivalLocation
#include "situation_local.h"		//Situation_Get`
#include "system/brightness.h"
#include "script.h"
#include "scr_tool.h"
#include "mapdefine.h"
#include "..\fielddata\script\common_scr_def.h"		//SCRID_GAME_OVER_RECOVER_PC
#include "sysflag.h"
#include "fld_flg_init.h"			//FldFlgInit_GameOver

//==============================================================================================
//
//	SŊ֘A
//
//==============================================================================================
#include "system/fontproc.h"						
#include "system/msgdata.h"							//MSGMAN_TYPE_DIRECT
#include "system/wordset.h"							//WORDSET_Create

#include "fld_bmp.h"						

#include "msgdata/msg.naix"							//NARC_msg_??_dat
#include "msgdata/msg_gameover.h"					//msg_all_dead_??
// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł͐p̃Q[I[o[bZ[W\
#ifdef PG5_TRIAL
#include "msgdata/msg_dp_festa.h"
#endif
// ----------------------------------------------------------------------------

#include "system/arc_util.h"
#include "system/font_arc.h"

//----------------------------------------------------------------------------------------------
//	\̐錾
//----------------------------------------------------------------------------------------------
typedef struct{
	int seq;

	FIELDSYS_WORK* fsys;

	GF_BGL_INI* bgl;								//BGLf[^

	GF_BGL_BMPWIN bmpwin;							//BMPEBhEf[^

	//STRBUF* msg_buf[EV_WIN_MENU_MAX];				//bZ[Wf[^̃|C^
	MSGDATA_MANAGER* msgman;						//bZ[W}l[W[
	WORDSET* wordset;								//PZbg

	//PALETTE_FADE_PTR pfd;							//pbgtF[h
}GAME_OVER_WORK;

#define GAME_OVER_MSG_BUF_SIZE		(1024)			//bZ[Wobt@TCY
#define GAME_OVER_FADE_SYNC			(8)				//tF[hsync

//----------------------------------------------------------------------------------------------
//	BMPEBhE
//----------------------------------------------------------------------------------------------
enum{
	GAME_OVER_BMPWIN_FRAME	= GF_BGL_FRAME3_M,
	//GAME_OVER_BMPWIN_PX1	= 1,//2,
	//GAME_OVER_BMPWIN_PY1	= 1,//2,
	//GAME_OVER_BMPWIN_SX		= 29,//25,
	//GAME_OVER_BMPWIN_SY		= 19,//18,
	GAME_OVER_BMPWIN_PX1	= 4,
	GAME_OVER_BMPWIN_PY1	= 5,
	GAME_OVER_BMPWIN_SX		= 25,
	GAME_OVER_BMPWIN_SY		= 15,
	GAME_OVER_BMPWIN_PL		= FLD_SYSFONT_PAL,
	GAME_OVER_BMPWIN_CH		= 1,
};

static const BMPWIN_DAT	GameOverWinData = {
	GAME_OVER_BMPWIN_FRAME,						//EChEgpt[
	GAME_OVER_BMPWIN_PX1,GAME_OVER_BMPWIN_PY1,	//EChË̍X,YWiLPʂŎwj
	GAME_OVER_BMPWIN_SX, GAME_OVER_BMPWIN_SY,	//EChËX,YTCYiLPʂŎwj
	GAME_OVER_BMPWIN_PL,						//EChË̃pbgio[	
	GAME_OVER_BMPWIN_CH							//EChEL̈̊JnLN^io[
};

//----------------------------------------------------------------------------------------------
//	vg^Cv錾
//----------------------------------------------------------------------------------------------
static void GameOverCall( FIELDSYS_WORK* fsys, GMEVENT_CONTROL* event );
static BOOL GMEVENT_GameOver( GMEVENT_CONTROL* event );
static void scr_msg_print( GAME_OVER_WORK* wk, u16 msg_id, u8 x, u8 y );

static void SetBgHeader( GF_BGL_INI * ini );
static void BgExit( GF_BGL_INI * ini );


static void setup_bg_sys( GF_BGL_INI* bgl )
{
	static const GF_BGL_DISPVRAM SetBankData = {
		GX_VRAM_BG_128_B,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_64_E,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_0_A,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
	};

	static const GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
	};

	static const GF_BGL_BGCNT_HEADER header = {
		0, 0, 0x800, 0,	// scrX, scrY, scrbufSize, scrbufofs,
		GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
		GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000,
		GX_BG_EXTPLTT_01, 1, 0, 0, FALSE	// pal, pri, areaover, dmy, mosaic
	};

	GF_Disp_SetBank( &SetBankData );
	GF_BGL_InitBG( &BGsys_data );
	GF_BGL_BGControlSet( bgl, GAME_OVER_BMPWIN_FRAME, &header, GF_BGL_MODE_TEXT );

	ArcUtil_PalSet( ARC_FONT, NARC_font_system_ncrl, PALTYPE_MAIN_BG, 
		GAME_OVER_BMPWIN_PL*0x20, 0x20, HEAPID_WORLD );
}

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ʌĂяo
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void GameOverCall( FIELDSYS_WORK* fsys, GMEVENT_CONTROL* event )
{
	GAME_OVER_WORK* wk;

	wk = sys_AllocMemory( HEAPID_WORLD, sizeof(GAME_OVER_WORK) );
	if( wk == NULL ){
		GF_ASSERT( (0) && "mۂɎs܂I" );
	}
	memset( wk, 0, sizeof(GAME_OVER_WORK) );

	wk->seq			= 0;
	wk->fsys		= fsys;
	wk->bgl 		= GF_BGL_BglIniAlloc( HEAPID_WORLD );

	setup_bg_sys( wk->bgl );

	//bZ[Wf[^}l[W[쐬
#ifdef PG5_TRIAL
	wk->msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_dp_festa_dat, HEAPID_WORLD);
#else
	wk->msgman = MSGMAN_Create(MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_gameover_dat, HEAPID_WORLD);
#endif
	wk->wordset = WORDSET_Create( HEAPID_WORLD );

	//rbg}bvǉ
	GF_BGL_BmpWinAddEx( wk->bgl, &wk->bmpwin, &GameOverWinData );

	//lZbg
	WORDSET_RegisterPlayerName(wk->wordset, 0, SaveData_GetMyStatus(GameSystem_GetSaveData(fsys)));

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł͐p̃Q[I[o[bZ[W\
#ifdef PG5_TRIAL
	scr_msg_print( wk, msg_festa_gameover_01, 0, 0);
#else
	//}bvǗ\BGMio[Ԃ
	if( fsys->location->zone_id == ZONE_ID_T01R0201 ){
		OS_Printf( "05 zone_id = %d\n", fsys->location->zone_id );
		scr_msg_print( wk, msg_all_dead_05, 0, 0 );
	}else{
		OS_Printf( "04 zone_id = %d\n", fsys->location->zone_id );
		scr_msg_print( wk, msg_all_dead_04, 0, 0 );
	}
#endif
// ----------------------------------------------------------------------------

	GF_BGL_BmpWinOn( &wk->bmpwin );

	FieldEvent_Call( event, GMEVENT_GameOver, wk );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	Q[I[o[ʃC
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static BOOL GMEVENT_GameOver( GMEVENT_CONTROL* event )
{
	GAME_OVER_WORK * wk = FieldEvent_GetSpecialWork( event );

	switch( wk->seq ){

	case 0:

		WIPE_SYS_Start(WIPE_PATTERN_M, WIPE_TYPE_FADEIN, WIPE_TYPE_MAX,
				WIPE_FADE_BLACK, GAME_OVER_FADE_SYNC, WIPE_DEF_SYNC, HEAPID_EVENT);
		wk->seq++;
		break;

	case 1:
		if (WIPE_SYS_EndCheck()) {
			wk->seq++;
		}
		break;

	//L[҂
	case 2:
		if( (sys.trg & PAD_BUTTON_A) || (sys.trg & PAD_BUTTON_B) ){
			WIPE_SYS_Start(WIPE_PATTERN_WMS, WIPE_TYPE_FADEOUT, WIPE_TYPE_FADEOUT,
					WIPE_FADE_BLACK, GAME_OVER_FADE_SYNC, WIPE_DEF_SYNC, HEAPID_EVENT);
			wk->seq++;
		}
		break;

	//CʃubNAEg҂
	case 3:
		if (WIPE_SYS_EndCheck()) {

			GF_BGL_BmpWinDataFill( &wk->bmpwin, FBMP_COL_NULL );		//hԂ

			wk->seq++;
		}
		break;

	//IJ
	case 4:
		BmpTalkWinClear( &wk->bmpwin, WINDOW_TRANS_ON );
		GF_BGL_BmpWinDel( &wk->bmpwin );

		WORDSET_Delete( wk->wordset );
		MSGMAN_Delete( wk->msgman );
		GF_BGL_BGControlExit( wk->bgl, GAME_OVER_BMPWIN_FRAME );
		sys_FreeMemoryEz( wk->bgl );

		sys_FreeMemoryEz( wk );

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł̓Q[I[o[ʂ甲烊Zbg
#ifdef PG5_TRIAL
		OS_ResetSystem(0);
#endif
// ----------------------------------------------------------------------------

		return TRUE;
	};

	return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief	bZ[W\
 *
 * @param	wk			EV_WIN_WORK^̃AhX
 * @param	msg_id		bZ[WID
 * @param	x			\wW
 * @param	y			\xW
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void scr_msg_print( GAME_OVER_WORK* wk, u16 msg_id, u8 x, u8 y )
{
	STRBUF* tmp_buf = STRBUF_Create( GAME_OVER_MSG_BUF_SIZE, HEAPID_WORLD );
	STRBUF* tmp_buf2= STRBUF_Create( GAME_OVER_MSG_BUF_SIZE, HEAPID_WORLD );

	GF_BGL_BmpWinDataFill( &wk->bmpwin, FBMP_COL_NULL );			//hԂ

// ----------------------------------------------------------------------------
// localize_spec_mark(LANG_ALL) imatake 2007/02/09
// ̌łł͐p̃Q[I[o[bZ[W\
#ifdef PG5_TRIAL
	MSGMAN_GetString( wk->msgman, msg_id, tmp_buf2 );
#else
	MSGMAN_GetString( wk->msgman, msg_id, tmp_buf );
	WORDSET_ExpandStr( wk->wordset, tmp_buf2, tmp_buf );
#endif
// ----------------------------------------------------------------------------

	// ----------------------------------------------------------------------------
	// localize_spec_mark(LANG_ALL) imatake 2006/12/06
	// Q[I[o[bZ[WŒinĂ x ̓e͔jj
	{
		u32 width = FontProc_GetPrintMaxLineWidth(FONT_SYSTEM, tmp_buf2, 0);
		x = (u8)(wk->bmpwin.sizx * 8 - width) / 2 - 4;		// EBhEE
	}
	// ----------------------------------------------------------------------------
	GF_STR_PrintColor( &wk->bmpwin, FONT_SYSTEM, tmp_buf2, x, y, MSG_NO_PUT, 
					GF_PRINTCOLOR_MAKE(FBMP_COL_WHITE,FBMP_COL_BLK_SDW,FBMP_COL_NULL), NULL );

	STRBUF_Delete( tmp_buf );
	STRBUF_Delete( tmp_buf2 );
	return;
}


//============================================================================================
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	ʏ퓬FSŃV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 */
//-----------------------------------------------------------------------------
BOOL GMEVENT_NormalGameOver(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	int * seq;
	fsys = FieldEvent_GetFieldSysWork(event);
	seq = FieldEvent_GetSeqWork(event);

	switch (*seq) {
	case 0:
		//[vIDŎw肳ꂽ߂
		{
			LOCATION_WORK next;
			SITUATION * sit = SaveData_GetSituation(fsys->savedata);
			u16 warp_id = Situation_GetWarpID(sit);
			WARPDATA_GetRevivalLocation(warp_id, &next);
			//GXP[v|Cg[v|CgɍĐݒ
			WARPDATA_GetWarpLocation(warp_id,Situation_GetEscapeLocation(sit));
			//}bv`FW
			EventCmd_MapChangeByLocation(event, &next);
			//Q[I[o[̃tÕNA
			FldFlgInit_GameOver(fsys);
		}
		(*seq) ++;
		break;

	case 1:
		//BGMtF[hAEg
		Snd_BgmFadeOut( 0, 20 );
		(*seq) ++;
		break;

	case 2:
		//BGMtF[hAEg҂
		if( Snd_FadeCheck() == 0 ){

			//TEhQ[I[o[
			Snd_GameOverSet();

			(*seq) ++;
		}
		break;

	case 3:
		//xBGȊO\It
		SetBrightness( BRIGHTNESS_BLACK, (PLANEMASK_ALL^PLANEMASK_BG3), MASK_MAIN_DISPLAY);
		SetBrightness( BRIGHTNESS_BLACK, PLANEMASK_ALL, MASK_SUB_DISPLAY);

		//Q[I[o[x
		GameOverCall( fsys, event );
		(*seq) ++;
		break;

	case 4:
		//CxgR}hFtB[h}bvvZXA
		EventCmd_StartFieldMap(event);
		(*seq)++;
		break;

	case 5:
		//\It
		SetBrightness( BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);

		//CĂ˃XNvg
		
		//bΏۂOBJ擾鏈KvɂȂ
		//OS_Printf( "field_encount zone_id = %d\n", fsys->location->zone_id );
		if(	WARPDATA_GetInitializeID()
				== Situation_GetWarpID(SaveData_GetSituation(fsys->savedata))) {
			//l̃[vIDŏ̖߂Ȃ̂Ŏ̉
			EventCall_Script( event, SCRID_GAME_OVER_RECOVER_MYHOME, NULL, NULL );
		}else{
			//ȊO|PẐ͂
			EventCall_Script( event, SCRID_GAME_OVER_RECOVER_PC, NULL, NULL );
		}
		(*seq) ++;
		break;

	case 6:
		//TEhX^[g(06/07/10Ȃ̂ō폜)
		//Snd_RestartSet( fsys );

		return TRUE;
	}
	return FALSE;
}


//-----------------------------------------------------------------------------
/**
 * @brief	CxgR}hFʏSŏ
 * @param	event		Cxg䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventCmd_NormalLose(GMEVENT_CONTROL * event)
{
	FieldEvent_Call(event, GMEVENT_NormalGameOver, NULL);
}



